<?php
class StripeController extends Controller
{

    public function __construct()
    {
        $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        
        $this->mobileWrapper = new mobileWrapper();
    }


 

public function index()
{
    $amount_to_pay = 0;
    $error = '';
    $credentials = '';
    $payment_description = '';
    $merchant_name = '';
    $reference_id = '';
    $client_info = [];
    $trans_type = 'order';
    $currency_code = $this->functions->getCurrencyCode();

    $back_url = Config::$baseUrl . "/store/confirmorder";
    $orig_amount_to_pay = 0;
    $currency_used = '';
    $order_card_fee = 0;
    $exchange_rate_convertion = 0;
    $client_email = '';

    $exchange_rate = $this->functions->getRates();
    $order_id_token = $_GET['id'] ?? '';

    $_SESSION['stp_redirect_url'] = $_GET['redirect_url'];
    $_SESSION['stp_cancel_url'] = $_GET['cancel_url'];
    $cancel_url_view = $_SESSION['stp_cancel_url'];

    if ($data = $this->functions->getOrderByToken_appside($order_id_token)) {

        if ($data['status'] == 'paid') {
            $client_id = $data['client_id'];
            $msg = "already paid";
            $this->mobileWrapper->clearCartByCustomerID($client_id);      
            $redirect_link = Config::$baseUrl . "/webappv2/stripe/success?message=" . $msg;
            header('Location: ' . $redirect_link . "&note=already paid");
            exit;
        }

       $_SESSION['order_id']= $data['order_id'];

        $merchant_id = $data['merchant_id'] ?? '';
        $client_id = $data['client_id'];
        $order_id = $data['order_id'];
        $reference_id = $order_id_token;
        
        $_SESSION['reference_id_stp']=$order_id_token;

        $order_card_fee = isset($data['card_fee']) ? (float)$data['card_fee'] : 0;

        $merchant_name = isset($data['merchant_name']) ? $this->functions->clearString($data['merchant_name']) : '';
        $payment_description = $this->functions->translation(
            "default",
            "Payment to merchant " . $merchant_name . " Order ID# " . $order_id
        );
        $description = $this->functions->translation("default", "Purchase Order ID# " . $order_id);

        $amount_to_pay = $this->functions->normalPrettyPrice($data['total_w_tax']);
        $orig_amount_to_pay = $this->functions->convertToRaw($amount_to_pay);
        $client_info = $this->functions->getClientInfo($client_id);
        $client_email = $client_info['email_address'] ?? '';
    } else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for.");
    }

    if (empty($currency_code)) {
        $currency_code = $this->functions->translation("default", $this->functions->getCurrencyCode());
    }

    if (empty($error)) {
        if ($credentials = $this->functions->getCredentials_stripe($merchant_id)) {
            try {
                $amount_to_pay = $this->functions->convertToRaw($amount_to_pay) * 100;

                
                require_once(__DIR__ . '/../../../vendor/stripe/init.php');

               

                \Stripe\Stripe::setApiKey($credentials['secret_key']);

                $session = \Stripe\Checkout\Session::create([
                    'customer_email' => trim($client_email),
                    'client_reference_id' => $trans_type . "-" . $reference_id,
                    'payment_method_types' => ['card'],
                    'mode' => "payment",
                    'success_url' => $this->functions->websiteUrl() . "/webappv2/stripe/verify?reference_id=" . urlencode($reference_id) . "&trans_type=$trans_type&session_id={CHECKOUT_SESSION_ID}",
                    'cancel_url' => $cancel_url_view,
                    'line_items' => [
                        [
                            'price_data' => [
                                'currency' => $currency_code,
                                'unit_amount' => $amount_to_pay,
                                'product_data' => [
                                    'name' => $payment_description,
                                    'description' => $description
                                ]
                            ],
                            'quantity' => 1
                        ]
                    ],
                ]);

                // Save the Stripe session ID or payment intent for verification
                $params_update = [
                    'payment_gateway_ref' => $session->payment_intent
                ];
                $this->functions->updateData('mt_order', $params_update, 'order_id', $order_id);

                // ✅ Skip the view and redirect user directly to Stripe
                header("Location: " . $session->url);
                exit;

            } catch (Exception $e) {
                $error = $this->functions->translation("default", "Caught exception: " . $e->getMessage());
            }
        } else {
            $error = $this->functions->translation("default", "Invalid payment credentials");
        }
    }

    if (!empty($error)) {
        $redirect_link = Config::$baseUrl . "/webappv2/stripe/error?error=" . urlencode($error);
        header('Location: ' . $redirect_link);
        exit;
    }
}




        public function verify_olds()
{

$get = $_GET;$error = '';
    $post = $_POST;
    $back_url = Config::$baseUrl."/store/confirmorder";


    $reference_id = isset($get['reference_id'])?$get['reference_id']:'';
    $trans_type = isset($get['trans_type'])?$get['trans_type']:'';  

    

    if(!empty($reference_id)){      
            
      switch ($trans_type) {
        case "order":
          if ($data = $this->functions->getOrderInfoByToken_appside($reference_id)){
            $payment_gateway_ref=isset($data['payment_gateway_ref'])?$data['payment_gateway_ref']:'';       
            $merchant_id=isset($data['merchant_id'])?$data['merchant_id']:''; 
                  $client_id = $data['client_id'];
                  $order_id = $data['order_id'];
                  
                  

                  $redirec_link=Config::$baseUrl."/webappv2/stripe/success?id=".$order_id;

                         
                  if($credentials = $this->functions->getCredentials_stripe($merchant_id)){               
                    try {                     
                    //  $resp = StripeWrapper::retrievePaymentIntent($credentials['secret_key'],$payment_gateway_ref);
                      //dump($resp); die();
                      if($data['status']=="paid"){
                          

                        $redirec_link = $redirec_link."&msg=already paid";
                      header("Location: " . $redirec_link);
                      exit();



                      } else {                        
                        $this->functions->updateOrderPayment($order_id,'stp',
                        $payment_gateway_ref,$resp,$reference_id);

                        $this->mobileWrapper->clearCartByCustomerID($client_id);

                        $this->mobileWrapper->sendNotification($order_id);

                        $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
                       if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}

                       $params_update=array( 
                      
                      'order_number'=>$order_number, 
                    );  

                       $this->functions->updateData('mt_order', $params_update,'order_id',$order_id);
                        $msg="Payment successfull";
                        $redirect_link=Config::$baseUrl . "/webappv2/stripe/success?message=".$msg;
                        header('Location: ' . $redirect_link);
                        exit;
                                                                          
                      }
                    } catch (Exception $e) {
                

                $error = $this->functions->translation("default","Caught exception: ".$e->getMessage());

              }                 
                  } else $error = $this->functions->translation("default","invalid payment credentials");       
          } else $error = $this->functions->translation("default","Failed getting order information");      
          break;
          
       
        
      
        default:

          

          $error = $this->functions->translation("default","invalid transaction type: ".$trans_type);

          break;
      }     
    } else $error = $this->functions->translation("default","Sorry but we cannot find what your are looking for.");
    
    if(!empty($error)){
         $redirect_link=Config::$baseUrl . "/webappv2/stripe/error?error=".$error;
         header('Location: ' . $redirect_link);




        }
    
}


  




    public function verify()
{

$get = $_GET;$error = '';
    $post = $_POST;
    $back_url = Config::$baseUrl."/store/confirmorder";


    $reference_id =$_SESSION['reference_id_stp'];
    $trans_type = "order";  

   

    if(!empty($reference_id)){      
            
      switch ($trans_type) {
        case "order":
          if ($data = $this->functions->getOrderInfoByToken_appside($reference_id)){
            $payment_gateway_ref=isset($data['payment_gateway_ref'])?$data['payment_gateway_ref']:'';       
            $merchant_id=isset($data['merchant_id'])?$data['merchant_id']:''; 
                  $client_id = $data['client_id'];
                  $order_id = $data['order_id'];
                  
                  

                  $redirec_link=Config::$baseUrl."/webappv2/stripe/success?id=".$order_id;

                         
                  if($credentials = $this->functions->getCredentials_stripe($merchant_id)){               
                    try {                     
                    //  $resp = StripeWrapper::retrievePaymentIntent($credentials['secret_key'],$payment_gateway_ref);
                      //dump($resp); die();
                      if($data['status']=="paid"){
                          

                        $redirec_link = $redirec_link."&msg=already paid";
                      header("Location: " . $redirec_link);
                      exit();



                      } else {                        
                        $this->functions->updateOrderPayment($order_id,'stp',
                        $payment_gateway_ref,$resp,$reference_id);

                        $this->mobileWrapper->executeAddons($order_id);

                        $this->mobileWrapper->clearCartByCustomerID($client_id);

                        

                        $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
                       if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}

                       $params_update=array( 
                      
                      'order_number'=>$order_number, 
                      'gateway_status'=>'succeeded'
                    );  

                       unset($_SESSION['reference_id_stp']);
                       $this->functions->updateData('mt_order', $params_update,'order_id',$order_id);

                       $this->mobileWrapper->sendNotification($order_id);


                        $msg="Payment successfull";
                        $redirect_link=Config::$baseUrl . "/webappv2/stripe/success?message=".$msg;
                        header('Location: ' . $redirect_link);
                        exit;
                                                                          
                      }
                    } catch (Exception $e) {
                

                $error = $this->functions->translation("default","Caught exception: ".$e->getMessage());

              }                 
                  } else $error = $this->functions->translation("default","invalid payment credentials");       
          } else $error = $this->functions->translation("default","Failed getting order information");      
          break;
          
       
        
      
        default:

          

          $error = $this->functions->translation("default","invalid transaction type: ".$trans_type);

          break;
      }     
    } else $error = $this->functions->translation("default","Sorry but we cannot find what your are looking for.");
    
    if(!empty($error)){
         $redirect_link=Config::$baseUrl . "/webappv2/stripe/error?error=".$error;
         header('Location: ' . $redirect_link);




        }
    
}













public function success()
    {

   /* $redirect_turl=$this->functions->websiteUrl()."/order-now/order/receipt";
    header("Location: " . $redirect_turl);
    exit;*/
   $order_id=$_SESSION['order_id'];
    $params=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>"paid",
                        'remarks'=>"success"
                      
                        ); 

    $this->functions->insertData('mt_order_log', $params); 

    unset($_SESSION['order_id']);

    

    $redirect_url_w = $_SESSION['stp_redirect_url'];

    echo '<script type="text/javascript">';
    echo 'window.location.href = "' . $redirect_url_w . '";';
    echo '</script>';
    exit;

    }



    public function error()
    {

        $order_id=$_SESSION['order_id'];
    $params=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>"not paid",
                        'remarks'=>"error"
                      
                        ); 

    $this->functions->insertData('mt_order_log', $params); 
    unset($_SESSION['order_id']);


        $error = isset($_GET['error'])?$_GET['error']:'';
        if(!empty($error)){
            echo $error;
        } else echo "undefined error";
    }
    
    public function cancel()
    {
    /*$redirect_turl=$this->functions->websiteUrl()."/order-now/order/payment_option";
    header("Location: " . $redirect_turl);
    exit;*/

    $order_id=$_SESSION['order_id'];
    $params=array( 
                        'order_id'=>$order_id, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>"not paid",
                        'remarks'=>"cancel"
                      
                        ); 

    $this->functions->insertData('mt_order_log', $params); 
    unset($_SESSION['order_id']);

     $redirect_url_cancel=$_SESSION['stp_cancel_url'];

      echo '<script type="text/javascript">';
    echo 'window.location.href = "' . $redirect_url_cancel . '";';
    echo '</script>';
    exit;
        
    }
    
    
    
    
    
}
/*end class*/