<?php
class Functions {
    protected $db;
    public $data;
    public $sms_msg;
    
    public $code=2;
    public $msg;
    public $details; 
    public $db_ext;
    public $has_session=false;  
    
    public $search_result_total=0;
    
    public $additional_details;

    public  $currency_code = '';    
public $distance_type_result = '';  

    public static $number_format = array(
        'decimals' => 2,
        'decimal_separator' => '.',
        'thousand_separator' => '',
        'position' => "left",
        'spacer' => " ",
        'currency_symbol' => "",
        'show_symbol' => true
    );

    public function __construct() {
    // Get the DB instance
    $model = Model::getInstance();
    $this->db = $model->getDb();

    $this->distance_type_result = "";

    // Try to load currency from settings
    try {
        $this->curr_code= $this->getOptionAdmin("admin_currency_set");

         if (empty($curr_code)) {

            $this->curr_code = "USD";

        }
		 $this->curr_code;
        $stmt = "SELECT * FROM mt_currency WHERE currency_code = ? LIMIT 1";
        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        $cmd = $this->db->prepare($stmt);
        //$cmd->execute([$curr_code]);
		//$cmd->execute([$this->curr_code]);
		    $cmd->execute([$curr_code]);

        if ($res = $cmd->fetch(PDO::FETCH_ASSOC)) {
				
             $this->curr_code = $res['currency_symbol'];
        } else {
            $this->curr_code = "$";
        }

    } catch (PDOException $e) {
        $this->curr_code = "$";
        // Optional: log or report error
        // error_log("Currency fetch error: " . $e->getMessage());
    }
 


}



   public function initPriceFormatter($currency = 'USD')
{
    

    $this->currency_code = $currency;
    $res = array();
    
   

            $stmt = $this->db->prepare("
            SELECT option_name, option_value
            FROM mt_option
            WHERE option_name IN (
                'admin_decimal_separator', 'admin_currency_set', 'admin_currency_position',
                'admin_add_space_between_price', 'admin_use_separators', 'admin_thousand_separator', 'admin_decimal_place'
            )
        ");   

        $stmt->execute();
        $options = $stmt->fetchAll(PDO::FETCH_ASSOC); 
     $new_data = array();

     if(isset($options)&&!empty($options)){
        foreach ($options as $val) {
            $new_data[$val['option_name']] = $val['option_value'];
        }
        
        $decimal_separator = isset($new_data['admin_decimal_separator']) ? $new_data['admin_decimal_separator'] : '.';
        $currency_set = isset($new_data['admin_currency_set']) ? $new_data['admin_currency_set'] : 'USD';
        $currency_position = isset($new_data['admin_currency_position']) ? $new_data['admin_currency_position'] : '';
        $space_between_price = isset($new_data['admin_add_space_between_price']) ? $new_data['admin_add_space_between_price'] : '';
        $use_separators = isset($new_data['admin_use_separators']) ? $new_data['admin_use_separators'] : '';
        $thousand_separator = isset($new_data['admin_thousand_separator']) ? $new_data['admin_thousand_separator'] : '';
        $decimal_place = isset($new_data['admin_decimal_place']) ? $new_data['admin_decimal_place'] : '';
        
        if ($space_between_price == 1) {
            $currency_position = $currency_position == "right" ? "right_space" : "left_space";
        }
        
        if ($use_separators == "yes") {
            $thousand_separator = !empty($thousand_separator) ? $thousand_separator : ",";
        }
        
        $res = array(
            'currency_code' => $currency_set,
            'currency_symbol' => $this->getSymbol($currency_set),
            'currency_position' => $currency_position,
            'number_decimal' => $decimal_place,
            'decimal_separator' => !empty($decimal_separator) ? $decimal_separator : '.',
            'thousand_separator' => $thousand_separator
        );
    }
    
    if ($res) {
        $spacer = ""; $currency_position = $res['currency_position'];
        switch ($res['currency_position']) {
            case "left_space":
                $spacer = " ";
                $currency_position = "left";
                break;
                
            case "right_space":
                $spacer = " ";
                $currency_position = "right";
                break;
            
            default:
                break;
        }
        
        self::$number_format = array(
            'decimals' => $res['number_decimal'],
            'decimal_separator' => $res['decimal_separator'],
            'thousand_separator' => $res['thousand_separator'],
            'position' => $currency_position,
            'spacer' => $spacer,
            'currency_symbol' => $res['currency_symbol']
        );
    }
}

public  function getLocationDefaultCountry()
   {
        $country_id=$this->getOptionAdmin('location_default_country'); $state_ids='';
        if(empty($country_id)){
            if($res=$this->getCountryByCode()){              
                $country_id=$res['country_id'];
            }
        }
        return $country_id;
   }

   public function getdistance_type_result(){
    return $this->distance_type_result;
   }

   public  function getCommissionStatusBased($formated_query=true)
    {
        $commission_status=$this->getOptionAdmin('total_commission_status');
        if(!empty($commission_status)){
            $commission_status=json_decode($commission_status,true);            
            if($formated_query){
                $_stats='';
                foreach ($commission_status as $stats) {
                    $_stats.="'$stats',";
                }
                $_stats=substr($_stats,0,-1);
                return $_stats;
            } else return $commission_status;
        }
        return false;
    }


  public function getOrderInfoByTokenWithCustomerName($order_id_token = '')
{
    if (empty($order_id_token)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT 
            a.order_id, 
            a.merchant_id, 
            a.order_id_token, 
            a.status, 
            CONCAT(b.first_name, ' ', b.last_name) AS customer_name, 
            CONCAT(c.first_name, ' ', c.last_name) AS client_name, 
            c.contact_email 
        FROM mt_order a
        LEFT JOIN mt_client b ON a.client_id = b.client_id
        LEFT JOIN mt_order_delivery_address c ON a.order_id = c.order_id
        WHERE a.order_id_token = :order_id_token
        LIMIT 1
    ");

    $stmt->bindParam(':order_id_token', $order_id_token, PDO::PARAM_STR);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        if (!empty($res['client_name'])) {
            $res['customer_name'] = $res['client_name'];
        }
        return $res;
    }

    return false;
}


public function calculate_starting_date($merchant_id)
{
    $today = new DateTime();

    try {
        $stmt = $this->db->prepare("
            SELECT MAX(date) as max_date 
            FROM mt_booking_slots 
            WHERE merchant_id = ?
        ");
        $stmt->execute([$merchant_id]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);

        if (!empty($row['max_date'])) {
            $maxDate = new DateTime($row['max_date']);
            $maxDate->modify('+1 day');

            // Ensure starting date is at least today
            if ($maxDate < $today) {
                $maxDate = clone $today;
            }

            return $maxDate->format('Y-m-d');
        }

    } catch (Exception $e) {
        // Optional: log error
    }

    // Default: today if no result or exception
    return $today->format('Y-m-d');
}




public function displayDate($date_to_format='')
    {
        if ( $date_to_format==""){
            return '';
        } else {
            $date=date('M d,Y G:i:s',strtotime($date_to_format));  
            $date=$this->translateDate($date);
            return $date;
        }
    }


    public function unlock_allcarts($device_id = "")
{
    if (empty($device_id)) {
        return false; // no device ID provided
    }

    $stmt = $this->db->prepare("
        UPDATE mt_pos_cart
        SET 
            lock_flag = 0,
            lock_user_id = ''
        WHERE current_device_id = :device_id
    ");

    return $stmt->execute([
        ':device_id' => $device_id
    ]);
}








    public function getCityList($stated_id = 0)
{
    $and = "";
    $data = [];

    if ($stated_id <= 0) {
        $country_id = $this->getOptionAdmin('location_default_country');
        $state_ids = '';

        if (empty($country_id)) {
            if ($res = $this->getCountryByCode()) {
                $country_id = $res['country_id'];
            }
        }

        if (!empty($country_id)) {
            if ($res = $this->locationStateList($country_id)) {
                $state_ids_array = array_map(function ($val) {
                    return $val['state_id'];
                }, $res);
                if (!empty($state_ids_array)) {
                    $state_ids = implode(",", array_map('intval', $state_ids_array));
                }
            }
        }

        if (!empty($state_ids)) {
            $and .= " AND state_id IN ($state_ids) ";
        }
    } else {
        $and .= " AND state_id = :state_id ";
    }

    $stmt = "SELECT city_id, name FROM mt_location_cities WHERE 1 $and ORDER BY name ASC LIMIT 10";

    try {
        $query = $this->db->prepare($stmt);

        if ($stated_id > 0) {
            $query->bindParam(':state_id', $stated_id, PDO::PARAM_INT);
        }

        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                $data[] = [
                    'id'   => $val['city_id'],
                    'name' => $val['name']
                ];
            }
        }
    } catch (PDOException $e) {
        return false; // Return false in case of an error
    }

    return !empty($data) ? $data : false;
}



public function inventory_datatable_format($cols = array(), $data = array())
{
    $resp = [
        'where' => '',
        'order' => '',
        'limit' => ''
    ];

    $order = '';
    $limit = '';

    if (is_array($data) && count($data) >= 1) {
        // Handle ordering
        if (isset($data['order']) && is_array($data['order']) && count($data['order']) >= 1) {
            foreach ($data['order'] as $val) {
                if (array_key_exists($val['column'], (array) $cols)) {
                    $order = "ORDER BY " . htmlspecialchars($cols[$val['column']]) . " " . htmlspecialchars($val["dir"]);
                }
            }
            if (!empty($order)) {
                $resp['order'] = $order;
            }
        }

        // Handle limiting
        if (isset($data['start']) && isset($data['length'])) {
            $limit = "LIMIT " . intval($data['start']) . "," . intval($data['length']);
            $resp['limit'] = $limit;
        } else {
            $resp['limit'] = "LIMIT 0,10";
        }
    }

    return $resp;
}


public  function merchantChangeStatus_emailtpl()
    {    
      return <<<HTML
      <p>hi {owner_name}<br/></p>
      <p>your merchant {restaurant_name} has change status to {status}</p>
      <br/>
      <p>{website_title}</p>
      <p>Thank you.</p> 
HTML;
    }


    public function getReviewByOrder($client_id = '', $order_id = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_review 
        WHERE client_id = :client_id 
        AND order_id = :order_id 
        LIMIT 1
    ");
    
    $stmt->execute([
        ':client_id' => $client_id,
        ':order_id' => $order_id
    ]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res ? $res : false;
}


public function locationCountry($country_id = '')
{
    $stmt = $this->db->prepare("SELECT * FROM mt_location_countries WHERE country_id = :country_id LIMIT 1");
    $stmt->bindParam(':country_id', $country_id, PDO::PARAM_INT);
    $stmt->execute();
    
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }
    
    return false;
}


public  function smsBalance_widget()
  {
    $enabled=$this->getOptionAdmin("mechant_sms_enabled");
    if ( $enabled==""):
    ?>
    <div class="sms_credit_wrap" style="margin-left:5px;">
    <p style="margin:6px 0px 0px 0px !important"><?php echo $this->translation("default","SMS Credits")?>: <?php echo $this->getMerchantSMSCredit($this->getMerchantID());?></p>
    </div>
    <?php
    endif;
  }


public function getCountryByID($country_id = '')
{
    if (empty($country_id)) {
        return false;
    }

    $stmt = $this->db->prepare("SELECT * FROM mt_location_countries WHERE country_id = :country_id LIMIT 1");
    $stmt->bindParam(':country_id', $country_id, PDO::PARAM_INT);
    $stmt->execute();

    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    return $res ?: false;
}

 public function getInvoiceByID($invoice_id = '')
{
    $stmt = "
        SELECT 
            invoice_number,
            invoice_token,
            viewed,
            pdf_filename,
            status,
            payment_status
        FROM mt_invoice
        WHERE
            invoice_number = ".($invoice_id)."
        LIMIT 0,1
    ";

    try {
        $query = $this->db->query($stmt);
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            return $res[0];
        }
    } catch (Exception $e) {
        // handle error if needed
        return false;
    }

    return false;
}


public  function invoicePaymentStatusList()
    {
        return array(
          'unpaid'=>"unpaid",
          'paid'=>"paid",
          'pending'=>"pending",
          'denied'=>"denied",          
        );
    }

    public function getInvoiceHistory($invoice_id = '')
{
    if (empty($invoice_id)) {
        return false;
    }

    $stmt = "
        SELECT 
            a.*
        FROM mt_invoice_history a
        WHERE
            invoice_number = " . ($invoice_id) . "
        ORDER BY id DESC
    ";

    if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}
   


  

public function getStateByID($state_id = '')
{
    if (empty($state_id)) {
        return false;
    }

    $stmt = $this->db->prepare("SELECT * FROM mt_location_states WHERE state_id = :state_id LIMIT 1");
    $stmt->bindParam(':state_id', $state_id, PDO::PARAM_INT);
    $stmt->execute();

    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    return $res ?: false;
}


public function getCityByID($city_id = '')
{
    try {
        $stmt = $this->db->prepare("SELECT * FROM mt_location_cities WHERE city_id = :city_id LIMIT 1");
        $stmt->execute([':city_id' => $city_id]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        return $result ? $result : false;
    } catch (Exception $e) {
        return false;
    }
}


public function getAreaLocation($area_id = '')
{
    $stmt = $this->db->prepare("SELECT * FROM mt_location_area WHERE area_id = :area_id LIMIT 1");
    $stmt->execute([':area_id' => $area_id]);

    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    return $res ? $res : false;
}








public function getSizebyname($size_name = '', $mt_id = '')
{
    try {
        $stmt = $this->db->prepare("SELECT * FROM mt_size WHERE size_name = :size_name AND merchant_id = :merchant_id LIMIT 0,1");
        $stmt->bindParam(':size_name', $size_name, PDO::PARAM_STR);
        $stmt->bindParam(':merchant_id', $mt_id, PDO::PARAM_INT);
        $stmt->execute();
        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
        return false;
    } catch (PDOException $e) {
        // Log or handle the exception as needed
        return false;
    }
}


public  function deleteUploadedFile($filename='', $folder='')
    {
        $path=self::uploadPath();
        if(!empty($folder)){
            $path.="/$folder";
        }   
        if(!empty($filename)){
            $file_to_delete = $path."/$filename";
            if(file_exists($file_to_delete)){
                @unlink($file_to_delete);
            }
        }
    }


public function getCategorybyname($name = '', $mid='')
{
    try {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_category 
            WHERE category_name LIKE :name 
            AND merchant_id = :merchant_id 
            ORDER BY cat_id DESC
        ");
        $likeName = "%$name%";
        $stmt->bindParam(':name', $likeName, PDO::PARAM_STR);
        $stmt->bindParam(':merchant_id', $mid, PDO::PARAM_INT);
        $stmt->execute();
        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
        return false;
    } catch (PDOException $e) {
        // Log or handle the exception as needed
        return false;
    }
}


 public  function notifyBooking($data='')
   {       


    
       if(isset($data['date_booking'])){
          $data['date_booking']=$this->prettyDate($data['date_booking']);
       }       
      
       $lang='en'; 
       $sender=$this->getOptionAdmin("global_admin_sender_email");
       
       
       /*NOTIFY CUSTOMER EMAIL*/
       $enabled=$this->getOptionAdmin("customer_booked_email");
       if($enabled==1){
          $tpl=$this->getOptionAdmin("customer_booked_tpl_content_$lang");
          $subject=$this->getOptionAdmin("customer_booked_tpl_subject_$lang");
          
          $email=isset($data['email'])?$data['email']:'';
          
          $pattern=array(           
           'customer_name'=>"booking_name",
           'restaurant_name'=>'restaurant_name',    
           'number_guest'=>'number_guest',
           'date_booking'=>'date_booking',
           'time'=>"booking_time",
           'email'=>"email",
           'mobile'=>"mobile",
           'instruction'=>"booking_notes",
           'booking_id'=>"booking_id",
           'status'=>'status',
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),                     
          );

          
          //$tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
          $tpl=$this->buildBookingEmail_customer($tpl,$pattern,$data);
         
          

          $subject=$this->replaceTemplateTags($subject,$pattern,$data);
          
          $params=array(
           'email_address'=>$email,
           'sender'=>$sender,
           'subject'=>$subject,
           'content'=>$tpl,
           'date_created'=>$this->dateNow(),
           'ip_address'=>$_SERVER['REMOTE_ADDR'],
           'module_type'=>'core'
          );                                  
          
          $this->insertData("mt_email_logs",$params);         
       }
       
       /*NOTIFY ADMIN*/
       $enabled=$this->getOptionAdmin("booked_notify_admin_email");
       if($enabled==1){
          $tpl=$this->getOptionAdmin("booked_notify_admin_tpl_content_$lang");
          $subject=$this->getOptionAdmin("booked_notify_admin_tpl_subject_$lang");
          
          $email=$this->getOptionAdmin("noti_booked_admin_email");
          
          $pattern=array(           
           'customer_name'=>"booking_name",
           'restaurant_name'=>'restaurant_name',    
           'number_guest'=>'number_guest',
           'date_booking'=>'date_booking',
           'time'=>"booking_time",
           'email'=>"email",
           'mobile'=>"mobile",
           'instruction'=>"booking_notes",
           'booking_id'=>"booking_id",
           'status'=>'status',
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),                     
          );
          //$tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
          $tpl=$this->buildBookingEmail_admin($tpl,$pattern,$data);

          

          $subject=$this->replaceTemplateTags($subject,$pattern,$data);
          
          //dump($email);dump($subject);dump($tpl);
          
          $email=explode(",",$email);
          if(is_array($email) && count($email)>=1){
             foreach ($email as $email_val) {                            
                  $params=array(
                   'email_address'=>$email_val,
                   'sender'=>$sender,
                   'subject'=>$subject,
                   'content'=>$tpl,
                   'date_created'=>$this->dateNow(),
                   'ip_address'=>$_SERVER['REMOTE_ADDR'],
                   'module_type'=>'core'
                  );                                  
                  
                  $this->insertData("mt_email_logs",$params);         
             }
          }
       }
       
       
       /*NOTIFY MERCHANT*/
       $enabled=$this->getOptionAdmin("booked_notify_merchant_email");
       if($enabled==1){
          $tpl=$this->getOptionAdmin("booked_notify_merchant_tpl_content_$lang");
          $subject=$this->getOptionAdmin("booked_notify_merchant_tpl_subject_$lang");
          
          $email=$this->getOption('merchant_booking_receiver',$data['merchant_id_our_system']);



         $booking_details=$this->getBooking_idwise($data['booking_id_our_system']);

         $booking_token=$booking_details['token'];
          

         $cancel_link = Config::$baseUrl . '/cron/booking_cancel_from_email?booking_id=' . $data['booking_id_our_system'] . '&token=' . $booking_token;

         $approve_link =Config::$baseUrl.'/cron/booking_approve_from_email?booking_id='.$data['booking_id_our_system']. '&token=' . $booking_token; 
         


          
          $pattern=array(           
           'customer_name'=>"booking_name",
           'restaurant_name'=>'restaurant_name',    
           'number_guest'=>'number_guest',
           'date_booking'=>'date_booking',
           'time'=>"booking_time",
           'email'=>"email",
           'mobile'=>"mobile",
           'instruction'=>"booking_notes",
           'booking_id'=>"booking_id",
            
           'accept_link'=>$approve_link,   
           'decline_link'=>$cancel_link,


           'status'=>'status',
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),                     
          );
          //$tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
          $tpl=$this->buildBookingEmail($tpl,$pattern,$data);
          $subject=$this->replaceTemplateTags($subject,$pattern,$data);

          //echo $tpl;die();
          
          //dump($email);dump($subject);dump($tpl);
          
          $email=explode(",",$email);
          if(is_array($email) && count($email)>=1){
             foreach ($email as $email_val) {                                           
                  $params=array(
                   'email_address'=>$email_val,
                   'sender'=>$sender,
                   'subject'=>$subject,
                   'content'=>$tpl,
                   'date_created'=>$this->dateNow(),
                   'ip_address'=>$_SERVER['REMOTE_ADDR'],
                   'module_type'=>'core'
                  );                                  
                  
                  $this->insertData("mt_email_logs",$params);       
             }
          }            
       }
       
     

              
       /*SEND PUSH TO MERCHANT APP V2*/
                    
           

          require __DIR__ . '/../../app/modules/merchantappv2/components/OrderWrapper.php';   
          $this->OrderWrapper = new OrderWrapper();

            $this->OrderWrapper->InsertOrderTrigger(
               isset($data['booking_id'])?$data['booking_id']:'',
               'booked_notify_merchant',
               isset($data['booking_notes'])?$data['booking_notes']:'',
               'booking'
            );
        
       
       //unset($DbExt);
       //FunctionsV3::runCronEmail();
   }

   public function buildBookingEmail_customer($tpl = '', $pattern = [], $data = [])
{
    // Remove all line breaks and minify the HTML
    $html = '<div style="font-family:Arial,sans-serif;color:#333;line-height:1.6;margin:0;padding:0;"><h2 style="color:#444;margin:0 0 16px 0;">Booking Confirmation</h2><p style="margin:0 0 16px 0;">Hi ' . htmlspecialchars($data[$pattern['customer_name']] ?? '') . '</p><p style="margin:0 0 16px 0;">Thank you for your reservation with ' . htmlspecialchars($pattern['sitename'] ?? 'Our Restaurant') . '. We will get back to you soon as possible with the confirmation of the booking.</p><p style="margin:0 0 16px 0;"><strong>Your Reservation Details:</strong></p><p style="margin:0 0 16px 0;">********************</p><table border="0" cellpadding="6" cellspacing="0" width="100%" style="border-collapse:collapse;margin:16px 0;"><tr><td width="40%"><strong>Booking id :</strong></td><td>' . htmlspecialchars($data[$pattern['booking_id']] ?? '') . '</td></tr><tr><td><strong>Number of guest :</strong></td><td>' . htmlspecialchars($data[$pattern['number_guest']] ?? '') . '</td></tr><tr><td><strong>Date of Booking :</strong></td><td>' . date("M d, Y", strtotime($data[$pattern['date_booking']] ?? '')) . '</td></tr><tr><td><strong>Time :</strong></td><td>' . htmlspecialchars($data[$pattern['time']] ?? '') . '</td></tr><tr><td><strong>Email address :</strong></td><td>' . htmlspecialchars($data[$pattern['email']] ?? '') . '</td></tr><tr><td><strong>Mobile :</strong></td><td>' . htmlspecialchars($data[$pattern['mobile']] ?? '') . '</td></tr><tr><td><strong>Special instruction :</strong></td><td>' . htmlspecialchars($data[$pattern['instruction']] ?? '') . '</td></tr></table><p style="font-size:13px;color:#888;margin:32px 0 0 0;">Regards,<br><strong>' . htmlspecialchars($pattern['sitename'] ?? 'Our Restaurant') . '</strong><br><a href="' . htmlspecialchars($pattern['siteurl'] ?? '#') . '" style="color:#007bff;text-decoration:none;">' . htmlspecialchars($pattern['siteurl'] ?? '') . '</a></p></div>';

    return $html;
}


   public function buildBookingEmail_admin($tpl = '', $pattern = [], $data = [])
{
    // Remove all line breaks and minify the HTML
    $html = '<div style="font-family:Arial,sans-serif;color:#333;line-height:1.6;margin:0;padding:0;"><h2 style="color:#444;margin:0 0 16px 0;">New Booking Received</h2><p style="margin:0 0 16px 0;">hi admins</p><p style="margin:0 0 16px 0;">there is new booking from <strong>' . htmlspecialchars($data[$pattern['customer_name']] ?? '') . '</strong></p><p style="margin:0 0 16px 0;">with the following information</p><table border="0" cellpadding="6" cellspacing="0" width="100%" style="border-collapse:collapse;margin:16px 0;"><tr><td width="40%"><strong>Booking ID :</strong></td><td>' . htmlspecialchars($data[$pattern['booking_id']] ?? '') . '</td></tr><tr><td><strong>Name :</strong></td><td>' . htmlspecialchars($data[$pattern['customer_name']] ?? '') . '</td></tr><tr><td><strong>Number of guest :</strong></td><td>' . htmlspecialchars($data[$pattern['number_guest']] ?? '') . '</td></tr><tr><td><strong>Date of Booking :</strong></td><td>' . date("M d, Y", strtotime($data[$pattern['date_booking']] ?? '')) . '</td></tr><tr><td><strong>Time :</strong></td><td>' . htmlspecialchars($data[$pattern['time']] ?? '') . '</td></tr><tr><td><strong>Email address :</strong></td><td>' . htmlspecialchars($data[$pattern['email']] ?? '') . '</td></tr><tr><td><strong>Mobile :</strong></td><td>' . htmlspecialchars($data[$pattern['mobile']] ?? '') . '</td></tr><tr><td><strong>Special instruction :</strong></td><td>' . htmlspecialchars($data[$pattern['instruction']] ?? '') . '</td></tr></table><p style="font-size:13px;color:#888;margin:32px 0 0 0;">Thank you,<br><strong>' . htmlspecialchars($pattern['sitename'] ?? 'Our Restaurant') . '</strong><br><a href="' . htmlspecialchars($pattern['siteurl'] ?? '#') . '" style="color:#007bff;text-decoration:none;">' . htmlspecialchars($pattern['siteurl'] ?? '') . '</a></p></div>';

    return $html;
}


   public function buildBookingEmail($tpl = '', $pattern = [], $data = [])
{
    $approveLink = isset($pattern['accept_link']) ? $pattern['accept_link'] : '#';
    $declineLink = isset($pattern['decline_link']) ? $pattern['decline_link'] : '#';

    // Remove all line breaks and minify the HTML
    $html = '<div style="font-family:Arial,sans-serif;color:#333;line-height:1.6;margin:0;padding:0;"><h2 style="color:#444;margin:0 0 16px 0;">New Booking Received</h2><p style="margin:0 0 16px 0;">Hello,</p><p style="margin:0 0 16px 0;">There is a new booking from <strong>' . htmlspecialchars($data[$pattern['customer_name']] ?? '') . '</strong> with the following details:</p><table border="0" cellpadding="6" cellspacing="0" width="100%" style="border-collapse:collapse;margin:16px 0;"><tr><td width="40%"><strong>Booking ID:</strong></td><td>' . htmlspecialchars($data[$pattern['booking_id']] ?? '') . '</td></tr><tr><td><strong>Name:</strong></td><td>' . htmlspecialchars($data[$pattern['customer_name']] ?? '') . '</td></tr><tr><td><strong>Number of Guests:</strong></td><td>' . htmlspecialchars($data[$pattern['number_guest']] ?? '') . '</td></tr><tr><td><strong>Date of Booking:</strong></td><td>' . date("M d, Y", strtotime($data[$pattern['date_booking']] ?? '')) . '</td></tr><tr><td><strong>Time:</strong></td><td>' . htmlspecialchars($data[$pattern['time']] ?? '') . '</td></tr><tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($data[$pattern['email']] ?? '') . '</td></tr><tr><td><strong>Mobile:</strong></td><td>' . htmlspecialchars($data[$pattern['mobile']] ?? '') . '</td></tr><tr><td><strong>Special Instruction:</strong></td><td>' . htmlspecialchars($data[$pattern['instruction']] ?? '') . '</td></tr></table><table border="0" cellpadding="0" cellspacing="0" style="margin:32px 0;"><tr><td align="left" bgcolor="#28a745" style="border-radius:5px;"><a href="' . $approveLink . '" target="_blank" style="font-size:14px;font-family:Arial,sans-serif;color:#ffffff;text-decoration:none;padding:10px 20px;display:inline-block;">Approve Booking</a></td><td width="15"></td><td align="left" bgcolor="#dc3545" style="border-radius:5px;"><a href="' . $declineLink . '" target="_blank" style="font-size:14px;font-family:Arial,sans-serif;color:#ffffff;text-decoration:none;padding:10px 20px;display:inline-block;">Reject Booking</a></td></tr></table><p style="font-size:13px;color:#888;margin:32px 0 0 0;">Thank you,<br><strong>' . htmlspecialchars($pattern['sitename'] ?? 'Our Restaurant') . '</strong><br><a href="' . htmlspecialchars($pattern['siteurl'] ?? '#') . '" style="color:#007bff;text-decoration:none;">' . htmlspecialchars($pattern['siteurl'] ?? '') . '</a></p></div>';

    return $html;
}


public function buildBookingEmail_bkup($tpl = '', $pattern = [], $data = [])
{
    $approveLink = isset($pattern['accept_link']) ? $pattern['accept_link'] : '#';
    $declineLink = isset($pattern['decline_link']) ? $pattern['decline_link'] : '#';

    // Remove all line breaks and minify the HTML
    $html = '<div style="font-family:Arial,sans-serif;color:#333;line-height:1.6;margin:0;padding:0;"><h2 style="color:#444;margin:0 0 16px 0;">New Booking Received</h2><p style="margin:0 0 16px 0;">Hello,</p><p style="margin:0 0 16px 0;">There is a new booking from <strong>' . htmlspecialchars($data[$pattern['customer_name']] ?? '') . '</strong> with the following details:</p><table border="0" cellpadding="6" cellspacing="0" width="100%" style="border-collapse:collapse;margin:16px 0;"><tr><td width="40%"><strong>Booking ID:</strong></td><td>' . htmlspecialchars($data[$pattern['booking_id']] ?? '') . '</td></tr><tr><td><strong>Name:</strong></td><td>' . htmlspecialchars($data[$pattern['customer_name']] ?? '') . '</td></tr><tr><td><strong>Number of Guests:</strong></td><td>' . htmlspecialchars($data[$pattern['number_guest']] ?? '') . '</td></tr><tr><td><strong>Date of Booking:</strong></td><td>' . date("M d, Y", strtotime($data[$pattern['date_booking']] ?? '')) . '</td></tr><tr><td><strong>Time:</strong></td><td>' . htmlspecialchars($data[$pattern['time']] ?? '') . '</td></tr><tr><td><strong>Email:</strong></td><td>' . htmlspecialchars($data[$pattern['email']] ?? '') . '</td></tr><tr><td><strong>Mobile:</strong></td><td>' . htmlspecialchars($data[$pattern['mobile']] ?? '') . '</td></tr><tr><td><strong>Special Instruction:</strong></td><td>' . htmlspecialchars($data[$pattern['instruction']] ?? '') . '</td></tr></table><table border="0" cellpadding="0" cellspacing="0" style="margin:32px auto;"><tr><td align="center" bgcolor="#28a745" style="border-radius:5px;"><a href="' . $approveLink . '" target="_blank" style="font-size:16px;font-family:Arial,sans-serif;color:#ffffff;text-decoration:none;padding:12px 25px;display:inline-block;">Approve Booking</a></td><td width="20"></td><td align="center" bgcolor="#dc3545" style="border-radius:5px;"><a href="' . $declineLink . '" target="_blank" style="font-size:16px;font-family:Arial,sans-serif;color:#ffffff;text-decoration:none;padding:12px 25px;display:inline-block;">Reject Booking</a></td></tr></table><p style="font-size:13px;color:#888;margin:32px 0 0 0;">Thank you,<br><strong>' . htmlspecialchars($pattern['sitename'] ?? 'Our Restaurant') . '</strong><br><a href="' . htmlspecialchars($pattern['siteurl'] ?? '#') . '" style="color:#007bff;text-decoration:none;">' . htmlspecialchars($pattern['siteurl'] ?? '') . '</a></p></div>';

    return $html;
}

   













  public function generateSMSOrderCode($mobile = '')
{
    $code = $this->generateRandomKey(4);

    $stmt = "
    SELECT * FROM mt_order_sms
    WHERE mobile = :mobile
    AND code = :code
    LIMIT 1
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindValue(':mobile', $mobile, PDO::PARAM_STR);
        $query->bindValue(':code', $code, PDO::PARAM_STR);
        $query->execute();

        if ($query->fetch(PDO::FETCH_ASSOC)) {
            return $this->generateRandomKey(6);
        }

        return $code;
    } catch (PDOException $e) {
        return "Database error: " . $e->getMessage();
    }
}






   public function sendSMS($to='',$message='' , $record_id='')
    {
        $to=trim($to);
        $message=trim($message);
        
        $msg='';$raw='';
        $sms_provider=$this->getOptionAdmin('sms_provider');        
                        
        //if ($sms_provider=="nexmo"){    
        $sms_provider=strtolower($sms_provider);
        
        //dump($sms_provider);
                
        switch ($sms_provider) {
            
            


                case "smsglobal":
   /* $sms_sender_id = $this->getOptionAdmin('smsglobal_senderid');
    $sms_username = $this->getOptionAdmin('smsglobal_username'); // Global SMS Username
    $sms_password = $this->getOptionAdmin('smsglobal_password'); // Global SMS Password

    try {
        // Send SMS using the Global SMS HTTP API
        $resp = $this->send_sms_globalsms($sms_username, $sms_password, array(
            'to' => $to,
            'from' => $sms_sender_id,
            'message' => $message
        ));

        $msg = "process"; // Indicating success
        $raw = $resp;     // Storing the raw response from the API
    } catch (Exception $e) {
        $msg = $e->getMessage(); // Capture error message
    }*/
    try {
    $sms_sender_id = $this->getOptionAdmin('smsglobal_senderid');
    $sms_username = $this->getOptionAdmin('smsglobal_username'); // Global SMS Username
    $sms_password = $this->getOptionAdmin('smsglobal_password');
    $resp=$this->sendSms_globalsms($to, $message, $sms_sender_id, $sms_username, $sms_password);
    $msg="process";
    $raw = $resp;
    }catch (Exception $e){
                    $msg  = $e->getMessage();                   
    }
    
    break;



                
            
            
            
                    
            case "twilio":
                            
                    
                $sms_sender_id=$this->getOptionAdmin('sms_sender_id');
                $sms_account_id=$this->getOptionAdmin('sms_account_id');
                $sms_token=$this->getOptionAdmin('sms_token');
                try {                   
                    //TwilioWrapper::setCredentials($sms_account_id,$sms_token);
                    $resp = $this->send_sms_twillio($sms_account_id,$sms_token,array(
                      'To'=>$to,
                      'From'=>$sms_sender_id,
                      'Body'=>$message
                    ));
                    $msg="process";
                    $raw = $resp;
                } catch (Exception $e){
                    $msg  = $e->getMessage();                   
                }               
                break;      
                
                                
                                                    
            default:
               $msg="No sms gateway selected";
               break;       
                    
        }
        
        /*logs*/
        $params_logs=array(
          'contact_phone'=>$to,
          'sms_message'=>$message,
          'status'=>$msg,
          'gateway_response'=>$raw,
          'gateway'=>$sms_provider,
          'date_created'=>$this->dateNow(),
          'date_executed'=>$this->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        //dump($params_logs); die();
                
        
        if($record_id>0){
            $params_logs=array(
              'status'=>$msg,
              'gateway_response'=>$raw,
              'date_executed'=>$this->dateNow(),
              'gateway'=>$sms_provider,
              'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
            
            $this->updateData("mt_sms_broadcast_details",$params_logs,'id',$record_id);
            

        } else $this->insertData("mt_sms_broadcast_details",$params_logs);      
            
        
        return array(
          'msg'=>$msg,
          'raw'=>$raw,
          'sms_provider'=>$sms_provider
        );
    }


    public function update_payment_id($order_id,$payment_id){

       $params=array(
              'payment_gateway_ref'=>$payment_id,
              
            );

        $this->updateData("mt_order",$params,'order_id',$order_id);

    }




    public function sendSms_globalsms($to, $message, $sms_sender_id, $sms_username, $sms_password) {
    // Validate required parameters
    if (empty($sms_username)) {
        throw new Exception("Username is required");
    }
    if (empty($sms_password)) {
        throw new Exception("Password is required");
    }
    if (empty($to)) {
        throw new Exception("Destination number is required");
    }
    if (empty($message)) {
        throw new Exception("Message content is required");
    }
    if (empty($sms_sender_id)) {
        throw new Exception("Sender ID is required");
    }

    // Base URL for SMSGlobal API
    $smsGlobalURL = 'https://api.smsglobal.com/http-api.php?';

    // Build the query parameters
    $query = http_build_query([
        'action' => 'sendsms',
        'user' => $sms_username,
        'password' => $sms_password,
        'from' => $sms_sender_id,
        'to' => $to,
        'text' => $message,
    ]);

    // Complete URL
    $smsGlobalURL = $smsGlobalURL . $query;

    // Initialize cURL
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $smsGlobalURL);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    // Execute the request
    $output = curl_exec($ch);

    // Capture HTTP response code
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    // Close cURL
    curl_close($ch);

    // Check response and HTTP code
    if ($httpCode === 200) {
        // Check if the response contains success
        if (strpos($output, 'OK:') !== false) {
            return "SMS sent successfully!";
        } else {
            throw new Exception("Failed to send SMS. Response: $output");
        }
    } else {
        throw new Exception("HTTP Error: $httpCode. Response: $output");
    }
}



   public function sendSms_globalsms_bkup($to, $message, $sms_sender_id, $sms_username, $sms_password) {
    if (empty($sms_username)) {
        throw new Exception("Username is required");
    }
    if (empty($sms_password)) {
        throw new Exception("Password is required");
    }
    if (empty($to)) {
        throw new Exception("Destination number is required");
    }
    if (empty($message)) {
        throw new Exception("Message content is required");
    }
    if (empty($sms_sender_id)) {
        throw new Exception("Sender ID is required");
    }

    $url = "https://api.smsglobal.com/v2/sms/";

    $data = [
        'destination' => $to,
        'message' => $message,
        'origin' => $sms_sender_id,
    ];
     

    // Generate Authorization Header
    $authHeader = 'Basic ' . base64_encode("$sms_username:$sms_password");

    echo $authHeader;die();

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Authorization: ' . $authHeader,
        'Content-Type: application/json',
    ]);

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    curl_close($ch);

    if ($httpCode === 200) {
        $jsonResponse = json_decode($response, true);
        if (isset($jsonResponse['messages'][0]['messageId'])) {
            return $jsonResponse['messages'][0]['messageId'];
        } else {
            throw new Exception("Unexpected response: " . $response);
        }
    } else {
        throw new Exception("Failed to send SMS. Response: $response");
    }
}







    public function send_sms_twillio($sid='', $token='',$params=array()){
        if(empty($sid)){
            throw new Exception( ("Invalid account sid") );
        }
        if(empty($token)){
            throw new Exception( ("Invalid auth token") );
        }
        $sid = trim($sid); 
        $token=trim($token);


        $data = http_build_query($params);      
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.twilio.com/2010-04-01/Accounts/'.$sid.'/Messages.json');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data );
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_USERPWD, $sid . ':' . $token);
        
        $resp = curl_exec($ch);     
        if (curl_errno($ch)) {
            throw new Exception( curl_error($ch) );
        }
        curl_close($ch);
        
        if($json = json_decode($resp,true)){            
            if(isset($json['sid'])){
                return $json['sid'];
            } else {
                throw new Exception( $json['message'] );
            }
        } else throw new Exception( ("Invalid response from server") );


    }





public function getcookingname($size_name = '', $mt_id = '')
{
    try {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_cooking_ref 
            WHERE cooking_name = :cooking_name 
            AND merchant_id = :merchant_id 
            LIMIT 0,1
        ");
        $stmt->bindParam(':cooking_name', $size_name, PDO::PARAM_STR);
        $stmt->bindParam(':merchant_id', $mt_id, PDO::PARAM_INT);
        $stmt->execute();
        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
        return false;
    } catch (PDOException $e) {
        // Log or handle the exception as needed
        return false;
    }
}



 public  function updateBookingNotify($data='')
   {
       $lang='en'; 
       $sender=$this->getOptionAdmin("global_admin_sender_email");
         
       
       if($booking_details = $this->getBookingByIDWithDetails($data['booking_id'])){
          $data['restaurant_name']=$booking_details['restaurant_name'];
       }      
       
       $booking_status = isset($data['status'])?$data['status']:'';
       $data['status'] = ($data['status']);
       
       $enabled=$this->getOptionAdmin("booking_update_status_email");
       if($enabled==1){
          $tpl=$this->getOptionAdmin("booking_update_status_tpl_content_$lang");
          $subject=$this->getOptionAdmin("booking_update_status_tpl_subject_$lang");
          
          $email=isset($data['email'])?$data['email']:'';
          
          $pattern=array(           
           'customer_name'=>"booking_name",
           'restaurant_name'=>'restaurant_name',    
           'number_guest'=>'number_guest',
           'date_booking'=>'date_booking',
           'time'=>"booking_time",
           'email'=>"email",
           'mobile'=>"mobile",
           'instruction'=>"booking_notes",
           'booking_id'=>"booking_id",
           'booking_id_our_system'=>"booking_id_our_system",
           'status'=>'status',
           'merchant_remarks'=>'remarks',
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),                    
          );
         // $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
          $tpl=$this->buildupdatebookingemail($tpl,$pattern,$data);
          
          
          

          $subject=$this->replaceTemplateTags($subject,$pattern,$data);
          
          /*dump($email); dump($subject); dump($tpl);
          die();*/
          
          $params=array(
           'email_address'=>$email,
           'sender'=>$sender,
           'subject'=>$subject,
           'content'=>$tpl,
           'date_created'=>$this->dateNow(),
           'ip_address'=>$_SERVER['REMOTE_ADDR'],
           'module_type'=>'core'
          );                                  
         

          $this->insertData("mt_email_logs",$params);

       }
       
       
       
       
       
      
       
       /*MOBILE VERSION 2*/
        
            
            /*require __DIR__ . '/../../app/modules/mobileappv2/components/mobileWrapper.php';
            $this->mobileWrapper = new mobileWrapper();      */

            if (!class_exists('mobileWrapper')) {
            require __DIR__ . '/../../app/modules/mobileappv2/components/mobileWrapper.php';
            }
            $this->mobileWrapper = new mobileWrapper();  
                                                 
            $this->mobileWrapper->OrderTrigger($data['booking_id'],$booking_status,$data['remarks'],'booking');
            
        
       
       //unset($DbExt);
       //FunctionsV3::runCronEmail();
   }

   public function buildupdatebookingemail($tpl = '', $pattern = [], $data = [])
{
    // Remove all line breaks and minify the HTML
    $html = '<div style="font-family:Arial,sans-serif;color:#333;line-height:1.6;margin:0;padding:0;"><h2 style="color:#444;margin:0 0 16px 0;">Booking Update</h2><p style="margin:0 0 16px 0;">Hi ' . htmlspecialchars($data[$pattern['customer_name']] ?? '') . '</p><p style="margin:0 0 16px 0;">Your reservation at ' . htmlspecialchars($pattern['sitename'] ?? 'Our Restaurant') . '.</p><p style="margin:0 0 16px 0;"><strong>Your Reservation Details:</strong></p><p style="margin:0 0 16px 0;">********************</p><table border="0" cellpadding="6" cellspacing="0" width="100%" style="border-collapse:collapse;margin:16px 0;"><tr><td width="40%"><strong> Booking id :</strong></td><td>' . htmlspecialchars($data[$pattern['booking_id_our_system']] ?? '') . '</td></tr><tr><td><strong>Number of guest :</strong></td><td>' . htmlspecialchars($data[$pattern['number_guest']] ?? '') . '</td></tr><tr><td><strong>Date of Booking :</strong></td><td>' . date("M d, Y", strtotime($data[$pattern['date_booking']] ?? '')) . '</td></tr><tr><td><strong>Time :</strong></td><td>' . htmlspecialchars($data[$pattern['time']] ?? '') . '</td></tr><tr><td><strong>Email address :</strong></td><td>' . htmlspecialchars($data[$pattern['email']] ?? '') . '</td></tr><tr><td><strong>Mobile :</strong></td><td>' . htmlspecialchars($data[$pattern['mobile']] ?? '') . '</td></tr><tr><td><strong>Special instruction :</strong></td><td>' . htmlspecialchars($data[$pattern['instruction']] ?? '') . '</td></tr></table><p style="margin:0 0 16px 0;"><strong>merchant remarks :</strong><br>' . htmlspecialchars($data[$pattern['merchant_remarks']] ?? '') . '</p><p style="font-size:13px;color:#888;margin:32px 0 0 0;">Regards<br> - ' . htmlspecialchars($pattern['sitename'] ?? 'Love Eatery') . '</p></div>';

    return $html;
}



   public  function notifyCancelOrder($data=array())
    {
        if(!is_array($data) && count($data)<=0){
            return false;
        }
        
        $merchant_id = isset($data['merchant_id'])?$data['merchant_id']:'';
    
        $lang="en";
                
        $tpl_email_enabled = $this->getOptionAdmin('order_request_cancel_to_merchant_email');
        $tpl_sms_enabled = $this->getOptionAdmin('order_request_cancel_to_merchant_sms');
                        
        
        $pattern=array(                        
           'restaurant_name'=>'merchant_name',
           'customer_name'=>'full_name',
           'order_id'=>'order_id',
           'login_url'=>'login_url',               
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),        
        );
        
        $total_amount = $this->prettyPrice($data['total_w_tax']);
            
        /*EMAIL*/
        if($tpl_email_enabled==1){
            $email_subject = $this->getOptionAdmin("order_request_cancel_to_merchant_tpl_subject_$lang");
            $email_content = $this->getOptionAdmin("order_request_cancel_to_merchant_tpl_content_$lang");
                        
            $email_content=$this->replaceTemplateTags($email_content,$pattern,$data);
            $email_content = $this->smarty('total_order_amount',$total_amount,$email_content);
            
            $email_subject=$this->replaceTemplateTags($email_subject,$pattern,$data);
            $email_subject = $this->smarty('total_order_amount',$total_amount,$email_subject);
            
            if(is_numeric($merchant_id)){
                $email = $this->getOption('merchant_cancel_order_email',$merchant_id);
                $emails = explode(',',$email);
                if(is_array($emails) && count($emails)>=1){
                    foreach ($emails as $email_val) {
                       

                        $this->insertData("mt_email_logs",array(
                          'email_address'=>$emails,
                          'subject'=>$email_subject,
                          'content'=>$email_content,
                          'date_created'=>$this->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR']
                        ));
                    }
                }
            }       
                                    
        }
        
        /*SMS*/
        if($tpl_sms_enabled==1){
            $sms_content = $this->getOptionAdmin("order_request_cancel_to_merchant_sms_content_$lang");
            $sms_content=$this->replaceTemplateTags($sms_content,$pattern,$data);
            $sms_content = $this->smarty('total_order_amount',$total_amount,$sms_content);       
            
            $phone = $this->getOption('merchant_cancel_order_phone',$merchant_id);
            $phones = explode(",",$phone);
            if(is_array($phones) && count($phones)>=1){
                foreach ($phones as $phone_val) {                   
                    $this->sendSMS($phone_val,$sms_content);
                }
            }
        }       
                
      

        
        /*SEND NOTIFICATION TO ADMIN EMAIL*/
        $enabled = $this->getOptionAdmin('order_request_cancel_to_admin_email');
        if($enabled==1){
            $email = $this->getOptionAdmin('order_cancel_admin_email');
            $tpl =  $this->getOptionAdmin("order_request_cancel_to_admin_tpl_content_$lang"); 
            $subject =  $this->getOptionAdmin("order_request_cancel_to_admin_tpl_subject_$lang"); 
            
            $tpl = $this->replaceTemplateTags($tpl,$pattern,$data);
                        
            $tpl = $this->smarty('total_order_amount',$total_amount,$tpl);
            
            $subject = $this->replaceTemplateTags($subject,$pattern,$data);
            $subject = $this->smarty('total_order_amount',$total_amount,$subject);
            
            if(!empty($email)){
                $emails = explode(",",$email);
                if(is_array($emails) && count($emails)>=1){
                    foreach ($emails as $emal_val) {
                        $this->sendEmail($emal_val,'',$subject,$tpl);
                    }
                }
            }       
        }       
        /*END SEND NOTIFICATION TO ADMIN EMAIL*/
        
        /*SEND NOTIFICATION TO ADMIN SMS*/
        $enabled = $this->getOptionAdmin('order_request_cancel_to_admin_sms');
        if($enabled==1){
            $tpl_sms =  $this->getOptionAdmin("order_request_cancel_to_admin_sms_content_$lang");          
            $tpl_sms = $this->replaceTemplateTags($tpl_sms,$pattern,$data);                       
            $tpl_sms = $this->smarty('total_order_amount',$total_amount,$tpl_sms);           
            $order_cancel_admin_sms_phone = $this->getOptionAdmin('order_cancel_admin_sms');           
            if(!empty($order_cancel_admin_sms_phone)){
                $phones = explode(",",$order_cancel_admin_sms_phone);
                if(is_array($phones) && count($phones)>=1){
                    foreach ($phones as $phone_val) {
                        $this->sendSMS($phone_val,$tpl_sms);
                    }
                }
            }
        }   
        /*END SEND NOTIFICATION TO ADMIN SMS*/      

        /*SEND PUSH TO MERCHANT APP V2*/
                 
           require __DIR__ . '/../../app/modules/merchantappv2/components/OrderWrapper.php';
           $this->OrderWrapper = new OrderWrapper();
             $this->OrderWrapper->InsertOrderTrigger(
               isset($data['order_id'])?$data['order_id']:'',
               'order_request_cancel_to_merchant'
             );
              
        
    }



    public function getTodaysBookings()
{

    $merchant_id = $this->getMerchantID();
    try {
        $today = date("Y-m-d"); // current date (YYYY-MM-DD)
        
        $stmt = $this->db->prepare("
            SELECT COUNT(*) as total
            FROM mt_bookingtable
            WHERE merchant_id = ?
            AND DATE(date_booking) = ?
            AND status IN ('approved')
        ");
        
        $stmt->execute([$merchant_id, $today]);
        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res && isset($res['total'])) {
            return (int)$res['total'];
        }
        return 0;
    } catch (PDOException $e) {
        // log error if needed
        return 0;
    }
}





public function getsupplieridbyname($size_name = '', $mt_id = '')
{
    try {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_inventory_supplier 
            WHERE supplier_name = :supplier_name 
            AND merchant_id = :merchant_id 
            LIMIT 0,1
        ");
        $stmt->bindParam(':supplier_name', $size_name, PDO::PARAM_STR);
        $stmt->bindParam(':merchant_id', $mt_id, PDO::PARAM_INT);
        $stmt->execute();
        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
        return false;
    } catch (PDOException $e) {
        // Log or handle the exception as needed
        return false;
    }
}


public function checklskualready_itemwrap($merchant_id='',$params=array(), $item_id='',$raw_data=array())
    {   
                if(isset($raw_data['sku']) && !empty($raw_data['sku'])){
                    
                    
                        if(is_array($raw_data['sku']) && count($raw_data['sku'])>=1){
                            
                        $raw_data['sku'][0]=$merchant_id.'-'.$raw_data['sku'][0];
                    }else{

$raw_data['sku']=$merchant_id.'-'.$raw_data['sku'];                 }
                        
                    }
                        
                
                $skus=$this->prepareCheckSKUexist_bulk_sku_itemwrap(
                  isset($raw_data['sku'])?$raw_data['sku']:''
                );      

                return $skus;
                        
        
    } 


     public  function prepareCheckSKUexist_bulk_sku_itemwrap($data='',$item_id='', $size='')
    {       
        if(is_array($data) && count($data)>=1){
            foreach ($data as $key=>$sku) {                             
                if($datas=$this->checkSKUexist_bulk_sku_sku_itemwrap($sku,$item_id, isset($size[$key])?$size[$key]:'' )){                 
                    return $datas;              
                }else{return true;}
            }
        } else {
            if($datas=$this->checkSKUexist_bulk_sku_sku_itemwrap($data,$item_id)){
                return $datas;      
            }else{return true;}
        }
    }



   public function checkSKUexist_bulk_sku_sku_itemwrap($sku = '', $item_id = '', $size_id = 0)
{
    try {
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_item_relationship_size 
            WHERE sku = :sku
            LIMIT 1
        ");
        $stmt->bindParam(':sku', $sku, PDO::PARAM_STR);
        $stmt->execute();
        
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($resp) {
            return $resp;
        }
        return false;
    } catch (PDOException $e) {
        // Log or handle the exception as needed
        return false;
    }
}



















public function getBookingByIDWithDetails($booking_id = '')
{
    if (empty($booking_id)) {
        return false; // Early return for empty booking_id
    }

    // Prepare the SQL query with placeholders to prevent SQL injection
    $stmt = "
        SELECT a.*, b.restaurant_name
        FROM mt_bookingtable a
        LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
        WHERE a.booking_id = :booking_id
        LIMIT 1
    ";

    try {
        // Prepare and execute the query
        $query = $this->db->prepare($stmt);
        $query->bindParam(':booking_id', $booking_id, PDO::PARAM_INT); // Bind the parameter
        $query->execute();

        // Fetch the result
        $result = $query->fetch(PDO::FETCH_ASSOC);

        return $result ?: false; // Return the result or false if no rows found
    } catch (PDOException $e) {
        // Handle exception (log or debug as needed)
        error_log("Database Error: " . $e->getMessage());
        return false;
    }
}


public function getCountryByCode($code = 'US')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_location_countries 
        WHERE shortcode = :code 
        LIMIT 1
    ");
    $stmt->execute([':code' => $code]);
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    return $res ? $res : false;
}






public function listPointExpiry()
  {
    return array(
       1=>"points expire at the end of the next year after you earned them",
       //2=>t("points expire after 6 months"),
       3=>"points never expire"
    );
  }


  public function explodeData($data='')
  {
    if (preg_match("/|/i", $data)) {
      $ret=explode("|",$data);
      if (is_array($ret) && count($ret)>=1){
        return $ret;
      }
    }
    return false;
  }



  public function geodecodeAddress($address='')
    {
         
        $this->MapsWrapper = new MapsWrapper();
        try {           
            $resp = $this->MapsWrapper->geoCodeAdress($address);           
            return $resp;
        } catch (Exception $e) {
            return false;
        }               
    }



    public function searchByAddress($address = '', $page = 0, $per_page = 5, $getdata = '')
{
    if (empty($address)) {
        return false;
    }

    if ($page > 0) {
        $page = ($page - 1) * $per_page;
    }

    $lat = 0;
    $long = 0;
    $and = '';

    try {
        $lat_res = $this->geodecodeAddress($address);
        $lat = $lat_res['lat'];
        $long = $lat_res['long'];
    } catch (Exception $e) {
        $lat = 0;
        $long = 0;
    }

    $home_search_unit_type = $this->getOptionAdmin('home_search_unit_type');
    $home_search_radius = $this->getOptionAdmin('home_search_radius');

    if (empty($home_search_unit_type)) {
        $home_search_unit_type = 'mi';
    }
    if (!is_numeric($home_search_radius)) {
        $home_search_radius = 10;
    }

    $distance_exp = ($home_search_unit_type == "km") ? 6371 : 3959;

    $sort_by = " ORDER BY open_status DESC, is_sponsored DESC, distance ASC";
    $sort_combine = $sort_by;

    if (isset($getdata['sort_filter']) && !empty($getdata['sort_filter'])) {
        $sort = "ASC";
        if (in_array($getdata['sort_filter'], ['ratings', 'open_status'])) {
            $sort = "DESC";
        }
        $sort_combine = " ORDER BY " . $getdata['sort_filter'] . " $sort";
    }

    // Delivery type filters
    if (isset($getdata['filter_delivery_type'])) {
        switch ($getdata['filter_delivery_type']) {
            case 1:
                $and .= " AND service IN ('1','2','3','4','5','6')";
                break;
            case 2:
                $and .= " AND service = '2'";
                break;
            case 3:
                $and .= " AND service = '3'";
                break;
            case 5:
                $and .= " AND service IN ('1','2','4','7')";
                break;
            case 6:
                $and .= " AND service IN ('3','4','6','7')";
                break;
            case 7:
                $and .= " AND service = '7'";
                break;
        }
    }

    // Cuisine filter
    if (isset($_GET['filter_cuisine']) && !empty($_GET['filter_cuisine'])) {
        $filter_cuisines = explode(",", $_GET['filter_cuisine']);
        if (is_array($filter_cuisines) && count($filter_cuisines) >= 1) {
            $cuisine_conditions = [];
            foreach ($filter_cuisines as $val) {
                $val = trim($val);
                if (!empty($val)) {
                    $val_escaped = str_replace("'", "''", $val);
                    $cuisine_conditions[] = "cuisine LIKE '%\"$val_escaped\"%'";
                }
            }
            if (!empty($cuisine_conditions)) {
                $and .= " AND (" . implode(" OR ", $cuisine_conditions) . ")";
            }
        }
    }

    // Minimum order filter
    if (isset($_GET['filter_minimum']) && is_numeric($_GET['filter_minimum'])) {
        $min = (int) $_GET['filter_minimum'];
        $and .= " AND CAST(minimum_order AS SIGNED) <= $min";
    }

    // Restaurant name filter
    if (isset($_GET['restaurant_name']) && !empty($_GET['restaurant_name'])) {
        $search_name = trim($_GET['restaurant_name']);
        $search_name = str_replace("'", "''", $search_name);
        $and .= " AND restaurant_name LIKE '%$search_name%'";
    }

    $and .= " AND status='active'";
    $and .= " AND is_ready='2'";

    $time_now = date("H:i");
    $open_day = strtolower(date("l"));

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*, 
        (
            $distance_exp * acos(
                cos(radians($lat)) * cos(radians(latitude)) *
                cos(radians(lontitude) - radians($long)) +
                sin(radians($lat)) * sin(radians(latitude))
            )
        ) AS distance,
        CONCAT(street, ' ', city, ' ', state, ' ', post_code) AS merchant_address,
        (
            SELECT COUNT(*) FROM mt_opening_hours
            WHERE merchant_id = a.merchant_id
              AND day = '$open_day'
              AND status = 'open'
              AND (
                  CAST('$time_now' AS TIME) BETWEEN CAST(start_time AS TIME) AND CAST(end_time AS TIME)
                  OR
                  CAST('$time_now' AS TIME) BETWEEN CAST(start_time_pm AS TIME) AND CAST(end_time_pm AS TIME)
              )
        ) AS open_status

        FROM mt_view_merchant a 
        HAVING distance < delivery_distance_covered
        $and
        $sort_combine
        LIMIT $page, $per_page
    ";

    $this->db->exec("SET SQL_BIG_SELECTS=1");

    $query = $this->db->query($stmt);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $total_found = 0;
        $query_found = $this->db->query("SELECT FOUND_ROWS()");
        $rows = $query_found->fetch(PDO::FETCH_ASSOC);
        if ($rows) {
            $total_found = $rows['FOUND_ROWS()'];
        }

        return array(
            'total' => $total_found,
            'client' => array(
                'lat' => $lat,
                'long' => $long
            ),
            'list' => $res,
            'sql' => $stmt
        );
    }

    return false;
}





    public function showAddressBook()   
    {
        if ( $this->isClientLogin()){
            $client_id=$this->getClientId();
            if ( $res=$this->hasAddressDefault($client_id)){                
                return $res;
            }
        }
        return false;
    }



public function searchByMerchant($stype = '', $address = '', $page = 0, $per_page = 5, $getdata = '')
{
    // Calculate offset for pagination
    $page = max(0, ($page > 0 ? ($page - 1) * $per_page : 0));

     
    // Geocode the address if provided
    $lat = 0;
    $long = 0;
    if (!empty($address) && $lat_res = $this->functions->geodecodeAddress($address)) {
        $lat = $lat_res['lat'];
        $long = $lat_res['long'];
    }

    // Defaults for latitude and longitude
    $lat = $lat ?: 0;
    $long = $long ?: 0;

    // Sort handling
    $sort_by = isset($getdata['sort_filter']) && !empty($getdata['sort_filter'])
        ? " ORDER BY {$getdata['sort_filter']} " . ($getdata['sort_filter'] === "ratings" ? "DESC" : "ASC")
        : " ORDER BY is_sponsored DESC, restaurant_name ASC";

    // Base query filters
    $time_now = date("H:i");
    $open_day = strtolower(date("l"));

    $and_open_qry = "
        LEFT JOIN (
            SELECT merchant_id, 
                   COUNT(*) AS open_status
            FROM mt_opening_hours
            WHERE day = '$open_day'
              AND status = 'open'
              AND (
                  CAST('$time_now' AS TIME) BETWEEN CAST(start_time AS TIME) AND CAST(end_time AS TIME)
                  OR CAST('$time_now' AS TIME) BETWEEN CAST(start_time_pm AS TIME) AND CAST(end_time_pm AS TIME)
              )
            GROUP BY merchant_id
        ) b ON a.merchant_id = b.merchant_id
    ";

    $query = "1"; // Default condition
    $stmt = ''; // Initialize the statement

    // Call the searchGetFilter function to modify or add to filters
    $filter_conditions = $this->searchGetFilter($getdata);
     $query .= $filter_conditions;

    switch ($stype) {
        case "kr_search_restaurantname":
            if (!empty($getdata['restaurant-name'])) {
                $merchant_name = str_replace("'", '', $getdata['restaurant-name']);
                $query = "restaurant_name LIKE '%$merchant_name%'";
            }
            break;

        case "kr_search_streetname":
            if (!empty($getdata['street-name'])) {
                $street_name = $getdata['street-name'];
                $query = "street LIKE '%$street_name%'";
            }
            break;

        case "kr_search_foodname":
            if (!empty($getdata['foodname'])) {
                $foodname_str = "%" . $getdata['foodname'] . "%";
                $query = "
                    merchant_id IN (
                        SELECT DISTINCT merchant_id
                        FROM mt_item
                        WHERE item_name LIKE '$foodname_str'
                    )
                ";
            }
            break;

        case "kr_postcode":
            if (!empty($getdata['zipcode'])) {
                $post_code = explode(" ", $getdata['zipcode'])[0] ?? '-1';
                $query = "post_code LIKE '%$post_code%'";
            }
            break;

        default:
            // No specific type, use default query
            break;
    }

    // Build the final SQL query
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*,
        CONCAT(street, ' ', city, ' ', state, ' ', post_code) AS merchant_address
        FROM mt_view_merchant a
        $and_open_qry
        WHERE $query
        $sort_by
        LIMIT $page, $per_page
    ";

    // Execute query
    $this->db->query("SET SQL_BIG_SELECTS=1");

    try {
        $query_result = $this->db->prepare($stmt);
        $query_result->execute();
        $res = $query_result->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $stmt_rows_result = $this->db->prepare("SELECT FOUND_ROWS()");
            $stmt_rows_result->execute();
            $rows = $stmt_rows_result->fetch(PDO::FETCH_ASSOC);

            return [
                'total' => $rows['FOUND_ROWS()'] ?? 0,
                'client' => ['lat' => $lat, 'long' => $long],
                'list' => $res,
                'sql' => $stmt
            ];
        }
    } catch (PDOException $e) {
        // Log and return the error
        return ['error' => $e->getMessage(), 'sql' => $stmt];
    }

    return false;
}













public function GetCuisineByName($name = '')
{
    try {
        // Prepare the query
        $stmt = $this->db->prepare("SELECT * FROM mt_cuisine WHERE cuisine_name LIKE :name LIMIT 0, 1");

        // Bind parameters
        $stmt->bindValue(':name', "%$name%", PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
            return $res;
        }
    } catch (PDOException $e) {
        // Handle PDO exception
        error_log("Database error in GetCuisineByName: " . $e->getMessage());
        return false;
    }

    // Return false if no result
    return false;
}

public  function clearSearchParams($field_to_clear='',$extra_params='')
    {     
      $request=$_GET;    
      $new_request='';
      if (is_array($request) && count($request)>=1){
        foreach ($request as $key=>$val) {
          if ($key!=$field_to_clear){
            $new_request.="$key=$val&";
          }         
        }
      }
      if (!empty($extra_params)){
        $new_request.=$extra_params;
      }
      //return Yii::app()->createUrl('/searcharea?'.$new_request);    

      return Config::$baseUrl."/searcharea?".$new_request;    
    }





    public function searchGetFilter($getdata = '')
{
    unset($getdata['url'], $getdata['slug']);
    $and = '';

    // Filter: Delivery Type
    if (isset($getdata['filter_delivery_type'])) {
        switch ((int)$getdata['filter_delivery_type']) {
            case 1:
                $and .= " AND (service IN ('1','2','3','4','5','6'))";
                break;
            case 2:
                $and .= " AND (service = '2')";
                break;
            case 3:
                $and .= " AND (service = '3')";
                break;
            case 5:
                $and .= " AND (service IN ('1','2','4','7'))";
                break;
            case 6:
                $and .= " AND (service IN ('3','4','6','7'))";
                break;
            case 7:
                $and .= " AND (service = '7')";
                break;
            // case 4 and default: no filter
        }
    }

    // Filter: Cuisine
    if (!empty($getdata['filter_cuisine'])) {
        $filter_cuisines = explode(",", $getdata['filter_cuisine']);
        $cuisine_conditions = [];

        foreach ($filter_cuisines as $val) {
            $val = trim($val);
            if (!empty($val)) {
                $val_escaped = addslashes($val);
                $cuisine_conditions[] = "cuisine LIKE '%\"$val_escaped\"%'";
            }
        }

        if (!empty($cuisine_conditions)) {
            $and .= " AND (" . implode(" OR ", $cuisine_conditions) . ")";
        }
    }

    // Filter: Minimum Order
    if (isset($getdata['filter_minimum']) && is_numeric($getdata['filter_minimum'])) {
        $min_order = (float)$getdata['filter_minimum'];
        $and .= " AND CAST(minimum_order AS SIGNED) <= $min_order";
    }

    // Filter: Restaurant Name
    if (!empty($getdata['restaurant_name'])) {
        $name = addslashes($getdata['restaurant_name']);
        $and .= " AND restaurant_name LIKE '%$name%'";
    }

    // Always apply active and ready condition
    $and .= " AND status='active'";
    $and .= " AND is_ready='2'";

    return $and;
}






    


 public function hasAddressDefault($client_id='')
{
    try {
        // Prepare the SQL query with a parameterized client_id
        $stmt = $this->db->prepare("
            SELECT 
                CONCAT(street, ' ', city, ' ', state, ' ', zipcode) AS address,
                id,
                location_name,
                country_code
            FROM mt_address_book
            WHERE client_id = :client_id
            AND as_default = '2'
            LIMIT 1
        ");

        // Bind the client_id parameter
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result or false if no record found
        if ($res) {
            return $res;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        // Handle any potential PDO exceptions
        return false;
    }
}


public function getAddressBookDefault($client_id='')
{
    try {
        // Prepare the SQL query with a parameterized client_id
        $stmt = $this->db->prepare("
            SELECT *               
            FROM mt_address_book
            WHERE client_id = :client_id
            AND as_default = '2'
            LIMIT 0,1
        ");

        // Bind the client_id parameter
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result if found, else return false
        if ($res) {
            return $res;
        }
    } catch (PDOException $e) {
        // Handle any potential PDO exceptions
        return false;
    }

    return false;
}



public function getAddressBookByClient($client_id='')
{
    if ($client_id > 0) {
        try {
            // Prepare the SQL query with a parameterized client_id
            $stmt = $this->db->prepare("
                SELECT  
                    CONCAT(street, ' ', city, ' ', state, ' ', zipcode) AS address,
                    id,
                    location_name,
                    country_code,
                    latitude,
                    longitude
                FROM mt_address_book
                WHERE client_id = :client_id
                ORDER BY street ASC
            ");

            // Bind the client_id parameter
            $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);

            // Execute the query
            $stmt->execute();

            // Fetch the results
            $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

            // Return the results or false if no records are found
            if ($res) {
                return $res;
            }
        } catch (PDOException $e) {
            // Handle any potential PDO exceptions
            return false;
        }
    }
    return false;
}



  


  public   function displaySpicyIconNew($dish='',$class='')
  {   
    $result='';
    if (!empty($dish)){
      $dish=json_decode($dish);     
      if (is_array($dish) && count($dish)>=1){
        $result='<div class="mytable '.$class.'">';
        foreach ($dish as $dish_id) {
          $dish_info=$this->GetDish($dish_id);          
          $result.='<div class="col">'; 
                   $result .= '<img class="spicydish-icon" src="' . $this->uploadURL() . "/" . $dish_info['photo'] . '" alt="" title="">';

                    $result.='</div>';                      
        }
        $result.='</div>';   
      }   
    }   
    return $result;
  }


   public function getMerchantOpeningHours($merchant_id='')
  {
        $stores_open_day=$this->getOption("stores_open_day",$merchant_id);
    $stores_open_starts=$this->getOption("stores_open_starts",$merchant_id);
    $stores_open_ends=$this->getOption("stores_open_ends",$merchant_id);
    $stores_open_custom_text=$this->getOption("stores_open_custom_text",$merchant_id);
    
    $stores_open_day=!empty($stores_open_day)?(array)json_decode($stores_open_day):false;
    $stores_open_starts=!empty($stores_open_starts)?(array)json_decode($stores_open_starts):false;
    $stores_open_ends=!empty($stores_open_ends)?(array)json_decode($stores_open_ends):false;
    $stores_open_custom_text=!empty($stores_open_custom_text)?(array)json_decode($stores_open_custom_text):false;
    
    
    $stores_open_pm_start=$this->getOption("stores_open_pm_start",$merchant_id);
    $stores_open_pm_start=!empty($stores_open_pm_start)?(array)json_decode($stores_open_pm_start):false;
    
    $stores_open_pm_ends=$this->getOption("stores_open_pm_ends",$merchant_id);
    $stores_open_pm_ends=!empty($stores_open_pm_ends)?(array)json_decode($stores_open_pm_ends):false;   
                        
    $open_starts='';
    $open_ends='';
    $open_text='';
    $data=array();
        
    if (is_array($stores_open_day) && count($stores_open_day)>=1){
      foreach ($stores_open_day as $val_open) { 
        if (array_key_exists($val_open,(array)$stores_open_starts)){
          $open_starts=$this->timeFormat($stores_open_starts[$val_open],true);
        }             
        if (array_key_exists($val_open,(array)$stores_open_ends)){
          $open_ends=$this->timeFormat($stores_open_ends[$val_open],true);
        }             
        if (array_key_exists($val_open,(array)$stores_open_custom_text)){
          $open_text=$stores_open_custom_text[$val_open];
        }         
        
        $pm_starts=''; $pm_ends=''; $pm_opens='';
        if (array_key_exists($val_open,(array)$stores_open_pm_start)){
          $pm_starts=$this->timeFormat($stores_open_pm_start[$val_open],true);
        }                     
        if (array_key_exists($val_open,(array)$stores_open_pm_ends)){
          $pm_ends=$this->timeFormat($stores_open_pm_ends[$val_open],true);
        }                       
        
        $full_time='';
        if (!empty($open_starts) && !empty($open_ends)){          
          $full_time=$open_starts." - ".$open_ends."&nbsp;&nbsp;";
        }     
        if (!empty($pm_starts) && !empty($pm_ends)){
          if ( !empty($full_time)){
            $full_time.=" / ";
          }       
          $full_time.="$pm_starts - $pm_ends";
        }                       
                
        $data[]=array(
          'day'=>$val_open,
          'hours'=>$full_time,
          'open_text'=>$open_text
        );
        
        $open_starts='';
            $open_ends='';
            $open_text='';
      }
      return $data;
    }     
    return false;   
  }


  public function travelMmode()
    {
      return array(
        'DRIVING'=>$this->translation("default","Driving"),
        'WALKING'=>$this->translation("default","Walking"),
        'BICYCLING'=>$this->translation("default","Bicycling"),
        'TRANSIT'=>$this->translation("default","Transit")
      );
    } 


    public function getReviewsList($merchant_id = '')
{
    try {
        $stmt = $this->db->prepare("
            SELECT a.*, 
            (
                SELECT first_name 
                FROM mt_client 
                WHERE client_id = a.client_id
            ) as client_name
            FROM mt_review a
            WHERE merchant_id = :merchant_id
            AND status = 'publish'
            ORDER BY id DESC
            LIMIT 0, 1000
        ");

        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->execute();

        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $res ? $res : false;
    } catch (PDOException $e) {
        // Handle the exception, log it, or return false
        return false;
    }
}


public  function getAvatar($client_id='')
    {
        if ( $res= $this->getClientInfo($client_id) ){
            $file=$res['avatar'];
            
        } else $file='avatar.jpg';
        
        if (empty($file)){
            $file='avatar.jpg';
        }
                    
        
        $path=$this->uploadURL()."/$file";
        
        if ( ($file!='avatar.jpg') ){                              
            return $this->uploadURL()."/$file";
        } else return $this->assetsURL()."/images/avatar.jpg";     
    }


    public function getRemainingReview($client_id = '', $merchant_id = '')
{


    try {
        $and = $this->getReviewStatus();
       $stmt = $this->db->prepare("
            SELECT COUNT(*) as total,
            (
                SELECT COUNT(*)
                FROM mt_review
                WHERE client_id = :client_id
                AND merchant_id = :merchant_id
                AND status IN ('publish', 'pending')
            ) as total_review
            FROM mt_order
            WHERE client_id = :client_id
            AND merchant_id = :merchant_id
            $and 
        ");




        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->execute();

        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        
        

        if ($res && $res['total'] >= $res['total_review']) {
            $remaining = $res['total'] - $res['total_review'];
            return $remaining;
        }

        return false;
    } catch (PDOException $e) {
        // Handle the exception, log it, or return false

        

        echo $e->getMessage();die();

        return false;
    }
}
  


    public function reviewReplyList($parent_id = '', $status = '')
{
    try {
        $and = '';
        if (!empty($status)) {
            $and = " AND status = :status ";
        }

        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_review
            WHERE parent_id = :parent_id
            $and
            ORDER BY id ASC
            LIMIT 0, 10
        ");

        $stmt->bindParam(':parent_id', $parent_id, PDO::PARAM_INT);
        
        if (!empty($status)) {
            $stmt->bindParam(':status', $status, PDO::PARAM_STR);
        }

        $stmt->execute();

        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
        return $res ? $res : false;
    } catch (PDOException $e) {
        // Handle the exception, log it, or return false
        return false;
    }
}



public function addToFavorites($client_id = '', $merchant_id = '')
{
    try {
        // Check if the favorite already exists
        $stmt = $this->db->prepare("
            SELECT * FROM mt_favorites
            WHERE fav_type = 'restaurant'
            AND client_id = :client_id
            AND merchant_id = :merchant_id
            LIMIT 1
        ");
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->execute();

        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            // If it exists, delete the favorite
            $deleteStmt = $this->db->prepare("
                DELETE FROM mt_favorites
                WHERE id = :id
            ");
            $deleteStmt->bindParam(':id', $res['id'], PDO::PARAM_INT);
            $deleteStmt->execute();

            return false;
        } else {
            // If it doesn't exist, add a new favorite
            $insertStmt = $this->db->prepare("
                INSERT INTO mt_favorites (client_id, merchant_id, fav_type, date_created, ip_address)
                VALUES (:client_id, :merchant_id, 'restaurant', :date_created, :ip_address)
            ");
            $dateCreated = $this->dateNow();
            $ipAddress = $_SERVER['REMOTE_ADDR'];
            $insertStmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
            $insertStmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $insertStmt->bindParam(':date_created', $dateCreated);
            $insertStmt->bindParam(':ip_address', $ipAddress);

            return $insertStmt->execute();
        }
    } catch (PDOException $e) {
        // Handle the exception, log it, or return false
        return false;
    }
}





   public function getClientId()
    {
      if (isset($_SESSION['kr_client'])){
        if (array_key_exists('client_id',$_SESSION['kr_client'])){          
          if (is_numeric($_SESSION['kr_client']['client_id'])){
            return $_SESSION['kr_client']['client_id'];
          }
        }     
      }
      return false;
    }


    public function chk_id_for_google_reservation($merchant_id)
{
    $stmt = $this->db->prepare("
        SELECT merchant_id 
        FROM mt_option 
        WHERE option_name = 'booking_id' 
          AND merchant_id = ? 
        LIMIT 1
    ");
    $stmt->execute([$merchant_id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    return $row ? true : false;
}

 public function add_id_for_google_reservation($merchant_id)
{
    // Step 1: Get the last booking_id option_value
    $stmt = $this->db->prepare("
        SELECT option_value 
        FROM mt_option 
        WHERE option_name = 'booking_id' 
        ORDER BY id DESC 
        LIMIT 1
    ");
    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row && !empty($row['option_value'])) {
        // Extract numeric part
        preg_match('/_(\d+)_pk$/', $row['option_value'], $matches);
        $last_num = isset($matches[1]) ? (int)$matches[1] : 0;
        $new_num  = str_pad($last_num + 1, 3, "0", STR_PAD_LEFT);
    } else {
        // Start fresh if no record exists
        $new_num = "001";
    }

    // Step 2: Build new booking_id
    $new_booking_id = "loveeatery_" . $new_num . "_pk";

    // Step 3: Insert into mt_option
    $insert = $this->db->prepare("
        INSERT INTO mt_option (merchant_id, option_name, option_value)
        VALUES (?, 'booking_id', ?)
    ");
    $insert->execute([$merchant_id, $new_booking_id]);

    return $new_booking_id;
}




   public function getCustomerByPhone($phone = '')
{
    // Prepare the SQL statement with a LIKE clause for the phone number
    $stmt = $this->db->prepare("SELECT * FROM mt_client WHERE contact_phone LIKE :phone");

    // Bind the parameter with a wildcard for partial matching
    $stmt->bindValue(':phone', '%' . $phone . '%');

    // Execute the query
    $stmt->execute();

    // Fetch a single row
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    // Check if a result was found
    if ($resp) {
        return $resp;
    }

    // Throw an exception if no result was found
    throw new Exception("We cannot find your phone number in our records");
}


public function getCustomerByPhone_forgotpassword($phone = '')
{
    // Prepare the SQL with merchant_id check
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_client 
        WHERE contact_phone LIKE :phone 
        AND (merchant_id = 0 OR merchant_id IS NULL)
        LIMIT 1
    ");

    // Bind the parameter with wildcard for partial matching
    $stmt->bindValue(':phone', '%' . $phone . '%');

    // Execute the query
    $stmt->execute();

    // Fetch a single row
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    // Check if a result was found
    if ($resp) {
        return $resp;
    }

    // Throw exception if not found
    throw new Exception("We cannot find your phone number in our records");
}





 public function getLostPassToken($token = '')
{
    if (!empty($token)) {
        // Prepare the SQL statement with a parameter placeholder for the token
        $stmt = $this->db->prepare("SELECT * FROM mt_client WHERE lost_password_token = :token LIMIT 1");

        // Bind the token parameter
        $stmt->bindValue(':token', $token);

        // Execute the query
        $stmt->execute();

        // Fetch a single row
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result if found
        if ($res) {
            return $res;
        }
    }

    // Return false if no result was found or if the token is empty
    return false;
}


 public function checkIfUserCanRateMerchant($user_id = '', $merchant_id = '')
{
    try {
        $and = $this->getReviewStatus();

        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_order
            WHERE client_id = :user_id
            AND merchant_id = :merchant_id
            $and
            LIMIT 1
        ");

        $stmt->bindParam(':user_id', $user_id, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->execute();

        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        return $res ? true : false;
    } catch (PDOException $e) {
        // Handle the exception, log it, or return false
        return false;
    }
}

 public function canReviewBasedOnOrder($client_id = '', $merchant_id = '')
{
    try {
        $and = $this->getReviewStatus();

        $stmt = $this->db->prepare("
            SELECT COUNT(*) as total,
            (
                SELECT COUNT(*) 
                FROM mt_review
                WHERE client_id = :client_id
                AND merchant_id = :merchant_id
                AND status = 'publish'
            ) as total_review
            FROM mt_order
            WHERE client_id = :client_id
            AND merchant_id = :merchant_id
            $and
        ");

        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->execute();

        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        return $res && $res['total'] > $res['total_review'];
    } catch (PDOException $e) {
        // Handle the exception, log it, or return false
        return false;
    }
}


  public function reviewByLastOrderRef($client_id = '', $merchant_id = '')
{
    try {
        $and = $this->getReviewStatus();

        $stmt = $this->db->prepare("
            SELECT a.order_id 
            FROM mt_order a
            WHERE client_id = :client_id
            AND merchant_id = :merchant_id
            $and
            AND order_id NOT IN (
                SELECT order_id 
                FROM mt_review 
                WHERE merchant_id = a.merchant_id 
                AND client_id = a.client_id
            )  
            ORDER BY order_id ASC
        ");

        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->execute();

        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        return $res ? $res['order_id'] : false;
    } catch (PDOException $e) {
        // Handle the exception, log it, or return false
        return false;
    }
}

    public function updateRatings($merchant_id='',$ratings='',$client_id='')
    {
        
        
        $params=array(
          'merchant_id'=>$merchant_id,
          'ratings'=>$ratings,
          'client_id'=>$client_id,
          'date_created'=>$this->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );              
                        
        if ( !$res=$this->isClientRatingExist($merchant_id,$client_id) ){       
            $this->insertData("mt_rating",$params);           
            return true;
        } else {                    
            $rating_id=$res['id'];                  
            $update=array(
              'ratings'=>$ratings,
               'date_created'=>$this->dateNow(),
               'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
            if ( $this->updateData("mt_rating",$update,'id',$rating_id) ){                
                return true;
            }               
        }     
        return false;   
    }


    public function isClientRatingExist($merchant_id = '', $client_id = '')
{
    try {
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_rating
            WHERE merchant_id = :merchant_id
            AND client_id = :client_id
            LIMIT 1
        ");

        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        $stmt->execute();

        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        return $res ? $res : false;
    } catch (PDOException $e) {
        // Handle the exception, log it, or return false
        return false;
    }
}


 



    public  function getReviewStatus()
    {
        $website_review_type=$this->getOptionAdmin('website_review_type');
        
        $and=''; $in_status='';
        $status = $this->getOptionAdmin('review_merchant_can_add_review_status');      
        if($website_review_type==2){
            $status = $this->getOptionAdmin('review_baseon_status');       
        }
        
        if(!empty($status)){
            $status = json_decode($status,true);            
            if(is_array($status) && count($status)>=1){
                foreach ($status as $val) {
                   
                    $in_status .= "'" . $val . "',";

                }
                $in_status = substr($in_status,0,-1);
                $and=" AND status in ($in_status)";
            }
        }
        return $and;
    }



public function updateCustomerProfile($client_id = '', $params = array())
{
    // Prepare the base SQL update statement
    $sql = "UPDATE mt_client SET ";

    // Build the dynamic part of the SQL based on the params array
    $setParts = [];
    foreach ($params as $key => $value) {
        $setParts[] = "$key = :$key";
    }
    $sql .= implode(", ", $setParts);
    $sql .= " WHERE client_id = :client_id";

    // Prepare the statement
    $stmt = $this->db->prepare($sql);

    // Bind each parameter value dynamically
    foreach ($params as $key => $value) {
        $stmt->bindValue(":$key", $value);
    }

    // Bind the client_id parameter
    $stmt->bindValue(":client_id", (int)$client_id, PDO::PARAM_INT);

    // Execute the statement
    $resp = $stmt->execute();

    // Check if rows were affected
    if ($resp) {
        return true;
    }

    // Throw an exception if the update failed
    throw new Exception("Cannot update records");
}



    public function getEnabledLanguage()
  {
    $lang=$this->getOptionAdmin("set_lang_id");
    //dump($lang);
    if(!empty($lang)){
      $lang=json_decode($lang,true);
    }
    return $lang;
  }



    public  function hasModuleAddon($modulename='')
  {
    
       $path_to_upload=Config::$baseUrl."/app/modules/$modulename"; 
       if(file_exists($path_to_upload)){
        
           /*check if tables exist for modules*/           
           $check_table='';
           if($modulename=="driver"){
              $check_table = 'driver_task';
              
           } elseif ($modulename=="pointsprogram"){
              $check_table = 'points_earn'; 
              
           } elseif ($modulename=="printer"){
              $check_table = 'printer_print'; 
              
           } elseif ($modulename=="mobileapp"){
              $check_table = 'mobile_registered';  
              
           } elseif ($modulename=="singlemerchant"){
              $check_table = 'singleapp_cart'; 
           }
           if(!empty($check_table)){
              if(!$this->checkIfTableExist($check_table)){
                 return false;
              }         
           }     
           return true;
       }
    
    return false;
  }   

public function checkIfTableExist($table_name = '')
{
    // Ensure table_name is provided
    if (empty($table_name)) {
        return false;
    }

    // Prepare the table name with a prefix
    $prefix = 'mt_';
    $table = $prefix . $table_name;

    // Prepare the SQL query
    $stmt = "SHOW TABLES LIKE :table";

    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);

    // Bind the table name parameter
    $query->bindParam(':table', $table, PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    // If the table exists, return the result
    if ($res) {
        return $res;
    }

    // Return false if the table does not exist
    return false;
}



 public function getOrder2($order_id = '')
{
    $and = '';

    if (!isset($_GET['backend'])) {
        /* Custom code start */
        if (isset($_GET['debug']) || $_GET['chk'] == '1') {
            // Custom logic can be added here
        } else {
            $and = "AND client_id=" . ($this->getClientId()) . " ";
        }
        /* Custom code ends */
    }

    $stmt = "
    SELECT a.*,
    (
        SELECT concat(first_name, ' ', last_name) as full_name
        FROM mt_client
        WHERE client_id = a.client_id
        LIMIT 0,1
    ) as full_name,

    (
        SELECT email_address
        FROM mt_client
        WHERE client_id = a.client_id
        LIMIT 0,1
    ) as email_address,

    (
        SELECT custom_field1
        FROM mt_client
        WHERE client_id = a.client_id
        LIMIT 0,1
    ) as custom_field1,

    (
        SELECT custom_field2
        FROM mt_client
        WHERE client_id = a.client_id
        LIMIT 0,1
    ) as custom_field2,

    (
        SELECT restaurant_name
        FROM mt_merchant
        WHERE merchant_id = a.merchant_id
        LIMIT 0,1
    ) as merchant_name,

    (
        SELECT restaurant_slug
        FROM mt_merchant
        WHERE merchant_id = a.merchant_id
        LIMIT 0,1
    ) as restaurant_slug,

    (
        SELECT concat(street, ' ', city, ' ', state, ' ', zipcode)
        FROM mt_client
        WHERE client_id = a.client_id
        LIMIT 0,1
    ) as full_address,

    (
        SELECT location_name
        FROM mt_order_delivery_address
        WHERE order_id = a.order_id
        LIMIT 0,1
    ) as location_name,

    (
        SELECT contact_phone
        FROM mt_client
        WHERE client_id = a.client_id
        LIMIT 0,1
    ) as contact_phone,

    (
        SELECT credit_card_number
        FROM mt_client_cc
        WHERE cc_id = a.cc_id
        LIMIT 0,1
    ) as credit_card_number,

    (
        SELECT payment_reference
        FROM mt_payment_order
        WHERE order_id = a.order_id
        ORDER BY id DESC
        LIMIT 0,1
    ) as payment_reference,

    (
        SELECT restaurant_phone
        FROM mt_merchant
        WHERE merchant_id = a.merchant_id
        LIMIT 0,1
    ) as merchant_contact_phone,

    (
        SELECT abn
        FROM mt_merchant
        WHERE merchant_id = a.merchant_id
        LIMIT 0,1
    ) as abn,

    (
        SELECT concat(street, ' ', area_name, ' ', city, ' ', state, ' ', zipcode)
        FROM mt_order_delivery_address
        WHERE order_id = a.order_id
        LIMIT 0,1
    ) as client_full_address,

    (
        SELECT location_name
        FROM mt_order_delivery_address
        WHERE order_id = a.order_id
        LIMIT 0,1
    ) as location_name1,

    (
        SELECT contact_phone
        FROM mt_order_delivery_address
        WHERE order_id = a.order_id
        LIMIT 0,1
    ) as contact_phone1,

    (
        SELECT concat(street, ' ', city, ' ', state, ' ', post_code)
        FROM mt_merchant
        WHERE merchant_id = a.merchant_id
        LIMIT 0,1
    ) as merchant_address,

    (
        SELECT concat(street, ' ', area_name, ' #', location_name, ' ', city, ', ', state, ' ', zipcode)
        FROM mt_order_delivery_address
        WHERE order_id = a.order_id
        LIMIT 0,1
    ) as client_delivery_address

    FROM mt_order a
    WHERE order_id = :order_id
    $and
    LIMIT 0,1
    ";

    // Using PDO
    $stmt = $this->db->prepare($stmt);
    $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        return $rows[0];
    }
    return false;
}
 




  public function AAmenuList()
  {
    $menu_list=array();
    $menu=$this->adminMenu();   
    foreach ($menu['items'] as $val) {
      $menu_list[] = strtolower($val['tag']);
      if (isset($val['items'])){
        if (is_array($val['items']) && count($val['items'])>=1){
          foreach ($val['items'] as $sub_val) {
            $menu_list[]= strtolower($sub_val['tag']);
          }
        }
      }
    }   
    return $menu_list;
  }


   public function validateMerchantControllerAccess($action_name='')
    {
      $action_name = strtolower($action_name);      
      $menu = $this->getMerchantMenuTag();
          
      $merchant_id=$this->getMerchantID();
      
   
            
      if (in_array($action_name,(array)$menu)){
        if ($info=$this->getMerchantInfo()){
          $info = (array)$info[0];          
          $user_access = json_decode( isset($info['user_access'])?$info['user_access']:'',true);          
          if(is_array($user_access) && count((array)$user_access)>=1){
            $user_access = array_map('strtolower', $user_access);
            if($info['is_commission']==2){
                array_push($user_access,"statement","earnings","withdrawals");
            }
            //dump($user_access);
            if (!in_array($action_name,$user_access)){
              return false;
            } //else echo 'has acces';
          } //else echo 'no user access';
        } //else echo 'no info';
      } //else echo 'not validate';
      return true;
    }   

     public function getMerchantMenuTag()
    {
      $menu_list=array();
    $menu=$this->merchantMenu();    
    foreach ($menu['items'] as $val) {
      $menu_list[] = strtolower($val['tag']);
      if (isset($val['items'])){
        if (is_array($val['items']) && count($val['items'])>=1){
          foreach ($val['items'] as $sub_val) {
            $menu_list[]= strtolower($sub_val['tag']);
          }
        }
      }
    }   
    return $menu_list;
    }



public function bookingStatus_x()
{
  return array(
    'pending'=>$this->translation("default",'pending'),
    'approved'=>$this->translation('default','approved'),
    'denied'=>$this->translation('default','denied'),
    'request_cancel_booking'=>$this->translation('default','request cancel booking'),
    'cancel_booking_approved'=>$this->translation('default','cancel booking approved'),
  );
}


public function bookingStatus()
{
  return array(
    
    'approved'=>$this->translation('default','approved'),
    
    'cancel_booking_approved'=>$this->translation('default','cancel booking approved'),
  );
}


public function getBooking($booking_id = '')
{
    $mtid = $this->getMerchantID();
    
    // Prepare the SQL query using PDO
    $stmt = "
        SELECT * FROM
        mt_bookingtable
        WHERE
        booking_id = :booking_id
        AND
        merchant_id = :merchant_id
        LIMIT 1
    ";
    
    // Prepare the statement
    $query = $this->db->prepare($stmt);
    
    // Bind parameters safely
    $query->bindParam(':booking_id', $booking_id, PDO::PARAM_INT);
    $query->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    // Return the first result or false if not found
    return $res ? $res : false;
}

public function getBooking_clientwise($client_id = '')
{
    // Prepare the SQL query with placeholders for better security
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_bookingtable
        WHERE client_id = :client_id
        ORDER BY booking_id DESC
        LIMIT 0, 20
    ");

    // Bind the `client_id` parameter to the query
    $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);

    // Execute the query
    $stmt->execute();

    // Fetch all results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return the results if any, otherwise return false
    return !empty($res) ? $res : false;
}

public function getBooking_idwise($booking_id = '')
{
    // Prepare the SQL query with a placeholder
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_bookingtable
        WHERE booking_id = :booking_id
        LIMIT 1
    ");

    // Bind the `booking_id` parameter
    $stmt->bindParam(':booking_id', $booking_id, PDO::PARAM_INT);

    // Execute the query
    $stmt->execute();

    // Fetch a single record
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the result if found, otherwise false
    return !empty($res) ? $res : false;
}

public function getBooking_idwise_token($booking_id = '', $token = '')
{
    // Prepare the SQL query with placeholders
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_bookingtable
        WHERE booking_id = :booking_id 
        AND token = :token
        LIMIT 1
    ");

    // Bind parameters
    $stmt->bindParam(':booking_id', $booking_id, PDO::PARAM_INT);
    $stmt->bindParam(':token', $token, PDO::PARAM_STR);

    // Execute the query
    $stmt->execute();

    // Fetch a single record
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the result if found, otherwise false
    return !empty($res) ? $res : false;
}




public function booking_cancel_via_email($merchant_id,$booking_id,$token)
        {
            
            if($token==""){
              $msg="Booking Link has been expired";
              return $msg;     
            }
                     
             $booking_id=$booking_id;
             $msg='';
            $params=array(
              'merchant_id'=>$merchant_id,
              'status'=>'cancel_booking_approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   

          /*echo $params['status'];
          echo $booking_id;die();*/


            $mt_info=$this->getMerchantInfo_mobileapp($merchant_id);

            //$params['restaurant_name']=$mt_info['restaurant_name'];       
            
           
            if (isset($booking_id) && is_numeric($booking_id)){             
             
                $params['date_modified']=$this->dateNow();


//+++++++++++++++++++++++++++++was custom code++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

                     //+++getting booking data
                   $bookingId=$booking_id;
                    $stmt = $this->db->prepare("
                    SELECT * 
                    FROM mt_bookingtable 
                    WHERE booking_id = ?
                ");
                  $stmt->execute([$bookingId]);
                  $booking_from_db = $stmt->fetch(PDO::FETCH_ASSOC);

                   //---getting booking data


                    
                $params_noti=array(
              'merchant_id'=>$merchant_id,
              'number_guest'=>isset($booking_from_db['number_guest'])?$booking_from_db['number_guest']:'',
              'date_booking'=>isset($booking_from_db['date_booking'])?$booking_from_db['date_booking']:'',
              'booking_time'=>isset($booking_from_db['booking_time'])?$booking_from_db['booking_time']:'',
              'booking_name'=>isset($booking_from_db['booking_name'])?$booking_from_db['booking_name']:'',
              'email'=>isset($booking_from_db['email'])?$booking_from_db['email']:'',
              'mobile'=>isset($booking_from_db['mobile'])?$booking_from_db['mobile']:'',
              'booking_notes'=>isset($booking_from_db['booking_notes'])?$booking_from_db['booking_notes']:'',
              'status'=>'cancel_booking_approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   
            
            

                   //+++for slots decrement
                  

                   if($params['status']=="cancel_booking_approved"&&$booking_from_db['status']!="cancel_booking_approved"){
                     $utc_times=$booking_from_db['utc_times'];
                     
                               $booking_id_google=$booking_from_db['booking_id_google'];
                     
                    
                     
                     
                       $slots_info_data=$this->getslotsbyUTC_alols($utc_times,$merchant_id);
       
       if(isset($slots_info_data) && !empty($slots_info_data)){
           foreach($slots_info_data as $slots_info){
             $used_slots=$slots_info['used_slots']-1;
       $available_slots=$slots_info['no_of_slots']-$used_slots;
       
       $slot_id=$slots_info['id'];
        $params_update1=array(
            'used_slots'=>$used_slots,
            'available_slots'=>$available_slots,
          );  


             $this->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
           }
           
           
       }
       
                     
                     
                     
                     
                     
                     
                     
                     
                     
                    if($booking_from_db['status']=="pending"){
                    $this->google_trigger($booking_from_db,"DECLINED_BY_MERCHANT");
                    }else{
                        $this->google_trigger($booking_from_db,"CANCELED");
                        
                    }



                   }


                   //---for slots decrement



//--------------------------------------------------------was custom code-----------------------------------------


                $params['token']="";
                
                $res= $this->updateData("mt_bookingtable", $params, 'booking_id', $booking_id);


                if ($res){
                    
                    $msg=$this->translation("default",'Booking cancelled.');  
                    
                    /*INSERT HISTORY*/
                    $params_history=array(
                      'booking_id'=>$booking_id,
                      'status'=>$params['status'],
                      'remarks'=>$msg,
                      'date_created'=>$this->dateNow()
                    );
                    

                   $this->insertData('mt_bookingtable_history', $params_history);

              
            



                    
                    /*SEND EMAIL TO CUSTOMER*/
                    $new_data=$params_noti;
                    $new_data['booking_id']=$booking_id_google;
                    $new_data['remarks']=$msg;

                   if($params['status']=="cancel_booking_approved"){
                    $new_data['status']="is canceled";
                   }

                   
                   $new_data['booking_time']= $this->prettyTime($booking_from_db['booking_time']);
                    $new_data['restaurant_name']=$mt_info['restaurant_name'];

                    $this->updateBookingNotify($new_data);


                   $this->PointsProgram = new PointsProgram(); 
                   $this->PointsProgram->updateBookTable($booking_id,$params['status']);

                } else $msg=$this->translation("default","ERROR: cannot update");
            } else { 

                $last_insert_id = $this->insertData('mt_bookingtable', $params);
                if ($last_insert_id!== false){  
                                       
                    //dump($this->details);
                    
                    $msg=$this->translation("default",'Booking added.');                      
                } else $msg=$this->translation("default",'ERROR. cannot insert data.');
            }  

            return $msg;         
        }


        public function booking_approve_via_email($merchant_id,$booking_id,$token)
        {
            if($token==""){
              $msg="Booking Link has been expired";
              return $msg;     
            }
                    
             $booking_id=$booking_id;
             $msg='';
            $params=array(
              'merchant_id'=>$merchant_id,
              'status'=>'approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   


            $mt_info=$this->getMerchantInfo_mobileapp($merchant_id);

            //$params['restaurant_name']=$mt_info['restaurant_name'];       
            
           
            if (isset($booking_id) && is_numeric($booking_id)){             
             
                $params['date_modified']=$this->dateNow();


//+++++++++++++++++++++++++++++was custom code++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

                     //+++getting booking data
                   $bookingId=$booking_id;
                    $stmt = $this->db->prepare("
                    SELECT * 
                    FROM mt_bookingtable 
                    WHERE booking_id = ?
                ");
                  $stmt->execute([$bookingId]);
                  $booking_from_db = $stmt->fetch(PDO::FETCH_ASSOC);

                   //---getting booking data


                    
                $params_noti=array(
              'merchant_id'=>$merchant_id,
              'number_guest'=>isset($booking_from_db['number_guest'])?$booking_from_db['number_guest']:'',
              'date_booking'=>isset($booking_from_db['date_booking'])?$booking_from_db['date_booking']:'',
              'booking_time'=>isset($booking_from_db['booking_time'])?$booking_from_db['booking_time']:'',
              'booking_name'=>isset($booking_from_db['booking_name'])?$booking_from_db['booking_name']:'',
              'email'=>isset($booking_from_db['email'])?$booking_from_db['email']:'',
              'mobile'=>isset($booking_from_db['mobile'])?$booking_from_db['mobile']:'',
              'booking_notes'=>isset($booking_from_db['booking_notes'])?$booking_from_db['booking_notes']:'',
              'status'=>'approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   
            
            

                   //+++for slots decrement
                  

                   if($params['status']=="approved"&&$booking_from_db['status']!="approved"){
                     $utc_times=$booking_from_db['utc_times'];
                     
                               $booking_id_google=$booking_from_db['booking_id_google'];
                     
                    
                                     

                    $this->google_trigger($booking_from_db,'CONFIRMED');




                   }


                   //---for slots decrement



//--------------------------------------------------------was custom code-----------------------------------------



                $params['token']="";
                $res= $this->updateData("mt_bookingtable", $params, 'booking_id', $booking_id);


                if ($res){
                    
                    $msg=$this->translation("default",'Booking approved.');  
                    
                    /*INSERT HISTORY*/
                    $params_history=array(
                      'booking_id'=>$booking_id,
                      'status'=>$params['status'],
                      'remarks'=>$msg,
                      'date_created'=>$this->dateNow()
                    );
                    

                   $this->insertData('mt_bookingtable_history', $params_history);

              
            



                    
                    /*SEND EMAIL TO CUSTOMER*/
                    $new_data=$params_noti;
                    $new_data['booking_id']=$booking_id_google;
                    $new_data['remarks']=$msg;

                   if($params['status']=="approved"){
                    $new_data['status']="is confirmed";
                   }

                   
                   $new_data['booking_time']= $this->prettyTime($booking_from_db['booking_time']);
                    $new_data['restaurant_name']=$mt_info['restaurant_name'];

                    $this->updateBookingNotify($new_data);
                    $this->PointsProgram = new PointsProgram();
                   $this->PointsProgram->updateBookTable($booking_id,$params['status']);

                } else $msg=$this->translation("default","ERROR: cannot update");
            } else { 

                $last_insert_id = $this->insertData('mt_bookingtable', $params);
                if ($last_insert_id!== false){  
                   
                    $msg=$this->translation("default",'Booking added.');                      
                } else $msg=$this->translation("default",'ERROR. cannot insert data.');
            } 

            return $msg;          
        }









public function getBookings_datemerchantwise($merchant_id = '', $date_booking = '')
{
    // Prepare the SQL query directly with variables
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_bookingtable
        WHERE merchant_id = '$merchant_id'
        AND date_booking = '$date_booking'
        ORDER BY booking_id DESC
    ");

    // Execute the query
    $stmt->execute();

    // Fetch all results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return the results if any, otherwise return false
    return !empty($res) ? $res : false;
}

public function bookingcancel_holiday($merchant_id="",$booking_id="")
        {
            
                   
             $booking_id=$booking_id;
             
            $params=array(
              'merchant_id'=>$merchant_id,
              'status'=>'cancel_booking_approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   


            $mt_info=$this->getMerchantInfo_mobileapp($merchant_id);

            //$params['restaurant_name']=$mt_info['restaurant_name'];       
            
           
            if (isset($booking_id) && is_numeric($booking_id)){             
             
                $params['date_modified']=$this->dateNow();


//+++++++++++++++++++++++++++++was custom code++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

                     //+++getting booking data
                   $bookingId=$booking_id;
                    $stmt = $this->db->prepare("
                    SELECT * 
                    FROM mt_bookingtable 
                    WHERE booking_id = ?
                ");
                  $stmt->execute([$bookingId]);
                  $booking_from_db = $stmt->fetch(PDO::FETCH_ASSOC);

                   //---getting booking data


                    
                $params_noti=array(
              'merchant_id'=>$merchant_id,
              'number_guest'=>isset($booking_from_db['number_guest'])?$booking_from_db['number_guest']:'',
              'date_booking'=>isset($booking_from_db['date_booking'])?$booking_from_db['date_booking']:'',
              'booking_time'=>isset($booking_from_db['booking_time'])?$booking_from_db['booking_time']:'',
              'booking_name'=>isset($booking_from_db['booking_name'])?$booking_from_db['booking_name']:'',
              'email'=>isset($booking_from_db['email'])?$booking_from_db['email']:'',
              'mobile'=>isset($booking_from_db['mobile'])?$booking_from_db['mobile']:'',
              'booking_notes'=>isset($booking_from_db['booking_notes'])?$booking_from_db['booking_notes']:'',
              'status'=>'cancel_booking_approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   
            
            

                   //+++for slots decrement
                  

                   if($params['status']=="cancel_booking_approved"&&$booking_from_db['status']!="cancel_booking_approved"){
                     $utc_times=$booking_from_db['utc_times'];
                     
                               $booking_id_google=$booking_from_db['booking_id_google'];
                     
                    
                     
                     
                       $slots_info_data=$this->getslotsbyUTC_alols($utc_times,$merchant_id);
       
       if(isset($slots_info_data) && !empty($slots_info_data)){
           foreach($slots_info_data as $slots_info){
             $used_slots=$slots_info['used_slots']-1;
       $available_slots=$slots_info['no_of_slots']-$used_slots;
       
       $slot_id=$slots_info['id'];
        $params_update1=array(
            'used_slots'=>$used_slots,
            'available_slots'=>$available_slots,
          );  


             $this->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
           }
           
           
       }
       
                     
                     
                     
                     
                     
                     
                     
                     
                     
                    if($booking_from_db['status']=="pending"){
                    $this->google_trigger($booking_from_db,"DECLINED_BY_MERCHANT");
                    }else{
                        $this->google_trigger($booking_from_db,"CANCELED");
                        
                    }



                   }


                   //---for slots decrement



//--------------------------------------------------------was custom code-----------------------------------------



                
                $res= $this->updateData("mt_bookingtable", $params, 'booking_id', $booking_id);


                if ($res){
                    
                    
                    /*INSERT HISTORY*/
                    $params_history=array(
                      'booking_id'=>$booking_id,
                      'status'=>$params['status'],
                      'remarks'=>"holiday",
                      'date_created'=>$this->dateNow()
                    );
                    

                   $this->insertData('mt_bookingtable_history', $params_history);

              
            



                    
                    /*SEND EMAIL TO CUSTOMER*/
                    $new_data=$params_noti;
                    $new_data['booking_id']=$booking_id_google;
                    $new_data['remarks']=$this->data['message'];

                   if($params['status']=="cancel_booking_approved"){
                    $new_data['status']="is canceled";
                   }

                   
                   $new_data['booking_time']= $this->prettyTime($booking_from_db['booking_time']);
                    $new_data['restaurant_name']=$mt_info['restaurant_name'];

                    $this->updateBookingNotify($new_data);
                    $this->PointsProgram = new PointsProgram();  
                    
                   $this->PointsProgram->updateBookTable($booking_id,$params['status']);

                } 
            }          
        }

public function updatebooking_childtable($merchant_id, $holiday_date)
{
    try {
        // Delete from child table
        $stmt1 = $this->db->prepare("
            DELETE FROM mt_booking_slots_child
            WHERE merchant_id = '$merchant_id' 
            AND date = '$holiday_date'
        ");
        $stmt1->execute();
        $deletedChild = $stmt1->rowCount();

        // Delete from main table
        $stmt2 = $this->db->prepare("
            DELETE FROM mt_booking_slots
            WHERE merchant_id = '$merchant_id' 
            AND date = '$holiday_date'
        ");
        $stmt2->execute();
        $deletedMain = $stmt2->rowCount();

        // If any record was deleted, update admin option
        if ($deletedChild > 0 || $deletedMain > 0) {
            $this->updateOptionAdmin('feed_upload', 1);
        }

        return true;

    } catch (Exception $e) {
        // Log or handle error if needed
        return false;
    }
}


public function chk_slots_duplication($merchant_id, $date)
{
    try {
        $stmt = $this->db->prepare("
            SELECT COUNT(*) AS cnt 
            FROM mt_booking_slots 
            WHERE merchant_id = '$merchant_id' 
            AND date = '$date'
        ");
        $stmt->execute();
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        
        return isset($res['cnt']) ? (int)$res['cnt'] : 0;
        
    } catch (Exception $e) {
        // Optionally log the error
        return 0;
    }
}








public function getPageByID($page_id = "")
{
    if (empty($page_id)) {
        return false;
    }

    // Prepare the SQL statement
    $stmt = "
    SELECT * FROM
    mt_singleapp_pages
    WHERE
    page_id = :page_id
    LIMIT 1
    ";

    // Prepare and execute the statement
    $query = $this->db->prepare($stmt);
    $query->bindParam(':page_id', $page_id, PDO::PARAM_INT);
    
    // Execute the query
    if ($query->execute()) {
        // Fetch the result as an associative array
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res ?: false; // Return the result or false if empty
    }

    return false; // Return false if execution fails
}
 




public function getAddonCategory2($subcat_id = '') {
    $mid = $this->getMerchantID();
    
    // Get the PDO connection from the Model class
    $connection = $this->db;
    
    // Prepare the SQL statement with placeholders
    $stmt = "
        SELECT * FROM mt_subcategory
        WHERE subcat_id = :subcat_id
        AND merchant_id = :merchant_id
        ORDER BY subcat_id DESC
    ";
    
    // Prepare the query
    $query = $connection->prepare($stmt);
    
    // Bind the parameters
    $query->bindParam(':subcat_id', $subcat_id, PDO::PARAM_INT);
    $query->bindParam(':merchant_id', $mid, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);
    
    // Return the first row if found, otherwise return false
    if ($res) {
        return $res;
    }
    
    return false;
}


public function getCustomPageList()
{
    // Prepare the SQL query
    $stmt = $this->db->prepare("
        SELECT * FROM mt_custom_page
        WHERE status IN ('publish')
        ORDER BY sequence ASC
    ");

    // Execute the query
    $stmt->execute();

    // Fetch the results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Check if there are results and return them, otherwise return false
    if ($res) {
        return $res;
    }

    return false;
}


public function limitDescription($text='',$limit=300)
    {
      if ( !empty($text)){
        return substr($text,0,$limit)."...";
      }
      return false;   
    }



public function timezoneList()
  {
      $t= array (
      '(UTC-11:00) Midway Island' => 'Pacific/Midway',
      '(UTC-11:00) Samoa' => 'Pacific/Samoa',
      '(UTC-10:00) Hawaii' => 'Pacific/Honolulu',
      '(UTC-09:00) Alaska' => 'US/Alaska',
      '(UTC-08:00) Pacific Time (US &amp; Canada)' => 'America/Los_Angeles',
      '(UTC-08:00) Tijuana' => 'America/Tijuana',
      '(UTC-07:00) Arizona' => 'US/Arizona',
      '(UTC-07:00) Chihuahua' => 'America/Chihuahua',
      '(UTC-07:00) La Paz' => 'America/Chihuahua',
      '(UTC-07:00) Mazatlan' => 'America/Mazatlan',
      '(UTC-07:00) Mountain Time (US &amp; Canada)' => 'US/Mountain',
      '(UTC-06:00) Central America' => 'America/Managua',
      '(UTC-06:00) Central Time (US &amp; Canada)' => 'US/Central',
      '(UTC-06:00) Guadalajara' => 'America/Mexico_City',
      '(UTC-06:00) Mexico City' => 'America/Mexico_City',
      '(UTC-06:00) Monterrey' => 'America/Monterrey',
      '(UTC-06:00) Saskatchewan' => 'Canada/Saskatchewan',
      '(UTC-05:00) Bogota' => 'America/Bogota',
      '(UTC-05:00) Eastern Time (US &amp; Canada)' => 'US/Eastern',
      '(UTC-05:00) Indiana (East)' => 'US/East-Indiana',
      '(UTC-05:00) Lima' => 'America/Lima',
      '(UTC-05:00) Quito' => 'America/Bogota',
      '(UTC-04:00) Atlantic Time (Canada)' => 'Canada/Atlantic',
      '(UTC-04:30) Caracas' => 'America/Caracas',
      '(UTC-04:00) La Paz' => 'America/La_Paz',
      '(UTC-04:00) Santiago' => 'America/Santiago',
      '(UTC-03:30) Newfoundland' => 'Canada/Newfoundland',
      '(UTC-03:00) Brasilia' => 'America/Sao_Paulo',
      '(UTC-03:00) Buenos Aires' => 'America/Argentina/Buenos_Aires',
      '(UTC-03:00) Georgetown' => 'America/Argentina/Buenos_Aires',
      '(UTC-03:00) Greenland' => 'America/Godthab',
      '(UTC-02:00) Mid-Atlantic' => 'America/Noronha',
      '(UTC-01:00) Azores' => 'Atlantic/Azores',
      '(UTC-01:00) Cape Verde Is.' => 'Atlantic/Cape_Verde',
      '(UTC+00:00) Casablanca' => 'Africa/Casablanca',
      '(UTC+00:00) Edinburgh' => 'Europe/London',
      '(UTC+00:00) Greenwich Mean Time : Dublin' => 'Etc/Greenwich',
      '(UTC+00:00) Lisbon' => 'Europe/Lisbon',
      '(UTC+00:00) London' => 'Europe/London',
      '(UTC+00:00) Monrovia' => 'Africa/Monrovia',
      '(UTC+00:00) UTC' => 'UTC',
      '(UTC+01:00) Amsterdam' => 'Europe/Amsterdam',
      '(UTC+01:00) Belgrade' => 'Europe/Belgrade',
      '(UTC+01:00) Berlin' => 'Europe/Berlin',
      '(UTC+01:00) Bern' => 'Europe/Berlin',
      '(UTC+01:00) Bratislava' => 'Europe/Bratislava',
      '(UTC+01:00) Brussels' => 'Europe/Brussels',
      '(UTC+01:00) Budapest' => 'Europe/Budapest',
      '(UTC+01:00) Copenhagen' => 'Europe/Copenhagen',
      '(UTC+01:00) Ljubljana' => 'Europe/Ljubljana',
      '(UTC+01:00) Madrid' => 'Europe/Madrid',
      '(UTC+01:00) Paris' => 'Europe/Paris',
      '(UTC+01:00) Prague' => 'Europe/Prague',
      '(UTC+01:00) Rome' => 'Europe/Rome',
      '(UTC+01:00) Sarajevo' => 'Europe/Sarajevo',
      '(UTC+01:00) Skopje' => 'Europe/Skopje',
      '(UTC+01:00) Stockholm' => 'Europe/Stockholm',
      '(UTC+01:00) Vienna' => 'Europe/Vienna',
      '(UTC+01:00) Warsaw' => 'Europe/Warsaw',
      '(UTC+01:00) West Central Africa' => 'Africa/Lagos',
      '(UTC+01:00) Zagreb' => 'Europe/Zagreb',
      '(UTC+02:00) Athens' => 'Europe/Athens',
      '(UTC+02:00) Bucharest' => 'Europe/Bucharest',
      '(UTC+02:00) Cairo' => 'Africa/Cairo',
      '(UTC+02:00) Harare' => 'Africa/Harare',
      '(UTC+02:00) Helsinki' => 'Europe/Helsinki',
      '(UTC+02:00) Istanbul' => 'Europe/Istanbul',
      '(UTC+02:00) Jerusalem' => 'Asia/Jerusalem',
      '(UTC+02:00) Kyiv' => 'Europe/Helsinki',
      '(UTC+02:00) Pretoria' => 'Africa/Johannesburg',
      '(UTC+02:00) Riga' => 'Europe/Riga',
      '(UTC+02:00) Sofia' => 'Europe/Sofia',
      '(UTC+02:00) Tallinn' => 'Europe/Tallinn',
      '(UTC+02:00) Vilnius' => 'Europe/Vilnius',
      '(UTC+03:00) Baghdad' => 'Asia/Baghdad',
      '(UTC+03:00) Kuwait' => 'Asia/Kuwait',
      '(UTC+03:00) Minsk' => 'Europe/Minsk',
      '(UTC+03:00) Nairobi' => 'Africa/Nairobi',
      '(UTC+03:00) Riyadh' => 'Asia/Riyadh',
      '(UTC+03:00) Volgograd' => 'Europe/Volgograd',
      '(UTC+03:30) Tehran' => 'Asia/Tehran',
      '(UTC+04:00) Abu Dhabi' => 'Asia/Muscat',
      '(UTC+04:00) Baku' => 'Asia/Baku',
      '(UTC+04:00) Moscow' => 'Europe/Moscow',
      '(UTC+04:00) Muscat' => 'Asia/Muscat',
      '(UTC+04:00) St. Petersburg' => 'Europe/Moscow',
      '(UTC+04:00) Tbilisi' => 'Asia/Tbilisi',
      '(UTC+04:00) Yerevan' => 'Asia/Yerevan',
      '(UTC+04:30) Kabul' => 'Asia/Kabul',
      '(UTC+05:00) Islamabad' => 'Asia/Karachi',
      '(UTC+05:00) Karachi' => 'Asia/Karachi',
      '(UTC+05:00) Tashkent' => 'Asia/Tashkent',
      '(UTC+05:30) Chennai' => 'Asia/Calcutta',
      '(UTC+05:30) Kolkata' => 'Asia/Kolkata',
      '(UTC+05:30) Mumbai' => 'Asia/Calcutta',
      '(UTC+05:30) New Delhi' => 'Asia/Calcutta',
      '(UTC+05:30) Sri Jayawardenepura' => 'Asia/Calcutta',
      '(UTC+05:45) Kathmandu' => 'Asia/Katmandu',
      '(UTC+06:00) Almaty' => 'Asia/Almaty',
      '(UTC+06:00) Astana' => 'Asia/Dhaka',
      '(UTC+06:00) Dhaka' => 'Asia/Dhaka',
      '(UTC+06:00) Ekaterinburg' => 'Asia/Yekaterinburg',
      '(UTC+06:30) Rangoon' => 'Asia/Rangoon',
      '(UTC+07:00) Bangkok' => 'Asia/Bangkok',
      '(UTC+07:00) Hanoi' => 'Asia/Bangkok',
      '(UTC+07:00) Jakarta' => 'Asia/Jakarta',
      '(UTC+07:00) Novosibirsk' => 'Asia/Novosibirsk',
      '(UTC+08:00) Beijing' => 'Asia/Hong_Kong',
      '(UTC+08:00) Chongqing' => 'Asia/Chongqing',
      '(UTC+08:00) Hong Kong' => 'Asia/Hong_Kong',
      '(UTC+08:00) Krasnoyarsk' => 'Asia/Krasnoyarsk',
      '(UTC+08:00) Kuala Lumpur' => 'Asia/Kuala_Lumpur',
      '(UTC+08:00) Perth' => 'Australia/Perth',
      '(UTC+08:00) Singapore' => 'Asia/Singapore',
      '(UTC+08:00) Taipei' => 'Asia/Taipei',
      '(UTC+08:00) Ulaan Bataar' => 'Asia/Ulan_Bator',
      '(UTC+08:00) Urumqi' => 'Asia/Urumqi',
      '(UTC+09:00) Irkutsk' => 'Asia/Irkutsk',
      '(UTC+09:00) Osaka' => 'Asia/Tokyo',
      '(UTC+09:00) Sapporo' => 'Asia/Tokyo',
      '(UTC+09:00) Seoul' => 'Asia/Seoul',
      '(UTC+09:00) Tokyo' => 'Asia/Tokyo',
      '(UTC+09:30) Adelaide' => 'Australia/Adelaide',
      '(UTC+09:30) Darwin' => 'Australia/Darwin',
      '(UTC+10:00) Brisbane' => 'Australia/Brisbane',
      '(UTC+10:00) Canberra' => 'Australia/Canberra',
      '(UTC+10:00) Guam' => 'Pacific/Guam',
      '(UTC+10:00) Hobart' => 'Australia/Hobart',
      '(UTC+10:00) Melbourne' => 'Australia/Melbourne',
      '(UTC+10:00) Port Moresby' => 'Pacific/Port_Moresby',
      '(UTC+10:00) Sydney' => 'Australia/Sydney',
      '(UTC+10:00) Yakutsk' => 'Asia/Yakutsk',
      '(UTC+11:00) Vladivostok' => 'Asia/Vladivostok',
      '(UTC+12:00) Auckland' => 'Pacific/Auckland',
      '(UTC+12:00) Fiji' => 'Pacific/Fiji',
      '(UTC+12:00) International Date Line West' => 'Pacific/Kwajalein',
      '(UTC+12:00) Kamchatka' => 'Asia/Kamchatka',
      '(UTC+12:00) Magadan' => 'Asia/Magadan',
      '(UTC+12:00) Marshall Is.' => 'Pacific/Fiji',
      '(UTC+12:00) New Caledonia' => 'Asia/Magadan',
      '(UTC+12:00) Solomon Is.' => 'Asia/Magadan',
      '(UTC+12:00) Wellington' => 'Pacific/Auckland',
      '(UTC+13:00) Nuku\'alofa' => 'Pacific/Tongatapu'
      );
      
      $t=array_flip($t);
      return $t;
  }



    

    public function getCustomPage($id = '')
{
    // Access the database connection from the Model class
    $stmt = $this->db->prepare("SELECT * FROM mt_custom_page WHERE id = :id LIMIT 1");
    
    // Bind the ID parameter to prevent SQL injection
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch the result
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }
    
    // Return false if no results are found
    return false;
}


public function getVoucherCodeByIdNew($voucher_id='')
    {
            
        $stmt = "
    SELECT a.*,
    (
        SELECT count(*)
        FROM mt_order
        WHERE voucher_code = a.voucher_name
    ) as found
    FROM mt_voucher_new a
    WHERE voucher_id = :voucher_id
    LIMIT 0, 1
";

$query = $this->db->prepare($stmt);
$query->execute([':voucher_id' => $voucher_id]);

$res = $query->fetch(PDO::FETCH_ASSOC);

if ($res) {
    return $res;
}

return false;

    } 

     public function voucherType()
    {
        return array(
          'fixed amount'=>$this->translation("default","fixed amount"),
          'percentage'=>$this->translation("default","percentage")
        );
    }


    public function checkIFVoucherCodeExisting($voucher_name = '', $voucher_id = '')
{
    $stmt = "SELECT * FROM
        mt_voucher_new
        WHERE
        voucher_name = :voucher_name
        AND
        voucher_id NOT IN (:voucher_id)
        LIMIT 1
    ";
    
    $params = [
        ':voucher_name' => $voucher_name,
        ':voucher_id' => $voucher_id
    ];
    
    $query = $this->db->prepare($stmt);
    $query->execute($params);
    
    $result = $query->fetchAll(PDO::FETCH_ASSOC);
    
    if ($result) {
        return $result;
    }
    
    return false;
}


public function isAdminExist($contact_email = '')
{
    if (empty($contact_email)) {
        return false; // Handle empty email case
    }

    $sql = "SELECT * FROM mt_admin_user WHERE email_address = :email_address LIMIT 0,1";
    
    $stmt = $this->db->prepare($sql);
    $stmt->bindParam(':email_address', $contact_email, PDO::PARAM_STR);
    
    if ($stmt->execute()) {
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }
    
    return false;
}

 public function generateCustomerToken() 
{
    $token = $this->generateCode(70);
    
    // Check if the generated token already exists
    $stmt = $this->db->prepare("SELECT token FROM mt_client WHERE token = :token LIMIT 1");
    $stmt->bindValue(':token', $token);
    $stmt->execute();

    // If the token already exists, generate a new one
    if ($stmt->rowCount() > 0) {
        return $this->generateCustomerToken();
    }
    
    return $token;
}


public  function sendEmailVerificationCode($to='',$code='',$info='')
    {    
      if(empty($to)){
        return false;
      }

      $lang='en';     
      $enabled  = $this->getOptionAdmin("customer_verification_code_email_email");
      if ( $enabled==1){
        $subject = $this->getOptionAdmin("customer_verification_code_email_tpl_subject_$lang");
        if(!empty($subject)){
          $subject=$this->smarty('firstname',isset($info['first_name'])?$info['first_name']:'',$subject );
          $subject=$this->smarty('lastname',isset($info['last_name'])?$info['last_name']:'',$subject );
        }
        
        $tpl = $this->getOptionAdmin("customer_verification_code_email_tpl_content_$lang");
        if(!empty($tpl)){         
          $tpl=$this->smarty('firstname',isset($info['first_name'])?$info['first_name']:'',$tpl );
          $tpl=$this->smarty('lastname',isset($info['last_name'])?$info['last_name']:'',$tpl );
          $tpl=$this->smarty('verification_link',isset($info['verification_link'])?$info['verification_link']:'',$tpl );
          $tpl=$this->smarty('code',$code,$tpl );
          $tpl=$this->smarty('sitename',$this->getOptionAdmin('website_title'),$tpl);
          $tpl=$this->smarty('siteurl',$this->websiteUrl(),$tpl);
        }
        if(!empty($subject) && !empty($tpl)){
          $this->sendEmail($to,'',$subject,$tpl);
          return true;
        }
      }
      
      return false;
    }

    public  function sendCustomerWelcomeEmail($data='')
    {
      $to = isset($data['email_address'])?$data['email_address']:'';
      $lang="en";     
      $enabled=$this->getOptionAdmin("customer_welcome_email_email");     
      if (!empty($to)){
        if ($enabled==1){
          $subject = $this->getOptionAdmin("customer_welcome_email_tpl_subject_$lang");
          
          $sitename = $this->getOptionAdmin('website_title');
          $site_url = $this->websiteUrl();
          
          if(!empty($subject)){
            $subject=$this->smarty('firstname',isset($data['first_name'])?$data['first_name']:'',$subject );
            $subject=$this->smarty('lastname',isset($data['lastname'])?$data['lastname']:'',$subject );
            $subject=$this->smarty('sitename',$sitename,$subject );
            $subject=$this->smarty('siteurl',$site_url,$subject );
          }
          
          $tpl=$this->getOptionAdmin('customer_welcome_email_tpl_content_'.$lang);
          if (!empty($tpl)){            
            $tpl=$this->smarty('firstname',isset($data['first_name'])?$data['first_name']:'',$tpl );
            $tpl=$this->smarty('lastname',isset($data['last_name'])?$data['last_name']:'',$tpl );
            $tpl=$this->smarty('sitename',$sitename,$tpl);
            $tpl=$this->smarty('siteurl',$site_url,$tpl);
          }       
          if (!empty($subject) && !empty($tpl)){
            $this->sendEmail($to,'',$subject,$tpl);
          }
        }
      }
    }


    public function clientAutoLogin($user = '', $pass = '', $md5_pass = '') 
{     
    // Prepare the SQL statement
    if (!empty($md5_pass)) {
        $stmt = $this->db->prepare("SELECT * FROM mt_client WHERE email_address = :email AND password = :password AND status IN ('active') AND is_guest = 2 LIMIT 1");
        $stmt->bindValue(':email', $user);
        $stmt->bindValue(':password', $md5_pass);
    } else {
        $stmt = $this->db->prepare("SELECT * FROM mt_client WHERE email_address = :email AND password = :password AND status IN ('active') AND is_guest = 2 LIMIT 1");
        $stmt->bindValue(':email', $user);
        $stmt->bindValue(':password', md5($pass));
    }

    // Execute the statement
    $stmt->execute();

    // Check if a user is found
    if ($stmt->rowCount() > 0) {        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        unset($res['password']); // Remove password from the result
        $client_id = $res['client_id'];

        // Update last login and IP address
        $update = [
            'last_login' => $this->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR']
        ];
        $this->updateData("mt_client", $update, 'client_id', $client_id);

        // Store user information in session
        $_SESSION['kr_client'] = $res;
        return true;
    }

    return false;
}


 public function clientAutoLogin_mainwebsite($user = '', $pass = '', $md5_pass = '') 
{     
    // Prepare the SQL statement
    if (!empty($md5_pass)) {
        $stmt = $this->db->prepare("SELECT * FROM mt_client WHERE email_address = :email AND password = :password AND status IN ('active') AND is_guest = 2 AND merchant_id = 0 LIMIT 1");
        $stmt->bindValue(':email', $user);
        $stmt->bindValue(':password', $md5_pass);
    } else {
        $stmt = $this->db->prepare("SELECT * FROM mt_client WHERE email_address = :email AND password = :password AND status IN ('active') AND is_guest = 2 AND merchant_id = 0 LIMIT 1");
        $stmt->bindValue(':email', $user);
        $stmt->bindValue(':password', md5($pass));
    }

    // Execute the statement
    $stmt->execute();

    // Check if a user is found
    if ($stmt->rowCount() > 0) {        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        unset($res['password']); // Remove password from the result
        $client_id = $res['client_id'];

        // Update last login and IP address
        $update = [
            'last_login' => $this->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR']
        ];
        $this->updateData("mt_client", $update, 'client_id', $client_id);

        // Store user information in session
        $_SESSION['kr_client'] = $res;
        return true;
    }

    return false;
}



  public function clientAutoLogin_with_merchant($user = '', $pass = '', $md5_pass = '', $merchant_id = '') 
{     
    if (!empty($md5_pass)) {
        $stmt = $this->db->prepare("SELECT * FROM mt_client 
            WHERE email_address = :email 
            AND password = :password 
            AND merchant_id = :merchant_id 
            AND status IN ('active') 
            AND is_guest = 2 
            LIMIT 1");
        $stmt->bindValue(':email', $user);
        $stmt->bindValue(':merchant_id', $merchant_id);
        $stmt->bindValue(':password', $md5_pass);
    } else {
        $stmt = $this->db->prepare("SELECT * FROM mt_client 
            WHERE email_address = :email 
            AND merchant_id = :merchant_id 
            AND password = :password 
            AND status IN ('active') 
            AND is_guest = 2 
            LIMIT 1");
        $stmt->bindValue(':email', $user);
        $stmt->bindValue(':merchant_id', $merchant_id);
        $stmt->bindValue(':password', md5($pass));
    }

    $stmt->execute();

    if ($stmt->rowCount() > 0) {        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        unset($res['password']); 
        $client_id = $res['client_id'];

        $update = [
            'last_login' => $this->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR']
        ];
        $this->updateData("mt_client", $update, 'client_id', $client_id);

        $_SESSION['kr_client'] = $res;
        return true;
    }

    return false;
}










public function clientAutoLogin_guest($user = '', $pass = '', $md5_pass = '') 
{       
    // Prepare the SQL statement
    if (!empty($md5_pass)) {
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_client 
            WHERE email_address = :email 
            AND password = :password 
            AND status IN ('active') 
            AND is_guest = 1 
            LIMIT 1
        ");
        $stmt->bindValue(':email', $user);
        $stmt->bindValue(':password', $md5_pass);
    } else {
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_client 
            WHERE email_address = :email 
            AND password = :password 
            AND status IN ('active') 
            AND is_guest = 1 
            LIMIT 1
        ");
        $stmt->bindValue(':email', $user);
        $stmt->bindValue(':password', md5($pass));
    }

    // Execute the statement
    $stmt->execute();

    // Check if a user is found
    if ($stmt->rowCount() > 0) {            
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        unset($res['password']); // Remove password from the result
        $client_id = $res['client_id'];

        // Update last login and IP address
        $update = [
            'last_login' => $this->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR']
        ];
        $this->updateData("mt_client", $update, 'client_id', $client_id);

        // Store user information in session
        $_SESSION['kr_client'] = $res;
        return true;
    }

    return false;
}


public function clientAutoLogin_guest_existing($user = '', $pass = '', $md5_pass = '') 
{       
    // Prepare the SQL statement
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_client 
        WHERE email_address = :email 
        AND password = :password 
        AND status IN ('active') 
        AND is_guest = 1 
        LIMIT 1
    ");
    
    // Bind parameters based on whether md5_pass is provided
    $stmt->bindValue(':email', $user);
    $stmt->bindValue(':password', $pass);

    // Execute the statement
    $stmt->execute();

    // Check if a user is found
    if ($stmt->rowCount() > 0) {            
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        unset($res['password']); // Remove password from the result
        $client_id = $res['client_id'];

        // Update last login and IP address
        $update = [
            'last_login' => $this->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR']
        ];
        $this->updateData("mt_client", $update, 'client_id', $client_id);

        // Store user information in session
        $_SESSION['kr_client'] = $res;
        return true;
    }

    return false;
}


 public function getLastIncrement($table_name = '')
{
    if (empty($table_name)) {
        return false;
    }

    $stmt = $this->db->prepare("SHOW TABLE STATUS LIKE ?");
    $stmt->execute([$table_name]);

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res['Auto_increment'];
    }

    return false;
}



















public  function sectionHeader($title='')
    {
      ?>
      <div class="section-label">
      <a class="section-label-a">
        <span class="bold">
        <?php echo ($title)?></span>
        <b></b>
      </a>     
     </div>    
      <?php
    }


   public function getAddressBookList($client_id = '')
{
    // Prepare SQL query with placeholders for safety
    $stmt = "
        SELECT 
            a.*, 
            b.name as state_name, 
            c.name as city_name, 
            c.postal_code, 
            d.name as area_name, 
            CONCAT(a.street, ' ', b.name, ' ', c.name, ' ', d.name, ' ', c.postal_code) as complete_address
        FROM
            mt_address_book_location a
        LEFT JOIN mt_location_states b ON a.state_id = b.state_id
        LEFT JOIN mt_location_cities c ON a.city_id = c.city_id
        LEFT JOIN mt_location_area d ON a.area_id = d.area_id
        WHERE
            a.client_id = :client_id
    ";

    // Prepare the statement using PDO
    $query = $this->db->prepare($stmt);
    
    // Bind the client_id parameter
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        $data = array();

        // Fetch the results and populate the data array
        while ($val = $query->fetch(PDO::FETCH_ASSOC)) {
            $data[$val['id']] = $val['complete_address'];
        }

        return $data;
    }

    return false;
}


public function getDefaultAddressByLocation($client_id = '')
{
    if ($client_id > 0) {
        // Prepare SQL query with a placeholder for client_id
        $stmt = "
            SELECT * FROM
                mt_address_book_location
            WHERE
                client_id = :client_id
                AND as_default = '1'
            LIMIT 1
        ";

        // Prepare the statement using PDO
        $query = $this->db->prepare($stmt);

        // Bind the client_id parameter
        $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);

        // Execute the query
        if ($query->execute()) {
            // Fetch the result
            $result = $query->fetch(PDO::FETCH_ASSOC);
            
            // If a result is found, return it
            if ($result) {
                return $result;
            }
        }
    }

    return false;
}

    public function checkalreadyorder_x($m_id = '')
{
    $m_id = (int) $m_id; // Ensure it's an integer to avoid SQL injection
    $sql = "SELECT order_number FROM mt_order
            WHERE merchant_id = $m_id
            
            ORDER BY order_number DESC
            LIMIT 1";

    $stmt = $this->db->query($sql);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!empty($res)) {
        return $res[0]['order_number'];
    }

    return 0;
}

public function checkalreadyorder($m_id = '')
{
    $m_id = (int) $m_id; // Ensure it's an integer to avoid SQL injection
    
    $sql = "SELECT MAX(order_number) as order_number 
            FROM mt_order 
            WHERE merchant_id = $m_id";
    
    $stmt = $this->db->query($sql);
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!empty($res) && $res['order_number'] !== null) {
        return $res['order_number'];
    }

    return 0;
}









public function generateCode($length = 8) {
       $chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
       $ret = '';
       for($i = 0; $i < $length; ++$i) {
         $random = str_shuffle($chars);
         $ret .= $random[0];
       }
       return $ret;
    }


    public function generateOrderToken()
{
    // Generate a token using the helper method
    $token = $this->generateCode(10);

    // Prepare the SQL query to check if the token already exists
    $stmt = "
        SELECT order_id_token
        FROM mt_order
        WHERE order_id_token = :token
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);
    
    // Bind the token parameter
    $query->bindParam(':token', $token, PDO::PARAM_STR);
    
    // Execute the query
    $query->execute();

    // Check if the token already exists
    if ($query->fetch(PDO::FETCH_ASSOC)) {
        // If the token exists, recursively generate a new one
        return $this->generateOrderToken();
    }

    // Return the generated token
    return $token;
}


public function saveAddresBookByLocation($client_id = '', $params = array())
{
    // Check if country_id is less than or equal to 0
    if ($params['country_id'] <= 0) {
        $stmt = "
            SELECT country_id
            FROM mt_location_states
            WHERE state_id = :state_id
            LIMIT 1
        ";

        // Prepare the statement
        $query = $this->db->prepare($stmt);

        // Bind the parameter
        $query->bindParam(':state_id', $params['state_id'], PDO::PARAM_INT);

        // Execute the query
        $query->execute();

        // Fetch the result
        $resp = $query->fetch(PDO::FETCH_ASSOC);
        
        // If a result is found, update the country_id in the params
        if ($resp) {
            $params['country_id'] = $resp['country_id'];
        }
    }

    // Now check if the address already exists in the address book
    $stmt = "
        SELECT * FROM mt_address_book_location
        WHERE client_id = :client_id
        AND state_id = :state_id
        AND city_id = :city_id
        AND area_id = :area_id
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind parameters
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $query->bindParam(':state_id', $params['state_id'], PDO::PARAM_INT);
    $query->bindParam(':city_id', $params['city_id'], PDO::PARAM_INT);
    $query->bindParam(':area_id', $params['area_id'], PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // If no results found, insert the new address
    if ($query->rowCount() === 0) {
        $this->insertData('mt_address_book_location', $params);
    }

    return false;
}
 



    public function getWebsiteName()
    {
        return $this->getOptionAdmin('website_title');
    }

    public function smarty($search='',$value='',$subject='')
    {   
       $n=str_replace("[".$search."]",$value,$subject);
       $n=str_replace("{".$search."}",$value,$n);
       return $n;
    } 

    public function prettyLink($link='')
    {
      if (!preg_match("/http/i", $link)) {
       $link="http://".$link;
        } 
        return $link;
    }


   public function getAdminUserInfo($admin_id = '')
{
    if (empty($admin_id)) {
        return false;
    }

    $stmt = $this->db->prepare("SELECT * FROM mt_admin_user WHERE admin_id = :admin_id LIMIT 1");
    $stmt->bindParam(':admin_id', $admin_id, PDO::PARAM_INT);

    if ($stmt->execute()) {
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }

    return false;
}

public  function getRates()
{
    // Assuming you are storing the exchange rate in a session variable
     // Start the session if not already started
    
    // Retrieve exchange rate from the session
    $rates = isset($_SESSION['exchange_rate']) ? $_SESSION['exchange_rate'] : [];
    
    // Get the exchange rate or set default to 1 if not set
    $exchange_rate = isset($rates['exchange_rate']) ? (float)$rates['exchange_rate'] : 1;
    
    return $exchange_rate;
}

 public function GetViewLocationRateByMerchant($mtid = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_view_location_rate
        WHERE merchant_id = :merchant_id
        ORDER BY sequence ASC
    ");
    $stmt->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);
    $stmt->execute();
    
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    return $res ?: false;
}   


public  function getDeliveryEstimation($merchant_id='')
    {
      $delivery_est=$this->getOption("merchant_delivery_estimation",$merchant_id);
      if (empty($delivery_est)){
        return "not available";
      }
      return $delivery_est;
    }


public function merchantActiveVoucher($merchant_id = '')
{
    // Prepare the necessary values for the query
    $mtid = '"' . $merchant_id . '"';
    $today = strtolower(date("l"));

    // PDO query with placeholders to prevent SQL injection
    $stmt = $this->db->prepare("
        SELECT * FROM mt_voucher_new
        WHERE status IN ('publish', 'published')
        AND now() <= expiration
        AND {$today} = 1
        AND (merchant_id = :merchant_id OR joining_merchant LIKE :mtid)
        LIMIT 10
    ");

    // Bind parameters to the query
    $stmt->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindValue(':mtid', "%$mtid%", PDO::PARAM_STR); // Use bindValue instead of bindParam

    // Execute the query
    $stmt->execute();

    // Fetch all results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Check if any results were found
    if ($res) {
        return $res;
    }

    return false;
}

public function getOrderInfoByToken($order_id_token = '')
{
    if (empty($order_id_token)) {
        return false;
    }

    $stmt = "SELECT * FROM mt_order WHERE order_id_token = :order_id_token LIMIT 1";
    $query = $this->db->prepare($stmt);
    $query->bindParam(':order_id_token', $order_id_token, PDO::PARAM_STR);
    
    if ($query->execute()) {
        $result = $query->fetch(PDO::FETCH_ASSOC);
        return $result ?: false;
    }
    return false;
}


public function getOrderInfoByToken_appside($order_id_token = '')
{
    if (empty($order_id_token)) {
        return false;
    }

    $stmt = "SELECT * FROM mt_order WHERE order_id= :order_id_token LIMIT 1";
    $query = $this->db->prepare($stmt);
    $query->bindParam(':order_id_token', $order_id_token, PDO::PARAM_STR);
    
    if ($query->execute()) {
        $result = $query->fetch(PDO::FETCH_ASSOC);
        return $result ?: false;
    }
    return false;
}


public function get_windcave_payment_status($session_id, $merchant_id)
{
    $merchant_type = $this->getMerchantMembershipType($merchant_id);
    
    if ($merchant_type == '1') {
        $paymode = $this->getOption('windcave_mode', $merchant_id);
        $apiUsername = $this->getOption(
            $paymode == 'Sandbox' ? 'wind_user_id_sandbox' : 'wind_user_id',
            $merchant_id
        );
        $apiKey = $this->getOption(
            $paymode == 'Sandbox' ? 'wind_key_sandbox' : 'wind_key',
            $merchant_id
        );
    } else {
        $paymode = $this->getOptionAdmin('windcave_mode');
        $apiUsername = $this->getOptionAdmin(
            $paymode == 'Sandbox' ? 'wind_user_id_sandbox' : 'wind_user_id'
        );
        $apiKey = $this->getOptionAdmin(
            $paymode == 'Sandbox' ? 'wind_key_sandbox' : 'wind_key'
        );
    }

    $auth = base64_encode("{$apiUsername}:{$apiKey}");

    $url = $paymode == 'Sandbox'
        ? "https://uat.windcave.com/api/v1/sessions/{$session_id}"
        : "https://sec.windcave.com/api/v1/sessions/{$session_id}";

    $headers = [
        "Authorization: Basic $auth",
        "Content-Type: application/json",
    ];

    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");

    $response = curl_exec($ch);
    curl_close($ch);

    return json_decode($response, true);
}







public  function updateOrderPayment(
    $order_id,$payment_code='',$payment_ref='',$payment_response='', $merchant_ref='')
    {
      
      $params_logs = array(
       'order_id'=>$order_id,
       'payment_type'=>$payment_code,
       'payment_reference'=>$payment_ref,
       'raw_response'=>json_encode($payment_response),
       'date_created'=>$this->dateNow(),
         'ip_address'=>$_SERVER['REMOTE_ADDR'],
         'merchant_ref'=>$merchant_ref
      );  
      $this->insertData("mt_payment_order",$params_logs);
      
      $params_update=array(
         'status'=>'paid',
         'date_modified'=>$this->dateNow(),
         'ip_address'=>$_SERVER['REMOTE_ADDR']
      );              
      $this->updateData("mt_order",$params_update,'order_id',$order_id);
      
      $this->insertData("mt_order_history",array(
         'order_id'=>$order_id,
         'status'=>"paid",
         'date_created'=>$this->dateNow(),
         'ip_address'=>$_SERVER['REMOTE_ADDR'],
      ));
       
    }

public function getSMSTransLog($payment_ref = '')
{
    // Prepare the SQL statement with a placeholder for the payment reference
    $stmt = $this->db->prepare("SELECT * FROM mt_sms_trans_logs WHERE payment_reference = :payment_ref LIMIT 1");

    // Bind the payment reference to the placeholder
    $stmt->bindParam(':payment_ref', $payment_ref, PDO::PARAM_STR);

    // Execute the query
    if ($stmt->execute()) {
        // Fetch the result as an associative array
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }

    return false;
}





 public function getMerchantByToken($token = '')
{
    if (empty($token)) {
        return false;
    }

    $stmt = "
        SELECT a.*, 
        (
            SELECT title 
            FROM mt_packages 
            WHERE package_id = a.package_id
        ) as package_name
        FROM mt_merchant a
        WHERE activation_token = :activation_token
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':activation_token', $token, PDO::PARAM_STR);

    if ($query->execute()) {
        $result = $query->fetch(PDO::FETCH_ASSOC);
        return $result ?: false;
    }

    return false;
}


public  function getAdminCredentials_stp()
  {
    $enabled = false; $mode=''; 
    $secret_key = ''; $publish_key='';
    $webhook_secret='';
    
    $enabled = $this->getOptionAdmin('admin_stripe_enabled');
    $mode = $this->getOptionAdmin('admin_stripe_mode');   
    $card_fee = $this->getOptionAdmin('admin_stripe_card_fee');       
    
    $mode= strtolower($mode);
    switch ($mode){
      case "live":
        $secret_key = $this->getOptionAdmin('admin_live_stripe_secret_key');
        $publish_key = $this->getOptionAdmin('admin_live_stripe_pub_key');
        $webhook_secret=$this->getOptionAdmin('admin_live_stripe_webhooks');
        break;
        
      case "sandbox":
        $secret_key = $this->getOptionAdmin('admin_sanbox_stripe_secret_key');
        $publish_key = $this->getOptionAdmin('admin_sandbox_stripe_pub_key');
        $webhook_secret=$this->getOptionAdmin('admin_sandbox_stripe_webhooks');
        break;  
    }
                    
    if($enabled=="yes" && !empty($secret_key) && !empty($publish_key) ){
      return array(
        'mode'=>$mode,
        'card_fee'=>$card_fee,
        'secret_key'=>$secret_key,
        'publish_key'=>$publish_key,
        'webhook_secret'=>$webhook_secret
      );
    }
    return false;
  }


      public function upgradeMembership($merchant_id='',$package_id='')
    {
      $membership_expired='';
      $package_price='';
      if ( $package=$this->getPackagesById($package_id)){               
        $package_price=$package['price'];
        if ($package['promo_price']>0){
          $package_price=$package['promo_price'];
        }     
        $expiration=$package['expiration'];
            $membership_expired = date('Y-m-d', strtotime ("+$expiration days"));            
      }
      
      //dump("expire on : ".$membership_expired);
      
      if ($info=$this->getMerchant($merchant_id)){
        $t1=date('Ymd');        
        $membership_expired_1=$info['membership_expired'];        
        if ($membership_expired_1!="0000-00-00"){         
          $t2=date("Ymd",strtotime($membership_expired_1));         
          if ($t2>$t1){             
                $membership_expired = date('Y-m-d', strtotime ("$membership_expired_1 +$expiration days"));  
          }  
        }             
      }
      
      //dump("expire on : ".$membership_expired);
      
      return array(
       'membership_expired'=>$membership_expired,
       'package_price'=>$package_price
      );
    }


    public  function sendWelcomeEmailMerchant($data='',$force_send=false)
    {
      $lang='en'; $sender=$this->getOptionAdmin('global_admin_sender_email');
      $enabled=$this->getOptionAdmin("merchant_welcome_signup_email");
      
      $disabled_verification = $this->getOptionAdmin("merchant_email_verification");
      if($disabled_verification=="yes"){
      } else {
        if($force_send==false){
           return ;
        }
      }
     
      if($enabled==1){
         
          $tpl=$this->getOptionAdmin("merchant_welcome_signup_tpl_content_$lang");
          $subject=$this->getOptionAdmin("merchant_welcome_signup_tpl_subject_$lang");
        
          $data['login_url'] = Config::$baseUrl."/merchant";
          $email=isset($data['contact_email'])?$data['contact_email']:'';
        
          $pattern=array(                    
           'restaurant_name'=>'restaurant_name',
           'login_url'=>'login_url',
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),               
          );
          $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
          $subject=$this->replaceTemplateTags($subject,$pattern,$data);
            

          
          $params=array(
         'email_address'=>$email,
         'sender'=>$sender,
         'subject'=>$subject,
         'content'=>$tpl,
         'date_created'=>$this->dateNow(),
         'ip_address'=>$_SERVER['REMOTE_ADDR'],
         'module_type'=>'core'
        );                    
        $this->insertData("mt_email_logs",$params);       
        
      }     
    }


     public  function NotiNewMerchantSignup($data='', $merchant_type='')
    {
        /*EMAIL*/
        
        $sender=$this->getOptionAdmin('global_admin_sender_email');
        
        $lang='en'; 
        $enabled = $this->getOptionAdmin('merchant_new_signup_email');
        $to = trim($this->getOptionAdmin('noti_new_signup_email'));

       
        if ($enabled==1 && !empty($to)){
         

            $subject = $this->getOptionAdmin("merchant_new_signup_tpl_subject_$lang");
            $tpl = $this->getOptionAdmin("merchant_new_signup_tpl_content_$lang");
            $package_info = $this->getPackagesById( isset($data['package_id'])?$data['package_id']:'' ); 
            if (!empty($tpl)){                                              
                $tpl = $this->smarty("restaurant_name",$data['restaurant_name'],$tpl);
                $tpl = $this->smarty("merchant_type",$merchant_type,$tpl);               
                $tpl = $this->smarty("package_name",isset($package_info['title'])?$package_info['title']:'',$tpl);
                $tpl=$this->smarty('sitename',$this->getOptionAdmin('website_title'),$tpl);
                $tpl=$this->smarty('siteurl',$this->websiteUrl(),$tpl);
            }




            if (!empty($subject)){                                              
                $subject = $this->smarty("restaurant_name",$data['restaurant_name'],$subject);
                $subject = $this->smarty("merchant_type",$merchant_type,$subject);               
                $subject = $this->smarty("package_name",isset($package_info['title'])?$package_info['title']:'',$subject);
                $subject=$this->smarty('sitename',$this->getOptionAdmin('website_title'),$subject);
                $subject=$this->smarty('siteurl',$this->websiteUrl(),$subject);
            }

            if(!empty($tpl) && !empty($to)){
                $to=explode(",",$to);               
                if(is_array($to) && count($to)>=1){
                    foreach ($to as $email) {  

                        $params=array(
                           'email_address'=>$email,
                           'sender'=>$sender,
                           'subject'=>$subject,
                           'content'=>$tpl,
                           'date_created'=>$this->dateNow(),
                           'ip_address'=>$_SERVER['REMOTE_ADDR'],
                           'module_type'=>'core',                          
                        );
                        $this->insertData("mt_email_logs",$params);
                    }
                }
            }
        }       
        
        /*SMS*/
        $enabled = $this->getOptionAdmin('merchant_new_signup_sms');
        $mobile = trim($this->getOptionAdmin('noti_new_signup_sms'));
        if ($enabled==1 && !empty($mobile)){
            $tpl = $this->getOptionAdmin("merchant_new_signup_sms_content_$lang");
            if(!empty($tpl)){
                
                $tpl = $this->smarty("restaurant_name",$data['restaurant_name'],$tpl);
                $tpl = $this->smarty("merchant_type",$merchant_type,$tpl);               
                $tpl = $this->smarty("package_name",isset($package_info['title'])?$package_info['title']:'',$tpl);
                $tpl=$this->smarty('sitename',$this->getOptionAdmin('website_title'),$tpl);
                $tpl=$this->smarty('siteurl',$this->websiteUrl(),$tpl);
                
                $mobile = explode(",",$mobile);             
                if(is_array($mobile) && count($mobile)>=1){
                    foreach ($mobile as $phone) {                       
                        $params=array(
                          'contact_phone'=>$phone,
                          'sms_message'=>$tpl,
                          'date_created'=>$this->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR']
                        );
                        $this->insertData("mt_sms_broadcast_details",$params);
                    }
                }
            }
        }       
    }




       public  function sendMerchantActivation($data='',$code='')
    {

      $disabled_verification = $this->getOptionAdmin("merchant_email_verification");
      if($disabled_verification=="yes"){
        return false;
      } 


            
      $to=isset($data['contact_email'])?$data['contact_email']:'';

      $lang="en";         
      $enabled=$this->getOptionAdmin("merchant_verification_code_email");

      if ($enabled||1==1){

        $subject = $this->getOptionAdmin("merchant_verification_code_tpl_subject_$lang");
        $tpl=$this->getOptionAdmin("merchant_verification_code_tpl_content_$lang");
        if(!empty($tpl)){
          $tpl=$this->smarty('code',$code,$tpl);
          
          $tpl=$this->smarty('restaurant_name',
          isset($data['restaurant_name'])?$data['restaurant_name']:"",$tpl);
          
          $tpl=$this->smarty('login_url',Config::$baseUrl."/merchant"
          ,$tpl);
          
          $tpl=$this->smarty('sitename',$this->getOptionAdmin('website_title'),$tpl);
                $tpl=$this->smarty('siteurl',$this->websiteUrl(),$tpl); 
        }
        if (!empty($tpl) && !empty($subject)){
          
          $this->sendEmail($to,'',$subject, $tpl );
        }
      }
    }







public function getOrderByToken($order_id_token = '')
{
    $stmt = "
        SELECT a.*,
        (
            SELECT CONCAT(first_name, ' ', last_name) AS full_name
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS full_name,
        
        (
            SELECT email_address
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS email_address,
        
        (
            SELECT restaurant_name
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id
            LIMIT 1
        ) AS merchant_name,
        
        (
            SELECT restaurant_slug
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id
            LIMIT 1
        ) AS restaurant_slug,
        
        (
            SELECT CONCAT(street, ' ', city, ' ', state, ' ', zipcode)
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS full_address,
        
        (
            SELECT location_name
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS location_name,
        
        (
            SELECT contact_phone
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS contact_phone,
        
        (
            SELECT credit_card_number
            FROM mt_client_cc
            WHERE cc_id = a.cc_id
            LIMIT 1
        ) AS credit_card_number
        FROM mt_order a
        WHERE order_id_token = :order_id_token
        LIMIT 1
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':order_id_token', $order_id_token, PDO::PARAM_STR);
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);
        
        if (is_array($rows) && count($rows) >= 1) {
            return $rows[0];
        }
        return false;
    } catch (PDOException $e) {
        // Handle exception or log error
        error_log('Database Query Error: ' . $e->getMessage());
        return false;
    }
}


public function getOrderByToken_appside($order_id_token = '')
{
    $stmt = "
        SELECT a.*,
        (
            SELECT CONCAT(first_name, ' ', last_name) AS full_name
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS full_name,
        
        (
            SELECT email_address
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS email_address,
        
        (
            SELECT restaurant_name
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id
            LIMIT 1
        ) AS merchant_name,
        
        (
            SELECT restaurant_slug
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id
            LIMIT 1
        ) AS restaurant_slug,
        
        (
            SELECT CONCAT(street, ' ', city, ' ', state, ' ', zipcode)
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS full_address,
        
        (
            SELECT location_name
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS location_name,
        
        (
            SELECT contact_phone
            FROM mt_client
            WHERE client_id = a.client_id
            LIMIT 1
        ) AS contact_phone,
        
        (
            SELECT credit_card_number
            FROM mt_client_cc
            WHERE cc_id = a.cc_id
            LIMIT 1
        ) AS credit_card_number
        FROM mt_order a
        WHERE order_id = :order_id_token
        LIMIT 1
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':order_id_token', $order_id_token, PDO::PARAM_STR);
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);
        
        if (is_array($rows) && count($rows) >= 1) {
            return $rows[0];
        }
        return false;
    } catch (PDOException $e) {
        // Handle exception or log error
        error_log('Database Query Error: ' . $e->getMessage());
        return false;
    }
}
    



public function getCustomerFavorites($client_id = '')
{
    try {
        $query = "
            SELECT merchant_id
            FROM mt_favorites
            WHERE client_id = :client_id
            ORDER BY id ASC
        ";

        $stmt = $this->db->prepare($query);
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);

        if ($stmt->execute()) {
            $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
            return $res ?: false; // Return the result or false if empty
        }
    } catch (PDOException $e) {
        // Log or handle the exception as needed
        return false;
    }
}


 


public function getOffersByMerchantNew($merchant_id = '', $exchange_rate = 1)
{
    $offer_list = array();
    $offer = '';

    // PDO query with placeholders to prevent SQL injection
    $stmt = $this->db->prepare("
        SELECT * FROM mt_offers
        WHERE status IN ('publish', 'published')
        AND now() >= valid_from AND now() <= valid_to
        AND merchant_id = :merchant_id
        ORDER BY valid_from ASC
    ");

    // Bind the merchant_id to the query
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    $stmt->execute();

    // Fetch all results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $applicable_to_list = '';

            // Check if applicable_to exists and is not empty
            if (isset($val['applicable_to'])) {
                $applicable_to = json_decode($val['applicable_to'], true);

                // If applicable_to is an array and not empty
                if (is_array($applicable_to) && count($applicable_to) >= 1) {
                    foreach ($applicable_to as $applicable_to_val) {
                        $applicable_to_list .= ($applicable_to_val) . ",";
                    }
                    $applicable_to_list = rtrim($applicable_to_list, ','); // Remove last comma
                }
            }

            // Construct offer string
            if (!empty($applicable_to_list)) {
                $offer = number_format($val['offer_percentage'], 0) . "% " . "Off over";
                $offer .= " " . self::formatNumber((float)$val['offer_price'] * (float)$exchange_rate);
                $offer .= " " . ("if") . " " . $applicable_to_list;
            } else {
                $offer = number_format($val['offer_percentage'], 0) . "% " . ("Off over");
                $offer .= " " . self::formatNumber((float)$val['offer_price'] * (float)$exchange_rate);
            }

            // Add offer to the offer list
            $offer_list[] = $offer;
        }

        return $offer_list;
    }

    return false;
}

public  function getOffersByMerchant($merchant_id='',$display_type=1)
    {
      $offer='';
      if ( $res=$this->getMerchantOffersActive($merchant_id)){                
        if ($display_type==1){
          $offer=number_format($res['offer_percentage'],0)."% "."Off";
        } else {
          $applicable_to_list = '';
          if(isset($res['applicable_to'])){
             $applicable_to=json_decode($res['applicable_to'],true);  
             if(is_array($applicable_to) && count($applicable_to)>=1){
                foreach ($applicable_to as $applicable_to_val) {                   
                   $applicable_to_list.=$this->translation("default",$applicable_to_val).",";
                }
                $applicable_to_list = substr($applicable_to_list,0,-1);
             }          
          }             
          if (!empty($applicable_to_list)){
            $offer=number_format($res['offer_percentage'],0)."% ".$this->translation("default","off today on orders over");
            $offer.=" ".$this->prettyPrice($res['offer_price']);
            $offer.=" ".$this->translation("default","when you checkout via")." ".$applicable_to_list;
          } else {
            $offer=number_format($res['offer_percentage'],0)."% ".$this->translation("default","off today on orders over");
            $offer.=" ".$this->prettyPrice($res['offer_price']);
          }
        }
        return $offer;
      }
      return false;
    } 
  




     public function sendEmail($to='',$from='',$subject='',$body='' , $record_id='')
    {    

        
        /*custom code 5 start */
        if(isset($from) && !empty($from)){}else{
        /*custom code 5 end*/
        
        $from1=$this->getOptionAdmin('global_admin_sender_email');
        if (!empty($from1)){
            $from=$from1;
        }       
        }
        $email_dsiabled_auto_break=$this->getOptionAdmin('email_dsiabled_auto_break');
        if($email_dsiabled_auto_break!=1){
           $body=nl2br($body);
        }
                    
        $send_status=false; $send_msg='';
                    
        $email_provider=$this->getOptionAdmin('email_provider');
        //dump($email_provider);
        switch ($email_provider) {
            case "smtp":
                $phpMailerPath = __DIR__ . '/../../vendor/smtp/src/PHPMailer.php';
    $smtpPath = __DIR__ . '/../../vendor/smtp/src/SMTP.php';
    $exceptionPath = __DIR__ . '/../../vendor/smtp/src/Exception.php';

    

    // Check if files exist
    if (file_exists($phpMailerPath) && file_exists($smtpPath) && file_exists($exceptionPath)) {
        require_once($phpMailerPath);
        require_once($smtpPath);
        require_once($exceptionPath);
    } else {
        //die("One or more PHPMailer files are missing.");
    }

               

               $mail = new \PHPMailer\PHPMailer\PHPMailer();

                // SMTP configuration
                $smtp_host = $this->getOptionAdmin('smtp_host'); // e.g., smtp.example.com
                $smtp_port =  $this->getOptionAdmin('smtp_port'); // or 465 for SSL
                $smtp_username = $this->getOptionAdmin('smtp_username'); // SMTP username
                $smtp_password = $this->getOptionAdmin('smtp_password'); // SMTP password
                $smtp_secure = $this->getOptionAdmin('smtp_secure'); // or 'ssl'

                // Server settings
                $mail->isSMTP(); // Set mailer to use SMTP
                $mail->Host = $smtp_host; // Specify main and backup SMTP servers
                $mail->SMTPAuth = true; // Enable SMTP authentication
                $mail->Username = $smtp_username; // SMTP username
                $mail->Password = $smtp_password; // SMTP password
                $mail->SMTPSecure = $smtp_secure; // Enable TLS encryption, `ssl` also accepted
                $mail->Port = $smtp_port; // TCP port to connect to

                // Recipients
                $mail->setFrom($from, ''); // From address
                $mail->addAddress($to, ''); // Add a recipient

                // Content
                $mail->isHTML(true); // Set email format to HTML
                $mail->Subject = $subject; // Email subject
                $mail->Body    = $body; // HTML body
                $mail->AltBody = strip_tags($body); // Plain text body (optional)

                // Send the email
                if (!$mail->send()) {
                    $send_msg = "Error occurred: " . $mail->ErrorInfo;
                    $send_status = false;
                } else {
                    $send_status = true;
                    $send_msg = "Sent";
                }

                break;
        
          
                 
            case "mailjet":     
                
                $phpMailerPath = __DIR__ . '/../../vendor/mailjet/Mailjet.php';
                if (file_exists($phpMailerPath)) {
                    require_once($phpMailerPath);
                }
                //require_once 'mailjet/Mailjet.php';
                $apikey = trim($this->getOptionAdmin('mailjet_api_key'));
                $secret_key = trim($this->getOptionAdmin('mailjet_secret_key'));
                $mj = new Mailjet($apikey, $secret_key);
                
                $params = array(
                    "method"  => "POST",
                    "from"    => $from,
                    "to"      => $to,
                    "subject" => $subject,
                    "html"    => $body
                );

                $mj_resp = $mj->sendEmail($params);
                
                if ($mj->_response_code == 200){
                   $send_status=true; $send_msg="sent";
                } else $send_msg = t("error occurred")." ".$mj->_response_code;
                            
               break;
          
            
            default:                
                $headers  = "From: $from\r\n";      
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";
                
$message =<<<EOF
$body
EOF;
                $headers  = "From: $from\r\n";                                
                $headers .= "Content-type: text/html; charset=UTF-8\r\n";

                //$message=htmlentities($message, ENT_QUOTES, 'UTF-8');

                if (!empty($to)) {
                    //if (@mail($to, '=?utf-8?B?'.base64_encode($subject).'?=', $message, $headers)){       
                    if (mail($to, $subject, $message, $headers)){
                        $send_status=true; $send_msg="sent";
                    } else $send_msg = $this->translation("default","error occurred");
                } else $send_msg = $this->translation("default","to is missing"); 
                break;
        }
                            
        $params_logs=array(
           'email_address'=>$to,
           'sender'=>$from,
           'subject'=>$subject,
           'content'=>$body,
           'status'=>$send_msg,
           'date_created'=>$this->dateNow(),
           'ip_address'=>$_SERVER['REMOTE_ADDR'],
           'module_type'=>"core",
           'email_provider'=>$email_provider
        );      
        //$DbExt=new DbExt;
        
        if ($record_id>0){
            $params_logs=array(
               'status'=>$send_msg,
               'email_provider'=>$email_provider,
               'ip_address'=>$_SERVER['REMOTE_ADDR'],
            );
            $this->updateData('mt_email_logs' , $params_logs ,'id',$record_id);
            //$DbExt->updateData("{{email_logs}}",$params_logs,'id',$record_id);
        } else $this->insertData('mt_email_logs', $params_logs);  
        //unset($DbExt);
        
        return $send_status;    
    }   


    public  function sendCustomerSMSVerification($phone='', $code='')
    {       
        $lang='en';   
        $enabled = $this->getOptionAdmin("customer_verification_code_sms_sms");    
        if ($enabled==1){
            $tpl = $this->getOptionAdmin("customer_verification_code_sms_sms_content_$lang");
            if(!empty($tpl)){
                $tpl=$this->smarty('code',$code,$tpl);
                $tpl=$this->smarty('sitename',$this->getOptionAdmin('website_title'),$tpl);
                $tpl=$this->smarty('siteurl',$this->websiteUrl(),$tpl);
            }           
            $res=$this->sendSMS($phone,$tpl);           
        }
    }              





public function checkIFVoucherCodeExists($voucher_name = '')
{
    $stmt = "SELECT * FROM
        mt_voucher_new
        WHERE
        voucher_name = :voucher_name
        LIMIT 1
    ";
    
    // Prepare the SQL statement
    $query = $this->db->prepare($stmt);
    
    // Bind the parameters
    $query->bindParam(':voucher_name', $voucher_name);
    
    // Execute the statement
    $query->execute();
    
    // Fetch the result
    $result = $query->fetchAll(PDO::FETCH_ASSOC);
    
    if ($result) {
        return $result;
    }
    
    return false;
}






public function dayList()
    {
        return array(
          'monday'=>$this->translation("default","monday"),
          'tuesday'=>$this->translation("default","tuesday"),
          'wednesday'=>$this->translation("default","wednesday"),
          'thursday'=>$this->translation("default","thursday"),
          'friday'=>$this->translation("default","friday"),
          'saturday'=>$this->translation("default","saturday"),
          'sunday'=>$this->translation("default","sunday")
        );
    }



public function getTopMenuActivated()
    {
        $theme_top_menu=$this->getOptionAdmin('theme_top_menu');
        if(empty($theme_top_menu)){
            $theme_top_menu=array(
              'browse','resto_signup','contact','signup','driver_signup'
            );
        } else $theme_top_menu=json_decode($theme_top_menu,true);
        
        return $theme_top_menu;
    }


   public function hasMembershipPackage()
{
    try {
        $stmt = "
        SELECT * FROM
        mt_packages
        WHERE status IN ('publish', 'published')
        LIMIT 0,1
        ";
        
        $query = $this->db->prepare($stmt);
        $query->execute();
        
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        
        if (!empty($res)) {
            return $res;
        }
        
        return false;
    } catch (PDOException $e) {
        // Log the error or handle it as needed
        error_log("Database error: " . $e->getMessage());
        return false;
    }
}

public  function minimumDeliveryFee()   
    {
        $minimum_list=array(
          '5'=>"< ".$this->displayPrice($this->getCurrencyCode(),5),
          '10'=>"< ".$this->displayPrice($this->getCurrencyCode(),10),
          '15'=>"< ".$this->displayPrice($this->getCurrencyCode(),15),
          '20'=>"< ".$this->displayPrice($this->getCurrencyCode(),20),
        );      
        return $minimum_list;
    }


public function getCurrencyCode()
    {
        
        $curr_code=$this->getOptionAdmin("admin_currency_set");
        if (empty($curr_code)){
            return "USD";
        }           
        return $curr_code;

       /*$curr_code = $this->getOptionAdmin("admin_currency_set");
if (empty($curr_code)) {
    $curr_code = "USD";
}

$stmt = "SELECT * FROM mt_currency WHERE currency_code = '$curr_code' LIMIT 0,1";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
$cmd = $this->db->prepare($stmt);
$cmd->execute();

if ($res = $cmd->fetch(PDO::FETCH_ASSOC)) {
    return $res['currency_symbol'];
}
return "$";*/


    }


    public static function getCurrencyCode_static()
    {
        
        /*$curr_code=$this->getOptionAdmin("admin_currency_set");
        if (empty($curr_code)){
            return "USD";
        }           
        return $curr_code;*/

       $curr_code = $this->getOptionAdmin("admin_currency_set");
if (empty($curr_code)) {
    $curr_code = "USD";
}

$stmt = "SELECT * FROM mt_currency WHERE currency_code = '$curr_code' LIMIT 0,1";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
$cmd = $this->db->prepare($stmt);
$cmd->execute();

if ($res = $cmd->fetch(PDO::FETCH_ASSOC)) {
    return $res['currency_symbol'];
}
return "$";


    }
	
	
	    public function getCurrencyCode_dunamics()
    {
     $curr_code = $this->getOptionAdmin("admin_currency_set");
if (empty($curr_code)) {
    $curr_code = "USD";
}

$stmt = "SELECT * FROM mt_currency WHERE currency_code = '$curr_code' LIMIT 0,1";
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
$cmd = $this->db->prepare($stmt);
$cmd->execute();

if ($res = $cmd->fetch(PDO::FETCH_ASSOC)) {
    return $res['currency_symbol'];
}
return "$";


    }
	



   public function getMerchantFailedWithdrawal($merchant_id = '')
{
    $and = "AND status NOT IN ('paid','pending','approved')";
    $merchant_id = (int)$merchant_id;

    $stmt = "
        SELECT * FROM mt_withdrawal
        WHERE merchant_id = $merchant_id
        $and
        ORDER BY withdrawal_id DESC
    ";

    $result = $this->db->query($stmt);
    if ($res = $result->fetchAll(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}
    



    public  function prettyPriceNoCurrency($amount='')
    {
        if(!empty($amount)){
            return $this->displayPrice("",$this->prettyFormat($amount));
        }
        return '';
    }   


function getSymbol($currency_code = '')
{
    // Assuming you have a method to get the database connection in your new MVC
    
    
    $stmt = $this->db->prepare("
        SELECT currency_symbol 
        FROM mt_currency
        WHERE currency_code = :currency_code
        LIMIT 1
    ");
    $stmt->bindParam(':currency_code', $currency_code);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    return $res ? $res['currency_symbol'] : '$';
}

public static function formatNumber_bkedup($value = 0)
    {
        $formatted_number = number_format(
            (float)$value,
            self::$number_format['decimals'] ?? 0,
            self::$number_format['decimal_separator'],
            self::$number_format['thousand_separator']
        );






        
        if (self::$number_format['position'] == "left") {

           
              
            
            return self::$number_format['currency_symbol'] . self::$number_format['spacer'] . $formatted_number;
        } else {
            return $formatted_number . self::$number_format['spacer'] . self::$number_format['currency_symbol'];
        }
    }



    public  function formatNumber($value = 0)
    {
       
      $formatted_number = number_format(
            (float)$value,
            self::$number_format['decimals'] ?? 0,
            self::$number_format['decimal_separator'],
            self::$number_format['thousand_separator']
        );




        
        if (self::$number_format['position'] == "left") {

           
              
            
            return $this->curr_code . self::$number_format['spacer'] . $formatted_number;
        } else {
            return $formatted_number . self::$number_format['spacer'] . self::$number_format['currency_symbol'];
        }
    }



    public static function formatNumber_pos($value = 0)
    {
        $formatted_number = number_format(
            (float)$value,
            self::$number_format['decimals'] ?? 0,
            self::$number_format['decimal_separator'],
            self::$number_format['thousand_separator']
        );


        
        if (self::$number_format['position'] == "left") {

            

            return self::$number_format['spacer'] . $formatted_number;
        } else {
            return $formatted_number . self::$number_format['spacer'] . self::$number_format['currency_symbol'];
        }
    }



    public static function formatNumberNoSymbol($value = 0)
    {
        return number_format(
            (float)$value,
            self::$number_format['decimals'] ?? 0,
            self::$number_format['decimal_separator'],
            self::$number_format['thousand_separator']
        );
    }






    public function getOptionAdmin($option_name) {
        $stmt = $this->db->prepare("SELECT option_value FROM mt_option WHERE option_name = :option_name AND merchant_id = 0 LIMIT 1");
        $stmt->bindParam(':option_name', $option_name);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($result) {
            return stripslashes($result['option_value']);
        }
        return '';
    }

    public function getSize($id = '') {
    // Use the PDO instance from $this->db
    $pdo = $this->db;

    // Prepare the SQL statement with a placeholder for the ID
    $stmt = $pdo->prepare("SELECT * FROM mt_size WHERE size_id = :id LIMIT 1");

    // Bind the ID parameter to the placeholder
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the result or false if no result
    return $result ? $result : false;
}


public function getSizeList($merchant_id)
{
    $data_feed = [];
    $stmt = "
        SELECT * FROM
        mt_size
        WHERE
        merchant_id = :merchant_id
        ORDER BY sequence ASC
    ";

    // Prepare the PDO query
    $query = $this->db->prepare($stmt);

    // Bind the merchant_id parameter to prevent SQL injection
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    $data11='list';

    // Check if results exist
    if ($res && is_array($res)) {
        // If 'list' format is required, return the size ID and name mapping
        if ($data11 == "list") {
            foreach ($res as $val) {
                $data_feed[$val['size_id']] = $val['size_name'];
            }
            return $data_feed;
        } else {
            // Otherwise, return the raw results
            return $res;
        }
    }

    // Return false if no results
    return false;
}

public function getFoodItem2($item_id = '')
{
    $merchant_id = $this->getMerchantID();
    $stmt = $this->db->prepare("SELECT * FROM mt_item WHERE item_id = :item_id AND merchant_id = :merchant_id LIMIT 1");
    $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->execute();
    
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }
    return false;
}


public function getAddOnList($merchant_id = '')
{
    $datafeed = [];
    $stmt = $this->db->prepare("SELECT * FROM mt_subcategory WHERE merchant_id = :merchant_id ORDER BY sequence ASC");
    $stmt->execute([':merchant_id' => $merchant_id]);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        foreach ($res as $val) {
            $datafeed[] = [
                'addon_id' => $val['subcat_id'],
                'addon_item_name' => $val['subcategory_name'],
                'item' => $this->getAddonItemList($val['subcat_id'])
            ];
        }
        return $datafeed;
    }
    return false;
}


 public function getAddonItemList($category = '')
{
    $data_feed = [];
    $stmt = $this->db->prepare("SELECT * FROM mt_subcategory_item WHERE category LIKE :category ORDER BY sequence ASC");
    $stmt->execute([':category' => "%$category%"]);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        foreach ($res as $val) {
            $data_feed[$val['sub_item_id']] = $val['sub_item_name'];
        }
        return $data_feed;
    }
    return false;
}

public function getSelectedItemArray($key='',$array='')
{   
  if (is_array($array) && count($array)>=1){
    foreach ($array as $keys=>$val) {
      if ( $key == $keys){
        return $val;
      }
    }
  }
  return false;
}

public function multiOptions()
  {
    return array(
      'one'=>$this->translation("default","Can Select Only One"),
      'multiple'=>$this->translation("default","Can Select Multiple"),
      'custom'=>$this->translation("default","Custom")
    );
  }






public function deleteSize($merchant_id = 0, $size_id = 0)
{
    try {
        // Check if the size has a reference in the order details
        $stmt = $this->db->prepare("
            SELECT cat_id FROM mt_order_details
            WHERE size_id = :size_id
        ");
        $stmt->bindParam(':size_id', $size_id, PDO::PARAM_INT);
        $stmt->execute();
        if ($stmt->fetch()) {
            throw new Exception("Cannot delete this item, it has a reference to the order table.");
        }

        // Delete the size record
        $stmt = $this->db->prepare("
            DELETE FROM mt_size 
            WHERE merchant_id = :merchant_id AND size_id = :size_id
        ");
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':size_id', $size_id, PDO::PARAM_INT);
        $resp = $stmt->execute();

        if ($resp) {
            // Delete related records in size_translation and item_relationship_size tables
            $this->deleteRelationship($size_id, 'size_id', 'mt_size_translation');
             $this->deleteRelationship($size_id, 'size_id', 'mt_item_relationship_size');
            return true;
        }

        throw new Exception("Failed, cannot delete records.");
    } catch (Exception $e) {
        throw new Exception($e->getMessage());
    }
}

public function deleteBookingslots($id=0){

     $stmt = $this->db->prepare("
            DELETE FROM mt_booking_slots 
            WHERE id = :id 
        ");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        
        $resp = $stmt->execute();

        if ($resp) {

            $stmt = $this->db->prepare("
            DELETE FROM mt_booking_slots_child 
            WHERE parent_id = :id 
        ");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        
        $resp1 = $stmt->execute();

        $this->updateOptionAdmin('feed_upload', 1);


        }


}




public function deleteCategory($merchant_id = 0, $cat_id = 0)
{
    try {
        // Check if the category has a reference in the order details
        $stmt = $this->db->prepare("
            SELECT cat_id FROM mt_order_details
            WHERE cat_id = :cat_id
        ");
        $stmt->bindParam(':cat_id', $cat_id, PDO::PARAM_INT);
        $stmt->execute();
        if ($stmt->fetch()) {
            throw new Exception("Cannot delete this item, it has a reference to the order table.");
        }

        // Fetch the photo related to the category
        $photo = '';
        $stmt = $this->db->prepare("
            SELECT photo FROM mt_category
            WHERE cat_id = :cat_id
        ");
        $stmt->bindParam(':cat_id', $cat_id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $photo = $data['photo'];
        }

        // Delete the category
        $stmt = $this->db->prepare("
            DELETE FROM mt_category 
            WHERE merchant_id = :merchant_id AND cat_id = :cat_id
        ");
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':cat_id', $cat_id, PDO::PARAM_INT);
        $resp = $stmt->execute();

        if ($resp) {
            // Delete related records in translation and relationship tables
            $this->deleteRelationship($cat_id, 'cat_id', 'mt_category_translation');
            $this->deleteRelationship($cat_id, 'cat_id', 'mt_item_relationship_category');

            // Delete the photo if it exists
            if (!empty($photo)) {
                
            }

            return true;
        }

        throw new Exception("Failed, cannot delete records.");
    } catch (Exception $e) {
        throw new Exception($e->getMessage());
    }
}


  public function getSubcategory()
{
    $data_feed = array();
    $data='list';
    // Prepare the SQL query
    $stmt = "
    SELECT * FROM mt_subcategory
    WHERE merchant_id = :merchant_id
    ORDER BY sequence ASC
    ";

    try {
        // Get the PDO connection
        $connection = $this->db;

        // Prepare the statement
        $query = $connection->prepare($stmt);

        // Bind the merchant ID
        $merchant_id = $this->getMerchantID();
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the query
        $query->execute();

        // Fetch the rows
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            if ($data == "list") {
                foreach ($rows as $val) {
                    $data_feed[$val['subcat_id']] = $val['subcategory_name'];
                }
                return $data_feed;
            } else {
                return $rows;
            }
        }

        return false;
    } catch (Exception $e) {
        throw new Exception("Error retrieving subcategory: " . $e->getMessage());
    }
}


 public function getAddonItem2($sub_item_id = '', $sortby = 'sub_item_id')
{
    $mid = $this->getMerchantID();

    // Prepare the SQL statement
    $stmt = "SELECT * FROM mt_subcategory_item
              WHERE sub_item_id = :sub_item_id
              AND merchant_id = :merchant_id
              ORDER BY $sortby DESC";

    try {
        // Prepare the statement using $this->db
        $query = $this->db->prepare($stmt);

        // Bind parameters
        $query->bindParam(':sub_item_id', $sub_item_id, PDO::PARAM_INT);
        $query->bindParam(':merchant_id', $mid, PDO::PARAM_INT);

        // Execute the query
        $query->execute();

        // Fetch the result
        $result = $query->fetch(PDO::FETCH_ASSOC);

        return $result ?: false;
    } catch (Exception $e) {
        // Handle exception (optional)
        throw new Exception("Error retrieving addon item: " . $e->getMessage());
    }
}


public function deleteAddonItem($merchant_id = 0, $id = 0)
{
    try {
        // Fetch the photo field using a prepared statement
        $photo = '';
        $stmt = $this->db->prepare("SELECT photo FROM mt_subcategory_item WHERE sub_item_id = :sub_item_id");
        $stmt->bindParam(':sub_item_id', $id, PDO::PARAM_INT);
        $stmt->execute();
        
        // Get the row if it exists
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $photo = $data['photo'];
        }
        
        // Prepare the DELETE statement
        $deleteStmt = $this->db->prepare("DELETE FROM mt_subcategory_item WHERE merchant_id = :merchant_id AND sub_item_id = :sub_item_id");
        $deleteStmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $deleteStmt->bindParam(':sub_item_id', $id, PDO::PARAM_INT);
        
        // Execute the DELETE statement
        $resp = $deleteStmt->execute();
        
        if ($resp) {
            // Call deleteRelationship for both relationships
            $this->deleteRelationship($id, 'sub_item_id', 'mt_subcategory_item_translation');
            $this->deleteRelationship($id, 'sub_item_id', 'mt_subcategory_item_relationships');
            
            return true;
        }

        // If the deletion failed, throw an exception
        throw new Exception("Failed to delete records");

    } catch (PDOException $e) {
        // Handle any PDO exceptions
        echo "Error: " . $e->getMessage();
        return false;
    }
}


public  function defaultExchangeRate($currency_code='')
  {
    $admin_currency_set = $this->getOptionAdmin('admin_currency_set');
    return array(
      'used_currency'=>$admin_currency_set,
      'base_currency'=>$admin_currency_set,
      'exchange_rate'=>1      
    );
  }

  public  function getServiceFee($merchant_id=0)
  {   
    $merchant_id = (integer)$merchant_id;
    $fee = 0; $apply_tax = false;
    if($this->isMerchantCommission($merchant_id)){
      $fee = $this->getOptionAdmin('admin_service_fee');
      $apply_tax = $this->getOptionAdmin('admin_service_fee_applytax');
    } else {
      $fee = $this->getOption('merchant_service_fee',$merchant_id);
      $apply_tax = $this->getOption('merchant_service_fee_applytax',$merchant_id);
    }
    
    if($fee>0){
      return array(
        'service_fee'=>$fee,
        'service_fee_applytax'=>$apply_tax==1?false:true
      );
    } else return false;
  }




public function getIngredients($id = '')
{
    try {
        // Prepare the SQL query with a placeholder for the ingredients ID
        $stmt = $this->db->prepare("SELECT * FROM mt_ingredients WHERE ingredients_id = :id LIMIT 1");

        // Bind the ID parameter to prevent SQL injection
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // Check if a result was found
        if ($res) {
            return $res;
        }
        
        return false;
        
    } catch (PDOException $e) {
        // Handle any exceptions
        echo "Error: " . $e->getMessage();
        return false;
    }
}

public function deleteIngredients($merchant_id = 0, $id = 0)
{
    try {
        // Prepare the SQL statement for deletion
        $stmt = $this->db->prepare("DELETE FROM mt_ingredients WHERE merchant_id = :merchant_id AND ingredients_id = :ingredients_id");

        // Bind the parameters
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':ingredients_id', $id, PDO::PARAM_INT);

        // Execute the statement
        $resp = $stmt->execute();

        if ($resp) {
            // Perform related deletions if the main deletion was successful
            $this->deleteRelationship($id, 'ingredients_id', 'mt_ingredients_translation');
            $this->deleteMetaID($merchant_id, 'ingredients', $id);
            return true;
        }
        
        throw new Exception("Failed: cannot delete records");

    } catch (PDOException $e) {
        // Handle any exceptions
        throw new Exception("Error: " . $e->getMessage());
    }
}


  public function deleteMetaID($merchant_id = '', $meta_name = '', $meta_id = '')
{
    try {
        // Prepare the SQL statement for deletion
        $stmt = $this->db->prepare("DELETE FROM mt_item_meta WHERE merchant_id = :merchant_id AND meta_name = :meta_name AND meta_id = :meta_id");

        // Bind the parameters
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':meta_id', $meta_id, PDO::PARAM_INT);
        $stmt->bindParam(':meta_name', $meta_name, PDO::PARAM_STR);

        // Execute the statement
        $stmt->execute();

    } catch (PDOException $e) {
        // Handle any exceptions
        throw new Exception("Error: " . $e->getMessage());
    }
}


public function getIngredientsList($merchant_id = '')
{
    $data_feed = array();
    try {
        // Prepare the SQL statement
        $stmt = $this->db->prepare("SELECT * FROM mt_ingredients WHERE merchant_id = :merchant_id AND status IN ('publish') ORDER BY sequence ASC");

        // Bind the merchant_id parameter
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the statement
        $stmt->execute();

        // Fetch the results
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            if ($this->data == "list") {
                foreach ($res as $val) {
                    $data_feed[$val['ingredients_id']] = $val['ingredients_name'];
                }
                return $data_feed;
            } else {
                return $res;
            }
        }
        
        return false;

    } catch (PDOException $e) {
        // Handle any exceptions
        throw new Exception("Error: " . $e->getMessage());
    }
}


public function getCookingRef($id = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_cooking_ref
        WHERE cook_id = :cook_id
        LIMIT 1
    ");

    // Bind the cook_id parameter
    $stmt->bindParam(':cook_id', $id, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    return $res ? $res : false;
}


public function deleteCookingRef($merchant_id = 0, $id = 0)
{
    // Prepare the delete statement
    $stmt = $this->db->prepare("
        DELETE FROM mt_cooking_ref 
        WHERE merchant_id = :merchant_id AND cook_id = :cook_id
    ");

    // Bind parameters
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindParam(':cook_id', $id, PDO::PARAM_INT);

    // Execute the statement
    $resp = $stmt->execute();

    if ($resp) {
        // Perform additional deletions if the main deletion was successful
        $this->deleteRelationship($id, 'cook_id', 'cooking_ref_translation');
        $this->deleteMetaID($merchant_id, 'cooking_ref', $id);
        return true;
    }

    throw new Exception("Failed to delete records");
}


 public function getCookingRefList($merchant_id = '')
{
    $data_feed = [];
    
    // Prepare the SQL statement
    $stmt = $this->db->prepare("
        SELECT * FROM mt_cooking_ref
        WHERE merchant_id = :merchant_id
        ORDER BY sequence ASC
    ");
    
    // Bind the parameter
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the statement
    $stmt->execute();
    
    // Fetch the results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        if ($this->data == "list") {
            foreach ($res as $val) {
                $data_feed[$val['cook_id']] = $val['cooking_name'];
            }
            return $data_feed;
        } else {
            return $res;
        }
    }
    
    return false;
}





public function getAddonItemListByMerchant($merchant_id = '')
{
    try {
        // Prepare the SQL query
        $stmt = $this->db->prepare("SELECT * FROM mt_subcategory_item WHERE merchant_id = :merchant_id ORDER BY sequence ASC");

        // Bind the merchant_id parameter to prevent SQL injection
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch all results
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Check if results exist
        if ($res) {
            return $res;
        }
        
        return false;
        
    } catch (PDOException $e) {
        // Handle any errors
        echo "Error: " . $e->getMessage();
        return false;
    }
}



public  function AjaxData($aColumns='')
    {
      /* 
     * Paging
     */
    $sLimit = "";
    if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
    {
      $sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".
        ( $_GET['iDisplayLength'] );
    }
    
    /*
     * Ordering
     */
    if ( isset( $_GET['iSortCol_0'] ) )
    {
      $sOrder = "ORDER BY  ";
      for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
      {
        if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
        {
          $sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
            ".( $_GET['sSortDir_'.$i] ) .", ";
        }
      }
      
      $sOrder = substr_replace( $sOrder, "", -2 );
      if ( $sOrder == "ORDER BY" )
      {
        $sOrder = "";
      }
    }
    
    /* 
     * Filtering
     * NOTE this does not match the built-in DataTables filtering which does it
     * word by word on any field. It's possible to do here, but concerned about efficiency
     * on very large tables, and MySQL's regex functionality is very limited
     */
    $sWhere = "";
    if ( $_GET['sSearch'] != "" )
    {
      $sWhere = "AND (";
      for ( $i=0 ; $i<count($aColumns) ; $i++ )
      {
        $sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
      }
      $sWhere = substr_replace( $sWhere, "", -3 );
      $sWhere .= ')';
    }
    
    /* Individual column filtering */
    for ( $i=0 ; $i<count($aColumns) ; $i++ )
    {
      if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
      {
        if ( $sWhere == "" )
        {
          $sWhere = "AND ";
        }
        else
        {
          $sWhere .= " AND ";
        }
        $sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
      }
    }

    return array(
      'sWhere'=>$sWhere,
      'sOrder'=>$sOrder,
      'sLimit'=>$sLimit
    );
    } 





        public function ajaxDataTables($aColumns='')
    {
        /* 
         * Paging
         */
        $sLimit = "";
        if ( isset( $_GET['iDisplayStart'] ) && $_GET['iDisplayLength'] != '-1' )
        {
            $sLimit = "LIMIT ".( $_GET['iDisplayStart'] ).", ".
                ( $_GET['iDisplayLength'] );
        }
        
        /*
         * Ordering
         */
        if ( isset( $_GET['iSortCol_0'] ) )
        {
            $sOrder = "ORDER BY  ";
            for ( $i=0 ; $i<intval( $_GET['iSortingCols'] ) ; $i++ )
            {
                if ( $_GET[ 'bSortable_'.intval($_GET['iSortCol_'.$i]) ] == "true" )
                {
                    $sOrder .= $aColumns[ intval( $_GET['iSortCol_'.$i] ) ]."
                        ".( $_GET['sSortDir_'.$i] ) .", ";
                }
            }
            
            $sOrder = substr_replace( $sOrder, "", -2 );
            if ( $sOrder == "ORDER BY" )
            {
                $sOrder = "";
            }
        }
        
        /* 
         * Filtering
         * NOTE this does not match the built-in DataTables filtering which does it
         * word by word on any field. It's possible to do here, but concerned about efficiency
         * on very large tables, and MySQL's regex functionality is very limited
         */
        $sWhere = "";
        if ( $_GET['sSearch'] != "" )
        {
            $sWhere = "WHERE (";
            for ( $i=0 ; $i<count($aColumns) ; $i++ )
            {
                //$sWhere .= $aColumns[$i]." LIKE '%".( $_GET['sSearch'] )."%' OR ";
               $sWhere .= $aColumns[$i] . " LIKE '%" . $_GET['sSearch'] . "%' OR ";

            }
            $sWhere = substr_replace( $sWhere, "", -3 );
            $sWhere .= ')';
        }
        
        /* Individual column filtering */
        for ( $i=0 ; $i<count($aColumns) ; $i++ )
        {
            if(!isset($_GET['bSearchable_'.$i])){
                $_GET['bSearchable_'.$i]='';
            }
            if ( $_GET['bSearchable_'.$i] == "true" && $_GET['sSearch_'.$i] != '' )
            {
                if ( $sWhere == "" )
                {
                    $sWhere = "WHERE ";
                }
                else
                {
                    $sWhere .= " AND ";
                }
                //$sWhere .= $aColumns[$i]." LIKE '%".($_GET['sSearch_'.$i])."%' ";
                $sWhere .= $aColumns[$i] . " LIKE '%" . $_GET['sSearch'] . "%' ";

            }
        }

        return array(
          'sWhere'=>$sWhere,
          'sOrder'=>$sOrder,
          'sLimit'=>$sLimit
        );
    }


    public  function isMerchantcanCheckout($merchant_id='')
    {
        $msg=''; $code=2; $button=''; $holiday=2;
        $is_pre_order=2;
        
        $now=date('Y-m-d');
        if ( $m_holiday=$this->getMerchantHoliday($merchant_id)){                     
           if (in_array($now,(array)$m_holiday)){
              $holiday=1;
              $msg=$this->getOption('merchant_close_msg_holiday',$merchant_id);   
              if (empty($msg)){
                  $msg="Sorry merchant is closed";
              }
           }
        }
                
        $is_merchant_open = $this->isMerchantOpen($merchant_id); 
        $merchant_preorder= $this->getOption("merchant_preorder",$merchant_id);
        
        if ($is_merchant_open){
            $code=1; $button="Checkout";
            if ($holiday==1){
                $code=2;
                if($merchant_preorder==1){
                    $is_pre_order=1;
                }           
            }
        } else {
            if ($merchant_preorder==1){
                $code=1; $button="Pre-Order";
                $is_pre_order=1;
            } else {
                if ($holiday==2){
                    $merchant_close_msg=$this->getOption('merchant_close_msg',$merchant_id);
                    if (empty($merchant_close_msg)){
                        $msg="Sorry merchant is closed.";
                    } else $msg=$merchant_close_msg;
                }
            }
        }
        
        /*check if merchant is close via backend*/
        if ( $this->getOption('merchant_close_store',$merchant_id)=="yes"){
            $code=2; 
            $msg=$this->getOption('merchant_close_msg',$merchant_id);
            if (empty($msg)){
                $msg="This restaurant is closed now. Please check the opening times.";
            }
        }
        
        if (!$this->validateSellLimit($merchant_id) ){
            $msg="This merchant has reach the maximum sells per month";
            $code=2;
        }
                
        return array(
         'code'=>$code,
         'msg'=>$msg,
         'button'=>$button,
         'holiday'=>$holiday,
         'is_pre_order'=>$is_pre_order
        );
    }


    public function getTotalEarnPoints($client_id='', $merchant_id='', $redeem_condition='')
{
    $pts_redeem_condition = $this->getOptionAdmin('pts_redeem_condition');

    if (!empty($redeem_condition)) {
        $pts_redeem_condition = $redeem_condition;
    }

    $and = '';

    if (!empty($merchant_id)) {
        switch ($pts_redeem_condition) {
            case 1:
                $and = " AND (merchant_id = :merchant_id OR trans_type = 'adjustment')";
                break;

            case 3:
                $and = " AND (merchant_id = :merchant_id OR trans_type IN ('first_order', 'review', 'signup', 'adjustment', 'booking'))";
                break;

            default:
                break;
        }
    }

    // Prepare the SQL statement
    $stmt = "
        SELECT SUM(total_points_earn) as total_earn,
        (
            SELECT SUM(total_points)
            FROM mt_points_expenses
            WHERE status = 'active'
            AND client_id = :client_id
            $and
        ) as total_points_expenses
        FROM mt_points_earn
        WHERE status = 'active'
        AND client_id = :client_id
        $and
    ";

    // Prepare the PDO statement
    $pdoStatement = $this->db->prepare($stmt);

    // Bind parameters
    $pdoStatement->bindParam(':client_id', $client_id, PDO::PARAM_STR);
    if (!empty($merchant_id)) {
        $pdoStatement->bindParam(':merchant_id', $merchant_id, PDO::PARAM_STR);
    }

    // Execute the statement
    $pdoStatement->execute();

    // Fetch the result
    if ($res = $pdoStatement->fetch(PDO::FETCH_ASSOC)) {
        return $res['total_earn'] - $res['total_points_expenses'];
    }
    return 0;
}


  public function PointsDefinition($points_type='earn',$trans_type='',
  $order_id='',$total_points_earn='')
  {
    $label='';
    if ( $points_type=="earn"){
      switch ($trans_type) {
        case "signup":
          $label=$this->translation("default","Points gained by signing up");
          break;
          
        case "first_order": 
            $label=$this->translation("default","Points gained on first order");
            break;
            
        case "review":  
            $label=$this->translation("default","Points gained by reviewing");
            break;    
            
        case "adjustment":  
            $label=$this->translation("default","Points adjusted by admin");
            break;        
            
        case "booking": 
            $label=$this->translation("default","Points gained by Booking Table");
            break;            
                    
        default:
          $label=$this->translation("default","Points gained by buy item Order ID").": ".$order_id;
          break;
      }
    } else {
      switch ($trans_type) {
        case "adjustment":          
              $label=$this->translation("default","Points adjusted by admin");
          break;
      
        default:          
              $label=$this->translation("default","Points Exchanged Into Discount On Order").": ".$order_id;
          break;
      }
    }
    return $label;
  }


  public function checkTableStructure($table_name = '')
{
    // Ensure table name is not empty to prevent SQL errors
    if (empty($table_name)) {
        return false;
    }
    $table_name="mt_".$table_name;
   
    // Prepare the SQL statement using PDO
    $stmt = $this->db->prepare("SHOW COLUMNS FROM `$table_name`");

    // Execute the statement
    if ($stmt->execute()) {
        return $stmt->fetchAll(PDO::FETCH_ASSOC); // Fetch and return the results
    }

    return false; // Return false if execution fails
}


public  function checkTableFields($table='',$new_field='')
    {
        
        $prefix='mt_';        
        $existing_field=array();
        if ( $res = $this->checkTableStructure($table)){
            foreach ($res as $val) {                                
                $existing_field[$val['Field']]=$val['Field'];
            }                           
            foreach ($new_field as $key_new=>$val_new) {                                
                if (in_array($key_new,(array)$existing_field)){ 
                    return true;
                } 
            }
        }           
        return false;
    }





    public function getIngredientsByName($name = '', $mtid = '')
{
    // Prepare the SQL query with named parameters
    $stmt = "
        SELECT * 
        FROM mt_ingredients
        WHERE ingredients_name = :ingredients_name
        AND merchant_id = :merchant_id
        LIMIT 1
    ";

    // Prepare the statement using the class's PDO connection
    $query = $this->db->prepare($stmt);

    // Bind the parameters to the query
    $query->bindParam(':ingredients_name', $name, PDO::PARAM_STR);
    $query->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }

    return false;
}

public function getAddonCategory($subcat_id = '')
{
    // Prepare the SQL query with a named parameter
    $stmt = "
        SELECT * 
        FROM mt_subcategory
        WHERE subcat_id = :subcat_id
        ORDER BY subcat_id DESC
        LIMIT 1
    ";

    // Prepare the statement using the class's PDO connection
    $query = $this->db->prepare($stmt);

    // Bind the parameter to the query
    $query->bindParam(':subcat_id', $subcat_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }

    return false;
}


public function prettyFormat($price='',$merchant_id='')
    {
        /*$decimal=yii::app()->functions->getOption('merchant_decimal',$merchant_id);
        $decimal_separators=yii::app()->functions->getOption('merchant_use_separators',$merchant_id);*/     
        
        $decimal=$this->getOptionAdmin('admin_decimal_place');
        $decimal_separators=$this->getOptionAdmin('admin_use_separators');      
        
        $thousand_separator=$this->getOptionAdmin('admin_thousand_separator');
        $decimal_separator=$this->getOptionAdmin('admin_decimal_separator');
        
        if (empty($thousand_separator)){
            $thousand_separator=',';
        }
        if (empty($decimal_separator)){
            $decimal_separator='.';
        }
        
        $thou_separator='';
        if (!empty($price)){
            if ($decimal==""){
                $decimal=2;
            }
            if ( $decimal_separators=="yes"){
                //$thou_separator=",";
                $thou_separator=$thousand_separator;
            }       
            //return number_format((float)$price,$decimal,".",$thou_separator);
            return self::formatNumber((float)$price,$decimal,$decimal_separator,$thou_separator);
        }   
        if ($decimal==""){
            $decimal=2;
        }   
        //return number_format(0,$decimal,".",$thou_separator); 
        $thou_separator=$thousand_separator;
        return self::formatNumber(0,$decimal,$decimal_separator,$thou_separator);    
    }



       public function extraDeliveryFee($mtid='', $current_fee='', $delivery_time='' , $delivery_date='')
   {
           
       $debug = false;
       $fee =  $current_fee;
       
       if(empty($delivery_date)){
          $delivery_date=date("Y-m-d");
       }  
       
       if(empty($delivery_time)){
          $delivery_time = date("Gi");
       } else $delivery_time = date("Gi",strtotime($delivery_time));
       
       if ($debug){
          dump("mtid=> $mtid");
          dump("current_fee=> $current_fee");
          dump("delivery_time=> $delivery_time");
          dump("delivery_date=> $delivery_date");
       }
       
       $extra_charge_start_time=$this->getOption('extra_charge_start_time',$mtid);
       $extra_charge_end_time='';
       if(!empty($extra_charge_start_time)){
          $extra_charge_start_time = json_decode($extra_charge_start_time,true);          
          $extra_charge_end_time = json_decode( $this->getOption('extra_charge_end_time',$mtid) ,true );
          $extra_charge_fee = json_decode( $this->getOption('extra_charge_fee',$mtid) ,true );
       }   
       
       if(is_array($extra_charge_start_time) && count($extra_charge_start_time)>=1){         
          foreach ($extra_charge_start_time as $key=>$start) {
              $start = date("Gi",strtotime($start));
              if(isset($extra_charge_end_time[$key])){
                  $end  = date("Gi",strtotime($extra_charge_end_time[$key]));
              } else $end='';
              
              if(isset($extra_charge_fee[$key])){
                 $charge = $extra_charge_fee[$key];
              } else $charge='';
              
              if (!empty($charge) && !empty($start) && !empty($end) ){  
                 if ( $start<=$delivery_time && $end>=$delivery_time){                 
                     $fee+=$charge;
                     if ($debug){
                        dump("TIME=> $start - $end = $charge");
                     }
                     break;
                 }
              }
          }
       }   
       
       if ($debug){
          dump("final fee: $fee");
       }
                       
       return $fee;
   }





    public function enabledExtraCharges()
   {
      return false;
   }


   public function timeFormat($time='',$is_display=false)
  {
    if(empty($time)){
      return false;
    }
    
    $time_format=$this->getOptionAdmin("website_time_picker_format");
    //dump($time_format); 
    switch ($time_format){
      case "12":
        if ( $is_display==true){
          return date("g:i A", strtotime($time));
        } else return date("G:i", strtotime($time));
        break;
      default:
        if ( $is_display==true){
          return date("G:i", strtotime($time));
        } else return date("G:i", strtotime($time));
        break;  
    }
    return $time;
  }


   public function getDays()
  {
    return array(
      'monday'=>$this->translation("default",'monday'),
      'tuesday'=>$this->translation("default",'tuesday'),
      'wednesday'=>$this->translation("default",'wednesday'),
      'thursday'=>$this->translation("default",'thursday'),
      'friday'=>$this->translation("default",'friday'),
      'saturday'=>$this->translation("default",'saturday'),
      'sunday'=>$this->translation("default",'sunday')
    );
  }



  public function isMerchantCommission($merchant_id = '') {
        // Prepare the SQL statement
        $stmt = "
        SELECT * FROM mt_merchant
        WHERE merchant_id = :merchant_id
        LIMIT 1
        ";

        // Prepare the statement
        $query = $this->db->prepare($stmt);

        // Bind parameters
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the query
        $query->execute();

        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);

        // Check if results were returned and evaluate the condition
        if ($res) {
            if ($res['merchant_type'] == 2 || $res['merchant_type'] == 3) {
                return true;
            }
        }

        return false;
    }


   

    public function getAddonTranslation($name = '', $mt_id = '')
{
    // Prepare the SQL query with named parameters
    $stmt = "
        SELECT * 
        FROM mt_subcategory_item
        WHERE sub_item_name = :sub_item_name
        AND merchant_id = :merchant_id
        LIMIT 1
    ";

    // Prepare the statement using the class's PDO connection
    $query = $this->db->prepare($stmt);

    // Bind the parameters to the query
    $query->bindParam(':sub_item_name', $name, PDO::PARAM_STR);
    $query->bindParam(':merchant_id', $mt_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            // Process and return the translation data
            $t['sub_item_name_trans'] = !empty($res['sub_item_name_trans']) ? json_decode($res['sub_item_name_trans'], true) : '';
            return $t;
        }
    }

    return false;
}


public function getLocationDeliveryFee($merchant_id = '', $default_fee = '', $data = '')
{
    $fee = 0;
    $and = '';

    if (is_array($data) && count($data) >= 1) {
        switch ($data['location_type']) {
            case 2:
                $state_id = isset($data['state_id']) ? (integer)$data['state_id'] : 0;
                $city_id = isset($data['city_id']) ? (integer)$data['city_id'] : 0;

                $and .= " AND state_id = :state_id";
                
                if ($city_id > 0) {
                    $and .= " AND city_id = :city_id";
                }

                $area_id = isset($data['area_id']) ? (integer)$data['area_id'] : 0;
                if ($area_id > 0) {
                    $and .= " AND area_id = :area_id";
                }
                break;

            case 3:
                $postal_code = isset($data['postal_code']) ? (integer)$data['postal_code'] : 0;
                $city_id = isset($data['city_id']) ? (integer)$data['city_id'] : 0;
                $area_id = isset($data['area_id']) ? (integer)$data['area_id'] : 0;

                if ($postal_code > 0) {
                    $and .= " AND postal_code = :postal_code";
                }
                if ($city_id > 0) {
                    $and .= " AND city_id = :city_id";
                }
                if ($area_id > 0) {
                    $and .= " AND area_id = :area_id";
                }
                break;

            default:
                $city_id = isset($data['city_id']) ? (integer)$data['city_id'] : 0;
                $area_id = isset($data['area_id']) ? (integer)$data['area_id'] : 0;
                $and .= " AND city_id = :city_id";
                if ($area_id > 0) {
                    $and .= " AND area_id = :area_id";
                }
                break;
        }

        $stmt = "
            SELECT fee
            FROM mt_view_location_rate
            WHERE merchant_id = :merchant_id
            $and
            ORDER BY rate_id ASC
            LIMIT 0,1
        ";

        try {
            $query = $this->db->prepare($stmt);

            // Bind parameters
            $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            
            if (isset($state_id)) {
                $query->bindParam(':state_id', $state_id, PDO::PARAM_INT);
            }
            if (isset($city_id)) {
                $query->bindParam(':city_id', $city_id, PDO::PARAM_INT);
            }
            if (isset($area_id)) {
                $query->bindParam(':area_id', $area_id, PDO::PARAM_INT);
            }
            if (isset($postal_code)) {
                $query->bindParam(':postal_code', $postal_code, PDO::PARAM_INT);
            }

            $query->execute();

            // Fetch the result
            $res = $query->fetch(PDO::FETCH_ASSOC);

            $fee = $res ? $res['fee'] : $default_fee;
        } catch (PDOException $e) {
            // Log error if needed and fallback to default fee
            error_log("Error fetching delivery fee: " . $e->getMessage());
            $fee = $default_fee;
        }
    } else {
        $fee = $default_fee;
    }

    return $fee;
}





   

 public function displayOrderHTML($data='',$cart_item='',$receipt=false,$new_order_id='')
    {
        $item_array=array();
        $this->code=2;
        $htm='';    
        $subtotal=0;
        $subtotal_non=0;
        $mid=isset($data['merchant_id'])?$data['merchant_id']:''; 

        $this->PointsProgram = new PointsProgram();  
        $this->data="list";
               
        if (empty($mid)){
            $this->msg=$this->translation("default","Merchant ID is empty");
            return ;
        }   
                            
        //Yii::app()->functions->data="list";
        $food_item=$this->getFoodItemLists($mid);
        $subcat_list=$this->getAddOnLists($mid);       
        
        $merchant_packaging_wise = $this->getOption('merchant_packaging_wise',$mid);
        $wise_packaging_fee = 0;
        $merchant_packaging_charge = 0;
        $card_fees = 0;
        
        $exchange_rate = isset($data['exchange_rate']) ? (float)$data['exchange_rate'] : 1;
                                           
        if (isset($cart_item)){
            if (is_array($cart_item) && count($cart_item)>=1){
                $x=0;
                foreach ($cart_item as $key=>$val) {        
                    
                    //dump($val);               
                    
                    $val['notes']=isset($val['notes'])?$val['notes']:"";
                    
                    $size_words=''; $_size_id=0;
                    $t=!empty($val['price'])?explode("|",$val['price']):'';                 
                    if (is_array($t) && count($t)>=1){
                        $val['price']=$t[0];
                        if (isset($t[1])){
                            $size_words=$t[1];
                            $_size_id=isset($t[2])?(integer)$t[2]:0;  // inventory new code
                        } else $size_words='';                  
                    }
                    
                    $price=$this->cleanNumber($this->unPrettyPrice($val['price']));
                    
                    if (!empty($val['discount'])){
                        $val['discount']=$this->unPrettyPrice($val['discount']);
                        $price=$price-$val['discount'];
                    }           
                    
                    $price = (float) $price * $exchange_rate;
                    
                    $qty=$val['qty'];  /** fixed addon qty */                   
                    $total_price=$val['qty']*(float)$price;
                                
                    /** check if item is taxable*/
                    //dump($val);
                    $food_taxable=true;                                     
                    if (isset($val['non_taxable'])){
                        if ( $val['non_taxable']==2){
                            $food_taxable=false;
                        }   
                    }           
                                                                            
                    $subtotal=$subtotal+$total_price; 
                    
                    if ($food_taxable==false){
                        //dump($total_price);
                        $subtotal_non=$subtotal_non+$total_price;                       
                    }           
                    
                    /*$size_words='';
                    if ( $price_size=explodeData($val['price'])){                           
                        if (isset($price_size[1])){
                            $size_words=$price_size[1];
                        }
                    }   */                                      
                    
                    /** Translation */
                    $food_infos=array(); $food_info = array();
                    $size_info_trans='';
                    $cooking_ref_trans='';
                    if ($this->getOptionAdmin("enabled_multiple_translation")==2){
                        $food_info=$this->getFoodItem($val['item_id']);
                        $food_infos['item_name_trans']=!empty($food_info['item_name_trans'])?json_decode($food_info['item_name_trans'],true):'';        
                                                
                        if (!empty($size_words)){
                            $size_info_trans=$this->getSizeTranslation($size_words,$mid);
                        }               

                        if(!empty($val['cooking_ref'])){                            
                            $cooking_ref_trans=$this->getCookingTranslation($val['cooking_ref'],$mid);
                        }   
                    } else $food_info=$this->getFoodItem($val['item_id']);
                    
                    
                    /*GET PACKAGING CHARGE*/
                    if($merchant_packaging_wise==1){ 

                       if(isset($food_info['packaging_fee'])){
                           if($food_info['packaging_fee']>0){
                               if ($food_info['packaging_incremental']==1){
                                  $wise_packaging_fee+= $food_info['packaging_fee']*$qty;
                               } else {                             
                                   $wise_packaging_fee+= $food_info['packaging_fee'];
                               }
                           }
                       }
                    }
                    
                    /*dump($food_item);
                    dump($val['item_id']);*/  

                    
                    $htm.='<div class="item-order-list item-row">';
                                          
                      $val['category_id']=isset($val['category_id'])?$val['category_id']:'';
                      
                      if ($res_category=$this->getCategory($val['category_id'])){                         
                          $category_name_trans['category_name_trans']=!empty($res_category['category_name_trans'])?
                          json_decode($res_category['category_name_trans'],true):false; 
                                                                  
                          $htm.="<p style=\"margin:0;\"><b>".$this->qTranslate($res_category['category_name'],
                          'category_name',$category_name_trans)."</b></p>";
                      } 
                      
                      //dump($htm);


                                    

                    if($val['variable_price']>0){
                    $htm.='<div class="a" style="width:60px">'.$val['qty'].' x'.$val['variable_price'].'</div>';                    
                }else{
                    $htm.='<div class="a">'.$val['qty'].'</div>';
                }


                                    
                      
                      $htm.='<div class="b">'.$food_info['item_name'];
                      
                      if (!empty($size_words)){
                         $htm.="(".$size_words.")";
                      }
                      

                      //dump($val);
                        //echo $htm;die();
                      
                      $_category_name = isset($res_category['category_name_trans'])?$res_category['category_name']:'';
                      
                      // array value
                      $item_array[$key]=array(
                        'item_id'=>$val['item_id'],
                        'item_name'=>isset($food_info['item_name'])?$food_info['item_name']:'',
                        'size_words'=>$size_words,
                        'size_id'=>$_size_id, // inventory
                        'qty'=>$val['qty'],
                        
                        'is_printed'=>$val['is_printed'],
                        'is_printed_already'=>$val['is_printed_already'],
                        'variable_price'=>$val['variable_price'],
                        //'normal_price'=>prettyFormat($val['price']),
                        'normal_price'=> (float)$val['price'] *  (float)$exchange_rate  ,
                        'discounted_price'=>$price,
                        'discount'=>$val['discount'],
                        
                        /* Custom code 13 starts */
                        'promo_id'=>$val['promo_id'],
                        /* Custom code 13 Ends */
                        
                        'order_notes'=>isset($val['notes'])?$val['notes']:'',
                        'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
                        'ingredients'=>isset($val['ingredients'])?$val['ingredients']:'',
                        'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1,
                        'category_id'=>isset($val['category_id'])?$val['category_id']:'',
                        'category_name'=>!empty($_category_name)?$_category_name:$res_category['category_name'],
                        'category_name_trans'=>isset($category_name_trans)?$category_name_trans:'',                     
                        'item_name_trans'=>isset($food_infos)?$food_infos:'',
                        'size_name_trans'=>isset($size_info_trans)?$size_info_trans:'',
                        'cooking_name_trans'=>isset($cooking_ref_trans)?$cooking_ref_trans:'',                                                                      
                      );                                         
                      
                      $htm.=$this->displaySpicyIconByID($val['item_id']);
                      
                      if (!empty($val['discount'])){
                          $htm.="<p class=\"uk-text-small\">".
                          "<span class=\"normal-price\">". self::formatNumber( ((float)$val['price']*$exchange_rate) ) ." </span>".
                          "<span class=\"sale-price\">". self::formatNumber($price) ."</span>"
                          ."</p>";      
                                          
                      } else {
                        
                        $htm.="<p class=\"uk-text-small\">".                          
                          "<span class=\"base-price\">". self::formatNumber($price) ."</span>"
                          ."</p>";                        
                      }
                      
                      /*Custom code 13 starts */
                      if($val['promo_id']>0){
                      $htm.="<p class=\"small\" style='margin: 0px;color:red'>Promo ID :".$val['promo_id']."</p>";  
                      }
                      /*Custom code 13 Ends */
                      
                      if (!empty($val['cooking_ref'])){
                          $htm.="<p class=\"small\">".
                          $this->qTranslate($val['cooking_ref'],'cooking_name',$cooking_ref_trans)."</p>";
                      }                 
                      if (!empty($val['notes'])){
                          $htm.="<p class=\"small text-info\">".$val['notes']."</p>";
                      }                       
                                         
                      /*ingredients*/                     
                      if (isset($val['ingredients'])){
                        if (!empty($val['ingredients'])){
                            if (is_array($val['ingredients']) && count($val['ingredients'])>=1){
                                $htm.="<p class=\"small ingredients-label\">".$this->translation("default","Ingredients").":</p>";
                                foreach ($val['ingredients'] as $val_ingred) {      
                                                                       
                                   if($details_ingredients=$this->getIngredientsByName($val_ingred,$mid)){
                                      $_ingredients['ingredients_name_trans']=json_decode($details_ingredients['ingredients_name_trans'],true);                                   
                                      $htm.="<p class=\"small\">".
                                      $this->qTranslate($val_ingred,'ingredients_name',$_ingredients)
                                      ."</p>";
                                   } else $htm.="<p class=\"small\">".$val_ingred."</p>";
                                }   
                            }
                        }   
                      }
                      
                      $htm.='</div>';
                      
                      $htm.='<div class="manage">';
                        $htm.='<div class="c">';
                        
                         if ( $receipt==false):
                         $htm.='<a href="javascript:;" class="edit_item" data-row="'.$key.'" rel="'.$val['item_id'].'" >
                                    <i class="ion-compose"></i>
                                 </a>';
                          $htm.='<a href="javascript:;" class="delete_item" data-row="'.$key.'" rel="'.$val['item_id'].'" >
                                   <i class="ion-trash-a"></i>
                                </a>';
                         endif;
                         
                         
                        $htm.='</div>';
                         $htm.='<div class="d">'. self::formatNumber($total_price) .'</div>';
                      $htm.='</div>';
                      $htm.='<div class="clear"></div>';
                      
                      /*SUB ITEM*/
                      //dump($val);                   
                      //$item_array[$key]['sub_item']=$val['sub_item'];
                      $val['sub_item']=isset($val['sub_item'])?$val['sub_item']:'';
                      //dump($val['sub_item']);
                      //$val['sub_item']='';
                      
                      if (is_array($val['sub_item']) && count($val['sub_item'])>=1){
                         foreach ($val['sub_item'] as $cat_id=>$val_sub) {                              
                            
                            if (array_key_exists($cat_id,(array)$subcat_list)){     
                                
                                //** Translation */
                                $subcategory_trans=array();
                                if ($this->getOptionAdmin("enabled_multiple_translation")==2){
                                    if($subcategory_tran=$this->getAddonCategory($cat_id)){
                                        $subcategory_trans['subcategory_name_trans']=!empty($subcategory_tran['subcategory_name_trans'])?json_decode($subcategory_tran['subcategory_name_trans'],true):'';
                                    }                                                                   
                                }
                            
                                $htm.='<div class="a"></div>';
                                $htm.='<div class="b uk-text-success">'.
                                $this->qTranslate($subcat_list[$cat_id],'subcategory_name',
                                $subcategory_trans).'</div>';  
                                $htm.='<div class="clear"></div>';
                            }
                                                                                                                
                            $addon_qty=1;                               
                            foreach ($val_sub as $addon_row=> $val_subs) {
                                                                
                                if (isset( $val['addon_qty'][$cat_id] )){                                       
                                    $addon_qty=$val['addon_qty'][$cat_id][$addon_row];
                                } else {
                                     $addon_qty=$qty; /** fixed addon qty */
                                     /*if ( in_array($val['item_id'],(array)$added_item)){
                                        $addon_qty=0;
                                     }*/
                                }                           
                                                                
                                $val_subs=$this->explodeData($val_subs);
                                
                                //dump($val_subs);
                                $addon_raw_price=$this->prettyFormat($val_subs[1]);

                                $addon_item_price= $this->unPrettyPrice($val_subs[1]);
                                $addon_item_price=(integer)$addon_qty*$addon_item_price;
                                
                                $addon_raw_price = (float)$addon_raw_price* (float)$exchange_rate;
                                $addon_item_price = (float)$addon_item_price* (float)$exchange_rate;
                                
                                
                                /** two flavor */
                                if (!isset($val['two_flavors'])){
                                    $val['two_flavors']='';
                                }
                                if ( $val['two_flavors']==2){
                                    if ( $val_subs[3]==""){
                                       $subtotal+=$addon_item_price;    
                                       if ($food_taxable==false){
                                           $subtotal_non+=$addon_item_price;
                                       }
                                    }
                                } else {        
                                     /** check if item is taxable*/
                                     $subtotal+=$addon_item_price;
                                     if ($food_taxable==false){
                                         $subtotal_non+=$addon_item_price;
                                     }
                                }
                                
                                

                                $item_array[$key]['sub_item'][]=array(
                                  'addon_name'=>$val_subs[2],
                                  'addon_category'=>$subcat_list[$cat_id],
                                  'addon_qty'=>$addon_qty,
                                  //'addon_price'=>$addon_item_price
                                  'addon_price'=>$this->unPrettyPrice($val_subs[1]),
                                  'sub_item_id'=>$this->unPrettyPrice($val_subs[0]), // inventory new code,
                                  'subcat_id'=>$cat_id // inventory new code,
                                );
                                                                
                                /**translation */
                                $addon_name_trans='';
                                if ($this->getOptionAdmin("enabled_multiple_translation")==2){
                                    $addon_name_trans=$this->getAddonTranslation($val_subs[2],$mid);
                                }
                                                                                                                        
                                $htm.='<div class="a">'.$addon_qty.'x</div>';

//+++was fankari

/*$htm.='<div class="b uk-text-muted">'. self::formatNumber($addon_raw_price) ." ".$this->qTranslate($val_subs[2],
'sub_item_name',$addon_name_trans).'</div>';*/

$htm.='<div class="b uk-text-muted">'. self::formatNumber($val_subs[1]) ." ".$this->qTranslate($val_subs[2],
'sub_item_name',$addon_name_trans).'</div>';
//---was fankari

                                  $htm.='<div class="manage">';                                      
                                     if ( $addon_item_price!=0){
                                     $htm.='<div class="d">'. self::formatNumber($addon_item_price) .'</div>';
                                     } else $htm.='<div class="d">-</div>';
                                  $htm.='</div>';
                                $htm.='<div class="clear"></div>';
                                
                                /*changes for driver app*/
                                $item_array[$key]['new_sub_item'][$subcat_list[$cat_id]][]=array(
                                  'addon_name'=>$val_subs[2],
                                  'addon_category'=>$subcat_list[$cat_id],
                                  'addon_qty'=>$addon_qty,                                
                                  'addon_price'=>$this->unPrettyPrice($val_subs[1]),
                                  'subcategory_name_trans'=>isset($subcategory_trans)?$subcategory_trans:'',
                                  'sub_item_name_trans'=>isset($addon_name_trans)?$addon_name_trans:'',
                                );
                            }
                         }
                      }                 
                      
                      $htm.='</div>';
                                              
                      $x++;
                      $added_item[]=$val['item_id'];  /** fixed addon qty */
                      
                } /*END LOOP FOOD ITEM*/      
                
                                
                $taxable_subtotal=0;                    
                $tax_amt=0;
                
                $tax=$this->getOption('merchant_tax',$mid);
                                
                /*FIXED TAX BASED ON DATA WHEN VIEWING RECEIPT*/
                if($receipt){                                                       
                    if(isset($data['tax_set'])){
                       if($data['tax_set']>0.0001){                     
                           $tax =   $data['tax_set']*100;
                       } else $tax = $data['tax_set'];
                    }
                }
                                
                /*if transaction is pickup*/
                /*if ($data['delivery_type']=="pickup"){
                    $tax=0;
                }*/
                
                $tax_amt=$tax;
                $delivery_charges=$this->getOption('merchant_delivery_charges',$mid);
                $default_fee = $delivery_charges;
                
                /*dump($delivery_charges);
                dump($_SESSION['shipping_fee']);
                dump($subtotal);*/
                
                //shipping rates
                if (isset($_SESSION['shipping_fee'])){
                    if (is_numeric($_SESSION['shipping_fee'])){
                        if($_SESSION['shipping_fee']>0.0001){
                           $delivery_charges=$_SESSION['shipping_fee'];
                        }
                    }
                }

                
                if (!isset($data['delivery_charge'])){
                   /* if(FunctionsV3::isClassDeliveryTableExist()){               
                        if(isset($_SESSION['distance_info'])){
                            if(is_array($_SESSION['distance_info']) && count($_SESSION['distance_info'])>=1){
                               $delivery_charges = DeliveryTableRate::getDeliveryFee(
                               $mid,$subtotal,$default_fee,
                               $_SESSION['distance_info']['distance'],$_SESSION['distance_info']['unit']);
                            }
                        }
                    }*/
                }
                            
                
                if (isset($data['delivery_charge'])){
                    $delivery_charges=$data['delivery_charge'];
                }                   
                
                /*dump("final fee=>".$delivery_charges);
                die();*/
                
                /*EXTRA DELIVERY COST*/
                if (!$receipt){                                 
                    if ($data['delivery_type']=="delivery"){                        
                        $delivery_time = isset($_SESSION['kr_delivery_options']['delivery_time'])?$_SESSION['kr_delivery_options']['delivery_time']:'';  
                        
                        $delivery_date = isset($_SESSION['kr_delivery_options']['delivery_date'])?$_SESSION['kr_delivery_options']['delivery_date']:'';  
                                                
                        if ($this->enabledExtraCharges()){ 
                            $delivery_charges = $this->extraDeliveryFee(
                            $mid,$delivery_charges,
                            $delivery_time,
                            $delivery_date );
                        }
                    }       
                }       
                /*EXTRA DELIVERY COST*/
                
                //end shipping rates
                
                
                /*PACKAGING*/

                if($merchant_packaging_wise==1){                    
                    $merchant_packaging_charge = $wise_packaging_fee;
                } else {
                    $merchant_packaging_charge=$this->getOption('merchant_packaging_charge',$mid); 
                    $merchant_packaging_increment = $this->getOption('merchant_packaging_increment',$mid);
                    if($merchant_packaging_increment==2){
                        if (!isset($data['packaging'])){
                            $total_cart_item=0;                     
                            foreach ($cart_item as $cart_item_x) {                          
                                $total_cart_item+=$cart_item_x['qty'];
                            }                       
                            $merchant_packaging_charge=$total_cart_item*$merchant_packaging_charge;
                        }
                    }           
                }
                
                //fixed packaging charge
                if (isset($data['packaging'])){
                    $merchant_packaging_charge=$data['packaging'];
                }           
                
                if (!empty($delivery_charges)){
                    $delivery_charges=$this->unPrettyPrice($delivery_charges);
                } else $delivery_charges=0;        
                
                /*if transaction is pickup*/
                //dump($data);
                if ($data['delivery_type']=="pickup" || $data['delivery_type']=="dinein"){
                    $delivery_charges=0;
                }           
                
                if ( $data['delivery_type']=="dinein"){                 
                    //$merchant_packaging_charge=0;
                }
                
        
                
                $delivery_charges = (float)$delivery_charges * (float)$exchange_rate;
                $merchant_packaging_charge = (float)$merchant_packaging_charge * (float)$exchange_rate;
                
                                
                /*VOUCHER*/                                                
                $has_voucher=false;
                $less_voucher=0; 
                $voucher_type="";       

                $has_voucher_orig=false;
                $less_voucher_orig=0; 
                
                $pts_redeem_amt_orig=0;
                $pts_redeem_amt_found=false;
                $pts_redeem_amt=0;
                
                $order_infos=array();
                            
                 if (isset($_SESSION['voucher_code'])){                 
                    if (is_array($_SESSION['voucher_code'])){                       
                        $has_voucher=true;
                        //dump($_SESSION['voucher_code']);
                        $_SESSION['voucher_code']['amount']=$this->unPrettyPrice($_SESSION['voucher_code']['amount']);                     
                        if ( $_SESSION['voucher_code']['voucher_type']=="fixed amount" ){
                            $less_voucher=$_SESSION['voucher_code']['amount'];
                        } else {
                            $less_voucher=$subtotal*($_SESSION['voucher_code']['amount']/100);
                            $voucher_type=$this->normalPrettyPrice($_SESSION['voucher_code']['amount'])."%";
                        }            
                        $_SESSION['less_voucher']=$less_voucher;
                    }                
                }             
                
                /*APPMERCHANT CHANGES*/             
                if(!empty($data['voucher_name'])){
                    $has_voucher=true;                  
                    /*$_SESSION['voucher_code']['voucher_type'] = $data['voucher_type'];
                    $_SESSION['voucher_code']['amount'] = $data['voucher_amount'];*/
                    
                    if ( $data['voucher_type']=="fixed amount" ){
                        $less_voucher = $this->unPrettyPrice($data['voucher_amount']);
                        $used_currency = $this->getCurrencyCode();
                        $voucher_type=$used_currency.$this->normalPrettyPrice($data['voucher_amount']);
                    } else {
                        $less_voucher=$subtotal*($data['voucher_amount']/100);
                        $voucher_type=$this->normalPrettyPrice($data['voucher_amount'])."%";
                    }
                }
                      
                if ( $receipt==TRUE){                   
                    $order_ids=isset($data['order_id'])?$data['order_id']:'';
                    if (isset($_GET['id'])){
                        $order_ids=$_GET['id'];
                    }                                   
                    $order_infos=$this->getOrderInfo($order_ids);
                    //dump($order_infos);
                    if (!empty($order_infos['voucher_code'])){
                        $has_voucher=true;
                        if ($order_infos['voucher_type']=="fixed amount"){
                            $less_voucher=$order_infos['voucher_amount'];
                        } else {
                            $voucher_type=$this->normalPrettyPrice((integer)$order_infos['voucher_amount'])."%";
                            $less_voucher=$subtotal*($order_infos['voucher_amount']/100);
                        }                   
                    } else $has_voucher=false;          
                }           
                
                
                /*GET CALCULATION METHOD*/              
                $calculation_method='';
                if($receipt==TRUE){             
                  $calculation_method = $order_infos['calculation_method'];
                } else {
                  $calculation_method = $this->getReceiptCalculationMethod();
                }               
                
                /*VOUCHER*/
                if ( $receipt==TRUE){                   
                    //if ($order_infos['calculation_method']==2){
                    if($calculation_method==2){
                        $has_voucher_orig = $has_voucher;
                        $less_voucher_orig = $less_voucher;
                        $has_voucher=false; 
                        $less_voucher=0; 
                    }
                } else {
                    //if(FunctionsV3::isReceiptCalculationMethodTwo()){
                    if($calculation_method==2){
                        $has_voucher_orig = $has_voucher;
                        $less_voucher_orig = $less_voucher;
                        $has_voucher=false; 
                        $less_voucher=0; 
                    }
                }
                
                $less_voucher = (float)$less_voucher * (float)$exchange_rate;
                $less_voucher_orig = (float)$less_voucher_orig * (float)$exchange_rate;

                if ($less_voucher==TRUE){
                    $subtotal=$subtotal-$less_voucher;
                    
                    /** check if item is taxable*/
                    if ($food_taxable==false){
                        $subtotal_non=$subtotal_non-$less_voucher;
                    }
                }       
                                
                /*PROMO STARTS HERE*/
                $show_discount=false;
                $discounted_amount=0;
                $merchant_discount_amount=0;
                
                $discounted_amount_orig=0;
                $has_discount = false;
                
                
                if(isset($_SESSION['promo_discount'])){
                   unset($_SESSION['promo_discount']);
                }
                
                if ($receipt==TRUE){
                    $_GET['id']=isset($_GET['id'])?$_GET['id']:$new_order_id;
                    if ( $promo_res=$this->getOrderDiscount($_GET['id'])){                      
                        if ( $promo_res['discounted_amount']>=0.0001){
                            
                            //if ($order_infos['calculation_method']==2){
                            if($calculation_method==2){
                                $merchant_discount_amount=$this->formatNumber_pos($promo_res['discount_percentage']);

                                $discounted_amount=$promo_res['discounted_amount'];
                                $has_discount=true;
                            } else {
                                $show_discount=true;
                                $merchant_discount_amount=$this->formatNumber_pos($promo_res['discount_percentage']);
                                $discounted_amount=$promo_res['discounted_amount'];
                                $subtotal=$subtotal-$discounted_amount;
                                
                                /** check if item is taxable*/
                                if ($food_taxable==false){
                                    //$subtotal_non=$subtotal_non-$discounted_amount;
                                }
                            }
                        }
                    }                   
                } else {
                    //if ( $promo_res=Yii::app()->functions->getMerchantOffersActive($mid)){
                    if ( $promo_res=$this->getMerchantOffersActive($mid,$data['delivery_type'])){
                        //dump($promo_res);
                        $offer_continue=true;
                        
                        if(isset($promo_res['applicable_to'])){
                          if (!empty($promo_res['applicable_to'])){
                              if ($promo_res['applicable_to']!="all"){
                                 $applicable_to = json_decode($promo_res['applicable_to'],true);                                 
                                 if(!in_array($data['delivery_type'],(array)$applicable_to)){
                                    $offer_continue=false;
                                 }
                              }
                          } 
                        }
                                            
                        $merchant_spend_amount=$promo_res['offer_price'];

                        $merchant_discount_amount=$promo_res['offer_percentage'];


                        $merchant_discount_amount=$this->normalPrettyPrice($merchant_discount_amount);

                        

                        
                        
                        $merchant_spend_amount = (float)$merchant_spend_amount * (float)$exchange_rate;
                        
                        if($offer_continue){
                            if ( $subtotal>=$merchant_spend_amount){
                                        
                               //if(FunctionsV3::isReceiptCalculationMethodTwo()){
                               if($calculation_method==2){
                                  $merchant_discount_amount1=$merchant_discount_amount/100;
                                  $discounted_amount=$subtotal*$merchant_discount_amount1;
                                  $has_discount=true;
                               } else {                    
                                   $show_discount=true;
                                   $merchant_discount_amount1=floatval($merchant_discount_amount)/100;
                                   $discounted_amount=$subtotal*$merchant_discount_amount1;                 
                                   $subtotal=$subtotal-$discounted_amount;
                                   
                                   $_SESSION['promo_discount']=1;
                                   
                                   /** check if item is taxable*/
                                   if ($food_taxable==false){
                                       //$subtotal_non=$subtotal_non-$discounted_amount;
                                   }
                               }
                               
                            } 
                        }
                        
                    }       
                }   
                
                
                /*dump($discounted_amount);
                dump($merchant_discount_amount);*/
                
                /**above sub total free delivery*/      
                $free_delivery=false;        
                if ( $data['delivery_type']=="delivery"){
                    
                    if(!isset($_GET['backend'])){
                        $free_delivery_above_price = (float)$this->getOption("free_delivery_above_price",$mid);
                        if ($this->isSearchByLocation() && $receipt==false){
                        
                            //$location_data=FunctionsV3::getSearchByLocationData();    

                                 $location_data=false; 
                            if(isset($data['location_data'])){
                                if(is_array($data['location_data']) && count($data['location_data'])>=1){
                                    $location_data = $data['location_data'];
                                }                           
                            }       
                                                        
                            $delivery_fee_resp=$this->getLocationDeliveryFeeWithMinimum(
                              $mid,0,0,$location_data
                            );                                      
                            if($delivery_fee_resp['free_above_subtotal']>0){
                                $free_delivery_above_price = (float)$delivery_fee_resp['free_above_subtotal'];
                            }                       
                        }
                        if($free_delivery_above_price>0){
                            //dump("subtotal=>$subtotal  free_delivery_above_price=>$free_delivery_above_price");
                            if ($subtotal>=$free_delivery_above_price){
                                $delivery_charges=0;
                                $free_delivery=true;
                            }
                        }
                    }                   
                }
                /**above sub total free delivery*/
                
                
              
                
                /*POINTS PROGRAM*/
                     
                            
                    if (isset($_SESSION['pts_redeem_amt']) && $_SESSION['pts_redeem_amt']>0.01){
                        $pts_redeem_amt=$this->unPrettyPrice($_SESSION['pts_redeem_amt']);                                             
                        $pts_redeem_amt = (float)$pts_redeem_amt * (float)$exchange_rate;
                        if($calculation_method==2){
                           $subtotal=$this->unPrettyPrice($subtotal);
                           $pts_redeem_amt_found=true;
                        } else $subtotal=$this->unPrettyPrice($subtotal)-$pts_redeem_amt;
                    } elseif ( isset($data['points_amount'])){
                        
                        $pts_redeem_amt=$this->unPrettyPrice($data['points_amount']);      
                        $pts_redeem_amt = (float)$pts_redeem_amt * (float)$exchange_rate;
                        
                        if($calculation_method==2){
                           $subtotal=$this->unPrettyPrice($subtotal);
                           $pts_redeem_amt_found=true;
                        } else $subtotal=$this->unPrettyPrice($subtotal)-$pts_redeem_amt;
                        
                    } else {
                        if ($receipt==TRUE){                    
                            if (isset($data['points_discount']) && $data['points_discount']>0){
                               $pts_redeem_amt=$this->unPrettyPrice($data['points_discount']);                            
                               $pts_redeem_amt = (float)$pts_redeem_amt * (float)$exchange_rate;
                               
                               if($calculation_method==2){
                                  $subtotal=$this->unPrettyPrice($subtotal);
                                  $pts_redeem_amt_found=true;
                               } else $subtotal=$this->unPrettyPrice($subtotal)-$pts_redeem_amt;                              
                            }           
                        }       
                    }
                
                               
                
                $service_fee = isset($data['service_fee'])?(float)$data['service_fee']:0;                   
                $service_fee_taxable = isset($data['service_fee'])?(float)$data['service_fee']:0;
                
                $service_fee  = (float)$service_fee * (float)$exchange_rate;
                $service_fee_taxable  = (float)$service_fee_taxable * (float)$exchange_rate;
                                
                if(isset($data['service_fee_applytax'])){
                    if(!$data['service_fee_applytax']){
                        $service_fee_taxable = 0;
                    }                   
                }               
                    
                 
                if ( !empty($tax)){
                    $tax=$tax/100;
                    
                    /** check if item is taxable*/    
                    $temp_delivery_charges=$delivery_charges;                           
                    if ($this->getOption("merchant_tax_charges",$mid)==2){
                        $temp_delivery_charges=0;                       
                    }  
                                    
                    if ($receipt==true){                        
                        if (isset($data['donot_apply_tax_delivery'])){
                            if ($data['donot_apply_tax_delivery']==2){
                                $temp_delivery_charges=0;                               
                            } else $temp_delivery_charges=$delivery_charges;
                        }                       
                    }

                    if (!isset($subtotal_non)){
                        $subtotal_non=0;
                    }          
                    
                                                                                            
                    /*FIXED TAX ISSUE*/
                    if ($subtotal_non>=0.0001){                     
                        $temp_subtotal=$subtotal-$subtotal_non;                             
                        if($temp_subtotal>0){                           
                           $taxable_subtotal=($temp_subtotal+$temp_delivery_charges+$merchant_packaging_charge+$service_fee_taxable)*$tax;
                        } else {                    
                           if($merchant_packaging_charge>0 && $merchant_packaging_charge>0){                            
                              $taxable_subtotal=($temp_delivery_charges+$merchant_packaging_charge+$service_fee_taxable)*$tax;                         
                           }
                        }
                    } else {                        
                        $taxable_subtotal=( (float)$subtotal+ (float)$temp_delivery_charges + (float)$merchant_packaging_charge + (float) $service_fee_taxable )*$tax;    
                    }
                                        
                    
                    /*dump($temp_delivery_charges."=>".$merchant_packaging_charge);
                    dump($subtotal);
                    dump($subtotal_non);
                    dump("taxable_subtotal=>".$taxable_subtotal);*/
                }           
                
                
                //$htm.="TAXABLE=>$taxable_subtotal <br/>";
                
                                            
                $total=(float)$subtotal + (float)$taxable_subtotal + (float)$delivery_charges + (float)$merchant_packaging_charge + (float) $service_fee;
                
                
                /*VOUCHER*/
                                
                $htm.='<div class="summary-wrap">';

                
                if($data['show_item_total']==1){
                if($less_voucher>0||$pts_redeem_amt>0){
                      $item_total = (float)($less_voucher ?? 0) + (float)($subtotal ?? 0) + (float)($pts_redeem_amt ?? 0);
                      $htm.=$this->receiptRowTotal('Item Total',
                             "(".self::formatNumber($item_total).")" );  
                     
                     }
                 }
                        
                
                 if ( $has_voucher==TRUE){       

                     if ( $show_discount==true):                                        
                       $htm.=$this->receiptRowTotal( ("Discount")." $merchant_discount_amount%" ,
                       self::formatNumber($discounted_amount)
                       );
                     endif;
                   

                                      
                                         
                     if ($receipt==TRUE){
                        $voucher_code=" - ".$order_infos['voucher_code']."";
                     } else $voucher_code='';
                                         
                     $htm.=$this->receiptRowTotal( $this->translation("default","Less Voucher")." ".$voucher_type ,
                     "(". self::formatNumber($less_voucher) .")" 
                     );          
                     
                                            
                         $pts_redeem_amt_orig = $pts_redeem_amt;
                         if($receipt==TRUE){                            
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         } else {                           
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         }
                         if($pts_redeem_amt>0){
                             $htm.=$this->receiptRowTotal('Points Discount',
                             "(".self::formatNumber($pts_redeem_amt).")" );  
                         }  
                     
                                         
                     $htm.=$this->receiptRowTotal("Sub Total", self::formatNumber($subtotal) );
                                    
                 } else {                    
                    
                     if ( $show_discount==true):                     
                     $htm.=$this->receiptRowTotal( ("Discount")." $merchant_discount_amount%",
                       "(". self::formatNumber($discounted_amount) .")"
                      );
                     endif;
                                     
                     /*POINTS PROGRAM*/         
                         
                                   
                         
                         $pts_redeem_amt_orig = $pts_redeem_amt;
                         
                         if($receipt==TRUE){
                            //if ($order_infos['calculation_method']==2){
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         } else {
                            //if(FunctionsV3::isReceiptCalculationMethodTwo()){
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         }
                                
                         if($pts_redeem_amt>0){
                             $htm.=$this->receiptRowTotal('Points Discount',
                             "(".self::formatNumber($pts_redeem_amt).")" );  
                         }  
                     
                                         
                    $htm.=$this->receiptRowTotal('Sub Total',
                    self::formatNumber($subtotal) ,'','cart_subtotal' );
                    
                 }          
                 
                 
                 if(isset($data['service_fee'])){
                     if($data['service_fee']>0){
                        $htm.=$this->receiptRowTotal('Service Fee',
                        self::formatNumber(  $data['service_fee'] * $exchange_rate )
                        );
                     }
                 }
                                 
                 if (!empty($delivery_charges)){
                    $htm.=$this->receiptRowTotal('Delivery Fee',
                    self::formatNumber($delivery_charges)
                    );
                 }               
                 
                 if ( $free_delivery==true){                     
                     $htm.=$this->receiptRowTotal("Delivery Fee", "Free" );
                 }
                 
                 if (!empty($merchant_packaging_charge)){       
                   if($merchant_packaging_charge>=0.001){         
                       $htm.=$this->receiptRowTotal("Packaging",
                         self::formatNumber($merchant_packaging_charge)                       
                       );
                   }
                 }
                                                         
                 if ( !empty($tax)){                 
                     if($taxable_subtotal>0.0001){    
                         $htm.=$this->receiptRowTotal( "Tax"." $tax_amt%" ,
                          self::formatNumber($taxable_subtotal)
                         );
                     }
                 }

                 /*TIPS*/
                 if (isset($data['cart_tip_percentage'])){
                    if(strlen($data['cart_tip_percentage'])>=0.0001){
                        $data['tip_enabled']=2;
                        $data['tip_percent']=$data['cart_tip_percentage'];
                    }
                 }
                                 
                 if (isset($data['tip_enabled'])){                  
                    if ($data['tip_enabled']==2 && $data['tip_percent']>=0.0001){                                           
                        $data['cart_tip_value'] =  $subtotal * $data['tip_percent'];                        
                        
                        $data['cart_tip_percentage']=$data['tip_percent']*100;
                        
                        $t_cart_tip_percentage = explode(".",$data['cart_tip_percentage']);                                      
                        $tip_decimal_places = 0;
                        if(count($t_cart_tip_percentage)>=2){
                            $tip_decimal_places = 2;
                        }
                        
                        $htm.=$this->receiptRowTotal( ("Tips")." ".number_format($data['cart_tip_percentage'],$tip_decimal_places)."%" ,
                          self::formatNumber($data['cart_tip_value'])
                        );                 
                        
                                                
                        $data['cart_tip_percentage']  = number_format($data['cart_tip_percentage'],$tip_decimal_places,'.','');  


                             
                        $total+=$data['cart_tip_value'];                        
                    }
                 }
                                 
                 
                 /*CARD FEE*/                            
                 if (isset($data['card_fee']) || isset($data['card_percentage'])){                  
                     $fee = isset($data['card_fee'])?(float)$data['card_fee']:0;          
                     $card_percentage = isset($data['card_percentage'])?(float)$data['card_percentage']:0;                   
                     //dump("$card_percentage=>$fee");                   
                     if($fee>0 || $card_percentage>0){
                         if($card_percentage>0){                            
                            $card_fees = (float)$total*((float)$data['card_percentage']/100);                           
                         }                  
                         if($fee>0){
                            $card_fees+=(float)$data['card_fee'];
                         }
                         
                         $card_fees = (float)$card_fees * (float)$exchange_rate;
                         
                         $htm.=$this->receiptRowTotal("Card Fee", self::formatNumber($card_fees) );

                         if($receipt){
                          $total+=(float)$card_fees;
                         }
                         
                     }                   
                 }          

                 //dump($card_fees);                      
               
               /*VOUCHER*/
               if($has_voucher_orig){
                 $htm.=$this->receiptRowTotal(("Voucher"), "(".self::formatNumber($less_voucher_orig).")" );  
                 $total=$this->unPrettyPrice($total)-$this->unPrettyPrice($less_voucher_orig);
               }
               
               
               /*POINTS PROGRAM*/
                                  
                   if($pts_redeem_amt_found){
                      $htm.=$this->receiptRowTotal(("Points Discount"), "(".self::formatNumber($pts_redeem_amt_orig).")" );  
                      $total=$this->unPrettyPrice($total)-$this->unPrettyPrice($pts_redeem_amt_orig);
                      
                   }
               
               
               /*DISCOUNT*/
               if($has_discount){
                  $htm.=$this->receiptRowTotal( ("Discount")." $merchant_discount_amount%",
                       "(". self::formatNumber($discounted_amount) .")"
                      );
                  $total=$this->unPrettyPrice($total)-$this->unPrettyPrice($discounted_amount);
               }
                                           
               $htm.="<div class=\"row cart_total_wrap bold\">";
               $htm.="<div class=\"col-md-6 col-xs-6  text-right\">".("Total")."</div>";
               $htm.="<div class=\"col-md-6 col-xs-6  text-right cart_total\">".               
               self::formatNumber($total) ."</div>";
               $htm.="</div>";
               

               /*POINTS PROGRAM*/
                                                
                  $htm.=$this->PointsProgram->cartTotalEarnPoints($cart_item,$receipt,$subtotal,$mid);
               
               
               if(!isset($pts_redeem_amt)){
                  $pts_redeem_amt=0;
               }
               $htm .= '<input type="hidden" name="subtotal_order" id="subtotal_order" value="' . htmlspecialchars($this->unPrettyPrice($subtotal + $less_voucher + $pts_redeem_amt), ENT_QUOTES, 'UTF-8') . '" />';
              $htm .= '<input type="hidden" name="subtotal_order2" id="subtotal_order2" value="' . htmlspecialchars($this->unPrettyPrice($subtotal), ENT_QUOTES, 'UTF-8') . '" />';
              $htm .= '<input type="hidden" name="subtotal_extra_charge" id="subtotal_extra_charge" value="' . htmlspecialchars($this->unPrettyPrice((float)$delivery_charges + (float)$merchant_packaging_charge + (float)$taxable_subtotal), ENT_QUOTES, 'UTF-8') . '" />';
               
               
               if(!isset($data['cart_tip_percentage'])){
                   $data['cart_tip_percentage']='';
               }
               
               $tips_decimal_places = $this->getOptionAdmin('admin_decimal_place');               
               if(empty($tips_decimal_places)){             
                  $tips_decimal_places=2;
               }               
               
               //dump($data['cart_tip_percentage']);
               // array value
               
               if(!isset($data['cart_tip_percentage'])){
                   $data['cart_tip_percentage']='';
               }
               if($tax>0){
               $tasxa=$this->normalPrettyPrice($tax*100).'%';
                $tax_label="TaxABC1 ".$tasxa;
               }else{$tax_label="";}

               $used_currency = $this->getCurrencyCode();

               //$data['cart_tip_percentage']=15;

               $item_array_total=array(
                 'subtotal'=>round($subtotal,2),
                 'taxable_total'=>round($taxable_subtotal,2),
                 'delivery_charges'=>$delivery_charges,
                 'total'=>round($total,2),               
                 'tax'=>$tax,
                 'tax_amt'=>$tax_amt,
                 'tax_label'=>$tax_label,
                 'curr'=>$used_currency,
                 'mid'=>$mid,
                 'discounted_amount'=>round($discounted_amount,2),
                 'merchant_discount_amount' => round(floatval($merchant_discount_amount), 2),
				  'merchant_discount_amount_new' =>$merchant_discount_amount,

                 'merchant_packaging_charge'=>$merchant_packaging_charge,
                 'less_voucher'=>$less_voucher,
                 'voucher_type'=>$voucher_type,
                 /*'tips'=>isset($data['cart_tip_value'])?$data['cart_tip_value']:'',
                 'tips_percent'=>$data['cart_tip_percentage']>0.1?number_format($data['cart_tip_percentage'],0)."%":'',
                 'cart_tip_percentage'=>$data['cart_tip_percentage']>0.1?number_format($data['cart_tip_percentage']):'',*/
                 'tips'=>$data['cart_tip_percentage']>0.1?self::formatNumber($data['cart_tip_value'],$tips_decimal_places):'',                
                 'tips_percent'=>$data['cart_tip_percentage']>0.1?$data['cart_tip_percentage']."%":'',               
                 'cart_tip_percentage'=>$data['cart_tip_percentage']>0.1?($data['cart_tip_percentage']):'',
                 'pts_redeem_amt'=>isset($pts_redeem_amt)?$pts_redeem_amt:'',
                 'voucher_value'=>isset($_SESSION['voucher_code']['amount'])?$_SESSION['voucher_code']['amount']:'',
                 'voucher_types'=>isset($_SESSION['voucher_code']['voucher_type'])?$_SESSION['voucher_code']['voucher_type']:'',
                 
                 'calculation_method'=>$calculation_method,
                 'pts_redeem_amt_orig'=>$pts_redeem_amt_orig,
                 'less_voucher_orig'=>$less_voucher_orig,                
                 'service_fee'=>isset($service_fee)?(float)$service_fee:0
               );   

                           
                           
               if ($receipt){                 
                  $item_array_total['voucher_value']=isset($data['voucher_amount'])?$data['voucher_amount']:0;
                  $item_array_total['voucher_types']=isset($data['voucher_type'])?$data['voucher_type']:'';
               }
               
               if (isset($data['card_fee']) || isset($data['card_percentage']) ){
                   if($card_fees>0){
                       $item_array_total['card_fee']=$card_fees;
                   }
               }


               //print_r($item_array_total);die();

               
               //dump($data);
               /*header('Content-Type: text/html; charset=utf-8');
               echo $htm;*/
               

               if($_REQUEST['debug']){print_r($item_array);}
               
               
                            
                $this->code=1;
                $this->msg="OK";

                $this->details=array(
                  'item-count'=>$x,
                  'code'=>1,
                  'msg'=>"OK",
                  'html'=>$htm,
                  'raw'=>array('item'=>$item_array,'total'=>$item_array_total)
                );


    // Returning the details array
    return $this->details;
            } else $this->msg=$this->translation("default","No Item added yet!");
        } else $this->msg=$this->translation("default","No Item added yet!");
    }



public function displayOrderHTML_taxwebapp($data='',$cart_item='',$receipt=false,$new_order_id='')
    {
        $item_array=array();
        $this->code=2;
        $htm='';    
        $subtotal=0;
        $subtotal_non=0;
        $mid=isset($data['merchant_id'])?$data['merchant_id']:''; 

        $this->PointsProgram = new PointsProgram();  

               
        if (empty($mid)){
            $this->msg=$this->translation("default","Merchant ID is empty");
            return ;
        }   
                            
        //Yii::app()->functions->data="list";
        $food_item=$this->getFoodItemLists($mid);
        $subcat_list=$this->getAddOnLists($mid);       
        
        $merchant_packaging_wise = $this->getOption('merchant_packaging_wise',$mid);
        $wise_packaging_fee = 0;
        $merchant_packaging_charge = 0;
        $card_fees = 0;
        
        $exchange_rate = isset($data['exchange_rate']) ? (float)$data['exchange_rate'] : 1;
                                           
        if (isset($cart_item)){
            if (is_array($cart_item) && count($cart_item)>=1){
                $x=0;
                foreach ($cart_item as $key=>$val) {        
                    
                    //dump($val);               
                    
                    $val['notes']=isset($val['notes'])?$val['notes']:"";
                    
                    $size_words=''; $_size_id=0;
                    $t=!empty($val['price'])?explode("|",$val['price']):'';                 
                    if (is_array($t) && count($t)>=1){
                        $val['price']=$t[0];
                        if (isset($t[1])){
                            $size_words=$t[1];
                            $_size_id=isset($t[2])?(integer)$t[2]:0;  // inventory new code
                        } else $size_words='';                  
                    }
                    
                    $price=$this->cleanNumber($this->unPrettyPrice($val['price']));
                    
                    if (!empty($val['discount'])){
                        $val['discount']=$this->unPrettyPrice($val['discount']);
                        $price=$price-$val['discount'];
                    }           
                    
                    $price = (float) $price * $exchange_rate;
                    
                    $qty=$val['qty'];  /** fixed addon qty */                   
                    $total_price=$val['qty']*(float)$price;
                                
                    /** check if item is taxable*/
                    //dump($val);
                    $food_taxable=true;                                     
                    if (isset($val['non_taxable'])){
                        if ( $val['non_taxable']==2){
                            $food_taxable=false;
                        }   
                    }           
                                                                            
                    $subtotal=$subtotal+$total_price; 
                    
                    if ($food_taxable==false){
                        //dump($total_price);
                        $subtotal_non=$subtotal_non+$total_price;                       
                    }           
                    
                    /*$size_words='';
                    if ( $price_size=explodeData($val['price'])){                           
                        if (isset($price_size[1])){
                            $size_words=$price_size[1];
                        }
                    }   */                                      
                    
                    /** Translation */
                    $food_infos=array(); $food_info = array();
                    $size_info_trans='';
                    $cooking_ref_trans='';
                    if ($this->getOptionAdmin("enabled_multiple_translation")==2){
                        $food_info=$this->getFoodItem($val['item_id']);
                        $food_infos['item_name_trans']=!empty($food_info['item_name_trans'])?json_decode($food_info['item_name_trans'],true):'';        
                                                
                        if (!empty($size_words)){
                            $size_info_trans=$this->getSizeTranslation($size_words,$mid);
                        }               

                        if(!empty($val['cooking_ref'])){                            
                            $cooking_ref_trans=$this->getCookingTranslation($val['cooking_ref'],$mid);
                        }   
                    } else $food_info=$this->getFoodItem($val['item_id']);
                    
                    
                    /*GET PACKAGING CHARGE*/
                    if($merchant_packaging_wise==1){ 

                       if(isset($food_info['packaging_fee'])){
                           if($food_info['packaging_fee']>0){
                               if ($food_info['packaging_incremental']==1){
                                  $wise_packaging_fee+= $food_info['packaging_fee']*$qty;
                               } else {                             
                                   $wise_packaging_fee+= $food_info['packaging_fee'];
                               }
                           }
                       }
                    }
                    
                    /*dump($food_item);
                    dump($val['item_id']);*/  

                    
                    $htm.='<div class="item-order-list item-row">';
                                          
                      $val['category_id']=isset($val['category_id'])?$val['category_id']:'';
                      
                      if ($res_category=$this->getCategory($val['category_id'])){                         
                          $category_name_trans['category_name_trans']=!empty($res_category['category_name_trans'])?
                          json_decode($res_category['category_name_trans'],true):false; 
                                                                  
                          $htm.="<p style=\"margin:0;\"><b>".$this->qTranslate($res_category['category_name'],
                          'category_name',$category_name_trans)."</b></p>";
                      } 
                      
                      //dump($htm);


                                    

                    if($val['variable_price']>0){
                    $htm.='<div class="a" style="width:60px">'.$val['qty'].' x'.$val['variable_price'].'</div>';                    
                }else{
                    $htm.='<div class="a">'.$val['qty'].'</div>';
                }


                                    
                      
                      $htm.='<div class="b">'.$food_info['item_name'];
                      
                      if (!empty($size_words)){
                         $htm.="(".$size_words.")";
                      }
                      

                      //dump($val);
                        //echo $htm;die();
                      
                      $_category_name = isset($res_category['category_name_trans'])?$res_category['category_name']:'';
                      
                      // array value
                      $item_array[$key]=array(
                        'item_id'=>$val['item_id'],
                        'item_name'=>isset($food_item[$val['item_id']])?$food_item[$val['item_id']]:'',
                        'size_words'=>$size_words,
                        'size_id'=>$_size_id, // inventory
                        'qty'=>$val['qty'],
                        
                        'is_printed'=>$val['is_printed'],
                        'is_printed_already'=>$val['is_printed_already'],
                        'variable_price'=>$val['variable_price'],
                        //'normal_price'=>prettyFormat($val['price']),
                        'normal_price'=> (float)$val['price'] *  (float)$exchange_rate  ,
                        'discounted_price'=>$price,
                        'discount'=>$val['discount'],
                        
                        /* Custom code 13 starts */
                        'promo_id'=>$val['promo_id'],
                        /* Custom code 13 Ends */
                        
                        'order_notes'=>isset($val['notes'])?$val['notes']:'',
                        'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
                        'ingredients'=>isset($val['ingredients'])?$val['ingredients']:'',
                        'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1,
                        'category_id'=>isset($val['category_id'])?$val['category_id']:'',
                        'category_name'=>!empty($_category_name)?$_category_name:$res_category['category_name'],
                        'category_name_trans'=>isset($category_name_trans)?$category_name_trans:'',                     
                        'item_name_trans'=>isset($food_infos)?$food_infos:'',
                        'size_name_trans'=>isset($size_info_trans)?$size_info_trans:'',
                        'cooking_name_trans'=>isset($cooking_ref_trans)?$cooking_ref_trans:'',                                                                      
                      );                                         
                      
                      $htm.=$this->displaySpicyIconByID($val['item_id']);
                      
                      if (!empty($val['discount'])){
                          $htm.="<p class=\"uk-text-small\">".
                          "<span class=\"normal-price\">". self::formatNumber( ((float)$val['price']*$exchange_rate) ) ." </span>".
                          "<span class=\"sale-price\">". self::formatNumber($price) ."</span>"
                          ."</p>";      
                                          
                      } else {
                        
                        $htm.="<p class=\"uk-text-small\">".                          
                          "<span class=\"base-price\">". self::formatNumber($price) ."</span>"
                          ."</p>";                        
                      }
                      
                      /*Custom code 13 starts */
                      if($val['promo_id']>0){
                      $htm.="<p class=\"small\" style='margin: 0px;color:red'>Promo ID :".$val['promo_id']."</p>";  
                      }
                      /*Custom code 13 Ends */
                      
                      if (!empty($val['cooking_ref'])){
                          $htm.="<p class=\"small\">".
                          $this->qTranslate($val['cooking_ref'],'cooking_name',$cooking_ref_trans)."</p>";
                      }                 
                      if (!empty($val['notes'])){
                          $htm.="<p class=\"small text-info\">".$val['notes']."</p>";
                      }                       
                                         
                      /*ingredients*/                     
                      if (isset($val['ingredients'])){
                        if (!empty($val['ingredients'])){
                            if (is_array($val['ingredients']) && count($val['ingredients'])>=1){
                                $htm.="<p class=\"small ingredients-label\">".$this->translation("default","Ingredients").":</p>";
                                foreach ($val['ingredients'] as $val_ingred) {      
                                                                       
                                   if($details_ingredients=$this->getIngredientsByName($val_ingred,$mid)){
                                      $_ingredients['ingredients_name_trans']=json_decode($details_ingredients['ingredients_name_trans'],true);                                   
                                      $htm.="<p class=\"small\">".
                                      $this->qTranslate($val_ingred,'ingredients_name',$_ingredients)
                                      ."</p>";
                                   } else $htm.="<p class=\"small\">".$val_ingred."</p>";
                                }   
                            }
                        }   
                      }
                      
                      $htm.='</div>';
                      
                      $htm.='<div class="manage">';
                        $htm.='<div class="c">';
                        
                         if ( $receipt==false):
                         $htm.='<a href="javascript:;" class="edit_item" data-row="'.$key.'" rel="'.$val['item_id'].'" >
                                    <i class="ion-compose"></i>
                                 </a>';
                          $htm.='<a href="javascript:;" class="delete_item" data-row="'.$key.'" rel="'.$val['item_id'].'" >
                                   <i class="ion-trash-a"></i>
                                </a>';
                         endif;
                         
                         
                        $htm.='</div>';
                         $htm.='<div class="d">'. self::formatNumber($total_price) .'</div>';
                      $htm.='</div>';
                      $htm.='<div class="clear"></div>';
                      
                      /*SUB ITEM*/
                      //dump($val);                   
                      //$item_array[$key]['sub_item']=$val['sub_item'];
                      $val['sub_item']=isset($val['sub_item'])?$val['sub_item']:'';
                      //dump($val['sub_item']);
                      //$val['sub_item']='';
                      
                      if (is_array($val['sub_item']) && count($val['sub_item'])>=1){
                         foreach ($val['sub_item'] as $cat_id=>$val_sub) {                              
                            
                            if (array_key_exists($cat_id,(array)$subcat_list)){     
                                
                                //** Translation */
                                $subcategory_trans=array();
                                if ($this->getOptionAdmin("enabled_multiple_translation")==2){
                                    if($subcategory_tran=$this->getAddonCategory($cat_id)){
                                        $subcategory_trans['subcategory_name_trans']=!empty($subcategory_tran['subcategory_name_trans'])?json_decode($subcategory_tran['subcategory_name_trans'],true):'';
                                    }                                                                   
                                }
                            
                                $htm.='<div class="a"></div>';
                                $htm.='<div class="b uk-text-success">'.
                                $this->qTranslate($subcat_list[$cat_id],'subcategory_name',
                                $subcategory_trans).'</div>';  
                                $htm.='<div class="clear"></div>';
                            }
                                                                                                                
                            $addon_qty=1;                               
                            foreach ($val_sub as $addon_row=> $val_subs) {
                                                                
                                if (isset( $val['addon_qty'][$cat_id] )){                                       
                                    $addon_qty=$val['addon_qty'][$cat_id][$addon_row];
                                } else {
                                     $addon_qty=$qty; /** fixed addon qty */
                                     /*if ( in_array($val['item_id'],(array)$added_item)){
                                        $addon_qty=0;
                                     }*/
                                }                           
                                                                
                                $val_subs=$this->explodeData($val_subs);
                                
                                //dump($val_subs);
                                $addon_raw_price=$this->prettyFormat($val_subs[1]);

                                $addon_item_price= $this->unPrettyPrice($val_subs[1]);
                                $addon_item_price=(integer)$addon_qty*$addon_item_price;
                                
                                $addon_raw_price = (float)$addon_raw_price* (float)$exchange_rate;
                                $addon_item_price = (float)$addon_item_price* (float)$exchange_rate;
                                
                                
                                /** two flavor */
                                if (!isset($val['two_flavors'])){
                                    $val['two_flavors']='';
                                }
                                if ( $val['two_flavors']==2){
                                    if ( $val_subs[3]==""){
                                       $subtotal+=$addon_item_price;    
                                       if ($food_taxable==false){
                                           $subtotal_non+=$addon_item_price;
                                       }
                                    }
                                } else {        
                                     /** check if item is taxable*/
                                     $subtotal+=$addon_item_price;
                                     if ($food_taxable==false){
                                         $subtotal_non+=$addon_item_price;
                                     }
                                }
                                
                                $item_array[$key]['sub_item'][]=array(
                                  'addon_name'=>$val_subs[2],
                                  'addon_category'=>$subcat_list[$cat_id],
                                  'addon_qty'=>$addon_qty,
                                  //'addon_price'=>$addon_item_price
                                  'addon_price'=>$this->unPrettyPrice($val_subs[1]),
                                  'sub_item_id'=>$this->unPrettyPrice($val_subs[0]), // inventory new code,
                                  'subcat_id'=>$cat_id // inventory new code,
                                );
                                                                
                                /**translation */
                                $addon_name_trans='';
                                if ($this->getOptionAdmin("enabled_multiple_translation")==2){
                                    $addon_name_trans=$this->getAddonTranslation($val_subs[2],$mid);
                                }
                                                                                                                        
                                $htm.='<div class="a">'.$addon_qty.'x</div>';

//+++was fankari

/*$htm.='<div class="b uk-text-muted">'. self::formatNumber($addon_raw_price) ." ".$this->qTranslate($val_subs[2],
'sub_item_name',$addon_name_trans).'</div>';*/

$htm.='<div class="b uk-text-muted">'. self::formatNumber($val_subs[1]) ." ".$this->qTranslate($val_subs[2],
'sub_item_name',$addon_name_trans).'</div>';
//---was fankari

                                  $htm.='<div class="manage">';                                      
                                     if ( $addon_item_price!=0){
                                     $htm.='<div class="d">'. self::formatNumber($addon_item_price) .'</div>';
                                     } else $htm.='<div class="d">-</div>';
                                  $htm.='</div>';
                                $htm.='<div class="clear"></div>';
                                
                                /*changes for driver app*/
                                $item_array[$key]['new_sub_item'][$subcat_list[$cat_id]][]=array(
                                  'addon_name'=>$val_subs[2],
                                  'addon_category'=>$subcat_list[$cat_id],
                                  'addon_qty'=>$addon_qty,                                
                                  'addon_price'=>$this->unPrettyPrice($val_subs[1]),
                                  'subcategory_name_trans'=>isset($subcategory_trans)?$subcategory_trans:'',
                                  'sub_item_name_trans'=>isset($addon_name_trans)?$addon_name_trans:'',
                                );
                            }
                         }
                      }                 
                      
                      $htm.='</div>';
                                              
                      $x++;
                      $added_item[]=$val['item_id'];  /** fixed addon qty */
                      
                } /*END LOOP FOOD ITEM*/      
                
                                
                $taxable_subtotal=0;                    
                $tax_amt=0;
                
                $tax=$this->getOption('merchant_tax',$mid);
                                
                /*FIXED TAX BASED ON DATA WHEN VIEWING RECEIPT*/
                if($receipt){                                                       
                    if(isset($data['tax_set'])){
                       if($data['tax_set']>0.0001){                     
                           $tax =   $data['tax_set']*100;
                       } else $tax = $data['tax_set'];
                    }
                }
                                
                /*if transaction is pickup*/
                /*if ($data['delivery_type']=="pickup"){
                    $tax=0;
                }*/
                
                $tax_amt=$tax;
                $delivery_charges=$this->getOption('merchant_delivery_charges',$mid);
                $default_fee = $delivery_charges;
                
                /*dump($delivery_charges);
                dump($_SESSION['shipping_fee']);
                dump($subtotal);*/
                
                //shipping rates
                if (isset($_SESSION['shipping_fee'])){
                    if (is_numeric($_SESSION['shipping_fee'])){
                        if($_SESSION['shipping_fee']>0.0001){
                           $delivery_charges=$_SESSION['shipping_fee'];
                        }
                    }
                }

                
                if (!isset($data['delivery_charge'])){
                   /* if(FunctionsV3::isClassDeliveryTableExist()){               
                        if(isset($_SESSION['distance_info'])){
                            if(is_array($_SESSION['distance_info']) && count($_SESSION['distance_info'])>=1){
                               $delivery_charges = DeliveryTableRate::getDeliveryFee(
                               $mid,$subtotal,$default_fee,
                               $_SESSION['distance_info']['distance'],$_SESSION['distance_info']['unit']);
                            }
                        }
                    }*/
                }
                            
                
                if (isset($data['delivery_charge'])){
                    $delivery_charges=$data['delivery_charge'];
                }                   
                
                /*dump("final fee=>".$delivery_charges);
                die();*/
                
                /*EXTRA DELIVERY COST*/
                if (!$receipt){                                 
                    if ($data['delivery_type']=="delivery"){                        
                        $delivery_time = isset($_SESSION['kr_delivery_options']['delivery_time'])?$_SESSION['kr_delivery_options']['delivery_time']:'';  
                        
                        $delivery_date = isset($_SESSION['kr_delivery_options']['delivery_date'])?$_SESSION['kr_delivery_options']['delivery_date']:'';  
                                                
                        if ($this->enabledExtraCharges()){ 
                            $delivery_charges = $this->extraDeliveryFee(
                            $mid,$delivery_charges,
                            $delivery_time,
                            $delivery_date );
                        }
                    }       
                }       
                /*EXTRA DELIVERY COST*/
                
                //end shipping rates
                
                
                /*PACKAGING*/

                if($merchant_packaging_wise==1){                    
                    $merchant_packaging_charge = $wise_packaging_fee;
                } else {
                    $merchant_packaging_charge=$this->getOption('merchant_packaging_charge',$mid); 
                    $merchant_packaging_increment = $this->getOption('merchant_packaging_increment',$mid);
                    if($merchant_packaging_increment==2){
                        if (!isset($data['packaging'])){
                            $total_cart_item=0;                     
                            foreach ($cart_item as $cart_item_x) {                          
                                $total_cart_item+=$cart_item_x['qty'];
                            }                       
                            $merchant_packaging_charge=$total_cart_item*$merchant_packaging_charge;
                        }
                    }           
                }
                
                //fixed packaging charge
                if (isset($data['packaging'])){
                    $merchant_packaging_charge=$data['packaging'];
                }           
                
                if (!empty($delivery_charges)){
                    $delivery_charges=$this->unPrettyPrice($delivery_charges);
                } else $delivery_charges=0;        
                
                /*if transaction is pickup*/
                //dump($data);
                if ($data['delivery_type']=="pickup" || $data['delivery_type']=="dinein"){
                    $delivery_charges=0;
                }           
                
                if ( $data['delivery_type']=="dinein"){                 
                    //$merchant_packaging_charge=0;
                }
                
        
                
                $delivery_charges = (float)$delivery_charges * (float)$exchange_rate;
                $merchant_packaging_charge = (float)$merchant_packaging_charge * (float)$exchange_rate;
                
                                
                /*VOUCHER*/                                                
                $has_voucher=false;
                $less_voucher=0; 
                $voucher_type="";       

                $has_voucher_orig=false;
                $less_voucher_orig=0; 
                
                $pts_redeem_amt_orig=0;
                $pts_redeem_amt_found=false;
                $pts_redeem_amt=0;
                
                $order_infos=array();
                            
                 if (isset($_SESSION['voucher_code'])){                 
                    if (is_array($_SESSION['voucher_code'])){                       
                        $has_voucher=true;
                        //dump($_SESSION['voucher_code']);
                        $_SESSION['voucher_code']['amount']=$this->unPrettyPrice($_SESSION['voucher_code']['amount']);                     
                        if ( $_SESSION['voucher_code']['voucher_type']=="fixed amount" ){
                            $less_voucher=$_SESSION['voucher_code']['amount'];
                        } else {
                            $less_voucher=$subtotal*($_SESSION['voucher_code']['amount']/100);
                            $voucher_type=$this->normalPrettyPrice($_SESSION['voucher_code']['amount'])."%";
                        }            
                        $_SESSION['less_voucher']=$less_voucher;
                    }                
                }             
                
                /*APPMERCHANT CHANGES*/             
                if(!empty($data['voucher_name'])){
                    $has_voucher=true;                  
                    /*$_SESSION['voucher_code']['voucher_type'] = $data['voucher_type'];
                    $_SESSION['voucher_code']['amount'] = $data['voucher_amount'];*/
                    
                    if ( $data['voucher_type']=="fixed amount" ){
                        $less_voucher = $this->unPrettyPrice($data['voucher_amount']);
                        $used_currency = $this->getCurrencyCode();
                        $voucher_type=$used_currency.$this->normalPrettyPrice($data['voucher_amount']);
                    } else {
                        $less_voucher=$subtotal*($data['voucher_amount']/100);
                        $voucher_type=$this->normalPrettyPrice($data['voucher_amount'])."%";
                    }
                }
                      
                if ( $receipt==TRUE){                   
                    $order_ids=isset($data['order_id'])?$data['order_id']:'';
                    if (isset($_GET['id'])){
                        $order_ids=$_GET['id'];
                    }                                   
                    $order_infos=$this->getOrderInfo($order_ids);
                    //dump($order_infos);
                    if (!empty($order_infos['voucher_code'])){
                        $has_voucher=true;
                        if ($order_infos['voucher_type']=="fixed amount"){
                            $less_voucher=$order_infos['voucher_amount'];
                        } else {
                            $voucher_type=$this->normalPrettyPrice((integer)$order_infos['voucher_amount'])."%";
                            $less_voucher=$subtotal*($order_infos['voucher_amount']/100);
                        }                   
                    } else $has_voucher=false;          
                }           
                
                
                /*GET CALCULATION METHOD*/              
                $calculation_method='';
                if($receipt==TRUE){             
                  $calculation_method = $order_infos['calculation_method'];
                } else {
                  $calculation_method = $this->getReceiptCalculationMethod();
                }               
                
                /*VOUCHER*/
                if ( $receipt==TRUE){                   
                    //if ($order_infos['calculation_method']==2){
                    if($calculation_method==2){
                        $has_voucher_orig = $has_voucher;
                        $less_voucher_orig = $less_voucher;
                        $has_voucher=false; 
                        $less_voucher=0; 
                    }
                } else {
                    //if(FunctionsV3::isReceiptCalculationMethodTwo()){
                    if($calculation_method==2){
                        $has_voucher_orig = $has_voucher;
                        $less_voucher_orig = $less_voucher;
                        $has_voucher=false; 
                        $less_voucher=0; 
                    }
                }
                
                $less_voucher = (float)$less_voucher * (float)$exchange_rate;
                $less_voucher_orig = (float)$less_voucher_orig * (float)$exchange_rate;

                if ($less_voucher==TRUE){
                    $subtotal=$subtotal-$less_voucher;
                    
                    /** check if item is taxable*/
                    if ($food_taxable==false){
                        $subtotal_non=$subtotal_non-$less_voucher;
                    }
                }       
                                
                /*PROMO STARTS HERE*/
                $show_discount=false;
                $discounted_amount=0;
                $merchant_discount_amount=0;
                
                $discounted_amount_orig=0;
                $has_discount = false;
                
                
                if(isset($_SESSION['promo_discount'])){
                   unset($_SESSION['promo_discount']);
                }
                
                if ($receipt==TRUE){
                    $_GET['id']=isset($_GET['id'])?$_GET['id']:$new_order_id;
                    if ( $promo_res=$this->getOrderDiscount($_GET['id'])){                      
                        if ( $promo_res['discounted_amount']>=0.0001){
                            
                            //if ($order_infos['calculation_method']==2){
                            if($calculation_method==2){
                                $merchant_discount_amount=$this->formatNumber($promo_res['discount_percentage']);

                                $discounted_amount=$promo_res['discounted_amount'];
                                $has_discount=true;
                            } else {
                                $show_discount=true;
                                $merchant_discount_amount=$this->formatNumber($promo_res['discount_percentage']);
                                $discounted_amount=$promo_res['discounted_amount'];
                                $subtotal=$subtotal-$discounted_amount;
                                
                                /** check if item is taxable*/
                                if ($food_taxable==false){
                                    //$subtotal_non=$subtotal_non-$discounted_amount;
                                }
                            }
                        }
                    }                   
                } else {
                    //if ( $promo_res=Yii::app()->functions->getMerchantOffersActive($mid)){
                    if ( $promo_res=$this->getMerchantOffersActive($mid,$data['delivery_type'])){
                        //dump($promo_res);
                        $offer_continue=true;
                        
                        if(isset($promo_res['applicable_to'])){
                          if (!empty($promo_res['applicable_to'])){
                              if ($promo_res['applicable_to']!="all"){
                                 $applicable_to = json_decode($promo_res['applicable_to'],true);                                 
                                 if(!in_array($data['delivery_type'],(array)$applicable_to)){
                                    $offer_continue=false;
                                 }
                              }
                          } 
                        }
                                            
                        $merchant_spend_amount=$promo_res['offer_price'];

                        $merchant_discount_amount=$promo_res['offer_percentage'];


                        $merchant_discount_amount=$this->normalPrettyPrice($merchant_discount_amount);

                        

                        
                        
                        $merchant_spend_amount = (float)$merchant_spend_amount * (float)$exchange_rate;
                        
                        if($offer_continue){
                            if ( $subtotal>=$merchant_spend_amount){
                                        
                               //if(FunctionsV3::isReceiptCalculationMethodTwo()){
                               if($calculation_method==2){
                                  $merchant_discount_amount1=$merchant_discount_amount/100;
                                  $discounted_amount=$subtotal*$merchant_discount_amount1;
                                  $has_discount=true;
                               } else {                    
                                   $show_discount=true;
                                   $merchant_discount_amount1=floatval($merchant_discount_amount)/100;
                                   $discounted_amount=$subtotal*$merchant_discount_amount1;                 
                                   $subtotal=$subtotal-$discounted_amount;
                                   
                                   $_SESSION['promo_discount']=1;
                                   
                                   /** check if item is taxable*/
                                   if ($food_taxable==false){
                                       //$subtotal_non=$subtotal_non-$discounted_amount;
                                   }
                               }
                               
                            } 
                        }
                        
                    }       
                }   
                
                
                /*dump($discounted_amount);
                dump($merchant_discount_amount);*/
                
                /**above sub total free delivery*/      
                $free_delivery=false;        
                if ( $data['delivery_type']=="delivery"){
                    
                    if(!isset($_GET['backend'])){
                        $free_delivery_above_price = (float)$this->getOption("free_delivery_above_price",$mid);
                        if ($this->isSearchByLocation() && $receipt==false){
                        
                            //$location_data=FunctionsV3::getSearchByLocationData();    

                                 $location_data=false; 
                            if(isset($data['location_data'])){
                                if(is_array($data['location_data']) && count($data['location_data'])>=1){
                                    $location_data = $data['location_data'];
                                }                           
                            }       
                                                        
                            $delivery_fee_resp=$this->getLocationDeliveryFeeWithMinimum(
                              $mid,0,0,$location_data
                            );                                      
                            if($delivery_fee_resp['free_above_subtotal']>0){
                                $free_delivery_above_price = (float)$delivery_fee_resp['free_above_subtotal'];
                            }                       
                        }
                        if($free_delivery_above_price>0){
                            //dump("subtotal=>$subtotal  free_delivery_above_price=>$free_delivery_above_price");
                            if ($subtotal>=$free_delivery_above_price){
                                $delivery_charges=0;
                                $free_delivery=true;
                            }
                        }
                    }                   
                }
                /**above sub total free delivery*/
                
                
              
                
                /*POINTS PROGRAM*/
                     
                            
                    if (isset($_SESSION['pts_redeem_amt']) && $_SESSION['pts_redeem_amt']>0.01){
                        $pts_redeem_amt=$this->unPrettyPrice($_SESSION['pts_redeem_amt']);                                             
                        $pts_redeem_amt = (float)$pts_redeem_amt * (float)$exchange_rate;
                        if($calculation_method==2){
                           $subtotal=$this->unPrettyPrice($subtotal);
                           $pts_redeem_amt_found=true;
                        } else $subtotal=$this->unPrettyPrice($subtotal)-$pts_redeem_amt;
                    } elseif ( isset($data['points_amount'])){
                        
                        $pts_redeem_amt=$this->unPrettyPrice($data['points_amount']);      
                        $pts_redeem_amt = (float)$pts_redeem_amt * (float)$exchange_rate;
                        
                        if($calculation_method==2){
                           $subtotal=$this->unPrettyPrice($subtotal);
                           $pts_redeem_amt_found=true;
                        } else $subtotal=$this->unPrettyPrice($subtotal)-$pts_redeem_amt;
                        
                    } else {
                        if ($receipt==TRUE){                    
                            if (isset($data['points_discount']) && $data['points_discount']>0){
                               $pts_redeem_amt=$this->unPrettyPrice($data['points_discount']);                            
                               $pts_redeem_amt = (float)$pts_redeem_amt * (float)$exchange_rate;
                               
                               if($calculation_method==2){
                                  $subtotal=$this->unPrettyPrice($subtotal);
                                  $pts_redeem_amt_found=true;
                               } else $subtotal=$this->unPrettyPrice($subtotal)-$pts_redeem_amt;                              
                            }           
                        }       
                    }
                
                               
                
                $service_fee = isset($data['service_fee'])?(float)$data['service_fee']:0;                   
                $service_fee_taxable = isset($data['service_fee'])?(float)$data['service_fee']:0;
                
                $service_fee  = (float)$service_fee * (float)$exchange_rate;
                $service_fee_taxable  = (float)$service_fee_taxable * (float)$exchange_rate;
                                
                if(isset($data['service_fee_applytax'])){
                    if(!$data['service_fee_applytax']){
                        $service_fee_taxable = 0;
                    }                   
                }               
                    
                 
                if ( !empty($tax)){
                    $tax=$tax/100;
                    
                    /** check if item is taxable*/    
                    $temp_delivery_charges=$delivery_charges;                           
                    if ($this->getOption("merchant_tax_charges",$mid)==2){
                        $temp_delivery_charges=0;                       
                    }  
                                    
                    if ($receipt==true){                        
                        if (isset($data['donot_apply_tax_delivery'])){
                            if ($data['donot_apply_tax_delivery']==2){
                                $temp_delivery_charges=0;                               
                            } else $temp_delivery_charges=$delivery_charges;
                        }                       
                    }

                    if (!isset($subtotal_non)){
                        $subtotal_non=0;
                    }          
                    
                                                                                            
                    /*FIXED TAX ISSUE*/
                    if ($subtotal_non>=0.0001){                     
                        $temp_subtotal=$subtotal-$subtotal_non;                             
                        if($temp_subtotal>0){                           
                           $taxable_subtotal=($temp_subtotal+$temp_delivery_charges+$merchant_packaging_charge+$service_fee_taxable)*$tax;
                        } else {                    
                           if($merchant_packaging_charge>0 && $merchant_packaging_charge>0){                            
                              $taxable_subtotal=($temp_delivery_charges+$merchant_packaging_charge+$service_fee_taxable)*$tax;                         
                           }
                        }
                    } else {                        
                        $taxable_subtotal=( (float)$subtotal+ (float)$temp_delivery_charges + (float)$merchant_packaging_charge + (float) $service_fee_taxable )*$tax;    
                    }
                                        
                    
                    /*dump($temp_delivery_charges."=>".$merchant_packaging_charge);
                    dump($subtotal);
                    dump($subtotal_non);
                    dump("taxable_subtotal=>".$taxable_subtotal);*/
                }           
                
                
                //$htm.="TAXABLE=>$taxable_subtotal <br/>";
                
                                            
                $total=(float)$subtotal + (float)$taxable_subtotal + (float)$delivery_charges + (float)$merchant_packaging_charge + (float) $service_fee;
                
                
                /*VOUCHER*/
                                
                $htm.='<div class="summary-wrap" style="display:none;">';
                
                 if ( $has_voucher==TRUE){       

                     if ( $show_discount==true):                                        
                       $htm.=$this->receiptRowTotal( ("Discount")." $merchant_discount_amount%" ,
                       self::formatNumber($discounted_amount)
                       );
                     endif;
                                         
                                         
                     if ($receipt==TRUE){
                        $voucher_code=" - ".$order_infos['voucher_code']."";
                     } else $voucher_code='';
                                         
                     $htm.=$this->receiptRowTotal( $this->translation("default","Less Voucher")." ".$voucher_type ,
                     "(". self::formatNumber($less_voucher) .")" 
                     );          
                     
                                            
                         $pts_redeem_amt_orig = $pts_redeem_amt;
                         if($receipt==TRUE){                            
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         } else {                           
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         }
                         if($pts_redeem_amt>0){
                             $htm.=$this->receiptRowTotal('Points Discount',
                             "(".self::formatNumber($pts_redeem_amt).")" );  
                         }  
                     
                                         
                     $htm.=$this->receiptRowTotal("Sub Total", self::formatNumber($subtotal) );
                                    
                 } else {                    
                    
                     if ( $show_discount==true):                     
                     $htm.=$this->receiptRowTotal( ("Discount")." $merchant_discount_amount%",
                       "(". self::formatNumber($discounted_amount) .")"
                      );
                     endif;
                                     
                     /*POINTS PROGRAM*/         
                         
                                   
                         
                         $pts_redeem_amt_orig = $pts_redeem_amt;
                         
                         if($receipt==TRUE){
                            //if ($order_infos['calculation_method']==2){
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         } else {
                            //if(FunctionsV3::isReceiptCalculationMethodTwo()){
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         }
                                
                         if($pts_redeem_amt>0){
                             $htm.=$this->receiptRowTotal('Points Discount',
                             "(".self::formatNumber($pts_redeem_amt).")" );  
                         }  
                     
                                         
                    $htm.=$this->receiptRowTotal('Sub Total',
                    self::formatNumber($subtotal) ,'','cart_subtotal' );
                    
                 }          
                 
                 
                 if(isset($data['service_fee'])){
                     if($data['service_fee']>0){
                        $htm.=$this->receiptRowTotal('Service Fee',
                        self::formatNumber(  $data['service_fee'] * $exchange_rate )
                        );
                     }
                 }
                                 
                 if (!empty($delivery_charges)){
                    $htm.=$this->receiptRowTotal('Delivery Fee',
                    self::formatNumber($delivery_charges)
                    );
                 }               
                 
                 if ( $free_delivery==true){                     
                     $htm.=$this->receiptRowTotal("Delivery Fee", "Free" );
                 }
                 
                 if (!empty($merchant_packaging_charge)){       
                   if($merchant_packaging_charge>=0.001){         
                       $htm.=$this->receiptRowTotal("Packaging",
                         self::formatNumber($merchant_packaging_charge)                       
                       );
                   }
                 }
                                                         
                 if ( !empty($tax)){                 
                     if($taxable_subtotal>0.0001){    
                         $htm.=$this->receiptRowTotal( "Tax"." $tax_amt%" ,
                          self::formatNumber($taxable_subtotal)
                         );
                     }
                 }

                 /*TIPS*/
                 if (isset($data['cart_tip_percentage'])){
                    if(strlen($data['cart_tip_percentage'])>=0.0001){
                        $data['tip_enabled']=2;
                        $data['tip_percent']=$data['cart_tip_percentage'];
                    }
                 }
                                 
                 if (isset($data['tip_enabled'])){                  
                    if ($data['tip_enabled']==2 && $data['tip_percent']>=0.0001){                                           
                        $data['cart_tip_value'] =  $subtotal * $data['tip_percent'];                        
                        
                        $data['cart_tip_percentage']=$data['tip_percent']*100;
                        
                        $t_cart_tip_percentage = explode(".",$data['cart_tip_percentage']);                                      
                        $tip_decimal_places = 0;
                        if(count($t_cart_tip_percentage)>=2){
                            $tip_decimal_places = 2;
                        }
                        
                        $htm.=$this->receiptRowTotal( ("Tips")." ".number_format($data['cart_tip_percentage'],$tip_decimal_places)."%" ,
                          self::formatNumber($data['cart_tip_value'])
                        );                 
                        
                                                
                        $data['cart_tip_percentage']  = number_format($data['cart_tip_percentage'],$tip_decimal_places,'.','');  


                             
                        $total+=$data['cart_tip_value'];                        
                    }
                 }
                                 
                 
                 /*CARD FEE*/                            
                 if (isset($data['card_fee']) || isset($data['card_percentage'])){                  
                     $fee = isset($data['card_fee'])?(float)$data['card_fee']:0;          
                     $card_percentage = isset($data['card_percentage'])?(float)$data['card_percentage']:0;                   
                     //dump("$card_percentage=>$fee");                   
                     if($fee>0 || $card_percentage>0){
                         if($card_percentage>0){                            
                            $card_fees = (float)$total*((float)$data['card_percentage']/100);                           
                         }                  
                         if($fee>0){
                            $card_fees+=(float)$data['card_fee'];
                         }
                         
                         $card_fees = (float)$card_fees * (float)$exchange_rate;
                         
                         $htm.=$this->receiptRowTotal("Card Fee", self::formatNumber($card_fees) );

                         if($receipt){
                          $total+=(float)$card_fees;
                         }
                         
                     }                   
                 }          

                 //dump($card_fees);                      
               
               /*VOUCHER*/
               if($has_voucher_orig){
                 $htm.=$this->receiptRowTotal(("Voucher"), "(".self::formatNumber($less_voucher_orig).")" );  
                 $total=$this->unPrettyPrice($total)-$this->unPrettyPrice($less_voucher_orig);
               }
               
               
               /*POINTS PROGRAM*/
                                  
                   if($pts_redeem_amt_found){
                      $htm.=$this->receiptRowTotal(("Points Discount"), "(".self::formatNumber($pts_redeem_amt_orig).")" );  
                      $total=$this->unPrettyPrice($total)-$this->unPrettyPrice($pts_redeem_amt_orig);
                      
                   }
               
               
               /*DISCOUNT*/
               if($has_discount){
                  $htm.=$this->receiptRowTotal( ("Discount")." $merchant_discount_amount%",
                       "(". self::formatNumber($discounted_amount) .")"
                      );
                  $total=$this->unPrettyPrice($total)-$this->unPrettyPrice($discounted_amount);
               }
                                           
               $htm.="<div class=\"row cart_total_wrap bold\">";
               $htm.="<div class=\"col-md-6 col-xs-6  text-right\">".("Total")."</div>";
               $htm.="<div class=\"col-md-6 col-xs-6  text-right cart_total\">".               
               self::formatNumber($total) ."</div>";
               $htm.="</div>";
               

               /*POINTS PROGRAM*/
                                                
                  $htm.=$this->PointsProgram->cartTotalEarnPoints($cart_item,$receipt,$subtotal,$mid);
               
               
               if(!isset($pts_redeem_amt)){
                  $pts_redeem_amt=0;
               }
               $htm .= '<input type="hidden" name="subtotal_order" id="subtotal_order" value="' . htmlspecialchars($this->unPrettyPrice($subtotal + $less_voucher + $pts_redeem_amt), ENT_QUOTES, 'UTF-8') . '" />';
              $htm .= '<input type="hidden" name="subtotal_order2" id="subtotal_order2" value="' . htmlspecialchars($this->unPrettyPrice($subtotal), ENT_QUOTES, 'UTF-8') . '" />';
              $htm .= '<input type="hidden" name="subtotal_extra_charge" id="subtotal_extra_charge" value="' . htmlspecialchars($this->unPrettyPrice((float)$delivery_charges + (float)$merchant_packaging_charge + (float)$taxable_subtotal), ENT_QUOTES, 'UTF-8') . '" />';
                $htm.="</div>";
               
               if(!isset($data['cart_tip_percentage'])){
                   $data['cart_tip_percentage']='';
               }
               
               $tips_decimal_places = $this->getOptionAdmin('admin_decimal_place');               
               if(empty($tips_decimal_places)){             
                  $tips_decimal_places=2;
               }               
               
               //dump($data['cart_tip_percentage']);
               // array value
               
               if(!isset($data['cart_tip_percentage'])){
                   $data['cart_tip_percentage']='';
               }
               if($tax>0){
               $tasxa=$this->normalPrettyPrice($tax*100).'%';
                $tax_label="TaxABC1 ".$tasxa;
               }else{$tax_label="";}

               $used_currency = $this->getCurrencyCode();

               //$data['cart_tip_percentage']=15;

               $item_array_total=array(
                 'subtotal'=>round($subtotal,2),
                 'taxable_total'=>round($taxable_subtotal,2),
                 'delivery_charges'=>$delivery_charges,
                 'total'=>round($total,2),               
                 'tax'=>$tax,
                 'tax_amt'=>$tax_amt,
                 'tax_label'=>$tax_label,
                 'curr'=>$used_currency,
                 'mid'=>$mid,
                 'discounted_amount'=>$discounted_amount,
				 'merchant_discount_amount' => round(floatval($merchant_discount_amount), 2),
                 'merchant_packaging_charge'=>$merchant_packaging_charge,
                 'less_voucher'=>$less_voucher,
                 'voucher_type'=>$voucher_type,
                 /*'tips'=>isset($data['cart_tip_value'])?$data['cart_tip_value']:'',
                 'tips_percent'=>$data['cart_tip_percentage']>0.1?number_format($data['cart_tip_percentage'],0)."%":'',
                 'cart_tip_percentage'=>$data['cart_tip_percentage']>0.1?number_format($data['cart_tip_percentage']):'',*/
                 'tips'=>$data['cart_tip_percentage']>0.1?self::formatNumber($data['cart_tip_value'],$tips_decimal_places):'',                
                 'tips_percent'=>$data['cart_tip_percentage']>0.1?$data['cart_tip_percentage']."%":'',               
                 'cart_tip_percentage'=>$data['cart_tip_percentage']>0.1?($data['cart_tip_percentage']):'',
                 'pts_redeem_amt'=>isset($pts_redeem_amt)?$pts_redeem_amt:'',
                 'voucher_value'=>isset($_SESSION['voucher_code']['amount'])?$_SESSION['voucher_code']['amount']:'',
                 'voucher_types'=>isset($_SESSION['voucher_code']['voucher_type'])?$_SESSION['voucher_code']['voucher_type']:'',
                 
                 'calculation_method'=>$calculation_method,
                 'pts_redeem_amt_orig'=>$pts_redeem_amt_orig,
                 'less_voucher_orig'=>$less_voucher_orig,                
                 'service_fee'=>isset($service_fee)?(float)$service_fee:0
               );   

                           
                           
               if ($receipt){                 
                  $item_array_total['voucher_value']=isset($data['voucher_amount'])?$data['voucher_amount']:0;
                  $item_array_total['voucher_types']=isset($data['voucher_type'])?$data['voucher_type']:'';
               }
               
               if (isset($data['card_fee']) || isset($data['card_percentage']) ){
                   if($card_fees>0){
                       $item_array_total['card_fee']=$card_fees;
                   }
               }


               //print_r($item_array_total);die();

               
               //dump($data);
               /*header('Content-Type: text/html; charset=utf-8');
               echo $htm;*/
               

               if($_REQUEST['debug']){print_r($item_array);}
               
               
                            
                $this->code=1;
                $this->msg="OK";

                $this->details=array(
                  'item-count'=>$x,
                  'code'=>1,
                  'msg'=>"OK",
                  'html'=>$htm,
                  'raw'=>array('item'=>$item_array,'total'=>$item_array_total)
                );


    // Returning the details array
    return $this->details;
            } else $this->msg=$this->translation("default","No Item added yet!");
        } else $this->msg=$this->translation("default","No Item added yet!");
    }

    public  function receiptTableRow($label='',$value='')
    {
      ?>
      <tr>
         <td><?php echo $this->translation("default",$label)?></td>
         <td class="text-right"><?php echo $value?></td>
        </tr>
      <?php
    }




     public function displayOrderHTML_bkupbywas($data='',$cart_item='',$receipt=false,$new_order_id='')
    {
        $item_array=array();
        $this->code=2;
        $htm='';    
        $subtotal=0;
        $subtotal_non=0;
        $mid=isset($data['merchant_id'])?$data['merchant_id']:'';   

                
        if (empty($mid)){
            $this->msg=$this->translation("default","Merchant ID is empty");
            return ;
        }   
                            
        //Yii::app()->functions->data="list";
        $food_item=$this->getFoodItemLists($mid);
        $subcat_list=$this->getAddOnLists($mid);       
        
        $merchant_packaging_wise = $this->getOption($mid,'merchant_packaging_wise');
        $wise_packaging_fee = 0;
        $merchant_packaging_charge = 0;
        $card_fees = 0;
        
        $exchange_rate = isset($data['exchange_rate']) ? (float)$data['exchange_rate'] : 1;
                                           
        if (isset($cart_item)){
            if (is_array($cart_item) && count($cart_item)>=1){
                $x=0;
                foreach ($cart_item as $key=>$val) {        
                    
                    //dump($val);               
                    
                    $val['notes']=isset($val['notes'])?$val['notes']:"";
                    
                    $size_words=''; $_size_id=0;
                    $t=!empty($val['price'])?explode("|",$val['price']):'';                 
                    if (is_array($t) && count($t)>=1){
                        $val['price']=$t[0];
                        if (isset($t[1])){
                            $size_words=$t[1];
                            $_size_id=isset($t[2])?(integer)$t[2]:0;  // inventory new code
                        } else $size_words='';                  
                    }
                    
                    $price=$this->cleanNumber($this->unPrettyPrice($val['price']));
                    
                    if (!empty($val['discount'])){
                        $val['discount']=$this->unPrettyPrice($val['discount']);
                        $price=$price-$val['discount'];
                    }           
                    
                    $price = (float) $price * $exchange_rate;
                    
                    $qty=$val['qty'];  /** fixed addon qty */                   
                    $total_price=$val['qty']*(float)$price;
                                
                    /** check if item is taxable*/
                    //dump($val);
                    $food_taxable=true;                                     
                    if (isset($val['non_taxable'])){
                        if ( $val['non_taxable']==2){
                            $food_taxable=false;
                        }   
                    }           
                                                                            
                    $subtotal=$subtotal+$total_price; 
                    
                    if ($food_taxable==false){
                        //dump($total_price);
                        $subtotal_non=$subtotal_non+$total_price;                       
                    }           
                    
                    /*$size_words='';
                    if ( $price_size=explodeData($val['price'])){                           
                        if (isset($price_size[1])){
                            $size_words=$price_size[1];
                        }
                    }   */                                      
                    
                    /** Translation */
                    $food_infos=array(); $food_info = array();
                    $size_info_trans='';
                    $cooking_ref_trans='';
                    if ($this->getOptionAdmin("enabled_multiple_translation")==2){
                        $food_info=$this->getFoodItem($val['item_id']);
                        $food_infos['item_name_trans']=!empty($food_info['item_name_trans'])?json_decode($food_info['item_name_trans'],true):'';        
                                                
                        if (!empty($size_words)){
                            $size_info_trans=$this->getSizeTranslation($size_words,$mid);
                        }               

                        if(!empty($val['cooking_ref'])){                            
                            $cooking_ref_trans=$this->getCookingTranslation($val['cooking_ref'],$mid);
                        }   
                    } else $food_info=$this->getFoodItem($val['item_id']);
                    
                    
                    /*GET PACKAGING CHARGE*/
                    if($merchant_packaging_wise==1){ 
                       if(isset($food_info['packaging_fee'])){
                           if($food_info['packaging_fee']>0){
                               if ($food_info['packaging_incremental']==1){
                                  $wise_packaging_fee+= $food_info['packaging_fee']*$qty;
                               } else {                             
                                   $wise_packaging_fee+= $food_info['packaging_fee'];
                               }
                           }
                       }
                    }
                    
                    /*dump($food_item);
                    dump($val['item_id']);*/  

                    
                    $htm.='<div class="item-order-list item-row">';
                                          
                      $val['category_id']=isset($val['category_id'])?$val['category_id']:'';
                      
                      if ($res_category=$this->getCategory($val['category_id'])){                         
                          $category_name_trans['category_name_trans']=!empty($res_category['category_name_trans'])?
                          json_decode($res_category['category_name_trans'],true):false; 
                                                                  
                          $htm.="<p style=\"margin:0;\"><b>".$this->qTranslate($res_category['category_name'],
                          'category_name',$category_name_trans)."</b></p>";
                      } 
                      
                      //dump($htm);
                                    

                    if($val['variable_price']>0){
                    $htm.='<div class="a" style="width:60px">'.$val['qty'].' x'.$val['variable_price'].'</div>';                    
                }else{
                    $htm.='<div class="a">'.$val['qty'].'</div>';
                }
                                    
                      
                      $htm.='<div class="b">'.$this->qTranslate(
                      isset($food_item[$val['item_id']])?$food_item[$val['item_id']]:''
                      ,'item_name',$food_infos);
                      if (!empty($size_words)){
                         $htm.="(".$this->qTranslate($size_words,'size_name',$size_info_trans).")";
                      }
                      
                      //dump($val);
                      
                      $_category_name = isset($res_category['category_name_trans'])?$res_category['category_name']:'';
                      
                      // array value
                      $item_array[$key]=array(
                        'item_id'=>$val['item_id'],
                        'item_name'=>isset($food_item[$val['item_id']])?$food_item[$val['item_id']]:'',
                        'size_words'=>$size_words,
                        'size_id'=>$_size_id, // inventory
                        'qty'=>$val['qty'],
                        
                        'is_printed'=>$val['is_printed'],
                        'is_printed_already'=>$val['is_printed_already'],
                        'variable_price'=>$val['variable_price'],
                        //'normal_price'=>prettyFormat($val['price']),
                        'normal_price'=> (float)$val['price'] *  (float)$exchange_rate  ,
                        'discounted_price'=>$price,
                        'discount'=>$val['discount'],
                        
                        /* Custom code 13 starts */
                        'promo_id'=>$val['promo_id'],
                        /* Custom code 13 Ends */
                        
                        'order_notes'=>isset($val['notes'])?$val['notes']:'',
                        'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
                        'ingredients'=>isset($val['ingredients'])?$val['ingredients']:'',
                        'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1,
                        'category_id'=>isset($val['category_id'])?$val['category_id']:'',
                        'category_name'=>!empty($_category_name)?$_category_name:$res_category['category_name'],
                        'category_name_trans'=>isset($category_name_trans)?$category_name_trans:'',                     
                        'item_name_trans'=>isset($food_infos)?$food_infos:'',
                        'size_name_trans'=>isset($size_info_trans)?$size_info_trans:'',
                        'cooking_name_trans'=>isset($cooking_ref_trans)?$cooking_ref_trans:'',                                                                      
                      );                                         
                      
                      $htm.=$this->displaySpicyIconByID($val['item_id']);
                      
                      if (!empty($val['discount'])){
                          $htm.="<p class=\"uk-text-small\">".
                          "<span class=\"normal-price\">". self::formatNumber( ((float)$val['price']*$exchange_rate) ) ." </span>".
                          "<span class=\"sale-price\">". self::formatNumber($price) ."</span>"
                          ."</p>";      
                                          
                      } else {
                        
                        $htm.="<p class=\"uk-text-small\">".                          
                          "<span class=\"base-price\">". self::formatNumber($price) ."</span>"
                          ."</p>";                        
                      }
                      
                      /*Custom code 13 starts */
                      if($val['promo_id']>0){
                      $htm.="<p class=\"small\" style='margin: 0px;color:red'>Promo ID :".$val['promo_id']."</p>";  
                      }
                      /*Custom code 13 Ends */
                      
                      if (!empty($val['cooking_ref'])){
                          $htm.="<p class=\"small\">".
                          $this->qTranslate($val['cooking_ref'],'cooking_name',$cooking_ref_trans)."</p>";
                      }                 
                      if (!empty($val['notes'])){
                          $htm.="<p class=\"small text-info\">".$val['notes']."</p>";
                      }                       
                                         
                      /*ingredients*/                     
                      if (isset($val['ingredients'])){
                        if (!empty($val['ingredients'])){
                            if (is_array($val['ingredients']) && count($val['ingredients'])>=1){
                                $htm.="<p class=\"small ingredients-label\">".t("Ingredients").":</p>";
                                foreach ($val['ingredients'] as $val_ingred) {      
                                                                       
                                   if($details_ingredients=$this->getIngredientsByName($val_ingred,$mid)){
                                      $_ingredients['ingredients_name_trans']=json_decode($details_ingredients['ingredients_name_trans'],true);                                   
                                      $htm.="<p class=\"small\">".
                                      $this->qTranslate($val_ingred,'ingredients_name',$_ingredients)
                                      ."</p>";
                                   } else $htm.="<p class=\"small\">".$val_ingred."</p>";
                                }   
                            }
                        }   
                      }
                      
                      $htm.='</div>';
                      
                      $htm.='<div class="manage">';
                        $htm.='<div class="c">';
                        
                         if ( $receipt==false):
                         $htm.='<a href="javascript:;" class="edit_item" data-row="'.$key.'" rel="'.$val['item_id'].'" >
                                    <i class="ion-compose"></i>
                                 </a>';
                          $htm.='<a href="javascript:;" class="delete_item" data-row="'.$key.'" rel="'.$val['item_id'].'" >
                                   <i class="ion-trash-a"></i>
                                </a>';
                         endif;
                         
                         
                        $htm.='</div>';
                         $htm.='<div class="d">'. self::formatNumber($total_price) .'</div>';
                      $htm.='</div>';
                      $htm.='<div class="clear"></div>';
                      
                      /*SUB ITEM*/
                      //dump($val);                   
                      //$item_array[$key]['sub_item']=$val['sub_item'];
                      $val['sub_item']=isset($val['sub_item'])?$val['sub_item']:'';
                      //dump($val['sub_item']);
                      //$val['sub_item']='';
                      
                      if (is_array($val['sub_item']) && count($val['sub_item'])>=1){
                         foreach ($val['sub_item'] as $cat_id=>$val_sub) {                              
                            
                            if (array_key_exists($cat_id,(array)$subcat_list)){     
                                
                                //** Translation */
                                $subcategory_trans=array();
                                if ($this->getOptionAdmin("enabled_multiple_translation")==2){
                                    if($subcategory_tran=$this->getAddonCategory($cat_id)){
                                        $subcategory_trans['subcategory_name_trans']=!empty($subcategory_tran['subcategory_name_trans'])?json_decode($subcategory_tran['subcategory_name_trans'],true):'';
                                    }                                                                   
                                }
                            
                                $htm.='<div class="a"></div>';
                                $htm.='<div class="b uk-text-success">'.
                                $this->qTranslate($subcat_list[$cat_id],'subcategory_name',
                                $subcategory_trans).'</div>';  
                                $htm.='<div class="clear"></div>';
                            }
                                                                                                                
                            $addon_qty=1;                               
                            foreach ($val_sub as $addon_row=> $val_subs) {
                                                                
                                if (isset( $val['addon_qty'][$cat_id] )){                                       
                                    $addon_qty=$val['addon_qty'][$cat_id][$addon_row];
                                } else {
                                     $addon_qty=$qty; /** fixed addon qty */
                                     /*if ( in_array($val['item_id'],(array)$added_item)){
                                        $addon_qty=0;
                                     }*/
                                }                           
                                                                
                                $val_subs=explodeData($val_subs);
                                
                                //dump($val_subs);
                                $addon_raw_price=$this->prettyFormat($val_subs[1]);
                                $addon_item_price= $this->unPrettyPrice($val_subs[1]);
                                $addon_item_price=(integer)$addon_qty*$addon_item_price;
                                
                                $addon_raw_price = (float)$addon_raw_price* (float)$exchange_rate;
                                $addon_item_price = (float)$addon_item_price* (float)$exchange_rate;
                                
                                
                                /** two flavor */
                                if (!isset($val['two_flavors'])){
                                    $val['two_flavors']='';
                                }
                                if ( $val['two_flavors']==2){
                                    if ( $val_subs[3]==""){
                                       $subtotal+=$addon_item_price;    
                                       if ($food_taxable==false){
                                           $subtotal_non+=$addon_item_price;
                                       }
                                    }
                                } else {        
                                     /** check if item is taxable*/
                                     $subtotal+=$addon_item_price;
                                     if ($food_taxable==false){
                                         $subtotal_non+=$addon_item_price;
                                     }
                                }
                                
                                $item_array[$key]['sub_item'][]=array(
                                  'addon_name'=>$val_subs[2],
                                  'addon_category'=>$subcat_list[$cat_id],
                                  'addon_qty'=>$addon_qty,
                                  //'addon_price'=>$addon_item_price
                                  'addon_price'=>$this->unPrettyPrice($val_subs[1]),
                                  'sub_item_id'=>$this->unPrettyPrice($val_subs[0]), // inventory new code,
                                  'subcat_id'=>$cat_id // inventory new code,
                                );
                                                                
                                /**translation */
                                $addon_name_trans='';
                                if ($this->getOptionAdmin("enabled_multiple_translation")==2){
                                    $addon_name_trans=$this->getAddonTranslation($val_subs[2],$mid);
                                }
                                                                                                                        
                                $htm.='<div class="a">'.$addon_qty.'x</div>';
$htm.='<div class="b uk-text-muted">'. self::formatNumber($addon_raw_price) ." ".qTranslate($val_subs[2],
'sub_item_name',$addon_name_trans).'</div>';
                                  $htm.='<div class="manage">';                                      
                                     if ( $addon_item_price!=0){
                                     $htm.='<div class="d">'. self::formatNumber($addon_item_price) .'</div>';
                                     } else $htm.='<div class="d">-</div>';
                                  $htm.='</div>';
                                $htm.='<div class="clear"></div>';
                                
                                /*changes for driver app*/
                                $item_array[$key]['new_sub_item'][$subcat_list[$cat_id]][]=array(
                                  'addon_name'=>$val_subs[2],
                                  'addon_category'=>$subcat_list[$cat_id],
                                  'addon_qty'=>$addon_qty,                                
                                  'addon_price'=>$this->unPrettyPrice($val_subs[1]),
                                  'subcategory_name_trans'=>isset($subcategory_trans)?$subcategory_trans:'',
                                  'sub_item_name_trans'=>isset($addon_name_trans)?$addon_name_trans:'',
                                );
                            }
                         }
                      }                 
                      
                      $htm.='</div>';
                                              
                      $x++;
                      $added_item[]=$val['item_id'];  /** fixed addon qty */
                      
                } /*END LOOP FOOD ITEM*/      
                
                                
                $taxable_subtotal=0;                    
                $tax_amt=0;
                
                $tax=$this->getOption('merchant_tax',$mid);
                                
                /*FIXED TAX BASED ON DATA WHEN VIEWING RECEIPT*/
                if($receipt){                                                       
                    if(isset($data['tax_set'])){
                       if($data['tax_set']>0.0001){                     
                           $tax =   $data['tax_set']*100;
                       } else $tax = $data['tax_set'];
                    }
                }
                                
                /*if transaction is pickup*/
                /*if ($data['delivery_type']=="pickup"){
                    $tax=0;
                }*/
                
                $tax_amt=$tax;
                $delivery_charges=$this->getOption('merchant_delivery_charges',$mid);
                $default_fee = $delivery_charges;
                
                /*dump($delivery_charges);
                dump($_SESSION['shipping_fee']);
                dump($subtotal);*/
                
                //shipping rates
                if (isset($_SESSION['shipping_fee'])){
                    if (is_numeric($_SESSION['shipping_fee'])){
                        if($_SESSION['shipping_fee']>0.0001){
                           $delivery_charges=$_SESSION['shipping_fee'];
                        }
                    }
                }

                
                if (!isset($data['delivery_charge'])){
                   /* if(FunctionsV3::isClassDeliveryTableExist()){               
                        if(isset($_SESSION['distance_info'])){
                            if(is_array($_SESSION['distance_info']) && count($_SESSION['distance_info'])>=1){
                               $delivery_charges = DeliveryTableRate::getDeliveryFee(
                               $mid,$subtotal,$default_fee,
                               $_SESSION['distance_info']['distance'],$_SESSION['distance_info']['unit']);
                            }
                        }
                    }*/
                }
                            
                
                if (isset($data['delivery_charge'])){
                    $delivery_charges=$data['delivery_charge'];
                }                   
                
                /*dump("final fee=>".$delivery_charges);
                die();*/
                
                /*EXTRA DELIVERY COST*/
                if (!$receipt){                                 
                    if ($data['delivery_type']=="delivery"){                        
                        $delivery_time = isset($_SESSION['kr_delivery_options']['delivery_time'])?$_SESSION['kr_delivery_options']['delivery_time']:'';  
                        
                        $delivery_date = isset($_SESSION['kr_delivery_options']['delivery_date'])?$_SESSION['kr_delivery_options']['delivery_date']:'';  
                                                
                        if ($this->enabledExtraCharges()){ 
                            $delivery_charges = $this->extraDeliveryFee(
                            $mid,$delivery_charges,
                            $delivery_time,
                            $delivery_date );
                        }
                    }       
                }       
                /*EXTRA DELIVERY COST*/
                
                //end shipping rates
                
                
                /*PACKAGING*/

                if($merchant_packaging_wise==1){                    
                    $merchant_packaging_charge = $wise_packaging_fee;
                } else {
                    $merchant_packaging_charge=$this->getOption('merchant_packaging_charge',$mid); 
                    $merchant_packaging_increment = $this->getOption('merchant_packaging_increment',$mid);
                    if($merchant_packaging_increment==2){
                        if (!isset($data['packaging'])){
                            $total_cart_item=0;                     
                            foreach ($cart_item as $cart_item_x) {                          
                                $total_cart_item+=$cart_item_x['qty'];
                            }                       
                            $merchant_packaging_charge=$total_cart_item*$merchant_packaging_charge;
                        }
                    }           
                }
                
                //fixed packaging charge
                if (isset($data['packaging'])){
                    $merchant_packaging_charge=$data['packaging'];
                }           
                
                if (!empty($delivery_charges)){
                    $delivery_charges=$this->unPrettyPrice($delivery_charges);
                } else $delivery_charges=0;        
                
                /*if transaction is pickup*/
                //dump($data);
                if ($data['delivery_type']=="pickup" || $data['delivery_type']=="dinein"){
                    $delivery_charges=0;
                }           
                
                if ( $data['delivery_type']=="dinein"){                 
                    //$merchant_packaging_charge=0;
                }
                
        
                
                $delivery_charges = (float)$delivery_charges * (float)$exchange_rate;
                $merchant_packaging_charge = (float)$merchant_packaging_charge * (float)$exchange_rate;
                
                                
                /*VOUCHER*/                                                
                $has_voucher=false;
                $less_voucher=0; 
                $voucher_type="";       

                $has_voucher_orig=false;
                $less_voucher_orig=0; 
                
                $pts_redeem_amt_orig=0;
                $pts_redeem_amt_found=false;
                $pts_redeem_amt=0;
                
                $order_infos=array();
                            
                 if (isset($_SESSION['voucher_code'])){                 
                    if (is_array($_SESSION['voucher_code'])){                       
                        $has_voucher=true;
                        //dump($_SESSION['voucher_code']);
                        $_SESSION['voucher_code']['amount']=$this->unPrettyPrice($_SESSION['voucher_code']['amount']);                     
                        if ( $_SESSION['voucher_code']['voucher_type']=="fixed amount" ){
                            $less_voucher=$_SESSION['voucher_code']['amount'];
                        } else {
                            $less_voucher=$subtotal*($_SESSION['voucher_code']['amount']/100);
                            $voucher_type=$this->normalPrettyPrice($_SESSION['voucher_code']['amount'])."%";
                        }            
                        $_SESSION['less_voucher']=$less_voucher;
                    }                
                }             
                
                /*APPMERCHANT CHANGES*/             
                if(!empty($data['voucher_name'])){
                    $has_voucher=true;                  
                    /*$_SESSION['voucher_code']['voucher_type'] = $data['voucher_type'];
                    $_SESSION['voucher_code']['amount'] = $data['voucher_amount'];*/
                    
                    if ( $data['voucher_type']=="fixed amount" ){
                        $less_voucher = $this->unPrettyPrice($data['voucher_amount']);
                        $used_currency = $this->getCurrencyCode();
                        $voucher_type=$used_currency.$this->normalPrettyPrice($data['voucher_amount']);
                    } else {
                        $less_voucher=$subtotal*($data['voucher_amount']/100);
                        $voucher_type=$this->normalPrettyPrice($data['voucher_amount'])."%";
                    }
                }
                      
                if ( $receipt==TRUE){                   
                    $order_ids=isset($data['order_id'])?$data['order_id']:'';
                    if (isset($_GET['id'])){
                        $order_ids=$_GET['id'];
                    }                                   
                    $order_infos=$this->getOrderInfo($order_ids);
                    //dump($order_infos);
                    if (!empty($order_infos['voucher_code'])){
                        $has_voucher=true;
                        if ($order_infos['voucher_type']=="fixed amount"){
                            $less_voucher=$order_infos['voucher_amount'];
                        } else {
                            $voucher_type=$this->normalPrettyPrice((integer)$order_infos['voucher_amount'])."%";
                            $less_voucher=$subtotal*($order_infos['voucher_amount']/100);
                        }                   
                    } else $has_voucher=false;          
                }           
                
                
                /*GET CALCULATION METHOD*/              
                $calculation_method='';
                if($receipt==TRUE){             
                  $calculation_method = $order_infos['calculation_method'];
                } else {
                  $calculation_method = $this->getReceiptCalculationMethod();
                }               
                
                /*VOUCHER*/
                if ( $receipt==TRUE){                   
                    //if ($order_infos['calculation_method']==2){
                    if($calculation_method==2){
                        $has_voucher_orig = $has_voucher;
                        $less_voucher_orig = $less_voucher;
                        $has_voucher=false; 
                        $less_voucher=0; 
                    }
                } else {
                    //if(FunctionsV3::isReceiptCalculationMethodTwo()){
                    if($calculation_method==2){
                        $has_voucher_orig = $has_voucher;
                        $less_voucher_orig = $less_voucher;
                        $has_voucher=false; 
                        $less_voucher=0; 
                    }
                }
                
                $less_voucher = (float)$less_voucher * (float)$exchange_rate;
                $less_voucher_orig = (float)$less_voucher_orig * (float)$exchange_rate;

                if ($less_voucher==TRUE){
                    $subtotal=$subtotal-$less_voucher;
                    
                    /** check if item is taxable*/
                    if ($food_taxable==false){
                        $subtotal_non=$subtotal_non-$less_voucher;
                    }
                }       
                                
                /*PROMO STARTS HERE*/
                $show_discount=false;
                $discounted_amount=0;
                $merchant_discount_amount=0;
                
                $discounted_amount_orig=0;
                $has_discount = false;
                
                
                if(isset($_SESSION['promo_discount'])){
                   unset($_SESSION['promo_discount']);
                }
                
                if ($receipt==TRUE){
                    $_GET['id']=isset($_GET['id'])?$_GET['id']:$new_order_id;
                    if ( $promo_res=$this->getOrderDiscount($_GET['id'])){                      
                        if ( $promo_res['discounted_amount']>=0.0001){
                            
                            //if ($order_infos['calculation_method']==2){
                            if($calculation_method==2){
                                $merchant_discount_amount=$this->formatNumber($promo_res['discount_percentage'],0);
                                $discounted_amount=$promo_res['discounted_amount'];
                                $has_discount=true;
                            } else {
                                $show_discount=true;
                                $merchant_discount_amount=$this->formatNumber($promo_res['discount_percentage'],0);
                                $discounted_amount=$promo_res['discounted_amount'];
                                $subtotal=$subtotal-$discounted_amount;
                                
                                /** check if item is taxable*/
                                if ($food_taxable==false){
                                    //$subtotal_non=$subtotal_non-$discounted_amount;
                                }
                            }
                        }
                    }                   
                } else {
                    //if ( $promo_res=Yii::app()->functions->getMerchantOffersActive($mid)){
                    if ( $promo_res=$this->getMerchantOffersActive($mid,$data['delivery_type'])){
                        //dump($promo_res);
                        $offer_continue=true;
                        
                        if(isset($promo_res['applicable_to'])){
                          if (!empty($promo_res['applicable_to'])){
                              if ($promo_res['applicable_to']!="all"){
                                 $applicable_to = json_decode($promo_res['applicable_to'],true);                                 
                                 if(!in_array($data['delivery_type'],(array)$applicable_to)){
                                    $offer_continue=false;
                                 }
                              }
                          } 
                        }
                                            
                        $merchant_spend_amount=$promo_res['offer_price'];
                        $merchant_discount_amount=$this->formatNumber($promo_res['offer_percentage'],0);
                        
                        $merchant_spend_amount = (float)$merchant_spend_amount * (float)$exchange_rate;
                        
                        if($offer_continue){
                            if ( $subtotal>=$merchant_spend_amount){
                                        
                               //if(FunctionsV3::isReceiptCalculationMethodTwo()){
                               if($calculation_method==2){
                                  $merchant_discount_amount1=$merchant_discount_amount/100;
                                  $discounted_amount=$subtotal*$merchant_discount_amount1;
                                  $has_discount=true;
                               } else {                    
                                   $show_discount=true;
                                   $merchant_discount_amount1=$merchant_discount_amount/100;
                                   $discounted_amount=$subtotal*$merchant_discount_amount1;                 
                                   $subtotal=$subtotal-$discounted_amount;
                                   
                                   $_SESSION['promo_discount']=1;
                                   
                                   /** check if item is taxable*/
                                   if ($food_taxable==false){
                                       //$subtotal_non=$subtotal_non-$discounted_amount;
                                   }
                               }
                               
                            } 
                        }
                        
                    }       
                }   
                
                
                /*dump($discounted_amount);
                dump($merchant_discount_amount);*/
                
                /**above sub total free delivery*/      
                $free_delivery=false;        
                if ( $data['delivery_type']=="delivery"){
                    
                    if(!isset($_GET['backend'])){
                        $free_delivery_above_price = (float)$this->getOption("free_delivery_above_price",$mid);
                        if ($this->isSearchByLocation() && $receipt==false){
                        
                            //$location_data=FunctionsV3::getSearchByLocationData();    

                                 $location_data=false; 
                            if(isset($data['location_data'])){
                                if(is_array($data['location_data']) && count($data['location_data'])>=1){
                                    $location_data = $data['location_data'];
                                }                           
                            }       
                                                        
                            $delivery_fee_resp=$this->getLocationDeliveryFeeWithMinimum(
                              $mid,0,0,$location_data
                            );                                      
                            if($delivery_fee_resp['free_above_subtotal']>0){
                                $free_delivery_above_price = (float)$delivery_fee_resp['free_above_subtotal'];
                            }                       
                        }
                        if($free_delivery_above_price>0){
                            //dump("subtotal=>$subtotal  free_delivery_above_price=>$free_delivery_above_price");
                            if ($subtotal>=$free_delivery_above_price){
                                $delivery_charges=0;
                                $free_delivery=true;
                            }
                        }
                    }                   
                }
                /**above sub total free delivery*/
                
                
              
                
                /*POINTS PROGRAM*/
                /*if (FunctionsV3::hasModuleAddon("pointsprogram")){      
                            
                    if (isset($_SESSION['pts_redeem_amt']) && $_SESSION['pts_redeem_amt']>0.01){
                        $pts_redeem_amt=unPrettyPrice($_SESSION['pts_redeem_amt']);                                             
                        $pts_redeem_amt = (float)$pts_redeem_amt * (float)$exchange_rate;
                        if($calculation_method==2){
                           $subtotal=unPrettyPrice($subtotal);
                           $pts_redeem_amt_found=true;
                        } else $subtotal=unPrettyPrice($subtotal)-$pts_redeem_amt;
                    } elseif ( isset($data['points_amount'])){
                        
                        $pts_redeem_amt=unPrettyPrice($data['points_amount']);      
                        $pts_redeem_amt = (float)$pts_redeem_amt * (float)$exchange_rate;
                        
                        if($calculation_method==2){
                           $subtotal=unPrettyPrice($subtotal);
                           $pts_redeem_amt_found=true;
                        } else $subtotal=unPrettyPrice($subtotal)-$pts_redeem_amt;
                        
                    } else {
                        if ($receipt==TRUE){                    
                            if (isset($data['points_discount']) && $data['points_discount']>0){
                               $pts_redeem_amt=unPrettyPrice($data['points_discount']);                            
                               $pts_redeem_amt = (float)$pts_redeem_amt * (float)$exchange_rate;
                               
                               if($calculation_method==2){
                                  $subtotal=unPrettyPrice($subtotal);
                                  $pts_redeem_amt_found=true;
                               } else $subtotal=unPrettyPrice($subtotal)-$pts_redeem_amt;                              
                            }           
                        }       
                    }
                }*/
                               
                
                $service_fee = isset($data['service_fee'])?(float)$data['service_fee']:0;                   
                $service_fee_taxable = isset($data['service_fee'])?(float)$data['service_fee']:0;
                
                $service_fee  = (float)$service_fee * (float)$exchange_rate;
                $service_fee_taxable  = (float)$service_fee_taxable * (float)$exchange_rate;
                                
                if(isset($data['service_fee_applytax'])){
                    if(!$data['service_fee_applytax']){
                        $service_fee_taxable = 0;
                    }                   
                }               
                    
                 
                if ( !empty($tax)){
                    $tax=$tax/100;
                    
                    /** check if item is taxable*/    
                    $temp_delivery_charges=$delivery_charges;                           
                    if ($this->getOption("merchant_tax_charges",$mid)==2){
                        $temp_delivery_charges=0;                       
                    }  
                                    
                    if ($receipt==true){                        
                        if (isset($data['donot_apply_tax_delivery'])){
                            if ($data['donot_apply_tax_delivery']==2){
                                $temp_delivery_charges=0;                               
                            } else $temp_delivery_charges=$delivery_charges;
                        }                       
                    }

                    if (!isset($subtotal_non)){
                        $subtotal_non=0;
                    }          
                    
                                                                                            
                    /*FIXED TAX ISSUE*/
                    if ($subtotal_non>=0.0001){                     
                        $temp_subtotal=$subtotal-$subtotal_non;                             
                        if($temp_subtotal>0){                           
                           $taxable_subtotal=($temp_subtotal+$temp_delivery_charges+$merchant_packaging_charge+$service_fee_taxable)*$tax;
                        } else {                    
                           if($merchant_packaging_charge>0 && $merchant_packaging_charge>0){                            
                              $taxable_subtotal=($temp_delivery_charges+$merchant_packaging_charge+$service_fee_taxable)*$tax;                         
                           }
                        }
                    } else {                        
                        $taxable_subtotal=( (float)$subtotal+ (float)$temp_delivery_charges + (float)$merchant_packaging_charge + (float) $service_fee_taxable )*$tax;    
                    }
                                        
                    
                    /*dump($temp_delivery_charges."=>".$merchant_packaging_charge);
                    dump($subtotal);
                    dump($subtotal_non);
                    dump("taxable_subtotal=>".$taxable_subtotal);*/
                }           
                
                
                //$htm.="TAXABLE=>$taxable_subtotal <br/>";
                
                                            
                $total=(float)$subtotal + (float)$taxable_subtotal + (float)$delivery_charges + (float)$merchant_packaging_charge + (float) $service_fee;
                
                
                /*VOUCHER*/
                                
                $htm.='<div class="summary-wrap">';
                
                 if ( $has_voucher==TRUE){       

                     if ( $show_discount==true):                                        
                       $htm.=$this->receiptRowTotal( ("Discount")." $merchant_discount_amount%" ,
                       self::formatNumber($discounted_amount)
                       );
                     endif;
                                         
                                         
                     if ($receipt==TRUE){
                        $voucher_code=" - ".$order_infos['voucher_code']."";
                     } else $voucher_code='';
                                         
                     $htm.=$this->receiptRowTotal( $this->translation("default","Less Voucher")." ".$voucher_type ,
                     "(". self::formatNumber($less_voucher) .")" 
                     );          
                     
                    /* if (FunctionsV3::hasModuleAddon("pointsprogram")){                          
                         $pts_redeem_amt_orig = $pts_redeem_amt;
                         if($receipt==TRUE){                            
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         } else {                           
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         }
                         if($pts_redeem_amt>0){
                             $htm.=FunctionsV3::receiptRowTotal('Points Discount',
                             "(".Price_Formatter::formatNumber($pts_redeem_amt).")" );  
                         }  
                     }*/
                                         
                     $htm.=$this->receiptRowTotal("Sub Total", self::formatNumber($subtotal) );
                                    
                 } else {                    
                    
                     if ( $show_discount==true):                     
                     $htm.=$this->receiptRowTotal( ("Discount")." $merchant_discount_amount%",
                       "(". self::formatNumber($discounted_amount) .")"
                      );
                     endif;
                                     
                     /*POINTS PROGRAM*/         
                   /*  if (FunctionsV3::hasModuleAddon("pointsprogram")){      
                                   
                         
                         $pts_redeem_amt_orig = $pts_redeem_amt;
                         
                         if($receipt==TRUE){
                            //if ($order_infos['calculation_method']==2){
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         } else {
                            //if(FunctionsV3::isReceiptCalculationMethodTwo()){
                            if($calculation_method==2){
                                $pts_redeem_amt=0;
                            }
                         }
                                
                         if($pts_redeem_amt>0){
                             $htm.=FunctionsV3::receiptRowTotal('Points Discount',
                             "(".Price_Formatter::formatNumber($pts_redeem_amt).")" );  
                         }  
                     }*/
                                         
                    $htm.=$this->receiptRowTotal('Sub Total',
                    self::formatNumber($subtotal) ,'','cart_subtotal' );
                    
                 }          
                 
                 
                 if(isset($data['service_fee'])){
                     if($data['service_fee']>0){
                        $htm.=$this->receiptRowTotal('Service Fee',
                        self::formatNumber(  $data['service_fee'] * $exchange_rate )
                        );
                     }
                 }
                                 
                 if (!empty($delivery_charges)){
                    $htm.=$this->receiptRowTotal('Delivery Fee',
                    self::formatNumber($delivery_charges)
                    );
                 }               
                 
                 if ( $free_delivery==true){                     
                     $htm.=$this->receiptRowTotal("Delivery Fee", "Free" );
                 }
                 
                 if (!empty($merchant_packaging_charge)){       
                   if($merchant_packaging_charge>=0.001){         
                       $htm.=$this->receiptRowTotal("Packaging",
                         self::formatNumber($merchant_packaging_charge)                       
                       );
                   }
                 }
                                                         
                 if ( !empty($tax)){                 
                     if($taxable_subtotal>0.0001){    
                         $htm.=$this->receiptRowTotal( "Tax"." $tax_amt%" ,
                          self::formatNumber($taxable_subtotal)
                         );
                     }
                 }

                 /*TIPS*/
                 if (isset($data['cart_tip_percentage'])){
                    if(strlen($data['cart_tip_percentage'])>=0.0001){
                        $data['tip_enabled']=2;
                        $data['tip_percent']=$data['cart_tip_percentage'];
                    }
                 }
                                 
                 if (isset($data['tip_enabled'])){                  
                    if ($data['tip_enabled']==2 && $data['tip_percent']>=0.0001){                                           
                        $data['cart_tip_value'] =  $subtotal * $data['tip_percent'];                        
                        
                        $data['cart_tip_percentage']=$data['tip_percent']*100;
                        
                        $t_cart_tip_percentage = explode(".",$data['cart_tip_percentage']);                                      
                        $tip_decimal_places = 0;
                        if(count($t_cart_tip_percentage)>=2){
                            $tip_decimal_places = 2;
                        }
                        
                        $htm.=$this->receiptRowTotal( ("Tips")." ".self::formatNumber($data['cart_tip_percentage'],$tip_decimal_places)."%" ,
                          self::formatNumber($data['cart_tip_value'])
                        );                 
                        
                                                
                        $data['cart_tip_percentage']  = self::formatNumber($data['cart_tip_percentage'],$tip_decimal_places,'.','');                     
                             
                        $total+=$data['cart_tip_value'];                        
                    }
                 }
                                 
                 
                 /*CARD FEE*/                            
                 if (isset($data['card_fee']) || isset($data['card_percentage'])){                  
                     $fee = isset($data['card_fee'])?(float)$data['card_fee']:0;          
                     $card_percentage = isset($data['card_percentage'])?(float)$data['card_percentage']:0;                   
                     //dump("$card_percentage=>$fee");                   
                     if($fee>0 || $card_percentage>0){
                         if($card_percentage>0){                            
                            $card_fees = (float)$total*((float)$data['card_percentage']/100);                           
                         }                  
                         if($fee>0){
                            $card_fees+=(float)$data['card_fee'];
                         }
                         
                         $card_fees = (float)$card_fees * (float)$exchange_rate;
                         
                         $htm.=$this->receiptRowTotal("Card Fee", self::formatNumber($card_fees) );
                         $total+=(float)$card_fees;
                     }                   
                 }          

                 //dump($card_fees);                      
               
               /*VOUCHER*/
               if($has_voucher_orig){
                 $htm.=$this->receiptRowTotal(t("Voucher"), "(".self::formatNumber($less_voucher_orig).")" );  
                 $total=$this->unPrettyPrice($total)-$this->unPrettyPrice($less_voucher_orig);
               }
               
               
               /*POINTS PROGRAM*/
             /*  if (FunctionsV3::hasModuleAddon("pointsprogram")){                     
                   if($pts_redeem_amt_found){
                      $htm.=FunctionsV3::receiptRowTotal(t("Points Discount"), "(".Price_Formatter::formatNumber($pts_redeem_amt_orig).")" );  
                      $total=unPrettyPrice($total)-unPrettyPrice($pts_redeem_amt_orig);
                      
                   }
               }*/
               
               /*DISCOUNT*/
               if($has_discount){
                  $htm.=$this->receiptRowTotal( ("Discount")." $merchant_discount_amount%",
                       "(". self::formatNumber($discounted_amount) .")"
                      );
                  $total=$this->unPrettyPrice($total)-$this->unPrettyPrice($discounted_amount);
               }
                                           
               $htm.="<div class=\"row cart_total_wrap bold\">";
               $htm.="<div class=\"col-md-6 col-xs-6  text-right\">".("Total")."</div>";
               $htm.="<div class=\"col-md-6 col-xs-6  text-right cart_total\">".               
               self::formatNumber($total) ."</div>";
               $htm.="</div>";
               

               /*POINTS PROGRAM*/
               /*if (FunctionsV3::hasModuleAddon("pointsprogram")){                                  
                  $htm.=PointsProgram::cartTotalEarnPoints($cart_item,$receipt,$subtotal,$mid);
               }*/
               
               if(!isset($pts_redeem_amt)){
                  $pts_redeem_amt=0;
               }
               $htm .= '<input type="hidden" name="subtotal_order" id="subtotal_order" value="' . htmlspecialchars($this->unPrettyPrice($subtotal + $less_voucher + $pts_redeem_amt), ENT_QUOTES, 'UTF-8') . '" />';
              $htm .= '<input type="hidden" name="subtotal_order2" id="subtotal_order2" value="' . htmlspecialchars($this->unPrettyPrice($subtotal), ENT_QUOTES, 'UTF-8') . '" />';
              $htm .= '<input type="hidden" name="subtotal_extra_charge" id="subtotal_extra_charge" value="' . htmlspecialchars($this->unPrettyPrice((float)$delivery_charges + (float)$merchant_packaging_charge + (float)$taxable_subtotal), ENT_QUOTES, 'UTF-8') . '" />';
               
               
               if(!isset($data['cart_tip_percentage'])){
                   $data['cart_tip_percentage']='';
               }
               
               $tips_decimal_places = $this->getOptionAdmin('admin_decimal_place');               
               if(empty($tips_decimal_places)){             
                  $tips_decimal_places=2;
               }               
               
               //dump($data['cart_tip_percentage']);
               // array value
               
               if(!isset($data['cart_tip_percentage'])){
                   $data['cart_tip_percentage']='';
               }
               if($tax>0){
               $tasxa=$this->normalPrettyPrice($tax*100).'%';
                $tax_label="TaxABC1 ".$tasxa;
               }else{$tax_label="";}

               $used_currency = $this->getCurrencyCode();

               $item_array_total=array(
                 'subtotal'=>round($subtotal,2),
                 'taxable_total'=>round($taxable_subtotal,2),
                 'delivery_charges'=>$delivery_charges,
                 'total'=>round($total,2),               
                 'tax'=>$tax,
                 'tax_amt'=>$tax_amt,
                 'tax_label'=>$tax_label,
                 'curr'=>$used_currency,
                 'mid'=>$mid,
                 'discounted_amount'=>$discounted_amount,
                 'merchant_discount_amount'=>$merchant_discount_amount,
                 'merchant_packaging_charge'=>$merchant_packaging_charge,
                 'less_voucher'=>$less_voucher,
                 'voucher_type'=>$voucher_type,
                 /*'tips'=>isset($data['cart_tip_value'])?$data['cart_tip_value']:'',
                 'tips_percent'=>$data['cart_tip_percentage']>0.1?number_format($data['cart_tip_percentage'],0)."%":'',
                 'cart_tip_percentage'=>$data['cart_tip_percentage']>0.1?number_format($data['cart_tip_percentage']):'',*/
                 'tips'=>$data['cart_tip_percentage']>0.1?self::formatNumber($data['cart_tip_value'],$tips_decimal_places):'',                
                 'tips_percent'=>$data['cart_tip_percentage']>0.1?$data['cart_tip_percentage']."%":'',               
                 'cart_tip_percentage'=>$data['cart_tip_percentage']>0.1?($data['cart_tip_percentage']):'',
                 'pts_redeem_amt'=>isset($pts_redeem_amt)?$pts_redeem_amt:'',
                 'voucher_value'=>isset($_SESSION['voucher_code']['amount'])?$_SESSION['voucher_code']['amount']:'',
                 'voucher_types'=>isset($_SESSION['voucher_code']['voucher_type'])?$_SESSION['voucher_code']['voucher_type']:'',
                 
                 'calculation_method'=>$calculation_method,
                 'pts_redeem_amt_orig'=>$pts_redeem_amt_orig,
                 'less_voucher_orig'=>$less_voucher_orig,                
                 'service_fee'=>isset($service_fee)?(float)$service_fee:0
               );   

                           
                           
               if ($receipt){                 
                  $item_array_total['voucher_value']=isset($data['voucher_amount'])?$data['voucher_amount']:0;
                  $item_array_total['voucher_types']=isset($data['voucher_type'])?$data['voucher_type']:'';
               }
               
               if (isset($data['card_fee']) || isset($data['card_percentage']) ){
                   if($card_fees>0){
                       $item_array_total['card_fee']=$card_fees;
                   }
               }

               
               //dump($data);
               /*header('Content-Type: text/html; charset=utf-8');
               echo $htm;*/
               if($_REQUEST['debug']){print_r($item_array);}
               
               
                            
                $this->code=1;
                $this->msg="OK";
                
                return $this->details=array(
                  'item-count'=>$x,
                  'html'=>$htm,
                  'raw'=>array('item'=>$item_array,'total'=>$item_array_total)
                );
            } else $this->msg=$this->translation("default","No Item added yet!");
        } else $this->msg=$this->translation("default","No Item added yet!");
    }


    public  function salesReceipt($data='',$item_details='')
  {       
        
    $tr=""; $sms_details='';
    if (is_array($data) && count($data)>=1){
      foreach ($data as $val) {       
        $tr.="<tr>";
        $tr.="<td>".$val['label']."</td>";
        $tr.="<td>".stripslashes($val['value'])."</td>";
        $tr.="</tr>";
      }
    }
    
    $mid=isset($item_details['total']['mid'])?$item_details['total']['mid']:'';
    //dump($mid);
    
    //dump($item_details);
    
    
    $tr.="<tr>";
    $tr.="<td colspan=\"2\">&nbsp;</td>";
    $tr.="</tr>";
    if (isset($item_details['item'])){
      if (is_array($item_details['item']) && count($item_details['item'])>=1){
        foreach ($item_details['item'] as $item) {
          //dump($item);
          $notes='';
          $item_total=$item['qty']*$item['discounted_price'];
          if (!empty($item['order_notes'])){
              $notes="<p>".$item['order_notes']."</p>";
          }
          $cookref='';
          if (!empty($item['cooking_ref'])){
              $cookref="<p>".$this->qTranslate($item['cooking_ref'],'cooking_name',$item['cooking_name_trans'])."</p>";
          }
          $size=''; $size_sms = '';
          if (!empty($item['size_words'])){
            $size_words=$this->qTranslate($item['size_words'],'size_name',$item['size_name_trans']);
              $size="<p>".$size_words."</p>";
              $size_sms = $size_words;
          }
          
          $ingredients='';
          if (isset($item['ingredients'])){
            if (is_array($item['ingredients']) && count($item['ingredients'])>=1){
              $ingredients.="<p>"."Ingredients"."</p>";
              $ingredients.="<p>";
              foreach ($item['ingredients'] as $ingredients_val) {
                if($details_ingredients=$this->getIngredientsByName($ingredients_val,$mid)){
                  $_ingredients['ingredients_name_trans']=json_decode($details_ingredients['ingredients_name_trans'],true);                       
                  $ingredients.="- ".$this->qTranslate($ingredients_val,'ingredients_name',$_ingredients)."<br/>";
                  
                } else $ingredients.="- $ingredients_val<br/>";               
              }
              $ingredients.="</p>";
            }
          }
          
          if (!empty($item['category_id'])){
            $tr.="<tr>";
            $tr.="<td colspan=\"2\"><b>".
            $this->qTranslate($item['category_name'],'category_name',$item['category_name_trans'])."</td>";
            $tr.="</b></tr>";
          }
          
          $item_name=$this->qTranslate($item['item_name'],'item_name',$item['item_name_trans']);
                    
          $tr.="<tr>";
          
          /*Custom code 13 starts */
            if($item['promo_id']>0){
            $tr.="<td>".$item['qty']." ".$item_name."( Promo ID :".$item['promo_id'].")".$size_sms.$notes.$cookref.$ingredients."</td>";
           }else{
              $tr.="<td>".$item['qty']." ".$item_name.$size_sms.$notes.$cookref.$ingredients."</td>";
           }
           /*Custom code 13 ends */
            
            $tr.="<td>".$this->formatNumber($item_total)."</td>";
            $tr.="</tr>";
                                    
            $sms_details.=$item['qty']." x ".$item_name.$size.$notes.$cookref.$ingredients." ".$this->formatNumberNoSymbol($item_total);
            $sms_details.=$this->smsSeparator();
                                           
          
            if (isset($item['new_sub_item'])){
              if (is_array($item['new_sub_item']) && count($item['new_sub_item'])>=1){
                foreach ($item['new_sub_item'] as $subcategory_name=> $subcategory_item) {
                  //dump($subcategory_item);
                  
                  if(!isset($subcategory_item[0])){
                    $subcategory_item[0]['subcategory_name_trans']='';
                  }
                  
                  $subcategory_name_trans=$this->qTranslate($subcategory_name,'subcategory_name',
                  $subcategory_item[0]['subcategory_name_trans']);
                  
                  $tr.="<tr>";
                  $tr.="<td colspan=\"2\">".$subcategory_name_trans."</td>";
                  
                  $tr.="</tr>";
                  $sms_details.=$subcategory_name_trans;
                  $sms_details.=$this->smsSeparator();
                  foreach ($subcategory_item as $itemsub) {
                    
                    $addon_name=$this->qTranslate($itemsub['addon_name'],'sub_item_name',
                    $itemsub['sub_item_name_trans']);
                    
                    $subitem_total=$itemsub['addon_qty']*$itemsub['addon_price'];               
                    $tr.="<tr>";
                        $tr.="<td style=\"text-indent:10px;\">".$itemsub['addon_qty']."x".$this->formatNumber($itemsub['addon_price'])." ".$addon_name."</td>";
                        $tr.="<td>".$this->formatNumber($subitem_total)."</td>";
                        $tr.="</tr>";
                        
                        $sms_details.=$itemsub['addon_qty']." x ".$this->formatNumberNoSymbol($itemsub['addon_price']);
                          $sms_details.=" ".$addon_name;
                          $sms_details.=$this->smsSeparator();
                  }
                }
              }
            }
            
        }
      }
    }
    $tr.="<tr>";
    $tr.="<td colspan=\"2\">&nbsp;</td>";
    $tr.="</tr>";
    
    //dump($item_details);
    
    
    //Yii::app()->functions->additional_details=$sms_details;
    
    if (isset($item_details['total'])){
      
      if(!isset($item_details['total']['less_voucher'])){
        $item_details['total']['less_voucher']='';
      }
      if(!isset($item_details['total']['pts_redeem_amt'])){
        $item_details['total']['pts_redeem_amt']='';
      }
      if(!isset($item_details['total']['tips'])){
        $item_details['total']['tips']='';
      }
      
      if ($item_details['total']['less_voucher']>0.001){
        $tr.="<tr>";
        $tr.="<td>".$this->translation("default","Less Voucher")." " .$item_details['total']['voucher_type'] . ":</td>";
        $tr.="<td>(".$this->formatNumber($item_details['total']['less_voucher']).")</td>";
        $tr.="</tr>";
      }
      
      if ($item_details['total']['pts_redeem_amt']>0.001){
        $tr.="<tr>";
        $tr.="<td>".$this->translation("default","Points discount").":</td>";
        $tr.="<td>(".$this->formatNumber($item_details['total']['pts_redeem_amt']).")</td>";
        $tr.="</tr>";
      }
            
      if(!isset($item_details['total']['discounted_amount'])){
        $item_details['total']['discounted_amount']=0;
      }
      
      if($item_details['total']['calculation_method']==1){
        if($item_details['total']['discounted_amount']>0.001){
          $tr.="<tr>";
            $tr.="<td>".$this->translation("default","Discount")." " . $item_details['total']['merchant_discount_amount_new']  ."% :</td>";
            $tr.="<td>".$this->formatNumber($item_details['total']['discounted_amount'])."</td>";
            $tr.="</tr>";
        }
      }
            
      
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Sub Total").":</td>";
      $tr.="<td>".$this->formatNumber($item_details['total']['subtotal'])."</td>";
      $tr.="</tr>";
      
      if(isset($item_details['total']['service_fee'])):
      if (!empty($item_details['total']['service_fee'])):
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Service Fee").":</td>";
      $tr.="<td>".$this->formatNumber($item_details['total']['service_fee'])."</td>";
      $tr.="</tr>";
      endif;
      endif;
      
      if (!empty($item_details['total']['delivery_charges'])):
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Delivery Fee").":</td>";
      $tr.="<td>".$this->formatNumber($item_details['total']['delivery_charges'])."</td>";
      $tr.="</tr>";
      endif;
      
          
      if (!empty($item_details['total']['merchant_packaging_charge'])):
      if ($item_details['total']['merchant_packaging_charge']>0.0001){
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Packaging").":</td>";
      $tr.="<td>".$this->formatNumber($item_details['total']['merchant_packaging_charge'])."</td>";
      $tr.="</tr>";
      }
      endif;
      
      if(isset($item_details['total']['tax_amt'])){
        $tr.="<tr>";
        $tr.="<td>".$this->translation("default","Tax")." ".$item_details['total']['tax_amt']."%</td>";
        $tr.="<td>".$this->formatNumber($item_details['total']['taxable_total'])."</td>";
        $tr.="</tr>";
      }
      
      if (!isset($item_details['total']['card_fee'])){
        $item_details['total']['card_fee']='';
      }
      
      if ($item_details['total']['card_fee']>0):
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Card Fee").":</td>";
      $tr.="<td>".$this->formatNumber($item_details['total']['card_fee'])."</td>";
      $tr.="</tr>";
      endif;
      
      if ($item_details['total']['tips']>0.001){
        $tr.="<tr>";
        $tr.="<td>".$this->translation("default","Tips")." " .$item_details['total']['tips_percent'] . ":</td>";
        $tr.="<td>".$this->formatNumber($item_details['total']['tips'])."</td>";
        $tr.="</tr>";
      }
      
      if($item_details['total']['calculation_method']==2){
        if($item_details['total']['less_voucher_orig']>0.01){
          $tr.="<tr>";
          $tr.="<td>".$this->translation("default","Voucher"). ":</td>";
          $tr.="<td>(".$this->formatNumber($item_details['total']['less_voucher_orig']).")</td>";
          $tr.="</tr>";
        }
        
        if($item_details['total']['pts_redeem_amt_orig']>0.01){
          $tr.="<tr>";
          $tr.="<td>".$this->translation("default","Points Discount"). ":</td>";
          $tr.="<td>(".$this->formatNumber($item_details['total']['pts_redeem_amt_orig']).")</td>";
          $tr.="</tr>";
        }
        
        if($item_details['total']['discounted_amount']>0.001){
          $tr.="<tr>";
            $tr.="<td>".$this->translation("default","Discount")." " . $item_details['total']['merchant_discount_amount_new']  ."% :</td>";
            $tr.="<td>(".$this->formatNumber($item_details['total']['discounted_amount']).")</td>";
            $tr.="</tr>";
        }
      }
      
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Total").":</td>";
      $tr.="<td>".$this->formatNumber($item_details['total']['total'])."</td>";
      $tr.="</tr>";
    }
    ob_start();
    ?>
    <!--<div style="display: block;max-height: 70px;max-width: 200px;">-->
    <?php //echo Widgets::receiptLogo();?>
    <!--</div>-->
    <table border="0">
    <?php echo $tr;?>   
    </table>
    <?php 
    $receipt = ob_get_contents();
        ob_end_clean();
        return $receipt;
  }

  public function getMerchantActivationToken($merchant_id = '')
{
    // Prepare the SQL query
    $stmt = $this->db->prepare("SELECT activation_token FROM mt_merchant WHERE merchant_id = :merchant_id LIMIT 0,1");

    // Bind the merchant_id to the prepared statement
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Check if the result exists and handle the activation_token
    if ($res) {
        if (empty($res['activation_token'])) {
            // If activation_token is empty, update it
            $token = $this->updateMerchantToken($merchant_id);
        } else {
            // Otherwise, use the existing activation_token
            $token = $res['activation_token'];
        }

        return $token;
    }

    // Return false if no result is found
    return false;
}

public function updateMerchantToken($merchant_id='')
  {
    $token=$this->generateRandomKey();
    $token=md5($token);
    
    $params=array('activation_token'=>$token);
    if ( $this->updateData("mt_merchant",$params,'merchant_id',$merchant_id)){
      return $token;
    }
    return false;
      
  }




  public function notifyMerchant2($data='',$sms_data='',$order_details_html1='',$order_details_html='')    
    {   
                 
      $lang='en';       
      $sender=$this->getOptionAdmin("global_admin_sender_email");    
            
      /*SEND EMAIL TO MERCHANT*/    
      $enabled=$this->getOptionAdmin("receipt_send_to_merchant_email");    
      $enabled_alert_notification=$this->getOptionAdmin("enabled_alert_notification");         
      $merchant_email=$this->getOption("merchant_notify_email",$data['merchant_id']);    
      if ($enabled==1 && $enabled_alert_notification!=1 && !empty($merchant_email) ){   
        $subject=$this->getOptionAdmin("receipt_send_to_merchant_tpl_subject_$lang");    
            
         $merchant_token=$this->getMerchantActivationToken($data['merchant_id']);   
            

          $accept_link = Config::$baseUrl.'/acceptorder/id/'.$data['order_id'].'/token/'.$merchant_token;   


          

        $decline_link =Config::$baseUrl.'/declineorder/id/'.$data['order_id'].'/token/'.$merchant_token; 


        $pattern=array(   
           'customer_name'=>'full_name',    
           'order_id'=>'order_id',    
           'restaurant_name'=>'merchant_name',    
           'total_amount'=>'total_w_tax',   
           'sitename'=>$this->getOptionAdmin('website_title'),   
           'siteurl'=>$this->websiteUrl(),   
           'accept_link'=>$accept_link,   
           'decline_link'=>$decline_link,   
           'receipt'=>$order_details_html1,   
         'merchant_email_tag'=>$order_details_html    
        );    
                    
        if(!empty($subject)){             
          $subject=$this->replaceTemplateTags($subject,$pattern,$data);    
        }   
            
        $tpl = $this->getOptionAdmin("receipt_send_to_merchant_tpl_content_$lang");    
        if(!empty($tpl)){             
          $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);    
        }         
                            
        $merchant_email=explode(",",$merchant_email);   
        if(is_array($merchant_email) && count($merchant_email)>=1){   
           foreach ($merchant_email as $email) {    
              $params=array(    
             'email_address'=>$email,   
             'sender'=>$sender,   
             'subject'=>$subject,   
             'content'=>$tpl,   
             'date_created'=>$this->dateNow(),   
             'ip_address'=>$_SERVER['REMOTE_ADDR'],   
           'order_id'=>$data['order_id'],   
             'module_type'=>'core'    
            );                  
            $this->insertData("mt_email_logs",$params);
            
           // FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("cron/processemail"));
           }    
        }           
      }           
          
      /*SEND SMS*/    
      $enabled=$this->getOptionAdmin("receipt_send_to_merchant_sms");    
      $mobiles = $this->getOption("sms_notify_number",$data['merchant_id']);   
      if ($enabled==1 && !empty($mobiles)){   
                    
        $data['taxable_total'] = $this->prettyPrice($data['taxable_total']);    
        $data['cart_tip_value'] = $this->prettyPrice($data['cart_tip_value']);            
            
        $data['total_order_amount'] = $this->normalPrettyPrice($data['total_w_tax']);            
            
        $pattern=array(   
           'customer_name'=>'full_name',    
           'order_id'=>'order_id',    
           'restaurant_name'=>'merchant_name',    
           'total_amount'=>'total_w_tax',   
           'order_details'=>$sms_data,    
           'sitename'=>$this->getOptionAdmin('website_title'),   
           'siteurl'=>$this->websiteUrl(),   
           'customer_mobile'=>'contact_phone',    
           'customer_address'=>'client_delivery_address',   
           'payment_type'=>'payment_type',    
           'transaction_type'=>'trans_type',    
           'delivery_time'=>'delivery_time',    
           'delivery_instruction'=>'delivery_instruction',    
           'taxable_total'=>'taxable_total',    
           'cart_tip_value'=>'cart_tip_value',    
           'delivery_date'=>'delivery_date',    
           'total_order_amount'=>'total_order_amount',    
           'order_change'=>'order_change'   
        );            
        $tpl=$this->getOptionAdmin("receipt_send_to_merchant_sms_content_$lang");    
        $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);    
            
        $balance=$this->getMerchantSMSCredit($data['merchant_id']);                   
        if (is_numeric($balance) && $balance>=1){             
          $mobiles=explode(",",$mobiles);   
          if(is_array($mobiles) && count($mobiles)>=1){   
            foreach ($mobiles as $mobile) {   
              $params=array(    
                'contact_phone'=>$mobile,   
                'sms_message'=>$tpl,    
                'date_created'=>$this->dateNow(),    
                'ip_address'=>$_SERVER['REMOTE_ADDR'],    
                'merchant_id'=>$data['merchant_id']   
              );                  
              $this->insertData("mt_sms_broadcast_details",$params);    
            }   
          }   
        } else {              
          $mobiles=explode(",",$mobiles);   
          if(is_array($mobiles) && count($mobiles)>=1){   
            foreach ($mobiles as $mobile) {   
              $params=array(    
                'contact_phone'=>$mobile,   
                'sms_message'=>$tpl,    
                'date_created'=>$this->dateNow(),    
                'ip_address'=>$_SERVER['REMOTE_ADDR'],    
                'merchant_id'=>$data['merchant_id'],    
                'status'=>"merchant has no sufficient balance has make this request"    
              );                          
              $this->insertData("mt_sms_broadcast_details",$params);    
            }   
          }   
        }   
      }   
          
          
      /*SEND PUSH TO MERCHANT*/       
      /*if (FunctionsV3::hasModuleAddon("merchantapp")){            
        self::MerchantpushNewOrder($data['order_id']);    
        FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("merchantapp/cron/processpush"));    
      }   
        */
       /*SEND PUSH TO MERCHANT APP V2*/ 

         require __DIR__ . '/../../app/modules/merchantappv2/components/OrderWrapper.php';
                
          $this->OrderWrapper = new OrderWrapper();
           $this->OrderWrapper->InsertOrderTrigger(  
             isset($data['order_id'])?$data['order_id']:'', 
             'receipt_send_to_merchant'           
           ); 
         
                
      
    } 



    public function notifyMerchant2_notsendingEmails($data='',$sms_data='',$order_details_html1='',$order_details_html='',$not_sending_emails)    
    {   
                 
      $lang='en';       
      $sender=$this->getOptionAdmin("global_admin_sender_email");    
            
      /*SEND EMAIL TO MERCHANT*/    
      $enabled=$this->getOptionAdmin("receipt_send_to_merchant_email");    
      $enabled_alert_notification=$this->getOptionAdmin("enabled_alert_notification");         
      //$merchant_email=$this->getOption("merchant_notify_email",$data['merchant_id']);   
      $merchant_email=$not_sending_emails;  
      if ($enabled==1 && $enabled_alert_notification!=1 && !empty($merchant_email) ){   
        $subject=$this->getOptionAdmin("receipt_send_to_merchant_tpl_subject_$lang");    
            
         $merchant_token=$this->getMerchantActivationToken($data['merchant_id']);   
            

          $accept_link = Config::$baseUrl.'/acceptorder/id/'.$data['order_id'].'/token/'.$merchant_token;   


          

        $decline_link =Config::$baseUrl.'/declineorder/id/'.$data['order_id'].'/token/'.$merchant_token; 


        $pattern=array(   
           'customer_name'=>'full_name',    
           'order_id'=>'order_id',    
           'restaurant_name'=>'merchant_name',    
           'total_amount'=>'total_w_tax',   
           'sitename'=>$this->getOptionAdmin('website_title'),   
           'siteurl'=>$this->websiteUrl(),   
           'accept_link'=>$accept_link,   
           'decline_link'=>$decline_link,   
           'receipt'=>$order_details_html1,   
         'merchant_email_tag'=>$order_details_html    
        );    
                    
        if(!empty($subject)){             
          $subject=$this->replaceTemplateTags($subject,$pattern,$data);    
        }   
            
        $tpl = $this->getOptionAdmin("receipt_send_to_merchant_tpl_content_$lang");    
        if(!empty($tpl)){             
          $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);    
        }         
                            
        $merchant_email=explode(",",$merchant_email);   
        if(is_array($merchant_email) && count($merchant_email)>=1){   
           foreach ($merchant_email as $email) {    
              $params=array(    
             'email_address'=>$email,   
             'sender'=>$sender,   
             'subject'=>$subject,   
             'content'=>$tpl,   
             'date_created'=>$this->dateNow(),   
             'ip_address'=>$_SERVER['REMOTE_ADDR'],   
           'order_id'=>$data['order_id'],   
             'module_type'=>'core'    
            );                  
            $this->insertData("mt_email_logs",$params);


            
           // FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("cron/processemail"));
           }  

           
           $params_order=array('resend_email'=>2);
           $this->updateData("mt_order",$params_order,'order_id',$data['order_id']);



        }           
      }           
          
     
         
                
      
    } 




    public  function fastRequest($url)
  { 
      
        if (preg_match("/https/i", $url)) {
          //@shell_exec("curl $url");
          $this->consumeUrl($url);
        } else {          
        $parts=parse_url($url);     
        $fp = fsockopen($parts['host'],isset($parts['port'])?$parts['port']:80,$errno, $errstr, 30);
        $out = "GET ".$parts['path']." HTTP/1.1\r\n";
        $out.= "Host: ".$parts['host']."\r\n";
        $out.= "Content-Length: 0"."\r\n";
        $out.= "Connection: Close\r\n\r\n"; 
        fwrite($fp, $out);
        fclose($fp);
        }     
  }

  public function Curl($uri="",$post="")
  {   
     $error_no=0;
     $ch = curl_init($uri);
     curl_setopt($ch, CURLOPT_POST, 1);    
     curl_setopt($ch, CURLOPT_POSTFIELDS, $post);    
     curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
     curl_setopt($ch, CURLOPT_HEADER, 0);
         curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
     $resutl=curl_exec ($ch);   
                       
     if ($error_no==0) {
       return $resutl;
     } else return false;      
     curl_close ($ch);                                
  } 

  public  function consumeUrl($url='')
  { 
      
    $is_curl_working = true;
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_TIMEOUT, 1);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    $result = curl_exec($ch);
    if (curl_errno($ch)) {        
        $is_curl_working = false;
    }
    curl_close($ch);
    
    if(!$is_curl_working){
       $response = @file_get_contents($url);       
       if (isset($http_response_header)) {
        if (!in_array('HTTP/1.1 200 OK',(array)$http_response_header) && !in_array('HTTP/1.0 200 OK',(array)$http_response_header)) {
          //
        }
       }
    }
  }


  public function chk_email_status_against_order($order_id, $merchant_id)
{
    // Fetch merchant notify emails
    $merchant_email_ids = $this->getOption('merchant_notify_email', $merchant_id);

    if (empty($merchant_email_ids)) {
        return 'not sent'; // No emails configured
    }

    // Split and trim emails
    $email_array = array_map('trim', explode(',', $merchant_email_ids));

    $total_emails = count($email_array);
    $sent_count = 0;

    foreach ($email_array as $email) {
        $stmt = $this->db->prepare("
            SELECT COUNT(*) 
            FROM mt_email_logs 
            WHERE order_id = ? 
            AND TRIM(LOWER(email_address)) = TRIM(LOWER(?))
        ");
        $stmt->execute([$order_id, $email]);

        if ($stmt->fetchColumn() > 0) {
            $sent_count++;
        }
    }

    // Determine status
    if ($sent_count == 0) {
        return 'Not Sent';
    } elseif ($sent_count == $total_emails) {
        return 'Sent';
    } else {
        return 'Partial Sent';
    }
}





 public function getMerchantById($merchant_id = '')
{
    // Set SQL_BIG_SELECTS=1 to allow large select statements
    $this->db->query("SET SQL_BIG_SELECTS=1");

    $stmt = "
    SELECT *,
    CONCAT(street, ' ', city, ' ', state, ' ', post_code) as merchant_address
    FROM mt_view_merchant
    WHERE merchant_id = :merchant_id
    LIMIT 0, 1
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Execute the query with parameters
    $query->execute([
        ':merchant_id' => $merchant_id
    ]);

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    // Return the first result if found, otherwise false
    if ($res) {
        return $res;
    }

    return false;
}


public function getMinOrderByTableRates($mtid = '', $distance = '', $unit = '', $min_fee = 0)
{
    // Get the option for minimum tables enabled
    $is_enabled = $this->getOption('min_tables_enabled', $mtid);    
    if ($is_enabled != 1) {
        return $min_fee;
    }
    
    // Standardize the unit of measurement
    switch (strtolower($unit)) {
        case "miles":
        case "mi":
            $unit = 'mi';
            break;
        case "kilometers":
        case "km":
            $unit = 'km';
            break;
        case "ft":
            $unit = 'mi';
            $distance = 1;
            break;
    }

    $min_fees = $min_fee;

    // Prepare the SQL query
    $stmt = "SELECT * FROM mt_minimum_table 
             WHERE merchant_id = :mtid 
             AND shipping_units = :unit
             ORDER BY distance_to ASC";

    // Prepare the statement with PDO
    $query = $this->db->prepare($stmt);
    
    // Bind parameters to avoid SQL injection
    $query->bindParam(':mtid', $mtid, PDO::PARAM_INT);
    $query->bindParam(':unit', $unit, PDO::PARAM_STR);

    // Execute the query
    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            $found = false;
            $last_records = '';
            foreach ($res as $val) {
                if ($val['distance_from'] <= $distance && $val['distance_to'] >= $distance) {
                    $min_fees = $val['min_order'];
                    $found = true;
                } else {
                    $last_records = $val;
                }
            }

            if (!$found) {
                if ($distance > $last_records['distance_to']) {
                    $min_fees = $last_records['min_order'];
                }
            }
        }
    }
    
    return $min_fees;
}



public  function getMerchantDistanceType($merchant_id='')
    {
      $distance_type=$this->getOption('merchant_distance_type',$merchant_id);
      $distance_type=strtolower($distance_type);        
        switch ($distance_type) {
          case "mi":
            $type="M";
            break;        
          case "km":  
              $type="K";
              break;
          default:
            $type="M";
            break;
        }
        return $type;
    }

    public function getAddressBookByID($id = '')
{
    $stmt = "
    SELECT * 
    FROM mt_address_book
    WHERE id = :id
    LIMIT 0, 1
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Execute the query with parameters
    $query->execute([
        ':id' => $id
    ]);

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    // Return the first result if found, otherwise false
    if ($res) {
        return $res;
    }

    return false;
}
      





    public  function notifyAdmin($data='',$sms_data='',$order_details_html='')
    {
             
      $lang='en';   
      $sender=$this->getOptionAdmin("global_admin_sender_email");
      
      /*SEND EMAIL TO ADMIN*/
      $enabled=$this->getOptionAdmin("receipt_send_to_admin_email");    
      $emails=$this->getOptionAdmin("noti_receipt_email");     
      if ($enabled==1 && !empty($emails) ){
        $subject=$this->getOptionAdmin("receipt_send_to_admin_tpl_subject_$lang");
        
         $merchant_token=$this->getMerchantActivationToken($data['merchant_id']);
             $accept_link = Config::$baseUrl.'/acceptorder/id/'.$data['order_id'].'/token/'.$merchant_token;   


          

        $decline_link =Config::$baseUrl.'/declineorder/id/'.$data['order_id'].'/token/'.$merchant_token; 

        $pattern=array(
           'customer_name'=>'full_name',
           'order_id'=>'order_id',
           'restaurant_name'=>'merchant_name',
           'total_amount'=>'total_w_tax',
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),
           'accept_link'=>$accept_link,
           'decline_link'=>$decline_link,
           'receipt'=>$order_details_html,
           'contact_phone'=>"contact_phone" 
        );
                
        if(!empty($subject)){         
          $subject=$this->replaceTemplateTags($subject,$pattern,$data);
        }
        
        $tpl = $this->getOptionAdmin("receipt_send_to_admin_tpl_content_$lang");
        if(!empty($tpl)){         
          $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
        }     
                
        $emails=explode(",",$emails);
        if(is_array($emails) && count($emails)>=1){
           foreach ($emails as $email) {
              $params=array(
             'email_address'=>$email,
             'sender'=>$sender,
             'subject'=>$subject,
             'content'=>$tpl,
             'date_created'=>$this->dateNow(),
             'ip_address'=>$_SERVER['REMOTE_ADDR'],
             
             /*custom code start */ 
           'order_id'=>$data['order_id'], 
           /*custom code ends*/
           
             'module_type'=>'core'
            );      
            $this->insertData("mt_email_logs",$params);           
           }
        }       
      }        
      
      /*SEND SMS*/
      $enabled=$this->getOptionAdmin("receipt_send_to_admin_sms");
      $mobiles = $this->getOptionAdmin('noti_receipt_sms');
      if ($enabled==1 && !empty($mobiles)){
        $pattern=array(
           'customer_name'=>'full_name',
           'order_id'=>'order_id',
           'restaurant_name'=>'merchant_name',
           'total_amount'=>'total_w_tax',
           'total_amount_order'=>$this->normalPrettyPrice($data['total_w_tax']),
           'order_details'=>$sms_data,
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),  
           'contact_phone'=>"contact_phone" 
        );
        $tpl=$this->getOptionAdmin("receipt_send_to_admin_sms_content_$lang");
        $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);                
        $mobiles=explode(",",$mobiles);
        if(is_array($mobiles) && count($mobiles)>=1){
          foreach ($mobiles as $mobile) {
            $params=array(
              'contact_phone'=>$mobile,
              'sms_message'=>$tpl,
              'date_created'=>$this->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'merchant_id'=>$data['merchant_id']
            );          
            $this->insertData("mt_sms_broadcast_details",$params); 
          }
        }       
      }
      
      
    }


 public function getClientInfowm_id($client_id = '', $mid = '', $cid = '')
{
    $stmt = "
    SELECT * FROM mt_client
    WHERE client_id = $client_id
    AND merchant_id = $mid
    AND single_app_merchant_id > 0
    LIMIT 0,1
    ";

    $cmd = $this->db->prepare($stmt);
    $cmd->execute();
    $res = $cmd->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        return $res[0];
    }
    return false;
}

 public function getallcustomers($id, $pid)
{
    $stmt = "
    SELECT * FROM mt_client
    WHERE 1
    AND merchant_id = $id
    AND status = 'active'
    AND (author_url IS NULL OR author_url = '')
    ";

    $this->PointsProgram = new PointsProgram();

    $points_enabled = '';
    $pts_disabled_redeem = '';

    $points_enabled = $this->getOptionAdmin('points_enabled');
    if ($points_enabled == "1") {
        if (!$this->PointsProgram->isMerchantSettingsDisabled()) {
            $mt_disabled_pts = $this->getOption('mt_disabled_pts', $id);
            if ($mt_disabled_pts == 2) {
                $points_enabled = '';
            }
        }
    }
$this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $cmd = $this->db->prepare($stmt);
    $cmd->execute();
    $res = $cmd->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $data = array();
        foreach ($res as $val) {
            if ($points_enabled == "1") {
                $available_points = $this->PointsProgram->getTotalEarnPoints($val['client_id'], $id);
                $available_points_label = "Your available points " . $available_points;
                $val['available_points'] = $available_points;
                $val['available_points_label'] = $available_points_label;
            }
            $data[] = $val;
        }
        return $data;
    }
    return false;
}




   public function getMerchantSMSCredit($merchant_id = '')
{
    // Check if SMS purchase is disabled
    $status = $this->getOptionAdmin('mechant_sms_purchase_disabled');
    if ($status == "yes") {
        return 1;
    }

    // Prepare the SQL query with two parts: total_credits and total_send
    $stmt = $this->db->prepare("
        SELECT 
            SUM(sms_limit) AS total_credits,
            (
                SELECT COUNT(*) AS total_send
                FROM mt_sms_broadcast_details
                WHERE merchant_id = :merchant_id
                AND status IN ('process')
            ) AS total_send
        FROM mt_sms_package_trans
        WHERE merchant_id = :merchant_id
        AND status IN ('paid')
    ");

    // Bind the merchant ID to the prepared statement
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Calculate and return the remaining SMS credits
    if ($res) {
        return $res['total_credits'] - $res['total_send'];
    }

    // Return 0 if no result is found
    return 0;
}




  public function notifyCustomer($data='',$sms_data='',$order_details_html='', $to='')
    {           
            
      $lang='en';   
      $sms_provider=$this->getOptionAdmin('sms_provider'); 
      $enabled = $this->getOptionAdmin("receipt_template_email");
      $sender=$this->getOptionAdmin("global_admin_sender_email");
      
      /*Custom code 5 start */
    //send email from merchant email  
    if($data['merchant_id']>0){ 
      $merch=$this->getMerchant($data['merchant_id']);  
      if($merch['is_use_email']=='2'){  
        if(isset($merch['contact_email']) && !empty($merch['contact_email'])){  
          $sender=$merch['contact_email'];    
        } 
      } 

        
    }else{$sender=$this->getOptionAdmin("global_admin_sender_email");}
    /*custom code 5 ends*/
      
      /*SEND EMAIL TO CUSTOMER*/
      if($enabled==1 && !empty($to)){
        $subject = $this->getOptionAdmin("receipt_template_tpl_subject_$lang");
        $tpl = $this->getOptionAdmin("receipt_template_tpl_content_$lang");

        
        $pattern=array(
           'customer_name'=>'full_name',
           'order_id'=>'order_id',
           'restaurant_name'=>'merchant_name',
           'total_amount'=>'total_w_tax',
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),          
           'receipt'=>$order_details_html
        );
        
        if(!empty($subject)){
          $subject=$this->replaceTemplateTags($subject,$pattern,$data);
        }
        if(!empty($tpl)){  
            $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
        } 




        $params=array(
          'email_address'=>$to,
          'sender'=>$sender,
          'subject'=>$subject,
          'content'=>$tpl,
          'date_created'=>$this->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          
          /*Custom code start */
          'order_id'=>$data['order_id'],
        /*custom code ends*/
        
          'module_type'=>'core'
        );
        $this->insertData("mt_email_logs",$params);     
      }
                  
      /*SEND SMS*/
      $enabled = $this->getOptionAdmin("receipt_template_sms");
      $tpl=$this->getOptionAdmin("receipt_template_sms_content_$lang");
      $to = isset($data['contact_phone'])?$data['contact_phone']:'';      
      if($enabled==1 && !empty($to) && !empty($tpl)){
        $pattern=array(
           'customer_name'=>'full_name',
           'order_id'=>'order_id',
           'restaurant_name'=>'merchant_name',
           'total_amount'=>'total_w_tax',
           'total_amount_order'=>$this->formatNumberNoSymbol($data['total_w_tax']),
           'order_details'=>$sms_data,
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>$this->websiteUrl(),
           'order_change'=>'order_change',
           'contact_phone1'=>'contact_phone1',
           'delivery_instruction'=>'delivery_instruction',
           'client_delivery_address'=>'client_delivery_address',
        );
        $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);        
        $params=array(
          'contact_phone'=>$to,
          'sms_message'=>$tpl,
          'date_created'=>$this->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']        
        );        
        $this->insertData("mt_sms_broadcast_details",$params); 
      }
      
      
    }


      public  function notifyMerchant($data='',$sms_data='',$order_details_html='')
    {
               
        $lang="en";   
        $sender=$this->getOptionAdmin("global_admin_sender_email");
        
        /*SEND EMAIL TO MERCHANT*/
        $enabled=$this->getOptionAdmin("receipt_send_to_merchant_email");
        $enabled_alert_notification=$this->getOptionAdmin("enabled_alert_notification");       
        $merchant_email=$this->getOption("merchant_notify_email",$data['merchant_id']);
        if ($enabled==1 && $enabled_alert_notification!=1 && !empty($merchant_email) ){
            $subject=$this->getOptionAdmin("receipt_send_to_merchant_tpl_subject_$lang");
            
             $merchant_token=$this->getMerchantActivationToken($data['merchant_id']);

              $accept_link = Config::$baseUrl . "/acceptorder?id=" . $data['order_id'] . "&token=" . $merchant_token;
        $decline_link = Config::$baseUrl . "/declineorder?id=" . $data['order_id'] . "&token=" . $merchant_token; 


            $pattern=array(
               'customer_name'=>'full_name',
               'order_id'=>'order_id',
               'restaurant_name'=>'merchant_name',
               'total_amount'=>'total_w_tax',
               'sitename'=>$this->getOptionAdmin('website_title'),
               'siteurl'=>$this->websiteUrl(),
               'accept_link'=>$accept_link,
               'decline_link'=>$decline_link,
               'receipt'=>$order_details_html,
               
               /*custom code 7 start */ 
               'merchant_email_tag'=>$order_details_html    
               /*custom code 7 ends */
            );
                        
            if(!empty($subject)){               
                $subject=$this->replaceTemplateTags($subject,$pattern,$data);
            }
            
            $tpl = $this->getOptionAdmin("receipt_send_to_merchant_tpl_content_$lang");
            if(!empty($tpl)){               
                $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
            }       
                                    
            $merchant_email=explode(",",$merchant_email);
            if(is_array($merchant_email) && count($merchant_email)>=1){
               foreach ($merchant_email as $email) {
                  $params=array(
                   'email_address'=>$email,
                   'sender'=>$sender,
                   'subject'=>$subject,
                   'content'=>$tpl,
                   'date_created'=>$this->dateNow(),
                   'ip_address'=>$_SERVER['REMOTE_ADDR'],
                   
                   /*custom code start */   
                   'order_id'=>$data['order_id'],   
                   /*custom code ends */    
                   
                   'module_type'=>'core'
                  );                      
                  $this->insertData("mt_email_logs",$params);               
               }
            }           
        }          
        
        /*SEND SMS*/
        $enabled=$this->getOptionAdmin("receipt_send_to_merchant_sms");
        $mobiles = $this->getOption("sms_notify_number",$data['merchant_id']);
        if ($enabled==1 && !empty($mobiles)){
                        
            $data['taxable_total'] = $this->prettyPrice($data['taxable_total']);
            $data['cart_tip_value'] = $this->prettyPrice($data['cart_tip_value']);            
            
            $data['total_order_amount'] = $this->normalPrettyPrice($data['total_w_tax']);          
             
            $pattern=array(
               'customer_name'=>'full_name',
               'order_id'=>'order_id',
               'restaurant_name'=>'merchant_name',
               'total_amount'=>'total_w_tax',
               'order_details'=>$sms_data,
               'sitename'=>$this->getOptionAdmin('website_title'),
               'siteurl'=>$this->websiteUrl(),
               'customer_mobile'=>'contact_phone',
               'customer_address'=>'client_delivery_address',
               'payment_type'=>'payment_type',
               'transaction_type'=>'trans_type',
               'delivery_time'=>'delivery_time',
               'delivery_instruction'=>'delivery_instruction',
               'taxable_total'=>'taxable_total',
               'cart_tip_value'=>'cart_tip_value',
               'delivery_date'=>'delivery_date',
               'total_order_amount'=>'total_order_amount',
               'order_change'=>'order_change'
            );          
            $tpl=$this->getOptionAdmin("receipt_send_to_merchant_sms_content_$lang");
            $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
            
            $balance=$this->getMerchantSMSCredit($data['merchant_id']);                     
            if (is_numeric($balance) && $balance>=1){               
                $mobiles=explode(",",$mobiles);
                if(is_array($mobiles) && count($mobiles)>=1){
                    foreach ($mobiles as $mobile) {
                        $params=array(
                          'contact_phone'=>$mobile,
                          'sms_message'=>$tpl,
                          'date_created'=>self::dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR'],
                          'merchant_id'=>$data['merchant_id']
                        );                      
                        $this->insertData("mt_sms_broadcast_details",$params); 
                    }
                }
            } else {                
                $mobiles=explode(",",$mobiles);
                if(is_array($mobiles) && count($mobiles)>=1){
                    foreach ($mobiles as $mobile) {
                        $params=array(
                          'contact_phone'=>$mobile,
                          'sms_message'=>$tpl,
                          'date_created'=>$this->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR'],
                          'merchant_id'=>$data['merchant_id'],
                          'status'=>"merchant has no sufficient balance has make this request"
                        );                                  
                        $this->insertData("mt_sms_broadcast_details",$params); 
                    }
                }
            }
        }
        
        
        /*SEND PUSH TO MERCHANT*/    
        
        
        /*SEND PUSH TO MERCHANT APP V2*/
                 
             require __DIR__ . '/../../app/modules/merchantappv2/components/OrderWrapper.php';
             $this->OrderWrapper = new OrderWrapper();
              $this->OrderWrapper->InsertOrderTrigger(
               isset($data['order_id'])?$data['order_id']:'',
               'receipt_send_to_merchant'              
             );
        
                
        
    }




      public  function latToAdress($lat='' , $lng='')
  {

    $map = $this->getMapProvider();
    
    if($map['provider']=="mapbox"){

      $mapPath = __DIR__ . '/../../vendor/mapbox/Mapbox.php';
            if (file_exists($mapPath)) {
                require_once($mapPath);
            }
        
      
      $mapbox = new Mapbox($map['token']);      
      $res = $mapbox->reverseGeocode($lng, $lat);
      $success = $res->success();
      $count = $res->getCount();
      
      if($success && $count>0){
           $relevance=array();
           $data = array();
           
           foreach ($res as $key => $val) {                      
            $data[$key]=$val;
            $relevance[$key]=$val['relevance'];
           }           
           $value = max($relevance);           
           $key = array_search($value, $relevance);
                                        
           if($key>=0){
            if(isset($data[$key]['place_name'])){   
              
              $temp_data = $data[$key];
              
              $out_address = ''; $out_city='';
              $out_state=''; $out_country=''; $out_country_code='';
              $out_zip='';
              
              if(isset($temp_data['properties'])){
                 if(isset($temp_data['properties']['address'])){
                     $out_address=$temp_data['properties']['address'];
                 }
              }
              
              if(isset($temp_data['context'])){
                foreach ($temp_data['context'] as $val_context) {                 
                  if (preg_match("/locality./i", $val_context['id'])) {
                    if(empty($out_address)){
                       $out_address = $val_context['text'];
                    }
                  }
                  if (preg_match("/district./i", $val_context['id'])) {
                    if(empty($out_address)){
                       $out_address = $val_context['text'];
                    }
                  }
                  if (preg_match("/locality./i", $val_context['id'])) {
                    if(empty($out_address)){
                       $out_address = $val_context['text'];
                    }
                  }
                  if (preg_match("/place./i", $val_context['id'])) {
                    $out_city = $val_context['text'];
                  }
                  if (preg_match("/postcode./i", $val_context['id'])) {
                    $out_zip = $val_context['text'];
                  }
                  if (preg_match("/region./i", $val_context['id'])) {
                    $out_state = $val_context['text'];
                  }
                  if (preg_match("/country./i", $val_context['id'])) {
                    $out_country = $val_context['text'];
                    $out_country_code = isset($val_context['short_code'])?$val_context['short_code']:'';
                  }
                }
              }           
                        
              
              $out['address']=$out_address;
              $out['city']=$out_city;
              $out['state']=$out_state;
              $out['zip']=$out_zip;
              $out['country']=$out_country;
              $out['country_code']=$out_country_code;
              $out['formatted_address']=$temp_data['place_name'];
              
              return $out;
            }
           }                   
      }   
      return false;
    }
    /*END MAPBOX*/
    
    $lat_lng="$lat,$lng";
    $protocol = isset($_SERVER["https"]) ? 'https' : 'http';
    if ($protocol=="http"){
      $api="http://maps.googleapis.com/maps/api/geocode/json?latlng=".urlencode($lat_lng);
    } else $api="https://maps.googleapis.com/maps/api/geocode/json?latlng=".urlencode($lat_lng);
    
    /*check if has provide api key*/
    $key=$this->getOptionAdmin('google_geo_api_key');   
    if ( !empty($key)){
      $api="https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($lat_lng)."&key=".urlencode($key);
    } 
            
    if (!$json = @file_get_contents($api)) {
    $ch = curl_init($api);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $json = curl_exec($ch);
    curl_close($ch);
}
    
    if (isset($_GET['debug'])){
      /*dump($api);   
      dump($json);  */  
    }
    
    $address_out=array();
      
    if (!empty($json)){     
      $results = json_decode($json,true);   
      //dump($results);   
      $parts = array(
        'address'=>array('street_number','route'),        
        //'city'=>array('locality'),
        'city'=>array('locality','political','sublocality'),
        'state'=>array('administrative_area_level_1'),
        'zip'=>array('postal_code'),
        'country'=>array('country'),
        'country_code'=>array('country'),
      );        
      if (!empty($results['results'][0]['address_components'])) {
        $ac = $results['results'][0]['address_components'];
        foreach($parts as $need=>$types) {
        foreach($ac as &$a) {                         
            if (in_array($a['types'][0],$types)){
              if (in_array($a['types'][0],$types)){
                if($need=="address"){
                  if(isset($address_out[$need])) {
                   $address_out[$need] .= " ".$a['long_name'];
                  } else $address_out[$need]= $a['long_name'];
                } elseif ($need=="country_code"){             
                    $address_out[$need] = $a['short_name'];
                } else $address_out[$need] = $a['long_name'];                       
              }
            } elseif (empty($address_out[$need])) $address_out[$need] = ''; 
        }
        }
        
        if(!empty($results['results'][0]['formatted_address'])){
         $address_out['formatted_address']=$results['results'][0]['formatted_address'];
        }
        
        return $address_out;
      }         
    }     
    return false;
  }


  public  function salesReceiptM_bkedupbywas($address,$data2,$data='',$item_details='')   
  { $tr=""; $sms_details='';    
      
    
  //$_SESSION['kr_delivery_options']['delivery_date']='2020-05-13';   
  $deliver_date=$this->prettyDate($data2['delivery_date']);   
  $createddates= $this->prettyDate($data2['date_created']);
  
  $tests='';    
  if($deliver_date>$createddates){    
    $tests=" (Future Order)";   
  } else {$tests=" (New Order)";}
  
  
  $dates= $this->prettyDate($data2['date_created'])." ".$this->prettyTime($data2['date_created']);    
      
   $delivery_address='';    
    if($data2['trans_type']=='delivery'){   
        
     if (!empty($data2['client_full_address'])){                  
               $delivery_address=$data2['client_full_address'];   
             } else {$delivery_address=$data2['full_address'];  }   
            
    }   
    
  $transtype= $this->prettyPaymentType('payment_order',   
           $data2['payment_type'],$data2['order_id'],$data2['trans_type']);
      
      
//   if($data2['status']=='paid'|| $data2['status']=='successful' || $data2['status']=='delivered'){$st=" Paid ";}else{$st="Not-Paid";}
   if($transtype=='PAID ONLINE' || $transtype=='ONLINE PAY VIA POLI' || $transtype=='PAYPAL_V2'){$st=" Paid ";}else{$st="Not-Paid";}
      
    $tr.="<tr style='text-align:center'>";    
    $tr.="<td colspan='2' style='border-bottom: 3px solid;' ><b style='font-size: 18px;   font-weight: 600;'>".$st." ".$tests."</b></td></tr>";   
        
    $tr.="<tr><td style='width1: 13%'></td><td style='width1: 13%'> </td></tr>";    
        
        
    $tr.="<tr>";    
    $tr.="<td style='text-align:left' >TRN Date :".$dates."</td>";    
        
        
        
    
    if($data2['request_from']=="pos" &&  $data2['order_number']>0){
      
      $tr.="<td style='text-align:right;float: right;width: 180px;' >Order:".$data2['merchant_id'].'-'.$data2['order_number']."</td></tr>";   
      
      }else if($data2['request_from']=="webappv2" &&  $data2['order_number']>0){      
    
      $tr.="<td style='text-align:right;float: right;width: 180px;' >Order:".$data2['merchant_id'].'-'.$data2['order_number']."</td></tr>"; 
      
      }else {   
    
      $tr.="<td style='text-align:right' >Order:".$data2['order_id']."</td></tr>";    
      
      }

    
    
        
    $tr.="<tr><td  colspan='2' style='border-bottom: 3px solid;'></td></tr>";   
        
        
          
          
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'><b>Order ID</b></td>";    
    //$tr.="<td style='text-align:right'><b>Customer Detail</b></td>";    
    //$tr.="</tr>";   
        
        
     if ( !empty($data2['contact_phone1'])){    
              $data2['contact_phone']=$data2['contact_phone1'];   
             }    
            
            
        
    $tr.="<tr><td colspan='2' style='text-align:center'><b>Customer Detail</b></td></tr>";    
        
    $tr.="<tr><td colspan='2' style='text-align:center'>".$data2['full_name']."</td></tr>";   
        
    $tr.="<tr><td colspan='2' style='text-align:center'>".$data2['contact_phone']."</td></tr>";   
        
    $tr.="<tr><td colspan='2' style='text-align:center'>".$delivery_address."</td></tr>";   
        
    $tr.="<tr><td  colspan='2' style='border-bottom: 3px solid;'></td></tr>";   
        
    //$tr.="<td style='text-align:right'><b>Customer Detail</b></td>";    
    //$tr.="</tr>";       
            
        
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'>".$data2['order_id']."</td>";   
    //$tr.="<td style='text-align:right'>".$data2['full_name']."  </td>";   
    //$tr.="</tr>";   
        
    //$tr.="<tr style='float: left;margin: 1px;'><td style='width1: 13%'></td></tr>";   
        
        
        
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'><b>TRN Date</b></td>";    
    //$tr.="<td style='text-align:right'>".$data2['contact_phone']."</td>";   
    //$tr.="</tr>";   
        
    //$tr.="<tr>";    
        
        
        
        
    //$tr.="<td style='width1: 13%'>".$dates."</td>";   
    //$tr.="<td style='text-align:right'>".$delivery_address."  </td>";   
    //$tr.="</tr>";   
        
    //$tr.="<tr style='float: left;margin:0px;'><td style='width1: 13%'></td></tr>";    
        
        
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'></td>";   
    //$tr.="<td style='text-align:right'>".$data2['merchant_contact_phone']."</td>";    
    //$tr.="</tr>";   
        
    $tr.="<tr style='float: left;margin-top:5px;'>";    
        
    //$tr.="<td style='width1: 13%'><b>Customer Detail</b></td>";   
    //$tr.="<td style='width1: 13%'></td>";   
    //$tr.="</tr>";   
        
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'>".$data2['full_name']."</td>";    
    //$tr.="<td style='width1: 13%'></td>";   
    //$tr.="</tr>";   
        
                
        
    //  $tr.="<tr>";    
    //$tr.="<td style='width1: 13%'>".$data2['contact_phone']."</td>";    
    //$tr.="<td style='width1: 13%'></td>";   
    //$tr.="</tr>";   
        
  //  $tr.="<tr style='float: left;margin: 5px;'><td style='width1: 13%'></td></tr>";   
        
        
        
          
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'><b>Order Type </b></td>";   
    $tr.="</tr>";   
        
    $deliver_date=date('d M',strtotime($data2['delivery_date']));   
        
    $tr.="<tr>";    
    //Custom code starts  
       if($data2['delivery_asap']==1){    
       $tr.="<td colspan='2' style='text-align: center;'>".$data2['trans_type'].','.$deliver_date."</td>";}else{$tr.="<td colspan='2' style='text-align: center;'>".$data2['trans_type'].','.$deliver_date.$this->prettyTime($data2['delivery_time'])."</td>";  
       }    
    //Custom code ends  
      
    $tr.="</tr>";     
        
    $transtype= $this->prettyPaymentType('payment_order',   
           $data2['payment_type'],$data2['order_id'],$data2['trans_type']);   
              
          
          if($data2['is_sop']=='1' && $data2['trans_type']=='pickup'){    
          $transtype='Swipe on Pickup';   
        }   
            
        
        
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'><b>Payment type </b></td>";   
    $tr.="</tr>";   
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'>".($transtype)."</td>";    
    $tr.="</tr>";   
        
        
        
    if($data2['trans_type']=='delivery'){   
        
     if (!empty($data2['client_full_address'])){                  
               $delivery_address=$data2['client_full_address'];   
             } else {$delivery_address=$data2['full_address'];  }   
        
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'>".$delivery_address."</td>";    
    $tr.="</tr>";   
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'>".($data2['delivery_instruction'])."</td>";    
    $tr.="</tr>";   
        
        
        
    }
    
//    Custom code 12 starts
    if($data2['trans_type']=='pickup' && $data2['car_park_enable']=='1'){   
      $tr.="<tr>";    
      $tr.="<td colspan='2' style='text-align: center;'><b>Car Park Delivery</b></td>";   
      $tr.="</tr>";   
          
      $tr.="<tr>";    
      $tr.="<td colspan='2' style='text-align: center;'>Yes</td>";    
      $tr.="</tr>";
      
      
      $tr.="<tr>";    
      $tr.="<td colspan='2' style='text-align: center;'><b>Number Plate</b></td>";    
      $tr.="</tr>";   
          
      $tr.="<tr>";    
      $tr.="<td colspan='2' style='text-align: center;'>".$data2['number_plate']."</td>";   
      $tr.="</tr>";
      
    }
    
//    Custom code 12 ends
        
       if($data2['delivery_asap']==1){    
            $tr.="<td colspan='2' style='text-align: center;'>Deliver ASAP:Yes </td>";    
          
     }    
        
     if ($data2['order_change']>=0.1){          
      $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'>Change:".$this->displayPrice( $this->getCurrencyCode(), $this->normalPrettyPrice($data2['order_change']))." </td>";   
    $tr.="</tr>";   
                
     }    
        
        
        
      
        
        
        
     $tr.="<tr><td  colspan='2' style='border-bottom: 3px solid;'></td></tr>";    
            
    /*    
    if (is_array($data) && count($data)>=1){    
      foreach ($data as $val) {           
        $tr.="<tr>";    
          $tr.="<td><small>".$val['label']."</small></td>";   
        $tr.="<td><small>".stripslashes($val['value'])."</small></td>";   
        $tr.="</tr>";   
      }   
    }*/   
        
    $mid=isset($item_details['total']['mid'])?$item_details['total']['mid']:'';   
    //dump($mid);   
        
    //dump($item_details);    
        
    $tr.="<tr>";    
    $tr.="<td colspan=\"2\">&nbsp;</td>";   
    $tr.="</tr>";   
    if (isset($item_details['item'])){    
      if (is_array($item_details['item']) && count($item_details['item'])>=1){    
        foreach ($item_details['item'] as $item) {    
          //dump($item);    
          $notes='';    
          $item_total=$item['qty']*$item['discounted_price'];   
          if (!empty($item['order_notes'])){    
              $notes="<p style='float:left'>".$item['order_notes']."</p>";    
          }   
          $cookref='';    
          if (!empty($item['cooking_ref'])){    
              $cookref="<p style='float:left'>".$this->qTranslate($item['cooking_ref'],'cooking_name',$item['cooking_name_trans'])."</p>";   
          }   
          $size='';   
          if (!empty($item['size_words'])){   
            $size_words=$this->qTranslate($item['size_words'],'size_name',$item['size_name_trans']);   
              $size="<p style='float:left'>".$size_words."</p><br/>";   
          }   
              
          $ingredients='';    
          if (isset($item['ingredients'])){   
            if (is_array($item['ingredients']) && count($item['ingredients'])>=1){    
              $ingredients.="<p style='float:left'>".$this->translation("default","Ingredients")."</p>";   
              $ingredients.="<p style='float:left'>";   
              foreach ($item['ingredients'] as $ingredients_val) {    
                if($details_ingredients=$this->getIngredientsByName($ingredients_val,$mid)){    
                  $_ingredients['ingredients_name_trans']=json_decode($details_ingredients['ingredients_name_trans'],true);                           
                  $ingredients.="- ".$this->qTranslate($ingredients_val,'ingredients_name',$_ingredients)."<br/>";   
                      
                } else $ingredients.="- $ingredients_val<br/>";                   
              }   
              $ingredients.="</p>";   
            }   
          }   
              
        //  if (!empty($item['category_id'])){    
        //    $tr.="<tr>";    
        //    $tr.="<td colspan=\"2\"><b>".   
        //    qTranslate($item['category_name'],'category_name',$item['category_name_trans'])."</td>";    
        //    $tr.="</b></tr>";   
        //  }   
              
          $item_name=$this->qTranslate($item['item_name'],'item_name',$item['item_name_trans']);   
              
          $tr.="<tr>";    
              
            /* Custom code 13 starts */
            if($item['promo_id']>0){
            
          $tr.="<td style=\"width:0px; border-bottom:3pt solid black;width: 99%;\"><medium style='float:left'><b style='float:left'>".$item['qty']." x ".$item_name."(Promo ID :".$item['promo_id'].")".$size.$notes.$cookref.$ingredients."</b></medium></td>";  
          
           }else{
          
          $tr.="<td style=\"width:0px; border-bottom:3pt solid black;width: 99%;\"><medium style='float:left'><b style='float:left'>".$item['qty']." x ".$item_name.$size.$notes.$cookref.$ingredients."</b></medium></td>";  
          
           }
           /* Custom code 13 ends */
           
           $tr.="<td style=\"border-bottom:3pt solid black;width: 1%;text-align: right;\"><small style='float:left'><b style='float:left'>".$this->prettyPrice($item_total)."</b></small></td>";  
           $tr.="</tr>" ;
                
            //$sms_details.=$item['qty']." x ".$item_name." ".standardPrettyFormat($item_total);    
            $sms_details.=$item['qty']." x ".$item_name.$size.$notes.$cookref.$ingredients." ".$this->standardPrettyFormat($item_total);   
            $sms_details.=$this->smsSeparator();    
                                              
            /*if (isset($item['sub_item'])){    
              if (is_array($item['sub_item']) && count($item['sub_item'])>=1){    
                foreach ($item['sub_item'] as $itemsub) {                       
                  $subitem_total=$itemsub['addon_qty']*$itemsub['addon_price'];                   
                  $tr.="<tr>";                          
                      $tr.="<td style=\"text-indent:10px;\">".$itemsub['addon_qty']."x".FunctionsV3::prettyPrice($itemsub['addon_price'])." ".$itemsub['addon_name']."</td>";   
                      $tr.="<td>".FunctionsV3::prettyPrice($subitem_total)."</td>";   
                      $tr.="</tr>";   
                          
                      $sms_details.=$itemsub['addon_qty']." x ".standardPrettyFormat($itemsub['addon_price']);    
                      $sms_details.=" ".$itemsub['addon_name'];   
                      $sms_details.=FunctionsV3::smsSeparator();    
                }   
              }   
            }*/   
                
            if (isset($item['new_sub_item'])){    
              if (is_array($item['new_sub_item']) && count($item['new_sub_item'])>=1){    
                foreach ($item['new_sub_item'] as $subcategory_name=> $subcategory_item) {    
                  //dump($subcategory_item);    
                      
                  if(!isset($subcategory_item[0])){   
                    $subcategory_item[0]['subcategory_name_trans']='';    
                  }   
                      
                  $subcategory_name_trans=$this->qTranslate($subcategory_name,'subcategory_name',    
                  $subcategory_item[0]['subcategory_name_trans']);    
                      
                  $tr.="<tr>";    
                  $tr.="<td colspan=\"2\">".$subcategory_name_trans."</td>";    
                      
                  $tr.="</tr>";   
                  $sms_details.=$subcategory_name_trans;    
                  $sms_details.=$this->smsSeparator();    
                  foreach ($subcategory_item as $itemsub) {   
                        
                    $addon_name=$this->qTranslate($itemsub['addon_name'],'sub_item_name',    
                    $itemsub['sub_item_name_trans']);   
                        
                    $subitem_total=$itemsub['addon_qty']*$itemsub['addon_price'];                   
                    $tr.="<tr>";    
                        $tr.="<td style=\"text-indent:10px;\">".$itemsub['addon_qty']."x".$this->prettyPrice($itemsub['addon_price'])." ".$addon_name."</td>";    
                        $tr.="<td >".$this->prettyPrice($subitem_total)."</td>";    
                        $tr.="</tr>";   
                            
                        $sms_details.=$itemsub['addon_qty']." x ".$this->standardPrettyFormat($itemsub['addon_price']);    
                          $sms_details.=" ".$addon_name;    
                          $sms_details.=$this->smsSeparator();    
                  }   
                }   
              }   
            }   
                
        }   
      }   
    }   
    $tr.="<tr>";    
    $tr.="<td colspan=\"2\">&nbsp;</td>";   
    $tr.="</tr>";   
        
    //dump($item_details);    
        
    //Yii::app()->functions->additional_details=$sms_details;   
        
    if (isset($item_details['total'])){   
          
      if(!isset($item_details['total']['less_voucher'])){   
        $item_details['total']['less_voucher']='';    
      }   
      if(!isset($item_details['total']['pts_redeem_amt'])){   
        $item_details['total']['pts_redeem_amt']='';    
      }   
      if(!isset($item_details['total']['tips'])){   
        $item_details['total']['tips']='';    
      }   
          
      if ($item_details['total']['less_voucher']>0.001){    
        $tr.="<tr>";    
        $tr.="<td>".$this->translation("default","Less Voucher")." " .$item_details['total']['voucher_type'] . ":</td>";    
        $tr.="<td style='text-align:right'>(".$this->prettyPrice($item_details['total']['less_voucher']).")</td>";    
        $tr.="</tr>";   
      }   
          
      if ($item_details['total']['pts_redeem_amt']>0.001){    
        $tr.="<tr>";    
        $tr.="<td>".$this->translation("default","Points discount").":</td>";   
        $tr.="<td style='text-align:right'>(".$this->prettyPrice($item_details['total']['pts_redeem_amt']).")</td>";    
        $tr.="</tr>";   
      }   
                
      if(!isset($item_details['total']['discounted_amount'])){    
        $item_details['total']['discounted_amount']=0;    
      }   
          
      if($item_details['total']['calculation_method']==1){    
        if($item_details['total']['discounted_amount']>0.001){    
          $tr.="<tr>";    
            $tr.="<td>".$this->translation("default","Discount")." " . $item_details['total']['merchant_discount_amount']  ."% :</td>";   
            $tr.="<td style='text-align:right'>".$this->prettyPrice($item_details['total']['discounted_amount'])."</td>";   
            $tr.="</tr>";   
        }   
      }   
                
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Sub Total").":</td>";   
      $tr.="<td style='text-align:right'>".$this->prettyPrice($item_details['total']['subtotal'])."</td>";    
      $tr.="</tr>";   
          
      if (!empty($item_details['total']['delivery_charges'])):    
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Delivery Fee").":</td>";    
      $tr.="<td style='text-align:right'>".$this->prettyPrice($item_details['total']['delivery_charges'])."</td>";    
      $tr.="</tr>";   
      endif;    
          
              
      if (!empty($item_details['total']['merchant_packaging_charge'])):   
      if ($item_details['total']['merchant_packaging_charge']>0.0001){    
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Packaging").":</td>";   
      $tr.="<td style='text-align:right'>".$this->prettyPrice($item_details['total']['merchant_packaging_charge'])."</td>";   
      $tr.="</tr>";   
      }   
      endif;    
          
      /* Hide Tax field in the merchant email */    
          
//      if(isset($item_details['total']['tax_amt'])){   
//        $tr.="<tr>";    
//        $tr.="<td>".Yii::t("default","Tax")." ".$item_details['total']['tax_amt']."%</td>";   
//        $tr.="<td>".FunctionsV3::prettyPrice($item_details['total']['taxable_total'])."</td>";    
//        $tr.="</tr>";   
//      }   
          
      if (!isset($item_details['total']['card_fee'])){    
        $item_details['total']['card_fee']='';    
      }   
          
      if ($item_details['total']['card_fee']>0):    
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Card Fee").":</td>";    
      $tr.="<td style='text-align:right'>".$this->prettyPrice($item_details['total']['card_fee'])."</td>";    
      $tr.="</tr>";   
      endif;    
          
      if ($item_details['total']['tips']>0.001){    
        $tr.="<tr>";    
        $tr.="<td>".$this->translation("default","Tips")." " .$item_details['total']['tips_percent'] . ":</td>";    
        $tr.="<td style='text-align:right'>".$this->prettyPrice($item_details['total']['tips'])."</td>";    
        $tr.="</tr>";   
      }   
          
      if($item_details['total']['calculation_method']==2){    
        if($item_details['total']['less_voucher_orig']>0.01){   
          $tr.="<tr>";    
          $tr.="<td>".$this->translation("default","Voucher"). ":</td>";    
          $tr.="<td style='text-align:right'>(".$this->prettyPrice($item_details['total']['less_voucher_orig']).")</td>";   
          $tr.="</tr>";   
        }   
            
        if($item_details['total']['pts_redeem_amt_orig']>0.01){   
          $tr.="<tr>";    
          $tr.="<td>".$this->translation("default","Points Discount"). ":</td>";    
          $tr.="<td style='text-align:right'>(".$this->prettyPrice($item_details['total']['pts_redeem_amt_orig']).")</td>";   
          $tr.="</tr>";   
        }   
            
        if($item_details['total']['discounted_amount']>0.001){    
          $tr.="<tr>";    
            $tr.="<td>".$this->translation("default","Discount")." " . $item_details['total']['merchant_discount_amount']  ."% :</td>";   
            $tr.="<td style='text-align:right'>(".$this->prettyPrice($item_details['total']['discounted_amount']).")</td>";   
            $tr.="</tr>";   
        }   
      }   
          
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Total").":</td>";   
      $tr.="<td style='text-align:right'>".$this->prettyPrice($item_details['total']['total'])."</td>";   
      $tr.="</tr>";   
          
          
            
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center; border-top: 3pt solid black;'><b style='font-weight:600'>Merchant Detail</b></td>";    
    $tr.="</tr>";   
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;font-size: 13px;'>".$data2['merchant_name']."</td>";    
    $tr.="</tr>";   
        
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;font-size: 13px;'>".$address."</td>";   
    $tr.="</tr>";   
        
        
     $merchant_tax_number=$this->getOption('merchant_tax_number',$data2['merchant_id']);   
         if (!empty($merchant_tax_number)){   
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;    font-size: 13px;'>Gst :".$merchant_tax_number."</td>";    
    $tr.="</tr>";   
       }    
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;     font-size: 13px;   border-bottom: 3pt solid black;'>Phone # :".$data2['merchant_contact_phone']."</td>";   
    $tr.="</tr>";   
          
          
    }ob_start();?><table border="0" style='width: 100%;'>   
    <?php echo $tr;?>       
    </table>    
    <?php $receipt = ob_get_contents();ob_end_clean();    
        return $receipt;    
  }   




    public  function salesReceiptM($address,$data2,$data='',$item_details='')   
  { $tr=""; $sms_details='';    
      
    
  //$_SESSION['kr_delivery_options']['delivery_date']='2020-05-13';   
  $deliver_date=$this->prettyDate($data2['delivery_date']);   
  $createddates= $this->prettyDate($data2['date_created']);
  
  $tests='';    
  if($deliver_date>$createddates){    
    $tests=" (Future Order)";   
  } else {$tests=" (New Order)";}
  
  
  $dates= $this->prettyDate($data2['date_created'])." ".$this->prettyTime($data2['date_created']);    
      
   $delivery_address='';    
    if($data2['trans_type']=='delivery'){   
        
     if (!empty($data2['client_full_address'])){                  
               $delivery_address=$data2['client_full_address'];   
             } else {$delivery_address=$data2['full_address'];  }   
            
    }   
    
  $transtype= $this->prettyPaymentType('payment_order',   
           $data2['payment_type'],$data2['order_id'],$data2['trans_type']);
      
      
 if($data2['status']=='paid'|| $data2['status']=='successful' || $data2['status']=='delivered'){$st=" Paid ";}else{$st="Not-Paid";}
  // if($transtype=='PAID ONLINE' || $transtype=='ONLINE PAY VIA POLI' || $transtype=='PAYPAL_V2'){$st=" Paid ";}else{$st="Not-Paid";}
      
    $tr.="<tr style='text-align:center'>";    
    $tr.="<td colspan='2' style='border-bottom: 3px solid;' ><b style='font-size: 18px;   font-weight: 600;'>".$st." ".$tests."</b></td></tr>";   
        
    $tr.="<tr><td style='width1: 13%'></td><td style='width1: 13%'> </td></tr>";    
        
        
    $tr.="<tr>";    
    $tr.="<td style='text-align:left' >TRN Date :".$dates."</td>";    
        
        
        
    
    if($data2['request_from']=="pos" &&  $data2['order_number']>0){
      
      $tr.="<td style='text-align:right;float: right;width: 180px;' >Order:".$data2['merchant_id'].'-'.$data2['order_number']."</td></tr>";   
      
      }else if($data2['request_from']=="webappv2" &&  $data2['order_number']>0){      
    
      $tr.="<td style='text-align:right;float: right;width: 180px;' >Order:".$data2['merchant_id'].'-'.$data2['order_number']."</td></tr>"; 
      
      }else {   
    
      $tr.="<td style='text-align:right' >Order:".$data2['order_id']."</td></tr>";    
      
      }

    
    
        
    $tr.="<tr><td  colspan='2' style='border-bottom: 3px solid;'></td></tr>";   
        
        
          
          
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'><b>Order ID</b></td>";    
    //$tr.="<td style='text-align:right'><b>Customer Detail</b></td>";    
    //$tr.="</tr>";   
        
        
     if ( !empty($data2['contact_phone1'])){    
              $data2['contact_phone']=$data2['contact_phone1'];   
             }    
            
            
        
    $tr.="<tr><td colspan='2' style='text-align:center'><b>Customer Detail</b></td></tr>";    
        
    $tr.="<tr><td colspan='2' style='text-align:center'>".$data2['full_name']."</td></tr>";   
        
    $tr.="<tr><td colspan='2' style='text-align:center'>".$data2['contact_phone']."</td></tr>";   
        
    $tr.="<tr><td colspan='2' style='text-align:center'>".$delivery_address."</td></tr>";   
        
    $tr.="<tr><td  colspan='2' style='border-bottom: 3px solid;'></td></tr>";   
        
    //$tr.="<td style='text-align:right'><b>Customer Detail</b></td>";    
    //$tr.="</tr>";       
            
        
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'>".$data2['order_id']."</td>";   
    //$tr.="<td style='text-align:right'>".$data2['full_name']."  </td>";   
    //$tr.="</tr>";   
        
    //$tr.="<tr style='float: left;margin: 1px;'><td style='width1: 13%'></td></tr>";   
        
        
        
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'><b>TRN Date</b></td>";    
    //$tr.="<td style='text-align:right'>".$data2['contact_phone']."</td>";   
    //$tr.="</tr>";   
        
    //$tr.="<tr>";    
        
        
        
        
    //$tr.="<td style='width1: 13%'>".$dates."</td>";   
    //$tr.="<td style='text-align:right'>".$delivery_address."  </td>";   
    //$tr.="</tr>";   
        
    //$tr.="<tr style='float: left;margin:0px;'><td style='width1: 13%'></td></tr>";    
        
        
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'></td>";   
    //$tr.="<td style='text-align:right'>".$data2['merchant_contact_phone']."</td>";    
    //$tr.="</tr>";   
        
    $tr.="<tr style='float: left;margin-top:5px;'>";    
        
    //$tr.="<td style='width1: 13%'><b>Customer Detail</b></td>";   
    //$tr.="<td style='width1: 13%'></td>";   
    //$tr.="</tr>";   
        
    //$tr.="<tr>";    
    //$tr.="<td style='width1: 13%'>".$data2['full_name']."</td>";    
    //$tr.="<td style='width1: 13%'></td>";   
    //$tr.="</tr>";   
        
                
        
    //  $tr.="<tr>";    
    //$tr.="<td style='width1: 13%'>".$data2['contact_phone']."</td>";    
    //$tr.="<td style='width1: 13%'></td>";   
    //$tr.="</tr>";   
        
  //  $tr.="<tr style='float: left;margin: 5px;'><td style='width1: 13%'></td></tr>";   
        
        
        
          
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'><b>Order Type </b></td>";   
    $tr.="</tr>";   
        
    $deliver_date=date('d M',strtotime($data2['delivery_date']));   
        
    $tr.="<tr>";    
    //Custom code starts  
       if($data2['delivery_asap']==1){    
       $tr.="<td colspan='2' style='text-align: center;'>".$data2['trans_type'].','.$deliver_date."</td>";}else{$tr.="<td colspan='2' style='text-align: center;'>".$data2['trans_type'].','.$deliver_date.$this->prettyTime($data2['delivery_time'])."</td>";  
       }    
    //Custom code ends  
      
    $tr.="</tr>";     
        
    $transtype= $this->prettyPaymentType('payment_order',   
           $data2['payment_type'],$data2['order_id'],$data2['trans_type']);   
              
          
          if($data2['is_sop']=='1' && $data2['trans_type']=='pickup'){    
          $transtype='Swipe on Pickup';   
        }   
            
     $transtype=$this->payment_translations($data2['trans_type'],$data2['payment_type'],$data2['is_sop']);   
        
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'><b>Payment type </b></td>";   
    $tr.="</tr>";   
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'>".($transtype)."</td>";    
    $tr.="</tr>";   
        
        
        
    if($data2['trans_type']=='delivery'){   
        
     if (!empty($data2['client_full_address'])){                  
               $delivery_address=$data2['client_full_address'];   
             } else {$delivery_address=$data2['full_address'];  }   
        
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'>".$delivery_address."</td>";    
    $tr.="</tr>";   
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'>".($data2['delivery_instruction'])."</td>";    
    $tr.="</tr>";   
        
        
        
    }
    
//    Custom code 12 starts
    if($data2['trans_type']=='pickup' && $data2['car_park_enable']=='1'){   
      $tr.="<tr>";    
      $tr.="<td colspan='2' style='text-align: center;'><b>Car Park Delivery</b></td>";   
      $tr.="</tr>";   
          
      $tr.="<tr>";    
      $tr.="<td colspan='2' style='text-align: center;'>Yes</td>";    
      $tr.="</tr>";
      
      
      $tr.="<tr>";    
      $tr.="<td colspan='2' style='text-align: center;'><b>Number Plate</b></td>";    
      $tr.="</tr>";   
          
      $tr.="<tr>";    
      $tr.="<td colspan='2' style='text-align: center;'>".$data2['number_plate']."</td>";   
      $tr.="</tr>";
      
    }
    
//    Custom code 12 ends
        
       if($data2['delivery_asap']==1){    
            $tr.="<td colspan='2' style='text-align: center;'>Deliver ASAP:Yes </td>";    
          
     }    
        
     if ($data2['order_change']>=0.1){          
      $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;'>Change:".$this->displayPrice( $this->getCurrencyCode(), $this->normalPrettyPrice($data2['order_change']))." </td>";   
    $tr.="</tr>";   
                
     }    
        
        
        
      
        
        
        
     $tr.="<tr><td  colspan='2' style='border-bottom: 3px solid;'></td></tr>";    
            
    /*    
    if (is_array($data) && count($data)>=1){    
      foreach ($data as $val) {           
        $tr.="<tr>";    
          $tr.="<td><small>".$val['label']."</small></td>";   
        $tr.="<td><small>".stripslashes($val['value'])."</small></td>";   
        $tr.="</tr>";   
      }   
    }*/   
        
    $mid=isset($item_details['total']['mid'])?$item_details['total']['mid']:'';   
    //dump($mid);   
        
    //dump($item_details);    
        
    $tr.="<tr>";    
    $tr.="<td colspan=\"2\">&nbsp;</td>";   
    $tr.="</tr>";   
    if (isset($item_details['item'])){    
      if (is_array($item_details['item']) && count($item_details['item'])>=1){    
        foreach ($item_details['item'] as $item) {    
          //dump($item);    
          $notes='';    
          $item_total=$item['qty']*$item['discounted_price'];   
          if (!empty($item['order_notes'])){    
              $notes="<p style='float:left'>".$item['order_notes']."</p>";    
          }   
          $cookref='';    
          if (!empty($item['cooking_ref'])){    
              $cookref="<p style='float:left'>".$this->qTranslate($item['cooking_ref'],'cooking_name',$item['cooking_name_trans'])."</p>";   
          }   
          $size='';   
          if (!empty($item['size_words'])){   
            $size_words=$this->qTranslate($item['size_words'],'size_name',$item['size_name_trans']);   
              //$size="<p style='float:left'>".$size_words."</p><br/>"; 
              $size=$size_words;   
          }   
              
          $ingredients='';    
          if (isset($item['ingredients'])){   
            if (is_array($item['ingredients']) && count($item['ingredients'])>=1){    
              $ingredients.="<p style='float:left'>".$this->translation("default","Ingredients")."</p>";   
              $ingredients.="<p style='float:left'>";   
              foreach ($item['ingredients'] as $ingredients_val) {    
                if($details_ingredients=$this->getIngredientsByName($ingredients_val,$mid)){    
                  $_ingredients['ingredients_name_trans']=json_decode($details_ingredients['ingredients_name_trans'],true);                           
                  $ingredients.="- ".$this->qTranslate($ingredients_val,'ingredients_name',$_ingredients)."<br/>";   
                      
                } else $ingredients.="- $ingredients_val<br/>";                   
              }   
              $ingredients.="</p>";   
            }   
          }   
              
        //  if (!empty($item['category_id'])){    
        //    $tr.="<tr>";    
        //    $tr.="<td colspan=\"2\"><b>".   
        //    qTranslate($item['category_name'],'category_name',$item['category_name_trans'])."</td>";    
        //    $tr.="</b></tr>";   
        //  }   
             
          $item_name=$this->qTranslate($item['item_name'],'item_name',$item['item_name_trans']);

          $stmt = $this->db->prepare("
          SELECT item_name 
          FROM mt_item 
          WHERE item_id = :item_id
      ");
$stmt->execute([':item_id' => $item['item_id']]);
$item_name = $stmt->fetchColumn();

$item_name =$item_name." " ;
         

              
          $tr.="<tr>";    
              
            /* Custom code 13 starts */
            if($item['promo_id']>0){
            
          $tr.="<td style=\"width:0px; border-bottom:3pt solid black;width: 99%;\"><medium style='float:left'><b style='float:left'>".$item['qty']." x ".$item_name."(Promo ID :".$item['promo_id'].")".$size.$notes.$cookref.$ingredients."</b></medium></td>";  
          
           }else{
          
          $tr.="<td style=\"width:0px; border-bottom:3pt solid black;width: 99%;\"><medium style='float:left'><b style='float:left'>".$item['qty']." x ".$item_name.$size.$notes.$cookref.$ingredients."</b></medium></td>";  
          
           }
           /* Custom code 13 ends */
           
           $tr.="<td style=\"border-bottom:3pt solid black;width: 1%;text-align: right;\"><small style='float:left'><b style='float:left'>".$this->formatNumber($item_total)."</b></small></td>";  
           $tr.="</tr>" ;
                
            //$sms_details.=$item['qty']." x ".$item_name." ".standardPrettyFormat($item_total);    
            $sms_details.=$item['qty']." x ".$item_name.$size.$notes.$cookref.$ingredients." ".$this->standardPrettyFormat($item_total);   
            $sms_details.=$this->smsSeparator();    
                                              
            /*if (isset($item['sub_item'])){    
              if (is_array($item['sub_item']) && count($item['sub_item'])>=1){    
                foreach ($item['sub_item'] as $itemsub) {                       
                  $subitem_total=$itemsub['addon_qty']*$itemsub['addon_price'];                   
                  $tr.="<tr>";                          
                      $tr.="<td style=\"text-indent:10px;\">".$itemsub['addon_qty']."x".FunctionsV3::prettyPrice($itemsub['addon_price'])." ".$itemsub['addon_name']."</td>";   
                      $tr.="<td>".FunctionsV3::prettyPrice($subitem_total)."</td>";   
                      $tr.="</tr>";   
                          
                      $sms_details.=$itemsub['addon_qty']." x ".standardPrettyFormat($itemsub['addon_price']);    
                      $sms_details.=" ".$itemsub['addon_name'];   
                      $sms_details.=FunctionsV3::smsSeparator();    
                }   
              }   
            }*/   
                
            if (isset($item['new_sub_item'])){    
              if (is_array($item['new_sub_item']) && count($item['new_sub_item'])>=1){    
                foreach ($item['new_sub_item'] as $subcategory_name=> $subcategory_item) {    
                  //dump($subcategory_item);    
                      
                  if(!isset($subcategory_item[0])){   
                    $subcategory_item[0]['subcategory_name_trans']='';    
                  }   
                      
                  $subcategory_name_trans=$this->qTranslate($subcategory_name,'subcategory_name',    
                  $subcategory_item[0]['subcategory_name_trans']);    
                      
                  $tr.="<tr>";    
                  $tr.="<td colspan=\"2\">".$subcategory_name_trans."</td>";    
                      
                  $tr.="</tr>";   
                  $sms_details.=$subcategory_name_trans;    
                  $sms_details.=$this->smsSeparator();    
                  foreach ($subcategory_item as $itemsub) {   
                        
                    $addon_name=$this->qTranslate($itemsub['addon_name'],'sub_item_name',    
                    $itemsub['sub_item_name_trans']);   
                        
                    $subitem_total=$itemsub['addon_qty']*$itemsub['addon_price'];                   
                    $tr.="<tr>";    
                        $tr.="<td style=\"text-indent:10px;\">".$itemsub['addon_qty']."x".$this->formatNumber($itemsub['addon_price'])." ".$addon_name."</td>";    
                        $tr.="<td >".$this->formatNumber($subitem_total)."</td>";    
                        $tr.="</tr>";   
                            
                        $sms_details.=$itemsub['addon_qty']." x ".$this->formatNumber($itemsub['addon_price']);    
                          $sms_details.=" ".$addon_name;    
                          $sms_details.=$this->smsSeparator();    
                  }   
                }   
              }   
            }   
                
        }   
      }   
    }   
    $tr.="<tr>";    
    $tr.="<td colspan=\"2\">&nbsp;</td>";   
    $tr.="</tr>";   
        
    //dump($item_details);    
        
    //Yii::app()->functions->additional_details=$sms_details;   
        
    if (isset($item_details['total'])){   
          
      if(!isset($item_details['total']['less_voucher'])){   
        $item_details['total']['less_voucher']='';    
      }   
      if(!isset($item_details['total']['pts_redeem_amt'])){   
        $item_details['total']['pts_redeem_amt']='';    
      }   
      if(!isset($item_details['total']['tips'])){   
        $item_details['total']['tips']='';    
      }   
          
      if ($item_details['total']['less_voucher']>0.001){    
        $tr.="<tr>";    
        $tr.="<td>".$this->translation("default","Less Voucher")." " .$item_details['total']['voucher_type'] . ":</td>";    
        $tr.="<td style='text-align:right'>(".$this->formatNumber($item_details['total']['less_voucher']).")</td>";    
        $tr.="</tr>";   
      }   
          
      if ($item_details['total']['pts_redeem_amt']>0.001){    
        $tr.="<tr>";    
        $tr.="<td>".$this->translation("default","Points discount").":</td>";   
        $tr.="<td style='text-align:right'>(".$this->formatNumber($item_details['total']['pts_redeem_amt']).")</td>";    
        $tr.="</tr>";   
      }   
                
      if(!isset($item_details['total']['discounted_amount'])){    
        $item_details['total']['discounted_amount']=0;    
      }   
          
      if($item_details['total']['calculation_method']==1){    
        if($item_details['total']['discounted_amount']>0.001){    
          $tr.="<tr>";    
            $tr.="<td>".$this->translation("default","Discount")." " . $item_details['total']['merchant_discount_amount_new']  ."% :</td>";   
            $tr.="<td style='text-align:right'>".$this->formatNumber($item_details['total']['discounted_amount'])."</td>";   
            $tr.="</tr>";   
        }   
      }   
                
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Sub Total").":</td>";   
      $tr.="<td style='text-align:right'>".$this->formatNumber($item_details['total']['subtotal'])."</td>";    
      $tr.="</tr>";   
          
      if (!empty($item_details['total']['delivery_charges'])):    
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Delivery Fee").":</td>";    
      $tr.="<td style='text-align:right'>".$this->formatNumber($item_details['total']['delivery_charges'])."</td>";    
      $tr.="</tr>";   
      endif;    
          
              
      if (!empty($item_details['total']['merchant_packaging_charge'])):   
      if ($item_details['total']['merchant_packaging_charge']>0.0001){    
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Packaging").":</td>";   
      $tr.="<td style='text-align:right'>".$this->formatNumber($item_details['total']['merchant_packaging_charge'])."</td>";   
      $tr.="</tr>";   
      }   
      endif;    
          
      /* Hide Tax field in the merchant email */    
          
//      if(isset($item_details['total']['tax_amt'])){   
//        $tr.="<tr>";    
//        $tr.="<td>".Yii::t("default","Tax")." ".$item_details['total']['tax_amt']."%</td>";   
//        $tr.="<td>".FunctionsV3::prettyPrice($item_details['total']['taxable_total'])."</td>";    
//        $tr.="</tr>";   
//      }   
          
      if (!isset($item_details['total']['card_fee'])){    
        $item_details['total']['card_fee']='';    
      }   
          
      if ($item_details['total']['card_fee']>0):    
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Card Fee").":</td>";    
      $tr.="<td style='text-align:right'>".$this->formatNumber($item_details['total']['card_fee'])."</td>";    
      $tr.="</tr>";   
      endif;    
          
      if ($item_details['total']['tips']>0.001){    
        $tr.="<tr>";    
        $tr.="<td>".$this->translation("default","Tips")." " .$item_details['total']['tips_percent'] . ":</td>";    
        $tr.="<td style='text-align:right'>".$this->formatNumber($item_details['total']['tips'])."</td>";    
        $tr.="</tr>";   
      }   
          
      if($item_details['total']['calculation_method']==2){    
        if($item_details['total']['less_voucher_orig']>0.01){   
          $tr.="<tr>";    
          $tr.="<td>".$this->translation("default","Voucher"). ":</td>";    
          $tr.="<td style='text-align:right'>(".$this->formatNumber($item_details['total']['less_voucher_orig']).")</td>";   
          $tr.="</tr>";   
        }   
            
        if($item_details['total']['pts_redeem_amt_orig']>0.01){   
          $tr.="<tr>";    
          $tr.="<td>".$this->translation("default","Points Discount"). ":</td>";    
          $tr.="<td style='text-align:right'>(".$this->formatNumber($item_details['total']['pts_redeem_amt_orig']).")</td>";   
          $tr.="</tr>";   
        }   
            
        if($item_details['total']['discounted_amount']>0.001){    
          $tr.="<tr>";    
            $tr.="<td>".$this->translation("default","Discount")." " . $item_details['total']['merchant_discount_amount_new']  ."% :</td>";   
            $tr.="<td style='text-align:right'>(".$this->formatNumber($item_details['total']['discounted_amount']).")</td>";   
            $tr.="</tr>";   
        }   
      }   
          
      $tr.="<tr>";    
      $tr.="<td>".$this->translation("default","Total").":</td>";   
      $tr.="<td style='text-align:right'>".$this->formatNumber($item_details['total']['total'])."</td>";   
      $tr.="</tr>";   
          
          
            
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center; border-top: 3pt solid black;'><b style='font-weight:600'>Merchant Detail</b></td>";    
    $tr.="</tr>";   
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;font-size: 13px;'>".$data2['merchant_name']."</td>";    
    $tr.="</tr>";   
        
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;font-size: 13px;'>".$address."</td>";   
    $tr.="</tr>";   
        
        
     $merchant_tax_number=$this->getOption('merchant_tax_number',$data2['merchant_id']);   
         if (!empty($merchant_tax_number)){   
        
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;    font-size: 13px;'>Gst :".$merchant_tax_number."</td>";    
    $tr.="</tr>";   
       }    
    $tr.="<tr>";    
    $tr.="<td colspan='2' style='text-align: center;     font-size: 13px;   border-bottom: 3pt solid black;'>Phone # :".$data2['merchant_contact_phone']."</td>";   
    $tr.="</tr>";   
          
          
    }ob_start();?><table border="0" style='width: 100%;'>   
    <?php echo $tr;?>       
    </table>    
    <?php $receipt = ob_get_contents();ob_end_clean();    
        return $receipt;    
  } 



  public function isBookingDataValid($merchant_id)
{
    // Get options
    $stores_open_starts_raw   = $this->getOption("stores_open_starts", $merchant_id);
    $stores_open_ends_raw     = $this->getOption("stores_open_ends", $merchant_id);
    $stores_open_pm_start_raw = $this->getOption("stores_open_pm_start", $merchant_id);
    $stores_open_pm_ends_raw  = $this->getOption("stores_open_pm_ends", $merchant_id);
    $stores_open_day_raw      = $this->getOption("stores_open_day", $merchant_id);

    // Convert JSON to arrays
    $starts   = !empty($stores_open_starts_raw)   ? json_decode($stores_open_starts_raw, true)   : [];
    $ends     = !empty($stores_open_ends_raw)     ? json_decode($stores_open_ends_raw, true)     : [];
    $pm_start = !empty($stores_open_pm_start_raw) ? json_decode($stores_open_pm_start_raw, true) : [];
    $pm_end   = !empty($stores_open_pm_ends_raw)  ? json_decode($stores_open_pm_ends_raw, true)  : [];
    $days     = !empty($stores_open_day_raw)      ? json_decode($stores_open_day_raw, true)      : [];

    // ---- 1. Validate open days ----
    if (empty($days) || !is_array($days)) {
        return false;
    }

    $valid_days = [];
    foreach ($days as $k => $v) {
        if (is_string($k) && trim($k) !== '') $valid_days[] = strtolower(trim($k));
        if (is_string($v) && trim($v) !== '') $valid_days[] = strtolower(trim($v));
    }
    $valid_days = array_unique($valid_days);
    if (count($valid_days) == 0) return false;

    // ---- 2. Validate existence of ANY time ----
    $anyTimes = $this->arrayHasNonEmpty($starts) || $this->arrayHasNonEmpty($ends)
               || $this->arrayHasNonEmpty($pm_start) || $this->arrayHasNonEmpty($pm_end);
    if (!$anyTimes) return false;

    // ---- 3. Validate daily shifts ----
    foreach ($valid_days as $day) {
        $s1_start = $starts[$day] ?? '';
        $s1_end   = $ends[$day] ?? '';
        $s2_start = $pm_start[$day] ?? '';
        $s2_end   = $pm_end[$day] ?? '';

        // Has complete shift?
        $hasShift1 = (!empty($s1_start) && !empty($s1_end));
        $hasShift2 = (!empty($s2_start) && !empty($s2_end));

        // If no complete shifts at all -> invalid day
        if (!$hasShift1 && !$hasShift2) return false;

        // Incomplete check
        if ((!empty($s1_start) && empty($s1_end)) || (empty($s1_start) && !empty($s1_end))) return false;
        if ((!empty($s2_start) && empty($s2_end)) || (empty($s2_start) && !empty($s2_end))) return false;

        // Invalid shift order
        if ($hasShift1 && strtotime($s1_start) >= strtotime($s1_end)) return false;
        if ($hasShift2 && strtotime($s2_start) >= strtotime($s2_end)) return false;
    }

    return true;
}

public function arrayHasNonEmpty($arr)
{
    if (empty($arr) || !is_array($arr)) return false;
    foreach ($arr as $v) {
        if (trim((string)$v) !== '') return true;
    }
    return false;
}  


  public  function tableRow_euro($label='', $value='')
  {
    $html='<tr>';
      $html.="<td class=\"col-1\">$label</td>";
      $html.="<td class=\"col-2\">$value</td>";
    $html.='</tr>';
    return $html;
  }



    public  function computeWithTax($data=array(), $merchant_id='')
  {
        
    $total_plus_charges = 0; $total_food=0; $grand_total=0;
    
    /*GET TOTAL FOOD*/
    if(is_array($data['item']) && count($data['item'])>=1){
      foreach ($data['item'] as $row => $item) {
        
         $price=$item['normal_price'];
           if ( $item['discount']>0){
            $price=$item['discounted_price'];
           }
           $total_food+=$item['qty']*$price;
           
           if (is_array($item['new_sub_item']) && count($item['new_sub_item'])>=1){
               foreach ($item['new_sub_item'] as $sub_name => $sub_item){
                 foreach ($sub_item as $sub_item2){                  
                   $total_food+=$sub_item2['addon_price']*$sub_item2['addon_qty'];
                 }
               }  
           }           
      }
    }
        
    $data_total = $data['total'];     
        
    $debug = false;
    if(isset($_GET['debug'])){    
      $debug=true;
    }
    
    if($debug){
       echo($data_total);
       echo("total food :$total_food");
    }
    
    $total_plus_charges = $total_food;
    if (isset($data_total['delivery_charges'])){
      if($data_total['delivery_charges']>0.001){        
        $total_plus_charges+=$data_total['delivery_charges'];
      }
    }
    if (isset($data_total['merchant_packaging_charge'])){
      if($data_total['merchant_packaging_charge']>0.001){
        $total_plus_charges+=$data_total['merchant_packaging_charge'];
      }
    }
    
    if (isset($data_total['card_fee'])){
      if ($data_total['card_fee']>0.001){
        $total_plus_charges+=$data_total['card_fee'];
      }
    }
        
    if ( $data_total['cart_tip_percentage']>0.001){
      $data_total['tips']=$total_food*($data_total['cart_tip_percentage']/100);
      $total_plus_charges+=+$data_total['tips'];
    }
    
    if (isset($data_total['less_voucher'])){
      if ($data_total['less_voucher']>0.001){
        if (empty($data_total['voucher_type'])){      
           $total_plus_charges+=-$data_total['less_voucher'];
        } else {
           $data_total['less_voucher']=$total_food*($data_total['voucher_value']/100);  
           $total_plus_charges+=-$data_total['less_voucher'];
        }
      }
    }
    
    if (isset($data_total['pts_redeem_amt'])){
      if ($data_total['pts_redeem_amt']>0.001){
        $total_plus_charges+=-$data_total['pts_redeem_amt'];
      }
    }
        
    if($debug){
       dump("total_plus_charge :$total_plus_charges");
    }
    
    $grand_total+=$total_plus_charges;
    
    if ( $data_total['discounted_amount']>0.001){ 
      $data_total['discounted_amount']=$total_food*($data_total['merchant_discount_amount']/100);
      $grand_total+=-$data_total['discounted_amount'];
    }
    
    if($debug){
       dump("grand total :".$grand_total);
    }
    
    $tax = $this->getMerchantTax($merchant_id);
    
    if($debug){
       echo("tax :".$tax);
    }
    
    $data_total['total']=$grand_total;
        $data_total['subtotal']=$grand_total/($tax+1); 
        $data_total['taxable_total']=$data_total['total']-$data_total['subtotal'];
    
    $tasxa=$this->normalPrettyPrice( $data_total['taxable_total']*100).'%';
    $data_total['tax_label']="TaxABC ".$tasxa;
    

        if($debug){
           echo("tax :".$data_total['taxable_total']);
        }                   
    return $data_total;
  }


  public function getMerchantTax($mtid='')
  {
    $merchant_tax=$this->getOption('merchant_tax',$mtid);
    if($merchant_tax>0){
        $merchant_tax=$merchant_tax/100;
        return $merchant_tax;
    }
    return false;
  }



  public  function salesReceiptTax($data='',$item_details='')
  {     
        
    $tr=""; $sms_details='';
    if (is_array($data) && count($data)>=1){
      foreach ($data as $val) {       
        $tr.="<tr>";
        $tr.="<td>".$val['label']."</td>";
        $tr.="<td>".stripslashes($val['value'])."</td>";
        $tr.="</tr>";
      }
    }
    
    $mid=isset($item_details['total']['mid'])?$item_details['total']['mid']:'';
    
    $tr.="<tr>";
    $tr.="<td colspan=\"2\">&nbsp;</td>";
    $tr.="</tr>";
    if (isset($item_details['item'])){
      if (is_array($item_details['item']) && count($item_details['item'])>=1){
        foreach ($item_details['item'] as $item) {
          //dump($item);
          $notes='';
          $item_total=$item['qty']*$item['discounted_price'];
          if (!empty($item['order_notes'])){
              $notes="<p>".$item['order_notes']."</p>";
          }
          $cookref='';
          if (!empty($item['cooking_ref'])){            
              $cookref="<p>".$this->qTranslate($item['cooking_ref'],'cooking_name',$item['cooking_name_trans'])."</p>";
          }
          $size='';         
          if (!empty($item['size_words'])){
            $size_words=$this->qTranslate($item['size_words'],'size_name',$item['size_name_trans']);
              $size="<p>".$size_words."</p>";
          }
          
          $ingredients='';
          if (isset($item['ingredients'])){
            if (is_array($item['ingredients']) && count($item['ingredients'])>=1){
              $ingredients.="<p>"."Ingredients"."</p>";
              $ingredients.="<p>";
              foreach ($item['ingredients'] as $ingredients_val) {
                $ingredients.="- $ingredients_val<br/>";
              }
              $ingredients.="</p>";
            }
          }
          
          if (!empty($item['category_id'])){
            $tr.="<tr>";
            $tr.="<td colspan=\"2\"><b>".
            $this->qTranslate($item['category_name'],'category_name',$item['category_name_trans'])."</td>";
            $tr.="</b></tr>";
          }
          
          $item_name=$this->qTranslate($item['item_name'],'item_name',$item['item_name_trans']);
          
          $tr.="<tr>";
            $tr.="<td>".$item['qty']." ".$item_name.$size.$notes.$cookref.$ingredients."</td>";
            $tr.="<td>".$this->formatNumber($item_total)."</td>";
            $tr.="</tr>";
            
            
             if (isset($item['new_sub_item'])){
              if (is_array($item['new_sub_item']) && count($item['new_sub_item'])>=1){
                foreach ($item['new_sub_item'] as $subcategory_name=> $subcategory_item) {
                  
                  if(!isset($subcategory_item[0])){
                    $subcategory_item[0]['subcategory_name_trans']='';
                  }
                  
                  $tr.="<tr>";
                  $tr.="<td colspan=\"2\">".$this->qTranslate($subcategory_name,'subcategory_name',
                  $subcategory_item[0]['subcategory_name_trans'])."</td>";
                  
                  $tr.="</tr>";
                                                    
                  foreach ($subcategory_item as $itemsub) {
                    
                    $addon_name=$this->qTranslate($itemsub['addon_name'],'sub_item_name',
                    $itemsub['sub_item_name_trans']);
                    
                    $subitem_total=$itemsub['addon_qty']*$itemsub['addon_price'];               
                    $tr.="<tr>";
                        $tr.="<td style=\"text-indent:10px;\">".$itemsub['addon_qty']."x".$this->formatNumber($itemsub['addon_price'])." ".$addon_name."</td>";
                        $tr.="<td>".$this->formatNumber($subitem_total)."</td>";
                        $tr.="</tr>";
                                                
                  }
                }
              }
            }
            
        }
      }
    }
    $tr.="<tr>";
    $tr.="<td colspan=\"2\">&nbsp;</td>";
    $tr.="</tr>";   
    $data_total=$item_details['total'];
    
    if ($data_total['delivery_charges']>0){
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Delivery Fee").":</td>";
      $tr.="<td>".$this->formatNumber($data_total['delivery_charges'])."</td>";
      $tr.="</tr>";
    }
    
    if ($data_total['service_fee']>0){
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Service Fee").":</td>";
      $tr.="<td>".$this->formatNumber($data_total['service_fee'])."</td>";
      $tr.="</tr>";
    }

    if(isset($data_total['card_fee'])){
    if ($data_total['card_fee']>0){
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Card Fee").":</td>";
      $tr.="<td>".$this->formatNumber($data_total['card_fee'])."</td>";
      $tr.="</tr>";
    }
    }

    if(isset($data_total['merchant_packaging_charge'])){
    if ($data_total['merchant_packaging_charge']>0){
      $tr.="<tr>";
      $tr.="<td>".$this->translation("default","Packaging").":</td>";
      $tr.="<td>".$this->formatNumber($data_total['merchant_packaging_charge'])."</td>";
      $tr.="</tr>";
    }
    }
    
    if(isset($data_total['cart_tip_percentage'])){
    if ($data_total['cart_tip_percentage']>0){
      $tr.="<tr>";
      $tr.="<td>". "Tip"." ".$data_total['cart_tip_percentage']."%:</td>";
      $tr.="<td>".$this->formatNumber($data_total['tips'])."</td>";
      $tr.="</tr>";
    }
    }
    
    if(isset($data_total['discounted_amount'])){
    if ($data_total['discounted_amount']>0){
      $tr.="<tr>";
      $tr.="<td>"."Discount"." ".$data_total['merchant_discount_amount']."%:</td>";
      $tr.="<td>".$this->formatNumber($data_total['discounted_amount'])."</td>";
      $tr.="</tr>";
    }
    }
    
    if(isset($data_total['pts_redeem_amt'])){
    if ($data_total['pts_redeem_amt']>0){
      $tr.="<tr>";
      $tr.="<td>"."Points Discount".":</td>";
      $tr.="<td>".$this->formatNumber($data_total['pts_redeem_amt'])."</td>";
      $tr.="</tr>";
    }
    }
    
    if(isset($data_total['less_voucher'])){
    if ($data_total['less_voucher']>0){
      $tr.="<tr>";
      $tr.="<td>"."Less Voucher"." ".":</td>";
      $tr.="<td>".$this->formatNumber($data_total['less_voucher'])."</td>";
      $tr.="</tr>";
    }
    }
    
    if(isset($data_total['subtotal'])){
    if ($data_total['subtotal']>0){
      $tr.="<tr>";
      $tr.="<td>"."Sub Total".":</td>";
      $tr.="<td>".$this->formatNumber($data_total['subtotal'])."</td>";
      $tr.="</tr>";
    }
    }
    
    if(isset($data_total['taxable_total'])){
    if ($data_total['taxable_total']>0){
      $tr.="<tr>";
      $tr.="<td>"."Tax"." ".$data_total['tax_amt']."%:</td>";
      $tr.="<td>".$this->formatNumber($data_total['taxable_total'])."</td>";
      $tr.="</tr>";
    }
    }
    
    if(isset($data_total['total'])){
    if ($data_total['total']>0){
      $tr.="<tr>";
      $tr.="<td>"."Total".":</td>";
      $tr.="<td>".$this->formatNumber($data_total['total'])."</td>";
      $tr.="</tr>";
    }
    }
    
    $website_enabled_rcpt=$this->getOptionAdmin("website_enabled_rcpt");
    ob_start();
    ?>
    <?php if ($website_enabled_rcpt==2):?>
    <!--<div style="display: block;max-height: 70px;max-width: 200px;">-->
    <?php //echo Widgets::receiptLogo();?>
    <!--</div>    -->
    <?php endif;?>
    <table border="0">
    <?php echo $tr;?>   
    </table>
    <?php 
    $receipt = ob_get_contents();
        ob_end_clean();
        return $receipt;
  } 





public function GetTables($id = '')
{
    if (empty($id)) {
        return false;
    }

    try {
        // Prepare the SQL query
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_table
            WHERE id = :id
            LIMIT 0, 1
        ");
        
        // Bind the ID parameter to the query
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        
        // Execute the query
        $stmt->execute();
        
        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($res) {
            return $res;
        }
    } catch (PDOException $e) {
        // Handle any errors here
        return false;
    }
    
    return false;
}















public function cleanNumber($string='')
{
    return preg_replace("/[^0-9^.]/","",$string);
}

public function unPrettyPrice($price='')
    {
        if ( !empty($price)){
            //return number_format($price,2,".","");
            return str_replace(",","",$price);
        }
        return false;
    }


    public function deleteAddonCategory($merchant_id = 0, $id = 0)
{
    try {
        // Get the PDO connection from the Model class
        $connection = $this->db;

        // Prepare the delete query
        $stmt = "
            DELETE FROM mt_subcategory
            WHERE merchant_id = :merchant_id
            AND subcat_id = :subcat_id
        ";

        // Prepare the statement
        $query = $connection->prepare($stmt);

        // Bind the parameters
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindParam(':subcat_id', $id, PDO::PARAM_INT);

        // Execute the statement
        if ($query->execute()) {
            // Call the deleteRelationship method for related records
            $this->deleteRelationship($id, 'subcat_id', 'mt_subcategory_translation');
            $this->deleteRelationship($id, 'subcat_id', 'mt_item_relationship_subcategory');
            return true;
        }

        // If the query fails, throw an exception
        throw new Exception("Failed, cannot delete records");
    } catch (Exception $e) {
        throw new Exception($e->getMessage());
    }
}


public function getMerchantOffers($merchant_id = '', $start = '', $end = '', $applicable_to = '', $id = '')
{
    $and = '';
    
    if (!empty($id)) { 
        $and = "AND offers_id != :id ";
    }

    // Prepare the SQL statement
    $stmt = "SELECT * FROM mt_offers
              WHERE status IN ('publish', 'published')
              AND :start >= valid_from AND :end <= valid_to
              AND merchant_id = :merchant_id
              AND applicable_to = :applicable_to
              $and
              LIMIT 1";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind parameters
    $query->bindParam(':start', $start);
    $query->bindParam(':end', $end);
    $query->bindParam(':merchant_id', $merchant_id);
    $query->bindParam(':applicable_to', $applicable_to);
    
    if (!empty($id)) {
        $query->bindParam(':id', $id);
    }

    // Execute the query
    $query->execute();

    // Fetch the result
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }
    
    return false;
}





public function get_stp_payment_status($session_id, $merchant_id)
{
    require_once __DIR__ . '/../../vendor/stripe/init.php';

    if ($credentials = $this->getCredentials_stripe($merchant_id)) {
        try {
            \Stripe\Stripe::setApiKey($credentials['secret_key']);

            // Step 1: Retrieve Checkout Session (cs_...)
            $session = \Stripe\Checkout\Session::retrieve($session_id);

            if (empty($session->payment_intent)) {
                return ['error' => 'No payment intent found in session'];
            }

            // Step 2: Retrieve actual PaymentIntent (pi_...)
            $paymentIntent = \Stripe\PaymentIntent::retrieve($session->payment_intent);

            return $paymentIntent;

        } catch (\Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }

    return ['error' => 'Invalid Stripe credentials'];
}

public function get_stp_payment_status_stripe_test($session_id, $merchant_id)
{
    require_once __DIR__ . '/../../vendor/stripe/init.php';

    if ($credentials = $this->getCredentials_stripe($merchant_id)) {
        try {
            \Stripe\Stripe::setApiKey($credentials['secret_key']);

            // Step 1: Retrieve Checkout Session (cs_...)
            //$session = \Stripe\Checkout\Session::retrieve($session_id);

            if (empty($session->payment_intent)) {
              //  return ['error' => 'No payment intent found in session'];
            }

            // Step 2: Retrieve actual PaymentIntent (pi_...)
            $paymentIntent = \Stripe\PaymentIntent::retrieve($session_id);

            return $paymentIntent;

        } catch (\Exception $e) {
            return ['error' => $e->getMessage()];
        }
    }

    return ['error' => 'Invalid Stripe credentials'];
}









   public function getAddOnLists($merchant_id = '')
{
    $pdo = $this->db; // Assuming $this->db is your PDO connection instance
    $data_feed = array();

    $stmt = "
        SELECT * 
        FROM mt_subcategory
        WHERE merchant_id = :merchant_id
        ORDER BY sequence ASC
    ";

    $query = $pdo->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            if ($this->data == "list") {
                foreach ($rows as $val) {
                    $data_feed[$val['subcat_id']] = $val['subcategory_name'];
                }
                return $data_feed;
            } else {
                return $rows;
            }
        }
    }

    return false;
}

public  function updatePoints_module($order_id='', $order_status='')
    {
       
           $this->PointsProgram = new PointsProgram();
                $this->PointsProgram->updateOrderBasedOnStatus($order_status,$order_id);
            
        
    }


    public function getFoodItemLists($merchant_id = '')
{
    $pdo = $this->db; // Assuming $this->db is your PDO connection instance
    $where = '';

    if (is_numeric($merchant_id)) {
        $where = " WHERE merchant_id = :merchant_id";
    }

    $data_feed = array();
    $stmt = "
        SELECT * 
        FROM mt_item
        $where
        ORDER BY sequence ASC
    ";

    $query = $pdo->prepare($stmt);

    if (is_numeric($merchant_id)) {
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    }

    if ($query->execute()) {
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($rows && count($rows) >= 1) {
            if ($this->data == "list") {
                foreach ($rows as $val) {
                    $data_feed[$val['item_id']] = $val['item_name'];
                }
                return $data_feed;
            } else {
                return $rows;
            }
        }
    }

    return false;
}


public function getFoodItemList($merchant_id = '')
{
    $data_feed = array();
    
    // Prepare the SQL query with a placeholder for the merchant_id
    $stmt = "
    SELECT * FROM
    mt_item
    WHERE 
    merchant_id = :merchant_id
    ORDER BY sequence ASC
    ";

    try {
        // Assuming $this->db is already an established PDO connection
        $connection = $this->db;
        $query = $connection->prepare($stmt);

        // Bind the merchant_id parameter to the query
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the query
        $query->execute();

        // Fetch all the rows
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        // Check if rows exist and process the data
        if (is_array($rows) && count($rows) >= 1) {
            if ($this->data == "list"||1==1) {
                foreach ($rows as $val) {
                    $data_feed[$val['item_id']] = $val['item_name'];
                }
                return $data_feed;
            } else {
                return $rows;
            }
        }

    } catch (PDOException $e) {
        // Handle any PDO exceptions here
        echo "Database error: " . $e->getMessage();
    }

    return FALSE;
}



public function getFoodItemList_sort($merchant_id = '')
{
    $data_feed = array();

    // Use parameterized query for security
    $stmt = "
        SELECT * FROM
        mt_item
        WHERE 
        merchant_id = ?
        ORDER BY sequence ASC
    ";

    try {
        $connection = $this->db;
        $query = $connection->prepare($stmt);

        // Bind merchant_id as integer
        $query->execute([$merchant_id]);

        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            if ($this->data == "list") {
                foreach ($rows as $val) {
                    $data_feed[$val['item_id']] = $val['item_name'];
                }
                return $data_feed;
            } else {
                return $rows;
            }
        }

    } catch (PDOException $e) {
        // Log error or handle appropriately
        echo "Database error: " . $e->getMessage();
    }

    return false;
}

 

public function windcavestatus($sessionId,$merchant_id){



   

    $paymode=$this->getOption('windcave_mode',$merchant_id);
    $merchant_type=$this->getMerchantMembershipType($merchant_id);
    if($merchant_type=='1'){
          $paymode=$this->getOption('windcave_mode',$merchant_id);
          if($paymode=='Sandbox'){
          $apiUsername = $this->getOption('wind_user_id_sandbox', $merchant_id);
          $apiKey = $this->getOption('wind_key_sandbox', $merchant_id);

          }else{
          $apiUsername = $this->getOption('wind_user_id', $merchant_id);
          $apiKey = $this->getOption('wind_key', $merchant_id);
          }


        }else{
          $paymode=$this->getOptionAdmin('windcave_mode');

          if($paymode=='Sandbox'){
          $apiUsername = $this->getOptionAdmin('wind_user_id_sandbox');
          $apiKey = $this->getOptionAdmin('wind_key_sandbox');
          }else{
          $apiUsername = $this->getOptionAdmin('wind_user_id');
          $apiKey = $this->getOptionAdmin('wind_key');
          }
        }
       

      if($paymode=='Sandbox'){
      $url = 'https://uat.windcave.com/api/v1/sessions/' . urlencode($sessionId);
      }else{
      $url = 'https://sec.windcave.com/api/v1/sessions/' . urlencode($sessionId);  
      }


    // $resp = $this->windcave_request('GET', $url,$apiUsername,$apiKey);

      //+++
     $username = $apiUsername; // store in env
    $password = $apiKey;

$body = null;
$method='GET';
    

    $ch = curl_init();
    $headers = ['Content-Type: application/json'];
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, "$username:$password");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper($method));
    if ($body !== null) {
        $json = json_encode($body);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        $headers[] = 'Content-Length: ' . strlen($json);
    }
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    $resp = curl_exec($ch);



    $data = json_decode($resp, true);
    //$acquirerResponse = $data['transactions'][0]['acquirer']['responseText']??$data['transactions'][0]['responseText'];
    
    $txn = $data['transactions'][0] ?? [];

$acquirerResponse = !empty($txn['acquirer']['responseText'])
    ? $txn['acquirer']['responseText']
    : ($txn['responseText'] ?? 'response');
    
    
    
    $merchantRef = $data['transactions'][0]['merchantReference'] ?? null;
    if ($merchantRef) {
   
    $orderId = str_replace("Order#", "", $merchantRef);
    
    }



    

    $params=array(
          'payment_type'=>"windcave",
          'payment_reference'=>$data['transactions'][0]['id'],
          'order_id'=> $orderId,
          'merchant_ref'=> $orderId,
          'raw_response'=> json_encode($data, true),
          'ip_address'=>$_SERVER['REMOTE_ADDR']          
        );  





    $this->insertData('mt_payment_order', $params);  


    $params_log=array( 
                        'order_id'=>$orderId, 
                        'ip_address'=>$_SERVER['REMOTE_ADDR'],
                        'status'=>"not paid",
                        'remarks'=>"cancel"
                      
                        ); 

    $this->insertData('mt_order_log', $params_log); 
   


        
            
             return $acquirerResponse;
                             
        
             
        
     

      //---

     


}







public function getCategory2($cat_id = '')
{
    $mid = $this->getMerchantID();
    
    // Prepare the SQL query
    $stmt = "SELECT * FROM mt_category
             WHERE cat_id = :cat_id
             AND merchant_id = :merchant_id
             ORDER BY cat_id DESC";
    
    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);
    
    // Bind the parameters
    $query->bindParam(':cat_id', $cat_id, PDO::PARAM_INT);
    $query->bindParam(':merchant_id', $mid, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Fetch the result
    $result = $query->fetch(PDO::FETCH_ASSOC);
    
    if ($result) {
        return $result;
    }
    
    return false;
}


public function getDishList()
{
    // Get the PDO instance from the class
    $pdo = $this->db;

    // Define the SQL query with placeholders if needed
    $stmt = "SELECT * FROM mt_dishes
             WHERE status IN ('publish', 'published')
             ORDER BY dish_name ASC";

    try {
        // Prepare the SQL statement
        $query = $pdo->prepare($stmt);

        // Execute the statement
        $query->execute();

        // Fetch all results
        $results = $query->fetchAll(PDO::FETCH_ASSOC);

        // Check if results are not empty
        if ($results) {
            return $results;
        }
    } catch (PDOException $e) {
        // Handle potential exceptions
        echo "Error: " . $e->getMessage();
    }

    return false;
}


public function validateMerchantCanPost($merchant_id = '')
{
    // Prepare the SQL statement with placeholders
    $stmt = "
        SELECT a.merchant_id,
               a.package_id,
               a.is_commission,
               b.unlimited_post,
               b.post_limit,
               (
                 SELECT count(*)
                 FROM mt_item
                 WHERE merchant_id = a.merchant_id
               ) AS total_post
        FROM mt_merchant a
        LEFT JOIN mt_packages b
          ON a.package_id = b.package_id
        WHERE a.merchant_id = :merchant_id
        LIMIT 1
    ";

    // Prepare the query using $this->db
    $query = $this->db->prepare($stmt);

    // Bind the merchant_id parameter
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        // Check if the merchant is on a commission-based package
        if ($res['is_commission'] == 2) {
            return true;
        }

        // Check if the package has unlimited posts or if the limit has been reached
        if ($res['unlimited_post'] == 1) {
            if ($res['total_post'] >= $res['post_limit']) {
                return false;
            }
        }
    }

    return true;
}

 public function checkifbarcodeexistwithitem($barcode = '', $mid = '0', $item = '0')
{
    // Prepare the SQL statement with placeholders
    $stmt = "
        SELECT * 
        FROM mt_item
        WHERE item_id != :item_id
          AND merchant_id = :merchant_id
          AND barcode = :barcode
    ";

    // Prepare the query using $this->db
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':item_id', $item, PDO::PARAM_INT);
    $query->bindParam(':merchant_id', $mid, PDO::PARAM_INT);
    $query->bindParam(':barcode', $barcode, PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}
public function checkifbarcodeexist($barcode = '', $mid = '0')
{
    // Prepare the SQL statement with placeholders
    $stmt = "
        SELECT * 
        FROM mt_item
        WHERE merchant_id = :merchant_id
          AND barcode = :barcode
    ";

    // Prepare the query using $this->db
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':merchant_id', $mid, PDO::PARAM_INT);
    $query->bindParam(':barcode', $barcode, PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;
}


public function generateFoodToken()
{
    // Generate a random token
    $token = $this->generateCode(20);

    // Prepare the SQL query
    $stmt = "
        SELECT item_token 
        FROM mt_item
        WHERE item_token = :item_token
        LIMIT 1
    ";

    // Prepare the query using $this->db
    $query = $this->db->prepare($stmt);

    // Bind the token parameter
    $query->bindParam(':item_token', $token, PDO::PARAM_STR);

    // Execute the query
    $query->execute();
 
    // Fetch the result
    $resp = $query->fetch(PDO::FETCH_ASSOC);

    // If the token exists, recursively generate a new one
    if ($resp) {
        $token = $this->generateFoodToken();
    }

    return $token;
}

public function insertItemRelationship($merchant_id = '', $item_id = 0, $data = array())
{
    // Delete existing relationships first
    $this->deleteItemRelationshipCategory($merchant_id, $item_id);

    // Check if data array is valid and non-empty
    if (is_array($data) && count($data) >= 1) {
        // Loop through each category ID in the data array
        foreach ($data as $cat_id) {
            // Prepare SQL query to insert item relationships
            $stmt = "
                INSERT INTO mt_item_relationship_category (merchant_id, item_id, cat_id)
                VALUES (:merchant_id, :item_id, :cat_id)
            ";

            // Prepare the PDO statement
            $query = $this->db->prepare($stmt);

            // Bind parameters to prevent SQL injection
            $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
            $query->bindParam(':cat_id', $cat_id, PDO::PARAM_INT);

            // Execute the query
            $query->execute();
        }
    }
}


  public function deleteItemRelationshipCategory($merchant_id = '', $item_id = '')
{
    // Prepare SQL query to delete item relationships
    $stmt = "
        DELETE FROM mt_item_relationship_category
        WHERE merchant_id = :merchant_id AND item_id = :item_id
    ";

    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);

    // Bind parameters to ensure secure input
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();
}


public function insertItemRelationshipSubcategory($merchant_id = '', $item_id = 0, $data = array())
{
    // Delete existing relationships first
    $this->deleteItemRelationshipSubcategory($merchant_id, $item_id);
    $this->deleteItemRelationshipSubcategoryItem($merchant_id, $item_id);

    // Check if data array is valid and non-empty
    if (is_array($data) && count($data) >= 1) {
        foreach ($data as $subcat_id => $val) {
            // Insert into mt_item_relationship_subcategory
            $stmt = "
                INSERT INTO mt_item_relationship_subcategory (merchant_id, item_id, subcat_id)
                VALUES (:merchant_id, :item_id, :subcat_id)
            ";

            $query = $this->db->prepare($stmt);
            $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
            $query->bindParam(':subcat_id', $subcat_id, PDO::PARAM_INT);
            $query->execute();

            // If there are subcategory items, insert into mt_item_relationship_subcategory_item
            if (is_array($val) && count($val) >= 1) {
                foreach ($val as $sub_item_id) {
                    $stmt_sub = "
                        INSERT INTO mt_item_relationship_subcategory_item 
                        (merchant_id, item_id, subcat_id, sub_item_id)
                        VALUES (:merchant_id, :item_id, :subcat_id, :sub_item_id)
                    ";

                    $query_sub = $this->db->prepare($stmt_sub);
                    $query_sub->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
                    $query_sub->bindParam(':item_id', $item_id, PDO::PARAM_INT);
                    $query_sub->bindParam(':subcat_id', $subcat_id, PDO::PARAM_INT);
                    $query_sub->bindParam(':sub_item_id', $sub_item_id, PDO::PARAM_INT);
                    $query_sub->execute();
                }
            }
        }
    }
}


public function deleteItemRelationshipSubcategory($merchant_id = '', $item_id = '')
{
    // Prepare the SQL query
    $stmt = "
        DELETE FROM mt_item_relationship_subcategory
        WHERE merchant_id = :merchant_id AND item_id = :item_id
    ";

    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);

    // Bind parameters
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();
}


public function deleteItemRelationshipSubcategoryItem($merchant_id = '', $item_id = '')
{
    $stmt = "
        DELETE FROM mt_item_relationship_subcategory_item
        WHERE merchant_id = :merchant_id AND item_id = :item_id
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    
    return $query->execute();
}


public function insertItemRelatinship_bkupbywasi($merchant_id = '', $item_id = '', $data = array())
{
    // Delete existing relationships
    $this->deleteItemRelationship($merchant_id, $item_id);

    // Prepare insert statement
    $stmt = "
        INSERT INTO mt_item_relationship_size (merchant_id, item_id, size_id, price, created_at, item_token)
        VALUES (:merchant_id, :item_id, :size_id, :price, :created_at, :item_token)
    ";
    
    $query = $this->db->prepare($stmt);
    
    if (is_array($data['size']) && count($data['size']) >= 1) {
        foreach ($data['size'] as $key => $size_id) {
            $price = isset($data['price'][$key]) ? $data['price'][$key] : 0;
            $token = self::generateFoodSizeToken();

            // Bind parameters
            $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
            $query->bindParam(':size_id', $size_id, PDO::PARAM_INT);
            $query->bindParam(':price', $price, PDO::PARAM_STR);
            $query->bindParam(':created_at', $this->dateNow(), PDO::PARAM_STR);
            $query->bindParam(':item_token', $token, PDO::PARAM_STR);
            
            // Execute the insert
            $query->execute();
        }
    } else {
        $token = $this->generateFoodSizeToken();
        $params = array(
            'merchant_id' => (integer)$merchant_id,
            'item_id' => (integer)$item_id,
            'size_id' => (integer)0,
            'price' => (float)0,
            'created_at' => $this->dateNow(),
            'item_token' => $token
        );

        // Bind parameters
        $query->bindParam(':merchant_id', $params['merchant_id'], PDO::PARAM_INT);
        $query->bindParam(':item_id', $params['item_id'], PDO::PARAM_INT);
        $query->bindParam(':size_id', $params['size_id'], PDO::PARAM_INT);
        $query->bindParam(':price', $params['price'], PDO::PARAM_STR);
        $query->bindParam(':created_at', $params['created_at'], PDO::PARAM_STR);
        $query->bindParam(':item_token', $params['item_token'], PDO::PARAM_STR);
        
        // Execute the insert
        $query->execute();
    }
}


public function deleteItemRelationship($merchant_id = '', $item_id = '')
{
    $stmt = "
        DELETE FROM mt_item_relationship_size 
        WHERE merchant_id = :merchant_id AND item_id = :item_id
    ";

    $query = $this->db->prepare($stmt);

    // Bind parameters
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    
    // Execute the delete
    return $query->execute();
}


public  function insertItemRelatinship($merchant_id = '', $item_id = '', $data = array())
{
    $with_size=0;
    // Delete any previous item relationship records
    $this->deleteItemRelationship($merchant_id, $item_id);                
    $last_sku = isset($data['last_sku']) ? $data['last_sku'] : ''; // Get the last SKU
    // Check if 'size' is provided in the data
    if (is_array($data['size']) && count($data['size']) >= 1) {
        // Loop through each size_id
        

        foreach ($data['size'] as $key => $size_id) {
            $price = isset($data['price'][$key]) ? $data['price'][$key] : 0;
            $token = $this->generateFoodSizeToken();

            // Check if the 'results' parameter is passed and if size_id exists in the results
            if (isset($data['results'])) {
                $sku = ''; // Initialize SKU
                $found_sku = false; // Flag to check if sku is found
                
                // Loop through $results to check if the size_id exists
                foreach ($data['results'] as $result) {
                    if ($result['size_id'] == $size_id) {
                        $sku = $result['sku']; // Get the sku for this size_id
                        $found_sku = true;
                        break;
                    }
                }

                // If SKU is not found in the results, increment the last SKU
                if (!$found_sku) {
                    
                    if ($last_sku) {
                        // If SKU contains '-', split and increment the second part
                        if (strpos($last_sku, '-') !== false) {
                            $parts = explode("-", $last_sku);
                            $new_sku = $parts[0] . "-" . (intval($parts[1]) + 1);
                        } else {
                            // If no dash, just add -1
                          $new_sku = $merchant_id . "-" . (intval($last_sku) + 1);
                          $last_sku=(intval($last_sku) + 1);
                          
                        }
                        $sku = $new_sku; // Set the new SKU
                    }
                }
            } else {
                // If results are not passed, set SKU to a default value or handle as needed
                $sku = 0;
            }

            // Insert the item relationship with the appropriate SKU

            if($size_id>0){
                $with_size=1;
            }

            $params = array(
                'merchant_id' => (integer)$merchant_id,
                'item_id' => (integer)$item_id,
                'size_id' => (integer)$size_id,
                'price' => (float)$price,
                'created_at' => $this->dateNow(),
                'item_token' => $token,
                'sku' => $sku // Add the SKU to the params
            );
            
            

            $this->insertData("mt_item_relationship_size", $params);
        }
    } else {
        // If no sizes are provided, insert a default entry
        $sku_without_size=$merchant_id . "-" . $last_sku;
        $token = self::generateFoodSizeToken();
        $params = array(
            'merchant_id' => (integer)$merchant_id,
            'item_id' => (integer)$item_id,
            'size_id' => (integer)0,
            'price' => (float)0,
            'created_at' => $this->dateNow(),
            'item_token' => $token,
            'sku' => $sku_without_size
        );

        $this->insertData("mt_item_relationship_size", $params);
        $last_sku=(intval($last_sku) + 1);
    }

$params = array(
    'with_size' => (integer)$with_size
);
    // Update the `{{item}}` table where `item_id` matches the given `$item_id`


$this->updateData('mt_item' , $params ,'item_id',$item_id);



}




public  function insertItemRelatinship_addscenario($merchant_id='',$item_id='',$data=array())
    {
        $with_size=0;
        $last_sku=$this->autoGenerateSKU($merchant_id);                              
        $this->deleteItemRelationship($merchant_id,$item_id);                
        if(is_array($data['size']) && count($data['size'])>=1){

            
            

            foreach ($data['size'] as $key=>$size_id) {                     
                $price = isset($data['price'][$key])?$data['price'][$key]:0;
                $token=$this->generateFoodSizeToken();
                $new_sku = $merchant_id . "-" . $last_sku;
                $params = array(
                  'merchant_id'=>(integer)$merchant_id,
                  'item_id'=>(integer)$item_id,
                  'size_id'=>(integer)$size_id,
                  'price'=>(float)$price,
                  'created_at'=>$this->dateNow(),
                  'item_token'=>$token,
                  'sku' => $new_sku

                );
                 
                 if($size_id>0){
                $with_size=1;
            }


                   
                $this->insertData("mt_item_relationship_size",$params);      
                $last_sku=(intval($last_sku) + 1);      
            }
        } else {
            $token=$this->generateFoodSizeToken();
            $new_sku = $merchant_id . "-" . $last_sku;
            $params = array(
              'merchant_id'=>(integer)$merchant_id,
              'item_id'=>(integer)$item_id,
              'size_id'=>(integer)0,
              'price'=>(float)0,
              'created_at'=>$this->dateNow(),
              'item_token'=>$token,
              'sku' => $new_sku
            );                  
            $this->insertData("mt_item_relationship_size",$params);   
            $last_sku=(intval($last_sku) + 1);          
        }

        $params = array(
    'with_size' => (integer)$with_size
);

// Update the `{{item}}` table where `item_id` matches the given `$item_id`


 $this->updateData('mt_item' , $params ,'item_id',$item_id);




    }



public function generateAlphanumeric($length = 8) {
    $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz';
    $randomString = '';
    for ($i = 0; $i < $length; $i++) {
        $index = rand(0, strlen($characters) - 1);
        $randomString .= $characters[$index];
    }
    return $randomString;
}


public function autoGenerateSKU($merchant_id = '')
{
    try {
        $stmt = $this->db->prepare("
            SELECT sku
            FROM mt_view_item_stocks
            WHERE merchant_id = :merchant_id
            AND sku REGEXP '^[0-9]+-[0-9]+$'
            ORDER BY CAST(SUBSTRING_INDEX(sku, '-', -1) AS UNSIGNED) DESC
            LIMIT 1
        ");
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_STR);
        $stmt->execute();

        $resp = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($resp) {
            $sku = $resp['sku']; // Get the SKU value
            $parts = explode('-', $sku); // Split the SKU into parts
            if (isset($parts[1])) {
                return (int)$parts[1] + 1; // Increment the second part and return
            }else{
                return 1;
            }
        }
        return 1;
    } catch (PDOException $e) {
        // Handle exceptions if needed
        echo "Database error: " . $e->getMessage();
        return false;
    }
}



public function generateFoodSizeToken()
{
    $token = $this->generateCode(20);
    
    $stmt = "
        SELECT item_token 
        FROM mt_item_relationship_size 
        WHERE item_token = :item_token 
        LIMIT 1
    ";
    
    $query = $this->db->prepare($stmt);
    $query->bindParam(':item_token', $token, PDO::PARAM_STR);
    $query->execute();
    
    $resp = $query->fetch(PDO::FETCH_ASSOC);
    
    if ($resp) {
        $token = $this->generateFoodSizeToken();
    }
    
    return $token;
}


public function accountExistSocial($email = '', $social = 'google')
{
    $stmt = "
        SELECT * FROM mt_client
        WHERE email_address = ?
        AND social_strategy = ?
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([$email, $social]);
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        return $rows;
    } else {
        return false;
    }
}





    public function googleRegister($data='')
    {       

         $this->PointsProgram = new PointsProgram();

        

        $givenName = $data['given_name'] ?? $data['givenName'] ?? '';
        $familyName = $data['family_name'] ?? $data['familyName'] ?? '';
        


        if ($social_info=$this->accountExistSocial($data['email'])){            
            if ($social_info[0]['status']=='pending'){
                if (strlen($social_info[0]['email_verification_code'])>2){
                    $social_info[0]['verification_type']='email';
                }
            }
            return $social_info[0];
        } else {
            $params=array(
              'first_name'=>$givenName,
              'last_name'=>$familyName,
              'email_address'=>addslashes($data['email']),
              'social_strategy'=>'google',
              'merchant_id'=>0,
              'password'=>md5(addslashes($data['id'])),
              'date_created'=>$this->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']         
            );                  
            
            $verification_type=''; $email_code='';
            $email_verification=$this->getOptionAdmin('theme_enabled_email_verification');
            $sms_verification=$this->getOptionAdmin("website_enabled_mobile_verification");     
            if ($email_verification==2 || $sms_verification=="yes"){
                $email_code=$this->generateCode(10);
                $params['email_verification_code']=$email_code;
                $params['status']='pending';
                $verification_type='sms';
            }
            
            
            $customer_token =$this->generateCustomerToken();
            $params['token']=$customer_token;
                
            if ( $client_id=$this->insertData("mt_client",$params)){              
                
                $params['client_id']=$client_id;                
                
                if(!empty($verification_type)){
                    switch ($verification_type) {
                        case "sms":
                        case "email":
                            $params['verification_type']='sms';
                            $params['verification_link'] = $this->websiteUrl()."/email_verification/?id=".urlencode($customer_token);
                            $this->sendEmailVerificationCode($params['email_address'],$email_code,$params);
                            break;
                                        
                        default:                        
                            break;
                    }
                }
                
                /*POINTS PROGRAM*/
                
                   $this->PointsProgram->signupReward($client_id);                 
                
                return $params;
            } 
        }
        return false;
    }




public function insertMetax($merchant_id = '', $item_id = '', $meta_name = '', $meta_id = array())
{
    $this->deleteMeta($merchant_id, $item_id, $meta_name);
    
    if (is_array($meta_id) && count($meta_id) >= 1) {
        $stmt_insert = [];
        
        foreach ($meta_id as $id) {
            $stmt_insert[] = "(NULL, :merchant_id, :item_id, :meta_name, :meta_id_$id)";
        }

        $stmt_insert = implode(',', $stmt_insert);
        $stmt = "
            INSERT INTO mt_item_meta (column1, column2, column3, column4, column5) 
            VALUES $stmt_insert
        ";

        $query = $this->db->prepare($stmt);
        
        // Bind merchant_id, item_id, and meta_name
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
        $query->bindParam(':meta_name', $meta_name, PDO::PARAM_STR);
        
        // Bind each meta_id
        foreach ($meta_id as $id) {
            $query->bindValue(":meta_id_$id", (int)$id, PDO::PARAM_INT);
        }

        if ($query->execute()) {
            return true;
        }
    }

    return false;
}


public function insertMeta($merchant_id = '', $item_id = '', $meta_name = '', $meta_id = array())
{
    $this->deleteMeta($merchant_id, $item_id, $meta_name);

    if (is_array($meta_id) && count($meta_id) >= 1) {
        $stmt = "INSERT INTO mt_item_meta (id, merchant_id, item_id, meta_name, meta_id) VALUES ";
        $values = [];

        foreach ($meta_id as $id) {
            $values[] = "(NULL, :merchant_id, :item_id, :meta_name, :meta_id)";
        }

        $stmt .= implode(', ', $values);
        
        $query = $this->db->prepare($stmt);

        // Bind parameters for each execution
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
        $query->bindParam(':meta_name', $meta_name, PDO::PARAM_STR);

        foreach ($meta_id as $index => $id) {
            $query->bindValue(':meta_id', $id, PDO::PARAM_INT);
            if (!$query->execute()) {
                return false; // Exit if any insertion fails
            }
        }

        return true; // Return true if all inserts were successful
    }

    return false; // Return false if no meta_id provided
}





public function deleteMeta($merchant_id = '', $item_id = '', $meta_name = '')
{
    $stmt = "
    DELETE FROM mt_item_meta
    WHERE 
    merchant_id = :merchant_id
    AND item_id = :item_id
    AND meta_name = :meta_name
    ";

    $query = $this->db->prepare($stmt);

    // Bind parameters
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->bindParam(':meta_name', $meta_name, PDO::PARAM_STR);

    if ($query->execute()) {
        return true;
    }
    return false;
}



public function deleteFoodItem($merchant_id = 0, $id = 0)
{
    // Check if the item has references in the order table
    $stmt = $this->db->prepare("SELECT cat_id FROM mt_order_details WHERE item_id = :item_id");
    $stmt->bindParam(':item_id', $id, PDO::PARAM_INT);
    $stmt->execute();
    
    if ($stmt->fetch()) {
        throw new Exception("Cannot delete this item; it has references in the order table");
    }

    // Get photo and gallery photo
    $stmt = $this->db->prepare("SELECT photo, gallery_photo FROM mt_item WHERE item_id = :item_id");
    $stmt->bindParam(':item_id', $id, PDO::PARAM_INT);
    $stmt->execute();
    
    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    $photo = $data['photo'] ?? '';
    $gallery_photo = json_decode($data['gallery_photo'], true) ?? [];

    // Delete the item
    $stmt = $this->db->prepare("DELETE FROM mt_item WHERE merchant_id = :merchant_id AND item_id = :item_id");
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindParam(':item_id', $id, PDO::PARAM_INT);
    
    if ($stmt->execute()) {
        // Delete related data
        $this->deleteRelationship($id, 'item_id', 'mt_item_translation');
        $this->deleteRelationship($id, 'item_id', 'mt_item_relationship_category');
        $this->deleteRelationship($id, 'item_id', 'mt_item_relationship_subcategory');
        $this->deleteRelationship($id, 'item_id', 'mt_item_relationship_subcategory_item');
        $this->deleteRelationship($id, 'item_id', 'mt_item_relationship_size');
        $this->deleteAllMeta($merchant_id, $id);
        
        return true;
    }
    
    throw new Exception("Failed; cannot delete records");
}


public function deleteAllMeta($merchant_id = '', $item_id = '')
{
    $stmt = $this->db->prepare("DELETE FROM mt_item_meta WHERE merchant_id = :merchant_id AND item_id = :item_id");
    
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    
    return $stmt->execute();
}













    public function orderStatusList($aslist = true)
{
    $mid = $this->getMerchantID();
    $list = array();

    if ($aslist) {
        $list['0'] = 'Please select'; // Use an empty key for "Please select" if needed
    }

    // Prepare the PDO statement
    $stmt = $this->db->prepare("
        SELECT * FROM mt_order_status
        WHERE merchant_id IN ('0', :mid)
        ORDER BY stats_id
    ");

    // Bind the merchant ID parameter
    $stmt->bindParam(':mid', $mid, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            // Replace with direct translation, assuming t() is a global function or method
            $list[$val['description']] = ($val['description']);
        }
        return $list;
    }

    return false;
}


public function getMerchantOffersActive($merchant_id = '', $transaction_type = 'delivery')
{
    $trans_type = $transaction_type;
    $date_now = date('Y-m-d');

    // Prepare the SQL query with named parameters
    $stmt = "
        SELECT * 
        FROM mt_offers
        WHERE status IN ('publish', 'published')
        AND NOW() >= valid_from 
        AND NOW() <= valid_to
        AND merchant_id = :merchant_id
        AND applicable_to LIKE :trans_type
        ORDER BY valid_from ASC
        LIMIT 1
    ";

    // Prepare the statement using the class's PDO connection
    $query = $this->db->prepare($stmt);

    // Bind the parameters to the query
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindValue(':trans_type', "%$trans_type%", PDO::PARAM_STR);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }

    return false;
}



public function getReceiptCalculationMethod()
    {
        $receipt_computation_method=$this->getOptionAdmin('receipt_computation_method');
        if(empty($receipt_computation_method)){
            $receipt_computation_method=1;
        }    
        return $receipt_computation_method;
    }

    public function getOrderDiscount($order_id = '')
{
    // Prepare the SQL query with named parameters
    $stmt = "
        SELECT discounted_amount, discount_percentage 
        FROM mt_order
        WHERE order_id = :order_id
        LIMIT 1
    ";

    // Prepare the statement using the class's PDO connection
    $query = $this->db->prepare($stmt);

    // Bind the parameter to the query
    $query->bindParam(':order_id', $order_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }

    return false;
}


public function getLastTwoMonths()
    {
        $a=date("F Y"); 
        $b=date("F Y",strtotime("-1 Months")); 
        $c=date("F Y",strtotime("-2 Months")); 
        return array(
          date("Y-m-d")=>$a,
          date("Y-m-d",strtotime("-1 Months"))=>$b,
          date("Y-m-d",strtotime("-2 Months"))=>$c
        );
    }


public function getallactivephoneorders($device_uiid = '', $id, $search = '')
{
   

    if (isset($search) && !empty($search)) {
        $search = addslashes($search); // Still escaping for basic safety since we're not binding
        $ands = "AND (a.email LIKE '%$search%' OR a.phones LIKE '%$search%' OR a.client_name LIKE '%$search%')";
    } else {
        $ands = "";
    }

    $stmt = "
    SELECT 
        cart_id,
        client_name as CustomerName,
        phones as phone,
        merchant_id,
        clients_id as client_id
    FROM mt_pos_cart a
    WHERE 1
    AND a.merchant_id = " . ($id) . "
    AND a.clients_id > 0
    $ands
    ORDER BY cart_id DESC
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    try {
        $result = $this->db->query($stmt);
        if ($result && $rows = $result->fetchAll(PDO::FETCH_ASSOC)) {
            return $rows;
        }
    } catch (Exception $e) {
        // optional: log the error or handle it
    }

    return false;
}

public function pos_cart_lock_chk($device_uiid = '', $cart_id = '')
{
    if (empty($device_uiid)) {
        return false;
    }

    $stmt = "
        SELECT *
        FROM mt_pos_cart
        WHERE cart_id = '" . addslashes($cart_id) . "'
        AND lock_flag = 1
        LIMIT 1
    ";

    try {
        $result = $this->db->query($stmt);
        if ($result && ($row = $result->fetch(PDO::FETCH_ASSOC))) {
            return $row; // ✅ return complete row
        }
    } catch (Exception $e) {
        // optional logging
    }

    return false; // no lock
}




public function getClientInfobyids($client_id = '')
{
    $stmt = "
    SELECT client_id, first_name, last_name, email_address, contact_phone 
    FROM mt_client
    WHERE client_id = " . ($client_id) . "
    LIMIT 0,1
    ";

    try {
        $result = $this->db->query($stmt);
        $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
        if ($result && $res = $result->fetchAll(PDO::FETCH_ASSOC)) {
            return $res[0];
        }
    } catch (Exception $e) {
        // Optional: log or handle error
    }

    return false;
}









public function getOrderInfo($order_id = '')
{
    // Prepare the SQL statement using PDO
    $stmt = $this->db->prepare("
        SELECT * FROM mt_order
        WHERE order_id = :order_id
        LIMIT 1
    ");

    // Bind the order_id parameter securely
    $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the result or FALSE if no result is found
    if ($row) {
        return $row;
    }
    return false;
}


public function getSlotInfo($id = '')
{
    // Prepare the SQL statement using PDO
    $stmt = $this->db->prepare("
        SELECT * FROM mt_booking_slots_child
        WHERE id = :id
        LIMIT 1
    ");

    // Bind the order_id parameter securely
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the result or FALSE if no result is found
    if ($row) {
        return $row;
    }
    return false;
}


public function getslotsbyUTC($startSec)
{
    // Prepare the SQL statement using PDO
    $stmt = $this->db->prepare("
        SELECT * FROM mt_booking_slots_child
        WHERE utc_times = :startSec
        LIMIT 1
    ");

    // Bind the order_id parameter securely
    $stmt->bindParam(':startSec', $startSec, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the result or FALSE if no result is found
    if ($row) {
        return $row;
    }
    return false;
}


public function getslotsbyUTC_alols($startSec, $merchant_id)
{
    // Prepare the SQL statement using PDO
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_booking_slots_child
        WHERE utc_times = ? 
        AND merchant_id = ?
    ");

    // Execute the statement with parameters directly
    $stmt->execute([$startSec, $merchant_id]);

    // Fetch the result
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Return the result or FALSE if no result is found
    return $rows ?: false;
}





public function getReviewBasedOnStatus($order_status='')
    {
        $status='pending';
        $publish_review_status = $this->getOptionAdmin('publish_review_status');
        if(!empty($publish_review_status)){
            $publish_review_status = json_decode($publish_review_status,true);          
            if(in_array($order_status,(array)$publish_review_status)){
                $status='publish';
            }
        }
        return $status;
    }



  public function getNewCancelOrderAdmins()
{
    try {
        // Prepare the SQL statement with placeholders for PDO
        $stmt = $this->db->prepare("
            SELECT COUNT(*) as total
            FROM mt_order
            WHERE request_cancel = :request_cancel
            AND request_cancel_viewed = :request_cancel_viewed
            AND request_cancel_status = :request_cancel_status
            LIMIT 50
        ");

        // Execute the query with the relevant parameters
        $stmt->execute([
            ':request_cancel' => 1,
            ':request_cancel_viewed' => 2,
            ':request_cancel_status' => 'pending'
        ]);

        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // Check if there are any results and return the count
        if ($res && $res['total'] > 0) {
            return $res['total'];
        }
    } catch (PDOException $e) {
        // Handle exceptions, maybe log the error
        error_log($e->getMessage());
    }

    return false;
}

public function getEmailLogsByID($id = '')
{
    // Prepare the SQL statement with a parameterized query
    $stmt = "
        SELECT * 
        FROM mt_email_logs
        WHERE id = :id
        LIMIT 0, 1
    ";

    // Prepare the statement
    $stmtMain = $this->db->prepare($stmt);
    
    // Bind the ID parameter to the query
    $stmtMain->bindParam(':id', $id, PDO::PARAM_INT);
    
    // Execute the query
    $stmtMain->execute();
    
    // Fetch the result
    $res = $stmtMain->fetch(PDO::FETCH_ASSOC);

    // Return the first result if found, otherwise return false
    if ($res) {
        return $res;
    }

    return false;
}






    public function getNewOrders($type = '')
{
    // Create a new PDO connection instance
    $db = $this->db;
    
    // Determine the additional condition based on the type
    switch ($type) {
        case "admin":
            $and = " AND admin_viewed <= 0 ";
            break;
        
        case "merchantapp": 
            $and = " AND merchantapp_viewed <= 0 ";
            break;
            
        default:
            $and = " AND viewed = '1' ";
            break;
    }
    
    // Prepare the SQL query
    $stmt = $db->prepare("
        SELECT * FROM mt_order
        WHERE date_created LIKE :date_created
        $and

        AND request_from != 'pos'

        AND status NOT IN (:initial_status)
        ORDER BY date_created DESC
        LIMIT 50
    ");
    
    // Bind parameters
    $date_created = date('Y-m-d') . '%';
    $initial_status = $this->initialStatus();  // Make sure this method returns a comma-separated list or an array
    $stmt->bindParam(':date_created', $date_created);
    $stmt->bindParam(':initial_status', $initial_status);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Return results or false if no results
    return !empty($res) ? $res : false;
}




public function updateReviews($order_id = '', $order_status = '')
{
    $website_review_type = $this->getOptionAdmin('website_review_type');
    
    if ($website_review_type == 2) {
        $stmt = "SELECT id FROM mt_review WHERE order_id = :order_id LIMIT 1";
        $query = $this->db->prepare($stmt);
        $query->bindParam(':order_id', $order_id, PDO::PARAM_INT);
        $query->execute();

        if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
            $params = [
                'status'       => $this->getReviewBasedOnStatus($order_status),
                'date_modified'=> $this->dateNow(),
                'ip_address'   => $_SERVER['REMOTE_ADDR']
            ];

            $this->updateData('mt_review', $params, 'id', $res['id']);
        }
    }
}








public function newOrderList($viewed = '')
{
    $merchant_id = $this->getMerchantID();
    $today = date('Y-m-d') . '%';

   


    

    $stmt = $this->db->prepare("
        SELECT * FROM mt_order
        WHERE date_created LIKE '$today'
        AND merchant_id = $merchant_id
        AND viewed = '2'
        AND status NOT IN ('initial_order')
        AND request_from != 'pos'
        AND request_cancel = '2'
        ORDER BY date_created DESC
        LIMIT 0,50
    ");

    

    $stmt->execute();

    if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}


public function getNewCancelOrder($merchant_id = '')
{
    $stmt = $this->db->prepare("
        SELECT COUNT(*) as total
        FROM mt_order
        WHERE merchant_id = ?
        AND request_cancel = '1'
        AND request_cancel_viewed = '2'
        AND request_cancel_status = 'pending'
        LIMIT 0,50
    ");

    $stmt->execute([$merchant_id]);

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if ($res['total'] > 0) {
            return $res['total'];
        }
    }

    return false;
}







public  function notifyCustomerOrderStatusChange($order_id='',$status='', $remarks='')
    {                       
        $_GET['backend']=true; 
        
        $lang="en";   
        if ($data=$this->getOrder2($order_id)){                         
            /*EMAIL*/
            
            $status=str_replace(" ","_",$status);
            
            $sender=$this->getOptionAdmin("global_admin_sender_email");
            
            /*custom code 5 start*/
            if($data['merchant_id']>0){ 
            $merch=$this->getMerchant($data['merchant_id']);    
            if($merch['is_use_email']=='2'){    
                if(isset($merch['contact_email']) && !empty($merch['contact_email'])){  
                  $sender=$merch['contact_email'];      
                }   
            }   
                
            }else{$sender=$this->getOptionAdmin("global_admin_sender_email");}
            /*custom code 5 ends*/
            
            $enabled = $this->getOptionAdmin("order_status_".$status."_email");
            $to=isset($data['email_address'])?trim($data['email_address']):'';
                    
            if($enabled==1 && !empty($to)){             
                $subject = $this->getOptionAdmin("order_status_".$status."_tpl_subject_$lang");
                $tpl = $this->getOptionAdmin("order_status_".$status."_tpl_content_$lang");
                
                $pattern=array(
                   'customer_name'=>'full_name',
                   'order_id'=>'order_id',
                   'restaurant_name'=>'merchant_name',
                   'total_amount'=>'total_w_tax',
                   'order_status'=>'status',
                   'sitename'=>$this->getOptionAdmin('website_title'),
                   'siteurl'=>$this->websiteUrl(),           
                   'remarks'=>$remarks
                );
                
                if(!empty($subject)){
                    $subject=$this->replaceTemplateTags($subject,$pattern,$data);
                }
                if(!empty($tpl)){  
                    $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
                }                       
                $params=array(
                  'email_address'=>$to,
                  'sender'=>$sender,
                  'subject'=>$subject,
                  'content'=>$tpl,
                  'date_created'=>$this->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  
                  /*custom code start*/
                  'order_id'=>$data['order_id'],
                  /*custom code ends*/
                  
                  'module_type'=>'core'
                );      
                if (!empty($subject) && !empty($tpl)){          
                      

                    $this->insertData("mt_email_logs",$params);               
                    
                }
            }
            
            /*SMS*/
            $balance=$this->getMerchantSMSCredit($data['merchant_id']);
            if (is_numeric($balance) && $balance>=1){
                $enabled = $this->getOptionAdmin("order_status_".$status."_sms");
                $tpl=$this->getOptionAdmin("order_status_".$status."_sms_content_$lang");
                $to = isset($data['contact_phone1'])?$data['contact_phone1']:'';        
                if(empty($to)){
                    $to = isset($data['contact_phone'])?$data['contact_phone']:''; 
                }
                if($enabled==1 && !empty($to) && !empty($tpl)){
                    $pattern=array(
                       'customer_name'=>'full_name',
                       'order_id'=>'order_id',
                       'restaurant_name'=>'merchant_name',
                       'total_amount'=>'total_w_tax',
                       'order_status'=>'status',
                       'sitename'=>$this->getOptionAdmin('website_title'),
                       'siteurl'=>$this->websiteUrl(),         
                       'remarks'=>$remarks   
                    );
                    $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);                
                    $params=array(
                      'contact_phone'=>$to,
                      'sms_message'=>$tpl,
                      'date_created'=>$this->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR']          
                    );              
                     
                    $this->insertData("mt_sms_broadcast_details",$params);
                }
            }
            
        
            
            /*SINGLEMERCHANT PUSH*/
           
              
               require __DIR__ . '/../../app/modules/singlemerchant/components/SingleAppClass.php';
               
               $this->SingleAppClass = new SingleAppClass();                 
              $this->SingleAppClass->OrderTrigger($order_id,$status,$remarks);                   
              $link=$this->websiteUrl()."/singlemerchant/cron/trigger_order";
              $this->consumeUrl($link);
                
            /*MOBILE VERSION 2*/
            
               
                require __DIR__ . '/../../app/modules/mobileappv2/components/mobileWrapper.php';
                $this->mobileWrapper = new mobileWrapper();
                                                     
                $this->mobileWrapper->OrderTrigger($order_id,$status,$remarks);
                
            
            
        } 
        
    }










    public function getOrderStatus($stats_id = '')
{
    $stmt = $this->db->prepare("SELECT * FROM mt_order_status WHERE stats_id = :stats_id");
    $stmt->bindParam(':stats_id', $stats_id, PDO::PARAM_INT);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        return $result;
    }
    return false;
}

public function getTagsByID($tag_id = '')
{
    $stmt = $this->db->prepare("SELECT * FROM mt_tags WHERE tag_id = :tag_id");
    $stmt->bindParam(':tag_id', $tag_id, PDO::PARAM_INT);
    $stmt->execute();

    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    throw new Exception($this->translation("default", "We cannot find what you're looking for"));
}







    public function getMerchantPromotions($id = '')
{
    // Prepare the SQL query
    $stmt = "SELECT a.*, (
                SELECT restaurant_name 
                FROM mt_merchant 
                WHERE merchant_id = a.merchant_id
            ) as merchant_name 
            FROM mt_promotions a 
            WHERE id = :id 
            LIMIT 0,1";

    // Prepare and execute the PDO statement
    $query = $this->db->prepare($stmt);
    $query->bindParam(':id', $id, PDO::PARAM_INT);
    $query->execute();

    // Fetch the result
    $result = $query->fetch(PDO::FETCH_ASSOC);

    // Return the first row if found, otherwise return false
    if ($result) {
        return $result;
    }
    return false;
}

public function getBranch($id = '')
{
    $stmt = "SELECT * FROM mt_branches WHERE id = :id LIMIT 1";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':id', $id, PDO::PARAM_INT);
    $query->execute();

    $result = $query->fetch(PDO::FETCH_ASSOC);

    return $result ?: false;
}





    public function getMerchantHoliday($merchant_id='')
    {
        $merchant_holiday=$this->getOption("merchant_holiday",$merchant_id);
        if (!empty($merchant_holiday)){
            $merchant_holiday=json_decode($merchant_holiday,true);
            if (is_array($merchant_holiday) && count($merchant_holiday)>=1){
               return $merchant_holiday;    
            }           
        }       
        return false;
    }


     public function merchantOpenTag($merchant_id='')
    {
        $is_merchant_open = $this->isMerchantOpen($merchant_id); 
        $merchant_preorder= $this->getOption("merchant_preorder",$merchant_id);
        
        $now=date('Y-m-d');
        $is_holiday=false;
            if ( $m_holiday=$this->getMerchantHoliday($merchant_id)){  
           if (in_array($now,(array)$m_holiday)){
              $is_merchant_open=false;
           }
        }
        
        if ( $is_merchant_open==true){
            if ( $this->getOption('merchant_close_store',$merchant_id)=="yes"){
                $is_merchant_open=false;    
                $merchant_preorder=false;                           
            }
        }
        
        if ($is_merchant_open){
            $tag='<span class="label label-success">'.("Open").'</span>';
        } else {
            if ($merchant_preorder){
                $tag='<span class="label label-info">'.("Pre-Order").'</span>';
            } else {
                $tag='<span class="label label-danger">'.("Closed").'</span>';
            }
        }      
        return $tag;  
    }

    public  function displayCuisine($cuisine='', $list='')
    {    
        $p='';
        if ( !empty($cuisine)){
            //$list=Yii::app()->functions->Cuisine(true);
            if (!is_array($list) && count((array)$list)<=1){
                $list=$this->Cuisine(true);           
            }
            $cuisine=json_decode($cuisine,true);            
            if (is_array($cuisine) && count($cuisine)>=1){
                foreach ($cuisine as $val) {                    
                    if (array_key_exists($val,(array)$list)){
                        
                         if ( $this->multipleField()==2){
                            
                            $cuisine_id=$val;                   
                            $cuisine_info=$this->GetCuisine($cuisine_id);
                            
                            $cuisine_json['cuisine_name_trans']=!empty($cuisine_info['cuisine_name_trans'])?
                            json_decode($cuisine_info['cuisine_name_trans'],true):'';
                            
                            $p.= $this->qTranslate($list[$val],'cuisine_name',$cuisine_json)  .", ";
                         } else {
                        
                            $p.= $list[$val].", ";
                         }
                    }
                }
                $p=substr($p,0,-2);
            }
        }
        return $p;
    }

   public function getCuisiness()
{
    $data = [];
    
    // Prepare the first statement to get cuisines
    $stmt = "SELECT * FROM mt_cuisine ORDER BY sequence ASC";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $val) {
                // Prepare the second statement to count active merchants for each cuisine
                $stmt2 = "SELECT COUNT(*) AS total 
                          FROM mt_merchant 
                          WHERE cuisine LIKE :cuisine_id 
                          AND status = 'active' 
                          AND is_ready = '2'";
                
                $cuisineId = '%' . $val['cuisine_id'] . '%'; // Use % for LIKE query

                $query2 = $this->db->prepare($stmt2);
                $query2->bindParam(':cuisine_id', $cuisineId, PDO::PARAM_STR);
                $query2->execute();
                $count = $query2->fetch(PDO::FETCH_ASSOC);
                
                $val['total'] = $count['total'];
                $data[] = $val;
            }
            return $data;
        }
    } catch (PDOException $e) {
        // Handle exception or log error
        // echo 'Database error: ' . $e->getMessage();
    }

    return false;
}



 public  function displayCashAvailable($merchant_id='',$echo=true, $services='')
    {
      //dump($services);
      $payment_list=$this->PaymentOptionList();        
      $payment_available=array();
            
        $is_commission=false;
    if ( $this->isMerchantCommission($merchant_id)){      
      $is_commission=true;
      $payment_available=$this->getMerchantListOfPaymentGateway();      
    } else {      
      $pay_available=$this->getMerchantListOfPaymentGateway();      
      if ( $this->getOption('merchant_disabled_cod',$merchant_id)==""){
        if (in_array('cod',(array)$pay_available)){
           $payment_available[]='cod';
        }
      }       
    }
    
    $new_payment_list=array();
    if (is_array($payment_list) && count($payment_list)>=1){
      foreach ($payment_list as $key=>$val) {
        if(in_array($key,(array)$payment_available)){
           $new_payment_list[$key]=$val;
        }
      }
    }
    /*Check Admin individual settings for cod, offline cc, payon delivery*/
    if ( $this->getOption('merchant_switch_master_cod',$merchant_id)==2){
      //cod
      if (array_key_exists('cod',(array)$new_payment_list)){
        unset($new_payment_list['cod']);
      }
    }
    
    /*check if has payment on delivery = pyr */
    if (array_key_exists('pyr',(array)$new_payment_list)){
      if ($is_commission){
        $provider_list=$this->getPaymentProviderListActive();           
      } else {
        $provider_list=$this->getPaymentProviderMerchant($merchant_id);
      }     
      if (!is_array($provider_list) && count( (array) $provider_list)<=1){        
        unset($new_payment_list['pyr']);
      }       
    }
    
    if (array_key_exists('ocr',(array)$new_payment_list)){
      $cc_offline_master=$this->getOption('merchant_switch_master_ccr',$merchant_id);
      if ($cc_offline_master==2){
        unset($new_payment_list['ocr']);
      }
    }
        
    $payment_accepted='';
    if (array_key_exists('cod',(array)$new_payment_list)){      
      $payment_accepted="<p class=\"cod-text\">".$this->translation("default","Cash on delivery available")."</p>";
      if($services==3){
        $payment_accepted="<p class=\"cod-text\">".$this->translation("default","Cash on pickup available")."</p>";
      } elseif ( $services==6 ){
        $payment_accepted="<p class=\"cod-text\">".$this->translation("default","Cash on pickup available")."</p>";
      } elseif ( $services==7 ){
        $payment_accepted="<p class=\"cod-text\">".$this->translation("default","Pay in person available")."</p>";  
      } else {  
        
      }
    }
    if (array_key_exists('ocr',(array)$new_payment_list)){
      if(!empty($payment_accepted)){
        $payment_accepted.='<div style="height:5px;"></div>';
      }
      $payment_accepted.="<p class=\"cod-text\">".$this->translation("default","Credit Card available")."</p>";
    }
    
    if(!empty($payment_accepted)){
      if ($echo){ 
        echo $payment_accepted;
      } else return true;
    }
        
    return false;
    }



      public  function displayServicesList($service='')
    {    
        $htm='<ul class="services-type">';
        switch ($service) {
            case 1:
                $htm.='<li>'.$this->translation("default","Delivery").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                $htm.='<li>'.$this->translation("default","Pickup").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                break;              
        
            case 2:
                $htm.='<li>'.$this->translation("default","Delivery").' <i class="green-color ion-android-checkmark-circle"></i></li>';                    
                break; 
            case 3:
                $htm.='<li>'.$this->translation("default","Pickup").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                break; 
                
            case 4:
                $htm.='<li>'.$this->translation("default","Delivery").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                $htm.='<li>'.$this->translation("default","Pickup").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                $htm.='<li>'.$this->translation("default","Dinein").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                break;              
                
            case 5:
                $htm.='<li>'.$this->translation("default","Delivery").' <i class="green-color ion-android-checkmark-circle"></i></li>';                
                $htm.='<li>'.$this->translation("default","Dinein").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                break;              
                
            case 6:             
                $htm.='<li>'.$this->translation("default","Pickup").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                $htm.='<li>'.$this->translation("default","Dinein").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                break;              
                
            case 7:             
                $htm.='<li>'.$this->translation("default","Dinein").' <i class="green-color ion-android-checkmark-circle"></i></li>';
                break;                              
                    
            default:
                break;
        }
        $htm.='</ul>';
        return $htm;
    }



   public function clearString($text='')
{
    if(!empty($text)){
       return stripslashes($text);
    }
    return ;
}

public function convertToRaw($price, $decimal=2)
    {
        if (is_numeric($price)){
            return number_format($price,$decimal,'.','');
        }
        return 0;        
    }


    public function payoutRequest_merside($payment_method='',$data='')
    {
        $token=md5($this->generateRandomKey());
        $wd_days_process=$this->getOptionAdmin("wd_days_process");
        //if (empty($wd_days_process)){
        if (!is_numeric($wd_days_process)){
            $wd_days_process=5;
        }
        $process_date=date("Y-m-d", strtotime (" +$wd_days_process days"));
        switch ($payment_method) {
            case "paypal":
                
                $params=array(
                  'merchant_id'=>$this->getMerchantID(),
                  'payment_type'=>$data['payment_type'],
                  'payment_method'=>$data['payment_method'],
                  'amount'=>$data['amount'],
                  'currency_code'=>$this->getCurrencyCode(),
                  'date_created'=>$this->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'account'=>$data['account'],
                  'date_to_process'=>$process_date,
                  'current_balance'=>$data['current_balance'],
                  'balance'=>$data['current_balance']-$data['amount'],
                  'date_to_process'=>$process_date,
                  'withdrawal_token'=>$token
                );
                if ( $w_id=$this->insertData("mt_withdrawal",$params)){
                    //return Yii::app()->db->getLastInsertID();
                    return array(
                      'id'=>$w_id,
                      'token'=>$token
                    );
                }
                break;
        
            case "bank":    
                $wd_bank_fields=$this->getOptionAdmin('wd_bank_fields');                    
                $mtid=$this->getMerchantID();                   
                $params=array(
                  'merchant_id'=>$this->getMerchantID(),
                  'payment_type'=>$data['payment_type'],
                  'payment_method'=>$data['payment_method'],
                  'amount'=>$data['amount'],
                  'currency_code'=>$this->getCurrencyCode(),
                  'date_created'=>$this->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'account_name'=>$data['account_name'],
                  'bank_account_number'=>$data['bank_account_number'],
                  'swift_code'=>$data['swift_code'],
                  'bank_name'=>isset($data['bank_name'])?$data['bank_name']:'',
                  'bank_branch'=>isset($data['bank_branch'])?$data['bank_branch']:'',
                  'bank_country'=>isset($data['bank_country'])?$data['bank_country']:'',
                  'date_to_process'=>$process_date,
                  'current_balance'=>$data['current_balance'],
                  'balance'=>$data['current_balance']-$data['amount'],
                  'date_to_process'=>$process_date,
                  'withdrawal_token'=>$token
                );                      
                if (!empty($wd_bank_fields)){
                    $params['bank_type']=$wd_bank_fields;
                }           
                                            
                if (isset($data['default_account_bank'])){
                    if ( $data['default_account_bank']==2){
                        $this->updateOption("merchant_payout_bank_account",
                        json_encode($params),$this->getMerchantID());
                    }
                }
                    
                if ( $w_id=$this->insertData("mt_withdrawal",$params)){
                    //return Yii::app()->db->getLastInsertID();
                    return array(
                      'id'=>$w_id,
                      'token'=>$token
                    );
                }               
                break;
                                
            default:
                break;
        }
        
        return true;
    }

    public function getWithdrawalInformation($id = '')
{
    $id = (int)$id; // Ensure it's integer-safe

    $stmt = "
        SELECT * FROM mt_withdrawal
        WHERE withdrawal_id = $id
        LIMIT 0,1
    ";

    $result = $this->db->query($stmt);
    if ($result && $row = $result->fetch(PDO::FETCH_ASSOC)) {
        return $row;
    }
    return false;
}





    public function payoutRequest()
    {
        return <<<HTML
<p>Hi {merchant-name},</p>
<br/>
<p>We're just letting you know that we got your request to pay out {payout-amount} via {payment-method} to {account}</p>
<br/> 
    
<p>
You can cancel this request any time before {cancel-date} here:<br/>
{cancel-link}
</p>

<p>
We will complete this request on the {process-date} (or the next business day), but it can take up to 7 days to appear in your account. A second confirmation email will be sent at this time.
</p>

<br/>
<p> Kind Regards</p>
HTML;
    }
    
    public function payoutProcess()
    {
return <<<HTML
<p>Hi {merchant-name},</p>
<br/>
<p>We just processed your request for {payout-amount} via {payment-method}.</p>
<p>Your payment was sent to {acoount}</p>
<br/> 

<p>Happy Spending!</p>

<br/>
<p> Kind Regards</p>
HTML;
    }


    public function getBusinnesHours($merchant_id='')
    {
        $stores_open_day=$this->getOption("stores_open_day",$merchant_id);
        $stores_open_day=$this->getOption("stores_open_day",$merchant_id);
        $stores_open_starts=$this->getOption("stores_open_starts",$merchant_id);
        $stores_open_ends=$this->getOption("stores_open_ends",$merchant_id);
        $stores_open_custom_text=$this->getOption("stores_open_custom_text",$merchant_id);
        
        $stores_open_day=!empty($stores_open_day)?(array)json_decode($stores_open_day):false;
        $stores_open_starts=!empty($stores_open_starts)?(array)json_decode($stores_open_starts):false;
        $stores_open_ends=!empty($stores_open_ends)?(array)json_decode($stores_open_ends):false;
                
        
        $stores_open_pm_start=$this->getOption("stores_open_pm_start",$merchant_id);
        $stores_open_pm_start=!empty($stores_open_pm_start)?(array)json_decode($stores_open_pm_start):false;
        
        $stores_open_pm_ends=$this->getOption("stores_open_pm_ends",$merchant_id);
        $stores_open_pm_ends=!empty($stores_open_pm_ends)?(array)json_decode($stores_open_pm_ends):false;       
        
        $business_hours=array();
        if (is_array($stores_open_day) && count($stores_open_day)>=1){
           foreach ($stores_open_day as $days) {              
              $days1=substr($days,0,3);
              $start=''; $end='';
              if (array_key_exists($days,$stores_open_starts)){          
                 if (!empty($stores_open_starts[$days])){
                     $start=date("h:i A",strtotime($stores_open_starts[$days]));
                 }
              }
              if (array_key_exists($days,(array)$stores_open_ends)){         
                 if (!empty($stores_open_ends[$days]))        {
                     $end=date("h:i A",strtotime($stores_open_ends[$days]));
                 }
              }
              
              $pm_starts=''; $pm_ends='';
              if (array_key_exists($days,(array)$stores_open_pm_start)){              
                if (!empty($stores_open_pm_start[$days])){
                    $pm_starts=date("h:i A",strtotime($stores_open_pm_start[$days]));
                }
              }
              if (array_key_exists($days,(array)$stores_open_pm_ends)){           
                 if (!empty($stores_open_pm_ends[$days])){
                    $pm_ends=date("h:i A",strtotime($stores_open_pm_ends[$days]));
                 }
              }
                                     
              if (!empty($start) && !empty($end)){              
                  $business_hours[$days1]="$start - $end";
              }
              if (!empty($pm_starts) && !empty($pm_ends)){
                  $business_hours[$days1].=",$pm_starts - $pm_ends";
              }
           }
        }                           
                
        if (is_array($business_hours) && count($business_hours)>=1){
            return $business_hours;
        } else return false;
    }


    public function bookingApproved()
  {
    return <<<HTML
<p>Dear {customer-name},</p>
<br/><br/>
<p> Thank you. Your booking has been approved.</p>
<p>{booking-information}</p>
<br/>
  
<br/><br/>
<p> Kind Regards</p>
HTML;
  }

  public  function bookingDenied()
  {
    return <<<HTML
<p>Dear {customer-name},</p>
<br/><br/>
<p> We regret to inform you that your table booking has been denied.</p>
<p>{booking-information}</p>
<br/>
  
<br/><br/>
<p> Kind Regards</p>
HTML;
  } 

  public function bookingTPL()
  {
    return <<<HTML
<p>Dear admin,</p>
<br/>
<p> New table booking has been receive.</p>
<p>{booking-information}</p>
<br/>
  
<br/><br/>
<p> Kind Regards</p>
HTML;
  } 


public function dateNow()
    {
        return date('Y-m-d G:i:s');
    }


    public function isMerchantOpen($mtid='')
    {
       //http://stackoverflow.com/questions/14904864/determine-if-business-is-open-closed-based-on-business-hours
       //http://php.net/manual/en/class.datetime.php
       
       if (!empty($mtid)){
           $timezone=$this->getOption("merchant_timezone",$mtid);          
           if (!empty($timezone)){         
               date_default_timezone_set($timezone);           
           }           
           
           $times=$this->getBusinnesHours($mtid);
           if (empty($times)){
              return true;
              
           }
           /*dump(Yii::app()->timeZone);
           echo FunctionsV3::dateNow();*/
           //dump($times);
                                   
            $now = strtotime(date("h:ia"));
            $open = $this->isOpen($now, $times);
    
            if ($open == 0) {
                //echo "is close";
                return false;
            } else {
                //echo "Is open. Will close in ".ceil($open/60)." minutes";
                return true;
            }          
       }
       return false;        
    }


    public function isOpen($now, $times) {
        $open = 0;
        $hours = array_merge($this->compileHours($times, strtotime('yesterday',$now)),$this->compileHours($times, $now));       
        foreach ($hours as $h) {
            if ($now >= $h[0] and $now < $h[1]) {
                $open = $h[1] - $now;
                return $open;
            } 
        }
        return $open;
    }   

    public function compileHours($times, $timestamp) {
        //$times = $times[strtolower(date('D',$timestamp))];
        $times = isset($times[strtolower(date('D',$timestamp))])?$times[strtolower(date('D',$timestamp))]:'';   
        if(!strpos($times, '-')) return array();
        $hours = explode(",", $times);
        $hours = array_map('explode', array_pad(array(),count($hours),'-'), $hours);
        $hours = array_map('array_map', array_pad(array(),count($hours),'strtotime'), $hours, array_pad(array(),count($hours),array_pad(array(),2,$timestamp)));
        end($hours);
        if ($hours[key($hours)][0] > $hours[key($hours)][1]) $hours[key($hours)][1] = strtotime('+1 day', $hours[key($hours)][1]);
        return $hours;
    }

     public function updateAllPaidOrders($merchant_id = '')
{
    $stats = $this->getAllowedCommissionStats();       
    $status = '';

    if (is_array($stats) && count($stats)) {
        foreach ($stats as $val) {
            $status .= "'" . $val . "',";
        }
        $status = rtrim($status, ',');

        $merchant_id = (int)$merchant_id;

        $stmt = "
            UPDATE mt_order 
            SET order_locked = '2'
            WHERE merchant_id = $merchant_id
            AND status IN ($status)
        ";

        $this->db->exec($stmt);
    }
}

 public  function getAllowedCommissionStats()
    {
        $stats=$this->getOptionAdmin('total_commission_status');
        if (!empty($stats)){
            $stats=json_decode($stats,true);
            return $stats;
        }    
        return false;
    }




public function getOffers($offers_id = '')
{
    // Use the existing PDO connection from $this->db
    $stmt = $this->db->prepare("SELECT * FROM mt_offers WHERE offers_id = :offers_id LIMIT 1");
    
    // Bind the parameter
    $stmt->bindParam(':offers_id', $offers_id, PDO::PARAM_INT);
    
    // Execute the entent
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    return $res ? $res : false;
}






public function getOption($option_name = '', $merchant_id = '')
{
    $and = '';
    if (!empty($merchant_id)) {
        $and = " AND merchant_id = :merchant_id";
    }

    $stmt = "SELECT * FROM mt_option WHERE option_name = :option_name $and LIMIT 0,1";

    $pdo = $this->db; // Assuming $this->db is your PDO instance.
    $query = $pdo->prepare($stmt);

    $query->bindParam(':option_name', $option_name, PDO::PARAM_STR);

    if (!empty($merchant_id)) {
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    }

    $query->execute();
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        return stripslashes($rows[0]['option_value']);
    }

    return '';
}

public function dropdownFormat($data=array(),$value='', $label='', $default_value=array())
    {               
        $list = array();
        if(is_array($default_value) && count($default_value)>=1){
            $list = $default_value;
        } else $list['']='';        
        if(is_array($data) && count($data)>=1){
            foreach ($data as $val) {
                if(isset($val[$value]) && isset($val[$label])){
                   $list[ $val[$value] ] = ($val[$label]);
                }
            }
        }
        $list = array_filter($list);
        return $list;
    }

 public function getMerchantByMtidCC($id = '', $merchant_id = '')
{
    try {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_merchant_cc
            WHERE mt_id = :id AND merchant_id = :merchant_id
        ");

        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        $stmt->execute();

        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            return $result;
        }

        return false;
    } catch (PDOException $e) {
        // Handle error here
        return false;
    }
}


 public function getallrows_daywise($merchant_id = '', $day = '')
{
    try {
        $stmt = $this->db->prepare("SELECT * FROM mt_opening_hours WHERE merchant_id = :merchant_id AND day = :day");
        $stmt->execute([
            ':merchant_id' => $merchant_id,
            ':day' => $day
        ]);
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        
        return $res ?: false; // Return first row or false if empty
    } catch (PDOException $e) {
        return false; // Handle errors silently
    }
}




public function ccExpirationMonth()
    {
      $data=array();
      for ($i = 1; $i <= 12; $i++) {                
        $temp=$i;
        if (strlen($i)==1){
          $temp="0".$i;
        }       
        $data[$temp]=$temp;
      }
      return $data;
    }

     public function ccExpirationYear()
    {
      $data=array();
      $yr_now=date("Y");
      for ($i = 0; $i <= 12; $i++) {                        
        $yr=$yr_now+$i;
        $data[$yr]=$yr;
      }
      return $data;
    }


      public  function getTimeList_with_type($merchant_id='', $delivery_date='',$trans_type='')
    {


        $times = array(); 
        $date_now = date("Y-m-d");
        $time_start = '7:30'; $time_end = '18:30'; $interval = '15 mins';       
        
        $mt_timezone=$this->getOption("merchant_timezone",$merchant_id);
        if(!empty($mt_timezone)){
            
            date_default_timezone_set($mt_timezone);
        }
        
        $delivery_day = isset($delivery_date)?date("l",strtotime($delivery_date)): date("l") ;
        $delivery_day = strtolower($delivery_day);              
        if ( $res = $this->getOpeningHours($merchant_id) ){                   
            if (array_key_exists($delivery_day,(array)$res)){                   
                $time_based = $res[$delivery_day]['hours'];             
                if(!empty($time_based)){                    
                                            
                    $time_based_ex='';
                    if (preg_match("/x/i", $time_based)) {                          
                        $time_based_sep = explode("x",$time_based);                                                     
                        $time_based_sep_1 = explode("-",$time_based_sep[0]);
                        $time_based_sep_2 = explode("-",$time_based_sep[1]);
                        $time_based_start = $time_based_sep_1[0];
                        $time_based_end = $time_based_sep_2[1];
                        
                        $time_based_combined = "$time_based_start-$time_based_end";                         
                        $time_based_ex = explode("-",$time_based_combined);
                    } else $time_based_ex = explode("-",$time_based);
                                            
                    //dump($time_based_ex);
                                            
                    if(is_array($time_based_ex) && count($time_based_ex)>=1){                       
                        $time_start = $time_based_ex[0];
                        //$time_end = $time_based_ex[1];
                        $time_end = date("G:i",strtotime($time_based_ex[1]));

                        /*CHECK IF SAME DAY*/
                        if ($delivery_date==$date_now){
                            $hour_now = date("Gi");
                            $hour_now_l = date("G:i");
                            $time_start_1 = date("Gi",strtotime($time_start));                              
                            if($hour_now>$time_start_1){
                                $time_start = $hour_now_l;
                            }
                        }
                                                    
                    }
                }
            } 
        }       
                
                
        /*CONVERT TO WHOLE NUMBER*/
        
        $enabled_whole_number = false;
        
        if($enabled_whole_number){
            if(!empty($time_start)){
                $time_s = explode(":",$time_start);
                if(is_array($time_s) && count($time_s)>=1){
                    if(isset($time_s[1])){                      
                        $rounded_minutes = round($time_s[1],-1);                                
                        if($rounded_minutes>=60){
                        } else {                    
                            $time_start =$time_s[0].":$rounded_minutes";
                        }                   
                    }
                }
            }    
        }
                       
        $time_interval = 15; 
        
        $website_time_picker_interval= $this->getOptionAdmin('website_time_picker_interval');
        if($website_time_picker_interval>0){
            $time_interval=$website_time_picker_interval;
        }    
        
        
        if($trans_type=='pickup'){
        /*GET MERCHANT TIME INTERVAL*/
        $website_merchant_time_picker_interval = $this->getOption('website_merchant_time_picker_interval',$merchant_id);
        if($website_merchant_time_picker_interval>0){
            $time_interval = $website_merchant_time_picker_interval;
        }    
        }else       if($trans_type=='delivery'){
                
        $website_merchant_time_picker_interval = $this->getOption('website_delivery_merchant_time_picker_interval',$merchant_id);
        if($website_merchant_time_picker_interval>0){
            $time_interval = $website_merchant_time_picker_interval;
        }    
        }else{
            $website_merchant_time_picker_interval = $this->getOption('website_merchant_time_picker_interval',$merchant_id);
        if($website_merchant_time_picker_interval>0){
            $time_interval = $website_merchant_time_picker_interval;
        }    
            
            
        }
                        
                
                
        $time_format = 12;
        
        $website_time_picker_format = $this->getOptionAdmin('website_time_picker_format');     
        if(!empty($website_time_picker_format)){
            $time_format = $website_time_picker_format;
        }    
                        
        /*REMOVE CURRENT TIME*/
        $time_start = date("G:i",strtotime($time_start." +$time_interval mins"));  

                        
        $times = $this->createTimeRange($time_start, $time_end , "$time_interval mins",$time_format);     
        if(is_array($times) && count($times)>=1){           
        } else {
            $times = $this->createTimeRange("6:00", "23:59" , "$time_interval mins",$time_format);        
        }       
                
        /*fixed time list with end of time opening hours*/
        $time_end_integer = str_replace(":","",$time_end);
        $time_end_last = 0;         
        if(is_array($times) && count($times)>=1){
            $time_end_last = date("G:i",strtotime($times[ count($times)-1 ]));
            $time_end_last = str_replace(":","",$time_end_last);            
            if($time_end_last>$time_end_integer){
                $times[ count($times)-1 ]  = $time_end;
            }
        }
                    
        $final_time = array();
        if(is_array($times) && count($times)>=1){
            foreach ($times as $val) {
                //$final_time[$val]=$val;
                $final_time[$val]=$this->prettyTime($val);
            }
        } 

        //print_r($final_time) ;die(); 
                
        return $final_time;
    }


     public  function getTimeList_with_type_new($merchant_id='', $delivery_date='',$trans_type='')
    {


        $merchant_id=$merchant_id;
        $todaydate=$delivery_date; 
        $transaction_type=$trans_type;
       
       $timestamp = strtotime($delivery_date);
        $day = date('l', $timestamp);

        //$day=date("l");
        $day=strtolower($day);
$date_now = date("Y-m-d");

        $current_day=date("l");
        $current_day=strtolower($current_day);
        $res=$this->getallrows_daywise($merchant_id,$day);
        if($res['status']=="close"){
        $final_times[]="";
        return $final_times;
        }else{
             
              //delivery type
               if($transaction_type=="delivery")
               {
                
                if($res['stores_del_day']==1){
                $start_time =$res['start_time']; 
                $end_time   =$res['end_time']; 
                
                
                $interval = '30 mins';
                $interval = $this->getOption('website_delivery_merchant_time_picker_interval',$merchant_id).' mins';
                $format = '12';

                $startTime = strtotime($start_time); 
                $startTime_start = strtotime($start_time); 
                $endTime   = strtotime($end_time);
                $returnTimeFormat = ($format == '12')?'g:i A':'G:i';

    
                $current   = time(); 
                $addTime   = strtotime('+'.$interval, $current); 
                $diff      = $addTime - $current;
    
                if($date_now==$todaydate && $current>=$startTime){
                    $startTime=$current;                    
                }
    
                //$times1 = array();        
                while ($startTime<=$endTime) {
                    $startTime += $diff; 
                if(($startTime>=$current &&  $startTime>=$startTime_start && $startTime<=$endTime) || ($day!=$current_day && $startTime>=$startTime_start && $startTime<=$endTime)){
                    
                    
                    
                    $times1_new = date($returnTimeFormat, $startTime);
                    $times1[$times1_new] =$times1_new;  

                    }
                
                 } 
                //$times1[] = date($returnTimeFormat, $startTime); 
             //print_r($times1);die(); 

                }else{
                    //$times1[]="";
                }


                if($res['stores_del_day_2']==1){
                
                $start_time_pm  =$res['start_time_pm']; 
                $end_time_pm    =$res['end_time_pm']; 
                //echo $start_time_pm;die();
                $start_time_pm= date("G:i", strtotime($start_time_pm));
                $end_time_pm    =date("G:i", strtotime($end_time_pm));
           
           

                $start_time_pm  =$start_time_pm.':00'; 
                $end_time_pm    =$end_time_pm.':00'; 

                $interval = '30 mins';
                $interval =$this->getOption('website_delivery_merchant_time_picker_interval',$merchant_id).' mins';
                //$interval = getOption($merchant_id,'website_delivery_merchant_time_picker_interval');
                $format = '12';

                $startTime = strtotime($start_time_pm); 
                $startTime_start = strtotime($start_time_pm); 
                $endTime   = strtotime($end_time_pm);
                $returnTimeFormat = ($format == '12')?'g:i A':'G:i';
                $current   = time(); 
                $addTime   = strtotime('+'.$interval, $current); 
                $diff      = $addTime - $current;
        //echo date('Y-d-m h i a s',$endTime);  
                //$times2 = array();    
                    if($date_now==$todaydate && $current>=$startTime){
                    $startTime=$current;                    
                }
    
                
                while ($startTime<=$endTime ) {
                    $startTime += $diff;  
                    //$startTime_start += $diff;  
                    if(($startTime>=$current &&  $startTime>=$startTime_start && $startTime<=$endTime) || ($day!=$current_day && $startTime>=$startTime_start && $startTime<=$endTime)){
                    $times2_new=date($returnTimeFormat, $startTime); 
                    $times2[$times2_new]=$times2_new; 
                    }
                // print_r($times2);
                
                 }
                 //$times2[] = date($returnTimeFormat, $startTime); 

                




                }else{
                    //$times2[]="";
                }

              //$final_times = array_merge($times1, $times2);
              
              
              if(isset($times1) && !empty($times1) &&  isset($times2) && !empty($times2) )
                {$final_times = array_merge($times1, $times2);}
                else if(isset($times1) && !empty($times1))
                {$final_times = $times1;}
            else if(isset($times2) && !empty($times2) )
                {$final_times =$times2;}
              

              //print_r($final_times);die();

            }

            //delivery type ends


            //pickuptype

            if($transaction_type=="pickup")
               {
                
                if($res['stores_pickup_day']==1){
                $start_time =$res['start_time']; 
                $end_time   =$res['end_time']; 
                
                
                $interval = '30 mins';
               $interval = $this->getOption('website_merchant_time_picker_interval',$merchant_id).' mins';
                $format = '12';

                $startTime = strtotime($start_time); 
                $startTime_start = strtotime($start_time); 
                $endTime   = strtotime($end_time);
                $returnTimeFormat = ($format == '12')?'g:i A':'G:i';

    
                  $current   = time(); 
                $addTime   = strtotime('+'.$interval, $current); 
                $diff      = $addTime - $current;
    
        if($date_now==$todaydate && $current>=$startTime){
                    $startTime=$current;                    
                }
    
                //$times1 = array();        
                while ($startTime<=$endTime) {
                    $startTime += $diff;  
                    if(($startTime>=$current &&  $startTime>=$startTime_start && $startTime<=$endTime) || ($day!=$current_day && $startTime>=$startTime_start && $startTime<=$endTime)){
                    $times1_1 = date($returnTimeFormat, $startTime);
                    $times1[$times1_1] =$times1_1;
                    }
                //$startTime += $diff; 
                 } 
                //$times1[] = date($returnTimeFormat, $startTime); 
             //print_r($times1);die(); 

                }else{
                    //$times1[]="";
                }


                if($res['stores_pickup_day_2']==1){
                
                $start_time_pm  =$res['start_time_pm']; 
                $end_time_pm    =$res['end_time_pm']; 
                //echo $start_time_pm;die();
                $start_time_pm= date("G:i", strtotime($start_time_pm));
                $end_time_pm    =date("G:i", strtotime($end_time_pm));
           
           

                $start_time_pm  =$start_time_pm.':00'; 
                $end_time_pm    =$end_time_pm.':00'; 

                $interval = '30 mins';
                $interval = $this->getOption('website_merchant_time_picker_interval',$merchant_id).' mins';
                $format = '12';

                $startTime = strtotime($start_time_pm); 
                $startTime_start = strtotime($start_time_pm); 
                $endTime   = strtotime($end_time_pm);
                $returnTimeFormat = ($format == '12')?'g:i A':'G:i';
                $current   = time(); 
                $addTime   = strtotime('+'.$interval, $current); 
                $diff      = $addTime - $current;
        //echo date('Y-d-m h i a s',$endTime);  
                //$times2 = array();
    if($date_now==$todaydate && $current>=$startTime){
                    $startTime=$current;                    
                }
                    
                while ($startTime<=$endTime) {$startTime += $diff;  
                    if(($startTime>=$current &&  $startTime>=$startTime_start && $startTime<=$endTime) || ($day!=$current_day && $startTime>=$startTime_start && $startTime<=$endTime)){
                    $times2_new=date($returnTimeFormat, $startTime); 
                    $times2[$times2_new]=$times2_new; 
                    }
                // print_r($times2);
                //$startTime += $diff;  
                 }
                 //$times2[] = date($returnTimeFormat, $startTime); 

                




                }else{
                    //$times2[]="";
                }
                
                
                if(isset($times1) && !empty($times1) &&  isset($times2) && !empty($times2) )
                {$final_times = array_merge($times1, $times2);}
                else if(isset($times1) && !empty($times1))
                {$final_times = $times1;}
            else if(isset($times2) && !empty($times2) )
                {$final_times =$times2;}
              //print_r($final_times);die();

            }
            return $final_times;
            //pickup type ends   
       }
    }





    public  function applyVoucher($merchant_id='')
    {
        $enabled=$this->getOption('merchant_enabled_voucher',$merchant_id);
        if ( $enabled!="yes"){
            return ;
        }       
        $style='';
        $has_voucher=false;     
        $code='';
        $text=$this->translation("default","Use Voucher");
         if (isset($_SESSION['voucher_code'])){                 
            if (!empty($_SESSION['voucher_code']['voucher_name'])){
                $has_voucher=true;              
                $style="display:none;";
                $code=$_SESSION['voucher_code']['voucher_name'];
                $text=$this->translation("default","Remove Voucher");
            }                
        }         
        ?>
        <div class="voucher_wrap">
    <?php 
        echo '<input type="text" name="voucher_code" id="voucher_code" value="' . htmlspecialchars($code) . '" 
        placeholder="' . htmlspecialchars($this->translation("default", "Enter Voucher here")) . '" 
        class="grey-fields center" style="' . htmlspecialchars($style) . '">';
    ?>
    <a href="javascript:;" class="green-button apply_voucher"><?php echo htmlspecialchars($text); ?></a>
</div>

        <?php
    }



   public function getShippingRates($mtid = '')
{
    $stmt = "SELECT * FROM mt_shipping_rate WHERE merchant_id = :merchant_id ORDER BY id ASC";
    
    try {
        $connection = $this->db; // Assuming `$this->db` is a PDO connection
        $query = $connection->prepare($stmt);
        $query->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);
        $query->execute();
        
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    } catch (PDOException $e) {
        // Handle exception or log error
        echo "Error: " . $e->getMessage();
    }
    
    return false;
}
   


    public function getTags()
    {
        try {
            // Prepare the SQL query
            $sql = "
                SELECT * 
                FROM mt_tags
                ORDER BY tag_name ASC
                LIMIT 1000
            ";
            
            // Prepare and execute the statement
            $stmt = $this->db->prepare($sql);
            $stmt->execute();
            
            // Fetch all results
            $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // Check if any results were found
            if ($resp) {
                return $resp;
            }
            
            return false;
        } catch (PDOException $e) {
            // Handle exception or log error
            // For example: return false or handle error gracefully
            return false;
        }
    }




 public function generate_dropdownlist($name, $selectedValue, $options, $attributes = []) {
    $html = '<select name="' . $name . '"';
    
    foreach ($attributes as $attr => $value) {
        $html .= ' ' . $attr . '="' . $value . '"';
    }
    
    $html .= '>';
    
    foreach ($options as $value => $text) {
        $isSelected = $value == $selectedValue ? ' selected' : '';
        $html .= '<option value="' . $value . '"' . $isSelected . '>' . $text . '</option>';
    }
    
    $html .= '</select>';
    
    return $html;
}








    public function DisplayMembershipType($merchant_type='', $terms='')
    {       
        $list=$this->MembershipType(); $terms_list=$this->InvoiceTerms();
        if (array_key_exists($merchant_type,$list)){
            if ( $merchant_type==3 ){
                if(isset($terms_list[$terms])){
                    return $list[$merchant_type]." ".$terms_list[$terms];
                } else return $list[$merchant_type];
            } else return $list[$merchant_type];            
        }
        return '-';
    }   

    public function MembershipType()
    {
        return array(
          1=>$this->translation("default","Membership"),
          2=>$this->translation("default","Commission"),
          3=>$this->translation("default","Commission+Invoice")
        );
    }


     public function prettyInvoiceTerms($term_id='')
    {
      $list=$this->InvoiceTerms();
      if (array_key_exists($term_id,$list)){
        return $list[$term_id];
      }
      return false;
    }



    public function InvoiceTerms()
    {
        return array(
          1=>$this->translation("default","Daily"),
          7=>$this->translation("default","Weekly"),
          15=>$this->translation("default","Every 15 Days"),
          30=>$this->translation("default","Every 30 Days"),
        );
    }
    public function validImageExtension()
  {
    return array('jpeg', 'png' ,'jpg' , 'gif' ); 
  }

  public  function imageLimitSize()
  {
    return 10485760;
  }

    public  function prettyUrl($url='')
    {
        if (preg_match("/http/i", $url)) {
            return $url;
        }
        return "http://".$url;
    }

  public function getImage($image='', $show_default = false)
  { 
    $url='';      
    $path_to_upload=Config::$baseUrl."/upload/";        
     
    if (!empty($image)){
            
      if (file_exists($path_to_upload."/$image")||1==1){
                                      
        $url = $path_to_upload."$image";

      }
    } 
    
    if($show_default==TRUE){
       if(empty($url)){
          $url = Config::$baseUrl."/assets/images/default-image-merchant.png";
       }
    }
        
    return $url;
  }


  public function generateInvoiceToken()
{
    // generate 6-digit token
    $token = $this->generateCode(6);

    // quote because your old self::q() was adding single quotes
    $quoted = "'" . $token . "'";

    $stmt = "
        SELECT invoice_token
        FROM mt_invoice
        WHERE invoice_token = $quoted
        LIMIT 0,1
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetch(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        // optional: log / echo error
        $res = false;
    }

    // if token already exists → regenerate
    if ($res) {
        $token= $this->generateInvoiceToken();
    }

    return $token;
}




    public  function getDesktopLogo()
    {
        $upload_path=Config::$baseUrl."/upload/";   
        $logo=$this->getOptionAdmin('website_logo');

        if (!empty($logo)){
           
            if (file_exists($upload_path."/$logo")||1==1){
                
                return $this->uploadURL()."/$logo";
            }
        } 
        return $this->assetsURL()."/images/logo-desktop.png";
    } 


    public  function getMobileLogo()
    {
        $upload_path=Config::$baseUrl."/upload/"; 
        $logo=$this->getOptionAdmin('mobilelogo');
        

       
        if (!empty($logo)){
            
              
                return $this->uploadURL()."/$logo";
            
        } 
        return $this->assetsURL()."/images/logo-mobile.png";
    }  

    public function test(){
      return "hello";
    } 


  


    public function htaccessForUpload()
  {
    $content ='<Files *>'."\n";
    $content .='SetHandler None'."\n";
    $content .='</Files>'."\n";
    
    $content .='<Files *.php>'."\n";
    $content .='deny from all'."\n";
    $content .='</Files>'."\n";
    
    $content .='<Files *.html>'."\n";
    $content .='deny from all'."\n";
    $content .='</Files>'."\n";
    
    $content .='<Files *.js>'."\n";
    $content .='deny from all'."\n";
    $content .='</Files>'."\n";
    
    $content .='<Files *.cgi>'."\n";
    $content .='deny from all'."\n";
    $content .='</Files>'."\n";
    return $content;
  }


    public function getPackagesList($price = false)
{
    $and = '';
    if ($price) {
        $and = " AND price > 0 ";
    }

    $data_feed = array();
    $stmt = "SELECT * FROM mt_packages WHERE status = :status" . $and . " ORDER BY sequence ASC";

    // Prepare the SQL statement
    $query = $this->db->prepare($stmt);

    // Bind parameters
    $query->bindValue(':status', 'publish', PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Fetch the results
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        if ($this->data == "list") {
            foreach ($rows as $val) {
                $data_feed[$val['package_id']] = ucwords($val['title']);
            }
            return $data_feed;
        } else {
            return $rows;
        }
    }

    return false;
}

  public function ExpirationType()
    {
        return array(
         'days'=>$this->translation("default","Days"),
         'year'=>$this->translation("default","Year")
        );
    }

     public function smsSeparator()
   {
      return "\n";
   }

   public function isMerchantLogin()
    {                       
        $is_login=FALSE;                        
        if (!empty($_SESSION['kr_merchant_user'])){
            $user=json_decode($_SESSION['kr_merchant_user']);                                   
            if (is_numeric($user[0]->merchant_id)){
                $is_login=TRUE;
            }
        }
        if ($is_login){
            return true;
        }
        return false;
    }


    public  function getPerPage()
    {
        return 4;       
    }




    public function updateMerchantSponsored()
{
    // Get the PDO instance from the class property
    $pdo = $this->db;

    // Get today's date
    $today = date('Y-m-d');

    // Prepare the SQL statement with placeholders
    $stmt = $pdo->prepare("
        UPDATE mt_merchant
        SET is_sponsored = :is_sponsored
        WHERE is_sponsored = :current_status
        AND sponsored_expiration < :today
    ");

    // Bind the parameters
    $stmt->bindParam(':is_sponsored', $is_sponsored);
    $stmt->bindParam(':current_status', $current_status);
    $stmt->bindParam(':today', $today);

    // Set the parameter values
    $is_sponsored = '1';
    $current_status = '2';

    // Execute the statement
    $stmt->execute();
}


public function updateMerchantExpired()
{
    // Get the PDO instance from the class property
    $pdo = $this->db;

    // Get today's date
    $today = date('Y-m-d');

    // Prepare the SQL statement with placeholders
    $stmt = $pdo->prepare("
        UPDATE mt_merchant
        SET status = :status
        WHERE status = :current_status
        AND membership_expired < :today
        AND is_commission = :is_commission
    ");

    // Bind the parameters
    $stmt->bindParam(':status', $status);
    $stmt->bindParam(':current_status', $current_status);
    $stmt->bindParam(':today', $today);
    $stmt->bindParam(':is_commission', $is_commission);

    // Set the parameter values
    $status = 'expired';
    $current_status = 'active';
    $is_commission = '1';

    // Execute the statement
    $stmt->execute();
}



public function hasMerchantAccess($tag='')
  {
    /*LIST OF ACCEPTED CONTROLLER NAME IN MERCHANT*/
    $accepted_tag=array(
      'MerchantStatus',
      'purchaseSMScredit',
      'paypalInit',
      'stripeInit',
      'mercadopagoInit',
      'sisowinit',
      'payuinit',
      'obdinit',
      'pysinit',
      'creditCardInit',
      'smsReceipt',
      'Setlanguage',
      'pay',
      'paymentconfirm',
      'faxreceipt',
      'profile',
      'print'
    );
    if (in_array($tag,$accepted_tag)){
      return true;
    } 
    
    /*HIDE TABLE BOOKING IF DISABLED */
    if ( $tag=="tablebook"){
      $tbl_booking=$this->getOption( $this->getMerchantID() ,'merchant_master_table_boooking');
      if($tbl_booking==1){
        return false;
      }   
    }
    
    /*HIDE MINIMUM TABLE RATES IF SEARCH TYPE IS BY LOCATION*/
    if ( $tag=="mintable"){
      if ($this->isSearchByLocation()){
        return false;
      }
    } 
        
    if ($tag=="invoice"){
      if ( $merchant_type=$this->getMerchantMembershipType( $this->getMerchantID() )){
        if($merchant_type==1){
          return false;
        }     
      }
    }   
    
    /*special category*/
    if($tag=="CategoryList"){
       $merchant_category_disabled=$this->getOptionAdmin('merchant_category_disabled');
       if($merchant_category_disabled==1){
          return false;
       }    
    }     
    
    
    
    /*CHECK IF ENABLED IN PAYMENT GATEWAY SETTINGS*/
    if ( $tag=="obdreceive"){
      $tag='obd';
    } 
    
    $payment_list=$this->PaymentOptionList();   
    if (array_key_exists($tag,(array)$payment_list)){
      $list_payment_enabled=$this->getMerchantListOfPaymentGateway();   
      if ( !in_array($tag,(array)$list_payment_enabled)){
         return false;
      } else {
        $master_key="merchant_switch_master_$tag";
        $master_key_val=$this->getOption($this->getMerchantID(),$master_key);
        if($master_key_val==1){
          return false;
        }     
      }
    }
    
    if ($tag=='sms-gateway'){
      $mechant_sms_enabled=$this->getOptionAdmin('mechant_sms_enabled');
      if ($mechant_sms_enabled=="yes"){
         return false;  
      }
    } 
    
    if ( $tag=="purchaseSMS"){
      $mechant_sms_purchase_disabled=$this->getOptionAdmin('mechant_sms_purchase_disabled');
      if ( $mechant_sms_purchase_disabled=="yes"){
        return false;
      }
    } 
    
    /*check if table booking is enabled by admin*/
    if ( $tag=="tablebooking"){     
      if ($this->getOptionAdmin('merchant_tbl_book_disabled')==2){       
        return false;
      }
    }
    
    switch ($tag) {
      case "tablebooking":
          $tag="tablebook"; 
        break;
      case "paypalSettings":
          $tag="paypal";  
          break; 
      case "stripeSettings":    
          $tag="stripe";  
          break; 
      case "mercadopagoSettings":    
          $tag="mercadopago"; 
          break; 
      case "sisowsettings":    
          $tag="ide"; 
          break;     
      case "payumoneysettings":    
          $tag="payu";  
          break;         
      case "payserasettings":    
          $tag="pys"; 
          break;             
      case "payondelivery":    
          //$tag="ccr"; 
          $tag="pyr";
          break;                 
      default:
        break;
    }
    
    $info=$this->getMerchantInfo();   
    if ( is_array($info) && count($info)>=1){
      $info=(array)$info[0];      
      if (isset($info['merchant_user_id'])){
        $access=json_decode($info['user_access']);

        if (!is_array($access)) {
            /*print_r($info);die();
            echo "you dont have any access";die();*/
        }

        $tag=strtolower($tag);
        $access = array_map('strtolower', $access);       
        if (in_array($tag,(array)$access)){
          return true;
        }     
      } else return true;                 
    }
    return false;   
  }











    public function getSMSPackagesById($package_id = '')
{
    // Prepare the SQL statement
    $stmt = "
        SELECT * 
        FROM mt_sms_package 
        WHERE sms_package_id = :package_id 
        LIMIT 0,1
    ";

    // Execute the query
    $query = $this->db->prepare($stmt);
    $query->bindParam(':package_id', $package_id, PDO::PARAM_INT);
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }

    return false;    
}


public function getPaymentProviderListActive()
{
    try {
        $stmt = "SELECT * FROM mt_payment_provider WHERE status IN ('publish','published') ORDER BY sequence ASC";
        
        // Prepare and execute the query using PDO
        $query = $this->db->prepare($stmt);
        $query->execute();
        
        // Fetch all results
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        
        if ($res) {
            return $res;
        }
        
        return false;
        
    } catch (PDOException $e) {
        // Handle any potential PDO errors
        echo "Error: " . $e->getMessage();
        return false;
    }
}


  public function hasSMSCredits()
{
    $stats = $this->getOptionAdmin('mechant_sms_purchase_disabled'); 
    if ($stats == "yes") {
        return true;
    }
    
    $merchant_id = $this->getMerchantID();
    
    // Using PDO for database interaction
    $stmt = "SELECT * FROM mt_sms_package_trans WHERE merchant_id = :merchant_id AND status IN ('paid') LIMIT 1";

    // Prepare the statement
    $query = $this->db->prepare($stmt);
    
    // Bind the merchant_id parameter
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        return !empty($res); // Return true if there are results, false otherwise
    }
    
    return false; 
}

 public function SMSsendStatus()
    {
        return array(
           1=>$this->translation("default","Send to All Customer"),
           2=>$this->translation("default","Send to Customer Who already buy your products"),
           3=>$this->translation("default","Send to specific mobile numbers")
        );
    }


    public function getAllCustomerCount()
{
    $stmt = "
    SELECT COUNT(*) as total
    FROM mt_client
    WHERE contact_phone != ''
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return $res['total'];
        }
        return 0;
    } catch (PDOException $e) {
        // Handle exception
        echo "Database error: " . $e->getMessage();
        return 0;
    }
}


public function getAllClientsByMerchant($merchant_id = '')
{
    $stmt = "
    SELECT a.client_id, COUNT(*) as total
    FROM mt_client a
    WHERE 
    client_id IN (
        SELECT client_id 
        FROM mt_order 
        WHERE client_id = a.client_id AND merchant_id = :merchant_id
    )
    AND contact_phone != ''
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute([':merchant_id' => $merchant_id]);
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res) {
            return $res['total'];
        }
        return 0;
    } catch (PDOException $e) {
        // Handle exception
        echo "Database error: " . $e->getMessage();
        return 0;
    }
}





 public function getSMSPackagesList($price = false)
{
    $and = '';
    if ($price) {
        $and = " AND price > 0 ";
    }

    $stmt = "
    SELECT * FROM mt_sms_package
    WHERE status = 'publish'
    $and
    ORDER BY sequence ASC
    ";

    $db = $this->db; // Assuming the PDO connection is stored in $this->db from your model

    try {
        $query = $db->prepare($stmt);
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            if ($this->data == "list") {
                $data_feed = [];
                foreach ($rows as $val) {
                    $data_feed[$val['sms_package_id']] = ucwords($val['title']);
                }
                return $data_feed;
            } else {
                return $rows;
            }
        }
    } catch (PDOException $e) {
        // Handle exception
        return false;
    }

    return false;
}


public function chk_duplicate_transaction_id($transaction_id)
{
    

    $stmt = "
    SELECT * FROM mt_sms_package_trans
    WHERE payment_gateway_response = $transaction_id
    ";

    $db = $this->db; // Assuming the PDO connection is stored in $this->db from your model

    try {
        $query = $db->prepare($stmt);
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            return 1;
        }else{
            return 0;
        }
    } catch (PDOException $e) {
        // Handle exception
        return false;
    }

    return false;
}



     


 public function standardPrettyFormat($price='')
    {        
        $decimal=$this->getOptionAdmin('admin_decimal_place');
        $decimal_separators=$this->getOptionAdmin('admin_use_separators');      
        $thou_separator='';
        if (!empty($price)){
            if ($decimal==""){
                $decimal=2;
            }
            if ( $decimal_separators=="yes"){
                $thou_separator=",";
            }       
            return number_format((float)$price,$decimal,".",$thou_separator);
        }   
        if ($decimal==""){
            $decimal=2;
        }   
        return number_format(0,$decimal,".",$thou_separator);   
        
    }

    public  function prettyTime($time='')
    {
        if (!empty($time)){
            $format=$this->getOptionAdmin('website_time_format');          
            if(empty($format)){
                $format="g:i:s a";
            }
            return date($format,strtotime($time));
        }
        return false;
    }


    public function prettyDate($date='',$full=false)
    {
        if ($date=="0000-00-00"){
            return ;
        }    
        if ($date=="0000-00-00 00:00:00"){
            return ;
        }
        if ( !empty($date)){
            if  ($full==TRUE){
                 return date('M d,Y G:i:s',strtotime($date));
            } else return date('M d,Y',strtotime($date));
        }
        return false;
    }


      public function sendFax($merchant_id='',$order_id='')
    {           
      $enabled=$this->getOption('fax_merchant_enabled',$merchant_id);
      if ( $enabled==2){
        $params=array(
          'merchant_id'=>$merchant_id,
          'faxno'=>$this->getOption('fax_merchant_number',$merchant_id),
          'recipname'=>$this->getOption('fax_merchant_recipient',$merchant_id),
          'faxurl'=>Config::$baseUrl."/fax/?id=$order_id",  
          'date_created'=>$this->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        
        $this->insertData('mt_fax_broadcast', $params);
      }
    }


     public function MerchantchangeStatus($mtid='' , $data='')
   {
           
       $lang='en';   
       $email_enabled=$this->getOptionAdmin("merchant_change_status_email");
       $sms_enabled=$this->getOptionAdmin("merchant_change_status_sms");
       $sender=$this->getOptionAdmin("global_admin_sender_email");
       
       if($email_enabled!=1 && $sms_enabled!=1){        
          return false;
       }
       
       if (isset($data['old_status']) && isset($data['status']) ){
           if (!empty($data['old_status'])){
               if ( $data['old_status']==$data['status']){
                  return false;
               }
           }
       }

      
       
       $tpl=$this->getOptionAdmin("merchant_change_status_tpl_content_$lang");
       $subject=$this->getOptionAdmin("merchant_change_status_tpl_subject_$lang");
       $tpl_sms=$this->getOptionAdmin("merchant_change_status_sms_content_$lang");
       
       //$data['status']=t($data['status']);
       
       $pattern=array(                 
           'restaurant_name'=>'restaurant_name',    
           'status'=>'status',
           'sitename'=>$this->getOptionAdmin('website_title'),
           'siteurl'=>Config::$baseUrl,                    
        );
        $tpl=$this->replaceTemplateTags($tpl,$pattern,$data); 
        $subject=$this->replaceTemplateTags($subject,$pattern,$data); 
        $tpl_sms=$this->replaceTemplateTags($tpl_sms,$pattern,$data);     
        
        $merchant_email=isset($data['contact_email'])?$data['contact_email']:'';
        $contact_phone=isset($data['contact_phone'])?$data['contact_phone']:'';

        $params=array(
          'email_address'=>$merchant_email,
          'sender'=>$sender,
          'subject'=>$subject,
          'content'=>$tpl,
          'date_created'=> $this->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          
          /*custom code start*/ 
          'order_id'=>$data['order_id'],    
          /*custom code ends*/
          
          'module_type'=>'core'
        );                      
        
        $this->insertData('mt_email_logs', $params);  
        
        $params=array(
          'contact_phone'=>$contact_phone,
          'sms_message'=>$tpl_sms,
          'date_created'=> $this->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']          
        );                      
        
        $this->insertData('mt_sms_broadcast_details', $params);        
        
        /*unset($DbExt);
        FunctionsV3::runCronEmail();
        FunctionsV3::runCronSMS();*/
   }


   public function windcave_request($method, $url, $body = null,$apiUsername,$apiKey) {
    $username = $apiUsername; // store in env
    $password = $apiKey;

    

    $ch = curl_init();
    $headers = ['Content-Type: application/json'];
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, "$username:$password");
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, strtoupper($method));
    if ($body !== null) {
        $json = json_encode($body);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $json);
        $headers[] = 'Content-Length: ' . strlen($json);
    }
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_TIMEOUT, 15);
    $resp = curl_exec($ch);

    $data = json_decode($resp, true);
    $acquirerResponse = $data['transactions'][0]['acquirer']['responseText'] ?? null;
    $merchantRef = $data['transactions'][0]['merchantReference'] ?? null;
    if ($merchantRef) {
   
    $orderId = str_replace("Order#", "", $merchantRef);
    
    }

    

    $params=array(
          'payment_type'=>"windcave",
          'payment_reference'=>$data['transactions'][0]['id'],
          'order_id'=> $orderId,
          'merchant_ref'=> $orderId,
          'raw_response'=> json_encode($resp, true),
          'ip_address'=>$_SERVER['REMOTE_ADDR']          
        );                      
        
        $this->insertData('mt_payment_order', $params);        
        
     return $acquirerResponse;

    
}





   public function getSizeList_sorting($merchant_id)
{
    $data_feed[] = '';

    $stmt = "SELECT * FROM mt_size WHERE merchant_id = ? ORDER BY sequence ASC";
    $params = [$merchant_id];

    $cmd = $this->db->prepare($stmt);
    if ($cmd->execute($params)) {
        $res = $cmd->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            if ($this->data == "list") {
                foreach ($res as $val) {
                    $data_feed[$val['size_id']] = $val['size_name'];
                }
                return $data_feed;
            } else {
                return $res;
            }
        }
    }

    return false;
}


       public function replaceTemplateTags($tpl='',$pattern='', $data='')
    {
      foreach ($pattern as $key=>$val) {
        switch ($key) {
          case "sitename":
          case "siteurl": 
          case "accept_link": 
          case "decline_link":  
          case "receipt":
          case "order_details": 
          case "remarks":
          case "total_amount_order":
              
              /*custom code 7 start*/ 
        case "merchant_email_tag":  
        /*custom code 7 ends*/
        
            $tpl=$this->smarty($key,$val,$tpl);
            break;        
          case "total_w_tax": 
          case "total_amount":
              $tpl=$this->smarty($key,
            isset($data[$val])?$this->formatNumber($data[$val]):'',$tpl);
              break; 
          case "expiration_date":    
          case "date_booking":
              $tpl=$this->smarty($key,
            isset($data[$val])? date("M d,Y",strtotime($data[$val]))  :'',$tpl);
             break; 
          default:            
            $tpl=$this->smarty($key,
            isset($data[$val])?$this->clearString($data[$val]):'',$tpl);
            break;
        }       
      }
      return $tpl;
    }





     public  function PaymentOptionList()
    {
        /*
        Important: you can change the value but not the key
        like cod ocr pyr etc 
        */
        
        return array(
          'cod'=>$this->translation("default","Cash On delivery"),
          'windcave'=>$this->translation("default","Card Pay(Windcave)"),
          'paypal_v2'=>$this->translation("default","Paypal V2"),
          'stp'=>$this->translation("default","Stripe"), 
          /*custom code 2 start */
          'poli'=>$this->translation("default","Poli"),
          /*custom code 2 ends */
           /*custom code 3 start */
          //'sop'=>$this->translation("default","Swipe on Pickup"),
          
          /*custom code 3 ends */
          
          
          'pyr'=>$this->translation("default","Alternative Payment")       
          
                 
                 
        );
    }

    public function getPaymentProvider($id = '')
{
    // Ensure $id is properly sanitized or validated
    $id = intval($id); // Use intval to sanitize the id

    // Define the SQL query with a placeholder for the id
    $stmt = "SELECT * FROM mt_payment_provider WHERE id = :id LIMIT 1";

    // Prepare and execute the statement
    $pdo = $this->db; // Assuming $this->db is a PDO instance
    $query = $pdo->prepare($stmt);
    $query->bindParam(':id', $id, PDO::PARAM_INT);
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res;
    }
    return false;
}


public function getPaymentProviderList() {
    $stmt = "SELECT * FROM mt_payment_provider ORDER BY sequence ASC";
    
    try {
        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        
        return $res;
    } catch (PDOException $e) {
        // Handle query error
        echo 'Query failed: ' . $e->getMessage();
        return false;
    }
}



public function getPaymentProviderMerchant($merchant_id='')
    {
        $provider=array();
        $payondeliver_list=$this->getOption('payment_provider',$merchant_id);
        if (!empty($payondeliver_list)){
            $payondeliver_list=json_decode($payondeliver_list);
            if (is_array($payondeliver_list) && count($payondeliver_list)>=1){
                foreach ($payondeliver_list as $val) {
                    if ( $res=$this->getPaymentProvider($val)){                     
                        $provider[]=array(
                          'id'=>$res['id'],
                          'payment_name'=>$res['payment_name'],                       
                          'payment_logo'=>$res['payment_logo'],
                        );
                    }
                }
            }      
            
            if (is_array($provider) && count($provider)>=1) {
                return $provider;
            }               
        }   
        return false;        
    }



    public  function getMerchantPaymentListNew1($merchant_id='',$amount='') //add amount for stripe restriction
  {
      /*custom code start*/
         $transaction_type = isset($_GET['transaction_type'])?$_GET['transaction_type']:''; 
         if($_GET['debug']){    
                
            /* $res=SingleAppClass::getCart($_GET['device_uiid']);    
        print_r($res);  
                
             echo $this->data['transaction_type'];  
                echo $_GET['transaction_type']; */
             }
        /*custom code ends*/
        
        $payment_available=array(); 
        $payment_available_final=array();
        $payment_list = $this->PaymentOptionList();
        $merchant_type=$this->getMerchantMembershipType($merchant_id);       
        //dump($merchant_type);
        switch ($merchant_type) {           
            case 2:                     
                /*COMMISSION*/  
                $payment_available=$this->getMerchantListOfPaymentGateway();                    
                //dump($payment_available);
                if(is_array($payment_available) && count($payment_available)>=1){
                   foreach ($payment_available as $payment_key) {                      
                       $master_key="merchant_switch_master_$payment_key";
                       $master_key_val=$this->getOption($master_key,$merchant_id);
                       if($master_key_val!=1){
                                                
                          if(isset($payment_list[$payment_key])){
                             $payment_available_final[$payment_key]=$payment_list[$payment_key];
                          } 
                          
                          /*custom code 3 start*/
                          if($_SESSION['kr_delivery_options']['delivery_type']=='pickup' || $transaction_type=="pickup"){   
                            
                          }else{unset($payment_available_final['sop']);}
                          /*custom code 3 ends*/
                          
                          if ($payment_key=="pyr"){
                              $provider_list=$this->getPaymentProviderMerchant($merchant_id);
                              $merchant_payondeliver_enabled=$this->getOption('merchant_payondeliver_enabled',$merchant_id);
                              if($merchant_payondeliver_enabled==""){
                                 $provider_list=array();                                 
                              }                           
                              if (!is_array($provider_list) && count((array)$provider_list)<=1){                
                                  unset($payment_available_final['pyr']);
                              }                   
                          }                                           
                          
                       }                                                   
                   }
                }       
                break;
        
            default:
                /*MEMBERSHIP IS DEFAULT*/           
                if ( $this->getOption('merchant_disabled_cod',$merchant_id)==""){
                    $payment_available[]='cod';
                }
                if ( $this->getOption('merchant_disabled_ccr',$merchant_id)==""){
                    $payment_available[]='ocr';
                }
                if ( $this->getOption('enabled_paypal',$merchant_id)=="yes"){
                    $payment_available[]='pyp';
                }
                if ( $this->getOption('stripe_enabled',$merchant_id)=="yes"){
                    $payment_available[]='stp';
                }
                if ( $this->getOption('merchant_mercado_enabled',$merchant_id)=="yes"){
                    $payment_available[]='mcd';
                }
                if ( $this->getOption('merchant_sisow_enabled',$merchant_id)=="yes"){
                    $payment_available[]='ide';
                }
                if ( $this->getOption('merchant_payu_enabled',$merchant_id)=="yes"){
                    $payment_available[]='payu';
                }
                if ( $this->getOption('merchant_paysera_enabled',$merchant_id)=="yes"){
                    $payment_available[]='pys';
                }
                if ( $this->getOption('merchant_payondeliver_enabled',$merchant_id)=="yes"){
                    $payment_available[]='pyr';
                }
                if ( $this->getOption('merchant_enabled_barclay',$merchant_id)=="yes"){
                    $payment_available[]='bcy';
                }
                if ( $this->getOption('merchant_enabled_epaybg',$merchant_id)=="yes"){
                    $payment_available[]='epy';
                }
                if ( $this->getOption('merchant_enabled_autho',$merchant_id)=="yes"){
                    $payment_available[]='atz';
                }
                if ( $this->getOption('merchant_bankdeposit_enabled',$merchant_id)=="yes"){
                    $payment_available[]='obd';
                }       
                /*if ( getOption($merchant_id,'merchant_mol_enabled')=="2"){
                    $payment_available[]='mol';
                }*/     
                if ($this->getOption('merchant_btr_enabled',$merchant_id)==2){
                    $payment_available[]='btr';
                }               
                if ($this->getOption('merchant_rzr_enabled',$merchant_id)==2){
                    $payment_available[]='rzr';
                }                                           
                if ($this->getOption('merchant_vog_enabled',$merchant_id)==2){
                    $payment_available[]='vog';
                }
                if ($this->getOption('merchant_ipay_enabled',$merchant_id)==2){
                    $payment_available[]='ipay';
                }
                if ($this->getOption('merchant_pipay_enabled',$merchant_id)==2){
                    $payment_available[]='pipay';
                }
                if ($this->getOption('merchant_hubtel_enabled',$merchant_id)==2){
                    $payment_available[]='hubtel';
                }               
                if ($this->getOption('merchant_jampie_enabled',$merchant_id)==2){                  
                    $payment_available[]='jampie';
                }
                if ($this->getOption('merchant_wing_enabled',$merchant_id)==2){                    
                    $payment_available[]='wing';
                }
                if ($this->getOption('merchant_paymill_enabled',$merchant_id)==2){                 
                    $payment_available[]='paymill';
                }
                if ($this->getOption('merchant_stripe_ideal_enabled',$merchant_id)==1){                    
                    $payment_available[]='strip_ideal';
                }
                if ($this->getOption('merchant_ipay_africa_enabled',$merchant_id)==1){                 
                    $payment_available[]='ipay_africa';
                }
                if ($this->getOption('merchant_dixipay_enabled',$merchant_id)==1){                 
                    $payment_available[]='dixipay';
                }
                if ($this->getOption('merchant_wirecard_enabled',$merchant_id)==1){                    
                    $payment_available[]='wirecard';
                }
                if ($this->getOption('merchant_payulatam_enabled',$merchant_id)==1){                   
                    $payment_available[]='payulatam';
                }
                if ($this->getOption('merchant_paystack_enabled',$merchant_id)==1){                    
                    $payment_available[]='paystack';
                }                               
                if ($this->getOption('merchant_moneris_enabled',$merchant_id)==2){
                   // $payment_available[]=Moneris::getPaymentCode();
                }
                if ($this->getOption('merchant_paypal_v2_enabled',$merchant_id)==1){
                    $payment_available[]='paypal_v2';
                } 



               $payment_available[]='windcave';


                if ($this->getOption('merchant_mercadopago_v2_enabled',$merchant_id)==1){                  
                    $payment_available[]='mercadopago';
                }
                
                /*custom code 3 start */
                if ($this->getOption('merchant_switch_master_sop',$merchant_id)!=1){                       
                    if($_SESSION['kr_delivery_options']['delivery_type']=='pickup' || $transaction_type=="pickup"){ 
                    $payment_available[]='sop'; 
                        
                    }else{unset($payment_available['sop']);}    
                }else{unset($payment_available['sop']);}    
                /*custom code 3 ends */ 
                /*custom code 2 start */    
                    if ($this->getOption('merchant_switch_master_poli',$merchant_id)!=1){                      
                        
                    if (($this->getOption('poli_enabled',$merchant_id)=='yes') && (!empty($this->getOption('merchant_poli_merchant_id',$merchant_id))) && (!empty($this->getOption('merchant_auth_poli_code',$merchant_id)))){       
                    $payment_available[]='poli';}   
                }
                /*custom code 2 ends */
                                
                $enabled_payment=$this->getMerchantListOfPaymentGateway();          
                //dump($enabled_payment);
                if(is_array($payment_available) && count($payment_available)>=1){
                    foreach ($payment_available as $pm_val) {
                        if(in_array($pm_val,(array)$enabled_payment)){
                           $master_key="merchant_switch_master_$pm_val";
                           $master_key_val=$this->getOption($master_key,$merchant_id);
                           if($master_key_val!=1){
                            
                              if(isset($payment_list[$pm_val])){
                                 $payment_available_final[$pm_val]=$payment_list[$pm_val];
                              }
                              
                              if ($pm_val=="pyr"){
                                 $provider_list=$this->getPaymentProviderMerchant($merchant_id);
                                 if (!is_array($provider_list) && count($provider_list)<=1){                
                                      unset($payment_available_final['pyr']);
                                 }                
                              }
                              
                           }                                                   
                        }
                    }
                }
                break;
        }
        
    /*custom code 4 start*/
    $amounts=0; 
        
    if($_GET['amount']>0){  
    $amounts= $_GET['amount'];  
    }   
    if($_SESSION['kmrs_subtotal']>0){$amounts=$_SESSION['kmrs_subtotal'];}  
         //if($_GET['debug']){  
             // $_SESSION['kmrs_subtotal']; 
             //print_r($_SESSION);      
            //print_r($payment_available_final);    
            // }    
                
              $stripe_limit_order=0;    
              $windcave_limit_order=0;          
                    $merch=$this->getMerchant($merchant_id);  



                    

                        $stripe_limit_order= $merch['stripe_limit_order'];  
                        $windcave_limit_order= $merch['windcave_limit_order'];  
                            
                    if($stripe_limit_order>0){  
                        if($amount>$stripe_limit_order){}else{ unset($payment_available_final['stp']);}    
                            }
                    if($windcave_limit_order>0){  
                        if($amount>$windcave_limit_order){}else{ unset($payment_available_final['windcave']);}    
                            }
    /*custom code 4 ends*/
        
        //dump($payment_available_final);
        return $payment_available_final;        
  }







public  function getMerchantPaymentListNew($merchant_id='')
    {
        /*custom code start*/
         $transaction_type = isset($_GET['transaction_type'])?$_GET['transaction_type']:''; 
         if($_GET['debug']){    
                
            /* $res=SingleAppClass::getCart($_GET['device_uiid']);    
        print_r($res);  
                
             echo $this->data['transaction_type'];  
                echo $_GET['transaction_type']; */
             }
        /*custom code ends*/
        
        $payment_available=array(); 
        $payment_available_final=array();
        $payment_list = $this->PaymentOptionList();
        $merchant_type=$this->getMerchantMembershipType($merchant_id);       
        //dump($merchant_type);
        switch ($merchant_type) {           
            case 2:                     
                /*COMMISSION*/  
                $payment_available=$this->getMerchantListOfPaymentGateway();                    
                //dump($payment_available);
                if(is_array($payment_available) && count($payment_available)>=1){
                   foreach ($payment_available as $payment_key) {                      
                       $master_key="merchant_switch_master_$payment_key";
                       $master_key_val=$this->getOption($master_key,$merchant_id);
                       if($master_key_val!=1){
                                                
                          if(isset($payment_list[$payment_key])){
                             $payment_available_final[$payment_key]=$payment_list[$payment_key];
                          } 
                          
                          /*custom code 3 start*/
                          if($_SESSION['kr_delivery_options']['delivery_type']=='pickup' || $transaction_type=="pickup"){   
                            
                          }else{unset($payment_available_final['sop']);}
                          /*custom code 3 ends*/
                          
                          if ($payment_key=="pyr"){
                              $provider_list=$this->getPaymentProviderMerchant($merchant_id);
                              $merchant_payondeliver_enabled=$this->getOption('merchant_payondeliver_enabled',$merchant_id);
                              if($merchant_payondeliver_enabled==""){
                                 $provider_list=array();                                 
                              }                           
                              if (!is_array($provider_list) && count((array)$provider_list)<=1){                
                                  unset($payment_available_final['pyr']);
                              }                   
                          }                                           
                          
                       }                                                   
                   }
                }       
                break;
        
            default:
                /*MEMBERSHIP IS DEFAULT*/           
                if ( $this->getOption('merchant_disabled_cod',$merchant_id)==""){
                    $payment_available[]='cod';
                }
                if ( $this->getOption('merchant_disabled_ccr',$merchant_id)==""){
                    $payment_available[]='ocr';
                }
                if ( $this->getOption('enabled_paypal',$merchant_id)=="yes"){
                    $payment_available[]='pyp';
                }
                if ( $this->getOption('stripe_enabled',$merchant_id)=="yes"){
                    $payment_available[]='stp';
                }
                if ( $this->getOption('merchant_mercado_enabled',$merchant_id)=="yes"){
                    $payment_available[]='mcd';
                }
                if ( $this->getOption('merchant_sisow_enabled',$merchant_id)=="yes"){
                    $payment_available[]='ide';
                }
                if ( $this->getOption('merchant_payu_enabled',$merchant_id)=="yes"){
                    $payment_available[]='payu';
                }
                if ( $this->getOption('merchant_paysera_enabled',$merchant_id)=="yes"){
                    $payment_available[]='pys';
                }
                if ( $this->getOption('merchant_payondeliver_enabled',$merchant_id)=="yes"){
                    $payment_available[]='pyr';
                }
                if ( $this->getOption('merchant_enabled_barclay',$merchant_id)=="yes"){
                    $payment_available[]='bcy';
                }
                if ( $this->getOption('merchant_enabled_epaybg',$merchant_id)=="yes"){
                    $payment_available[]='epy';
                }
                if ( $this->getOption('merchant_enabled_autho',$merchant_id)=="yes"){
                    $payment_available[]='atz';
                }
                if ( $this->getOption('merchant_bankdeposit_enabled',$merchant_id)=="yes"){
                    $payment_available[]='obd';
                }       
                /*if ( getOption($merchant_id,'merchant_mol_enabled')=="2"){
                    $payment_available[]='mol';
                }*/     
                if ($this->getOption('merchant_btr_enabled',$merchant_id)==2){
                    $payment_available[]='btr';
                }               
                if ($this->getOption('merchant_rzr_enabled',$merchant_id)==2){
                    $payment_available[]='rzr';
                }                                           
                if ($this->getOption('merchant_vog_enabled',$merchant_id)==2){
                    $payment_available[]='vog';
                }
                if ($this->getOption('merchant_ipay_enabled',$merchant_id)==2){
                    $payment_available[]='ipay';
                }
                if ($this->getOption('merchant_pipay_enabled',$merchant_id)==2){
                    $payment_available[]='pipay';
                }
                if ($this->getOption('merchant_hubtel_enabled',$merchant_id)==2){
                    $payment_available[]='hubtel';
                }               
                if ($this->getOption('merchant_jampie_enabled',$merchant_id)==2){                  
                    $payment_available[]='jampie';
                }
                if ($this->getOption('merchant_wing_enabled',$merchant_id)==2){                    
                    $payment_available[]='wing';
                }
                if ($this->getOption('merchant_paymill_enabled',$merchant_id)==2){                 
                    $payment_available[]='paymill';
                }
                if ($this->getOption('merchant_stripe_ideal_enabled',$merchant_id)==1){                    
                    $payment_available[]='strip_ideal';
                }
                if ($this->getOption('merchant_ipay_africa_enabled',$merchant_id)==1){                 
                    $payment_available[]='ipay_africa';
                }
                if ($this->getOption('merchant_dixipay_enabled',$merchant_id)==1){                 
                    $payment_available[]='dixipay';
                }
                if ($this->getOption('merchant_wirecard_enabled',$merchant_id)==1){                    
                    $payment_available[]='wirecard';
                }
                if ($this->getOption('merchant_payulatam_enabled',$merchant_id)==1){                   
                    $payment_available[]='payulatam';
                }
                if ($this->getOption('merchant_paystack_enabled',$merchant_id)==1){                    
                    $payment_available[]='paystack';
                }                               
                if ($this->getOption('merchant_moneris_enabled',$merchant_id)==2){
                   // $payment_available[]=Moneris::getPaymentCode();
                }
                if ($this->getOption('merchant_paypal_v2_enabled',$merchant_id)==1){
                    $payment_available[]='paypal_v2';
                } 



               $payment_available[]='windcave';


                if ($this->getOption('merchant_mercadopago_v2_enabled',$merchant_id)==1){                  
                    $payment_available[]='mercadopago';
                }
                
                /*custom code 3 start */
                if ($this->getOption('merchant_switch_master_sop',$merchant_id)!=1){                       
                    if($_SESSION['kr_delivery_options']['delivery_type']=='pickup' || $transaction_type=="pickup"){ 
                    $payment_available[]='sop'; 
                        
                    }else{unset($payment_available['sop']);}    
                }else{unset($payment_available['sop']);}    
                /*custom code 3 ends */ 
                /*custom code 2 start */    
                    if ($this->getOption('merchant_switch_master_poli',$merchant_id)!=1){                      
                        
                    if (($this->getOption('poli_enabled',$merchant_id)=='yes') && (!empty($this->getOption('merchant_poli_merchant_id',$merchant_id))) && (!empty($this->getOption('merchant_auth_poli_code',$merchant_id)))){       
                    $payment_available[]='poli';}   
                }
                /*custom code 2 ends */
                                
                $enabled_payment=$this->getMerchantListOfPaymentGateway();          
                //dump($enabled_payment);
                if(is_array($payment_available) && count($payment_available)>=1){
                    foreach ($payment_available as $pm_val) {
                        if(in_array($pm_val,(array)$enabled_payment)){
                           $master_key="merchant_switch_master_$pm_val";
                           $master_key_val=$this->getOption($master_key,$merchant_id);
                           if($master_key_val!=1){
                            
                              if(isset($payment_list[$pm_val])){
                                 $payment_available_final[$pm_val]=$payment_list[$pm_val];
                              }
                              
                              if ($pm_val=="pyr"){
                                 $provider_list=$this->getPaymentProviderMerchant($merchant_id);
                                 if (!is_array($provider_list) && count($provider_list)<=1){                
                                      unset($payment_available_final['pyr']);
                                 }                
                              }
                              
                           }                                                   
                        }
                    }
                }
                break;
        }
        
    /*custom code 4 start*/
    $amounts=0; 
        
    if($_GET['amount']>0){  
    $amounts= $_GET['amount'];  
    }   
    if($_SESSION['kmrs_subtotal']>0){$amounts=$_SESSION['kmrs_subtotal'];}  
         //if($_GET['debug']){  
             // $_SESSION['kmrs_subtotal']; 
             //print_r($_SESSION);      
            //print_r($payment_available_final);    
            // }    
                
              $stripe_limit_order=0;
              $windcave_limit_order=0;    
                        
                    $merch=$this->getMerchant($merchant_id);  



                    

                        $stripe_limit_order= $merch['stripe_limit_order']; 
                        $windcave_limit_order= $merch['windcave_limit_order']; 
                            
                    if($stripe_limit_order>0){  
                        if($amounts>$stripe_limit_order){}else{ unset($payment_available_final['stp']);}    
                            }
                    if($windcave_limit_order>0){  
                        if($amounts>$windcave_limit_order){}else{ unset($payment_available_final['windcave']);}    
                            }



    /*custom code 4 ends*/
        
        //dump($payment_available_final);
        return $payment_available_final;        
    }


    public  function isMerchantPaymentToUseAdmin($merchant_id='')
    {
        if ($merchant_type=$this->getMerchantMembershipType($merchant_id)){          
            if ($merchant_type==2){
                return true;
            }
        }
        return false;
    }


     public function paymentCode($type='',$is_reverse=false)
    {       
        $code= array(
          'paypal'=>"pyp",
          'creditcard'=>"ocr",
          'stripe'=>"stp",
          'mercadopago'=>"mcd",
          "payline"=>"pyl",
          'sisow'=>"ide",
          'payumoney'=>"payu",
          'paysera'=>'pys',
          'bankdeposit'=>'obd',
          'payondeliver'=>"pyr",
          'barclay'=>"bcy",
          "epaybg"=>"epy",
          "authorize"=>"atz"
        );
        if ($is_reverse){
            $code=array_flip($code);
        }           
        if (array_key_exists($type,$code)){
            return $code[$type];
        }
        return '';
    } 


    public function getPackageSMSTransByMerchant($package_id = '', $merchant_id = '')
{
    try {
        $stmt = $this->db->prepare("
            SELECT 
                a.*,
                (
                    SELECT title
                    FROM mt_sms_package
                    WHERE sms_package_id = a.sms_package_id
                ) as title
            FROM 
                mt_sms_package_trans a
            WHERE 
                id = :package_id
                AND merchant_id = :merchant_id
            LIMIT 0,1
        ");

        // Bind the parameters to prevent SQL injection
        $stmt->bindParam(':package_id', $package_id, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        return $result ?: false;
    } catch (PDOException $e) {
        // Log or handle the exception as needed
        error_log("Error in getPackageSMSTransByMerchant: " . $e->getMessage());
        return false;
    }
}


public function get_paypal_payment_status($paypal_order_id, $merchant_id)
{
    if ($credentials = $this->getCredentials_paypal($merchant_id)) {
        $clientId = $credentials['client_id'];
        $clientSecret = $credentials['secret_key'];

        $baseUrl = $credentials['mode'] == 'live'
            ? 'https://api-m.paypal.com'
            : 'https://api-m.sandbox.paypal.com';

        // Step 1: Get access token
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$baseUrl/v1/oauth2/token");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERPWD, "$clientId:$clientSecret");
        curl_setopt($ch, CURLOPT_POSTFIELDS, "grant_type=client_credentials");
        curl_setopt($ch, CURLOPT_POST, true);

        $response = curl_exec($ch);
        curl_close($ch);
        if (!$response) {
            return ['error' => 'Unable to fetch access token'];
        }

        $accessToken = json_decode($response)->access_token ?? '';
        if (empty($accessToken)) {
            return ['error' => 'No access token received'];
        }

        // Step 2: Get order status
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "$baseUrl/v2/checkout/orders/$paypal_order_id");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Authorization: Bearer $accessToken"
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

        $orderStatus = json_decode($response, true);

        if (isset($orderStatus['status'])) {
            return $orderStatus;
        }

        return ['error' => 'Failed to fetch order status'];
    }

    return ['error' => 'Invalid PayPal credentials'];
}







    public  function getOfflinePaymentList()
    {
        /*
        Important: you can change the value but not the key
        like cod ocr pyr etc 
        */
        
        return array(
           'cod'=>$this->translation("default","Cash On delivery"),
           
           /*custom code 2 start */
           'poli'=>$this->translation("default","Poli"),
           /*custom code 2 ends*/
           
           'ocr'=>$this->translation("default","Offline Credit Card Payment"),
           'obd'=>$this->translation("default","Offline Bank Deposit") ,
           'pyr'=>$this->translation("default","Pay On Delivery"),       
        );
    }


    public  function getCredentials_paypal($merchant_id='')
    {
                        
        if($merchant_id<0 || empty($merchant_id)){
            return false;
        }
        
        $enabled = false; $mode=''; 
        $client_id = ''; 
        $secret_key='';     
        
        if ($this->isMerchantPaymentToUseAdmin($merchant_id)){            
            
            $enabled = $this->getOptionAdmin('admin_paypal_v2_enabled');
            $mode = $this->getOptionAdmin('admin_paypal_v2_mode');     
            $card_fee = $this->getOptionAdmin('admin_paypal_v2_card_fee');             
            
            $client_id = $this->getOptionAdmin('admin_paypal_v2_client_id');
            $secret_key = $this->getOptionAdmin('admin_paypal_v2_secret');
                
        } else {    
                        
            $enabled = $this->getOption('merchant_paypal_v2_enabled',$merchant_id);
            $mode = $this->getOption('merchant_paypal_v2_mode',$merchant_id);      
            $card_fee = $this->getOption('merchant_paypal_v2_card_fee',$merchant_id);
            
            $client_id = $this->getOption('merchant_paypal_v2_client_id',$merchant_id);
            $secret_key = $this->getOption('merchant_paypal_v2_secret',$merchant_id);      
            
        }       
        
        if($enabled==1 && !empty($client_id) && !empty($secret_key) ){
            return array(
              'mode'=>$mode,
              'card_fee'=>$card_fee,
              'client_id'=>trim($client_id),
              'secret_key'=>trim($secret_key)
            );
        }
        return false;
    }



    public  function getCredentials_windcave($merchant_id='')
    {
                        
        if($merchant_id<0 || empty($merchant_id)){
            return false;
        }
        
          
        
        if ($this->isMerchantPaymentToUseAdmin($merchant_id)){            
            
             
            $card_fee = $this->getOptionAdmin('admin_windcave_card_fee');             
            
            
                
        } else {    
                        
               
            $card_fee = $this->getOption('merchant_windcave_card_fee',$merchant_id);
            
                  
            
        }       
        
        
            return array(
              
              'card_fee'=>$card_fee
              
            );
        
       
    }








      public  function getCredentials_paypal_purchasesms($merchant_id='')
    {
                        
        if($merchant_id<0 || empty($merchant_id)){
            return false;
        }
        
        $enabled = false; $mode=''; 
        $client_id = ''; 
        $secret_key='';     
        
        if (1==1){            
            
            $enabled = $this->getOptionAdmin('admin_paypal_v2_enabled');
            $mode = $this->getOptionAdmin('admin_paypal_v2_mode');     
            $card_fee = $this->getOptionAdmin('admin_paypal_v2_card_fee');             
            
            $client_id = $this->getOptionAdmin('admin_paypal_v2_client_id');
            $secret_key = $this->getOptionAdmin('admin_paypal_v2_secret');
                
        } else {    
                        
            $enabled = $this->getOption('merchant_paypal_v2_enabled',$merchant_id);
            $mode = $this->getOption('merchant_paypal_v2_mode',$merchant_id);      
            $card_fee = $this->getOption('merchant_paypal_v2_card_fee',$merchant_id);
            
            $client_id = $this->getOption('merchant_paypal_v2_client_id',$merchant_id);
            $secret_key = $this->getOption('merchant_paypal_v2_secret',$merchant_id);      
            
        }       
        
        if($enabled==1 && !empty($client_id) && !empty($secret_key) ){
            return array(
              'mode'=>$mode,
              'card_fee'=>$card_fee,
              'client_id'=>trim($client_id),
              'secret_key'=>trim($secret_key)
            );
        }
        return false;
    }





    public function getAdminCredentials_paypalv2()
  {
    $enabled = false; $mode=''; 
    $client_id = ''; 
    $secret_key='';   
    
    $enabled = $this->getOptionAdmin('admin_paypal_v2_enabled');
    $mode = $this->getOptionAdmin('admin_paypal_v2_mode');    
    $card_fee = $this->getOptionAdmin('admin_paypal_v2_card_fee');        
    
    $client_id = $this->getOptionAdmin('admin_paypal_v2_client_id');
    $secret_key = $this->getOptionAdmin('admin_paypal_v2_secret');
                    
    if($enabled==1 && !empty($client_id) && !empty($secret_key) ){
      return array(
        'mode'=>$mode,
        'card_fee'=>$card_fee,
        'client_id'=>trim($client_id),
        'secret_key'=>trim($secret_key)
      );
    }
    return false;
  }



    public  function createSession_stp($secret='',$params=array())
  { 

    $stpPath = __DIR__ . '/../../vendor/stripe/init.php';
        if (file_exists($stpPath)) {
        require_once($stpPath);
        }

    
    try {
      \Stripe\Stripe::setApiKey("$secret");   
      $resp = \Stripe\Checkout\Session::create($params);    
      return array(
       'id'=>$resp->id,      
       'payment_intent'=>$resp->payment_intent
      );
    } catch (Exception $e) {
      throw new Exception( $e->getMessage() );
    }       
  }



        public  function getCredentials_stripe($merchant_id='')
    {
                        
        if($merchant_id<0 || empty($merchant_id)){
            return false;
        }
        
        $enabled = false; $mode=''; 
        $secret_key = ''; $publish_key='';
        $webhook_secret='';
        
        if ($this->isMerchantPaymentToUseAdmin($merchant_id)){


            
            $enabled = $this->getOptionAdmin('admin_stripe_enabled');
            $mode = $this->getOptionAdmin('admin_stripe_mode');        
            $card_fee = $this->getOptionAdmin('admin_stripe_card_fee');        
            
            $mode= strtolower($mode);


            switch ($mode){
                case "live":
                    $secret_key = $this->getOptionAdmin('admin_live_stripe_secret_key');
                    $publish_key = $this->getOptionAdmin('admin_live_stripe_pub_key');
                    $webhook_secret = $this->getOptionAdmin('admin_live_stripe_webhooks');
                    break;
                    
                case "sandbox":
                    $secret_key = $this->getOptionAdmin('admin_sandbox_stripe_secret_key');

                   
                    
                    
                    
                    $publish_key = $this->getOptionAdmin('admin_sandbox_stripe_pub_key');



                    $webhook_secret = $this->getOptionAdmin('admin_sandbox_stripe_webhooks');
                    break;  
            }       
                
        } else {    
                        
            $enabled = $this->getOption('stripe_enabled',$merchant_id);
            $mode = $this->getOption('stripe_mode',$merchant_id);      
            $card_fee = $this->getOption('merchant_stripe_card_fee',$merchant_id);     

            $mode= strtolower($mode);
            switch ($mode){
                case "live":
                    $secret_key = $this->getOption('live_stripe_secret_key',$merchant_id);
                    $publish_key = $this->getOption('live_stripe_pub_key',$merchant_id);
                    $webhook_secret =$this->getOption('merchant_live_stripe_webhooks',$merchant_id);
                    break;
                    
                case "sandbox":
                    $secret_key = $this->getOption('sanbox_stripe_secret_key',$merchant_id);
                    $publish_key = $this->getOption('sandbox_stripe_pub_key',$merchant_id);
                    $webhook_secret = $this->getOption('merchant_sandbox_stripe_webhooks',$merchant_id);
                    break;  
            }               
        }       
        
        if($enabled=="yes" && !empty($secret_key) && !empty($publish_key) ){        
            return array(
              'mode'=>$mode,
              'card_fee'=>$card_fee,
              'secret_key'=>$secret_key,
              'publish_key'=>$publish_key,
              'webhook_secret'=>$webhook_secret
            );
        }
        return false;
    }



      public  function getCredentials_stripe_purchase_sms($merchant_id='')
    {
                        
        if($merchant_id<0 || empty($merchant_id)){
            return false;
        }
        
        $enabled = false; $mode=''; 
        $secret_key = ''; $publish_key='';
        $webhook_secret='';
        
        if (1==1){


            
            $enabled = $this->getOptionAdmin('admin_stripe_enabled');
            $mode = $this->getOptionAdmin('admin_stripe_mode');        
            $card_fee = $this->getOptionAdmin('admin_stripe_card_fee');        
            
            $mode= strtolower($mode);


            switch ($mode){
                case "live":
                    $secret_key = $this->getOptionAdmin('admin_live_stripe_secret_key');
                    $publish_key = $this->getOptionAdmin('admin_live_stripe_pub_key');
                    $webhook_secret = $this->getOptionAdmin('admin_live_stripe_webhooks');
                    break;
                    
                case "sandbox":
                    $secret_key = $this->getOptionAdmin('admin_sandbox_stripe_secret_key');

                   
                    
                    
                    
                    $publish_key = $this->getOptionAdmin('admin_sandbox_stripe_pub_key');



                    $webhook_secret = $this->getOptionAdmin('admin_sandbox_stripe_webhooks');
                    break;  
            }       
                
        } else {    
                        
            $enabled = $this->getOption('stripe_enabled',$merchant_id);
            $mode = $this->getOption('stripe_mode',$merchant_id);      
            $card_fee = $this->getOption('merchant_stripe_card_fee',$merchant_id);     

            $mode= strtolower($mode);
            switch ($mode){
                case "live":
                    $secret_key = $this->getOption('live_stripe_secret_key',$merchant_id);
                    $publish_key = $this->getOption('live_stripe_pub_key',$merchant_id);
                    $webhook_secret =$this->getOption('merchant_live_stripe_webhooks',$merchant_id);
                    break;
                    
                case "sandbox":
                    $secret_key = $this->getOption('sanbox_stripe_secret_key',$merchant_id);
                    $publish_key = $this->getOption('sandbox_stripe_pub_key',$merchant_id);
                    $webhook_secret = $this->getOption('merchant_sandbox_stripe_webhooks',$merchant_id);
                    break;  
            }               
        }       
        
        if($enabled=="yes" && !empty($secret_key) && !empty($publish_key) ){        
            return array(
              'mode'=>$mode,
              'card_fee'=>$card_fee,
              'secret_key'=>$secret_key,
              'publish_key'=>$publish_key,
              'webhook_secret'=>$webhook_secret
            );
        }
        return false;
    }







    public function sms_payment_successthings_poli($transaction_id,$id,$type,$merchant_id){

                        $info=$this->getSMSPackagesById($id);
                         $price=$info['price'];
            if ( $info['promo_price']>0){
              $price=$info['promo_price'];
            }  

                        
                        $payment_code="poli";
                        $params=array(
                          'merchant_id'=>$merchant_id,
                          'sms_package_id'=>$id,
                          'payment_type'=>$payment_code,
                          'package_price'=>$price,
                          'sms_limit'=>$info['sms_limit'],
                          'date_created'=>$this->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR'],
                          'payment_gateway_response'=>$transaction_id,
                          'status'=>"paid"
                        );   
                         $last_insert_id = $this->insertData('mt_sms_package_trans', $params);



                         return $last_insert_id;



    }


      public function sms_payment_successthings_windcave($transaction_id,$id,$type,$merchant_id){

                        $info=$this->getSMSPackagesById($id);
                         $price=$info['price'];
            if ( $info['promo_price']>0){
              $price=$info['promo_price'];
            }  

                        
                        $payment_code="wdc";
                        $params=array(
                          'merchant_id'=>$merchant_id,
                          'sms_package_id'=>$id,
                          'payment_type'=>$payment_code,
                          'package_price'=>$price,
                          'sms_limit'=>$info['sms_limit'],
                          'date_created'=>$this->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR'],
                          'payment_gateway_response'=>$transaction_id,
                          'status'=>"paid"
                        );   
                         $last_insert_id = $this->insertData('mt_sms_package_trans', $params);



                         return $last_insert_id;



    }



    public function sms_payment_successthings_stripe($transaction_id,$id,$type,$merchant_id){

                        $info=$this->getSMSPackagesById($id);
                         $price=$info['price'];
            if ( $info['promo_price']>0){
              $price=$info['promo_price'];
            }  

             $stpdata=$this->getCredentials_stripe($merchant_id);
             $card_fee =0;
         if($stpdata['card_fee']>0.0001){
         $card_fee = $price*$stpdata['card_fee']/100;
         }
         
         $price=$price+$card_fee;

                        
                        $payment_code="stp";
                        $params=array(
                          'merchant_id'=>$merchant_id,
                          'sms_package_id'=>$id,
                          'payment_type'=>$payment_code,
                          'package_price'=>$price,
                          'sms_limit'=>$info['sms_limit'],
                          'date_created'=>$this->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR'],
                          'payment_gateway_response'=>json_encode($transaction_id),
                          'status'=>"paid"
                        );   
                         $last_insert_id = $this->insertData('mt_sms_package_trans', $params);



                         return $last_insert_id;



    }



      public function sms_payment_successthings_paypalv2($transaction_id,$id,$type,$merchant_id){

                        $info=$this->getSMSPackagesById($id);
                         $price=$info['price'];
            if ( $info['promo_price']>0){
              $price=$info['promo_price'];
            }  

             $credentials = $this->getCredentials_paypal($merchant_id);
      $card_fee=0;
      if($credentials['card_fee']>0){
      $card_fee=$credentials['card_fee'];
      }
         
         $price=$price+$card_fee;

                        
                        $payment_code="paypal_v2";
                        $params=array(
                          'merchant_id'=>$merchant_id,
                          'sms_package_id'=>$id,
                          'payment_type'=>$payment_code,
                          'package_price'=>$price,
                          'sms_limit'=>$info['sms_limit'],
                          'date_created'=>$this->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR'],
                          'payment_gateway_response'=>json_encode($transaction_id),
                          'status'=>"paid"
                        );   
                         $last_insert_id = $this->insertData('mt_sms_package_trans', $params);



                         return $last_insert_id;



    }







    public function getMerchantPaymentTransaction($merchant_id = '')
{
    // Prepare the SQL statement
    $stmt = "
        SELECT a.*,
        (
            SELECT title
            FROM mt_packages
            WHERE package_id = a.package_id
        ) AS package_name
        FROM mt_package_trans a
        WHERE merchant_id = :merchant_id
        ORDER BY id DESC
    ";

    // Execute the query using the existing PDO instance
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id);
    $query->execute();

    // Fetch and return the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    return $res ? $res : false;
}


public function prettyPrice($amount='')
  {   
    return $this->displayPrice($this->getCurrencyCode(),$this->prettyFormat( (float) $amount));    
  } 



     public function displayPrice($currency='',$amount='')
    {       
        $spacer="";
        $spacer_enabled=$this->getOptionAdmin("admin_add_space_between_price");
        if($spacer_enabled==1){
            $spacer=" ";
        }
        $pos=$this->getOptionAdmin('admin_currency_position');      
        if ( $pos=="right"){
            return $amount.$spacer.$currency;
        } else {            
            return $amount;
        }
    }

    public function adminCurrencySymbol()
{
    $curr_code = $this->getOptionAdmin("admin_currency_set");
    if (empty($curr_code)) {
        $curr_code = "USD";
    }

    // Prepare the SQL statement with placeholders
    $stmt = $this->db->prepare("
        SELECT * 
        FROM mt_currency 
        WHERE currency_code = :currency_code 
        LIMIT 1
    ");
    
    // Bind the value to the placeholder
    $stmt->bindValue(':currency_code', $curr_code, PDO::PARAM_STR);
    $stmt->execute();
    
    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Return the currency symbol or default value
    return $res ? $res['currency_symbol'] : "$";
}

public function normalPrettyPrice($price='')
    {
        if (is_numeric($price)){
            return number_format($price,2,'.','');
        }
        return false;        
    }

        public  function sendInvoiceNotification($merchant_id='', $data='', $pdf_filename='')
    {
        $lang="en";
        $sender=$this->getOptionAdmin('global_admin_sender_email');
                        
        $merchant_email= $this->getOption('merchant_invoice_email',$merchant_id);
        $is_enabled=$this->getOptionAdmin("merchant_invoice_email");




        if ($is_enabled==true && !empty($merchant_email)){
            $tpl=$this->getOptionAdmin("merchant_invoice_tpl_content_$lang");
            $subject=$this->getOptionAdmin("merchant_invoice_tpl_subject_$lang");
            
           
            $data['invoice_terms']=$this->prettyInvoiceTerms($data['invoice_terms']);
            

            $data['period']=$this->prettyDate($data['date_from']).' to '.$this->prettyDate($data['date_to']);

            
            $data['invoice_link']=$this->websiteUrl()."/upload/invoice/".$pdf_filename;
            
            $pattern=array(
              'restaurant_name'=>'merchant_name',
              'invoice_number'=>'invoice_number',
              'terms'=>'invoice_terms',
              'period'=>'period',
              'invoice_link'=>'invoice_link',
              'sitename'=>$this->getOptionAdmin('website_title'),
              'siteurl'=>$this->websiteUrl(),                  
            );
            $tpl=$this->replaceTemplateTags($tpl,$pattern,$data);
            $subject=$this->replaceTemplateTags($subject,$pattern,$data);
            
           
            $params=array(
               'email_address'=>$merchant_email,
               'sender'=>$sender,
               'subject'=>$subject,
               'content'=>$tpl,
               'date_created'=>$this->dateNow(),
               'ip_address'=>$_SERVER['REMOTE_ADDR'],
               'module_type'=>'core'
            );          
            $this->insertData("mt_email_logs",$params);         
            
            
        }           
    }


   public function getCountryByShortCode($short_code = '')
{
    // Escape and quote the shortcode manually
    $short_code = addslashes($short_code);

    $stmt = "
        SELECT country_id, shortcode, country_name
        FROM mt_location_countries
        WHERE shortcode = '$short_code'
        LIMIT 0,1
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            return $res[0];
        }

    } catch (PDOException $e) {
        // Optional: handle/log error
        // echo "Database Error: " . $e->getMessage();
    }

    return false;
}
 



   public function getTotalCommission()
{
    // Get total commission status from admin options
    $total_commission_status = $this->getOptionAdmin('total_commission_status');
    if (!empty($total_commission_status)) {
        $total_commission_status = json_decode($total_commission_status);
    } else {
        $total_commission_status = array('paid');
    }

    // Prepare the placeholders and bind the values
    $placeholders = [];
    foreach ($total_commission_status as $index => $val) {
        $placeholders[] = ":status_$index";
    }
    $status = implode(',', $placeholders);

    // Prepare the SQL statement
    $and = '';
    if ($this->getOptionAdmin('admin_exclude_cod_balance') == 2) {
        $and = " AND payment_type NOT IN ('cod','pyr','ccr')";
    }

    $stmt = $this->db->prepare("
        SELECT SUM(total_commission) AS total_commission
        FROM mt_order
        WHERE request_from <> 'POS' AND status IN ($status)
        $and
    ");

    // Bind the status values
    foreach ($total_commission_status as $index => $val) {
        $stmt->bindValue(":status_$index", $val, PDO::PARAM_STR);
    }

    // Execute the statement
    $stmt->execute();
    
    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the total commission or default value
    if ($res) {
        return $res['total_commission'] ?: 0;
    }

    return false;
}

public  function generateHours()
    {
        $list=array();
        for ($i = 0; $i <= 12; $i++) {
            $ii = str_pad($i,2,"0",STR_PAD_LEFT);
            $list[$i]=$ii;
        }
        return $list;
    }
    
    public  function generateMinutes()
    {
        $list=array();
        for ($i = 0; $i <= 60; $i++) {
            $ii = str_pad($i,2,"0",STR_PAD_LEFT);
            $list[$i]=$ii;
        }
        return $list;
    }

public function locationCountryList()
{
    // Use $this->db to get the PDO instance
    $db = $this->db;
    
    // Prepare the SQL statement
    $stmt = "
        SELECT * 
        FROM mt_location_countries
        ORDER BY country_name ASC
    ";
    
    // Prepare and execute the query
    $query = $db->prepare($stmt);
    $query->execute();
    
    // Fetch all results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);
    
    // Return results
    return $res ?: false;
}


public  function countrysList()
   {
       if ($res=$this->locationCountryList()){
           $data=array();
           foreach ($res as $val) {
               $data[$val['country_id']]=$this->cleanString($val['country_name']);
           }
           return $data;
       }
       return false;
   }

   public  function cleanString($string='')
    {
        $string = str_replace(' ', '-', $string); // Replaces all spaces with hyphens.
        return preg_replace('/[^A-Za-z0-9\-]/', '', $string); // Removes special chars.
    }


public function zipcodeSearchType()
    {
        /*return array(
          1=>t("Search by post code"),
          2=>t("Search by Area/City"),
          3=>t("Search by address"),
        );*/
        return array(
          1=>("City / Area"),
          2=>("State / City"),
          3=>("PostalCode/ZipCode"),
          //4=>t("State / City / Area"),          
        );
    }

      public function GetFeeByRateIDView($rate_id = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_view_location_rate
        WHERE rate_id = :rate_id
        LIMIT 1
    ");
    $stmt->bindParam(':rate_id', $rate_id, PDO::PARAM_INT);
    $stmt->execute();
    
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }
    
    return false;
}





      public  function canCancelOrderNew($request_cancel='',$date_created='',
    $order_status='',$order_locked='', $request_cancel_status='pending', $cancel_order_enabled='')
    {
                
        if($request_cancel==1){
           return true; 
        }
        
        if($request_cancel_status!='pending'){
            return false;
        }   
                            
        if($cancel_order_enabled==1){
            $check_0 = true;
        } else $check_0 = false;
        
        $check_1 = $this->cancelOrderCheckDayTime($date_created);     
        $check_2 = $this->cancelOrderCheckStatus($order_status);
        if($check_0==TRUE && $check_1==TRUE && $check_2==TRUE){
            return true;
        }
        return false;
    }


    public  function canCancel($date_created='', $days=0, $hours=0, $minutes=0)
  {
    if(!empty($date_created)){
        $date_created = date("Y-m-d g:i:s a",strtotime($date_created));     
      $date_now=date('Y-m-d g:i:s a');      
      $time_diff=$this->dateDifference($date_created,$date_now);      
      if(is_array($time_diff) && count($time_diff)>=1){       
        if($days>$time_diff['days']){         
          return true;
        } elseif ( $hours>$time_diff['hours'] ) {
          return true;          
        } elseif ( $hours>=$time_diff['hours']){          
          if($minutes<$time_diff['minutes']){           
            return false;
          } else return true;
        } elseif ( $minutes>=$time_diff['minutes'] ){         
          return true;          
        }
                
      } else return true;
    }
        return true;
    
  }


   public function getBookingHistory($booking_id = '')
{
    try {
        // Prepare the SQL statement
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_bookingtable_history 
            WHERE booking_id = :booking_id 
            ORDER BY id DESC
        ");

        // Bind the booking_id parameter
        $stmt->bindParam(':booking_id', $booking_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch all results
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Return the results if found, otherwise return false
        return $res ? $res : false;

    } catch (PDOException $e) {
        // Handle any errors
        error_log("Error in getBookingHistory: " . $e->getMessage());
        return false;
    }
}


public function getCustomerFavoritesList($client_id = '')
{
    // Check if the 'favorites' table exists
    if (!$this->checkIfTableExist('favorites')) {
        return false;
    }

    try {
        // Prepare the SQL query
        $stmt = $this->db->prepare("
            SELECT 
                a.id,
                a.merchant_id,
                a.date_created,
                b.restaurant_name,
                b.restaurant_slug
            FROM mt_favorites a
            LEFT JOIN mt_merchant b
                ON a.merchant_id = b.merchant_id
            WHERE a.client_id = :client_id
            ORDER BY a.id DESC
        ");

        // Bind the client_id parameter
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch all results
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Return results if found, otherwise return false
        return $res ? $res : false;

    } catch (PDOException $e) {
        // Log the error
        error_log("Error in getCustomerFavoritesList: " . $e->getMessage());
        return false;
    }
}


public function removeFavorites($client_id = '', $id = '')
{
    if ($client_id > 0 && $id > 0) {
        try {
            // Prepare the SQL statement
            $stmt = $this->db->prepare("DELETE FROM mt_favorites WHERE client_id = :client_id AND id = :id");

            // Bind parameters
            $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);

            // Execute the statement
            $stmt->execute();

            // Check if rows were affected
            if ($stmt->rowCount() > 0) {
                return true;
            }
        } catch (PDOException $e) {
            // Log the error
            error_log("Error in removeFavorites: " . $e->getMessage());
        }
    }

    return false;
}








    public  function cancelOrderCheckStatus($order_status='',$order_locked='')
    {
        if($order_locked==2){
            return false;
        }   
        $status = $this->getOptionAdmin('cancel_order_status_accepted');
        if(!empty($status)){                    
            $status = json_decode($status,true);            
            if(in_array($order_status,(array)$status)){
                return true;
            }
        }
        return false;   
    }


     public  function prettyPaymentTypeTrans($transaction_type='', $payment_code='')
    {       
        $payment_list=$this->PaymentOptionList();
        if (array_key_exists($payment_code,(array)$payment_list)){
            switch ($transaction_type) {
                case "dinein":
                    if ( $payment_code=="cod"){
                        return $this->translation("default","Pay in person");
                    } else return $payment_list[$payment_code];
                    break;
            
                case "pickup":
                    if($payment_code=="cod"){
                       return $this->translation("default","Cash On Pickup");
                    } else return $payment_list[$payment_code];
                    break;  
                    
                default:
                    return $payment_list[$payment_code];
                    break;
            }
        }
        return $payment_code;
    }


    public function canReviewOrder($order_status='')
    {   
        $website_review_type = $this->getOptionAdmin('website_review_type');
        if($website_review_type==2){
            $review_baseon_status = $this->getOptionAdmin('review_baseon_status');         
            if(!empty($review_baseon_status)){
               $review_baseon_status = json_decode($review_baseon_status,true);
               if (is_array($review_baseon_status) && count($review_baseon_status)>=1){
                  if (in_array($order_status,$review_baseon_status)){
                      return true;
                  }
               }
            } else return true;
        }
        return false;
    }


  public function istableExist_new_by_user_id($email_address = '', $mid = '')
{
    $stmt = "
    SELECT * FROM mt_table
    WHERE name = '$email_address'
    AND m_user_id = '$mid'
    LIMIT 0,1
    ";

    $cmd = $this->db->prepare($stmt);
    if ($cmd->execute()) {
        $res = $cmd->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            return $res[0];
        }
    }

    return false;
}





    public  function cancelOrderCheckDayTime($date_created='')
    {
        $cancel_order_days_applied = $this->getOptionAdmin('cancel_order_days_applied');
        
        $cancel_order_hours =  $this->getOptionAdmin('cancel_order_hours');
        if(!is_numeric($cancel_order_hours)){
            $cancel_order_hours=0;
        }
        
        $cancel_order_minutes =  $this->getOptionAdmin('cancel_order_minutes');
        if(!is_numeric($cancel_order_minutes)){
            $cancel_order_minutes=0;
        }
        
        if($cancel_order_days_applied>0 || $cancel_order_hours>0 || $cancel_order_minutes>0){           
            $date_now=date('Y-m-d g:i:s a');
            $date_created = date('Y-m-d g:i:s a',strtotime($date_created));
            $time_diff=$this->dateDifference($date_created,$date_now);                      
            //dump($time_diff);
            if(is_array($time_diff) && count($time_diff)>=1){       
                
                if($cancel_order_days_applied>0){
                    if($time_diff['days']>=$cancel_order_days_applied){                     
                        return false;
                    }                   
                }   
                
                $time_1 = $time_diff['hours'].$time_diff['minutes'];                
                $time_2 = $cancel_order_hours.$cancel_order_minutes;                
                
                if($time_diff['days']>=$cancel_order_days_applied){
                    if($time_1>$time_2){                        
                        return false;
                    }           
                }
                
            }
        } else return false;
            
        return true;
    }


     public function getMerchantWithdrawal($merchant_id = '', $status = '')
{
    $and = "";
    $temp_status = '';

    if (is_array($status) && count($status) >= 1) {
        foreach ($status as $val) {
            $temp_status .= "'" . $val . "',";
        }
        $temp_status = rtrim($temp_status, ',');
        $and = " AND status IN ($temp_status) ";
    }

    $merchant_id = (int)$merchant_id;

    $stmt = "
        SELECT * FROM mt_withdrawal
        WHERE merchant_id = $merchant_id
        $and
        ORDER BY withdrawal_id DESC
    ";

    $result = $this->db->query($stmt);
    if ($res = $result->fetchAll(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}
   




public function CountryList()
    {
        $cuntry_list=array (
  'AF' => 'Afghanistan',
  'AL' => 'Albania',
  'DZ' => 'Algeria',
  'AS' => 'American Samoa',
  'AD' => 'Andorra',
  'AO' => 'Angola',
  'AI' => 'Anguilla',
  'AQ' => 'Antarctica',
  'AG' => 'Antigua and Barbuda',
  'AR' => 'Argentina',
  'AM' => 'Armenia',
  'AW' => 'Aruba',
  'AU' => 'Australia',
  'AT' => 'Austria',
  'AZ' => 'Azerbaijan',
  'BS' => 'Bahamas',
  'BH' => 'Bahrain',
  'BD' => 'Bangladesh',
  'BB' => 'Barbados',
  'BY' => 'Belarus',
  'BE' => 'Belgium',
  'BZ' => 'Belize',
  'BJ' => 'Benin',
  'BM' => 'Bermuda',
  'BT' => 'Bhutan',
  'BO' => 'Bolivia',
  'BA' => 'Bosnia and Herzegovina',
  'BW' => 'Botswana',
  'BV' => 'Bouvet Island',
  'BR' => 'Brazil',
  'BQ' => 'British Antarctic Territory',
  'IO' => 'British Indian Ocean Territory',
  'VG' => 'British Virgin Islands',
  'BN' => 'Brunei',
  'BG' => 'Bulgaria',
  'BF' => 'Burkina Faso',
  'BI' => 'Burundi',
  'KH' => 'Cambodia',
  'CM' => 'Cameroon',
  'CA' => 'Canada',
  'CT' => 'Canton and Enderbury Islands',
  'CV' => 'Cape Verde',
  'KY' => 'Cayman Islands',
  'CF' => 'Central African Republic',
  'TD' => 'Chad',
  'CL' => 'Chile',
  'CN' => 'China',
  'CX' => 'Christmas Island',
  'CC' => 'Cocos [Keeling] Islands',
  'CO' => 'Colombia',
  'KM' => 'Comoros',
  'CG' => 'Congo - Brazzaville',
  'CD' => 'Congo - Kinshasa',
  'CK' => 'Cook Islands',
  'CR' => 'Costa Rica',
  'HR' => 'Croatia',
  'CU' => 'Cuba',
  'CY' => 'Cyprus',
  'CZ' => 'Czech Republic',
  'CI' => 'Côte d’Ivoire',
  'DK' => 'Denmark',
  'DJ' => 'Djibouti',
  'DM' => 'Dominica',
  'DO' => 'Dominican Republic',
  'NQ' => 'Dronning Maud Land',
  'DD' => 'East Germany',
  'EC' => 'Ecuador',
  'EG' => 'Egypt',
  'SV' => 'El Salvador',
  'GQ' => 'Equatorial Guinea',
  'ER' => 'Eritrea',
  'EE' => 'Estonia',
  'ET' => 'Ethiopia',
  'FK' => 'Falkland Islands',
  'FO' => 'Faroe Islands',
  'FJ' => 'Fiji',
  'FI' => 'Finland',
  'FR' => 'France',
  'GF' => 'French Guiana',
  'PF' => 'French Polynesia',
  'TF' => 'French Southern Territories',
  'FQ' => 'French Southern and Antarctic Territories',
  'GA' => 'Gabon',
  'GM' => 'Gambia',
  'GE' => 'Georgia',
  'DE' => 'Germany',
  'GH' => 'Ghana',
  'GI' => 'Gibraltar',
  'GR' => 'Greece',
  'GL' => 'Greenland',
  'GD' => 'Grenada',
  'GP' => 'Guadeloupe',
  'GU' => 'Guam',
  'GT' => 'Guatemala',
  'GG' => 'Guernsey',
  'GN' => 'Guinea',
  'GW' => 'Guinea-Bissau',
  'GY' => 'Guyana',
  'HT' => 'Haiti',
  'HM' => 'Heard Island and McDonald Islands',
  'HN' => 'Honduras',
  'HK' => 'Hong Kong SAR China',
  'HU' => 'Hungary',
  'IS' => 'Iceland',
  'IN' => 'India',
  'ID' => 'Indonesia',
  'IR' => 'Iran',
  'IQ' => 'Iraq',
  'IE' => 'Ireland',
  'IM' => 'Isle of Man',
  'IL' => 'Israel',
  'IT' => 'Italy',
  'JM' => 'Jamaica',
  'JP' => 'Japan',
  'JE' => 'Jersey',
  'JT' => 'Johnston Island',
  'JO' => 'Jordan',
  'KZ' => 'Kazakhstan',
  'KE' => 'Kenya',
  'KI' => 'Kiribati',
  'KW' => 'Kuwait',
  'KG' => 'Kyrgyzstan',
  'LA' => 'Laos',
  'LV' => 'Latvia',
  'LB' => 'Lebanon',
  'LS' => 'Lesotho',
  'LR' => 'Liberia',
  'LY' => 'Libya',
  'LI' => 'Liechtenstein',
  'LT' => 'Lithuania',
  'LU' => 'Luxembourg',
  'MO' => 'Macau SAR China',
  'MK' => 'Macedonia',
  'MG' => 'Madagascar',
  'MW' => 'Malawi',
  'MY' => 'Malaysia',
  'MV' => 'Maldives',
  'ML' => 'Mali',
  'MT' => 'Malta',
  'MH' => 'Marshall Islands',
  'MQ' => 'Martinique',
  'MR' => 'Mauritania',
  'MU' => 'Mauritius',
  'YT' => 'Mayotte',
  'FX' => 'Metropolitan France',
  'MX' => 'Mexico',
  'FM' => 'Micronesia',
  'MI' => 'Midway Islands',
  'MD' => 'Moldova',
  'MC' => 'Monaco',
  'MN' => 'Mongolia',
  'ME' => 'Montenegro',
  'MS' => 'Montserrat',
  'MA' => 'Morocco',
  'MZ' => 'Mozambique',
  'MM' => 'Myanmar [Burma]',
  'NA' => 'Namibia',
  'NR' => 'Nauru',
  'NP' => 'Nepal',
  'NL' => 'Netherlands',
  'AN' => 'Netherlands Antilles',
  'NT' => 'Neutral Zone',
  'NC' => 'New Caledonia',
  'NZ' => 'New Zealand',
  'NI' => 'Nicaragua',
  'NE' => 'Niger',
  'NG' => 'Nigeria',
  'NU' => 'Niue',
  'NF' => 'Norfolk Island',
  'KP' => 'North Korea',
  'VD' => 'North Vietnam',
  'MP' => 'Northern Mariana Islands',
  'NO' => 'Norway',
  'OM' => 'Oman',
  'PC' => 'Pacific Islands Trust Territory',
  'PK' => 'Pakistan',
  'PW' => 'Palau',
  'PS' => 'Palestinian Territories',
  'PA' => 'Panama',
  'PZ' => 'Panama Canal Zone',
  'PG' => 'Papua New Guinea',
  'PY' => 'Paraguay',
  'YD' => 'People\'s Democratic Republic of Yemen',
  'PE' => 'Peru',
  'PH' => 'Philippines',
  'PN' => 'Pitcairn Islands',
  'PL' => 'Poland',
  'PT' => 'Portugal',
  'PR' => 'Puerto Rico',
  'QA' => 'Qatar',
  'RO' => 'Romania',
  'RU' => 'Russia',
  'RW' => 'Rwanda',
  'RE' => 'Réunion',
  'BL' => 'Saint Barthélemy',
  'SH' => 'Saint Helena',
  'KN' => 'Saint Kitts and Nevis',
  'LC' => 'Saint Lucia',
  'MF' => 'Saint Martin',
  'PM' => 'Saint Pierre and Miquelon',
  'VC' => 'Saint Vincent and the Grenadines',
  'WS' => 'Samoa',
  'SM' => 'San Marino',
  'SA' => 'Saudi Arabia',
  'SN' => 'Senegal',
  'RS' => 'Serbia',
  'CS' => 'Serbia and Montenegro',
  'SC' => 'Seychelles',
  'SL' => 'Sierra Leone',
  'SG' => 'Singapore',
  'SK' => 'Slovakia',
  'SI' => 'Slovenia',
  'SB' => 'Solomon Islands',
  'SO' => 'Somalia',
  'ZA' => 'South Africa',
  'GS' => 'South Georgia and the South Sandwich Islands',
  'KR' => 'South Korea',
  'ES' => 'Spain',
  'LK' => 'Sri Lanka',
  'SD' => 'Sudan',
  'SR' => 'Suriname',
  'SJ' => 'Svalbard and Jan Mayen',
  'SZ' => 'Swaziland',
  'SE' => 'Sweden',
  'CH' => 'Switzerland',
  'SY' => 'Syria',
  'ST' => 'São Tomé and Príncipe',
  'TW' => 'Taiwan',
  'TJ' => 'Tajikistan',
  'TZ' => 'Tanzania',
  'TH' => 'Thailand',
  'TL' => 'Timor-Leste',
  'TG' => 'Togo',
  'TK' => 'Tokelau',
  'TO' => 'Tonga',
  'TT' => 'Trinidad and Tobago',
  'TN' => 'Tunisia',
  'TR' => 'Turkey',
  'TM' => 'Turkmenistan',
  'TC' => 'Turks and Caicos Islands',
  'TV' => 'Tuvalu',
  'UM' => 'U.S. Minor Outlying Islands',
  'PU' => 'U.S. Miscellaneous Pacific Islands',
  'VI' => 'U.S. Virgin Islands',
  'UG' => 'Uganda',
  'UA' => 'Ukraine',
  'SU' => 'Union of Soviet Socialist Republics',
  'AE' => 'United Arab Emirates',
  'GB' => 'United Kingdom',
  'US' => 'United States',
  'ZZ' => 'Unknown or Invalid Region',
  'UY' => 'Uruguay',
  'UZ' => 'Uzbekistan',
  'VU' => 'Vanuatu',
  'VA' => 'Vatican City',
  'VE' => 'Venezuela',
  'VN' => 'Vietnam',
  'WK' => 'Wake Island',
  'WF' => 'Wallis and Futuna',
  'EH' => 'Western Sahara',
  'YE' => 'Yemen',
  'ZM' => 'Zambia',
  'ZW' => 'Zimbabwe',
  'AX' => 'Åland Islands',
);  
        return $cuntry_list;
    }


    public function MobileCountryCode(){
        return array(
    'AD'=>array('name'=>'ANDORRA','code'=>'376'),
    'AE'=>array('name'=>'UNITED ARAB EMIRATES','code'=>'971'),
    'AF'=>array('name'=>'AFGHANISTAN','code'=>'93'),
    'AG'=>array('name'=>'ANTIGUA AND BARBUDA','code'=>'1268'),
    'AI'=>array('name'=>'ANGUILLA','code'=>'1264'),
    'AL'=>array('name'=>'ALBANIA','code'=>'355'),
    'AM'=>array('name'=>'ARMENIA','code'=>'374'),
    'AN'=>array('name'=>'NETHERLANDS ANTILLES','code'=>'599'),
    'AO'=>array('name'=>'ANGOLA','code'=>'244'),
    'AQ'=>array('name'=>'ANTARCTICA','code'=>'672'),
    'AR'=>array('name'=>'ARGENTINA','code'=>'54'),
    'AS'=>array('name'=>'AMERICAN SAMOA','code'=>'1684'),
    'AT'=>array('name'=>'AUSTRIA','code'=>'43'),
    'AU'=>array('name'=>'AUSTRALIA','code'=>'61'),
    'AW'=>array('name'=>'ARUBA','code'=>'297'),
    'AZ'=>array('name'=>'AZERBAIJAN','code'=>'994'),
    'BA'=>array('name'=>'BOSNIA AND HERZEGOVINA','code'=>'387'),
    'BB'=>array('name'=>'BARBADOS','code'=>'1246'),
    'BD'=>array('name'=>'BANGLADESH','code'=>'880'),
    'BE'=>array('name'=>'BELGIUM','code'=>'32'),
    'BF'=>array('name'=>'BURKINA FASO','code'=>'226'),
    'BG'=>array('name'=>'BULGARIA','code'=>'359'),
    'BH'=>array('name'=>'BAHRAIN','code'=>'973'),
    'BI'=>array('name'=>'BURUNDI','code'=>'257'),
    'BJ'=>array('name'=>'BENIN','code'=>'229'),
    'BL'=>array('name'=>'SAINT BARTHELEMY','code'=>'590'),
    'BM'=>array('name'=>'BERMUDA','code'=>'1441'),
    'BN'=>array('name'=>'BRUNEI DARUSSALAM','code'=>'673'),
    'BO'=>array('name'=>'BOLIVIA','code'=>'591'),
    'BR'=>array('name'=>'BRAZIL','code'=>'55'),
    'BS'=>array('name'=>'BAHAMAS','code'=>'1242'),
    'BT'=>array('name'=>'BHUTAN','code'=>'975'),
    'BW'=>array('name'=>'BOTSWANA','code'=>'267'),
    'BY'=>array('name'=>'BELARUS','code'=>'375'),
    'BZ'=>array('name'=>'BELIZE','code'=>'501'),
    'CA'=>array('name'=>'CANADA','code'=>'1'),
    'CC'=>array('name'=>'COCOS (KEELING) ISLANDS','code'=>'61'),
    'CD'=>array('name'=>'CONGO, THE DEMOCRATIC REPUBLIC OF THE','code'=>'243'),
    'CF'=>array('name'=>'CENTRAL AFRICAN REPUBLIC','code'=>'236'),
    'CG'=>array('name'=>'CONGO','code'=>'242'),
    'CH'=>array('name'=>'SWITZERLAND','code'=>'41'),
    'CI'=>array('name'=>'COTE D IVOIRE','code'=>'225'),
    'CK'=>array('name'=>'COOK ISLANDS','code'=>'682'),
    'CL'=>array('name'=>'CHILE','code'=>'56'),
    'CM'=>array('name'=>'CAMEROON','code'=>'237'),
    'CN'=>array('name'=>'CHINA','code'=>'86'),
    'CO'=>array('name'=>'COLOMBIA','code'=>'57'),
    'CR'=>array('name'=>'COSTA RICA','code'=>'506'),
    'CU'=>array('name'=>'CUBA','code'=>'53'),
    'CV'=>array('name'=>'CAPE VERDE','code'=>'238'),
    'CX'=>array('name'=>'CHRISTMAS ISLAND','code'=>'61'),
    'CY'=>array('name'=>'CYPRUS','code'=>'357'),
    'CZ'=>array('name'=>'CZECH REPUBLIC','code'=>'420'),
    'DE'=>array('name'=>'GERMANY','code'=>'49'),
    'DJ'=>array('name'=>'DJIBOUTI','code'=>'253'),
    'DK'=>array('name'=>'DENMARK','code'=>'45'),
    'DM'=>array('name'=>'DOMINICA','code'=>'1767'),
    'DO'=>array('name'=>'DOMINICAN REPUBLIC','code'=>'1809'),
    'DZ'=>array('name'=>'ALGERIA','code'=>'213'),
    'EC'=>array('name'=>'ECUADOR','code'=>'593'),
    'EE'=>array('name'=>'ESTONIA','code'=>'372'),
    'EG'=>array('name'=>'EGYPT','code'=>'20'),
    'ER'=>array('name'=>'ERITREA','code'=>'291'),
    'ES'=>array('name'=>'SPAIN','code'=>'34'),
    'ET'=>array('name'=>'ETHIOPIA','code'=>'251'),
    'FI'=>array('name'=>'FINLAND','code'=>'358'),
    'FJ'=>array('name'=>'FIJI','code'=>'679'),
    'FK'=>array('name'=>'FALKLAND ISLANDS (MALVINAS)','code'=>'500'),
    'FM'=>array('name'=>'MICRONESIA, FEDERATED STATES OF','code'=>'691'),
    'FO'=>array('name'=>'FAROE ISLANDS','code'=>'298'),
    'FR'=>array('name'=>'FRANCE','code'=>'33'),
    'GA'=>array('name'=>'GABON','code'=>'241'),
    'GB'=>array('name'=>'UNITED KINGDOM','code'=>'44'),
    'GD'=>array('name'=>'GRENADA','code'=>'1473'),
    'GE'=>array('name'=>'GEORGIA','code'=>'995'),
    'GH'=>array('name'=>'GHANA','code'=>'233'),
    'GI'=>array('name'=>'GIBRALTAR','code'=>'350'),
    'GL'=>array('name'=>'GREENLAND','code'=>'299'),
    'GM'=>array('name'=>'GAMBIA','code'=>'220'),
    'GN'=>array('name'=>'GUINEA','code'=>'224'),
    'GQ'=>array('name'=>'EQUATORIAL GUINEA','code'=>'240'),
    'GR'=>array('name'=>'GREECE','code'=>'30'),
    'GT'=>array('name'=>'GUATEMALA','code'=>'502'),
    'GU'=>array('name'=>'GUAM','code'=>'1671'),
    'GW'=>array('name'=>'GUINEA-BISSAU','code'=>'245'),
    'GY'=>array('name'=>'GUYANA','code'=>'592'),
    'HK'=>array('name'=>'HONG KONG','code'=>'852'),
    'HN'=>array('name'=>'HONDURAS','code'=>'504'),
    'HR'=>array('name'=>'CROATIA','code'=>'385'),
    'HT'=>array('name'=>'HAITI','code'=>'509'),
    'HU'=>array('name'=>'HUNGARY','code'=>'36'),
    'ID'=>array('name'=>'INDONESIA','code'=>'62'),
    'IE'=>array('name'=>'IRELAND','code'=>'353'),
    'IL'=>array('name'=>'ISRAEL','code'=>'972'),
    'IM'=>array('name'=>'ISLE OF MAN','code'=>'44'),
    'IN'=>array('name'=>'INDIA','code'=>'91'),
    'IQ'=>array('name'=>'IRAQ','code'=>'964'),
    'IR'=>array('name'=>'IRAN, ISLAMIC REPUBLIC OF','code'=>'98'),
    'IS'=>array('name'=>'ICELAND','code'=>'354'),
    'IT'=>array('name'=>'ITALY','code'=>'39'),
    'JM'=>array('name'=>'JAMAICA','code'=>'1876'),
    'JO'=>array('name'=>'JORDAN','code'=>'962'),
    'JP'=>array('name'=>'JAPAN','code'=>'81'),
    'KE'=>array('name'=>'KENYA','code'=>'254'),
    'KG'=>array('name'=>'KYRGYZSTAN','code'=>'996'),
    'KH'=>array('name'=>'CAMBODIA','code'=>'855'),
    'KI'=>array('name'=>'KIRIBATI','code'=>'686'),
    'KM'=>array('name'=>'COMOROS','code'=>'269'),
    'KN'=>array('name'=>'SAINT KITTS AND NEVIS','code'=>'1869'),
    'KP'=>array('name'=>'KOREA DEMOCRATIC PEOPLES REPUBLIC OF','code'=>'850'),
    'KR'=>array('name'=>'KOREA REPUBLIC OF','code'=>'82'),
    'KW'=>array('name'=>'KUWAIT','code'=>'965'),
    'KY'=>array('name'=>'CAYMAN ISLANDS','code'=>'1345'),
    'KZ'=>array('name'=>'KAZAKSTAN','code'=>'7'),
    'LA'=>array('name'=>'LAO PEOPLES DEMOCRATIC REPUBLIC','code'=>'856'),
    'LB'=>array('name'=>'LEBANON','code'=>'961'),
    'LC'=>array('name'=>'SAINT LUCIA','code'=>'1758'),
    'LI'=>array('name'=>'LIECHTENSTEIN','code'=>'423'),
    'LK'=>array('name'=>'SRI LANKA','code'=>'94'),
    'LR'=>array('name'=>'LIBERIA','code'=>'231'),
    'LS'=>array('name'=>'LESOTHO','code'=>'266'),
    'LT'=>array('name'=>'LITHUANIA','code'=>'370'),
    'LU'=>array('name'=>'LUXEMBOURG','code'=>'352'),
    'LV'=>array('name'=>'LATVIA','code'=>'371'),
    'LY'=>array('name'=>'LIBYAN ARAB JAMAHIRIYA','code'=>'218'),
    'MA'=>array('name'=>'MOROCCO','code'=>'212'),
    'MC'=>array('name'=>'MONACO','code'=>'377'),
    'MD'=>array('name'=>'MOLDOVA, REPUBLIC OF','code'=>'373'),
    'ME'=>array('name'=>'MONTENEGRO','code'=>'382'),
    'MF'=>array('name'=>'SAINT MARTIN','code'=>'1599'),
    'MG'=>array('name'=>'MADAGASCAR','code'=>'261'),
    'MH'=>array('name'=>'MARSHALL ISLANDS','code'=>'692'),
    'MK'=>array('name'=>'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF','code'=>'389'),
    'ML'=>array('name'=>'MALI','code'=>'223'),
    'MM'=>array('name'=>'MYANMAR','code'=>'95'),
    'MN'=>array('name'=>'MONGOLIA','code'=>'976'),
    'MO'=>array('name'=>'MACAU','code'=>'853'),
    'MP'=>array('name'=>'NORTHERN MARIANA ISLANDS','code'=>'1670'),
    'MR'=>array('name'=>'MAURITANIA','code'=>'222'),
    'MS'=>array('name'=>'MONTSERRAT','code'=>'1664'),
    'MT'=>array('name'=>'MALTA','code'=>'356'),
    'MU'=>array('name'=>'MAURITIUS','code'=>'230'),
    'MV'=>array('name'=>'MALDIVES','code'=>'960'),
    'MW'=>array('name'=>'MALAWI','code'=>'265'),
    'MX'=>array('name'=>'MEXICO','code'=>'52'),
    'MY'=>array('name'=>'MALAYSIA','code'=>'60'),
    'MZ'=>array('name'=>'MOZAMBIQUE','code'=>'258'),
    'NA'=>array('name'=>'NAMIBIA','code'=>'264'),
    'NC'=>array('name'=>'NEW CALEDONIA','code'=>'687'),
    'NE'=>array('name'=>'NIGER','code'=>'227'),
    'NG'=>array('name'=>'NIGERIA','code'=>'234'),
    'NI'=>array('name'=>'NICARAGUA','code'=>'505'),
    'NL'=>array('name'=>'NETHERLANDS','code'=>'31'),
    'NO'=>array('name'=>'NORWAY','code'=>'47'),
    'NP'=>array('name'=>'NEPAL','code'=>'977'),
    'NR'=>array('name'=>'NAURU','code'=>'674'),
    'NU'=>array('name'=>'NIUE','code'=>'683'),
    'NZ'=>array('name'=>'NEW ZEALAND','code'=>'64'),
    'OM'=>array('name'=>'OMAN','code'=>'968'),
    'PA'=>array('name'=>'PANAMA','code'=>'507'),
    'PE'=>array('name'=>'PERU','code'=>'51'),
    'PF'=>array('name'=>'FRENCH POLYNESIA','code'=>'689'),
    'PG'=>array('name'=>'PAPUA NEW GUINEA','code'=>'675'),
    'PH'=>array('name'=>'PHILIPPINES','code'=>'63'),
    'PK'=>array('name'=>'PAKISTAN','code'=>'92'),
    'PL'=>array('name'=>'POLAND','code'=>'48'),
    'PM'=>array('name'=>'SAINT PIERRE AND MIQUELON','code'=>'508'),
    'PN'=>array('name'=>'PITCAIRN','code'=>'870'),
    'PR'=>array('name'=>'PUERTO RICO','code'=>'1'),
    'PT'=>array('name'=>'PORTUGAL','code'=>'351'),
    'PW'=>array('name'=>'PALAU','code'=>'680'),
    'PY'=>array('name'=>'PARAGUAY','code'=>'595'),
    'QA'=>array('name'=>'QATAR','code'=>'974'),
    'RO'=>array('name'=>'ROMANIA','code'=>'40'),
    'RS'=>array('name'=>'SERBIA','code'=>'381'),
    'RU'=>array('name'=>'RUSSIAN FEDERATION','code'=>'7'),
    'RW'=>array('name'=>'RWANDA','code'=>'250'),
    'SA'=>array('name'=>'SAUDI ARABIA','code'=>'966'),
    'SB'=>array('name'=>'SOLOMON ISLANDS','code'=>'677'),
    'SC'=>array('name'=>'SEYCHELLES','code'=>'248'),
    'SD'=>array('name'=>'SUDAN','code'=>'249'),
    'SE'=>array('name'=>'SWEDEN','code'=>'46'),
    'SG'=>array('name'=>'SINGAPORE','code'=>'65'),
    'SH'=>array('name'=>'SAINT HELENA','code'=>'290'),
    'SI'=>array('name'=>'SLOVENIA','code'=>'386'),
    'SK'=>array('name'=>'SLOVAKIA','code'=>'421'),
    'SL'=>array('name'=>'SIERRA LEONE','code'=>'232'),
    'SM'=>array('name'=>'SAN MARINO','code'=>'378'),
    'SN'=>array('name'=>'SENEGAL','code'=>'221'),
    'SO'=>array('name'=>'SOMALIA','code'=>'252'),
    'SR'=>array('name'=>'SURINAME','code'=>'597'),
    'ST'=>array('name'=>'SAO TOME AND PRINCIPE','code'=>'239'),
    'SV'=>array('name'=>'EL SALVADOR','code'=>'503'),
    'SY'=>array('name'=>'SYRIAN ARAB REPUBLIC','code'=>'963'),
    'SZ'=>array('name'=>'SWAZILAND','code'=>'268'),
    'TC'=>array('name'=>'TURKS AND CAICOS ISLANDS','code'=>'1649'),
    'TD'=>array('name'=>'CHAD','code'=>'235'),
    'TG'=>array('name'=>'TOGO','code'=>'228'),
    'TH'=>array('name'=>'THAILAND','code'=>'66'),
    'TJ'=>array('name'=>'TAJIKISTAN','code'=>'992'),
    'TK'=>array('name'=>'TOKELAU','code'=>'690'),
    'TL'=>array('name'=>'TIMOR-LESTE','code'=>'670'),
    'TM'=>array('name'=>'TURKMENISTAN','code'=>'993'),
    'TN'=>array('name'=>'TUNISIA','code'=>'216'),
    'TO'=>array('name'=>'TONGA','code'=>'676'),
    'TR'=>array('name'=>'TURKEY','code'=>'90'),
    'TT'=>array('name'=>'TRINIDAD AND TOBAGO','code'=>'1868'),
    'TV'=>array('name'=>'TUVALU','code'=>'688'),
    'TW'=>array('name'=>'TAIWAN, PROVINCE OF CHINA','code'=>'886'),
    'TZ'=>array('name'=>'TANZANIA, UNITED REPUBLIC OF','code'=>'255'),
    'UA'=>array('name'=>'UKRAINE','code'=>'380'),
    'UG'=>array('name'=>'UGANDA','code'=>'256'),
    'US'=>array('name'=>'UNITED STATES','code'=>'1'),
    'UY'=>array('name'=>'URUGUAY','code'=>'598'),
    'UZ'=>array('name'=>'UZBEKISTAN','code'=>'998'),
    'VA'=>array('name'=>'HOLY SEE (VATICAN CITY STATE)','code'=>'39'),
    'VC'=>array('name'=>'SAINT VINCENT AND THE GRENADINES','code'=>'1784'),
    'VE'=>array('name'=>'VENEZUELA','code'=>'58'),
    'VG'=>array('name'=>'VIRGIN ISLANDS, BRITISH','code'=>'1284'),
    'VI'=>array('name'=>'VIRGIN ISLANDS, U.S.','code'=>'1340'),
    'VN'=>array('name'=>'VIET NAM','code'=>'84'),
    'VU'=>array('name'=>'VANUATU','code'=>'678'),
    'WF'=>array('name'=>'WALLIS AND FUTUNA','code'=>'681'),
    'WS'=>array('name'=>'SAMOA','code'=>'685'),
    'XK'=>array('name'=>'KOSOVO','code'=>'381'),
    'YE'=>array('name'=>'YEMEN','code'=>'967'),
    'YT'=>array('name'=>'MAYOTTE','code'=>'262'),
    'ZA'=>array('name'=>'SOUTH AFRICA','code'=>'27'),
    'ZM'=>array('name'=>'ZAMBIA','code'=>'260'),
    'ZW'=>array('name'=>'ZIMBABWE','code'=>'263')
);
    }



    public  function ListLocationState($country_id='',$with_select=true)
   {
      if ( $res=$this->locationStateList($country_id)){
           $data=array();
           if($with_select){
              $data['']="Select State";
           }
           foreach ($res as $val) {              
              $data[$val['state_id']]=stripslashes($val['name']);
           }           
           return $data;
      }
      return false;
   }


  public function getalltables($id, $pid)
{

  $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = "
    SELECT * FROM mt_table
    WHERE 1
    AND m_id = $id
    ORDER BY name ASC
    ";

    $result = $this->db->query($stmt);
    if ($result && $data = $result->fetchAll(PDO::FETCH_ASSOC)) {
        return $data;
    }

    return false;
}

public function getallactivetables($id)
{
    $stmt = "
    SELECT a.* 
    FROM mt_table a, mt_pos_cart b 
    WHERE 1
    AND a.m_id = $id 
    AND a.id = b.table_number 
    ORDER BY name ASC
    ";
   $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $result = $this->db->query($stmt);
    if ($result && $data = $result->fetchAll(PDO::FETCH_ASSOC)) {
        return $data;
    }

    return false;
}


public function getallavailabletables($id)
{
    $data = [];
    $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = "SELECT * FROM mt_table WHERE 1 AND m_id = $id ORDER BY name ASC";
    $result = $this->db->query($stmt);
    
    if ($result && $res = $result->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {

            $table_id = $val['id'];
            $stmt1 = "SELECT table_number FROM mt_pos_cart WHERE 1 AND table_number = $table_id";
            $result1 = $this->db->query($stmt1);
            $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
            if (!($result1 && $result1->fetch(PDO::FETCH_ASSOC))) {
                $data[] = array(
                    'id' => $val['id'],
                    'm_id' => $val['m_id'],
                    'm_user_id' => $val['m_user_id'],
                    'name' => $val['name'],
                    'date_created' => $val['date_created'],
                );
            }
        }

        return $data;
    }

    return false;
}



public function getallcustomers_byname($id, $pid, $name)
{
    $this->PointsProgram = new PointsProgram();
    
    $stmt = "
    SELECT * FROM mt_client 
    WHERE 1 
    AND merchant_id = $id 
    AND status = 'active' 
    AND (author_url IS NULL OR author_url = '')
    AND ( first_name LIKE '%$name%' OR last_name LIKE '%$name%' )
    LIMIT 10
    ";

    $points_enabled = '';
    
    $points_enabled = $this->getOptionAdmin('points_enabled');
    if ($points_enabled == "1") {
        if (!$this->PointsProgram->isMerchantSettingsDisabled()) {
            $mt_disabled_pts = $this->getOption('mt_disabled_pts', $id);
            if ($mt_disabled_pts == 2) {
                $points_enabled = '';
            }
        }
    }

    $result = $this->db->query($stmt);
    if ($result && $res = $result->fetchAll(PDO::FETCH_ASSOC)) {
        $data = array();
        foreach ($res as $val) {
            if ($points_enabled == "1") {
                $available_points = $this->PointsProgram->getTotalEarnPoints($val['client_id'], $id);
                $available_points_label = "Your available points " . $available_points;
                $val['available_points'] = $available_points;
                $val['available_points_label'] = $available_points_label;
            }
            $data[] = $val;
        }
        return $data;
    }

    return false;
}







  public function clientHistyOrder_f($client_id = '')
{
    // Initialize the database connection (use $this->db instead of $DbExt)
    $stmt = "
        SELECT a.*, 
               (SELECT restaurant_name FROM mt_merchant WHERE merchant_id = a.merchant_id) AS merchant_name
        FROM mt_order a
        WHERE client_id = :client_id
        AND status NOT IN ('initial_order')
        ORDER BY order_id DESC
        LIMIT 0, 10
    ";

    // Prepare the SQL query
    $stmt = $this->db->prepare($stmt);

    // Bind the client_id parameter to prevent SQL injection
    $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);

    // Execute the query
    $stmt->execute();

    // Fetch the results as an associative array
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Check if there are results and return them
    if ($res) {
        return $res;
    }

    // Return false if no results are found
    return false;
}


  public function clientHistyOrder($client_id = '')
{
    $data = [];
    
    // Prepare the query
    $stmt = $this->db->prepare("
        SELECT a.*,
            (SELECT restaurant_name FROM mt_merchant WHERE merchant_id = a.merchant_id LIMIT 1) AS merchant_name,
            (SELECT COUNT(*) FROM mt_review WHERE order_id = a.order_id) AS review_count,
            (SELECT used_currency FROM mt_order_delivery_address WHERE order_id = a.order_id LIMIT 1) AS used_currency
        FROM mt_order a
        WHERE client_id = :client_id
        AND status NOT IN ('initial_order')
        ORDER BY order_id DESC
        LIMIT 10
    ");

    // Bind parameters
    $stmt->bindValue(':client_id', (int)$client_id, PDO::PARAM_INT);

    // Execute query
    $stmt->execute();

    // Fetch results
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    return $data ?: false;
}








 public function locationStateList($country_id = '')
{
    if ($country_id > 0) {
        $stmt = $this->db->prepare("
            SELECT * FROM
            mt_location_states
            WHERE
            country_id = :country_id
            ORDER BY sequence ASC
        ");
        
        // Bind the country_id parameter
        $stmt->bindParam(':country_id', $country_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the results
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            return $res;
        }
    }
    
    return false;
}

public function getLocationStateIdByCity($city_id = 0)
{
    if ($city_id > 0) {
        $stmt = $this->db->prepare("
            SELECT state_id, name, postal_code FROM mt_location_cities
            WHERE city_id = :city_id
        ");
        
        // Bind the city_id parameter
        $stmt->bindParam(':city_id', $city_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($resp) {
            return $resp;
        }
    }

    return false;
}


public  function ListCityList($state_id='' , $with_select=true )
   {
       if ($res=$this->locationCityList($state_id)){
           $data=array();
           if($with_select){
              $data['']="Select City";
           }
           foreach ($res as $val) {
               $data[$val['city_id']]=stripslashes($val['name']);
           }
           return $data;
       }
       return false;
   }


public function locationCityList($state_id = '')
{
    if ($state_id !== '') {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_location_cities
            WHERE state_id = :state_id
            ORDER BY sequence ASC
        ");

        // Bind the state_id parameter
        $stmt->bindParam(':state_id', $state_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch all results
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            return $res;
        }
    }

    return false;
}


 public  function AreaList($city_id='' , $with_select=true)
   {
       if ($res=$this->locationAreaList($city_id)){
           $data=array();
           if($with_select){
              $data['']="Select Distric/Area/neighborhood";
           }
           foreach ($res as $val) {
               $data[$val['area_id']]=stripslashes($val['name']);
           }
           return $data;
       }
       return false;
   }


  public function locationAreaList($city_id = '')
{
    if ($city_id !== '') {
        $stmt = $this->db->prepare("
            SELECT * FROM mt_location_area
            WHERE city_id = :city_id
            ORDER BY sequence ASC
        ");

        // Bind the city_id parameter
        $stmt->bindParam(':city_id', $city_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch all results
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            return $res;
        }
    }

    return false;
}

 




     public function getSMSTransaction($id = '')
{
    $stmt = "
        SELECT a.*,
            (
                SELECT restaurant_name
                FROM mt_merchant
                WHERE merchant_id = a.merchant_id
            ) AS merchant_name,
            (
                SELECT title
                FROM mt_sms_package
                WHERE sms_package_id = a.sms_package_id
            ) AS sms_package_name
        FROM mt_sms_package_trans a
        WHERE a.id = :id
        LIMIT 1
    ";

    // Prepare and execute the query using $this->db
    $query = $this->db->prepare($stmt);
    $query->bindParam(':id', $id, PDO::PARAM_INT);
    $query->execute();
    
    $res = $query->fetchAll(PDO::FETCH_ASSOC);
    
    if (!empty($res)) {
        return $res[0];
    }
    
    return false;
}


        public  function minimumDeliveryFeeNew($exchange_rate=1)   
    {     
      $minimum_list = array();
      $data = array(5,10,15,20);
      foreach ($data as $val) {
        $value = (float)$val * $exchange_rate;
        $minimum_list[$val] = "< ".$this->formatNumber($value);
      }
    return $minimum_list;
    }



     public function Cuisine($list = true) {
        $lists[]='Please select';
    $lists=array();
        // Prepare the SQL statement
        $stmt = $this->db->prepare("SELECT * FROM mt_cuisine ORDER BY sequence ASC");

        // Execute the query
        $stmt->execute();

        // Fetch the results
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($result) {
            if ($list) {
                // Add 'Please select' option
                

                foreach ($result as $val) {
                    $lists[$val['cuisine_id']] = $val['cuisine_name'];  // Adjust as needed
                }
                return $lists;
            }
            return $result;
        }
        return false;
    }

    public function uploadURL()
{
    return Config::$baseUrl."/upload";
}

public function uploadPath()
{
    return Config::$baseUrl."/upload";
}


public function getFoodDefaultImage($photo='',$small=true)
    {
        $path=$this->uploadPath()."/$photo";     
        if (empty($photo)){
            if ( $small){
                $url_image=$this->websiteUrl()."/assets/images/default-food-image.png";
            } else $url_image=$this->websiteUrl()."/assets/images/default-food-image-large.png";
        } else $url_image=$this->websiteUrl()."/upload/$photo";        
        return $url_image;
    }   




 public function multipleField()
    {
        
        return false;
    }

    public function okToDecode()
{
    $version=phpversion();      
    if ( $version>5.3){
        return true;
    }
    return false;
}

  public function deleteDishes($dish_id = 0)
{
    try {
        // Start a transaction
        $this->db->beginTransaction();

        // Delete from the `mt_dishes` table
        $stmt1 = $this->db->prepare("DELETE FROM mt_dishes WHERE dish_id = :dish_id");
        $stmt1->bindParam(':dish_id', $dish_id, PDO::PARAM_INT);
        $resp1 = $stmt1->execute();

        if ($resp1) {
            // Delete from the `item_meta` table
            $meta_name = 'dish';

$stmt2 = $this->db->prepare("DELETE FROM mt_item_meta WHERE meta_name = :meta_name AND meta_id = :meta_id");
$stmt2->bindParam(':meta_name', $meta_name, PDO::PARAM_STR);  // Now passing the variable by reference
$stmt2->bindParam(':meta_id', $dish_id, PDO::PARAM_INT);
$resp2 = $stmt2->execute();


            // Delete related records in `dishes_translation` table
            $this->deleteRelationship($dish_id, 'dish_id', 'mt_dishes_translation');

            // Commit the transaction
            $this->db->commit();
            return true;
        } else {
            // Rollback the transaction if something went wrong
            $this->db->rollBack();
            throw new Exception("Failed cannot delete records");
        }
    } catch (Exception $e) {
        // Rollback the transaction in case of an error
        $this->db->rollBack();
        throw new Exception("Failed cannot delete records: " . $e->getMessage());
    }
}

public function deleteRelationship($id = '', $primary = '', $table = '')
{
    try {
        // Check if the table exists
        $stmt = $this->db->prepare("SHOW TABLES LIKE :table");
        $stmt->bindParam(':table', $table, PDO::PARAM_STR);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            // Prepare and execute the delete statement
            $deleteStmt = $this->db->prepare("DELETE FROM $table WHERE $primary = :id");
            $deleteStmt->bindParam(':id', $id, PDO::PARAM_INT);
            $deleteStmt->execute();
        }
    } catch (Exception $e) {
        throw new Exception("Failed to delete relationship: " . $e->getMessage());
    }
}




public function getDishes($dish_id = 0)
{
    $data = array();
    $stmt = "
    SELECT 
    a.dish_id,
    a.dish_name,
    a.photo,
    a.status,
    IFNULL(b.language, 'default') as language,
    IFNULL(b.dish_name, '') as dish_name_trans
    
    FROM mt_dishes a
    LEFT JOIN mt_dishes_translation b
    ON a.dish_id = b.dish_id
    
    WHERE a.dish_id = :dish_id
    ";

    // Assuming $this->db is the PDO connection object
    $query = $this->db->prepare($stmt);
    $query->bindParam(':dish_id', $dish_id, PDO::PARAM_INT);
    $query->execute();
    
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {
            $data[$val['language']] = array(
                'dish_id' => $val['dish_id'],
                'dish_name' => $val['language'] == "default" ? $val['dish_name'] : $val['dish_name_trans'],
                'photo' => $val['photo'],
                'status' => $val['status'],
            );
        }
        return $data;
    }
    
    return false;
}



public function GetCuisine($id = '')
{
    // Prepare the SQL statement with a placeholder for the parameter
    $stmt = "SELECT * FROM mt_cuisine WHERE cuisine_id = :id LIMIT 1";

    try {
        // Prepare the query
        $query = $this->db->prepare($stmt);

        // Bind the parameter to the query
        $query->bindValue(':id', $id, PDO::PARAM_INT);

        // Execute the query
        $query->execute();

        // Fetch the result
        $result = $query->fetch(PDO::FETCH_ASSOC);

        // Return the result or false if no result
        return $result ? $result : false;

    } catch (PDOException $e) {
        // Handle any exceptions (e.g., log the error)
        error_log($e->getMessage());
        return false;
    }
}

public function currencyPosition()
    {
        return array(
           'left'=>("Left"),
           'right'=>("Right"),
        );
    } 


    public function getLanguageList($aslist=true)
  {
    
      $list[0]="Please select";
      $list[1]="en";
              
        return $list;
        
  }


    public function updateOptionAdmin($option_name = '', $option_value = '')
{
    // Prepare the database connection
    $db = $this->db;

    // Prepare the SELECT statement
    $stmt = $db->prepare("SELECT * FROM mt_option WHERE option_name = :option_name AND merchant_id = 0");
    $stmt->execute([':option_name' => $option_name]);

    // Fetch the results
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Prepare parameters for the INSERT/UPDATE operation
    $params = [
        'option_name'  => addslashes($option_name),
        'option_value' => addslashes($option_value)
    ];

    if (is_array($rows) && count($rows) >= 1) {
        // If the option exists, update it
        $option_id = $rows[0]['id'];
        
        $update_stmt = $db->prepare("UPDATE mt_option SET option_name = :option_name, option_value = :option_value WHERE id = :id");
        $res = $update_stmt->execute([
            ':option_name'  => $params['option_name'],
            ':option_value' => $params['option_value'],
            ':id'           => addslashes($option_id)
        ]);
        
        if ($res) {
            return true;
        }
    } else {
        // If the option doesn't exist, insert it
        $insert_stmt = $db->prepare("INSERT INTO mt_option (option_name, option_value) VALUES (:option_name, :option_value)");
        $res = $insert_stmt->execute($params);
        
        if ($res) {
            return true;
        }
    }

    return false;
}





    public function decimalPlacesList()
    {
        $numbers=array();
        for ($x=0; $x<=10; $x++) {            
            $numbers[$x]=$x;
        } 
        return $numbers;
    } 

public function currencyList()
{
    $data_feed = array();
    
    // Prepare the SQL statement
    $stmt = "
        SELECT * 
        FROM mt_currency
        ORDER BY currency_code ASC
    ";
    
    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->execute();
    
    // Fetch all results
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);
    
    // Check if rows are returned and process them
    if (is_array($rows) && count($rows) >= 1) {
        $data_feed[] = "";
        foreach ($rows as $val) {
            $data_feed[$val['currency_code']] = $val['currency_code'];
        }
        return $data_feed;
    }
    
    return false;
}



  public function getRatingInfo($id = '') {
    // Prepare the PDO connection
    $stmt = $this->db->prepare("SELECT * FROM mt_rating_meaning WHERE id = :id LIMIT 1");

    // Bind the parameter to prevent SQL injection
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    // Execute the query
    if ($stmt->execute()) {
        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // Return the first result if found, otherwise return false
        if ($res) {
            return $res;
        }
    }

    return false;
}

public function getCurrencyDetails($currency_code = '')
{
    $pdo = $this->db; // Use the PDO instance from the new MVC structure
    
    $stmt = $pdo->prepare("SELECT * FROM mt_currency WHERE currency_code = :currency_code LIMIT 1");
    $stmt->bindParam(':currency_code', $currency_code);
    
    $stmt->execute();
    
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($result) {
        return $result;
    }
    
    return false;
}


public function getCurrencyDetailsByID($id = '')
{
    // Prepare the SQL query
    $stmt = $this->db->prepare("SELECT * FROM mt_currency WHERE id = :id LIMIT 1");
    
    // Bind the parameter
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Return the result or false if no data
    return $res !== false ? $res : false;
}







   public function clientStatus()
{
    return array(
      'pending'=>$this->translation("default",'pending for approval'),
     'active'=>$this->translation("default",'active'),   
     'suspended'=>$this->translation("default",'suspended'),
     'blocked'=>$this->translation("default",'blocked'),
     'expired'=>$this->translation("default",'expired')
    );
}


    public function Services()
    {
        return array(
          1=>$this->translation("default","Delivery & Pickup"),
          2=>$this->translation("default","Delivery Only"),
          3=>$this->translation("default","Pickup Only"),
          4=>$this->translation("default","Delivery / Pickup / Dinein"),
          5=>$this->translation("default","Delivery & Dinein"),
          6=>$this->translation("default","Pickup & Dinein"),
          7=>$this->translation("default","Dinein Only")
        );
    }

    public function distanceOption()
    {
        return array(
           'mi'=>$this->translation("default","Miles"),
           'km'=>$this->translation("default","Kilometers")
        );
    }   


    public  function getMerchant($merchant_id = '')
{
    // Assuming $this->db is a PDO instance
    $stmt = "
    SELECT a.*,
    (
        SELECT GROUP_CONCAT(option_value)
        FROM mt_option
        WHERE merchant_id = a.merchant_id
        AND option_name = 'tags'
    ) as tag_id
    FROM mt_merchant a
    WHERE merchant_id = :merchant_id
    LIMIT 1";
    
    // Prepare the query using the existing PDO connection ($this->db)
    $query = $this->db->prepare($stmt);
    
    // Bind the merchant_id parameter to avoid SQL injection
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Fetch the result as an associative array
    $res = $query->fetch(PDO::FETCH_ASSOC);
    
    // Check if a result was found
    if ($res) {
        // Strip slashes from the result
        return array_map('stripslashes', $res);
    }
    
    return false; // No result found
}



 public function hasAddressBook($client_id='', $type="location")
{
    try {
        // Prepare the base query based on the type
        if ($type == "address") {
            $stmt = $this->db->prepare("SELECT * FROM mt_address_book WHERE client_id = :client_id LIMIT 1");
        } else {
            $stmt = $this->db->prepare("SELECT * FROM mt_address_book_location WHERE client_id = :client_id LIMIT 1");
        }

        // Bind the client_id parameter
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);

        // Execute the statement
        $stmt->execute();

        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result or false if no record found
        if ($res) {
            return $res;
        } else {
            return false;
        }
    } catch (PDOException $e) {
        // Handle any potential PDO exceptions
        return false;
    }
}


public function adminCountry()
    {
        $admin_country_set=$this->getOptionAdmin('admin_country_set');
        $country_list=$this->CountryList();
        $country='';
        if (array_key_exists($admin_country_set,(array)$country_list)){
            $country=$country_list[$admin_country_set];
        } else $country=$admin_country_set;
        return $country;
    }



public function getMapProvider()
  {
    $map_provider = $this->getOptionAdmin('map_provider');
    $token = ''; $map_api = '';
    $map_distance_results  = ''; $mode = "driving";
    
    if(empty($map_provider)){
      $map_provider='google.maps';
    }
    
    switch ($map_provider) {
      case "mapbox":
        $token = $this->getOptionAdmin('mapbox_access_token');       
        $map_api = $token;
        $mode = $this->getOptionAdmin('mapbox_method');
        break;

      case "google.maps": 
          $token = $this->getOptionAdmin('google_geo_api_key');
          $map_api = $this->getOptionAdmin('google_maps_api_key');
          $mode = $this->getOptionAdmin('google_distance_method');
      default:
        break;
    }
    
    $map_distance_results = (integer) $this->getOptionAdmin('map_distance_results');
    if($map_distance_results<0){
      $map_distance_results=2;
    }
        
    return array(     
      'provider'=>$map_provider,
      'token'=>$token,
      'map_api'=>$map_api,
      'map_distance_results'=>$map_distance_results,
      'mode'=>$mode
    );
  }


  public function getMapProvider_mobileapp($device_platform)
  {
    $map_provider = $this->getOptionAdmin('map_provider');
    $token = ''; $map_api = '';
    $map_distance_results  = ''; $mode = "driving";
    
    if(empty($map_provider)){
      $map_provider='google.maps';
    }
    
    switch ($map_provider) {
      case "mapbox":
        $token = $this->getOptionAdmin('mapbox_access_token');       
        $map_api = $token;
        $mode = $this->getOptionAdmin('mapbox_method');
        break;

      case "google.maps": 


          if($device_platform=="android"){
          $token = $this->getOptionAdmin('google_geo_api_key_android');
          $map_api = $this->getOptionAdmin('google_geo_api_key_android');
         }else{
            $token = $this->getOptionAdmin('google_geo_api_key_ios');
          $map_api = $this->getOptionAdmin('google_geo_api_key_ios'); 
         }


          $mode = $this->getOptionAdmin('google_distance_method');
      default:
        break;
    }
    
    $map_distance_results = (integer) $this->getOptionAdmin('map_distance_results');
    if($map_distance_results<0){
      $map_distance_results=2;
    }
        
    return array(     
      'provider'=>$map_provider,
      'token'=>$token,
      'map_api'=>$map_api,
      'map_distance_results'=>$map_distance_results,
      'mode'=>$mode
    );
  }


  public function getMapProvider_merchant($merchant_id)
  {
    $map_provider = $this->getOptionAdmin('map_provider');
    $token = ''; $map_api = '';
    $map_distance_results  = ''; $mode = "driving";
    
    if(empty($map_provider)){
      $map_provider='google.maps';
    }
    
    switch ($map_provider) {
      case "mapbox":
        $token = $this->getOptionAdmin('mapbox_access_token');       
        $map_api = $token;
        $mode = $this->getOptionAdmin('mapbox_method');
        break;

      case "google.maps": 
          $token = $this->getOptionAdmin('google_geo_api_key');
          //$map_api = $this->getOptionAdmin('google_maps_api_key');

          $map_api = $this->getOption('google_map_api_key',$merchant_id);
          $token=$map_api;
          $mode = $this->getOptionAdmin('google_distance_method');
      default:
        break;
    }
    
    $map_distance_results = (integer) $this->getOptionAdmin('map_distance_results');
    if($map_distance_results<0){
      $map_distance_results=2;
    }
        
    return array(     
      'provider'=>$map_provider,
      'token'=>$token,
      'map_api'=>$map_api,
      'map_distance_results'=>$map_distance_results,
      'mode'=>$mode
    );
  }



 public function getMapProvider_merchant_platform($merchant_id,$plats_form='android')
  {
    $map_provider = $this->getOptionAdmin('map_provider');
    $token = ''; $map_api = '';
    $map_distance_results  = ''; $mode = "driving";
    
    if(empty($map_provider)){
      $map_provider='google.maps';
    }
    
    switch ($map_provider) {
      case "mapbox":
        $token = $this->getOptionAdmin('mapbox_access_token');       
        $map_api = $token;
        $mode = $this->getOptionAdmin('mapbox_method');
        break;

      case "google.maps": 
         // $token = $this->getOptionAdmin('google_geo_api_key');
          //$map_api = $this->getOptionAdmin('google_maps_api_key');

		if($plats_form=='android' || $plats_form=='Android'  ){
          $map_api = $this->getOption('google_map_api_key_android',$merchant_id);
		}else{		  
		  $map_api = $this->getOption('google_map_api_key_ios',$merchant_id);
		}
		  
		  
		  
          $token=$map_api;
          $mode = $this->getOptionAdmin('google_distance_method');
      default:
        break;
    }
    
    $map_distance_results = (integer) $this->getOptionAdmin('map_distance_results');
    if($map_distance_results<0){
      $map_distance_results=2;
    }
        
    return array(     
      'provider'=>$map_provider,
      'token'=>$token,
      'map_api'=>$map_api,
      'map_distance_results'=>$map_distance_results,
      'mode'=>$mode
    );
  }




  public  function getMerchantDeliveryFee($merchant_id='',$fee='',$distance='',$unit='')
    {
        //$distance=!empty($distance)?number_format($distance,3):0;     
        $distance=is_numeric($distance)?number_format($distance,3):0; 
        $shipping_enabled=$this->getOption('shipping_enabled',$merchant_id);       
        $charge=$fee;
        if ( $shipping_enabled==2){
           
            $charge=$this->getDeliveryChargesByDistance(
              $merchant_id,
              $distance,
              $unit,
              $fee
            );
        }       
        
        if ($unit=="ft" || $unit=="mm" || $unit=="mt"){
            if ($fee>0){
                return $fee;
            }
            return false;
        }
        
        if ($charge>0){
            return $charge;
        }
        return false;
    }


     public  function getDistanceBetweenPlot($lat1, $lon1, $lat2, $lon2, $unit)
    {
          
          if(empty($lat2) && empty($lon2)){
              return false;
          }
          if(empty($lat1) && empty($lon1)){
              return false;
          }
          
          
          
          
                          
         
          
          $units_params='';
          
          switch ($unit) {
            case "M":
            case "Miles":
                $units_params='imperial';
                break;
          
            default:
                $units_params='metric';
                break;
          }
          
          $method=$this->getOptionAdmin('google_distance_method');
          $use_curl=$this->getOptionAdmin('google_use_curl');
          
          $protocol = isset($_SERVER["https"]) ? 'https' : 'http';
          $key=$this->getOptionAdmin('google_geo_api_key');
          
          //dump($method);
          
          if ($method=="driving" || $method=="transit"){
             $url="https://maps.googleapis.com/maps/api/distancematrix/json";
             $url.="?origins=".urlencode("$lat1,$lon1");
             $url.="&destinations=".urlencode("$lat2,$lon2");
             $url.="&mode=".urlencode($method);       
             $url.="&units=".urlencode($units_params);
             if(!empty($key)){
                $url.="&key=".urlencode($key);
             }
             
             if(isset($_GET['debug'])){
                //dump($url);
             }
             
             if ($use_curl==2){
                $data = $this->Curl($url);
             } else $data = @file_get_contents($url);   
             $data = json_decode($data);  
                         
             if (is_object($data)){
                if ($data->status=="OK"){ 
                    if($data->rows[0]->elements[0]->status=="ZERO_RESULTS"){
                        return false;
                    }
                    if($data->rows[0]->elements[0]->status=="NOT_FOUND"){
                        return false;
                    }                   
                                    
                    $distance=0;                                        
                    $text  = $data->rows[0]->elements[0]->distance->text;
                    $value = $data->rows[0]->elements[0]->distance->value;                      
                                                
                    if($unit=="M"){                     
                        $distance= (integer) $value*0.000621371192;
                    } else $distance= (integer) $value*0.001;
                                        
                    $distance = number_format($distance,1,'.',''); 
                    
                    if($distance<=0){                                       
                        if($unit=="M"){
                            $unit='ft';
                        } else $unit='m';
                    }
                    
                    $this->distance_type_result = $unit;     
                    
                    return $distance;           
                                        
                } elseif ( $data->status=="OVER_QUERY_LIMIT" ) {
                    return 0;
                }            
             }
             return false;
          }
          
          if (empty($lat1)){ return false; }
          if (empty($lon1)){ return false; }
          
          $theta = $lon1 - $lon2;
          $dist = sin(deg2rad($lat1)) * sin(deg2rad($lat2)) +  cos(deg2rad($lat1)) * cos(deg2rad($lat2)) * cos(deg2rad($theta));
          $dist = acos($dist);
          $dist = rad2deg($dist);
          $miles = $dist * 60 * 1.1515;
          $unit = strtoupper($unit);
        
          if ($unit == "K") {
              return ($miles * 1.609344);
          } else if ($unit == "N") {
              return ($miles * 0.8684);
          } else {
              return $miles;
          }
    }



     public function getDeliveryChargesByDistance($mtid='',$distance='',$unit='',$delivery_fee='')
    {       
        //$distance=round($distance);
        switch (strtolower($unit)){
            case "miles":    
            case "mi":  
            case "m":
                $unit='mi';
                break;
            case "kilometers":      
            case "km":      
            case "k":
                $unit='km';
                break;
            case "ft":  
                $unit='mi';
                $distance=1;
                break;
        }
        //dump($mtid);
        //dump($distance);
        //dump($unit);
        $charge=$delivery_fee;
        if ( $res=$this->getShippingRates($mtid,$unit)){            
            foreach ($res as $val) {                                                
                if ( $val['distance_from']<=$distance && $val['distance_to']>=$distance){
                    //dump($val);
                    $charge=$val['distance_price'];
                }
            }
        }
        return $charge;
    }

 



public function getMerchantxxx($merchant_id = '')
{
    // Initialize database connection
    $db = $this->db;  // Assuming $this->db is your PDO connection

    // Prepare SQL statement with placeholder
    $stmt = "
        SELECT a.*,
        (
            SELECT title
            FROM mt_packages
            WHERE package_id = a.package_id
            LIMIT 1
        ) AS package_name
        FROM mt_merchant a
        WHERE merchant_id = :merchant_id
        LIMIT 1
    ";

    try {
        // Prepare and execute the statement
        $query = $db->prepare($stmt);
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->execute();

        // Fetch the result
        $result = $query->fetch(PDO::FETCH_ASSOC);
        
        // Return the result if found
        if ($result) {
            return $result;
        }
    } catch (PDOException $e) {
        // Handle database errors
        error_log("Database query error: " . $e->getMessage());
    }

    // Return false if no result or on error
    return false;
}

public function getCreditCardInfo($client_id = '', $id = '')
{
    $pdo = $this->db; // Assuming $this->db is your PDO connection instance

    $stmt = "
        SELECT * 
        FROM mt_client_cc
        WHERE
        cc_id = :cc_id
        AND
        client_id = :client_id
        LIMIT 1
    ";

    $query = $pdo->prepare($stmt);
    $query->bindParam(':cc_id', $id, PDO::PARAM_INT);
    $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res ? $res : false;
    }

    return false;
}




public function getMerchantID()
    {
        if (!empty($_SESSION['kr_merchant_user'])){
            $user=json_decode($_SESSION['kr_merchant_user']);           
            if (is_array($user) && count($user)>=1){
                return $user[0]->merchant_id;
            }
        }
        return false;
    }  

    function initialStatus()
{
    return 'initial_order';
} 

public function websiteUrl()
{
  return Config::$baseUrl;
}

 public function tipsList($list=false)
    {
      if ( $list==true){
        return array(
           ''=>("none"),
           '0.1'=>"10%",
           '0.15'=>"15%",
           '0.2'=>"20%",
           '0.25'=>"25%"         
          );
      } else {
        return array(
           '0.1'=>"10%",
           '0.15'=>"15%",
           '0.2'=>"20%",
           '0.25'=>"25%"         
        );
      }
    }


public function getReviewsById2($id = '', $merchant_id = '')
{
    // Prepare SQL statement with placeholders
    $stmt = "SELECT * FROM mt_review WHERE id = :id AND merchant_id = :merchant_id LIMIT 1";

    // Prepare the statement using PDO
    $stmt = $this->db->prepare($stmt);

    // Bind parameters
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        return $res[0]; // Return the first result if available
    }
    return false; // Return false if no results found
}


public function getMerchantCommission($merchant_id = '')
{
    $stmt = "
        SELECT * FROM mt_merchant
        WHERE merchant_id = :merchant_id
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);
    
    // Bind the parameter
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();

    // Fetch the result
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res['percent_commision']; // Return the 'percent_commision' column value
    }

    return false; // Return false if no result found
}


public function getMerchantCommissionDetails($merchant_id = '')
{
    $stmt = "
        SELECT * FROM mt_merchant
        WHERE merchant_id = :merchant_id
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);
    
    // Bind the parameter
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();

    // Fetch the result
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return array(
            'is_commission' => $res['is_commission'],
            'commision_type' => $res['commision_type'],
            'percent_commision' => $res['percent_commision']
        );
    }

    return false; // Return false if no result found
}


public function getMerchantCommissionOffline($merchant_id = '')
{
    $stmt = "
        SELECT * FROM mt_merchant
        WHERE merchant_id = :merchant_id
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);
    
    // Bind the parameter
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();

    // Fetch the result
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res['offline_percent_commision']; // Return the 'offline_percent_commision' column value
    }

    return false; // Return false if no result found
}


public function getMerchantCommissionDetailsOffline($merchant_id = '')
{
    $stmt = "
        SELECT * FROM mt_merchant
        WHERE merchant_id = :merchant_id
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);
    
    // Bind the parameter
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();

    // Fetch the result
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return array(
            'is_commission' => $res['is_commission'],
            'commision_type' => $res['offline_commision_type'],
            'percent_commision' => $res['offline_percent_commision']
        );
    }

    return false; // Return false if no result found
}
 


  



 public function formatAsChart($data='')
    {
      $chart_data='';
      if (is_array($data) && count($data)>=1){
        foreach ($data as $key => $val) {
          $key=addslashes($key);
          $chart_data.="[\"$key\",$val],";
        }
        $chart_data=substr($chart_data,0,-1);
        return "[[$chart_data]]";
      } 
      return "[[0]]";
    }    


public function getMerchantUserName()
  {
    if (!empty($_SESSION['kr_merchant_user'])){
      $user=json_decode($_SESSION['kr_merchant_user'],true);      
      //dump($user);
      if (is_array($user) && count($user)>=1){
        //return ucwords($user[0]->contact_name);
        if (isset($user[0]['first_name'])){
          return $user[0]['first_name'];
        } else return $user[0]['contact_name'];
      }
    }
    return false;
  }




 public function orderHistory($order_id = '')
{
    // Assuming $this->db is your PDO connection
    $db = $this->db;

    // Prepare the SQL query
    $stmt = $db->prepare("
        SELECT * FROM mt_order_history
        WHERE order_id = :order_id
        ORDER BY id ASC
    ");
    
    // Bind the order_id parameter
    $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch the results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Return the results or false if no records are found
    return !empty($res) ? $res : false;
}


public function getCommissionOrderStatsArray()
    {
      $total_commission_status=$this->getOptionAdmin('total_commission_status');
    if (!empty($total_commission_status)){
      $total_commission_status=json_decode($total_commission_status);
    } else {
      $total_commission_status=array('paid');
    }     
      /*$status='';
      if (is_array($total_commission_status) && count($total_commission_status)>=1){
        foreach ($total_commission_status as $val) {          
          $status.="'$val',";
        }
        $status=substr($status,0,-1);
      } else $status="'paid'";*/
      
      return $total_commission_status;
    }


    


    public function getCommissionOrderStats()
    {
        $total_commission_status=$this->getOptionAdmin('total_commission_status');
        if (!empty($total_commission_status)){
            $total_commission_status=json_decode($total_commission_status);
        } else {
            $total_commission_status=array('paid');
        }       
        $status='';
        if (is_array($total_commission_status) && count($total_commission_status)>=1){
            foreach ($total_commission_status as $val) {                
                //$status.="'$val',";
               $status .= "'" . $val . "',";
            }
            $status=substr($status,0,-1);
        } else $status="'paid'";
        
        return $status;
    }






    public function getTotalCommissionToday()
{
    /* Custom code 1 starts */
    $total_commission_status = $this->getOptionAdmin('total_commission_status');
    if (!empty($total_commission_status)) {
        $total_commission_status = json_decode($total_commission_status);
    } else {
        $total_commission_status = array('paid');
    }

    // Prepare status values for SQL IN clause
    $status = '';
    if (is_array($total_commission_status) && count($total_commission_status) >= 1) {
        foreach ($total_commission_status as $key => $val) {
            $status .= ":status_$key,";
        }
        $status = substr($status, 0, -1);
    } else {
        $status = "'paid'";
    }

    $start_date = date("Y-m-d");
    $end_date = date("Y-m-d");

    // Construct the SQL query dynamically
    $sql = "
        SELECT SUM(total_commission) AS total_commission
        FROM mt_order
        WHERE request_from <> 'POS' AND status IN ($status)
        AND date_created BETWEEN :start_date AND :end_date
    ";

    // Add exclusion clause conditionally
    if ($this->getOptionAdmin('admin_exclude_cod_balance') == 2) {
        $sql .= " AND payment_type NOT IN ('cod','pyr','ccr')";
    }

    // Prepare the SQL statement
    $stmt = $this->db->prepare($sql);

    // Bind parameters for the status values
    if (is_array($total_commission_status) && count($total_commission_status) >= 1) {
        foreach ($total_commission_status as $key => $val) {
            $stmt->bindValue(":status_$key", $val, PDO::PARAM_STR);
        }
    } else {
        $stmt->bindValue(':status_0', 'paid', PDO::PARAM_STR);
    }

    // Bind date range parameters
    $stmt->bindValue(':start_date', "$start_date 00:00:00", PDO::PARAM_STR);
    $stmt->bindValue(':end_date', "$end_date 23:59:59", PDO::PARAM_STR);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the total commission or default value
    if ($res) {
        return $res['total_commission'] ?: 0;
    }

    return false;
    /* Custom code 1 Ends */
}



 public function getTotalCommissionLast()
{
    // Get total commission status from admin options
    $total_commission_status = $this->getOptionAdmin('total_commission_status');
    if (!empty($total_commission_status)) {
        $total_commission_status = json_decode($total_commission_status);
    } else {
        $total_commission_status = array('paid');
    }

    // Prepare the status list for the query
    $status = '';
    if (is_array($total_commission_status) && count($total_commission_status) >= 1) {
        foreach ($total_commission_status as $val) {
            $status .= $this->db->quote($val) . ",";
        }
        $status = rtrim($status, ",");
    } else {
        $status = "'paid'";
    }

    // Date range for the last 30 days
    $end_date = date("Y-m-d");
    $start_date = date('Y-m-d', strtotime('-30 days'));
    $and = " AND date_created BETWEEN " . $this->db->quote("$start_date 00:00:00") . " AND " . $this->db->quote("$end_date 23:59:00");

    // Exclude specific payment types if the option is set
    if ($this->getOptionAdmin('admin_exclude_cod_balance') == 2) {
        $and .= " AND payment_type NOT IN ('cod','pyr','ccr')";
    }

    // Prepare and execute the query
    $stmt = $this->db->prepare("
        SELECT SUM(total_commission) AS total_commission
        FROM mt_order
        WHERE request_from <> 'POS' AND status IN ($status)
        $and
    ");
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($res) {
        return !empty($res['total_commission']) ? $res['total_commission'] : 0;
    }

    return false;
}












    public function generateRandomKey($range=10) 
    {
        $chars = "0123456789";  
        srand((double)microtime()*1000000); 
        $i = 0; 
        $pass = '' ;    
        while ($i <= $range) {
            $num = rand() % $range; 
            $tmp = substr($chars, $num, 1); 
            $pass = $pass . $tmp;   
            $i++;   
        }
        return $pass;
    }

    public function isAdminLogin()
    {                       
        $is_login=FALSE;                
        /*if (!empty($_COOKIE['kr_user'])){
            $user=json_decode($_COOKIE['kr_user']);                                 
            if (is_numeric($user[0]->admin_id)){
                $is_login=TRUE;
            }
        }*/             
        if ($this->validateAdminSession()){
            return true;
        }           
        return false;
    }

public function validateAdminSession()
{
    $this->has_session = false;
    
    if (isset($_SESSION['kr_user_session'])) {
        $allowed = $this->getOptionAdmin('website_admin_mutiple_login');
        
        if ($allowed == "") {
            if (empty($_SESSION['kr_user_session'])) {
                return false;
            }
            return true;
        }
        
        $admin_id = $this->getAdminId();
        $kr_user_session = $_SESSION['kr_user_session'];
        
        // Prepare the statement using PDO
        $stmt = $this->db->prepare("
            SELECT session_token
            FROM mt_admin_user
            WHERE admin_id = :admin_id
            LIMIT 1
        ");
        $stmt->bindValue(':admin_id', $admin_id, PDO::PARAM_INT);
        $stmt->execute();
        
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($res) {
            if ($kr_user_session == $res['session_token']) {
                return true;
            }
            $this->has_session = true;
        }
    }
    
    return false;
}


    public function getAdminId()
    {
        if (!empty($_SESSION['kr_user'])){
            $user=json_decode($_SESSION['kr_user']);                                    
            if (is_numeric($user[0]->admin_id)){
                return $user[0]->admin_id;
            }
        }
        return false;
    }  

    public function AAccess()
    {
        $info=$this->getAdminInfo();        
        if (is_object($info)){
            $access=!empty($info->user_access)?json_decode($info->user_access):false;
            if ($access!=false){
                //return $access;
                return array_map('strtolower', $access);
            }
        }
        return false;
    }

    public function getAdminInfo()
    {
        /*if (!empty($_COOKIE['kr_user'])){
            $user=json_decode($_COOKIE['kr_user']);                                 
            if (is_numeric($user[0]->admin_id)){
                return $user[0];
            }
        }*/     
        if (!empty($_SESSION['kr_user'])){
            $user=json_decode($_SESSION['kr_user']);                                    
            if (is_numeric($user[0]->admin_id)){
                return $user[0];
            }
        }
        return false;
    }

    public function translation($param='',$word=''){

        return $word;

    }

  public function prettyCC($card='')
    {
        if(!empty($card)){
            if(strlen($card)>=16){
            $format = substr($card,0,4)." ";
            $format.= substr($card,4,4)." ";
            $format.= substr($card,8,4)." ";
            $format.= substr($card,12,4);
            return $format;
            } else return $card;
        }
        return $card;
    }

    public function maskCardnumber($cardnumber='')
    {
        if ( !empty($cardnumber)){
            return substr($cardnumber,0,4)."XXXXXXXX".substr($cardnumber,-4,4);
        }
        return '';
    }

  


    public function getPaypalOrderPayment($order_id = '')
{
    $pdo = $this->db; // Assuming $this->db is your PDO connection instance

    $stmt = "
        SELECT * 
        FROM mt_paypal_payment
        WHERE
        order_id = :order_id
        LIMIT 1
    ";

    $query = $pdo->prepare($stmt);
    $query->bindParam(':order_id', $order_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res ? $res : false;
    }

    return false;
}



    public static function prettyPaymentType($transaction_type = '', $payment_code = '', $data = '', $trn_type = '')
{
    $payment_prefix = '';

    // Handle payment code based on transaction type
    switch ($trn_type) {
        case "dinein":
            if ($payment_code == "cod") {
                $payment_code = "pay_in_person";
            }
            break;

        case "pickup":
            if ($payment_code == "cod") {
                $payment_code = "cash_pickup";
            }
            break;

        default:
            break;
    }

    // Check for 'mol' payment code
    $transaction_type="mt_".$transaction_type;
    if ($payment_code == "mol") {
        switch ($transaction_type) {
            case "payment_order":
                $stmt = $this->db->prepare("
                    SELECT raw_response 
                    FROM $transaction_type
                    WHERE order_id = :order_id 
                    LIMIT 1
                ");
                $stmt->bindValue(':order_id', $data, PDO::PARAM_INT);
                $stmt->execute();
                $res = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($res) {
                    $details = json_decode($res['raw_response'], true);
                    if (is_array($details) && count($details) >= 1) {
                        $payment_prefix = "-" . strtoupper(t($details['method']));
                    }
                }
                break;

            case "package_trans":
                $stmt = $this->db->prepare("
                    SELECT id, payment_type, PAYPALFULLRESPONSE 
                    FROM mt_package_trans 
                    WHERE id = :id 
                    ORDER BY id DESC 
                    LIMIT 1
                ");
                $stmt->bindValue(':id', $data, PDO::PARAM_INT);
                $stmt->execute();
                $res = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($res) {
                    $details = json_decode($res['PAYPALFULLRESPONSE'], true);
                    if (is_array($details) && count($details) >= 1) {
                        $payment_prefix = "-" . strtoupper(t($details['method']));
                    }
                }
                break;

            case "sms_package_trans":
                $stmt = $this->db->prepare("
                    SELECT id, payment_gateway_response 
                    FROM mt_sms_package_trans 
                    WHERE id = :id 
                    ORDER BY id DESC 
                    LIMIT 1
                ");
                $stmt->bindValue(':id', $data, PDO::PARAM_INT);
                $stmt->execute();
                $res = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($res) {
                    $details = json_decode($res['payment_gateway_response'], true);
                    if (is_array($details) && count($details) >= 1) {
                        $payment_prefix = "-" . strtoupper(t($details['method']));
                    }
                }
                break;

            default:
                break;
        }

        return strtoupper(($payment_code)) . $payment_prefix;
    } else {
        return strtoupper(($payment_code));
    }
}





    public function FormatDateTime($date='',$time=true)
    {
        if ($date=="0000-00-00"){
            return ;
        }    
        if ($date=="0000-00-00 00:00:00"){
            return ;
        }
        if ( !empty($date)){            
            $date_f=$this->getOptionAdmin("website_date_format");
            $time_f=$this->getOptionAdmin("website_time_format");               
            if (!empty($date_f)){
                if ( $time==TRUE){
                    $date_ouput = date("$date_f $time_f",strtotime($date)); 
                } else $date_ouput = date("$date_f",strtotime($date));                  
                return $this->translateDate($date_ouput);
            } else {
                if ( $time==TRUE){
                    $date_ouput= date('M d,Y G:i:s',strtotime($date));  
                } else $date_ouput= date('M d,Y',strtotime($date)); 
                return $this->translateDate($date_ouput);
            }
        }
        return false;
    }


    public function translateFoodItemByOrderId_x($order_id = '', $lang_key = 'kr_lang_id')
{
    $translated_item = '';
    $trans = [];

    // Assuming $this->db is your PDO instance initialized in your base model
    $stmt = $this->db->prepare("
        SELECT a.*, b.item_name_trans
        FROM mt_order_details a
        LEFT JOIN mt_item b ON a.item_id = b.item_id
        WHERE order_id = :order_id
        ORDER BY a.id ASC
    ");

    $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);
    $stmt->execute();

    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $trans['item_name_trans'] = !empty($val['item_name_trans']) ? json_decode($val['item_name_trans'], true) : '';
            $translated_item .= $this->qTranslate(
                $val['item_name'], 
                'item_name', 
                (array)$trans,
                $lang_key
            ) . ",";
        }
        $translated_item = !empty($translated_item) ? substr($translated_item, 0, -1) : $translated_item;
        return $translated_item;
    }
    return '';
}


public  function translateFoodItemByOrderId($order_id = '', $lang_key = 'kr_lang_id')
{
    $translated_item = ''; 
    $trans = [];
    
    // Prepare the SQL query with placeholders for parameters
    $stmt = "
        SELECT a.*, b.item_name
        FROM mt_order_details a
        LEFT JOIN mt_item b ON a.item_id = b.item_id
        WHERE order_id = :order_id
        ORDER BY id ASC
    ";

    // Use PDO to prepare the statement
    $query = $this->db->prepare($stmt);
    
    // Bind the parameters
    $query->bindParam(':order_id', $order_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the results
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        //print_r($res);die();
        
        // Loop through the results and build the translated item string
        foreach ($res as $val) {
            // Decode the item_name_trans JSON if it exists
            $trans['item_name_trans'] = !empty($val['item_name_trans']) ? json_decode($val['item_name_trans'], true) : '';
            
            // Call the qTranslate method and append the result
            $translated_item .= $this->qTranslate(
                $val['item_name'], 'item_name', (array)$trans, $lang_key
            ) . ",";
        }
        
        // Remove the trailing comma if any
        $translated_item = !empty($translated_item) ? rtrim($translated_item, ',') : $translated_item;
        
        return $translated_item;
    }
    
    return '';
}




function qTranslate($text,$key,$data,$cookie_lang_id='')
{       

    return stripslashes($text);
    
    if ( $this->getOptionAdmin("enabled_multiple_translation")!=2){
        return stripslashes($text);
    }
    $key=$key."_trans";             
    $id='en';   
    //dump($text);dump($key); dump($data);
    if(!empty($id)){
        if (is_array($data) && count($data)>=1){
            if (isset($data[$key])){                    
                if (array_key_exists($id,(array)$data[$key])){
                    if (!empty($data[$key][$id])){                          
                        //return stripslashes($data[$key][$id]);                        
                        return (stripslashes($data[$key][$id]));
                    }
                }
            }
        }
    }           
    return (stripslashes($text));
    //return stripslashes($text);
}


  public function chktoemail($order_id='')  
{   
    // Prepare the SQL statement with a placeholder for the order_id
    $stmt = "SELECT * FROM mt_email_logs WHERE order_id = :order_id LIMIT 0, 1";
    
    // Prepare the query using PDO
    $query = $this->db->prepare($stmt);
    
    // Bind the order_id parameter
    $query->bindParam(':order_id', $order_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Check if a record is found
    if ($query->rowCount() > 0) {
        return '1';
    }
    
    return '0';
}

public function formatOrderNumber($order_id='')
    {
        //return str_pad($order_id,10,"0");
        return $order_id;
    }

    public  function isApplyTax($merchant_id='')
    {
        $apply_tax = $this->getOption('merchant_apply_tax',$merchant_id);
        $euro_tax = $this->getMerchantTax($merchant_id);
        if ( $apply_tax==1 && $euro_tax>0.0001){
            return $euro_tax;
        }
        return false;
    }


    public  function inventoryEnabled($merchant_id='')
    {   

        
        if(empty($merchant_id)){
            return false;
        }   
        if(!is_numeric($merchant_id)){
            return false;
        }   
        
        $inv_enabled = false; 
        
            
                $inventory_live = $this->getOption('inventory_live',$merchant_id);
                if($inventory_live==1){
                    $inv_enabled = true;
                     
                }
            
        
        return $inv_enabled;
    }







    public function translateDate($date='')
    {               
        $translate=$this->dateTranslation();        
        foreach ($translate as $key=>$val) {            
            $date=str_replace($key,$val,$date);
        }
        return $date;
    }


    public function getReceiptByID($order_id = 0, $client_id = 0)
{
    $pdo = $this->db; // Assuming $this->db is your PDO connection instance
    $and = '';
    $order_id = (int)$order_id;
    $client_id = (int)$client_id;

    if ($client_id > 0) {
        $and = " AND a.client_id = :client_id";
    }

    $stmt = "
        SELECT a.*, b.contact_email as email_address,
        b.contact_email as customer_email,
        concat(b.first_name, ' ', b.last_name) as full_name,
        b.location_name,
        concat(b.street, ' ', b.area_name, ' ', b.city, ' ', b.state, ' ', b.zipcode) as full_address,
        b.contact_phone,
        b.contact_phone as customer_phone,
        b.opt_contact_delivery,
        
        b.used_currency,
        b.base_currency,
        b.exchange_rate,
        b.service_fee,
        b.service_fee_applytax,
        
        c.restaurant_name as merchant_name,
        c.restaurant_phone as merchant_contact_phone,
        
        d.payment_reference,
        
        (
            SELECT credit_card_number
            FROM mt_client_cc
            WHERE cc_id = a.cc_id 
            LIMIT 1
        ) as credit_card_number
        
        FROM mt_order a
        LEFT JOIN mt_order_delivery_address b ON a.order_id = b.order_id
        LEFT JOIN mt_merchant c ON a.merchant_id = c.merchant_id
        LEFT JOIN mt_payment_order d ON a.order_id = d.order_id
        
        WHERE a.order_id = :order_id
        $and
        LIMIT 1
    ";

    $query = $pdo->prepare($stmt);
    $query->bindParam(':order_id', $order_id, PDO::PARAM_INT);
    if ($client_id > 0) {
        $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    }

    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);

        // FIXED OLD DATA
        if ($res && empty(trim($res['full_name']))) {
            $stmt2 = "
                SELECT 
                concat(first_name, ' ', last_name) as full_name,
                contact_phone
                FROM mt_client
                WHERE client_id = :client_id
            ";
            $query2 = $pdo->prepare($stmt2);
            $query2->bindParam(':client_id', $res['client_id'], PDO::PARAM_INT);

            if ($query2->execute()) {
                $res2 = $query2->fetch(PDO::FETCH_ASSOC);
                if ($res2) {
                    $res['full_name'] = $res2['full_name'];
                    $res['contact_phone'] = $res2['contact_phone'];
                }
            }
        }
        return $res;
    }

    return false;
}

public function orderStatusList2($aslist = true)
{
    $mid = $this->getMerchantID();
    $list = array();
    
    if ($aslist) {
        $list[] = "Please select";  // Replace Yii::t with plain text
    }

    // Prepare the SQL statement
    $stmt = "SELECT * FROM mt_order_status ORDER BY stats_id";

    // Execute the query using PDO
    $query = $this->db->prepare($stmt);
    $query->execute();
    
    // Fetch the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            // Assuming 't' is a translation function in your new MVC structure
            $list[$val['description']] = ($val['description']);
        }
        return $list;
    }

    return false;    
}






    public function jsLanguageValidator()
    {
        $js_lang=array(
          'requiredFields'=>$this->translation("default","You have not answered all required fields"),
          'groupCheckedTooFewStart'=>$this->translation("default","Please choose at least"),
          'badEmail'=>$this->translation("default","You have not given a correct e-mail address"),
        );
        return $js_lang;
    }


     public function jsLanguageAdmin()
    {
      
      $link="<a href=\"".Config::$baseUrl."/merchant/MerchantStatus/"."\">".$this->translation("default","click here to renew membership")."</a>";
      return array(
        "deleteWarning"=>$this->translation("default","You are about to permanently delete the selected items.\n'Cancel' to stop, 'OK' to delete.?"),
        "checkRowDelete"=>$this->translation("default","Please check on of the row to delete."),
        "removeFeatureImage"=>$this->translation("default","Remove image"),
        "removeFiles"=>$this->translation("default","Remove Files"),
        "lastTotalSales"=>$this->translation("default","Last 30 days Total Sales"),
        "lastItemSales"=>$this->translation("default","Last 30 days Total Sales By Item"),
        "NewOrderStatsMsg"=>$this->translation("default","New Order has been placed."),
        
        'Hour'=>$this->translation("default","Hour"),
        'Minute'=>$this->translation("default","Minute"),
        'processing'=>$this->translation("default","processing."),
        'merchantStats'=>$this->translation("default","Your merchant membership is expired. Please renew your membership.").$link,
        "Status"=>$this->translation("default","Status"),
        
        "tablet_1"=>$this->translation("default","No data available in table"),
        "tablet_2"=>$this->translation("default","Showing _START_ to _END_ of _TOTAL_ entries"),
        "tablet_3"=>$this->translation("default","Showing 0 to 0 of 0 entries"),
        "tablet_4"=>$this->translation("default","(filtered from _MAX_ total entries)"),
        "tablet_5"=>$this->translation("default","Show _MENU_ entries"),
        "tablet_6"=>$this->translation("default","Loading..."),
        "tablet_7"=>$this->translation("default","Processing..."),
        "tablet_8"=>$this->translation("default","Search:"),
        "tablet_9"=>$this->translation("default","No matching records found"),
        "tablet_10"=>$this->translation("default","First"),
        "tablet_11"=>$this->translation("default","Last"),
        "tablet_12"=>$this->translation("default","Next"),
        "tablet_13"=>$this->translation("default","Previous"),
        "tablet_14"=>$this->translation("default",": activate to sort column ascending"),
        "tablet_15"=>$this->translation("default",": activate to sort column descending"),
                
        "trans_1"=>$this->translation("default","Please rate the restaurant before submitting your review!"),
        "trans_2"=>$this->translation("default","Sorry but you can select only"),
        "trans_3"=>$this->translation("default","addon"),
        "trans_4"=>$this->translation("default","Are you sure?"),
        "trans_5"=>$this->translation("default","Sorry but Minimum order is"),
        "trans_6"=>$this->translation("default","Please select payment method"),
        "trans_7"=>$this->translation("default","Mobile number is required"),
        "trans_8"=>$this->translation("default","Please select your credit card"),
        "trans_9"=>$this->translation("default","Map not available"),
        "trans_10"=>$this->translation("default","Are you sure you want to delete this review? This action cannot be undone."),
        "trans_11"=>$this->translation("default","Add your recent order to cart?"),
        "trans_12"=>$this->translation("default","Got a total of _TOTAL_ Merchant to show (_START_ to _END_)"),
        "trans_13"=>$this->translation("default","Got a total of _TOTAL_ Records to show (_START_ to _END_)"),
        "trans_14"=>$this->translation("default","ERROR:"),
        "trans_15"=>$this->translation("default","Sorry but this merchant delivers only with in "),
        "trans_16"=>$this->translation("default","miles"),
        "trans_17"=>$this->translation("default","Notice: Your merchant will not show on search result. Click on Publish your merchant."),
        "trans_18"=>$this->translation("default","Continue?"),
        "trans_19"=>$this->translation("default","You are about to send SMS to"),
        "trans_20"=>$this->translation("default","customer"),
        "trans_21"=>$this->translation("default","Browse"),
        "trans_22"=>$this->translation("default","Invalid Voucher code"),
        "trans_23"=>$this->translation("default","Remove Voucher"),
        "trans_24"=>$this->translation("default","Use Voucher"),
        "trans_25"=>$this->translation("default","Please enter your origin"),
        "trans_26"=>$this->translation("default","Error: Something went wrong"),
        "trans_27"=>$this->translation("default","No results found"),
        "trans_28"=>$this->translation("default","Geocoder failed due to:"),
        "trans_29"=>$this->translation("default","Please select price"),
        "trans_30"=>$this->translation("default","Sorry this merchant is closed."),
        'Prev'=>$this->translation("default","Prev"),
        'Next'=>$this->translation("default","Next"),
        'Today'=>$this->translation("default","Today"),
        'January'=>$this->translation("default","January"),
        'February'=>$this->translation("default","February"),
        'March'=>$this->translation("default","March"),
        'April'=>$this->translation("default","April"),
        'May'=>$this->translation("default","May"),
        'June'=>$this->translation("default","June"),
        'July'=>$this->translation("default","July"),
        'August'=>$this->translation("default","August"),
        'September'=>$this->translation("default","September"),
        'October'=>$this->translation("default","October"),
        'November'=>$this->translation("default","November"),
        'December'=>$this->translation("default","December"),
        'Jan'=>$this->translation("default","Jan"),
        'Feb'=>$this->translation("default","Feb"),
        'Mar'=>$this->translation("default","Mar"),
        'Apr'=>$this->translation("default","Apr"),
        'May'=>$this->translation("default","May"),
        'Jun'=>$this->translation("default","Jun"),
        'Jul'=>$this->translation("default","Jul"),
        'Aug'=>$this->translation("default","Aug"),
        'Sep'=>$this->translation("default","Sep"),
        'Oct'=>$this->translation("default","Oct"),
        'Nov'=>$this->translation("default","Nov"),
        'Dec'=>$this->translation("default","Dec"),
        'Sun'=>$this->translation("default","Sun"),
        'Mon'=>$this->translation("default","Mon"),
        'Tue'=>$this->translation("default","Tue"),
        'Wed'=>$this->translation("default","Wed"),
        'Thu'=>$this->translation("default","Thu"),
        'Fri'=>$this->translation("default","Fri"),
        'Sat'=>$this->translation("default","Sat"),     
        'Su'=>$this->translation("default","Su"),
        'Mo'=>$this->translation("default","Mo"),
        'Tu'=>$this->translation("default","Tu"),
        'We'=>$this->translation("default","We"),
        'Th'=>$this->translation("default","Th"),
        'Fr'=>$this->translation("default","Fr"),
        'Sa'=>$this->translation("default","Sa"),
        'Hour'=>$this->translation("default","Hour"),
        'Minute'=>$this->translation("default","Minute"),
        'AM'=>$this->translation("default","AM"),
        'PM'=>$this->translation("default","PM"),
        "trans_31"=>$this->translation("default","Sorry but Maximum order is"),
        "trans_32"=>$this->translation("default","Select Some Options"),
        "trans_33"=>$this->translation("default","No results match"),
        "trans_34"=>$this->translation("default","New Booking Table"),
        "trans_35"=>$this->translation("default","Restaurant name"),
        "trans_36"=>$this->translation("default","Address"),
        "trans_37"=>$this->translation("default","Order Now"),
        "trans_38"=>$this->translation("default","Pickup Time"),
        "trans_39"=>$this->translation("default","Delivery Time"),
        "trans_40"=>$this->translation("default","Please select payment provider"),
        "trans_41"=>$this->translation("default","Pickup Time is required"),
        "trans_42"=>$this->translation("default","Pickup Date is required"),
        "trans_43"=>$this->translation("default","Delivery Date is required"),
        "trans_44"=>$this->translation("default","Delivery Time is required"),
        "trans_45"=>$this->translation("default","Tip"),
        "trans_46"=>$this->translation("default","You must select price for left and right flavor"),
        'trans_47'=>$this->translation("default","You must select at least one addon"),
        'trans_48'=>$this->translation("default","Please drag the marker to select your address"),
        'trans_49'=>$this->translation("default","You can drag the map marker"),
        'trans_50'=>$this->translation("default","Is this address correct"),
        'trans_51'=>$this->translation("default","Sorry but this item is not available"),
        'trans_52'=>$this->translation("default","Please validate Captcha"),
        'trans_53'=>$this->translation("default","SMS code is required"),
                
        'find_restaurant_by_name'=>$this->translation("default","Find restaurant by name"),
        'find_restaurant_by_streetname'=>$this->translation("default","Find by street name"),
        'find_restaurant_by_cuisine'=>$this->translation("default","Find restaurant by cuisine"),
        'find_restaurant_by_food'=>$this->translation("default","Find restaurant by food"),
        'read_more'=>$this->translation("default","Read more"),
        'close'=>$this->translation("default","Close"),
        'close_fullscreen'=>$this->translation("default","Close fullscreen"),
        'view_fullscreen'=>$this->translation("default","View in fullscreen"),
        'not_authorize'=>$this->translation("default","You are not authorize with this app"),
        'not_login_fb'=>$this->translation("default","Sorry but you are not login with facebook"),
        'login_succesful'=>$this->translation("default","Login Successful"),
        'you_cannot_edit_order'=>$this->translation("default","You cannot edit this order since you have redeem points"),
        'dinein_time_is_required'=>$this->translation("default","Dinein time is required"),
        'dinein_time'=>$this->translation("default","Dine in time"),
        'invalid_file_ext'=>$this->translation("default","Invalid File extension"),
        'invalid_file_size'=>$this->translation("default","Invalid File size"),
        'upload_failed'=>$this->translation("default","Upload failed"),
        'search_placeholder'=>$this->translation("default","Street Address,City,State"),
        'geolocation_failed'=>$this->translation("default","Geolocation failed"),
        'browser_not_supported'=>$this->translation("default","Your browser does not support geolocation"),
        'select_from_map'=>$this->translation("default","select your location from map"),
        'enter_full_name'=>$this->translation("default","please enter name on card eg. [first name][space][last name]"),
        'not_rated_yet'=>$this->translation("default","Not rated yet!"),
      );
    }


    public function merchantList2($as_list = true)
    {
        $data = [];

        // Define the SQL query
        $stmt = "SELECT * FROM mt_merchant
                 WHERE status IN ('active')
                 AND is_commission = '2'
                 ORDER BY restaurant_name ASC";

        // Prepare the statement
        $pdoStmt = $this->db->prepare($stmt);

        // Execute the statement
        $pdoStmt->execute();

        // Fetch results
        $res = $pdoStmt->fetchAll(PDO::FETCH_ASSOC);

        // Add "All Merchant" as the first option
        $data[] = $this->translation("default","All Merchant");

        // Process the results based on $as_list
        if ($res) {
            if ($as_list) {
                foreach ($res as $val) {
                    $data[$val['merchant_id']] = stripslashes($val['restaurant_name']);
                }
                return $data;
            } else {
                return $res;
            }
        }

        return false;
    }


  public function getActivemerchantList($current_branch_merchant_ids = [])
{
    if (!is_array($current_branch_merchant_ids)) {
        $current_branch_merchant_ids = [];
    }

    if (empty($current_branch_merchant_ids)) {
        $stmt = "
            SELECT merchant_id, restaurant_name 
            FROM mt_merchant 
            WHERE status = 'active'
            AND merchant_id NOT IN (
                SELECT DISTINCT JSON_UNQUOTE(JSON_EXTRACT(j.value, '$'))
                FROM mt_branches b,
                JSON_TABLE(b.merchant_id, '$[*]' COLUMNS (value VARCHAR(255) PATH '$')) j
            )
            ORDER BY restaurant_name ASC
        ";
        $pdoStmt = $this->db->prepare($stmt);
        $pdoStmt->execute();
    } else {
        $placeholders = implode(',', array_fill(0, count($current_branch_merchant_ids), '?'));
        $stmt = "
            SELECT merchant_id, restaurant_name 
            FROM mt_merchant 
            WHERE status = 'active'
            AND merchant_id NOT IN (
                SELECT DISTINCT JSON_UNQUOTE(JSON_EXTRACT(j.value, '$'))
                FROM mt_branches b,
                JSON_TABLE(b.merchant_id, '$[*]' COLUMNS (value VARCHAR(255) PATH '$')) j
                WHERE JSON_UNQUOTE(JSON_EXTRACT(j.value, '$')) NOT IN ($placeholders)
            )
            ORDER BY restaurant_name ASC
        ";
        $pdoStmt = $this->db->prepare($stmt);
        $pdoStmt->execute($current_branch_merchant_ids);
    }

    return $pdoStmt->fetchAll(PDO::FETCH_ASSOC);
}








     public function dateTranslation()
    {
        return array(
          'January'=>$this->translation("default","January"),
          'February'=>$this->translation("default","February"),
          'March'=>$this->translation("default","March"),
          'April'=>$this->translation("default","April"),
          'May'=>$this->translation("default","May"),
          'June'=>$this->translation("default","June"),
          'July'=>$this->translation("default","July"),
          'August'=>$this->translation("default","August"),
          'September'=>$this->translation("default","September"),
          'October'=>$this->translation("default","October"),
          'November'=>$this->translation("default","November"),
          'December'=>$this->translation("default","December"),
          'Jan'=>$this->translation("default","Jan"),
          'Feb'=>$this->translation("default","Feb"),
          'Mar'=>$this->translation("default","Mar"),
          'Apr'=>$this->translation("default","Apr"),
          'May'=>$this->translation("default","May"),
          'Jun'=>$this->translation("default","Jun"),
          'Jul'=>$this->translation("default","Jul"),
          'Aug'=>$this->translation("default","Aug"),
          'Sep'=>$this->translation("default","Sep"),
          'Oct'=>$this->translation("default","Oct"),
          'Nov'=>$this->translation("default","Nov"),
          'Dec'=>$this->translation("default","Dec"),
          'Sunday'=>$this->translation("default","Sunday"),
          'Monday'=>$this->translation("default","Monday"),
          'Tuesday'=>$this->translation("default","Tuesday"),
          'Wednesday'=>$this->translation("default","Wednesday"),
          'Thursday'=>$this->translation("default","Thursday"),
          'Friday'=>$this->translation("default","Friday"),
          'Saturday'=>$this->translation("default","Saturday"),
          'Sun'=>$this->translation("default","Sun"),
          'Mon'=>$this->translation("default","Mon"),
          'Tue'=>$this->translation("default","Tue"),
          'Wed'=>$this->translation("default","Wed"),
          'Thu'=>$this->translation("default","Thu"),
          'Fri'=>$this->translation("default","Fri"),
          'Sat'=>$this->translation("default","Sat"),
          'Su'=>$this->translation("default","Su"),
          'Mo'=>$this->translation("default","Mo"),
          'Tu'=>$this->translation("default","Tu"),
          'We'=>$this->translation("default","We"),
          'Th'=>$this->translation("default","Th"),
          'Fr'=>$this->translation("default","Fr"),
          'Sa'=>$this->translation("default","Sa"),
          
          'days'=>$this->translation("default","days"),
          'day'=>$this->translation("default","day"),         
          'week'=>$this->translation("default","week"),
          'weeks'=>$this->translation("default","weeks"),
          'months'=>$this->translation("default","months"),
          'month'=>$this->translation("default","month"),         
          'ago'=>$this->translation("default","ago"),
          'In'=>$this->translation("default","In"),
          'minute'=>$this->translation("default","minute"),
          'hour'=>$this->translation("default","hour"),
        );
    }

    public function required($field=array(), $data='') {
        if (is_array($field) && count($field) >= 1) {
            foreach ($field as $key => $value) {
                if (empty($data[$key])) {
                    $this->msg[] = $value;
                }
            }
        } else
            $this->msg[] = "fields must be an array";
    }

    public function validate() {
        if (!is_array($this->msg) && count((array)$this->msg) <= 1) {
            return true;
        } else
            return false;
    }

    public function getErrorAsHTML() {
        $content = '';

        $content.="<ul id=\"cvalidator\">";
        if (is_array($this->msg) && count($this->msg) >= 1) {
            foreach ($this->msg as $value) {
                $content.="<li>$value</li>";
            }
        }
        $content.="</ul>";
        return $content;
    }


   public function getSubsriberEmail($email_address = '')
{
    $stmt = $this->db->prepare("SELECT * FROM mt_newsletter WHERE email_address = :email_address LIMIT 0,1");
    $stmt->bindParam(':email_address', $email_address, PDO::PARAM_STR);
    
    if ($stmt->execute()) {
        $res = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            return $res;
        }
    }
    
    return false;
}





     public function merchantList3($as_list = true, $with_select = false) {
        $data = [];
        $stmt = "SELECT * FROM mt_merchant ORDER BY restaurant_name ASC";

        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($with_select) {
            $data[] = $this->translation("default", "All Merchant");
        }

        if ($res) {
            if ($as_list) {
                foreach ($res as $val) {
                    $data[$val['merchant_id']] = ucwords($val['restaurant_name']);
                }
                return $data;
            } else {
                return $res;
            }
        }
        
        return false;
    }


     public function orderStatusTPL($type=1)
    {
        $data = [];
        $stmt = $this->db->prepare("SELECT * FROM mt_order_status ORDER BY description ASC");
        $stmt->execute();

        if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
            foreach ($res as $val) {
                $description = str_replace(" ", "_", $val['description']);
                
                if ($type == 1) {
                    $data["order_status_" . $description] = array(
                        'email' => true,
                        'sms' => true,
                        'push' => true,
                        'email_tag' => 'order_id,order_status,restaurant_name,customer_name,remarks,sitename,siteurl',
                        'sms_tag' => 'order_id,order_status,restaurant_name,customer_name,remarks,sitename,siteurl',
                        'push_tag' => 'order_id,order_status,restaurant_name,customer_name,remarks,sitename,siteurl',
                    );
                } else {
                    $data[] = "order_status_" . $description . "_email";
                    $data[] = "order_status_" . $description . "_sms";
                    $data[] = "order_status_" . $description . "_push";
                }
            }
        }

        return $data;
    }
     





   public function adminMenu()
  {
    return array(  
        'activeCssClass'=>'active', 
        'encodeLabel'=>false,
        'items'=>array(
                array('visible'=>$this->AA('dashboard'),
                'tag'=>"dashboard",'label'=>'<i class="fa fa-home"></i>'.$this->translation("default","Dashboard"),
                'url'=>array('/admin/dashboard')),    

                array('visible'=>$this->AA('packages'),
                'tag'=>"packages",'label'=>'<i class="fa fa-list-alt"></i>'.$this->translation("default","Packages"),
                'url'=>array('/admin/packages')),                            
                                                
                array('visible'=>$this->AA('merchant'),
                'tag'=>"merchant",'label'=>'<i class="fa fa-cutlery"></i>'.$this->translation("default","Merchant List"),
                'url'=>array('/admin/merchant')),

                array('visible'=>$this->AA('invoice'),
                'tag'=>"invoice",
                'label'=>'<i class="fa fa-list-alt"></i>'.$this->translation("default","Invoice"),
                'url'=>array('/admin/invoice')),  

                 array('visible'=>$this->AA('withdrawal'),'tag'=>'Orders',
                   'label'=>'<i class="fa fa-desktop"></i>'.$this->translation("default",'Orders'),
                   'itemOptions'=>array('class'=>''), 
                   'items'=>array(        
                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'incomingorders',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","All Orders"), 
                     'url'=>array('/admin/incomingorders')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'posorders',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","POS Orders"), 
                     'url'=>array('/admin/pointofsale')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'cancel_order',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","New Cancel Orders"), 
                     'url'=>array('/admin/cancel_order')),                                
                     
                                                        
                 )), 





                    array('visible'=>$this->AA('withdrawal'),'tag'=>'Marketing',
                   'label'=>'<i class="fa fa-ticket"></i>'.$this->translation("default",'Marketing'),
                   'itemOptions'=>array('class'=>''), 
                   'items'=>array(        
                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'sponsoredMerchantList',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Sponsored Listing"), 
                     'url'=>array('/admin/sponsoredMerchantList')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'PromotionsList',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Promotions"), 
                     'url'=>array('/admin/PromotionsList')), 


                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'voucher',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Voucher"), 
                     'url'=>array('/admin/voucher')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'subscriberlist',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Subscriber List"), 
                     'url'=>array('/admin/subscriberlist')), 

                     
                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'reviews',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Reviews"), 
                     'url'=>array('/admin/reviews')), 
                                                   
                     
                                                        
                 )), 

                                                   
                  
                



                 array('visible'=>$this->AA('withdrawal'),'tag'=>'Marketing',
                   'label'=>'<i class="fa fa-university"></i>'.$this->translation("default",'Food Items'),
                   'itemOptions'=>array('class'=>''), 
                   'items'=>array(        
                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'Cuisine',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Cuisine"), 
                     'url'=>array('/admin/Cuisine')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'dishes',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Dishes"), 
                     'url'=>array('/admin/dishes')),  
                                                        
                 )), 



                 array('visible'=>$this->AA('withdrawal'),'tag'=>'Marketing',
                   'label'=>'<i class="fa fa-cogs"></i>'.$this->translation("default",'Settings'),
                   'itemOptions'=>array('class'=>''), 
                   'items'=>array(        
                     
                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'tags',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Tags"), 
                     'url'=>array('/admin/tags')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'OrderStatus',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Order Status"), 
                     'url'=>array('/admin/OrderStatus')), 


                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'BranchList',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Branch Management"), 
                     'url'=>array('/admin/BranchList')), 


                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'settings',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","General Settings"), 
                     'url'=>array('/admin/settings')),

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'themesettings',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Theme settings"), 
                     'url'=>array('/admin/themesettings')),

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'commisionsettings',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Commission Settings"), 
                     'url'=>array('/admin/commisionsettings')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'cronjobs',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Cron Jobs"), 
                     'url'=>array('/admin/cronjobs')),  

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'ContactSettings',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Contact Settings"), 
                     'url'=>array('/admin/ContactSettings')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'SocialSettings',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Social Settings"), 
                     'url'=>array('/admin/SocialSettings')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'ManageCurrency',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Manage Currency"), 
                     'url'=>array('/admin/ManageCurrency')), 


                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'ManageLocation',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Manage Location"), 
                     'url'=>array('/admin/ManageLocation')), 




                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'ManageLanguage',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Manage Language"), 
                     'url'=>array('/admin/ManageLanguage')),

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'Seo',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","SEO"), 
                     'url'=>array('/admin/Seo')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'Ratings',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Ratings"), 
                     'url'=>array('/admin/Ratings')), 

                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'analytics',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Custom Code & Analytics"), 
                     'url'=>array('/admin/analytics')), 
                                                        
                 )), 

              
                   
                  
                
                
                    
                
            
                                                                 
                                
                array('visible'=>$this->AA('withdrawal'),'tag'=>'withdrawal',
                   'label'=>'<i class="fa fa-university"></i>'.$this->translation("default",'Withdrawal'),
                   'itemOptions'=>array('class'=>''), 
                   'items'=>array(        
                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'incomingwithdrawal',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Withdrawal List"), 
                     'url'=>array('/admin/incomingwithdrawal')),                                
                     
                      array('visible'=>$this->AA('withdrawalsettings'),'tag'=>'withdrawalsettings',
                      'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Settings"), 
                     'url'=>array('/admin/withdrawalsettings')),                                   
                 )),   



                array('visible'=>$this->AA('withdrawal'),'tag'=>'withdrawal',
                   'label'=>'<i class="fa fa-envelope"></i>'.$this->translation("default",'Email'),
                   'itemOptions'=>array('class'=>''), 
                   'items'=>array(        
                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'emailsettings',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Email Settings"), 
                     'url'=>array('/admin/emailsettings')),                                
                     
                      array('visible'=>$this->AA('withdrawalsettings'),'tag'=>'emailogs',
                      'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Email Logs"), 
                     'url'=>array('/admin/emailogs')),                                   
                 )),  



                 array('visible'=>$this->AA('withdrawal'),'tag'=>'withdrawal',
                   'label'=>'<i class="fa fa-bell"></i>'.$this->translation("default",'Notifications'),
                   'itemOptions'=>array('class'=>''), 
                   'items'=>array(        
                     array('visible'=>$this->AA('incomingwithdrawal'),'tag'=>'emailtpl',
                     'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Notification Template"), 
                     'url'=>array('/admin/emailtpl')),                                
                     
                      array('visible'=>$this->AA('withdrawalsettings'),'tag'=>'notisettings',
                      'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Notification Settings"), 
                     'url'=>array('/admin/notisettings')),                                   
                 )),  


                  array('visible'=>$this->AA('addons'),'tag'=>'addons',
                'label'=>'<i class="fa fa-plus-circle"></i>'.$this->translation("default",'Add-ons'),
                   'itemOptions'=>array('class'=>''), 'items'=>array(                   
                   
                   /*array('visible'=>$this->AA('addonexport'),
                   'tag'=>'addonexport','label'=>'<i class="fa"></i>'.$this->translation("default","Export/Import"), 
                   'url'=>Config::$baseUrl."/exportmanager?lang=en"),   */             
                   
                   
                   
                   /*array('visible'=>$this->AA('mobileapp'),
                   'tag'=>'mobileapp','label'=>'<i class="fa"></i>'.$this->translation("default","MobileApp"), 
                   'url'=> ('/mobileapp?lang=en') ),  */              
                   
                   array('visible'=>$this->AA('pointsprogram'),
                   'tag'=>'pointsprogram','label'=>'<i class="fa"></i>'.$this->translation("default","Loyalty Points Program"), 
                   'url'=>Config::$baseUrl."/pointsprogram/index/settings"),                
                                      
                  /* array('visible'=>$this->AA('merchantapp'),
                   'tag'=>'merchantapp','label'=>'<i class="fa"></i>'.$this->translation("default","MerchantApp"), 
                   'url'=>Config::$baseUrl."/merchantapp?lang=en"), */               
                   
                   array('visible'=>$this->AA('printermodule'),
                   'tag'=>'pos','label'=>'<i class="fa"></i>'.$this->translation("default","POS"), 
                   'url'=>Config::$baseUrl."/pos?lang=en"),                
                   
                   array('visible'=>$this->AA('singlemerchant'),
                   'tag'=>'singlemerchant','label'=>'<i class="fa"></i>'.$this->translation("default","Single Merchant"), 
                   'url'=>Config::$baseUrl."/singlemerchant/index/settings"),  




                   array('visible'=>true,
                   'tag'=>'pos','label'=>'<i class="fa"></i>'.$this->translation("default","POS"), 
                   'url'=>Config::$baseUrl."/pos/index/settings"), 

                   
                   array('visible'=>$this->AA('mobileappv2'),
                   'tag'=>'mobileappv2','label'=>'<i class="fa"></i>'.$this->translation("default","MobileApp v2"), 
                   'url'=>Config::$baseUrl."/mobileappv2/index/settings"),  

                   array('visible'=>$this->AA('mobileappv2'),
                   'tag'=>'mobileappv2','label'=>'<i class="fa"></i>'.$this->translation("default","WebApp v2"), 
                   'url'=>Config::$baseUrl."/webappv2/index/settings"),                
                   
                   array('visible'=>$this->AA('merchantappv2'),
                   'tag'=>'merchantappv2','label'=>'<i class="fa"></i>'.$this->translation("default","Merchantapp v2"), 
                   'url'=>Config::$baseUrl."/merchantappv2/index/settings"),                
                   
                  /* array('visible'=>$this->AA('driverapp'),
                   'tag'=>'driverapp','label'=>'<i class="fa"></i>'.$this->translation("default","Driver app"), 
                   'url'=>Config::$baseUrl."/driver?lang=en"),     */           
                   
                   /*array('visible'=>$this->AA('multicurrency'),
                   'tag'=>'multicurrency','label'=>'<i class="fa"></i>'.$this->translation("default","Multi Currency"), 
                   'url'=>Config::$baseUrl."/multicurrency?lang=en"),  */              
              
                 )),  
                /**add ons */   





                 array('visible'=>$this->AA('customPage'),
                'tag'=>"customPage",'label'=>'<i class="fa fa-list-alt"></i>'.$this->translation("default","Custom Page"),
                'url'=>array('/admin/customPage')),  

                 array('visible'=>$this->AA('customerlist'),'tag'=>"customerlist",
                'label'=>'<i class="fa fa-list-alt"></i>'.$this->translation("default","Customer List"),
                'url'=>array('/admin/customerlist')),  

                 array('visible'=>$this->AA('bankdeposit'),'tag'=>"bankdeposit",
                'label'=>'<i class="fa fa-list-alt"></i>'.$this->translation("default","Receive Bank Deposit"),
                'url'=>array('/admin/bankdeposit')), 



                 array('visible'=>$this->AA('paymentgateway'),'tag'=>'paymentgateway',
                'label'=>'<i class="fa fa-usd"></i>'.$this->translation("default",'Payment Gateway'),
                   'itemOptions'=>array('class'=>''), 'items'=>array(                   
                   
/*                   array('visible'=>$this->AA('paypalSettings'),
                   'tag'=>'paypalSettings','label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Paypal"), 
                   'url'=>array('admin/paypalSettings')),                */

                   array('visible'=>$this->AA('paypal_v2'),
                   'tag'=>'paymentgatewaysettings','label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Payment Gateway Settings"), 
                   'url'=>array('/admin/paymentgatewaysettings')),

                   array('visible'=>$this->AA('payondelivery'),'tag'=>'windcave',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Windcave"), 
                   'url'=>array('/admin/windcave')),
                   
                   array('visible'=>$this->AA('paypal_v2'),
                   'tag'=>'paypal_v2','label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Paypal V2"), 
                   'url'=>array('/admin/paypal_v2')),                
                   
                                                  
                   
                   array('visible'=>$this->AA('stripeSettings'),
                   'tag'=>'stripeSettings','label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Stripe"), 
                   'url'=>array('/admin/stripeSettings')),                
                   
                                                   
                   
                                                   
                    array('visible'=>$this->AA('polipay'),'tag'=>'polipay', 
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Poli"),  
                   'url'=>array('/admin/polipay')), 
                      
                   
                             
                   
                   array('visible'=>$this->AA('payondelivery'),'tag'=>'payondelivery',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Alternative Payment"), 
                   'url'=>array('/admin/payondelivery')),    
                                            
                                                
                     
                                                                  
                   
                   
                   
                   /*custom code 2 start */
                   
           /*custom code 2 ends */
                    
                 )),  


                  array('visible'=>$this->AA('sms'),
                 'tag'=>'sms','label'=>'<i class="fa fa-list-alt"></i>'.$this->translation("default",'SMS'),
                   'itemOptions'=>array('class'=>''), 'items'=>array(
                   
                   array('visible'=>$this->AA('smsSettings'),'tag'=>'smsSettings',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","SMS Settings"), 
                   'url'=>array('/admin/smsSettings')),                
                   
                   array('visible'=>$this->AA('smsPackage'),'tag'=>'smsPackage',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","SMS Package"), 
                   'url'=>array('/admin/smsPackage')),                                                                         
                   array('visible'=>$this->AA('smstransaction'),'tag'=>'smstransaction',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","SMS Transaction"), 
                   'url'=>array('/admin/smstransaction')),    
                               
                   array('visible'=>$this->AA('smslogs'),
                   'tag'=>'smslogs','label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","SMS Logs"), 
                   'url'=>array('/admin/smslogs')),                
                 )),              




                
                array('visible'=>$this->AA('reports'),
                'tag'=>'reports','label'=>'<i class="fa fa-list-alt"></i>'.$this->translation("default",'Reports'),
                   'itemOptions'=>array('class'=>''), 'items'=>array(


                    array('visible'=>$this->AA('rptMerchantReg'),'tag'=>'merchantcommission',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Merchant Commission"), 
                   'url'=>array('/admin/merchantcommission')),
                   
                   array('visible'=>$this->AA('rptMerchantReg'),'tag'=>'rptMerchantReg',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Merchant Registration"), 
                   'url'=>array('/admin/rptMerchantReg')), 
                   
                   array('visible'=>$this->AA('rptMerchantPayment'),'tag'=>'rptMerchantPayment',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Merchant Payment"), 
                   'url'=>array('/admin/rptMerchantPayment')), 
                   
                   array('visible'=>$this->AA('rptMerchanteSales'),'tag'=>'rptMerchanteSales',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Merchant Sales Report"), 
                   'url'=>array('/admin/rptMerchanteSales')), 
                   
                   array('visible'=>$this->AA('rptmerchantsalesummary'),'tag'=>'rptmerchantsalesummary',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Merchant Sales Summary Report"), 
                   'url'=>array('/admin/rptmerchantsalesummary')), 


                   
                   array('visible'=>$this->AA('rptbookingsummary'),'tag'=>'rptbookingsummary',
                   'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Booking Summary Report"), 
                   'url'=>array('/admin/rptbookingsummary')), 
                 )),
                 
                 array('visible'=>$this->AA('userList'),
                 'tag'=>"userlist",'label'=>'<i class="fa fa-users"></i>'.$this->translation("default","User List"),
                'url'=>array('/admin/userlist')),                
                                
                array('visible'=>true,'tag'=>"logout",'label'=>'<i class="fa fa-sign-out"></i>'.$this->translation("default","Logout"),
                'url'=>array('/admin/login/logout/true')),
            )
    );
  }

  public function getMerchantInfo()
    {
        if (!empty($_SESSION['kr_merchant_user'])){
            $user=json_decode($_SESSION['kr_merchant_user']);           
            if (is_array($user) && count($user)>=1){
                return $user;
            }
        }
        return false;
    }

  public function getMerchantInfo_mobileapp($merchant_id = '')
{
    $stmt = $this->db->prepare("
        SELECT a.*, 
        CONCAT(street, ' ', city, ' ', state, ' ', post_code, ' ', country_code) AS complete_address
        FROM mt_merchant a
        WHERE merchant_id = :merchant_id
        LIMIT 1
    ");

    $stmt->execute([':merchant_id' => $merchant_id]);
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    return $res ?: false;
}


public function all_merchant_except_curr_merchant($merchant_id = '')
{
    try {
        $stmt = $this->db->prepare("
            SELECT merchant_id, restaurant_name
            FROM mt_merchant
            WHERE merchant_id != :merchant_id
            AND status = 'active'
        ");

        $stmt->execute([':merchant_id' => $merchant_id]);
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        return $res ?: false;
    } catch (PDOException $e) {
        // Optional: log the error
        // error_log("DB Error: " . $e->getMessage());
        return false;
    }
}


   


  public function getMerchantInfo_idwise($merchant_id = '')
{
    // Prepare the SQL statement
    $stmt = "SELECT a.*,
             CONCAT(street, ' ', city, ' ', state, ' ', post_code, ' ', country_code) AS complete_address
             FROM mt_merchant a
             WHERE merchant_id = :merchant_id
             LIMIT 0, 1";

    // Prepare the query
    $query = $this->db->prepare($stmt);
    
    // Bind the parameter to avoid SQL injection
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result as an associative array
        $res = $query->fetch(PDO::FETCH_ASSOC);
        
        // Return the result if it exists
        if ($res) {
            return $res;
        }
    }

    // Return false if no result is found
    return false;
}


public  function saveFbAvatarPicture($id='')
    {                   
        if( @ini_get('allow_url_fopen') ) {             
            $fbid=$id;
            $fb_avatar_filename="avatar_".$id.".jpg";
            $context = stream_context_create(array('http' => array('header'=>'Connection: close\r\n')));            
            $image = json_decode(file_get_contents("https://graph.facebook.com/$fbid/picture?type=large&redirect=false",false,$context),true);              
            if(isset($image['data']['url'])){
                $image = file_get_contents($image['data']['url']);
                @file_put_contents( $this->uploadPath()."/$fb_avatar_filename",$image);
                return $fb_avatar_filename;
            } 
        } 
        return false;
    }



   public function getMerchantUserAccess()
    {
        if ($info=$this->getMerchantInfo()){
            $info = (array)$info[0];  
            $user_access = json_decode( isset($info['user_access'])?$info['user_access']:'',true); 
            if(is_array($user_access) && count((array)$user_access)>=1){
                $user_access = array_map('strtolower', $user_access);
                return $user_access;
            }
        }    
        return false;
    } 

     public function isSearchByLocation()
   {
        $home_search_mode=$this->getOptionAdmin('home_search_mode');
        if($home_search_mode=="postcode"){
            return true;
        }
        return false;
   }


 public function GetLocationRateByMerchantWithName($mtid = '')
{
    $stmt = "
        SELECT a.*, 
            b.country_name, 
            c.name AS state_name, 
            d.name AS city_name, 
            d.postal_code, 
            e.name AS area_name
        FROM mt_location_rate a
        LEFT JOIN mt_location_countries b ON a.country_id = b.country_id
        LEFT JOIN mt_location_states c ON a.state_id = c.state_id
        LEFT JOIN mt_location_cities d ON a.city_id = d.city_id
        LEFT JOIN mt_location_area e ON a.area_id = e.area_id
        WHERE merchant_id = :mtid
        ORDER BY sequence ASC
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':mtid', $mtid, PDO::PARAM_INT);
    $query->execute();

    return $query->fetchAll(PDO::FETCH_ASSOC) ?: false;
}


public function getDefaultCountrySignup($country_code = '')
{    
    $stmt = "
        SELECT country_id 
        FROM mt_location_countries 
        WHERE shortcode = :country_code
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':country_code', $country_code, PDO::PARAM_STR);
    $query->execute();

    $result = $query->fetch(PDO::FETCH_ASSOC);

    return $result ? $result['country_id'] : false;
}


public function GetLocationRateByID($rate_id = '')
{
    $stmt = "
        SELECT * FROM mt_location_rate 
        WHERE rate_id = :rate_id 
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':rate_id', $rate_id, PDO::PARAM_INT);
    $query->execute();

    return $query->fetch(PDO::FETCH_ASSOC) ?: false;
}





public function bookedAvailable($merchant_id = '')
{
    // Determine the booking date and day
    if (isset($_POST['date_booking'])) {
        $day_now = strtolower(date("l", strtotime($_POST['date_booking'])));
        $datenow = date("Y-m-d", strtotime($_POST['date_booking']));
    } else {
        $datenow = date('Y-m-d');
        $day_now = strtolower(date('l'));
    }

    $max_booking = 0;

    // Get max booking for the day
    $max_booked = $this->getOption("max_booked", $merchant_id);
    if (!empty($max_booked)) {
        $max_booked = json_decode($max_booked, true);
        if (isset($max_booked[$day_now])) {
            $max_booking = $max_booked[$day_now];
        }
    }

    $total_book_today = 0;

    // Using PDO to count the number of bookings for today
    $stmt = $this->db->prepare("
        SELECT COUNT(*) AS total
        FROM mt_bookingtable
        WHERE date_booking LIKE :datenow
        AND status IN ('pending', 'approved')
    ");

    // Create a variable for the parameter
    $date_with_wildcard = $datenow . '%';

    // Bind the parameter to the query
    $stmt->bindParam(':datenow', $date_with_wildcard, PDO::PARAM_STR);

    // Execute the query
    $stmt->execute();

    // Fetch the result
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($result) {
        $total_book_today = $result['total'];
    }

    // Check if the bookings have reached the maximum limit
    if ($max_booking >= 1) {
        if ($total_book_today >= $max_booking) {
            return false; // Booking limit reached
        }
    }

    return true; // Booking available
}






   public function getClientInfo($client_id = '')
{
    // Prepare the SQL query with placeholders
    $stmt = "SELECT * FROM mt_client WHERE client_id = :client_id LIMIT 0,1";
    
    try {
        // Prepare the PDO statement
        $query = $this->db->prepare($stmt);
        
        // Bind the client_id parameter to the query
        $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
        
        // Execute the query
        $query->execute();
        
        // Fetch the result as an associative array
        $result = $query->fetch(PDO::FETCH_ASSOC);
        
        // Return the first result if found
        if ($result) {
            return $result;
        }
        
        // Return false if no result is found
        return false;

    } catch (PDOException $e) {
        // Handle potential database errors
        return false;
    }
}

 public  function getFreeDeliveryTag($merchant_id='')
    {
        $fee=$this->getOption('free_delivery_above_price',$merchant_id);
        if ($fee>0){
            return '<span class="label label-default">'. $this->translation("default","Free Delivery On Orders Over")." ". $this->prettyPrice($fee).'</span>';
        }
        return '&nbsp;';
    }

    public  function fixedLink($link='')
    {
        if  (!empty($link)){
           if (!preg_match("/http/i", $link)) {
               $link="http://".$link;
           }
           return $link;
       }  
       return false;
    }

public  function getMerchantLogox($merchant_id='',$logo='')
    {       
           
        $upload_path=Config::$baseUrl."/upload/"; 
        if (!empty($logo)){
            $merchant_logo=$logo;
        } else $merchant_logo=$this->getOption('merchant_photo',$merchant_id);                  
        if (!empty($merchant_logo)){
            if (file_exists($upload_path."/".$merchant_logo)){
               $merchant_logo=$this->uploadURL()."/$merchant_logo";    
            } else $merchant_logo=$this->assetsURL()."/images/default-image-merchant.png";
        } else $merchant_logo=$this->assetsURL()."/images/default-image-merchant.png";
        return $merchant_logo;
    }


    public  function getMerchantLogo($merchant_id='',$logo='')
    {       
           
        $upload_path=Config::$baseUrl."/upload/"; 
        if (!empty($logo)){
            $merchant_logo=$logo;
        } else $merchant_logo=$this->getOption('merchant_photo',$merchant_id);  
        

        if (!empty($merchant_logo)){
            if (1==1){
               $merchant_logo=$this->uploadURL()."/$merchant_logo";    
            } else $merchant_logo=$this->assetsURL()."/images/default-image-merchant.png";
        } else $merchant_logo=$this->assetsURL()."/images/default-image-merchant.png";
        return $merchant_logo;
    }



public  function getMerchantbg($merchant_id='',$background='')
    {              
        $upload_path=Config::$baseUrl."/upload/"; 
        if (!empty($background)){
            $merchant_bg=$background;
        } else $merchant_bg=$this->getOption('merchant_photo_bg',$merchant_id);  
        

        if (!empty($merchant_bg)){
            if (1==1){
               $merchant_bg=$this->uploadURL()."/$merchant_bg";    
            } else $merchant_bg=$this->assetsURL()."/images/default-image-merchant.png";
        } else $merchant_bg=$this->assetsURL()."/images/default-image-merchant.png";
        return $merchant_bg;
    }




public function getRatings($merchant_id = '')
{

  $this->db->setAttribute(PDO::ATTR_STRINGIFY_FETCHES, true);
    $stmt = "SELECT SUM(rating) as ratings, COUNT(*) AS count
            FROM
            mt_review
            WHERE
            merchant_id = :merchant_id
            AND
            status IN ('publish', 'published')";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->execute();
        
        $res = $query->fetch(PDO::FETCH_ASSOC);
        
        if ($res && $res['ratings'] >= 1) {
            $ret = array(
                'ratings' => number_format($res['ratings'] / $res['count'], 1),
                'votes' => $res['count']
            );
        } else {
            $ret = array(
                'ratings' => "0",
                'votes' => "0"
            );
        }
    } catch (PDOException $e) {
        // Handle exception or log error
        // echo 'Database error: ' . $e->getMessage();
        $ret = array(
            'ratings' => "0",
            'votes' => "0"
        );
    }

    return $ret;
}



 public function getFeatureMerchant()
{
    $sort_options = $this->getOptionAdmin('featured_merchant_sort');
    $sortby = '';
    $tbl = 'mt_merchant';

    switch ($sort_options) {
        case 1:
            $sortby = 'ORDER BY RAND()';
            break;

        case 2:
            $sortby = 'ORDER BY restaurant_name ASC';
            break;

        case 3:
            $tbl = 'view_merchant';
            $sortby = 'ORDER BY ratings DESC';
            break;

        default:
            $sortby = 'ORDER BY restaurant_name ASC';
            break;
    }

    $stmt = "SELECT a.*           
            FROM
            $tbl a
            WHERE
            status IN ('active')
            AND
            is_featured = '2'
            AND
            is_ready = '2'
            $sortby
            LIMIT 0, 100";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute();
        
        if ($query->rowCount() > 0) {
            return $query->fetchAll(PDO::FETCH_ASSOC);
        }
    } catch (PDOException $e) {
        // Handle exception or log error
        // echo 'Database error: ' . $e->getMessage();
    }
    
    return false;
}


public  function cookieLocation()
    {
        $check_cookie=false;
        if (!isset($_SESSION['client_location'])){
            $check_cookie=true;
        } else {
            if (empty($_SESSION['client_location'])){
                $check_cookie=true;
            }
        }
        if ($check_cookie){         
            $temp_location=$this->getCookie('client_location');            
            if (!empty($temp_location)){                
                $temp_location=json_decode($temp_location,true);                
                $_SESSION['client_location']=$temp_location;
            }
        }
    }
 



     public function getSearchByLocationData()
   {      
      $location_type=$this->getOptionAdmin('admin_zipcode_searchtype');    
      $location_data=$this->getCookie('kr_location_search');
      if(!empty($location_data)){
         $location_data=json_decode($location_data,true);
         if(is_array($location_data) && count($location_data)>=1){
            $location_data['location_type']=$location_type;
            return $location_data;
         }
      }
      return false;
   }

   public function getCookie($name)
{
    if (!empty($_COOKIE[$name])) {
        return $_COOKIE[$name];
    }
    return null; // Optional: return null or false if the cookie doesn't exist
}

public  function setCookie($name, $value)
    {
        setcookie ($name, $value , time() + (500*3600) , '/'); 
    }


public function getSessionAddress()
    {
        $kr_search_adrress='';
        if (isset($_SESSION['kr_search_address'])){ 
            $kr_search_adrress=$_SESSION['kr_search_address'];      
        } else {
            $kr_search_adrress=$this->getCookie('kr_search_address');
            if (!empty($kr_search_adrress)){
                $_SESSION['kr_search_address']=$kr_search_adrress;
            }
        }
        
        return $kr_search_adrress;
    }



public function getLocationDeliveryFeeWithMinimum(
    $merchant_id = '', 
    $default_fee = '', 
    $default_minimum_order = 0, 
    $data = ''
) {
    $fee = 0; 
    $minimum_order = 0; 
    $free_above_subtotal = 0; 
    $and = '';

    // Initialize variables to prevent undefined issues
    $state_id = 0;
    $city_id = 0;
    $area_id = 0;
    $postal_code = 0;

    if (is_array($data) && count($data) >= 1) {
        switch ($data['location_type']) {
            case 2:                                 
                $state_id = isset($data['state_id']) ? (int)$data['state_id'] : 0;
                $city_id = isset($data['city_id']) ? (int)$data['city_id'] : 0; 
                
                $and .= " AND state_id = :state_id ";
                
                if ($city_id > 0) {
                    $and .= " AND city_id = :city_id ";
                }
                
                $area_id = isset($data['area_id']) ? (int)$data['area_id'] : 0;
                if ($area_id > 0) {
                    $and .= " AND area_id = :area_id ";
                }
                break;
                
            case 3:
                $postal_code = isset($data['postal_code']) ? (int)$data['postal_code'] : 0;
                $city_id = isset($data['city_id']) ? (int)$data['city_id'] : 0; 
                $area_id = isset($data['area_id']) ? (int)$data['area_id'] : 0;
                
                if ($postal_code > 0) {
                    $and .= " AND postal_code = :postal_code ";                                  
                }
                if ($city_id > 0) {
                    $and .= " AND city_id = :city_id ";
                }
                if ($area_id > 0) {
                    $and .= " AND area_id = :area_id ";
                }
                break;  
                
            default:
                $city_id = isset($data['city_id']) ? (int)$data['city_id'] : 0;
                $area_id = isset($data['area_id']) ? (int)$data['area_id'] : 0;
                $and .= " AND city_id = :city_id ";
                if ($area_id > 0) {
                    $and .= " AND area_id = :area_id ";
                }
                break;
        }
        
        // Prepare the SQL query with named parameters
        $stmt = "
            SELECT * 
            FROM mt_view_location_rate
            WHERE merchant_id = :merchant_id
            $and
            ORDER BY rate_id ASC
            LIMIT 1
        ";        
        
        // Prepare and execute the statement
        $query = $this->db->prepare($stmt);

        // Bind parameters
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Only bind parameters if they are used in the query
        if (strpos($stmt, ':state_id') !== false) $query->bindParam(':state_id', $state_id, PDO::PARAM_INT);
        if (strpos($stmt, ':city_id') !== false) $query->bindParam(':city_id', $city_id, PDO::PARAM_INT);
        if (strpos($stmt, ':area_id') !== false) $query->bindParam(':area_id', $area_id, PDO::PARAM_INT);
        if (strpos($stmt, ':postal_code') !== false) $query->bindParam(':postal_code', $postal_code, PDO::PARAM_INT);

        // Execute the query
        if ($query->execute()) {
            $res = $query->fetch(PDO::FETCH_ASSOC);

            if ($res) {
                $fee = $res['fee'] > 0 ? $res['fee'] : $default_fee;
                $minimum_order = $res['minimum_order'] > 0 ? $res['minimum_order'] : $default_minimum_order;
                $free_above_subtotal = $res['free_above_subtotal'] > 0 ? $res['free_above_subtotal'] : 0;
            } else {
                $fee = $default_fee;
                $minimum_order = $default_minimum_order;
            }
        } else {
            $fee = $default_fee;
            $minimum_order = $default_minimum_order;
        }
    } else {
        $fee = $default_fee;
        $minimum_order = $default_minimum_order;
    }                   
    
    return array(
        'fee' => $fee,
        'minimum_order' => $minimum_order,
        'free_above_subtotal' => $free_above_subtotal
    );
}



public function receiptRowTotal($label='',$value='',$class1='',$class2='')
    {
        $html='';
        $html.="<div class=\"row\">";
        $html.="<div class=\"col-md-6 col-xs-6 text-right $class1\">".($label)."</div>";
        $html.="<div class=\"col-md-6 col-xs-6 text-right $class2\">$value</div>";
        $html.="</div>";
        return $html;
    }







  public function getMerchantMembershipType($merchant_id = '')
{
    // Prepare the SQL statement
    $stmt = $this->db->prepare("
        SELECT merchant_type 
        FROM mt_merchant 
        WHERE merchant_id = :merchant_id
        LIMIT 1
    ");

    // Bind the merchant ID parameter
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    if ($stmt->execute()) {
        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            return $result['merchant_type'];
        }
    }

    return false;
}


 public  function validateChangeOrder($order_id='')
    {
      $order_info=$this->getOrderInfo($order_id);     
      if ( $order_info['order_locked']==2){
        return true;
      }
      return false;
      
      
    }



   public function getOrder($order_id = '')
{
    if (empty($order_id)) {
        return false; // Early return for empty order_id
    }

    // Define the query with placeholders
    $stmt = "
        SELECT 
            a.*,
            (
                SELECT CONCAT(first_name, ' ', last_name) 
                FROM mt_client 
                WHERE client_id = a.client_id
            ) AS full_name,
            (
                SELECT email_address 
                FROM mt_client 
                WHERE client_id = a.client_id
            ) AS email_address,
            (
                SELECT restaurant_name 
                FROM mt_merchant 
                WHERE merchant_id = a.merchant_id
            ) AS merchant_name,
            (
                SELECT restaurant_slug 
                FROM mt_merchant 
                WHERE merchant_id = a.merchant_id
            ) AS restaurant_slug,
            (
                SELECT CONCAT(street, ' ', city, ' ', state, ' ', zipcode) 
                FROM mt_client 
                WHERE client_id = a.client_id
            ) AS full_address,
            (
                SELECT location_name 
                FROM mt_client 
                WHERE client_id = a.client_id
            ) AS location_name,
            (
                SELECT contact_phone 
                FROM mt_client 
                WHERE client_id = a.client_id
            ) AS contact_phone,
            (
                SELECT credit_card_number 
                FROM mt_client_cc 
                WHERE cc_id = a.cc_id
            ) AS credit_card_number
        FROM mt_order a
        WHERE order_id = :order_id
        LIMIT 1
    ";

    try {
        // Prepare the query
        $query = $this->db->prepare($stmt);
        $query->bindParam(':order_id', $order_id, PDO::PARAM_INT); // Bind the parameter

        // Execute the query
        $query->execute();

        // Fetch the result
        $result = $query->fetch(PDO::FETCH_ASSOC);

        return $result ?: false; // Return result or false if no rows found
    } catch (PDOException $e) {
        // Handle exception
        error_log("Database Error: " . $e->getMessage());
        return false;
    }
}
 





    public function verifyOrderIdByOwner($order_id = '', $merchant_id = '')
{
    try {
        // Assuming you're using $this->db for the database connection as preferred
        $stmt = $this->db->prepare("SELECT * FROM mt_order WHERE order_id = :order_id AND merchant_id = :merchant_id");

        // Bind the parameters
        $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result if found
        if ($res) {
            return $res;
        }
        
        return false;
    } catch (PDOException $e) {
        // Handle exception
        error_log("Database Error: " . $e->getMessage());
        return false;
    }
}


public function dateDifference($start, $end )
    {
        $uts['start']=strtotime( $start );
    $uts['end']=strtotime( $end );
    if( $uts['start']!==-1 && $uts['end']!==-1 )
    {
    if( $uts['end'] >= $uts['start'] )
    {
    $diff    =    $uts['end'] - $uts['start'];
    if( $days=intval((floor($diff/86400))) )
        $diff = $diff % 86400;
    if( $hours=intval((floor($diff/3600))) )
        $diff = $diff % 3600;
    if( $minutes=intval((floor($diff/60))) )
        $diff = $diff % 60;
    $diff    =    intval( $diff );            
    return( array('days'=>$days, 'hours'=>$hours, 'minutes'=>$minutes, 'seconds'=>$diff) );
    }
    else
    {     
    return false;
    }
    }
    else
    {     
    return false;
    }
    return( false );
     }  


 



public function itemLists($as_list = true, $with_select = false)
{
    $merchant_id = $this->getMerchantID();  // Assuming this function exists
    $data = array();

    // Prepare the SQL query using PDO
    $stmt = "
        SELECT * FROM mt_item
        WHERE merchant_id = :merchant_id
        AND status IN ('publish', 'published')
        ORDER BY item_name ASC
    ";

    // PDO connection (assuming $this->db is your PDO instance)
    $connection = $this->db;
    $query = $connection->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();

    // Fetch the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // If $with_select is true, add 'Please select' as the first option
    if ($with_select) {
        $data[] = "Please select";
    }

    // Check if there are results
    if ($res) {
        if ($as_list == true) {
            // If $as_list is true, return the array with item_id as the key and item_name as the value
            foreach ($res as $val) {
                $data[$val['item_id']] = ucwords(stripslashes($val['item_name']));
            }
            return $data;
        } else {
            // Return the full result set if $as_list is false
            return $res;
        }
    }

    return false;  // Return false if no results were found
}



public function getMerchantTypefromDb()
{
    // Retrieve the merchant ID first
   if(isset($_GET['id'])&&$_GET['id']>0){
      $merchant_id = $_GET['id'];
   }else{
     $merchant_id = $this->getMerchantID();
   }
   
    
    // Prepare the SQL query to fetch the merchant_type
    $sql = "SELECT merchant_type FROM mt_merchant WHERE merchant_id = :merchant_id";

    // Prepare the statement using PDO
    $stmt = $this->db->prepare($sql);

    // Bind the merchant ID parameter
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    $stmt->execute();

    // Fetch the result
    $merchant = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the merchant_type if found, or null if not
    return $merchant ? $merchant['merchant_type'] : null;
}



public function getMerchantTypeBySession()
    {
        if (!empty($_SESSION['kr_merchant_user'])){
            $user=json_decode($_SESSION['kr_merchant_user'],true);          
            //dump($user);
            if (is_array($user) && count($user)>=1){                
                return $user[0]['merchant_type'];
            }
        }
        return false;
    }
      public function ListlimitedPost()
    {
        return array(
          2=>$this->translation("default","Unlimited"),
          1=>$this->translation("default","Limited")
        );
    }

    public function statusList()
{
    return array(
     'publish'=>$this->translation("default",'Publish'),
     'pending'=>$this->translation("default",'Pending for review'),
     'draft'=>$this->translation("default",'Draft')
    );
}

public function itemlists_ad($merchant_id = '0', $as_list = true, $with_select = false)
{
    // Initialize the array to hold the data
    $data = [];
    
    // Prepare the SQL statement
    $stmt = $this->db->prepare("
        SELECT * FROM mt_item
        WHERE 
            merchant_id = :merchant_id
            AND status IN ('publish', 'published')
        ORDER BY item_name ASC
    ");
    
    // Bind the merchant ID to the query
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch the results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // If $with_select is true, add a "Please select" option at the start
    if ($with_select) {
        $data[] = t("Please select");
    }
    
    // If there are results
    if ($res) {
        // If $as_list is true, return an associative array with item IDs as keys and item names as values
        if ($as_list) {
            foreach ($res as $val) {
                $data[$val['item_id']] = ucwords(stripslashes($val['item_name']));
            }
            return $data;
        } else {
            // Otherwise, return the full result set
            return $res;
        }
    }
    
    // Return false if no results are found
    return false;
}
public function getSMSPackage()
{
    $stmt = "
        SELECT * FROM mt_sms_package
        WHERE status IN ('publish')
        ORDER BY sequence ASC
    ";

    $connection = $this->db; // Use PDO instance from the new MVC structure
    $query = $connection->prepare($stmt);
    $query->execute();
    
    $result = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($result) {
        return $result;
    }
    
    return false;
}

public function paymentStatus()
{
  return array(
   'pending'=>$this->translation("default",'pending'),
   'paid'=>$this->translation("default",'paid'),
   'draft'=>$this->translation("default",'Draft')
  );
}


public function getMerchantBalanceThisMonth($merchant_id = '')
{
    $and = ''; 
    $merchant_id = (int)$merchant_id;

    $status_based = array('paid');
    $used_status = '';
    $offline = "'cod','ocr','pyr','obd'";
    $status = $this->getOptionAdmin('total_commission_status');
    $include_all_offline_payment = $this->getOptionAdmin('admin_include_all_offline_payment');         

    if ($json = json_decode($status, true)) {
        $status_based = $json;
    }

    foreach ($status_based as $val) {
        $used_status .= "'" . $val . "',";
    }
    $used_status = rtrim($used_status, ',');

    if ($include_all_offline_payment != 1) {
        $and .= " AND payment_type NOT IN ($offline) ";
    }

    $query_date = date("Y-m-d");
    $range1 = date('Y-m-01', strtotime($query_date));
    $range2 = date('Y-m-t', strtotime($query_date));
    $and .= " AND DATE_FORMAT(date_created,'%Y-%m-%d') BETWEEN '$range1' AND '$range2' ";

    $stmt = "
        SELECT 
            sum(total_commission) as total_commission,
            sum(total_w_tax) as total_w_tax,
            count(*) as total_order
        FROM mt_order
        WHERE merchant_id = $merchant_id
        AND status IN ($used_status)
        $and
    ";

    $result = $this->db->query($stmt);
    if ($res = $result->fetch(PDO::FETCH_ASSOC)) {
        return array(
            'balance' => (float)$res['total_w_tax'] - (float)$res['total_commission'],
            'count' => (int)$res['total_order']
        );
    }

    return false;
}


 public function getMerchantTotalSales($merchant_id = '')
{
    $and = ''; 
    $merchant_id = (int)$merchant_id;

    $status_based = array('paid');
    $used_status = '';
    $offline = "'cod','ocr','pyr','obd'";
    $status = $this->getOptionAdmin('total_commission_status');
    $include_all_offline_payment = $this->getOptionAdmin('admin_include_all_offline_payment');         

    if ($json = json_decode($status, true)) {
        $status_based = $json;
    }

    foreach ($status_based as $val) {
        $used_status .= "'" . $val . "',";
    }
    $used_status = rtrim($used_status, ',');

    if ($include_all_offline_payment != 1) {
        $and .= " AND payment_type NOT IN ($offline) ";
    }

    $stmt = "
        SELECT 
            sum(total_w_tax) as total_w_tax,
            count(*) as total_order
        FROM mt_order
        WHERE status IN ($used_status)
        AND merchant_id = $merchant_id
        $and
    ";

    $result = $this->db->query($stmt);
    if ($res = $result->fetch(PDO::FETCH_ASSOC)) {
        return array(
            'balance' => (float)$res['total_w_tax'],
            'count' => (int)$res['total_order']
        );
    }

    return false;
}


  




     public function merchantList($as_list = true, $with_select = false) {
        $data = [];
        
        // PDO query using the Model's database connection
        $stmt = $this->db->prepare("SELECT * FROM mt_merchant WHERE status IN ('active') ORDER BY restaurant_name ASC");
        $stmt->execute();

        // If $with_select is true, add a "Please select" option
        if ($with_select) {
            $data[] = "Please select";
        }

        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            if ($as_list) {
                foreach ($res as $val) {
                    $data[$val['merchant_id']] = ucwords(stripslashes($val['restaurant_name']));
                }
                return $data;
            } else {
                return $res;
            }
        }

        return false;
    }


    public function getMerchantPromotionsByMinOrder($min = '', $merchant_id='', $id='')
{
    $stmt = "SELECT a.* 
             FROM mt_promotions a 
             WHERE min_order = :min_order 
             AND merchant_id = :merchant_id 
             AND id != :id 
             LIMIT 0, 1";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':min_order', $min, PDO::PARAM_STR);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':id', $id, PDO::PARAM_INT);
    $query->execute();
    $result = $query->fetch(PDO::FETCH_ASSOC);

    return $result ?: false;
}






  public function getMerchantListOfPaymentGateway()
{
    // Get the 'paymentgateway' option from admin settings
    $paymentgateway = $this->getOptionAdmin('paymentgateway');
    
    if (!empty($paymentgateway)) {
        $paymentgateway = json_decode($paymentgateway, true);
    } else {
        // Prepare the SQL statement using PDO
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_option 
            WHERE option_name = :option_name
        ");
        
        // Bind the parameter for 'option_name'
        $stmt->bindValue(':option_name', 'paymentgateway', PDO::PARAM_STR);

        // Execute the query
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            // If results are found, initialize an empty array
            if ($result) {
                $paymentgateway = array();
            } else {
                // Default payment gateways if no option is found
                $paymentgateway = array('pyp', 'stp', 'mcd', 'ide', 'payu', 'pys');
            }
        }
    }
    
    return $paymentgateway;
}





     public function hasMerchantAccessToMenu($user_access=array(), $tag='')
    {
        $tag = strtolower($tag);        
        $merchant_id=$this->getMerchantID();
        
        switch ($tag) {
            case "tablebooking":
                $tbl_booking=$this->getOption( $merchant_id ,'merchant_master_table_boooking');
                if($tbl_booking==1){
                    return false;
                }
                
                if ($this->getOptionAdmin('merchant_tbl_book_disabled')==2){               
                    return false;
                }
                break;

            case "mintable":    
                if ($this->isSearchByLocation()){
                    return false;
                }
                break;
        
            case "invoice":    
               if ( $merchant_type=$this->getMerchantMembershipType($merchant_id)){
                    if($merchant_type==1){
                        return false;
                    }           
                }
               break;
            
            case "sms-gateway":    
               $mechant_sms_enabled=$this->getOptionAdmin('mechant_sms_enabled');
               if ($mechant_sms_enabled=="yes"){
                   return false;    
               }
               break;
               
            case "purchasesms":   
            case "purchasesmstransaction":
               $mechant_sms_purchase_disabled=$this->getOptionAdmin('mechant_sms_purchase_disabled');
               if ( $mechant_sms_purchase_disabled=="yes"){
                    return false;
               }
               break;
               
            case "obdreceive":   
               $tag='obd';
              break;
              
            /*case "pyp":
               $tag="paypal";
               break;*/
               
            /*case "stp":
               $tag="stripe";
               break;   */
               
            /*case "mcd":
               $tag="mercadopago";
               break;      */
               
               
            case "commission":
            case "statement":
            case "earnings":
            case "withdrawals":
                $merchant_type =  $this->getMerchantTypeBySession();
                if($merchant_type==1){
                    return false;
                }       
                break;
                 
            default:
                break;
        }
        
        /*if ( $tag=="obdreceive"){
            $tag='obd';
        }*/ 
        
        $payment_list=$this->PaymentOptionList();     
        if (array_key_exists($tag,(array)$payment_list)){
            $list_payment_enabled=$this->getMerchantListOfPaymentGateway();                         
            if ( !in_array($tag,(array)$list_payment_enabled)){              
                 return false;
            } else {
                $master_key="merchant_switch_master_$tag";
                $master_key_val=$this->getOption($master_key,$merchant_id);
                if($master_key_val==1){
                    return false;
                }           
            }
        }
                
        if(!empty($user_access[0])){            
            if (in_array($tag,(array)$user_access)){
                return true;
            }
        } else {            
            return true;
        }    
        
        return false;
    }


    public function isMerchantExist($contact_email = '')
{
    $stmt = "
        SELECT * FROM mt_merchant
        WHERE contact_email = :contact_email
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':contact_email', $contact_email, PDO::PARAM_STR);
    $query->execute();
    
    $result = $query->fetch(PDO::FETCH_ASSOC);
    
    if ($result) {
        return $result;
    }
    
    return false;
}




public function insertData_bkup($table, $params) {
    // Basic sanitization for table name
    

    // Encode array values as JSON if needed
    foreach ($params as $key => $value) {
        if (is_array($value)) {
            $params[$key] = json_encode($value); // Encode arrays as JSON
        }
        if ($value === '') {
            $params[$key] = null; // Handle empty strings
        }
    }

    // Build the SQL query dynamically
    $columns = array();
    $placeholders = array();
    foreach ($params as $key => $value) {
        // Include only valid columns with non-null values
        if ($value !== '' && $value !== null) {
            $columns[] = $key;
            $placeholders[] = ":$key";
        }
    }

    // If no valid columns, return false
    if (empty($columns)) {
        return false;
    }

    //print_r( $placeholders);die();

    // Prepare the SQL query
    $sql = "INSERT INTO $table (" . implode(', ', $columns) . ") VALUES (" . implode(', ', $placeholders) . ")";

    // Debugging: Print SQL query and bound parameters
    //echo "SQL Query: $sql\n";
    //print_r($params);

    try {
        $stmt = $this->db->prepare($sql);

        // Debugging: Show bound parameters
        //echo "Bound Parameters:\n";
        /*foreach ($params as $key => $value) {
             "$key => $value\n";
        }*/

        $result = $stmt->execute($params);

        // Output success message
        //echo "Insert successful\n";
        return $result ? $this->db->lastInsertId() : false;
    } catch (PDOException $e) {
        // Handle error and print error message
        echo "Error: " . $e->getMessage();
        return false;
    }
}







    public function updateOption($option_name = '', $option_value = '', $merchant_id = '') {
        $and = '';
        if (!empty($merchant_id)) {
            $and = " AND merchant_id = :merchant_id ";
        }

        // Prepare the SELECT statement
        $stmt = "SELECT * FROM mt_option WHERE option_name = :option_name $and";
        $query = $this->db->prepare($stmt);
        $query->bindValue(':option_name', $option_name);
        if (!empty($merchant_id)) {
            $query->bindValue(':merchant_id', $merchant_id);
        }
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        // Prepare the parameters for INSERT/UPDATE
        $params = [
            'option_name' => $option_name,
            'option_value' => $option_value
        ];

        if (!empty($merchant_id)) {
            $params['merchant_id'] = $merchant_id;
        }






        //$command = $this->db->prepare();





        if (is_array($rows) && count($rows) >= 1) {
            // Update existing record
            $sql = "UPDATE mt_option SET option_value = :option_value WHERE option_name = :option_name AND merchant_id = :merchant_id";
            $query = $this->db->prepare($sql);
            $query->bindValue(':option_name', $option_name);
            $query->bindValue(':option_value', $option_value);
            $query->bindValue(':merchant_id', $merchant_id);

            return $query->execute();
        } else {
            // Insert new record
            $sql = "INSERT INTO mt_option (option_name, option_value" . (!empty($merchant_id) ? ", merchant_id" : "") . ") VALUES (:option_name, :option_value" . (!empty($merchant_id) ? ", :merchant_id" : "") . ")";
            $query = $this->db->prepare($sql);
            $query->bindValue(':option_name', $option_name);
            $query->bindValue(':option_value', $option_value);
            if (!empty($merchant_id)) {
                $query->bindValue(':merchant_id', $merchant_id);
            }

            return $query->execute();
        }

        return false;
    }

    public function preConfiguredSize()
   {       
       $size_list =  array(
         'small','medium','large'
       );
       
       $pre_configure_size = $this->getOptionAdmin('pre_configure_size');
       if(!empty($pre_configure_size)){
           $pre_configure_size = explode(",",$pre_configure_size);
           if(is_array($pre_configure_size) && count($pre_configure_size)>=1){
              $size_list = $pre_configure_size;
           }       
       }
               
       return $size_list;
   }


public function getMinOrderTable($mtid = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_minimum_table
        WHERE merchant_id = :merchant_id
        ORDER BY distance_to ASC
    ");

    $stmt->execute([':merchant_id' => $mtid]);

    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        return $res;
    }
    return false;
}






      public function autoAddSize($mtid='')
   {
         
        $size=$this->preConfiguredSize();
        if(is_array($size) && count($size)>=1){
            foreach ($size as $size_name) {
                $params_size=array(
                   'merchant_id'=>$mtid,
                   'size_name'=>$size_name,
                   'status'=>"publish",
                   'date_created'=>$this->dateNow(),
                   'ip_address'=>$_SERVER['REMOTE_ADDR'],
                   'size_name_trans'=>''
                );
                $this->insertData("mt_size",$params_size);
            }
        }      
       
   }

  public function insertCuisine($merchant_id = '', $cuisine = array()) {
        $merchant_id = (int)$merchant_id;

        // Delete existing cuisines for the merchant
        $stmt = "DELETE FROM mt_cuisine_merchant WHERE merchant_id = :merchant_id";
        $query = $this->db->prepare($stmt);
        $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->execute();

        // Insert new cuisines
        if (is_array($cuisine) && count($cuisine) >= 1) {
            $stmt = "INSERT INTO mt_cuisine_merchant (merchant_id, cuisine_id) VALUES (:merchant_id, :cuisine_id)";
            $query = $this->db->prepare($stmt);

            foreach ($cuisine as $cuisine_id) {
                $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
                $query->bindValue(':cuisine_id', (int)$cuisine_id, PDO::PARAM_INT);
                $query->execute();
            }
        }
    }

    public function insertTag($merchant_id = 0, $tag_id = array()) {
        $merchant_id = (int)$merchant_id;
        
        // Delete existing tags for the merchant
        $stmt = "DELETE FROM mt_option WHERE merchant_id = :merchant_id AND option_name = 'tags'";
        $query = $this->db->prepare($stmt);
        $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->execute();

        // Insert new tags
        if (is_array($tag_id) && count($tag_id) >= 1 && $merchant_id > 0) {
            $stmt = "INSERT INTO mt_option (merchant_id, option_name, option_value) VALUES (:merchant_id, 'tags', :option_value)";
            $query = $this->db->prepare($stmt);

            foreach ($tag_id as $tagid) {
                $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
                $query->bindValue(':option_value', (int)$tagid, PDO::PARAM_INT);
                $query->execute();
            }
        }
    }



    public function getMerchantPaymentMembership($merchant_id = '', $package_id = '')
{
    // Prepare the SQL statement
    $stmt = $this->db->prepare("SELECT * FROM mt_package_trans WHERE merchant_id = :merchant_id AND package_id = :package_id ORDER BY id DESC LIMIT 1");
    
    // Bind the parameters safely
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindParam(':package_id', $package_id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Check if any results were returned
    if ($stmt->rowCount() > 0) {
        // Fetch and return the first row
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }
    
    // Return false if no results found
    return false;
}







public function getPackagesById($package_id = '')
{
    $stmt = "
        SELECT * FROM mt_packages
        WHERE package_id = :package_id
        LIMIT 0,1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':package_id', $package_id, PDO::PARAM_INT);
    $query->execute();
    
    $result = $query->fetch(PDO::FETCH_ASSOC);
    
    if ($result) {
        return $result;
    }
    
    return false;
}

public function seo_friendly_url($string){
        $string = str_replace(array('[\', \']'), '', $string);
        $string = preg_replace('/\[.*\]/U', '', $string);
        $string = preg_replace('/&(amp;)?#?[a-z0-9]+;/i', '-', $string);
        $string = htmlentities($string, ENT_COMPAT, 'utf-8');
        $string = preg_replace('/&([a-z])(acute|uml|circ|grave|ring|cedil|slash|tilde|caron|lig|quot|rsquo);/i', '\\1', $string );
        $string = preg_replace(array('/[^a-z0-9]/i', '/[-]+/') , '-', $string);
        return strtolower(trim($string, '-'));
    }




    public function getCuisineBySlug($slug = '')
{
    if (!empty($slug)) {
        try {
            $query = "
                SELECT cuisine_id
                FROM mt_cuisine
                WHERE slug = :slug
                LIMIT 1
            ";

            $stmt = $this->db->prepare($query);
            $stmt->bindParam(':slug', $slug, PDO::PARAM_STR);

            if ($stmt->execute()) {
                $res = $stmt->fetch(PDO::FETCH_ASSOC);
                return $res ?: false; // Return the result or false if no row is found
            }
        } catch (PDOException $e) {
            // Log or handle the exception as needed
            return false;
        }
    }

    return false;
}



   public function createSlug($merchant_name='')
{
    // Sanitize input
    $merchant_name = str_replace("'", '', $merchant_name);

    // Prepare SQL statement
    $sql = "SELECT COUNT(*) AS total FROM mt_merchant WHERE restaurant_name LIKE :merchant_name LIMIT 1";

    // Prepare the PDO statement
    $stmt = $this->db->prepare($sql);
    
    // Bind parameters
    $stmt->bindValue(':merchant_name', "%$merchant_name%", PDO::PARAM_STR);

    // Execute the statement
    $stmt->execute();
    
    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Check the result and handle slug creation
    if ($res && $res['total'] == 0) {
        return $this->seo_friendly_url($merchant_name);
    } else {
        return $this->createSlug($merchant_name . $res['total']);
    }
}

public function customPageCreateSlug($page_name = '')
{
    // Use the seo_friendly_url function to convert the page name to a slug
    $slug_name = $this->seo_friendly_url($page_name);

    // Access the database via PDO from the Model class
    $stmt = $this->db->prepare("
        SELECT COUNT(*) as total
        FROM mt_custom_page
        WHERE slug_name = :slug_name
    ");

    // Bind the slug_name to the prepared statement
    $stmt->bindParam(':slug_name', $slug_name);

    // Execute the query
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Check if the slug already exists
    if ($res && $res['total'] >= 1) {
        // If it exists, append the total count to make the slug unique
        return $slug_name . $res['total'];
    } else {
        // If it doesn't exist, return the slug as is
        return $slug_name;
    }
}


   public function getDishInItem($dish_id = '') {
        // Create the wildcard search pattern for the LIKE clause
        $q = '%' . $dish_id . '%';
        
        // Prepare the SQL statement with placeholders
        $stmt = $this->db->prepare("
            SELECT category 
            FROM mt_item
            WHERE dish LIKE :dish
            LIMIT 0,1
        ");

        // Bind the parameter to the placeholder
        $stmt->bindParam(':dish', $q, PDO::PARAM_STR);

        // Execute the statement
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

    public function getCategoryInItem($category_id = '') {
        // Create the wildcard search pattern for the LIKE clause
        $q = '%' . $category_id . '%';

        // Prepare the SQL statement with placeholders
        $stmt = $this->db->prepare("
            SELECT category 
            FROM mt_item
            WHERE category LIKE :category
            LIMIT 0,1
        ");

        // Bind the parameter to the placeholder
        $stmt->bindParam(':category', $q, PDO::PARAM_STR);

        // Execute the statement
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

      public function getSizeInItem($size_id = '', $mtid = '') {
        // Create the wildcard search pattern for the LIKE clause
        $sizePattern = '%' . $size_id . '%';

        // Prepare the SQL statement with placeholders
        $stmt = $this->db->prepare("
            SELECT item_id, price
            FROM mt_item
            WHERE price LIKE :sizePattern
            AND merchant_id = :merchant_id
            LIMIT 0,1
        ");

        // Bind the parameters to the placeholders
        $stmt->bindParam(':sizePattern', $sizePattern, PDO::PARAM_STR);
        $stmt->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);

        // Execute the statement
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

      public function getMerchantPackageByID($package_id = '') {
        // Prepare the SQL statement with a placeholder for package_id
        $stmt = $this->db->prepare("
            SELECT package_id
            FROM mt_merchant
            WHERE package_id = :package_id
            LIMIT 0,1
        ");

        // Bind the package_id parameter to the placeholder
        $stmt->bindParam(':package_id', $package_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

    public function getMerchantByCuisine($cuisine_id = '') {
        // Prepare the SQL statement with a placeholder for cuisine
        $stmt = $this->db->prepare("
            SELECT cuisine 
            FROM mt_merchant
            WHERE cuisine LIKE :cuisine_id
            LIMIT 0,1
        ");

        // Prepare the search pattern with wildcards for the LIKE clause
        $cuisine_param = "%\"$cuisine_id\"%";
        
        // Bind the cuisine_id parameter to the placeholder
        $stmt->bindParam(':cuisine_id', $cuisine_param, PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($result) {
            return $result;
        } else {
            return false;
        }
    }


public function isTableExist($table_name = '')
{
    $table_name = 'mt_' . $table_name;
    $stmt = $this->db->prepare("SHOW TABLE STATUS LIKE :table_name");
    $stmt->bindValue(':table_name', $table_name, PDO::PARAM_STR);
    $stmt->execute();
    
    if ($stmt->fetch()) {
        return true;
    }
    return false;
}
   

  public function getMerchantBySlug($slug_id = '')
{
    // Enable big selects
    $this->db->query("SET SQL_BIG_SELECTS=1");

    // Prepare the SQL statement with a parameter placeholder for the slug
    $stmt = $this->db->prepare("SELECT *, 
        CONCAT(street, ' ', city, ' ', state, ' ', post_code) AS merchant_address 
        FROM mt_view_merchant 
        WHERE restaurant_slug = :slug_id 
        LIMIT 1");

    // Bind the slug parameter
    $stmt->bindValue(':slug_id', $slug_id);

    // Execute the query
    $stmt->execute();

    // Fetch a single row
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Return the result if found
    if ($res) {
        return $res;
    }

    // Return false if no result was found
    return false;
}
 





public function displaySpicyIconByID($item_id=1)
    {
        if ($resp=$this->getFoodItem($item_id)){
            return $this->displaySpicyIcon($resp['spicydish'],'',$resp['merchant_id']);
        }   
        return '';
    }

  public function assetsURL()
{
    return Config::$baseUrl."/assets";
}

    public function displaySpicyIcon($spicydish=1,$style='',$mtid='')
    {
        if ($spicydish==2){
            //$spicydish=Yii::app()->functions->getOptionAdmin('spicydish');
            $spicydish=$this->getOption('spicydish',$mtid);
            if (empty($spicydish)){
                $resp="<img class=\"spicydish-icon $style\" src=\"".$this->assetsURL()."/images/spicy.png"."\">";
            } else $resp="<img class=\"spicydish-icon $style\" src=\"".$this->uploadURL()."/$spicydish"."\">";
            return $resp;
        }
        return '';
    }





    public function getCategory($cat_id = '') {
        // Prepare the SQL statement with a placeholder for cat_id
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_category
            WHERE cat_id = :cat_id
            ORDER BY cat_id DESC
        ");

        // Bind the cat_id parameter to the placeholder
        $stmt->bindParam(':cat_id', $cat_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result or false if no data found
        return $result ? $result : false;
    }


    public  function getDishIcon($dishs='')
    {
        $data = array();
        $dish = json_decode($dishs,true);
        if(is_array($dish) && count($dish)>=1){
           foreach ($dish as $id) {
              if($res=$this->GetDish($id)){              
                 $data[]=$this->websiteUrl()."/upload/".$res['photo'];
              }
           }
           return $data;
        }
        return false;       
    }

   public function isClientExist1($email_address = '', $merchant_id = '') {   
    $stmt = "
        SELECT * FROM mt_client 
        WHERE email_address = :email_address   
        AND merchant_id = :merchant_id
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':email_address' => $email_address,
        ':merchant_id' => $merchant_id
    ]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}


  public function isClientExist_webappv2($email_address = '') {   
    $stmt = "
        SELECT * FROM mt_client 
        WHERE email_address = :email_address   
        AND social_strategy = :social_strategy
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':email_address' => $email_address,
        ':social_strategy' =>'webappv2'
    ]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}

public function isClientExist_webappv2_guest($email_address = '') {   
    $stmt = "
        SELECT * FROM mt_client 
        WHERE email_address = :email_address   
        AND social_strategy = :social_strategy
        AND is_guest = 1
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':email_address' => $email_address,
        ':social_strategy' => 'webappv2'
    ]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}





   public function isClientExist1_phone($contact_phone = '', $merchant_id = '') {   
    $stmt = "
        SELECT * FROM mt_client  WHERE contact_phone= :contact_phone AND merchant_id = :merchant_id     LIMIT 1 ";
    $query = $this->db->prepare($stmt);
    $query->execute([
        ':contact_phone' =>$contact_phone,
        ':merchant_id' => $merchant_id
    ]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }

    return false;
}




  public function getItemById($item_id = '', $addon = true)
{
    $data = [];

    // Prepare the SQL query
    $stmt = "
    SELECT * FROM mt_item
    WHERE item_id = :item_id
    LIMIT 1
    ";

    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);
    
    // Bind the parameter
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Fetch the result
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if results are found
    if ($res) {
        foreach ($res as $val) {
            $multi_option = $this->multiOptionToArray($val['multi_option']);
            $multi_option_val = $this->multiOptionToArray($val['multi_option_value']);
            $two_flavors_position = $this->multiOptionToArray($val['two_flavors_position']);
            $require_addon = $this->multiOptionToArray($val['require_addon']);
            $price = $this->sizePriceToArray($val['price'], $val['discount']);
            $cooking_ref = $this->cookingRefToArray($val['cooking_ref']);
            $addon_item = $this->addOnItemToArray(
                $val['addon_item'],
                $multi_option,
                $multi_option_val,
                $two_flavors_position,
                $require_addon,
                $val['merchant_id']
            );
            $ingredients = $this->ingredientsToArray($val['ingredients']);
            $cooking_ref2 = $this->cookingRefToArray2($val['cooking_ref']);

            // Structure data based on $addon flag
            if ($addon === true) {
                $data[] = [
                    'merchant_id' => $val['merchant_id'],
                    'item_id' => $val['item_id'],
                    'item_name' => $val['item_name'],
                    'item_description' => $val['item_description'],
                    'item_name_trans' => !empty($val['item_name_trans']) ? json_decode($val['item_name_trans'], true) : '',
                    'item_description_trans' => !empty($val['item_description_trans']) ? json_decode($val['item_description_trans'], true) : '',
                    'discount' => $val['discount'],
                    'photo' => $val['photo'],
                    'prices' => $price,
                    'is_variable_price' => $val['is_variable_price'],
                    'quantity' => $val['quantity'],
                    'cooking_ref' => $cooking_ref,
                    'cooking_ref_trans' => isset($cooking_ref2['cooking_name_trans']) ? $cooking_ref2['cooking_name_trans'] : '',
                    'addon_item' => $addon_item,
                    'ingredients' => $ingredients,
                    'barcode' => $val['barcode'],
                    'spicydish' => $val['spicydish'],
                    'dish' => $val['dish'],
                    'two_flavors' => $val['two_flavors'],
                    'gallery_photo' => $val['gallery_photo'],
                    'not_available' => $val['not_available'],
                ];
            } else {
                $data[] = [
                    'merchant_id' => $val['merchant_id'],
                    'item_id' => $val['item_id'],
                    'item_name' => $val['item_name'],
                    'item_description' => $val['item_description'],
                    'item_name_trans' => !empty($val['item_name_trans']) ? json_decode($val['item_name_trans'], true) : '',
                    'item_description_trans' => !empty($val['item_description_trans']) ? json_decode($val['item_description_trans'], true) : '',
                    'discount' => $val['discount'],
                    'photo' => $val['photo'],
                    'barcode' => $val['barcode'],
                    'is_variable_price' => $val['is_variable_price'],
                    'quantity' => $val['quantity'],
                    'prices' => $price,
                    'ingredients' => $ingredients,
                    'spicydish' => $val['spicydish'],
                    'dish' => $val['dish'],
                    'two_flavors' => $val['two_flavors'],
                    'gallery_photo' => $val['gallery_photo'],
                    'not_available' => $val['not_available'],
                ];
            }
        }
        return $data; // Return the constructed data
    }
    return false; // Return false if no result is found
}



  public function getItemById_pos($item_id = '', $addon = true)
{
    $data = [];

    // Prepare the SQL query
    $stmt = "
    SELECT * FROM mt_item
    WHERE item_id = :item_id
    LIMIT 1
    ";

    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);
    
    // Bind the parameter
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Fetch the result
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if results are found
    if ($res) {
        foreach ($res as $val) {
            $multi_option = $this->multiOptionToArray($val['multi_option']);
            $multi_option_val = $this->multiOptionToArray($val['multi_option_value']);
            $two_flavors_position = $this->multiOptionToArray($val['two_flavors_position']);
            $require_addon = $this->multiOptionToArray($val['require_addon']);
            $price = $this->sizePriceToArray_pos($val['price'], $val['discount']);
            $price_dinein = $this->sizePriceToArray_pos($val['price_dinein'], $val['discount']);
            $cooking_ref = $this->cookingRefToArray($val['cooking_ref']);
            $addon_item = $this->addOnItemToArray(
                $val['addon_item'],
                $multi_option,
                $multi_option_val,
                $two_flavors_position,
                $require_addon,
                $val['merchant_id']
            );
            $ingredients = $this->ingredientsToArray($val['ingredients']);
            $cooking_ref2 = $this->cookingRefToArray2($val['cooking_ref']);

            // Structure data based on $addon flag
            if ($addon === true) {
                $data[] = [
                    'merchant_id' => $val['merchant_id'],
                    'item_id' => $val['item_id'],
                    'item_name' => $val['item_name'],
                    'item_description' => $val['item_description'],
                    'item_name_trans' => !empty($val['item_name_trans']) ? json_decode($val['item_name_trans'], true) : '',
                    'item_description_trans' => !empty($val['item_description_trans']) ? json_decode($val['item_description_trans'], true) : '',
                    'discount' => $val['discount'],
                    'photo' => $val['photo'],
                    'prices' => $price,
                    //'prices_dinein' => $price_dinein,
                    'is_variable_price' => $val['is_variable_price'],
                    'quantity' => $val['quantity'],
                    'cooking_ref' => $cooking_ref,
                    'cooking_ref_trans' => isset($cooking_ref2['cooking_name_trans']) ? $cooking_ref2['cooking_name_trans'] : '',
                    'addon_item' => $addon_item,
                    'ingredients' => $ingredients,
                    'barcode' => $val['barcode'],
                    'spicydish' => $val['spicydish'],
                    'dish' => $val['dish'],
                    'two_flavors' => $val['two_flavors'],
                    'gallery_photo' => $val['gallery_photo'],
                    'not_available' => $val['not_available'],
                ];
            } else {
                $data[] = [
                    'merchant_id' => $val['merchant_id'],
                    'item_id' => $val['item_id'],
                    'item_name' => $val['item_name'],
                    'item_description' => $val['item_description'],
                    'item_name_trans' => !empty($val['item_name_trans']) ? json_decode($val['item_name_trans'], true) : '',
                    'item_description_trans' => !empty($val['item_description_trans']) ? json_decode($val['item_description_trans'], true) : '',
                    'discount' => $val['discount'],
                    'photo' => $val['photo'],
                    'barcode' => $val['barcode'],
                    'is_variable_price' => $val['is_variable_price'],
                    'quantity' => $val['quantity'],
                    'prices' => $price,
                    //'prices_dinein' => $price_dinein,
                    'ingredients' => $ingredients,
                    'spicydish' => $val['spicydish'],
                    'dish' => $val['dish'],
                    'two_flavors' => $val['two_flavors'],
                    'gallery_photo' => $val['gallery_photo'],
                    'not_available' => $val['not_available'],
                ];
            }
        }
        return $data; // Return the constructed data
    }
    return false; // Return false if no result is found
}


public function getItemById_dine($item_id='',$addon=true)
{       
  $data=array();    
  $stmt="SELECT * FROM
  mt_item
  WHERE
  item_id = ".($item_id)."
  LIMIT 0,1   
  ";        
  if($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)){
    foreach ($res as $val) {        
                      
      $multi_option=$this->multiOptionToArray($val['multi_option']);
      $multi_option_val=$this->multiOptionToArray($val['multi_option_value']);
      $two_flavors_position=$this->multiOptionToArray($val['two_flavors_position']);
      
      $require_addon=$this->multiOptionToArray($val['require_addon']);              
                                    
      $price=$this->sizePriceToArray_pos($val['price_dinein'],$val['discount']);            
      $cooking_ref=$this->cookingRefToArray($val['cooking_ref']);
      
      $addon_item=$this->addOnItemToArray(
        $val['addon_item'],
        $multi_option,$multi_option_val,
        $two_flavors_position,
        $require_addon,
        $val['merchant_id']
      );
      $ingredients=$this->ingredientsToArray($val['ingredients']);
      
      $cooking_ref2=$this->cookingRefToArray2($val['cooking_ref']);       
      
      if ($addon==TRUE){
        $data[]=array(
          'merchant_id'=>$val['merchant_id'],
          'item_id'=>$val['item_id'],
          'item_name'=>$val['item_name'],
          'item_description'=>$val['item_description'],
          'item_name_trans'=>!empty($val['item_name_trans'])?json_decode($val['item_name_trans'],true):'',
          'item_description_trans'=>!empty($val['item_description_trans'])?json_decode($val['item_description_trans'],true):'',
          'discount'=>$val['discount'],
          'photo'=>$val['photo'],
          'prices'=>$price,
          'is_variable_price'=>$val['is_variable_price'],
          'quantity'=>$val['quantity'],
          
          'cooking_ref'=>$cooking_ref,          
          'cooking_ref_trans'=>isset($cooking_ref2['cooking_name_trans'])?$cooking_ref2['cooking_name_trans']:'',
          'addon_item'=>$addon_item,
          'ingredients'=>$ingredients,
          'barcode'=>$val['barcode'],
          'spicydish'=>$val['spicydish'],
          'dish'=>$val['dish'],
          'two_flavors'=>$val['two_flavors'],
          'gallery_photo'=>$val['gallery_photo'],
          'not_available'=>$val['not_available']
        );  
      } else {
        $data[]=array(
          'merchant_id'=>$val['merchant_id'],
          'item_id'=>$val['item_id'],
          'item_name'=>$val['item_name'],
          'item_description'=>$val['item_description'],
          'item_name_trans'=>!empty($val['item_name_trans'])?json_decode($val['item_name_trans'],true):'',
          'item_description_trans'=>!empty($val['item_description_trans'])?json_decode($val['item_description_trans'],true):'',
          'discount'=>$val['discount'],
          'photo'=>$val['photo'],
          'barcode'=>$val['barcode'],
          'is_variable_price'=>$val['is_variable_price'],
          'quantity'=>$val['quantity'],
          'prices'=>$price,         
          'ingredients'=>$ingredients,
          'spicydish'=>$val['spicydish'],
          'dish'=>$val['dish'],
          'two_flavors'=>$val['two_flavors'],
          'gallery_photo'=>$val['gallery_photo'],
          'not_available'=>$val['not_available']      
        );        
      }
    }     
    return $data;
  }
  return false;
}



public function getMerchantUserInfobymid($merchant_user_id = '')
{
    $mid = $this->getMerchantID();
    
    // Prepare the SQL query
    $stmt = "
    SELECT * FROM mt_merchant_user
    WHERE merchant_user_id = :merchant_user_id
    LIMIT 1
    ";

    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);
    
    // Bind the parameter
    $query->bindParam(':merchant_user_id', $merchant_user_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    // Check if a result is found
    if ($res) {
        return $res; // Return the merchant user information
    }
    
    return false; // Return false if no result is found
}




    public function cookingRefToArray2($json_data='')
    {
        $data=array();
        $json_data=!empty($json_data)?json_decode($json_data):false;                
        if ( $json_data!=false){
            foreach ($json_data as $cooking_id) {               
                $info=$this->getCookingRef($cooking_id);
                $data['cooking_name_trans']=!empty($info['cooking_name_trans'])?json_decode($info['cooking_name_trans'],true):'';
            }
            return $data;
        }
        return false;
    }    


    public function ingredientsToArray($json_data='')
    {
        $data=array();
        $json_data=!empty($json_data)?json_decode($json_data,true):false;       
        $cooking_ref=$this->getIngredientsAll();        
        //if ( $json_data!=false){
        if(is_array($json_data) && count((array)$json_data)>=1){
            foreach ($json_data as $cooking_id) {
                if (array_key_exists($cooking_id,(array)$cooking_ref)){
                    $data[$cooking_id]=$cooking_ref[$cooking_id];
                }
            }
            return $data;
        }
        return false;
    }

public function getIngredientsAll()
{       
    $data_feed = [];
    
    // Prepare the SQL query
    $stmt = "
    SELECT * FROM mt_ingredients     
    WHERE status IN ('publish') 
    ORDER BY sequence ASC
    ";
    
    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);
    
    // Execute the query
    $query->execute();
    
    // Fetch all the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);
    
    // Check if results are found
    if ($res) {
        // If the $this->data is "list", format the result as key-value pairs
        if ($this->data == "list") {
            foreach ($res as $val) {
                $data_feed[$val['ingredients_id']] = $val['ingredients_name'];
            }
            return $data_feed; // Return the formatted list
        } else {
            return $res; // Return the raw results
        }
    }
    
    return false; // Return false if no result is found
}


    public function cookingRefToArray($json_data='')
    {
        $data=array();
        $json_data=!empty($json_data)?json_decode($json_data,true):false;       
        $cooking_ref=$this->getCookingRefAll();     
        //if ( $json_data!=false){
        if(is_array($json_data) && count((array)$json_data)>=1){
            foreach ($json_data as $cooking_id) {
                if (array_key_exists($cooking_id,(array)$cooking_ref)){
                    $data[$cooking_id]=$cooking_ref[$cooking_id];
                }
            }
            return $data;
        }
        return false;
    }

public function getCookingRefAll()
{
    $data_feed = [];

    // Prepare the SQL query
    $stmt = "
    SELECT * FROM mt_cooking_ref
    ORDER BY sequence ASC
    ";
    
    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);

    // Execute the query
    $query->execute();

    // Fetch all the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if results are found
    if ($res) {
        // If the $this->data is "list", format the result as key-value pairs
        if ($this->data == "list") {
            foreach ($res as $val) {
                $data_feed[$val['cook_id']] = $val['cooking_name'];
            }
            return $data_feed; // Return the formatted list
        } else {
            return $res; // Return the raw results
        }
    }

    return false; // Return false if no result is found
}
    


    public function sizePriceToArray($json_data='',$discount='')
    {       
        $this->data='list';
        $data=array();
        $size=$this->getSizeListAll(); 



        $json_data=!empty($json_data)?json_decode($json_data,true):false; 
       
        if(is_array($json_data) && count($json_data)>=1){
            foreach ($json_data as $size_id=>$price) {              
                if (array_key_exists($size_id,(array)$size)){                   
                    
                    $size_info=$this->getSize($size_id);        
                    
                    if(isset($size[$size_id])){
                       $size_name = $size[$size_id];
                    } else $size_name='';

                                    
                    $formatted_price = $this->formatNumber($price);
                    
                    $discount_price = 0;
                    if($discount>=0.001){
                        $discount_price = $price-$discount;
                    }
                    
                    $data[]=array(
                      'price'=>$price,
                      'size'=>$size[$size_id],
                      'size_id'=>$size_id,
                      'size_trans'=>!empty($size_info['size_name_trans'])?json_decode($size_info['size_name_trans'],true):'',
                      'formatted_price'=>$formatted_price,
                      'discount_price'=>$discount_price,
                      'formatted_discount_price'=>$this->formatNumber($discount_price)
                    );
                    
                } else {



                    $data[]=array(
                      'price'=>$price,
                    );
                }
            }
            return $data;
        }
        return false;
    }


     public function sizePriceToArray_pos($json_data='',$discount='')
    {       
        $this->data='list';
        $data=array();
        $size=$this->getSizeListAll(); 



        $json_data=!empty($json_data)?json_decode($json_data,true):false; 
       
        if(is_array($json_data) && count($json_data)>=1){
            foreach ($json_data as $size_id=>$price) {              
                if (array_key_exists($size_id,(array)$size)){                   
                    
                    $size_info=$this->getSize($size_id);        
                    
                    if(isset($size[$size_id])){
                       $size_name = $size[$size_id];
                    } else $size_name='';

                                    
                    $formatted_price = $this->formatNumber_pos($price);
                    
                    $discount_price = 0;
                    if($discount>=0.001){
                        $discount_price = $price-$discount;
                    }
                    
                    $data[]=array(
                      'price'=>$price,
                      'size'=>$size[$size_id],
                      'size_id'=>$size_id,
                      'size_trans'=>!empty($size_info['size_name_trans'])?json_decode($size_info['size_name_trans'],true):'',
                      'formatted_price'=>$formatted_price,
                      'discount_price'=>$discount_price,
                      'formatted_discount_price'=>$this->formatNumber_pos($discount_price)
                    );
                    
                } else {



                    $data[]=array(
                      'price'=>$price,
                    );
                }
            }
            return $data;
        }
        return false;
    }




    public function getSizeListAll()
{
    $data_feed[]='';
    
    // Prepare the SQL query
    $stmt = "
    SELECT * FROM mt_size
    ORDER BY sequence ASC
    ";
    
    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);

    // Execute the query
    $query->execute();

    // Fetch all the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if results are found
    if ($res) {
        // If the $this->data is "list", format the result as key-value pairs
        if ($this->data == "list") {
            foreach ($res as $val) {
                $data_feed[$val['size_id']] = $val['size_name'];
            }
            return $data_feed; // Return the list of sizes
        } else {
            return $res; // Return the raw results
        }
    }

    return false; // Return false if no result is found
}



    public function addOnItemToArray($json_data='',$multi_option='',$multi_option_val='',$two_flavors_position='',$require_addon='',$merhant_id='')
    {       
                                
        $data=array();
        $data_sub=array();
        $json_data=!empty($json_data)?json_decode($json_data):false;        
        $this->data="list";
        $sub_category=$this->getSubcategory2($merhant_id);      
        //dump($sub_category);
                
        if ( $json_data!=FALSE ){
            foreach ($json_data as $sub_id=>$val) {                             
                if (array_key_exists($sub_id,(array)$sub_category)){
                    foreach ($val as $subitem_id) {                     
                        if ($subitem_details=$this->getAddonItem($subitem_id,'sequence')){  
                                                        
                            $data_sub[]=array(
                              'sub_item_id'=>$subitem_details['sub_item_id'],
                              'sub_item_name'=>$subitem_details['sub_item_name'],
                              'item_description'=>$subitem_details['item_description'],
                              'price'=>$subitem_details['price'],
                              'photo'=>$subitem_details['photo'],
                              'sub_item_name_trans'=>!empty($subitem_details['sub_item_name_trans'])?json_decode($subitem_details['sub_item_name_trans'],true):'',
                              'item_description_trans'=>!empty($subitem_details['item_description_trans'])?json_decode($subitem_details['item_description_trans'],true):'',
                              'pretty_price'=>$this->formatNumber($subitem_details['price'])
                            );
                        }                       
                    }
                    
                    $multi_options='';                  
                    if (array_key_exists($sub_id,(array)$multi_option)){                        
                        $multi_options=$multi_option[$sub_id];
                    }
                    
                    $multi_option_vals='';
                    if (array_key_exists($sub_id,(array)$multi_option_val)){                        
                        $multi_option_vals=$multi_option_val[$sub_id];
                    }
                    
                    $two_flavor='';
                    if (array_key_exists($sub_id,(array)$two_flavors_position)){                        
                        $two_flavor=$two_flavors_position[$sub_id];
                    }
                                        
                    $require_addons='';
                    if (array_key_exists($sub_id,(array)$require_addon)){                                               
                        $require_addons=$require_addon[$sub_id];
                    }
                                                
                    $data[]=array(
                      'subcat_id'=>$sub_id,
                      'subcat_name'=>$sub_category[$sub_id],
                      'subcat_name_trans'=>$this->getSubcategoryTranslation($sub_id),
                      'multi_option'=>$multi_options,
                      'multi_option_val'=>$multi_option_vals,
                      'two_flavor_position'=>$two_flavor,
                      'require_addons'=>$require_addons,
                      'sub_item'=>$data_sub                   
                    );
                    //$data_sub='';
                    unset($data_sub);
                }           
            }
            //dump($data);
            return $data;
        }
        return false;
    }

 public function getSubcategoryTranslation($subcat_id = '')
{
    // Prepare the SQL query
    $stmt = "
    SELECT subcategory_name_trans, subcategory_description_trans
    FROM mt_subcategory
    WHERE subcat_id = :subcat_id
    LIMIT 0,1
    ";

    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);

    // Bind the subcat_id parameter securely
    $query->bindValue(':subcat_id', $subcat_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch the result
    $res = $query->fetch(PDO::FETCH_ASSOC);

    // Check if a result was found
    if ($res) {
        // If subcategory_name_trans is not empty, decode the JSON and return it
        if (!empty($res['subcategory_name_trans'])) {
            return json_decode($res['subcategory_name_trans'], true);
        }
    }

    // Return empty string if no result or no translation
    return '';
}


  public function getSubcategory2($merchant_id = '')
{
    // Check for merchant_id in session
    if (isset($_SESSION['kr_merchant_id'])) {
        $merchant_id = $_SESSION['kr_merchant_id'];
    }

    $data_feed = array();

    // Prepare the SQL query
    $stmt = "
    SELECT *
    FROM mt_subcategory
    WHERE
    merchant_id = :merchant_id
    AND status IN ('publish', 'published')
    ORDER BY sequence ASC
    ";

    // Prepare the PDO statement
    $query = $this->db->prepare($stmt);
    
    // Bind the merchant_id parameter securely
    $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch all rows
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if rows are returned
    if (is_array($rows) && count($rows) >= 1) {
        // Check if the data should be returned as a 'list'
        if ($this->data == "list") {
            foreach ($rows as $val) {
                // Add subcategory names to the list with their respective subcat_id as the key
                $data_feed[$val['subcat_id']] = $val['subcategory_name'];
            }
            return $data_feed; // Return as list
        } else {
            return $rows; // Return all rows if not 'list'
        }
    }

    return FALSE; // Return false if no rows are found
}


    public function multiOptionToArray($json_data='')
    {
        $data=array();
        $json_data=!empty($json_data)?(array)json_decode($json_data):false;     
        if (is_array($json_data) && count($json_data)>=1){
            foreach ($json_data as $key=>$val) {                
                $data[$key]=$val[0];
            }
            return $data;
        }
        return false;
    }




    public function GetDish($id = '')
{
    if (empty($id)) {
        return false;
    }

    try {
        // Prepare the SQL statement
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_dishes 
            WHERE dish_id = :id 
            LIMIT 0, 1
        ");

        // Bind the parameter to avoid SQL injection
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the first result if available
        if ($res) {
            return $res;
        }

    } catch (PDOException $e) {
        // Handle any database errors here
        return false;
    }

    return false;
}


    public function Getbranch_byid($id = '')
{
    if (empty($id)) {
        return false;
    }

    try {
        // Prepare the SQL statement
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_branches 
            WHERE id = :id 
            LIMIT 0, 1
        ");

        // Bind the parameter to avoid SQL injection
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $res = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the first result if available
        if ($res) {
            return $res;
        }

    } catch (PDOException $e) {
        // Handle any database errors here
        return false;
    }

    return false;
}


 



    public function getAddonItem($sub_item_id = '') {
        // Prepare the SQL statement with a placeholder for sub_item_id
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_subcategory_item
            WHERE sub_item_id = :sub_item_id
            LIMIT 1
        ");

        // Bind the sub_item_id parameter to the placeholder
        $stmt->bindParam(':sub_item_id', $sub_item_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result or false if no data found
        return $result ? $result : false;
    }


    public function insertSubcategoryItemRelationship($sub_item_id=0, $data=array())
  {
    $this->deleteSubcategoryItem($sub_item_id);    
    if(is_array($data) && count($data)>=1){
      foreach ($data as $subcat_id) {
        $params = array(
          'subcat_id'=>(integer)$subcat_id,
          'sub_item_id'=>(integer)$sub_item_id
        );        
         
        $this->insertData('mt_subcategory_item_relationships', $params);       
      }
    }
  }

  public function deleteSubcategoryItem($sub_item_id = '')
{
    try {
        // Prepare the SQL DELETE statement using the PDO instance stored in $this->db
        $stmt = $this->db->prepare("DELETE FROM mt_subcategory_item_relationships WHERE sub_item_id = :sub_item_id");

        // Bind the sub_item_id parameter as an integer
        $stmt->bindParam(':sub_item_id', $sub_item_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Check if any row was deleted
        return $stmt->rowCount() > 0;

    } catch (PDOException $e) {
        // Handle any errors
        echo "Error: " . $e->getMessage();
        return false;
    }
}




    public function getSizeTranslation($size_name = '', $mt_id = '')
{
    $pdo = $this->db; // Assuming $this->db is your PDO connection instance

    $stmt = "
        SELECT * 
        FROM mt_size
        WHERE size_name = :size_name
        AND merchant_id = :merchant_id
        LIMIT 1
    ";

    $query = $pdo->prepare($stmt);
    $query->bindParam(':size_name', $size_name, PDO::PARAM_STR);
    $query->bindParam(':merchant_id', $mt_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            $t['size_name_trans'] = !empty($res['size_name_trans']) ? json_decode($res['size_name_trans'], true) : '';
            return $t;
        }
    }

    return false;
}




public function getCookingTranslation($name = '', $mt_id = '')
{
    $pdo = $this->db; // Assuming $this->db is your PDO connection instance

    $stmt = "
        SELECT * 
        FROM mt_cooking_ref
        WHERE cooking_name = :cooking_name
        AND merchant_id = :merchant_id
        LIMIT 1
    ";

    $query = $pdo->prepare($stmt);
    $query->bindParam(':cooking_name', $name, PDO::PARAM_STR);
    $query->bindParam(':merchant_id', $mt_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        if ($res) {
            $t['cooking_name_trans'] = !empty($res['cooking_name_trans']) ? json_decode($res['cooking_name_trans'], true) : '';
            return $t;
        }
    }

    return false;
}










       public function getFoodItem($item_id = '') {
        // Prepare the SQL statement with a placeholder for item_id
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_item
            WHERE item_id = :item_id
            LIMIT 1
        ");

        // Bind the item_id parameter to the placeholder
        $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result or false if no data found
        return $result ? $result : false;
    }




      public function getDishx($id = '') {
        // Prepare the SQL statement with a placeholder for dish_id
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_dishes
            WHERE dish_id = :dish_id
            LIMIT 1
        ");

        // Bind the id parameter to the placeholder
        $stmt->bindParam(':dish_id', $id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result or false if no data found
        return $result ? $result : false;
    }

   public function getItemByCategory_promo_checks($merchant_id = '', $min = '', $getthepromolist_id = '')
{
    try {
        // SQL query with placeholders for safe parameter binding
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_promotions 
            WHERE id = :getthepromolist_id 
            AND min_order <= :min 
            AND merchant_id = :merchant_id 
            LIMIT 0,1
        ");
        
        // Binding parameters to prevent SQL injection
        $stmt->bindParam(':getthepromolist_id', $getthepromolist_id, PDO::PARAM_INT);
        $stmt->bindParam(':min', $min, PDO::PARAM_INT);
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_STR);

        // Execute the statement
        $stmt->execute();

        // Check if a result exists
        if ($stmt->rowCount() > 0) {
            return 1;
        } else {
            return 0;
        }
    } catch (Exception $e) {
        // Handle any potential exceptions
        return 0;
    }
}


  public function DeliveryOptions($merchant_id='')
    {       
        if ( $res=$this->getMerchant($merchant_id)){

            switch ($res['service']) {
                case 2:
                    return array(
                       'delivery'=>$this->translation("default","Delivery"),
                    );
                    break;
                case 3:
                    return array(
                        'pickup'=>$this->translation("default","Pickup")          
                    );
                    break;
                    
                case 4: 
                   return array(
                       'delivery'=>$this->translation("default","Delivery"),
                       'pickup'=>$this->translation("default","Pickup"),
                       'dinein'=>$this->translation("default","Dinein")
                    );
                   break;
                   
                case 5: 
                   return array(
                       'delivery'=>$this->translation("default","Delivery"),                       
                       'dinein'=>$this->translation("default","Dinein")
                    );
                   break;
                   
                case 6: 
                   return array(
                       'pickup'=>$this->translation("default","Pickup"),
                       'dinein'=>$this->translation("default","Dinein")
                    );
                   break;   
                  
                case 7: 
                   return array(                       
                       'dinein'=>$this->translation("default","Dinein")
                    );
                   break;       
                      
                default:
                    return array(
                       'delivery'=>$this->translation("default","Delivery"),
                       'pickup'=>$this->translation("default","Pickup") 
                    );
                    break;
            }
        } else {
            return array(
              'delivery'=>$this->translation("default","Delivery"),
              'pickup'=>$this->translation("default","Pickup") 
            );
        }
    }



      public function isMerchantOpenTimes($merchant_id='',$full_booking_day='',$booking_time='')
    {
     $business_hours=$this->getBusinnesHours($merchant_id);
     //dump($business_hours);    
     /*dump($merchant_id);
     dump($full_booking_day);
     dump($booking_time);*/
    if (is_array($business_hours) && count($business_hours)>=1){
      if (!array_key_exists($full_booking_day,$business_hours)){
        return false;
      } else {
        if (!empty($booking_time)){
          if (array_key_exists($full_booking_day,$business_hours)){           
            $selected_date=$business_hours[$full_booking_day];                    
            //dump($selected_date);
            $temp_selected=explode(",",$selected_date); 
            //dump($temp_selected); 
                        
            if(is_array($temp_selected) && count($temp_selected)>=1){             
              if ( empty($temp_selected[0])){
                  if (!empty($temp_selected[1])){
                    $temp_selected[0]=$temp_selected[1];
                  }
              }
            }
            
            $selected_date=explode("-",$temp_selected[0]);
            //dump($selected_date);
            $t1=trim($selected_date[0]);
            $t2=trim($selected_date[1]);
                                    
            if ( !$this->checkBetweenTime($booking_time,$t1,$t2)){  
              if (isset($selected_date[1])){                        
                if(!isset($temp_selected[1])){
                  $temp_selected[1]='';
                }
                $selected_date=explode("-",$temp_selected[1]);
                if(!isset($selected_date[1])){
                  $selected_date[1]='';
                }
                $t1=trim($selected_date[0]);
                    $t2=trim($selected_date[1]);                    
                    if ( $this->checkBetweenTime($booking_time,$t1,$t2)){
                      return true;
                    } 
              }                   
              return false;
            }
          }
        }
      }
    }             
    return true;              
    }


    public function checkBetweenTime($current_time='',$sunrise='',$sunset='')
    {     
      /*refference http://stackoverflow.com/questions/15911312/how-to-check-if-time-is-between-two-times-in-php*/     
        /*$current_time = "09:55 AM";
        $sunrise = "09:00 AM";
        $sunset = "07:30 PM";*/    
        /*dump($current_time);   
        dump($sunrise);
        dump($sunset);*/
    $date1 = DateTime::createFromFormat('H:i a', $current_time);    
    $date2 = DateTime::createFromFormat('H:i a', $sunrise);   
    $date3 = DateTime::createFromFormat('H:i a', $sunset);    
    if ($date1 >= $date2 && $date1 <= $date3) {     
        return true;
    } 
    return false;
    }  



     public  function getDateList($merchant_id='')
    {
      $dates = array();
      $mt_timezone=$this->getOption("merchant_timezone",$merchant_id);
    if(!empty($mt_timezone)){
      
      date_default_timezone_set($mt_timezone);
    }
    
    $day=$this->getOption("stores_open_day",$merchant_id);
    $day_open=!empty($day)?json_decode($day,true):false;
        
    $nos_days = 2;
    $merchant_preorder = $this->getOption('merchant_preorder',$merchant_id);

    if($merchant_preorder!=1){
      $nos_days = 1;
    }    
        
    if(is_array($day_open) && count($day_open)>=1){
      
      for ($i = 0; $i < $nos_days; $i++) {        
        $key=date("Y-m-d",strtotime("+$i day"));
        $key_day = strtolower(date("l",strtotime($key)));
        if(in_array($key_day,(array)$day_open)){
          $dates[$key] = $this->prettyDate($key);
        }
      }
    } else {      
      for ($i = 0; $i < $nos_days; $i++) {        
        $key=date("Y-m-d",strtotime("+$i day"));
        $dates[$key] = $this->prettyDate(date("D F d Y",strtotime("+$i day")));
      }
    }
    
    return $dates;
    }


    public  function getTimeList($merchant_id='', $delivery_date='')
    {
      $times = array(); 
    $date_now = date("Y-m-d");
    $time_start = '7:30'; $time_end = '18:30'; $interval = '15 mins';   
    
    $mt_timezone=$this->getOption("merchant_timezone",$merchant_id);
    if(!empty($mt_timezone)){
      
      date_default_timezone_set($mt_timezone);
    }
      
      $delivery_day = isset($delivery_date)?date("l",strtotime($delivery_date)): date("l") ;
       $delivery_day = strtolower($delivery_day);           
      if ( $res = $this->getOpeningHours($merchant_id) ){             
      if (array_key_exists($delivery_day,(array)$res)){         
        $time_based = $res[$delivery_day]['hours'];       
        if(!empty($time_based)){          
                      
          $time_based_ex='';
          if (preg_match("/x/i", $time_based)) {              
            $time_based_sep = explode("x",$time_based);                           
            $time_based_sep_1 = explode("-",$time_based_sep[0]);
            $time_based_sep_2 = explode("-",$time_based_sep[1]);
            $time_based_start = $time_based_sep_1[0];
            $time_based_end = $time_based_sep_2[1];
            
            $time_based_combined = "$time_based_start-$time_based_end";             
            $time_based_ex = explode("-",$time_based_combined);
          } else $time_based_ex = explode("-",$time_based);
                      
          //dump($time_based_ex);
                      
          if(is_array($time_based_ex) && count($time_based_ex)>=1){           
            $time_start = $time_based_ex[0];
            //$time_end = $time_based_ex[1];
            $time_end = date("G:i",strtotime($time_based_ex[1]));

            /*CHECK IF SAME DAY*/
            if ($delivery_date==$date_now){
              $hour_now = date("Gi");
              $hour_now_l = date("G:i");
              $time_start_1 = date("Gi",strtotime($time_start));                
              if($hour_now>$time_start_1){
                $time_start = $hour_now_l;
              }
            }
                          
          }
        }
      } 
      }     
            
            
      /*CONVERT TO WHOLE NUMBER*/
      
      $enabled_whole_number = false;
      
      if($enabled_whole_number){
        if(!empty($time_start)){
          $time_s = explode(":",$time_start);
          if(is_array($time_s) && count($time_s)>=1){
            if(isset($time_s[1])){              
              $rounded_minutes = round($time_s[1],-1);                  
              if($rounded_minutes>=60){
              } else {            
                $time_start =$time_s[0].":$rounded_minutes";
              }           
            }
          }
        }    
      }
                   
      $time_interval = 15; 
      
      $website_time_picker_interval= $this->getOptionAdmin('website_time_picker_interval');
      if($website_time_picker_interval>0){
        $time_interval=$website_time_picker_interval;
      }    
      
      /*GET MERCHANT TIME INTERVAL*/
      $website_merchant_time_picker_interval = $this->getOption('website_delivery_merchant_time_picker_interval',$merchant_id);
      if($website_merchant_time_picker_interval>0){
        $time_interval = $website_merchant_time_picker_interval;
      }    
            
      $time_format = 12;
      
      $website_time_picker_format = $this->getOptionAdmin('website_time_picker_format');      
      if(!empty($website_time_picker_format)){
        $time_format = $website_time_picker_format;
      }    
                  
      /*REMOVE CURRENT TIME*/
      $time_start = date("G:i",strtotime($time_start." +$time_interval mins"));  

                  
      $times = $this->createTimeRange($time_start, $time_end , "$time_interval mins",$time_format);     
      if(is_array($times) && count($times)>=1){     
    } else {
      $times = $this->createTimeRange("6:00", "23:59" , "$time_interval mins",$time_format);    
    }   
        
      //  dump($times);
        
    /*fixed time list with end of time opening hours*/
    $time_end_integer = str_replace(":","",$time_end);
    $time_end_last = 0;     
    if(is_array($times) && count($times)>=1){
      $time_end_last = date("G:i",strtotime($times[ count($times)-1 ]));
      $time_end_last = str_replace(":","",$time_end_last);      
      if($time_end_last>$time_end_integer){
        $times[ count($times)-1 ]  = $time_end;
      }
    }
          
    $final_time = array();
    if(is_array($times) && count($times)>=1){
      foreach ($times as $val) {
        //$final_time[$val]=$val;
        $final_time[$val]=$this->prettyTime($val);
      }
    }   
        
    return $final_time;
    }


      public  function createTimeRange($start, $end, $interval = '30 mins', $format = '12') {
      $startTime = strtotime($start); 
      $endTime   = strtotime($end);
      $returnTimeFormat = ($format == '12')?'g:i:s A':'G:i:s';
  
      $current   = time(); 
      $addTime   = strtotime('+'.$interval, $current); 
      $diff      = $addTime - $current;
  
      $times = array();       
      while ($startTime < $endTime) { 
          $times[] = date($returnTimeFormat, $startTime); 
          $startTime += $diff; 
      } 
      $times[] = date($returnTimeFormat, $startTime); 
      return $times; 
  } 



  public  function timeList()
    {
        $website_time_picker_format=$this->getOptionAdmin('website_time_picker_format');        
        $options[""]=""; $min30=array('00','30');
        foreach (range(0,23) as $fullhour) {
            
            if ( $website_time_picker_format=="12"){
                $parthour = $fullhour > 12 ? $fullhour - 12 : $fullhour;
            } else $parthour = $fullhour > 12 ? $fullhour - 0 : $fullhour;         
            
            foreach($min30 as $int){
                if($fullhour > 11){
                    //$options[$fullhour.".".$int]=$parthour.":".$int." PM";
                    if ( $website_time_picker_format=="12"){
                       $options[$parthour.":".$int." PM"]=$parthour.":".$int." PM";
                    } else $options[$parthour.":".$int.""]=$parthour.":".$int."";
                }else{
                    if($fullhour == 0){$parthour='12';}
                    //$options[$fullhour.".".$int]=$parthour.":".$int." AM" ;
                    if ( $website_time_picker_format=="12"){
                       $options[$parthour.":".$int." AM"]=$parthour.":".$int." AM" ;
                    } else $options[$parthour.":".$int.""]=$parthour.":".$int."" ;
                }                               
            }
        }
        return $options;
    }




        public  function getOpeningHours($merchant_id='')
  {
        $stores_open_day=$this->getOption("stores_open_day",$merchant_id);
    $stores_open_starts=$this->getOption("stores_open_starts",$merchant_id);
    $stores_open_ends=$this->getOption("stores_open_ends",$merchant_id);
    $stores_open_custom_text=$this->getOption("stores_open_custom_text",$merchant_id);
    
    $stores_open_day=!empty($stores_open_day)?(array)json_decode($stores_open_day):false;
    $stores_open_starts=!empty($stores_open_starts)?(array)json_decode($stores_open_starts):false;
    $stores_open_ends=!empty($stores_open_ends)?(array)json_decode($stores_open_ends):false;
    $stores_open_custom_text=!empty($stores_open_custom_text)?(array)json_decode($stores_open_custom_text):false;
    
    
    $stores_open_pm_start=$this->getOption("stores_open_pm_start",$merchant_id);
    $stores_open_pm_start=!empty($stores_open_pm_start)?(array)json_decode($stores_open_pm_start):false;
    
    $stores_open_pm_ends=$this->getOption("stores_open_pm_ends",$merchant_id);
    $stores_open_pm_ends=!empty($stores_open_pm_ends)?(array)json_decode($stores_open_pm_ends):false;   
                        
    $open_starts='';
    $open_ends='';
    $open_text='';
    $data=array();
        
    if (is_array($stores_open_day) && count($stores_open_day)>=1){
      foreach ($stores_open_day as $val_open) { 
        if (array_key_exists($val_open,(array)$stores_open_starts)){
          $open_starts=$this->timeFormat($stores_open_starts[$val_open],true);
        }             
        if (array_key_exists($val_open,(array)$stores_open_ends)){
          $open_ends=$this->timeFormat($stores_open_ends[$val_open],true);
        }             
        if (array_key_exists($val_open,(array)$stores_open_custom_text)){
          $open_text=$stores_open_custom_text[$val_open];
        }         
        
        $pm_starts=''; $pm_ends=''; $pm_opens='';
        if (array_key_exists($val_open,(array)$stores_open_pm_start)){
          $pm_starts=$this->timeFormat($stores_open_pm_start[$val_open],true);
        }                     
        if (array_key_exists($val_open,(array)$stores_open_pm_ends)){
          $pm_ends=$this->timeFormat($stores_open_pm_ends[$val_open],true);
        }                       
        
        $full_time='';
        if (!empty($open_starts) && !empty($open_ends)){          
          $full_time=$open_starts."-".$open_ends;
        }     
        if (!empty($pm_starts) && !empty($pm_ends)){
          if ( !empty($full_time)){
            $full_time.="x";
          }       
          $full_time.="$pm_starts-$pm_ends";
        }                       
                
        $data[$val_open]=array(
          'day'=>$val_open,
          'hours'=>$full_time         
        );
        
        $open_starts='';
            $open_ends='';
            $open_text='';
      }
      return $data;
    }     
    return false;   
  } 





     public function getMerchantOrders($merchant_id = '') {
        // Prepare the SQL statement with a placeholder for merchant_id
        $stmt = $this->db->prepare("
            SELECT * 
            FROM mt_order
            WHERE merchant_id = :merchant_id
            LIMIT 1
        ");

        // Bind the merchant_id parameter to the placeholder
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        // Return the result or false if no data found
        return $result ? $result : false;
    }







public function insertData_olds($table, $params) {
    // Basic sanitization for table name
    

    // Encode array values as JSON if needed
    foreach ($params as $key => $value) {
        if (is_array($value)) {
            $params[$key] = json_encode($value); // Encode arrays as JSON
        }
        if ($value === '') {
            $params[$key] = null; // Handle empty strings
        }
    }

    // Build the SQL query dynamically
    $columns = array();
    $placeholders = array();
    foreach ($params as $key => $value) {
        // Include only valid columns with non-null values
        if ($value !== '' && $value !== null) {
            $columns[] = $key;
            $placeholders[] = ":$key";
        }
    }

    // If no valid columns, return false
    if (empty($columns)) {
        return false;
    }

   

    // Prepare the SQL query
    echo $sql = "INSERT INTO $table (" . implode(', ', $columns) . ") VALUES (" . implode(', ', $placeholders) . ")";

    // Debugging: Print SQL query and bound parameters
    //echo "SQL Query: $sql\n";die();
    
 print_r( $params);die();
    try {
        $stmt = $this->db->prepare($sql);
        //echo "here";die();
        // Debugging: Show bound parameters
        echo "Bound Parameters:\n";
        foreach ($params as $key => $value) {
             "$key => $value\n";
        }

        $result = $stmt->execute($params);

        // Output success message
        //echo "Insert successful\n";
        return $result ? $this->db->lastInsertId() : false;
    } catch (PDOException $e) {
        // Handle error and print error message
        echo "Error: " . $e->getMessage();
        return false;
    }
}


public function updateData($table, $params, $whereColumn, $whereValue) {
        // Build the SQL query dynamically
        $setClauses = [];
        foreach ($params as $column => $value) {
            $setClauses[] = "$column = :$column";
        }
        $setString = implode(', ', $setClauses);

        // Prepare the SQL statement
        $stmt = "UPDATE $table SET $setString WHERE $whereColumn = :whereValue";
        $query = $this->db->prepare($stmt);

        // Bind parameters
        foreach ($params as $column => $value) {
            $query->bindValue(":$column", $value);
        }
        $query->bindValue(':whereValue', $whereValue);

        // Execute the statement and return result
        return $query->execute();
    }

    public function updateData_multiple($table, $params, $whereConditions, $whereValues) {
    // Build the SQL query dynamically
    $setClauses = [];
    foreach ($params as $column => $value) {
        $setClauses[] = "$column = :$column"; // Ensure parameter matches column name
    }
    $setString = implode(', ', $setClauses);

    // Prepare the SQL statement
    $stmt = "UPDATE $table SET $setString WHERE $whereConditions";
    $query = $this->db->prepare($stmt);

    // Bind SET parameters
    foreach ($params as $column => $value) {
        $query->bindValue(":$column", $value);
    }

    // Bind WHERE parameters
    foreach ($whereValues as $placeholder => $value) {
        $query->bindValue($placeholder, $value);
    }

    // Debugging (Optional: Remove in production)
   

    // Execute the statement and return result
    return $query->execute();
}

  
  
public function insertData($table, $params) {
    // Build the list of columns and placeholders
    $columns = implode(', ', array_keys($params));
    $placeholders = implode(', ', array_map(function($key) { return ":$key"; }, array_keys($params)));

    // Prepare the SQL statement
    $stmt = "INSERT INTO $table ($columns) VALUES ($placeholders)";
    $query = $this->db->prepare($stmt);

    // Bind parameters
    foreach ($params as $column => $value) {
        $query->bindValue(":$column", $value);
    }

 // Execute the statement
    if ($query->execute()) {
        // Return the last inserted ID
        return $this->db->lastInsertId();
    } else {
        return false;
    }
  
}



public function verifyMerchantSlug($slug_name='', $merchant_id='')
{
    // Prepare the base query
    $sql = "SELECT COUNT(*) AS total FROM mt_merchant WHERE restaurant_slug = :slug_name";
    
    // Add condition if merchant_id is provided
    if (is_numeric($merchant_id)) {
        $sql .= " AND merchant_id <> :merchant_id";
    }

    // Prepare the PDO statement
    $stmt = $this->db->prepare($sql);
    
    // Bind the parameters
    $params = [':slug_name' => $slug_name];
    if (is_numeric($merchant_id)) {
        $params[':merchant_id'] = $merchant_id;
    }

    // Execute the statement
    $stmt->execute($params);
    
    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Check the result and modify the slug if necessary
    if ($res && $res['total'] > 0) {
        $slug_name = $this->seo_friendly_url($slug_name . $res['total']);
    }
    
    return $slug_name;
}


public function getReviewsById($id = '')
{
    // Assuming $this->db is your PDO instance
    $stmt = $this->db->prepare("
        SELECT a.*, 
        (
            SELECT restaurant_name 
            FROM mt_merchant 
            WHERE merchant_id = a.merchant_id
        ) AS merchant_name
        FROM mt_review a
        WHERE id = :id
        LIMIT 1
    ");
    
    // Binding the ID parameter to avoid SQL injection
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch the first result
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Return the result or false if nothing is found
    return $result ? $result : false;
}









public function validateUsername($username='', $merchant_id='')
{
    $sql = "SELECT * FROM mt_merchant WHERE username = :username";
    $params = [':username' => $username];

    if (is_numeric($merchant_id)) {
        $sql .= " AND merchant_id <> :merchant_id";
        $params[':merchant_id'] = $merchant_id;
    }
    
    $sql .= " LIMIT 0,1";
    
    $stmt = $this->db->prepare($sql);
    $stmt->execute($params);
    
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res ?: false;
}



public function validateMerchantUserFromMerchantUser($username = '', $email = '', $id = '')
{
    $msg = '';

    // Prepare the SQL statement for username check
    $stmt1 = $this->db->prepare("SELECT * FROM mt_merchant_user WHERE username = :username LIMIT 0,1");
    $stmt1->bindParam(':username', $username, PDO::PARAM_STR);
    $stmt1->execute();

    if ($stmt1->rowCount() > 0) {
        $msg = $this->translation("default", "Username already exists");
    }

    // Prepare the SQL statement for email check
    $stmt2 = $this->db->prepare("SELECT * FROM mt_merchant_user WHERE contact_email = :email LIMIT 0,1");
    $stmt2->bindParam(':email', $email, PDO::PARAM_STR);
    $stmt2->execute();

    if ($stmt2->rowCount() > 0) {
        $msg = $this->translation("default", "Email address already exists");
    }

    // If no errors, return false, otherwise return the message
    if (empty($msg)) {
        return false;
    }

    return $msg;
}
  





public function validateMerchantEmail($email='', $merchant_id='')
{
    $sql = "SELECT * FROM mt_merchant WHERE contact_email = :email AND merchant_id <> :merchant_id LIMIT 0,1";
    
    $params = [
        ':email' => $email,
        ':merchant_id' => $merchant_id,
    ];
    
    $stmt = $this->db->prepare($sql);
    $stmt->execute($params);
    
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    return $res ?: false;
}


 public function getCategoryList($merchant_id = '')
{
    $data_feed = [];
    
    // Prepare the SQL query
    $stmt = "SELECT * FROM mt_category
             WHERE merchant_id = :merchant_id
             ORDER BY sequence ASC";

    // Use PDO for database operations
    $connection = $this->db; // Assuming $this->db is your PDO instance
    $query = $connection->prepare($stmt);

    // Bind the parameter
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Fetch all rows
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);
    $data22='list';

    if (is_array($rows) && count($rows) >= 1) {
        if ($data22 == "list") {
            foreach ($rows as $val) {
                $data_feed[$val['cat_id']] = $val['category_name'];
            }
            return $data_feed;
        } else {
            return $rows;
        }
    }
    return false;
}


public function getCategoryList_sort($merchant_id = '')
{
    $data_feed = array();

    $stmt = "
        SELECT * FROM
        mt_category
        WHERE 
        merchant_id = ?
        ORDER BY sequence ASC
    ";

    try {
        $connection = $this->db;
        $query = $connection->prepare($stmt);

        // Execute with merchant_id as a positional parameter
        $query->execute([$merchant_id]);

        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            if ($this->data == "list") {
                foreach ($rows as $val) {
                    $data_feed[$val['cat_id']] = $val['category_name'];
                }
                return $data_feed;
            } else {
                return $rows;
            }
        }

    } catch (PDOException $e) {
        echo "Database error: " . $e->getMessage();
    }

    return false;
}


public function readJsonFile($file)
{
 if (filter_var($file, FILTER_VALIDATE_URL)) {
        // Remote file: Use cURL
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $file);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Set to true in production
        $json = curl_exec($ch);
        if ($json === false) {
            throw new Exception("cURL error: " . curl_error($ch));
        }
        curl_close($ch);
    } else {
      
        
        $json = file_get_contents($file);
    }

    $serviceAccount = json_decode($json, true);
  

    return  $serviceAccount;
}





public function CountryListMerchant()
  {
      $country_list=$this->CountryList();
      $merchant_default_country=$this->getOptionAdmin('merchant_default_country');  
      $merchant_specific_country=$this->getOptionAdmin('merchant_specific_country');
      if (!empty($merchant_specific_country)){
      $merchant_specific_country=json_decode($merchant_specific_country);
      }    
      if (is_array($merchant_specific_country) && count($merchant_specific_country)>=1){      
         $country_list_tem=$country_list;
          $country_list=array();    
          foreach ($country_list_tem as $c_key=>$c_value) {                
             if ( in_array($c_key,$merchant_specific_country)){
              $country_list[$c_key]=$c_value;
             }
          }
      }  
      return $country_list;
  }



    public function getallreviewss($url='',$next_token1='',$token='',$merchant_id='')
    {
      
    
  $curl = curl_init();
//"https://mybusiness.googleapis.com/v4/accounts/113374890406115087450/locations/ChIJIydAEJkhMm0Rm1AiPTRxS9o/reviews",
curl_setopt_array($curl, array(
  CURLOPT_URL =>  
    $url."?pageToken=".$next_token1,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => "",
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 30,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => "GET",
  CURLOPT_HTTPHEADER => array(
    "accept: application/json",
    "authorization: Bearer ".$token."",
    "cache-control: no-cache",
    "maxresults: 10000",
    "postman-token: 22c00361-6b30-f829-9318-2e7ffebf9af3"
  ),
));


$response = curl_exec($curl);

           $params=array(
              'status'=>1,
              'merchant_id'=>$merchant_id,
              'date_created'=>$this->dateNow(),
              'responce'=>$response        
            );  
            
            $this->insertData('mt_review_logs', $params);


  $datas = json_decode($response, TRUE);
  $next_token= $datas['nextPageToken'];       
  
  if(isset($next_token) && !empty($next_token)){
    $url=$url;
    $this->getallreviewss($url,$next_token,$token,$merchant_id);    
  }else{
    
    
    
  
       
  
       $all_reviews_logs= $this->getallreview_logs();
       if(isset($all_reviews_logs)&&$all_reviews_logs!=""){
      foreach($all_reviews_logs as $all_reviews_log){


    //print_r($all_reviews_logs);
    

       $merchant_id=$all_reviews_log['merchant_id'];
     $id=$all_reviews_log['id'];
  //  $res2=FunctionsV3::getreview_logs($id); 
    
    
        if (isset($all_reviews_log)&&$all_reviews_log!=""){
          $response_json=$all_reviews_log['responce'];
          $datas = json_decode($response_json, TRUE);
        foreach($datas['reviews'] as $data){
          
           $reviewId=$data['reviewId'];
          
           $author_url=$data['reviewer']['profilePhotoUrl'];
           $displayName=$data['reviewer']['displayName'];
          
          
          
           $data['createTime'];
          
           $comment = $data['comment'];
          
          
             $ratings= $data['starRating'];
          
          if($ratings=='ONE'){$ratings='1';}else if($ratings=='TWO'){$ratings='2';}
          else if($ratings=='THREE'){$ratings='3';}
          else if($ratings=='FOUR'){$ratings='4';}
          else if($ratings=='FIVE'){$ratings='5';}


          
          
          

        $resrev=$this->getreview_byid($reviewId,$merchant_id); 




        
          
        $res3=$this->getreview_stage($author_url);

        
       

        
        if (isset($res3)&&$res3!=""){ //if data is found in review
                    
                     
          $created_date=$data['createTime'];
                    $created_date=date("Y-m-d H:i:s",strtotime($created_date));
                    

                    $author_time=$data['createTime'];
          

          if(isset($resrev)&&$resrev!=""){
                      //do nothing if time is already there 
          }else{ //insert record in table
            $params=array(
            'client_id'=>$res3['client_id'],
            'merchant_id'=>$merchant_id,
            'date_created'=>$created_date,
            'date_time'=>$created_date, 
            'review'=>$comment,
            'author_url'=>$author_url,  
          'review_id'=>$reviewId,  
            'rating'=>$ratings  
            );  
          
          
              
                  
                  $this->insertData('mt_review', $params);

          }
        }else{ //if data is not found in review
                    //echo "not found";die();
                    $created_date=$data['createTime'];
                    $created_date=date("Y-m-d H:i:s",strtotime($created_date));
                    

          $random_number=(rand(10000,100));
          $author_name=$displayName;
          $author_name_without_space = str_replace(' ', '', $author_name);
          $email=$author_name_without_space.$random_number.'@googlereviews.co.nz';
          
        $getcleintbyauthor=$this->getauthorfromclient($author_url); 
        
        if($getcleintbyauthor[0]['client_id']>0){
           $last_id_client=$getcleintbyauthor[0]['client_id'];
        }else{  
          
                 $params1=array(
            'merchant_id'=>$merchant_id,
            'date_created'=>$this->dateNow(),
            'first_name'=>$displayName,
            'password'=>md5('123456'), 
            'email_address'=>$email, 
          'author_url'=>$author_url  
          );  
        
                
              
               
               $last_insert_id = $this->insertData('mt_client', $params1);
         //insert client first
            
                   //echo "was";die();
               $last_id_client= $last_insert_id;
        }

 if(isset($resrev)&&$resrev!=""){
               
                    
          
         }else{
            $params2=array(
            'client_id'=>$last_id_client,
            'merchant_id'=>$merchant_id,
            'date_created'=>$created_date,
            'date_time'=>$created_date, 
            'review'=>$comment,
            'author_url'=>$author_url, 
          'review_id'=>$reviewId,  
            'rating'=>$ratings  

          );  
          


         
           $this->insertData('mt_review', $params2);
         }


        }
                 
                  

                  $this->updateData("mt_review_logs",array('status'=>0),'id',$id);
        }
        //echo "passed";
        
          //die();

        }
      }
    }


    
    
  }
    }



     public   function sendFCMNotification($data, $file,$pushtype)
    {
        // Generate the OAuth2 Bearer Token

        
        $accessToken = $this->generateFirebaseAccessToken($data, $file);
        

        // Define the FCM URL for sending notifications
        $project_id=$data['projectId'];
        

        $url = "https://fcm.googleapis.com/v1/projects/".$project_id."/messages:send";
       $curl = curl_init();

      if($pushtype=="broadcast"){

        $notificationPayload = json_encode([
            "message" => [
                "topic" =>$data['target'],
                "notification" => [
                    "title" => $data['title'],
                    "body" => $data['body'],
                ],
                "android" => [
                    "notification" => [
                        "sound" => $data['sound'],
                        "channel_id" => $data['channel'] 
                    ]
                ],
              
                "apns" => [
            "payload" => [
                "aps" => [
                    "sound" => "notificationsound.caf" 
                ]
            ]
        ],
               "data" => [
    "key_1" => (string) ($data['type'] ?? ""),
    "key_2" => (string) ($data['notification_id'] ?? ""),

    "title" => (string) ($data['title'] ?? ""),
    "notification_title" => (string) ($data['title'] ?? ""),

    "body" => (string) ($data['title'] ?? ""),
    "notification_body" => (string) ($data['title'] ?? ""),
    
    "notification_foreground" => "true"
]
            ]
        ]);
        
        
        //print_r($notificationPayload);die();
        
        

      }else{
     

       
        $notificationPayload = json_encode([
            "message" => [
                "token" => $data['target'],
                "notification" => [
                    "title" => $data['title'],
                    "body" => $data['body'],
                ],
                "android" => [
                    "notification" => [
                        "sound" => $data['sound'],
                        "channel_id" => $data['channel'] 
                    ]
                ],
              
                "apns" => [
            "payload" => [
                "aps" => [
                    "sound" => "notificationsound.caf" 
                ]
            ]
        ],
                "data" => [
                    "type" => $data['type'],
                    "notification_id" => $data['notification_id']
                ]
            ]
        ]);
      }
    
        curl_setopt_array($curl, array(
          CURLOPT_URL => $url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => $notificationPayload,
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$accessToken
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        //print_r($response);die();
        return $response;
        


    }



     public   function sendFCMNotification_bkup($data, $file,$pushtype)
    {
        // Generate the OAuth2 Bearer Token

        
        $accessToken = $this->generateFirebaseAccessToken($data, $file);
        

        // Define the FCM URL for sending notifications
        $project_id=$data['projectId'];
        

        $url = "https://fcm.googleapis.com/v1/projects/".$project_id."/messages:send";
       $curl = curl_init();

      if($pushtype=="broadcast"){

        $notificationPayload = json_encode([
            "message" => [
                "topic" => $data['target'],
                "notification" => [
                    "title" => $data['title'],
                    "body" => $data['body'],
                ],
                "android" => [
                    "notification" => [
                        "sound" => $data['sound'],
                        "channel_id" => $data['channel'] 
                    ]
                ],
              
                "apns" => [
            "payload" => [
                "aps" => [
                    "sound" => "notificationsound.caf" 
                ]
            ]
        ],
                "data" => [
                    "type" => $data['type'],
                    "notification_id" => $data['notification_id']
                ]
            ]
        ]);

      }else{
     

       
        $notificationPayload = json_encode([
            "message" => [
                "token" => $data['target'],
                "notification" => [
                    "title" => $data['title'],
                    "body" => $data['body'],
                ],
                "android" => [
                    "notification" => [
                        "sound" => $data['sound'],
                        "channel_id" => $data['channel'] 
                    ]
                ],
              
                "apns" => [
            "payload" => [
                "aps" => [
                    "sound" => "notificationsound.caf" 
                ]
            ]
        ],
                "data" => [
                    "type" => $data['type'],
                    "notification_id" => $data['notification_id']
                ]
            ]
        ]);
      }
    
        curl_setopt_array($curl, array(
          CURLOPT_URL => $url,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS => $notificationPayload,
          CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$accessToken
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        //print_r($response);die();
        return $response;
        


    }


   



    public function generateFirebaseAccessToken($data, $file)
{
    // Load service account file
    

    $serviceAccount = $file;

    $now = time();
    $exp = $now + 3600;

    // JWT header and payload
    $header = ['alg' => 'RS256', 'typ' => 'JWT'];
    $payload = [
        'iss' => $serviceAccount['client_email'],
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
        'aud' => 'https://oauth2.googleapis.com/token',
        'iat' => $now,
        'exp' => $exp,
    ];

    // Encode JWT parts
    $base64UrlHeader = rtrim(strtr(base64_encode(json_encode($header)), '+/', '-_'), '=');
    $base64UrlPayload = rtrim(strtr(base64_encode(json_encode($payload)), '+/', '-_'), '=');

    $data = $base64UrlHeader . '.' . $base64UrlPayload;

    // Sign the JWT using OpenSSL
    $privateKey = openssl_pkey_get_private($serviceAccount['private_key']);
    openssl_sign($data, $signature, $privateKey, 'sha256WithRSAEncryption');
    $base64UrlSignature = rtrim(strtr(base64_encode($signature), '+/', '-_'), '=');
    $jwt = $data . '.' . $base64UrlSignature;

    // Send cURL request
    $postFields = http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt,
    ]);

    $ch = curl_init('https://oauth2.googleapis.com/token');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postFields);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/x-www-form-urlencoded',
    ]);

    $response = curl_exec($ch);
    curl_close($ch);

    $result = json_decode($response, true);

    return $result['access_token'] ?? null;
}



    public  function generateFirebaseAccessToken_x()
    {
        // Path to the service account JSON file

        //$serviceAccountPath = storage_path('hello2eat-216404-firebase-adminsdk-cmqan-8f654900f9.json');
        $service_account = $this->getOptionAdmin('mobileapp2_services_account_json');
        $storagePath = __DIR__ . '/../../upload';  // Assuming your storage folder is in the same directory as this PHP file


        $serviceAccountPath = $storagePath."/".$service_account;



        $serviceAccount = json_decode(file_get_contents($serviceAccountPath), true);


    
        $now = time();
        $expiration = $now + 3600; // Token valid for 1 hour
    
        // JWT payload
        $payload = [
            'iss' => $serviceAccount['client_email'],
            'aud' => 'https://oauth2.googleapis.com/token',
            'sub' => $serviceAccount['client_email'],
            'iat' => $now,
            'exp' => $expiration,
            'scope' => 'https://www.googleapis.com/auth/firebase.messaging'
        ];
    
        // Create JWT token
        $jwt = JWT::encode($payload, $serviceAccount['private_key'], 'RS256');
    
        // Send request to obtain access token
        $client = new GuzzleClient();
        $response = $client->post('https://oauth2.googleapis.com/token', [
            'form_params' => [
                'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
                'assertion' => $jwt,
            ],
        ]);
    
        $responseData = json_decode($response->getBody(), true);
    
        // Return the access token from the response
        return $responseData['access_token'] ?? null;
    }






   public function getauthorfromclient($author_url = '')
{
    // Prepare the SQL statement
    $stmt = $this->db->prepare("SELECT * FROM mt_client WHERE author_url = :author_url LIMIT 1");
    
    // Bind the parameter
    $stmt->bindParam(':author_url', $author_url, PDO::PARAM_STR);
    
    // Execute the statement
    $stmt->execute();
    
    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Check if result is found
    if ($res) {
        return $res;
    }
    
    return false;
}




   public function getreview_stage($author_url = '')
{
    // Prepare the SQL statement
    $stmt = $this->db->prepare("SELECT * FROM mt_review WHERE author_url = :author_url LIMIT 1");
    
    // Bind the parameter
    $stmt->bindParam(':author_url', $author_url, PDO::PARAM_STR);
    
    // Execute the statement
    $stmt->execute();
    
    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Check if result is found
    if ($res) {
        return $res;
    }
    
    return false;
}



 public function getreview_byid_bkup($author_url = '', $merchant_id = 0)
{
    // Prepare the SQL statement
    $stmt = $this->db->prepare("SELECT * FROM mt_review WHERE review_id = :author_url AND merchant_id = :merchant_id LIMIT 1");
    
    // Bind the parameters
    $stmt->bindParam(':author_url', $author_url, PDO::PARAM_STR);
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the statement
    $stmt->execute();
    
    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Check if result is found
    if ($res) {
        return $res;
    }
    
    return false;
}

public function getreview_byid($author_url = '', $merchant_id = 0)
{
    // Build the SQL query using direct variables
    $sql = "SELECT * FROM mt_review 
            WHERE review_id = '$author_url' 
            AND merchant_id = $merchant_id 
            LIMIT 1";

    // Execute the query
    $stmt = $this->db->query($sql);

    // Fetch the result
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    // Check if result is found
    if ($res) {
        return $res;
    }

    return false;
}




public function getallreview_logs()
{
    // Prepare the SQL statement
    $stmt = $this->db->prepare("SELECT * FROM mt_review_logs WHERE status = :status");
    
    // Bind the parameter
    $status = 1;
    $stmt->bindParam(':status', $status, PDO::PARAM_INT);
    
    // Execute the statement
    $stmt->execute();
    
    // Fetch all results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Check if results are found
    if ($res) {
        return $res;
    }
    
    return false;
}







 public function validateSellLimit($merchant_id = '')
{
    $m1 = date('Y-m-01 00:00:00');
    $m2 = date('Y-m-t H:i:s');
    $expiration = 1;

    if ($merchant_info = $this->getMerchant($merchant_id)) {
        if ($merchant_info['is_commission'] == 2) {
            return true;
        }
        
        $membership_purchase_date = $merchant_info['membership_purchase_date'];
        $membership_purchase_date1 = date("Ymd", strtotime($membership_purchase_date));

        $m3 = date("Ymd");
        if ($membership_purchase_date1 >= $m3) {
            $m1 = $membership_purchase_date;
        }
    }

    $stmt = "
        SELECT a.merchant_id, a.package_id,
        (
            SELECT sell_limit
            FROM mt_packages
            WHERE package_id = a.package_id
        ) AS sell_limit,
        (
            SELECT COUNT(*) AS total
            FROM mt_order
            WHERE merchant_id = a.merchant_id
            AND date_created BETWEEN :m1 AND :m2
        ) AS total_sell
        FROM mt_merchant a
        WHERE merchant_id = :merchant_id
        LIMIT 1
    ";

    $command = $this->db->prepare($stmt);
    $command->bindParam(':m1', $m1);
    $command->bindParam(':m2', $m2);
    $command->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    if ($command->execute()) {
        $res = $command->fetch(PDO::FETCH_ASSOC);
        if ($res['sell_limit'] >= 1) {
            if ($res['total_sell'] >= $res['sell_limit']) {
                return false;
            }
        }
    }

    return true;
}




public function getMerchantUserInfo($merchant_user_id = '')
{
    $mid = $this->getMerchantID();

    $stmt = "
        SELECT * FROM mt_merchant_user
        WHERE merchant_user_id = :merchant_user_id
        AND merchant_id = :merchant_id
        LIMIT 1
    ";

    $command = $this->db->prepare($stmt);
    $command->bindParam(':merchant_user_id', $merchant_user_id, PDO::PARAM_INT);
    $command->bindParam(':merchant_id', $mid, PDO::PARAM_INT);

    if ($command->execute()) {
        $res = $command->fetch(PDO::FETCH_ASSOC);
        return $res ? $res : false; // Return the result or false if no result found
    }

    return false; // Return false in case of execution failure
}






  public function getMerchantBalance($merchant_id = '')
{
    $merchant_id = (integer)$merchant_id;

    if ($merchant_id > 0) {
        $status_based = array('paid');
        $used_status = '';
        $and = '';
        $status = $this->getOptionAdmin('total_commission_status');

        if ($json = json_decode($status, true)) {
            $status_based = $json;
        }

        // Enclose each status in single quotes
        foreach ($status_based as $val) {
            $used_status .= "'" . $val . "',"; // Add quotes around the status
        }
        $used_status = rtrim($used_status, ','); // Remove the trailing comma

        $offline = "'cod','ocr','pyr','obd'";
        $include_all_offline_payment = $this->getOptionAdmin('admin_include_all_offline_payment');

        $and = " AND payment_type NOT IN ($offline) ";

        $stmt = "
            SELECT
                IFNULL(SUM(a.merchant_earnings), '0') AS merchant_earnings,
                IFNULL((
                    SELECT SUM(amount) 
                    FROM mt_withdrawal 
                    WHERE merchant_id = :merchant_id     
                    AND status IN ('pending', 'paid', 'processing', 'approved')
                ), 0) AS total_payout,
                IFNULL((
                    SELECT SUM(merchant_earnings) 
                    FROM mt_order 
                    WHERE merchant_id = :merchant_id     
                    AND status IN ($used_status)    
                    AND payment_type IN ($offline)
                ), 0) AS offline_balance
            FROM mt_order a
            WHERE merchant_id = :merchant_id     
            AND status IN ($used_status)   
            $and
        ";

        $command = $this->db->prepare($stmt);
        $command->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        if ($command->execute()) {
            $res = $command->fetch(PDO::FETCH_ASSOC);
            $merchant_earnings = (float)$res['merchant_earnings'];
            $total_payout = (float)$res['total_payout'];
            $offline_balance = (float)$res['offline_balance'];

            if ($include_all_offline_payment == 1) {
                $balance = $merchant_earnings + $offline_balance - $total_payout;
            } else {
                $balance = $merchant_earnings - ($total_payout + $offline_balance);
            }
            return $balance;
        }
    }

    return 0;
}




public function validateMerchantUserAccount($username = '', $email = '', $id = '')
{
    $msg = '';
    $and = '';

    // Check if username exists in mt_merchant table
    $stmt1 = "SELECT * FROM mt_merchant WHERE username = :username LIMIT 1";
    $query = $this->db->prepare($stmt1);
    $query->bindParam(':username', $username);
    $query->execute();
    
    if ($query->rowCount() > 0) {
        $msg = "Username already exists";
    }

    // Check if email exists in mt_merchant table
    if (empty($msg)) {
        $stmt2 = "SELECT * FROM mt_merchant WHERE contact_email = :email LIMIT 1";
        $query = $this->db->prepare($stmt2);
        $query->bindParam(':email', $email);
        $query->execute();

        if ($query->rowCount() > 0) {
            $msg = "Email address already exists";
        }
    }

    // If ID is provided, add the condition to exclude current user in mt_merchant_user
    if (is_numeric($id)) {
        $and = " AND merchant_user_id != :id";
    }

    // Check if username exists in mt_merchant_user table
    if (empty($msg)) {
        $stmt3 = "SELECT * FROM mt_merchant_user WHERE username = :username $and LIMIT 1";
        $query = $this->db->prepare($stmt3);
        $query->bindParam(':username', $username);
        if (!empty($and)) {
            $query->bindParam(':id', $id);
        }
        $query->execute();

        if ($query->rowCount() > 0) {
            $msg = "Username already exists";
        }
    }

    // Check if email exists in mt_merchant_user table
    if (empty($msg)) {
        $stmt4 = "SELECT * FROM mt_merchant_user WHERE contact_email = :email $and LIMIT 1";
        $query = $this->db->prepare($stmt4);
        $query->bindParam(':email', $email);
        if (!empty($and)) {
            $query->bindParam(':id', $id);
        }
        $query->execute();

        if ($query->rowCount() > 0) {
            $msg = "Email address already exists";
        }
    }

    // If no error message, return false
    if (empty($msg)) {
        return false;
    }

    // Return the error message if there is one
    return $msg;
}



public function validateMerchantUserAccount_merchantwise($username = '',$merchant_id='', $email = '', $id = '')
{
    $msg = '';
    $and = '';

    // Check if username exists in mt_merchant table
    $stmt1 = "SELECT * FROM mt_merchant 
              WHERE username = :username 
              AND merchant_id = :merchant_id 
              LIMIT 1";
    $query = $this->db->prepare($stmt1);
    $query->bindParam(':username', $username);
    $query->bindParam(':merchant_id', $merchant_id);
    $query->execute();
    
    if ($query->rowCount() > 0) {
        $msg = "Username already exists";
    }

    // Check if email exists in mt_merchant table
    if (empty($msg)) {
        $stmt2 = "SELECT * FROM mt_merchant 
                  WHERE contact_email = :email 
                  AND merchant_id = :merchant_id 
                  LIMIT 1";
        $query = $this->db->prepare($stmt2);
        $query->bindParam(':email', $email);
        $query->bindParam(':merchant_id', $merchant_id);
        $query->execute();

        if ($query->rowCount() > 0) {
            $msg = "Email address already exists";
        }
    }

    // If ID is provided, add the condition to exclude current user in mt_merchant_user
    if (is_numeric($id)) {
        $and = " AND merchant_user_id != :id";
    }

    // Check if username exists in mt_merchant_user table
    if (empty($msg)) {
        $stmt3 = "SELECT * FROM mt_merchant_user 
                  WHERE username = :username 
                  AND merchant_id = :merchant_id 
                  $and 
                  LIMIT 1";
        $query = $this->db->prepare($stmt3);
        $query->bindParam(':username', $username);
        $query->bindParam(':merchant_id', $merchant_id);
        if (!empty($and)) {
            $query->bindParam(':id', $id);
        }
        $query->execute();

        if ($query->rowCount() > 0) {
            $msg = "Username already exists";
        }
    }

    // Check if email exists in mt_merchant_user table
    if (empty($msg)) {
        $stmt4 = "SELECT * FROM mt_merchant_user 
                  WHERE contact_email = :email 
                  AND merchant_id = :merchant_id 
                  $and 
                  LIMIT 1";
        $query = $this->db->prepare($stmt4);
        $query->bindParam(':email', $email);
        $query->bindParam(':merchant_id', $merchant_id);
        if (!empty($and)) {
            $query->bindParam(':id', $id);
        }
        $query->execute();

        if ($query->rowCount() > 0) {
            $msg = "Email address already exists";
        }
    }

    if (empty($msg)) {
        return false;
    }

    return $msg;
}




public function validateMerchantUsername($username = '')
{
    if (empty($username)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT * FROM mt_merchant_user
        WHERE username = :username
        LIMIT 0, 1
    ");
    
    $stmt->bindParam(':username', $username, PDO::PARAM_STR);
    $stmt->execute();

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }
    
    return false;
}

public function validateMerchantUsername_merchantwise($username = '', $merchant_id = '')
{
    if (empty($username)) {
        return false;
    }

    $stmt = $this->db->prepare("
        SELECT * FROM mt_merchant_user
        WHERE username = :username
        AND merchant_id = :merchant_id
        LIMIT 0, 1
    ");
    
    $stmt->bindParam(':username', $username, PDO::PARAM_STR);
    $stmt->bindParam(':merchant_id', $merchant_id);
    $stmt->execute();

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        return $res;
    }
    
    return false;
}



public function validateMerchantUser($username = '', $merchant_id = '')
{
    $stmt = "SELECT * FROM mt_merchant_user 
             WHERE username = :username 
             AND merchant_id <> :merchant_id 
             LIMIT 1";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':username', $username);
    $query->bindParam(':merchant_id', $merchant_id);
    $query->execute();

    $result = $query->fetch(PDO::FETCH_ASSOC);

    if ($result) {
        return $result;
    }

    return false;
}
 














 public function merchantMenu()
    {

      
     



        $user_access = (array)$this->getMerchantUserAccess();
        
        $payment_list=array('visible'=>$this->hasMerchantAccessToMenu($user_access,"payment-gateway"),'tag'=>'payment-gateway','label'=>'<i class="fa fa-usd"></i>'.$this->translation("default",'Payment Gateway'),
                
                   'itemOptions'=>array('class'=>''), 'items'=>array(
                   
                   array('visible'=>$this->hasMerchantAccessToMenu($user_access,"cod"),'tag'=>'cod', 'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Cash On delivery"),                    
                   'url'=>array('/merchant/codsettings')),                
                   
                   


                   array('visible'=>$this->hasMerchantAccessToMenu($user_access,"W_pos"),
                       'tag'=>'W_pos', 'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Windcave Pos"),
                       'url'=>array('/merchant/W_pos')), 


                        array('visible'=>$this->hasMerchantAccessToMenu($user_access,"Windcave"),
                       'tag'=>'Windcave', 'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Windcave"),
                       'url'=>array('/merchant/Windcave')),                                     
                   
                   /*array('visible'=>$this->hasMerchantAccessToMenu($user_access,"pyp"),'tag'=>'pyp', 'label'=>'<i class="fa fa-paypal"></i>'.$this->translation("default","Paypal"),                    
                   'url'=>array('merchant/paypalSettings')),                */
                   
                   array('