<?php

if (!isset($_SESSION)) { @session_start(); }

class Ajaxadmin {
    protected $db;
    protected $functions;
    public $data;
    public $code=2;
    public $msg;
    public $details;

    public function __construct() {
       
        //$model = new Model();
        $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
    $this->functions = new Functions(); // Create an instance of Functions

    $this->PointsProgram = new PointsProgram();

    $this->InventoryWrapper=new InventoryWrapper();
    $this->StocksWrapper=new StocksWrapper();
    $this->ItemWrap=new ItemWrap();

        $this->PrettyDateTime = new PrettyDateTime();

    $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);
        $this->CheckoutWrapper = new CheckoutWrapper();

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     
      date_default_timezone_set($website_timezone);


    }

    public function login() {
        // Check if admin has enabled the Google captcha
        /* 
        if (getOptionA('captcha_admin_login') == 2) {
            try {
                $recaptcha_token = isset($this->data['recaptcha_v3']) ? $this->data['recaptcha_v3'] : '';
                GoogleCaptchaV3::validateToken($recaptcha_token);
            } catch (Exception $e) {
                $this->msg = $e->getMessage();
                return;
            }
        }
        */

        $username = trim($this->data['username']);
        $password = md5(trim($this->data['password'])); 

        // Use prepared statements with PDO for security
        $stmt = $this->db->prepare("
            SELECT * FROM mt_admin_user
            WHERE username = :username
            AND password = :password
            LIMIT 1
        ");
        $stmt->bindValue(':username', $username, PDO::PARAM_STR);
        $stmt->bindValue(':password', $password, PDO::PARAM_STR);
        $stmt->execute();
        
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $_SESSION['kr_user'] = json_encode($res);
            $this->code = 1;
            
            $session_token = $this->functions->generateRandomKey() . md5($_SERVER['REMOTE_ADDR']);
            $params = array(
                'session_token' => $session_token,
                'last_login' => date('Y-m-d G:i:s')
            );
            $this->functions->updateData("mt_admin_user", $params, 'admin_id', $res[0]['admin_id']);
            
            $_SESSION['kr_user_session'] = $session_token;
            $this->msg = "Login Successful";
        } else {
            $this->msg = "Either username or password is invalid.";
        }
    }

   public function merchantLogin()
{
    // Call the functions to update merchant statuses
    $this->functions->updateMerchantSponsored();
    $this->functions->updateMerchantExpired();
    
    // Get the PDO instance from the class property
    $pdo = $this->db;

    // Prepare the SQL query with placeholders
    $stmt = $pdo->prepare("
        SELECT * FROM mt_merchant
        WHERE username = :username
        AND password = :password
        LIMIT 1
    ");

    // Bind the parameters with actual values
    $stmt->bindParam(':username', $username);
    $stmt->bindParam(':password', $password);

    // Set parameter values
    $username = $this->data['username'];
    $password = md5($this->data['password']);  // Hash the password

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Check if a result was found
    if (!empty($res)) {
        if ($res[0]['status'] == "active" || $res[0]['status'] == "expired") {
            // Store merchant user data in session
            $_SESSION['kr_merchant_user'] = json_encode($res);
            
            // Generate session token
            $session_token = $this->functions->generateRandomKey() . md5($_SERVER['REMOTE_ADDR']);
            
            // Update the merchant's session token and last login date
            $params = [
                'session_token' => $session_token,
                'last_login' => $this->functions->dateNow()
            ];
            
            // Call the function to update the merchant's information
            $this->functions->updateData('mt_merchant', $params, 'merchant_id', $res[0]['merchant_id']);
            
            // Store session token and user type in the session
            $_SESSION['kr_merchant_user_session'] = $session_token;
            $_SESSION['kr_merchant_user_type'] = 'admin';
            
            // Set the response code and message
            $this->code = 1;
            $this->msg = $this->functions->translation("default", "Login Successful");
        } else {
            // If the account status is not active or expired, show an error message
            $this->msg = $this->functions->translation("default", "Login Failed. Your account status is [status]", [
                '[status]' => $res[0]['status']
            ]);
        }
    } else {
        // If no result is found, call merchantUserLogin for further processing
        $this->merchantUserLogin();
    }
}


public function resendMobileCode()
  {
    $date_now=date('Y-m-d g:i:s a');        
    if ( isset($_SESSION['resend_code'])){      
      $date_diff=$this->functions->dateDifference($_SESSION['resend_code'],$date_now);     
      if (is_array($date_diff) && count($date_diff)>=1){
        if ( $date_diff['minutes']<5){
          $remaining=5-$date_diff['minutes'];
          $this->msg=$this->functions->translation("default","Please wait for a minute to receive your code");          
          $this->msg.=" (".$remaining ." "."minutes".")";
          return ;
        }     
      }   
    } 
        
    if ( isset($this->data['id'])){
      if( $res=$this->functions->getClientInfo($this->data['id'])){        
        $code=$res['mobile_verification_code'];
        $_SESSION['resend_code']=$date_now;       
        $this->functions->sendCustomerSMSVerification($res['contact_phone'],$code);
        $this->code=1;
        $this->msg=$this->functions->translation("default","Your verification code has been sent to")." ".$res['contact_phone'];
      } else $this->msg=$this->functions->translation("default","Sorry but we cannot find your records");
    } else $this->msg=$this->functions->translation("default","Missing id");
  }


  public function verifyMobileCode()
  {   
    if( $res=$this->functions->getClientInfo($this->data['client_id'])){
      if ( $this->data['code']==$res['mobile_verification_code']){
        $this->code=1;
        $this->msg=$this->functions->translation("default","Successful");
        
        $params=array( 
          'status'=>"active",
          'mobile_verification_date'=>$this->functions->dateNow()
        );
       
        $this->functions->updateData("mt_client",$params,'client_id',$res['client_id']);
        
        
        $this->functions->sendCustomerWelcomeEmail(array(
         'first_name'=>isset($res['first_name'])?$res['first_name']:'',
         'last_name'=>isset($res['last_name'])?$res['last_name']:'',
         'email_address'=>isset($res['email_address'])?$res['email_address']:'',
         'contact_phone'=>isset($res['contact_phone'])?$res['contact_phone']:''
        ));   
        
        $this->functions->clientAutoLogin($res['email_address'],$res['password'],$res['password']);
        
      } else $this->msg=$this->functions->translation("default","Verification code is invalid");    
    } else $this->msg=$this->functions->translation("default","Sorry but we cannot find your records");
  }





public function subscribeNewsletter()
        {
            
           
            $req=array(
               'subscriber_email'=>$this->functions->translation("default","Email is required")
            );
            
            $this->functions->required($req,$this->data);
            
            
            if ( $this->functions->getSubsriberEmail($this->data['subscriber_email']) ){
                //$msg=$this->functions->translation("default","Sorry your Email address is already exist in our records.");
                $this->msg = "ERROR: Sorry your Email address is already exist in our records.";
                  return false;
                
            }

            
                    
            if ($this->functions->validate()){               
                $params=array(
                  'email_address'=>$this->data['subscriber_email'],
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR']
                );              
                if ( $this->functions->insertData("mt_newsletter",$params)){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default","Thank you for subscribing to our mailing list!");
                } else $this->msg=$this->functions->translation("default","Sorry there is error while we saving your information.");          
            } else $this->msg=$this->functions->getErrorAsHTML();
        }



        public function merchantSignUp()
        {           
                                    
            /** check if admin has enabled the google captcha*/             
          
            
            if (isset($this->data['cpassword'])){
                if ($this->data['cpassword']!=$this->data['password']){
                    $this->msg=$this->functions->translation("default","Confirm password does not match");
                    return ;
                }
            }
                        
            if ($this->functions->isMerchantExist($this->data['contact_email'])){
                $this->msg=$this->functions->translation("default","Sorry you input email address that is already registered in our records.");
                return ;
            }       
            if (!isset($this->data['package_id'])){
                $this->msg=$this->functions->translation("default","ERROR: Missing package id");
                return ;
            }   
            
            if ( !$package=$this->functions->getPackagesById($this->data['package_id'])){
                $this->msg=$this->functions->translation("default","ERROR: Package information not found");
                return ;
            }       
            
            
            $package_price=0;
            if ( $package['promo_price']>=1){
                $package_price=$package['promo_price'];
            } else $package_price=$package['price'];            
            
            $expiration=$package['expiration'];         
            $membership_expired = date('Y-m-d', strtotime ("+$expiration days"));                           
            
            $status=$this->functions->getOptionAdmin('merchant_sigup_status');
            if(empty($status)){
                $status='pending';
            }       
            $token=md5($this->data['restaurant_name'].date('c'));
            
            
            
            $params=array(
              'restaurant_name'=>($this->data['restaurant_name']),
              'restaurant_phone'=>($this->data['restaurant_phone']),
              'contact_name'=>($this->data['contact_name']),
              'contact_phone'=>($this->data['contact_phone']),
              'contact_email'=>($this->data['contact_email']),
              'street'=>(addslashes($this->data['street'])),
              'city'=>(addslashes($this->data['city'])),
              'post_code'=>(addslashes($this->data['post_code'])),
              'cuisine'=>json_encode($this->data['cuisine']),
              'username'=>($this->data['username']),
              'password'=>md5($this->data['password']),
              'status'=>$status,
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'activation_token'=>$token,
              'activation_key'=>$this->functions->generateRandomKey(5),
              'restaurant_slug'=>$this->functions->createSlug($this->data['restaurant_name']),
              'package_id'=>$this->data['package_id'],
              'package_price'=>$package_price,
              'membership_expired'=>$membership_expired,
              'payment_steps'=>2,
              //'country_code'=>Yii::app()->functions->adminSetCounryCode(),
              'country_code'=>($this->data['country_code']),
              'state'=>(($this->data['state'])),
              'abn'=>isset($this->data['abn'])?($this->data['abn']):'',
              'service'=>isset($this->data['service'])?($this->data['service']):'',
              'delivery_distance_covered'=>isset($this->data['delivery_distance_covered'])?(float)$this->data['delivery_distance_covered']:0,
              'distance_unit'=>isset($this->data['distance_unit'])?($this->data['distance_unit']):'mi',
            );      

                      
            if ( !$this->functions->validateUsername($this->data['username']) ){
                                
                if ($respck=$this->functions->validateMerchantUserFromMerchantUser($params['username'],
                    $params['contact_email'])){
                    $this->msg=$respck;
                    return ;                    
                }           
                                                
                $params['percent_commision']=0;

                $disabled_verification = $this->functions->getOptionAdmin("merchant_email_verification");
          


                 $last_insert_id = $this->functions->insertData('mt_merchant', $params);
                 if ($last_insert_id!== false){ 
                
                    $mtid=$last_insert_id;

                    
                    $this->functions->updateOption("merchant_delivery_miles",
                    $params['delivery_distance_covered']
                    ,$mtid);
                    
                    $this->functions->updateOption("merchant_distance_type",
                    $params['distance_unit']
                    ,$mtid);
                    
                    //AUTO ADD SIZE
                    $this->functions->autoAddSize($mtid);         
                    
                    
                    /*ADD CUISINE*/
                    try {
                        $cuisine = isset($this->data['cuisine'])?$this->data['cuisine']:array();
                        $this->functions->insertCuisine($mtid,(array)$cuisine);
                    } catch (Exception $e) {
                        //$e->getMessage()
                    }  


                   

                     if($disabled_verification!="yes"){
            $this->functions->sendMerchantActivation($params,$params['activation_key']);
            }else{
               $this->functions->sendWelcomeEmailMerchant($params,true);
                     $this->functions->NotiNewMerchantSignup($params,'membership');
            } 


                    $this->code=1;
                    $this->msg=$this->functions->translation("default","Successful");
                    $this->details=$token;
                    
                    //FunctionsV3::NotiNewMerchantSignup($params,'membership');
                   
                    // send email activation key
                    if ($package_price<=0){
                       //$this->functions->sendWelcomeEmailMerchant($params,true);
                       //$this->functions->sendMerchantActivation($params,$params['activation_key']);



                    }
                                        
                } else $this->msg=$this->functions->translation("default","Sorry but we cannot add your information. Please try again later");
            } else $this->msg=$this->functions->translation("default","Sorry but your username is alread been taken.");
        }



        public function testSms()
  {
    require_once __DIR__ . '/../../models/test-sms.php'; 
    
    die();
  }



  public function SendTestSMS()
  {   
    if (isset($this->data['mobile'])){
      $text="This is a sms test message";
      if ( $res=$this->functions->sendSMS($this->data['mobile'],$text) ){                
        if ( $res['msg']=="process"){
          $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");
          
          $params=array(
              'merchant_id'=>'999999999',
              'broadcast_id'=>'999999999',
              'client_id'=>0,
              'client_name'=>'',
              'contact_phone'=>$this->data['mobile'],
              'sms_message'=>$text,
              'status'=>'process',
              'gateway_response'=>$res['raw'],
              'date_created'=>$this->functions->dateNow(),
              'date_executed'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'gateway'=>$res['sms_provider']
            );    
                        
            /*$db= new DbExt;
            $db->insertData("{{sms_broadcast_details}}",$params);
            unset($db);*/
      
        } else $this->msg=$res['msg'];
      } else $this->msg=$this->functions->translation("default","Failed");
    } else $this->msg=$this->functions->translation("default","Mobile number is required");       
  }


    public function smsBroadcastList()
{
    $send_status = $this->functions->SMSsendStatus();
    $slug = $this->data['slug'];

    $stmt = "
    SELECT * FROM
    mt_sms_broadcast
    WHERE
    merchant_id = :merchant_id
    ORDER BY broadcast_id DESC
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute([':merchant_id' => $this->functions->getMerchantID()]);
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            foreach ($rows as $val) {
                $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"$val[broadcast_id]\" class=\"chk_child\" >";

                $link = Config::$baseUrl . "/merchant/smsBroadcast/Do/view/bid/" . $val['broadcast_id'];
                $view = "<a href=\"$link\" >" . $this->functions->translation("default", "View") . "</a>";

                $date = $this->functions->FormatDateTime($val['date_created']);

                $status = '';
                if ($val['status'] == "process") {
                    $status = "<p class=\"uk-badge uk-badge-success\">" . $val['status'] . "</p>";
                } else {
                    $status = "<p class=\"uk-badge uk-badge-danger\">" . $val['status'] . "</p>";
                }

                $feed_data['aaData'][] = array(
                    $chk,
                    $val['broadcast_id'],
                    array_key_exists($val['send_to'], $send_status) ? $send_status[$val['send_to']] : '',
                    $val['sms_alert_message'],
                    $status,
                    $view,
                    $date
                );
            }
            $this->otableOutput($feed_data);
        } else {
            $this->otableNodata();
        }
    } catch (PDOException $e) {
        // Handle exception
        echo "Database error: " . $e->getMessage();
    }
}



public function SMSCreateBroadcast()
      {       
        $available_credit=$this->functions->getMerchantSMSCredit($this->functions->getMerchantID());        
        
       
        
        if ( $this->data['send_to']==1){          
          if ( $available_credit<$this->data['total_customer']){
            $this->msg=$this->functions->translation("default","Sorry but your SMS Credits is low. Please purchase SMS credit to continue send SMS. Thank you");
            return ;
          }
          
          if ( $this->data['total_customer']<=0){
            $this->msg=$this->functions->translation("default","No client found");
              return ;  
          }       
          
        } elseif ($this->data['send_to']==2){
          if ( $available_credit<$this->data['total_customer_by_merchant']){
            $this->msg=$this->functions->translation("default","Sorry but your SMS Credits is low. Please purchase SMS credit to continue send SMS. Thank you");
            return ;
          }
          
          if ( $this->data['total_customer_by_merchant']<=0){
            $this->msg=$this->functions->translation("default","No client found");
              return ;  
          }       
          
        } else {
          $list_mobile_number=isset($this->data['list_mobile_number'])?explode(",",$this->data['list_mobile_number']):0;
          if ( $available_credit<count($list_mobile_number)){
            $this->msg=$this->functions->translation("default","Sorry but your SMS Credits is low. Please purchase SMS credit to continue send SMS. Thank you");
            return ;
          }
                  
          if (empty($available_credit)){
            $this->msg=$this->functions->translation("default","Mobile number is invalid");
              return ;  
          }       
          
        }     
        
                
        $params=array(
          'send_to'=>$this->data['send_to'],
          'list_mobile_number'=>$this->data['list_mobile_number'],
          'sms_alert_message'=>$this->data['sms_alert_message'],
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'merchant_id'=>$this->functions->getMerchantID()
        );
        if ( $this->functions->insertData("mt_sms_broadcast",$params)){
          $this->code=1;
          $this->msg=$this->functions->translation('default',"SMS Broadcast saved");
        } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');     
      }



        public function smsBroadcastListDetails()
{
    $slug = $this->data['slug'];
    $broadcastId = $this->data['bid'];
    
    $stmt = "
        SELECT * FROM
        mt_sms_broadcast_details
        WHERE
        broadcast_id = :broadcast_id
        ORDER BY id ASC
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':broadcast_id', $broadcastId, PDO::PARAM_INT);
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            foreach ($rows as $val) {
                $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"{$val['id']}\" class=\"chk_child\" >";

                $date = date('M d, Y G:i:s', strtotime($val['date_created']));
                $date_process = $val['date_executed'] === "0000-00-00 00:00:00" 
                    ? "" 
                    : date('M d, Y G:i:s', strtotime($val['date_executed']));

                $status = $val['status'] === "process"
                    ? "<p class=\"uk-badge uk-badge-success\">{$val['status']}</p>"
                    : "<p class=\"uk-badge uk-badge-danger\">{$val['status']}</p>";

                $feed_data['aaData'][] = array(
                    $chk,
                    $val['id'],
                    $val['client_name'],
                    $val['contact_phone'],
                    $val['sms_message'],
                    $status,
                    $date,
                    $date_process
                );
            }
            $this->otableOutput($feed_data);
        } else {
            $this->otableNodata();
        }
    } catch (PDOException $e) {
        // Handle any database errors
        error_log("Database error: " . $e->getMessage());
        $this->otableNodata();
    }
}









        public function merchantResumeSignup()
{
    try {
        $stmt = $this->db->prepare(
            "SELECT * FROM mt_merchant WHERE contact_email = :email LIMIT 1"
        );
        $stmt->execute([':email' => $this->data['email_address']]);
        
        if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
            if ($res['status'] === "active") {
                $this->msg = $this->functions->translation("default", "Merchant is already active.");
            } else {
                $steps = $res['payment_steps'] + 1;
                $url = Config::$baseUrl . '/merchantsignup?Do=step' . $steps . '&token=' . $res['activation_token'];
                $this->code = 1;
                $this->msg = $this->functions->translation("default", "Successful");
                $this->details = $url;
            }
        } else {
            $this->msg = $this->functions->translation("default", "Sorry but we cannot find your email address.");
        }
    } catch (PDOException $e) {
        $this->msg = $this->functions->translation("default", "An error occurred while processing your request.");
        error_log($e->getMessage()); // Log the error for debugging purposes
    }
}



 public function initSelectPaymentProvider()
      {               
        if (!isset($this->data['sms_package_id'])){
          $this->msg=$this->functions->translation("default","Please select package");
          return ;
        }     
        if (!isset($this->data['payment_opt'])){
          $this->msg=$this->functions->translation("default","Please select Payment gateway.");
          return ;
        }

        
        
        $action='';
        $params='';
        switch ($this->data['payment_opt']) {
          case "pyp":
            $action="paypalInit";
            break;
           case "ccr":
            $action="creditCardInit";
            break;
          case "stp":
            $action="stripeInit";
            break;  
          case "mcd":
            $action="mercadopagoInit";
            break;    
          case "pyl":
            $action="paylineinit";            
            break;      
          case "ide":
            $action="sisowinit";            
            break;      
          case "mercadopago":     
              $action="mercadopago_v2";       
              break;
          default:
            $action=$this->data['payment_opt']."init";    
            break;
        }       
        $params="type=purchaseSMScredit&package_id=".$this->data['sms_package_id'];
        
        
        if ( $info=$this->functions->getSMSPackagesById($this->data['sms_package_id']) ){
          
          $price=$info['price'];
            if ( $info['promo_price']>0){
                     $price=$info['promo_price'];
          }       
          if ($price<=0){
            
            $params=array(
              'merchant_id'=>$this->functions->getMerchantID(),
              'sms_package_id'=>$this->data['sms_package_id'],              
              'package_price'=>$price,
              'sms_limit'=>$info['sms_limit'],
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'status'=>"paid"
            ); 

            $last_insert_id = $this->functions->insertData('mt_sms_package_trans', $params);
            if ($last_insert_id!== false){ 
              $params="id=".$last_insert_id;
                $action="smsReceipt";               
            } else {
              $this->msg=$this->functions->translation("default","ERROR: Cannot insert record.");  
              return ;
            }
          }       
        }

        //++++waseem custom code for direct ocr
        if($action=="ocrinit"){
        $package_id=isset($this->data['sms_package_id'])?$this->data['sms_package_id']:''; 
        if ( $info=$this->functions->getSMSPackagesById($package_id) ){
            $price=$info['price'];
            if ( $info['promo_price']>0){
              $price=$info['promo_price'];
            }         
            $payment_code=$this->functions->paymentCode("creditcard"); 
            $params=array(
              'merchant_id'=>$this->functions->getMerchantID(),
              'sms_package_id'=>$package_id,
              'payment_type'=>$payment_code,
              'package_price'=>$price,
              'sms_limit'=>$info['sms_limit'],
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'cc_id'=>''
            ); 
            $last_insert_id = $this->functions->insertData('mt_sms_package_trans', $params);
            if ($last_insert_id!== false){  
              $this->details=Config::$baseUrl."/merchant/smsReceipt/id/".$last_insert_id;                
              $this->code=1;
              $this->msg=$this->functions->translation("default","Successful");              
            } else $this->msg=$this->functions->translation("default","ERROR: Cannot insert record."); 
          } else $this->msg=$this->functions->translation("default","Package information not found.");

        }else{
        //----waseem custom code for direct ocr
        $this->code=1;
        $this->msg=$this->functions->translation("default","Please wait while we redirect you");
        $this->details=Config::$baseUrl."/".$this->data['controller']."/$action/?".$params;
        }

        
        
        
      }


      public function SMSAlertSettings()
      {
        $merchant_id=$this->functions->getMerchantID();
        
        $this->functions->updateOption("sms_enabled_alert",
        isset($this->data['sms_enabled_alert'])?$this->data['sms_enabled_alert']:''
        ,$merchant_id);
        
        $this->functions->updateOption("sms_notify_number",
        isset($this->data['sms_notify_number'])?$this->data['sms_notify_number']:''
        ,$merchant_id);
        
        $this->functions->updateOption("sms_alert_message",
        isset($this->data['sms_alert_message'])?$this->data['sms_alert_message']:''
        ,$merchant_id);
        
        $this->functions->updateOption("sms_alert_customer",
        isset($this->data['sms_alert_customer'])?$this->data['sms_alert_customer']:''
        ,$merchant_id);
        
        $this->functions->updateOption("sms_alert_change_status",
        isset($this->data['sms_alert_change_status'])?$this->data['sms_alert_change_status']:''
        ,$merchant_id);
        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");
      } 


      public function ViewccDetailSms()
  {    
     if ( $res=FunctionsV3::getMerchantCCdetails($this->data['id'])){
      Yii::app()->controller->renderPartial('/admin/cc-details',array(
               'data'=>$res,               
        ),false);
     } else echo t("No recods found");
       Yii::app()->end(); 
  }









        public function merchantSignUp2()
    {       
                                    
       
            
        $status=$this->functions->getOptionAdmin('merchant_sigup_status');
        if(empty($status)){
            $status='pending';
        }   
        $token=md5($this->data['restaurant_name'].date('c'));
        
        $percent=$this->functions->getOptionAdmin('admin_commision_percent');
        
        
                
        $params=array(
          'restaurant_name'=>($this->data['restaurant_name']),
          'restaurant_phone'=>($this->data['restaurant_phone']),
          'contact_name'=>($this->data['contact_name']),
          'contact_phone'=>($this->data['contact_phone']),
          'contact_email'=>($this->data['contact_email']),
          'street'=>($this->data['street']),
          'city'=>($this->data['city']),
          'post_code'=>$this->data['post_code'],
          'cuisine'=>json_encode($this->data['cuisine']),
          'username'=>$this->data['username'],
          'password'=>md5($this->data['password']),
          'status'=>$status,
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'activation_token'=>$token,
          'activation_key'=>$this->functions->generateRandomKey(5),
          'restaurant_slug'=>$this->functions->createSlug($this->data['restaurant_name']),       
          'payment_steps'=>3,         
          'country_code'=>$this->data['country_code'],
          'state'=>$this->data['state'],
          'is_commission'=>2,
          'percent_commision'=>is_numeric($percent)?$percent:0,       
          'abn'=>isset($this->data['abn'])?$this->data['abn']:'',
          'merchant_type'=>isset($this->data['merchant_type'])?$this->data['merchant_type']:'',
          'service'=>isset($this->data['service'])?$this->data['service']:1,
          'delivery_distance_covered'=>isset($this->data['delivery_distance_covered'])?(float)$this->data['delivery_distance_covered']:0,
          'distance_unit'=>isset($this->data['distance_unit'])?($this->data['distance_unit']):'mi',
        );          
        
        if (isset($this->data['invoice_terms'])){
            if (is_numeric($this->data['invoice_terms'])){
                $params['invoice_terms']=$this->data['invoice_terms'];
            }       
        }
                        
        $commision_type=$this->functions->getOptionAdmin('admin_commision_type');
        if(!empty($commision_type)){
            $params['commision_type']=$commision_type;
        }       
        
        if ( !$this->functions->validateUsername($this->data['username']) ){
            
            if ($respck=$this->functions->validateMerchantUserFromMerchantUser($params['username'],
                $params['contact_email'])){
                $this->msg=$respck;
                return ;                    
            } 

            $last_insert_id = $this->functions->insertData('mt_merchant', $params);
            if ($last_insert_id!== false){            
                                                
                $mtid=$last_insert_id;
                                
                $this->functions->updateOption("merchant_delivery_miles",
                $params['delivery_distance_covered']
                ,$mtid);
                
                $this->functions->updateOption("merchant_distance_type",
                $params['distance_unit']
                ,$mtid);            
                    
                //AUTO ADD SIZE
                $this->functions->autoAddSize($mtid);
                
                /*ADD CUISINE*/
                try {
                    $cuisine = isset($this->data['cuisine'])?$this->data['cuisine']:array();
                    $this->functions->insertCuisine($mtid,(array)$cuisine);
                } catch (Exception $e) {
                    //$e->getMessage()
                }   
                    
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");
                $this->details=$token;
                
                /*SEND WELCOME EMAIL*/
                $this->functions->sendWelcomeEmailMerchant($params,true);
                
                /*SEND NOTIFICATION TO ADMIN*/
                //$this->functions->NotiNewMerchantSignup($params,'commission');
                                                                            
            } else $this->msg=$this->functions->translation("default","Sorry but we cannot add your information. Please try again later");
        } else $this->msg=$this->functions->translation("default","Sorry but your username is alread been taken.");
    }





         public function clientRegistration()
        {           
            
            /** check if admin has enabled the google captcha*/             
            if ( $this->functions->getOptionAdmin('captcha_customer_signup')==2){
                try {                   
                    $recaptcha_token = isset($this->data['recaptcha_v3'])?$this->data['recaptcha_v3']:'';                   
                    $this->functions->validateToken($recaptcha_token);
                } catch (Exception $e) {
                     $this->msg = $e->getMessage();
                     return ;
                }
            } 
                                    
            /*add confirm password */
            if (isset($this->data['cpassword'])){
                if ($this->data['cpassword'] != $this->data['password']){
                    $this->msg=$this->functions->translation("default","Confirm password does not match");
                    return ;
                }           
            }           
            
            /*check if email address is blocked*/
            if ( $this->functions->emailBlockedCheck($this->data['email_address'])){
                $this->msg=$this->functions->translation("default","Sorry but your email address is blocked by website admin");
                return ;
            }       
            
            if ( $this->functions->mobileBlockedCheck($this->data['contact_phone'])){
                $this->msg=$this->functions->translation("default","Sorry but your mobile number is blocked by website admin");
                return ;
            }           
                        
            /*check if mobile number already exist*/
            
            if ( !$res=$this->functions->isClientExist($this->data['email_address']) ){
                if ( $this->functions->CheckCustomerMobile($this->data['contact_phone'])){
                    $this->msg=$this->functions->translation("default","Sorry but your mobile number is already exist in our records");
                    return ;
                }     
            }
            
           
            $this->functions->email(array(
              'email_address'=>$this->functions->translation("default","Invalid email address")
            ),$this->data);
            if (!$this->functions->validate()){
                $this->msg=$this->functions->getErrorAsHTML();
                return ;
            }
                        
            if ( !$res=$this->functions->isClientExist($this->data['email_address']) ){
                
                
                
                $params=array(
                  'first_name'=>($this->data['first_name']),
                  'last_name'=>($this->data['last_name']),
                  'email_address'=>(trim($this->data['email_address'])),
                  'password'=>md5($this->data['password']),
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'contact_phone'=>($this->data['contact_phone'])
                );
                
                /** send verification code */
                $verification=$this->functions->getOptionAdmin("website_enabled_mobile_verification");     
                if ( $verification=="yes"){
                    $code=$this->functions->generateRandomKey(5);                  
                    /*FunctionsV3::sendCustomerSMSVerification($this->data['contact_phone'],$code);
                    $params['mobile_verification_code']=$code;
                    $params['status']='pending';*/
                }             
                
                /*send email verification added on version 3*/
                $email_code=$this->functions->generateCode(10);
                $email_verification=$this->functions->getOptionAdmin('theme_enabled_email_verification');
                if ($email_verification==2){
                    $params['email_verification_code']=$email_code;
                    $params['status']='pending';                    
                    //FunctionsV3::sendEmailVerificationCode($params['email_address'],$email_code,$params);
                }
            
                /** update 2.3*/
                if (isset($this->data['custom_field1'])){
                    $params['custom_field1']=!empty($this->data['custom_field1'])?$this->data['custom_field1']:'';
                }
                if (isset($this->data['custom_field2'])){
                    $params['custom_field2']=!empty($this->data['custom_field2'])?$this->data['custom_field2']:'';
                }
                

                $customer_token =$this->functions->generateCustomerToken();
                $params['token']=$customer_token;
                
                $last_insert_id = $this->functions->insertData('mt_client', $params);
                if ($last_insert_id!== false){                      
                    $client_id = $last_insert_id;   
                    $this->details = $client_id;

                    
                    $this->code=1;
                    $this->msg=$this->functions->translation("default","Registration successful");

                    if ( $verification=="yes"){                     
                        $this->msg=$this->functions->translation("default","We have sent verification code to your mobile number");
                    } elseif ( $email_verification ==2 ){ 
                        $this->msg=$this->functions->translation("default","We have sent verification code to your email address");
                        
                        $params['verification_link'] = $this->functions->websiteUrl()."/email_verification/?id=".urlencode($customer_token);
                        $this->functions->sendEmailVerificationCode($params['email_address'],$email_code,$params);
                        
                    } else {
                       /*sent welcome email*/                          
                       $this->functions->sendCustomerWelcomeEmail($params);
                       $this->functions->clientAutoLogin($this->data['email_address'],$this->data['password']);
                    }                   
                                        
                    /*POINTS PROGRAM*/                  
                    /*if (FunctionsV3::hasModuleAddon("pointsprogram")){
                       PointsProgram::signupReward($this->details);
                    }*/
                    
                } else $this->msg=$this->functions->translation("default","Something went wrong during processing your request. Please try again later.");
            } else {                                
                $verification=$this->functions->getOptionAdmin("website_enabled_mobile_verification");     
                if ( $verification=="yes"){
                    if (strlen($res['mobile_verification_code'])>=2 && $res['status']=='pending'){
                        $this->msg=$this->functions->translation("default","Found existing registration");
                        $this->code=1;
                        $this->details=$res['client_id'];
                        return ;
                    }               
                }
               $this->msg=$this->functions->translation("default","Sorry but your email address already exist in our records.");
            }
        }               







          public function clientRegistrationModal()
        {           
            
            /** check if admin has enabled the google captcha*/  

            if ( $this->functions->getOptionAdmin('captcha_customer_signup')==2){

               if (!isset($this->data['captcha_check_reg'])){

                try {                   
                    $recaptcha_token = isset($this->data['recaptcha_v3'])?$this->data['recaptcha_v3']:'';                   
                    $this->functions->validateToken($recaptcha_token);
                } catch (Exception $e) {
                     $this->msg = $e->getMessage();
                     return ;
                }
              }


            } 
                                    
            /*add confirm password */
            if (isset($this->data['cpassword'])){
                if ($this->data['cpassword'] != $this->data['password']){
                    $this->msg=$this->functions->translation("default","Confirm password does not match");
                    return ;
                }           
            }           
            
            /*check if email address is blocked*/
            if ( $this->functions->emailBlockedCheck($this->data['email_address'])){
                $this->msg=$this->functions->translation("default","Sorry but your email address is blocked by website admin");
                return ;
            }       
            
            if ( $this->functions->mobileBlockedCheck($this->data['contact_phone'])){
                $this->msg=$this->functions->translation("default","Sorry but your mobile number is blocked by website admin");
                return ;
            }           
                        
            /*check if mobile number already exist*/
            
          /*  if ( $res=$this->functions->isClientExist_with_merchant($this->data['email_address'],0) ){
                if ( $this->functions->CheckCustomerMobile_with_merchant($this->data['contact_phone'],0)){
                    $this->msg=$this->functions->translation("default","Sorry but your mobile number is already exist in our records");
                    return ;
                }     
            }*/
           /* $res1=$this->functions->isClientExist_with_merchant($this->data['email_address'],0);
            print_r($res1);die();*/

            if ($this->functions->isClientExist_with_merchant($this->data['email_address'],0)){     
          
              
          $this->msg="Sorry but your email address already exist in our recordsss";
          return;
        }

        if ( $this->functions->CheckCustomerMobile_with_merchant($this->data['contact_phone'],0)){
            //$this->Validator->msg[]  = $this->functions->translation("default","Sorry but your mobile number is already exist in our records");     

            $this->msg="Sorry but your mobile number is already exist in our records";  
            return;     
          } 

            
            
            
            $this->functions->email(array(
              'email_address'=>"Invalid email address"
            ),$this->data);
            if (!$this->functions->validate()){
                $this->msg=$this->functions->getErrorAsHTML();
                return ;
            }
                        
            if ( 1==1 ){
                
                
                
                $params=array(
                  'first_name'=>($this->data['first_name']),
                  'last_name'=>($this->data['last_name']),
                  'email_address'=>(trim($this->data['email_address'])),
                  'password'=>md5($this->data['password']),
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'merchant_id'=>0,
                  'contact_phone'=>($this->data['contact_phone'])
                );
                
                /** send verification code */
                $verification=$this->functions->getOptionAdmin("website_enabled_mobile_verification");
                if (!isset($this->data['captcha_check_reg'])){  //added by was custom   
                if ( $verification=="yes"){
                    $code=$this->functions->generateRandomKey(5);                  
                    //$this->functions->sendCustomerSMSVerification($this->data['contact_phone'],$code);
                    $this->functions->sendCustomerSMSVerification($this->data['contact_phone'],$code);
                    $params['mobile_verification_code']=$code;
                    $params['status']='pending';
                }
                }             
                
                /*send email verification added on version 3*/
                $email_code=$this->functions->generateCode(10);
                $email_verification=$this->functions->getOptionAdmin('theme_enabled_email_verification');
                if (!isset($this->data['captcha_check_reg'])){ //added by was custom
                if ($email_verification==2){
                    $params['email_verification_code']=$email_code;
                    $params['status']='pending';                    
                    //FunctionsV3::sendEmailVerificationCode($params['email_address'],$email_code,$params);
                }
              }
            
                /** update 2.3*/
                if (isset($this->data['custom_field1'])){
                    $params['custom_field1']=!empty($this->data['custom_field1'])?$this->data['custom_field1']:'';
                }
                if (isset($this->data['custom_field2'])){
                    $params['custom_field2']=!empty($this->data['custom_field2'])?$this->data['custom_field2']:'';
                }
                

                $customer_token =$this->functions->generateCustomerToken();
                $params['token']=$customer_token;
               
                $last_insert_id = $this->functions->insertData('mt_client', $params);
                if ($last_insert_id!== false){                         
                
                    $client_id = $last_insert_id;   
                    $this->details = $client_id;

                    

                    
                    $this->code=1;
                    $this->msg=$this->functions->translation("default","Registration successful");
                    

                    //+++was custom code
                    if (isset($this->data['captcha_check_reg'])){
                      $verification=="no";
                       $email_verification =1;
                    }
                    //---was custom code


                    if ( $verification=="yes"){                     
                        $this->msg=$this->functions->translation("default","We have sent verification code to your mobile number");
                    } elseif ( $email_verification ==2 ){ 


                        $this->msg=$this->functions->translation("default","We have sent verification code to your email address");
                        
                        $params['verification_link'] = $this->functions->websiteUrl()."/email_verification/?id=".urlencode($customer_token);
                        $this->functions->sendEmailVerificationCode($params['email_address'],$email_code,$params);


                        
                    } else {
                       /*sent welcome email*/                          
                       $this->functions->sendCustomerWelcomeEmail($params);
                       $this->functions->clientAutoLogin_mainwebsite($this->data['email_address'],$this->data['password']);

                       /*$this->functions->clientAutoLogin_with_merchant($this->data['username'],
                       $this->data['password'],'',0);*/
                    } 

                    /*POINTS PROGRAM*/ 

                    $this->PointsProgram->signupReward($this->details);




                    
                    
                } else $this->msg=$this->functions->translation("default","Something went wrong during processing your request. Please try again later.");
            } else {                                
                $verification=$this->functions->getOptionAdmin("website_enabled_mobile_verification");     
                if ( $verification=="yes"){
                    if (strlen($res['mobile_verification_code'])>=2 && $res['status']=='pending'){
                        $this->msg=$this->functions->translation("default","Found existing registration");
                        $this->code=1;
                        $this->details=$res['client_id'];
                        return ;
                    }               
                }
               $this->msg=$this->functions->translation("default","Sorry but your email address already exist in our records.");
            }
        }


public function applyVoucher()
{           
    // Check if a discount is already applied
    if (isset($_SESSION['promo_discount'])){
        if ($_SESSION['promo_discount'] == 1){
            $this->msg = $this->functions->translation("default", "Sorry, you cannot apply voucher; an existing discount is already applied in your cart.");
            return;
        }   
    }

    // Check if the user is logged in
    if (!$this->functions->isClientLogin()){
        $this->msg = $this->functions->translation("default", "You must be logged in to use the voucher.");
        return;
    }

    // Initialize voucher code and other data
    $_SESSION['voucher_code'] = '';
    $voucher_code = isset($this->data['voucher_code']) ? $this->data['voucher_code'] : '';
    $merchant_id = isset($this->data['merchant_id']) ? $this->data['merchant_id'] : '';
    $sub_total = isset($this->data['sub_total']) ? (float)$this->data['sub_total'] : 0;

    if (!empty($voucher_code)) {
        $mtid = '"' . $merchant_id . '"';
        $today = strtolower(date("l"));

        // Prepare SQL query with named parameters
        $stmt = $this->db->prepare("
            SELECT *,
                (
                    SELECT COUNT(*) 
                    FROM mt_order
                    WHERE voucher_code = :voucher_code
                    AND client_id = :client_id
                    LIMIT 0, 1
                ) AS found
            FROM mt_voucher_new a
            WHERE voucher_name = :voucher_code
            AND CURDATE() <= expiration
            AND $today = 1
            AND (merchant_id = :merchant_id OR joining_merchant LIKE :mtid)
        ");

        // Bind the parameters using bindValue
        $stmt->bindValue(':voucher_code', $voucher_code, PDO::PARAM_STR);
        $stmt->bindValue(':client_id', $this->functions->getClientId(), PDO::PARAM_INT);
        $stmt->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindValue(':mtid', "%$mtid%", PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Fetch the result
        if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {

            // Check if voucher code can be used only once
            if ($res['used_once'] == 2) {
                if ($res['number_used'] > 0) {
                    $this->msg = $this->functions->translation("default", "Sorry, this voucher code has already been used.");
                    return;
                }
            }

            // Check if voucher code has already been used by the client
            if ($res['found'] > 0) {
                $this->msg = $this->functions->translation("default", "Sorry, but you have already used this voucher code.");
                return;
            }

            // Check for minimum order value for the voucher
            $min_order = isset($res['min_order']) ? (float)$res['min_order'] : 0;
            if ($min_order > 0) {
                if ($sub_total <= $min_order) {
                    $this->msg = $this->functions->translation("default", "Minimum order for this voucher is [min_order] " . $this->functions->formatNumber($min_order));
                    return;
                }
            }

            // Check if balance will be negative after applying the voucher
            $less_amount = 0;
            if ($res['voucher_type'] == "percentage") {
                $less_amount = $sub_total * ($res['amount'] / 100);
            } else {
                $less_amount = $res['amount'];
            }

            $sub_total_after_less_voucher = $sub_total - $less_amount;

            if ($sub_total_after_less_voucher <= -1) {
                $this->msg = $this->functions->translation("default", "Sorry, you cannot apply a voucher that will make the Sub Total negative after applying the voucher.");
                return;
            }

            // If everything checks out, set success message and store voucher in session
            $this->code = 1;
            $this->msg = "OK";
            $_SESSION['voucher_code'] = $res;

        } else {
            // Voucher code not found
            $this->msg = $this->functions->translation("default", "Voucher code not found.");
        }
    } else {
        // Voucher code is empty
        $this->msg = $this->functions->translation("default", "Please enter a voucher code.");
    }
}


        public function removeVoucher()
        {
            $this->code=1;
            $_SESSION['voucher_code']='';
        }   







         public function placeOrder()
        {

            
            
            /*Cannot do order again if previous order status is*/
            if ($this->functions->isClientLogin()){                
                try {                   
                    $client_id=$this->functions->getClientId();
                    $this->CheckoutWrapper->verifyCanPlaceOrder( (integer) $client_id);                    
                } catch (Exception $e) {
                     $this->msg = $e->getMessage();
                     return ;
                }
            }
                        
            $merchantid=isset($this->data['merchant_id'])?(integer)$this->data['merchant_id']:0;
            $time_order_management = $this->functions->getOption('merchant_time_order_management',$merchantid);           
            if($time_order_management==1){
                try {                   
                    
                    $deliverytime = isset($_SESSION['kr_delivery_options']['delivery_time'])?$_SESSION['kr_delivery_options']['delivery_time']:'';
                    if(is_null($deliverytime) || $deliverytime=="null" || empty($deliverytime)){
                        $deliverytime =date("H:i");
                    }               
                    
                    $this->CheckoutWrapper->verifyOrderTimeManagement(
                      $merchantid,
                      isset($this->data['delivery_type'])?$this->data['delivery_type']:'',
                      isset($_SESSION['kr_delivery_options']['delivery_date'])?$_SESSION['kr_delivery_options']['delivery_date']:'',
                      $deliverytime
                      
                    );
                } catch (Exception $e) {
                     $this->msg = $e->getMessage();
                     return ;
                }
            }       
                        
            //echo "orders_was";die(); 
            $transaction_type = isset($this->data['delivery_type'])?$this->data['delivery_type']:'';
            $accurate_address_lat = isset($this->data['map_accurate_address_lat'])?$this->data['map_accurate_address_lat']:$_SESSION['client_location']['lat'];
            $accurate_address_lng = isset($this->data['map_accurate_address_lng'])?$this->data['map_accurate_address_lng']:$_SESSION['client_location']['long'];
            //nnnnnnnnnnnnnnnnnnnnnnnnnnnnnnnn
            $enabled_map_selection_delivery = $this->functions->getOptionAdmin('enabled_map_selection_delivery');
            $disabled_order_confirm_page = $this->functions->getOptionAdmin('disabled_order_confirm_page');
            $is_by_location = $this->functions->isSearchByLocation();        
            
            if($enabled_map_selection_delivery!=1 && empty($accurate_address_lng) &&
                $transaction_type=="delivery" && $disabled_order_confirm_page!=1 ){             
                if(isset($_SESSION['checkout_resp_geocode'])){
                   $resp_geocode = $_SESSION['checkout_resp_geocode'];                 
                   if(isset($resp_geocode['lat'])){                 
                       $accurate_address_lat =  $resp_geocode['lat'];
                       $accurate_address_lng =  $resp_geocode['long'];
                   }
                }           
            }      
                                        
            if($transaction_type=="delivery" && empty($accurate_address_lng)
                && $disabled_order_confirm_page==1 && $is_by_location!=true ){      
                    
                $address_book_id = isset($this->data['address_book_id'])?$this->data['address_book_id']:'';
                if ($address_book_id > 0) {
          $client_id = $this->functions->getClientId();

          $stmt_book = "SELECT * FROM mt_address_book WHERE client_id = :client_id AND id = :address_book_id";
          $query = $this->db->prepare($stmt_book);
          
          $query->bindParam(':client_id', $client_id, PDO::PARAM_INT);
          $query->bindParam(':address_book_id', $address_book_id, PDO::PARAM_INT);
          
          $query->execute();
          
          if ($resp_book = $query->fetch(PDO::FETCH_ASSOC)) {
              $accurate_address_lat = $resp_book['latitude'];
              $accurate_address_lng = $resp_book['longitude'];
          }
            }
             
            }
            
            
            if($transaction_type=="delivery" && empty($accurate_address_lng)
                && $disabled_order_confirm_page==1 && $is_by_location!=true ){      
                
                $street = isset($this->data['street'])?$this->data['street']:'';
                $city = isset($this->data['city'])?$this->data['city']:'';      
                $state = isset($this->data['state'])?$this->data['state']:'';
                $zipcode = isset($this->data['zipcode'])?$this->data['zipcode']:'';
                $country_code = isset($this->data['country_code'])?$this->data['country_code']:'';
                $country_name = $this->functions->countryCodeToFull($country_code);        
                $complete_address = "$street $city $zipcode $country_name";                                     
                
                try {                                       
                    $resp_geocode = $this->functions->geodecodeAddress($complete_address);

                    $accurate_address_lat = $resp_geocode['lat'];
                    $accurate_address_lng = $resp_geocode['long'];      
                    $_SESSION['checkout_resp_geocode'] = $resp_geocode;
                } catch (Exception $e) {
                    $this->msg = $e->getMessage();
                    return ;
                }
                    
            }       
                        
            if ( $transaction_type=="delivery" && $is_by_location!=true){
                if(empty($accurate_address_lat) || empty($accurate_address_lng)){
                    $this->msg=$this->functions->translation("default","Please select location on tne map");
                    return ;
                }                   
            }
            
            
            
            
            $mtid=isset($_SESSION['kr_merchant_id'])?$_SESSION['kr_merchant_id']:'';
            if(empty($mtid)){
                $this->msg=$this->functions->translation("default","Merchant ID is missing");
                return ;
            }       
            
            // set merchant timezone            
            $mt_timezone=$this->functions->getOption("merchant_timezone",$mtid);                   
            if (!empty($mt_timezone)){
                date_default_timezone_set($mt_timezone);
            }                               
            
            /*CHECK IF CLOSING TIME ALREADY*/
            $order_delivery_date=isset($_SESSION['kr_delivery_options']['delivery_date'])?$_SESSION['kr_delivery_options']['delivery_date']:'';
            if(!empty($order_delivery_date)){               
               $order_delivery_date=strtolower(date("Y-m-d",strtotime($order_delivery_date)));
            }
            $enabled_merchant_check_closing_time=$this->functions->getOptionAdmin('enabled_merchant_check_closing_time');   
                            
            $full_delivery_date=$_SESSION['kr_delivery_options']['delivery_date']." ".$_SESSION['kr_delivery_options']['delivery_time'];            
            if(!empty($order_delivery_date) && $enabled_merchant_check_closing_time==1){               
                $delivery_date=strtolower(date("D",strtotime($order_delivery_date)));               
                if(!empty($_SESSION['kr_delivery_options']['delivery_time'])){
                    $delivery_time=date('h:i A',strtotime($full_delivery_date));
                } else $delivery_time=date('h:i A',strtotime(date('c')));               
                                
                if ( !$this->functions->isMerchantOpenTimes($mtid,$delivery_date,$delivery_time)){                 
                    $this->msg=$this->functions->translation("default","Sorry but merchant is already close");
                    return ;
                }               
            }    
            
            
            /*check if merchant has enabled Order sms verification*/
            if (isset($this->data['client_order_sms_code'])){
                if (!empty($this->data['client_order_sms_code'])){
                    if (!$this->functions->validateOrderSMSCode($this->data['contact_phone'],$this->data['client_order_sms_code'],
                    $this->data['client_order_session'])){                      
                        $this->msg=$this->functions->translation("default","Sorry but you have input invalid order sms code");
                        return ;
                    }               
                }
            }           
            
            /** re-check delivery address */



            if ( $this->data['delivery_type']=="delivery"){
                 
                /*Version 3 change getting of delivery fee*/
                if (!$this->functions->isSearchByLocation()){
                    /*RE CHECK DELIVERY FEE*/                   
                    try {           
                        $order_subtotal = isset($_SESSION['kmrs_subtotal'])?$_SESSION['kmrs_subtotal']:0;                       
                        $resp = $this->CheckoutWrapper->verifyLocation($mtid,$accurate_address_lat,$accurate_address_lng,$order_subtotal);                     
                        $_SESSION['shipping_fee']=$resp['delivery_fee'];
                        $_SESSION['shipping_distance']=isset($resp['pretty_distance'])?$resp['pretty_distance']:'';                 
                        
                    } catch (Exception $e) {
                        $this->msg = $e->getMessage();
                        return ;
                    }
                } else {                    
                    $disabled_order_confirm_page = $this->functions->getOptionAdmin('disabled_order_confirm_page');
                    
                    if(isset($this->data['address_book_id_location'])){
                       $address_book_id_location = $this->data['address_book_id_location'];     
                       if($res_book = $this->functions->getAddressByLocationFullDetails($address_book_id_location)){                            
                            $this->data['state_id']=$res_book['state_id'];
                            $this->data['city_id']=$res_book['city_id'];
                            $this->data['area_id']=$res_book['area_id'];
                            
                            $this->data['street'] = $res_book['street'];                    
                            $this->data['city'] = $res_book['city_name'];
                            $this->data['state'] = $res_book['state_name'];
                            $this->data['area_name'] = $res_book['area_name'];
                            $this->data['location_name'] = $res_book['location_name'];
                            $this->data['zipcode'] = $res_book['postal_code'];
                       }
                    }                       
                    $params_check=array(
                       'state_id'=>$this->data['state_id'],
                       'city_id'=>$this->data['city_id'],
                       'area_id'=>$this->data['area_id'],
                       'location_city'=>isset($this->data['city'])?$this->data['city']:'',
                       'city_name'=>isset($this->data['city'])?$this->data['city']:'',
                       'location_area'=>isset($this->data['area_name'])?$this->data['area_name']:'',
                       'location_type'=>$this->functions->getOptionAdmin('admin_zipcode_searchtype')
                    );
                    
                    if ( $fee=$this->functions->validateCanDeliverByLocation($mtid,$params_check)){
                            
                        $order_subtotal = isset($_SESSION['kmrs_subtotal'])?(float)$_SESSION['kmrs_subtotal']:0;  
                        $minimum_order = (float)$fee['minimum_order'];
                        if($minimum_order>0){
                            if($minimum_order>$order_subtotal){
                               
                                 $this->msg =  $this->functions->translation("default","Minimum order is ". $this->functions->formatNumber($minimum_order));
                                

                                return ;
                            }
                        }               
                        
                        $_SESSION['shipping_fee']=$fee['fee'];                          
                        //Cookie::setCookie('kr_location_search',json_encode($params_check)); 
                    } else {
                        $this->msg=$this->functions->translation("default","Sorry this merchant does not deliver to your location");
                        return ;
                    }               
                }           
            }           
            /** re-check delivery address */
     $is_guests='0';          
                        
            /*guest checkout*/                                               
            if (isset($this->data['is_guest_checkout'])){
                //$Validator=new Validator;


                
                if (empty($this->data['email_address'])){
                    $this->data['email_address']=str_replace(" ","_",$this->data['first_name']).$this->functions->generateRandomKey()."@".$_SERVER['HTTP_HOST'];
                }           
                                
                $guest_exist=false;         
                if ($res_check=$this->functions->isClientExist_guest($this->data['email_address'])){ 

                   

                    if ( $res_check['is_guest']==1){
                        //$this->msg="Sorry but your email address already exist in our records.";
                        //return ;

                        $guest_exist=true;
                        $guest_client_id_new=$res_check['client_id'];
                        $guest_password=$res_check['password'];



                    } else $guest_exist=false;
                }

               if($guest_exist){
                $_SESSION['guest_chkout']=1;
               }else{
                $_SESSION['guest_chkout']=0;
               }
                
                $this->data['password']=isset($this->data['password'])?$this->data['password']:'';
                if (empty($this->data['password'])){
                    $this->data['password']=$this->functions->generateRandomKey();
                }               
                                                        
                /*check if email address is blocked*/
                if ( $this->functions->emailBlockedCheck($this->data['email_address'])){
                    $this->msg=$this->functions->translation("default","Sorry but your email address is blocked by website admin");
                    return ;
                }
                
                if ( $this->functions->mobileBlockedCheck($this->data['contact_phone'])){
                    $this->msg=$this->functions->translation("default","Sorry but your mobile number is blocked by website admin");
                    return ;
                }     
                                
                //$functionk=new FunctionsK();                    
                
                $params=array(
                  'first_name'=>($this->data['first_name']),
                  'last_name'=>($this->data['last_name']),
                  'email_address'=>($this->data['email_address']),
                  'password'=>md5($this->data['password']),
                  'street'=>($this->data['street']),
                  'city'=>($this->data['city']),
                  'state'=>($this->data['state']),
                  'zipcode'=>($this->data['zipcode']),
                  'contact_phone'=>($this->data['contact_phone']),
                  'location_name'=>($this->data['location_name']),
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'contact_phone'=>($this->data['contact_phone']),
                  'is_guest'=>1
                );                                              
                if ($guest_exist){   

                      
                                 
                        $new_client_id = $guest_client_id_new;            
                        $this->functions->deleteCustomerGuest( (integer) $new_client_id,$params['email_address']);
                        $this->functions->clientAutoLogin_guest_existing($this->data['email_address'],$guest_password);
                       //echo ($this->functions->getClientId());die();
                        
                    
                } else {            
                    if ( $this->functions->insertData('mt_client', $params)){                      
                        $this->functions->clientAutoLogin_guest($this->data['email_address'],$this->data['password']);
                    } else{ $this->msg=$this->functions->translation("default","Something went wrong during processing your request. Please try again later.");return;}
                }
                
                if (!$this->functions->validate()){
                    $this->msg=$this->functions->getErrorAsHTML();
                    return ;
                }   


$is_guests='1';       
            }    


            /*guest checkout*/          
            
            $this->data['merchant_id']=$_SESSION['kr_merchant_id'];  
            
            $default_order_status=$this->functions->getOption("default_order_status",$_SESSION['kr_merchant_id']);                     
            $order_item=isset($_SESSION['kr_item'])?$_SESSION['kr_item']:'';
            if (is_array($order_item) && count($order_item)>=1){    
               
                /** card fee condition */
                $card_fee=0; $card_percentage=0;
                
                /*Custom code 10 starts */

                
                if ($transaction_type=="pickup"){
                        $n_total = $this->data['x_subtotal'];
                        } else 

                        $n_total = floatval($this->data['x_subtotal']) + floatval($_SESSION['shipping_fee'] ?? 0);


                /*Custom code 10 ends */
                
                
                                                
                /*if ( !empty($card_fee) && $card_fee>=0.0001){                 
                    $this->data['card_fee']=$card_fee;                  
                }*/

            
               

                if ( !empty($card_fee) && $card_fee>=0.0001){                       
                    $this->data['card_fee']=$card_fee;                          
                }
                if($card_percentage>0){
                    $this->data['card_percentage']=$card_percentage;    
                }               
                /** end card fee */


                
                /*MULTI CURRENCY*/
                $rates = array(); $multi_currency_enabled = false;
                $currency_use = isset($_SESSION['currency']) ? $_SESSION['currency'] : null;
                /*if ($multi_currency_enabled = Item_utility::MultiCurrencyEnabled()){
                    $rates = Multicurrency_finance::getExchangeRate( $currency_use );                               
                } else {
                    $rates = Item_utility::defaultExchangeRate( $currency_use );
                } */
                 $rates = $this->functions->defaultExchangeRate( $currency_use );
                //Price_Formatter::init( Yii::app()->session['currency'] );
                            
                $this->data = array_merge( (array) $this->data, (array) $rates);    
                
                /*SERVICE FEE*/                    
                if($service_resp = $this->functions->getServiceFee($this->data['merchant_id'])){
                    $this->data['service_fee'] = (float)$service_resp['service_fee'];
                    $this->data['service_fee_applytax'] = $service_resp['service_fee_applytax'];                
                }     


                               
                $displayOrderHTML=$this->functions->displayOrderHTML($this->data,$_SESSION['kr_item']);
               


                if ( $displayOrderHTML['code']==1){
                     
                    /*ITEM TAXABLE*/                        
                    $apply_tax=0;               
                    if(!empty($mtid)){
                        $apply_tax=$this->functions->getOption('merchant_apply_tax',$mtid);
                        $tax_set=$this->functions->getMerchantTax($mtid);
                        if ( $apply_tax==1 && $tax_set>0){                  
                            $displayOrderHTML['raw']=$_SESSION['cart_item_tax'];


                        }       
                    }
                                                
                    $raw=$displayOrderHTML['raw'];    
                   

                    
                    $exchange_rate = isset($rates['exchange_rate'])? (float) $rates['exchange_rate']:1;
                                                            
                   /* if($multi_currency_enabled && $exchange_rate!=1){                            
                       $order_item = Cart_utility::reFormat($order_item,$exchange_rate);                       
                    }*/
                    
                     /* custom code 3 starts */
                    $sop='';    
                    if($this->data['payment_opt']=='sop'){  
                            
                          $sop=$this->data['payment_opt'];  
                            $this->data['payment_opt']='cod';   
                        }
                    /* Custom code 3 ends */
                    
                    /* Custom code 12 starts */
                    if($_SESSION['kr_delivery_options']['delivery_type']=='pickup' && isset($_SESSION['kr_delivery_options']['car_no']) && !empty($_SESSION['kr_delivery_options']['car_no']) && $_SESSION['kr_delivery_options']['noplate']==1){
                        $car_no=$_SESSION['kr_delivery_options']['car_no'];
                        $noplates=$_SESSION['kr_delivery_options']['noplate'];
                    }else{
                        $car_no='';
                        $noplates='0';
                    }
                    
                    /* Custom code 12 ends */
                   
                                                            
                    if (is_array($raw) && count($raw)>=1){

                        $params=array(
                          'merchant_id'=>$this->data['merchant_id'],
                          'client_id'=>$this->functions->getClientId(),
                          'json_details'=>json_encode($order_item),
                          'trans_type'=>isset($_SESSION['kr_delivery_options']['delivery_type'])?$_SESSION['kr_delivery_options']['delivery_type']:'',
                          'payment_type'=>isset($this->data['payment_opt'])?$this->data['payment_opt']:'',
                          'sub_total'=>isset($raw['total']['subtotal'])?$raw['total']['subtotal']:'',                         
                          'tax'=>is_numeric($raw['total']['tax'])?$raw['total']['tax']:0,
                          'taxable_total'=>isset($raw['total']['taxable_total'])?$raw['total']['taxable_total']:'',
                          'total_w_tax'=>isset($raw['total']['total'])?$raw['total']['total']:'',
                          'delivery_charge'=>isset($raw['total']['delivery_charges'])?$raw['total']['delivery_charges']:'',
                          'delivery_date'=>isset($_SESSION['kr_delivery_options']['delivery_date'])?$_SESSION['kr_delivery_options']['delivery_date']:'',
                          'delivery_time'=>isset($_SESSION['kr_delivery_options']['delivery_time'])?$_SESSION['kr_delivery_options']['delivery_time']:'',
                          'delivery_asap'=>isset($_SESSION['kr_delivery_options']['delivery_asap'])?$_SESSION['kr_delivery_options']['delivery_asap']:'',
                          'date_created'=>$this->functions->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR'],
                          'delivery_instruction'=>isset($this->data['delivery_instruction'])?($this->data['delivery_instruction']):'',
                          'cc_id'=>isset($this->data['cc_id'])?$this->data['cc_id']:'',                       
                          'order_change'=>isset($this->data['order_change'])?str_replace(",",'',$this->data['order_change']):'',
                          'payment_provider_name'=>isset($this->data['payment_provider_name'])?$this->data['payment_provider_name']:'',
                          'apply_food_tax'=>$apply_tax,
                          
                    //    custom code 12 starts
                          'car_park_enable'=>$noplates,
                          'number_plate'=>$car_no,
                    //    custom code 12 ends
                    
                          'calculation_method'=>$this->functions->getReceiptCalculationMethod()
                        );   
                   
               

                  //+++for card fees and total 
                        switch ($this->data['payment_opt'])
                {
                     
                                                        
                    case "stp":   
                    if($credentials = $this->functions->getCredentials_stripe($this->data['merchant_id'])){
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                              
                                $card_fee = $params['total_w_tax']*$credentials['card_fee']/100;
                            
                          }
                       }
                    }   
                    $params['total_w_tax']=$params['total_w_tax']+$card_fee;    
                    break;          
                    
                    case "paypal_v2":   
                    if($credentials = $this->functions->getCredentials_paypal($this->data['merchant_id'])){
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                              //$card_fee=$credentials['card_fee'];
                              $card_fee = $params['total_w_tax']*$credentials['card_fee']/100;
                          }
                       }
                    }   
                    $params['total_w_tax']=$params['total_w_tax']+$card_fee;    
                    break;          
                    
                   case "windcave": 
              if($credentials = $this->functions->getCredentials_windcave($this->data['merchant_id'])){
                  
                  
                       if(is_numeric($credentials['card_fee'])){
                          if($credentials['card_fee']>0.0001){
                                
                                $card_fee = $params['total_w_tax']*$credentials['card_fee']/100;

                            
                          }
                       }
                    }
                  
                  $params['total_w_tax']=$params['total_w_tax']+$card_fee;    
             break;  
                                                                    
                          
                    default:                        
                        break;  
                }   

     
                        
                 //---for card fees and total        

                        
                        /* custom code 2 starts */
                        //sop payment gateway   
                        if($sop=='sop'){    
                            $params['is_sop']="1";  
                        }
                        /* Custom code 2 ends */
                        
                        /*FIXED ORDER STATUS*/                                              
                        if ($this->data['payment_opt']=="cod" || $this->data['payment_opt']=="pyr" || 
                            $this->data['payment_opt']=="ccr" || $this->data['payment_opt']=="ocr" ){
                            if (!empty($default_order_status)){
                                $params['status']=$default_order_status;
                            } else $params['status']="pending";
                        } else $params['status']='initial_order';                   
                        
                        if ($this->data['payment_opt']=="obd"){
                            $params['status']="pending";
                        }                   
                                                                        
                        /*PROMO*/                       
                        //dump($raw);
                        if (isset($raw['total']['discounted_amount'])){
                            if ($raw['total']['discounted_amount']>=0.0001){                            
                                $params['discounted_amount']=$raw['total']['discounted_amount'];
                                $params['discount_percentage']=$raw['total']['merchant_discount_amount'];
                            }
                        }
                        
                                                                        
                        /*VOUCHER*/
                        $has_voucher=false;
                        if (isset($_SESSION['voucher_code'])){                  
                            if (is_array($_SESSION['voucher_code'])){                                   
                                $params['voucher_amount']= (float)$_SESSION['voucher_code']['amount']  * $exchange_rate;
                                $params['voucher_code']=$_SESSION['voucher_code']['voucher_name'];
                                $params['voucher_type']=$_SESSION['voucher_code']['voucher_type'];
                                $has_voucher=true;
                            }                
                        }           
                                                                                    
                        
                        /** add tips */                     
                        $params['cart_tip_percentage']=$raw['total']['cart_tip_percentage'];
                        $params['cart_tip_value']=$raw['total']['tips'];

                        /* Custom code 1 starts */
                        if ($this->data['payment_opt']=="cod" || $this->data['payment_opt']=="pyr" || $this->data['payment_opt']=="ccr" || $this->data['payment_opt']=="ocr" )
                        {
                            $payment_method = "offline";
                        }
                        else
                        {
                            $payment_method = "online";
                        }
                        /* Custom code 1 Ends */
                        
                        
                        /*Commission*/
                          /* Custom code 1 starts */
                          if($payment_method == 'online')
                        {
                            
                            if ( $this->functions->isMerchantCommission($this->data['merchant_id'])){
                                $admin_commision_ontop=$this->functions->getOptionAdmin('admin_commision_ontop');
                                if ( $com=$this->functions->getMerchantCommission($this->data['merchant_id'])){
                                    $params['percent_commision']=$com;                              
                                //  $params['total_commission']=($com/100)*$params['total_w_tax'];
                                    /* Custom code 10 starts */
                                    $params['total_commission']=($com/100)*($params['total_w_tax']-$card_fee);
                                    /* Custom code 10 ends */
                                //  $params['merchant_earnings']=$params['total_w_tax']-$params['total_commission'];
                                    /* Custom code 10 starts */
                                    $params['merchant_earnings']=$params['total_w_tax']-$params['total_commission']-$card_fee;
                                    /* Custom code 10 ends */
                                    if ( $admin_commision_ontop==1){
                                        $params['total_commission']=($com/100)*$params['sub_total'];
                                        $params['commision_ontop']=$admin_commision_ontop;                              
                                        $params['merchant_earnings']=$params['sub_total']-$params['total_commission'];
                                    }
                                }           
                                
                                /** check if merchant commission is fixed  */
                                $merchant_com_details=$this->functions->getMerchantCommissionDetails($this->data['merchant_id']);
                                
                                if ( $merchant_com_details['commision_type']=="fixed"){
                                    $params['percent_commision']=$merchant_com_details['percent_commision'];
                                    $params['total_commission']=$merchant_com_details['percent_commision'];
                                    $params['merchant_earnings']=$params['total_w_tax']-$merchant_com_details['percent_commision'];
                                    $params['commision_type']='fixed';
                                    
                                    if ( $admin_commision_ontop==1){                                
                                        $params['merchant_earnings']=$params['sub_total']-$merchant_com_details['percent_commision'];
                                    }
                                }            
                            }
                        }
                        else
                        {
                            if ( $this->functions->isMerchantCommission($this->data['merchant_id']))
                            {
                                $admin_commision_ontop=$this->functions->getOptionAdmin('admin_commision_ontop');
                                if ( $com=$this->functions->getMerchantCommissionOffline($this->data['merchant_id'])){
                                    $params['percent_commision']=$com;                              
                                    $params['total_commission']=($com/100)*$params['total_w_tax'];
                                    $params['merchant_earnings']=$params['total_w_tax']-$params['total_commission'];
                                    if ( $admin_commision_ontop==1){
                                        $params['total_commission']=($com/100)*$params['sub_total'];
                                        $params['commision_ontop']=$admin_commision_ontop;                              
                                        $params['merchant_earnings']=$params['sub_total']-$params['total_commission'];
                                    }
                                }           
                                
                                /** check if merchant commission is fixed  */
                                $merchant_com_details=$this->functions->getMerchantCommissionDetailsOffline($this->data['merchant_id']);
                                
                                if ( $merchant_com_details['commision_type']=="fixed"){
                                    $params['percent_commision']=$merchant_com_details['percent_commision'];
                                    $params['total_commission']=$merchant_com_details['percent_commision'];
                                    $params['merchant_earnings']=$params['total_w_tax']-$merchant_com_details['percent_commision'];
                                    $params['commision_type']='fixed';
                                    
                                    if ( $admin_commision_ontop==1){                                
                                        $params['merchant_earnings']=$params['sub_total']-$merchant_com_details['percent_commision'];
                                    }
                                }            
                            }
                        }

                          /* Custom code 1 Ends */
                        /** end commission condition*/
                        
                                    
                        if(isset($raw['total'])){
                           if(isset($raw['total']['merchant_packaging_charge'])){               
                               if(is_numeric($raw['total']['merchant_packaging_charge'])){
                                  $params['packaging'] = $raw['total']['merchant_packaging_charge'];
                               }
                           }                        
                        }                       
                        
                        /** card fee */
                        if ( !empty($card_fee) && $card_fee>=0.1){                                                
                            $params['card_fee']=$card_fee;
                        }  


                        /*if(isset($raw['total']['card_fee'])){
                            if($raw['total']['card_fee']>0){
                                $params['card_fee'] = (float) $raw['total']['card_fee'];
                            }                       
                        }*/
                                                                                                                      
                        /*if has address book selected*/
                        if ( isset($this->data['address_book_id'])){
                            if ($address_book=$this->functions->getAddressBookByID($this->data['address_book_id'])){
                                $this->data['street']=$address_book['street'];
                                $this->data['city']=$address_book['city'];
                                $this->data['state']=$address_book['state'];
                                $this->data['zipcode']=$address_book['zipcode'];
                                $this->data['location_name']=$address_book['location_name'];                                
                            }                       
                        }                  
                                              
                        
                        /** check if item is taxable*/ 
                        if ($this->functions->getOption("merchant_tax_charges",$mtid)==2){
                            $params['donot_apply_tax_delivery']=2;
                        }    



                        /*POINTS PROGRAM*/                          
                        
                            if (isset($_SESSION['pts_redeem_amt'])){
                                $params['points_discount'] = (float)$_SESSION['pts_redeem_amt'] * $exchange_rate;
                            }
                                                                    
                                                
                        $order_id_token = $this->functions->generateOrderToken();
                        $params['order_id_token']=$order_id_token;
                        $params['dinein_number_of_guest']=isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'';
                        $params['dinein_special_instruction']=isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'';
                         
                        if ($params['cc_id']=="undefined"){
                            $params['cc_id']=0;
                        }   
                        
                        if(!is_numeric($params['cc_id'])){
                            $params['cc_id']=0;
                        }
                                                
                        if(!is_numeric($params['order_change'])){
                            $params['order_change']=0;
                        }                                           
                        
                        if(!is_numeric($params['apply_food_tax'])){
                            $params['apply_food_tax']=0;
                        }                                           
                        if(!is_numeric($params['cart_tip_percentage'])){
                            $params['cart_tip_percentage']=0;
                        }                                           
                        if(!is_numeric($params['cart_tip_value'])){
                            $params['cart_tip_value']=0;
                        }
                        
                        if(isset($params['packaging'])){
                            if(!is_numeric($params['packaging'])){
                                $params['packaging']=0;
                            }
                        }
                         
                        if(isset($this->data['dinein_table_number'])){
                            $params['dinein_table_number']=$this->data['dinein_table_number'];
                        }

                        $params['distance'] = isset($_SESSION['shipping_distance'])?$_SESSION['shipping_distance']:0;

                       
                           
                        $last_insert_id = $this->functions->insertData('mt_order', $params);

                        

                        if ($last_insert_id!== false){                                          
                            $order_id=$last_insert_id;
                            
                    //      Custom code 12 starts
                            $_SESSION['kr_delivery_options']['car_no']='';
                            $_SESSION['kr_delivery_options']['noplate']=0;
                    //      Custom code 12 ends
                            
                            /*POINTS PROGRAM*/                                  
                            if(!isset($this->data['is_guest_checkout'])){
                                    

                                    
                                    $this->PointsProgram->saveEarnPoints(
                                       isset($_SESSION['pts_earn'])?$_SESSION['pts_earn']:'',
                                       $this->functions->getClientId(),
                                       $this->data['merchant_id'],
                                       $order_id,
                                       $this->data['payment_opt'],
                                       $params['status'],
                                       $order_id
                                    );
                                    
                                    if (isset($_SESSION['pts_redeem_points'])){
                                        $this->PointsProgram->saveExpensesPoints(
                                          $_SESSION['pts_redeem_points'],
                                          $_SESSION['pts_redeem_amt'],
                                          $this->functions->getClientId(),
                                          $this->data['merchant_id'],
                                          $order_id,
                                          $this->data['payment_opt']
                                        );
                                    }

                                     //+++waseem code
                                     unset($_SESSION['pts_redeem_amt']);
                                     unset($_SESSION['pts_redeem_points']);
                                     //---waseem code

                                
                            }
                           
                                                
                            $params_address = array();
                            
                            if($transaction_type=="delivery"){
                                $params_address=array(                        
                                  'street'=>isset($this->data['street'])?($this->data['street']):'',
                                  'city'=>isset($this->data['city'])?($this->data['city']):'',
                                  'state'=>isset($this->data['state'])?($this->data['state']):'',
                                  'zipcode'=>isset($this->data['zipcode'])?($this->data['zipcode']):'',
                                  'location_name'=>isset($this->data['location_name'])?($this->data['location_name']):'',                               
                                  'date_created'=>$this->functions->dateNow(),
                                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                                  'contact_phone'=>($this->data['contact_phone']),
                                  'country'=>isset($this->data['country_code'])?$this->data['country_code']:$this->functions->getOptionAdmin('admin_country_set'),
                                  'google_lat'=>$accurate_address_lat,
                                  'google_lng'=>$accurate_address_lng,
                                  'opt_contact_delivery'=>isset($this->data['opt_contact_delivery'])?(integer)$this->data['opt_contact_delivery']:0
                                );          
                            } elseif ( $transaction_type=="pickup"){                                
                                $params_address = array(                          
                                   'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:''                       
                                );
                            } elseif ( $transaction_type=="dinein"){                                
                                $params_address = array(                          
                                  'contact_phone'=>isset($this->data['contact_phone'])?$this->data['contact_phone']:'',
                                  'dinein_number_of_guest'=>isset($this->data['dinein_number_of_guest'])?$this->data['dinein_number_of_guest']:'',
                                  'dinein_special_instruction'=>isset($this->data['dinein_special_instruction'])?$this->data['dinein_special_instruction']:'',
                                  'dinein_table_number'=>isset($this->data['dinein_table_number'])?$this->data['dinein_table_number']:''
                                );
                            }
                                                        
                            $client_id = $this->functions->getClientId();
                            $customer_first_name='';$customer_last_name=''; $contact_email='';
                            if($client_info = $this->functions->getClientInfo($client_id)){
                                $customer_first_name = $client_info['first_name'];
                                $customer_last_name = $client_info['last_name'];
                                $contact_email = $client_info['email_address'];
                            }               
                                                                
                            $params_address['order_id'] = (integer)$order_id;
                            $params_address['client_id'] = (integer)$client_id;
                            /*$params_address['first_name'] = $customer_first_name;
                            $params_address['last_name'] = $customer_last_name;*/
                             $params_address['first_name'] = isset($this->data['first_name'])?$this->data['first_name']:$customer_first_name;
                            
                            $params_address['last_name'] = isset($this->data['last_name'])?$this->data['last_name']:$customer_last_name;
                            $params_address['contact_email'] = $contact_email;
                            $params_address['date_created'] = $this->functions->dateNow();
                            $params_address['ip_address'] = $_SERVER['REMOTE_ADDR'];
                            $params_address['formatted_address']='';
                                                        
                            $params_address['used_currency'] = isset($rates['used_currency'])?$rates['used_currency']:'';
                            $params_address['base_currency'] = isset($rates['base_currency'])?$rates['base_currency']:'';
                            $params_address['exchange_rate'] = isset($rates['exchange_rate'])?(float)$rates['exchange_rate']:0;
                            /*SERVICE FEE*/                         
                            if($service_resp){
                               $params_address['service_fee'] = (float)$service_resp['service_fee'] * (float) $exchange_rate;
                               $params_address['service_fee_applytax'] = (integer)$service_resp['service_fee_applytax'];
                            }
                                                        
                            

                            $this->functions->insertData('mt_order_delivery_address', $params_address);
                            
                            /** save to address book*/
                            if (!isset($this->data['saved_address'])){
                                $this->data['saved_address']='';
                            }
                            if ( $this->data['saved_address']==2){                              
                                if (!$this->functions->isSearchByLocation()){
                                    $sql_up = "
                      UPDATE mt_address_book
                      SET as_default = :as_default
                      ";

                   $query = $this->db->prepare($sql_up);

                  // Bind the parameter
                    $as_default = 1;  // Set the value of 'as_default' to 1
                    $query->bindParam(':as_default', $as_default, PDO::PARAM_INT);

                  // Execute the query
                    $query->execute();
                                    $params_i=array(
                                      'client_id'=>$this->functions->getClientId(),
                                      'street'=>($this->data['street']),
                                      'city'=>($this->data['city']),
                                      'state'=>($this->data['state']),
                                      'zipcode'=>($this->data['zipcode']),
                                      'location_name'=>($this->data['location_name']),
                                      'date_created'=>$this->functions->dateNow(),
                                      'ip_address'=>$_SERVER['REMOTE_ADDR'],                                      
                                      'country_code'=>$this->functions->getOptionAdmin('admin_country_set'),
                                      'as_default'=>2,
                                      'latitude'=>$accurate_address_lat,
                                      'longitude'=>$accurate_address_lng
                                    );
                                    
                                    $this->functions->insertData("mt_address_book",$params_i);
                                } else {
                                    /*SAVE ADDRESS BOOK BY LOCATION*/                                   
                                    $params_loation_address = array(
                                      'client_id'=>$this->functions->getClientId(),
                                      'street'=>isset($this->data['street'])?$this->data['street']:'',
                                      'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
                                      'country_id'=>isset($this->data['country_id'])? (integer) $this->data['country_id']:0,
                                      'state_id'=>isset($this->data['state_id'])? (integer) $this->data['state_id']:'',
                                      'city_id'=>isset($this->data['city_id'])? (integer)$this->data['city_id']:'',
                                      'area_id'=>isset($this->data['area_id'])? (integer) $this->data['area_id']:'',
                                      'as_default'=>1,
                                      'date_created'=>$this->functions->dateNow(),
                                      'ip_address'=>$_SERVER['REMOTE_ADDR'],
                                      'latitude'=>$accurate_address_lat,
                                      'longitude'=>$accurate_address_lng
                                    );                                  
                                     $this->functions->saveAddresBookByLocation($this->functions->getClientId(),$params_loation_address);                                
                                }                           
                            }                                                                              
                            
                            foreach ($raw['item'] as $val) {                                
                                $params_order_details=array(
                                  'order_id'=>$order_id,
                                  'client_id'=> $this->functions->getClientId(),
                                  'item_id'=>isset($val['item_id'])?$val['item_id']:'',
                                  'item_name'=>isset($val['item_name'])?$val['item_name']:'',
                                  'order_notes'=>isset($val['order_notes'])?$val['order_notes']:'',
                                  'normal_price'=>isset($val['normal_price'])?$val['normal_price']:'',
                                  'discounted_price'=>isset($val['discounted_price'])?$val['discounted_price']:'',
                                  'size'=>isset($val['size_words'])?$val['size_words']:'',
                                  'qty'=>isset($val['qty'])?$val['qty']:'',                               
                                  'addon'=>isset($val['sub_item'])?json_encode($val['sub_item']):'',
                                  'cooking_ref'=>isset($val['cooking_ref'])?$val['cooking_ref']:'',
                                  'ingredients'=>isset($val['ingredients'])?json_encode($val['ingredients']):'',
                                  'non_taxable'=>isset($val['non_taxable'])?$val['non_taxable']:1,                                
                                );              
                                
                                /*inventory*/       
                                $new_fields=array('size_id'=>"size_id");
                                if ( $this->functions->checkTableFields('order_details',$new_fields)){
                                    $params_order_details['size_id'] = isset($val['size_id'])? (integer) $val['size_id']:0;
                                    $params_order_details['cat_id'] = isset($val['category_id'])? (integer) $val['category_id']:0;
                                }
                                                                                                
                                $this->functions->insertData("mt_order_details",$params_order_details);
                                
                                /*inventory*/
                                if ($this->functions->checkIfTableExist('order_details_addon')){
                                    if(isset($val['sub_item'])){
                                        if(is_array($val['sub_item']) && count($val['sub_item'])>=1){
                                            foreach ($val['sub_item'] as $sub_item_data) {
                                                $this->functions->insertData("mt_order_details_addon",array(
                                                  'order_id'=>(integer)$order_id,
                                                  'subcat_id'=>(integer)$sub_item_data['subcat_id'],
                                                  'sub_item_id'=>(integer)$sub_item_data['sub_item_id'],
                                                  'addon_price'=>(float)$sub_item_data['addon_price'],
                                                  'addon_qty'=>(float)$sub_item_data['addon_qty'],
                                                ));
                                            }
                                        }                           
                                    }
                                }
                                
                            }
                            
                            
                            /*PICKUP TRANSACTION SAVE MOBILE NUMBER*/
                            if ( $this->data['delivery_type']=="pickup"){                                   
                                $this->functions->updateData("mt_client",array(
                                  'contact_phone'=>$this->data['contact_phone']
                                ),'client_id',
                                $this->functions->getClientId());
                            }
                            
                            $this->code=1;
                            
                            /*Driver app*/
                            /*if (FunctionsV3::hasModuleAddon("driver")){
                               Yii::app()->setImport(array(         
                                  'application.modules.driver.components.*',
                               ));
                               Driver::addToTask($order_id);
                            }*/
                                                        
                            switch ($this->data['payment_opt'])
                            {
                                case "cod":
                                case "ccr":                                     
                                    $this->msg=$this->functions->translation("default","Your order has been placed.");
                                    
                                    if (isset($_SESSION['guest_client_id'])){
                                        if (isset($this->data['is_guest_checkout'])){
                                           $stmt = "
                        UPDATE mt_client_cc
                        SET client_id = :client_id
                        WHERE client_id = :guest_client_id
                       ";

                    // Prepare the statement
                      $query = $this->db->prepare($stmt);

                    // Bind the parameters
                      $query->bindParam(':client_id', $this->functions->getClientId(), PDO::PARAM_INT);
                      $query->bindParam(':guest_client_id', $_SESSION['guest_client_id'], PDO::PARAM_INT);

                    // Execute the query
                      $query->execute();

                                        }
                                    }
                                    
                                   
                                        $this->functions->updatePoints_module($order_id,$params['status']);
                                    
                                    
                                    /*INVENTORY ADDON*/
                                    
                                   
                                    if ($this->functions->inventoryEnabled($this->data['merchant_id'])){
                                      
                                        try {  

                                            $this->InventoryWrapper->insertInventorySale($order_id,strtolower($params['status']));  
                                        } catch (Exception $e) {                                            
                                          // echo $e->getMessage();                                       
                                        }                                       
                                    }

                                    $merchant_id=$this->data['merchant_id'];

                                    $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
                                    if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}


                                      $params_update_order=array( 
                                    
                                     
                                      'order_number'=>$order_number, 
                                    
                                      );    
                                        
                                  
                                    $this->functions->updateData('mt_order', $params_update_order,'order_id',$order_id); 

                                    
                                    break;
                                case "pyr":   

                                $merchant_id=$this->data['merchant_id'];

                                    $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
                                    if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}


                                      $params_update_order=array( 
                                    
                                     
                                      'order_number'=>$order_number, 
                                    
                                      );    
                                        
                                  
                                    $this->functions->updateData('mt_order', $params_update_order,'order_id',$order_id); 

                                                                
                                    /** Send email if payment type is Offline bank deposit*/
                                    /*FunctionsV3::sendBankInstructionPurchase(
                                      $mtid,
                                      $order_id,
                                      isset($params['total_w_tax'])?$params['total_w_tax']:0,
                                      Yii::app()->functions->getClientId()
                                    );
                                    
                                    $this->msg=Yii::t("default","Your order has been placed.");
                                    
                                    if (method_exists("FunctionsV3","updatePoints")){
                                        FunctionsV3::updatePoints($order_id,$params['status']);
                                    }
                                    
                                    
                                    if (FunctionsV3::inventoryEnabled($this->data['merchant_id'])){
                                        try {                                         
                                           InventoryWrapper::insertInventorySale($order_id,$params['status']);  
                                        } catch (Exception $e) {                                            
                                         
                                        }                                       
                                    }*/
                                    
                                    break;
                                default:    
                                    $this->msg=$this->functions->translation("default","Please wait while we redirect...");
                                    break;
                            }
                                                        
                            $payment_opt = isset($this->data['payment_opt'])?$this->data['payment_opt']:'';
                            if($payment_opt=="stp"){
                                $payment_opt='stripe';
                            }
                            $payment_action=$payment_opt."init";
                                                        
                            /*$payment_link = Yii::app()->createUrl("/store/$payment_action",array(
                             'order_id_token'=>$order_id_token,
                             'id'=>$order_id
                            ));*/ 

                            $payment_link =Config::$baseUrl."/".$payment_action."?order_id_token=".$order_id_token."&id=".$order_id; 

                            if (isset($this->data['is_guest_checkout'])){
                            unset($_SESSION['kr_client']);
                            }
                                                        
                            $this->details=array(
                              'order_id'=>$order_id,
                              'payment_type'=>$this->data['payment_opt'],
                              'payment_link'=>$payment_link
                            );
                                                        
                        } else $this->msg=$this->functions->translation("default","ERROR: Cannot insert records.");
                    } else $this->msg=$this->functions->translation("default","ERROR: Something went wrong");              
                } else $this->msg=$displayOrderHTML['msg'];
            } else $this->msg=$this->functions->translation("default","Sorry but your order is empty");        
        }




            public function updateClientProfile()
        {
                        
            $client_id=$this->functions->getClientId();            
            if (!is_numeric($client_id)){
                $this->msg=$this->functions->translation("default","ERROR: Your session has expired.");
                return ;
            }       
                    
            
            if ($this->functions->CheckCustomerMobile($this->data['contact_phone'],$client_id)){
                $this->msg=$this->functions->translation("default","Sorry but your mobile number is already exist in our records");
                return;
            }                   
            
           
            
            $params=array(
              'first_name'=>isset($this->data['first_name'])?($this->data['first_name']):'',
              'last_name'=>isset($this->data['last_name'])?($this->data['last_name']):'',
              'street'=>isset($this->data['street'])?($this->data['street']):'',
              'city'=>isset($this->data['city'])?($this->data['city']):'',
              'state'=>isset($this->data['state'])?($this->data['state']):'',
              'zipcode'=>isset($this->data['zipcode'])?($this->data['zipcode']):'',
              'contact_phone'=>isset($this->data['contact_phone'])?($this->data['contact_phone']):'',
              'date_modified'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
            
            
            /** update 2.3*/
            if (isset($this->data['custom_field1'])){
                $params['custom_field1']=!empty($this->data['custom_field1'])?($this->data['custom_field1']):'';
            }
            if (isset($this->data['custom_field2'])){
                $params['custom_field2']=!empty($this->data['custom_field2'])?($this->data['custom_field2']):'';
            }
                                        
            if (isset($this->data['password'])){
                if (!empty($this->data['password'])){
                    $params['password']=md5( ($this->data['password']) );
                }           
            }                   
            
            if (isset($this->data['password'])){
                if (!empty($this->data['password'])){
                    if (  $this->data['password']!=$this->data['cpassword'] ){
                        $this->msg=$this->functions->translation("default","Confirm password does not match.");
                        return ;
                    }
                }
            }       
                        
            if ($this->functions->updateData("mt_client",$params,'client_id',$client_id)){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Profile Updated.");
            } else $this->msg=$this->functions->translation("default","ERROR: cannot update profile.");
        }

        public function addAddressBookLocation()
    {
        $client_id=$this->functions->getClientId();
        
        if($client_id<=0){
            $this->msg =  $this->functions->translation("default","Session has expired");
            return ;
        }   
        
        $params = array(
         'client_id'=>$client_id,
         'street'=>$this->data['street'],
         'state_id'=>$this->data['state_id'],
         'city_id'=>$this->data['city_id'],
         'area_id'=>$this->data['area_id'],
         'location_name'=>isset($this->data['location_name'])?$this->data['location_name']:'',
         'country_id'=>$this->data['country_id'],
         'as_default'=>isset($this->data['as_default'])?$this->data['as_default']:0,
         'date_created'=>$this->functions->dateNow(),
         'ip_address'=>$_SERVER['REMOTE_ADDR']
        );      
       
        if(isset($this->data['id'])){
            unset($params['date_created']);
            unset($params['client_id']);
            $params['date_modified']=$this->functions->dateNow();            
            if ($this->functions->updateData("mt_address_book_location",$params,'id',$this->data['id'])){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");       
                
                
                if ($params['as_default'] == 1) {
    // Prepare the SQL statement
    $stmt = $this->db->prepare("
        UPDATE mt_address_book_location
        SET as_default = ''
        WHERE client_id = :client_id
        AND id <> :id
    ");

    // Bind the parameters to the statement
    $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $stmt->bindParam(':id', $this->data['id'], PDO::PARAM_INT);

    // Execute the query
    $stmt->execute();
}         
                
            } else $this->msg=$this->functions->translation("default","ERROR: Something went wrong"); 
        } else {   
             $last_insert_id = $this->functions->insertData('mt_address_book_location', $params);

             if ($last_insert_id!== false){
                $id=$last_insert_id;
                

                $this->details=Config::$baseUrl."/profile/tab/2/do/add/id/".$id;




                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");  
                
                if ($params['as_default'] == 1) {
    // Prepare the SQL statement
    $stmt = $this->db->prepare("
        UPDATE mt_address_book_location
        SET as_default = ''
        WHERE client_id = :client_id
        AND id <> :id
    ");

    // Bind the parameters to the prepared statement
    $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);

    // Execute the query
    $stmt->execute();
}
        
                 
            } else $this->msg=$this->functions->translation("default","ERROR: Something went wrong");     
        }   
        
    }


   public function addressBook()
{
    // Ensure the client is logged in
    $this->functions->isClientLogin();

    // Prepare the SQL query
    $sql = "
        SELECT id, location_name, country_code, as_default,
               CONCAT(street, ' ', city, ' ', state, ' ', zipcode) AS address
        FROM mt_address_book
        WHERE client_id = :client_id
        ORDER BY id DESC
    ";

    // Prepare the statement using PDO
    $stmt = $this->db->prepare($sql);

    // Bind the client_id parameter
    $stmt->bindParam(':client_id', $this->functions->getClientId(), PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();

    // Fetch all results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // If there are results, process them
    if ($res) {
        $feed_data = array();
        foreach ($res as $val) {
            // Create the slug URL for the action link
            $slug = Config::$baseUrl . "/profile?tab=2&do=add&id=" . $val['id'];

            // Action buttons
            $action = "
                <div class=\"options\">
                    <a href=\"$slug\"><i class=\"ion-ios-compose-outline\"></i></a>
                    <a href=\"javascript:;\" class=\"delete_addressbook\" data-id=\"$val[id]\"><i class=\"ion-ios-trash\"></i></a>
                </div>
            ";

            // Add data to the feed
            $feed_data['aaData'][] = array(
                $val['address'] . $action,
                $val['location_name'],
                $val['as_default'] == 2 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-times"></i>'
            );
        }

        // Output the data
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}




      public function addAddressBook()
     {      
        
        $params=array(
          'client_id'=>$this->functions->getClientId(),
          'street'=> ($this->data['street']) ,
          'city'=>($this->data['city']),
          'state'=>($this->data['state']),
          'zipcode'=>($this->data['zipcode']),
          'location_name'=>isset($this->data['location_name'])?($this->data['location_name']):'',
          'as_default'=>isset($this->data['as_default'])?$this->data['as_default']:1,
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'country_code'=>isset($this->data['country_code'])?$this->data['country_code']:'',
          'latitude'=>isset($this->data['latitude'])?$this->data['latitude']:'',
          'longitude'=>isset($this->data['longitude'])?$this->data['longitude']:'',
        );      
        
        if (!isset($this->data['as_default'])){
            $this->data['as_default']='';
        }
                
        if ($this->data['as_default'] == 2) {
    // Prepare the SQL update statement
    $sql_up = "
        UPDATE mt_address_book
        SET as_default = '1'
        WHERE client_id = :client_id
    ";

    // Prepare the statement using PDO
    $stmt = $this->db->prepare($sql_up);

    // Bind the client_id parameter securely
    $stmt->bindParam(':client_id', $this->functions->getClientId(), PDO::PARAM_INT);

    // Execute the statement
    $stmt->execute();
}  
        
        
        
        if ( isset($this->data['id'])){
            unset($params['date_created']);
            $params['date_modified']=$this->functions->dateNow();
            if ( $this->functions->updateData("mt_address_book",$params,'id',$this->data['id'])){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");       
            } else $this->msg=$this->functions->translation("default","ERROR: Something went wrong"); 
        } else {

            $last_insert_id = $this->functions->insertData('mt_address_book', $params);

            if ($last_insert_id!== false){
                $id=$last_insert_id;
               

                $this->details=Config::$baseUrl."/profile/tab/2/do/add/id/".$id;
                

                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");       
            } else $this->msg=$this->functions->translation("default","ERROR: Something went wrong");     
        }
     }


   public function addressBookLocation()
{       
    $client_id = $this->functions->getClientId();
    $feed_data = array();

    if ($client_id > 0) {
        // Prepare the SQL statement with placeholders for binding
        $stmt = $this->db->prepare("
            SELECT 
                a.*, 
                b.name as state_name, 
                c.name as city_name, 
                c.postal_code, 
                d.name as area_name
            FROM mt_address_book_location a
            LEFT JOIN mt_location_states b ON a.state_id = b.state_id
            LEFT JOIN mt_location_cities c ON a.city_id = c.city_id
            LEFT JOIN mt_location_area d ON a.area_id = d.area_id
            WHERE client_id = :client_id
        ");

        // Bind the client_id parameter
        $stmt->bindParam(':client_id', $client_id, PDO::PARAM_INT);

        // Execute the query
        $stmt->execute();

        // Check if there are any results
        if ($stmt->rowCount() > 0) {
            $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
            foreach ($res as $val) {
                $slug = Config::$baseUrl . "/profile/tab/2/do/add/id/" . $val['id'];

                // Construct the address string
                $address = $val['street'] . " " . $val['state_name'] . " " . $val['city_name'] . " " . $val['area_name'];
                $address .= " " . $val['postal_code'];

                // Construct the action string
                $action = "<div class=\"options\">
                    <a href=\"$slug\" ><i class=\"ion-ios-compose-outline\"></i></a>
                    <a href=\"javascript:;\" class=\"del_addresslocation\" data-id=\"$val[id]\" ><i class=\"ion-ios-trash\"></i></a>
                </div>";

                // Add data to the feed
                $feed_data['aaData'][] = array(
                    $address . $action,
                    $val['location_name'],
                    $val['as_default'] == 1 ? '<i class="fa fa-check"></i>' : '<i class="fa fa-times"></i>'
                );
            }
            // Output the table data
            $this->otableOutput($feed_data);
        } else {
            // No data found
            $this->otableNodata();
        }
    } else {
        // No client_id
        $this->otableNodata();
    }
}







         public function addReviews()
        {                                   
            
            if ( $this->functions->isClientLogin()){
                $client_id=$this->functions->getClientId();                
                $params=array(
                  'merchant_id'=>$this->data['merchant-id'],
                  'client_id'=>$client_id,
                  'review'=>$this->data['review_content'],
                  'date_created'=>$this->functions->dateNow(),
                  'rating'=>$this->data['initial_review_rating']
                );              
                
                /** check if user has bought from the merchant*/                
                if ( $this->functions->getOptionAdmin('website_reviews_actual_purchase')=="yes"){
                    
                    if (!$this->functions->checkIfUserCanRateMerchant($client_id,$this->data['merchant-id'])){
                        $this->msg=$this->functions->translation("default","Reviews are only accepted from actual purchases!");
                        return ;
                    }
                                                       
                    if (!$this->functions->canReviewBasedOnOrder($client_id,$this->data['merchant-id'])){
                       $this->msg=$this->functions->translation("default","Sorry but you can make one review per order");
                       return ;
                    }              
                                        
                    if ( $ref_orderid=$this->functions->reviewByLastOrderRef($client_id,$this->data['merchant-id'])){
                        $params['order_id']=$ref_orderid;
                    }
                }
                
                //dump($params);     
                $last_insert_id = $this->functions->insertData('mt_review', $params);
                if ($last_insert_id!== false){             
                    $review_id  = $this->details=$last_insert_id;
                    $this->code=1;
                    $this->msg=$this->functions->translation("default","Your review has been published.");
                    
                    if (isset($this->data['initial_review_rating'])){
                        $this->functions->updateRatings($this->data['merchant-id'],
                        $this->data['initial_review_rating'],$client_id
                        );
                    }
                    
                    /*POINTS PROGRAM*/                  
                    /*if (FunctionsV3::hasModuleAddon("pointsprogram")){
                       PointsProgram::reviewsReward($client_id , $review_id  , $this->data['merchant-id']);
                    }*/
                                        
                } else $this->msg=$this->functions->translation("default","ERROR: cannot insert records.");
            } else $this->msg=$this->functions->translation("default","Sorry but you need to login to write a review.");
        }






          public function loadReviews()
        {        


            $date_now=date('Y-m-d g:i:s a');                                                
            $client_id=$this->functions->getClientId();
            
            $website_title = $this->functions->getOptionAdmin('website_title');
            
            if ( $res=$this->functions->getReviewsList($this->data['merchant_id']) ){              
                ob_start();
                foreach ($res as $val) {                

                    $can_edit=true;             
                    
                    $date_diff=$this->functions->dateDifference(
                    date('Y-m-d g:i:s a',strtotime($val['date_created']))
                    ,$date_now);
                    if(is_array($date_diff) && count($date_diff)>=1){
                        if ($date_diff['days']>=5){
                           $can_edit=false;
                        }
                    }
                    
                    $pretyy_date=$this->PrettyDateTime->parse(new DateTime($val['date_created']));
                    //$pretyy_date=$val['date_created'];
                    $pretyy_date=$this->functions->translateDate($pretyy_date);
                    
                    if(isset($val['as_anonymous'])){
                        if($val['as_anonymous']==1){
                            

                            /* $val['client_name'] = $this->functions->translation("default","By [site_name] Customer"." ".$website_title);*/

                             $val['client_name'] = "By ".$website_title." Customer";

                        }                   
                    }           
                ?>
                <div  id="#review-<?php echo $val['id']?>" class="row row-review">
                   <div class="col-md-2 col-xs-2 border center into-row">
                   
                     <!--<i class="ion-android-contact"></i>-->
                     <img src="<?php echo $this->functions->getAvatar($val['client_id']);?>" class="img-circle">
                     
                     <p class="small"><?php echo $val['client_name']?></p>
                   </div> <!--col-->
                   <div class="col-md-7 col-xs-7 border into-row">
                   
                     <div class="col-md-12 ">                        
                         <div class="col-md-5 ">
                           <div class="rating-stars" data-score="<?php echo $val['rating']?>"></div>
                         </div>
                         <div class="col-md-4 small text-left">
                         <?php echo $pretyy_date;?>
                         </div>
                     </div> 
                     <div class="col-md-12 top10">
                        <p class="read-more"><?php echo nl2br($val['review'])?></p>     
                                                
                        <?php if ( $replies=$this->functions->reviewReplyList($val['id'],'publish')):?>                      
                        <?php foreach ($replies as $val_reply):?>
                        <div class="reply-wrap">
                           <p class="reply-from"><?php echo stripslashes($val_reply['reply_from'])." ".$this->functions->translation("default","reply")?>:</p>
                           <p class="reply-content read-more"><?php echo nl2br(trim($val_reply['review']))?></p>
                           </div>
                        <?php endforeach;?>                    
                        <?php endif;?>
                        
                     </div>
                     
                   </div> <!--col-->
                   
                   <div class="col-md-3 center col-xs-3 border into-row">
                   <?php if ( $val['client_id']==$client_id ):?>
                   <?php if ($can_edit==true):?>
                    <a href="javascript:;" data-id="<?php echo $val['id']?>" class="edit-review orange-button inline">
                    <?php echo $this->functions->translation("default","Edit")?>
                    </a>
                    <a href="javascript:;" data-id="<?php echo $val['id']?>" class="delete-review green-button inline">
                    <?php echo $this->functions->translation("default","Delete")?>
                    </a>
                    <?php endif;?>
                   <?php endif;?>
                   </div> <!--col-->
                   
                </div><!-- row-->
                <?php
                }
                $html = ob_get_contents();
                ob_end_clean();   
                
                $this->code=1;
                $this->msg="OK";                
                 $this->details=$html;
            } else $this->msg=$this->functions->translation("default","No reviews yet.");  
        }


         public function editReview()
        {
            

            if ( $this->functions->isClientLogin()){

                require_once __DIR__ . '/../../models/edit-review.php';   
                die();
            }else{
                die();
            }

           
            
        }   

         public function updateReview()
        {
           
            if ( $this->functions->isClientLogin()){
                      
            if (!isset($this->data['review_content'])){  
                $this->msg=$this->functions->translation("default","Review content is required.");
                return ;
            }
            if (empty($this->data['review_content'])){   
                $this->msg=$this->functions->translation("default","Review content is required.");
                return ;
            }
            if (!isset($this->data['id'])){  
                $this->msg=$this->functions->translation("default","Review ID is missig");
                return ;
            }
            if ( $this->data['web_session_id']!=session_id()){   
                $this->msg=$this->functions->translation("default","Sorry but you cannot post directly to this action");
                return ;
            }                       
            $params=array('review'=>$this->data['review_content'],
             'date_created'=>$this->functions->dateNow(),
             'ip_address'=>$_SERVER['REMOTE_ADDR']
            );          
            if ( $this->functions->updateData("mt_review",$params,'id',$this->data['id'])){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Your review has been updated.");
            } else $this->msg=$this->functions->translation("default","ERROR: cannot update reviews.");  
            }     
        }  


        public function deleteReview()
{
    if ($this->functions->isClientLogin()) {
        try {
            // Prepare the DELETE statement
            $stmt = $this->db->prepare("DELETE FROM mt_review WHERE id = :id");

            // Bind the id parameter
            $stmt->bindParam(':id', $this->data['id'], PDO::PARAM_INT);

            // Execute the statement
            if ($stmt->execute()) {
                $this->code = 1;
                $this->msg = $this->functions->translation("default", "Successful");

                // Uncomment and handle Points Program if needed
                /*if (FunctionsV3::hasModuleAddon("pointsprogram")){
                    PointsProgram::deleteReviews($this->data['id']);
                }*/

            } else {
                $this->msg = $this->functions->translation("default", "ERROR: Failed deleting reviews.");
            }
        } catch (PDOException $e) {
            // Handle any potential PDO exceptions
            $this->msg = $this->functions->translation("default", "ERROR: " . $e->getMessage());
        }
    }
}





        public function verifyEmailCode()
    {
        $client_id=isset($this->data['client_id'])?$this->data['client_id']:'';
        if( $res=$this->functions->getClientInfo( $client_id )){   
            
            if ($res['email_verification_code']==trim($this->data['code'])){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");
                
                $params=array( 
                  'status'=>"active",
                  'last_login'=>$this->functions->dateNow()
                );
                $this->functions->updateData("mt_client",$params,'client_id',$res['client_id']);
                
                $verification=$this->functions->getOptionAdmin("website_enabled_mobile_verification"); 
                $email_verification=$this->functions->getOptionAdmin('theme_enabled_email_verification');                             
                if ($verification=="yes" || $email_verification==2){
                    /*sent welcome email*/                  
                    $this->functions->sendCustomerWelcomeEmail($res);
                }
                
               // $this->functions->clientAutoLogin($res['email_address'],$res['password'],$res['password']);
                $this->functions->clientAutoLogin_mainwebsite($res['email_address'],$res['password'],$res['password']);
                
            } else $this->msg=$this->functions->translation("default","Verification code is invalid");
        } else $this->msg=$this->functions->translation("default","Sorry but we cannot find your information.");
    }

        public function clientLogin()
        {   
                                    
          
            /** check if admin has enabled the google captcha*/             
            if ( $this->data['action']=="clientLogin" || $this->data['action']=="clientLoginModal"){

         
                if (!isset($this->data['captcha_check'])){
                if ( $this->functions->getOptionAdmin('captcha_customer_login')==2){
                    try {                   
                        $recaptcha_token = isset($this->data['recaptcha_v3'])?$this->data['recaptcha_v3']:'';                   
                        $this->functions->validateToken($recaptcha_token);
                    } catch (Exception $e) {
                         $this->msg = $e->getMessage();
                         return ;
                    }
                }

              }



            }
                        
            /*check if email address is blocked by admin*/          
            if ( $this->functions->emailBlockedCheck($this->data['username'])){
                $this->msg=$this->functions->translation("default","Sorry but your email address is blocked by website admin");
                return ;
            }           
                        
            if (!isset($this->data['password_md5'])){
                $this->data['password_md5']='';
            }  


            
            $http_referer = isset($this->data['http_referer'])?$this->data['http_referer']:'';          
            if (preg_match("/receipt/i", $http_referer)) {
                $http_referer=$this->functions->websiteUrl()."/";
            }       
            if (preg_match("/orderHistory/i", $http_referer)) {
                $http_referer=$this->functions->websiteUrl()."/";
            }       
            if (preg_match("/Profile/i", $http_referer)) {
                $http_referer=$this->functions->websiteUrl()."/";
            }       
            if (preg_match("/Cards/i", $http_referer)) {
                $http_referer=$this->functions->websiteUrl()."/";
            }       
            if (preg_match("/PaymentOption/i", $http_referer)) {
                $http_referer=$this->functions->websiteUrl()."/";
            }       
            if (preg_match("/verification/i", $http_referer)) {
                $http_referer=$this->functions->websiteUrl()."/";
            }   

            if(isset($this->data['gstchk'])){
                $http_referer=$this->functions->websiteUrl()."/paymentoption";
            }        
            
           if(isset($http_referer) && !empty($http_referer)){}else{ $http_referer=$this->functions->websiteUrl()."/";}
            
            $this->data['username'] = ($this->data['username']);
            $this->data['password'] = ($this->data['password']);

           
                
            if ( $this->functions->clientAutoLogin_with_merchant($this->data['username'],
                $this->data['password'],$this->data['password_md5'],0)){
               
                $this->code=1;
                $this->msg=$this->functions->translation("default","Login Okay");          
                
                if(!empty($http_referer)){
                    $this->details = array(
                     'redirect'=>$http_referer
                    );
                }               
                    
            } else {
                /*check if user has pending application like mobile verification and email*/
                
                $res=$this->functions->login_chk_merchant_id($this->data['username'],$this->data['password'],0);
                
                if ( $res=$this->functions->login_chk_merchant_id($this->data['username'],$this->data['password'],0)){
                    if (strlen($res['mobile_verification_code'])>=2 && $res['status']=='pending'){
                        $this->msg=$this->functions->translation("default","Found existing registration");
                        $this->code=3;
                        $this->details=$res['client_id'];
                    } elseif (strlen($res['email_verification_code'])>=2 && $res['status']=='pending' ){    
                        $this->code=4;
                        $this->details=$res['client_id'];
                        $this->msg=$this->functions->translation("default","we have sent you email with verification");
                    } else {
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","Login Okay");
                        
                       
                        unset($res[0]['password']);
                        $client_id=$res['client_id'];
                        $update=array('last_login'=>$this->functions->dateNow(),'ip_address'=>$_SERVER['REMOTE_ADDR']);
                        $this->functions->updateData("mt_client",$update,'client_id',$client_id);
                        $_SESSION['kr_client']=$res;
                        
                          if(isset($http_referer) && !empty($http_referer)){}else{ $http_referer=$this->functions->websiteUrl()."/";}
                        if(!empty($http_referer)){
                            $this->details = array(
                             'redirect'=>$http_referer
                            );
                        }               
                                                    
                    }               
                } else $this->msg=$this->functions->translation("default","Login Failed. Either username or password is incorrect"); 
            }
        }





        public function contacUsSubmit()
        {           
                        
            unset($this->data['action']);
            foreach ($this->data as $key=>$val) {           
                $required[$key]=ucwords($key). " ". $this->functions->translation("default","is required");
            }                   
                        
            
            $this->functions->required($required,$this->data);
            if ($this->functions->validate()){            
                $lang='en';
                $to=$this->functions->getOptionAdmin('contact_email_receiver');
                $from='';
                
                $contact_us=$this->functions->getOptionAdmin('contact_us_email');
                if ( $contact_us==""){                  
                    $this->msg=$this->functions->translation("default","Contact form template is not enabled in template settings");
                    return ;
                }           
                
                $subject=$this->functions->getOptionAdmin('contact_us_tpl_subject_'.$lang);
                $tpl=$this->functions->getOptionAdmin('contact_us_tpl_content_'.$lang);
                if(!empty($tpl)){
                                                            
                    $tpl=$this->functions->smarty('name',
                    isset($this->data['name'])?$this->data['name']:'',$tpl);
                    
                    $tpl=$this->functions->smarty('email',
                    isset($this->data['email'])?$this->data['email']:'',$tpl);
                    
                    $tpl=$this->functions->smarty('country',
                    isset($this->data['country'])?$this->data['country']:'',$tpl);
                    
                    $tpl=$this->functions->smarty('message',
                    isset($this->data['message'])?$this->data['message']:'',$tpl);
                    
                    $tpl=$this->functions->smarty('phone',
                    isset($this->data['phone'])?$this->data['phone']:'',$tpl);
                    
                    $tpl=$this->functions->smarty('sitename',$this->functions->getOptionAdmin('website_title'),$tpl);
                    $tpl=$this->functions->smarty('siteurl',$this->functions->websiteUrl(),$tpl);
                }           
                    
                if (empty($to)){
                    $this->msg=$this->functions->translation("default","ERROR: no email to send.");
                    return ;
                }           
                if(empty($subject)){
                    $this->msg=$this->functions->translation("default","Subject is empty");
                    return ;
                }           
                if(empty($tpl)){
                    $this->msg=$this->functions->translation("default","Template is empty");
                    return ;
                }           
                                
                if ( $this->functions->sendEmail($to,$from,$subject,$tpl) ){
                    $this->code=1;          
                    $this->msg=$this->functions->translation("default","Your message was sent successfully. Thanks.");
                } else $this->msg=$this->functions->translation("default","ERROR: Cannot sent email.");                
            } else $this->msg=$this->functions->getErrorAsHTML();
        }



public function socialSettings()
        {
            $merchant_id=$this->functions->getMerchantID();
            
            $this->functions->updateOption("facebook_page",
            isset($this->data['facebook_page'])?$this->data['facebook_page']:''
            ,$merchant_id);
            
            $this->functions->updateOption("twitter_page",
            isset($this->data['twitter_page'])?$this->data['twitter_page']:''
            ,$merchant_id);
            
            $this->functions->updateOption("google_page",
            isset($this->data['google_page'])?$this->data['google_page']:''
            ,$merchant_id);
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved.");
        } 



         public function addAdminUser()
        {       
                                   
           $params=array(
              'first_name'=> trim($this->data['first_name']),
              'last_name'=> trim($this->data['last_name']),
              'username'=> trim($this->data['username']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'email_address'=>isset($this->data['email_address'])?trim($this->data['email_address']):'',
              'user_access'=>isset($this->data['user_access'])?json_encode($this->data['user_access']):''
            );
            
                 
                        
            if (isset($this->data['password'])){
                if (!empty($this->data['password'])){
                    if ($this->data['password']!=$this->data['cpassword']){
                        $this->msg=$this->functions->translation("default","Confirm password does not match.");
                        return ;
                    } else {
                        $params['password']=md5($this->data['password']);
                    }                       
                }           
            }
                        
            if (empty($this->data['id'])){  

                $last_insert_id = $this->functions->insertData('mt_admin_user', $params);
                if ($last_insert_id!== false){  
                       $this->details=$last_insert_id;
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","Successful");                      
                    }
                } else {                
                    unset($params['date_created']);
                    $params['date_modified']=$this->functions->dateNow();                
                    
                    $res = $this->functions->updateData("mt_admin_user", $params, 'admin_id', $this->data['id']);
                    if ($res){
                        $this->code=1;
                        $this->msg=$this->functions->translation("default",'User updated.');  
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            }   
        }




    public function singlemerchantPage()
{
    if (!$this->functions->isMerchantLogin()) {
        $this->msg = "ERROR: Your session has expired.";
        return false;
    }

    $merchant_id = (integer)$this->functions->getMerchantID();

    $cols = array(
        'page_id', 'title',
        'content', 'sequence',
        'date_created', 'page_id'
    );

    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    $t = $this->functions->ajaxDataTables($cols);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Prepare the SQL statement
    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.*
              FROM mt_singleapp_pages a
              WHERE merchant_id = :merchant_id
              $sOrder
              $sLimit";

    // Prepare and execute the statement
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $iTotalRecords = 0;
        $totalStmt = $this->db->query("SELECT FOUND_ROWS()");
        if ($res2 = $totalStmt->fetch(PDO::FETCH_ASSOC)) {
            $iTotalRecords = $res2['FOUND_ROWS()'];
        }

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $date_created = $this->functions->prettyDate($val['date_created'], true);
            $date_created = $this->functions->translateDate($date_created);

            $page_id = $val['page_id'];

            $link = Config::$baseUrl . "/merchant/single_merchant_settingsadd/page_id/" . $page_id;

            $action = '<a href="' . $link . '" class="edit_page btn btn-info" data-page_id="' . $page_id . '"><i class="fas fa-edit" aria-hidden="true"></i></a>';
            $action .= '<a href="javascript:;" class="delete_page btn btn-danger row_del" rev="' . $page_id . '"><i class="fas fa-trash" aria-hidden="true"></i></a>';

            $status = $val['status'];

            $val['content'] = stripslashes(strip_tags($val['content']));
            $use_html = '';
            $content = "<p class=\"concat-text\">" . $val['content'] . "..." . "</p>";
            if ($val['use_html'] == 2) {
                $use_html = '<i class="fa fa-check"></i>';
            }

            $feed_data['aaData'][] = array(
                $val['page_id'],
                stripslashes($val['title']),
                $content,
                $val['icon'],
                $use_html,
                $val['sequence'],
                $status . '<br/>' . $date_created,
                $action
            );
        }
        $this->otableOutput($feed_data);
    }
    $this->otableNodata();
}


public function MerchantUserList()
{
    $merchant_id = $this->functions->getMerchantID();
    $slug = $this->data['slug'];

    $stmt = "
    SELECT * FROM mt_merchant_user
    WHERE merchant_id = :merchant_id
    ORDER BY merchant_user_id DESC
    ";

    // Prepare the query using PDO
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();

    // Fetch the result as an associative array
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        $feed_data = [];

        foreach ($rows as $val) {
            // Prepare checkbox input
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"{$val['merchant_user_id']}\" class=\"chk_child\" >";

            // Format last login
            $last_login = $this->functions->FormatDateTime($val['last_login']);

            // Determine status
            $status = ($val['status'] == "active") ?
                "<p class=\"uk-badge uk-badge-success\">{$val['status']}</p>" :
                "<p class=\"uk-badge uk-badge-danger\">{$val['status']}</p>";

            // Prepare action links

            if($val['pos_user']==1){
              $slug="user_pos/Do/Add";
              $userType="POS";
            }else{
              $slug="user/Do/Add";
               $userType="Normal";
            }

            $action = "<div class=\"options\">
                        <a href=\"{$slug}/id/{$val['merchant_user_id']}\">" . $this->functions->translation("default", "Edit") . "</a>
                        <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['merchant_user_id']}\">" . $this->functions->translation("default", "Delete") . "</a>
                       </div>";

            // Translate date
            $last_login = $this->functions->translateDate($last_login);

            // Add row to the data
            $feed_data['aaData'][] = [
                $chk,
                $val['first_name'] . " " . $val['last_name'] . $action,
                $userType,
                $status,
                $last_login,
                $val['ip_address']
            ];
        }

        // Output table data
        $this->otableOutput($feed_data);
    } else {
        // Output no data
        $this->otableNodata();
    }
}




    public function addMerchantUser()
        {
            
            
            
            $merchant_id=$this->functions->getMerchantID();            
            $params=array(
              'merchant_id'=>$merchant_id,
              'first_name'=> ($this->data['first_name']) ,
              'last_name'=> ($this->data['last_name']),
              'username'=> ($this->data['username']),
              //'password'=>md5($this->data['password']),
              'pos_cashier_access' => isset($this->data['pos_cashier_access']) ? $this->data['pos_cashier_access'] : 0,

              'user_access'=>isset($this->data['access'])?json_encode($this->data['access']):'',
              'date_created'=>$this->functions->dateNow(),
              'status'=>$this->data['status'],
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'contact_email'=>$this->data['contact_email']
            );  
            
             $this->functions->updateOption("pos_cashier_access",
            isset($this->data['pos_cashier_access'])?$this->data['pos_cashier_access']:'0'
            ,$merchant_id);
                        
            if (isset($this->data['password'])){
                if ( !empty($this->data['password'])){
                    $params['password']=md5($this->data['password']);
                }
            }       
            
            /*dump($params);
            die();
            */
           
            if (empty($this->data['id'])){      
                if (empty($params['password'])){
                    $this->msg="Password is required.";
                    return ;
                }          
                                
                if ( $err_msg=$this->functions->validateMerchantUserAccount($this->data['username'],
                     $this->data['contact_email'])){
                     $this->msg=$err_msg;
                     return ;
                }                           
                
                if ( !$this->functions->validateMerchantUsername($this->data['username'])){    
                  $last_insert_id = $this->functions->insertData('mt_merchant_user', $params);
                    if ($last_insert_id!== false){         
                        $this->details=$last_insert_id;
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","Successful");                      
                    }
                } else $this->msg="Sorry your username is already exist. Please choose another username.";
            } else {                
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();                                
                
                if (!empty($params['username'])){
                    if ( $this->functions->validateMerchantUser($params['username'],$merchant_id) ){
                        $this->msg=$this->functions->translation("default","Merchant Username is already been taken");
                        return ;
                    }
                }           
                                
                if ( $err_msg=$this->functions->validateMerchantUserAccount($this->data['username'],
                     $this->data['contact_email'],$this->data['id'])){
                     $this->msg=$err_msg;
                     return ;
                }
                                                            
               // $res = $this->updateData('{{merchant_user}}' , $params ,'merchant_user_id',$this->data['id']);
                $res = $this->functions->updateData("mt_merchant_user", $params, 'merchant_user_id', $this->data['id']);

                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Merchant User updated.');  
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            }               
        }


         public function addMerchantUser_pos()
        {
            
            
            
            $merchant_id=$this->functions->getMerchantID();            
            $params=array(
              'merchant_id'=>$merchant_id,
              'first_name'=> ($this->data['first_name']) ,
              'last_name'=> ($this->data['last_name']),
              'username'=> ($this->data['username']),
              //'password'=>md5($this->data['password']),
              'pos_cashier_access' => 
        (isset($this->data['pos_cashier_access']) && $this->data['pos_cashier_access'] == 'cashier') ? 1 : 0,
              'user_access'=>isset($this->data['access'])?json_encode($this->data['access']):'',
              'date_created'=>$this->functions->dateNow(),
              'status'=>$this->data['status'],
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'pos_user'=>1,
              'contact_email'=>$this->data['contact_email']
            );  
            
             $this->functions->updateOption(
              "pos_cashier_access",
              (isset($this->data['pos_cashier_access']) && $this->data['pos_cashier_access'] == 'cashier') ? '1' : '0',
              $merchant_id
             );
                                  
            if (isset($this->data['password'])){
                if ( !empty($this->data['password'])){
                    $params['password']=md5($this->data['password']);
                }
            }       
            
            /*dump($params);
            die();
            */
           
            if (empty($this->data['id'])){      
                if (empty($params['password'])){
                    $this->msg="Password is required.";
                    return ;
                }          
                                
                if ( $err_msg=$this->functions->validateMerchantUserAccount_merchantwise($this->data['username'],$merchant_id,
                     $this->data['contact_email'])){
                     $this->msg=$err_msg;
                     return ;
                }                           
                
                if ( !$this->functions->validateMerchantUsername_merchantwise($this->data['username'],$merchant_id)){    
                  $last_insert_id = $this->functions->insertData('mt_merchant_user', $params);
                    if ($last_insert_id!== false){         
                        $this->details=$last_insert_id;
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","Successful");                      
                    }
                } else $this->msg="Sorry your username is already exist. Please choose another username.";
            } else {                
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();                                
                
                if (!empty($params['username'])){
                    if ( $this->functions->validateMerchantUser($params['username'],$merchant_id) ){
                        $this->msg=$this->functions->translation("default","Merchant Username is already been taken");
                        return ;
                    }
                }           
                                
                if ( $err_msg=$this->functions->validateMerchantUserAccount_merchantwise($this->data['username'],$merchant_id,
                     $this->data['contact_email'],$this->data['id'])){
                     $this->msg=$err_msg;
                     return ;
                }
                                                            
               // $res = $this->updateData('{{merchant_user}}' , $params ,'merchant_user_id',$this->data['id']);
                $res = $this->functions->updateData("mt_merchant_user", $params, 'merchant_user_id', $this->data['id']);

                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Merchant User updated.');  
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            }               
        }








public function singleMerchantAddPage()
    {
        if ( !$this->functions->isMerchantLogin()){
            $this->msg=$this->functions->translation("default","ERROR: Your session has expired.");
            return false;
       }
       
        $merchant_id = (integer)$this->functions->getMerchantID();
        
        
        $req=array( 
          'title'=>$this->functions->translation("default","title is required"),
          'content'=>$this->functions->translation("default","content is required"),
          'merchant_id'=>$this->functions->translation("default","merchant id is required"),
        );
        $this->functions->required($req,$this->data);
        if ( $this->functions->validate()){
            $params=array(
              'title'=>$this->data['title'],
              'content'=>$this->data['content'],
              'icon'=>isset($this->data['icon'])?$this->data['icon']:'',
              'sequence'=>isset($this->data['sequence'])?$this->data['sequence']:0,
              'status'=>$this->data['status'],
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'use_html'=>isset($this->data['use_html'])?$this->data['use_html']:1,
              'merchant_id'=>$merchant_id
            );
            
           
            if($params['use_html']=='on'){
             $params['use_html']=1;
            }else{
             $params['use_html']=0;
            }
                    
            if(!is_numeric($params['use_html'])){
                unset($params['use_html']);
                echo "here";die();
            }                   
            if(!is_numeric($params['sequence'])){
                $params['sequence']=0;
            }           
            if(!is_numeric($params['merchant_id'])){
                $params['merchant_id']=0;
            }
            
            $page_id = isset($this->data['page_id'])?(integer)$this->data['page_id']:0;
            
            if($page_id>0){
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();
                

                $up =$this->functions->updateData("mt_singleapp_pages", $params, 'page_id', $page_id);            
                if($up){
                    $this->code = 1;
                    $this->msg = $this->functions->translation("default","successfully updated");
                    $this->details=$page_id;
                } else $this->msg = $this->functions->translation("default","Failed cannot saved records");
            } else { 

                $last_insert_id = $this->functions->insertData('mt_singleapp_pages', $params);
                if ($last_insert_id!== false){  
                    $this->code = 1;
                    $this->details= $last_insert_id; 
                    $this->msg = $this->functions->translation("default","Successful");
                } else $this->msg = $this->functions->translation("default","Failed cannot saved records");
            }
            
        } else $this->msg= $this->functions->getErrorAsHTML();        
    }




        public function singleMerchantContact()
    {
        if ( !$this->functions->isMerchantLogin()){
            $this->msg="ERROR: Your session has expired.";
            return false;
       }
       
        $merchant_id = (integer)$this->functions->getMerchantID();
        
        $this->code = 1;        
        $this->msg = "Setting saved";
        
        $this->functions->updateOption("singleapp_contact_email",
        isset($this->data['singleapp_contact_email'])?$this->data['singleapp_contact_email']:''
        ,$merchant_id);
        
        $this->functions->updateOption("singleapp_contact_tpl",
        isset($this->data['singleapp_contact_tpl'])?$this->data['singleapp_contact_tpl']:''
        ,$merchant_id);
        
        $this->functions->updateOption("singleapp_contact_subject",
        isset($this->data['singleapp_contact_subject'])?$this->data['singleapp_contact_subject']:''
        ,$merchant_id);
        
        $this->functions->updateOption("singleapp_contactus_fields",
        isset($this->data['singleapp_contactus_fields'])?json_encode($this->data['singleapp_contactus_fields']):''
        ,$merchant_id);
        
        $this->functions->updateOption("singleapp_contactus_enabled",
        isset($this->data['singleapp_contactus_enabled'])?$this->data['singleapp_contactus_enabled']:''
        ,$merchant_id);
    }



public function tableBookingList()
{
    // Retrieve booking statuses
    $booking_stats = $this->functions->bookingStatus();
    
    // Get the slug and merchant ID
    $slug = $this->data['slug'];
    $merchant_id = $this->functions->getMerchantID();
    
    // Prepare the SQL query using PDO
    $stmt = "
        SELECT * FROM
        mt_bookingtable
        WHERE
        merchant_id = :merchant_id
        ORDER BY booking_id DESC
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Fetch all results
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if rows are returned
    if (is_array($rows) && count($rows) >= 1) {
        foreach ($rows as $val) {
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"{$val['booking_id']}\" class=\"chk_child\" >";
      
            $buttons = '';
            $tags = ' pending ';
            $stsatus_name = "Reservation Cancelled!";
      
      $no_resp = "";
          
            // 🕒 Check both date and time
            $booking_datetime = strtotime($val['date_booking'] . ' ' . $val['booking_time']);
          $now = time();
            $isPast = ($booking_datetime < $now);

            // Always show View button
            $buttons .= "<a href=\"{$slug}/id/{$val['booking_id']}\" class=\"tag Accepted\">" 
            . $this->functions->translation("default", "View") . "</a><br>";

            // Only show action buttons if booking is NOT in the past
            if (!$isPast) {
                if ($val['status'] == 'approved') {
                    $tags = ' sent ';
                    $buttons .= "<a href=\"javascript:;\" class=\"delete_item1 row_del_bokking tag pending\"  mid=\"{$merchant_id}\" rev=\"{$val['booking_id']}\">" 
                                . $this->functions->translation("default", "Cancel Reservation?") . "</a>";
                    $stsatus_name = "Reservation Confirmed!";
                } elseif ($val['status'] == 'pending') {
                    $tags = ' denied ';
                    $buttons .= "<a href=\"javascript:;\" class=\"delete_item1 row_del_bokking_approve tag sent\"  mid=\"{$merchant_id}\" rev=\"{$val['booking_id']}\">" 
                                . $this->functions->translation("default", "Approve Reservation?") . "</a>";

                    $buttons .= "<a href=\"javascript:;\" class=\"delete_item1 row_del_bokking tag pending\"  mid=\"{$merchant_id}\" rev=\"{$val['booking_id']}\">" 
                                . $this->functions->translation("default", "Cancel Reservation?") . "</a>";

                    $stsatus_name = "Reservation Pending!";
          
                }
            }else{
        
          if ($val['status'] == 'approved') { $tags = ' sent ';
                     $stsatus_name = "Reservation Confirmed!";
                } elseif ($val['status'] == 'pending') {
                     //$tags = ' denied ';
                    $stsatus_name = "Reservation Expired!";
          
          $no_resp = "No Response";
      
          
                }
        
        
        
        
        
        
      }
      
      
       // Only show action buttons if booking is NOT in the past
        
             
            

      

            $date = $this->functions->FormatDateTime($val['date_created']);
            $dateb = $this->functions->FormatDateTime($val['date_booking'], false);
            $stats = isset($booking_stats[$val['status']]) ? $booking_stats[$val['status']] : $val['status'];

            $feed_data['aaData'][] = array(
                $val['booking_id'],
                stripslashes($val['booking_name']) . '<br/>' . $val['email'],
                $dateb . "@" . $this->functions->prettyTime($val['booking_time']),
                $val['number_guest'],
                $val['mobile'],
                $val['booking_notes'],
                $buttons,
                "$date<br/><span class=\"tag {$tags}\">{$stsatus_name}<br/>{$no_resp}</span>",
            );
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}



    public function tableBookingList_bkup()
{
    // Retrieve booking statuses
    $booking_stats = $this->functions->bookingStatus();
    
    // Get the slug and merchant ID
    $slug = $this->data['slug'];
    $merchant_id = $this->functions->getMerchantID();
    
    // Prepare the SQL query using PDO
    $stmt = "
        SELECT * FROM
        mt_bookingtable
        WHERE
        merchant_id = :merchant_id
        ORDER BY booking_id DESC
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    
    // Fetch all results
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if rows are returned
    if (is_array($rows) && count($rows) >= 1) {
        foreach ($rows as $val) {
            // Checkbox for each booking
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"{$val['booking_id']}\" class=\"chk_child\" >";

            // Options for edit and delete
            /*$option = "<div class=\"options\">
                <a href=\"{$slug}/id/{$val['booking_id']}\" >" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['booking_id']}\" >" . $this->functions->translation("default", "Delete") . "</a>
            </div>";
      */
      
      
         $buttons = '';
           
      $tags=' pending ';
            // Edit button
            $buttons .= "<a href=\"{$slug}/id/{$val['booking_id']}\" class=\"tag Accepted\">" 
            . $this->functions->translation("default", "View") . "</a><br>";

      $stsatus_name="Reservation Cancelled!";         
            // Delete button
            if ($val['status']=='approved') {
        $tags=' sent ';
                $buttons .= "<a href=\"javascript:;\" class=\"delete_item1 row_del_bokking tag pending\"  mid=\"{$merchant_id}\" rev=\"{$val['booking_id']}\">" 
                            . $this->functions->translation("default", "Cancel Reservation?") . "</a>";
              
              
        $stsatus_name="Reservation Confirmed!";     
            }else if ($val['status']=='pending') {
        $tags=' denied ';
                $buttons .= "<a href=\"javascript:;\" class=\"delete_item1 row_del_bokking_approve tag sent\"  mid=\"{$merchant_id}\" rev=\"{$val['booking_id']}\">" 
                            . $this->functions->translation("default", "Approve Reservation?") . "</a>";
              

          $buttons .= "<a href=\"javascript:;\" class=\"delete_item1 row_del_bokking tag pending\"  mid=\"{$merchant_id}\" rev=\"{$val['booking_id']}\">" 
                            . $this->functions->translation("default", "Cancel Reservation?") . "</a>";
              
                  
        $stsatus_name="Reservation Pending!";     
            } 
      
      
      
            
            // Format the date and booking date
            $date = $this->functions->FormatDateTime($val['date_created']);
            $dateb = $this->functions->FormatDateTime($val['date_booking'], false);
            
            // Get the booking status
            $stats = isset($booking_stats[$val['status']]) ? $booking_stats[$val['status']] : $val['status'];

            // Add data to the output array
            $feed_data['aaData'][] = array(
                $val['booking_id'],
                stripslashes($val['booking_name']) .'<br/>'. $val['email'],
                $dateb . "@" . $this->functions->prettyTime($val['booking_time']),
                $val['number_guest'],
                $val['mobile'],
                $val['booking_notes'],
               
        $buttons, "$date<br/><span class=\"tag {$tags}\">{$stsatus_name}</span>",
            );
        }
        // Output the table data
        $this->otableOutput($feed_data);
    } else {
        // No data found
        $this->otableNodata();
    }
}







public function payOnDeliveryMerchant()
        {           
            $merchant_id=$this->functions->getMerchantID();
            
            $this->functions->updateOption("payment_provider",
            isset($this->data['payment_provider'])?json_encode($this->data['payment_provider']):''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_payondeliver_enabled",
            isset($this->data['merchant_payondeliver_enabled'])?$this->data['merchant_payondeliver_enabled']:''
            ,$merchant_id);
      
      
      $list21=$this->functions->getPaymentProviderList(); 
      
         if (is_array($list21) && count($list21)>=1){
          foreach ($list21 as $val1){
            $ids=$val1['id'];
              $names='payment_show_type_'.$ids;
              
            $max=$this->data[$names];
              
 
            $this->functions->updateOption($names,isset($max)?$max:'',$merchant_id);
      
      
          }
         }
      
      
      
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Setting saved");
        }



        public function adminProfile()
        {                   
                        
            $params=array(
              'first_name'=>trim($this->data['first_name']),
              'last_name'=>trim($this->data['last_name']),            
              'date_modified'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'email_address'=>isset($this->data['email_address'])?trim($this->data['email_address']):''
            );          
            
            
                        
            if (isset($this->data['password'])){
                if (!empty($this->data['password'])){
                    if ($this->data['password']!=$this->data['cpassword']){
                        $this->msg=$this->functions->translation("default","Confirm password does not match.");
                        return ;
                    } else {
                        $params['password']=md5($this->data['password']);
                    }                       
                }           
            }
            $admin_id=$this->functions->getAdminId(); 

            if ($this->functions->updateData("mt_admin_user", $params, 'admin_id', $admin_id)){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Profile updated.");
            } else $this->msg=$this->functions->translation("default","ERROR Cannot update.");
        }




        public function bookATableMerchant()
        {
            
            $merchant_id=$this->functions->getMerchantID();            
            $params=array(
              'merchant_id'=>$merchant_id,
              'number_guest'=>isset($this->data['number_guest'])?$this->data['number_guest']:'',
              'date_booking'=>isset($this->data['date_booking'])?$this->data['date_booking']:'',
              'booking_time'=>isset($this->data['booking_time'])?$this->data['booking_time']:'',
              'booking_name'=>isset($this->data['booking_name'])?$this->data['booking_name']:'',
              'email'=>isset($this->data['email'])?$this->data['email']:'',
              'mobile'=>isset($this->data['mobile'])?$this->data['mobile']:'',
              'booking_notes'=>isset($this->data['booking_notes'])?$this->data['booking_notes']:'',
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'status'=>isset($this->data['status'])?$this->data['status']:'',
              'viewed'=>2,
              'request_cancel'=>0
            );   

            $mt_info=$this->functions->getMerchantInfo_mobileapp($merchant_id);

            //$params['restaurant_name']=$mt_info['restaurant_name'];       
            
           
            if (isset($this->data['id']) && is_numeric($this->data['id'])){             
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();


//+++++++++++++++++++++++++++++was custom code++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

                     //+++getting booking data
                   $bookingId=$this->data['id'];
                    $stmt = $this->db->prepare("
                    SELECT * 
                    FROM mt_bookingtable 
                    WHERE booking_id = ?
                ");
                  $stmt->execute([$bookingId]);
                  $booking_from_db = $stmt->fetch(PDO::FETCH_ASSOC);

                   //---getting booking data

                   //+++for slots decrement
                  

                   if($params['status']=="cancel_booking_approved"&&$booking_from_db['status']!="cancel_booking_approved"){
                     $utc_times=$booking_from_db['utc_times'];
           
                     $booking_id_google=$booking_from_db['booking_id_google'];
           
           /*
                     $slots_info=$this->functions->getslotsbyUTC($utc_times);
           
           
                     $used_slots=$slots_info['used_slots']-1;
                     $available_slots=$slots_info['no_of_slots']-$used_slots;

                     $slot_id=$slots_info['id'];

                      $params_update=array(
                          'used_slots'=>$used_slots,
                          'available_slots'=>$available_slots,

                        );  


                     
                     $this->functions->updateData("mt_booking_slots_child", $params_update, 'id', $slot_id);
           */
           
           
             $slots_info_data=$this->functions->getslotsbyUTC_alols($utc_times,$merchant_id);
     
     if(isset($slots_info_data) && !empty($slots_info_data)){
       foreach($slots_info_data as $slots_info){
         $used_slots=$slots_info['used_slots']-1;
       $available_slots=$slots_info['no_of_slots']-$used_slots;

       $slot_id=$slots_info['id'];


        $params_update1=array(
            'used_slots'=>$used_slots,
            'available_slots'=>$available_slots,
          );  


       $this->functions->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
       }
       
       
       
       
       
     }
     
           
           
           
           
           
           
           
           
           

                    $this->functions->google_trigger($booking_from_db,'CONFIRMED');




                   }


                   //---for slots decrement




                   //+++for slot increment

                   if($params['status']=="approved"&&$booking_from_db['status']!="approved"){
                     $utc_times=$booking_from_db['utc_times'];
                     $slots_info=$this->functions->getslotsbyUTC($utc_times);
                     $used_slots=$slots_info['used_slots']+1;
                     $available_slots=$slots_info['no_of_slots']-$used_slots;

                     $slot_id=$slots_info['id'];

                      $params_update=array(
                          'used_slots'=>$used_slots,
                          'available_slots'=>$available_slots,

                        );  


                     
                     $this->functions->updateData("mt_booking_slots_child", $params_update, 'id', $slot_id);

                   }

                   //+++for slot increment



//--------------------------------------------------------was custom code-----------------------------------------



                
                $res= $this->functions->updateData("mt_bookingtable", $params, 'booking_id', $this->data['id']);


                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Booking updated.');  
                    
                    /*INSERT HISTORY*/
                    $params_history=array(
                      'booking_id'=>$this->data['id'],
                      'status'=>$params['status'],
                      'remarks'=>$this->data['message'],
                      'date_created'=>$this->functions->dateNow()
                    );
                    

                   $this->functions->insertData('mt_bookingtable_history', $params_history);

              


                    
                    /*SEND EMAIL TO CUSTOMER*/
                    $new_data=$params;
                    $new_data['booking_id']=$booking_id_google;
                    $new_data['remarks']=$this->data['message'];

                   if($params['status']=="cancel_booking_approved"){
                    $new_data['status']="is canceled";
                   }

                   
                   $new_data['booking_time']= $this->functions->prettyTime($params['booking_time']);
                    $new_data['restaurant_name']=$mt_info['restaurant_name'];

                    $this->functions->updateBookingNotify($new_data);
                    
                   $this->PointsProgram->updateBookTable($this->data['id'],$params['status']);

                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else { 

                $last_insert_id = $this->functions->insertData('mt_bookingtable', $params);
                if ($last_insert_id!== false){  
                    $this->details= $last_insert_id;                   
                    //dump($this->details);
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Booking added.');                      
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }           
        }
    
    
    
    
    
      public function booking_cancel()
        {
            
            $merchant_id=$this->data['mid'];         
       $this->data['id']=$this->data['bid'];
       $this->data['message']='';
            $params=array(
              'merchant_id'=>$merchant_id,
              'status'=>'cancel_booking_approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   


            $mt_info=$this->functions->getMerchantInfo_mobileapp($merchant_id);

            //$params['restaurant_name']=$mt_info['restaurant_name'];       
            
           
            if (isset($this->data['id']) && is_numeric($this->data['id'])){             
             
                $params['date_modified']=$this->functions->dateNow();


//+++++++++++++++++++++++++++++was custom code++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

                     //+++getting booking data
                   $bookingId=$this->data['id'];
                    $stmt = $this->db->prepare("
                    SELECT * 
                    FROM mt_bookingtable 
                    WHERE booking_id = ?
                ");
                  $stmt->execute([$bookingId]);
                  $booking_from_db = $stmt->fetch(PDO::FETCH_ASSOC);

                   //---getting booking data


          
        $params_noti=array(
              'merchant_id'=>$merchant_id,
              'number_guest'=>isset($booking_from_db['number_guest'])?$booking_from_db['number_guest']:'',
              'date_booking'=>isset($booking_from_db['date_booking'])?$booking_from_db['date_booking']:'',
              'booking_time'=>isset($booking_from_db['booking_time'])?$booking_from_db['booking_time']:'',
              'booking_name'=>isset($booking_from_db['booking_name'])?$booking_from_db['booking_name']:'',
              'email'=>isset($booking_from_db['email'])?$booking_from_db['email']:'',
              'mobile'=>isset($booking_from_db['mobile'])?$booking_from_db['mobile']:'',
              'booking_notes'=>isset($booking_from_db['booking_notes'])?$booking_from_db['booking_notes']:'',
              'status'=>'cancel_booking_approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   
      
      

                   //+++for slots decrement
                  

                   if($params['status']=="cancel_booking_approved"&&$booking_from_db['status']!="cancel_booking_approved"){
                     $utc_times=$booking_from_db['utc_times'];
           
                     $booking_id_google=$booking_from_db['booking_id_google'];
           
          
           
           
             $slots_info_data=$this->functions->getslotsbyUTC_alols($utc_times,$merchant_id);
     
     if(isset($slots_info_data) && !empty($slots_info_data)){
       foreach($slots_info_data as $slots_info){
         $used_slots=$slots_info['used_slots']-1;
       $available_slots=$slots_info['no_of_slots']-$used_slots;
     
       $slot_id=$slots_info['id'];
        $params_update1=array(
            'used_slots'=>$used_slots,
            'available_slots'=>$available_slots,
          );  


       $this->functions->updateData("mt_booking_slots_child", $params_update1, 'id', $slot_id);
       }
       
       
     }
     
           
           
           
           
           
           
           
           
           
          if($booking_from_db['status']=="pending"){
                    $this->functions->google_trigger($booking_from_db,"DECLINED_BY_MERCHANT");
          }else{
            $this->functions->google_trigger($booking_from_db,"CANCELED");
            
          }



                   }else{
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Booking already cancelled.'); 
                    return ;   
                   }


                   //---for slots decrement



//--------------------------------------------------------was custom code-----------------------------------------


                $params['token']='';
                
                $res= $this->functions->updateData("mt_bookingtable", $params, 'booking_id', $this->data['id']);


                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Booking updated.');  
                    
                    /*INSERT HISTORY*/
                    $params_history=array(
                      'booking_id'=>$this->data['id'],
                      'status'=>$params['status'],
                      'remarks'=>$this->data['message'],
                      'date_created'=>$this->functions->dateNow()
                    );
                    

                   $this->functions->insertData('mt_bookingtable_history', $params_history);

              
      



                    
                    /*SEND EMAIL TO CUSTOMER*/
                    $new_data=$params_noti;
                    //$new_data['booking_id']=$booking_id_google;

                    $new_data['booking_id']=$booking_from_db['booking_id'];

                    $new_data['remarks']=$this->data['message'];

                   if($params['status']=="cancel_booking_approved"){
                    $new_data['status']="is canceled";
                   }

                   
                   $new_data['booking_time']= $this->functions->prettyTime($booking_from_db['booking_time']);
                    $new_data['restaurant_name']=$mt_info['restaurant_name'];
                     $new_data['booking_id_our_system']=$booking_from_db['booking_id'];
                    

                    $this->functions->updateBookingNotify($new_data);
                    
                   $this->PointsProgram->updateBookTable($this->data['id'],$params['status']);

                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else { 

                $last_insert_id = $this->functions->insertData('mt_bookingtable', $params);
                if ($last_insert_id!== false){  
                    $this->details= $last_insert_id;                   
                    //dump($this->details);
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Booking added.');                      
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }           
        }
    
    
    
     public function booking_approved_new()
        {
            
            $merchant_id=$this->data['mid'];         
       $this->data['id']=$this->data['bid'];
       $this->data['message']='';
            $params=array(
              'merchant_id'=>$merchant_id,
              'status'=>'approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   


            $mt_info=$this->functions->getMerchantInfo_mobileapp($merchant_id);

            //$params['restaurant_name']=$mt_info['restaurant_name'];       
            
           
            if (isset($this->data['id']) && is_numeric($this->data['id'])){             
             
                $params['date_modified']=$this->functions->dateNow();


//+++++++++++++++++++++++++++++was custom code++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

                     //+++getting booking data
                   $bookingId=$this->data['id'];
                    $stmt = $this->db->prepare("
                    SELECT * 
                    FROM mt_bookingtable 
                    WHERE booking_id = ?
                ");
                  $stmt->execute([$bookingId]);
                  $booking_from_db = $stmt->fetch(PDO::FETCH_ASSOC);

                   //---getting booking data


          
        $params_noti=array(
              'merchant_id'=>$merchant_id,
              'number_guest'=>isset($booking_from_db['number_guest'])?$booking_from_db['number_guest']:'',
              'date_booking'=>isset($booking_from_db['date_booking'])?$booking_from_db['date_booking']:'',
              'booking_time'=>isset($booking_from_db['booking_time'])?$booking_from_db['booking_time']:'',
              'booking_name'=>isset($booking_from_db['booking_name'])?$booking_from_db['booking_name']:'',
              'email'=>isset($booking_from_db['email'])?$booking_from_db['email']:'',
              'mobile'=>isset($booking_from_db['mobile'])?$booking_from_db['mobile']:'',
              'booking_notes'=>isset($booking_from_db['booking_notes'])?$booking_from_db['booking_notes']:'',
              'status'=>'approved',
              'viewed'=>2,
              'request_cancel'=>0
            );   
      
      

                   //+++for slots decrement
                  

                   if($params['status']=="approved"&&$booking_from_db['status']!="approved"){
                     $utc_times=$booking_from_db['utc_times'];
           
                     $booking_id_google=$booking_from_db['booking_id_google'];
           
          
                   

                    $this->functions->google_trigger($booking_from_db,'CONFIRMED');




                   }else{
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Booking already approved.'); 
                    return ;   
                   }


                   //---for slots decrement



//--------------------------------------------------------was custom code-----------------------------------------



                $params['token']='';
                $res= $this->functions->updateData("mt_bookingtable", $params, 'booking_id', $this->data['id']);


                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Booking updated.');  
                    
                    /*INSERT HISTORY*/
                    $params_history=array(
                      'booking_id'=>$this->data['id'],
                      'status'=>$params['status'],
                      'remarks'=>$this->data['message'],
                      'date_created'=>$this->functions->dateNow()
                    );
                    

                   $this->functions->insertData('mt_bookingtable_history', $params_history);

              
      



                    
                    /*SEND EMAIL TO CUSTOMER*/
                    $new_data=$params_noti;
                    //$new_data['booking_id']=$booking_id_google;
                    $new_data['booking_id']=$booking_from_db['booking_id'];
                    
                    $new_data['remarks']=$this->data['message'];

                   if($params['status']=="approved"){
                    $new_data['status']="is confirmed";
                   }

                   
                   $new_data['booking_time']= $this->functions->prettyTime($booking_from_db['booking_time']);
                    $new_data['restaurant_name']=$mt_info['restaurant_name'];
                    $new_data['booking_id_our_system']=$booking_from_db['booking_id'];
                    

                    $this->functions->updateBookingNotify($new_data);
                    
                   $this->PointsProgram->updateBookTable($this->data['id'],$params['status']);

                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else { 

                $last_insert_id = $this->functions->insertData('mt_bookingtable', $params);
                if ($last_insert_id!== false){  
                    $this->details= $last_insert_id;                   
                    //dump($this->details);
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Booking added.');                      
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }           
        }
    




            public function bookATable()
        {
                        
           /**check if customer chooose past time */
           if ( isset($this->data['booking_time'])){
              if(!empty($this->data['booking_time'])){
                 $time_1=date('Y-m-d g:i:s a');
                 $time_2=$this->data['date_booking']." ".$this->data['booking_time'];
                 $time_2=date("Y-m-d g:i:s a",strtotime($time_2));                       
                 $time_diff=$this->functions->dateDifference($time_2,$time_1);                              
                 if (is_array($time_diff) && count($time_diff)>=1){
                     if ( $time_diff['hours']>0){                       
                         $this->msg=$this->functions->translation("default","Sorry but you have selected time that already past");
                         return ;                       
                     }              
                     if ( $time_diff['minutes']>0){                     
                         $this->msg=$this->functions->translation("default","Sorry but you have selected time that already past");
                         return ;                       
                     }              
                 }            
              }        
           }               
                                    
            $merchant_id=isset($this->data['merchant-id'])?$this->data['merchant-id']:'';           
                        
            $full_booking_time=$this->data['date_booking']." ".$this->data['booking_time'];
            $full_booking_day=strtolower(date("D",strtotime($full_booking_time)));          
            $booking_time=date('h:i A',strtotime($full_booking_time));          
                                
            if ( !$this->functions->isMerchantOpenTimes($merchant_id,$full_booking_day,$booking_time)){
                $this->msg=$this->functions->translation("default","Sorry but we are closed on"." ".date("F,d Y h:ia",strtotime($full_booking_time))).
                "<br/>".$this->functions->translation("default","Please check merchant opening hours");
                return ;
            }                   
                    
            $now=isset($this->data['date_booking'])?$this->data['date_booking']:'';         
            $merchant_close_msg_holiday='';
            $is_holiday=false;
            if ( $m_holiday=$this->functions->getMerchantHoliday($merchant_id)){
                if (in_array($now,(array)$m_holiday)){
                    $is_holiday=true;
                }
            }
            if ( $is_holiday==true){
                $merchant_close_msg_holiday=!empty($merchant_close_msg_holiday)?$merchant_close_msg_holiday:t("Sorry but we are on holiday on")." ".date("F d Y",strtotime($now));
                $this->msg=$merchant_close_msg_holiday;
                return ;
            }           
                        
            $fully_booked_msg=$this->functions->getOption("fully_booked_msg",$merchant_id);
            if (!$this->functions->bookedAvailable($merchant_id)){
                if (!empty($fully_booked_msg)){
                    $this->msg=$this->functions->translation("default",$fully_booked_msg);
                } else $this->msg=$this->functions->translation("default","Sorry we are fully booked for that day");              
                return ;
            }
                        
                              
            $params=array(
              'merchant_id'=>isset($this->data['merchant-id'])?($this->data['merchant-id']):'',
              'number_guest'=>isset($this->data['number_guest'])?($this->data['number_guest']):'',
              'date_booking'=>isset($this->data['date_booking'])?($this->data['date_booking']):'',
              'booking_time'=>isset($this->data['booking_time'])?($this->data['booking_time']):'',
              'booking_name'=>isset($this->data['booking_name'])?($this->data['booking_name']):'',
              'email'=>isset($this->data['email'])?($this->data['email']):'',
              'mobile'=>isset($this->data['mobile'])?($this->data['mobile']):'',
              'booking_notes'=>isset($this->data['booking_notes'])?($this->data['booking_notes']):'',
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']
            );          
            
            if ( $this->functions->isClientLogin()){
                $params['client_id']= $this->functions->getClientId();
            }
                    
            
            $new_data=$params;
            if ( !$merchant_info=$this->functions->getMerchant($merchant_id)){         
                $merchant_info['restaurant_name']=$this->functions->translation("default","None");
            } else {
                $new_data['restaurant_name']=$merchant_info['restaurant_name'];
            }       
                        
            /*check if email address is blocked*/
            if ( $this->functions->emailBlockedCheck($params['email'])){
                $this->msg=$this->functions->translation("default","Sorry but your email address is blocked by website admin");
                return ;
            }

             $last_insert_id = $this->functions->insertData('mt_bookingtable', $params);
            if ($last_insert_id!== false){ 
                                                                            
                $booking_id=$last_insert_id;
                $this->code=1;
                $this->msg=$this->functions->translation("default","Thank you your booking has been received");                                
                
                /*SEND NOTIFICATIONS*/              
                $new_data['booking_id']=$booking_id;
               // FunctionsV3::notifyBooking($new_data);
                $this->functions->notifyBooking($new_data);
                /*POINTS PROGRAM*/                  
               
                $this->PointsProgram->rewardsBookTable($booking_id , $this->functions->getClientId() , $merchant_id );
                
                                
            } else $this->msg=$this->functions->translation("default","Something went wrong during processing your request. Please try again later.");
        }





        public function bookingAlertSettings()
        {       
            $merchant_id=$this->functions->getMerchantID();
                        
            $this->functions->updateOption("merchant_booking_alert",
            isset($this->data['merchant_booking_alert'])?$this->data['merchant_booking_alert']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_booking_approved_tpl",
            isset($this->data['merchant_booking_approved_tpl'])?$this->data['merchant_booking_approved_tpl']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_booking_denied_tpl",
            isset($this->data['merchant_booking_denied_tpl'])?$this->data['merchant_booking_denied_tpl']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_booking_subject",
            isset($this->data['merchant_booking_subject'])?$this->data['merchant_booking_subject']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_booking_sender",
            isset($this->data['merchant_booking_sender'])?$this->data['merchant_booking_sender']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_booking_receiver",
            isset($this->data['merchant_booking_receiver'])?$this->data['merchant_booking_receiver']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_booking_tpl",
            isset($this->data['merchant_booking_tpl'])?$this->data['merchant_booking_tpl']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_booking_receive_subject",
            isset($this->data['merchant_booking_receive_subject'])?$this->data['merchant_booking_receive_subject']:''
            ,$merchant_id);
            
            $this->functions->updateOption("max_booked",
            isset($this->data['max_booked'])?json_encode($this->data['max_booked']):''
            ,$merchant_id);
            
            $this->functions->updateOption("fully_booked_msg",
            isset($this->data['fully_booked_msg'])?$this->data['fully_booked_msg']:''
            ,$merchant_id);         
            
            $this->functions->updateOption("accept_booking_sameday",
            isset($this->data['accept_booking_sameday'])?$this->data['accept_booking_sameday']:''
            ,$merchant_id);         
            
            $this->functions->updateOption("merchant_table_booking",
            isset($this->data['merchant_table_booking'])?$this->data['merchant_table_booking']:''
            ,$merchant_id);         
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved."); 
        } 



        public function getMerchantBalance()
    {
        $balance = 0;
        $merchant_id = $this->functions->getMerchantID();
        $balance = $this->functions->getMerchantBalance($merchant_id);
        
        $this->details=$this->functions->formatNumber($balance);
        $this->code=1;
        $this->msg="ok";
    }






         public function AlertSettings()
        {           
            $merchant_id=$this->functions->getMerchantID();
            
            $this->functions->updateOption("merchant_notify_email",
            isset($this->data['merchant_notify_email'])?$this->data['merchant_notify_email']:''
            ,$merchant_id);
            
            $this->functions->updateOption("enabled_alert_notification",
            isset($this->data['enabled_alert_notification'])?$this->data['enabled_alert_notification']:''
            ,$merchant_id);
            
            $this->functions->updateOption("enabled_alert_sound",
            isset($this->data['enabled_alert_sound'])?$this->data['enabled_alert_sound']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_invoice_email",
            isset($this->data['merchant_invoice_email'])?$this->data['merchant_invoice_email']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_cancel_order_email",
            isset($this->data['merchant_cancel_order_email'])?$this->data['merchant_cancel_order_email']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_cancel_order_phone",
            isset($this->data['merchant_cancel_order_phone'])?$this->data['merchant_cancel_order_phone']:''
            ,$merchant_id);
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved.");
        }




public function AllOrdersMerchant_pos()
{
    // Get merchant_id as an integer
    $merchant_id = (int)$this->functions->getMerchantID();
    
    if ($merchant_id > 0) {
        $aColumns = [
            'a.order_id', 'a.merchant_id', 'c.first_name', 'json_details', 'trans_type', 
            'payment_type', 'sub_total', 'taxable_total', 'total_w_tax', 'a.status', 
            'request_from', 'a.date_created'
        ];          
        $sWhere = ''; 
        $sOrder = ''; 
        $sLimit = '';

        // Get the Datatable query params
        $t = $this->functions->ajaxDataTables($aColumns);
        if (is_array($t) && count($t) >= 1) {
            $sWhere = $t['sWhere'];
            $sOrder = $t['sOrder'];
            $sLimit = $t['sLimit'];
            $sWhere = str_replace("WHERE", "AND", $sWhere);
        }   

        $where = " WHERE a.merchant_id = :merchant_id ";

        if (!empty($sWhere)) {
            $sWhere .= " AND a.status NOT IN ('initial_order')";
        } else {
            $sWhere .= " AND a.status NOT IN ('initial_order') AND `request_from` = 'pos'";
        }

        $select = ''; // Add any additional selects if necessary
        
        // Prepare SQL query
        $sql = "
            SELECT SQL_CALC_FOUND_ROWS 
            a.order_id, trans_type, payment_type, sub_total, taxable_total, total_w_tax, 
            a.status, a.order_number, a.merchant_id, a.date_created, admin_viewed,a.client_names,a.is_phone_order,a.phones,a.is_retail, 
            request_from, b.restaurant_name, 
            CONCAT(c.first_name, ' ', c.last_name) AS client_name, 
            CONCAT(d.first_name, ' ', d.last_name) AS customer_name,
           (
                SELECT CONCAT(first_name, ' ', last_name)
                FROM mt_order_delivery_address
                WHERE order_id = a.order_id
                LIMIT 0,1
            ) AS customer_name
      
            $select
            FROM mt_order a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            LEFT JOIN mt_client c ON a.client_id = c.client_id
            LEFT JOIN mt_order_delivery_address d ON a.order_id = d.order_id
            $where $sWhere $sOrder $sLimit
        ";
        
        // Prepare the statement using PDO
        $stmt = $this->db->prepare($sql);
        // Bind the merchant_id parameter
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        // Execute the query
        $stmt->execute();

        // Fetch results
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $iTotalRecords = 0;               
            $stmtTotal = $this->db->query("SELECT FOUND_ROWS()"); // Get total row count
            if ($resTotal = $stmtTotal->fetch(PDO::FETCH_ASSOC)) {
                $iTotalRecords = $resTotal['FOUND_ROWS()'];
            }

            // Prepare the feed data for output
            $feed_data['sEcho'] = intval($_GET['sEcho']);
            $feed_data['iTotalRecords'] = $iTotalRecords;
            $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

            foreach ($res as $val) {
                $action = '';
          if ($val['request_from'] == "webappv2" || $val['request_from'] == "web") {
        
        
         if(!empty($val['customer_name']) && strlen($val['customer_name'])>1 ){          
          $val['client_name'] = $val['customer_name'];
        }
    
         }
        
        
        
         if($val['request_from']=="pos"){}else{
         $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"edit-order\" href=\"javascript:\">" . $this->functions->translation("default", "Edit") . "</a>";}
                $action .= "<br/><a data-id=\"" . $val['order_id'] . "\" class=\"view-receipt\" href=\"javascript:\">" . $this->functions->translation("default", "View") . "</a>";
                $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"view-order-history\" href=\"javascript:\">" . $this->functions->translation("default", "History") . "</a>";          
               
                // Fetch and translate food items
                $item = $this->functions->translateFoodItemByOrderId($val['order_id']);

                $new = '';
                if ($val['admin_viewed'] <= 0) {
                    $new = " <div class=\"uk-badge\">" . $this->functions->translation("default", "NEW") . "</div>";
                }

                $val['client_name'] = !empty(trim($val['client_name'])) ? $val['client_name'] : 'Guest';

                // Date and time formatting
                $date_created = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);

                // Handle order number formatting based on request source
                $order_number = '-';
                if ($val['request_from'] == "webappv2" && $val['order_number'] > 0) { 
                    $order_number = $val['merchant_id'] . '-' . $val['order_number']; 
                } else if ($val['request_from'] == "pos" && $val['order_number'] > 0) {    
                    $order_number = $val['merchant_id'] . '-' . $val['order_number']; 
                } 

                 $order_number = $val['merchant_id'] . '-' . $val['order_number']; 
        
          if($val['is_phone_order']==1){
            
            $val['client_name']=$val['client_names'];
            
          }
        
        
        if($val['is_phone_order']==1 && $val['trans_type']=='pickup'){
            $val['trans_type']='Phone Pickup';
            
          }else if($val['is_phone_order']==1 && $val['trans_type']=='delivery'){
            $val['trans_type']='Phone Delivery';
            
          }     
          if($val['is_retail']==1){$val['trans_type']='Retail';}

                // Prepare table data for each record
                $val['payment_type']=$this->functions->payment_translations($val['trans_type'],$val['payment_type'],$val['is_sop']);
                $feed_data['aaData'][] = [
                    $val['order_id'], $order_number,
                    stripslashes($val['restaurant_name']) . $new,
                    $val['client_name'], $item,
                    $val['trans_type'], $val['payment_type'],
                    $this->functions->formatNumber($val['sub_total']),
                    $this->functions->formatNumber($val['taxable_total']),
                    $this->functions->formatNumber($val['total_w_tax']),
                    "<span class=\"tag " . $val['status'] . "\">" . $val['status'] . "</span><div>$action</div>",
                    $val['request_from'], $date_created
                ];
            }

            // Output the data in DataTable format
            $this->otableOutput($feed_data);
        }
    }
    
    // If no data found, return no data message
    $this->otableNodata();
}   



public function AllOrdersMerchant()
{
    // Get merchant_id as an integer
    $merchant_id = (int)$this->functions->getMerchantID();
    
    if ($merchant_id > 0) {
        $aColumns = [
            'a.order_id', 'a.merchant_id', 'c.first_name', 'json_details', 'trans_type', 
            'payment_type', 'sub_total', 'taxable_total', 'total_w_tax', 'a.status', 
            'request_from', 'a.date_created'
        ];          
        $sWhere = ''; 
        $sOrder = ''; 
        $sLimit = '';

        // Get the Datatable query params
        $t = $this->functions->ajaxDataTables($aColumns);
        if (is_array($t) && count($t) >= 1) {
            $sWhere = $t['sWhere'];
            $sOrder = $t['sOrder'];
            $sLimit = $t['sLimit'];
            $sWhere = str_replace("WHERE", "AND", $sWhere);
        }   

        $where = " WHERE a.merchant_id = :merchant_id ";

        if (!empty($sWhere)) {
            $sWhere .= " AND a.status NOT IN ('initial_order')";
        } else {
            $sWhere .= " AND a.status NOT IN ('initial_order')";
        }

        $select = ''; // Add any additional selects if necessary
        
        // Prepare SQL query
        $sql = "
            SELECT SQL_CALC_FOUND_ROWS 
            a.order_id, trans_type, payment_type, sub_total, taxable_total, total_w_tax, 
            a.status, a.order_number, a.merchant_id, a.date_created, admin_viewed,a.client_names,a.is_phone_order,a.phones,a.is_retail, 
            request_from, b.restaurant_name, 
            CONCAT(c.first_name, ' ', c.last_name) AS client_name, 
            CONCAT(d.first_name, ' ', d.last_name) AS customer_name,
           (
                SELECT CONCAT(first_name, ' ', last_name)
                FROM mt_order_delivery_address
                WHERE order_id = a.order_id
                LIMIT 0,1
            ) AS customer_name
      
            $select
            FROM mt_order a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            LEFT JOIN mt_client c ON a.client_id = c.client_id
            LEFT JOIN mt_order_delivery_address d ON a.order_id = d.order_id
            $where $sWhere $sOrder $sLimit
        ";
        
        // Prepare the statement using PDO
        $stmt = $this->db->prepare($sql);
        // Bind the merchant_id parameter
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        // Execute the query
        $stmt->execute();

        // Fetch results
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $iTotalRecords = 0;               
            $stmtTotal = $this->db->query("SELECT FOUND_ROWS()"); // Get total row count
            if ($resTotal = $stmtTotal->fetch(PDO::FETCH_ASSOC)) {
                $iTotalRecords = $resTotal['FOUND_ROWS()'];
            }

            // Prepare the feed data for output
            $feed_data['sEcho'] = intval($_GET['sEcho']);
            $feed_data['iTotalRecords'] = $iTotalRecords;
            $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

            foreach ($res as $val) {
                $action = '';
          if ($val['request_from'] == "webappv2" || $val['request_from'] == "web") {
        
        
         if(!empty($val['customer_name']) && strlen($val['customer_name'])>1 ){          
          $val['client_name'] = $val['customer_name'];
        }
    
         }
        
        
        
         if($val['request_from']=="pos"){}else{
         $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"edit-order\" href=\"javascript:\">" . $this->functions->translation("default", "Edit") . "</a>";}
                $action .= "<br/><a data-id=\"" . $val['order_id'] . "\" class=\"view-receipt\" href=\"javascript:\">" . $this->functions->translation("default", "View") . "</a>";
                $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"view-order-history\" href=\"javascript:\">" . $this->functions->translation("default", "History") . "</a>";          
               
                // Fetch and translate food items
                $item = $this->functions->translateFoodItemByOrderId($val['order_id']);

                $new = '';
                if ($val['admin_viewed'] <= 0) {
                    $new = " <div class=\"uk-badge\">" . $this->functions->translation("default", "NEW") . "</div>";
                }

                $val['client_name'] = !empty(trim($val['client_name'])) ? $val['client_name'] : 'Guest';

                // Date and time formatting
                $date_created = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);

                // Handle order number formatting based on request source
                $order_number = '-';
                if ($val['request_from'] == "webappv2" && $val['order_number'] > 0) { 
                    $order_number = $val['merchant_id'] . '-' . $val['order_number']; 
                } else if ($val['request_from'] == "pos" && $val['order_number'] > 0) {    
                    $order_number = $val['merchant_id'] . '-' . $val['order_number']; 
                } 

                 $order_number = $val['merchant_id'] . '-' . $val['order_number']; 
        
          if($val['is_phone_order']==1){
            
            $val['client_name']=$val['client_names'];
            
          }
        
        
        if($val['is_phone_order']==1 && $val['trans_type']=='pickup'){
            $val['trans_type']='Phone Pickup';
            
          }else if($val['is_phone_order']==1 && $val['trans_type']=='delivery'){
            $val['trans_type']='Phone Delivery';
            
          }     
          if($val['is_retail']==1){$val['trans_type']='Retail';}

                // Prepare table data for each record
                $val['payment_type']=$this->functions->payment_translations($val['trans_type'],$val['payment_type'],$val['is_sop']);
                $feed_data['aaData'][] = [
                    $val['order_id'], $order_number,
                    stripslashes($val['restaurant_name']) . $new,
                    $val['client_name'], $item,
                    $val['trans_type'], $val['payment_type'],
                    $this->functions->formatNumber($val['sub_total']),
                    $this->functions->formatNumber($val['taxable_total']),
                    $this->functions->formatNumber($val['total_w_tax']),
                    "<span class=\"tag " . $val['status'] . "\">" . $val['status'] . "</span><div>$action</div>",
                    $val['request_from'], $date_created
                ];
            }

            // Output the data in DataTable format
            $this->otableOutput($feed_data);
        }
    }
    
    // If no data found, return no data message
    $this->otableNodata();
}


  public function AddOnItemList()
{
    $aColumns = array('sub_item_id', 'sub_item_name', 'category', 'price', 'photo', 'status', 'date_created');
    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    // Handling ajax data for columns
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }

    $slug = $this->data['slug'];
    $mtid = $this->functions->getMerchantID();

    // Get subcategory list
    $cat_list = $this->functions->getSubcategory();
    $cat = '';

    // Prepare the SQL query
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.* 
        FROM mt_subcategory_item a         
        WHERE
        merchant_id = :merchant_id
        $sWhere
        $sOrder
        $sLimit
    ";

    try {
        // Get the PDO connection
        $connection = $this->db;

        // Prepare the statement
        $query = $connection->prepare($stmt);

        // Bind the merchant ID
        $query->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);

        // Execute the query
        $query->execute();

        // Fetch the rows
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            // Get total records
            $stmt2 = "SELECT FOUND_ROWS()";
            $query2 = $connection->query($stmt2);
            $iTotalRecords = $query2->fetchColumn();

            $feed_data['sEcho'] = intval($_GET['sEcho']);
            $feed_data['iTotalRecords'] = $iTotalRecords;
            $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

            foreach ($rows as $val) {
                $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"$val[sub_item_id]\" class=\"chk_child\" >";
                $option = "<div class=\"options\">
                <a href=\"$slug/id/$val[sub_item_id]\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"delete_item\" data-id=\"$val[sub_item_id]\">" . $this->functions->translation("default", "Delete") . "</a>
                </div>";
                $date = $this->functions->FormatDateTime($val['date_created']);
                
                if (!empty($val['category'])) {
                    $category = json_decode($val['category']);
                    if (is_array($category) && count($category) >= 1) {
                        foreach ($category as $cat_id) {
                            $cat .= $cat_list[$cat_id] . ",";
                        }
                        $cat = substr($cat, 0, -1);
                    }
                }

                $photo = '';
                if (!empty($val['photo'])) {
                    $img = Config::$baseUrl . "/upload/$val[photo]";
                    $photo = "<img src=\"$img\" class=\"uk-thumbnail uk-thumbnail-mini\" >";
                }

                $price = $this->functions->formatNumber($val['price']);

                $feed_data['aaData'][] = array(
                    $chk,
                    $val['sub_item_name'] . $option,
                    $val['item_description'],
                    $cat,
                    $price,
                    $photo,
                    "$date<br/><span class=\"tag " . $val['status'] . "\">" . $val['status'] . "</span>"
                );
                $cat = '';
            }

            $this->otableOutput($feed_data);
        } else {
            $this->otableNodata();
        }
    } catch (Exception $e) {
        throw new Exception("Error retrieving addon item list: " . $e->getMessage());
    }
}





public function smsPurchaseTransaction()
{
    $merchant_id = $this->functions->getMerchantID();
    $slug = $this->data['slug'];

    // Prepare the SQL statement with placeholders to prevent SQL injection
    $stmt = "
    SELECT a.*,
    (
        SELECT title
        FROM mt_sms_package
        WHERE sms_package_id = a.sms_package_id
    ) as package_name
    FROM mt_sms_package_trans a
    WHERE merchant_id = :merchant_id
    ORDER BY id DESC
    ";

    // Prepare and execute the statement using PDO
    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();

    // Fetch the result set as an associative array
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $feed_data = ['aaData' => []];
        foreach ($res as $val) {
            // Format the date using the custom function
            $date = $this->functions->FormatDateTime($val['date_created']);

            // Prepare each row of the result set
            $feed_data['aaData'][] = array(
                $val['id'],
                // Format payment type
                $this->functions->prettyPaymentType('sms_package_trans', $val['payment_type'], $val['id']),
                ucfirst($val['package_name']),
                // Format and display the price
                $this->functions->displayPrice($this->functions->adminCurrencySymbol(), $this->functions->normalPrettyPrice($val['package_price'])),
                $val['sms_limit'],
                $val['status'],
                $date
            );
        }
        // Output the table data
        $this->otableOutput($feed_data);
    } else {
        // Output no data if nothing was returned
        $this->otableNodata();
    }
}



 public function salesSummaryReport()
{           
    $aColumns = array(
        'item_id', 'item_name', 'size', 'discounted_price', 'total_qty', 'discounted_price'
    );

    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';

    // Assuming $this->functions->ajaxDataTables() processes the table filters and sorting
    $t = $this->functions->ajaxDataTables($aColumns);

    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    unset($_SESSION['rpt_date_range']);
    $and = '';  

    // Handle date range filtering
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $start_date = $this->data['start_date'] . " 00:00:00";
            $end_date = $this->data['end_date'] . " 23:59:59";
            $and = " AND date_created BETWEEN '$start_date' AND '$end_date'";
            $_SESSION['rpt_date_range'] = array(
                'start_date' => $this->data['start_date'],
                'end_date' => $this->data['end_date']
            );
        }
    }

    // Handle order status filtering
    $order_status_id = '';
    if (isset($this->data['stats_id']) && is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
        $order_status_id = implode("','", $this->data['stats_id']);
        if (!empty($order_status_id)) {
            $and .= " AND status IN ('$order_status_id')";
        }
    }

    // Get merchant ID
    $merchant_id = $this->functions->getMerchantID();

    // Prepare the SQL query
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS SUM(a.qty) as total_qty,
        a.item_id, a.item_name, a.discounted_price, a.size
        FROM mt_view_order_details a
        WHERE merchant_id = $merchant_id
        AND status NOT IN ('initial_order')
        $and
        GROUP BY item_id, size
        $sOrder
        $sLimit
    ";

    // Store the query for exporting, excluding the LIMIT clause
    $pos = strpos($stmt, "LIMIT");
    $_SESSION['kr_export_stmt'] = substr($stmt, 0, $pos);

    // Execute the query directly
    $query = $this->db->query($stmt);
    
    // Fetch the result set
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $iTotalRecords = 0;
        // Fetch total record count
        $stmt2 = "SELECT FOUND_ROWS()";
        $query2 = $this->db->query($stmt2);
        $res2 = $query2->fetch(PDO::FETCH_ASSOC);
        if ($res2) {
            $iTotalRecords = $res2['FOUND_ROWS()'];
        }

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        // Prepare the response data
        foreach ($res as $val) {
            $feed_data['aaData'][] = array(
                $val['item_id'],
                $val['item_name'],
                $val['size'],
                $this->functions->formatNumber($val['discounted_price']),
                $val['total_qty'],
                $this->functions->formatNumber((float)$val['discounted_price'] * (float)$val['total_qty'])
            );
        }

        // Output the table data
        $this->otableOutput($feed_data);
    } else {
        // No data found, output empty table message
        $this->otableNodata();
    }
}







public function bookingSummaryReport()
{
    $aColumns = array('total_approved', 'total_denied', 'total_pending');
    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';

    // Handle DataTables inputs
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Get merchant ID directly (no binding)
    $merchant_id = $this->functions->getMerchantID();

    $and = '';  
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $start_date = $this->data['start_date'] . ' 00:00:00';
            $end_date = $this->data['end_date'] . ' 23:59:00';
            $and = " AND date_created BETWEEN '$start_date' AND '$end_date'";
            $_SESSION['rpt_date_range'] = array(
                'start_date' => $this->data['start_date'],
                'end_date' => $this->data['end_date']
            );
        }
    }

    // SQL query with direct variables
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS SUM(a.number_guest) AS total_approved,
        (
            SELECT SUM(number_guest)
            FROM mt_bookingtable
            WHERE merchant_id = $merchant_id AND status = 'denied'
        ) AS total_denied,
        (
            SELECT SUM(number_guest)
            FROM mt_bookingtable
            WHERE merchant_id = $merchant_id AND status = 'pending'
        ) AS total_pending
        FROM mt_bookingtable a
        WHERE merchant_id = $merchant_id AND status = 'approved'
        $and
        $sOrder
        $sLimit
    ";

    // Store query for export functionality
    $pos = strpos($stmt, "LIMIT");
    if ($pos !== false) {
        $_SESSION['kr_export_stmt'] = $stmt;
    } else {
        $_SESSION['kr_export_stmt'] = $stmt;
    }

    // Execute the query directly (without binding)
    $query = $this->db->query($stmt);

    // Handle result
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $iTotalRecords = 0;
        $stmt2 = $this->db->query("SELECT FOUND_ROWS()");
        if ($res2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
            $iTotalRecords = $res2['FOUND_ROWS()'];
        }

        // Prepare data for DataTables output
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $feed_data['aaData'][] = array(
                $val['total_approved'] + 0,
                $val['total_denied'] + 0,
                $val['total_pending'] + 0
            );
        }

        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}









public function ingredientsList()
{
    $aColumns = array('ingredients_id', 'ingredients_name', 'status');
    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';

    // Assuming $this->functions->ajaxDataTables() returns required query parts
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }

    $slug = $this->data['slug'];
    
    // Prepare the SQL query
    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS * FROM mt_ingredients
    WHERE merchant_id = :merchant_id
    $sWhere
    $sOrder
    $sLimit
    ";

    try {
        // Prepare the statement
        $query = $this->db->prepare($stmt);
        
        // Bind the merchant ID
        $merchant_id = $this->functions->getMerchantID();
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

        // Execute the query
        $query->execute();

        // Fetch all rows
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        if (is_array($rows) && count($rows) >= 1) {
            // Get the total records
            $stmt2 = "SELECT FOUND_ROWS()";
            $query2 = $this->db->prepare($stmt2);
            $query2->execute();
            $iTotalRecords = $query2->fetchColumn();

            // Prepare the data for the response
            $feed_data['sEcho'] = intval($_GET['sEcho']);
            $feed_data['iTotalRecords'] = $iTotalRecords;
            $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

            // Loop through the results and format them
            foreach ($rows as $val) {
                $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"$val[ingredients_id]\" class=\"chk_child\" >";
                $option = "<div class=\"options\">
                            <a href=\"$slug/id/$val[ingredients_id]\" >" . $this->functions->translation("default", "Edit") . "</a>
                            <a href=\"javascript:;\" class=\"delete_item\" data-id=\"$val[ingredients_id]\" >" . $this->functions->translation("default", "Delete") . "</a>
                           </div>";
                $date = $this->functions->FormatDateTime($val['date_created']);

                $feed_data['aaData'][] = array(
                    $chk,
                    $val['ingredients_name'] . $option,
                    "$date<br/><span class=\"tag " . $val['status'] . "\">" . ($val['status']) . "</span>"
                );
            }

            // Output the table data
            $this->otableOutput($feed_data);
        } else {
            // No data found
            $this->otableNodata();
        }
    } catch (PDOException $e) {
        // Handle any exceptions
        echo "Error: " . $e->getMessage();
        return false;
    }
}


public function UpdateItemAvailable()
    {       
        if (isset($this->data['item_id'])){
            $params=array('not_available'=>$this->data['checked']==1?2:1);
            
            //print_r($params);die();
             

            if ( $this->functions->updateData("mt_item", $params, 'item_id', $this->data['item_id'])){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");
            } else $this->msg=$this->functions->translation("default","ERROR: cannot update records.");
        } else $this->msg=$this->functions->translation("default","Missing parameters");
    }
    
    public function UpdateCatPosAvailable()
    {       
        if (isset($this->data['cat_id'])){
            $params=array('pos_available'=>$this->data['checked']==1?2:1);
            
            //print_r($params);die();
             

            if ( $this->functions->updateData("mt_category", $params, 'cat_id', $this->data['cat_id'])){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");
            } else $this->msg=$this->functions->translation("default","ERROR: cannot update records.");
        } else $this->msg=$this->functions->translation("default","Missing parameters");
    }
    
     public function UpdateCatWebAvailable()
    {       
        if (isset($this->data['cat_id'])){
            $params=array('web_available'=>$this->data['checked']==1?2:1);
            
            //print_r($params);die();
             

            if ( $this->functions->updateData("mt_category", $params, 'cat_id', $this->data['cat_id'])){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");
            } else $this->msg=$this->functions->translation("default","ERROR: cannot update records.");
        } else $this->msg=$this->functions->translation("default","Missing parameters");
    }
    


    public function UpdateSlotsAvailable()
    {       
        if (isset($this->data['id'])){
            $params=array('available'=>$this->data['checked']==1?1:0);
            
            //print_r($params);die();
             

            if ( $this->functions->updateData("mt_booking_slots_child", $params, 'id', $this->data['id'])){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");
            } else $this->msg=$this->functions->translation("default","ERROR: cannot update records.");
        } else $this->msg=$this->functions->translation("default","Missing parameters");
    }








    public function AddIngredients()
    {
      $params=array(
          'ingredients_name'=>$this->data['ingredients_name'],
          'status'=>addslashes($this->data['status']),
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'merchant_id'=>$this->functions->getMerchantID()
        );                              

        if (isset($this->data['ingredients_name_trans'])){
            if ($this->functions->okToDecode()){
                $params['ingredients_name_trans']=json_encode($this->data['ingredients_name_trans'],
                JSON_UNESCAPED_UNICODE);
            } else $params['ingredients_name_trans']=json_encode($this->data['ingredients_name_trans']);
        }
        
        $ingredients_id = 0;
        
            
        
        if (isset($this->data['id']) && is_numeric($this->data['id'])){             
            unset($params['date_created']);
            $params['date_modified']=$this->functions->dateNow();                
            

            $res = $this->functions->updateData("mt_ingredients", $params, 'ingredients_id', $this->data['id']);

            if ($res){
                $this->code=1;
                $this->msg=$this->functions->translation("default",'ingredients updated');  
                $ingredients_id = $this->data['id'];
                              
            } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
        } else {  
            $last_insert_id = $this->functions->insertData('mt_ingredients', $params);
            if ($last_insert_id!== false){                
            
                $this->details=$last_insert_id;   
                $this->code=1;
                $this->msg=$this->functions->translation("default",'ingredients added'); 
                $ingredients_id = $this->details;
            } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
        }       

            
        
    }


    public function FoodItemAdd()
        {           
            
            $mtid=$this->functions->getMerchantID();
            if (!$this->functions->validateMerchantCanPost($mtid) ){
                if (isset($this->data['id']) && is_numeric($this->data['id'])){             
                } else {    
                   $this->msg=$this->functions->translation("default","Sorry but you reach the limit of adding food item. Please upgrade your membership");
                   return ;
                }
            }       
            
            if (isset($this->data['id']) && is_numeric($this->data['id'])){
            if (isset($this->data['barcode']) && !empty($this->data['barcode'])){
            if($barcodedata=$this->functions->checkifbarcodeexistwithitem($this->data['barcode'],$mtid,$this->data['id'])){
                    $this->msg=$this->functions->translation("default","Sorry but this barcode is already used!");
                   return ;
                }                       
            }
            }else{
                if (isset($this->data['barcode']) && !empty($this->data['barcode'])){
                if($barcodedata=$this->functions->checkifbarcodeexist($this->data['barcode'],$mtid)){
                    $this->msg=$this->functions->translation("default","Sorry but this barcode is already used!");
                   return ;
                }   
                }
                
            }
            
            $price=array();
      $price_dinein=array();
      
            if (isset($this->data['price']) && count($this->data['price'])>=1){
                foreach ($this->data['price'] as $key=>$val) {
                    if (!empty($val)){
                       $price[$this->data['size'][$key]]=$val;
                      
                    }
                }               
            }
      
      if (isset($this->data['price_dinein']) && count($this->data['price_dinein'])>=1){
          foreach ($this->data['price_dinein'] as $key=>$val) {
            if (!empty($val)){  
               $price_dinein[$this->data['size'][$key]]=$val;

           if($price[$key]>0){}else{
            // $price[$this->data['size'][$key]]=$val;
             }
             
            }
          }         
        }
      
      
        foreach ($price as $key => $value) {
    if (!isset($price_dinein[$key])) {
        $price_dinein[$key] = $value;
    }
}

foreach ($price_dinein as $key => $value) {
    if (!isset($price[$key])) {
        $price[$key] = $value;
    }
}
      
      

            $quantity=array();
            if (isset($this->data['quantity']) && count($this->data['quantity'])>=1){
                foreach ($this->data['quantity'] as $key=>$val) {
                    if (!empty($val)){
                       $quantity[$key]=$val;
                      
                    }
                }               
            }
            
                                
            
                    
            $params=array(            
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'merchant_id'=>$this->functions->getMerchantID(),
              'item_name'=>isset($this->data['item_name'])?($this->data['item_name']):"",
              'item_description'=>isset($this->data['item_description'])?($this->data['item_description']):'',
              'status'=>$this->data['status'],
              'category'=>isset($this->data['category'])?json_encode($this->data['category']):"",
              'price'=>isset($price)?json_encode($price):'',
        'price_dinein'=>isset($price_dinein)?json_encode($price_dinein):'',
              'quantity'=>isset($quantity)?json_encode($quantity):'',
              
              'addon_item'=>isset($this->data['sub_item_id'])?json_encode($this->data['sub_item_id']):"",
              'cooking_ref'=>isset($this->data['cooking_ref'])?json_encode($this->data['cooking_ref']):"",
              'discount'=>isset($this->data['discount'])?$this->data['discount']:"",
              'multi_option'=>isset($this->data['multi_option'])?json_encode($this->data['multi_option']):"",
              'multi_option_value'=>isset($this->data['multi_option_value'])?json_encode($this->data['multi_option_value']):"",
              'photo'=>isset($this->data['photo'])?$this->data['photo']:"",
              'ingredients'=>isset($this->data['ingredients'])?json_encode($this->data['ingredients']):"",
              'spicydish'=>isset($this->data['spicydish'])?$this->data['spicydish']:"0",
              'two_flavors'=>isset($this->data['two_flavors'])?$this->data['two_flavors']:'0',
              'two_flavors_position'=>isset($this->data['two_flavors_position'])?json_encode($this->data['two_flavors_position']):"",
              'require_addon'=>isset($this->data['require_addon'])?json_encode($this->data['require_addon']):"",
              'dish'=>isset($this->data['dish'])?json_encode($this->data['dish']):'',
              'non_taxable'=>isset($this->data['non_taxable'])?$this->data['non_taxable']:1,
              'gallery_photo'=>isset($this->data['gallery_photo'])?json_encode($this->data['gallery_photo']):"",
              'packaging_fee'=>isset($this->data['packaging_fee'])?$this->data['packaging_fee']:0,
              'packaging_incremental'=>isset($this->data['packaging_incremental'])?$this->data['packaging_incremental']:0,
              'item_token'=>$this->functions->generateFoodToken(),
              
              'is_variable_price'=>isset($this->data['is_variable_price'])?$this->data['is_variable_price']:1,
              
              'barcode'=>isset($this->data['barcode'])?$this->data['barcode']:'',
            );  


            
            if(!is_numeric($params['packaging_fee'])){
                $params['packaging_fee']=0;
            }
            if(!is_numeric($params['packaging_incremental'])){
                $params['packaging_incremental']=0;
            }
       
                        
            if (isset($this->data['item_name_trans'])){
                if ($this->functions->okToDecode()){
                    $params['item_name_trans']=json_encode($this->data['item_name_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['item_name_trans']=json_encode($this->data['item_name_trans']);
            }       
            if (isset($this->data['item_description_trans'])){
                if ($this->functions->okToDecode()){
                   $params['item_description_trans']=json_encode($this->data['item_description_trans'],
                   JSON_UNESCAPED_UNICODE);
                } else $params['item_description_trans']=json_encode($this->data['item_description_trans']);
            }       
            
            
                        
            
            $item_id = 0;
                        
            
            
            if (isset($this->data['id']) && is_numeric($this->data['id'])){     
                
                $file_to_delete=array();
                $item_id = (integer) $this->data['id'];
                
                if($old_data=$this->functions->getFoodItem($this->data['id'])){
                    
                    if(isset($old_data['item_token'])){
                       if(!empty($old_data['item_token'])){
                          unset($params['item_token']);
                       }                    
                    }               
                    
                    $gallery_photo=json_decode($old_data['gallery_photo'],true);
                    
                    if(!isset($this->data['gallery_photo'])){
                        $this->data['gallery_photo']='';
                    }
                    
                    if(isset($this->data['photo'])){
                        if ($this->data['photo']!=$old_data['photo']){
                            $file_to_delete[]=$old_data['photo'];
                        }
                    }
                
                    if(is_array($gallery_photo) && count($gallery_photo)>=1){
                        foreach ($gallery_photo as $val) {                          
                            if(!in_array($val,(array)$this->data['gallery_photo'])){                                
                                $file_to_delete[]=$val;
                            }                   
                        }
                    }
                }           
                
                //dump($this->data);
                /*dump($file_to_delete);
                die();*/
                        
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();                
                
                
                

                $res = $this->functions->updateData("mt_item", $params, 'item_id', $this->data['id']);

                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Item updated.');  
                    
                   
                    
                    $this->functions->insertItemRelationship(
                        $this->functions->getMerchantID(),
                        (integer)$this->data['id'],
                        isset($this->data['category'])?(array)$this->data['category']:''
                    );
                                        
                   $this->functions->insertItemRelationshipSubcategory(
                        $this->functions->getMerchantID(),
                        (integer)$this->data['id'],
                        isset($this->data['sub_item_id'])?(array)$this->data['sub_item_id']:''
                    );


//+++waseem code
$item_id = $this->data['id'];
$mtid = $this->functions->getMerchantID();  // Fetch merchant ID properly

// Use parameter binding to prevent SQL injection
$stmt = $this->db->prepare("
    SELECT * FROM mt_item_relationship_size
    WHERE merchant_id = :mtid AND item_id = :item_id
");

// Execute query with parameters
$stmt->bindParam(':mtid', $mtid, PDO::PARAM_INT);
$stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
$stmt->execute();
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);  // Fetch all results

if ($results) {
    $last_entry = end($results);  // Get the last element of the array
    // Access the SKU column from the last entry
    $last_sku = $last_entry['sku'];  // Assuming 'sku' is the column name

    // If SKU contains a '-', split it and take the second part
    if (strpos($last_sku, '-') !== false) {
        $parts = explode('-', $last_sku);
        $last_sku = isset($parts[1]) ? $parts[1] : $last_sku; // Take the second part after the dash
    }
} else {
    // If no results found, set default SKU or handle as needed
    $last_sku = 'default_sku';
}

$this->functions->insertItemRelatinship(
    $mtid,  // Pass the merchant_id
    (integer)$this->data['id'],  // Pass the item_id
    array(
        'size' => isset($this->data['size']) ? (array)$this->data['size'] : '',  // Pass the sizes
        'price' => isset($this->data['price']) ? (array)$this->data['price'] : '',  // Pass the prices
        'results' => $results,  // Pass the results (from the query)
        'last_sku' => $last_sku  // Pass the last SKU
    )
);

//---waseem code 




                    
                    /*$this->functions->insertItemRelatinship(
                      $this->functions->getMerchantID(),
                      (integer)$this->data['id'],
                      array(
                       'size'=>isset($this->data['size'])?(array)$this->data['size']:'',
                       'price'=>isset($this->data['price'])?(array)$this->data['price']:''
                      )                   
                    );*/
                                        
                    $merchant_id = (integer)$this->functions->getMerchantID();
                    
                    $this->functions->insertMeta( 
                      $merchant_id,
                      (integer)$this->data['id'],'cooking_ref',
                      isset($this->data['cooking_ref'])?(array)$this->data['cooking_ref']:''
                    );
                    
                    $this->functions->insertMeta( 
                      $merchant_id,
                      (integer)$this->data['id'],'ingredients',
                      isset($this->data['ingredients'])?(array)$this->data['ingredients']:''
                    );
                    
                    $this->functions->insertMeta( 
                      $merchant_id,
                      (integer)$this->data['id'],'dish',
                      isset($this->data['dish'])?(array)$this->data['dish']:''
                    );
                                                        
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else { 
                $last_insert_id = $this->functions->insertData('mt_item', $params);
                if ($last_insert_id!== false){                                  
                
                    $item_id = $last_insert_id;
                    $this->details = $item_id;
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Item added.');            
                    
                    
                    $this->functions->insertItemRelationship(
                        $this->functions->getMerchantID(),
                        (integer)$item_id,
                        isset($this->data['category'])?(array)$this->data['category']:''
                    );
                    
                    $this->functions->insertItemRelationshipSubcategory(
                        $this->functions->getMerchantID(),
                        (integer)$item_id,
                        isset($this->data['sub_item_id'])?(array)$this->data['sub_item_id']:''
                    );
                    
                    $this->functions->insertItemRelatinship_addscenario(
                      $this->functions->getMerchantID(),
                      (integer)$item_id,
                      array(
                       'size'=>isset($this->data['size'])?(array)$this->data['size']:'',
                       'price'=>isset($this->data['price'])?(array)$this->data['price']:''
                      )                   
                    );
                    
                    $merchant_id = (integer)$this->functions->getMerchantID();
                    
                     $this->functions->insertMeta( 
                       $merchant_id,
                      (integer)$item_id,'cooking_ref',
                      isset($this->data['cooking_ref'])?(array)$this->data['cooking_ref']:''
                    );
                    
                    $this->functions->insertMeta( 
                      $merchant_id, 
                      (integer)$item_id,'ingredients',
                      isset($this->data['ingredients'])?(array)$this->data['ingredients']:''
                    );
                    
                    $this->functions->insertMeta( 
                      $merchant_id,
                      (integer)$item_id,'dish',
                      isset($this->data['dish'])?(array)$this->data['dish']:''
                    );
                             
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }                       
            
             
            
        }


     public function CookingRefList()
{
    $aColumns = array('cook_id', 'cooking_name', 'date_created');
    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';
    
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }

    $slug = $this->data['slug'];

    // Prepare the main SQL statement
    $stmt = $this->db->prepare("
        SELECT SQL_CALC_FOUND_ROWS * FROM mt_cooking_ref
        WHERE merchant_id = :merchant_id
        $sWhere
        $sOrder
        $sLimit
    ");

    // Bind the merchant_id parameter
    $merchant_id = $this->functions->getMerchantID();
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the statement
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        // Prepare to get the total records
        $stmt2 = $this->db->query("SELECT FOUND_ROWS()");
        $iTotalRecords = $stmt2->fetchColumn();

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($rows as $val) {
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"$val[cook_id]\" class=\"chk_child\">";
            $option = "<div class=\"options\">
                <a href=\"$slug/id/$val[cook_id]\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"delete_item\" data-id=\"$val[cook_id]\">" . $this->functions->translation("default", "Delete") . "</a>
            </div>";

            $date = $this->functions->FormatDateTime($val['date_created']);
            $feed_data['aaData'][] = array(
                $chk, $val['cooking_name'] . $option,
                $date
            );
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


    public function MerchantInvoiceList()
{
    $aColumns = array(
        'invoice_number', 'merchant_name', 'invoice_terms',
        'invoice_total', 'date_from', 'status', 'pdf_filename'
    );

    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    $sTable = "mt_invoice";

    // Assuming this is some custom function that returns the search, order, and limit clauses
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sWhere = str_replace("WHERE", 'AND', $sWhere);
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Building the SQL query
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*
        FROM $sTable a
        WHERE merchant_id = :merchant_id
        $sWhere
        $sOrder
        $sLimit
    ";

    // For debugging purposes
    if (isset($_GET['debug'])) {
        dump($stmt);
    }

    try {
        // Assuming $this->db is the PDO connection
        $connection = $this->db;

        // Preparing the SQL query
        $query = $connection->prepare($stmt);

        // Binding parameters
        $query->bindParam(':merchant_id', $this->data['merchant_id'], PDO::PARAM_INT);

        // Executing the query
        $query->execute();

        // Fetching the results
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            // Get the total records count
            $iTotalRecords = 0;
            $stmt2 = "SELECT FOUND_ROWS()";
            $query2 = $connection->query($stmt2);
            $res2 = $query2->fetch(PDO::FETCH_ASSOC);
            if ($res2) {
                $iTotalRecords = $res2['FOUND_ROWS()'];
            }

            // Building the response data
            $feed_data['sEcho'] = intval($_GET['sEcho']);
            $feed_data['iTotalRecords'] = $iTotalRecords;
            $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

            foreach ($res as $val) {
                if (isset($_GET['debug'])) {
                    dump($val);
                }

                $action = '';
                if (!empty($val['pdf_filename']) && $val['pdf_filename'] != ".pdf") {
                    //$link = Config::$baseUrl . "merchant/viewinvoice";

                    $link=$this->functions->uploadURL()."/invoice/".$val['pdf_filename'];
                    $action = "<a href=\"$link\" target=\"_blank\">" . $this->functions->translation("default", "View") . "</a>";
                }

                $new = '';
                if ($val['viewed'] == 2 || $val['viewed'] == "") {
                    $new = '<span class="tag new">' . $this->functions->translation("default", "NEW") . '</span>';
                }

                $date_created = $this->functions->prettyDate($val['date_created']);
                $date_created .= " " . $this->functions->prettyTime($val['date_created']);

                $feed_data['aaData'][] = array(
                    $val['invoice_number'],
                    stripslashes($val['merchant_name']) . "<br/>" . $new,
                    $this->functions->prettyInvoiceTerms($val['invoice_terms']),
                    $this->functions->prettyDate($val['date_from']) . " - " . $this->functions->prettyDate($val['date_to']),
                    $this->functions->formatNumber($val['invoice_total']),
                    $date_created . "<br/><span class=\"tag $val[payment_status]\">" . ($val['payment_status']) . "</span>",
                    $action
                );
            }

            // Output the data
            $this->otableOutput($feed_data);
        }
    } catch (PDOException $e) {
        // Handle any errors
        echo "Database error: " . $e->getMessage();
    }

    // If no data found
    $this->otableNodata();
}



public function shippingRates()
{       
    $mtid = $this->functions->getMerchantID();   
    $this->functions->updateOption("shipping_enabled", isset($this->data['shipping_enabled']) ? $this->data['shipping_enabled'] : '', $mtid);
    $this->functions->updateOption("free_delivery_above_price", isset($this->data['free_delivery_above_price']) ? $this->data['free_delivery_above_price'] : '', $mtid);
    
    if (is_array($this->data['distance_from']) && count($this->data['distance_from']) >= 1) {          
        $x = 0;

        // Use prepared statements for deletion
        $stmt = $this->db->prepare("DELETE FROM mt_shipping_rate WHERE merchant_id = :merchant_id");
        $stmt->execute([':merchant_id' => $mtid]);

        foreach ($this->data['distance_from'] as $val) {                        
            $params = [
                'merchant_id' => $mtid,
                'distance_from' => is_numeric($val) ? $val : 0,
                'distance_to' => is_numeric($this->data['distance_to'][$x]) ? $this->data['distance_to'][$x] : 0,
                'shipping_units' => $this->data['shipping_units'][$x],
                'distance_price' => is_numeric($this->data['distance_price'][$x]) ? $this->data['distance_price'][$x] : 0,
            ];

            // Use prepared statements for insertion
            $insertStmt = $this->db->prepare("INSERT INTO mt_shipping_rate (merchant_id, distance_from, distance_to, shipping_units, distance_price) VALUES (:merchant_id, :distance_from, :distance_to, :shipping_units, :distance_price)");
            $insertStmt->execute($params);

            $x++;
        }
    }   
    
    $this->code = 1;
    $this->msg = $this->functions->translation("default", "Setting saved");
}


public function minTableRates()
{
    $mtid = $this->functions->getMerchantID();
    
    // Update min_tables_enabled option
    $this->functions->updateOption("min_tables_enabled",
        isset($this->data['min_tables_enabled']) ? $this->data['min_tables_enabled'] : '', $mtid);

    if (is_array($this->data['distance_from']) && count($this->data['distance_from']) >= 1) {
        $x = 0;
        
        // Prepare the DELETE statement
        $stmt = $this->db->prepare("DELETE FROM mt_minimum_table WHERE merchant_id = :merchant_id");
        $stmt->bindValue(':merchant_id', $mtid, PDO::PARAM_INT);
        $stmt->execute();

        // Prepare the INSERT statement
        $insertStmt = $this->db->prepare("INSERT INTO mt_minimum_table (merchant_id, distance_from, distance_to, shipping_units, min_order) VALUES (:merchant_id, :distance_from, :distance_to, :shipping_units, :min_order)");

        foreach ($this->data['distance_from'] as $val) {
            $params = array(
                'merchant_id' => $mtid,
                'distance_from' => is_numeric($val) ? $val : 0,
                'distance_to' => is_numeric($this->data['distance_to'][$x]) ? $this->data['distance_to'][$x] : 0,
                'shipping_units' => $this->data['shipping_units'][$x],
                'min_order' => is_numeric($this->data['min_order'][$x]) ? $this->data['min_order'][$x] : 0,
            );

            // Bind parameters for the insert statement
            $insertStmt->bindValue(':merchant_id', $params['merchant_id'], PDO::PARAM_INT);
            $insertStmt->bindValue(':distance_from', $params['distance_from'], PDO::PARAM_STR);
            $insertStmt->bindValue(':distance_to', $params['distance_to'], PDO::PARAM_STR);
            $insertStmt->bindValue(':shipping_units', $params['shipping_units'], PDO::PARAM_STR);
            $insertStmt->bindValue(':min_order', $params['min_order'], PDO::PARAM_STR);

            // Execute the insert statement
            $insertStmt->execute();
            $x++;
        }
    }

    $this->code = 1;
    $this->msg = $this->functions->translation("default", "Setting saved");
}


 public function addOffers()
        {
            $merchant_id=$this->functions->getMerchantID();
            $params=array(
              'offer_percentage'=>$this->data['offer_percentage'],            
              'offer_price'=>$this->data['offer_price'],
              'valid_from'=>$this->data['valid_from'],
              'valid_to'=>$this->data['valid_to'],
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'merchant_id'=>$merchant_id,
              'status'=>$this->data['status'],
              'applicable_to'=>isset($this->data['applicable_to'])?json_encode($this->data['applicable_to']):''
            );
            
            if (isset($_POST['offer_image']) && empty($_POST['offer_image'])) {
                $params['offer_image'] = '';  // clear existing image filename in DB
            } else if (isset($_POST['offer_image'])) {
                $params['offer_image'] = $_POST['offer_image'];
            }
            
            /*dump($this->data);
            dump($params);          
            die();*/
                    
            
            if (isset($this->data['id']) && is_numeric($this->data['id'])){ 
                
                if (!$this->functions->getMerchantOffers($merchant_id,
                $this->data['valid_from']." 00:00:00",$this->data['valid_to']." 00:00:00",
                $params['applicable_to'],
                $this->data['id'])){
                
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();   

                

                $res = $this->functions->updateData("mt_offers", $params, 'offers_id', $this->data['id']);

                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Offers updated');  
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
                } else $this->msg=$this->functions->translation("default","Already one offer is their in particular period of time.please delete or change the status to draft that offer then you can add another One offer");
            } else {                            
                if (!$this->functions->getMerchantOffers($merchant_id,$this->data['valid_from']." 00:00:00",
                $this->data['valid_to']." 00:00:00", $params['applicable_to']  )){
                    $last_insert_id = $this->functions->insertData('mt_offers', $params);
                    if ($last_insert_id!== false){ 
                        $this->details=$last_insert_id;   
                        $this->code=1;
                        $this->msg=$this->functions->translation("default",'Offers added');                    
                    } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
                } else $this->msg=$this->functions->translation("default","Already one offer is their in particular period of time.please delete or change the status to draft that offer then you can add another One offer");
            }           
        }


        public function gallerySettings()
        {           
            $merchant_id=$this->functions->getMerchantID();
            
            $old_data=$this->functions->getOption('merchant_gallery',$merchant_id);
            if(!empty($old_data)){
                $old_data=json_decode($old_data,true);
            }       
            
                               
            /*if(is_array($this->data['photo']) && count($this->data['photo'])>=1){            
               $count = count($this->data['photo']);               
               if($count>5){                
                   $this->msg=t("You can only upload 5 images");
                   echo $this->output();
                   Yii::app()->end();
               } 
            }*/     
            
            $this->functions->updateOption("merchant_gallery",
            isset($this->data['photo'])?json_encode($this->data['photo']):''
            ,$merchant_id);
            
            $this->functions->updateOption("gallery_disabled",
            isset($this->data['gallery_disabled'])?$this->data['gallery_disabled']:''
            ,$merchant_id);
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Setting saved");
        }   


            public function BannerSettings()
    {
        $merchant_id=$this->functions->getMerchantID();
        if($merchant_id>=1){
            
            $old_data=$this->functions->getOption('merchant_banner',$merchant_id);
            if(!empty($old_data)){
                $old_data=json_decode($old_data,true);
            }       
            
                    
            
            $this->functions->updateOption("merchant_banner",
            isset($this->data['photo'])?json_encode($this->data['photo']):''
            ,$merchant_id);
            
            $this->functions->updateOption("banner_enabled",
            isset($this->data['banner_enabled'])?$this->data['banner_enabled']:''
            ,$merchant_id);
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Setting saved");
        } else $this->msg = $this->functions->translation("default","invalid merchant id");
    }   




public function merchantOffers()
{
    $class = '';
    $merchant_id = $this->functions->getMerchantID();
    $slug = $this->data['slug'];

    // Prepare the SELECT statement
    $stmt = $this->db->prepare("
        SELECT * FROM mt_offers
        WHERE merchant_id = :merchant_id
        ORDER BY offers_id DESC
    ");
    
    // Bind the merchant_id parameter
    $stmt->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->execute();

    if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        $feed_data = array('aaData' => array());

        foreach ($res as $val) {
            $action = "<div class=\"options\">
                <a href=\"$slug/Do/Add/id/{$val['offers_id']}\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['offers_id']}\">" . $this->functions->translation("default", "Delete") . "</a>
                </div>";

            $date = $this->functions->FormatDateTime($val['date_created']);

            // Handle applicable_to field
            $applicable_to = array();
            $applicable_to_list = '';

            if (isset($val['applicable_to'])) {
                $applicable_to = json_decode($val['applicable_to'], true);
                if (is_array($applicable_to) && count($applicable_to) >= 1) {
                    $applicable_to_list = implode(',', $applicable_to);
                }
            }

            $feed_data['aaData'][] = array(
                $val['offers_id'],
                $this->functions->standardPrettyFormat($val['offer_percentage']) . " %" . $action,
                $this->functions->standardPrettyFormat($val['offer_price']),
                $this->functions->FormatDateTime($val['valid_from'], false),
                $this->functions->FormatDateTime($val['valid_to'], false),
                !empty($applicable_to_list) ? $applicable_to_list : "all",
                "$date<br/><span class=\"tag {$val['status']}\">" . ($val['status']) . "</span>"
            );
        }

        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


 public function merchantCreditCardList()
{
    $merchant_id = $this->functions->getMerchantID();
    if ($merchant_id >= 1) {
        $feed_data = array();

        try {
            // Prepare the main query with placeholders
            $stmt = $this->db->prepare("
                SELECT SQL_CALC_FOUND_ROWS a.*
                FROM mt_merchant_cc a
                WHERE merchant_id = :merchant_id
                ORDER BY mt_id DESC
            ");

            // Bind the merchant ID
            $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

            // Execute the query
            $stmt->execute();

            // Fetch all results
            $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

            if ($res) {
                // Get total records
                $stmt2 = $this->db->query("SELECT FOUND_ROWS()");
                $iTotalRecords = $stmt2->fetchColumn();

                // Populate the feed data
                $feed_data['sEcho'] = intval($_GET['sEcho']);
                $feed_data['iTotalRecords'] = $iTotalRecords;
                $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

                // Loop through each result
                foreach ($res as $val) {
                    $edit_link = Config::$baseUrl . "/merchant/manage_credit_cards/do/add&ids/" . $val['mt_id'];

                    $action = "<div class=\"options\">
                    <a href=\"$edit_link\">" . $this->functions->translation("default", "Edit") . "</a>
                    <a href=\"javascript:;\" class=\"row_del\" rev=\"" . $val['mt_id'] . "\" >" . $this->functions->translation("default", "Delete") . "</a>
                    </div>";

                    $feed_data['aaData'][] = array(
                        $val['mt_id'],
                        $val['card_name'] . $action,
                        $val['credit_card_number'],
                        $this->functions->prettyDate($val['date_created']),
                    );
                }

                // Output the data
                $this->otableOutput($feed_data);
            } else {
                $this->otableNodata();
            }
        } catch (PDOException $e) {
            // Handle error here
            $this->otableNodata();
        }
    } else {
        $this->otableNodata();
    }
}










   public function VoucherListNewxx()
{
    $slug = $this->data['slug'];
    
    if (isset($this->data['voucher_owner'])) {
        $stmt = "
            SELECT a.*,
            (
                SELECT COUNT(*) 
                FROM mt_order
                WHERE voucher_code = a.voucher_name         
            ) AS total_used
            FROM mt_voucher_new a
            WHERE voucher_owner = :voucher_owner
            ORDER BY voucher_id DESC
        ";
        $params = [':voucher_owner' => $this->data['voucher_owner']];
    } else {
        $merchant_id = $this->functions->getMerchantID();
        $stmt = "
            SELECT a.*,
            (
                SELECT COUNT(*) 
                FROM mt_order
                WHERE voucher_code = a.voucher_name         
            ) AS total_used
            FROM mt_voucher_new a
            WHERE merchant_id = :merchant_id
            ORDER BY voucher_id DESC
        ";
        $params = [':merchant_id' => $merchant_id];
    }

    $connection = $this->db; // Assuming $this->db is your PDO instance
    $query = $connection->prepare($stmt);
    $query->execute($params);
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        foreach ($rows as $val) {
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"{$val['voucher_id']}\" class=\"chk_child\" >";
            $action = "<div class=\"options\">
                        <a href=\"$slug/id/{$val['voucher_id']}\">" . $this->functions->translation("default", "Edit") . "</a>
                        <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['voucher_id']}\">" . $this->functions->translation("default", "Delete") . "</a>
                       </div>";

            $used = $val['total_used'] > 0 ? '<a class="voucher-details" href="javascript:;" data-id="' . $val['voucher_name'] . '">' . $val['total_used'] . '</a>' : '';

            $amt = $val['voucher_type'] == "percentage" 
                ? $this->functions->normalPrettyPrice($val['amount']) . " %" 
                : $this->functions->normalPrettyPrice($val['amount']);

            $date = $this->functions->FormatDateTime($val['date_created']);

            $feed_data['aaData'][] = array(
                $val['voucher_id'],
                $val['voucher_name'] . $action,
                $val['voucher_type'],
                $amt,
                $this->functions->FormatDateTime($val['expiration'], false),
                $used,
                "$date<br/><span class=\"tag {$val['status']}\">" . ($val['status']) . "</span>"
            );
        }
        $this->otableOutput($feed_data);
    }
    $this->otableNodata();
}














public function AddUpdateMerchantCC()
    {   
        
        $id = isset($this->data['id'])?$this->data['id']:'';        
        $merchant_id = $this->functions->getMerchantID();
        
        if($merchant_id>=1){
            
            
                        
            $params = array(
              'merchant_id'=>$merchant_id,
              'card_name'=>($this->data['card_name']),
              'credit_card_number'=>$this->functions->maskCardnumber(($this->data['credit_card_number'])),
              'expiration_month'=>$this->data['expiration_month'],
              'expiration_yr'=>$this->data['expiration_yr'],
              'cvv'=>$this->data['cvv'],
              'billing_address'=>($this->data['billing_address']),
              'date_created'=>$this->functions->dateNow()
            );
            
            try {
               $params['encrypted_card']=(($this->data['credit_card_number']));
            } catch (Exception $e) {
                $this->msg = $this->functions->translation("default","Caught exception: [error]",array(
                                '[error]'=>$e->getMessage()
                              ));
                return ;
            }
                        
            if($id>=1){
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();

                if ($this->functions->updateData("mt_merchant_cc", $params, 'mt_id', $id)){
                    $this->code=1;
                    $this->msg=("Successful");
                } else $this->msg=("Failed cannot update records");            
            } else {
                

                $id = $this->functions->insertData('mt_merchant_cc', $params);
                 

                $this->details = array(
                  

                   'redirect'=> Config::$baseUrl . "/merchant/manage_credit_cards/do/add/ids/".$id

                );
                $this->code = 1;
                $this->msg=("Successful");
            }       
            
        } else $this->msg = ("ERROR: Your session has expired.");
    }








  public function AddCookingRef()
        {
            $params=array(
              'cooking_name'=>$this->data['cooking_name'],
              'status'=>addslashes($this->data['status']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'merchant_id'=>$this->functions->getMerchantID()
            );                  

            if (isset($this->data['cooking_name_trans'])){
                if ($this->functions->okToDecode()){
                    $params['cooking_name_trans']=json_encode($this->data['cooking_name_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['cooking_name_trans']=json_encode($this->data['cooking_name_trans']);                
            }       
                    
            
            $cook_id = 0;
            
            
            if (isset($this->data['id']) && is_numeric($this->data['id'])){             
                $cook_id = (integer) $this->data['id'];
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();                
                

                $res = $this->functions->updateData("mt_cooking_ref", $params, 'cook_id', $this->data['id']);

                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Cooking Ref. updated.');  
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else {     
                $last_insert_id = $this->functions->insertData('mt_cooking_ref', $params);
                if ($last_insert_id!== false){               
                
                    $this->details=$last_insert_id;   
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Cooking Ref. added.');                     
                    
                    $cook_id = (integer) $this->details;
                    
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }                       
            
              
            
            
        }


        public function FoodItemList_x()
{                               
    $aColumns = array('item_id', 'item_name', 'item_description', 'category', 'price', 'photo', 'not_available', 'status');
    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';

    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }               

    $cat_list = $this->functions->getCategoryList($this->functions->getMerchantID());
    $size_list = $this->functions->getSizeList($this->functions->getMerchantID());
    
    $mtid = $this->functions->getMerchantID();
    $slug = $this->data['slug'];

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS * FROM mt_item
        WHERE merchant_id = :merchant_id
        $sWhere
        $sOrder
        $sLimit
    ";

    $command = $this->db->prepare($stmt);
    $command->bindValue(':merchant_id', $mtid, PDO::PARAM_INT);
    $command->execute();
    $rows = $command->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        $stmt2 = "SELECT FOUND_ROWS()";
        $command2 = $this->db->prepare($stmt2);
        $command2->execute();
        $res2 = $command2->fetch(PDO::FETCH_ASSOC);
        $iTotalRecords = $res2['FOUND_ROWS()'];

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($rows as $val) {          
            $categories = '';             
            $category = isset($val['category']) ? (array)json_decode($val['category']) : false;                   
            
            if (is_array($category) && count($category) >= 1) {
                foreach ($category as $valcat) {                    
                    if (array_key_exists($valcat, (array)$cat_list)) {
                        $categories .= $cat_list[$valcat] . ", ";
                    }                       
                }
                $categories = !empty($categories) ? substr($categories, 0, -2) : "";
            }               
            
            $price_list = '';

            

            $price = isset($val['price']) ? (array)json_decode($val['price']) : false;


            if (is_array($price) && count($price) >= 1) {
                foreach ($price as $key_price => $val_price) {                    
                    if (array_key_exists($key_price, (array)$size_list)) {                                                 
                        $price_list .= $this->functions->formatNumber($val_price) . " " . ucwords($size_list[$key_price]) . "<br/>";
                    }                   
                }
            }  

            if($price_list==""){
              $price_list=$this->functions->formatNumber($price[0]);
            }          
            
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"$val[item_id]\" class=\"chk_child\">";
            $option = "<div class=\"options\">
                <a href=\"$slug/id/$val[item_id]\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"delete_item\" data-id=\"$val[item_id]\">" . $this->functions->translation("default", "Delete") . "</a>
                </div>";
                                        
            $date = $this->functions->FormatDateTime($val['date_created']);
            
            $photo = !empty($val['photo']) ? "<img class=\"uk-thumbnail uk-thumbnail-mini\" src=\"" . Config::$baseUrl . "/upload/$val[photo]\">" : '';

            $feed_data['aaData'][] = array(
                $chk,
                $val['item_name'] . $option,
                $val['item_description'],
                stripslashes($categories),
                $price_list,
                $photo,
                "",
                '<input type="checkbox" name="food_not_available" class="not_available" id="not_available" value="' . $val['item_id'] . '" ' . ($val['not_available'] == 2 ? 'checked' : '') . '>',
                "$date<br/><span class=\"tag " . $val['status'] . "\">" . ($val['status']) . "</span>"
            );
        }

        $this->otableOutput($feed_data);
    }           
    $this->otableNodata();  
}


public function FoodItemList()
{                               
    $aColumns = array('item_id', 'item_name', 'item_description', 'category', 'price', 'photo', 'available_stocks', 'not_available', 'status');
    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';

    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];

        // Avoid ambiguity by prefixing all mt_item fields with alias `a.`
        $sWhere = str_replace("WHERE", "AND", $sWhere);
        $columnsToFix = ['item_id', 'item_name', 'item_description', 'category', 'price', 'photo', 'not_available', 'status'];
        foreach ($columnsToFix as $col) {
            $sWhere = preg_replace('/\b' . $col . '\b/', 'a.' . $col, $sWhere);
        }
    }               

    $cat_list = $this->functions->getCategoryList($this->functions->getMerchantID());
    $size_list = $this->functions->getSizeList($this->functions->getMerchantID());
    
    $mtid = $this->functions->getMerchantID();
    $slug = $this->data['slug'];

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
            a.*, 
            COALESCE(v.available_stocks, 0) as available_stocks 
        FROM mt_item a
        LEFT JOIN mt_view_item_stocks_status v 
            ON v.item_id = a.item_id AND v.track_stock = 1
        WHERE a.merchant_id = :merchant_id
        $sWhere
        GROUP BY a.item_id
        $sOrder
        $sLimit
    ";

    $command = $this->db->prepare($stmt);
    $command->bindValue(':merchant_id', $mtid, PDO::PARAM_INT);
    $command->execute();
    $rows = $command->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        $stmt2 = "SELECT FOUND_ROWS()";
        $command2 = $this->db->prepare($stmt2);
        $command2->execute();
        $res2 = $command2->fetch(PDO::FETCH_ASSOC);
        $iTotalRecords = $res2['FOUND_ROWS()'];

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($rows as $val) {          
            $categories = '';             
            $category = isset($val['category']) ? (array)json_decode($val['category']) : false;                   
            
            if (is_array($category) && count($category) >= 1) {
                foreach ($category as $valcat) {                    
                    if (array_key_exists($valcat, (array)$cat_list)) {
                        $categories .= $cat_list[$valcat] . ", ";
                    }                       
                }
                $categories = !empty($categories) ? substr($categories, 0, -2) : "";
            }               
            
            $price_list = '';
            $price = isset($val['price']) ? (array)json_decode($val['price']) : false;

            if (is_array($price) && count($price) >= 1) {
                foreach ($price as $key_price => $val_price) {                    
                    if (array_key_exists($key_price, (array)$size_list)) {                                                 
                        $price_list .= $this->functions->formatNumber($val_price) . " " . ucwords($size_list[$key_price]) . "<br/>";
                    }                   
                }
            }  

            if ($price_list == "") {
                $price_list = $this->functions->formatNumber($price[0]);
            }          
            
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"$val[item_id]\" class=\"chk_child\">";
            $option = "<div class=\"options\">
                <a href=\"$slug/id/$val[item_id]\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"delete_item\" data-id=\"$val[item_id]\">" . $this->functions->translation("default", "Delete") . "</a>
                </div>";
                                        
            $date = $this->functions->FormatDateTime($val['date_created']);
            $photo = !empty($val['photo']) ? "<img class=\"uk-thumbnail uk-thumbnail-mini\" src=\"" . Config::$baseUrl . "/upload/$val[photo]\">" : '';

            $stock_value = ($val['with_size'] == 1) ? "-" : intval($val['available_stocks']);
            $show_stock = $stock_value . "<br/><a href=\"javascript:;\" class=\"edit-stocks\" data-id=\"$val[item_id]\">
                <i class=\"fa fa-pencil\"></i></a>";

            $show_stock1 = "<br/><a href=\"javascript:;\" class=\"edit-stocks\" data-id=\"$val[item_id]\">
                <i class=\"fa fa-pencil\"></i></a>";

            if ($this->functions->inventoryEnabled($mtid)) {
                $feed_data['aaData'][] = array(
                    $chk,
                    $val['item_name'] . $option,
                    $val['item_description'],
                    stripslashes($categories),
                    $price_list . $show_stock1,
                    $photo,
                    $show_stock,
                    '<input type="checkbox" name="food_not_available" class="not_available" id="not_available" value="' . $val['item_id'] . '" ' . ($val['not_available'] == 2 ? 'checked' : '') . '>',
                    "$date<br/><span class=\"tag " . $val['status'] . "\">" . ($val['status']) . "</span>"
                );
            } else {
                $feed_data['aaData'][] = array(
                    $chk,
                    $val['item_name'] . $option,
                    $val['item_description'],
                    stripslashes($categories),
                    $price_list . $show_stock1,
                    $photo,
                    '<input type="checkbox" name="food_not_available" class="not_available" id="not_available" value="' . $val['item_id'] . '" ' . ($val['not_available'] == 2 ? 'checked' : '') . '>',
                    "$date<br/><span class=\"tag " . $val['status'] . "\">" . ($val['status']) . "</span>"
                );
            }
        }

        $this->otableOutput($feed_data);
        return;
    }           
    $this->otableNodata();  
}










  
  



public function AddOnCategoryList() {
    $aColumns = array('subcat_id', 'subcategory_name', 'subcategory_description', 'status');
    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';
    
    // Using the custom functions for processing ajaxDataTables
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }
    
    $slug = $this->data['slug'];
    
    // Prepare the PDO query
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS * FROM mt_subcategory
        WHERE merchant_id = :merchant_id
        $sWhere
        $sOrder
        $sLimit
    ";
    
    // Get the PDO connection from the Model
    $connection = $this->db;
    $query = $connection->prepare($stmt);
    
    // Binding merchant_id
    $merchant_id = $this->functions->getMerchantID();
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $query->execute();
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);
    
    if (is_array($rows) && count($rows) >= 1) {
        $iTotalRecords = 0;
        
        // Fetch the total records using FOUND_ROWS()
        $stmt2 = "SELECT FOUND_ROWS()";
        $result = $connection->query($stmt2);
        if ($res2 = $result->fetch(PDO::FETCH_ASSOC)) {
            $iTotalRecords = $res2['FOUND_ROWS()'];
        }
        
        // Prepare the data for output
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($rows as $val) {
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"{$val['subcat_id']}\" class=\"chk_child\" >";         
            $option = "<div class=\"options\">
                        <a href=\"$slug/id/{$val['subcat_id']}\">" . $this->functions->translation("default", "Edit") . "</a>
                        <a href=\"javascript:;\" class=\"delete_item\" data-id=\"{$val['subcat_id']}\">" . $this->functions->translation("default", "Delete") . "</a>
                       </div>";
            //$date = $this->functions->FormatDateTime($val['date_created']);

           $date = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
            
            // Adding data to the output array
            $feed_data['aaData'][] = array(
                $chk,
                stripslashes($val['subcategory_name']) . $option,
                stripslashes($val['subcategory_description']),
                "$date<br/><span class=\"tag {$val['status']}\">" . ($val['status']) . "</span>"
            );
        }

        // Output the data
        $this->otableOutput($feed_data);
    } else {
        // No data found
        $this->otableNodata();
    }
}


public function addAddOnCategory()
        {
            $params=array(
              'subcategory_name'=>addslashes($this->data['subcategory_name']),
              'subcategory_description'=>addslashes($this->data['subcategory_description']),              
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'merchant_id'=>$this->functions->getMerchantID(),
              'status'=>$this->data['status']
            );              

            if (isset($this->data['subcategory_name_trans'])){
                if ($this->functions->okToDecode()){
                    $params['subcategory_name_trans']=json_encode($this->data['subcategory_name_trans'],
                    JSON_UNESCAPED_UNICODE);
                    $params['subcategory_description_trans']=json_encode($this->data['subcategory_description_trans'],JSON_UNESCAPED_UNICODE);
                } else {
                    $params['subcategory_name_trans']=json_encode($this->data['subcategory_name_trans']);
                    $params['subcategory_description_trans']=json_encode($this->data['subcategory_description_trans']);
                }           
            }       
            
            
            $subcat_id = 0;
            
            
            if (isset($this->data['id']) && is_numeric($this->data['id'])){             
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();                
                
                $res = $this->functions->updateData("mt_subcategory", $params, 'subcat_id', $this->data['id']);
                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'SubCategory updated.');                                       

                    $subcat_id = (integer) $this->data['id'];
                    
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else {
                $last_insert_id = $this->functions->insertData('mt_subcategory', $params);
                if ($last_insert_id!== false){                 
                
                    $this->details=$last_insert_id;   
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'SubCategory added.');      
                    $subcat_id = (integer) $this->details;
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }
            
                  
            
        }



        public function addOnItemNew()
        {
            if (!isset($this->data['photo'])){
                $this->data['photo']='';
            }
            $this->data['category']=isset($this->data['category'])?$this->data['category']:'';
                   
            $params=array(
              'sub_item_name'=>addslashes($this->data['sub_item_name']),
              'item_description'=>isset($this->data['item_description'])?addslashes($this->data['item_description']):"",
              'category'=>json_encode($this->data['category']),
              'price'=>isset($this->data['price'])?trim($this->data['price']):0,
              'photo'=>isset($this->data['photo'])?addslashes(trim($this->data['photo'])):"",
              'status'=>addslashes($this->data['status']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'merchant_id'=>$this->functions->getMerchantID()
            );      
            
            if (isset($this->data['sub_item_name_trans'])){
                if ($this->functions->okToDecode()){
                    $params['sub_item_name_trans']=json_encode($this->data['sub_item_name_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['sub_item_name_trans']=json_encode($this->data['sub_item_name_trans']);              
            }       
            if (isset($this->data['item_description_trans'])){
                if ($this->functions->okToDecode()){
                    $params['item_description_trans']=json_encode($this->data['item_description_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['item_description_trans']=json_encode($this->data['item_description_trans']);
            }       
            
            
            $sub_item_id = 0;
            
           
            if (isset($this->data['id']) && is_numeric($this->data['id'])){     
                
                $sub_item_id = (integer) $this->data['id'];
                
                $filename_to_delete='';
                if ($temp_res=$this->functions->getAddonItem($this->data['id'])){
                    if(!isset($this->data['photo'])){
                        $this->data['photo']='';
                    }       
                    if($this->data['photo']!=$temp_res['photo']){
                        $filename_to_delete=$temp_res['photo'];
                    }       
                }
                        
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();                
                
               $res = $this->functions->updateData("mt_subcategory_item", $params, 'sub_item_id', $this->data['id']);
                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'AddOn Item updated.');  
                    $item_id=$this->data['id'];
                    
                              
                    
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else {   
                $last_insert_id = $this->functions->insertData('mt_subcategory_item', $params);
                if ($last_insert_id!== false){              
                    $sub_item_id=$last_insert_id;
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'AddOn Item added.');                   
                    $this->details=$sub_item_id;                                                                    
                    
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }
            
            /*INSERT SUBCAT RELATIONSHIP*/
            if($this->code==1){                
               $this->functions->insertSubcategoryItemRelationship(
                 $sub_item_id,
                 isset($this->data['category'])?(array)$this->data['category']:array()
               );
            }   
            
                
            
        }
    






 public function recentOrder()
{
    $merchant_id = $this->functions->getMerchantID();        
    $today_date = date('Y-m-d');
    
    // Prepare the SQL statement
    $stmt = $this->db->prepare("
        SELECT 
            order_id, trans_type, payment_type, sub_total, taxable_total, total_w_tax, a.status, 
            a.order_number, a.merchant_id, a.date_created, admin_viewed, request_from, viewed,a.client_names,a.is_phone_order,a.phones,a.is_retail,
            (
                SELECT CONCAT(first_name, ' ', last_name)
                FROM mt_client
                WHERE client_id = a.client_id
            ) AS client_name,
            (
                SELECT contact_phone
                FROM mt_client
                WHERE client_id = a.client_id
            ) AS contact_phone,
            (
                SELECT GROUP_CONCAT(item_name)
                FROM mt_order_details
                WHERE order_id = a.order_id
            ) AS item,
            (
                SELECT CONCAT(first_name, ' ', last_name)
                FROM mt_order_delivery_address
                WHERE order_id = a.order_id
                LIMIT 1
            ) AS customer_name
        FROM mt_order a
        WHERE merchant_id = :merchant_id
        AND date_created LIKE :today_date
        AND status NOT IN ('initial_order')
        AND a.request_from != 'pos'
        AND request_cancel = '2'
        ORDER BY date_created DESC
    ");
    
    // Bind the parameters
    $stmt->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->bindValue(':today_date', $today_date . '%', PDO::PARAM_STR);
    
    // Execute the query
    if ($stmt->execute()) {
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            foreach ($res as $val) {
                $new = '';
        
          if ($val['request_from'] == "webappv2" || $val['request_from'] == "web") {
            
             if(!empty($val['customer_name']) && strlen($val['customer_name'])>1 ){          
          $val['client_name'] = $val['customer_name'];
        }
            
          }
        
        
         if($val['request_from']=="pos"){}else{
          $action = "<a data-id=\"".$val['order_id']."\" class=\"edit-order\" href=\"javascript:\">".$this->functions->translation("default", "Edit")."</a>";
         }
        $action .= "<a data-id=\"".$val['order_id']."\" class=\"view-receipt\" href=\"javascript:\">".$this->functions->translation("default", "View")."</a>";
                $action .= "<a data-id=\"".$val['order_id']."\" class=\"view-order-history\" href=\"javascript:\">".$this->functions->translation("default", "History")."</a>";
                
                if ($val['viewed'] == 1) {
                    $new = " <div class=\"uk-badge\">" . $this->functions->translation("default", "NEW") . "</div>";
                }
                
                $date = $this->functions->FormatDateTime($val['date_created']);
                $item = $this->functions->translateFoodItemByOrderId($val['order_id'], 'kr_merchant_lang_id');
                
                $type_pr = $this->functions->prettyPaymentType('payment_order', $val['payment_type'], $val['order_id'], $val['trans_type']);  
                if ($val['is_sop'] == '1' && $val['trans_type'] == 'pickup') {    
                    $type_pr = 'Swipe on Pickup'; 
                }
                
                $client_name = !empty(trim($val['client_name'])) ? $val['client_name'] : 'Guest';
        
        if($val['is_phone_order']==1){
            
            $val['client_name']=$val['client_names'];
            $val['contact_phone']=$val['phones'];
            
          }
          
          
            if($val['is_phone_order']==1 && $val['trans_type']=='pickup'){
            $val['trans_type']='Phone Pickup';
            
          }else if($val['is_phone_order']==1 && $val['trans_type']=='delivery'){
            $val['trans_type']='Phone Delivery';
            
          } 
          if($val['is_retail']==1){$val['trans_type']='Retail';}    
        

                $order_number = '-';
                if (($val['request_from'] == "webappv2" || $val['request_from'] == "pos") && $val['order_number'] > 0) {
                    $order_number = $val['merchant_id'] . '-' . $val['order_number'];
                }
                $order_number = $val['merchant_id'] . '-' . $val['order_number'];
                // Prepare the data for the output

                $type_pr=$this->functions->payment_translations($val['trans_type'],$val['payment_type'],$val['is_sop']);


                $feed_data['aaData'][] = array(
                    $val['order_id'], $order_number,
                    ucwords($client_name) . $new,
                    $val['contact_phone'],
                    $item,
                    $val['trans_type'],
                    $type_pr,
                    $this->functions->formatNumber($val['sub_total']),
                    $this->functions->formatNumber($val['taxable_total']),
                    $this->functions->formatNumber($val['total_w_tax']),
                    "<span class=\"tag " . $val['status'] . "\">" . $val['status'] . "</span>",
                    $val['request_from'],
                    $date,
                    $action
                );
            }
            $this->otableOutput($feed_data);
        }else{$this->otableNodata();}
    } else {
        $this->otableNodata();
    }
}




       public function merchantUserLogin()
{
    // Get the PDO instance from the class property
    $pdo = $this->db;

    // Prepare the SQL statement with placeholders
    $stmt = $pdo->prepare("
        SELECT a.*,
            (
                SELECT restaurant_name
                FROM mt_merchant
                WHERE merchant_id = a.merchant_id
            ) AS restaurant_name,
            (
                SELECT restaurant_slug
                FROM mt_merchant
                WHERE merchant_id = a.merchant_id
            ) AS restaurant_slug,
            (
                SELECT merchant_type
                FROM mt_merchant
                WHERE merchant_id = a.merchant_id
            ) AS merchant_type
        FROM mt_merchant_user a
        WHERE username = :username
        AND password = :password
        AND status = 'active'
        LIMIT 1
    ");

    // Bind parameters
    $stmt->bindParam(':username', $username);
    $stmt->bindParam(':password', $password);

    // Set parameter values
    $username = $this->data['username'];
    $password = md5($this->data['password']);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!empty($res)) {
        if ($res[0]['status'] == "active" || $res[0]['status'] == "expired") {
            $mt_id = $res[0]['merchant_id'];

            // Get merchant info
            if ($merchant_info = $this->functions->getMerchant($mt_id)) {
                $res[0]['is_commission'] = $merchant_info['is_commission'];
            }

            // Set session data
            $_SESSION['kr_merchant_user'] = json_encode($res);

            //+++was custom code
             $info=$this->functions->getMerchantInfo();
            if ( is_array($info) && count($info)>=1){
              $info=(array)$info[0];      
              if (isset($info['merchant_user_id'])){
                $access=json_decode($info['user_access']);

                if (!is_array($access)) {
                    $this->msg = $this->functions->translation("default", "You dont have any access.");
                }else{
                  $this->code = 1;
                  $this->msg = $this->functions->translation("default", "Login Successful");
                }

               
                }                
          }
            //---was custom code

            

            // Generate session token
            $session_token = $this->functions->generateRandomKey() . md5($_SERVER['REMOTE_ADDR']);
            $_SESSION['kr_merchant_user_session'] = $session_token;
            $_SESSION['kr_merchant_user_type'] = 'merchant_user';

            // Update last login information
            $params = [
                'last_login' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'session_token' => $session_token
            ];
            $this->functions->updateData("mt_merchant_user", $params, 'merchant_user_id', $res[0]['merchant_user_id']);
            

           


        } else {
            $this->msg = $this->functions->translation("default", "Login Failed. Your account status is [status]", [
                '[status]' => $res[0]['status']
            ]);
        }
    } else {
        $this->msg = $this->functions->translation("default", "Either username or password is invalid.");
    }
}


      public function merchantUserLogin_bkup()
{
    // Get the PDO instance from the class property
    $pdo = $this->db;

    // Prepare the SQL statement with placeholders
    $stmt = $pdo->prepare("
        SELECT a.*,
            (
                SELECT restaurant_name
                FROM mt_merchant
                WHERE merchant_id = a.merchant_id
            ) AS restaurant_name,
            (
                SELECT restaurant_slug
                FROM mt_merchant
                WHERE merchant_id = a.merchant_id
            ) AS restaurant_slug,
            (
                SELECT merchant_type
                FROM mt_merchant
                WHERE merchant_id = a.merchant_id
            ) AS merchant_type
        FROM mt_merchant_user a
        WHERE username = :username
        AND password = :password
        AND status = 'active'
        LIMIT 1
    ");

    // Bind parameters
    $stmt->bindParam(':username', $username);
    $stmt->bindParam(':password', $password);

    // Set parameter values
    $username = $this->data['username'];
    $password = md5($this->data['password']);

    // Execute the statement
    $stmt->execute();

    // Fetch the result
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!empty($res)) {
        if ($res[0]['status'] == "active" || $res[0]['status'] == "expired") {
            $mt_id = $res[0]['merchant_id'];

            // Get merchant info
            if ($merchant_info = $this->functions->getMerchant($mt_id)) {
                $res[0]['is_commission'] = $merchant_info['is_commission'];
            }

            // Set session data
            $_SESSION['kr_merchant_user'] = json_encode($res);

            $this->code = 1;
            $this->msg = $this->functions->translation("default", "Login Successful");

            // Generate session token
            $session_token = $this->functions->generateRandomKey() . md5($_SERVER['REMOTE_ADDR']);
            $_SESSION['kr_merchant_user_session'] = $session_token;
            $_SESSION['kr_merchant_user_type'] = 'merchant_user';

            // Update last login information
            $params = [
                'last_login' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR'],
                'session_token' => $session_token
            ];
            $this->functions->updateData("mt_merchant_user", $params, 'merchant_user_id', $res[0]['merchant_user_id']);
            
            //+++was new code
            $info=$this->functions->getMerchantInfo();
            if ( is_array($info) && count($info)>=1){
              $info=(array)$info[0];      
              if (isset($info['merchant_user_id'])){
                $access=json_decode($info['user_access']);

                if (!is_array($access)) {
                    $this->msg = $this->functions->translation("default", "You dont have any access.");
                }

               
                }                
          }
           //---was new code


        } else {
            $this->msg = $this->functions->translation("default", "Login Failed. Your account status is [status]", [
                '[status]' => $res[0]['status']
            ]);
        }
    } else {
        $this->msg = $this->functions->translation("default", "Either username or password is invalid.");
    }
}







    public function AdminUpdateCustomerReviews()
    {
                 
        if (isset($this->data['id'])){
            $params=array(
              'review'=>$this->data['review'],
              'status'=>$this->data['status'],
              'rating'=>$this->data['rating'],
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'date_modified'=>$this->functions->dateNow()
            );

            if ($this->functions->updateData('mt_review' , $params ,'id',$this->data['id'])){
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");
            } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
        } else $this->msg="";       
    }



    public function customerReviews()
{       
    $aColumns = array('id','client_name', 'review', 'rating', 'status');
    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';         

    // Handle DataTables inputs
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }           

    $merchant_id = $this->functions->getMerchantID();            
    $slug = $this->data['slug'];                              

    // SQL query to fetch customer reviews
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*, 
        CONCAT(b.first_name, ' ', b.last_name) AS client_name,
        (
            SELECT COUNT(*) 
            FROM mt_review
            WHERE parent_id = a.id
        ) AS total_reply
        FROM mt_review a
        LEFT JOIN mt_client b ON a.client_id = b.client_id
        WHERE a.merchant_id = :merchant_id
        $sOrder
        $sLimit
    ";

    // Prepare and execute statement
    $stmt = $this->db->prepare($stmt);
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $stmt->execute();

    // Fetch results
    if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        $iTotalRecords = 0;

        // Get total records found
        $stmt2 = $this->db->query("SELECT FOUND_ROWS()");
        if ($res2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
            $iTotalRecords = $res2['FOUND_ROWS()'];
        }   

        // Prepare data for DataTables output
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $reply_link = Config::$baseUrl . "/merchant/reviewreply/id/" . $val['id'];
            $action = "<div class=\"options\">
                <a href=\"$slug/Do/Add/id/$val[id]\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"$val[id]\">" . $this->functions->translation("default", "Delete") . "</a>
                <a href=\"$reply_link\">" . $this->functions->translation("default", "Reply") . "</a>
            </div>";

            if ($this->data['currentController'] != "admin") {                        
                if ($this->functions->getOptionAdmin('merchant_can_edit_reviews') == "yes") {
                    $action = "<div class=\"options\">                            
                        <a href=\"$reply_link\">" . $this->functions->translation("default", "Reply") . "</a>
                    </div>";              
                }
            }
                               
            $date = $this->functions->FormatDateTime($val['date_created']);
            $comment = '';
            if ($val['total_reply'] > 0) {
                $comment = '<a href="javascript:;" data-id="' . $val['id'] . '" class="review-comment rcom-' . $val['id'] . '">' . ("comment") . "(" . $val['total_reply'] . ")" . '</a>';
                $comment .= "<div class=\"cm-review comment-review-details-$val[id]\"></div>";
            }               

            $feed_data['aaData'][] = array(
                $val['id'],
                ucwords($val['client_name']) . $action,
                $val['review'] . $comment,                    
                $val['rating'],
                "$date<br/><span class=\"tag " . $val['status'] . "\">" . ($val['status']) . "</span>"                     
            );                  
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();  
    }
}


public function UpdateCustomerReviews()
    {
          
      if (isset($this->data['id'])){
        $params=array(
          'review'=>$this->data['review'],
          'status'=>$this->data['status'],
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        if ($this->functions->updateData("mt_review",$params,'id',$this->data['id'])){
          $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");
        } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
      } else $this->msg="";   
    }




public function replyToReview()
    {       
        if($merchant_info=$this->functions->getMerchantInfo()){
            $params=array(
              'parent_id'=>$this->data['parent_id'],
              'review'=>stripslashes($this->data['review']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'reply_from'=>$merchant_info[0]->restaurant_name
            );          
            
            
            if (isset($this->data['record_id'])){
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();



                if ( $this->functions->updateData('mt_review' , $params ,'id',$this->data['record_id'])){
                    $this->msg=("Successful"); $this->code=1;
                } else $this->msg=("Failed cannot update records");
            } else {
                //$DbExt->insertData("{{review}}",$params);
                $last_insert_id = $this->functions->insertData('mt_review', $params);
                $this->msg=("Successful"); $this->code=1;
            }
                        
                      
        } else $this->msg=("ERROR: Your session has expired.");
    }








       public function BankDepositList()
{
    // Prepare the SQL query using PDO
    $stmt = $this->db->prepare("
        SELECT 
            a.*,
            b.merchant_id as new_merchant_id,
            IFNULL(c.restaurant_name,'') as merchant_name
        FROM
            mt_bank_deposit a
        LEFT JOIN mt_order b       
            ON a.order_id = b.order_id     
        LEFT JOIN mt_merchant c
            ON b.merchant_id = c.merchant_id
        ORDER BY a.id DESC
    ");

    // Execute the query
    $stmt->execute();

    // Fetch the results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $feed_data = [];

        foreach ($res as $val) {
            // Format the date
            $date = $this->functions->FormatDateTime($val['date_created']);

            // Handle the scan photo
            if (!empty($val['scanphoto'])) {
                $img = Config::$baseUrl . "/upload/$val[scanphoto]";
                $scanphoto = "<a href=\"$img\" target=\"_blank\">";
                $scanphoto .= "<img class=\"uk-thumbnail uk-thumbnail-mini\" src=\"$img\" >";   
                $scanphoto .= "</a>";
            } else {
                $scanphoto = '';
            }

            // Handle the order ID
            $order_id = '';
            if ($val['order_id'] > 0) {
                $order_id .= '<p>' . ("Order Id") . ': ' . $val['order_id'] . '</p>';
            }

            // Build the data array
            $feed_data['aaData'][] = array(
                $val['id'],
                ($val['transaction_type']),
                stripslashes(ucwords($val['merchant_name'])),
                $val['branch_code'],
                $this->functions->FormatDateTime($val['date_of_deposit'], false),
                $val['time_of_deposit'],
                $this->functions->standardPrettyFormat($val['amount']),
                $scanphoto . $order_id,
                $date
            );
        }

        // Output the table data
        $this->otableOutput($feed_data);
    } else {
        // No data found
        $this->otableNodata();
    }
}


public function paymentgatewaySettings()
        {       
            $this->functions->updateOptionAdmin("paymentgateway",
            isset($this->data['paymentgateway'])?json_encode($this->data['paymentgateway']):'');
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Setting saved");         
        } 

        public function branchmangement()
        {       
            $this->functions->updateOptionAdmin("branchmangement",
            isset($this->data['merchant_id'])?json_encode($this->data['merchant_id']):'');
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Setting saved");         
        } 



        public function adminPaypalV2Settings()
    {
        $this->functions->updateOptionAdmin("admin_paypal_v2_enabled",
        isset($this->data['admin_paypal_v2_enabled'])?$this->data['admin_paypal_v2_enabled']:'');
        
        $this->functions->updateOptionAdmin("admin_paypal_v2_mode",
        isset($this->data['admin_paypal_v2_mode'])?$this->data['admin_paypal_v2_mode']:'');
        
        $this->functions->updateOptionAdmin("admin_paypal_v2_card_fee",
        isset($this->data['admin_paypal_v2_mode'])?$this->data['admin_paypal_v2_card_fee']:'');
        
        $this->functions->updateOptionAdmin("admin_paypal_v2_client_id",
        isset($this->data['admin_paypal_v2_client_id'])?$this->data['admin_paypal_v2_client_id']:'');
        
        $this->functions->updateOptionAdmin("admin_paypal_v2_secret",
        isset($this->data['admin_paypal_v2_secret'])?$this->data['admin_paypal_v2_secret']:'');
                
        $this->code = 1;
        $this->msg = $this->functions->translation("default","Setting saved");    
    }



        public function stripeSettings()
        {       
            $merchant_id=$this->functions->getMerchantID();
                        
            $this->functions->updateOption("stripe_enabled",
            isset($this->data['stripe_enabled'])?$this->data['stripe_enabled']:''
            ,$merchant_id);
            
            $this->functions->updateOption("stripe_mode",
            isset($this->data['stripe_mode'])?$this->data['stripe_mode']:''
            ,$merchant_id);
            
            $this->functions->updateOption("stripe_enabled",
            isset($this->data['stripe_enabled'])?$this->data['stripe_enabled']:''
            ,$merchant_id);
            
            $this->functions->updateOption("sanbox_stripe_secret_key",
            isset($this->data['sanbox_stripe_secret_key'])?$this->data['sanbox_stripe_secret_key']:''
            ,$merchant_id);
            
            $this->functions->updateOption("sandbox_stripe_pub_key",
            isset($this->data['sandbox_stripe_pub_key'])?$this->data['sandbox_stripe_pub_key']:''
            ,$merchant_id);
            
            $this->functions->updateOption("live_stripe_secret_key",
            isset($this->data['live_stripe_secret_key'])?$this->data['live_stripe_secret_key']:''
            ,$merchant_id);
            
            $this->functions->updateOption("live_stripe_pub_key",
            isset($this->data['live_stripe_pub_key'])?$this->data['live_stripe_pub_key']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_stripe_ideal_enabled",
            isset($this->data['merchant_stripe_ideal_enabled'])?$this->data['merchant_stripe_ideal_enabled']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_stripe_ideal_fee",
            isset($this->data['merchant_stripe_ideal_fee'])?$this->data['merchant_stripe_ideal_fee']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_stripe_card_fee",
            isset($this->data['merchant_stripe_card_fee'])?$this->data['merchant_stripe_card_fee']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_sandbox_stripe_webhooks",
            isset($this->data['merchant_sandbox_stripe_webhooks'])?$this->data['merchant_sandbox_stripe_webhooks']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_live_stripe_webhooks",
            isset($this->data['merchant_live_stripe_webhooks'])?$this->data['merchant_live_stripe_webhooks']:''
            ,$merchant_id);
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved.");
        } 



            public function merchantPolipaySettings()   
        {           
            $merchant_id=$this->functions->getMerchantID();  

            $this->functions->updateOption("merchant_poli_mode", 
            isset($this->data['merchant_poli_mode'])?$this->data['merchant_poli_mode']:''   
            ,$merchant_id); 

            $this->functions->updateOption("merchant_poli_merchant_id_sandbox", 
            isset($this->data['merchant_poli_merchant_id_sandbox'])?$this->data['merchant_poli_merchant_id_sandbox']:''   
            ,$merchant_id); 

            $this->functions->updateOption("merchant_auth_poli_code_sandbox", 
            isset($this->data['merchant_auth_poli_code_sandbox'])?$this->data['merchant_auth_poli_code_sandbox']:''   
            ,$merchant_id); 


                            
            $this->functions->updateOption("poli_enabled", 
            isset($this->data['poli_enabled'])?$this->data['poli_enabled']:''   
            ,$merchant_id); 
                
            $this->functions->updateOption("merchant_poli_merchant_id",    
            isset($this->data['merchant_poli_merchant_id'])?$this->data['merchant_poli_merchant_id']:'' 
            ,$merchant_id); 
                
            $this->functions->updateOption("merchant_auth_poli_code",  
            isset($this->data['merchant_auth_poli_code'])?$this->data['merchant_auth_poli_code']:'' 
            ,$merchant_id); 
                
                
                
            $this->code=1;  
            $this->msg=$this->functions->translation("default","Settings saved."); 
        } 



        public function adminStripeSettings()
        {       
                    
            $this->functions->updateOptionAdmin("admin_stripe_enabled",
            isset($this->data['admin_stripe_enabled'])?$this->data['admin_stripe_enabled']:'');
            
            $this->functions->updateOptionAdmin("admin_stripe_mode",
            isset($this->data['admin_stripe_mode'])?$this->data['admin_stripe_mode']:'');
            
            $this->functions->updateOptionAdmin("admin_sandbox_stripe_secret_key",
            isset($this->data['admin_sandbox_stripe_secret_key'])?$this->data['admin_sandbox_stripe_secret_key']:'');
            
            $this->functions->updateOptionAdmin("admin_sanbox_stripe_secret_key",
            isset($this->data['admin_sanbox_stripe_secret_key'])?$this->data['admin_sanbox_stripe_secret_key']:'');
            
            $this->functions->updateOptionAdmin("admin_sandbox_stripe_pub_key",
            isset($this->data['admin_sandbox_stripe_pub_key'])?$this->data['admin_sandbox_stripe_pub_key']:'');
            
            $this->functions->updateOptionAdmin("admin_live_stripe_secret_key",
            isset($this->data['admin_live_stripe_secret_key'])?$this->data['admin_live_stripe_secret_key']:'');
            
            $this->functions->updateOptionAdmin("admin_live_stripe_pub_key",
            isset($this->data['admin_live_stripe_pub_key'])?$this->data['admin_live_stripe_pub_key']:'');
            
            $this->functions->updateOptionAdmin("admin_stripe_ideal_enabled",
            isset($this->data['admin_stripe_ideal_enabled'])?$this->data['admin_stripe_ideal_enabled']:'');
            
            $this->functions->updateOptionAdmin("admin_stripe_ideal_fee",
            isset($this->data['admin_stripe_ideal_fee'])?$this->data['admin_stripe_ideal_fee']:'');
            
            
            $this->functions->updateOptionAdmin("admin_stripe_card_fee",
            isset($this->data['admin_stripe_card_fee'])?$this->data['admin_stripe_card_fee']:'');
            
            $this->functions->updateOptionAdmin("admin_sandbox_stripe_webhooks",
            isset($this->data['admin_sandbox_stripe_webhooks'])?$this->data['admin_sandbox_stripe_webhooks']:'');
            
            $this->functions->updateOptionAdmin("admin_live_stripe_webhooks",
            isset($this->data['admin_live_stripe_webhooks'])?$this->data['admin_live_stripe_webhooks']:'');
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved.");
        }



        public function AdminPolipaySettings()
    {

        $this->functions->updateOptionAdmin("admin_poli_mode",
        isset($this->data['admin_poli_mode'])?$this->data['admin_poli_mode']:'');

        $this->functions->updateOptionAdmin("admin_poli_merchant_id_sandbox",
        isset($this->data['admin_poli_merchant_id_sandbox'])?$this->data['admin_poli_merchant_id_sandbox']:'');

        $this->functions->updateOptionAdmin("admin_auth_poli_code_sandbox",
        isset($this->data['admin_auth_poli_code_sandbox'])?$this->data['admin_auth_poli_code_sandbox']:'');



        $this->functions->updateOptionAdmin("admin_poli_merchant_id",
        isset($this->data['admin_poli_merchant_id'])?$this->data['admin_poli_merchant_id']:'');
        
        $this->functions->updateOptionAdmin("admin_auth_poli_code",
        isset($this->data['admin_auth_poli_code'])?$this->data['admin_auth_poli_code']:'');
        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");
    }


   public function paymentProviderList()
{
    // Get the slug value
    $slug = $this->data['slug'];

    // Define the SQL query
    $stmt = "SELECT * FROM mt_payment_provider ORDER BY id DESC";

    // Prepare and execute the statement
    $pdo = $this->db; // Assuming $this->db is a PDO instance
    $query = $pdo->prepare($stmt);
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    $feed_data = array();
    
    // Process the results
    if ($res) {
        foreach ($res as $val) {
            $action = "<div class=\"options\">
                <a href=\"$slug/Do/Add/id/{$val['id']}\" >" . htmlspecialchars($this->functions->translation("default", "Edit")) . "</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['id']}\" >" . htmlspecialchars($this->functions->translation("default", "Delete")) . "</a>
                </div>";

            $date = $this->functions->FormatDateTime($val['date_created']);
            
            $feed_data['aaData'][] = array(
                $val['id'],
                $val['payment_name'] . $action,
                '<img src="' . htmlspecialchars($this->functions->uploadURL() . "/" . $val['payment_logo']) . '" class="uk-thumbnail uk-thumbnail-mini">',
                $date . "<br/>" . htmlspecialchars($val['status'])
            );
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


   public function addPayonDeliver()
        {           
            $req=array(
              'photo'=>$this->functions->translation("default","Payment Logo is required"),
              'card_name'=>$this->functions->translation("default","Payment Name is required")
            );
            
            $this->functions->required($req,$this->data);

            if ($this->functions->validate()){
                $params=array(
                  'payment_name'=>$this->data['card_name'],
                  'payment_logo'=>$this->data['photo'],
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],
                  'status'=>$this->data['status']
                );
                if (isset($this->data['id']) && is_numeric($this->data['id'])){ 
                    $params['date_modified']=$this->functions->dateNow();
                    unset($params['date_created']);

                    if ( $this->functions->updateData('mt_payment_provider' , $params ,'id',$this->data['id'])){
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","Successful updated");
                    } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
                } else {

                    $last_insert_id = $this->functions->insertData('mt_payment_provider', $params);
                    if ($last_insert_id!== false){ 
                        $this->details=$last_insert_id;                       
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","Successful");
                    } else $this->msg=$this->functions->translation("default","ERROR. cannot insert data.");
                }   
            } else $this->msg=$this->functions->getErrorAsHTML(); 
        }



        public function bookingSettings()
        {

        $merchant_id=$this->functions->getMerchantID();

        $chk_id_for_google_reservation=$this->functions->chk_id_for_google_reservation($merchant_id);

        if(!$chk_id_for_google_reservation){
          $this->functions->add_id_for_google_reservation($merchant_id);
        }
        

          $this->functions->updateOption("number_of_slots",
        isset($this->data['number_of_slots'])?$this->data['number_of_slots']:''
        ,$merchant_id); 


        $this->functions->updateOption("party_size",
        isset($this->data['party_size'])?$this->data['party_size']:''
        ,$merchant_id); 

        



  $this->functions->updateOption("google_merchant_duration",
        isset($this->data['google_merchant_duration'])?$this->data['google_merchant_duration']:''
        ,$merchant_id);

  $this->functions->updateOption("booking_confirmation_mode",
        isset($this->data['booking_confirmation_mode'])?$this->data['booking_confirmation_mode']:''
        ,$merchant_id);


  $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");

        }







        public function merchantSettings()
      {       
                      
        $merchant_id=$this->functions->getMerchantID();
        
        /** reverse back to 24 hour format if format is 12 hour*/
        if ( $this->functions->getOptionAdmin("website_time_picker_format") =="12"){
          if (is_array($this->data['stores_open_starts'])){
            foreach ($this->data['stores_open_starts'] as $key=>$val) {
              //dump($key."=>".$val);
              $this->data['stores_open_starts'][$key]=$this->functions->timeFormat($val);

            }
          }


         /*  if (is_array($this->data['stores_open_pm_start'])){
            foreach ($this->data['stores_open_pm_start'] as $key=>$val) {
              //dump($key."=>".$val);
              $this->data['stores_open_pm_start'][$key]=$this->functions->timeFormat($val);
              
            }
          }
*/
          
          if (is_array($this->data['stores_open_ends'])){
            foreach ($this->data['stores_open_ends'] as $key=>$val) {
              //dump($key."=>".$val);
              $this->data['stores_open_ends'][$key]=$this->functions->timeFormat($val);
            }
          }


           /* if (is_array($this->data['stores_open_pm_ends'])){
            foreach ($this->data['stores_open_pm_ends'] as $key=>$val) {
              //dump($key."=>".$val);
              $this->data['stores_open_pm_ends'][$key]=$this->functions->timeFormat($val);
            }
          }
      */





        }


        if (empty($this->data['merchant_holiday']) || !is_array($this->data['merchant_holiday'])) {
            // Empty or invalid
        } else {
            $holiday_dates=$this->data['merchant_holiday'];


      if(isset($holiday_dates) && !empty($holiday_dates)){
            foreach ($holiday_dates as $holiday_date) {
          if(isset($holiday_date) && !empty($holiday_date)){
              $bookings=$this->functions->getBookings_datemerchantwise($merchant_id,$holiday_date);


                if(isset($bookings)){
                foreach ($bookings as $booking) {
                  $booking_id=$booking['booking_id'];
                  $this->functions->bookingcancel_holiday($merchant_id,$booking_id);
                 
                }
              }
                 
                $this->functions->updatebooking_childtable($merchant_id,$holiday_date);
      }
             
            }}

        }


                            
                
        /*SAVE OPENING HOURS*/  
        // Prepare the DELETE statement
$sql = "DELETE FROM mt_opening_hours WHERE merchant_id = :merchant_id";

// Prepare the statement using $this->db
$stmt = $this->db->prepare($sql);

// Bind the merchant_id parameter
$stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

// Execute the statement
$stmt->execute();

        $days=$this->functions->getDays();       
        
if(isset($this->data['stores_open_day'])){
    foreach ($days as $day_key => $day) {
        $params_days = array(
            'merchant_id' => $merchant_id,
            'day' => $day_key,
            'status' => in_array($day_key, (array)$this->data['stores_open_day']) ? "open" : "close",
            'start_time' => isset($this->data['stores_open_starts'][$day_key]) ? $this->data['stores_open_starts'][$day_key] : '',
            'end_time' => isset($this->data['stores_open_ends'][$day_key]) ? $this->data['stores_open_ends'][$day_key] : '',
            'start_time_pm' => isset($this->data['stores_open_pm_start'][$day_key]) ? $this->data['stores_open_pm_start'][$day_key] : '',
            'stores_pickup_day' => isset($this->data['stores_pickup_day'][$day_key]) ? $this->data['stores_pickup_day'][$day_key] : 0, // Default to 0 if not selected
            'stores_pickup_day_2' => isset($this->data['stores_pickup_day_2'][$day_key]) ? $this->data['stores_pickup_day_2'][$day_key] : 0, // Default to 0 if not selected
            'stores_del_day' => isset($this->data['stores_del_day'][$day_key]) ? $this->data['stores_del_day'][$day_key] : 0, // Default to 0 if not selected
            'stores_del_day_2' => isset($this->data['stores_del_day_2'][$day_key]) ? $this->data['stores_del_day_2'][$day_key] : 0, // Default to 0 if not selected
            'stores_dine_day' => isset($this->data['stores_dine_day'][$day_key]) ? $this->data['stores_dine_day'][$day_key] : 0, // Default to 0 if not selected
            'stores_dine_day_2' => isset($this->data['stores_dine_day_2'][$day_key]) ? $this->data['stores_dine_day_2'][$day_key] : 0, // Default to 0 if not selected
            'end_time_pm' => isset($this->data['stores_open_pm_ends'][$day_key]) ? $this->data['stores_open_pm_ends'][$day_key] : '',
        );
        
        // Perform proper validation and sanitization of input data before insertion
        // Example: Validate if $merchant_id, $day_key, etc., are valid before inserting
        
        // Insert data into the database
        try {
            
            $this->functions->insertData('mt_opening_hours', $params_days);
        } catch (Exception $e) {
            // Handle database insertion errors
          echo "Error inserting data into opening_hours table";
          die();
            //Yii::log("Error inserting data into opening_hours table: " . $e->getMessage(), 'error');
        }
    }
}


        
        $params=array(
          'delivery_charges'=>is_numeric($this->data['merchant_delivery_charges'])?$this->data['merchant_delivery_charges']:0,
          'minimum_order'=>is_numeric($this->data['merchant_minimum_order'])?$this->data['merchant_minimum_order']:0,
          'delivery_minimum_order'=>is_numeric($this->data['merchant_minimum_order'])?$this->data['merchant_minimum_order']:0,
          'delivery_maximum_order'=>is_numeric($this->data['merchant_maximum_order'])?$this->data['merchant_maximum_order']:0,
          'pickup_minimum_order'=>is_numeric($this->data['merchant_minimum_order_pickup'])?$this->data['merchant_minimum_order_pickup']:0,
          'pickup_maximum_order'=>is_numeric($this->data['merchant_maximum_order_pickup'])?$this->data['merchant_maximum_order_pickup']:0,
          'logo'=>isset($this->data['photo'])?$this->data['photo']:'',
          'recaptcha_site_key'=>isset($this->data['merchant_recaptcha_site_key'])?$this->data['merchant_recaptcha_site_key']:'',
          'recaptcha_secret_key'=>isset($this->data['merchant_recaptcha_secret_key'])?$this->data['merchant_recaptcha_secret_key']:'',
          'google_tag'=>isset($this->data['merchant_google_tag'])?$this->data['merchant_google_tag']:'',
          'google_tag_event_snippet'=>isset($this->data['merchant_google_tag_event_snippet'])?$this->data['merchant_google_tag_event_snippet']:'',
          'delivery_estimation'=>isset($this->data['merchant_delivery_estimation'])?$this->data['merchant_delivery_estimation']:'',         
          'distance_unit'=>isset($this->data['merchant_distance_type'])?$this->data['merchant_distance_type']:'',
          'delivery_distance_covered'=>isset($this->data['merchant_delivery_miles'])?(float)$this->data['merchant_delivery_miles']:0,
          'close_store'=>isset($this->data['merchant_close_store'])?1:0
        );        
        //dump($params);
       

        $this->functions->updateData('mt_merchant' , $params ,'merchant_id',$merchant_id);
                
        
        $this->functions->updateOption("merchant_minimum_order",
        isset($this->data['merchant_minimum_order'])?$this->data['merchant_minimum_order']:''
        ,$merchant_id);
        
        /* Custom code 11 starts */
        $this->functions->updateOption("auto_print",
        isset($this->data['auto_print'])?$this->data['auto_print']:'0'
        ,$merchant_id);

        /*$this->functions->updateOption("inventory_live",
        isset($this->data['inventory_live'])?$this->data['inventory_live']:''
        ,$merchant_id);*/

          /* Custom code 11 ends */
          
          /* Custom code 12 starts */
          $this->functions->updateOption("car_parking_enable",
        isset($this->data['car_parking_enable'])?$this->data['car_parking_enable']:'0'
        ,$merchant_id);
        /* Custom code 12 ends */
        
        $this->functions->updateOption("merchant_tax",
        isset($this->data['merchant_tax'])?$this->data['merchant_tax']:''
        ,$merchant_id);

        

        
        $this->functions->updateOption("merchant_delivery_charges",
        isset($this->data['merchant_delivery_charges'])?$this->data['merchant_delivery_charges']:''
        ,$merchant_id);
        
        $this->functions->updateOption("stores_open_day",
        isset($this->data['stores_open_day'])?json_encode($this->data['stores_open_day']):''
        ,$merchant_id);
        
        $this->functions->updateOption("stores_open_starts",
        isset($this->data['stores_open_starts'])?json_encode($this->data['stores_open_starts']):''
        ,$merchant_id);
      
      
      $this->functions->updateOption("stores_pickup_day",
        isset($this->data['stores_pickup_day'])?json_encode($this->data['stores_pickup_day']):''
        ,$merchant_id);

        $this->functions->updateOption("stores_pickup_day_2",
        isset($this->data['stores_pickup_day_2'])?json_encode($this->data['stores_pickup_day_2']):''
        ,$merchant_id);

        $this->functions->updateOption("stores_del_day",
        isset($this->data['stores_del_day'])?json_encode($this->data['stores_del_day']):''
        ,$merchant_id);
        $this->functions->updateOption("stores_del_day_2",
        isset($this->data['stores_del_day_2'])?json_encode($this->data['stores_del_day_2']):''
        ,$merchant_id);


        $this->functions->updateOption("stores_dine_day",
        isset($this->data['stores_dine_day'])?json_encode($this->data['stores_dine_day']):''
        ,$merchant_id);
        $this->functions->updateOption("stores_dine_day_2",
        isset($this->data['stores_dine_day_2'])?json_encode($this->data['stores_dine_day_2']):''
        ,$merchant_id);
      
      
        
        $this->functions->updateOption("stores_open_ends",
        isset($this->data['stores_open_ends'])?json_encode($this->data['stores_open_ends']):''
        ,$merchant_id);
        
        $this->functions->updateOption("stores_open_custom_text",
        isset($this->data['stores_open_custom_text'])?json_encode($this->data['stores_open_custom_text']):''
        ,$merchant_id);
                
        
        $this->functions->updateOption("merchant_photo",
        isset($this->data['photo'])?$this->data['photo']:''
        ,$merchant_id);       
                
                        
        $this->functions->updateOption("merchant_delivery_estimation",
        isset($this->data['merchant_delivery_estimation'])?$this->data['merchant_delivery_estimation']:''
        ,$merchant_id);
        
/*      
    $this->functions->updateOption("merchant_recaptcha_site_key",
        isset($this->data['merchant_recaptcha_site_key'])?$this->data['merchant_recaptcha_site_key']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_recaptcha_secret_key",
        isset($this->data['merchant_recaptcha_secret_key'])?$this->data['merchant_recaptcha_secret_key']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_google_tag",
        isset($this->data['merchant_google_tag'])?$this->data['merchant_google_tag']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_google_tag_event_snippet",
        isset($this->data['merchant_google_tag_event_snippet'])?$this->data['merchant_google_tag_event_snippet']:''
        ,$merchant_id);
        
        $this->functions->updateOption("book_now_url",
        isset($this->data['book_now_url'])?$this->data['book_now_url']:''
        ,$merchant_id);
        
        $this->functions->updateOption("about_us_url",
        isset($this->data['about_us_url'])?$this->data['about_us_url']:''
        ,$merchant_id);
        
        $this->functions->updateOption("contact_url",
        isset($this->data['contact_url'])?$this->data['contact_url']:''
        ,$merchant_id);
        
        $this->functions->updateOption("ios_appstore_url",
        isset($this->data['ios_appstore_url'])?$this->data['ios_appstore_url']:''
        ,$merchant_id);
        
        $this->functions->updateOption("google_playstore_url",
        isset($this->data['google_playstore_url'])?$this->data['google_playstore_url']:''
        ,$merchant_id);
    
    
    */
    
        
        $this->functions->updateOption("merchant_cart_note",
        isset($this->data['merchant_cart_note'])?$this->data['merchant_cart_note']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_delivery_miles",
        isset($this->data['merchant_delivery_miles'])?$this->data['merchant_delivery_miles']:''
        ,$merchant_id);
        
        
        $this->functions->updateOption("merchant_photo_bg",
        isset($this->data['photo2'])?$this->data['photo2']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_disabled_cod",
        isset($this->data['merchant_disabled_cod'])?$this->data['merchant_disabled_cod']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_disabled_ccr",
        isset($this->data['merchant_disabled_ccr'])?$this->data['merchant_disabled_ccr']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_extenal",
        isset($this->data['merchant_extenal'])?$this->data['merchant_extenal']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_enabled_voucher",
        isset($this->data['merchant_enabled_voucher'])?$this->data['merchant_enabled_voucher']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_distance_type",
        isset($this->data['merchant_distance_type'])?$this->data['merchant_distance_type']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_timezone",
        isset($this->data['merchant_timezone'])?$this->data['merchant_timezone']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_close_msg",
        isset($this->data['merchant_close_msg'])?$this->data['merchant_close_msg']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_preorder",
        isset($this->data['merchant_preorder'])?$this->data['merchant_preorder']:''
        ,$merchant_id);
        
        
        $this->functions->updateOption("merchant_maximum_order",
        isset($this->data['merchant_maximum_order'])?$this->data['merchant_maximum_order']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_packaging_charge",
        isset($this->data['merchant_packaging_charge'])?$this->data['merchant_packaging_charge']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_close_msg_holiday",
        isset($this->data['merchant_close_msg_holiday'])?$this->data['merchant_close_msg_holiday']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_holiday",
        isset($this->data['merchant_holiday'])?json_encode($this->data['merchant_holiday']):''
        ,$merchant_id);
                
        $this->functions->updateOption("merchant_activated_menu",
        isset($this->data['merchant_activated_menu'])?$this->data['merchant_activated_menu']:''
        ,$merchant_id);
        
        $this->functions->updateOption("spicydish",
        isset($this->data['spicydish'])?$this->data['spicydish']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_required_delivery_time",
        isset($this->data['merchant_required_delivery_time'])?$this->data['merchant_required_delivery_time']:''
        ,$merchant_id);
        
        $this->functions->updateOption("merchant_close_store",
        isset($this->data['merchant_close_store'])?$this->data['merchant_close_store']:''
        ,$merchant_id);               
        
        $this->functions->updateOption("merchant_packaging_increment",
        isset($this->data['merchant_packaging_increment'])?$this->data['merchant_packaging_increment']:''
        ,$merchant_id);               
        
        $this->functions->updateOption("merchant_show_time",
        isset($this->data['merchant_show_time'])?$this->data['merchant_show_time']:''
        ,$merchant_id);               
        
        $this->functions->updateOption("merchant_enabled_tip",
        isset($this->data['merchant_enabled_tip'])?$this->data['merchant_enabled_tip']:''
        ,$merchant_id);               
        
        $this->functions->updateOption("merchant_tip_default",
        isset($this->data['merchant_tip_default'])?$this->data['merchant_tip_default']:''
        ,$merchant_id);               
                
        $this->functions->updateOption("merchant_minimum_order_pickup",
        isset($this->data['merchant_minimum_order_pickup'])?$this->data['merchant_minimum_order_pickup']:''
        ,$merchant_id);               
        
        $this->functions->updateOption("merchant_maximum_order_pickup",
        isset($this->data['merchant_maximum_order_pickup'])?$this->data['merchant_maximum_order_pickup']:''
        ,$merchant_id);               
        
        $this->functions->updateOption("merchant_disabled_ordering",
        isset($this->data['merchant_disabled_ordering'])?$this->data['merchant_disabled_ordering']:''
        ,$merchant_id);               
              
        $this->functions->updateOption("merchant_tax_charges",
        isset($this->data['merchant_tax_charges'])?$this->data['merchant_tax_charges']:''
        ,$merchant_id);     

        $this->functions->updateOption("stores_open_pm_start",
        isset($this->data['stores_open_pm_start'])?json_encode($this->data['stores_open_pm_start']):''
        ,$merchant_id);
                
        $this->functions->updateOption("stores_open_pm_ends",
        isset($this->data['stores_open_pm_ends'])?json_encode($this->data['stores_open_pm_ends']):''
        ,$merchant_id);     
        
        $this->functions->updateOption("food_option_not_available",
        isset($this->data['food_option_not_available'])?$this->data['food_option_not_available']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("order_verification",
        isset($this->data['order_verification'])?$this->data['order_verification']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("order_sms_code_waiting",
        isset($this->data['order_sms_code_waiting'])?$this->data['order_sms_code_waiting']:''
        ,$merchant_id); 


       

        
        $this->functions->updateOption("disabled_food_gallery",
        isset($this->data['disabled_food_gallery'])?$this->data['disabled_food_gallery']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_apply_tax",
        isset($this->data['merchant_apply_tax'])?$this->data['merchant_apply_tax']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("printing_receipt_width",
        isset($this->data['printing_receipt_width'])?$this->data['printing_receipt_width']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("printing_receipt_size",
        isset($this->data['printing_receipt_size'])?$this->data['printing_receipt_size']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("free_delivery_above_price",
        isset($this->data['free_delivery_above_price'])?$this->data['free_delivery_above_price']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_minimum_order_dinein",
        isset($this->data['merchant_minimum_order_dinein'])?$this->data['merchant_minimum_order_dinein']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_maximum_order_dinein",
        isset($this->data['merchant_maximum_order_dinein'])?$this->data['merchant_maximum_order_dinein']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("food_viewing_private",
        isset($this->data['food_viewing_private'])?$this->data['food_viewing_private']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_tax_number",
        isset($this->data['merchant_tax_number'])?$this->data['merchant_tax_number']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_packaging_wise",
        isset($this->data['merchant_packaging_wise'])?$this->data['merchant_packaging_wise']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_show_category_image",
        isset($this->data['merchant_show_category_image'])?$this->data['merchant_show_category_image']:''
        ,$merchant_id);  
                
        if ($this->functions->enabledExtraCharges()){
          $this->functions->updateOption("extra_charge_start_time",
          isset($this->data['extra_charge_start_time'])?json_encode($this->data['extra_charge_start_time']):''
          ,$merchant_id);
          
          $this->functions->updateOption("extra_charge_end_time",
          isset($this->data['extra_charge_end_time'])?json_encode($this->data['extra_charge_end_time']):''
          ,$merchant_id);
          
          $this->functions->updateOption("extra_charge_fee",
          isset($this->data['extra_charge_fee'])?json_encode($this->data['extra_charge_fee']):''
          ,$merchant_id);
          
          $this->functions->updateOption("extra_charge_notification",
          isset($this->data['extra_charge_notification'])?$this->data['extra_charge_notification']:''
          ,$merchant_id);
        }
        
        
        $this->functions->updateOption("merchant_two_flavor_option",
        isset($this->data['merchant_two_flavor_option'])?$this->data['merchant_two_flavor_option']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_opt_contact_delivery",
        isset($this->data['merchant_opt_contact_delivery'])?$this->data['merchant_opt_contact_delivery']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("website_merchant_time_picker_interval",
        isset($this->data['website_merchant_time_picker_interval'])?$this->data['website_merchant_time_picker_interval']:''
        ,$merchant_id);  


        $this->functions->updateOption("website_delivery_merchant_time_picker_interval",
        isset($this->data['website_delivery_merchant_time_picker_interval'])?$this->data['website_delivery_merchant_time_picker_interval']:''
        ,$merchant_id);  
        
        $this->functions->updateOption("tracking_estimation_delivery1",
        isset($this->data['tracking_estimation_delivery1'])?(integer)$this->data['tracking_estimation_delivery1']:0
        ,$merchant_id);  
        
        $this->functions->updateOption("tracking_estimation_delivery2",
        isset($this->data['tracking_estimation_delivery2'])?(integer)$this->data['tracking_estimation_delivery2']:0
        ,$merchant_id);  
        
        $this->functions->updateOption("tracking_estimation_pickup1",
        isset($this->data['tracking_estimation_pickup1'])?(integer)$this->data['tracking_estimation_pickup1']:0
        ,$merchant_id);  
        
        $this->functions->updateOption("tracking_estimation_pickup2",
        isset($this->data['tracking_estimation_pickup2'])?(integer)$this->data['tracking_estimation_pickup2']:0
        ,$merchant_id);  
        
        $this->functions->updateOption("tracking_estimation_dinein1",
        isset($this->data['tracking_estimation_dinein1'])?(integer)$this->data['tracking_estimation_dinein1']:0
        ,$merchant_id);  
        
        $this->functions->updateOption("tracking_estimation_dinein2",
        isset($this->data['tracking_estimation_dinein2'])?(integer)$this->data['tracking_estimation_dinein2']:0
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_menu_lazyload",
        isset($this->data['merchant_menu_lazyload'])?(integer)$this->data['merchant_menu_lazyload']:0
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_service_fee",
        isset($this->data['merchant_service_fee'])?(float)$this->data['merchant_service_fee']:0
        ,$merchant_id);  
        
        $this->functions->updateOption("merchant_service_fee_applytax",
        isset($this->data['merchant_service_fee_applytax'])?(integer)$this->data['merchant_service_fee_applytax']:0
        ,$merchant_id);  




          //+++code for merchant google enable in merchant table and setting data validation
             $disable_google_reservations_chk=(int) $this->functions->getOption("disable_google_reservations",$merchant_id);
             if (empty($disable_google_reservations_chk) || $disable_google_reservations_chk == 0) {
            


             if (!$this->functions->isBookingDataValid($merchant_id)) {
              $this->functions->updateData("mt_merchant", ['data_validation' => 0], 'merchant_id', $merchant_id);
             }else{
              $this->functions->updateData("mt_merchant", ['data_validation' => 1], 'merchant_id', $merchant_id);
             }

          
         //----code for merchant google enable in merchant table and setting data validation



             }








        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");
      } 








    public function editMerchantStatus()
        {                   
            $status_list=$this->functions->clientStatus();
            ?>
            <div class="view-receipt-pop">
             <h3>Change Order Status</h3>
             
             <?php if ( $res=$this->functions->getMerchant($this->data['id']) ):?>
                <form id="frm-pop" class="frm-pop uk-form uk-form-horizontal" method="POST" onsubmit="return false;">

                <input type="hidden" name="action" id="action" value="updateMerchantStatus">
                <input type="hidden" name="id" value="<?php echo $this->data['id']; ?>">

                
                 <div class="uk-form-row">
                <label class="uk-form-label"><?php echo $this->functions->translation("default", "Status"); ?></label>
                <select name="status" class="uk-form-width-large">
                    <?php foreach ((array)$status_list as $key => $value): ?>
                        <option value="<?php echo $key; ?>" <?php echo $res['status'] == $key ? 'selected' : ''; ?>>
                            <?php echo $value; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
                </div>

                <div class="action-wrap">
                    <button type="submit" class="uk-button uk-form-width-medium uk-button-success">Submit</button>
                </div>






               </form> 
             <?php else:?>
             <p class="uk-text-danger"><?php echo $this->functions->translation("default","Error: Order not found")?></p>
             <?php endif;?>
            </div> <!--view-receipt-pop-->                              
            <script type="text/javascript">
            $.validate({    
                form : '#frm-pop',    
                onError : function() {      
                },
                onSuccess : function() {     
                  form_submit('frm-pop');
                  return false;
                }  
            });     
            </script>
            <?php
            die();
        }



        public function merchantStatus()
        {
            $mtid=$this->functions->getMerchantID();                   
            if ( $res=$this->functions->getMerchant($mtid)){                                               
                $this->code=1;
                $this->msg=$res['is_ready'];
                $this->details=array(
                 'status'=>$res['status'],               
                 'display_status'=>strtoupper($this->functions->translation("default",$res['status'])),
                 'is_commission'=>$res['is_commission']
                );
            } else $this->msg=$this->functions->translation("default","ERROR:");
        }



        public function getLimitSellStatus()
        {
            $merchant_id=$this->functions->getMerchantID();            
            if ( !$this->functions->validateSellLimit($merchant_id)){
                $link="<a href=\"".Config::$baseUrl."/merchant/MerchantStatus/"."\">".$this->functions->translation("default","click here to upgrade")."</a>";
                $this->msg=$this->functions->translation("default","You have reach the maximum limit of selling item. Please upgrade your membership.")." $link";
            } else $this->code=1;
        }


        public function merchantSetReady()
        {
            $mtid=$this->functions->getMerchantID();
            if (isset($this->data['status'])){
                $params=array(
                  'is_ready'=>$this->data['status'],
                  'date_modified'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR']
                );          

                            
                if ( $_SESSION['kr_merchant_user_type']=="merchant_user"){
                    $user_info=$this->functions->getMerchantInfo();                    
                    $user_id=$user_info[0]->merchant_user_id;                   
                    if (!$data=$this->functions->getMerchantUserInfo($user_id)){
                        $this->msg="Sorry but you dont have permission";
                        return ;
                    } else $user_access=json_decode($data['user_access'],true);                 
                    if (!in_array('can_published_merchant',$user_access)){
                        $this->msg="Sorry but you dont have permission";
                        return ;
                    }
                }
                
                if ( $this->functions->updateData('mt_merchant' , $params ,'merchant_id',$mtid)){
                    $this->code=1;
                    if ( $this->data['status']==2){
                        $this->msg=$this->functions->translation("default","Successful Merchant is now published.");
                    } else $this->msg=$this->functions->translation("default","Successful");
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update status");          
            } else $this->msg=$this->functions->translation("default","Missing parameters");       
        }   




            public function updateMerchantStatus()
        {           
            if (isset($this->data['id'])){
                $params=array( 
                   'status'=>$this->data['status'],
                   'date_modified'=>$this->functions->dateNow(),
                   'ip_address'=>$_SERVER['REMOTE_ADDR']
                ); 

                                                          
                if ($this->functions->updateData('mt_merchant' , $params ,'merchant_id',$this->data['id'])){
                    
                    if ($merchant_info = $this->functions->getMerchantInfo($this->data['id'])){
                        $merchant_info['status']=$this->data['status'];
                        $this->functions->MerchantchangeStatus($this->data['id'] , $merchant_info );
                    }                   
                    
                    $this->code=1;
                    $this->msg=$this->functions->translation("default","Status Updated.");
                } else $this->msg=$this->functions->translation("default","Error; cannot update status.");
            } else $this->msg=$this->functions->translation("default","Missing parameters");
        }


            public function ratingList()
        {
            $slug = Config::$baseUrl.'/admin/Ratings';
$stmt = $this->db->prepare("SELECT * FROM mt_rating_meaning ORDER BY rating_start ASC");

if ($stmt->execute()) {
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        foreach ($res as $val) {                                        
                    $action="<div class=\"options\">
                    <a href=\"$slug/Do/Add/id/$val[id]\" >".$this->functions->translation("default","Edit")."</a>
                    <a href=\"javascript:;\" class=\"row_del\" rev=\"$val[id]\" >".$this->functions->translation("default","Delete")."</a>
                    </div>";               
                   $feed_data['aaData'][]=array(
                      $val['rating_start'].$action,
                      $val['rating_end'],
                      ($val['meaning'])
                   );                  
               }
               $this->otableOutput($feed_data);
            }
            $this->otableNodata();                      
        }
    }




        public function contactSettings()
        {           
            if (!isset($this->data['contact_content'])){
                $this->data['contact_content']='';
            }
            if (!isset($this->data['contact_map'])){
                $this->data['contact_map']='';
            }
            if (!isset($this->data['map_latitude'])){
                $this->data['map_latitude']='';
            }
            if (!isset($this->data['map_longitude'])){
                $this->data['map_longitude']='';
            }
            if (!isset($this->data['contact_email_receiver'])){
                $this->data['contact_email_receiver']='';
            }
            if (!isset($this->data['contact_field'])){
                $this->data['contact_field']='';
            }
        
            if (is_array($this->data['contact_field']) && count($this->data['contact_field'])>=1){
            $this->functions->updateOptionAdmin('contact_content',$this->data['contact_content']);
            $this->functions->updateOptionAdmin('contact_map',$this->data['contact_map']);
            $this->functions->updateOptionAdmin('map_latitude',$this->data['map_latitude']);
            $this->functions->updateOptionAdmin('map_longitude',$this->data['map_longitude']);
            $this->functions->updateOptionAdmin('contact_email_receiver',$this->data['contact_email_receiver']);
            $this->functions->updateOptionAdmin('contact_field',json_encode($this->data['contact_field']));
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved.");
            } else $this->msg=$this->functions->translation("default","Contact field must have 1 or more fields");
        }



         public function adminSocialSettings()
      {       
        $this->functions->updateOptionAdmin('social_flag',isset($this->data['social_flag'])?$this->data['social_flag']:"");
        
        $this->functions->updateOptionAdmin('fb_flag',isset($this->data['fb_flag'])?$this->data['fb_flag']:"");
        $this->functions->updateOptionAdmin('fb_app_id',isset($this->data['fb_app_id'])?$this->data['fb_app_id']:"");
        $this->functions->updateOptionAdmin('fb_app_secret',isset($this->data['fb_app_secret'])?$this->data['fb_app_secret']:"");
        
        $this->functions->updateOptionAdmin('admin_fb_page',isset($this->data['admin_fb_page'])?$this->data['admin_fb_page']:"");
        
        $this->functions->updateOptionAdmin('admin_twitter_page',isset($this->data['admin_twitter_page'])?$this->data['admin_twitter_page']:"");
        
        $this->functions->updateOptionAdmin('admin_google_page',isset($this->data['admin_google_page'])?$this->data['admin_google_page']:"");
        
        $this->functions->updateOptionAdmin('admin_merchant_share',isset($this->data['admin_merchant_share'])?$this->data['admin_merchant_share']:"");
        
        $this->functions->updateOptionAdmin('google_client_id',
        isset($this->data['google_client_id'])?$this->data['google_client_id']:"");
        
        $this->functions->updateOptionAdmin('google_client_secret',
        isset($this->data['google_client_secret'])?$this->data['google_client_secret']:"");
        
        $this->functions->updateOptionAdmin('google_client_redirect_ulr',
        isset($this->data['google_client_redirect_ulr'])?$this->data['google_client_redirect_ulr']:"");
        
        $this->functions->updateOptionAdmin('google_login_enabled',
        isset($this->data['google_login_enabled'])?$this->data['google_login_enabled']:"");
        
        $this->functions->updateOptionAdmin('default_share_text',
        isset($this->data['default_share_text'])?$this->data['default_share_text']:"");
        
        $this->functions->updateOptionAdmin('admin_intagram_page',
        isset($this->data['admin_intagram_page'])?$this->data['admin_intagram_page']:"");
        
        $this->functions->updateOptionAdmin('admin_youtube_url',
        isset($this->data['admin_youtube_url'])?$this->data['admin_youtube_url']:"");
        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");
      }



      





        public function currencyList()
{
    // Fetch slug if needed, currently unused in the method
    $slug = $this->data['slug'];

    // Prepare and execute the query
    $stmt = $this->db->prepare("SELECT * FROM mt_currency ORDER BY date_created DESC");
    $stmt->execute();
    
    // Fetch the results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    //$feed_data = array('aaData' => array());

    if ($res) {
        foreach ($res as $val) {
            $link = 'managecurrency/id/' . urlencode($val['id']) . '/Do/add';
            $action = '<div class="options">
                        <a href="' . htmlspecialchars($link, ENT_QUOTES, 'UTF-8') . '">' . htmlspecialchars($this->functions->translation("default", "Edit"), ENT_QUOTES, 'UTF-8') . '</a>
                        <a href="javascript:;" class="row_del" rev="' . htmlspecialchars($val['id'], ENT_QUOTES, 'UTF-8') . '">' . htmlspecialchars($this->functions->translation("default", "Delete"), ENT_QUOTES, 'UTF-8') . '</a>
                       </div>';
            
            // Format date using your existing function
            $date = $this->functions->FormatDateTime($val['date_created']);
            
            // Prepare data for output
            $feed_data['aaData'][] = array(
                $val['id'],
                $val['currency_code'] . $action,
                $val['currency_symbol'],
                $date
            );
        }
        
        // Output the data (assuming this method is defined elsewhere in your class)
        $this->otableOutput($feed_data);
    } else {
        // No data available
        $this->otableNodata();
    }
}







      public function addRatings()
        {               
            
            $req=array(
              'meaning'=>$this->functions->translation("default","Rating is required")
            );      
            $this->functions->required($req,$this->data);
            if ($this->functions->validate()){
                $params=array(
                  'rating_start'=>$this->data['rating_start'],
                  'rating_end'=>$this->data['rating_end'],
                  'meaning'=>$this->data['meaning'],
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR']               
                );              
               if (empty($this->data['id'])){  
                    $last_insert_id = $this->functions->insertData('mt_rating_meaning', $params);
                    if ($last_insert_id!== false){    
                           $this->details= $last_insert_id ;
                            $this->code=1;
                            $this->msg=$this->functions->translation("default","Successful");                          
                        }
                    } else {                
                        unset($params['date_created']);
                        $params['date_modified']=$this->functions->dateNow(); 
                        //$this->functions->updateData('mt_rating_meaning' , $params ,'id',$this->data['id']);

                        $res = $this->functions->updateData('mt_rating_meaning' , $params ,'id',$this->data['id']);
                        if ($res){
                            $this->code=1;
                            $this->msg=$this->functions->translation("default",'Rating updated.');  
                    } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
                }   
            } else $this->msg=$this->functions->getErrorAsHTML();     
        }



        public function addCurrency()
        {           
            
            $req=array(
              'currency_code'=>$this->functions->translation("default","Currency Code is required"),
              'currency_symbol'=>$this->functions->translation("default","Currency Symbol is required")
            );      
                        
            if (empty($this->data['id'])){
                if ( $this->functions->getCurrencyDetails($this->data['currency_code'])){
                    echo ("Currency code already exist");die();
                }           
            }       
            
            $this->functions->required($req,$this->data);
            if ($this->functions->validate()){
                $params=array(
                  'currency_code'=>$this->data['currency_code'],
                  'currency_symbol'=>$this->data['currency_symbol'],
                  'ip_address'=>$_SERVER['REMOTE_ADDR']
                );
               if (empty($this->data['id'])){ 
                    $last_insert_id = $this->functions->insertData('mt_currency', $params);
                    if ($last_insert_id!== false){   
                            $this->details=$last_insert_id;
                            $this->code=1;
                            $this->msg=$this->functions->translation("default","Successful");                          
                        }
                    } else {                
                        unset($params['date_created']);
                        $params['date_modified']=$this->functions->dateNow();                
                        //$res = $this->updateData('{{currency}}' , $params ,'id',$this->data['id']);
                        $res = $this->functions->updateData('mt_currency' , $params ,'id',$this->data['id']);
                        if ($res){
                            $this->code=1;
                            $this->msg=$this->functions->translation("default",'Currency updated.');  
                    } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
                }   
            } else $this->msg=$this->functions->getErrorAsHTML();      
        }


        public function languageSettings()
        {
                    
            $this->functions->updateOptionAdmin('show_language',
            isset($this->data['show_language'])?$this->data['show_language']:"");       
                
            $this->functions->updateOptionAdmin('default_language',
            isset($this->data['default_language'])?$this->data['default_language']:"");
            
            $this->functions->updateOptionAdmin('set_lang_id',
            isset($this->data['set_lang_id'])?json_encode($this->data['set_lang_id']):"");
            
            $this->functions->updateOptionAdmin('enabled_multiple_translation',
            isset($this->data['enabled_multiple_translation'])?$this->data['enabled_multiple_translation']:"");
            
            /*yii::app()->functions->updateOptionAdmin('default_language_backend',
            isset($this->data['default_language_backend'])?$this->data['default_language_backend']:"");*/
            
            $this->functions->updateOptionAdmin('show_language_backend',
            isset($this->data['show_language_backend'])?$this->data['show_language_backend']:"");
            
            $this->functions->updateOptionAdmin('lang_rtl',
            isset($this->data['lang_rtl'])?json_encode($this->data['lang_rtl']):"");
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved.");
        }   


        public function SeoSettings()
    {
      $this->functions->updateOptionAdmin('seo_home',
      isset($this->data['seo_home'])?$this->data['seo_home']:""); 
      
      $this->functions->updateOptionAdmin('seo_home_meta',
      isset($this->data['seo_home_meta'])?$this->data['seo_home_meta']:""); 
      
      $this->functions->updateOptionAdmin('seo_home_keywords',
      isset($this->data['seo_home_keywords'])?$this->data['seo_home_keywords']:""); 
      
      $this->functions->updateOptionAdmin('seo_search',
      isset($this->data['seo_search'])?$this->data['seo_search']:""); 
      $this->functions->updateOptionAdmin('seo_search_meta',
      isset($this->data['seo_search_meta'])?$this->data['seo_search_meta']:""); 
      $this->functions->updateOptionAdmin('seo_search_keywords',
      isset($this->data['seo_search_keywords'])?$this->data['seo_search_keywords']:""); 
      
      $this->functions->updateOptionAdmin('seo_menu',
      isset($this->data['seo_menu'])?$this->data['seo_menu']:""); 
      $this->functions->updateOptionAdmin('seo_menu_meta',
      isset($this->data['seo_menu_meta'])?$this->data['seo_menu_meta']:""); 
      $this->functions->updateOptionAdmin('seo_menu_keywords',
      isset($this->data['seo_menu_keywords'])?$this->data['seo_menu_keywords']:""); 
      
      $this->functions->updateOptionAdmin('seo_checkout',
      isset($this->data['seo_checkout'])?$this->data['seo_checkout']:""); 
      $this->functions->updateOptionAdmin('seo_checkout_meta',
      isset($this->data['seo_checkout_meta'])?$this->data['seo_checkout_meta']:""); 
      $this->functions->updateOptionAdmin('seo_checkout_keywords',
      isset($this->data['seo_checkout_keywords'])?$this->data['seo_checkout_keywords']:""); 
      
      $this->functions->updateOptionAdmin('seo_contact',
      isset($this->data['seo_contact'])?$this->data['seo_contact']:""); 
      $this->functions->updateOptionAdmin('seo_contact_meta',
      isset($this->data['seo_contact_meta'])?$this->data['seo_contact_meta']:""); 
      $this->functions->updateOptionAdmin('seo_contact_keywords',
      isset($this->data['seo_contact_keywords'])?$this->data['seo_contact_keywords']:""); 
      
      $this->functions->updateOptionAdmin('seo_merchantsignup',
      isset($this->data['seo_merchantsignup'])?$this->data['seo_merchantsignup']:""); 
      $this->functions->updateOptionAdmin('seo_merchantsignup_meta',
      isset($this->data['seo_merchantsignup_meta'])?$this->data['seo_merchantsignup_meta']:""); 
      $this->functions->updateOptionAdmin('seo_merchantsignup_keywords',
      isset($this->data['seo_merchantsignup_keywords'])?$this->data['seo_merchantsignup_keywords']:""); 
                
      $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");
    }










    public function themeSettings()
    {
                  
      $this->functions->updateOptionAdmin("theme_hide_logo",
        isset($this->data['theme_hide_logo'])?$this->data['theme_hide_logo']:'');
        
        $this->functions->updateOptionAdmin("theme_hide_how_works",
        isset($this->data['theme_hide_how_works'])?$this->data['theme_hide_how_works']:'');
        
        $this->functions->updateOptionAdmin("theme_hide_cuisine",
        isset($this->data['theme_hide_cuisine'])?$this->data['theme_hide_cuisine']:'');
        
        $this->functions->updateOptionAdmin("disabled_featured_merchant",
        isset($this->data['disabled_featured_merchant'])?$this->data['disabled_featured_merchant']:'');
        
        $this->functions->updateOptionAdmin("disabled_subscription",
        isset($this->data['disabled_subscription'])?$this->data['disabled_subscription']:'');
        
        $this->functions->updateOptionAdmin("social_flag",
        isset($this->data['social_flag'])?$this->data['social_flag']:'');
        
        $this->functions->updateOptionAdmin("theme_custom_footer",
        isset($this->data['theme_custom_footer'])?$this->data['theme_custom_footer']:'');
        
        $this->functions->updateOptionAdmin("theme_show_app",
        isset($this->data['theme_show_app'])?$this->data['theme_show_app']:'');
        
        $this->functions->updateOptionAdmin("theme_app_android",
        isset($this->data['theme_app_android'])?$this->data['theme_app_android']:'');
        
        $this->functions->updateOptionAdmin("theme_app_ios",
        isset($this->data['theme_app_ios'])?$this->data['theme_app_ios']:'');
        
        $this->functions->updateOptionAdmin("theme_app_windows",
        isset($this->data['theme_app_windows'])?$this->data['theme_app_windows']:'');
      
        $this->functions->updateOptionAdmin("theme_filter_colapse",
        isset($this->data['theme_filter_colapse'])?$this->data['theme_filter_colapse']:'');
        
        $this->functions->updateOptionAdmin("theme_list_style",
        isset($this->data['theme_list_style'])?$this->data['theme_list_style']:'');
        
        $this->functions->updateOptionAdmin("enabled_search_map",
        isset($this->data['enabled_search_map'])?$this->data['enabled_search_map']:'');

        $this->functions->updateOptionAdmin("theme_menu_colapse",
        isset($this->data['theme_menu_colapse'])?$this->data['theme_menu_colapse']:'');
        
        $this->functions->updateOptionAdmin("theme_top_menu",
        isset($this->data['theme_top_menu'])?json_encode($this->data['theme_top_menu']):'');
        
        $this->functions->updateOptionAdmin("show_language",
        isset($this->data['show_language'])?$this->data['show_language']:'');
        
        $this->functions->updateOptionAdmin("theme_promo_tab",
        isset($this->data['theme_promo_tab'])?$this->data['theme_promo_tab']:'');

        $this->functions->updateOptionAdmin("merchant_tbl_book_disabled",
        isset($this->data['merchant_tbl_book_disabled'])?$this->data['merchant_tbl_book_disabled']:'');

        $this->functions->updateOptionAdmin("theme_hours_tab",
        isset($this->data['theme_hours_tab'])?$this->data['theme_hours_tab']:'');
        
        $this->functions->updateOptionAdmin("theme_reviews_tab",
        isset($this->data['theme_reviews_tab'])?$this->data['theme_reviews_tab']:'');
        
        $this->functions->updateOptionAdmin("theme_map_tab",
        isset($this->data['theme_map_tab'])?$this->data['theme_map_tab']:'');
        
        $this->functions->updateOptionAdmin("theme_info_tab",
        isset($this->data['theme_info_tab'])?$this->data['theme_info_tab']:'');
        
        $this->functions->updateOptionAdmin("theme_photos_tab",
        isset($this->data['theme_photos_tab'])?$this->data['theme_photos_tab']:'');
        
        $this->functions->updateOptionAdmin("cookie_law_enabled",
        isset($this->data['cookie_law_enabled'])?$this->data['cookie_law_enabled']:'');
        $this->functions->updateOptionAdmin("cookie_accept_text",
        isset($this->data['cookie_accept_text'])?$this->data['cookie_accept_text']:'');
        $this->functions->updateOptionAdmin("cookie_info_text",
        isset($this->data['cookie_info_text'])?$this->data['cookie_info_text']:'');
        $this->functions->updateOptionAdmin("cookie_msg_text",
        isset($this->data['cookie_msg_text'])?$this->data['cookie_msg_text']:'');
        $this->functions->updateOptionAdmin("cookie_info_link",
        isset($this->data['cookie_info_link'])?$this->data['cookie_info_link']:'');
        
        $this->functions->updateOptionAdmin("theme_search_merchant_name",
        isset($this->data['theme_search_merchant_name'])?$this->data['theme_search_merchant_name']:'');
        
        $this->functions->updateOptionAdmin("theme_search_street_name",
        isset($this->data['theme_search_street_name'])?$this->data['theme_search_street_name']:'');
        
        $this->functions->updateOptionAdmin("theme_search_cuisine",
        isset($this->data['theme_search_cuisine'])?$this->data['theme_search_cuisine']:'');
        
        $this->functions->updateOptionAdmin("theme_search_foodname",
        isset($this->data['theme_search_foodname'])?$this->data['theme_search_foodname']:'');
        
        $this->functions->updateOptionAdmin("theme_compression",
        isset($this->data['theme_compression'])?$this->data['theme_compression']:'');
        
        $this->functions->updateOptionAdmin("theme_search_merchant_address",
        isset($this->data['theme_search_merchant_address'])?$this->data['theme_search_merchant_address']:'');
        
        $this->functions->updateOptionAdmin("theme_lang_pos",
        isset($this->data['theme_lang_pos'])?$this->data['theme_lang_pos']:'');
        
        $this->functions->updateOptionAdmin("theme_hide_footer_section1",
        isset($this->data['theme_hide_footer_section1'])?$this->data['theme_hide_footer_section1']:'');
        
        $this->functions->updateOptionAdmin("theme_hide_footer_section2",
        isset($this->data['theme_hide_footer_section2'])?$this->data['theme_hide_footer_section2']:'');
        
        $this->functions->updateOptionAdmin("theme_time_pick",
        isset($this->data['theme_time_pick'])?$this->data['theme_time_pick']:'');
        
        $this->functions->updateOptionAdmin("featured_merchant_sort",
        isset($this->data['featured_merchant_sort'])?$this->data['featured_merchant_sort']:'');
        
        $this->functions->updateOptionAdmin("age_restriction",
        isset($this->data['age_restriction'])?$this->data['age_restriction']:'');
        
        $this->functions->updateOptionAdmin("age_restriction_content",
        isset($this->data['age_restriction_content'])?$this->data['age_restriction_content']:'');
        
        $this->functions->updateOptionAdmin("age_restriction_exit_link",
        isset($this->data['age_restriction_exit_link'])?$this->data['age_restriction_exit_link']:'');
        
        $this->functions->updateOptionAdmin("browse_page_sort",
        isset($this->data['browse_page_sort'])?$this->data['browse_page_sort']:'');
        
        $this->functions->updateOptionAdmin("theme_enabled_rtl",
        isset($this->data['theme_enabled_rtl'])?$this->data['theme_enabled_rtl']:'');
        
      $this->code=1;
        $this->msg=$this->functions->translation("default","Setting saved");
    }



     public function addCustomPage()
        {           
                        
            $params=array(
              'page_name'=>trim($this->data['page_name']),
              'content'=>trim($this->data['content']),            
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'status'=>$this->data['status'],
              'icons'=>$this->data['icons'],
              'open_new_tab'=>isset($this->data['open_new_tab'])?$this->data['open_new_tab']:1,
              'seo_title'=>isset($this->data['seo_title'])?$this->data['seo_title']:'',
              'meta_description'=>isset($this->data['meta_description'])?$this->data['meta_description']:'',
              'meta_keywords'=>isset($this->data['meta_keywords'])?$this->data['meta_keywords']:'',
            );
                                    
            if (isset($this->data['page_name_trans'])){             
                if ($this->functions->okToDecode()){
                    $params['page_name_trans']=json_encode($this->data['page_name_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['page_name_trans']=json_encode($this->data['page_name_trans']);              
            } else $params['page_name_trans']='';
            
            if (isset($this->data['content_trans'])){               
                if ($this->functions->okToDecode()){
                    $params['content_trans']=json_encode($this->data['content_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['content_trans']=json_encode($this->data['content_trans']);              
            } else $params['content_trans']='';
            
            if (isset($this->data['seo_title_trans'])){             
                if ($this->functions->okToDecode()){
                    $params['seo_title_trans']=json_encode($this->data['seo_title_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['seo_title_trans']=json_encode($this->data['seo_title_trans']);              
            } else $params['seo_title_trans']='';
            
            if (isset($this->data['meta_description_trans'])){              
                if ($this->functions->okToDecode()){
                    $params['meta_description_trans']=json_encode($this->data['meta_description_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['meta_description_trans']=json_encode($this->data['meta_description_trans']);                
            } else $params['meta_description_trans']='';
            
            if (isset($this->data['meta_keywords_trans'])){             
                if ($this->functions->okToDecode()){
                    $params['meta_keywords_trans']=json_encode($this->data['meta_keywords_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['meta_keywords_trans']=json_encode($this->data['meta_keywords_trans']);              
            } else $params['meta_keywords_trans']='';
            
            //$params = FunctionsV3::purifyData($params);                   
            
            if (empty($this->data['id'])){  
                $params['slug_name']=strtolower($this->functions->customPageCreateSlug($this->data['page_name']));

                 $last_insert_id = $this->functions->insertData('mt_custom_page', $params);
                if ($last_insert_id!== false){         
                
                    $this->details=$last_insert_id;
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","Successful");                      
                    }
                } else {                            
                    unset($params['date_created']);
                    $params['date_modified']=$this->functions->dateNow();                
                    //$res = $this->updateData('{{custom_page}}' , $params ,'id',$this->data['id']);
                    $res = $this->functions->updateData('mt_custom_page' , $params ,'id',$this->data['id']);
                    if ($res){
                        $this->code=1;
                        $this->msg=$this->functions->translation("default",'Page updated.');  
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            }               
        }



         public function assignCustomPage()
        {           
            if (is_array($this->data['id']) && count($this->data['id'])>=1)
            {
                $x=1;
                foreach ($this->data['id'] as $key=>$id) {
                    $params=array(
                      'assign_to'=>$this->data['assign_to'][$key],
                      'date_modified'=>$this->functions->dateNow(),
                      'ip_address'=>$_SERVER['REMOTE_ADDR'],
                      'sequence'=>$x
                    );                  
                    //$this->updateData("{{custom_page}}",$params,'id',$id);
                    $this->functions->updateData('mt_custom_page' , $params ,'id',$id);
                    $x++;
                }
            }
            $this->code=1;
            $this->msg=$this->functions->translation("default","Successfully updated.");
        }



        public function addCustomPageLink()
        {       
            $params=array(
              'page_name'=>$this->data['page_name'],
              'content'=>$this->data['content'],              
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'status'=>$this->data['status'],
              'is_custom_link'=>2,
              'open_new_tab'=>isset($this->data['open_new_tab'])?$this->data['open_new_tab']:1
            );
            if (isset($this->data['page_name_trans'])){             
                if ($this->functions->okToDecode()){
                    $params['page_name_trans']=json_encode($this->data['page_name_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['page_name_trans']=json_encode($this->data['page_name_trans']);              
            } else $params['page_name_trans']='';
            
                        
            if (empty($this->data['id'])){ 
                $last_insert_id = $this->functions->insertData('mt_custom_page', $params);
                if ($last_insert_id!== false){                  
                
                    $this->details=$last_insert_id;
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","Successful");                      
                    }
                } else {                            
                    unset($params['date_created']);
                    $params['date_modified']=$this->functions->dateNow();                
                    //$res = $this->updateData('{{custom_page}}' , $params ,'id',$this->data['id']);
                    $res = $this->functions->updateData('mt_custom_page' , $params ,'id',$this->data['id']);

                    if ($res){
                        $this->code=1;
                        $this->msg=$this->functions->translation("default",'Page updated.');  
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            }                   
        }   



    public function customPageList()
        {
            $slug=Config::$baseUrl."/admin/".$_GET['slug'];
            $stmt = $this->db->prepare("SELECT * FROM mt_custom_page ORDER BY slug_name ASC");

            // Execute the statement
            $stmt->execute();

            // Fetch all results as an associative array
            $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Check if there are any results
         if ($res) {
            foreach ($res as $val) {                                        
                    $action="<div class=\"options\">
                    <a href=\"$slug/Do/Add/id/$val[id]\" >".$this->functions->translation("default","Edit")."</a>
                    <a href=\"javascript:;\" class=\"row_del\" rev=\"$val[id]\" >".$this->functions->translation("default","Delete")."</a>
                    </div>";              
                   /*$date=Yii::app()->functions->prettyDate($val['date_created']); 
                   $date=Yii::app()->functions->translateDate($date);    */
                   $date=$this->functions->FormatDateTime($val['date_created']);
                   $feed_data['aaData'][]=array(
                      $val['id'],
                      $val['slug_name'],
                      $val['page_name'].$action,
                      //Yii::app()->functions->limitDescription($val['content']),
                      '<div class="limit-content">'.$val['content'].'</div>',
                      //$date."<br/>".$val['status']
                      "$date<br/><span class=\"tag ".$val['status']."\">".($val['status'])."</span>",
                   );                  
               }
               $this->otableOutput($feed_data);
            }
            $this->otableNodata();                                  
        }



    public function adminForgotPass()
        {           
            if ( isset($this->data['email_address'])){
                if ($res=$this->functions->isAdminExist($this->data['email_address']) ){ 
                    //print_r($res);die();   
                    //echo  $res['email_address']; die();             
                    $new_pass=$this->functions->generateCode();
                    //$new_pass='123456';
                    $params=array(
                      'lost_password_code'=> $new_pass,
                      'password'=>md5($new_pass)
                      );        


                    if ($this->functions->updateData('mt_admin_user' , $params ,'admin_id',$res['admin_id'])){
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","An email address was sent to your.");
                        
                        
                        /*$tpl=EmailTPL::adminForgotPassword($new_pass);                                            
                        $sender=Yii::app()->functions->getOptionAdmin('website_contact_email');
                        $to=$res[0]['email_address'];                       
                        if (!sendEmail($to,$sender,t("Admin Forgot Password"),$tpl)){               
                            $this->details="failed $new_pass";
                        } else $this->details="ok mail $new_pass";*/
                    
                        $data=$res;
                        
                        $enabled = $this->functions->getOptionAdmin("admin_forgot_password_email");
                        if($enabled==1){
                            $lang="en";   
                            $subject = $this->functions->getOptionAdmin("admin_forgot_password_tpl_subject_$lang");
                            $tpl = $this->functions->getOptionAdmin("admin_forgot_password_tpl_content_$lang");                           
                            
                            if(!empty($subject)){
                                $tpl=$this->functions->smarty('restaurant_name', 
                                isset($data['restaurant_name'])?$data['restaurant_name']:''
                                ,$tpl); 
                            }                       
                            if (!empty($tpl)){
                                $tpl=$this->functions->smarty('restaurant_name', 
                                isset($data['restaurant_name'])?$data['restaurant_name']:''
                                ,$tpl);
                                
                                $tpl=$this->functions->smarty('newpassword', $new_pass ,$tpl);
                                
                                $tpl=$this->functions->smarty('sitename',$this->functions->getOptionAdmin('website_title'),$tpl);
                                $tpl= $this->functions->smarty('siteurl',Config::$baseUrl,$tpl);
                            }           
                            if (!empty($tpl) && !empty($subject)){
                                $to = isset($data['email_address'])?$data['email_address']:'';
                                
                                $this->functions->sendEmail($to,'',$subject, $tpl);
                            }                       
                        }                   
                        
                        
                    } else $this->msg=$this->functions->translation("default","ERROR: Cannot update.");                
                } else $this->msg=$this->functions->translation("default","Sorry but we cannot find your email address.");
            } else $this->msg=$this->functions->translation("default","Email address is required");        
        } 



         public function forgotPassword()
        {      


            $lang='en';           
            $forgot_pass_action = isset($this->data['forgot_pass_action'])?$this->data['forgot_pass_action']:'';
            switch ($forgot_pass_action) {
                case "email":                   
                    $req=array(
                      'username-email'=>$this->functions->translation("default","Email is required")
                    );  
                    $this->functions->email(array(
                     'username-email'=>$this->functions->translation("default","Invalid email address, please enter valid email")
                    ),$this->data);
                    $this->functions->required($req,$this->data);
                    if ($this->functions->validate()){
                        $email = isset($this->data['username-email'])?$this->data['username-email']:'';
                        if ( $res=$this->functions->isClientExist_for_password_forgot($email)){                            
                            $token=md5(date('c').$res['client_id']);
                            $params=array('lost_password_token'=>$token);                           
                             

                            $up = $this->functions->updateData('mt_client' , $params ,'client_id',$res['client_id']);                        
                            $this->code=1; $this->msg=$this->functions->translation("default","We sent your forgot password link, Please follow that link. Thank You.");
                            $this->details = array(
                               'verification_type'=>$forgot_pass_action,
                            );
                            $to=trim($res['email_address']);
                            
                            try {
                                
                                

                                $link = Config::$baseUrl."/forgotpassword?token=".$token;
                                
                                
                                $resp = $this->functions->getNotificationTemplate('customer_forgot_password',$lang);
                                
                                $resp['email_content'] =  stripslashes($resp['email_content']);
                                $resp['email_subject'] =  stripslashes($resp['email_subject']);
                                
                                $email_content = $resp['email_content'];
                                $email_subject = $resp['email_subject'];
                                $data = array(
                                  'firstname'=>$res['first_name'],
                                  'lastname'=>$res['last_name'],
                                  'change_pass_link'=>$link,
                                  'sitename'=>$this->functions->getOptionAdmin('website_title'),
                                  'siteurl'=>$this->functions->websiteUrl()
                                );                              
                                $email_content = $this->functions->replaceTags($email_content,$data);
                                $email_subject = $this->functions->replaceTags($email_subject,$data);
                                                        
                                $this->functions->sendEmail($to,'',$email_subject, $email_content );      
                                
                            } catch (Exception $e) {
                                $this->msg = $e->getMessage();
                            }
                            
                        } else $this->msg=$this->functions->translation("default","Sorry but your Email address does not exist in our records.");
                    } else $this->msg=$this->functions->getErrorAsHTML();
                    break;
                    
                case "sms":                     
                    $phone_number = isset($this->data['forgot_phone_number'])?$this->data['forgot_phone_number']:'';                                        
                    $req=array(
                      'forgot_phone_number'=>$this->functions->translation("default","Phone number is required")
                    );  
                    
                    if(strlen($phone_number)<=4){
                        $Validator->msg[] = $this->functions->translation("default","Phone number is required");
                    }           
                    
                    $this->functions->required($req,$this->data);
                    if ($this->functions->validate()){                        
                        try {
                            
                           $code = $this->functions->generateRandomKey(5);
                           $res = $this->functions->getCustomerByPhone_forgotpassword( str_replace("+","",$phone_number) );
                           $token=md5(date('c').$res['client_id']);                                                      
                           
                           $this->functions->updateCustomerProfile($res['client_id'],array(
                             'mobile_verification_code'=>$code,
                             'mobile_verification_date'=>$this->functions->dateNow(),
                             'lost_password_token'=>$token,
                             'ip_address'=>$_SERVER['REMOTE_ADDR']
                           ));
                           
                           $resp = $this->functions->getNotificationTemplate('customer_forgot_password',$lang,'sms');
                           $data = array(
                              'firstname'=>$res['first_name'],
                              'lastname'=>$res['last_name'],
                              'code'=>$code,                              
                            );      
                            $sms_content = $resp['sms_content'];
                            $sms_content = $this->functions->replaceTags($sms_content,$data);
                            //$sms = Yii::app()->functions->sendSMS($phone_number,$sms_content);
                            if($sms['msg']=="process"){
                                $this->code=1; $this->msg=$this->functions->translation("default","We have sent verification code in your phone number");
                                $this->details = array(                               
                                  'verification_type'=>$forgot_pass_action,
                                  'url'=>Config::$baseUrl."/changepassword_sms?token=".$token
                                );

                            } else $this->msg = $this->functions->translation("default","Failed sending sms [error] ".$sms['msg']);
                             
                        } catch (Exception $e) {
                           $this->msg = $e->getMessage();
                        }
                    } else $this->msg=$this->functions->getErrorAsHTML();
                    break;
            
                default:
                    $this->msg = $this->functions->translation("default","Invalid forgot password selection");
                    break;
            }
        }


        public function changePassword()
      {                       
        
      $req=array(
        'token'=>$this->functions->translation("default","Token is missing")
      );    
      if ($this->data['password']!=$this->data['confirm_password']){
        $this->msg=$this->functions->translation("default","Confirm password does not match.");
        return ;
      }     
      $this->functions->required($req,$this->data);
      if ($this->functions->validate()){
          if ( $res=$this->functions->getLostPassToken($this->data['token'])){            
            $params=array(
              'password'=>md5($this->data['password']),
              'date_modified'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'lost_password_token'=>md5(date('c'))
            );          
            if ( $this->functions->updateData("mt_client",$params,'client_id',$res['client_id'])){
              $this->code=1;
              $this->msg=$this->functions->translation("default","Successful. Your password has been changed.");
            } else $this->msg=$this->functions->translation("default","ERROR");         
          } else $this->msg=$this->functions->translation("default","ERROR: Cannot update password");
        } else $this->msg=$this->functions->translation("default","Token is missing");
      }          




      public function VoucherListNew()
    {
      $slug = $this->data['slug'];

$and = '';
if (isset($this->data['voucher_owner'])) {
    $stmt = "
    SELECT a.*,
    (
        SELECT count(*) 
        FROM mt_order
        WHERE voucher_code = a.voucher_name
    ) as total_used
    FROM mt_voucher_new a
    WHERE voucher_owner = :voucher_owner
    ORDER BY voucher_id DESC
    ";

    $params = [':voucher_owner' => $this->data['voucher_owner']];
} else {
    $merchant_id = $this->functions->getMerchantID();
    $stmt = "
    SELECT a.*,
    (
        SELECT count(*) 
        FROM mt_order
        WHERE voucher_code = a.voucher_name
    ) as total_used
    FROM mt_voucher_new a
    WHERE merchant_id = :merchant_id
    ORDER BY voucher_id DESC
    ";

    $params = [':merchant_id' => $merchant_id];
}

$query = $this->db->prepare($stmt);
$query->execute($params);
$rows = $query->fetchAll(PDO::FETCH_ASSOC);

// If you need to process the rows
if (is_array($rows) && count($rows) >= 1) {
    foreach ($rows as $val) {                 
              $chk="<input type=\"checkbox\" name=\"row[]\" value=\"$val[voucher_id]\" class=\"chk_child\" >";      
              $action="<div class=\"options\">
              <a href=\"$slug/id/$val[voucher_id]\" >".$this->functions->translation("default","Edit")."</a>
              <a href=\"javascript:;\" class=\"row_del\" rev=\"$val[voucher_id]\" >".$this->functions->translation("default","Delete")."</a>
              </div>";
              
              
              if ( $val['total_used']>0){
                $used='<a class="voucher-details" href="javascript:;" data-id="'.$val['voucher_name'].'">'.
                $val['total_used'].'</a>';
              } else $used='';           
              
              if ($val['voucher_type']=="percentage"){
                $amt=$this->functions->normalPrettyPrice($val['amount']). " %";
              } else $amt=$this->functions->normalPrettyPrice($val['amount']);        
                            
              $date=$this->functions->FormatDateTime($val['date_created']);
              
              $feed_data['aaData'][]=array(
                $val['voucher_id'],
                $val['voucher_name'].$action,               
                ($val['voucher_type']),
                $amt,             
                $this->functions->FormatDateTime($val['expiration'],false),
                $used,
                "$date<br/><span class=\"tag ".$val['status']."\">".($val['status'])."</span>"
                //$date."<div>".Yii::t("default",$val['status'])."</div>"
              );
            }
            $this->otableOutput($feed_data);
          }           
          $this->otableNodata();  
     }



      public function InvoiceList()
  {
        
   $aColumns = array(
        'invoice_number', 'merchant_name', 'invoice_terms',
        'invoice_total', 'date_from', 'status', 'pdf_filename'
    );

    $sWhere = ''; $sOrder = ''; $sLimit = '';

    $sTable = "mt_invoice";

    // Assuming ajaxDataTables generates SQL parts with placeholders
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Construct the SQL statement
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.*
        FROM $sTable a
        $sWhere
        $sOrder
        $sLimit
    ";

    // For debugging, you may want to output or log the query
    if (isset($_GET['debug'])) {
        echo htmlspecialchars($stmt); // Escape output for safety
    }

    // Prepare and execute the statement
    $query = $this->db->prepare($stmt);
    $query->execute();

    // Fetch the results
    $results = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if results are valid
    if (is_array($results) && count($results) >= 1) {
        // Calculate total records
        $stmt2 = "SELECT FOUND_ROWS() AS total_records";
        $query2 = $this->db->prepare($stmt2);
        $query2->execute();
        $totalRecords = $query2->fetch(PDO::FETCH_ASSOC)['total_records'];

        // Prepare the response data
        $feed_data = array();
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $totalRecords;
        $feed_data['iTotalDisplayRecords'] = $totalRecords;

        // Initialize the data array
        $feed_data['data'] = array();

        // Process and format results for output
        foreach ($results as $val) {
         if (isset($_GET['debug'])){dump($val);}
         
         $action='';
         
         if(!empty($val['pdf_filename']) && $val['pdf_filename']!=".pdf" ){     
            $link=$this->functions->uploadURL()."/invoice/".$val['pdf_filename'];
            $action="<a href=\"$link\" target=\"_blank\" class=\"uk-button uk-button-primary\">".$this->functions->translation("default","View")."</a>";
         }    
         
         $action.='<br/><br/>';
         $action.='<a href="javascript:;" class="uk-button invoice_view_history" data-id="'.$val['invoice_number'].'" >'.$this->functions->translation("default","History").'</a>';
         
         $edit_actions='<div class="options">';
         $edit_actions.='<a href="javascript:;" data-id="'.$val['invoice_number'].'" class="edit_invoice">'.$this->functions->translation("default","Edit").'</a>';
         $edit_actions.="&nbsp;";
         $edit_actions.='<a href="javascript:;" class="row_del" rev="'.$val['invoice_number'].'">'.$this->functions->translation("default","Delete").'</a>';
         $edit_actions.='</div>';
         
         $date_created=$this->functions->prettyDate($val['date_created']);
         $date_created.=" ".$this->functions->prettyTime($val['date_created']);
         $feed_data['aaData'][]=array(      
           $val['invoice_number'],
           stripslashes($val['merchant_id']).$edit_actions,
           stripslashes($val['merchant_name']),          
           $this->functions->prettyInvoiceTerms($val['invoice_terms']),           
           $this->functions->prettyDate($val['date_from'])." - ".$this->functions->prettyDate($val['date_to']),
           $this->functions->formatNumber($val['invoice_total']),
           $date_created."<span class=\"tag $val[status]\">".$this->functions->translation("default",$val['status'])."</span>",
           "<span class=\"tag $val[payment_status]\">".$this->functions->translation("default",$val['payment_status'])."</span>",
           $action
         );
          
      }                   
            
      $this->otableOutput($feed_data);  
    }
      $this->otableNodata();
  }



 public function payoutChangeStatus()
  {     
      $this->validator=new Validator;
      $req=array(
       'withdrawal_id'=>("withdrawal id is required"),
       'status'=>("Status is required"),
      );
      $this->validator->required($req,$this->data);
      if ( $this->validator->validate()){
        $params=array(
          'status'=>$this->data['status'],
          'viewed'=>2
        );        
        
        if ( $this->functions->updateData("mt_withdrawal",$params,'withdrawal_id',$this->data['withdrawal_id'])){
          $this->code=1;
          $this->msg=("Successful");
        } else $this->msg=("Failed cannot update records");      
      } else $this->msg=$this->validator->getErrorAsHTML();
  }























  public function incomingWithdrawals()
{   
    $show_action = true;
    $and = "WHERE status IN ('pending')";   

    // Filtering based on status
    if (isset($this->data['w-list'])) {
        switch ($this->data['w-list']) {
            case "cancel":
                $and = "WHERE status IN ('cancel')";
                $show_action = false;
                break;
            case "reversal":
                $and = "WHERE status IN ('reversal')";
                $show_action = false;
                break;
            case "paid":          
                $and = "WHERE status IN ('paid')";
                $show_action = true;
                break;
            case "denied":          
                $and = "WHERE status IN ('denied')";
                $show_action = false;
                break;
            case "failed":  
                $and = "WHERE status NOT IN ('paid','pending','denied','approved','reversal')";
                $show_action = false;
                break;
            case "approved":    
                $and = "WHERE status IN ('approved')";
                $show_action = false;
                break;
            case "all":    
                $and = "";
                $show_action = false;
                break;
            default:
                break;
        }
    }
    
    // Filtering based on date range
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $start_date = $this->data['start_date'] . " 00:00:00";
            $end_date = $this->data['end_date'] . " 23:59:59";
            
            if (!empty($and)) {
                $and .= " AND date_created BETWEEN :start_date AND :end_date";
            } else {
                $and = " WHERE date_created BETWEEN :start_date AND :end_date";
            }
        }
    }
    
    // Filtering based on merchant_id
    if (isset($this->data['merchant_id']) && !empty($this->data['merchant_id'])) {
        if (!empty($and)) {
            $and .= " AND merchant_id = :merchant_id";
        } else {
            $and = " WHERE merchant_id = :merchant_id";
        }
    }
    
    // Prepare the SQL statement
    $stmt = "
        SELECT a.*,
        (
            SELECT restaurant_name 
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id
        ) AS merchant_name
        FROM mt_withdrawal a
        $and
        ORDER BY withdrawal_id DESC
    ";

    // Store the statement in session
    $_SESSION['kr_export_stmt'] = $stmt;

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);

    // Bind parameters
    if (isset($start_date) && isset($end_date)) {
        $query->bindParam(':start_date', $start_date);
        $query->bindParam(':end_date', $end_date);
    }
    if (isset($this->data['merchant_id']) && !empty($this->data['merchant_id'])) {
        $query->bindParam(':merchant_id', $this->data['merchant_id']);
    }

    $query->execute();
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    // Process each result
    if (is_array($rows) && count($rows) >= 1) {
        $feed_data = ['aaData' => []];
        foreach ($rows as $val) {
            $method = $this->functions->translation("default", "Paypal to") . " " . $val['account'];
            if ($val['payment_method'] == "bank") {
                $method = $this->functions->translation("Bank to") . " " . $val['bank_account_number'];
            }

            $action = "";
            if ($this->data['w-list'] == "paid") {
                $action = "<a href=\"javascript:;\" class=\"payout_action\" data-id=\"{$val['withdrawal_id']}\" data-status=\"reversal\">" . $this->functions->translation("default", "Apply reversal") . "</a><br/>";
            } else {
                $action = "<a href=\"javascript:;\" class=\"payout_action\" data-id=\"{$val['withdrawal_id']}\" data-status=\"approved\">" . $this->functions->translation("default", "approved") . "</a><br/>";
                $action .= "<a href=\"javascript:;\" class=\"payout_action\" data-id=\"{$val['withdrawal_id']}\" data-status=\"denied\">" . $this->functions->translation("default", "denied") . "</a>";
            }

            $date_created = $this->functions->FormatDateTime($val['date_created'], false);
            $date_to_process = $this->functions->FormatDateTime($val['date_to_process'], false);

            $bank_info = '';
            if ($val['payment_method'] == "bank") {
                $bank_info = "<br/><a href=\"javascript:;\" data-id=\"{$val['withdrawal_id']}\" class=\"view-bank-info\">" . $this->functions->translation("default", "View bank info") . "</a>";
            }

            $feed_data['aaData'][] = [
                $val['withdrawal_id'],
                $val['merchant_name'],
                $method . $bank_info,
                $this->functions->formatNumber($val['amount']),
                $this->functions->formatNumber($val['current_balance']),
                "<span class=\"uk-badge withdrawal-status\">" . $val['status'] . "</span>",
                $date_created,
                $date_to_process,
                $show_action ? $action : ''
            ];
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}






public function analyticsSetting()
        {
        
            $this->functions->updateOptionAdmin("admin_header_codes",
            isset($this->data['admin_header_codes'])?$this->data['admin_header_codes']:'');
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Setting saved");   
        } 








        public function customerList()
{
    $slug = $this->data['slug'];
    $aColumns = array('client_id', 'first_name', 'email_address', 'contact_phone', 'social_strategy', 'status');

    $sWhere = '';
    $sOrder = '';
    $sLimit = '';
    $sTable = "mt_client";

    // Get datatables query parts
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Add condition to only include clients with NULL author_url
    if (!empty($sWhere)) {
        $sWhere .= " AND a.author_url IS NULL";
    } else {
        $sWhere = "WHERE a.author_url IS NULL";
    }

    // Address subquery based on location setting
    if ($this->functions->isSearchByLocation()) {
        $sub_query = "(
            select concat(street,' ',location_name)
            from mt_address_book_location
            where client_id=a.client_id
            limit 0,1
        ) as address";
    } else {
        $sub_query = "(
            select concat(street,' ',city,' ', state,' ',zipcode)
            from mt_address_book
            where client_id=a.client_id
            limit 0,1
        ) as address";
    }

    // Full SQL statement
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.*,
        $sub_query
        FROM $sTable a
        $sWhere
        $sOrder
        $sLimit
    ";

    // Store the query for export (without LIMIT)
    $stmt2 = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.*             
        FROM $sTable a
        $sWhere
        $sOrder
    ";
    $_SESSION['kr_export_stmt'] = $stmt2;

    // Execute the SQL query using PDO
    try {
        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        // Fetch total record count
        $queryTotal = $this->db->query("SELECT FOUND_ROWS()");
        $iTotalRecords = $queryTotal->fetchColumn();

        // Prepare response for datatables
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $link = Config::$baseUrl.'/admin/customerlist/Do/Add/id/'.$val['client_id'];
            $action = "<div class=\"options\">
                    <a href=\"$link\" >Edit</a>
                    <a href=\"javascript:;\" class=\"row_del\" rev=\"$val[client_id]\">Delete</a>
                </div>";
            $date = $this->functions->FormatDateTime($val['date_created']);

            $feed_data['aaData'][] = array(
                $val['client_id'],
                $val['first_name'] . " " . $val['last_name'] . $action,
                $val['email_address'],
                $val['contact_phone'],
                $val['address'],
                $val['social_strategy'],
                "$date<br/><span class=\"tag " . $val['status'] . "\">" . ($val['status']) . "</span>",
            );
        }

        $this->otableOutput($feed_data);

    } catch (PDOException $e) {
        $this->otableNodata();
    }
}




public function merchantcustomerList()
{
    $slug = $this->data['slug'];
    $aColumns = array('client_id', 'first_name', 'email_address', 'contact_phone', 'social_strategy', 'status');

    $mid = $this->functions->getMerchantID();

    $sWhere = '';
    $sOrder = '';
    $sLimit = '';
    $sTable = "mt_client";

    // Get SQL parts for DataTables
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Add merchant_id condition
    if (!empty($mid)) {
        if (!empty($sWhere)) {
            $sWhere .= " AND a.merchant_id = " . intval($mid) . " ";
        } else {
            $sWhere = "WHERE a.merchant_id = " . intval($mid) . " ";
        }
    }

    // Add author_url IS NULL condition
    if (!empty($sWhere)) {
        $sWhere .= " AND a.author_url IS NULL";
    } else {
        $sWhere = "WHERE a.author_url IS NULL";
    }

    // Choose sub-query depending on search by location condition
    if ($this->functions->isSearchByLocation()) {
        $sub_query = "(
            select concat(street,' ',location_name)
            from mt_address_book_location
            where client_id=a.client_id
            limit 0,1
        ) as address";
    } else {
        $sub_query = "(
            select concat(street,' ',city,' ', state,' ',zipcode)
            from mt_address_book
            where client_id=a.client_id
            limit 0,1
        ) as address";
    }

    // Prepare the SQL statement with WHERE, ORDER, and LIMIT
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.*,
        $sub_query
        FROM $sTable a
        $sWhere
        $sOrder
        $sLimit
    ";

    // Store query for export
    $stmt2 = "
        SELECT SQL_CALC_FOUND_ROWS 
        a.*             
        FROM $sTable a
        $sWhere
        $sOrder
    ";
    $_SESSION['kr_export_stmt'] = $stmt2;

    try {
        $query = $this->db->prepare($stmt);
        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        $queryTotal = $this->db->query("SELECT FOUND_ROWS()");
        $iTotalRecords = $queryTotal->fetchColumn();

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $link = Config::$baseUrl . '/merchant/merchant_customer_list/Do/Add/id/' . $val['client_id'];
            $action = "<div class=\"options\">
                    <a href=\"$link\" >Edit</a>
                    <a href=\"javascript:;\" class=\"row_del\" rev=\"$val[client_id]\">Delete</a>
                </div>";
            $date = $this->functions->FormatDateTime($val['date_created']);

            $feed_data['aaData'][] = array(
                $val['client_id'],
                $val['first_name'] . " " . $val['last_name'] . $action,
                $val['email_address'],
                $val['contact_phone'],
                $val['address'],
                $val['social_strategy'],
                "$date<br/><span class=\"tag " . $val['status'] . "\">" . ($val['status']) . "</span>",
            );
        }

        $this->otableOutput($feed_data);

    } catch (PDOException $e) {
        $this->otableNodata();
    }
}









    public function customerAdd()
        {           
                        

           
            
            $params=array(
              'first_name'=>($this->data['first_name']),
              'last_name'=>($this->data['last_name']),
              'email_address'=>($this->data['email_address']),
             
              'status'=>$this->data['status'],
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']           
            );  
            
                
            if (isset($this->data['password'])){
                if (!empty($this->data['password'])){
                    $params['password']=md5($this->data['password']);
                }
            }           
                        
           /** update 2.3*/
            if (isset($this->data['custom_field1'])){
                $params['custom_field1']=!empty($this->data['custom_field1'])?$this->data['custom_field1']:'';
            }
            if (isset($this->data['custom_field2'])){
                $params['custom_field2']=!empty($this->data['custom_field2'])?$this->data['custom_field2']:'';
            }                       
            
            
            if (isset($this->data['id']) && is_numeric($this->data['id'])){             
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();                
                

                $res = $this->functions->updateData('mt_client' , $params ,'client_id',$this->data['id']);

                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Client updated.');  
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else {  

                 $last_insert_id = $this->functions->insertData('mt_client', $params);
                if ($last_insert_id!== false){              
                
                    $this->details=$last_insert_id;   
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Client added.');                   
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }
            
        }



        public function subscriberList()
{
    // Define the SQL query
    $stmt = "SELECT * FROM mt_newsletter ORDER BY id DESC";

    // Save the query for export, if needed
    $_SESSION['kr_export_stmt'] = $stmt;

    // Prepare and execute the query using PDO
    $pdo = $this->db; // Assuming you have a PDO instance in your controller class
    $query = $pdo->prepare($stmt);
    $query->execute();
    
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $action = "<div class=\"options\">
                <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['id']}\">" . 
                $this->functions->translation("default", "Delete") . "</a>
                </div>";
            
            // Formatting the date using the FormatDateTime method
            $date = $this->functions->FormatDateTime($val['date_created']);
            
            // Building feed data for output
            $feed_data['aaData'][] = array(
                $val['id'],
                $val['email_address'] . $action,
                $date,
                $val['ip_address']
            );
        }
        // Output the table data
        $this->otableOutput($feed_data);
    } else {
        // No data found case
        $this->otableNodata();
    }
}



   public function adminCustomerReviews()
{
    $slug = $this->data['slug'];

    // Define the SQL query with PDO-friendly placeholders
    $stmt = "
        SELECT a.*,
        (
            SELECT CONCAT(first_name, ' ', last_name)
            FROM mt_client
            WHERE client_id = a.client_id
        ) AS client_name,
        (
            SELECT restaurant_name
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id
        ) AS merchant_name
        FROM mt_review a
        ORDER BY id DESC
    ";

    // Prepare and execute the query using PDO
    $pdo = $this->db; // Assuming you have a PDO instance in your controller class
    $query = $pdo->prepare($stmt);
    $query->execute();
    
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            $action = "<div class=\"options\">
                <a href=\"$slug/Do/Add/id/{$val['id']}\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['id']}\">" . $this->functions->translation("default", "Delete") . "</a>
            </div>";

            // Check if the current controller is "admin" and if the merchant can edit reviews
            if ($this->data['currentController'] != "admin" && 
                $this->functions->getOptionAdmin('merchant_can_edit_reviews') == "yes") {
                $action = '';
            }

            // Format the date
            $date = $this->functions->FormatDateTime($val['date_created']);

            // Construct the feed data
            $feed_data['aaData'][] = array(
                $val['id'],
                !empty($val['merchant_name']) ? stripslashes($val['merchant_name']) . $action : stripslashes($val['reply_from']) . $action,
                !empty($val['client_name']) ? stripslashes($val['client_name']) : '-',
                $val['review'],
                $val['rating'],
                "$date<br/><span class=\"tag {$val['status']}\">" . $val['status'] . "</span>"
            );
        }
        // Output the data in a table
        $this->otableOutput($feed_data);
    } else {
        // No data found
        $this->otableNodata();
    }
}



public function merchantCommission_x()
{
    $where = '';
    $and = '';  
    $and_date = '';       
    $where_params = '';
    $and_params = '';

    // Date range filtering
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])){
            $and = " AND a.date_created BETWEEN '".$this->data['start_date']." 00:00:00' AND '".$this->data['end_date']." 23:59:00'";
            $and_date = " AND date_created BETWEEN '".$this->data['start_date']." 00:00:00' AND '".$this->data['end_date']." 23:59:00'";
            
            $and_params .= "a.date_created|".$this->data['start_date']." 00:00:00";
            $and_params .= ",".$this->data['end_date']." 23:59:00";
        }
    }

    // Query filtering for last 15 days
    if ($this->data['query'] == "last15") {
        $start_date = date("Y-m-d", strtotime('-15 days'));
        $end_date = date("Y-m-d");

        $and = " AND a.date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";
        $and_date = " AND date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";

        $and_params .= "a.date_created|".$start_date." 00:00:00";
        $and_params .= ",".$end_date." 23:59:00";
    } elseif ($this->data['query'] == "last30") {
        $start_date = date("Y-m-d", strtotime('-30 days'));
        $end_date = date("Y-m-d");

        $and = " AND a.date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";
        $and_date = " AND date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";

        $and_params .= "a.date_created|".$start_date." 00:00:00";
        $and_params .= ",".$end_date." 23:59:00";
    } elseif ($this->data['query'] == "month") {
        $query_date = $this->data['query_date'];
        $start_date = date('Y-m-01', strtotime($query_date));
        $end_date = date('Y-m-t', strtotime($query_date));

        $and = " AND a.date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";
        $and_date = " AND date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";

        $and_params .= "a.date_created|".$start_date." 00:00:00";
        $and_params .= ",".$end_date." 23:59:00";
    }

    // Order status filtering
    $order_status_id = '';
    $order_status_raw = '';
    if (isset($this->data['stats_id']) && is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
        foreach ($this->data['stats_id'] as $stats_id) {
            $order_status_id .= "'".$stats_id."',";
            $order_status_raw .= "$stats_id,";
        }
        if (!empty($order_status_id)) {
            $order_status_id = rtrim($order_status_id, ',');
        }
    }

    if (!empty($order_status_id)) {         
        $where = " WHERE a.status IN ($order_status_id)";          
        $and_date .= " AND status IN ($order_status_id)";
        $where_params .= "a.status_in|$order_status_raw";
    } else {
        $initial_status = $this->functions->initialStatus();
        $where = " WHERE a.status NOT IN ('$initial_status')";
        $and_date .= " AND status NOT IN ('$initial_status')";
        $where_params .= "a.status_not_in|$order_status_raw";
    }

    // Merchant ID filtering
    if ($this->data['merchant_id'] >= 1) {
        $and .= " AND a.merchant_id = '".$this->data['merchant_id']."'";
    }

    // Payment type filtering
    if (isset($this->data['payment_type'])) {
        if ($this->data['payment_type'] == 2) { // cash
            $and_date .= " AND payment_type IN ('cod','pyr','ccr','ocr')";
            $and .= " AND payment_type IN ('cod','pyr','ccr','ocr')";
            $and_params .= "&payment_type_in=payment_type|cod,pyr,ccr,ocr";
        } elseif ($this->data['payment_type'] == 3) { // card
            $and_date .= " AND payment_type NOT IN ('cod','pyr','ccr','ocr')";
            $and .= " AND payment_type NOT IN ('cod','pyr','ccr','ocr')";
            $and_params .= "&payment_type_not_in=cod,pyr,ccr,ocr";
        }       
    } 

    // Prepare the SQL statement
    $stmt = "
        SELECT a.merchant_id,
            (
            SELECT restaurant_name 
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id 
            ) AS merchant_name,
            SUM(total_w_tax) - SUM(card_fee) AS total_order,
            SUM(card_fee) AS card_fee1,
            SUM(total_commission) AS total_commission
        FROM mt_order a
        LEFT JOIN mt_merchant b
        ON a.merchant_id = b.merchant_id
        $where
        $and
        AND b.is_commission = '2'
        AND a.request_from != 'pos'
        GROUP BY a.merchant_id
        ORDER BY MIN(a.order_id) DESC
        LIMIT 0, 2000
    ";



    // Execute the query
$_SESSION['kr_export_stmt'] = $stmt;




    $query = $this->db->prepare($stmt);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_ASSOC);

    // Initialize total_commission
    $total_commission = 0;
    $feed_data['aaData'] = [];

    // Process each result
    if($results){
    foreach ($results as $val) {          
        $link = Config::$baseUrl . "/admin/merchantcommissiondetails";            
        $link .= "?mtid=" . $val['merchant_id'];
        $link .= "&where=$where_params";
        $link .= "&and=$and_params";

        $total_commission += $val['total_commission'];

        $action = "<a href=\"$link\" >" . $this->functions->translation("default","Details") . "</a>";
        $date = $this->functions->prettyDate($val['date_created'], true);
        $date = $this->functions->translateDate($date);

        $feed_data['aaData'][] = [
            $val['merchant_id'],
            $val['merchant_name'],
            $this->functions->formatNumber($val['total_order']),
            $this->functions->normalPrettyPrice($val['card_fee1']),
            $this->functions->formatNumber($val['total_commission']),
            $action             
        ];
    }         

    // Set total_commission and output the table
    $feed_data['total_commission'] = $this->functions->formatNumber($total_commission);
    $this->otableOutput($feed_data);
   }
    // If no data, output no data message
    $this->otableNodata(); 
}


public function merchantCommission()
{
    $where = '';
    $and = '';  
    $and_date = '';       
    $where_params = '';
    $and_params = '';

    // Date range filtering
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])){
            $and = " AND a.date_created BETWEEN '".$this->data['start_date']." 00:00:00' AND '".$this->data['end_date']." 23:59:00'";
            $and_date = " AND date_created BETWEEN '".$this->data['start_date']." 00:00:00' AND '".$this->data['end_date']." 23:59:00'";
            
            $and_params .= "a.date_created|".$this->data['start_date']." 00:00:00";
            $and_params .= ",".$this->data['end_date']." 23:59:00";
        }
    }

    // Query filtering for last 15 days
    if ($this->data['query'] == "last15") {
        $start_date = date("Y-m-d", strtotime('-15 days'));
        $end_date = date("Y-m-d");

        $and = " AND a.date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";
        $and_date = " AND date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";

        $and_params .= "a.date_created|".$start_date." 00:00:00";
        $and_params .= ",".$end_date." 23:59:00";
    } elseif ($this->data['query'] == "last30") {
        $start_date = date("Y-m-d", strtotime('-30 days'));
        $end_date = date("Y-m-d");

        $and = " AND a.date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";
        $and_date = " AND date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";

        $and_params .= "a.date_created|".$start_date." 00:00:00";
        $and_params .= ",".$end_date." 23:59:00";
    } elseif ($this->data['query'] == "month") {
        $query_date = $this->data['query_date'];
        $start_date = date('Y-m-01', strtotime($query_date));
        $end_date = date('Y-m-t', strtotime($query_date));

        $and = " AND a.date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";
        $and_date = " AND date_created BETWEEN '".$start_date." 00:00:00' AND '".$end_date." 23:59:00'";

        $and_params .= "a.date_created|".$start_date." 00:00:00";
        $and_params .= ",".$end_date." 23:59:00";
    }

    // Order status filtering
    $order_status_id = '';
    $order_status_raw = '';
    if (isset($this->data['stats_id']) && is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
        foreach ($this->data['stats_id'] as $stats_id) {
            $order_status_id .= "'".$stats_id."',";
            $order_status_raw .= "$stats_id,";
        }
        if (!empty($order_status_id)) {
            $order_status_id = rtrim($order_status_id, ',');
        }
    }

    if (!empty($order_status_id)) {         
        $where = " WHERE a.status IN ($order_status_id) AND a.request_from != 'pos'";          
        $and_date .= " AND status IN ($order_status_id) AND request_from != 'pos'";
        $where_params .= "a.status_in|$order_status_raw";
    } else {
        $initial_status = $this->functions->initialStatus();
        $where = " WHERE a.status NOT IN ('$initial_status') AND a.request_from != 'pos'";
        $and_date .= " AND status NOT IN ('$initial_status') AND request_from != 'pos'";
        $where_params .= "a.status_not_in|$order_status_raw";
    }

    // Merchant ID filtering
    if ($this->data['merchant_id'] >= 1) {
        $and .= " AND a.merchant_id = '".$this->data['merchant_id']."'";
    }

    // Payment type filtering
    if (isset($this->data['payment_type'])) {
        if ($this->data['payment_type'] == 2) { // cash
            $and_date .= " AND payment_type IN ('cod','pyr','ccr','ocr')";
            $and .= " AND payment_type IN ('cod','pyr','ccr','ocr')";
            $and_params .= "&payment_type_in=payment_type|cod,pyr,ccr,ocr";
        } elseif ($this->data['payment_type'] == 3) { // card
            $and_date .= " AND payment_type NOT IN ('cod','pyr','ccr','ocr')";
            $and .= " AND payment_type NOT IN ('cod','pyr','ccr','ocr')";
            $and_params .= "&payment_type_not_in=cod,pyr,ccr,ocr";
        }       
    } 

    // Prepare the SQL statement
    $stmt = "
        SELECT a.merchant_id,
            (
            SELECT restaurant_name 
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id 
            ) AS merchant_name,
            SUM(total_w_tax) - SUM(card_fee) AS total_order,
            SUM(card_fee) AS card_fee1,
            SUM(total_commission) AS total_commission
        FROM mt_order a
        LEFT JOIN mt_merchant b
        ON a.merchant_id = b.merchant_id
        $where
        $and
        AND b.is_commission = '2'
        GROUP BY a.merchant_id
        ORDER BY MIN(a.order_id) DESC
        LIMIT 0, 2000
    ";

    // Store for export
    $_SESSION['kr_export_stmt'] = $stmt;

    // Execute the query
    $query = $this->db->prepare($stmt);
    $query->execute();
    $results = $query->fetchAll(PDO::FETCH_ASSOC);

    // Initialize total_commission
    $total_commission = 0;
    $feed_data['aaData'] = [];

    // Process each result
    if ($results) {
        foreach ($results as $val) {          
            $link = Config::$baseUrl . "/admin/merchantcommissiondetails";            
            $link .= "?mtid=" . $val['merchant_id'];
            $link .= "&where=$where_params";
            $link .= "&and=$and_params";

            $total_commission += $val['total_commission'];

            $action = "<a href=\"$link\" >" . $this->functions->translation("default", "Details") . "</a>";
            $date = $this->functions->prettyDate($val['date_created'], true);
            $date = $this->functions->translateDate($date);

            $feed_data['aaData'][] = [
                $val['merchant_id'],
                $val['merchant_name'],
                $this->functions->formatNumber($val['total_order']),
                $this->functions->normalPrettyPrice($val['card_fee1']),
                $this->functions->formatNumber($val['total_commission']),
                $action             
            ];
        }

        // Set total_commission and output the table
        $feed_data['total_commission'] = $this->functions->formatNumber($total_commission);
        $this->otableOutput($feed_data);
    }

    // If no data, output no data message
    $this->otableNodata(); 
}






























public function export()
        {   

             require_once __DIR__ . '/../../vendor/ExcelFormat.php';  

            $merchant_id=$this->functions->getMerchantID();
            
            if (!empty($_SESSION['kr_export_stmt'])){
                $stmt= $_SESSION['kr_export_stmt'];
               
               //echo $stmt;
                
                
                                                
                switch ($this->data['rpt']) {
                    case 'sales-report':
                        if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
                              
                            $csvdata=array();
                            $datas=array();  
                            foreach ($res as $val) {                                    
                                $item='';                               
                                $date=date('m-d-Y G:i:s',strtotime($val['date_created']));                  
                                $latestdata[]=array(                      
                                  $val['order_id'],
                                  $val['client_name'],
                                  $val['item'],
                                  $val['trans_type'],
                                  $val['payment_type'],
                                  $this->functions->prettyFormat($val['sub_total'],$merchant_id),
                                  $this->functions->prettyFormat($val['taxable_total'],$merchant_id),
                                  $this->functions->prettyFormat($val['total_w_tax'],$merchant_id),
                                  $val['status'],
                                  $date
                                );                  
                            }                               
                            unset($data);
                            $data=$latestdata;                          
                            
                        }   
                        
                        if (is_array($data) && count($data)>=1){
                            $csvdata=array();
                            $datas=array();
                            foreach ($data as $val) {                   
                                foreach ($val as $key => $vals) {
                                    $datas[]=$vals;
                                }
                                $csvdata[]=$datas;
                                unset($datas);
                            }   
                        }           
                        
                        $header=array(
                        $this->functions->translation("default","Ref#"),
                        $this->functions->translation("default","Client Name"),
                        $this->functions->translation("default","Item"),
                        $this->functions->translation("default","Trans Type"),
                        $this->functions->translation("default","Payment Type"),
                        $this->functions->translation("default","Total"),
                        $this->functions->translation("default","Tax"),
                        $this->functions->translation("default","Total W/Tax"),
                        $this->functions->translation("default","Status"),
                        $this->functions->translation("default","Date"));
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($csvdata);    
                        $excel->prepareExcel();  
                        exit;
                        break;
                
                    case "sales-summary-report":    
                       $has_date_range=false;
                       if (isset($_SESSION['rpt_date_range'])){
                           if (is_array($_SESSION['rpt_date_range'])){
                               $has_date_range=true;
                           }
                       }
                       
                        if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
           
                            foreach ($res as $val) {    
                                $total_amt='';
                                if ( $has_date_range==true){
                                    $data[]=array(
                                       $val['item_id'],
                                       $val['item_name'],
                                       $val['size'],
                                       $this->functions->prettyFormat($val['discounted_price'],$merchant_id),
                                       $this->functions->prettyFormat($val['total_qty'],$merchant_id),
                                       $this->functions->prettyFormat($val['total_qty']*$val['discounted_price'],$merchant_id),
                                       $_SESSION['rpt_date_range']['start_date'],
                                       $_SESSION['rpt_date_range']['end_date'],
                                    );
                                } else {                                
                                    $data[]=array(
                                       $val['item_id'],
                                       $val['item_name'],
                                       $val['size'],
                                       $this->functions->prettyFormat($val['discounted_price'],$merchant_id),
                                       $this->functions->prettyFormat($val['total_qty'],$merchant_id),
                                       $this->functions->prettyFormat($val['total_qty']*$val['discounted_price'],$merchant_id)
                                    );
                                }
                            }                       
                        }                                                         
                        $header=array(
                        $this->functions->translation("default","Item"),
                        $this->functions->translation("default","Item Name"),
                        $this->functions->translation("default","Size"),
                        $this->functions->translation("default","Item Price"),
                        $this->functions->translation("default","Total Qty"),
                        $this->functions->translation("default","Total Amount")
                        );      
                        if ( $has_date_range==true) {
                           $header[]="Start Date";
                           $header[]="End Date";
                        }                       
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel(); 
                        exit; 
                        break;
                        
                    case "rptSalesMerchant":                       
                       if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
            
                            foreach ($res as $val) {                                    
                                $data[]=array(
                                   $val['merchant_id'],
                                   $val['restaurant_name'],
                                   $val['contact_name'],
                                   $val['contact_phone']." / ".$val['contact_email'],
                                   $val['street']." ".$val['city']." ".$val['state']." ".$val['country_code']." ".$val['post_code'],
                                   ucwords($val['package_name']),
                                   $val['status'],
                                   $this->functions->prettyDate($val['date_created'],true)
                                );
                            }                       
                        }                               
                        $header=array(
                        $this->functions->translation("default","MerchantID"),
                        $this->functions->translation("default","MerchantName"),
                        $this->functions->translation("default","ContactName"),
                        $this->functions->translation("default","Contact"),
                        $this->functions->translation("default","Address"),
                        $this->functions->translation("default","Package"),
                        $this->functions->translation("default","Status"),
                        $this->functions->translation("default","Date")
                        );                    
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel(); 
                        exit; 
                        break;
                    break;
                    
                    case 'rptAdminSalesMerchant':
                    if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
             
                            foreach ($res as $val) {                                
                                $date=$this->functions->prettyDate($val['date_created'],true);
                                $date=$this->functions->translateDate($date);
                                
                                $item=$this->functions->translateFoodItemByOrderId($val['order_id']);
                                
                                $data[]=array(
                                    $val['order_id'],
                                      stripslashes($val['restaurant_name']),
                                      ucwords($val['client_name']),
                                      $val['contact_phone'],
                                      $item,
                                      ucwords($this->functions->translation("default",$val['trans_type'])),
                                      strtoupper($this->functions->translation("default",$val['payment_type'])),
                                      $this->functions->standardPrettyFormat($val['sub_total'],$merchant_id),
                                      $this->functions->standardPrettyFormat($val['taxable_total'],$merchant_id),
                                      $this->functions->standardPrettyFormat($val['total_w_tax'],$merchant_id),
                                      ucwords($val['status']),
                                      ucwords($val['request_from']),
                                      $date,
                                );
                            }                       
                        }               
                        
                        $header=array(
                        $this->functions->translation("default","Ref#"),
                        $this->functions->translation("default","Merchant Name"),
                        $this->functions->translation("default","Name"),
                        $this->functions->translation("default","Contact#"),
                        $this->functions->translation("default","Item"),
                        $this->functions->translation("default","TransType"),
                        $this->functions->translation("default","Payment Type"),
                        $this->functions->translation("default","Total"),                      
                        $this->functions->translation("default","Tax"),
                        $this->functions->translation("default","Total W/Tax"),
                        $this->functions->translation("default","Status"),
                        $this->functions->translation("default","Platform"),
                        $this->functions->translation("default","Date")
                        );                    
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel(); 
                        exit; 
                        break;

                    case "rptCustomerList":             
                        if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {
   
                            foreach ($res as $val) {
                                $data[]=array(
                                   $val['email_address'],
                                   $val['first_name'],
                                   $val['last_name'],
                                   $val['contact_phone']
                                );
                            }                           
                        }                           
                        $header=array(
                         "Email",
                         "firstname",
                         "lastname",
                         "Phone"
                        );
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel(); 
                        exit; 
                        break;
                        
                    case "rptSubriberList":                     
                     if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {

                            foreach ($res as $val) {
                                $date=$this->functions->prettyDate($val['date_created'],true);
                                $date=$this->functions->translateDate($date);
                                $data[]=array(
                                    $val['id'],                   
                                    $val['email_address'],
                                    $date,
                                    $val['ip_address']      
                                );
                            }                       
                        }                                                      
                       $header=array(
                        "ID","Email address","Date Created","I.P Address"
                       );
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel(); 
                        exit;                        
                       break;
                       
                    case "rptmerchantcommission":
                        if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {

                            foreach ($res as $val) {
                                $date=$this->functions->prettyDate($val['date_created'],true);
                                $date=$this->functions->translateDate($date);
                                $data[]=array(
                                   $val['merchant_id'],
                                   $val['merchant_name'],
                                   $this->functions->normalPrettyPrice($val['total_order']),
                                   $this->functions->normalPrettyPrice($val['total_commission'])
                                );
                            }                       
                        }                                  
                       $header=array(
                        "ID",
                        "Merchant Name",
                        "Total Price",
                        "Commission Price"                       
                       );
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel(); 
                        exit;                      
                        break;   
                                
                    case "rptmerchantcommissiondetails":                
                    
                        $total_order=0;
                        $total_commission=0;
                        
                      if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {

                            foreach ($res as $val) {
                                $date=$this->functions->prettyDate($val['date_created'],true);
                                $date=$this->functions->translateDate($date);
                                
                                $total_order=$total_order+$val['total_order'];
                                $total_commission=$total_commission+$val['total_commission'];
                                
                                $data[]=array(
                                   $val['order_id'],
                                   $this->functions->normalPrettyPrice($val['total_w_tax']),
                                   $this->functions->normalPrettyPrice($val['percent_commision']),
                                   $this->functions->normalPrettyPrice($val['total_commission']),
                                   $date
                                );
                            }                       
                        }                                           
                        $header=array(
                        "Reference #",
                        "Total Price",
                        "Commission (%)",
                        "Commission price",
                        "Date"
                       );
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel(); 
                        exit;                      
                        break;     
                    
                    case "rptmerchantstatement":
                        
                        if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {

                             foreach ($res as $val) {
                                $date=$this->functions->prettyDate($val['date_created'],true);
                                $date=$this->functions->translateDate($date);
                                
                                 $total=$val['total_w_tax'];
                                 if ( $val['commision_ontop']==1){
                                     $total=$val['sub_total'];
                                 }
                                    
                                 $total_commission=$val['total_commission'];
                                 $amount=$total-$total_commission;
                                
                                $data[]=array(
                                   $val['order_id'],
                                    strtoupper($val['payment_type']),
                                    $this->functions->normalPrettyPrice($total),                                  
                                    $this->functions->normalPrettyPrice($val['percent_commision']),
                                    $this->functions->normalPrettyPrice($total_commission),
                                    $this->functions->normalPrettyPrice($amount),
                                    $date
                                );
                            }            
                        }                       
                        $header=array(
                        "Reference #",
                        "Payment Type",
                        "Total Price",                       
                        "Commission (%)",
                        "Commission",
                        "Net Amount",
                        "Date"
                       );
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel(); 
                        
                        exit;                      
                        break; 
                      
                    case "rptmerchantsalesummary":  
                        
                       $has_date_range=false;
                       if (isset($_SESSION['rpt_date_range'])){
                           if (is_array($_SESSION['rpt_date_range'])){
                               $has_date_range=true;
                           }
                       }
                       if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {

                             foreach ($res as $val) {                               
                                if ($has_date_range==true){
                                    $data[]=array(
                                       $val['restaurant_name'],
                                       $this->functions->normalPrettyPrice($val['total_sales']+0),
                                       $this->functions->normalPrettyPrice($val['total_commission']+0),
                                       $this->functions->normalPrettyPrice($val['total_earnings']+0),
                                       $_SESSION['rpt_date_range']['start_date'],
                                       $_SESSION['rpt_date_range']['end_date'],
                                    );
                                } else {
                                    $data[]=array(
                                       $val['restaurant_name'],
                                       $this->functions->normalPrettyPrice($val['total_sales']+0),
                                       $this->functions->normalPrettyPrice($val['total_commission']+0),
                                       $this->functions->normalPrettyPrice($val['total_earnings']+0),                                
                                    );
                                }
                            }            
                        }                       
                       $header=array(
                        "Merchant Name",
                        "Total Sales",
                        "Total Commission",
                        "Merchant Earnings",
                        //t("Approved No. Of Guests")
                       );
                       if ( $has_date_range==true) {
                           $header[]="Start Date";
                           $header[]="End Date";
                       }
                                           
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel(); 
                        
                        exit;                      
                        break; 
                        
                    case "booking-summary-report":
                        
                       $has_date_range=false;
                       if (isset($_SESSION['rpt_date_range'])){
                           if (is_array($_SESSION['rpt_date_range'])){
                               $has_date_range=true;
                           }
                       }
                       
                        if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {

                             foreach ($res as $val) {       
                                if ( $has_date_range==true){
                                    $data[]=array(
                                         $val['total_approved']+0,
                                         $val['total_denied']+0,
                                         $val['total_pending']+0,
                                         $_SESSION['rpt_date_range']['start_date'],
                                         $_SESSION['rpt_date_range']['end_date'],
                                    );
                                } else {
                                    $data[]=array(
                                         $val['total_approved']+0,
                                         $val['total_denied']+0,
                                         $val['total_pending']+0
                                    );
                                }
                            }            
                        }                       
                        $header=array(
                        "Total Approved",
                        "Total Denied",
                        "Total Pending"                      
                       );
                       
                       if ( $has_date_range==true) {
                           $header[]="Start Date";
                           $header[]="End Date";
                       }
                       
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel();                         
                        exit;                  
                        break;  
                        
                    case "merchanBbookingSummaryReport":
                        
                       $has_date_range=false;
                       if (isset($_SESSION['rpt_date_range'])){
                           if (is_array($_SESSION['rpt_date_range'])){
                               $has_date_range=true;
                           }
                       }
                                            
                       if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {

                             foreach ($res as $val) {                               
                                if ( $has_date_range==true){
                                     $data[]=array(
                                        ucwords($val['merchant_name']),
                                        $val['total_approved']+0,
                                        $val['total_denied']+0,
                                        $val['total_pending']+0,
                                        $_SESSION['rpt_date_range']['start_date'],
                                        $_SESSION['rpt_date_range']['end_date'],
                                    );
                                } else {                             
                                    $data[]=array(
                                        ucwords($val['merchant_name']),
                                        $val['total_approved']+0,
                                        $val['total_denied']+0,
                                        $val['total_pending']+0
                                    );
                                }
                            }            
                        }                       
                        $header=array(
                        "Merchant Name",
                        "Total Approved",
                        "Total Denied",
                        "Total Pending"                      
                       );
                       if ( $has_date_range==true) {
                           $header[]="Start Date";
                           $header[]="End Date";
                       }
                       
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel();                         
                        exit;                  
                        break;  
                        
                    case "rpt_incomingwithdrawal":
                        
                         if ($res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC)) {

                             foreach ($res as $val) {   
                                   $date=date('M d,Y G:i:s',strtotime($val['date_created']));  
                                   $date=$this->functions->translateDate($date);
                
                                   $date_created=$this->functions->translateDate($val['date_created']);
                                   $date_to_process=$this->functions->translateDate($val['date_to_process']);
                                            
                                   $method=("Paypal to")." ".$val['account'];
                                   if ( $val['payment_method']=="bank"){
                                        $method=("Bank to")." ".$val['bank_account_number'];
                                   }
                                                
                                   $data[]=array(
                                      $val['withdrawal_id'],
                                      $val['merchant_name'],
                                      $method,
                                      $this->functions->normalPrettyPrice($val['amount']),
                                      $this->functions->normalPrettyPrice($val['current_balance']),
                                      $val['status'],
                                      $date_created,
                                      $date_to_process,             
                                    );
                            }            
                        }                       
                        $header=array(
                        "ID",
                        "Merchant Name",
                        "Payment Method",
                        "Amount",                        
                        "From Balance",
                        "Status",
                        "Date Of Request",
                        "Date to process"
                       );
                     
                       
                        $filename = $this->data['rpt'].'-'. date('c') .'.csv';          
                        $excel  = new ExcelFormat($filename);
                        $excel->addHeaders($header);
                        $excel->setData($data);   
                        $excel->prepareExcel();                         
                        exit;                  
                        break;  
                    default:
                        break;
                }
            } else echo $this->functions->translation("default","Error: Something went wrong. please try again.");
        }



  public function merchantStatement()
{
    $mtid = $this->functions->getMerchantID();
    $orderstats = $this->functions->getCommissionOrderStats();

    $and = '';
    $trans_type = '';

    if ($this->data['query'] == "month") {
        $query_date = $this->data['query_date'];
        $start_date = date('Y-m-01', strtotime($query_date));
        $end_date = date('Y-m-t', strtotime($query_date));
        $and = " AND date_created BETWEEN '{$start_date} 00:00:00' AND '{$end_date} 23:59:00' ";
    } elseif ($this->data['query'] == "period") {
        $start_date = $this->data['start_date'];
        $end_date = $this->data['end_date'];
        $and = " AND date_created BETWEEN '{$start_date} 00:00:00' AND '{$end_date} 23:59:00' ";
    } elseif ($this->data['query'] == "last15") {
        $start_date = date("Y-m-d", strtotime('-15 days'));
        $end_date = date("Y-m-d");
        $and = " AND date_created BETWEEN '{$start_date} 00:00:00' AND '{$end_date} 23:59:00' ";
    } elseif ($this->data['query'] == "last30") {
        $start_date = date("Y-m-d", strtotime('-30 days'));
        $end_date = date("Y-m-d");
        $and = " AND date_created BETWEEN '{$start_date} 00:00:00' AND '{$end_date} 23:59:00' ";
    }

    if (isset($this->data['payment_type'])) {
        if ($this->data['payment_type'] == 2) {
            $trans_type = "AND payment_type IN ('cod','pyr','ccr','ocr')";
        } elseif ($this->data['payment_type'] == 3) {
            $trans_type = "AND payment_type NOT IN ('cod','pyr','ccr','ocr')";
        }
    }

    $stmt = "
        SELECT * FROM mt_order
        WHERE merchant_id = $mtid
        AND status IN ($orderstats)
        $and
        $trans_type
        ORDER BY order_id DESC
    ";

    $_SESSION['kr_export_stmt'] = $stmt;

    $total_amount = 0;
    $total_payable = 0;
    $feed_data = [];

    $stmt_exec = $this->db->query($stmt);
    if ($stmt_exec) {
        $res = $stmt_exec->fetchAll(PDO::FETCH_ASSOC);
        if ($res) {
            $mc_enabled = false;
            foreach ($res as $val) {
                $date = $this->functions->FormatDateTime($val['date_created']);

                if (!$mc_enabled) {
                    $total = $val['total_w_tax'];
                    if ($val['commision_ontop'] == 1) {
                        $total = $val['sub_total'];
                    }

                    $total_commission = $val['total_commission'];
                    $amount = $total - $total_commission;
                    $amount = $val['merchant_earnings'];
                } else {
                    $total = $val['total_w_tax_ex'];
                    if ($val['commision_ontop'] == 1) {
                        $total = $val['sub_total_ex'];
                    }

                    $total_commission = $val['total_commission_ex'];
                    $amount = $total - $total_commission;
                    $amount = $val['merchant_earnings_ex'];
                }

                // Custom code 10
                $link = "<a href=\"javascript:;\" class=\"view-receipt\"  data-id=\"$val[order_id]\">" .
                    $this->functions->formatNumber($total - $val['card_fee']) . "</a>";

                // Custom code 3
                if ($val['is_sop'] == '1' && $val['trans_type'] == 'pickup') {
                    $val['payment_type'] = 'Swipe on Pickup';
                }

                $feed_data['aaData'][] = array(
                    $val['order_id'],
                    strtoupper($val['payment_type']),
                    $link,
                    $this->functions->normalPrettyPrice($val['percent_commision']),
                    $this->functions->formatNumber($total_commission),
                    $this->functions->formatNumber($amount),
                    $date
                );

                $total_amount += $amount;
                $total_payable += $total_commission;
            }

            $feed_data['total_amount'] = $this->functions->displayPrice(
                $this->functions->adminCurrencySymbol(),
                $this->functions->normalPrettyPrice($total_amount)
            );

            $feed_data['total_payable'] = $this->functions->displayPrice(
                $this->functions->adminCurrencySymbol(),
                $this->functions->normalPrettyPrice($total_payable)
            );

            $this->otableOutput($feed_data);
            return;
        }
    }

    $this->otableNodata();
}



  public function requestPayout()
  {
    
    $mtid=$this->functions->getMerchantID();

    
    
    
    $wd_paypal_minimum=$this->functions->getOptionAdmin('wd_paypal_minimum');
        $wd_bank_minimum=$this->functions->getOptionAdmin('wd_bank_minimum');
        
        $wd_paypal_minimum=$this->functions->standardPrettyFormat($wd_paypal_minimum);
        $wd_bank_minimum=$this->functions->standardPrettyFormat($wd_bank_minimum);
        
        $current_balance=$this->functions->getMerchantBalance($mtid);
        $this->data['current_balance']=$current_balance;

    $this->Validator = new Validator();
   
    $req=array(
      'payment_type'=>("Payment type is required"),
      'payment_method'=>("Payment Method is required"),
    );                
    
    if ( $this->data['payment_method']=="paypal"){
      $req2=array(
       'account'=>("Email account not valid"),  
       'account_confirm'=>("Confirm email account not valid"),
      );
      $this->Validator->email($req2,$this->data);

      

      

      $req['amount']=("Amount is required");

      if ( $this->data['account']!=$this->data['account_confirm']){
         $this->Validator->setmsg("Confirm email does not match");
      }
                                 
    } elseif ( $this->data['payment_method']=="bank" ){
      
    }       
    
    if ( $this->data['payment_type']=="single"){
      if ( $this->data['minimum_amount']>$this->data['amount']){
         $this->Validator->setmsg(
    "Sorry but minimum amount is " .
    $this->functions->displayPrice(
        $this->functions->getCurrencyCode(),
        $this->data['minimum_amount']
    )
);

      }       
      if ( $current_balance<$this->data['amount']){         
           $this->Validator->setmsg("Amount is greater than your balance");
        }
    } elseif ( $this->data['payment_type']=="all-earnings"){            
      $this->data['amount']=$current_balance;
      if ( $this->data['minimum_amount']>$this->data['amount']){
          $this->Validator->setmsg(("Sorry but minimum amount is")." ".$this->functions->displayPrice($this->functions->getCurrencyCode(),$this->data['minimum_amount']));
      }       
      if ( $this->data['minimum_amount']>$current_balance){
          $this->Validator->setmsg(("Sorry but minimum amount is")." ".$this->functions->displayPrice($this->functions->getCurrencyCode(),$this->data['minimum_amount']));
      }   
    } else {
      
    }
                        
    $this->Validator->required($req,$this->data);
                      
    if ( $this->Validator->validate()){
      if ( $this->data['payment_type']=="single"){                              
        /*if  ( $wd_paypal_minimum>$this->data['amount']){
          $this->msg=t("Sorry but minimum amount is")." ".displayPrice(baseCurrency(),$wd_paypal_minimum);
        } else {*/
          $resp=$this->functions->payoutRequest_merside($this->data['payment_method'],$this->data);
          if ($resp){
            $this->details=$resp['id'];
            $this->code=1;
            $this->msg=("Successful");
                                  
          } else $this->msg=("ERROR: Something went wrong");
        //}     
      } else {
        //echo 'all earning';
        $resp=$this->functions->payoutRequest_merside($this->data['payment_method'],$this->data);
        if ($resp){
          $this->details=$resp['id'];
          $this->code=1;
          $this->msg=("Successful");                     
         } else $this->msg=("ERROR: Something went wrong");
      }
    } else $this->msg=$this->Validator->getErrorAsHTML();
        
    if ( $this->code==1){
      
      /*update all orders paid status to locked*/   
        $this->functions->updateAllPaidOrders($mtid);
      
      if ( isset($this->data['default_account_paypal'])){
         if ( $this->data['default_account_paypal']==2){
              $this->functions->updateOption("merchant_payout_account",
                  isset($this->data['account'])?$this->data['account']:'',$mtid);
         }
            }     
            
            if ( isset($this->data['default_account_bank'])){
              if ( $this->data['default_account_bank']==2){
                $bank_info=array(
                  'swift_code'=>isset($this->data['swift_code'])?$this->data['swift_code']:'',
                  'bank_account_number'=>isset($this->data['bank_account_number'])?$this->data['bank_account_number']:'' ,
                  'account_name'=>isset($this->data['account_name'])?$this->data['account_name']:'',
                  'bank_account_number'=>isset($this->data['bank_account_number'])?$this->data['bank_account_number']:'',
                  'swift_code'=>isset($this->data['swift_code'])?$this->data['swift_code']:'',
                  'bank_name'=>isset($this->data['bank_name'])?$this->data['bank_name']:'',
                  'bank_branch'=>isset($this->data['bank_branch'])?$this->data['bank_branch']:''
                );
                $this->functions->updateOption("merchant_payout_bank_account",
                json_encode($bank_info),$mtid);
              }            
            }   
            
            // send email
            $merchant_email='';
      $tpl='';
      
      $wd_days_process=$this->functions->getOptionAdmin("wd_days_process");    
      if (empty($wd_days_process)){
            $wd_days_process=5;
          }
      $cancel_date=$wd_days_process-2;
          $cancel_date=date("F d Y", strtotime (" +$cancel_date days"));
          $process_date=date("F d Y", strtotime (" +$wd_days_process days"));
          
      if ( $merchant_info=$this->functions->getMerchant($mtid)){     
        $merchant_email=$merchant_info['contact_email'];
        $cancel_link=$this->functions->websiteUrl()."/store/cancelwithdrawal/id/".$resp['token'];
        $tpl=$this->functions->getOptionAdmin('wd_template_payout');
          $tpl=$this->functions->smarty("merchant-name",$merchant_info['restaurant_name'],$tpl);
          $tpl=$this->functions->smarty("payout-amount",$this->functions->standardPrettyFormat($this->data['amount']),$tpl);
          $tpl=$this->functions->smarty("payment-method",$this->data['payment_method'],$tpl);
          $tpl=$this->functions->smarty("account",$this->data['account'],$tpl);
          $tpl=$this->functions->smarty("cancel-date",$cancel_date,$tpl);
          $tpl=$this->functions->smarty("cancel-link",$cancel_link,$tpl);
          $tpl=$this->functions->smarty("process-date",$process_date,$tpl);
      }   
                    
      if (!empty($tpl)){
        $wd_template_payout_subject=$this->functions->getOptionAdmin('wd_template_payout_subject');

                if (empty($wd_template_payout_subject)){
                  $wd_template_payout_subject=("Your Request for Withdrawal was Received");
                }                
        $this->functions->sendEmail($merchant_email,'',$wd_template_payout_subject,$tpl);
      }            
    }     
  }













 public function withdrawalSettings()
  {
    /*$this->functions->updateOptionAdmin("wd_minimum_amount",
      isset($this->data['wd_minimum_amount'])?$this->data['wd_minimum_amount']:'');*/
    
    $this->functions->updateOptionAdmin("wd_paypal_minimum",
      isset($this->data['wd_paypal_minimum'])?$this->data['wd_paypal_minimum']:'');
      
      $this->functions->updateOptionAdmin("wd_bank_minimum",
      isset($this->data['wd_bank_minimum'])?$this->data['wd_bank_minimum']:'');
      
      $this->functions->updateOptionAdmin("wd_days_process",
      isset($this->data['wd_days_process'])?$this->data['wd_days_process']:'');
      
      $this->functions->updateOptionAdmin("wd_paypal",
      isset($this->data['wd_paypal'])?$this->data['wd_paypal']:'');
      
      $this->functions->updateOptionAdmin("wd_paypal_mode",
      isset($this->data['wd_paypal_mode'])?$this->data['wd_paypal_mode']:'');
      
      $this->functions->updateOptionAdmin("wd_paypal_mode_user",
      isset($this->data['wd_paypal_mode_user'])?$this->data['wd_paypal_mode_user']:'');
      
      $this->functions->updateOptionAdmin("wd_paypal_mode_pass",
      isset($this->data['wd_paypal_mode_pass'])?$this->data['wd_paypal_mode_pass']:'');
      
      $this->functions->updateOptionAdmin("wd_paypal_mode_signature",
      isset($this->data['wd_paypal_mode_signature'])?$this->data['wd_paypal_mode_signature']:'');
      
      /*$this->functions->updateOptionAdmin("wd_paypal_client_id",
      isset($this->data['wd_paypal_client_id'])?$this->data['wd_paypal_client_id']:'');
      
      $this->functions->updateOptionAdmin("wd_paypal_client_secret",
      isset($this->data['wd_paypal_client_secret'])?$this->data['wd_paypal_client_secret']:'');*/
      
      $this->functions->updateOptionAdmin("wd_bank_deposit",
      isset($this->data['wd_bank_deposit'])?$this->data['wd_bank_deposit']:'');
      
      $this->functions->updateOptionAdmin("wd_template_payout",
      isset($this->data['wd_template_payout'])?$this->data['wd_template_payout']:'');
      
      $this->functions->updateOptionAdmin("wd_template_process",
      isset($this->data['wd_template_process'])?$this->data['wd_template_process']:'');
      
      $this->functions->updateOptionAdmin("wd_enabled_paypal",
      isset($this->data['wd_enabled_paypal'])?$this->data['wd_enabled_paypal']:'');
      
      $this->functions->updateOptionAdmin("wd_payout_disabled",
      isset($this->data['wd_payout_disabled'])?$this->data['wd_payout_disabled']:'');
            
      $this->functions->updateOptionAdmin("wd_payout_notification",
      isset($this->data['wd_payout_notification'])?$this->data['wd_payout_notification']:'');
      
      $this->functions->updateOptionAdmin("wd_template_payout_subject",
      isset($this->data['wd_template_payout_subject'])?$this->data['wd_template_payout_subject']:'');
      
      $this->functions->updateOptionAdmin("wd_template_process_subject",
      isset($this->data['wd_template_process_subject'])?$this->data['wd_template_process_subject']:'');
      
      $this->functions->updateOptionAdmin("wd_bank_fields",
      isset($this->data['wd_bank_fields'])?$this->data['wd_bank_fields']:'');
      
      $this->code=1;
      $this->msg=$this->functions->translation("default","Successful");
  }



public function merchantCommissionDetails()
{
    $where = '';    
    $and = " AND a.merchant_id = :merchant_id ";
    $params = [':merchant_id' => $this->data['mtid']];

    if (isset($this->data['where']) && !empty($this->data['where'])) {
        $data_where = explode("|", $this->data['where']);
        if (is_array($data_where) && count($data_where) >= 1) {
           /* switch ($data_where[0]) {
                case "a.status_in":
                    $data_where_query = explode(",", $data_where[1]);
                    if (is_array($data_where_query) && count($data_where_query) >= 1) {
                        $status_in = implode(",", array_map('intval', $data_where_query));

                        $and .= " AND a.status IN ($status_in)";
                    }             
                    break;
                default:
                    break;
            }*/


            switch ($data_where[0]) {
                case "a.status_in":
                  $data_where_query = explode(",",$data_where[1]);
                  if(is_array($data_where_query) && count($data_where_query)>=1){
                     $status_in='';
                     foreach ($data_where_query as $val) {
                        if(!empty($val)){
                          $status_in .= "'".addslashes($val)."',";

                        }                    
                      } 
                      $status_in = substr($status_in,0,-1);
                      $and.=" AND a.status IN ($status_in)";
                  }             
                  break;
              
                default:
                  break;
              }


        }       
    }

    

    if (isset($this->data['and'])) {
        $data_and = explode("|", $this->data['and']);

        if (is_array($data_and) && count($data_and) >= 1) {
            $data_and_date = explode(",", $data_and[1]);
            if (is_array($data_and_date) && count($data_and_date) >= 1) {         
                $data_and_between = $data_and_date[0] . " AND " . $data_and_date[1];
               if(!empty($data_and_date[0])){
               
                $and .= " AND a.date_created BETWEEN :start_date AND :end_date";
                $params[':start_date'] = $data_and_date[0] . " 00:00:00";
                $params[':end_date'] = $data_and_date[1] . " 23:59:59";
               }
            }
        }
    }

    if (isset($this->data['payment_type_in']) && !empty($this->data['payment_type_in'])) {
        $payment_type_in = explode("|", $this->data['payment_type_in']);
        if (is_array($payment_type_in) && count($payment_type_in) >= 1) {
            $payment_type_list = implode(",", array_map('intval', explode(",", $payment_type_in[1])));
            $and .= " AND a.payment_type IN ($payment_type_list)";
        }
    }

    if (isset($this->data['payment_type_not_in']) && !empty($this->data['payment_type_not_in'])) {
        $payment_type_not_in = implode(",", array_map('intval', explode(",", $this->data['payment_type_not_in'])));
        $and .= " AND a.payment_type NOT IN ($payment_type_not_in)";
    }

    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $and .= " AND a.date_created BETWEEN :start_date_range AND :end_date_range";
            $params[':start_date_range'] = $this->data['start_date'] . " 00:00:00";
            $params[':end_date_range'] = $this->data['end_date'] . " 23:59:59";
        }
    }

    

    $sql = "
        SELECT a.*,   
        (
            SELECT restaurant_name 
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id 
        ) as merchant_name      
        FROM mt_order a
        WHERE 1 
        $where 
        $and 
        ORDER BY a.order_id DESC
    ";

    // Set session variable for export statement
    $_SESSION['kr_export_stmt'] = $sql;

    // Initialize variables
    $mc_enabled = false;
    $total_order = 0; 
    $total_commission = 0;      

    // Prepare and execute the query
    $stmt = $this->db->prepare($sql);

    // Bind parameters
    foreach ($params as $key => $value) {
        $stmt->bindValue($key, $value);
    }

    if ($stmt->execute()) {
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Check if the result is not empty and iterate over the results
        if ($res) {
            foreach ($res as $val) {
                if (!isset($val['total_order'])) {
                    $val['total_order'] = 0;
                }   

                if (!$mc_enabled) {
                    $total_order += $val['total_order'];
                    $total_commission += $val['total_commission'];
                } else {
                    $total_order += $val['total_order'];
                    $total_commission += $val['total_commission_ex'];
                }

                $date = $this->functions->FormatDateTime($val['date_created']);

                $feed_data['total_commission'] = $this->functions->formatNumber($total_commission);
                $feed_data['merchant_name'] = $this->functions->clearString($val['merchant_name']);

                if (!$mc_enabled) {
                    $total_w_tax = $val['commision_ontop'] == 1 
                        ? "<a  class=\"view-receipt\" data-id=\"$val[order_id]\" href=\"javascript:;\">".$this->functions->formatNumber($val['sub_total'])."</a>"
                        : "<a  class=\"view-receipt\" data-id=\"$val[order_id]\" href=\"javascript:;\">".$this->functions->formatNumber($val['total_w_tax'] - $val['card_fee'])."</a>";
                } else {
                    $total_w_tax = $val['commision_ontop'] == 1 
                        ? "<a  class=\"view-receipt\" data-id=\"$val[order_id]\" href=\"javascript:;\">".$this->functions->formatNumber($val['sub_total_ex'])."</a>"
                        : "<a  class=\"view-receipt\" data-id=\"$val[order_id]\" href=\"javascript:;\">".$this->functions->formatNumber($val['total_w_tax_ex'] - $val['card_fee'])."</a>";
                }

                $val_percent_commision = !$mc_enabled ? $val['percent_commision'] : $val['percent_commision'];
                $val_total_commission = !$mc_enabled ? $val['total_commission'] : $val['total_commission_ex'];

                $feed_data['aaData'][] = [
                    $val['order_id'],
                    $val['payment_type'],
                    $total_w_tax,
                    $this->functions->normalPrettyPrice($val['card_fee']),
                    $this->functions->convertToRaw($val_percent_commision),
                    $this->functions->formatNumber($val_total_commission),
                    $date
                ];
            }
            $this->otableOutput($feed_data);
        }
        $this->otableNodata();
    }
}


public function SMSpackagesList()
{
    $slug = $this->data['slug'];

    // Prepare the SQL statement
    $stmt = "
        SELECT * 
        FROM mt_sms_package 
        ORDER BY sms_package_id DESC
    ";

    // Execute the query
    $query = $this->db->prepare($stmt);
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        foreach ($res as $val) {
            // Format the date
            $date = $this->functions->FormatDateTime($val['date_created']);

            // Action buttons for Edit and Delete
            $action = "<div class=\"options\">
                <a href=\"$slug/id/{$val['sms_package_id']}\" >".$this->functions->translation("default", "Edit")."</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['sms_package_id']}\" >".$this->functions->translation("default", "Delete")."</a>
            </div>";

            // Capitalize the title
            $val['title'] = ucwords($val['title']);

            // Add the data to the feed
            $feed_data['aaData'][] = [
                $val['sms_package_id'],
                $val['title'] . $action,
                $this->functions->limitDescription($val['description']),
                $this->functions->standardPrettyFormat($val['price']),
                $this->functions->standardPrettyFormat($val['promo_price']),
                $val['sms_limit'],
                $date . "<div>" . $this->functions->translation("default", $val['status']) . "</div>"
            ];
        }

        // Output the data
        $this->otableOutput($feed_data);
    } else {
        // No data found, output no data message
        $this->otableNodata();
    }
}


public function smsPackageAdd()
    {      
         $params=array(
           'title'=>$this->data['title'],
           'description'=>$this->data['description'],
           'price'=>$this->data['price'],
           'promo_price'=>is_numeric($this->data['promo_price'])?$this->data['promo_price']:0,
           'sms_limit'=>$this->data['sms_limit'],
           'status'=>$this->data['status'],
           'date_created'=>$this->functions->dateNow(),
           'ip_address'=>$_SERVER['REMOTE_ADDR']
         );        
         if (empty($this->data['id'])){
           $last_insert_id = $this->functions->insertData('mt_sms_package', $params);
                if ($last_insert_id!== false){             
            $this->details=$last_insert_id;
            $this->code=1;
            $this->msg=$this->functions->translation("default","Successful");           
          }
        } else {          
          unset($params['date_created']);
        $params['date_modified']=$this->functions->dateNow();       
        
        $res = $this->functions->updateData("mt_sms_package",$params,'sms_package_id',$this->data['id']);
        if ($res){
          $this->code=1;
                  $this->msg=$this->functions->translation("default",'Package updated.');  
        } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
        } 
      
    }

public function smsTransactionList()
{
    $aColumns = array(
        'id', 'merchant_id', 'sms_package_id', 'package_price', 'sms_limit', 'payment_type', 'status'
    );

    $sWhere = ''; $sOrder = ''; $sLimit = '';
    $sTable = 'mt_sms_package_trans';

    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
            a.*,
            (
                SELECT restaurant_name
                FROM mt_merchant
                WHERE merchant_id = a.merchant_id
            ) AS merchant_name,
            (
                SELECT title
                FROM mt_sms_package
                WHERE sms_package_id = a.sms_package_id
            ) AS sms_package_name
        FROM $sTable a
        $sWhere
        $sOrder
        $sLimit
    ";

    if (isset($_GET['debug'])) {
        echo "<pre>" . htmlspecialchars($stmt) . "</pre>";
    }

    // Prepare and execute the query using $this->db
    $query = $this->db->prepare($stmt);
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // Retrieve the total number of records
    $stmt2 = "SELECT FOUND_ROWS()";
    $query2 = $this->db->prepare($stmt2);
    $query2->execute();
    $res2 = $query2->fetch(PDO::FETCH_ASSOC);

    $iTotalRecords = $res2['FOUND_ROWS()'] ?? 0;

    $feed_data = [
        'sEcho' => intval($_GET['sEcho']),
        'iTotalRecords' => $iTotalRecords,
        'iTotalDisplayRecords' => $iTotalRecords,
        'aaData' => []
    ];

    foreach ($res as $val) {


        $link = Config::$baseUrl.'/admin/smstransaction/do/add/id/'.$val['id'];

        $action = "<div class=\"options\">
            <a href=\"$link\">" . htmlspecialchars($this->functions->translation("default", "Edit")) . "</a>
            <a href=\"javascript:;\" class=\"row_del\" rev=\"" . htmlspecialchars($val['id']) . "\">" . htmlspecialchars($this->functions->translation("default", "Delete")) . "</a>
        </div>";

        $class = htmlspecialchars($val['status']);
        $cc_link = '';
        if ($val['payment_type'] == "ccr" || $val['payment_type'] == "ocr") {
            $cc_link = "<br/><a data-id=\"" . htmlspecialchars($val['cc_id']) . "\" class=\"view-cc-details-sms\" href=\"javascript:;\">" . htmlspecialchars("View CC") . "</a>";
            $cc_link = "";
        }

        $date = htmlspecialchars($this->functions->FormatDateTime($val['date_created']));
        $feed_data['aaData'][] = [
            htmlspecialchars($val['id']),
            htmlspecialchars(stripslashes($val['merchant_name'])) . $action,
            htmlspecialchars($val['sms_package_name']),
            htmlspecialchars($this->functions->displayPrice($val['package_price'])),
            htmlspecialchars($val['sms_limit']),
            htmlspecialchars($this->functions->prettyPaymentType('sms_package_trans', $val['payment_type'], $val['id'])) . $cc_link,
            $date . "<br/><div class=\"tag $class\">" . htmlspecialchars($val['status']) . "</div>"
        ];
    }

    $this->otableOutput($feed_data);
}


  public function smsLogs()
{
    $slug = $this->data['slug'];
    
    $aColumns = array(
        'id', 'gateway', 'merchant_id', 'contact_phone', 'sms_message',
        'gateway_response', 'status', 'date_created'
    );
    
    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';
    
    $sTable = "mt_sms_broadcast_details";
    
    // Use the method to get DataTable parameters
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }
    
    // Prepare the SQL statement
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*,
            (
                SELECT restaurant_name
                FROM mt_merchant
                WHERE merchant_id = a.merchant_id
            ) AS restaurant_name
        FROM $sTable a
        $sWhere
        $sOrder
        $sLimit
    ";
    
    if (isset($_GET['debug'])) {
        echo "<pre>$stmt</pre>";
    }
    
    // Execute the query
    $command = $this->db->prepare($stmt);
    $command->execute();
    $res = $command->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        // Get total records
        $stmt2 = "SELECT FOUND_ROWS() AS total";
        $command2 = $this->db->prepare($stmt2);
        $command2->execute();
        $res2 = $command2->fetch(PDO::FETCH_ASSOC);
        $iTotalRecords = $res2['total'];
        
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;
        
        // Process data for output
        foreach ($res as $val) {
            $date = $this->functions->FormatDateTime($val['date_created']);
            
            $feed_data['aaData'][] = array(
                $val['id'],
                "<span class=\"uk-text-bold\">" . htmlspecialchars($val['gateway']) . "</span>",
                htmlspecialchars($val['restaurant_name']),
                htmlspecialchars($val['contact_phone']),
                "<span class=\"uk-text-success uk-text-small\">" . htmlspecialchars($val['sms_message']) . "</span>",
                "<span class=\"uk-text-warning uk-text-small concat-text\">" . htmlspecialchars($val['gateway_response']) . "</span>",
                "<span class=\"uk-text-danger uk-text-small\">" . htmlspecialchars($val['status']) . "</span>",
                $date
            );
        }
        
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


public function addReviewToOrder()
  {
    $order_info= array();
    $client_id = $this->functions->getClientId();
    if($client_id<=0){
      $this->msg =  "Session has expired";
      return ;
    } 
    
    if($this->data['initial_review_rating']<0 || empty($this->data['initial_review_rating'])){
       $this->msg = "Rating is required";
       return ; 
    } 
        
    $order_token = isset($this->data['order_id_token'])?$this->data['order_id_token']:'';   
    if(!empty($order_token)){
      $order_info = $this->functions->getOrderInfoByToken($order_token);
    }   
    if(is_array($order_info) && count($order_info)>=1){
      $order_id = $order_info['order_id'];      
      $params = array(
        'merchant_id'=>$order_info['merchant_id'],
        'client_id'=>$client_id,
        'review'=>$this->data['review_content'],
        'rating'=>$this->data['initial_review_rating'],
        'date_created'=>$this->functions->dateNow(),
        'ip_address'=>$_SERVER['REMOTE_ADDR'],
        'order_id'=>$order_id,
        'as_anonymous'=>isset($this->data['as_anonymous'])?$this->data['as_anonymous']:0
      );
      
     
        $params['status']=$this->functions->getReviewBasedOnStatus($order_info['status']);
      
                  
           
      if(!$this->functions->getReviewByOrder($client_id,$order_id)){

      $last_insert_id = $this->functions->insertData('mt_review', $params);
      if ($last_insert_id!== false){ 
          $review_id=$last_insert_id;



          /*POINTS REVIEW*/
          
              $this->PointsProgram->addReviewsPerOrder($order_id,$client_id,$review_id,$order_info['merchant_id'],$order_info['status']);
             
          
          $this->code = 1;
          $this->msg = "Your review has been published.";
        } else $this->msg = "ERROR. cannot insert data.";
      } else $this->msg = "You have already have add review to this order";
    } else $this->msg  = "Order id not found";
  }




public function rptSalesMerchant()
{
    $aColumns = array(
        'merchant_id', 'restaurant_name', 'contact_name', 'contact_phone', 'street',
        'package_name', 'status', 'merchant_id'
    );

    $and = '';
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $and = " WHERE date_created BETWEEN :start_date AND :end_date";
        }
    }

    $sWhere = '';
    $sOrder = '';
    $sLimit = '';
    $sTable = "mt_merchant";

    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

   $order_status_id = '';  // Initialize the variable

// Check if there are status IDs in the input
if (isset($this->data['stats_id'])) {
    if (is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
        // Loop through each status ID and wrap it in quotes
        foreach ($this->data['stats_id'] as $stats_id) {
            $order_status_id .= "'" . $stats_id . "',";  // Add quotes around each status
        }
        if (!empty($order_status_id)) {
            // Remove the last comma from the string
            $order_status_id = rtrim($order_status_id, ',');
        }
    }
}

// Append the status to the WHERE clause
if (!empty($order_status_id)) {
    if (empty($and)) {
        $and .= " WHERE status IN ($order_status_id)";
    } else {
        $and .= " AND status IN ($order_status_id)";
    }
}

    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.*,
            (SELECT title FROM mt_packages WHERE package_id = a.package_id) as package_name
            FROM mt_merchant a
            $and
            $sOrder
            $sLimit";

    // Prepare statement
    $pos = strpos($stmt,"LIMIT");
    if ($pos !== false) {
    // Store the substring up to the position of "LIMIT"
    $_SESSION['kr_export_stmt'] = substr($stmt, 0, $pos);
} else {
    // If "LIMIT" is not found, store the full statement
    $_SESSION['kr_export_stmt'] = $stmt;
}

//echo $_SESSION['kr_export_stmt']; die(); 



     
    $query = $this->db->prepare($stmt);

    // Bind parameters if dates are set
    if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
        $query->bindValue(':start_date', $this->data['start_date'] . " 00:00:00");
        $query->bindValue(':end_date', $this->data['end_date'] . " 23:59:00");
    }

    // Execute query
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        // Fetch total records
        $query = $this->db->prepare("SELECT FOUND_ROWS()");
        $query->execute();
        $res2 = $query->fetch(PDO::FETCH_ASSOC);
        $iTotalRecords = $res2['FOUND_ROWS()'];

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $action = "<a data-id=\"" . $val['merchant_id'] . "\" class=\"edit-merchant-status\" href=\"javascript:\">" . $this->functions->translation("default", "Edit") . "</a>";
            $date = $this->functions->FormatDateTime($val['date_created'], false);

            $feed_data['aaData'][] = array(
                $val['merchant_id'],
                $val['restaurant_name'],
                $val['contact_name'],
                $val['contact_phone'] . " / " . $val['contact_email'],
                $val['street'] . " " . $val['city'] . " " . $val['state'] . " " . $val['country_code'] . " " . $val['post_code'],
                ucwords($val['package_name']),
                $date . "<br/>" . ($val['status']),
                $action
            );
        }
        $this->otableOutput($feed_data);
    }

    $this->otableNodata();
}




public function getPackageInformation()
  {       
    if (isset($this->data['package_id'])){
      if ( $this->data['package_id']==0 ){
        $this->code=3;
        return false;
      }

      
      if ( $res=$this->functions->getSMSPackagesById($this->data['package_id'])){

        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Successful");
        $this->details=$res['sms_limit'];
      } else $this->msg=$this->functions->translation("default","Cannot find information");
    } else $this->msg=$this->functions->translation("default","Missing parameters");
  }


  public function updateSMSTransaction()
    {           
      if (empty($this->data['id'])){
        if ( $res=$this->functions->getSMSPackagesById($this->data['sms_package_id'])){
          if ( $res['promo_price']>=1){
            $package_price=$res['promo_price'];
          } else $package_price=$res['price'];
        }
        $params=array(
          'merchant_id'=>$this->data['merchant_id'],
          'sms_package_id'=>$this->data['sms_package_id'],
          'package_price'=>$package_price,
          'sms_limit'=>$this->data['sms_limit'],
          'status'=>$this->data['status'],
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'payment_type'=>"manual"
        );  

        $last_insert_id = $this->functions->insertData('mt_sms_package_trans', $params);
                if ($last_insert_id!== false){      
        
          $this->details=$last_insert_id;         
          $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");
        } else $this->msg=$this->functions->translation("default","ERROR. cannot insert data.");
      } else {    
        $params=array( 
          'sms_limit'=>$this->data['sms_limit'],
          'status'=>$this->data['status'],
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        ;
        if ( $this->functions->updateData("mt_sms_package_trans",$params,'id',$this->data['id']) ){
          $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");
        } else $this->msg=$this->functions->translation("default","ERROR: cannot update");    
      }
    }



       public function chartTotalSales()
    {
        $merchant_id = $this->functions->getMerchantID();

        $data = [];
        $date_now = date('Y-m-d 23:00:59');
        $start_date = date('Y-m-d 00:00:00', strtotime($date_now . " -30 days"));

        // Prepare the query using placeholders for better security
        $stmt = "
            SELECT 
                DATE_FORMAT(date_created, '%M-%D') as date_created_format,
                SUM(total_w_tax) as total
            FROM
                mt_order
            WHERE
                date_created BETWEEN :start_date AND :date_now
                AND merchant_id = :merchant_id
                AND status NOT IN ('initial_order')
            GROUP BY DATE_FORMAT(date_created, '%M-%D')
            ORDER BY date_created ASC
        ";

        // Use $this->db to prepare the statement (assuming $this->db is the PDO instance from the Model class)
        $query = $this->db->prepare($stmt);
        $query->bindParam(':start_date', $start_date);
        $query->bindParam(':date_now', $date_now);
        $query->bindParam(':merchant_id', $merchant_id);

        // Execute the query and fetch results
        if ($query->execute()) {
            $res = $query->fetchAll(PDO::FETCH_ASSOC);

            foreach ($res as $val) {
                $t = explode("-", $val['date_created_format']);
                if (is_array($t) && count($t) >= 1) {
                    $tt = $t[0] . "-" . $t[1];
                    $data[$tt] = $this->functions->unPrettyPrice($val['total']);
                } else {
                    $data[$val['date_created_format']] = $this->functions->unPrettyPrice($val['total']);
                }
            }
        }

        // Output the data as chart
        echo $this->functions->formatAsChart($data);
        die();
    }



     public function chartByItem()
    {
        $merchant_id = $this->functions->getMerchantID(); // Get merchant ID from your functions class

        $data = [];

        $date_now = date('Y-m-d 23:00:59');
        $start_date = date('Y-m-d 00:00:00', strtotime($date_now . " -30 days"));

        // Prepare the query using placeholders for security
        $stmt = "
            SELECT a.item_name, a.discounted_price,                  
                   SUM(a.qty) as total,
                   b.date_created
            FROM mt_view_order_details a
            LEFT JOIN mt_order b ON a.order_id = b.order_id
            WHERE b.date_created BETWEEN :start_date AND :date_now
              AND a.merchant_id = :merchant_id
              AND a.status NOT IN ('initial_order')
            GROUP BY a.item_id
            ORDER BY a.item_name ASC
        ";

        // Use $this->db to prepare the statement
        $query = $this->db->prepare($stmt);
        $query->bindParam(':start_date', $start_date);
        $query->bindParam(':date_now', $date_now);
        $query->bindParam(':merchant_id', $merchant_id);

        // Execute the query and fetch results
        if ($query->execute()) {
            $res = $query->fetchAll(PDO::FETCH_ASSOC);

            foreach ($res as $val) {
                $val['item_name'] = trim($val['item_name']);
                $val['item_name'] = str_replace("'", '', $val['item_name']); // Remove any single quotes from item names
                $data[$val['item_name']] = $val['discounted_price'] * $val['total']; // Calculate the total price for each item
            }
        }

        // Output the data as chart
        echo $this->functions->formatAsChart($data);
        die();
    }







     public function addVoucherNew()
  {         
       
    
    $merchant_id=$this->functions->getMerchantID();
    $params=array(
      'voucher_name'=>$this->data['voucher_name'],
      'voucher_type'=>$this->data['voucher_type'],
      'amount'=>$this->data['amount'],
      'expiration'=>$this->data['expiration'],
      'status'=>$this->data['status'],
      'date_created'=>$this->functions->dateNow(),
      'ip_address'=>$_SERVER['REMOTE_ADDR'],
      'merchant_id'=>$merchant_id,
      'min_order'=>isset($this->data['min_order'])?(float)$this->data['min_order']:0
    );
    
    $days_list = $this->functions->dayList(); $days_input = isset($this->data['days'])?$this->data['days']:array();    
    foreach ($days_list as $day=>$dayval) {
      if (in_array($day,(array)$days_input)){
        $params[$day]=1;
      } else $params[$day]=0;
    }
          
        
    if (isset($this->data['voucher_owner'])){
      unset($params['merchant_id']);
      $params['voucher_owner']=$this->data['voucher_owner'];
    }
    
    if (isset($this->data['joining_merchant'])){
      $params['joining_merchant']=json_encode($this->data['joining_merchant']);
    } else $params['joining_merchant']='';
    
    if (isset($this->data['used_once'])){
      $params['used_once']=$this->data['used_once'];
    } else  $params['used_once']='0';
              
    if (!empty($this->data['id'])){
      
      if ( $this->functions->checkIFVoucherCodeExisting($this->data['voucher_name'],$this->data['id'])){
        $this->msg=$this->functions->translation("default","Sorry but voucher name already exist!");
        return;
      }   
      
      $params['date_modified']=$this->functions->dateNow();
      unset($params['date_created']);
      
      if (  $this->functions->updateData("mt_voucher_new",$params,'voucher_id',$this->data['id'])){
        $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");
      } else $this->msg=$this->functions->translation("default","Failed cannot update records");        
    } else {
      if ( $this->functions->checkIFVoucherCodeExists($this->data['voucher_name'])){
        $this->msg=$this->functions->translation("default","Sorry but voucher name already exist!");
        return;
      }   
          $last_insert_id = $this->functions->insertData('mt_voucher_new', $params);
          if ($last_insert_id!== false){
            $this->details=$last_insert_id;
          $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");     
          } else $this->msg=$this->functions->translation("default","ERROR: Something went wrong");   
    }
  }



  public function UpdateMerchant()
        {           
            
            $merchant_id = (integer) $this->functions->getMerchantID();
            if (!empty($this->data['password'])){
                $params['username']=$this->data['username'];
                $params['password']=md5($this->data['password']);
            }
            
            if (!empty($this->data['password'])){
                if ( $this->functions->validateUsername($this->data['username'],$merchant_id) ){
                    $this->msg=$this->functions->translation("default","Merchant Username is already been taken");
                    return ;
                }           
            }               
            
            if ( $this->functions->validateMerchantEmail($this->data['contact_email'],$merchant_id) ){
                $this->msg=$this->functions->translation("default","Merchant Email address is already been taken");
                return ;
            }       
            /*dump($merchant_id);
            dump($params);
            die();*/
            
            $params['restaurant_name']=isset($this->data['restaurant_name'])?$this->data['restaurant_name']:"";
            $params['restaurant_phone']=isset($this->data['restaurant_phone'])?$this->data['restaurant_phone']:'';
            $params['contact_name']=isset($this->data['contact_name'])?$this->data['contact_name']:'';
            $params['contact_phone']=isset($this->data['contact_phone'])?$this->data['contact_phone']:'';
            $params['contact_email']=isset($this->data['contact_email'])?$this->data['contact_email']:'';
            $params['country_code']=isset($this->data['country_code'])?$this->data['country_code']:'';
            $params['street']=isset($this->data['street'])?$this->data['street']:'';
            $params['city']=isset($this->data['city'])?$this->data['city']:'';
            $params['post_code']=isset($this->data['post_code'])?$this->data['post_code']:'';
            $params['cuisine']=isset($this->data['cuisine'])?json_encode($this->data['cuisine']):'';
            $params['service']=isset($this->data['service'])?$this->data['service']:'';         
            $params['date_created']=$this->functions->dateNow();
            $params['ip_address']=$_SERVER['REMOTE_ADDR'];
            
            $params['state']=isset($this->data['state'])?$this->data['state']:'';
            $params['abn']=isset($this->data['abn'])?$this->data['abn']:'';
            
            $params['latitude']=isset($this->data['merchant_latitude'])?$this->data['merchant_latitude']:'';
            $params['lontitude']=isset($this->data['merchant_longtitude'])?$this->data['merchant_longtitude']:'';
            
            $merchant_id=$this->functions->getMerchantID();
            
            $params['restaurant_slug']=$this->functions->verifyMerchantSlug(
              $this->functions->seo_friendly_url($this->data['restaurant_slug']),$merchant_id
            );
           
            $this->functions->updateOption("merchant_latitude",
            isset($this->data['merchant_latitude'])?$this->data['merchant_latitude']:''
            ,$merchant_id);
            
            $this->functions->updateOption("merchant_longtitude",
            isset($this->data['merchant_longtitude'])?$this->data['merchant_longtitude']:''
            ,$merchant_id);


            $links  = isset($this->data['delivery_external_link']) ? $this->data['delivery_external_link'] : [];
$photos = isset($this->data['photo']) ? $this->data['photo'] : [];

$data_del = [];
foreach ($links as $i => $link) {
    $data_del[] = [
        'link'  => $link,
        'photo' => isset($photos[$i]) ? $photos[$i] : ''
    ];
}



            /*$this->functions->updateOption("delivery_external_link",
            isset($this->data['delivery_external_link'])?$this->data['delivery_external_link']:''
            ,$merchant_id);*/

            $this->functions->updateOption(
    "delivery_external_link",
    json_encode($data_del, JSON_UNESCAPED_UNICODE),
    $merchant_id
);
            
      
       $this->functions->updateOption("google_map_api_key",
            isset($this->data['google_map_api_key'])?$this->data['google_map_api_key']:''
            ,$merchant_id);
      
      
         $this->functions->updateOption("google_map_api_key_javascript",
            isset($this->data['google_map_api_key_javascript'])?$this->data['google_map_api_key_javascript']:''
            ,$merchant_id);
      
      
      
      
      
       $this->functions->updateOption("google_map_api_key_android",
            isset($this->data['google_map_api_key_android'])?$this->data['google_map_api_key_android']:''
            ,$merchant_id);
      
      
       $this->functions->updateOption("google_map_api_key_ios",
            isset($this->data['google_map_api_key_ios'])?$this->data['google_map_api_key_ios']:''
            ,$merchant_id);
      
            
                
            $this->functions->updateOption("location_id",
            isset($this->data['location_id'])?$this->data['location_id']:''
            ,$merchant_id);
                        
            $merchant_information  = isset($this->data['merchant_information'])?$this->data['merchant_information']:'';
            /*if(class_exists('DOMDocument')){          
                $doc = new DOMDocument();
                @$doc->loadHTML($merchant_information);
                $merchant_information =  $doc->saveHTML();              
            } */
            
            $this->functions->updateOption("merchant_information",
            $merchant_information,$merchant_id);
                        
            unset($params['date_created']);
            $params['date_modified']=$this->functions->dateNow();                
                                                    
            //$res = $this->updateData('{{merchant}}' , $params ,'merchant_id', $merchant_id );
             $res = $this->functions->updateData('mt_merchant' , $params ,'merchant_id',$merchant_id);
            if ($res){
                $this->code=1;
                $this->msg=$this->functions->translation("default",'Merchant updated.');  
                
                $cuisine = $this->data['cuisine'];
                try {
                    $this->functions->insertCuisine($merchant_id,(array)$cuisine);                   
                } catch (Exception $e) {
                    //$e->getMessage()
                }                
            
            } else $this->msg=$this->functions->translation("default","ERROR: cannot update");         
        }


      public function getGoogleCordinateStatus()
        {
            $merchant_id=$this->functions->getMerchantID();            
            $merchant_latitude=$this->functions->getOption("merchant_latitude",$merchant_id);
            $merchant_longtitude=$this->functions->getOption("merchant_longtitude",$merchant_id);            
            
            if (empty($merchant_longtitude) || empty($merchant_latitude)){
                $this->msg=$this->functions->translation("default","Your merchant might not be searchable fixed this by adding coordinates on google map under merchant information");
            } else $this->code=1;
        } 
        



  public function MerchantPointsSettings()
    {
        $mtid=$this->functions->getMerchantID();
        
        $this->functions->updateOption("mt_disabled_pts",
        isset($this->data['mt_disabled_pts'])?$this->data['mt_disabled_pts']:'',$mtid); 
        
        $this->functions->updateOption("mt_pts_earn_points_status",
        isset($this->data['mt_pts_earn_points_status'])?json_encode($this->data['mt_pts_earn_points_status']):'',$mtid); 
        
       $this->functions->updateOption("mt_pts_earning_points",
        isset($this->data['mt_pts_earning_points'])?$this->data['mt_pts_earning_points']:'',$mtid); 
        
        $this->functions->updateOption("mt_pts_earning_points_value",
        isset($this->data['mt_pts_earning_points_value'])?$this->data['mt_pts_earning_points_value']:'',$mtid); 
        
       $this->functions->updateOption("mt_pts_disabled_redeem",
        isset($this->data['mt_pts_disabled_redeem'])?$this->data['mt_pts_disabled_redeem']:'',$mtid); 
        
        $this->functions->updateOption("mt_pts_redeeming_point",
        isset($this->data['mt_pts_redeeming_point'])?$this->data['mt_pts_redeeming_point']:'',$mtid); 
        
        $this->functions->updateOption("mt_pts_redeeming_point_value",
        isset($this->data['mt_pts_redeeming_point_value'])?$this->data['mt_pts_redeeming_point_value']:'',$mtid); 
        
        $this->functions->updateOption("mt_points_apply_order_amt",
        isset($this->data['mt_points_apply_order_amt'])?$this->data['mt_points_apply_order_amt']:'',$mtid); 
        
        $this->functions->updateOption("mt_points_minimum",
        isset($this->data['mt_points_minimum'])?$this->data['mt_points_minimum']:'',$mtid); 
        
        $this->functions->updateOption("mt_points_max",
        isset($this->data['mt_points_max'])?$this->data['mt_points_max']:'',$mtid); 
        
        $this->functions->updateOption("mt_points_based_earn",
        isset($this->data['mt_points_based_earn'])?$this->data['mt_points_based_earn']:'',$mtid); 
        
        $this->functions->updateOption("mt_pts_earn_above_amount",
        isset($this->data['mt_pts_earn_above_amount'])?$this->data['mt_pts_earn_above_amount']:'',$mtid); 
        
        $this->functions->updateOption("mt_pts_enabled_add_voucher",
        isset($this->data['mt_pts_enabled_add_voucher'])?$this->data['mt_pts_enabled_add_voucher']:'',$mtid); 
        
        $this->functions->updateOption("mt_pts_enabled_offers_discount",
        isset($this->data['mt_pts_enabled_offers_discount'])?$this->data['mt_pts_enabled_offers_discount']:'',$mtid); 
                
        $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");     
    }


  




     /*Proimotions */
  public function promotionlistad()
    {
      $slug=$this->data['slug'];
        
        
        $stmt = "SELECT a.*, (
                SELECT restaurant_name 
                FROM mt_merchant 
                WHERE merchant_id = a.merchant_id
            ) as merchant_name 
            FROM mt_promotions a 
            WHERE 1 
            ORDER BY id DESC";

    // Prepare and execute the PDO statement
    $query = $this->db->prepare($stmt);
    $query->execute();

    // Fetch all rows
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if rows are returned
    if (is_array($rows) && count($rows) >= 1) {
            foreach ($rows as $val) {                   
              $chk="<input type=\"checkbox\" name=\"row[]\" value=\"$val[id]\" class=\"chk_child\" >";      
              $action="<div class=\"options\">
              <a href=\"$slug/id/$val[id]\" >".$this->functions->translation("default","Edit")."</a>
              <a href=\"javascript:;\" class=\"row_del\" rev=\"$val[id]\" >".$this->functions->translation("default","Delete")."</a>
              </div>";
              
              $date=$this->functions->FormatDateTime($val['date_created']);
              $item_names='';
          if (!empty($val['item_id'])){
                $category=json_decode($val['item_id']);
                if (is_array($category) && count($category)>=1){
                  foreach ($category as $cat_id) { 
                $datas= $this->functions->getFoodItem($cat_id);    
                $item_names .=$datas['item_name'] .',';
                
                          }     
                          $item_names=substr($item_names,0,-1);
                }
              } 
          
          
              $feed_data['aaData'][]=array(
                $val['id'],
                $val['merchant_name'].$action,                
                ($item_names), $this->functions->normalPrettyPrice($val['min_order']),  
            $val['totals'],
                          
                $this->functions->FormatDateTime($val['expiration'],false),
               
                "$date<br/><span class=\"tag ".$val['status']."\">".($val['status'])."</span>"
                
              );
            }
            $this->otableOutput($feed_data);
          }           
          $this->otableNodata();  
     }


      public function branchList()
    {
      $slug=$this->data['slug'];
        
      
        
       $stmt = "SELECT * FROM mt_branches ORDER BY id DESC";

$query = $this->db->prepare($stmt);
$query->execute();

$rows = $query->fetchAll(PDO::FETCH_ASSOC);


    // Check if rows are returned
    if (is_array($rows) && count($rows) >= 1) {
            foreach ($rows as $val) {                   
              $chk="<input type=\"checkbox\" name=\"row[]\" value=\"$val[id]\" class=\"chk_child\" >";      
              $action="<div class=\"options\">
              <a href=\"$slug/id/$val[id]\" >".$this->functions->translation("default","Edit")."</a>
              <a href=\"javascript:;\" class=\"row_del\" rev=\"$val[id]\" >".$this->functions->translation("default","Delete")."</a>
              </div>";
              
              $date=$this->functions->FormatDateTime($val['date_created']);
              $item_names='';
          if (!empty($val['merchant_id'])){
                $merchant_id=json_decode($val['merchant_id']);
                if (is_array($merchant_id) && count($merchant_id)>=1){
                  foreach ($merchant_id as $mt_id) { 
                $datas= $this->functions->getMerchantById($mt_id);    
                $item_names .=$datas['restaurant_name'] .',';
                
                          }     
                          $item_names=substr($item_names,0,-1);
                }
              } 
          
          
              $feed_data['aaData'][]=array(
                $val['id'],
                $val['branch_name'].$action,                
                ($item_names),  
                 $date
                          
                
               
                
                
              );
            }
            $this->otableOutput($feed_data);
          }           
          $this->otableNodata();  
     }




      public function requestCancelOrderList()
  {
              
    $and = '';
    $current_panel = isset($this->data['current_panel'])?$this->data['current_panel']:'';
    if(!empty($current_panel)){
      switch ($current_panel) {
        case "admin":
          if(!$this->functions->isAdminLogin() ){
             $this->otableNodata();
          }     
          break;
              
        default:
          if ( !$this->functions->isMerchantLogin()){
             $this->otableNodata();
          }
          $merchant_id=$this->functions->getMerchantID();
          $and=" AND merchant_id =".($merchant_id)." ";         
          break;
      }
    } 
          
    $select = '';
        
      
      $stmt = "SELECT 
      order_id, trans_type, payment_type, sub_total, taxable_total, total_w_tax, a.status,
      a.date_created, admin_viewed, request_from, order_id_token, request_cancel_viewed,
      (
        SELECT CONCAT(first_name, ' ', last_name)
        FROM mt_client
        WHERE client_id = a.client_id
      ) AS client_name,
      
      (
        SELECT CONCAT(contact_phone)
        FROM mt_client
        WHERE client_id = a.client_id
      ) AS contact_phone,
      
      (
        SELECT GROUP_CONCAT(item_name)
        FROM mt_order_details
        WHERE order_id = a.order_id
      ) AS item
      
      $select
      
      FROM mt_order a
      WHERE 1     
      $and
      AND status NOT IN ('" . $this->functions->initialStatus() . "')
      AND request_cancel = '1'
      ORDER BY date_created DESC        
      ";

$query = $this->db->prepare($stmt);
$query->execute();
$res = $query->fetchAll(PDO::FETCH_ASSOC);

if ($res) {
    foreach ($res as $val) { 
        
          $new='';
          $action="<a data-id=\"".$val['order_id_token']."\" class=\"order_cancel_review\" href=\"javascript:\">".("Review Order")."</a>";
          
          if ($val['request_cancel_viewed']==2){
            $new=" <div class=\"uk-badge\">".$this->functions->translation("default","NEW")."</div>";
          }
                    
          $date=$this->functions->FormatDateTime($val['date_created']);
          
          $item=$this->functions->translateFoodItemByOrderId(
            $val['order_id'],
            'kr_merchant_lang_id'
          );
          
          if(isset($val['currency_format'])){
            $currency_format = explode("|",$val['currency_format']);              
            /*Price_Formatter::$number_format = array(
               'decimals'=>isset($currency_format[0])?$currency_format[0]:2, 
             'decimal_separator'=>isset($currency_format[1])?$currency_format[1]:'.',
             'thousand_separator'=>isset($currency_format[2])?$currency_format[2]:'',
             'position'=>isset($currency_format[3])?$currency_format[3]:'left',
             'spacer'=>Price_Formatter::getSpacer( isset($currency_format[3])?$currency_format[3]:'left' ),
             'currency_symbol'=>isset($currency_format[4])?$currency_format[4]:'',
            );*/
          }   
          
          $feed_data['aaData'][]=array(
            $val['order_id'],
            ucwords($val['client_name']).$new,
            $val['contact_phone'],
            $item,
            ($val['trans_type']),              
            $this->functions->prettyPaymentType('payment_order',$val['payment_type'],$val['order_id'],$val['trans_type']),
            $this->functions->formatNumber($val['sub_total']),
            $this->functions->formatNumber($val['taxable_total']),
            $this->functions->formatNumber($val['total_w_tax']),   
            "<span class=\"tag ".$val['status']."\">".($val['status'])."</span>",
            ($val['request_from']),
            $date,
            $action
            );
        }
        $this->otableOutput($feed_data);
      }    
      $this->otableNodata();    
  }





     public function AllPOSOrders()
{
    // Check if the admin is logged in
    if (!$this->functions->isAdminLogin()) {
        die();
    }

    // Define the columns for the DataTable
    $aColumns = [
        'order_id', 'a.merchant_id', 'c.first_name',
        'json_details', 'trans_type', 'payment_type',
        'sub_total', 'taxable_total', 'total_w_tax', 'a.status', 'request_from', 'a.date_created'
    ];

    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';

    // Get the DataTable parameters
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Add conditions to the WHERE clause
    if (!empty($sWhere)) {
        $sWhere .= " AND a.status NOT IN ('initial_order')";
    } else {
        $sWhere = " WHERE a.status NOT IN ('initial_order') AND `request_from` = 'pos'";
    }

    // Query to fetch the order data
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
            order_id, trans_type, payment_type, sub_total, taxable_total, total_w_tax, a.status, 
            a.order_number, a.merchant_id, a.date_created, admin_viewed, request_from,a.client_names,a.is_phone_order,a.is_retail,
            b.restaurant_name,
            CONCAT(c.first_name, ' ', c.last_name) AS client_name,
            (
                SELECT CONCAT(first_name, ' ', last_name)
                FROM mt_order_delivery_address
                WHERE order_id = a.order_id
                LIMIT 0,1
            ) AS customer_name
            $select
        FROM mt_order a
        LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
        LEFT JOIN mt_client c ON a.client_id = c.client_id
        $sWhere
        $sOrder
        $sLimit
    ";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->execute();

    // Fetch all the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // Get the total number of records found
    $stmt2 = "SELECT FOUND_ROWS()";
    $query2 = $this->db->prepare($stmt2);
    $query2->execute();
    $iTotalRecords = $query2->fetchColumn();

    // Initialize the DataTable output
    $feed_data['sEcho'] = intval($_GET['sEcho']);
    $feed_data['iTotalRecords'] = $iTotalRecords;
    $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

    if($res) {
         
    }else{
          
          $this->otableNodata();
    }


    // Process each result
    foreach ($res as $val) {

        // Set the client name
        $client_name = (!empty($val['client_name']) && strlen($val['client_name']) > 1) ? $val['client_name'] : 'Guest';
    
          
          if($val['is_phone_order']==1){
            
            $val['client_name']=$val['client_names'];
            
          }
    
    

        // Generate actions for each order
        $action = '';
     if($val['request_from']=="pos"){}else{
        $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"edit-order\" href=\"javascript:\">" . $this->functions->translation("default", "Edit") . "</a>";
     }
     $action .= "<br/><a data-id=\"" . $val['order_id'] . "\" class=\"view-receipt\" href=\"javascript:\">" . $this->functions->translation("default", "View") . "</a>";
        $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"view-order-history\" href=\"javascript:\">" . $this->functions->translation("default", "History") . "</a>";

        // Translate food items for the order
        $item = $this->functions->translateFoodItemByOrderId($val['order_id']);

        // Mark new orders
        $new = ($val['admin_viewed'] <= 0) ? " <div class=\"uk-badge\">" . $this->functions->translation("default", "NEW") . "</div>" : '';


    if($val['is_phone_order']==1 && $val['trans_type']=='pickup'){
            $val['trans_type']='Phone Pickup';
            
          }else if($val['is_phone_order']==1 && $val['trans_type']=='delivery'){
            $val['trans_type']='Phone Delivery';
            
          }       
          if($val['is_retail']==1){$val['trans_type']='Retail';}    

        // Format the date
        $date_created = $this->functions->prettyDate($val['date_created']);
        $date_created .= " " . $this->functions->prettyTime($val['date_created']);

        // Populate the DataTable row
        $feed_data['aaData'][] = [
            $val['order_id'],
            $val['merchant_id'] . '-' . $val['order_number'],
            $val['restaurant_name'] . $new,
            $client_name,
            $item,
            $val['trans_type'],
            $val['payment_type'],
            
            $this->functions->formatNumber($val['sub_total']),
            
            $this->functions->formatNumber($val['taxable_total']),
            
            $this->functions->formatNumber($val['total_w_tax']),
            "<span class=\"tag " . $val['status'] . "\">" . $val['status'] . "</span><div>$action</div>",
            $val['request_from'],
            $date_created
        ];
    }

    // Output the DataTable JSON response
    $this->otableOutput($feed_data);

    // If no data was found, output a no-data response
    $this->otableNodata();
}


public function orderStatusSettings()
        {           
            $merchant_id=$this->functions->getMerchantID();
                    
            $this->functions->updateOption("default_order_status",
            isset($this->data['default_order_status'])?$this->data['default_order_status']:''
            ,$merchant_id);
            
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved.");
        }   




     public function OrderStatusList()
    {     
      $this->OrderStatusListMerchant(false);
    }
    
    public function OrderStatusListMerchant($as_merchant = true)
{
    $mtid = $this->functions->getMerchantID();
    $where = $as_merchant ? "WHERE merchant_id = :merchant_id" : '';
    
    $slug = $this->data['slug'];
    $stmt = $this->db->prepare("
        SELECT * FROM mt_order_status
        $where
        ORDER BY description ASC
    ");

    if ($as_merchant) {
        $stmt->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);
    }

    $stmt->execute();
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        $feed_data = ['aaData' => []];

        foreach ($res as $val) {
            //echo $val['date_created'];die();
            $action = "<div class=\"options\">
                <a href=\"OrderStatus/Do/Add/id/{$val['stats_id']}\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['stats_id']}\">" . $this->functions->translation("default", "Delete") . "</a>
            </div>";
            
            //$date = $this->functions->FormatDateTime($val['date_created']);

            $date = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
            
            $feed_data['aaData'][] = [
                $val['stats_id'],
                $val['description'] . $action,
                $date,
            ];
        }

        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}





public function adminSettings()
    {     
                 
     
        
        /*DESKTOP LOGO*/
        $old_website_logo=$this->functions->getOptionAdmin('website_logo');
        if(!isset($this->data['photo'])){
          $this->data['photo']='';
        }   
        
        
        /*MOBILE LOGO*/
        $old_mobilelogo=$this->functions->getOptionAdmin('mobilelogo');
        if(!isset($this->data['mobilelogo'])){
          $this->data['mobilelogo']='';
        }   
       
        
      $this->functions->updateOptionAdmin("website_disbaled_auto_cart",
        isset($this->data['website_disbaled_auto_cart'])?$this->data['website_disbaled_auto_cart']:'');
        
      $this->functions->updateOptionAdmin("website_enabled_mobile_verification",
        isset($this->data['website_enabled_mobile_verification'])?$this->data['website_enabled_mobile_verification']:'');
        
      $this->functions->updateOptionAdmin("website_date_picker_format",
        isset($this->data['website_date_picker_format'])?$this->data['website_date_picker_format']:'');
        
      $this->functions->updateOptionAdmin("website_time_picker_format",
        isset($this->data['website_time_picker_format'])?$this->data['website_time_picker_format']:'');
        
        /*dump($this->data);
        die();*/
        
      $this->functions->updateOptionAdmin("website_date_format",
        isset($this->data['website_date_format'])?$this->data['website_date_format']:'');
        
        $this->functions->updateOptionAdmin("website_time_format",
        isset($this->data['website_time_format'])?$this->data['website_time_format']:'');
        
      $this->functions->updateOptionAdmin("merchant_sigup_status",
        isset($this->data['merchant_sigup_status'])?$this->data['merchant_sigup_status']:'');
        
        $this->functions->updateOptionAdmin("merchant_email_verification",
        isset($this->data['merchant_email_verification'])?$this->data['merchant_email_verification']:'' );
        
        $this->functions->updateOptionAdmin("merchant_payment_enabled",
        isset($this->data['merchant_payment_enabled'])?$this->data['merchant_payment_enabled']:'' );
        
        $this->functions->updateOptionAdmin("admin_enabled_paypal",
        isset($this->data['admin_enabled_paypal'])?$this->data['admin_enabled_paypal']:'');
        
        $this->functions->updateOptionAdmin("admin_enabled_card",
        isset($this->data['admin_enabled_card'])?$this->data['admin_enabled_card']:'' );
        
        $this->functions->updateOptionAdmin("admin_country_set",
        isset($this->data['admin_country_set'])?$this->data['admin_country_set']:'');
        
        $this->functions->updateOptionAdmin("admin_currency_set",
        isset($this->data['admin_currency_set'])?$this->data['admin_currency_set']:'');
                
        $this->functions->updateOptionAdmin("home_search_text",
        isset($this->data['home_search_text'])?$this->data['home_search_text']:'' );        
        
        $this->functions->updateOptionAdmin("home_search_subtext",
        isset($this->data['home_search_subtext'])?$this->data['home_search_subtext']:'' );        
        
        $this->functions->updateOptionAdmin("home_search_mode",
        isset($this->data['home_search_mode'])?$this->data['home_search_mode']:'' );        
        
      
        $this->functions->updateOptionAdmin("website_logo",
        isset($this->data['photo'])?$this->data['photo']:'' );   

        $this->functions->updateOptionAdmin("google_services_account",
        isset($this->data['google_services_account'])?$this->data['google_services_account']:'' );     
        
        $this->functions->updateOptionAdmin("website_title",
        isset($this->data['website_title'])?($this->data['website_title']):'' );        
        
        $this->functions->updateOptionAdmin("website_address",
        isset($this->data['website_address'])?$this->data['website_address']:'' );        
        
        $this->functions->updateOptionAdmin("website_contact_phone",
        isset($this->data['website_contact_phone'])?$this->data['website_contact_phone']:'' );        
        
        $this->functions->updateOptionAdmin("website_contact_email",
        isset($this->data['website_contact_email'])?$this->data['website_contact_email']:'' );        
        
        $this->functions->updateOptionAdmin("admin_decimal_place",
        isset($this->data['admin_decimal_place'])?$this->data['admin_decimal_place']:'' );        
        
        $this->functions->updateOptionAdmin("admin_use_separators",
        isset($this->data['admin_use_separators'])?$this->data['admin_use_separators']:'' );    
        
        $this->functions->updateOptionAdmin("google_auto_address",
        isset($this->data['google_auto_address'])?$this->data['google_auto_address']:'' );            
        
        $this->functions->updateOptionAdmin("home_search_radius",
        isset($this->data['home_search_radius'])?$this->data['home_search_radius']:'' );            
        
        $this->functions->updateOptionAdmin("home_search_unit_type",
        isset($this->data['home_search_unit_type'])?$this->data['home_search_unit_type']:'' );            
        
        $this->functions->updateOptionAdmin("google_default_country",
        isset($this->data['google_default_country'])?$this->data['google_default_country']:'' );            
        
        $this->functions->updateOptionAdmin("enabled_advance_search",
        isset($this->data['enabled_advance_search'])?$this->data['enabled_advance_search']:'' );
        
        $this->functions->updateOptionAdmin("disabled_share_location",
        isset($this->data['disabled_share_location'])?$this->data['disabled_share_location']:'' );
        
        $this->functions->updateOptionAdmin("enabled_search_map",
        isset($this->data['enabled_search_map'])?$this->data['enabled_search_map']:'' );
        
        $this->functions->updateOptionAdmin("admin_currency_position",
        isset($this->data['admin_currency_position'])?$this->data['admin_currency_position']:'' );
        
        $this->functions->updateOptionAdmin("merchant_default_country",
        isset($this->data['merchant_default_country'])?$this->data['merchant_default_country']:'' );
        
        $this->functions->updateOptionAdmin("merchant_specific_country",
        isset($this->data['merchant_specific_country'])?json_encode($this->data['merchant_specific_country']):'' );
                
        $this->functions->updateOptionAdmin("map_marker",
        isset($this->data['photo2'])?$this->data['photo2']:'' );
        
        $this->functions->updateOptionAdmin("global_admin_sender_email",
        isset($this->data['global_admin_sender_email'])?$this->data['global_admin_sender_email']:'' );
        
        $this->functions->updateOptionAdmin("merchant_disabled_registration",
        isset($this->data['merchant_disabled_registration'])?$this->data['merchant_disabled_registration']:'' );
        
        $this->functions->updateOptionAdmin("disabled_subscription",
        isset($this->data['disabled_subscription'])?$this->data['disabled_subscription']:'' );
        
        $this->functions->updateOptionAdmin("disabled_featured_merchant",
        isset($this->data['disabled_featured_merchant'])?$this->data['disabled_featured_merchant']:'' );
        
        $this->functions->updateOptionAdmin("merchant_days_can_edit_status",
        isset($this->data['merchant_days_can_edit_status'])?$this->data['merchant_days_can_edit_status']:'' );
        
        $this->functions->updateOptionAdmin("disabled_website_ordering",
        isset($this->data['disabled_website_ordering'])?$this->data['disabled_website_ordering']:'' );
        
        $this->functions->updateOptionAdmin("admin_activated_menu",
        isset($this->data['admin_activated_menu'])?$this->data['admin_activated_menu']:'' );
        
        $this->functions->updateOptionAdmin("website_hide_foodprice",
        isset($this->data['website_hide_foodprice'])?$this->data['website_hide_foodprice']:'' );
        
        $this->functions->updateOptionAdmin("disabled_cc_management",
        isset($this->data['disabled_cc_management'])?$this->data['disabled_cc_management']:'' );
                
        $this->functions->updateOptionAdmin("merchant_reg_abn",
        isset($this->data['merchant_reg_abn'])?$this->data['merchant_reg_abn']:'' );
        
        $this->functions->updateOptionAdmin("spicydish",
        isset($this->data['spicydish'])?$this->data['spicydish']:'' );
        
        $this->functions->updateOptionAdmin("website_timezone",
        isset($this->data['website_timezone'])?$this->data['website_timezone']:'' );
        
        $this->functions->updateOptionAdmin("website_admin_mutiple_login",
        isset($this->data['website_admin_mutiple_login'])?$this->data['website_admin_mutiple_login']:'' );
        
        $this->functions->updateOptionAdmin("website_merchant_mutiple_login",
        isset($this->data['website_merchant_mutiple_login'])?$this->data['website_merchant_mutiple_login']:'' );
        
        $this->functions->updateOptionAdmin("website_disabled_guest_checkout",
        isset($this->data['website_disabled_guest_checkout'])?$this->data['website_disabled_guest_checkout']:'' );
        
        $this->functions->updateOptionAdmin("website_reviews_actual_purchase",
        isset($this->data['website_reviews_actual_purchase'])?$this->data['website_reviews_actual_purchase']:'' );
        
        $this->functions->updateOptionAdmin("website_terms_merchant",
        isset($this->data['website_terms_merchant'])?$this->data['website_terms_merchant']:'' );
        $this->functions->updateOptionAdmin("website_terms_merchant_url",
        isset($this->data['website_terms_merchant_url'])?$this->data['website_terms_merchant_url']:'' );
        
        $this->functions->updateOptionAdmin("website_terms_customer",
        isset($this->data['website_terms_customer'])?$this->data['website_terms_customer']:'' );
        $this->functions->updateOptionAdmin("website_terms_customer_url",
        isset($this->data['website_terms_customer_url'])?$this->data['website_terms_customer_url']:'' );
                
        $this->functions->updateOptionAdmin("admin_thousand_separator",
        isset($this->data['admin_thousand_separator'])?$this->data['admin_thousand_separator']:'' );
        
        $this->functions->updateOptionAdmin("admin_decimal_separator",
        isset($this->data['admin_decimal_separator'])?$this->data['admin_decimal_separator']:'' );
        
        $this->functions->updateOptionAdmin("website_disabled_login_popup",
        isset($this->data['website_disabled_login_popup'])?$this->data['website_disabled_login_popup']:'' );
        
        $this->functions->updateOptionAdmin("merchant_can_edit_reviews",
        isset($this->data['merchant_can_edit_reviews'])?$this->data['merchant_can_edit_reviews']:'' );
        
        $this->functions->updateOptionAdmin("website_enabled_rcpt",
        isset($this->data['website_enabled_rcpt'])?$this->data['website_enabled_rcpt']:'' );
        
        $this->functions->updateOptionAdmin("website_receipt_logo",
        isset($this->data['website_receipt_logo'])?$this->data['website_receipt_logo']:'' );
        
        $this->functions->updateOptionAdmin("disabled_cart_sticky",
        isset($this->data['disabled_cart_sticky'])?$this->data['disabled_cart_sticky']:'' );
        
        $this->functions->updateOptionAdmin("search_result_bydistance",
        isset($this->data['search_result_bydistance'])?$this->data['search_result_bydistance']:'' );
        
        $this->functions->updateOptionAdmin("google_geo_api_key",
        isset($this->data['google_geo_api_key'])?$this->data['google_geo_api_key']:'' );


         $this->functions->updateOptionAdmin("google_geo_api_key_android",
        isset($this->data['google_geo_api_key_android'])?$this->data['google_geo_api_key_android']:'' );
          $this->functions->updateOptionAdmin("google_geo_api_key_ios",
        isset($this->data['google_geo_api_key_ios'])?$this->data['google_geo_api_key_ios']:'' );
        
        /* custom code 8 starts */
        /*$this->functions->updateOptionAdmin("webapp2_api_has_key",
        isset($this->data['webapp2_api_has_key'])?$this->data['webapp2_api_has_key']:'' );*/
        /* custom code 8 ends */
        
          
        $this->functions->updateOption("place_api_id_admin",
        isset($this->data['place_api_id_admin'])?$this->data['place_api_id_admin']:'');
        
        $this->functions->updateOption("place_api_key_admin",
        isset($this->data['place_api_key_admin'])?$this->data['place_api_key_admin']:'');
        
        
        $this->functions->updateOptionAdmin("website_enabled_map_address",
        isset($this->data['website_enabled_map_address'])?$this->data['website_enabled_map_address']:'' );
        
        $this->functions->updateOptionAdmin("client_custom_field_name1",
        isset($this->data['client_custom_field_name1'])?$this->data['client_custom_field_name1']:'' );
        
        $this->functions->updateOptionAdmin("client_custom_field_name2",
        isset($this->data['client_custom_field_name2'])?$this->data['client_custom_field_name2']:'' );
        
        $this->functions->updateOptionAdmin("merchant_days_can_edit_status_basedon",
        isset($this->data['merchant_days_can_edit_status_basedon'])?$this->data['merchant_days_can_edit_status_basedon']:'' );
        
        $this->functions->updateOptionAdmin("merchant_status_disabled",
        isset($this->data['merchant_status_disabled'])?$this->data['merchant_status_disabled']:'' );
        
        $this->functions->updateOptionAdmin("view_map_disabled",
        isset($this->data['view_map_disabled'])?$this->data['view_map_disabled']:'' );
        
        $this->functions->updateOptionAdmin("view_map_default_zoom",
        isset($this->data['view_map_default_zoom'])?$this->data['view_map_default_zoom']:'' );
        
        $this->functions->updateOptionAdmin("view_map_default_zoom_s",
        isset($this->data['view_map_default_zoom_s'])?$this->data['view_map_default_zoom_s']:'' );
        
        $this->functions->updateOptionAdmin("receipt_default_subject",
        isset($this->data['receipt_default_subject'])?$this->data['receipt_default_subject']:'' );
        
        $this->functions->updateOptionAdmin("merchant_tbl_book_disabled",
        isset($this->data['merchant_tbl_book_disabled'])?$this->data['merchant_tbl_book_disabled']:'' );
        
        $this->functions->updateOptionAdmin("merchant_changeorder_sms",
        isset($this->data['merchant_changeorder_sms'])?$this->data['merchant_changeorder_sms']:'' );
        
        $this->functions->updateOptionAdmin("customer_ask_address",
        isset($this->data['customer_ask_address'])?$this->data['customer_ask_address']:'' );
                                    
        $this->functions->updateOptionAdmin("captcha_site_key",
        isset($this->data['captcha_site_key'])?$this->data['captcha_site_key']:'');
        
        $this->functions->updateOptionAdmin("captcha_secret",
        isset($this->data['captcha_secret'])?$this->data['captcha_secret']:'');
        
        $this->functions->updateOptionAdmin("captcha_lang",
        isset($this->data['captcha_lang'])?$this->data['captcha_lang']:'');
        
        $this->functions->updateOptionAdmin("captcha_customer_signup",
        isset($this->data['captcha_customer_signup'])?$this->data['captcha_customer_signup']:'');
        
        $this->functions->updateOptionAdmin("captcha_merchant_signup",
        isset($this->data['captcha_merchant_signup'])?$this->data['captcha_merchant_signup']:'');
        
        $this->functions->updateOptionAdmin("captcha_customer_login",
        isset($this->data['captcha_customer_login'])?$this->data['captcha_customer_login']:'');
        
        $this->functions->updateOptionAdmin("captcha_merchant_login",
        isset($this->data['captcha_merchant_login'])?$this->data['captcha_merchant_login']:'');
        
        $this->functions->updateOptionAdmin("captcha_admin_login",
        isset($this->data['captcha_admin_login'])?$this->data['captcha_admin_login']:'');
        
        $this->functions->updateOptionAdmin("captcha_order",
        isset($this->data['captcha_order'])?$this->data['captcha_order']:'');
    
     $this->functions->updateOptionAdmin("captcha_contact",
        isset($this->data['captcha_contact'])?$this->data['captcha_contact']:'');
    
        
        $this->functions->updateOptionAdmin("blocked_email_add",
        isset($this->data['blocked_email_add'])?$this->data['blocked_email_add']:'');
        
        $this->functions->updateOptionAdmin("blocked_mobile",
        isset($this->data['blocked_mobile'])?$this->data['blocked_mobile']:'');
        
        $this->functions->updateOptionAdmin("admin_zipcode_searchtype",
        isset($this->data['admin_zipcode_searchtype'])?$this->data['admin_zipcode_searchtype']:'');
        
        $this->functions->updateOptionAdmin("mobilelogo",
        isset($this->data['mobilelogo'])?$this->data['mobilelogo']:'');
        
        $this->functions->updateOptionAdmin("theme_enabled_email_verification",
        isset($this->data['theme_enabled_email_verification'])?$this->data['theme_enabled_email_verification']:'');
        
        $this->functions->updateOptionAdmin("google_distance_method",
        isset($this->data['google_distance_method'])?$this->data['google_distance_method']:'');
        
        $this->functions->updateOptionAdmin("google_use_curl",
        isset($this->data['google_use_curl'])?$this->data['google_use_curl']:'');
        
        $this->functions->updateOptionAdmin("admin_menu_allowed_merchant",
        isset($this->data['admin_menu_allowed_merchant'])?$this->data['admin_menu_allowed_merchant']:'');
        
        $this->functions->updateOptionAdmin("admin_printing_receipt_width",
        isset($this->data['admin_printing_receipt_width'])?$this->data['admin_printing_receipt_width']:'');
        
        $this->functions->updateOptionAdmin("admin_printing_receipt_size",
        isset($this->data['admin_printing_receipt_size'])?$this->data['admin_printing_receipt_size']:'');
        
        $this->functions->updateOptionAdmin("enabled_merchant_check_closing_time",
        isset($this->data['enabled_merchant_check_closing_time'])?$this->data['enabled_merchant_check_closing_time']:'');
        
        $this->functions->updateOptionAdmin("admin_add_space_between_price",
        isset($this->data['admin_add_space_between_price'])?$this->data['admin_add_space_between_price']:'');
        
        $this->functions->updateOptionAdmin("enabled_food_search_menu",
        isset($this->data['enabled_food_search_menu'])?$this->data['enabled_food_search_menu']:'');
        
        $this->functions->updateOptionAdmin("location_default_country",
        isset($this->data['location_default_country'])?$this->data['location_default_country']:'');
        
        $this->functions->updateOptionAdmin("cod_change_required",
        isset($this->data['cod_change_required'])?$this->data['cod_change_required']:'');
        
        /*$this->functions->updateOptionAdmin("receipt_computation_method",
        isset($this->data['receipt_computation_method'])?$this->data['receipt_computation_method']:1);*/
        
        $this->functions->updateOptionAdmin("website_disabled_cart_validation",
        isset($this->data['website_disabled_cart_validation'])?$this->data['website_disabled_cart_validation']:1);
        
        $this->functions->updateOptionAdmin("cancel_order_days_applied",
        isset($this->data['cancel_order_days_applied'])?$this->data['cancel_order_days_applied']:'');
        
        $this->functions->updateOptionAdmin("cancel_order_status_accepted",
        isset($this->data['cancel_order_status_accepted'])?json_encode($this->data['cancel_order_status_accepted']):1);
        
        $this->functions->updateOptionAdmin("cancel_order_enabled",
        isset($this->data['cancel_order_enabled'])?$this->data['cancel_order_enabled']:'');
        
        $this->functions->updateOptionAdmin("website_review_type",
        isset($this->data['website_review_type'])?$this->data['website_review_type']:'');
        
        $this->functions->updateOptionAdmin("review_baseon_status",
        isset($this->data['review_baseon_status'])?json_encode($this->data['review_baseon_status']):1);
        
        $this->functions->updateOptionAdmin("website_use_date_picker",
        isset($this->data['website_use_date_picker'])?$this->data['website_use_date_picker']:'');
        
        $this->functions->updateOptionAdmin("website_use_time_picker",
        isset($this->data['website_use_time_picker'])?$this->data['website_use_time_picker']:'');
        
        $this->functions->updateOptionAdmin("website_time_picker_interval",
        isset($this->data['website_time_picker_interval'])?$this->data['website_time_picker_interval']:'');
        
        $this->functions->updateOptionAdmin("mapbox_access_token",
        isset($this->data['mapbox_access_token'])?$this->data['mapbox_access_token']:'');
        
        $this->functions->updateOptionAdmin("map_provider",
        isset($this->data['map_provider'])?$this->data['map_provider']:'');
        
        $this->functions->updateOptionAdmin("mapbox_default_zoom",
        isset($this->data['mapbox_default_zoom'])?$this->data['mapbox_default_zoom']:'');
        
        $this->functions->updateOptionAdmin("earn_points_review_status",
        isset($this->data['earn_points_review_status'])?json_encode($this->data['earn_points_review_status']):1);

        $this->functions->updateOptionAdmin("inventory_accepted_order_status",
        isset($this->data['inventory_accepted_order_status'])?json_encode($this->data['inventory_accepted_order_status']):1);

        $this->functions->updateOptionAdmin("inventory_cancel_order_status",
        isset($this->data['inventory_cancel_order_status'])?json_encode($this->data['inventory_cancel_order_status']):1);

        $this->functions->updateOptionAdmin("inventory_reports_default_status",
        isset($this->data['inventory_reports_default_status'])?json_encode($this->data['inventory_reports_default_status']):1);

        
        $this->functions->updateOptionAdmin("earn_points_booking_status",
        isset($this->data['earn_points_booking_status'])?json_encode($this->data['earn_points_booking_status']):1);
        
        $this->functions->updateOptionAdmin("website_review_approved_status",
        isset($this->data['website_review_approved_status'])?$this->data['website_review_approved_status']:'');
        
        $this->functions->updateOptionAdmin("cancel_order_hours",
        isset($this->data['cancel_order_hours'])?$this->data['cancel_order_hours']:'');
        
        $this->functions->updateOptionAdmin("cancel_order_minutes",
        isset($this->data['cancel_order_minutes'])?$this->data['cancel_order_minutes']:'');
        
        $this->functions->updateOptionAdmin("website_review_decline_status",
        isset($this->data['website_review_decline_status'])?$this->data['website_review_decline_status']:'');
        
        $this->functions->updateOptionAdmin("publish_review_status",
        isset($this->data['publish_review_status'])?json_encode($this->data['publish_review_status']):1);
        
        $this->functions->updateOptionAdmin("book_table_earn_status",
        isset($this->data['book_table_earn_status'])?json_encode($this->data['book_table_earn_status']):1);
                        
        $this->functions->updateOptionAdmin("pre_configure_size",
        isset($this->data['pre_configure_size'])?$this->data['pre_configure_size']:'');
        
        $this->functions->updateOptionAdmin("enabled_map_selection_delivery",
        isset($this->data['enabled_map_selection_delivery'])?$this->data['enabled_map_selection_delivery']:'');
        
        $this->functions->updateOptionAdmin("disabled_order_confirm_page",
        isset($this->data['disabled_order_confirm_page'])?$this->data['disabled_order_confirm_page']:'');
        
        $this->functions->updateOptionAdmin("review_merchant_can_add_review_status",
        isset($this->data['review_merchant_can_add_review_status'])?json_encode($this->data['review_merchant_can_add_review_status']):'');
        
        $this->functions->updateOptionAdmin("booking_cancel_hours",
        isset($this->data['booking_cancel_hours'])?$this->data['booking_cancel_hours']:'');
        
        $this->functions->updateOptionAdmin("booking_cancel_days",
        isset($this->data['booking_cancel_days'])?$this->data['booking_cancel_days']:'');
        
        $this->functions->updateOptionAdmin("booking_cancel_minutes",
        isset($this->data['booking_cancel_minutes'])?$this->data['booking_cancel_minutes']:'');
        
        $this->functions->updateOptionAdmin("google_maps_api_key",
        isset($this->data['google_maps_api_key'])?$this->data['google_maps_api_key']:'');
        
        $this->functions->updateOptionAdmin("mapbox_method",
        isset($this->data['mapbox_method'])?$this->data['mapbox_method']:'');
        
        $this->functions->updateOptionAdmin("map_distance_results",
        isset($this->data['map_distance_results'])?$this->data['map_distance_results']:'');
        
        $this->functions->updateOptionAdmin("restrict_order_by_status",
        isset($this->data['restrict_order_by_status'])?json_encode($this->data['restrict_order_by_status']):'');

        $this->functions->updateOptionAdmin("admin_menu_lazyload",
        isset($this->data['admin_menu_lazyload'])?(integer)$this->data['admin_menu_lazyload']:'');  

        $this->functions->updateOptionAdmin("google_booking_mode",
        isset($this->data['google_booking_mode'])?$this->data['google_booking_mode']:'Sandbox'); 

         $this->functions->updateOptionAdmin("partner_id_google",
        isset($this->data['partner_id_google'])?$this->data['partner_id_google']:''); 

          $this->functions->updateOptionAdmin("google_booking_url_sandbox",
        isset($this->data['google_booking_url_sandbox'])?$this->data['google_booking_url_sandbox']:''); 

          $this->functions->updateOptionAdmin("google_booking_url_live",
        isset($this->data['google_booking_url_live'])?$this->data['google_booking_url_live']:''); 


        
        $this->functions->updateOptionAdmin("admin_service_fee",
        isset($this->data['admin_service_fee'])?(float)$this->data['admin_service_fee']:0);     
        
        $this->functions->updateOptionAdmin("admin_service_fee_applytax",
        isset($this->data['admin_service_fee_applytax'])?(integer)$this->data['admin_service_fee_applytax']:0);     
        
        $this->functions->updateOptionAdmin("captcha_driver_signup",
        isset($this->data['captcha_driver_signup'])?(integer)$this->data['captcha_driver_signup']:0);     
        
        $this->functions->updateOptionAdmin("mobile2_hide_empty_category",
        isset($this->data['mobile2_hide_empty_category'])?(integer)$this->data['mobile2_hide_empty_category']:0);     
        
        $this->functions->updateOptionAdmin("merchant_time_can_edit_status",
        isset($this->data['merchant_time_can_edit_status'])?trim($this->data['merchant_time_can_edit_status']):'');  

        

       


        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Setting saved");
    }


public function addOrderStatus()
    {       
      
     
      
      $mtid=$this->functions->getMerchantID();
      
      if (1==1){
        $params=array(
          'description'=>trim(($this->data['description']) ),
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'merchant_id'=>$mtid
        );
        if (isset($this->data['is_admin'])){
          unset($params['merchant_id']);
        }     
         if (empty($this->data['id'])){ 

           $last_insert_id = $this->functions->insertData('mt_order_status', $params);
          if ($last_insert_id!== false){
                  $this->details=$last_insert_id;
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");                
              }
            } else {          
              unset($params['date_created']);
            $params['date_modified']=$this->functions->dateNow(); 
                 
            $res = $this->functions->updateData('mt_order_status' , $params ,'stats_id',$this->data['id']);
            if ($res){
              $this->code=1;
                      $this->msg=$this->functions->translation("default",'Status updated.');  
          } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
          } 
      } else $this->msg="";           
    }













     public function categoryList()
{
    // Define columns and initialize query components
    $aColumns = array('cat_id', 'category_name', 'category_description', 'photo', 'dish', 'status');
    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    // Get DataTables parameters
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }

    // Get merchant ID and slug
    $mtid = $this->functions->getMerchantID();
    $slug = $this->data['slug'];

    // Prepare the SQL statement
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS * FROM mt_category
        WHERE merchant_id = :merchant_id
        $sWhere
        $sOrder
        $sLimit
    ";

    // Prepare and execute the SQL statement
    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        // Get total records
        $stmt2 = "SELECT FOUND_ROWS()";
        $query2 = $this->db->query($stmt2);
        $iTotalRecords = $query2->fetchColumn();

        $feed_data = [
            'sEcho' => intval($_GET['sEcho']),
            'iTotalRecords' => $iTotalRecords,
            'iTotalDisplayRecords' => $iTotalRecords,
            'aaData' => []
        ];

        // Process rows
        foreach ($rows as $val) {
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"{$val['cat_id']}\" class=\"chk_child\">";
            $option = "<div class=\"options\">
                <a href=\"{$slug}/id/{$val['cat_id']}\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"delete_item\" data-id=\"{$val['cat_id']}\">" . $this->functions->translation("default", "Delete") . "</a>
            </div>";

            $date = $this->functions->FormatDateTime($val['date_created']);

            $photo = !empty($val['photo'])
                ? "<img class=\"uk-thumbnail uk-thumbnail-mini\" src=\"" . Config::$baseUrl . "/upload/{$val['photo']}\" >"
                : '';

            $feed_data['aaData'][] = [
                $chk,
                stripslashes($val['category_name']) . $option,
                stripslashes($val['category_description']),
                $photo,
                $val['dish'],

                '<input type="checkbox" name="pos_available" class="pos_available" id="pos_available" value="' . $val['cat_id'] . '" ' . ($val['pos_available'] == 2 ? 'checked' : '') . '>',
                
                 '<input type="checkbox" name="web_available" class="web_available" id="web_available" value="' . $val['cat_id'] . '" ' . ($val['web_available'] == 2 ? 'checked' : '') . '>',
                

                "$date<br/><span class=\"tag {$val['status']}\">{$val['status']}</span>"
            ];
        }

        $this->otableOutput($feed_data);

    } catch (PDOException $e) {
        // Handle database errors
        $this->otableNodata();
    }
}


public function bookingSlots()
{
    $aColumns = array('date');
    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }

    $mtid = $this->functions->getMerchantID();
    $slug = $this->data['slug'];

    $sOrder = "ORDER BY date ASC";

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS * 
        FROM mt_booking_slots
        WHERE merchant_id = :merchant_id
        AND date >= CURDATE()
        $sWhere
        $sOrder
        $sLimit
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        $stmt2 = "SELECT FOUND_ROWS()";
        $query2 = $this->db->query($stmt2);
        $iTotalRecords = $query2->fetchColumn();

        $feed_data = [
            'sEcho' => intval($_GET['sEcho']),
            'iTotalRecords' => $iTotalRecords,
            'iTotalDisplayRecords' => $iTotalRecords,
            'aaData' => []
        ];

        foreach ($rows as $val) {

            // Get sum of used_slots from mt_booking_slots_child
            /*$stmt_child = $this->db->prepare("
                SELECT COALESCE(SUM(used_slots), 0) 
                FROM mt_booking_slots_child 
                WHERE parent_id = ?
            ");
            $stmt_child->execute([$val['id']]);
            $child_sum = $stmt_child->fetchColumn();*/


            $stmt_child = $this->db->prepare("
              SELECT COALESCE(SUM(used_slots), 0) 
              FROM (
                  SELECT MIN(used_slots) AS used_slots
                  FROM mt_booking_slots_child
                  WHERE parent_id = ?
                  GROUP BY utc_times
              ) AS t
          ");
          $stmt_child->execute([$val['id']]);
          $child_sum = $stmt_child->fetchColumn();



            // Build buttons for after date_created
            $buttons = '';
            $disableDelete = ($val['date'] == date('Y-m-d') || $child_sum > 0);

            // Edit button
            $buttons .= "<a href=\"{$slug}/id/{$val['id']}\" class=\"tag Accepted\">" 
            . $this->functions->translation("default", "View") . "</a><br>";


            // Delete button
            if (!$disableDelete) {
                $buttons .= "<a href=\"javascript:;\" class=\"delete_item tag pending\" data-id=\"{$val['id']}\">" 
                            . $this->functions->translation("default", "Delete") . "</a>";
            } else {
                /*$buttons .= "<span class=\"disabled_delete\">" 
                            . $this->functions->translation("default", "Delete") . "</span>";*/
            }

            $date_created = $this->functions->FormatDateTime($val['date_created']);


            if ($disableDelete) {
    $checkbox = '<input type="checkbox" disabled>';
} else {
    $checkbox = '<input type="checkbox" class="row_checkbox" value="'.$val['id'].'">';
}


            // Handle shift1 same time condition
$shift1_start = $val['shift1_start'];
$shift1_end   = $val['shift1_end'];
$shift1_display_start = $this->functions->prettyTime($shift1_start);
$shift1_display_end   = $this->functions->prettyTime($shift1_end);

if ($shift1_start == $shift1_end) {
    $shift1_display_start = '-';
    $shift1_display_end   = '-';
}

// Handle shift2 same time condition
$shift2_start = $val['shift2_start'];
$shift2_end   = $val['shift2_end'];
$shift2_display_start = $this->functions->prettyTime($shift2_start);
$shift2_display_end   = $this->functions->prettyTime($shift2_end);

if ($shift2_start == $shift2_end) {
    $shift2_display_start = '-';
    $shift2_display_end   = '-';
}


            $feed_data['aaData'][] = [
                $checkbox,
                $val['date'],               // Date column remains same
               $shift1_display_start,
    $shift1_display_end,
    $shift2_display_start,
    $shift2_display_end,
                $val['person_per_party'],
                $val['no_of_slots'],
                $child_sum,
                $date_created,  $buttons  // Buttons appear under date_created
            ];
        }

        $this->otableOutput($feed_data);

    } catch (PDOException $e) {
        $this->otableNodata();
    }
}






public function bookingSlots_9august()
{
    $aColumns = array('date');
    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }

    $mtid = $this->functions->getMerchantID();
    $slug = $this->data['slug'];

    $sOrder = "ORDER BY date ASC";

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS * 
        FROM mt_booking_slots
        WHERE merchant_id = :merchant_id
        AND date >= CURDATE()   -- ✅ exclude past dates
        $sWhere
        $sOrder
        $sLimit
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':merchant_id', $mtid, PDO::PARAM_INT);
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        $stmt2 = "SELECT FOUND_ROWS()";
        $query2 = $this->db->query($stmt2);
        $iTotalRecords = $query2->fetchColumn();

        $feed_data = [
            'sEcho' => intval($_GET['sEcho']),
            'iTotalRecords' => $iTotalRecords,
            'iTotalDisplayRecords' => $iTotalRecords,
            'aaData' => []
        ];

        foreach ($rows as $val) {
            $option = "<div class=\"options\">";
            $option .= "<a href=\"{$slug}/id/{$val['id']}\">" . $this->functions->translation("default", "Edit") . "</a> ";
            $option .= "<a href=\"javascript:;\" class=\"delete_item\" data-id=\"{$val['id']}\">" . $this->functions->translation("default", "Delete") . "</a>";
            $option .= "</div>";

            $date_created = $this->functions->FormatDateTime($val['date_created']);

            $feed_data['aaData'][] = [
                ($val['date']) . $option,
                ($val['shift1_start']),
                ($val['shift1_end']),
                ($val['shift2_start']),
                ($val['shift2_end']),
                ($val['person_per_party']),
                ($val['no_of_slots']),
                ($val['used_slots']),
                $date_created
            ];
        }

        $this->otableOutput($feed_data);

    } catch (PDOException $e) {
        $this->otableNodata();
    }
}





public function bookingSlots_child()
{
    $aColumns = array('slot_starts', 'slot_ends');
    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }

    $mtid = $this->functions->getMerchantID();
    $slug = $this->data['slug'];
    $parent_id = $this->data['parent_id'];

    // Override order to always sort by slot_starts ascending
    //$sOrder = "ORDER BY slot_starts ASC";

    $sOrder = "ORDER BY id ASC";

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS * FROM mt_booking_slots_child
        WHERE parent_id = :parent_id
        $sWhere
        $sOrder
        $sLimit
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->bindParam(':parent_id', $parent_id, PDO::PARAM_INT);
        $query->execute();
        $rows = $query->fetchAll(PDO::FETCH_ASSOC);

        $stmt2 = "SELECT FOUND_ROWS()";
        $query2 = $this->db->query($stmt2);
        $iTotalRecords = $query2->fetchColumn();

        $feed_data = [
            'sEcho' => intval($_GET['sEcho']),
            'iTotalRecords' => $iTotalRecords,
            'iTotalDisplayRecords' => $iTotalRecords,
            'aaData' => []
        ];
        $action="";
        $action1="";

        foreach ($rows as $val) {
          $action .= "<a data-id=\"" . $val['id'] . "\" class=\"edit-slots\" href=\"javascript:;\">"
         . "<i class=\"fa fa-pencil\"></i>"
         . "</a>";

         $action1 .= "<a data-id=\"" . $val['id'] . "\" class=\"edit-party\" href=\"javascript:;\">"
         . "<i class=\"fa fa-pencil\"></i>"
         . "</a>";


          

            $date_created = $this->functions->FormatDateTime($val['date_created']);

            $feed_data['aaData'][] = [

                '<input type="checkbox" name="slots_available" class="slots_available" id="slots_available" value="' . $val['id'] . '" ' . ($val['available'] == 1 ? 'checked' : '') . '>',

                 $this->functions->prettyTime($val['slot_starts']),
             $this->functions->prettyTime($val['slot_ends']),
                 ($val['person_per_party']). "<br>",
                ($val['no_of_slots']) . "<br>",
                $val['available_slots']
               
              
            ];
            $action="";
            $action1="";
        }

        $this->otableOutput($feed_data);

    } catch (PDOException $e) {
        $this->otableNodata();
    }
}









    public function addCategory()
        {           
                                                    
            $params=array(
              'category_name'=>addslashes($this->data['category_name']),
              'category_description'=>addslashes($this->data['category_description']),
              'photo'=>isset($this->data['photo'])?addslashes($this->data['photo']):'',
              'status'=>addslashes($this->data['status']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'merchant_id'=>$this->functions->getMerchantID(),              
              'spicydish_notes'=>isset($this->data['spicydish_notes'])?$this->data['spicydish_notes']:'',
              'dish'=>isset($this->data['dish'])?json_encode($this->data['dish']):''              
            );              
                                            
            $day_input = isset($this->data['days'])?$this->data['days']:'';
            $days = $this->functions->dayList();
            foreach ($days as $day=>$val) {
                $params[$day] = isset($day_input[$day])?$day_input[$day]:0;
            }
            
            if(isset($this->data['start_time'])){
                if(is_array($this->data['start_time']) && count($this->data['start_time'])>=1){
                    foreach ($this->data['start_time'] as $day=>$val) {
                        $params[$day."_start"]=$val;
                    }
                }           
            }       
            
            if(isset($this->data['end_time'])){
                if(is_array($this->data['end_time']) && count($this->data['end_time'])>=1){
                    foreach ($this->data['end_time'] as $day=>$val) {
                        $params[$day."_end"]=$val;
                    }
                }           
            }       
                    
                
            if (isset($this->data['category_name_trans'])){             
                if ($this->functions->okToDecode()){
                    $params['category_name_trans']=json_encode($this->data['category_name_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['category_name_trans']=json_encode($this->data['category_name_trans']);              
            }
            if (isset($this->data['category_description_trans'])){
                if ($this->functions->okToDecode()){
                    $params['category_description_trans']=json_encode($this->data['category_description_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['category_description_trans']=json_encode($this->data['category_description_trans']);
            }

            
            //$params = FunctionsV3::purifyData($params);
            $cat_id = 0;
            
            //$command = Yii::app()->db->createCommand();
            if (isset($this->data['id']) && is_numeric($this->data['id'])){ 
                
                $filename_to_delete='';
                
                if ($temp_res=$this->functions->getCategory($this->data['id'])){                                       
                    if(!isset($this->data['photo'])){
                        $this->data['photo']='';
                    }       
                    if($this->data['photo']!=$temp_res['photo']){
                        $filename_to_delete=$temp_res['photo'];
                    }               
                }   
                            
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();    
                                        
                

                $res =$this->functions->updateData('mt_category' , $params ,'cat_id',$this->data['id']);

                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Category updated.');  
                    
                                                                      
                    
                    $cat_id = (integer) $this->data['id'];
                    
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else {        

                 $last_insert_id = $this->functions->insertData('mt_category', $params);
                 if ($last_insert_id!== false){        
                
                    $this->details = $last_insert_id;  
                    $cat_id = (integer) $this->details;
                
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Category added.');                     
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }
            
            
                
            
        }


public function add_bookingslots()
{
    $merchant_id = $this->functions->getMerchantID();
    $date_now = $this->functions->dateNow();

    $enabled = isset($this->data['enabled']) ? $this->data['enabled'] : [];
    $original_day_enabled = isset($this->data['original_day_enabled']) ? $this->data['original_day_enabled'] : [];
    $day_name = isset($this->data['day_name']) ? $this->data['day_name'] : [];
    $date = isset($this->data['date']) ? $this->data['date'] : [];
    $shift1_start = isset($this->data['shift1_start']) ? $this->data['shift1_start'] : [];
    $shift1_end = isset($this->data['shift1_end']) ? $this->data['shift1_end'] : [];
    $shift2_start = isset($this->data['shift2_start']) ? $this->data['shift2_start'] : [];
    $shift2_end = isset($this->data['shift2_end']) ? $this->data['shift2_end'] : [];
    $person_per_party = isset($this->data['person_per_party']) ? $this->data['person_per_party'] : [];
    $no_of_slots = isset($this->data['no_of_slots']) ? $this->data['no_of_slots'] : [];
    $m_holiday=$this->functions->getMerchantHoliday($merchant_id);
    $m_holiday = !empty($m_holiday) ? $m_holiday : [];

    

    // First pass: validate required shift1 fields for enabled rows
   /* for ($i = 0; $i < 7; $i++) {
        if (isset($enabled[$i]) && $enabled[$i] == 1) {
            $start = trim($shift1_start[$i] ?? '');
            $end = trim($shift1_end[$i] ?? '');

            if (empty($start) || empty($end)) {
                $this->msg = "ERROR: Shift 1 start and end time are required for enabled row " . ($i + 1) . ".";
                return;
            }
        }
    }*/
//print_r($date);die();
    $saved = 0;

    for ($i = 0; $i < 7; $i++) {
        if (!isset($date[$i])) continue;

        // Skip rows that are not enabled
        if (!isset($enabled[$i]) || $enabled[$i] != 1) {

            if($original_day_enabled[$i]==0){

            continue;
            }
        }

        // Default to 1 if value is 0 or empty
        $party_size = isset($person_per_party[$i]) && (int)$person_per_party[$i] > 0 ? (int)$person_per_party[$i] : 1;



        $slots_count = isset($no_of_slots[$i]) && (int)$no_of_slots[$i] > 0 ? (int)$no_of_slots[$i] : 1;

        if (in_array($date[$i], $m_holiday)) {
            $available_count = 0;
            $enabled[$i]=0;
        }else{
          $available_count = $slots_count;
        }



        if (!isset($enabled[$i]) || $enabled[$i] != 1) {
           $available_count = 0;
          }else{
          $available_count = $slots_count;
          }


       if($available_count>0){

        $params = [
            'merchant_id'       => $merchant_id,
            'date_created'      => $date_now,
            'date'              => $date[$i],
            'enabled'           => 1,
            'shift1_start'      => $shift1_start[$i] ?? '',
            'shift1_end'        => $shift1_end[$i] ?? '',
            'shift2_start'      => $shift2_start[$i] ?? '',
            'shift2_end'        => $shift2_end[$i] ?? '',
            'person_per_party'  => $party_size,
            'no_of_slots'       => $slots_count,
            'used_slots'        => 0,
        ];

        // Insert into mt_booking_slots (parent)
        $parent_id = $this->functions->insertData('mt_booking_slots', $params);
      }




        if ($parent_id !== false) {
            $saved++;

            // Generate 30-min interval slots from both shifts
            $slots = $this->functions->generateTimeSlots($params['shift1_start'], $params['shift1_end']);
            $slots2 = $this->functions->generateTimeSlots($params['shift2_start'], $params['shift2_end']);

            $all_slots = array_unique(array_merge($slots, $slots2), SORT_REGULAR);

            $date1=$date[$i];

             /*$localDateTimeStr = "$date[$i]"; // e.g., 2025-08-08 13:00:00


            $timezone=$this->functions->getOptionAdmin("website_timezone");
      $localDateTime = new DateTime($localDateTimeStr, new DateTimeZone($timezone));

// Convert to UTC
$localDateTime->setTimezone(new DateTimeZone('UTC'));
$utcFormatted = $localDateTime->format('Y-m-d H:i:s'); // ← this is the correct UTC value to store
      
      $utcFormatted=strtotime($localDateTimeStr);*/


            foreach ($all_slots as $slot) {

              $localDateTimeStr = "$date1 $slot[0]"; // e.g., 2025-08-08 13:00:00
      $localDateTime = new DateTime($localDateTimeStr, new DateTimeZone('Pacific/Auckland'));

// Convert to UTC
$localDateTime->setTimezone(new DateTimeZone('UTC'));
$utcFormatted = $localDateTime->format('Y-m-d H:i:s'); // ← this is the correct UTC value to store
      
      $utcFormatted=strtotime($localDateTimeStr);


        for ($ii = 1; $ii <= $party_size; $ii++) {

               
                if($available_count>0){
                $child_params = [
                    'parent_id'     => $parent_id,
                    'merchant_id'   => $merchant_id,
                    'slot_starts'   => $slot[0],
                    'slot_ends'     => $slot[1],
                    'person_per_party'  => $ii,
                    'date_created'  => $date_now,
                    'no_of_slots'   => $slots_count,
                    'available_slots'   => $available_count,
                    'date'              => $date1,
                    'utc_times'                 =>$utcFormatted,
                ];

                

                $this->functions->insertData('mt_booking_slots_child', $child_params);
                }

        
        
        
        }
        
        
            }
        }
    }

    if ($saved > 0) {
      $this->functions->updateOptionAdmin('feed_upload', 1);
        $this->code = 1;
        $this->msg = $this->functions->translation("default", "$saved day(s) booking slots saved.");
    } else {
        $this->msg = $this->functions->translation("default", "No data was saved.");
    }
}


public function add_bookingslots_single()
{
    $merchant_id = $this->functions->getMerchantID();
    $date_now = $this->functions->dateNow();

    $enabled = isset($this->data['enabled']) ? $this->data['enabled'] : [];
    $original_day_enabled = isset($this->data['original_day_enabled']) ? $this->data['original_day_enabled'] : [];
    $day_name = isset($this->data['day_name']) ? $this->data['day_name'] : [];
    $date = isset($this->data['date']) ? $this->data['date'] : [];
    $shift1_start = isset($this->data['shift1_start']) ? $this->data['shift1_start'] : [];
    $shift1_end = isset($this->data['shift1_end']) ? $this->data['shift1_end'] : [];
    $shift2_start = isset($this->data['shift2_start']) ? $this->data['shift2_start'] : [];
    $shift2_end = isset($this->data['shift2_end']) ? $this->data['shift2_end'] : [];
    $person_per_party = isset($this->data['person_per_party']) ? $this->data['person_per_party'] : [];
    $no_of_slots = isset($this->data['no_of_slots']) ? $this->data['no_of_slots'] : [];
    $m_holiday=$this->functions->getMerchantHoliday($merchant_id);
    $m_holiday = !empty($m_holiday) ? $m_holiday : [];

    

    // First pass: validate required shift1 fields for enabled rows
   /* for ($i = 0; $i < 7; $i++) {
        if (isset($enabled[$i]) && $enabled[$i] == 1) {
            $start = trim($shift1_start[$i] ?? '');
            $end = trim($shift1_end[$i] ?? '');

            if (empty($start) || empty($end)) {
                $this->msg = "ERROR: Shift 1 start and end time are required for enabled row " . ($i + 1) . ".";
                return;
            }
        }
    }*/
//print_r($date);die();
    $saved = 0;

    for ($i = 0; $i < 7; $i++) {
        if (!isset($date[$i])) continue;

        // Skip rows that are not enabled
        if (!isset($enabled[$i]) || $enabled[$i] != 1) {

            if($original_day_enabled[$i]==0){

            continue;
            }
        }

        // Default to 1 if value is 0 or empty
        $party_size = isset($person_per_party[$i]) && (int)$person_per_party[$i] > 0 ? (int)$person_per_party[$i] : 1;



        $slots_count = isset($no_of_slots[$i]) && (int)$no_of_slots[$i] > 0 ? (int)$no_of_slots[$i] : 1;

        if (in_array($date[$i], $m_holiday)) {
            $available_count = 0;
            $enabled[$i]=0;
        }else{
          $available_count = $slots_count;
        }

        $chk_duplicate_slots=$this->functions->chk_slots_duplication($merchant_id,$date[$i]);

        if($chk_duplicate_slots>0){
          $this->msg = "Slots already added for this date";
          return;
        }


        if (!isset($enabled[$i]) || $enabled[$i] != 1) {
           $available_count = 0;
          }else{
          $available_count = $slots_count;
          }


       if($available_count>0){

        $params = [
            'merchant_id'       => $merchant_id,
            'date_created'      => $date_now,
            'date'              => $date[$i],
            'enabled'           => 1,
            'shift1_start'      => $shift1_start[$i] ?? '',
            'shift1_end'        => $shift1_end[$i] ?? '',
            'shift2_start'      => $shift2_start[$i] ?? '',
            'shift2_end'        => $shift2_end[$i] ?? '',
            'person_per_party'  => $party_size,
            'no_of_slots'       => $slots_count,
            'used_slots'        => 0,
        ];

        // Insert into mt_booking_slots (parent)
        $parent_id = $this->functions->insertData('mt_booking_slots', $params);
      }




        if ($parent_id !== false) {
            $saved++;

            // Generate 30-min interval slots from both shifts
            $slots = $this->functions->generateTimeSlots($params['shift1_start'], $params['shift1_end']);
            $slots2 = $this->functions->generateTimeSlots($params['shift2_start'], $params['shift2_end']);

            $all_slots = array_unique(array_merge($slots, $slots2), SORT_REGULAR);

            $date1=$date[$i];

             /*$localDateTimeStr = "$date[$i]"; // e.g., 2025-08-08 13:00:00


            $timezone=$this->functions->getOptionAdmin("website_timezone");
      $localDateTime = new DateTime($localDateTimeStr, new DateTimeZone($timezone));

// Convert to UTC
$localDateTime->setTimezone(new DateTimeZone('UTC'));
$utcFormatted = $localDateTime->format('Y-m-d H:i:s'); // ← this is the correct UTC value to store
      
      $utcFormatted=strtotime($localDateTimeStr);*/


            foreach ($all_slots as $slot) {

              $localDateTimeStr = "$date1 $slot[0]"; // e.g., 2025-08-08 13:00:00
      $localDateTime = new DateTime($localDateTimeStr, new DateTimeZone('Pacific/Auckland'));

// Convert to UTC
$localDateTime->setTimezone(new DateTimeZone('UTC'));
$utcFormatted = $localDateTime->format('Y-m-d H:i:s'); // ← this is the correct UTC value to store
      
      $utcFormatted=strtotime($localDateTimeStr);


        for ($ii = 1; $ii <= $party_size; $ii++) {

               
                if($available_count>0){
                $child_params = [
                    'parent_id'     => $parent_id,
                    'merchant_id'   => $merchant_id,
                    'slot_starts'   => $slot[0],
                    'slot_ends'     => $slot[1],
                    'person_per_party'  => $ii,
                    'date_created'  => $date_now,
                    'no_of_slots'   => $slots_count,
                    'available_slots'   => $available_count,
                    'date'              => $date1,
                    'utc_times'                 =>$utcFormatted,
                ];

                

                $this->functions->insertData('mt_booking_slots_child', $child_params);
                }

        
        
        
        }
        
        
            }
        }
    }

    if ($saved > 0) {
      $this->functions->updateOptionAdmin('feed_upload', 1);
        $this->code = 1;
        $this->msg = $this->functions->translation("default", "$saved day(s) booking slots saved.");
    } else {
        $this->msg = $this->functions->translation("default", "No data was saved.");
    }
}



public function update_booking_slot()
{
    $merchant_id = $this->functions->getMerchantID();
    $date_now = $this->functions->dateNow();

    $id = isset($this->data['id']) ? (int)$this->data['id'] : 0;
    if ($id <= 0) {
        $this->msg = "Invalid booking slot ID.";
        return;
    }

    // Fix: Get single values from array inputs (in case of [0] => value)
    $date          = is_array($this->data['date']) ? $this->data['date'][0] : ($this->data['date'] ?? '');
    $shift1_start  = is_array($this->data['shift1_start']) ? $this->data['shift1_start'][0] : ($this->data['shift1_start'] ?? '');
    $shift1_end    = is_array($this->data['shift1_end']) ? $this->data['shift1_end'][0] : ($this->data['shift1_end'] ?? '');
    $shift2_start  = is_array($this->data['shift2_start']) ? $this->data['shift2_start'][0] : ($this->data['shift2_start'] ?? '');
    $shift2_end    = is_array($this->data['shift2_end']) ? $this->data['shift2_end'][0] : ($this->data['shift2_end'] ?? '');

   $person_per_party = isset($this->data['person_per_party'][0]) ? max((int)$this->data['person_per_party'][0], 1) : 1;
   $no_of_slots = isset($this->data['no_of_slots'][0]) ? max((int)$this->data['no_of_slots'][0], 1) : 1;


    // Validate shift 1
    if (empty($shift1_start) || empty($shift1_end)) {
        $this->msg = "Shift 1 start and end time are required.";
        return;
    }

    // Prepare params
    $params = [
        'date'              => $date,
        'shift1_start'      => $shift1_start,
        'shift1_end'        => $shift1_end,
        'shift2_start'      => $shift2_start,
        'shift2_end'        => $shift2_end,
        'person_per_party'  => $person_per_party,
        'no_of_slots'       => $no_of_slots,
        'date_modified'     => $date_now,
    ];

    


    // Update parent record
    $update = $this->functions->updateData("mt_booking_slots", $params, 'id', $id);

    if ($update) {
        // Delete old children
        $deleteStmt = $this->db->prepare("DELETE FROM mt_booking_slots_child WHERE parent_id = :parent_id");
        $deleteStmt->bindParam(':parent_id', $id, PDO::PARAM_INT);
        $deleteStmt->execute();

        // Generate time slots
        $slots1 = $this->functions->generateTimeSlots($shift1_start, $shift1_end);
        $slots2 = $this->functions->generateTimeSlots($shift2_start, $shift2_end);
        $all_slots = array_unique(array_merge($slots1, $slots2), SORT_REGULAR);

        // Insert new children
        foreach ($all_slots as $slot) {
      
      
      $localDateTimeStr = "$date $slot[0]"; // e.g., 2025-08-08 13:00:00
      $localDateTime = new DateTime($localDateTimeStr, new DateTimeZone('Pacific/Auckland'));

// Convert to UTC
$localDateTime->setTimezone(new DateTimeZone('UTC'));
$utcFormatted = $localDateTime->format('Y-m-d H:i:s'); // ← this is the correct UTC value to store
      
      $utcFormatted=strtotime($localDateTimeStr);
            $child_params = [
                'parent_id'     => $id,
                'merchant_id'   => $merchant_id,
                'slot_starts'   => $slot[0],
                'slot_ends'     => $slot[1],
                'date_created'  => $date_now,
                'person_per_party'  => $person_per_party,
                'no_of_slots'       => $no_of_slots,
                'date'              => $date,
        'utc_times'                 =>$utcFormatted,
            ];
            $this->functions->insertData('mt_booking_slots_child', $child_params);
        }

        $this->code = 1;
        $this->msg = $this->functions->translation("default", "Booking slot updated successfully.");
    } else {
        $this->msg = $this->functions->translation("default", "Failed to update booking slot.");
    }
}
















        public function saveCategorySked()
    {
        
        
        $mtid = $this->functions->getMerchantID();
        if($mtid<=0){
           $this->msg = ("ERROR: Your session has expired.");
           return ; 
        }
        
        $this->functions->updateOption("enabled_category_sked",
        isset($this->data['enabled_category_sked'])?$this->data['enabled_category_sked']:'',$mtid);         
        
        $this->functions->updateOption("enabled_category_sked_time",
        isset($this->data['enabled_category_sked_time'])?$this->data['enabled_category_sked_time']:'',$mtid);       
        
        
        
        $this->code = 1;
        $this->msg = ("Setting saved");
    }


    public function SizeList()
{
    $aColumns = array('size_id', 'size_name', 'date_created');
    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    // Assuming ajaxDataTables() generates SQL parts
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
        $sWhere = str_replace("WHERE", "AND", $sWhere);
    }

    $slug = $this->data['slug'];
    $merchantID = $this->functions->getMerchantID();

    $pdo = $this->db; // Use $this->db for PDO connection

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS * FROM
    mt_size
    WHERE           
    merchant_id = :merchantID
    $sWhere
    $sOrder
    $sLimit
    ";

    $query = $pdo->prepare($stmt);
    $query->bindParam(':merchantID', $merchantID, PDO::PARAM_INT);
    $query->execute();
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {

        $iTotalRecords = 0;
        $stmt2 = "SELECT FOUND_ROWS()";
        $query2 = $pdo->query($stmt2);
        $res2 = $query2->fetch(PDO::FETCH_ASSOC);
        $iTotalRecords = $res2['FOUND_ROWS()'];

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($rows as $val) {
            $val['subcat_id'] = isset($val['subcat_id']) ? $val['subcat_id'] : '';
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"{$val['subcat_id']}\" class=\"chk_child\" >";
            $option = "<div class=\"options\">
            <a href=\"$slug/id/{$val['size_id']}\" >" . $this->functions->translation("default", "Edit") . "</a>
            <a href=\"javascript:;\" class=\"delete_item\" data-id=\"{$val['size_id']}\" >" . $this->functions->translation("default", "Delete") . "</a>
            </div>";

            //$date = $this->functions->FormatDateTime($val['date_created']);

            $date = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);

            $feed_data['aaData'][] = array(
                $chk, $val['size_name'] . $option,
                $date
            );
        }
        $this->otableOutput($feed_data);
    }
    $this->otableNodata();
}






  public function TagsList()
{
    $stmt = $this->db->prepare("SELECT * FROM mt_tags ORDER BY date_created DESC");
    $stmt->execute();
    
    if ($res = $stmt->fetchAll(PDO::FETCH_ASSOC)) {
        $feed_data = [];

        foreach ($res as $val) {
            //$val = $this->functions->stripSlashes($val);

            $link="tags_add/id/".$val['tag_id'];

            $action = "<div class=\"options\">
              <a href=\"$link\" >" . $this->functions->translation("default", "Edit") . "</a>
              <a href=\"javascript:;\" class=\"row_del\" rev=\"" . $val['tag_id'] . "\" >" . $this->functions->translation("default", "Delete") . "</a>
              </div>";

            $feed_data['aaData'][] = [
                $val['tag_id'],
                $val['tag_name'] . $action,
                $val['description'],
                $val['slug'],
                $this->functions->FormatDateTime($val['date_created'])
            ];
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


  public function addTag()
  {
    $tag_id = isset($this->data['tag_id'])?(integer)$this->data['tag_id']:0;
    $params = array(
      'tag_name'=>isset($this->data['tag_name'])?$this->data['tag_name']:'',
      'description'=>isset($this->data['description'])?$this->data['description']:'',
      'date_created'=>$this->functions->dateNow(),
      'ip_address'=>$_SERVER['REMOTE_ADDR']
    );
    
    if (isset($this->data['tag_name_trans'])){
      if ($this->functions->okToDecode()){
        $params['tag_name_trans']=json_encode($this->data['tag_name_trans'],
        JSON_UNESCAPED_UNICODE);
      } else $params['tag_name_trans']=json_encode($this->data['tag_name_trans']);
    }
    
    if (isset($this->data['description_trans'])){
      if ($this->functions->okToDecode()){
        $params['description_trans']=json_encode($this->data['description_trans'],
        JSON_UNESCAPED_UNICODE);
      } else $params['description_trans']=json_encode($this->data['description_trans']);
    }
        
    if($tag_id>0){
      if(!empty($params['tag_name'])){
       // $params['slug'] = $this->functions->createSlug('tags',$params['tag_name'],'tag_id',$tag_id);
      }  

      $up =$this->functions->updateData('mt_tags' , $params ,'tag_id',$tag_id);  


      /*$up =Yii::app()->db->createCommand()->update("{{tags}}",$params,
          'tag_id=:tag_id',
            array(
              ':tag_id'=>$tag_id
            )
          );*/
          $this->code = 1;
      $this->msg = $this->functions->translation("default","Successful");     
    } else {
      if(!empty($params['tag_name'])){
        //$params['slug'] = $this->functions->createSlug('tags',$params['tag_name']);
      } 

       $last_insert_id = $this->functions->insertData('mt_tags', $params);
      if ($last_insert_id!== false){
        $tag_id=$last_insert_id;
        $this->code = 1;
        $this->msg = $this->functions->translation("default","Successful");
       /* $this->details = array(
            'redirect'=>('/admin/tags')
          );*/
      } else $this->msg = $this->functions->translation("default","ERROR. cannot insert data.");
      }
    
  }




    public function addToCart()
        {                           
                            
            if(!isset($_SESSION['kr_item'])){
                $_SESSION['kr_item']=array();
            }
            
            
            if(isset($this->data['notes'])){
                $this->data['notes'] = ($this->data['notes']);
            }                       
            
            /*START VALIDATE IF PRICE IS HACK */
            $website_disabled_cart_validation = $this->functions->getOptionAdmin('website_disabled_cart_validation');
                        
            if ( $website_disabled_cart_validation!=2):
            
            
            $h_item_id = isset($this->data['item_id'])?(integer)$this->data['item_id']:'';
            $h_price = isset($this->data['price'])?$this->data['price']:'';
            $h_discount = isset($this->data['discount'])?$this->data['discount']:'';
                        
            if(!is_numeric($h_item_id)){
                $this->msg="Failed. item id is invalid";
                return ;
            }
                                        
            $original_price = 0;        
            if($food_info=$this->functions->getFoodItem($h_item_id)){              
                if ( $food_info['merchant_id']==$this->data['merchant_id']){
                    
                    $item_discount = $food_info['discount'];
                    $item_price = json_decode($food_info['price'],true);                                        
                    if(count($item_price)<=1 && is_numeric($h_price)){                      
                                                                                           
                        foreach ($item_price as $item_price_val) {                          
                            $original_price = $item_price_val;
                        }                                                                                               
                        if ( $food_info['two_flavors']==2){
                            //echo '2 flavor';
                        } else {
                            if ($original_price!=$h_price){
                               $this->msg="Failed. Price has been tampered";
                               return ;
                            }                       
                        }
                    } else {                        
                        //dump("WITH SIZE");                                                
                        if(is_numeric($h_price)){                           
                            $item_price_original = isset($item_price[0])?$item_price[0]:'';
                            if(is_numeric($item_price_original)){
                                if($h_price!=$item_price_original){
                                   $this->msg="Failed. Price has been tampered";
                                   return ;
                                }                           
                            }                       
                        } else {                                        
                            if(!isset($this->data['two_flavors'])){
                                $this->data['two_flavors']='';
                            }                   
                            if ($this->data['two_flavors']!=2){
                                if(!empty($h_price)){
                                   $h_price=explode("|",$h_price);
                                }                               
                                if(!is_array($h_price) && count($h_price)>=1){
                                    $this->msg="Failed. Price has been tampered";
                                    return ;
                                }                               
                                $h_size_id = isset($h_price[2])?$h_price[2]:'';
                                $h_price_added = isset($h_price[0])?$h_price[0]:'';
                                
                                $item_price_original = isset($item_price[$h_size_id])?$item_price[$h_size_id]:'';                               
                                                                                
                                if ( $item_price_original!=$h_price_added){
                                  $this->msg="Failed. Price has been tampered";
                                  return ;
                               }        
                           }                           
                       }
                       
                    }
                                        
                    /*CHECK DISCOUNT*/
                    /*dump("discount=>$item_discount");
                    dump("h_discount=>$h_discount");*/
                    
                    if($h_discount>0.001){
                      if ($h_discount!=$item_discount){
                         $this->msg="Failed. Discount has been tampered";
                         return ;
                      }                
                    } else {
                        if($item_discount>=0.001){
                            if ($h_discount!=$item_discount){
                               $this->msg="Failed. Discount has been tampered";
                               return ;
                            }                  
                        }
                    }               
                                        
                } else {
                    $this->msg="Failed. Food item id is belong to another merchant";
                    return ;
                }           
            } else {
                $this->msg="Failed. Food item id is tampered";
                return ;
            }       
                                    
            /*CHECK SUB ITEM PRICE*/
            //dump($this->data['sub_item']);
            if(isset($this->data['sub_item'])){
                if(is_array($this->data['sub_item']) && count($this->data['sub_item'])>=1){
                    foreach ($this->data['sub_item'] as $h_sub_item) {                  
                                                
                        if(is_array($h_sub_item) && count($h_sub_item)>=1){
                            foreach ($h_sub_item as $h_sub_item_val) {
                                $hh_sub_item=explode("|", $h_sub_item_val);                     
                                
                                if(is_array($hh_sub_item) && count($hh_sub_item)>=1){                                   
                                    $h_sub_item_id = isset($hh_sub_item[0])?$hh_sub_item[0]:'';
                                    $h_sub_item_price = isset($hh_sub_item[1])?$hh_sub_item[1]:'';
                                    /*dump("h_sub_item_id=>$h_sub_item_id");
                                    dump("h_sub_item_price=>$h_sub_item_price");*/
                                    if ( $sub_item_info = $this->functions->getAddonItem($h_sub_item_id)){                                                                      
                                        if($h_sub_item_price!=$sub_item_info['price']){
                                           $this->msg="Failed. addon item price is tampered";
                                           return;
                                        }                           
                                    } else {
                                        $this->msg="Failed. addon id is tampered";
                                        return ;
                                    }                                                           
                                } else {
                                   $this->msg="Failed. addon item price is tampered";
                                   return ;
                                }
                            }                           
                        }                       
                    }
                }
            }                   
            endif;
            /*END VALIDATE IF PRICE IS HACK */
            
            
            /*remove sub item with no values*/      
            $enabled_select_addon=TRUE; 
            if($enabled_select_addon==TRUE){
                if(isset($this->data['sub_item'])){
                    if(is_array($this->data['sub_item']) && count($this->data['sub_item'])>=1){
                        foreach ($this->data['sub_item'] as $key_subitem => $sub_item_val) {       
                            if (count($this->data['sub_item'][$key_subitem])<=1){
                                //if ($sub_item_val[0]=="0" || empty($sub_item_val[0])){
                                if(isset($sub_item_val[0])){
                                    if ($sub_item_val[0]=="0"){
                                        unset($this->data['sub_item'][$key_subitem]);
                                    }               
                                }
                            }
                        }
                    }       
                }
            }
            
            /*dump($this->data);
            die();  */
            
            /** two flavor pizza */
            if (!isset($this->data['two_flavors'])){
                $this->data['two_flavors']='';
            }
            
            if ( $this->data['two_flavors']==2){
                
                $merchant_two_flavor_option = $this->functions->getOption('merchant_two_flavor_option',$this->data['merchant_id']);
                
                $two_flavor_price='';
                if (is_array($this->data['sub_item']) && count($this->data['sub_item'])>=1){                    
                    $price=array();
                    foreach ($this->data['sub_item'] as $key=>$val) {                       
                        if(isset($val[0])){
                            $t=explode("|",$val[0]);                        
                            if ( $t[3]=="right" || $t[3]=="left"){
                               $price[$key]=$t[1];                      
                            }                   
                        }
                    }           
                                        
                    $highest_price = 0;
                                        
                    if($merchant_two_flavor_option==2){
                        if(is_array($price) && count($price)>=1){
                           $sum_up = 0;
                           foreach ($price as $price_val) {
                                $sum_up+=$price_val;
                           }    
                           if($sum_up>0){
                              $highest_price=$sum_up/2;
                           }
                        }
                    } else {                                        
                        $highest_price = max($price);                               
                        $highest_key = array_search($highest_price, $price);            
                    }
                                                                                                
                    $this->data['price']=$highest_price;                                            
                }           
            }       
            /** two flavor pizza */
                        
            //unset($_SESSION['kr_item']);
            $this->msg="Food Item added to cart";            
            if (isset($this->data['item_id'])){             
                $item=$this->data;
                //dump($item); die();
                
                /** check if item is taxable*/    
                if ( $food_info=$this->functions->getFoodItem($item['item_id'])){                  
                    $item['non_taxable']=$food_info['non_taxable'];
                }           
                
                unset($item['action']);
                if (is_numeric($this->data['row'])){
                    $row=$this->data['row']-1;
                    $_SESSION['kr_item'][$row]=$item;
                    $this->msg="Cart updated";
                } else {            
                    $addon_ids=array();                 
                    if (!isset($item['sub_item'])){
                        $item['sub_item']='';
                    }                   
                    if (is_array($item['sub_item']) && count($item['sub_item'])>=1){
                        foreach ($item['sub_item'] as $sub_item) {
                            foreach ($sub_item as $sub_item1) {
                                $t=explode("|",$sub_item1);
                                if(is_array($t) && count($t)>=1){
                                    $addon_ids[]=$t[0];
                                }
                            }
                        }
                    }                   
                    if (is_array($addon_ids) && count($addon_ids)>=1){
                        $item['addon_ids']=$addon_ids;      
                    }
                    
                    //dump($item);                  
                    //die();
                    
                    $found=false;     
                    $found_key='';              
                    if (!isset($_SESSION['kr_item'])){
                        //$_SESSION['kr_item']='';                      
                        $_SESSION['kr_item']=array();
                    }
                    if(is_array($_SESSION['kr_item']) && count($_SESSION['kr_item'])>=1){
                       $x=0;
                       foreach ($_SESSION['kr_item'] as $key=> $val) {                             
                           if ($val['item_id']==$item['item_id']){                                                    
                               $found_key=$key;     
                               
                               $notes=false;                                                           
                               if ( $item['notes']==$val['notes']){
                                  $notes=true;
                               }
                               
                               //dump($val);        
                               /** check cooking_ref*/
                               $cooking_ref=false;
                               if (!isset($val['cooking_ref'])){
                                   $val['cooking_ref']='';
                               }
                               if (!isset($item['cooking_ref'])){
                                   $item['cooking_ref']='';
                               }
                               
                               if ( $item['cooking_ref']==$val['cooking_ref']){
                                  $cooking_ref=true;
                               }               
                               
                               /*check size*/
                               $item_size=false;
                               if ($item['price']==$val['price']){
                                  $item_size=true;
                               }                           
                               
                               /** ingredients*/
                               $ingredients=false;
                               if (!isset($item['ingredients'])){
                                   $item['ingredients']='';
                               }
                               
                               if (!isset($val['ingredients'])){
                                  $val['ingredients']='';
                               }                                                               
                               if (is_array($item['ingredients']) && count( (array) $item['ingredients'])>=1){
                                   if ( count( (array) $val['ingredients']) >= count( (array) $item['ingredients']) ) {
                                       $compare=array_diff((array)$val['ingredients'],(array)$item['ingredients']);
                                       if (count($compare)<=0){                                       
                                          $ingredients=true;
                                       }                                   
                                   }                                   
                               } else {                                         
                                  if (!isset($val['ingredients'])){
                                     $val['ingredients']='';
                                  }                   
                                  $compare=array_diff((array)$val['ingredients'],(array)$item['ingredients']);
                                  if (count($compare)<=0){
                                      $ingredients=true;
                                   }
                               }                                                                                   
                               
                               /** addon */
                               if (!isset($item['addon_ids'])){
                                   $item['addon_ids']=''; 
                               }
                               if (!isset($val['addon_ids'])){
                                   $val['addon_ids']=''; 
                               }
                               
                               if (is_array($item['addon_ids']) && count($item['addon_ids'])>=1){    
                                   if ( count( (array) $val['addon_ids']) >= count( (array) $item['addon_ids']) ) {
                                       $compare=array_diff((array)$val['addon_ids'],(array)$item['addon_ids']);
                                       if (count($compare)<=0){     
                                          if($cooking_ref==TRUE && $ingredients==TRUE && $item_size==TRUE && $notes==TRUE ){
                                             $found=true;
                                             break;
                                          }
                                       }                                   
                                   }                                   
                               } else {                                
                                  if (!isset($val['addon_ids'])){
                                      $val['addon_ids']='';
                                  }       
                                  $compare=array_diff((array)$val['addon_ids'],(array)$item['addon_ids']);
                                  if (count($compare)<=0){
                                      if($cooking_ref==TRUE && $ingredients==TRUE && $item_size==TRUE && $notes==TRUE){
                                          $found=true;
                                          break;
                                      }
                                   }
                               }                           
                           }            
                                                   
                       }/* end foreach*/
                    }     
                                                            
                    /*if ( $found==false){
                        echo 'false';
                    } else echo "true=>$found_key";                        
                    die(); */ 
                    
                    //dump($item); die();
                    
                    /*inventory*/                   
                    $inv_cart=array();                  
                    if($this->functions->inventoryEnabled($this->data['merchant_id'])){
                                                          
                        //array_push($inv_cart,(array)$item);
                        $inv_cart = $_SESSION['kr_item'];                       
                                                
                        $current_item_id = isset($item['item_id'])?(integer)$item['item_id']:'';
                        $current_item_price = isset($item['price'])?$item['price']:'';      
                        $current_item_size = isset($item['with_size'])?(integer)$item['with_size']:0;
                        $current_item_size = $current_item_size==2?1:0;
                        $inv_qty = isset($item['qty'])?(integer)$item['qty']:0;                     
                        
                        if(is_array($inv_cart) && count($inv_cart)>=1){
                           foreach ($inv_cart as $inv_cartval) {                                                                   
                                if($current_item_id==$inv_cartval['item_id'] && trim($current_item_price) == trim($inv_cartval['price']) ){                                 
                                    $inv_qty+=$inv_cartval['qty'];
                                }
                            }   
                        }                               
                        
                        try {
                             $this->StocksWrapper->verifyStocks(
                               $inv_qty,
                               $this->data['merchant_id'],
                               $current_item_id,
                               $current_item_size,
                               $current_item_price
                             );
                         } catch (Exception $e) {
                             $this->msg = $e->getMessage();
                             return ;
                         }                      
                    }                   
                    
                    if ( $found==false){
                       $_SESSION['kr_item'][]=$item;
                    } else {        
                       $_SESSION['kr_item'][$found_key]['qty']+=$item['qty'];                                 
                    }                       
                }                           
                $this->code=1;              
            } else $this->msg=$this->functions->translation("default","Item id is required");      
        }


        public function viewBankInfo()
  {
    require_once dirname(__DIR__, 2) . '/models/bank-info.php';

    die();
  }





         public function loadItemCart()
        {                       
            // loadcart
            //dump($this->data);
            //dump($_SESSION['kr_item']);
            
            if (isset($this->data['merchant_id'])){             
                $current_merchant_id=$this->data['merchant_id'];        
                if (isset($_SESSION['kr_item'])) {      
                    if (is_array($_SESSION['kr_item']) && count($_SESSION['kr_item'])>=1){
                        foreach ($_SESSION['kr_item'] as $key=>$temp_item) {                        
                            if ( $temp_item['merchant_id']!=$current_merchant_id){
                                unset($_SESSION['kr_item'][$key]);
                            }                                           
                        }
                    }           
                }
            }       
                    
            /*tip amount*/
            if ( !isset($this->data['current_page'])){
                $this->data['current_page']='';
            }
            
            $mtid=isset($this->data['merchant_id'])?$this->data['merchant_id']:'';
                    
            if ( $this->data['current_page']!="menu"){              
                $tip_enabled = $this->functions->getOption('merchant_enabled_tip',$mtid);
                $default_tip = $this->functions->getOption('merchant_tip_default',$mtid);
                if ($tip_enabled==2){               
                    $this->data['tip_enabled']=$tip_enabled;        
                    $this->data['tip_percent']=$default_tip;
                                    
                    if (isset($this->data['cart_tip_percentage'])){                                     
                        if (strlen($this->data['cart_tip_percentage'])>=1){
                            $this->data['tip_percent'] = $this->data['cart_tip_percentage'];
                        }               
                    }
                }
            }
            
            /*MULTI CURRENCY*/
            $rates = array();
            $currency_use = isset($_SESSION['currency']) ? $_SESSION['currency'] : '';

            //if (Item_utility::MultiCurrencyEnabled()){
            if (1==2){
                //$rates = Multicurrency_finance::getExchangeRate( $currency_use );                               
            } else {
                $rates = $this->functions->defaultExchangeRate( $currency_use );
            } 
           // Price_Formatter::init( Yii::app()->session['currency'] );
                        
            $this->data = array_merge( (array) $this->data, (array) $rates);            
                            
            
            /*SERVICE FEE*/             
            if($service_resp = $this->functions->getServiceFee( isset($current_merchant_id)?$current_merchant_id:'' )){
                $this->data['service_fee'] = (float)$service_resp['service_fee'];
                $this->data['service_fee_applytax'] = $service_resp['service_fee_applytax'];                
            }                               
            
            $displayOrderHTML=$this->functions->displayOrderHTML($this->data, isset($_SESSION['kr_item'])?$_SESSION['kr_item']:'' );

            if($displayOrderHTML['code']==null){
            $this->code= 2;
            $this->msg= $this->functions->translation("default","No Item added yet!");
            $this->details=null; 
            }else{
            

             
            $this->code= $displayOrderHTML['code'];
            $this->msg= $displayOrderHTML['msg'];
            $this->details=$displayOrderHTML; 
            }

           
       
            //dump(Yii::app()->functions->details['raw']);
            //dump($this->details['html']);   
            
            /*SET ORDER SUB TOTAL*/
            unset($_SESSION['kmrs_subtotal']);
            $raw = $displayOrderHTML['raw'];
            if(isset($raw['total'])){
                if(isset($raw['total']['subtotal'])){
                   $_SESSION['kmrs_subtotal']=$raw['total']['subtotal'];
                }           
            }                               
                        
            /*ITEM TAXABLE CART*/            
            if(!empty($mtid)){
                $apply_tax=$this->functions->getOption('merchant_apply_tax',$mtid);
                $tax=$this->functions->getMerchantTax($mtid);
                if ( $apply_tax==1 && $tax>0){                  
                    /*$this->details['html']=Yii::app()->controller->renderPartial('/front/cart-with-tax',array(
                       'data'=>$this->details['raw'],
                       'tax'=>$tax,
                       'receipt'=>false,
                       'merchant_id'=>$mtid
                    ),true);*/
                 


                  

                    //++++cart-with-tax view
                    $data=$displayOrderHTML['raw'];
                    $tax=$tax;
                    $receipt=false;
                    $merchant_id=$mtid;
                    ob_start();
                    require __DIR__ . '/../../app/views/front/cart-with-tax.php';
                    $this->details['html'] = ob_get_clean();

                    //print_r($this->details['html']);die();

                    //----cart-with-tax-view




                }       
            }          
        }   


        public function clearCart()
    {
        unset($_SESSION['kr_item']);
        $this->code=1;
        $this->msg="OK";
    }



     public function deleteItem()
        {                                           
            if ( isset($_SESSION['kr_item'][$this->data['row']])){
                                
                //if (is_numeric($row_api_id)){
                if (isset($_SESSION['kr_item'][$this->data['row']]['row_api_id'])){
                    $row_api_id=$_SESSION['kr_item'][$this->data['row']]['row_api_id']; 

                    //$ApiFunctions=new ApiFunctions;
                   // $ApiFunctions->deleteItemFromCart($row_api_id);
                }           
                
               unset($_SESSION['kr_item'][$this->data['row']]);
            }
            $this->code=1;
            $this->msg="";
        }



         public function setDeliveryOptions()
        {


                                    
            /*Cannot do order again if previous order status is*/
            if ($this->functions->isClientLogin()){                
                try {                   
                    $client_id=$this->functions->getClientId();
                    $func=$this->CheckoutWrapper->verifyCanPlaceOrder( (integer) $client_id);
                                       
                } catch (Exception $e) {
                     $this->msg = $e->getMessage();

                     return ;
                }
            }
             
                    
            $merchantid=isset($this->data['merchant_id'])?(integer)$this->data['merchant_id']:0;
            $time_order_management = $this->functions->getOption('merchant_time_order_management',$merchantid);    


            if($time_order_management==1){
                try {           
                    
                    $deliverytime = isset($this->data['delivery_time'])?$this->data['delivery_time']:'';                
                    if(is_null($deliverytime) || $deliverytime=="null" || empty($deliverytime)){
                        $deliverytime =date("H:i");
                    }                   
                            
                    $this->CheckoutWrapper->verifyOrderTimeManagement(
                      $merchantid,
                      isset($this->data['delivery_type'])?$this->data['delivery_type']:'',
                      isset($this->data['delivery_date'])?$this->data['delivery_date']:'',
                      $deliverytime
                    );
                    
                } catch (Exception $e) {
                     $this->msg = $e->getMessage();
                     return ;
                }
            }   


                        
            
           /** check if time is non 24 hour format */       
           if ( $this->functions->getOptionAdmin('website_time_picker_format')=="12"){
               if ($this->data['delivery_time']=='null'){
                   $this->data['delivery_time']=date("G:i");                  
               } else {
                   if (!empty($this->data['delivery_time'])){
                      $this->data['delivery_time']=date("G:i", strtotime($this->data['delivery_time']));                  
                   }
               }
           } else {
               if ($this->data['delivery_time']=='null'){
                    $this->data['delivery_time']=date("G:i");
               }                
           }        
                   
                   
           /**check if customer chooose past time */
           if ( isset($this->data['delivery_time'])){
              if(!empty($this->data['delivery_time'])){
                 $time_1=date('Y-m-d g:i:s a');
                 $time_2=$this->data['delivery_date']." ".$this->data['delivery_time'];
                 $time_2=date("Y-m-d g:i:s a",strtotime($time_2));               
                 $time_diff=$this->functions->dateDifference($time_2,$time_1);             
                 //dump($time_diff);
                 if (is_array($time_diff) && count($time_diff)>=1){
                     if ( $time_diff['hours']>0){                       
                         $this->msg=$this->functions->translation("default","Sorry but you have selected time that already past");
                         return ;                       
                     }              
                     if ( $time_diff['minutes']>0){                     
                         $this->msg=$this->functions->translation("default","Sorry but you have selected time that already past");
                         return ;                       
                     }              
                 }            
              }        
           }               
           
           $_SESSION['kr_delivery_options']['delivery_type']=$this->data['delivery_type'];
           $_SESSION['kr_delivery_options']['delivery_date']=$this->data['delivery_date'];
           $_SESSION['kr_delivery_options']['delivery_time']=$this->data['delivery_time'];
           
           //Custom code 12 starts
           $_SESSION['kr_delivery_options']['car_no']=0;
           $_SESSION['kr_delivery_options']['noplate']='';
           $_SESSION['kr_delivery_options']['car_no']=$this->data['car_no'];
           $_SESSION['kr_delivery_options']['noplate']=$this->data['noplate'];
           //Custom code 12 ends
           
           $_SESSION['kr_delivery_options']['delivery_asap']=$this->data['delivery_asap']=="undefined"?"":1;     
           $_SESSION['kr_delivery_options']['opt_contact_delivery']=isset($this->data['opt_contact_delivery'])?(integer)$this->data['opt_contact_delivery']:0;
                  
           
           $time=isset($this->data['delivery_time'])?$this->data['delivery_time']:'';          
           $full_booking_time=$this->data['delivery_date']." ".$time;
           $full_booking_day=strtolower(date("D",strtotime($full_booking_time)));           
           $booking_time=date('h:i A',strtotime($full_booking_time));           
           if (empty($time)){
              $booking_time='';
           }        

           $merchant_id=isset($this->data['merchant_id'])?$this->data['merchant_id']:'';           
           if ( !$this->functions->isMerchantOpenTimes($merchant_id,$full_booking_day,$booking_time)){ 
                $date_close=date("F,d l Y h:ia",strtotime($full_booking_time));
                $date_close=$this->functions->translateDate($date_close);
                $this->msg=$this->functions->translation("default","Sorry but we are closed on")." ".$date_close;
                $this->msg.="<br/>";
                $this->msg.=$this->functions->translation("default","Please check merchant opening hours");
                return ;
            }                   
           
           /*CHECK IF DATE IS HOLIDAY*/     
           if(!empty($this->data['delivery_date'])){
               if ( $res_holiday =  $this->functions->getMerchantHoliday($merchant_id)){             
                  if (in_array($this->data['delivery_date'],$res_holiday)){


                     
                     

                     $this->msg=$this->functions->translation("default","were close on ".$this->data['delivery_date']);

                     
                     $close_msg=$this->functions->getOption('merchant_close_msg_holiday',$merchant_id);
                     if(!empty($close_msg)){

                       

                        $this->msg = $this->functions->translation("default",$close_msg." date".$this->data['delivery_date']
                        );

                     }            
                     return ;
                  }
               }    
           }       
                   
           $this->code=1;$this->msg=$this->functions->translation("default","OK");   
           $this->details=Config::$baseUrl."/checkout";
           
        }







public function AllOrders()
{
    // Check if admin is logged in
    if (!$this->functions->isAdminLogin()) {
        echo "admin is not login";
        die();
    }
    
    // Define columns for the query
    $aColumns = array(
        'order_id', 'a.merchant_id', 'c.first_name',
        'json_details', 'trans_type', 'payment_type',
        'sub_total', 'taxable_total', 'total_w_tax', 'a.status', 'request_from', 'a.date_created'
    );
    
    // Initialize query clauses
    $sWhere = ''; $sOrder = ''; $sLimit = '';
    
    // Get DataTables parameters
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t)) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    } 
    
    // Add filter for status
    if (!empty($sWhere)) {
        $sWhere .= " AND a.status NOT IN ('initial_order')";
    } else {
        $sWhere .= " WHERE a.status NOT IN ('initial_order') AND 1";
    }

    // Define any additional select clauses if needed
    $select = ''; // Add currency formatting or other select clauses if necessary

    // Prepare and execute the main query
    try {
        $stmt = $this->db->prepare("
            SELECT SQL_CALC_FOUND_ROWS 
            order_id, trans_type, payment_type, sub_total, taxable_total, total_w_tax, a.status, a.order_number, a.merchant_id,
            a.date_created, admin_viewed, request_from,a.is_retail,a.client_names,a.is_phone_order,
            b.restaurant_name,
            CONCAT(c.first_name, ' ', c.last_name) AS client_name,
            (
                SELECT CONCAT(first_name, ' ', last_name)
                FROM mt_order_delivery_address
                WHERE order_id = a.order_id
                LIMIT 0,1
            ) AS customer_name
            $select
            FROM mt_order a
            LEFT JOIN mt_merchant b ON a.merchant_id = b.merchant_id
            LEFT JOIN mt_client c ON a.client_id = c.client_id
            $sWhere
            $sOrder
            $sLimit
        ");
        $stmt->execute();
        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Fetch total number of records
        $stmt2 = $this->db->query("SELECT FOUND_ROWS()");
        $iTotalRecords = $stmt2->fetchColumn();

        // Prepare feed data
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        $action = '';  

      
       
        if($res) {
         
        }else{
          
          $this->otableNodata();
        }
             
        foreach ($res as $val) {

          if(!empty($val['customer_name']) && strlen($val['customer_name'])>1 ){          
          $val['client_name'] = $val['customer_name'];
        }


          $action='';
       if($val['request_from']=="pos"){}else{
        $action.="<a data-id=\"".$val['order_id']."\" class=\"edit-order\" href=\"javascript:\">".$this->functions->translation("default","Edit")."</a>";
       }
    $action.="<br/><a data-id=\"".$val['order_id']."\" class=\"view-receipt\" href=\"javascript:\">".$this->functions->translation("default","View")."</a>";
        
        $action.="<a data-id=\"".$val['order_id']."\" class=\"view-order-history\" href=\"javascript:\">".$this->functions->translation("default","History")."</a>";      
         
         $item=$this->functions->translateFoodItemByOrderId($val['order_id']);
          
           //print_r($item);die();

         $new='';
                if ($val['admin_viewed']<=0){
            $new=" <div class=\"uk-badge\">".$this->functions->translation("default","NEW")."</div>";
          }         
         
          if(isset($val['currency_format'])){
            $currency_format = explode("|",$val['currency_format']);              
            /*Price_Formatter::$number_format = array(
               'decimals'=>isset($currency_format[0])?$currency_format[0]:2, 
             'decimal_separator'=>isset($currency_format[1])?$currency_format[1]:'.',
             'thousand_separator'=>isset($currency_format[2])?$currency_format[2]:'',
             'position'=>isset($currency_format[3])?$currency_format[3]:'left',
             'spacer'=>Price_Formatter::getSpacer( isset($currency_format[3])?$currency_format[3]:'left' ),
             'currency_symbol'=>isset($currency_format[4])?$currency_format[4]:'',
            );*/
          } 
          
          /* custom code 3 starts*/
        //sop payment 
          if($val['is_sop']=='1' && $val['trans_type']=='pickup'){  
          $val['payment_type']='Swipe on Pickup'; 
        }
        /* custom code 3 ends */
              $order_number='-';
          if($val['request_from']=="webappv2" && $val['order_number']>0){ 
          $order_number=$val['merchant_id'].'-'.$val['order_number']; 
          }else if($val['request_from']=="pos" && $val['order_number']>0){  
          $order_number=$val['merchant_id'].'-'.$val['order_number']; 
          } 
          
          $order_number=$val['merchant_id'].'-'.$val['order_number']; 
      if(!empty($val['client_name']) && strlen($val['client_name'])>1 ){  
                $val['client_name'] = $val['client_name'];
             
            }else{
            $val['client_name'] ='Guest';
            
          }
          
          if($val['is_phone_order']==1){
            
            $val['client_name']=$val['client_names'];
            
          }
          

        if($val['is_phone_order']==1 && $val['trans_type']=='pickup'){
            $val['trans_type']='Phone Pickup';
            
          }else if($val['is_phone_order']==1 && $val['trans_type']=='delivery'){
            $val['trans_type']='Phone Delivery';
            
          }


        if($val['is_retail']==1){$val['trans_type']='Retail';}

        $val['payment_type']=$this->functions->payment_translations($val['trans_type'],$val['payment_type'],$val['is_sop']);
      
                
            
         $date_created=$this->functions->prettyDate($val['date_created']);
         $date_created.=" ".$this->functions->prettyTime($val['date_created']);
         $feed_data['aaData'][]=array(      
           $val['order_id'],$order_number,
           stripslashes($val['restaurant_name']).$new,
           $val['client_name'],
           $item,
           ($val['trans_type']),
           ($val['payment_type']),
           $this->functions->formatNumber($val['sub_total']),
           $this->functions->formatNumber($val['taxable_total']),
           $this->functions->formatNumber($val['total_w_tax']),
           "<span class=\"tag ".$val['status']."\">".($val['status'])."</span>"."<div>$action</div>",
           ($val['request_from']),
           $date_created
         );
        } 
        // Output the results
        $this->otableOutput($feed_data);  
    } catch (Exception $e) {
        // Handle any errors
        //echo "Error fetching orders: " . $e->getMessage();
        $this->otableNodata();
    }
}



    public function editOrder()
      {               
        
        if (isset($this->data['id'])){
           $params=array('viewed'=>2);
             $this->functions->updateData('mt_order' , $params ,'order_id',$this->data['id']);  
             //$this->updateData("{{order}}",$params,'order_id',$this->data['id']);
        }
        
        $status_list=$this->functions->orderStatusList();
        ?>
        <div class="view-receipt-pop">
         <h3><?php echo $this->functions->translation("default",'Change Order Status')?></h3>
         
         <?php if ( $res=$this->functions->getOrderInfo($this->data['id']) ):?>
            <form id="frm-pop" class="frm-pop uk-form uk-form-horizontal" method="POST" onsubmit="return false;">
            
            <?php 
            

            if ($this->data['currentController'] == "admin") {
            echo '<input type="hidden" id="action" name="action" value="updateOrderAdmin">';
            } else {
                echo '<input type="hidden" name="action" id="action" value="updateOrder">';
            }


            ?>
            <input type="hidden" name="order_id" value="<?php echo htmlspecialchars($this->data['id']); ?>">

            
          <div class="uk-form-row">
    <label class="uk-form-label"><?php echo htmlspecialchars($this->functions->translation("default", 'Status')); ?></label>
    <select name="status" class="uk-form-width-large">
        <?php foreach ($status_list as $value => $label): ?>
            <option value="<?php echo htmlspecialchars($value); ?>" <?php echo $res['status'] == $value ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($label); ?>
            </option>
        <?php endforeach; ?>
    </select>
</div>

           
           
           <div class="uk-form-row">
          <label class="uk-form-label"><?php echo htmlspecialchars($this->functions->translation("default", 'Remarks')); ?></label>
          <textarea name="remarks" class="uk-form-width-large"></textarea>
          </div>

           
           <!--Driver-->
           <?php 
           /*Yii::app()->setImport(array(     
            'application.modules.driver.components.*',
           ));
           Driver::AdminStatusTpl();*/
           ?>          
           <!--Driver-->
           
           
           <div class="action-wrap">
              <button type="submit" class="uk-button uk-form-width-medium uk-button-success">
                  <?php echo htmlspecialchars($this->functions->translation("default", 'Submit')); ?>
              </button>
          </div>

           </form> 
         <?php else:?>
         <p class="uk-text-danger"><?php echo $this->functions->translation("default","Error: Order not found")?></p>
         <?php endif;?>
        </div> <!--view-receipt-pop-->                    
      <script type="text/javascript">
      $.validate({  
          form : '#frm-pop',    
          onError : function() {      
          },
          onSuccess : function() {     
            form_submit('frm-pop');
            return false;
          }  
      });   
      </script>
        <?php
        die();
      }


        public function editSlots()
      {               
        
        
        
        
        ?>
        <div class="view-receipt-pop">
         <h3><?php echo $this->functions->translation("default",'Change No of slots')?></h3>
         
         <?php if ( $res=$this->functions->getSlotInfo($this->data['id']) ):?>
            <form id="frm-pop" class="frm-pop uk-form uk-form-horizontal" method="POST" onsubmit="return false;">
            
            <?php 
            

            
                echo '<input type="hidden" name="action" id="action" value="updateslotsChild">';
            


            ?>
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($this->data['id']); ?>">

            
          <div class="uk-form-row">
    <label class="uk-form-label"><?php echo htmlspecialchars($this->functions->translation("default", 'No of Slots')); ?></label>
    <input 
        type="number" 
        name="no_of_slots" 
        id="no_of_slots" 
        class="uk-form-width-large" 
        value="<?php echo htmlspecialchars($res['no_of_slots']); ?>" 
        min="0" 
        step="1"
        required
    >
</div>


           
           
           

           
           <!--Driver-->
           <?php 
           /*Yii::app()->setImport(array(     
            'application.modules.driver.components.*',
           ));
           Driver::AdminStatusTpl();*/
           ?>          
           <!--Driver-->
           
           
           <div class="action-wrap">
              <button type="submit" class="uk-button uk-form-width-medium uk-button-success">
                  <?php echo htmlspecialchars($this->functions->translation("default", 'Submit')); ?>
              </button>
          </div>

           </form> 
         <?php else:?>
         <p class="uk-text-danger"><?php echo $this->functions->translation("default","Error: Order not found")?></p>
         <?php endif;?>
        </div> <!--view-receipt-pop-->                    
      <script type="text/javascript">
      $.validate({  
          form : '#frm-pop',    
          onError : function() {      
          },
          onSuccess : function() {     
            form_submit('frm-pop');
            return false;
          }  
      });   
      </script>
        <?php
        die();
      }


      public function editParty()
      {               
        
        
        
        
        ?>
        <div class="view-receipt-pop">
         <h3><?php echo $this->functions->translation("default",'Change Party size')?></h3>
         
         <?php if ( $res=$this->functions->getSlotInfo($this->data['id']) ):?>
            <form id="frm-pop" class="frm-pop uk-form uk-form-horizontal" method="POST" onsubmit="return false;">
            
            <?php 
            

            
                echo '<input type="hidden" name="action" id="action" value="updatepartyChild">';
            


            ?>
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($this->data['id']); ?>">

            
          <div class="uk-form-row">
    <label class="uk-form-label"><?php echo htmlspecialchars($this->functions->translation("default", 'Party size')); ?></label>
    <input 
        type="number" 
        name="person_per_party" 
        id="person_per_party" 
        class="uk-form-width-large" 
        value="<?php echo htmlspecialchars($res['person_per_party']); ?>" 
        min="0" 
        step="1"
        required
    >
</div>


           
           
           

           
           <!--Driver-->
           <?php 
           /*Yii::app()->setImport(array(     
            'application.modules.driver.components.*',
           ));
           Driver::AdminStatusTpl();*/
           ?>          
           <!--Driver-->
           
           
           <div class="action-wrap">
              <button type="submit" class="uk-button uk-form-width-medium uk-button-success">
                  <?php echo htmlspecialchars($this->functions->translation("default", 'Submit')); ?>
              </button>
          </div>

           </form> 
         <?php else:?>
         <p class="uk-text-danger"><?php echo $this->functions->translation("default","Error: Order not found")?></p>
         <?php endif;?>
        </div> <!--view-receipt-pop-->                    
      <script type="text/javascript">
      $.validate({  
          form : '#frm-pop',    
          onError : function() {      
          },
          onSuccess : function() {     
            form_submit('frm-pop');
            return false;
          }  
      });   
      </script>
        <?php
        die();
      }







public function editStocks_x()
{
    $item_id = isset($this->data['id']) ? (int)$this->data['id'] : 0;
    $mtid = $this->functions->getMerchantID();

    if ($item_id > 0) {
        if ($res = $this->ItemWrap->getItemSizePricesWithStocks($mtid, $item_id)) {
            ?>
            <div class="view-receipt-pop">
                <h3><?php echo $this->functions->translation("default", "Edit Item Stock") ?></h3>
                
                <form id="frm-stock" class="frm-pop uk-form uk-form-horizontal" method="POST" onsubmit="return false;">
                    <input type="hidden" name="action" value="updateStock">
                    <input type="hidden" name="item_id" value="<?php echo htmlspecialchars($item_id); ?>">

                    <table class="uk-table uk-table-hover uk-table-striped uk-table-condensed">
                        <thead>
                            <tr>
                                <th><?php echo $this->functions->translation("default", "Size"); ?></th>
                                <th><?php echo $this->functions->translation("default", "Price"); ?></th>
                                <th><?php echo $this->functions->translation("default", "Stock"); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($res as $val): ?>
                                <tr class="tr_item_size_list">
                                    <td><?php echo htmlspecialchars($val['size_name']); ?></td>
                                    <td>
                                        <input 
                                            style="width:50%;"
                                            type="text" 
                                            name="price[<?php echo $val['sku']; ?>]" 
                                            class="form-control numeric_only" 
                                            value="<?php echo htmlspecialchars($this->functions->normalPrettyPrice($val['price'])); ?>"
                                        >
                                    </td>
                                    <td>
                                        <input 
                                            style="width:50%;"
                                            type="text" 
                                            name="stock[<?php echo $val['sku']; ?>]" 
                                            class="form-control numeric_only" 
                                            value="<?php echo htmlspecialchars($this->InventoryWrapper->prettyQuantity($val['available_stocks'])); ?>"
                                        >
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <div class="action-wrap">
                        <button type="submit" class="uk-button uk-form-width-medium uk-button-success">
                            <?php echo $this->functions->translation("default", 'Submit'); ?>
                        </button>
                    </div>
                </form>
            </div> <!-- .view-receipt-pop -->

            <script type="text/javascript">
            $.validate({  
                form : '#frm-stock',    
                onError : function() {},  
                onSuccess : function() {     
                    form_submit('frm-stock');
                    return false;
                }  
            }); 
            </script>
            <?php
        } else {
            echo '<p class="uk-text-danger">' . $this->functions->translation("default", "No results found") . '</p>';
        }
    } else {
        echo '<p class="uk-text-danger">' . $this->functions->translation("default", "Invalid item ID") . '</p>';
    }
    die();
}


public function editStocks()
{
    $item_id = isset($this->data['id']) ? (int)$this->data['id'] : 0;
    $mtid = $this->functions->getMerchantID();

    $inventory_enabled = $this->functions->inventoryEnabled($mtid);
    $inventory_style = ($inventory_enabled == 1) ? '' : 'display:none;';

    if ($item_id > 0) {
        if ($res = $this->ItemWrap->getItemSizePricesWithStocks($mtid, $item_id)) {

            // Fetch item row to get dinein prices
            $stmt = $this->db->prepare("SELECT price_dinein FROM mt_item WHERE item_id = ? LIMIT 1");
            $stmt->execute([$item_id]);
            $item_row = $stmt->fetch(PDO::FETCH_ASSOC);
            $price_dinein = [];

            if ($item_row && !empty($item_row['price_dinein'])) {
                $price_dinein = json_decode($item_row['price_dinein'], true);
            }
            ?>
            <div class="view-receipt-pop">
                <h3><?php echo $this->functions->translation("default", "Edit Item") ?></h3>

                <form id="frm-pop" class="frm-pop uk-form uk-form-horizontal" method="POST" onsubmit="return false;">
                    <input type="hidden" name="action" id="action" value="updateStock">
                    <input type="hidden" name="item_id" id="item_id" value="<?php echo htmlspecialchars($item_id); ?>">

                    <table class="uk-table uk-table-hover uk-table-striped uk-table-condensed">
                        <thead>
                            <tr>
                                <th><?php echo $this->functions->translation("default", "Size"); ?></th>
                                <th><?php echo $this->functions->translation("default", "Takeaway"); ?></th>
                                <th><?php echo $this->functions->translation("default", "Dinein"); ?></th>
                                <th style="<?php echo $inventory_style ?>"><?php echo $this->functions->translation("default", "Stock"); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($res as $val): 
                                $size_id = (int)$val['size_id'];
                                $dinein_price_val = isset($price_dinein[$size_id]) ? $this->functions->normalPrettyPrice($price_dinein[$size_id]) : '';
                            ?>
                                <tr class="tr_item_size_list">
                                    <td><?php echo htmlspecialchars($val['size_name']); ?></td>
                                    <td>
                                        <input 
                                            style="width:50%;"
                                            type="text" 
                                            name="price[<?php echo $val['sku']; ?>]" 
                                            class="form-control numeric_only" 
                                            value="<?php echo htmlspecialchars($this->functions->normalPrettyPrice($val['price'])); ?>"
                                            data-sizeid="<?php echo $size_id; ?>"
                                        >
                                    </td>
                                    <td>
                                        <input 
                                            style="width:50%;"
                                            type="text" 
                                            name="dinein_price[<?php echo $val['sku']; ?>]" 
                                            class="form-control numeric_only" 
                                            value="<?php echo htmlspecialchars($dinein_price_val); ?>"
                                            data-sizeid="<?php echo $size_id; ?>"
                                        >
                                    </td>
                                    <td style="<?php echo $inventory_style ?>">
                                        <input 
                                            style="width:50%;"
                                            type="text" 
                                            name="stock[<?php echo $val['sku']; ?>]" 
                                            class="form-control numeric_only" 
                                            value="<?php echo htmlspecialchars($this->InventoryWrapper->prettyQuantity($val['available_stocks'])); ?>"
                                        >
                                    </td>

                                    <!-- Hidden fields for syncing -->
                                    <input type="hidden" name="size_price[<?php echo $size_id; ?>]" value="<?php echo htmlspecialchars($this->functions->normalPrettyPrice($val['price'])); ?>">
                                    <input type="hidden" name="dinein_size_price[<?php echo $size_id; ?>]" value="<?php echo htmlspecialchars($dinein_price_val); ?>">
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>

                    <div class="action-wrap">
                        <button type="submit" class="uk-button uk-form-width-medium uk-button-success">
                            <?php echo $this->functions->translation("default", 'Submit'); ?>
                        </button>
                    </div>
                </form>
            </div> <!-- .view-receipt-pop -->

<script type="text/javascript">
$(document).on('input', 'input[name^="price["]', function () {
    var sizeId = $(this).data('sizeid');
    var priceVal = $(this).val();
    $('input[name="size_price[' + sizeId + ']"]').val(priceVal);
});

$(document).on('input', 'input[name^="dinein_price["]', function () {
    var sizeId = $(this).data('sizeid');
    var priceVal = $(this).val();
    $('input[name="dinein_size_price[' + sizeId + ']"]').val(priceVal);
});

$.validate({  
    form : '#frm-pop',    
    onError : function() {},  
    onSuccess : function() {     
        form_submit('frm-pop');
        return false;
    }  
}); 
</script>
            <?php
        } else {
            echo '<p class="uk-text-danger">' . $this->functions->translation("default", "No results found") . '</p>';
        }
    } else {
        echo '<p class="uk-text-danger">' . $this->functions->translation("default", "Invalid item ID") . '</p>';
    }
    die();
}








      public function viewOrderHistory()
  {   
    ?>
    <div class="view-receipt-pop">
        <h3><?php echo $this->functions->translation("default",'History')?></h3>
      
        <?php if ( $resh=$this->functions->orderHistory($this->data['id'])):?>                    
               <table class="uk-table uk-table-hover">
                 <thead>
                   <tr>
                    <th class="uk-text-muted"><?php echo $this->functions->translation("default","Date/Time")?></th>
                    <th class="uk-text-muted"><?php echo $this->functions->translation("default","Status")?></th>
                    <th class="uk-text-muted"><?php echo $this->functions->translation("default","Remarks")?></th>
                   </tr>
                 </thead>
                 <tbody>
                   <?php foreach ($resh as $valh):?>                   
                   <?php 
               $remarks = $valh['remarks'];
               if(!empty($valh['remarks2']) && !empty($valh['remarks_args']) ){
                   $remarks_args = json_decode($valh['remarks_args'],true);                  
                   if(is_array($remarks_args) && count($remarks_args)>=1){
                      $new_arrgs = array();
                      foreach ($remarks_args as $remarks_args_key=>$remarks_args_val) {
                        $new_arrgs[$remarks_args_key]= $this->functions->translation("default",$remarks_args_val);
                      }                     
                      $remarks = $this->functions->translation("default",$valh['remarks2'],$new_arrgs);                 
                   }
               }
               ?>                                      
                   <tr style="font-size:12px;">
                     <td><?php                       
                      echo $this->functions->FormatDateTime($valh['date_created'],true);
                      ?></td>
                     <td><?php echo ($valh['status'])?></td>
                     <td><?php echo $remarks?></td>
                   </tr>
                   <?php endforeach;?>
                 </tbody>
               </table> 
          <?php else :?>                
            <p class="uk-text-danger order-order-history show-history-<?php echo $val['order_id']?>">
              <?php echo ("No history found")?>
            </p>
          <?php endif;?>   
         
      </div>
    <?php
    die();
  }


   public function viewReceipt()
      {       
        if (isset($this->data['backend'])){
          if ( $this->data['currentController']=="admin"){
            $params=array( 'admin_viewed'=>1 );           
          } else {
            $params=array('viewed'=>3);           
          }
          $this->functions->updateData('mt_order',$params,'order_id',$this->data['id']);
          //$this->updateData("{{order}}",$params,'order_id',$this->data['id']);

        }   

             

        require_once __DIR__ . '/../../models/view-receipt.php';     
        //require_once 'view-receipt.php';
        die();
      } 

      public function testEmail()
  {
    
    //require_once 'test-email.php';
    require_once __DIR__ . '/../../models/test-email.php';   
    die();
  }

    public function enterAddress()
        {
           //require_once "enter-address.php";
           require_once __DIR__ . '/../../models/enter-address.php'; 
        }

         public function viewFoodItem()
        {           
            if (isset($this->data['item_id'])){
                
                require_once __DIR__ . '/../../models/food-item.php'; 
            } else {
                ?>
                <p class="uk-alert uk-alert-danger"><?php echo $this->functions->translation("default","Sorry but we cannot find what you are looking for.")?></p>
                <?php
            }
            die();
        }   


  public function sendTestEmail()
  {   
    if (isset($this->data['email'])){
      $content="This is a test email";
      if ( $this->functions->sendEmail($this->data['email'],'',$content,$content)){
        $this->code=1;
        $this->msg=$this->functions->translation("default","Successful");
      } else $this->msg=$this->functions->translation("default","Sending of email has failed");   
    }  else $this->msg=$this->functions->translation("default","Email is required");
  }

  public function CountryList()
{
    $aColumns = array(
        'country_id', 'shortcode', 'country_name', 'phonecode', 'country_id'
    );
    
    $t = $this->functions->AjaxData($aColumns);
    
    if (isset($_GET['debug'])) {
        // dump($t);
    }
    
    $sWhere = $sOrder = $sLimit = '';
    
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }
    
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*   
        FROM mt_location_countries a
        WHERE 1 
        $sWhere
        $sOrder
        $sLimit
    ";
    
    if (isset($_GET['debug'])) {
        // dump($stmt);
    }

    $query = $this->db->prepare($stmt);
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        // Get total record count
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $queryc = $this->db->prepare($stmtc);
        $queryc->execute();
        $resc = $queryc->fetch(PDO::FETCH_ASSOC);
        
        $iTotalRecords = $resc ? $resc['total_records'] : 0;

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $link = Config::$baseUrl . "/admin/definelocation?countryid=" . $val['country_id'];
            $action = "<a href=\"$link\">" . $this->functions->translation("default", "Define location") . "</a>";

            $feed_data['aaData'][] = array(
                $val['country_id'],
                $val['shortcode'],
                $val['country_name'],
                $val['phonecode'],
                $action
            );
        }

        if (isset($_GET['debug'])) {
            // dump($feed_data);
        }

        $this->otableOutput($feed_data);
        return;
    }
    
    $this->otableNodata();
}





    public function getCartCount()
    {
        //$count=count($_SESSION['kr_item']);
        $count = 0;             
        if(is_array($_SESSION['kr_item']) && count( (array) $_SESSION['kr_item'])>=1){
           foreach ($_SESSION['kr_item'] as $val) {          
             $count+= $val['qty'];
           }
        }
        if($count>0){
            $this->code=1;
            $this->msg="OK";
            $this->details=$count;
        } else $this->msg="No item";
    }




    public function setAddress()
        {           
            if (isset($this->data['client_address'])){              
                $_SESSION['kr_search_address']=$this->data['client_address'];
                //$this->data['client_address']="6th road rawalpindi pakistan";
                if ($lat_res=$this->functions->geodecodeAddress($this->data['client_address'])){

                   

                    $_SESSION['client_location']=array(
                      'lat'=>$lat_res['lat'],
                      'long'=>$lat_res['long']
                    );
                }
                $this->code=1;$this->msg=$this->functions->translation("default","Successful");
            } else $this->msg=$this->functions->translation("default","Address is required");      
        }




      public function emailSettings()
    {
      if (!isset($this->data['email_provider'])){
        $this->msg=$this->functions->translation("default","please select email provider");
        return ;
      }   
      $this->functions->updateOptionAdmin("smtp_host",
        isset($this->data['smtp_host'])?$this->data['smtp_host']:'');
        
        $this->functions->updateOptionAdmin("smtp_port",
        isset($this->data['smtp_port'])?$this->data['smtp_port']:'');
        
        $this->functions->updateOptionAdmin("smtp_username",
        isset($this->data['smtp_username'])?$this->data['smtp_username']:'');
        
        $this->functions->updateOptionAdmin("smtp_password",
        isset($this->data['smtp_password'])?$this->data['smtp_password']:'');
        
        $this->functions->updateOptionAdmin("email_provider",
        isset($this->data['email_provider'])?$this->data['email_provider']:'');
        
        $this->functions->updateOptionAdmin("mandrill_api_key",
        isset($this->data['mandrill_api_key'])?$this->data['mandrill_api_key']:'');
        
        $this->functions->updateOptionAdmin("sendgrid_api_key",
        isset($this->data['sendgrid_api_key'])?trim($this->data['sendgrid_api_key']):'');
        
        $this->functions->updateOptionAdmin("mailjet_api_key",
        isset($this->data['mailjet_api_key'])?trim($this->data['mailjet_api_key']):'');
        
        $this->functions->updateOptionAdmin("mailjet_secret_key",
        isset($this->data['mailjet_secret_key'])?trim($this->data['mailjet_secret_key']):'');
        
        $this->functions->updateOptionAdmin("elastic_email_apikey",
        isset($this->data['elastic_email_apikey'])?trim($this->data['elastic_email_apikey']):'');
        
        $this->functions->updateOptionAdmin("global_admin_sender_email",
        isset($this->data['global_admin_sender_email'])?trim($this->data['global_admin_sender_email']):'');
        
        $this->functions->updateOptionAdmin("email_dsiabled_auto_break",
        isset($this->data['email_dsiabled_auto_break'])?trim($this->data['email_dsiabled_auto_break']):'');
        
        $this->functions->updateOptionAdmin("smtp_secure",
        isset($this->data['smtp_secure'])?trim($this->data['smtp_secure']):'');
        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Setting saved");     
    }



   public function rptMerchantPayment()
{
    // Columns for data tables
    $aColumns = array(
        'id', 'merchant_name', 'package_name', 'price', 'payment_type', 'status', 'date_created', 'id'
    );

    // Initialize query components
    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    // Handle filtering, ordering, and pagination via the dataTables helper function
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Initialize filters
    $params = [];
    $and = '';

    // Date range filter
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $and = " WHERE date_created BETWEEN :start_date AND :end_date";
            $params[':start_date'] = $this->data['start_date'] . " 00:00:00";
            $params[':end_date'] = $this->data['end_date'] . " 23:59:00";
        }
    }

    // Status filter
    if (isset($this->data['stats_id']) && is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
        $order_status_id = implode(',', array_map(function ($status) {
            return "'$status'";
        }, $this->data['stats_id']));

        if (!empty($order_status_id)) {
            $and .= empty($and) ? " WHERE status IN ($order_status_id)" : " AND status IN ($order_status_id)";
        }
    }

    // Build the SQL query
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*,
        (
            SELECT title 
            FROM mt_packages 
            WHERE package_id = a.package_id
        ) as package_name,
        (
            SELECT restaurant_name
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id
        ) as merchant_name
        FROM mt_package_trans a
        $and
        $sOrder
        $sLimit
    ";

      $pos = strpos($stmt,"LIMIT");
    if ($pos !== false) {
    // Store the substring up to the position of "LIMIT"
    $_SESSION['kr_export_stmt'] = substr($stmt, 0, $pos);
} else {
    // If "LIMIT" is not found, store the full statement
    $_SESSION['kr_export_stmt'] = $stmt;
}

    // Prepare and execute the query
    $pdo = $this->db; // Assuming $this->db is your PDO instance
    $query = $pdo->prepare($stmt);

    // Execute the query with parameters
    $query->execute($params);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // Handle the results
    if ($res) {
        // Get total records
        $iTotalRecords = $pdo->query("SELECT FOUND_ROWS()")->fetchColumn();

        // Prepare data for output
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            // Format the data
            $action = "<a data-id=\"{$val['id']}\" class=\"edit-payment\" href=\"javascript:\">" . $this->functions->translation("default", "Edit") . "</a>";
            $date = $this->functions->FormatDateTime($val['date_created']);

            $payment_type = $val['payment_type'] == "ocr" ?
                "<a href=\"javascript:;\" class=\"show-cc-details\" data-id=\"{$val['id']}\">" . strtoupper($val['payment_type']) . "</a>" :
                strtoupper($val['payment_type']);

            $feed_data['aaData'][] = array(
                $val['id'],
                $val['merchant_name'],
                $val['package_name'],
                $val['price'] >= 1 ? $this->functions->formatNumber($val['price']) : "",
                $payment_type,
                "<span class=\"{$val['status']}\">{$val['status']}</span>",
                $date,
                $action
            );
        }

        // Output the data (assumed to be JSON)
        $this->otableOutput($feed_data);
    } else {
        // If no data, handle it
        $this->otableNodata();
    }
}


public function rptAdminSalesRpt()
{
    $aColumns = array(
        'order_id', 'restaurant_name', 'client_name', 'contact_phone', 'order_id',
        'trans_type', 'order_id', 'sub_total', 'taxable_total', 'total_w_tax',
        'status', 'request_from', 'date_created'
    );          
    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';
    
    $t = $this->functions->ajaxDataTables($aColumns);   
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }   
    
    $and = '';  
    if (isset($this->data['start_date']) && !empty($this->data['start_date']) &&
        isset($this->data['end_date']) && !empty($this->data['end_date'])) {
        $start_date = $this->data['start_date'] . " 00:00:00";
        $end_date = $this->data['end_date'] . " 23:59:59";
        $and .= " AND a.date_created BETWEEN '$start_date' AND '$end_date' ";
    }

    $order_status_id = '';
    if (isset($this->data['stats_id']) && is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
        foreach ($this->data['stats_id'] as $stats_id) {                        
            // Add single quotes around each status value
            $order_status_id .= "'$stats_id',";
        }
        // Remove the trailing comma
        $order_status_id = rtrim($order_status_id, ',');
    }

    if (!empty($order_status_id)) {             
        // Use the status values in the SQL query
        $and .= " AND a.status IN ($order_status_id)";
    }
                 
    $merchant_id = isset($this->data['merchant_id']) ? $this->data['merchant_id'] : '';
    $where_merchant = '';
    if (!empty($merchant_id)) {
        $where_merchant = " AND a.merchant_id = '$merchant_id' ";
    }

    $select = '';
    
    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.*,
        concat(b.first_name,' ',b.last_name) as client_name,
        c.restaurant_name,
        d.contact_phone,
        concat(d.first_name,' ',d.last_name) as customer_name
        $select
        FROM mt_order a
        LEFT JOIN mt_client b ON a.client_id = b.client_id
        LEFT JOIN mt_merchant c ON a.merchant_id = c.merchant_id
        LEFT JOIN mt_order_delivery_address d ON a.order_id = d.order_id
        WHERE 1
        $where_merchant
        AND a.status NOT IN ('initial_order')
        $and
        $sOrder
        $sLimit";

    // Debugging: Uncomment the next line to see the final SQL statement
    // echo $stmt; die();

    // Store the SQL statement in the session before LIMIT
    $pos = strpos($stmt, "LIMIT");          
    $_SESSION['kr_export_stmt'] = substr($stmt, 0, $pos);               

    // Execute the statement directly
    $query = $this->db->query($stmt);

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $iTotalRecords = 0;
        $stmt2 = "SELECT FOUND_ROWS()";
        if ($res2 = $this->db->query($stmt2)->fetch()) {
            $iTotalRecords = $res2['FOUND_ROWS()'];
        }

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {                                    
            $action = "<a data-id=\"" . $val['order_id'] . "\" class=\"edit-order\" href=\"javascript:\">" . $this->functions->translation("default", "Edit") . "</a>";
            $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"view-receipt\" href=\"javascript:\">" . $this->functions->translation("default", "View") . "</a>";
            
            $date = $this->functions->FormatDateTime($val['date_created']);
            $item = $this->functions->translateFoodItemByOrderId($val['order_id']);

            // Custom code
            $tr_type = $this->functions->prettyPaymentType('payment_order', $val['payment_type'], $val['order_id'], $val['trans_type']);    
            if ($val['is_sop'] == '1' && $val['trans_type'] == 'pickup') {  
                $tr_type = 'Swipe on Pickup';   
            }

            if (!empty(trim($val['customer_name']))) {
                $val['client_name'] = $val['customer_name'];
            }

            if (isset($val['currency_format'])) {
                $currency_format = explode("|", $val['currency_format']);                       
            }

            $feed_data['aaData'][] = array(
                $val['order_id'],
                stripslashes($val['restaurant_name']),
                ucwords($val['client_name']),
                $val['contact_phone'],
                $item,
                $val['trans_type'],
                $tr_type,
                $this->functions->formatNumber($val['sub_total']),
                $this->functions->formatNumber($val['taxable_total']),
                $this->functions->formatNumber($val['total_w_tax']),
                "<span class=\"tag " . $val['status'] . "\">" . $val['status'] . "</span>",
                $val['request_from'],
                $date
            );
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}






public function rptMerchantSalesSummaryReport()
{
    $aColumns = array(
        'restaurant_name', 'total_sales', 'total_commission', 'total_earnings'
    );

    $sWhere = ''; $sOrder = ''; $sLimit = '';
    
    // Prepare DataTables parameters
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }
    
    unset($_SESSION['rpt_date_range']);

    $and = '';
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $start_date = $this->data['start_date'] . " 00:00:00";
            $end_date = $this->data['end_date'] . " 23:59:59";
            $and = " AND date_created BETWEEN '$start_date' AND '$end_date' ";
            $_SESSION['rpt_date_range'] = array(
                'start_date' => $this->data['start_date'],
                'end_date' => $this->data['end_date']
            );
        }
    }
    
    $order_status_id = '';
    if (isset($this->data['stats_id'])) {
        if (is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
            $order_status_id = implode(',', array_map(function($status_id) {
                return "'" . addslashes($status_id) . "'";
            }, $this->data['stats_id']));
        }
    }
    
    if (!empty($order_status_id)) {
        $and .= " AND status IN ($order_status_id) ";
    }
    
    $where = '';
    if (isset($this->data['merchant_id'])) {
        if (!empty($this->data['merchant_id'])) {
            $merchant_id = intval($this->data['merchant_id']); // Sanitize to int
            $where = " WHERE merchant_id = $merchant_id ";
        }
    }
    
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.restaurant_name,
        (
            SELECT SUM(total_w_tax) AS total
            FROM mt_order
            WHERE merchant_id = a.merchant_id
            $and
        ) AS total_sales,
        
        (
            SELECT SUM(total_commission)
            FROM mt_order
            WHERE merchant_id = a.merchant_id
            $and
        ) AS total_commission,
        
        (
            SELECT SUM(merchant_earnings)
            FROM mt_order
            WHERE merchant_id = a.merchant_id
            $and
        ) AS total_earnings
        
        FROM mt_merchant a
        $where
        $sOrder
        $sLimit
    ";

    $pos = strpos($stmt,"LIMIT");
    if ($pos !== false) {
        // Store the substring up to the position of "LIMIT"
        $_SESSION['kr_export_stmt'] = substr($stmt, 0, $pos);
    } else {
        // If "LIMIT" is not found, store the full statement
        $_SESSION['kr_export_stmt'] = $stmt;
    }

    // Execute the query directly
    $query = $this->db->query($stmt);
    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        $iTotalRecords = 0;
        $stmt2 = "SELECT FOUND_ROWS()";
        $res2 = $this->db->query($stmt2)->fetch(PDO::FETCH_ASSOC);
        if ($res2) {
            $iTotalRecords = (int)$res2['FOUND_ROWS()'];
        }

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($rows as $val) {
            $feed_data['aaData'][] = array(
                $this->functions->clearString($val['restaurant_name']),
                $this->functions->formatNumber($val['total_sales'] + 0),
                $this->functions->formatNumber($val['total_commission'] + 0),
                $this->functions->formatNumber($val['total_earnings'] + 0),
            );
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}





public function merchanBbookingSummaryReport()
{
    $aColumns = array(
        'merchant_name', 'total_approved', 'total_denied', 'total_pending'
    );

    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = ''; 

    $t = $this->functions->ajaxDataTables($aColumns);   
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    unset($_SESSION['rpt_date_range']);
    $and = '';  
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $and = " AND date_created BETWEEN '" . $this->data['start_date'] . " 00:00:00' AND '" . $this->data['end_date'] . " 23:59:59'";
            $_SESSION['rpt_date_range'] = array(
                'start_date' => $this->data['start_date'],
                'end_date' => $this->data['end_date']
            );
        }
    }

    $where = '';
    if (isset($this->data['merchant_id'])) {
        if (!empty($this->data['merchant_id'])) {
            $where = " WHERE merchant_id = " . intval($this->data['merchant_id']);
        }       
    }   

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.merchant_id, a.restaurant_name as merchant_name,
        
        (
            SELECT SUM(number_guest)
            FROM mt_bookingtable
            WHERE merchant_id = a.merchant_id  
            AND status = 'approved'   
            $and
        ) AS total_approved,

        (
            SELECT SUM(number_guest)
            FROM mt_bookingtable
            WHERE merchant_id = a.merchant_id  
            AND status = 'denied'     
            $and
        ) AS total_denied,

        (
            SELECT SUM(number_guest)
            FROM mt_bookingtable
            WHERE merchant_id = a.merchant_id       
            AND status = 'pending'
            $and
        ) AS total_pending

        FROM mt_merchant a
        $where
        GROUP BY merchant_id        
        $sOrder
        $sLimit
    ";      

    $pos = strpos($stmt,"LIMIT");
    if ($pos !== false) {
        // Store the substring up to the position of "LIMIT"
        $_SESSION['kr_export_stmt'] = substr($stmt, 0, $pos);
    } else {
        // If "LIMIT" is not found, store the full statement
        $_SESSION['kr_export_stmt'] = $stmt;
    }

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Execute the query
    $query->execute();

    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        // Get total records count
        $stmt2 = "SELECT FOUND_ROWS()";
        $query2 = $this->db->prepare($stmt2);
        $query2->execute();
        $iTotalRecords = $query2->fetchColumn();

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($rows as $val) {
            $feed_data['aaData'][] = array(
                ucwords(stripslashes($val['merchant_name'])),
                $val['total_approved'] + 0,
                $val['total_denied'] + 0,
                $val['total_pending'] + 0
            );                  
        }
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


public function activationMerchant()
{
    $merchant_status = $this->functions->getOptionAdmin("merchant_sigup_status");

    if (isset($this->data['activation_code']) && isset($this->data['token'])) {
        // Prepare the SQL query using a parameterized statement
        $stmt = $this->db->prepare("SELECT * FROM mt_merchant WHERE activation_token = :token LIMIT 1");
        $stmt->execute([':token' => $this->data['token']]);

        if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
            if ($res['status'] == "active") {
                $this->msg = $this->functions->translation("default", "Merchant is already activated.");
            } else {
                if ($res['activation_key'] == $this->data['activation_code']) {
                    $this->code = 1;
                    $this->msg = $this->functions->translation("default", "Merchant Successfully activated.");
                    $this->details = $this->data['token'];

                    $params = [
                        'status' => "active",
                        'date_activated' => $this->functions->dateNow(),
                        'ip_address' => $_SERVER['REMOTE_ADDR']
                    ];

                    // Check if payment was offline to avoid setting the status to active
                    $package_info = $this->functions->getMerchantPaymentMembership($res['merchant_id'], $res['package_id']);
                    $offline_payment = $this->functions->getOfflinePaymentList();

                    if (isset($offline_payment[$package_info['payment_type']])) {
                        unset($params['status']);
                    }

                    // Update merchant status
                    $update_stmt = $this->db->prepare("UPDATE mt_merchant SET status = :status, date_activated = :date_activated, ip_address = :ip_address WHERE merchant_id = :merchant_id");
                    $update_stmt->execute([
                        ':status' => $params['status'] ?? null,
                        ':date_activated' => $params['date_activated'],
                        ':ip_address' => $params['ip_address'],
                        ':merchant_id' => $res['merchant_id']
                    ]);

                    // Send welcome email
                    $this->functions->sendWelcomeEmailMerchant($this->functions->getMerchantInfo($res['merchant_id']), true);
                } else {
                    $this->msg = $this->functions->translation("default", "Invalid Activation code.");
                }
            }
        } else {
            $this->msg = $this->functions->translation("default", "Sorry but we cannot find your information.");
        }
    } else {
        $this->msg = $this->functions->translation("default", "ERROR: Missing parameters");
    }
}

 public function resendActivationCode()
{     
    // Prepare the SQL query using a parameterized statement
    $stmt = $this->db->prepare("SELECT * FROM mt_merchant WHERE activation_token = :token LIMIT 1");
    $stmt->execute([':token' => $this->data['token']]);

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {        
        // Send email activation key
        $this->functions->sendMerchantActivation($res, $res['activation_key']);
        $this->code = 1;
        $this->msg = $this->functions->translation("default", "We have sent the activation code to your email address.");
    } else {
        $this->msg = $this->functions->translation("default", "Token is invalid.");
    }
}






public function AdminUserList()
{
    // Construct the URL slug for actions
    $slug = Config::$baseUrl . "/admin/" . (isset($_GET['slug']) ? $_GET['slug'] : '');

    // Prepare the SQL statement
    $stmt = "
        SELECT * FROM mt_admin_user    
        ORDER BY admin_id ASC
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Execute the query
    $query->execute();

    // Fetch all results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // Prepare the output data
    $feed_data = ['aaData' => []];
    
    if (is_array($res) && count($res) >= 1) {
        foreach ($res as $val) {
            // Create action links
            $action = "<div class=\"options\">
                <a href=\"$slug/Do/Add/id/{$val['admin_id']}\" >" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['admin_id']}\" >" . $this->functions->translation("default", "Delete") . "</a>
            </div>";

            // Format the date
            $date = $this->functions->FormatDateTime($val['date_created']);

            // Add data to the feed
            $feed_data['aaData'][] = array(
                $val['admin_id'],
                $val['username'] . $action,
                $val['first_name'] . " " . $val['last_name'],
                $date
            );
        }
        // Output the data
        $this->otableOutput($feed_data);
    } else {
        // No data available
        $this->otableNodata();
    }
}


       public function updateslotsChild()
  {
      //dump($this->data);
         
      
      if (isset($this->data['id'])){
        $id=$this->data['id'];
        
        $params=array(
            'no_of_slots'=>$this->data['no_of_slots']
            
        );      


        if ($this->functions->updateData('mt_booking_slots_child',$params,'id',$id)){
          
          $this->code=1;
          $this->msg=$this->functions->translation("default","Slots updated.");
          
          /*Now we insert the order history*/         
        
    }
}


}

       public function updatepartyChild()
  {
      //dump($this->data);
         
      
      if (isset($this->data['id'])){
        $id=$this->data['id'];
        
        $params=array(
            'person_per_party'=>$this->data['person_per_party']
            
        );      


        if ($this->functions->updateData('mt_booking_slots_child',$params,'id',$id)){
          
          $this->code=1;
          $this->msg=$this->functions->translation("default","Party size updated.");
          
          /*Now we insert the order history*/         
        
    }
}


}













        public function updateOrderAdmin()
  {
      //dump($this->data);
         
      $date_now=date('Y-m-d');
      if (isset($this->data['order_id'])){
        $order_id=$this->data['order_id'];
        
        $params=array(
            'status'=>$this->data['status'],
            'date_modified'=>$this->functions->dateNow(),
            'admin_viewed'=>1
        );      


        if ($this->functions->updateData('mt_order',$params,'order_id',$order_id)){
          
          $this->code=1;
          $this->msg=$this->functions->translation("default","Status saved.");
          
          /*Now we insert the order history*/         
        $params_history=array(
          'order_id'=>$order_id,
          'status'=>$this->data['status'],
          'remarks'=>isset($this->data['remarks'])?$this->data['remarks']:'',
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );            
          
        /*inventory*/ 
        if($admin_info=$this->functions->getAdminInfo()){
          $new_fields=array('update_by_id'=>"update_by_id");
                    //if ( FunctionsV3::checkTableFields('order_history',$new_fields)){ 
            $params_history['update_by_id']= (integer) $admin_info->admin_id;
            $params_history['update_by_name']="$admin_info->first_name $admin_info->last_name";
                   // }
        }      

        $this->functions->insertData('mt_order_history', $params_history); 
        
                
        /*UPDATE REVIEWS BASED ON STATUS*/
        //if (method_exists('FunctionsV3','updateReviews')){
          $this->functions->updateReviews($order_id , $this->data['status']);
       // }
        
        /*SEND NOTIFICATIONS TO CUSTOMER*/              
         $this->functions->notifyCustomerOrderStatusChange(
          $order_id,
          $this->data['status'],
          isset($this->data['remarks'])?$this->data['remarks']:''
        );
          
       
        
        /*UPDATE POINTS BASED ON ORDER STATUS*/
         $this->PointsProgram->updateOrderBasedOnStatus($this->data['status'],$order_id);
         $this->PointsProgram->udapteReviews($order_id,$this->data['status']);


         /*INVENTORY ADDON*/        
        $stmt = "SELECT merchant_id, order_id FROM mt_order WHERE order_id = ? LIMIT 1";
$params = [$order_id];

$cmd = $this->db->prepare($stmt);
$cmd->execute($params);
$resp = $cmd->fetch(PDO::FETCH_ASSOC);

if ($resp) {
    if ($this->functions->inventoryEnabled($resp['merchant_id'])) {
      
        try {
            $this->InventoryWrapper->insertInventorySale($order_id, strtolower($this->data['status']));
        } catch (Exception $e) {
            // You can log or handle the exception if needed
        }
    }
}



          
        
        
        
          
        } else $this->msg=$this->functions->translation("default","ERROR: cannot update order.");        
      } else $this->msg=$this->functions->translation("default","Missing parameters");     
  }



        public function updateOrder()
        {           
                                    
            
            $merchant_id=$this->functions->getMerchantID();                    
                            
            $mt_timezone=$this->functions->getOption("merchant_timezone",$merchant_id);
           
            
            /*dump($this->data);
            die();*/
            /** check if merchant has initiate widthrawals*/
            //if ( Yii::app()->functions->isMerchantCommission($merchant_id)){              
            if ($this->functions->getMerchantMembershipType($merchant_id)){
                if ( $this->functions->validateChangeOrder($this->data['order_id'])){
                    $this->msg=("Sorry but you cannot change the order status of this order it has reference already on the withdrawals that you made");
                    return;
                }           
            }                   
                                
            $date_now=date('Y-m-d g:i:s a');
                        
            if (isset($this->data['order_id'])){
                $order_id=$this->data['order_id'];              
                if ( $resp=$this->functions->verifyOrderIdByOwner($order_id,$merchant_id) ){
                    $params=array('status'=>$this->data['status'],'date_modified'=>$this->functions->dateNow(),'viewed'=>2);     
                    
                    /*check if merchant can change the status*/
                    $can_edit = (integer) $this->functions->getOptionAdmin('merchant_days_can_edit_status');
                    $edit_times =  $this->functions->getOptionAdmin('merchant_time_can_edit_status');
                    
                    
                    if($can_edit>0 || !empty($edit_times)){
                                                
                        $base_option=$this->functions->getOptionAdmin('merchant_days_can_edit_status_basedon');                                               
                        if ( $base_option==2){                          
                            if(!empty($resp['delivery_time'])){
                               $date_created=date("Y-m-d g:i:s a",strtotime($resp['delivery_date']." ".$resp['delivery_time']));
                            } else $date_created=date("Y-m-d g:i:s a",strtotime($resp['delivery_date']." ".$resp['date_created']));
                        } else $date_created=date("Y-m-d g:i:s a",strtotime($resp['date_created']));                                                                                                    
                        $date_interval=$this->functions->dateDifference($date_created,$date_now);
                        
                        if (is_array($date_interval) && count($date_interval)>=1){                          
                            if ( $date_interval['days']>$can_edit){
                                $this->msg=("Sorry but you cannot change the order status anymore. Order is lock by the website admin");
                                $this->details=json_encode($date_interval);
                                return ;
                            }          
                            
                            $validate_time = false;
                            if(!empty($edit_times)){                            
                                $times = explode(":",$edit_times);                                                          
                                $hour = isset($times[0])?(integer)$times[0]:0;                          
                                $minute = isset($times[1])?(integer)$times[1]:0;                            
                                if($hour>0){
                                    if($date_interval['hours']>$hour){
                                        $validate_time=true;
                                    }                           
                                } else {                                
                                    if($date_interval['minutes']>$minute){
                                        $validate_time=true;
                                    }                           
                                }                       
                            }                                   
                            
                            if($validate_time){
                                $this->msg=("Sorry but you cannot change the order status anymore. Order is lock by the website admin");                           
                                return ;
                            }               
                                                        
                        }/* end if*/                    
                    }/* end if*/
                    
                    $mechant_sms_enabled= $this->functions->getOptionAdmin("mechant_sms_enabled");
                    
                    /*check if order has past for 2 days*/
                    $this->details['order_id']=$order_id;
                    $this->details['show_sms']=2;
                    $date_created=date("Y-m-d g:i:s a",strtotime($resp['date_created']));
                    $date_interval=$this->functions->dateDifference($date_created,$date_now);                  
                    if (is_array($date_interval) && count($date_interval)>=1){                      
                        if ( $date_interval['days']>2){
                            $this->details['show_sms']=1;
                        }
                    }
                    
                    if ( $mechant_sms_enabled=="yes"){
                        $this->details['show_sms']=1;
                    }               
                    
                    /**check if admin has disabled the sending of sms*/
                    if ($this->functions->getOptionAdmin('merchant_changeorder_sms')==2){
                        $this->details['show_sms']=1;
                    }
                                      
                    if ($this->functions->updateData('mt_order' , $params ,'order_id',$order_id) ){
                        $this->code=1;
                        $this->msg=$this->functions->translation("default","Status saved.");
                        
                        /*Now we insert the order history*/             
                        $params_history=array(
                          'order_id'=>$order_id,
                          'status'=>$this->data['status'],
                          'remarks'=>isset($this->data['remarks'])?$this->data['remarks']:'',
                          'date_created'=>$this->functions->dateNow(),
                          'ip_address'=>$_SERVER['REMOTE_ADDR']
                        );                      
                        if($merchant_info = $this->functions->getMerchantInfo()){
                            $merchant_info = $merchant_info[0];                         
                            $kr_merchant_user_type = $_SESSION['kr_merchant_user_type'];
                            
                            $new_fields=array('update_by_id'=>"update_by_id");
                            
                        }                                           
                       
                        $this->functions->insertData('mt_order_history', $params_history);
          

                        
                        /*UPDATE REVIEWS BASED ON STATUS*/
                        
                         $this->functions->updateReviews($order_id , $this->data['status']);
                                          
                        
                        /*SEND NOTIFICATIONS TO CUSTOMER*/                      
                        $this->functions->notifyCustomerOrderStatusChange(
                          $order_id,
                          $this->data['status'],
                          isset($this->data['remarks'])?$this->data['remarks']:''
                        );
                        
                        
                        
                        /*UPDATE POINTS BASED ON ORDER STATUS*/
                                                                              
                            
                               $this->PointsProgram->updateOrderBasedOnStatus($this->data['status'],$order_id);
                          
                            
                               $this->PointsProgram->udapteReviews($order_id,$this->data['status']);
                            


                        
                        
                        /*INVENTORY ADDON*/             
                        if ($this->functions->inventoryEnabled($merchant_id)){
                            try {                             
                               $this->InventoryWrapper->insertInventorySale($order_id,strtolower($this->data['status']));  
                            } catch (Exception $e) {                                            
                                                                   
                            }                                       
                        }
                        
                    } else $this->msg=$this->functions->translation("default","ERROR: cannot update order.");
                } else $this->msg=$this->functions->translation("default","This Order does not belong to you.");
            } else $this->msg=$this->functions->translation("default","Missing parameters");       
        }


        public function updateStock()
{
    $merchant_id = $this->functions->getMerchantID(); 
    $date_now = $this->functions->dateNow();

    $price_data = isset($this->data['price']) ? $this->data['price'] : [];
    $stock_data = isset($this->data['stock']) ? $this->data['stock'] : [];

    $price_for_itemtable = isset($this->data['size_price']) ? $this->data['size_price'] : [];
    $dinein_price_for_itemtable = isset($this->data['dinein_size_price']) ? $this->data['dinein_size_price'] : [];

    

    
   

    $item_id=$this->data['item_id'];

    $raw_data=$this->data;

    if (empty($price_data) && empty($stock_data)) {
        $this->msg = $this->functions->translation("default", "Missing data");
        return;
    }

    $updated_count = 0;

    foreach ($price_data as $sku => $price) {
        $price = (float)$price;
        $sku = trim($sku);

        if (!empty($sku)) {
            try {
                $this->ItemWrap->inlineUpdatePriceBySku($merchant_id, $sku, $price);
                $updated_count++;
            } catch (Exception $e) {
                // Optional: log error $e->getMessage()
                continue;
            }
        }
    }


    $params=array(            
              
              'price'=>isset($price_for_itemtable)?json_encode($price_for_itemtable):'',
              'price_dinein'=>isset($dinein_price_for_itemtable)?json_encode($dinein_price_for_itemtable):'',
              
            );  
             

    $this->functions->updateData("mt_item", $params, 'item_id', $item_id);
               

    foreach ($stock_data as $sku => $stock) {
        $stock = (float)$stock;
        $sku = trim($sku);

        if (!empty($sku)) {
            if ($item = $this->ItemWrap->getItemBySku($merchant_id, $sku)) {
                try {
                    $this->StocksWrapper->updateStocksEditItem(
                        $sku,
                        $item['cost_price'],
                        $stock,
                        $merchant_id,
                        isset($_SESSION['username']) ? $_SESSION['username'] : ''
                    );
                    $updated_count++;
                } catch (Exception $e) {
                    // Optional: log error $e->getMessage()
                    continue;
                }
            }
        }
    }

    if ($updated_count > 0) {
        $this->code = 1;
        $this->msg = $this->functions->translation("default", "Stock and price updated successfully.");
       
    } else {
        $this->msg = $this->functions->translation("default", "Stock and price updated successfully.");
    }
}















       public function promotionlist()
{
    $slug = $this->data['slug'];

    // Assuming $this->functions->getMerchantID() is already available
    $merchant_id = $this->functions->getMerchantID();

    // Prepare the query using PDO
    $stmt = "
        SELECT a.*, 
        (SELECT restaurant_name 
        FROM mt_merchant 
        WHERE merchant_id = a.merchant_id) AS merchant_name 
        FROM mt_promotions a 
        WHERE a.merchant_id = :merchant_id 
        ORDER BY id DESC";

    // Prepare the PDO connection and statement
    $connection = $this->db;  // Assuming $this->db is the PDO connection
    $query = $connection->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();

    $rows = $query->fetchAll(PDO::FETCH_ASSOC);

    if (is_array($rows) && count($rows) >= 1) {
        $feed_data = [];
        foreach ($rows as $val) {
            $chk = "<input type=\"checkbox\" name=\"row[]\" value=\"$val[id]\" class=\"chk_child\" >";
            $action = "<div class=\"options\">
                <a href=\"$slug/id/$val[id]\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"$val[id]\">" . $this->functions->translation("default", "Delete") . "</a>
            </div>";

            $date = $this->functions->FormatDateTime($val['date_created']);
            $item_names = '';

            // Handle item names if item_id is present
            if (!empty($val['item_id'])) {
                $category = json_decode($val['item_id']);
                if (is_array($category) && count($category) >= 1) {
                    foreach ($category as $cat_id) {
                        $datas = $this->functions->getFoodItem($cat_id);
                        $item_names .= $datas['item_name'] . ',';
                    }
                    $item_names = substr($item_names, 0, -1);  // Remove trailing comma
                }
            }

            // Build feed data for each promotion
            $feed_data['aaData'][] = array(
                $val['id'],
                $val['merchant_name'] . $action,
                $item_names,
                $this->functions->normalPrettyPrice($val['min_order']),
                $val['totals'],
                $this->functions->FormatDateTime($val['expiration'], false),
                "$date<br/><span class=\"tag " . $val['status'] . "\">" . ($val['status']) . "</span>"
            );
        }

        // Output the feed data (replace otableOutput with your custom output method)
       $this->otableOutput($feed_data);
    } else {
        // No data found (replace otableNodata with your custom no data output method)
        $this->otableNodata();  
    }
}



   public function OrderTimeManagmentList()
{
    // Assuming $this->db is your PDO instance


    $connection = $this->db;
    $merchantID = $this->functions->getMerchantID();
    
    // Prepare the SQL query
    $stmt = "
        SELECT id, group_id, transaction_type, start_time, end_time, number_order_allowed, order_status,
        GROUP_CONCAT(days) AS days
        FROM mt_order_time_management
        WHERE merchant_id = :merchant_id
        GROUP BY group_id
        ORDER BY id DESC
    ";

    // Prepare and execute the statement
    $query = $connection->prepare($stmt);
    $query->bindParam(':merchant_id', $merchantID, PDO::PARAM_INT);
    $query->execute();
    
    // Fetch all results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);
    
    $feed_data = array();
    
    foreach ($res as $val) {
        // Process order status
        $order_status_inline = '';
        $order_status = !empty($val['order_status']) ? json_decode($val['order_status'], true) : array();    
        if (is_array($order_status) && count($order_status) >= 1) {
            foreach ($order_status as $order_status_val) {
                $order_status_inline .= ($order_status_val) . ",\n";
            }
            $order_status_inline = rtrim($order_status_inline, ",\n");
        }
        
        // Process days
        $days_inline = '';
        $days = !empty($val['days']) ? explode(",", $val['days']) : array();    
        if (is_array($days) && count($days) >= 1) {
            foreach ($days as $days_val) {
                $days_inline .= ($days_val) . ",\n";
            }
            $days_inline = rtrim($days_inline, ",\n");
        }
        
        // Generate options
        $option = "<div class=\"options\">
            <a href=\"javascript:;\" class=\"add_time_management\" data-id=\"{$val['group_id']}\" >" . $this->functions->translation("default", "Edit") . "</a>
            <a href=\"javascript:;\" class=\"delete_item\" data-id=\"{$val['group_id']}\" >" . $this->functions->translation("default", "Delete") . "</a>
            </div>";
        
        // Append to feed data
        $feed_data['aaData'][] = array(
            $val['group_id'],
            $val['transaction_type'] . $option,
            $days_inline,
            $this->functions->prettyTime($val['start_time']),
            $this->functions->prettyTime($val['end_time']),
            $val['number_order_allowed'],
            $order_status_inline
        );
    }
    
    // Output the data
    if (!empty($feed_data['aaData'])) {
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}






  public function getAdminNewOrder()
  {
    $list='';
    if ( $res=$this->functions->getNewOrders('admin')){
      $this->code=1;
        $this->msg=count($res);  
        $order_list='';
        foreach ($res as $val) {            
          $order_list.="<div class=\"new-order-link\">";
          $order_list.="<a class=\"view-receipt\" data-id=\"$val[order_id]\" 
          href=\"javascript:;\">".$this->functions->translation('default',"Click here to view")." ". $this->functions->translation('default',"Reference #") .":". $val['order_id'] . "</a>";            
          $order_list.="<div>";
        }         
        $this->details=$order_list;
    } else $this->msg= $this->functions->translation('default',"No results");
  }


   public function getNewOrder()
      {
        $list='';

        /*$res=$this->functions->newOrderList(1);
        echo($res);die();*/

        if ($res=$this->functions->newOrderList(1)){ 

          

          $this->code=1;
          $this->msg=count($res);         
          //$this->details=$list;
          $order_list='';
          foreach ($res as $val) {            
            $order_list.="<div class=\"new-order-link\">";
            $order_list.="<a class=\"view-receipt\" data-id=\"$val[order_id]\" 
            href=\"javascript:;\">".("Click here to view")." ". ("Reference #") .":". $val['order_id'] . "</a>";            
            $order_list.="<div>";
          }         
          $this->details=$order_list;
        } else $this->msg=$this->functions->translation("default","No results");     
      }



    public function emailLogs()
{
    $aColumns = array(
        'id','email_address','sender','subject','content','email_provider','status','date_created'
    );
    
    $t = $this->functions->ajaxDataTables($aColumns); 
    if (isset($_GET['debug'])){
        dump($t);
    }
    
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    } else {
        $sWhere = '';
        $sOrder = '';
        $sLimit = '';
    }

    // ✅ Ensure "WHERE" clause syntax works with/without $sWhere
    if (trim($sWhere) === '') {
        $sWhere = "WHERE email_address <> ''";
    } else {
        $sWhere .= " AND email_address <> ''";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*        
        FROM mt_email_logs a
        $sWhere
        $sOrder
        $sLimit
    ";

    if (isset($_GET['debug1'])) {
        echo $stmt;die();
    }

    $stmtMain = $this->db->prepare($stmt);
    $stmtMain->execute();
    $res = $stmtMain->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $iTotalRecords = 0;

        $stmtCount = $this->db->prepare("SELECT FOUND_ROWS() as total_records");
        $stmtCount->execute();
        $resc = $stmtCount->fetch(PDO::FETCH_ASSOC);

        if ($resc) {
            $iTotalRecords = $resc['total_records'];
        }

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $date_created = $this->functions->prettyDate($val['date_created'], true);
            $date_created = $this->functions->translateDate($date_created);   
            
            $status = "<span class=\"tag ".$val['status']."\">".($val['status'])."</span>";
            $link = Config::$baseUrl."/admin/viewemail/id/".$val['id'];
            $action = "<a target=\"_blank\" href=\"$link\">View Content</a>";
                    
            $feed_data['aaData'][] = array(           
                $val['id'],
                $val['email_address'],
                $val['sender'],
                $val['subject'],
                $action,
                ($val['email_provider']),
                $status,
                $date_created,
            );          
        }

        if (isset($_GET['debug'])){
            dump($feed_data);
        }
        $this->otableOutput($feed_data);  
        return;
    }

    $this->otableNodata();
}

















      public function addpromotionNew()
  {         
     
    if ( empty($this->data['merchant_id'])){
          $this->msg=$this->functions->translation("default","Merchant ID is missing");
           return ;
        } 
      
    if ( empty($this->data['item_id'])){
          $this->msg=$this->functions->translation("default","Plesae Select Item");
            return ;
        }   
      
      if ($this->functions->getMerchantPromotionsByMinOrder($this->data['min_order'],$this->data['merchant_id'],$this->data['id'])){
        $this->msg=$this->functions->translation("default","Sorry but promotion already created with Min Order ".$this->data['min_order']);
        return;
      } 
    
    $params=array(
      'totals'=>$this->data['totals'],
      'expiration'=>$this->data['expiration'],
      'status'=>$this->data['status'],
      'date_created'=>$this->functions->dateNow(),
      'ip_address'=>$_SERVER['REMOTE_ADDR'],
      'merchant_id'=>$this->data['merchant_id'],
      'min_order'=>isset($this->data['min_order'])?(float)$this->data['min_order']:0
    );
    
    if (isset($this->data['item_id'])){
      $params['item_id']=json_encode($this->data['item_id']);
    } else $params['item_id']='';
    
    if (!empty($this->data['id'])){
      $params['date_modified']=$this->functions->dateNow();
      unset($params['date_created']);

      if ( $this->functions->updateData('mt_promotions' , $params ,'id',$this->data['id'])){
        $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");
      } else $this->msg=$this->functions->translation("default","Failed cannot update records");        
    } else {
          $last_insert_pro_id = $this->functions->insertData('mt_promotions', $params);
          if ($last_insert_pro_id!== false){
            $this->details=$last_insert_pro_id;
          $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");     
          } else $this->msg=$this->functions->translation("default","ERROR: Something went wrong");   
    }
  }


       public function saveBranch_bkedup()
  {         
     
    if ( empty($this->data['merchant_id'])){
          $this->msg=$this->functions->translation("default","Merchant ID is missing");
           return ;
        } 
      
     
      
      
    
    $params=array(
      'branch_name'=>$this->data['branch_name'],
      
      'date_created'=>$this->functions->dateNow()
    );
    
    if (isset($this->data['merchant_id'])){
      $params['merchant_id']=json_encode($this->data['merchant_id']);
    } else $params['merchant_id']='';
    
    if (!empty($this->data['id'])){
      

      if ( $this->functions->updateData('mt_branches' , $params ,'id',$this->data['id'])){
        $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");
      } else $this->msg=$this->functions->translation("default","Failed cannot update records");        
    } else {
          $last_insert_pro_id = $this->functions->insertData('mt_branches', $params);
          if ($last_insert_pro_id!== false){
            $this->details=$last_insert_pro_id;
          $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");     
          } else $this->msg=$this->functions->translation("default","ERROR: Something went wrong");   
    }
  }


public function saveBranch()
{
    if (empty($this->data['merchant_id'])) {
        $this->msg = $this->functions->translation("default", "Merchant ID is missing");
        return;
    }

    $params = array(
        'branch_name' => $this->data['branch_name'],
        'date_created' => $this->functions->dateNow()
    );

    if (isset($this->data['merchant_id'])) {
        $params['merchant_id'] = json_encode($this->data['merchant_id']);
    } else {
        $params['merchant_id'] = '';
    }

    if (!empty($this->data['id'])) {
        if ($this->functions->updateData('mt_branches', $params, 'id', $this->data['id'])) {
            $this->code = 1;
            $this->msg = $this->functions->translation("default", "Successful");

            // 🔁 Update mt_client branch fields if necessary
            $merchantIds = $this->data['merchant_id']; // assumed to be an array of integers

            if (is_array($merchantIds)) {
                foreach ($merchantIds as $merchantId) {
                    // Find clients that have this merchantId in their branch field
                    $stmt = $this->db->prepare("
                        SELECT client_id 
                        FROM mt_client 
                        WHERE social_strategy IN ('SingleMerchant', 'webappv2')
                        AND JSON_CONTAINS(branch, ?)
                    ");
                    $stmt->execute([json_encode((int)$merchantId)]);
                    $clients = $stmt->fetchAll(PDO::FETCH_ASSOC);

                    if (!empty($clients)) {
                        foreach ($clients as $client) {
                            $clientId = $client['client_id'];

                            // Get the client's own merchant_id
                            $clientMerchantStmt = $this->db->prepare("SELECT merchant_id FROM mt_client WHERE client_id = ?");
                            $clientMerchantStmt->execute([$clientId]);
                            $clientRow = $clientMerchantStmt->fetch(PDO::FETCH_ASSOC);

                            if ($clientRow) {
                                $clientMerchantId = (int)$clientRow['merchant_id'];
                                $postedMerchantIds = array_map('intval', $merchantIds);

                                // CASE 1: posted merchant list includes the client's merchant_id
                                if (in_array($clientMerchantId, $postedMerchantIds)) {
                                    // Ensure it’s included
                                    $finalMerchantIds = $postedMerchantIds;
                                    if (!in_array($clientMerchantId, $finalMerchantIds)) {
                                        $finalMerchantIds[] = $clientMerchantId;
                                    }
                                } 
                                // CASE 2: client’s merchant_id was excluded — assign only their own
                                else {
                                    $finalMerchantIds = [$clientMerchantId];
                                }

                                // Now update branch field
                                $updateStmt = $this->db->prepare("
                                    UPDATE mt_client 
                                    SET branch = :branch 
                                    WHERE client_id = :client_id
                                ");
                                $updateStmt->execute([
                                    ':branch'    => json_encode($finalMerchantIds),
                                    ':client_id' => $clientId
                                ]);
                            }
                        }
                    }
                }
            }
        } else {
            $this->msg = $this->functions->translation("default", "Failed cannot update records");
        }
    } else {
        $last_insert_pro_id = $this->functions->insertData('mt_branches', $params);
        if ($last_insert_pro_id !== false) {
            $this->details = $last_insert_pro_id;
            $this->code = 1;
            $this->msg = $this->functions->translation("default", "Successful");
        } else {
            $this->msg = $this->functions->translation("default", "ERROR: Something went wrong");
        }
    }
}







  public function singleMerchantBanner()
    {       
        if (  $this->functions->isMerchantLogin()){
           $merchant_id = (integer)$this->functions->getMerchantID();
           
           $this->functions->updateOption("singleapp_banner",
            isset($this->data['photo'])?json_encode($this->data['photo']):''
            ,$merchant_id);
            
            $this->functions->updateOption("singleapp_enabled_banner",
            isset($this->data['singleapp_enabled_banner'])?$this->data['singleapp_enabled_banner']:''
            ,$merchant_id);
            
            $this->functions->updateOption("singleapp_homebanner_interval",
            isset($this->data['singleapp_homebanner_interval'])?$this->data['singleapp_homebanner_interval']:''
            ,$merchant_id);
            
            $this->functions->updateOption("singleapp_homebanner_auto_scroll",
            isset($this->data['singleapp_homebanner_auto_scroll'])?$this->data['singleapp_homebanner_auto_scroll']:''
            ,$merchant_id);
            
            $this->code = 1;        
            $this->msg = "Successful";    
        } else $this->msg="ERROR: Your session has expired.";
    }



    public function singleMerchantAndroid()
    {
        if (  $this->functions->isMerchantLogin()){
           $merchant_id = (integer)$this->functions->getMerchantID();
                                
            $this->functions->updateOption("singleapp_enabled_pushpic",
            isset($this->data['singleapp_enabled_pushpic'])?$this->data['singleapp_enabled_pushpic']:''
            ,$merchant_id);
            
            $this->functions->updateOption("singleapp_push_icon",
            isset($this->data['photo'])?$this->data['photo']:''
            ,$merchant_id);
            
            $this->functions->updateOption("singleapp_push_picture",
            isset($this->data['photo2'])?$this->data['photo2']:''
            ,$merchant_id);
                        
            $this->code = 1;        
            $this->msg = "Successful";    
        } else $this->msg="ERROR: Your session has expired.";
    }






    public function packagesAdd()
      {               
         if (isset($this->data['unlimited_post'])){
             if ( $this->data['unlimited_post']==1){
                  if ($this->data['post_limit']<=0){
                    $this->msg=$this->functions->translation("default","Number of Food Item Can Add must be greate than 1");
                    return ;
                  }            
             }         
         }      
         
        
         
         $params=array(
           'title'=>($this->data['title']),
           'description'=>($this->data['description']),
           'price'=>($this->data['price']),
           'promo_price'=>($this->data['promo_price']),
           'expiration'=>$this->data['expiration'],
           'status'=>($this->data['status']),
           'date_created'=>$this->functions->dateNow(),
           'ip_address'=>$_SERVER['REMOTE_ADDR'],
           'expiration_type'=>$this->data['expiration_type'],
           'unlimited_post'=>$this->data['unlimited_post'],
           'post_limit'=>is_numeric($this->data['post_limit'])?$this->data['post_limit']:0,
           'sell_limit'=>is_numeric($this->data['sell_limit'])?$this->data['sell_limit']:0
         );     
         
         if(!is_numeric($params['promo_price'])){
           $params['promo_price']=0;
         }      
         
         if ( $this->data['expiration_type']=="year"){
             $params['expiration']=$this->data['expiration']*365;
         }      
         if (empty($this->data['id'])){ 

          $last_insert_package_id = $this->functions->insertData('mt_packages', $params);
          if ($last_insert_package_id!== false){
            $this->details=$last_insert_package_id;
            $this->code=1;
            $this->msg=$this->functions->translation("default","Successful");            
          }
        } else {          
          unset($params['date_created']);
        $params['date_modified']=$this->functions->dateNow();        
        

        $res =$this->functions->updateData('mt_packages' , $params ,'package_id',$this->data['id']);

        if ($res){
          $this->code=1;
                  $this->msg=$this->functions->translation("default",'Package updated.');  
        } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
        } 
      }





    public function packagesList() {
        $data = [];
        $slug = $this->data['slug'];

        // PDO query using the Model's database connection
        $stmt = $this->db->prepare("SELECT * FROM mt_packages ORDER BY package_id DESC");
        $stmt->execute();

        $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $ListlimitedPost = $this->functions->ListlimitedPost();

            foreach ($res as $val) {
                $date = $this->functions->FormatDateTime($val['date_created']);

                $action = "<div class=\"options\">
                    <a href=\"$slug/id/{$val['package_id']}\" >Edit</a>
                    <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['package_id']}\" >Delete</a>
                    </div>";

                $val['title'] = ucwords($val['title']);
                
                $data['aaData'][] = array(
                    $val['package_id'],
                    $val['title'] . $action,
                    '<span class="concat-text">' . $val['description'] . '</span>',
                    $this->functions->formatNumber($val['price']),
                    $this->functions->formatNumber($val['promo_price']),
                    $val['expiration'],
                    $ListlimitedPost[$val['unlimited_post']],
                    $val['sell_limit'] >= 1 ? $val['sell_limit'] : '',
                    "$date<br/><span class=\"tag {$val['status']}\">" . ($val['status']) . "</span>",
                );
            }

            $this->otableOutput($data);
        } else {
            $this->otableNodata();
        }
    }




    public function sponsoreMerchantAdd()
    {   
      if (isset($this->data['merchant_id'])){
        $params=array(
          'is_sponsored'=>2,
          'sponsored_expiration'=>$this->data['expiration'],
          'date_modified'=>$this->functions->dateNow()
        );        
        if ( $this->functions->updateData("mt_merchant",$params,'merchant_id',$this->data['merchant_id'])){
          $this->code=1;
          $this->msg=$this->functions->translation("default","Successful");
          //$this->details=$this->data['merchant_id'];
        } else $this->msg=$this->functions->translation("default","ERROR: cannot update records.");
      } else $this->msg=$this->functions->translation("default","Missing parameters");
    } 



      public function sponsoredMerchantList()
{
    $aColumns = [
        'merchant_id', 'restaurant_name', 'sponsored_expiration'
    ]; 

    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';   

    // Assume the FunctionsK class is loaded and used properly
    
    $t = $this->functions->ajaxDataTables($aColumns);

    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Prepare SQL statement with PDO
    $stmt = "SELECT SQL_CALC_FOUND_ROWS * FROM mt_merchant
             WHERE status = :status
             AND is_sponsored = :is_sponsored
             $sWhere
             $sOrder
             $sLimit";
    
    // Bind parameters and execute
    $params = [
        ':status' => 'active',
        ':is_sponsored' => 2,
    ];

    $res = $this->db->prepare($stmt);
    $res->execute($params);

    // Fetch the result
    $merchants = $res->fetchAll(PDO::FETCH_ASSOC);

    // Check if we have results
    if ($merchants) {
        // Get the total records
        $stmt2 = "SELECT FOUND_ROWS() AS total";
        $res2 = $this->db->query($stmt2);
        $totalRecords = $res2->fetch(PDO::FETCH_ASSOC)['total'];

        $feed_data = [
            'sEcho' => intval($_GET['sEcho']),
            'iTotalRecords' => $totalRecords,
            'iTotalDisplayRecords' => $totalRecords,
            'aaData' => []
        ];

        foreach ($merchants as $val) {
            $link = "/admin/sponsoredMerchantList?Do=Add&id=" . $val['merchant_id'];

            $action = "<div class=\"options\">
                        <a href=\"$link\">" . $this->functions->translation("default", "Edit") . "</a>
                        <a href=\"javascript:;\" class=\"row_del\" rev=\"" . $val['merchant_id'] . "\">" . $this->functions->translation("default", "Remove") . "</a>
                       </div>";

            $date = $this->functions->formatDateTime($val['sponsored_expiration'], false);

            $feed_data['aaData'][] = [
                $val['merchant_id'],
                stripslashes($val['restaurant_name']) . $action,
                $date
            ];
        }

        // Output the table data
        $this->otableOutput($feed_data);
    } else {
        // No data found
        $this->otableNodata();
    }
}



 public function addMerchant()
    {     
      
      if (!empty($this->data['id'])){
        if(!is_numeric($this->data['id'])){
           $this->msg="Invalid merchant id"; 
               return ;
        }
      }
      
      if (empty($this->data['id'])){        
        if ( empty($this->data['username']) && empty($this->data['password'])){
          $this->msg=$this->functions->translation("default","username & password is required");
          return ;
        } else {
          $params['username']=$this->data['username'];
          $params['password']=md5($this->data['password']);
        }
      } else {
        if (!empty($this->data['password'])){
          $params['username']=$this->data['username'];
          $params['password']=md5($this->data['password']);
        }
      }         

      
      if (empty($this->data['id'])){          
          if ($this->functions->isMerchantExist($this->data['contact_email'])){
          $this->msg=$this->functions->translation("default","Sorry you input email address that is already registered in our records.");
          return ;
        }                           
        if ($this->data['merchant_type']==1){
          if (isset($this->data['package_id'])){
             if($this->data['package_id']>0){
              if ( !$package=$this->functions->getPackagesById($this->data['package_id'])){
                    $this->msg=$this->functions->translation("default","ERROR: Package information not found");
                      return ;
                   }    
             } else {
                 $this->msg= $this->functions->translation("default","Package is required for membership type, please go to tab merchant type");
               return ;
             }
          } else {
            $this->msg=$this->functions->translation("default","ERROR: Missing package id");
            return ;
          }     
        }
                
        if ( $t=$this->functions->validateUsername($this->data['username']) ){       
          $this->msg=$this->functions->translation("default","Merchant Username is already been taken");
          return ;
        }     
       } else {
         if ( !empty($this->data['password'])){
         if ( $this->functions->validateUsername($this->data['username'],$this->data['id']) ){
          $this->msg=$this->functions->translation("default","Merchant Username is already been taken");
          return ;
         }       
         }
                 
         if ( $this->functions->validateMerchantEmail($this->data['contact_email'],$this->data['id']) ){
             $this->msg=$this->functions->translation("default","Merchant Email address is already been taken");
              return ;
           }      
         
       }    

      if (!empty($this->data['restaurant_slug'])){
        $params['restaurant_slug']=$this->functions->verifyMerchantSlug(
          $this->functions->seo_friendly_url($this->data['restaurant_slug']),
          $this->data['id']
        );
      } else {  
          $params['restaurant_slug']=$this->functions->createSlug($this->data['restaurant_name']);
      }
      $params['restaurant_name']=addslashes($this->data['restaurant_name']);
      $params['restaurant_phone']=addslashes($this->data['restaurant_phone']);
      $params['contact_name']=addslashes($this->data['contact_name']);
      $params['contact_phone']=$this->data['contact_phone'];
      $params['contact_email']=$this->data['contact_email'];
      $params['country_code']=$this->data['country_code'];      
      $params['street']=$this->data['street'];
      $params['city']=$this->data['city'];
      $params['post_code']=$this->data['post_code'];
      $params['cuisine']=json_encode($this->data['cuisine']);
      $params['service']=$this->data['service'];
      $params['status']=$this->data['status'];
        $params['date_created']=$this->functions->dateNow();
        $params['ip_address']=$_SERVER['REMOTE_ADDR'];
        $params['membership_expired']=isset($this->data['membership_expired'])?$this->data['membership_expired']:'';
        $params['is_featured']=isset($this->data['is_featured'])?$this->data['is_featured']:1;
        $params['package_id']=isset($this->data['package_id'])?$this->data['package_id']:"";
        
        /* custom code 9 Starts*/ 
        $params['merchant_print']=isset($this->data['merchant_print'])?$this->data['merchant_print']:"0";
        $params['merchant_print_customreceipt_after_accept']=isset($this->data['merchant_print_customreceipt_after_accept'])?$this->data['merchant_print_customreceipt_after_accept']:"0";
        /* custom code 9 ends*/
        
        /*Custom code 4 starts */
      $params['stripe_limit_order']=isset($this->data['stripe_limit_order'])?$this->data['stripe_limit_order']:"0";
      $params['windcave_limit_order']=isset($this->data['windcave_limit_order'])?$this->data['windcave_limit_order']:"0";

      $params['is_use_email']=isset($this->data['is_use_email'])?$this->data['is_use_email']:1;
      /*Custom code 4 ends*/
      if(isset($this->data['pos_key']) && !empty($this->data['pos_key'])){
      $params['pos_key']=$this->data['pos_key'];
        }
        $params['state']=isset($this->data['state'])?$this->data['state']:'';               
        $params['percent_commision']=is_numeric($this->data['percent_commision'])?$this->data['percent_commision']:0;
        
        /* custom code 1 starts */
        $params['offline_percent_commision']=is_numeric($this->data['offline_percent_commision'])?$this->data['offline_percent_commision']:0;
            /* custom code 1 Ends */
        
        $params['abn']=isset($this->data['abn'])?$this->data['abn']:'';       
                
        $params['commision_type']=isset($this->data['commision_type'])?$this->data['commision_type']:'';
        
        /* custom code 1 starts */
        $params['offline_commision_type']=isset($this->data['offline_commision_type'])?$this->data['offline_commision_type']:'';        
            /* custom code 1 Ends */
        
        if (isset($this->data['package_id'])){
          if ($package=$this->functions->getPackagesById($this->data['package_id'])){            
            if ($package['promo_price']>=1){
              $params['package_price']=$package['promo_price'];
            } else $params['package_price']=$package['price'];          
          }       
        }   
       
        $params['is_ready']=isset($this->data['is_ready'])?$this->data['is_ready']:1;
        
        $params['latitude']=isset($this->data['merchant_latitude'])?$this->data['merchant_latitude']:'';
        $params['lontitude']=isset($this->data['merchant_longtitude'])?$this->data['merchant_longtitude']:'';
      
        $params['merchant_type']=isset($this->data['merchant_type'])?$this->data['merchant_type']:1;
        $params['invoice_terms']=isset($this->data['invoice_terms'])?$this->data['invoice_terms']:7;
        
        if ($this->data['merchant_type']==1){
          $params['is_commission']=1;
        } else $params['is_commission']=2;
        
        
        if (empty($params['membership_expired'])){
          $params['membership_expired']=date("Y-m-d");
        }   
        
        if(isset($this->data['access'])){
           $params['user_access']=json_encode($this->data['access']);
        } else $params['user_access']=json_encode(array());
                
        if(isset($params['package_price'])){
           $params['package_price'] = (float)$params['package_price'];
        }
        if(isset($params['is_featured'])){
           $params['is_featured'] = (integer)$params['is_featured'];
        }
        if(isset($params['is_ready'])){
           $params['is_ready'] = (integer)$params['is_ready'];
        }
        if(isset($params['is_commission'])){
           $params['is_commission'] = (integer)$params['is_commission'];
        }
        if(isset($params['percent_commision'])){
           $params['percent_commision'] = (float)$params['percent_commision'];
        }
        
        $params['distance_unit']= isset($this->data['distance_unit'])?$this->data['distance_unit']:'mi';
        $params['delivery_distance_covered'] = isset($this->data['delivery_distance_covered'])?(float)$this->data['delivery_distance_covered']:0;
                        
        $params = ($params);  
                
        
        $merchant_id = isset($this->data['id'])?(integer)$this->data['id']:0;
        $cuisine = isset($this->data['cuisine'])?$this->data['cuisine']:array();        
        $tag_id = isset($this->data['tag_id'])?$this->data['tag_id']:array();




                        
        if($merchant_id<=0){
         
          $last_insert_merchant_id = $this->functions->insertData('mt_merchant', $params);
           $last_insert_merchant_id;
          if ($last_insert_merchant_id!== false){
            $merchant_id =$last_insert_merchant_id;

            $this->details=$merchant_id;
                        
            $this->code=1;
            $this->msg=$this->functions->translation("default","Successful");            
            
            $mtid=$merchant_id;


             $links  = isset($this->data['delivery_external_link']) ? $this->data['delivery_external_link'] : [];
$photos = isset($this->data['photo']) ? $this->data['photo'] : [];

$data_del = [];
foreach ($links as $i => $link) {
    $data_del[] = [
        'link'  => $link,
        'photo' => isset($photos[$i]) ? $photos[$i] : ''
    ];
}



            

            $this->functions->updateOption(
    "delivery_external_link",
    json_encode($data_del, JSON_UNESCAPED_UNICODE),
    $merchant_id
);





            /*$this->functions->updateOption("delivery_external_link",
                isset($this->data['delivery_external_link'])?$this->data['delivery_external_link']:''
                ,$mtid);*/
            
                  $this->functions->updateOption("merchant_switch_master_cod",
                isset($this->data['merchant_switch_master_cod'])?$this->data['merchant_switch_master_cod']:''
                ,$mtid);


              $branch_ids = isset($this->data['branch_list']) && is_array($this->data['branch_list']) 
              ? array_map('intval', $this->data['branch_list']) 
              : [];

              $this->functions->updateOption(
                  "branchlist",
                  json_encode($branch_ids),
                  $merchant_id
              );




                
                $this->functions->updateOption("merchant_switch_master_ccr",
                isset($this->data['merchant_switch_master_ccr'])?$this->data['merchant_switch_master_ccr']:''
                ,$mtid);
                
                $this->functions->updateOption("merchant_switch_master_pyr",
                isset($this->data['merchant_switch_master_pyr'])?$this->data['merchant_switch_master_pyr']:''
                ,$mtid);
                
            $this->functions->updateOption("merchant_latitude",
            isset($this->data['merchant_latitude'])?$this->data['merchant_latitude']:''
            ,$mtid);
            
            $this->functions->updateOption("merchant_longtitude",
            isset($this->data['merchant_longtitude'])?$this->data['merchant_longtitude']:''
            ,$mtid);
            
            $this->functions->updateOption("merchant_master_table_boooking",
            isset($this->data['merchant_master_table_boooking'])?$this->data['merchant_master_table_boooking']:''
            ,$mtid);

             $this->functions->updateOption("disable_google_reservations",
            isset($this->data['disable_google_reservations'])?$this->data['disable_google_reservations']:'1'
            ,$mtid);

              $this->functions->updateOption("number_of_slots",
            isset($this->data['number_of_slots'])?$this->data['number_of_slots']:'5'
            ,$mtid);

             $this->functions->updateOption("party_size",
            isset($this->data['party_size'])?$this->data['party_size']:'10'
            ,$mtid);

             $this->functions->updateOption("google_merchant_duration",
            isset($this->data['google_merchant_duration'])?$this->data['google_merchant_duration']:'1800'
            ,$mtid);

            
            $this->functions->updateOption("disabled_single_app_modules",
            isset($this->data['disabled_single_app_modules'])?$this->data['disabled_single_app_modules']:''
            ,$mtid);
            
            $this->functions->updateOption("merchant_master_disabled_ordering",
            isset($this->data['merchant_master_disabled_ordering'])?$this->data['merchant_master_disabled_ordering']:''
            ,$mtid);



            //+++code for merchant google enable in merchant table and setting auto cron
             $disable_google_reservations_chk=(int) $this->functions->getOption("disable_google_reservations",$mtid);
             if (empty($disable_google_reservations_chk) || $disable_google_reservations_chk == 0) {
             $params_google = [
                'google_res_enable'=>1,
                'auto_slot_cron'=>1
             ];
            
             $this->functions->updateData('mt_merchant' , $params_google ,'merchant_id',$mtid);

             if (!$this->functions->isBookingDataValid($mtid)) {
              $this->functions->updateData("mt_merchant", ['data_validation' => 0], 'merchant_id', $mtid);
             }else{
              $this->functions->updateData("mt_merchant", ['data_validation' => 1], 'merchant_id', $mtid);
             }

             $stmt = $this->db->prepare("DELETE FROM mt_booking_slots WHERE date < CURDATE() AND merchant_id = $mtid");
             $stmt->execute();

             // Delete old child slots (if child table has merchant_id)
             $stmt = $this->db->prepare("DELETE FROM mt_booking_slots_child WHERE date < CURDATE() AND merchant_id = $mtid");
             $stmt->execute();


             }else{
                $params_google = [
                'google_res_enable'=>0,
                'auto_slot_cron'=>0
             ];
            
             $this->functions->updateData('mt_merchant' , $params_google ,'merchant_id',$mtid);
             }

          
           //---code for merchant google enable in merchant table and setting auto cron


            
            //AUTO ADD SIZE
            $this->functions->autoAddSize($mtid);
            
            $this->functions->updateOption("merchant_delivery_miles",
              $params['delivery_distance_covered']
              ,$merchant_id);
              
               $this->functions->updateOption("merchant_distance_type",
              $params['distance_unit']
              ,$merchant_id); 
            
            try {
              $this->functions->insertCuisine($merchant_id,(array)$cuisine);
              $this->functions->insertTag($merchant_id,(array)$tag_id);
            } catch (Exception $e) {
              //$e->getMessage()
            }
            
          }
        } else {          
          unset($params['date_created']);
        $params['date_modified']=$this->functions->dateNow();    
        $params['restaurant_slug']=$this->functions->verifyMerchantSlug($params['restaurant_slug'],$this->data['id']);
            
        $res = $this->functions->updateData('mt_merchant' , $params ,'merchant_id',$this->data['id']);
        if ($res){
          $this->code=1;
                  $this->msg=$this->functions->translation("default",'Merchant updated.');  
                  
                  $mtid=$this->data['id'];
                  $this->functions->updateOption("merchant_switch_master_cod",
                isset($this->data['merchant_switch_master_cod'])?$this->data['merchant_switch_master_cod']:''
                ,$mtid);
                
                $this->functions->updateOption("merchant_switch_master_ccr",
                isset($this->data['merchant_switch_master_ccr'])?$this->data['merchant_switch_master_ccr']:''
                ,$mtid);

                $links  = isset($this->data['delivery_external_link']) ? $this->data['delivery_external_link'] : [];
$photos = isset($this->data['photo']) ? $this->data['photo'] : [];

$data_del = [];
foreach ($links as $i => $link) {
    $data_del[] = [
        'link'  => $link,
        'photo' => isset($photos[$i]) ? $photos[$i] : ''
    ];
}



            

            $this->functions->updateOption(
    "delivery_external_link",
    json_encode($data_del, JSON_UNESCAPED_UNICODE),
    $merchant_id
);


               /* $this->functions->updateOption("delivery_external_link",
                isset($this->data['delivery_external_link'])?$this->data['delivery_external_link']:''
                ,$mtid);*/


                
                $this->functions->updateOption("merchant_switch_master_pyr",
                isset($this->data['merchant_switch_master_pyr'])?$this->data['merchant_switch_master_pyr']:''
                ,$mtid);
                
                 $this->functions->updateOption("merchant_latitude",
            isset($this->data['merchant_latitude'])?$this->data['merchant_latitude']:''
            ,$this->data['id']);
            
            $this->functions->updateOption("merchant_longtitude",
            isset($this->data['merchant_longtitude'])?$this->data['merchant_longtitude']:''
            ,$this->data['id']);
            
            $this->functions->updateOption("merchant_master_table_boooking",
            isset($this->data['merchant_master_table_boooking'])?$this->data['merchant_master_table_boooking']:''
            ,$mtid);

             $this->functions->updateOption("disable_google_reservations",
            isset($this->data['disable_google_reservations'])?$this->data['disable_google_reservations']:'1'
            ,$mtid);


             $number_of_slots=$this->functions->getOption("number_of_slots",$mtid);

             if (empty($number_of_slots)) {
             
             $this->functions->updateOption("number_of_slots",'5',$mtid);

             }

             $party_size=$this->functions->getOption("party_size",$mtid);

             if (empty($party_size)) {
             
             $this->functions->updateOption("party_size",'10',$mtid);

             }

              $google_merchant_duration=$this->functions->getOption("google_merchant_duration",$mtid);

             if (empty($google_merchant_duration)) {
             
             $this->functions->updateOption("google_merchant_duration",'1800',$mtid);

             }

           //+++code for merchant google enable in merchant table and setting auto cron
             $disable_google_reservations_chk=(int) $this->functions->getOption("disable_google_reservations",$mtid);
             if (empty($disable_google_reservations_chk) || $disable_google_reservations_chk == 0) {
             $params_google = [
                'google_res_enable'=>1,
                'auto_slot_cron'=>1
             ];
            
             $this->functions->updateData('mt_merchant' , $params_google ,'merchant_id',$mtid);


             if (!$this->functions->isBookingDataValid($mtid)) {
              $this->functions->updateData("mt_merchant", ['data_validation' => 0], 'merchant_id', $mtid);
             }else{
              $this->functions->updateData("mt_merchant", ['data_validation' => 1], 'merchant_id', $mtid);
             }

             $stmt = $this->db->prepare("DELETE FROM mt_booking_slots WHERE date < CURDATE() AND merchant_id = $mtid");
             $stmt->execute();

             // Delete old child slots (if child table has merchant_id)
             $stmt = $this->db->prepare("DELETE FROM mt_booking_slots_child WHERE date < CURDATE() AND merchant_id = $mtid");
             $stmt->execute();




             }else{
                $params_google = [
                'google_res_enable'=>0,
                'auto_slot_cron'=>0
             ];
            
             $this->functions->updateData('mt_merchant' , $params_google ,'merchant_id',$mtid);
             }

          
           //---code for merchant google enable in merchant table and setting auto cron



            
            $this->functions->updateOption("disabled_single_app_modules",
            isset($this->data['disabled_single_app_modules'])?$this->data['disabled_single_app_modules']:''
            ,$mtid);
            
            $this->functions->updateOption("merchant_master_disabled_ordering",
            isset($this->data['merchant_master_disabled_ordering'])?$this->data['merchant_master_disabled_ordering']:''
            ,$mtid);


            $branch_ids = isset($this->data['branch_list']) && is_array($this->data['branch_list']) 
            ? array_map('intval', $this->data['branch_list']) 
            : [];

            $this->functions->updateOption(
                "branchlist",
                json_encode($branch_ids),
                $merchant_id
            );
                        
            $payment_list=$this->functions->PaymentOptionList();
            foreach ($payment_list as $payment_key=>$payment_val) {
              $payment_keys="merchant_switch_master_$payment_key";
              $this->functions->updateOption($payment_keys,
                isset($this->data[$payment_keys])?$this->data[$payment_keys]:''
                ,$mtid);
            }
            
            $this->functions->updateOption("merchant_delivery_miles",
              $params['delivery_distance_covered']
              ,$mtid);
              
              $this->functions->updateOption("merchant_distance_type",
              $params['distance_unit']
              ,$merchant_id); 
            
            /*NOTIFY MERCHANT CHANGE STATUS*/
            //FunctionsV3::MerchantchangeStatus($this->data['id'] , $this->data );
            
            try {
              $this->functions->insertCuisine($merchant_id,(array)$cuisine);
              $this->functions->insertTag($merchant_id,(array)$tag_id);
            } catch (Exception $e) {
              //$e->getMessage()
            }
                                  
        } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
        } 
    }



      public function AddSize()
        {
            $params=array(
              'size_name'=>$this->data['size_name'],
              'status'=>addslashes($this->data['status']),
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR'],
              'merchant_id'=>$this->functions->getMerchantID()
            );                          
            
            if (isset($this->data['size_name_trans'])){
                if ($this->functions->okToDecode()){
                    $params['size_name_trans']=json_encode($this->data['size_name_trans'],
                    JSON_UNESCAPED_UNICODE);
                } else $params['size_name_trans']=json_encode($this->data['size_name_trans']);              
            }       
            
            $size_id = 0;
            
            
            if (isset($this->data['id']) && is_numeric($this->data['id'])){             
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();                
               

                $res =$this->functions->updateData('mt_size' , $params ,'size_id',$this->data['id']);

                if ($res){
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Size updated.');  
                  
                    $size_id = (integer) $this->data['id'];
                    
                } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
            } else {   

                $last_insert_id=$this->functions->insertData("mt_size",$params);
                if ( $last_insert_id!==false){             
                    $this->details=$last_insert_id;   
                    $this->code=1;
                    $this->msg=$this->functions->translation("default",'Size added.');       

                    $size_id = (integer) $this->details;
                                                      
                } else $this->msg=$this->functions->translation("default",'ERROR. cannot insert data.');
            }   

                        
                    
            
        }








    public function getCommissionTotal()
    {   
        /* Custom code 1 starts */


        $total_com=$this->functions->displayPrice($this->functions->adminCurrencySymbol(),  
        $this->functions->normalPrettyPrice($this->functions->getTotalCommission())); 






            
        $total_today=$this->functions->displayPrice($this->functions->adminCurrencySymbol(),    
        $this->functions->normalPrettyPrice($this->functions->getTotalCommissionToday()));   
                    
        $total_last=$this->functions->displayPrice($this->functions->adminCurrencySymbol(), 
        $this->functions->normalPrettyPrice($this->functions->getTotalCommissionLast()));    
            
        $commission=array(  
          'total_com'=>$total_com,  
          'total_today'=>$total_today,  
          'total_last'=>$total_last 
        );
        /* Custom code 1 ends */
        
        $this->code=1;
        $this->msg="Ok";
        $this->details=$commission;
    }



      public function rowDelete()
    {     
      
      
      
      if (!isset($this->data['tbl']))
      { 
        $this->msg=$this->functions->translation("default","Missing parameters");
        return ;             
      }     
      
            
      /*CHECK IF DATA HAS REFERENCE TO OTHER TABLE*/
      if($this->data['tbl']=="mt_dishes"){ 
        if($this->functions->getDishInItem($this->data['row_id'])){
          $this->msg=$this->functions->translation("default","Cannot delete this record it has reference to other tables");
          return ;
        }             
      }
      
      if($this->data['tbl']=="mt_category"){ 
        if($this->functions->getCategoryInItem($this->data['row_id'])){
           $this->msg=$this->functions->translation("default","Cannot delete this record it has reference to other tables");
           return ;
        }             
      }
      if($this->data['tbl']=="mt_size"){
        if($this->functions->getSizeInItem($this->data['row_id'],$this->functions->getMerchantID())){
          $this->msg=$this->functions->translation("default","Cannot delete this record it has reference to other tables");
            return ;
        }     
      }
      if($this->data['tbl']=="mt_packages"){
        if($this->functions->getMerchantPackageByID($this->data['row_id'])){
            $this->msg=$this->functions->translation("default","Cannot delete this record it has reference to other tables");
            return ;  
        }     
      }     
      if($this->data['tbl']=="mt_cuisine"){
        if($this->functions->getMerchantByCuisine($this->data['row_id'])){
            $this->msg=$this->functions->translation("default","Cannot delete this record it has reference to other tables");
            return ;  
        }     
      }
      /*end CHECK IF DATA HAS REFERENCE TO OTHER TABLE*/
                        
      if ($this->data['tbl']=="mt_merchantSponsoredList"){
        $params=array('is_sponsored'=>1,'date_modified'=>$this->functions->dateNow());

        if ($this->functions->updateData('mt_merchant' , $params ,'merchant_id',$this->data['row_id'])){
          $this->code=1;
          $this->msg=$this->functions->translation("default","Successfully remove.");
        } else $this->msg=$this->functions->translation("default","ERROR: cannot execute query.");     
        return ;
      }   
            
      if ($this->data['tbl']=="mt_merchant"){
        
        if ( $this->functions->getMerchantOrders($this->data['row_id'])){
          $this->msg=$this->functions->translation("default","Sorry but you cannot delete this merchant it has reference on order tables");
          return ;
        }     
      }
      
      
      /*DELETE IMAGE IF TABLE IS CATEGORY*/
      $filename_to_delete=array();      
      if($this->data['tbl']=="mt_category"){   
            
        if($this->functions->getCategoryInItem($this->data['row_id'])){
           $this->msg=$this->functions->translation("default","Cannot delete this record it has reference to other tables");
           return ;
        }             
        if ($temp_res=$this->functions->getCategory($this->data['row_id'])){         
          $filename_to_delete[]=$temp_res['photo'];
        } 
      } 
      
      
      /*DELETE IMAGE IF TABLE IS subcategory_item*/
      if($this->data['tbl']=="mt_subcategory_item"){
        if ($temp_res=$this->functions->getAddonItem($this->data['row_id'])){          
          $filename_to_delete[]=$temp_res['photo'];
        } 
      } 
      
      /*DELETE IMAGE IF TABLE IS ITEM*/
      if($this->data['tbl']=="mt_item"){
        if($old_data=$this->functions->getFoodItem($this->data['row_id'])){
           if (!empty($old_data['photo'])){
              $filename_to_delete[]=$old_data['photo'];
           }      
           $gallery_photo=json_decode($old_data['gallery_photo'],true);
           if(is_array($gallery_photo) && count($gallery_photo)>=1){
              foreach ($gallery_photo as $gallery_photo_val) {
                  $filename_to_delete[]=$gallery_photo_val;
              }
           }        
        }
      }
      
      /*DELETE IMAGE IF TABLE IS dishes*/
      if($this->data['tbl']=="mt_dishes"){               
        if($old_data=$this->functions->GetDish($this->data['row_id'])){
           $filename_to_delete[]=$old_data['photo'];
        }
      }

      if($this->data['tbl']=="mt_branches"){

       

        //+++was custom code
    $branch_data = $this->functions->Getbranch_byid($this->data['row_id']);

if (!$branch_data) {
    $this->msg = "Branch not found.";
    return;
}

$merchant_ids = json_decode($branch_data['merchant_id'], true); // ["3", "20"]

if (!is_array($merchant_ids) || empty($merchant_ids)) {
    $this->msg = "Invalid merchant_id format.";
    return;
}

// Prepare SQL
$placeholders = implode(',', array_fill(0, count($merchant_ids), '?'));
$sql = "SELECT merchant_id FROM mt_client 
         WHERE social_strategy IN ('SingleMerchant', 'webappv2') 
        AND merchant_id IN ($placeholders)";

$stmt = $this->db->prepare($sql);
$stmt->execute($merchant_ids);
$clients = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Loop and update
foreach ($clients as $client) {
    $merchant_id = (int) $client['merchant_id'];
    $new_branch = json_encode([$merchant_id]);

    $update_sql = "UPDATE mt_client SET branch = ? WHERE merchant_id = ?";
    $this->db->prepare($update_sql)->execute([$new_branch, $merchant_id]);
}

$this->msg = "Branch fields updated successfully.";






        //---was custom code

      }




                  
                  
     

      $whereid = $this->data['whereid'];
      $tbl = $this->data['tbl'];
      $row_id = $this->data['row_id'];
      // Prepare the SQL statement
      $query = "DELETE FROM $tbl WHERE $whereid = :row_id";
      // Prepare the statement
      $stmt = $this->db->prepare($query);
      // Bind the row_id parameter
      $stmt->bindParam(':row_id', $row_id, PDO::PARAM_INT);

      // Execute the statement
      if ($stmt->execute()) {
          $this->msg = $this->functions->translation("default","Successfully deleted.");
          $this->code = 1;

                 

                 /*DELETE TRANSLATION DATA*/                
                 /*Item_translation::deleteTranslation(
                   isset($this->data['row_id']) ? $this->data['row_id'] : 0,
                   isset($this->data['whereid']) ? $this->data['whereid'] : '',
                   isset($this->data['tbl']) ? $this->data['tbl'] : ''


                 );*/


             if ($this->data['tbl'] == "mt_booking_slots") {

              $row_id = $this->data['row_id'];

              // Prepare and execute deletion from the {{option}} table
              $stmt_del = "DELETE FROM mt_booking_slots_child WHERE parent_id = :row_id";
              $stmt = $this->db->prepare($stmt_del);
              $stmt->bindValue(':row_id', $row_id, PDO::PARAM_INT);
              if ($row_id >= 1) {
                  $stmt->execute();
              }


             }


                 
              if ($this->data['tbl'] == "mt_merchant") {
              $row_id = $this->data['row_id'];

              // Prepare and execute deletion from the {{option}} table
              $stmt_del = "DELETE FROM mt_option WHERE merchant_id = :row_id";
              $stmt = $this->db->prepare($stmt_del);
              $stmt->bindValue(':row_id', $row_id, PDO::PARAM_INT);
              if ($row_id >= 1) {
                  $stmt->execute();
              }

              // Prepare and execute deletion from the {{size}} table
              $stmt_size = "DELETE FROM mt_size WHERE merchant_id = :row_id";
              $stmt = $this->db->prepare($stmt_size);
              $stmt->bindValue(':row_id', $row_id, PDO::PARAM_INT);
              $stmt->execute();

              // Prepare and execute deletion from the {{cuisine_merchant}} table
              $stmt_cuisine = "DELETE FROM mt_cuisine_merchant WHERE merchant_id = :row_id";
              $stmt = $this->db->prepare($stmt_cuisine);
              $stmt->bindValue(':row_id', $row_id, PDO::PARAM_INT);
              $stmt->execute();

              // Prepare and execute deletion from the {{opening_hours}} table
              $stmt_hours = "DELETE FROM mt_opening_hours WHERE merchant_id = :row_id";
              $stmt = $this->db->prepare($stmt_hours);
              $stmt->bindValue(':row_id', $row_id, PDO::PARAM_INT);
              $stmt->execute();
              }
     
                 
                 /*special category*/
         if($this->data['tbl']=="mt_category"){
          //ClassCategory::deleteCategory($this->data['row_id']);
         }  
         
         /*DELETE IMAGE*/
      /*   if(is_array($filename_to_delete) && count($filename_to_delete)>=1){
          foreach ($filename_to_delete as $filename) {
            FunctionsV3::deleteUploadedFile($filename);
          }           
         }*/
                             
      } else $this->msg=$this->functions->translation("default","ERROR: cannot execute query.");
    }






    protected function updateData($table, $params, $key, $id) {
        $set = [];
        foreach ($params as $column => $value) {
            $set[] = "$column = :$column";
        }
        $set = implode(", ", $set);
        
        $stmt = $this->db->prepare("UPDATE $table SET $set WHERE $key = :id");
        foreach ($params as $column => $value) {
            $stmt->bindValue(":$column", $value, PDO::PARAM_STR);
        }
        $stmt->bindValue(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
    }

    public function output($debug=FALSE)
        {           
            $resp=array('code'=>$this->code,'msg'=>$this->msg,'details'=>$this->details);
            if ($debug){
                dump($resp);
            }
            return json_encode($resp);                      
        }



          public function rptMerchantPaymentxx()
{
    // Columns for data tables
    $aColumns = array(
        'id', 'merchant_name', 'package_name', 'price', 'payment_type', 'status', 'date_created', 'id'
    );
    
    // Initialize variables for the WHERE clause and other parts of the query
    $sWhere = '';
    $sOrder = '';
    $sLimit = '';
    
    // Handle filtering, ordering, and pagination via the dataTables helper function
    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    // Building the date filter (if any)
    $and = '';
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $and = " WHERE date_created BETWEEN :start_date AND :end_date";
        }
    }

    // Handling the status filter (if any)
    $order_status_id = '';
    if (isset($this->data['stats_id']) && is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
        $order_status_id = implode(",", array_map(function($status) {
            return "'$status'";
        }, $this->data['stats_id']));
        
        if (!empty($order_status_id)) {
            if (empty($and)) {
                $and = " WHERE status IN ($order_status_id)";
            } else {
                $and .= " AND status IN ($order_status_id)";
            }
        }
    }

    // Build the SQL query
    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS a.*,
        (
            SELECT title 
            FROM mt_packages 
            WHERE package_id = a.package_id
        ) as package_name,
        (
            SELECT restaurant_name
            FROM mt_merchant
            WHERE merchant_id = a.merchant_id
        ) as merchant_name
        FROM mt_package_trans a
        $and
        $sOrder
        $sLimit
    ";

    // Prepare and execute the query
    $pdo = $this->db; // Assuming $this->db is your PDO instance
    $query = $pdo->prepare($stmt);

    // Bind date parameters if date range exists
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        $query->bindValue(':start_date', $this->data['start_date'] . " 00:00:00");
        $query->bindValue(':end_date', $this->data['end_date'] . " 23:59:00");
    }

    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // Handle the results
    if ($res) {
        // Get total records
        $iTotalRecords = $pdo->query("SELECT FOUND_ROWS()")->fetchColumn();
        
        // Prepare data for output
        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            // Format the data
            $action = "<a data-id=\"{$val['id']}\" class=\"edit-payment\" href=\"javascript:\">" . $this->functions->translation("default", "Edit") . "</a>";
            $date = $this->functions->FormatDateTime($val['date_created']);
            
            if ($val['payment_type'] == "ocr") {
                $payment_type = "<a href=\"javascript:;\" class=\"show-cc-details\" data-id=\"{$val['id']}\">" . strtoupper($val['payment_type']) . "</a>";
            } else {
                $payment_type = strtoupper($val['payment_type']);
            }
            
            $feed_data['aaData'][] = array(
                $val['id'],
                $val['merchant_name'],
                $val['package_name'],
                $val['price'] >= 1 ? $this->functions->formatNumber($val['price']) : "",
                $payment_type,
                "<span class=\"{$val['status']}\">{$val['status']}</span>",
                $date,
                $action
            );
        }

        // Output the data (assumed to be JSON)
        $this->otableOutput($feed_data);
    } else {
        // If no data, handle it
        $this->otableNodata();
    }
}






      public function rptMerchantPaymentToday()
{
    // Step 1: Define the current date
    $datenow = date('Y-m-d');
    
    // Step 2: Prepare the SQL statement
    $stmt = $this->db->prepare("
        SELECT a.*,
            (SELECT title FROM mt_packages WHERE package_id = a.package_id) AS package_name,
            (SELECT restaurant_name FROM mt_merchant WHERE merchant_id = a.merchant_id) AS merchant_name
        FROM mt_package_trans a
        WHERE date_created LIKE :datenow
    ");
    
    // Step 3: Bind the parameters
    $stmt->bindValue(':datenow', "$datenow%", PDO::PARAM_STR);
    
    // Step 4: Execute the query
    $stmt->execute();
    
    // Step 5: Fetch the results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Step 6: Process and output the results
    if ($res) {
        $feed_data = [];
        foreach ($res as $val) {
            $action = "<a data-id=\"" . $val['id'] . "\" class=\"edit-payment\" href=\"javascript:\">" . $this->functions->translation("default", "Edit") . "</a>";
            
            $feed_data['aaData'][] = array(
                $val['id'],
                $val['merchant_name'],
                $val['package_name'],
                //$val['price'] >= 1 ? ($val['price']) : "",
                $val['price']>=1?$this->functions->formatNumber($val['price']):"",   
                $this->functions->prettyPaymentType('package_trans', $val['payment_type'], $val['id']),
                "<span class=\"tag " . $val['status'] . "\">" . t($val['status']) . "</span>",
                $this->functions->FormatDateTime($val['date_created'], true),
                $action
            );
        }
        
        // Output the result using the otableOutput function
        $this->otableOutput($feed_data);
    } else {
        // If no data, call the no data function
        $this->otableNodata();
    }
}


public function rptIncomingOrders()
{
    // Initialize query components
    $and = '';
    $params = [];
    
    // Handle date range filtering
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])){
            $and .= " AND date_created BETWEEN :start_date AND :end_date ";
            $params[':start_date'] = $this->data['start_date'] . ' 00:00:00';
            $params[':end_date'] = $this->data['end_date'] . ' 23:59:00';
        }
    }
    
    // Handle status ID filtering
    if (isset($this->data['stats_id']) && is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
        $placeholders = implode(',', array_fill(0, count($this->data['stats_id']), '?'));
        $and .= " AND status IN ($placeholders)";
        $params = array_merge($params, $this->data['stats_id']);
    }
    
    // Multi-currency handling
    $select = '';
    
     
    // Define the merchant ID
    $merchant_id = $this->functions->getMerchantID();
    
    // Prepare the SQL query
    $stmt = $this->db->prepare("
        SELECT a.*,
            (SELECT CONCAT(first_name, ' ', last_name) FROM mt_client WHERE client_id = a.client_id) AS client_name,
            (SELECT GROUP_CONCAT(item_name) FROM mt_order_details WHERE order_id = a.order_id) AS item,
            (SELECT restaurant_name FROM mt_merchant WHERE merchant_id = a.merchant_id) AS merchant_name,
      (
                SELECT CONCAT(first_name, ' ', last_name)
                FROM mt_order_delivery_address
                WHERE order_id = a.order_id
                LIMIT 0,1
            ) AS customer_name      

      
            $select
        FROM mt_order a
        WHERE a.status NOT IN ('".$this->functions->initialStatus()."')
        AND a.request_from != 'pos'
        AND date_created LIKE :today
        $and
        ORDER BY order_id DESC
        LIMIT 0,100
    ");
    
    // Bind the date for filtering today's orders
    $params[':today'] = date("Y-m-d") . '%';
    
    // Execute the query
    $stmt->execute($params);
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Process the results
    if ($res) {
        $feed_data = [];
        foreach ($res as $val) {
            
      
      
        if ($val['request_from'] == "webappv2" || $val['request_from'] == "web") {
      
         if(!empty($val['customer_name']) && strlen($val['customer_name'])>1 ){          
          $val['client_name'] = $val['customer_name'];
        }
    
    }

      
      
            // Client name processing
            $val['client_name'] = !empty($val['client_name']) ? $val['client_name'] : 'Guest';
      
      if($val['is_phone_order']==1){
            
            $val['client_name']=$val['client_names'];
            
          }
          
      
            
            // Generate action links
            $action = '';
       if($val['request_from']=="pos"){}else{
          $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"edit-order\" href=\"javascript:\">" . ("Edit") . "</a>";
       }
      $action .= "<br/><a data-id=\"" . $val['order_id'] . "\" class=\"view-receipt\" href=\"javascript:\">" . ("View") . "</a>";
            $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"view-order-history\" href=\"javascript:\">" . ("History") . "</a>";
            
            // Auto print status
            $autoprint = ($val['auto_print'] == '1') ? "Printed" : "Not Printed";

            // $emailstatus = "-";

            $emailstatus=$this->functions->chk_email_status_against_order($val['order_id'],$val['merchant_id']);
            
            //Email Status
            // $orderId = $val['order_id'];
            
           /* $sql = "
            SELECT 
              o.order_id,
              el.email_address,
              mo.option_value AS merchant_notify_email
            FROM mt_email_logs AS el
            JOIN mt_order AS o
              ON el.order_id = o.order_id
            JOIN mt_option AS mo
              ON mo.merchant_id = o.merchant_id
              AND mo.option_name = 'merchant_notify_email'
            WHERE o.order_id = :order_id
            ";
            
            $stmt = $this->db->prepare($sql);
            $stmt->execute([':order_id' => $val['order_id']]);
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
        // Fetch $results as before...
        
        $emailstatus = "Not Sent";
        
        if (!empty($results)) {
            $notify_emails = array_map('trim', explode(',', $results[0]['merchant_notify_email']));
            
            $loggedEmails = array_map('trim', array_column($results, 'email_address'));
            $uniqueLogged = array_unique($loggedEmails);
            $totalUnique = count($uniqueLogged);
            
            $matchCount = 0;
            foreach ($uniqueLogged as $email) {
                if (in_array($email, $notify_emails)) {
                    $matchCount++;
                }
            }
            
            if ($matchCount === 0) {
                $emailstatus = "Not Sent1";
            } elseif ($matchCount === $totalUnique) {
                $emailstatus = "Sent1";
            } else {
                $emailstatus = "Partial Sent1";
            }
        }*/

            
            // Date formatting
            $date = $this->functions->FormatDateTime($val['date_created']);
            $date = $this->functions->translateDate($date);
            
            // Translate food items
            $item = $this->functions->translateFoodItemByOrderId($val['order_id'], 'kr_admin_lang_id');
            
            // New order badge
            $new = ($val['admin_viewed'] <= 0) ? " <div class=\"uk-badge\">" . ("NEW") . "</div>" : '';
            
            // Handle currency formatting
            if (isset($val['currency_format'])) {
                $currency_format = explode("|", $val['currency_format']);
                /*Price_Formatter::$number_format = array(
                    'decimals' => isset($currency_format[0]) ? $currency_format[0] : 2,
                    'decimal_separator' => isset($currency_format[1]) ? $currency_format[1] : '.',
                    'thousand_separator' => isset($currency_format[2]) ? $currency_format[2] : '',
                    'position' => isset($currency_format[3]) ? $currency_format[3] : 'left',
                    'spacer' => Price_Formatter::getSpacer(isset($currency_format[3]) ? $currency_format[3] : 'left'),
                    'currency_symbol' => isset($currency_format[4]) ? $currency_format[4] : '',
                );*/
            }
            
            // Payment type
            $payment_type = $this->functions->prettyPaymentType('payment_order', $val['payment_type'], $val['order_id'], $val['trans_type']);
            if ($val['is_sop'] == '1' && $val['trans_type'] == 'pickup') {
                $payment_type = 'Swipe on Pickup';
            }
            
            // Order number
            $order_number = '-';
            if (($val['request_from'] == "webappv2" || $val['request_from'] == "pos") && $val['order_number'] > 0) {
                $order_number = $val['merchant_id'] . '-' . $val['order_number'];
            }
             $order_number = $val['merchant_id'] . '-' . $val['order_number'];
      
      if($val['is_phone_order']==1 && $val['trans_type']=='pickup'){
            $val['trans_type']='Phone Pickup';
            
          }else if($val['is_phone_order']==1 && $val['trans_type']=='delivery'){
            $val['trans_type']='Phone Delivery';
            
          } 
          if($val['is_retail']==1){$val['trans_type']='Retail';}
      
            
            $this->functions->initPriceFormatter('USD');
            // Populate the table data
            $payment_type=$this->functions->payment_translations($val['trans_type'],$val['payment_type'],$val['is_sop']);

            $feed_data['aaData'][] = array(
                $val['order_id'], $order_number,
                ucwords(stripslashes($val['merchant_name'])) . $new,
                ucwords(stripslashes($val['client_name'])),
                stripslashes($item),
                $this->functions->translation('default',$val['trans_type']),
                $this->functions->translation('default',$payment_type),
                $this->functions->formatNumber($val['sub_total']),
                $this->functions->formatNumber($val['taxable_total']),
                $this->functions->formatNumber($val['total_w_tax']),
                //$val['sub_total'],
                //$val['taxable_total'],
                //$val['total_w_tax'],
                "<span class=\"tag " . $val['status'] . "\">" . ($val['status']) . "</span><div>$action</div>",
                $this->functions->translation('default',$val['request_from']),
                $date,
                "<span class=\"tag " . $autoprint . "\">$autoprint</span>",
                "<span class=\"tag " . $emailstatus . "\">$emailstatus</span>"
            );
        }
        
        // Output the result using the otableOutput function
        $this->otableOutput($feed_data);
    } else {
        // If no data, call the no data function
        $this->otableNodata();
    }
}




   public function merchantList() {
    $slug = $this->data['slug'];

    $aColumns = [
        'merchant_id', 'restaurant_name', 'street', 'city', 'country_code', 'contact_phone',
        'package_id', 'activation_token', 'is_commission', 'status'
    ];

    $sWhere = ''; 
    $sOrder = ''; 
    $sLimit = '';
    $sTable = "mt_merchant";

    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    $stmt = $this->db->prepare("
        SELECT SQL_CALC_FOUND_ROWS 
        a.*,
        (
            SELECT title
            FROM mt_packages
            WHERE package_id = a.package_id
            LIMIT 0,1
        ) as package_name
        FROM $sTable a
        $sWhere
        $sOrder
        $sLimit
    ");

    $stmt->execute();
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $stmt2 = $this->db->query("SELECT FOUND_ROWS()");
        $iTotalRecords = $stmt2->fetchColumn();

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $class = '';
            $date = $this->functions->formatDateTime($val['date_created']);
            $action = "<div class=\"options\">
                        <a href=\"$slug/id/{$val['merchant_id']}\">Edit</a>
                        <a href=\"javascript:;\" class=\"row_del\" rev=\"{$val['merchant_id']}\">Delete</a>
                       </div>";
            
            $val['package_name'] = $val['package_name'] ?? '';

            if ($val['status'] == "expired") {
                $class = 'uk-badge-danger';
            } elseif ($val['status'] == "pending") {
                $class = '';
            } elseif ($val['status'] == "active") {
                $class = 'uk-badge-success';
            }

            $membershipdate = $this->functions->formatDateTime($val['membership_expired'], false);

            $url_login = Config::$baseUrl."/merchant/autologin/id/".$val['merchant_id']."/token/".$val['password'];
            $link_login = "<br/><br/><a target=\"_blank\" href=\"$url_login\"><div class=\"uk-badge\">AutoLogin</div></a>";

            if (!in_array('autologin', (array)$this->functions->AAccess())) {
                $link_login = '';                        
            }

            $today_status = $val['is_ready'] == 1 ? 'Not Published' : $this->functions->merchantOpenTag($val['merchant_id']);

            if ($this->functions->getOptionAdmin('home_search_mode') != "postcode") {
                $feed_data['aaData'][] = [
                    $val['merchant_id'], stripslashes($val['restaurant_name']) . $action,
                    $val['street'],
                    $val['city'],
                    $val['country_code'],
                    $val['restaurant_phone'] . " / " . $val['contact_phone'],
                    $val['package_name'] . "<br/>" . $membershipdate,
                    $val['activation_key'],
                    $this->functions->DisplayMembershipType($val['merchant_type'], $val['invoice_terms']),
                    "$date<br/><span class=\"tag {$val['status']}\">{$val['status']}</span>$link_login",
                    $today_status
                ];
            } else {
                $feed_data['aaData'][] = [
                    $val['merchant_id'], stripslashes($val['restaurant_name']) . $action,
                    $val['street'],
                    $val['post_code'],
                    $val['restaurant_phone'] . " / " . $val['contact_phone'],
                    $val['package_name'] . "<br/>" . $membershipdate,
                    $val['activation_key'],
                    $this->functions->DisplayMembershipType($val['merchant_type'], $val['invoice_terms']),
                    "$date<br/><span class=\"tag {$val['status']}\">{$val['status']}</span>$link_login",
                    $today_status
                ];
            }
        }

        $this->otableOutput($feed_data);    
    } else {
        $this->otableNodata();
    }
}

/*public function uploadFile()
  {
    echo "here";die();
  }*/


    public function CuisineList()
{
    // Extract the slug from data
    $slug = $this->data['slug'];
    
    // Prepare the SQL statement
    $stmt = "SELECT * FROM mt_cuisine ORDER BY sequence DESC";
    $query = $this->db->prepare($stmt);

    try {
        // Execute the query
        $query->execute();
        // Fetch all results as an associative array
        $results = $query->fetchAll(PDO::FETCH_ASSOC);

        $feed_data = array(); // Initialize feed_data

        // Loop through the results
        foreach ($results as $val) {
            // Generate actions with appropriate links
            $action = "<div class=\"options\">
                <a href=\"$slug/Do/Add/id/" . htmlspecialchars($val['cuisine_id']) . "\">" . $this->functions->translation("default", "Edit") . "</a>
                <a href=\"javascript:;\" class=\"row_del\" rev=\"" . htmlspecialchars($val['cuisine_id']) . "\">" . $this->functions->translation("default", "Delete") . "</a>
            </div>";

            // Handle image if available
            $image = '';
            if (!empty($val['featured_image'])) {
                $image = '<img class="uk-thumbnail uk-thumbnail-mini" src="' . htmlspecialchars($this->functions->uploadURL() . "/" . $val['featured_image']) . '">';
            }

            // Format the date
            $date = $this->functions->FormatDateTime($val['date_created']);
            
            // Prepare data for output
            $feed_data['aaData'][] = array(
                $val['cuisine_id'],
                $val['cuisine_name'] . $action,
                $val['slug'],
                $image,
                $date
            );
        }

        // Output data
        $this->otableOutput($feed_data);

    } catch (PDOException $e) {
        // Handle any errors that occur during query execution
        error_log($e->getMessage());
        $this->otableNodata();
    }
}




public function addCuisine()
    {     
      
      $cuisine_id = isset($this->data['id'])? (integer) $this->data['id']:0;
      
        
      $req=array(
        'cuisine_name'=>$this->functions->translation("default","Name is required")      
      );    
      
     
      if (1==1){
        $params=array(
          'cuisine_name'=>($this->data['cuisine_name']),
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'featured_image'=>isset($this->data['featured_image'])?$this->data['featured_image']:''
        );        
        
              if (isset($this->data['cuisine_name_trans'])){        
          if ($this->functions->okToDecode()){
            $params['cuisine_name_trans']=json_encode($this->data['cuisine_name_trans'],
            JSON_UNESCAPED_UNICODE);
          } else $params['cuisine_name_trans']=json_encode($this->data['cuisine_name_trans']);        
        }
                 
         if (empty($this->data['id'])){ 
              $params['slug'] = $params['cuisine_name'];
              $last_insert_id=$this->functions->insertData("mt_cuisine",$params);
            if ( $last_insert_id!==false){
                  $cuisine_id =$last_insert_id;
                  $this->details = $cuisine_id;
                $this->code=1;
                $this->msg=$this->functions->translation("default","Successful");                
              }
            } else {          
              $params['slug'] = $this->functions->createSlug('cuisine',$params['cuisine_name'],'slug','cuisine_id',$this->data['id']);             
              unset($params['date_created']);
            $params['date_modified']=$this->functions->dateNow();        
            $res = $this->functions->updateData('mt_cuisine' , $params ,'cuisine_id',$this->data['id']);
            if ($res){
              $this->code=1;
                      $this->msg=$this->functions->translation("default",'Cuisine updated.');  
          } else $this->msg=$this->functions->translation("default","ERROR: cannot update");
          } 
      } else $this->msg="";   
      
      
      /*INSERT TRANSLATION*/      
        if($this->code==1){       
        if(isset($this->data['cuisine_name_trans'])){
          $this->data['cuisine_name_trans']['default'] = isset($this->data['cuisine_name'])?$this->data['cuisine_name']:'';       
        }                 
       /* Item_translation::insertTranslation( 
        (integer) $cuisine_id ,
        'cuisine_id',
        'cuisine_name',
        '',
        array(                    
          'cuisine_name'=>isset($this->data['cuisine_name_trans'])?$this->data['cuisine_name_trans']:'',        
        ),"{{cuisine_translation}}");*/
      }   
      
    }


      public function commissionSettings()
  {   
        
    $this->functions->updateOptionAdmin("admin_commission_enabled",
      isset($this->data['admin_commission_enabled'])?$this->data['admin_commission_enabled']:'');
      
      $this->functions->updateOptionAdmin("admin_disabled_membership",
      isset($this->data['admin_disabled_membership'])?$this->data['admin_disabled_membership']:'');
      
      /* Custom code 1 starts */
      $this->functions->updateOptionAdmin("admin_online_commision_percent",  
      isset($this->data['admin_online_commision_percent'])?$this->data['admin_online_commision_percent']:''); 
      
      $this->functions->updateOptionAdmin("admin_offline_commision_percent", 
      isset($this->data['admin_offline_commision_percent'])?$this->data['admin_offline_commision_percent']:''); 
      /* Custom code 1 ends */
      
    //  $this->functions->updateOptionAdmin("admin_commision_percent",
    //  isset($this->data['admin_commision_percent'])?$this->data['admin_commision_percent']:'');
      
      $this->functions->updateOptionAdmin("admin_vat_no",
      isset($this->data['admin_vat_no'])?$this->data['admin_vat_no']:'');
      
      $this->functions->updateOptionAdmin("admin_vat_percent",
      isset($this->data['admin_vat_percent'])?$this->data['admin_vat_percent']:'');
      
      $this->functions->updateOptionAdmin("total_commission_status",
      isset($this->data['total_commission_status'])?json_encode($this->data['total_commission_status']):'');
      
      $this->functions->updateOptionAdmin("admin_commision_ontop",
      isset($this->data['admin_commision_ontop'])?$this->data['admin_commision_ontop']:'');
      
      /* Custom code 1 starts */
      $this->functions->updateOptionAdmin("admin_online_commision_type", 
      isset($this->data['admin_online_commision_type'])?$this->data['admin_online_commision_type']:''); 
        
      $this->functions->updateOptionAdmin("admin_offline_commision_type",  
      isset($this->data['admin_offline_commision_type'])?$this->data['admin_offline_commision_type']:'');
      /* Custom code 1 ends */
      
    //  $this->functions->updateOptionAdmin("admin_commision_type",
    //  isset($this->data['admin_commision_type'])?$this->data['admin_commision_type']:'');
      
      $this->functions->updateOptionAdmin("admin_include_merchant_cod",
      isset($this->data['admin_include_merchant_cod'])?$this->data['admin_include_merchant_cod']:'');
      
      $this->functions->updateOptionAdmin("admin_exclude_cod_balance",
      isset($this->data['admin_exclude_cod_balance'])?$this->data['admin_exclude_cod_balance']:'');
      
      $this->functions->updateOptionAdmin("admin_disabled_membership_signup",
      isset($this->data['admin_disabled_membership_signup'])?$this->data['admin_disabled_membership_signup']:'');
      
      $this->functions->updateOptionAdmin("admin_bank_account_name",
      isset($this->data['admin_bank_account_name'])?$this->data['admin_bank_account_name']:'');
      
      $this->functions->updateOptionAdmin("admin_bank_account_number",
      isset($this->data['admin_bank_account_number'])?$this->data['admin_bank_account_number']:'');
      
      $this->functions->updateOptionAdmin("admin_bank_custom_tpl",
      isset($this->data['admin_bank_custom_tpl'])?$this->data['admin_bank_custom_tpl']:'');
      
      $this->functions->updateOptionAdmin("admin_bank_deposited_timeframe",
      isset($this->data['admin_bank_deposited_timeframe'])?$this->data['admin_bank_deposited_timeframe']:'');
    
      /* Custom code 1 starts */
      $this->functions->updateOptionAdmin("admin_include_all_offline_payment",
      isset($this->data['admin_include_all_offline_payment'])?$this->data['admin_include_all_offline_payment']:'');
      /* Custom code 1 ends */
      
      $this->code=1;
      $this->msg=$this->functions->translation("default","Setting saved");
  }


public function addDish()
{   
    $dish_id = 0;

    $req=array(
      'dish_name'=>$this->functions->translation("default","Dish name is required"),
      'spicydish'=>$this->functions->translation("default","Icon is required")
    );  
    $this->functions->required($req,$this->data);
   
    if ($this->functions->validate()) { // Assuming this condition is a placeholder, otherwise this is redundant
        $params = array(
            'dish_name' => $this->data['dish_name'], // Corrected the misplaced parenthesis
            'photo' => $this->data['spicydish'],
            'status' => $this->data['status'],
            'date_created' => $this->functions->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR']
        );

        if (empty($this->data['id'])) { 
            $last_insert_id = $this->functions->insertData("mt_dishes", $params);
            if ($last_insert_id !== false) {
                $dish_id = $last_insert_id;
                $this->details = $dish_id;
                $this->code = 1;
                $this->msg = $this->functions->translation("default", "Successful");                
            }
        } else {          
            unset($params['date_created']);
            $params['date_modified'] = $this->functions->dateNow();
          
            $res = $this->functions->updateData('mt_dishes', $params, 'dish_id', $this->data['id']);
            if ($res) {
                $this->code = 1;
                $this->msg = $this->functions->translation("default", 'Dish updated');  
                $dish_id = (integer) $this->data['id'];
            } else {
                $this->msg = $this->functions->translation("default", "ERROR: cannot update");
            }
        } 
        
        /*INSERT TRANSLATION*/
        if ($this->code == 1) {         
            if (isset($this->data['dish_name_trans'])) {
                $this->data['dish_name_trans']['default'] = isset($this->data['dish_name']) ? $this->data['dish_name'] : '';        
            }                         
            /* Item_translation::insertTranslation( 
                (integer) $dish_id,
                'dish_id',
                'dish_name',
                '',
                array(                    
                    'dish_name' => isset($this->data['dish_name_trans']) ? $this->data['dish_name_trans'] : '',       
                ), "{{dishes_translation}}"); */
        }
        
    } else {
        $this->msg = $this->functions->getErrorAsHTML();
    }
}






      public function dishList()
  {
        
    
   
    $slug = $this->data['slug'];
    
    $sql = "
        SELECT * FROM mt_dishes
        WHERE status IN ('published', 'publish')
        ORDER BY dish_id DESC
    ";
    
    // Using $this->db, which is assumed to be a PDO instance
    $stmt = $this->db->prepare($sql);
    $stmt->execute();
    
    // Fetch all results
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (is_array($rows) && count($rows) >= 1) {
        foreach ($rows as $val) {  
          $chk="<input type=\"checkbox\" name=\"row[]\" value=\"$val[dish_id]\" class=\"chk_child\" >";       
          
          
          
          $option="<div class=\"options\">
          

          <a href=\"$slug/Do/Add/id/" . htmlspecialchars($val['dish_id']) . "\">" . $this->functions->translation("default", "Edit") . "</a>

          <a href=\"javascript:;\" class=\"delete_item\" data-id=\"$val[dish_id]\" >".$this->functions->translation("default","Delete")."</a>
          </div>";
          
          //<a href=\"javascript:;\" class=\"row_del\" rev=\"$val[dish_id]\" >".Yii::t("default","Delete")."</a>
          
          $date=$this->functions->FormatDateTime($val['date_created']);
          
          $feed_data['aaData'][]=array(
            $val['dish_id'],
            $val['dish_name'].$option,
            '<img class="uk-thumbnail uk-thumbnail-mini" src="'.$this->functions->uploadURL()."/".$val['photo'].'">',
            //$date."<div>".$val['status']."</div>"
            "$date<br/><span class=\"tag ".$val['status']."\">".($val['status'])."</span>",
          );
        }
        $this->otableOutput($feed_data);
      }           
      $this->otableNodata();  
  } 

  public function smsSettings()
    {           
      $this->functions->updateOptionAdmin("sms_sender_id",
        isset($this->data['sms_sender_id'])?$this->data['sms_sender_id']:'');
        
        $this->functions->updateOptionAdmin("sms_account_id",
        isset($this->data['sms_account_id'])?$this->data['sms_account_id']:'');
        
        $this->functions->updateOptionAdmin("sms_token",
        isset($this->data['sms_token'])?$this->data['sms_token']:'');
        
        $this->functions->updateOptionAdmin("mechant_sms_enabled",
        isset($this->data['mechant_sms_enabled'])?$this->data['mechant_sms_enabled']:'');
        
        $this->functions->updateOptionAdmin("mechant_sms_enabled",
        isset($this->data['mechant_sms_enabled'])?$this->data['mechant_sms_enabled']:'');
        
        $this->functions->updateOptionAdmin("sms_provider",
        isset($this->data['sms_provider'])?$this->data['sms_provider']:'');
        
        $this->functions->updateOptionAdmin("nexmo_sender_id",
        isset($this->data['nexmo_sender_id'])?$this->data['nexmo_sender_id']:'');
        
        $this->functions->updateOptionAdmin("nexmo_key",
        isset($this->data['nexmo_key'])?$this->data['nexmo_key']:'');
        
        $this->functions->updateOptionAdmin("nexmo_secret",
        isset($this->data['nexmo_secret'])?$this->data['nexmo_secret']:'');
        
        $this->functions->updateOptionAdmin("nexmo_use_curl",
        isset($this->data['nexmo_use_curl'])?$this->data['nexmo_use_curl']:'');
        
        $this->functions->updateOptionAdmin("privatesms_username",
        isset($this->data['privatesms_username'])?$this->data['privatesms_username']:'');
        
        $this->functions->updateOptionAdmin("privatesms_password",
        isset($this->data['privatesms_password'])?$this->data['privatesms_password']:'');
        
        $this->functions->updateOptionAdmin("privatesms_sender",
        isset($this->data['privatesms_sender'])?$this->data['privatesms_sender']:'');
        
        $this->functions->updateOptionAdmin("clickatel_user",
        isset($this->data['clickatel_user'])?$this->data['clickatel_user']:'');
        
        $this->functions->updateOptionAdmin("clickatel_password",
        isset($this->data['clickatel_password'])?$this->data['clickatel_password']:'');
        
        $this->functions->updateOptionAdmin("clickatel_api_id",
        isset($this->data['clickatel_api_id'])?$this->data['clickatel_api_id']:'');
                
        $this->functions->updateOptionAdmin("clickatel_use_curl",
        isset($this->data['clickatel_use_curl'])?$this->data['clickatel_use_curl']:'');
        
        $this->functions->updateOptionAdmin("nexmo_use_unicode",
        isset($this->data['nexmo_use_unicode'])?$this->data['nexmo_use_unicode']:'');
        
        $this->functions->updateOptionAdmin("clickatel_use_unicode",
        isset($this->data['clickatel_use_unicode'])?$this->data['clickatel_use_unicode']:'');
        
        $this->functions->updateOptionAdmin("clickatel_sender",
        isset($this->data['clickatel_sender'])?$this->data['clickatel_sender']:'');
        
        $this->functions->updateOptionAdmin("mechant_sms_purchase_disabled",
        isset($this->data['mechant_sms_purchase_disabled'])?$this->data['mechant_sms_purchase_disabled']:'');
        
        /*$this->functions->updateOptionAdmin("mechant_sms_use_admin_credits",
        isset($this->data['mechant_sms_use_admin_credits'])?$this->data['mechant_sms_use_admin_credits']:'');*/
        
        
        $this->functions->updateOptionAdmin("bhashsms_user",
        isset($this->data['bhashsms_user'])?$this->data['bhashsms_user']:'');
        
        $this->functions->updateOptionAdmin("bhashsms_pass",
        isset($this->data['bhashsms_pass'])?$this->data['bhashsms_pass']:'');
        
        $this->functions->updateOptionAdmin("bhashsms_senderid",
        isset($this->data['bhashsms_senderid'])?$this->data['bhashsms_senderid']:'');
        
        $this->functions->updateOptionAdmin("bhashsms_smstype",
        isset($this->data['bhashsms_smstype'])?$this->data['bhashsms_smstype']:'');
        
        $this->functions->updateOptionAdmin("bhashsms_priority",
        isset($this->data['bhashsms_priority'])?$this->data['bhashsms_priority']:'');
        
        $this->functions->updateOptionAdmin("bhashsms_use_curl",
        isset($this->data['bhashsms_use_curl'])?$this->data['bhashsms_use_curl']:'');
        
        $this->functions->updateOptionAdmin("smsglobal_senderid",
        isset($this->data['smsglobal_senderid'])?$this->data['smsglobal_senderid']:'');
        
        $this->functions->updateOptionAdmin("smsglobal_username",
        isset($this->data['smsglobal_username'])?$this->data['smsglobal_username']:'');
        
        $this->functions->updateOptionAdmin("smsglobal_password",
        isset($this->data['smsglobal_password'])?$this->data['smsglobal_password']:'');
        
        $this->functions->updateOptionAdmin("swift_accountkey",
        isset($this->data['swift_accountkey'])?$this->data['swift_accountkey']:'');
        
        $this->functions->updateOptionAdmin("swift_usecurl",
        isset($this->data['swift_usecurl'])?$this->data['swift_usecurl']:'');
        
        $this->functions->updateOptionAdmin("solutionsinfini_apikey",
        isset($this->data['solutionsinfini_apikey'])?$this->data['solutionsinfini_apikey']:'');
        
        $this->functions->updateOptionAdmin("solutionsinfini_usecurl",
        isset($this->data['solutionsinfini_usecurl'])?$this->data['solutionsinfini_usecurl']:'');
        
        $this->functions->updateOptionAdmin("solutionsinfini_useunicode",
        isset($this->data['solutionsinfini_useunicode'])?$this->data['solutionsinfini_useunicode']:'');
        
        $this->functions->updateOptionAdmin("solutionsinfini_sender",
        isset($this->data['solutionsinfini_sender'])?$this->data['solutionsinfini_sender']:'');
        
        
        $this->functions->updateOptionAdmin("plivo_auth_id",
        isset($this->data['plivo_auth_id'])?$this->data['plivo_auth_id']:'');
        
        $this->functions->updateOptionAdmin("plivo_auth_token",
        isset($this->data['plivo_auth_token'])?$this->data['plivo_auth_token']:'');
        
        $this->functions->updateOptionAdmin("plivo_sender_number",
        isset($this->data['plivo_sender_number'])?$this->data['plivo_sender_number']:'');
        
        $this->functions->updateOptionAdmin("msg91_authkey",
        isset($this->data['msg91_authkey'])?$this->data['msg91_authkey']:'');
        
        $this->functions->updateOptionAdmin("msg91_senderid",
        isset($this->data['msg91_senderid'])?$this->data['msg91_senderid']:'');
        
        $this->functions->updateOptionAdmin("msg91_unicode",
        isset($this->data['msg91_unicode'])?$this->data['msg91_unicode']:'');
        
        $this->functions->updateOptionAdmin("msg91_route",
        isset($this->data['msg91_route'])?$this->data['msg91_route']:'');
        
        
        
        $this->functions->updateOptionAdmin("spothit_apikey",
        isset($this->data['spothit_apikey'])?trim($this->data['spothit_apikey']):'');
        
        $this->functions->updateOptionAdmin("spothit_sms_type",
        isset($this->data['spothit_sms_type'])?$this->data['spothit_sms_type']:'');
        
        $this->functions->updateOptionAdmin("spothit_sender",
        isset($this->data['spothit_sender'])?$this->data['spothit_sender']:'');
        
        $this->functions->updateOptionAdmin("spothit_truncated",
        isset($this->data['spothit_truncated'])?$this->data['spothit_truncated']:'');
        
        $this->functions->updateOptionAdmin("spothit_use_curl",
        isset($this->data['spothit_use_curl'])?$this->data['spothit_use_curl']:'');
        
        
        /*libonet*/
        $this->functions->updateOptionAdmin("libonet_username",
        isset($this->data['libonet_username'])?$this->data['libonet_username']:'');       
        $this->functions->updateOptionAdmin("libonet_password",
        isset($this->data['libonet_password'])?$this->data['libonet_password']:'');
        $this->functions->updateOptionAdmin("libonet_sender",
        isset($this->data['libonet_sender'])?$this->data['libonet_sender']:'');
        $this->functions->updateOptionAdmin("libonet_use_unicode",
        isset($this->data['libonet_use_unicode'])?$this->data['libonet_use_unicode']:'');
        $this->functions->updateOptionAdmin("libonet_use_curl",
        isset($this->data['libonet_use_curl'])?$this->data['libonet_use_curl']:'');
        
        /*hubtel*/
        $this->functions->updateOptionAdmin("hubtel_username",
        isset($this->data['hubtel_username'])?$this->data['hubtel_username']:'');
        $this->functions->updateOptionAdmin("hubtel_password",
        isset($this->data['hubtel_password'])?$this->data['hubtel_password']:'');
        $this->functions->updateOptionAdmin("hubtel_sender",
        isset($this->data['hubtel_sender'])?$this->data['hubtel_sender']:'');
        $this->functions->updateOptionAdmin("hubtel_flashmessage",
        isset($this->data['hubtel_flashmessage'])?$this->data['hubtel_flashmessage']:'');
        
        
        /*infobip*/
        $this->functions->updateOptionAdmin("infobip_username",
        isset($this->data['infobip_username'])?$this->data['infobip_username']:'');
        
        $this->functions->updateOptionAdmin("infobip_password",
        isset($this->data['infobip_password'])?$this->data['infobip_password']:'');
        
        $this->functions->updateOptionAdmin("infobip_senderid",
        isset($this->data['infobip_senderid'])?$this->data['infobip_senderid']:'');
        
        $this->functions->updateOptionAdmin("infobip_use_curl",
        isset($this->data['infobip_use_curl'])?$this->data['infobip_use_curl']:'');
        
        $this->functions->updateOptionAdmin("infobip_use_unicode",
        isset($this->data['infobip_use_unicode'])?$this->data['infobip_use_unicode']:'');
        
        /*clickatel*/
        $this->functions->updateOptionAdmin("clickatel_api_key",
        isset($this->data['clickatel_api_key'])?$this->data['clickatel_api_key']:'');
        
        
        /*gramma sms*/
        $this->functions->updateOptionAdmin("gramma_apikey",
        isset($this->data['gramma_apikey'])?$this->data['gramma_apikey']:'');
        
        $this->functions->updateOptionAdmin("gramma_senderid",
        isset($this->data['gramma_senderid'])?$this->data['gramma_senderid']:'');
        
        $this->functions->updateOptionAdmin("gramma_sending_type",
        isset($this->data['gramma_sending_type'])?$this->data['gramma_sending_type']:'');
        
        $this->functions->updateOptionAdmin("gramma_use_curl",
        isset($this->data['gramma_use_curl'])?$this->data['gramma_use_curl']:'');
        
        
        /*saudisms*/
        $this->functions->updateOptionAdmin("saudisms_username",
        isset($this->data['saudisms_username'])?$this->data['saudisms_username']:'');
        
        $this->functions->updateOptionAdmin("saudisms_password",
        isset($this->data['saudisms_password'])?$this->data['saudisms_password']:'');
        
        $this->functions->updateOptionAdmin("saudisms_sender",
        isset($this->data['saudisms_sender'])?$this->data['saudisms_sender']:'');
        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");
    } 


public function salesReport()
{
    $aColumns = array(
        'order_id', 'client_name', 'contact_phone', 'item', 'trans_type',
        'payment_type', 'sub_total', 'taxable_total', 'total_w_tax', 'status',
        'request_from', 'date_created', 'order_id'
    );

    $sWhere = '';
    $sOrder = '';
    $sLimit = '';

    $t = $this->functions->ajaxDataTables($aColumns);
    if (is_array($t) && count($t) >= 1) {
        $sWhere = $t['sWhere'];
        $sOrder = $t['sOrder'];
        $sLimit = $t['sLimit'];
    }

    $and = '';
    if (isset($this->data['start_date']) && isset($this->data['end_date'])) {
        if (!empty($this->data['start_date']) && !empty($this->data['end_date'])) {
            $and = " AND date_created BETWEEN '" . ($this->data['start_date'] . " 00:00:00") . "' AND '" .
                ($this->data['end_date'] . " 23:59:59") . "'";
        }
    }

    $order_status_id = '';
    if (isset($this->data['stats_id'])) {
        if (is_array($this->data['stats_id']) && count($this->data['stats_id']) >= 1) {
            foreach ($this->data['stats_id'] as $stats_id) {
                $order_status_id .= "'$stats_id',";
            }
            if (!empty($order_status_id)) {
                $order_status_id = substr($order_status_id, 0, -1);
            }
        }
    }

    if (!empty($order_status_id)) {
        $and .= " AND status IN ($order_status_id)";
    }

    $merchant_id = $this->functions->getMerchantID();

    $select = '';

    $stmt = "SELECT SQL_CALC_FOUND_ROWS 
            order_id, trans_type, payment_type, sub_total, taxable_total, total_w_tax, a.status,
            a.date_created, admin_viewed, request_from,
            
            (SELECT CONCAT(first_name, ' ', last_name)
            FROM mt_client
            WHERE client_id = a.client_id) AS client_name,
            
            (SELECT CONCAT(first_name, ' ', last_name)
            FROM mt_order_delivery_address
            WHERE order_id = a.order_id
            LIMIT 0, 1) AS customer_name,
            
            (SELECT contact_phone
            FROM mt_order_delivery_address
            WHERE order_id = a.order_id) AS contact_phone,
            
            (SELECT GROUP_CONCAT(item_name)
            FROM mt_order_details
            WHERE order_id = a.order_id) AS item
            
            $select
            
            FROM mt_order a
            WHERE merchant_id = $merchant_id
            AND status NOT IN ('initial_order')
            $and
            $sOrder
            $sLimit";

    // Capture export statement for session
    $pos = strpos($stmt,"LIMIT");
    if ($pos !== false) {
       
    // Store the substring up to the position of "LIMIT"
    
    $_SESSION['kr_export_stmt'] = $stmt;
} else {
    // If "LIMIT" is not found, store the full statement
    
    $_SESSION['kr_export_stmt'] = $stmt;
}



    $query = $this->db->query($stmt);
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {


        $iTotalRecords = 0;

        // Get total records count
        $stmt2 = "SELECT FOUND_ROWS()";
        $query2 = $this->db->query($stmt2);
        if ($res2 = $query2->fetch(PDO::FETCH_ASSOC)) {
            $iTotalRecords = $res2['FOUND_ROWS()'];
        }

        $feed_data['sEcho'] = intval($_GET['sEcho']);
        $feed_data['iTotalRecords'] = $iTotalRecords;
        $feed_data['iTotalDisplayRecords'] = $iTotalRecords;

        foreach ($res as $val) {
            $action = "<a data-id=\"" . $val['order_id'] . "\" class=\"edit-order\" href=\"javascript:\">" . $this->functions->translation("default", "Edit") . "</a>";
            $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"view-receipt\" href=\"javascript:\">" . $this->functions->translation("default", "View") . "</a>";
            $action .= "<a data-id=\"" . $val['order_id'] . "\" class=\"view-order-history\" href=\"javascript:\">" . $this->functions->translation("default", "History") . "</a>";

            $date = $this->functions->FormatDateTime($val['date_created']);

            // Custom code 3 starts
            $tr_type = $this->functions->prettyPaymentType('payment_order', $val['payment_type'], $val['order_id'], $val['trans_type']);
            // sop payment
            if ($val['is_sop'] == '1' && $val['trans_type'] == 'pickup') {
                $tr_type = $val['payment_type'] = 'Swipe on Pickup';
            }
            // Custom code 3 ends

            if (!empty(trim($val['customer_name']))) {
                $val['client_name'] = $val['customer_name'];
            }

            $feed_data['aaData'][] = array(
                $val['order_id'],
                stripslashes($val['client_name']),
                $val['contact_phone'],
                $val['item'],
                $val['trans_type'],
                $tr_type,
                $this->functions->formatNumber($val['sub_total']),
                $this->functions->formatNumber($val['taxable_total'], $merchant_id),
                $this->functions->formatNumber($val['total_w_tax'], $merchant_id),
                "<span class=\"tag " . $val['status'] . "\">" . $val['status'] . "</span>",
                $val['request_from'],
                $date,
                $action
            );
        }

        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}










  public function windcaveSettings()
        {       

            $merchant_id = $this->functions->getMerchantID();
            
           
            
            $this->functions->updateOption("windcave_mode",
            isset($this->data['windcave_mode'])?$this->data['windcave_mode']:''
            ,$merchant_id);
            
            $this->functions->updateOption("wind_user_id",
            isset($this->data['wind_user_id'])?$this->data['wind_user_id']:''
            ,$merchant_id);
            
            $this->functions->updateOption("wind_key",
            isset($this->data['wind_key'])?$this->data['wind_key']:''
            ,$merchant_id);

            $this->functions->updateOption("merchant_windcave_card_fee",
            isset($this->data['merchant_windcave_card_fee'])?$this->data['merchant_windcave_card_fee']:''
            ,$merchant_id);



            $this->functions->updateOption("wind_user_id_sandbox",
            isset($this->data['wind_user_id_sandbox'])?$this->data['wind_user_id_sandbox']:''
            ,$merchant_id);
            
            $this->functions->updateOption("wind_key_sandbox",
            isset($this->data['wind_key_sandbox'])?$this->data['wind_key_sandbox']:''
            ,$merchant_id);
            
            
            
            
        
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved.");
        }


        public function windcaveSettings_admin()
        {       

            

            
              $this->functions->updateOptionAdmin("windcave_mode",
        isset($this->data['windcave_mode'])?$this->data['windcave_mode']:'');

        $this->functions->updateOptionAdmin("wind_user_id_sandbox",
        isset($this->data['wind_user_id_sandbox'])?$this->data['wind_user_id_sandbox']:'');

        $this->functions->updateOptionAdmin("wind_key_sandbox",
        isset($this->data['wind_key_sandbox'])?$this->data['wind_key_sandbox']:'');


         $this->functions->updateOptionAdmin("admin_windcave_card_fee",
        isset($this->data['admin_windcave_card_fee'])?$this->data['admin_windcave_card_fee']:'');




        $this->functions->updateOptionAdmin("wind_user_id",
        isset($this->data['wind_user_id'])?$this->data['wind_user_id']:'');
        
        $this->functions->updateOptionAdmin("wind_key",
        isset($this->data['wind_key'])?$this->data['wind_key']:'');
        
        $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");
        }





          public function windcaveSettings_pos()
        {       

            $merchant_id = $this->functions->getMerchantID();
            if(isset($merchant_id)){

            }else{
                $merchant_id=0;
            }

            $this->functions->updateOption("windcave_pos_enabled",
            isset($this->data['windcave_pos_enabled'])?$this->data['windcave_pos_enabled']:''
            ,$merchant_id);
            
            $this->functions->updateOption("windcave_mode_pos",
            isset($this->data['windcave_mode_pos'])?$this->data['windcave_mode_pos']:''
            ,$merchant_id);
            
            $this->functions->updateOption("wind_user_id_pos",
            isset($this->data['wind_user_id_pos'])?$this->data['wind_user_id_pos']:''
            ,$merchant_id);
            
            $this->functions->updateOption("wind_key_pos",
            isset($this->data['wind_key_pos'])?$this->data['wind_key_pos']:''
            ,$merchant_id);
            
            $this->functions->updateOption("wind_station_pos",
            isset($this->data['wind_station_pos'])?$this->data['wind_station_pos']:''
            ,$merchant_id);
            
            $this->functions->updateOption("wind_cur_pos",
            isset($this->data['wind_cur_pos'])?$this->data['wind_cur_pos']:''
            ,$merchant_id);
            
            
        
            $this->code=1;
            $this->msg=$this->functions->translation("default","Settings saved.");
        }


            public function saveCODSettings()
    {       
        $merchant_id=$this->functions->getMerchantID();
        
        $this->functions->updateOption("merchant_disabled_cod",
        isset($this->data['merchant_disabled_cod'])?$this->data['merchant_disabled_cod']:'',$merchant_id);
        
        $this->functions->updateOption("cod_change_required_merchant",
        isset($this->data['cod_change_required_merchant'])?$this->data['cod_change_required_merchant']:'',$merchant_id);

        $this->code=1;
        $this->msg=$this->functions->translation("default","Settings saved.");    
    }


        public function merchantPaypalV2Settings()
    {
        $mtid = $this->functions->getMerchantID();
        if($mtid<=0){
           $this->msg = $this->functions->translation("default","ERROR: Your session has expired.");
           return ; 
        }
        
        $this->functions->updateOption("merchant_paypal_v2_enabled",
        isset($this->data['merchant_paypal_v2_enabled'])?$this->data['merchant_paypal_v2_enabled']:'',$mtid);  
        
        $this->functions->updateOption("merchant_paypal_v2_mode",
        isset($this->data['merchant_paypal_v2_mode'])?$this->data['merchant_paypal_v2_mode']:'',$mtid);  
        
        $this->functions->updateOption("merchant_paypal_v2_card_fee",
        isset($this->data['merchant_paypal_v2_card_fee'])?$this->data['merchant_paypal_v2_card_fee']:'',$mtid);  
        
        $this->functions->updateOption("merchant_paypal_v2_client_id",
        isset($this->data['merchant_paypal_v2_client_id'])?$this->data['merchant_paypal_v2_client_id']:'',$mtid);  
        
        $this->functions->updateOption("merchant_paypal_v2_secret",
        isset($this->data['merchant_paypal_v2_secret'])?$this->data['merchant_paypal_v2_secret']:'',$mtid);  
        
        $this->code = 1;
        $this->msg = $this->functions->translation("default","Setting saved");    
    }






      public function sortItem()
      {       
      
        if ( isset($this->data['table']) && isset($this->data['sort_field'])){
          if (!empty($this->data['table']) && is_array($this->data['sort_field'])){
            $tbl=$this->data['table'];
            if (is_array($this->data['sort_field']) && count($this->data['sort_field'])>=1){
              $x=1;
              foreach ($this->data['sort_field'] as $item_id) {
                $params=array(
                 'sequence'=>$x
                );                
                $this->functions->updateData("{$tbl}",$params,$this->data['whereid'],$item_id);
                $x++;
              }
              $this->code=1;
              $this->msg=$this->functions->translation("default","Sort saved.");
            } else $this->msg=$this->functions->translation("default","Missing parameters");
          } else $this->msg=$this->functions->translation("default","Missing parameters");
        } else $this->msg=$this->functions->translation("default","Missing parameters");
      } 
    






            public function newmerchantreglist()
        {
            
            $datenow = date('Y-m-d') . '%';

            $stmt = $this->db->prepare("
                SELECT a.*,
                (
                    SELECT title 
                    FROM mt_packages 
                    WHERE package_id = a.package_id
                ) AS package_name,
                
                (
                    SELECT payment_type
                    FROM mt_package_trans
                    WHERE merchant_id = a.merchant_id
                    ORDER BY id DESC
                    LIMIT 1
                ) AS payment_type,
                
                (
                    SELECT id
                    FROM mt_package_trans
                    WHERE merchant_id = a.merchant_id
                    ORDER BY id DESC
                    LIMIT 1
                ) AS package_trans_id
                
                FROM mt_merchant a
                WHERE date_created LIKE :datenow
            ");

            $stmt->bindValue(':datenow', $datenow, PDO::PARAM_STR);
            $stmt->execute();

            $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if ($res){              
                foreach ($res as $val) {                   
                   $action="<a data-id=\"".$val['merchant_id']."\" class=\"edit-merchant-status\" href=\"javascript:\">".$this->functions->translation("default","Edit")."</a>";
                   $feed_data['aaData'][]=array(
                      $val['merchant_id'],
                      stripslashes($val['restaurant_name']),
                      $val['package_name'],
                      
                      $this->functions->formatNumber($val['package_price']),                   
                      $this->functions->prettyPaymentType('package_trans',$val['payment_type'],$val['package_trans_id']),
                      "<span class=\"tag ".$val['status']."\">".($val['status'])."</span>",                      
                      $this->functions->FormatDateTime($val['date_created'],true),
                      $action
                   );   
                }               
                $this->otableOutput($feed_data);
            }           
            $this->otableNodata();
        }  

        public function otableOutput($feed_data='')
        {
          echo json_encode($feed_data);
          die();
        }
        public function otableNodata()
        {
            if (isset($_GET['sEcho'])){
                $feed_data['sEcho']=$_GET['sEcho'];
            } else $feed_data['sEcho']=1;      
                 
            $feed_data['iTotalRecords']=0;
            $feed_data['iTotalDisplayRecords']=0;
            $feed_data['aaData']=array();       
            echo json_encode($feed_data);
            die();
        }




}
?>
