<script type="text/javascript" src="https://js.stripe.com/v3/"></script>

<div class="sections section-grey2 section-orangeform">
    <div class="container">
        <div class="row top30">
            <div class="inner1">
                <h1><?php echo $this->functions->translation("default", "Pay using Stripe Payment") ?></h1>

                <div class="rounded">

                  <table class="table">
 <tr>
 <tr>
   <td><?php echo $this->functions->translation("default","Description")?></td>
   <td><?php echo $payment_description?></td> 
 </tr>
 <?php if($fee>0.001):?>
  <tr>
   <td><?php echo $this->functions->translation("default","Card Fee")?></td>
   <td><?php echo $this->functions->formatNumber($fee)?></td> 
 </tr>
 
 <tr>
  <td><?php echo $this->functions->translation("default","Amount")?></td>
  <td><?php echo $this->functions->formatNumber( ($amount)-$fee  )?></td>
 </tr> 
 
 <tr>
  <td><?php echo $this->functions->translation("default","Total")?></td>
  <td><?php echo $this->functions->formatNumber( ($amount))?></td>
 </tr> 
 
 <?php else :?>
 
 <tr>
  <td><?php echo $this->functions->translation("default","Total")?></td>
  <td><?php echo $this->functions->formatNumber($amount)?></td>
 </tr> 
 
 
 <?php endif;?> 

</table>





                    <form id="payment-form">
                        <div class="form-row">
                            <label for="card-element">
                                <?php echo $this->functions->translation("default", "Card details") ?>
                            </label>
                            <div id="card-element">
                                <!-- A Stripe Element will be inserted here. -->
                            </div>
                            <!-- Used to display form errors. -->
                            <div id="card-errors" role="alert" style="color:red;"></div>
                        </div>
                        <button id="submit" class="btn paynowss_stripe" style="background: green;
    color: white;
    margin-top: 10px;">
                            <?php echo $this->functions->translation("default", "Pay Now") ?>
                        </button>
                    </form>

                    <div class="top25">
                        <a href="<?php echo Config::$baseUrl; ?>/merchant/purchasesms">
                            <i class="ion-ios-arrow-thin-left"></i> 
                            <?php echo $this->functions->translation("default", "Click here to change payment option")?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>




<script>
    var stripe = Stripe("<?php echo $publish_key; ?>"); // Replace with your own Stripe publishable key
    var elements = stripe.elements();

    var style = {
    base: {
        color: "#32325d",
        lineHeight: "24px",
        fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
        fontSmoothing: "antialiased",
        fontSize: "16px",
        backgroundColor: "antiquewhite", // Set the background color to antiquewhite
        "::placeholder": {
            color: "#aab7c4"
        }
    },
    invalid: {
        color: "#fa755a",
        iconColor: "#fa755a"
    }
};

    var card = elements.create("card", {hidePostalCode: true, style: style });
    card.mount("#card-element");

    var form = document.getElementById('payment-form');
    form.addEventListener('submit', function(event) {
        event.preventDefault();

        stripe.createPaymentMethod({
            type: 'card',
            card: card,
            billing_details: {
                name: 'Test User' // You can replace this with dynamic user info
            }
        }).then(function(result) {
            if (result.error) {
                // Show error in #card-errors
                var errorElement = document.getElementById('card-errors');
                errorElement.textContent = result.error.message;
            } else {
                // Send payment method ID to server
                stripeTokenHandler(result.paymentMethod.id);
            }
        });
    });

    function stripeTokenHandler(paymentMethodId) {
        // Create a form to send the token to your server
        var form = document.createElement('form');

        var trans_type = '<?php echo $trans_type; ?>';
        var reference_id = '<?php echo $reference_id; ?>';

        form.method = 'GET';
        form.action = '<?php echo Config::$baseUrl; ?>/merchant/stripe_success?reference_id='+reference_id+"&trans_type="+trans_type; // Server endpoint

        

        // Hidden field for trans_type
    var hiddenFieldTransType = document.createElement('input');
    hiddenFieldTransType.type = 'hidden';
    hiddenFieldTransType.name = 'trans_type';
    hiddenFieldTransType.value = trans_type;
    form.appendChild(hiddenFieldTransType);

    // Hidden field for reference_id
    var hiddenFieldReferenceId = document.createElement('input');
    hiddenFieldReferenceId.type = 'hidden';
    hiddenFieldReferenceId.name = 'reference_id';
    hiddenFieldReferenceId.value = reference_id;
    form.appendChild(hiddenFieldReferenceId);


        
        document.body.appendChild(form);
        form.submit();
    }
</script>
