<?php
$merchant_id=$this->functions->getMerchantID();
$merchant_currency=$this->functions->getOption("merchant_currency",$merchant_id);
$merchant_decimal=$this->functions->getOption("merchant_decimal",$merchant_id);
$merchant_use_separators=$this->functions->getOption("merchant_use_separators",$merchant_id);
$merchant_minimum_order=$this->functions->getOption("merchant_minimum_order",$merchant_id);
$merchant_tax=$this->functions->getOption("merchant_tax",$merchant_id);
$merchant_delivery_charges=$this->functions->getOption("merchant_delivery_charges",$merchant_id);
$stores_open_day=$this->functions->getOption("stores_open_day",$merchant_id);

$stores_open_pickups=$this->functions->getOption("stores_pickup_day",$merchant_id);
$stores_open_pickups_2=$this->functions->getOption("stores_pickup_day_2",$merchant_id);
$stores_open_del=$this->functions->getOption("stores_del_day",$merchant_id);
$stores_open_del_2=$this->functions->getOption("stores_del_day_2",$merchant_id);
$stores_open_dine=$this->functions->getOption("stores_dine_day",$merchant_id);
$stores_open_dine_2=$this->functions->getOption("stores_dine_day_2",$merchant_id);

$stores_open_starts=$this->functions->getOption("stores_open_starts",$merchant_id);
$stores_open_ends=$this->functions->getOption("stores_open_ends",$merchant_id);
$stores_open_custom_text=$this->functions->getOption("stores_open_custom_text",$merchant_id);

$stores_open_pickups=!empty($stores_open_pickups)?(array)json_decode($stores_open_pickups):false;
$stores_open_pickups_2=!empty($stores_open_pickups_2)?(array)json_decode($stores_open_pickups_2):false;
$stores_open_del=!empty($stores_open_del)?(array)json_decode($stores_open_del):false;
$stores_open_del_2=!empty($stores_open_del_2)?(array)json_decode($stores_open_del_2):false;
$stores_open_dine=!empty($stores_open_dine)?(array)json_decode($stores_open_dine):false;
$stores_open_dine_2=!empty($stores_open_dine_2)?(array)json_decode($stores_open_dine_2):false;

$stores_open_day=!empty($stores_open_day)?(array)json_decode($stores_open_day):false;

//print_r($stores_open_day);die();

$stores_open_starts=!empty($stores_open_starts)?(array)json_decode($stores_open_starts):false;
$stores_open_ends=!empty($stores_open_ends)?(array)json_decode($stores_open_ends):false;
$stores_open_custom_text=!empty($stores_open_custom_text)?(array)json_decode($stores_open_custom_text):false;

$merchant_recaptcha_site_key=$this->functions->getOption("merchant_recaptcha_site_key",$merchant_id);
$merchant_recaptcha_secret_key=$this->functions->getOption("merchant_recaptcha_secret_key",$merchant_id);
$merchant_google_tag=$this->functions->getOption("merchant_google_tag",$merchant_id);
$merchant_google_tag_event_snippet=$this->functions->getOption("merchant_google_tag_event_snippet",$merchant_id);

$book_now_url=$this->functions->getOption("book_now_url",$merchant_id);
$about_us_url=$this->functions->getOption("about_us_url",$merchant_id);
$contact_url=$this->functions->getOption("contact_url",$merchant_id);
$ios_appstore_url=$this->functions->getOption("ios_appstore_url",$merchant_id);
$google_playstore_url=$this->functions->getOption("google_playstore_url",$merchant_id);

$merchant_photo=$this->functions->getOption("merchant_photo",$merchant_id);
$merchant_delivery_estimation=$this->functions->getOption("merchant_delivery_estimation",$merchant_id);
$merchant_delivery_charges_type=$this->functions->getOption("merchant_delivery_charges_type",$merchant_id);

$merchant_photo_bg=$this->functions->getOption("merchant_photo_bg",$merchant_id);

$merchant_extenal=$this->functions->getOption("merchant_extenal",$merchant_id);
$merchant_maximum_order=$this->functions->getOption("merchant_maximum_order",$merchant_id);

$merchant_switch_master_cod=$this->functions->getOption("merchant_switch_master_cod",$merchant_id);
$merchant_switch_master_ccr=$this->functions->getOption("merchant_switch_master_ccr",$merchant_id);

$merchant_minimum_order_pickup=$this->functions->getOption("merchant_minimum_order_pickup",$merchant_id);
$merchant_maximum_order_pickup=$this->functions->getOption("merchant_maximum_order_pickup",$merchant_id);

$merchant_cart_note=$this->functions->getOption("merchant_cart_note",$merchant_id);



$stores_open_pm_start=$this->functions->getOption("stores_open_pm_start",$merchant_id);
$stores_open_pm_start=!empty($stores_open_pm_start)?(array)json_decode($stores_open_pm_start):false;

$stores_open_pm_ends=$this->functions->getOption("stores_open_pm_ends",$merchant_id);
$stores_open_pm_ends=!empty($stores_open_pm_ends)?(array)json_decode($stores_open_pm_ends):false;


$tips_list=$this->functions->tipsList(true);

$merchant_info=(array)$this->functions->getMerchantInfo();


?>

<div id="error-message-wrapper"></div>

<form class="uk-form uk-form-horizontal forms" id="forms">
<input type="hidden" name="action" id="action" value="merchantSettings">




<!--Merchant Logo-->
<div class="uk-form-row"> 
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Merchant Logo")?></label>
  <a href="javascript:;" id="sau_merchant_upload_file" 
   class="button uk-button" data-progress="sau_merchant_progress" data-preview="image_preview" data-field="photo">
    <?php echo $this->functions->translation("default","Browse")?>
  </a>
</div>
<div class="sau_merchant_progress"></div>

<div class="image_preview">
    <?php 
    $image = $merchant_photo;
    $image_url = $this->functions->getImage($image); 
    if (!empty($image_url)) {
        echo '<img src="' . $image_url . '" class="uk-thumbnail" id="logo-small" />';
        // Hidden input field
        echo '<input type="hidden" name="photo" id="photo" value="' . $image . '">';
        echo '<br />';
        // Remove link
        echo '<a href="javascript:;" class="sau_remove_file" data-preview="image_preview">Remove image</a>';
    }
    ?>
</div>


<div class="spacer"></div>

<!--END Merchant Logo-->

<!--HEADER BG-->

<div class="uk-form-row"> 
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Merchant Header/Background")?></label>
  <a href="javascript:;" id="single_uploadfile" 
   class="button uk-button" data-progress="single_uploadfile_progress" data-preview="single_uploadfile_preview" data-field="photo2">
    <?php echo $this->functions->translation("default","Browse")?>
  </a>
</div>
<div class="single_uploadfile_progress"></div>

<div class="single_uploadfile_preview">
    <?php 
    $image = $merchant_photo_bg;

    
    $image_url = $this->functions->getImage($image); 
    if (!empty($image_url)) {
        echo '<img src="' . $image_url . '" class="uk-thumbnail" id="logo-small" />';
        // Hidden input field
        echo '<input type="hidden" name="photo2" id="photo2" value="' . $image . '">';
        echo '<br />';
        // Remove link
        echo '<a href="javascript:;" class="single_uploadfile_remove" data-preview="image_preview">Remove image</a>';
    }
    ?>
</div>


<div class="spacer"></div>

<!--END HEADER BG-->

<hr/>


  
<?php if ( $this->functions->getOptionAdmin('mechant_sms_enabled')==""):?>
<h2><?php echo $this->functions->translation("default","Order Options")?></h2>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "Enabled Order SMS Verification") ?></label>  
  <input type="checkbox" name="order_verification" id="order_verification" class="icheck" value="2" 
  <?php echo $this->functions->getOption('order_verification', $merchant_id) == 2 ? 'checked' : '' ?>>
</div>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default", "Customer can request sms code every") ?></label>  
  <input type="text" name="order_sms_code_waiting" id="order_sms_code_waiting" value="<?php echo $this->functions->getOption( 'order_sms_code_waiting',$merchant_id) ?>" class="numeric_only">
  <span>(<?php echo $this->functions->translation("default", "Minutes") ?>) <?php echo $this->functions->translation("default", "default is 5 minutes") ?></span>
</div>


<hr/>
<?php endif;?>

<!-- Custom link starts
 <div class="uk-form-row ">
     <h2><?php echo $this->functions->translation("default","Custom Links")?></h2>
  <div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Book Now Url") ?></label>
    <input type="text" name="book_now_url" value="<?php echo $book_now_url ?>" placeholder="<?php echo $this->functions->translation("default", "https://www.book-now.com") ?>">
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "About Us Url") ?></label>
    <input type="text" name="about_us_url" value="<?php echo $about_us_url ?>" placeholder="<?php echo $this->functions->translation("default", "https://www.about-us.com") ?>">
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Contact Us Url") ?></label>
    <input type="text" name="contact_url" value="<?php echo $contact_url ?>" placeholder="<?php echo $this->functions->translation("default", "https://www.contact-us.com") ?>">
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "iOS Appstore Url") ?></label>
    <input type="text" name="ios_appstore_url" value="<?php echo $ios_appstore_url ?>" placeholder="<?php echo $this->functions->translation("default", "https://www.iosapplink.com") ?>">
</div>

        
        <div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Google playstore Url") ?></label>
    <input type="text" name="google_playstore_url" value="<?php echo $google_playstore_url ?>" placeholder="<?php echo $this->functions->translation("default", "https://www.googleplaystorelink.com") ?>">
</div>

</div>
<!-- Custom link ends -->

<!-- Custom code 11 starts -->


<!-- <h2><?php echo $this->functions->translation("default","Slots Options")?></h2>

<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "No of slots") ?>
  </label>  
  <input 
    type="number" 
    name="number_of_slots" 
    id="number_of_slots" 
    value="<?php echo $this->functions->getOption('number_of_slots',$merchant_id) ?>" 
    class="numeric_only" 
    min="1">
</div>


<div class="uk-form-row">
  <label class="uk-form-label">
    <?php echo $this->functions->translation("default", "Persons/Party") ?>
  </label>  
  <input 
    type="number" 
    name="party_size" 
    id="party_size" 
    value="<?php echo $this->functions->getOption('party_size', $merchant_id) ?>" 
    class="numeric_only"
    min="1" 
    max="10"
  >
</div>


<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Choose Duration") ?></label>
    <select name="google_merchant_duration">
        <option value="1800" <?php echo $this->functions->getOption( 'google_merchant_duration',$merchant_id) == 1800 ? 'selected' : '' ?>>
            <?php echo $this->functions->translation("default", "30 minutes") ?>
        </option>
        <option value="3600" <?php echo $this->functions->getOption( 'google_merchant_duration',$merchant_id) == 3600 ? 'selected' : '' ?>>
            <?php echo $this->functions->translation("default", "60 minutes") ?>
        </option>
    </select>
</div> -->



<h2><?php echo $this->functions->translation("default","Print Options")?></h2>
<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Enabled Auto Print") ?></label>  
    <input type="checkbox" name="auto_print" class="icheck" value="1" 
    <?php echo $this->functions->getOption('auto_print', $merchant_id) == 1 ? 'checked' : '' ?>>
</div>

<!-- Custom code 11 ends -->

<!-- Custom code 12 starts -->
<h2><?php echo $this->functions->translation("default","Car Park Delivery")?></h2>
<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Enabled Car park Pickup for Customers") ?></label>  
    <input type="checkbox" name="car_parking_enable" class="icheck" value="1" 
    <?php echo $this->functions->getOption('car_parking_enable', $merchant_id) == 1 ? 'checked' : '' ?>>
</div>

 <!-- Custom code 12 ends -->
 <!---
 <div class="uk-form-row">
     <h2><?php echo $this->functions->translation("default","Google reCAPTCHA Key")?></h2>
    <div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Site key") ?></label>
    <input type="text" name="merchant_recaptcha_site_key" value="<?php echo $merchant_recaptcha_site_key ?>" placeholder="<?php echo $this->functions->translation("default", "site key from google") ?>">
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Secret Key") ?></label>
    <input type="text" name="merchant_recaptcha_secret_key" value="<?php echo $merchant_recaptcha_secret_key ?>" placeholder="<?php echo $this->functions->translation("default", "secret key from google") ?>">
</div>

<h2><?php echo $this->functions->translation("default", "Google tag") ?></h2>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Add the Google Tag from ads.google.com") ?></label>
    <input type="text" name="merchant_google_tag" value="<?php echo $merchant_google_tag ?>" placeholder="<?php echo $this->functions->translation("default", "Google tag from google ads") ?>">
</div>

                   <h2><?php echo $this->functions->translation("default","Google Tag: Event snippet on the conversion page")?></h2>
    <div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Do not include script open and close tag") ?></label>
    <textarea name="merchant_google_tag_event_snippet" placeholder="<?php echo $this->functions->translation("default", "Event snippet on the conversion page") ?>"><?php echo $merchant_google_tag_event_snippet ?></textarea>
</div>

</div>-->
 
<h2><?php echo $this->functions->translation("default","Food Item Options")?></h2>

<h5><?php echo $this->functions->translation("default","If item is not available do the following actions")?></h5>
<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Hide") ?></label>
    <input type="radio" name="food_option_not_available" class="icheck" value="1" 
    <?php echo $this->functions->getOption('food_option_not_available', $merchant_id) == 1 ? 'checked' : '' ?>>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Disabled") ?></label>
    <input type="radio" name="food_option_not_available" class="icheck" value="2" 
    <?php echo $this->functions->getOption('food_option_not_available', $merchant_id) == 2 ? 'checked' : '' ?>>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Disabled food gallery") ?></label>
    <input type="checkbox" name="disabled_food_gallery" class="icheck" value="2" 
    <?php echo $this->functions->getOption('disabled_food_gallery', $merchant_id) == 2 ? 'checked' : '' ?>>
</div>


<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Make menu private") ?></label>
    <input type="checkbox" name="food_viewing_private" class="icheck" value="2" 
    <?php echo $this->functions->getOption('food_viewing_private', $merchant_id) == 2 ? 'checked' : '' ?>>
    
    <p class="uk-text-muted">
        <?php echo $this->functions->translation("default", "you can use this when you don't want to show yet your menu in front end") ?>.<br/>
        <?php echo $this->functions->translation("default", "to preview the menu in front end") ?> 
        <a target="_blank" 
    href="<?php echo Config::$baseUrl; ?>/menu/<?php echo trim($merchant_info[0]->restaurant_slug); ?>/preview/true/token/<?php echo md5($merchant_info[0]->password); ?>">
    <?php echo $this->functions->translation("default", "click here"); ?>
</a>

    </p>

    
</div>



<hr/>

<h2><?php echo $this->functions->translation("default","Two Flavor Options")?></h2>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Choose option") ?></label>
    <select name="merchant_two_flavor_option">
        <option value="1" <?php echo $this->functions->getOption( 'merchant_two_flavor_option',$merchant_id) == 1 ? 'selected' : '' ?>>
            <?php echo $this->functions->translation("default", "Highest price") ?>
        </option>
        <option value="2" <?php echo $this->functions->getOption( 'merchant_two_flavor_option',$merchant_id) == 2 ? 'selected' : '' ?>>
            <?php echo $this->functions->translation("default", "Sumup and divided by 2") ?>
        </option>
    </select>
</div>



<hr/>

<!--MENU OPTIONS SETTINGS FOR MERCHANT-->
<?php if ($this->functions->getOptionAdmin('admin_menu_allowed_merchant')==2):?>
<h2><?php echo $this->functions->translation("default","Menu Options")?></h2>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Default Menu") ?></label>
    <input type="radio" name="merchant_activated_menu" value="3" class="icheck"
    <?php echo $this->functions->getOption("merchant_activated_menu", $merchant_id) == "3" ? 'checked' : '' ?>>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Activate Menu 1") ?></label>
    <input type="radio" name="merchant_activated_menu" value="1" class="icheck"
    <?php echo $this->functions->getOption("merchant_activated_menu", $merchant_id) == "1" ? 'checked' : '' ?>>
</div>


<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Activate Menu 2") ?></label>
    <input type="radio" name="merchant_activated_menu" value="2" class="icheck"
    <?php echo $this->functions->getOption("merchant_activated_menu", $merchant_id) == "2" ? 'checked' : '' ?>>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Show Category Image") ?></label>
    <input type="checkbox" name="merchant_show_category_image" value="1" class="icheck"
    <?php echo $this->functions->getOption( 'merchant_show_category_image',$merchant_id) == 1 ? 'checked' : '' ?>>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Enabled lazyload") ?></label>
    <input type="checkbox" name="merchant_menu_lazyload" value="1" class="icheck"
    <?php echo $this->functions->getOption( 'merchant_menu_lazyload',$merchant_id) == 1 ? 'checked' : '' ?>>
</div>


<hr/>
<?php endif;?>
<!--MENU OPTIONS SETTINGS FOR MERCHANT-->

<h2><?php echo $this->functions->translation("default","Receipt Options")?></h2>


<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Tax number") ?></label>
    <input type="text" name="merchant_tax_number" value="<?php echo htmlspecialchars($this->functions->getOption('merchant_tax_number',$merchant_id)) ?>" 
           class="uk-width-1-4" maxlength="30">
</div>


<hr/>

<h2><?php echo $this->functions->translation("default","Printing Options")?></h2>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Receipt Width") ?></label>
    <input type="text" name="printing_receipt_width" value="<?php echo htmlspecialchars($this->functions->getOption('printing_receipt_width',$merchant_id)) ?>" 
           class="numeric_only">
    <span><?php echo $this->functions->translation("default", "px") ?></span>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Font size") ?></label>
    <input type="text" name="printing_receipt_size" value="<?php echo htmlspecialchars($this->functions->getOption( 'printing_receipt_size',$merchant_id)) ?>" 
           class="numeric_only">
    <span><?php echo $this->functions->translation("default", "px") ?></span>
</div>


<hr>

<h2><?php echo $this->functions->translation("default","Free Delivery Options")?></h2>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Free delivery above Sub Total Order") ?></label>
    <input type="text" name="free_delivery_above_price" value="<?php echo htmlspecialchars($this->functions->getOption('free_delivery_above_price',$merchant_id)) ?>" 
           class="numeric_only">
    <span style="padding-left:8px;"><?php echo $this->functions->adminCurrencySymbol(); ?></span>
</div>

<hr>

<h2><?php echo $this->functions->translation("default", "Merchant Open/Close") ?></h2>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Close Store") ?>?</label>
    <input type="checkbox" name="merchant_close_store" value="yes" class="icheck"
    <?php echo $this->functions->getOption('merchant_close_store', $merchant_id) == "yes" ? 'checked' : '' ?>>
</div>


<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Show Merchant Current Time") ?>?</label>
    <input type="checkbox" name="merchant_show_time" value="yes" class="icheck"
    <?php echo $this->functions->getOption('merchant_show_time', $merchant_id) == "yes" ? 'checked' : '' ?>>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Disabled Ordering") ?>?</label>
    <input type="checkbox" name="merchant_disabled_ordering" value="yes" class="icheck"
    <?php echo $this->functions->getOption('merchant_disabled_ordering', $merchant_id) == "yes" ? 'checked' : '' ?>>
</div>

  

<h3><?php echo $this->functions->translation("default","External Website")?></h3>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Website address") ?></label>
    <input type="text" name="merchant_extenal" value="<?php echo htmlspecialchars($merchant_extenal) ?>" class="uk-width-1-2">
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Enabled Voucher") ?>?</label>
    <input type="checkbox" name="merchant_enabled_voucher" value="yes" class="icheck"
    <?php echo $this->functions->getOption("merchant_enabled_voucher", $merchant_id) == "yes" ? 'checked' : '' ?>>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Make Delivery Time Required") ?>?</label>
    <input type="checkbox" name="merchant_required_delivery_time" value="yes" class="icheck"
    <?php echo $this->functions->getOption("merchant_required_delivery_time", $merchant_id) == "yes" ? 'checked' : '' ?>>
</div>




<h3><?php echo $this->functions->translation("default","Minimum Order")?> <?php echo $this->functions->translation("default","Delivery")?></h3>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Minimum purchase amount.") ?></label>
    <input type="text" name="merchant_minimum_order" value="<?php echo htmlspecialchars($merchant_minimum_order) ?>" class="numeric_only">
    <?php echo $this->functions->getCurrencyCode($this->functions->getMerchantID()); ?>
</div>

<h3><?php echo $this->functions->translation("default", "Maximum Order") ?> <?php echo $this->functions->translation("default", "Delivery") ?></h3>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Maximum purchase amount") ?></label>
    <input type="text" name="merchant_maximum_order" value="<?php echo htmlspecialchars($merchant_maximum_order) ?>" class="numeric_only">
    <?php echo $this->functions->getCurrencyCode($this->functions->getMerchantID()); ?>
</div>


<h3><?php echo $this->functions->translation("default","Minimum Order")?> <?php echo $this->functions->translation("default","Pickup")?></h3>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Minimum purchase amount.") ?></label>
    <input type="text" name="merchant_minimum_order_pickup" value="<?php echo htmlspecialchars($merchant_minimum_order_pickup) ?>" class="numeric_only">
    <?php echo $this->functions->getCurrencyCode($this->functions->getMerchantID()); ?>
</div>

<h3><?php echo $this->functions->translation("default", "Maximum Order") ?> <?php echo $this->functions->translation("default", "Pickup") ?></h3>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Maximum purchase amount.") ?></label>
    <input type="text" name="merchant_maximum_order_pickup" value="<?php echo htmlspecialchars($merchant_maximum_order_pickup) ?>" class="numeric_only">
    <?php echo $this->functions->getCurrencyCode($this->functions->getMerchantID()); ?>
</div>


<h3><?php echo $this->functions->translation("default","Dine in")?></h3>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Minimum purchase amount.") ?></label>
    <input type="text" name="merchant_minimum_order_dinein" value="<?php echo htmlspecialchars($this->functions->getOption( 'merchant_minimum_order_dinein',$merchant_id)) ?>" class="numeric_only">
    <?php echo $this->functions->getCurrencyCode($this->functions->getMerchantID()); ?>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Maximum purchase amount.") ?></label>
    <input type="text" name="merchant_maximum_order_dinein" value="<?php echo htmlspecialchars($this->functions->getOption( 'merchant_maximum_order_dinein',$merchant_id)) ?>" class="numeric_only">
    <?php echo $this->functions->getCurrencyCode($this->functions->getMerchantID()); ?>
</div>



<h3><?php echo $this->functions->translation("default","Packaging Charge")?></h3>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Enabled Packaging Wise") ?></label>
    <input type="checkbox" name="merchant_packaging_wise" id="merchant_packaging_wise" value="1" 
        <?php echo ($this->functions->getOption("merchant_packaging_wise", $merchant_id) == 1) ? 'checked' : '' ?> 
        class="icheck">
</div>


<p class="uk-text-muted"><?php echo $this->functions->translation("default","When this is enabled packaging charge will be use is what you set in food item")?></p>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Packaging Charge") ?></label>
    <input type="text" name="merchant_packaging_charge" id="merchant_packaging_charge" value="<?php echo $this->functions->getOption("merchant_packaging_charge", $merchant_id) ?>" class="numeric_only">
    <?php echo $this->functions->getCurrencyCode($this->functions->getMerchantID()); ?>
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Packaging Incremental") ?></label>
    <input type="checkbox" name="merchant_packaging_increment" id="merchant_packaging_increment" value="2" 
        <?php echo ($this->functions->getOption("merchant_packaging_increment", $merchant_id) == 2) ? 'checked' : '' ?> 
        class="icheck">
</div>


<h3><?php echo $this->functions->translation("default","Surcharge (Tax) & Delivery Charges")?></h3>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Surcharge") ?></label>
    <input type="text" name="merchant_tax" id="merchant_tax" value="<?php echo $merchant_tax ?>" class="numeric_only">%
</div>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Apply Tax to Food Item") ?></label>
    <input type="checkbox" name="merchant_apply_tax" id="merchant_apply_tax" value="1" 
        <?php echo ($this->functions->getOption( 'merchant_apply_tax',$merchant_id) == 1) ? 'checked' : '' ?>>
    <p class="uk-text-muted"><?php echo $this->functions->translation("default", "This will use the Euro tax computation") ?></p>
</div>


<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Delivery Charges") ?></label>
    <input type="text" name="merchant_delivery_charges" id="merchant_delivery_charges" value="<?php echo $merchant_delivery_charges ?>" class="numeric_only">
    
</div>



<?php if ( $this->functions->enabledExtraCharges()):?>
<hr>

<h3><?php echo $this->functions->translation("default","Extra Delivery Charges")?></h3>

<?php 
$extra_charge_start_time = $this->functions->getOption($merchant_id,'extra_charge_start_time');
$extra_charge_end_time=''; $extra_charge_fee='';
if(!empty($extra_charge_start_time)){
   $extra_charge_start_time = json_decode($extra_charge_start_time,true);
   $extra_charge_end_time = json_decode($this->functions->getOption($merchant_id,'extra_charge_end_time'),true);
   $extra_charge_fee = json_decode($this->functions->getOption($merchant_id,'extra_charge_fee'),true);
}  
?>

<?php if(!is_array($extra_charge_start_time) && count($extra_charge_start_time)<=1):?>
<div class="time_applicable_row">
<div class="uk-form-row time_applicable_rows">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Time Applicable") ?></label>
    
    <input type="text" name="extra_charge_start_time[]" value="" style="width:100px" class="timepick" placeholder="<?php echo $this->functions->translation("default", "Start") ?>">
    
    <span><?php echo $this->functions->translation("default", "To") ?></span>
    
    <input type="text" name="extra_charge_end_time[]" value="" style="width:100px" class="timepick" placeholder="<?php echo $this->functions->translation("default", "End") ?>">
    
    <input type="text" name="extra_charge_fee[]" value="" style="width:100px" class="numeric_only" placeholder="<?php echo $this->functions->translation("default", "Fee") ?>">
    
    <a href="javascript:;" class="extra_charge_add_new_row">
        <i class="fa fa-plus-square"></i>
    </a>
</div>
   
</div> <!--time_applicable_row-->
<?php endif;?>

<div class="more_charge_row">  
  <?php if(is_array($extra_charge_start_time) && count($extra_charge_start_time)>=1):?>
  
  <?php $x_counter=0; //dump($extra_charge_start_time); dump($extra_charge_fee);?>
  <?php foreach ($extra_charge_start_time as $keyx=>$valx): //dump($keyx);?>
  <div class="uk-form-row time_applicable_rows">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Time Applicable") ?></label>
    
    <input type="text" name="extra_charge_start_time[<?php echo $x_counter ?>]" value="<?php echo htmlspecialchars($valx) ?>" style="width:100px" class="timepick" placeholder="<?php echo $this->functions->translation("default", "Start") ?>">
    
    <span><?php echo $this->functions->translation("default", "To") ?></span>
    
    <input type="text" name="extra_charge_end_time[<?php echo $x_counter ?>]" value="<?php echo htmlspecialchars(isset($extra_charge_end_time[$keyx]) ? $extra_charge_end_time[$keyx] : '') ?>" style="width:100px" class="timepick" placeholder="<?php echo $this->functions->translation("default", "End") ?>">
    
    <input type="text" name="extra_charge_fee[]" value="<?php echo htmlspecialchars(isset($extra_charge_fee[$keyx]) ? $extra_charge_fee[$keyx] : '') ?>" style="width:100px" class="numeric_only" placeholder="<?php echo $this->functions->translation("default", "Fee") ?>">
    
    <a href="javascript:;" class="<?php echo $x_counter == 0 ? "extra_charge_add_new_row" : "remove_charge_row" ?>">
        <i class="fa <?php echo $x_counter == 0 ? "fa-plus-square" : "fa-minus-square" ?>"></i>
    </a>
</div>

	<?php $x_counter++;?>
	<?php endforeach;?>
  
  <?php endif;?>
</div> <!--more_charge_row-->



<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Extra Charge Notification") ?></label>
    <textarea name="extra_charge_notification" placeholder="" class="uk-form-width-large"><?php echo htmlspecialchars($this->functions->getOption($merchant_id, 'extra_charge_notification')) ?></textarea>
</div>



<hr>
<?php endif;?>

<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default", "Do not apply tax to delivery charges") ?></label>
    <input type="checkbox" name="merchant_tax_charges" value="2" class="icheck" <?php echo $this->functions->getOption("merchant_tax_charges", $merchant_id) == 2 ? 'checked' : '' ?> />
</div>


<?php if(!$this->functions->isMerchantCommission($merchant_id)):?>
<hr>
<h3><?php echo $this->functions->translation("default","Service fee")?></h3>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Service fee")?></label>
  <input type="text" name="merchant_service_fee" 
         value="<?php echo htmlspecialchars($this->functions->getOption($merchant_id, 'merchant_service_fee'), ENT_QUOTES, 'UTF-8'); ?>" 
         class="numeric_only" />
</div>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Do not apply tax to service fee")?></label>
  <input type="checkbox" name="merchant_service_fee_applytax" 
         value="1" 
         <?php echo $this->functions->getOption("merchant_service_fee_applytax", $merchant_id) == 1 ? 'checked' : ''; ?> 
         class="icheck" />
</div>

<?php endif;?>

<hr>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Enabled Opt in for no contact delivery")?></label>
  <input type="checkbox" name="merchant_opt_contact_delivery" 
         value="1" 
         <?php echo $this->functions->getOption("merchant_opt_contact_delivery", $merchant_id) == 1 ? 'checked' : ''; ?> 
         class="icheck" />
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Delivery Estimation")?></label>
  <input type="text" name="merchant_delivery_estimation" 
         value="<?php echo htmlspecialchars($merchant_delivery_estimation); ?>" 
         placeholder="<?php echo htmlspecialchars($this->functions->translation("default","1 hour approx.")); ?>" />
</div>


<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Delivery Distance Covered")?></label>
  <input type="text" name="merchant_delivery_miles" 
         value="<?php echo htmlspecialchars($this->functions->getOption("merchant_delivery_miles", $merchant_id)); ?>" 
         class="numeric_only" 
         placeholder="" />
  
  <select name="merchant_distance_type">
    <?php 
    foreach ($this->functions->distanceOption() as $value => $label) {
      $selected = ($value == $this->functions->getOption("merchant_distance_type", $merchant_id)) ? 'selected' : '';
      echo "<option value=\"$value\" $selected>$label</option>";
    }
    ?>
  </select>
</div>

<p class="uk-text-muted"><?php echo $this->functions->translation("default","Leave the fields empty to not check the distance")?></p>


<h3><?php echo $this->functions->translation("default","Tracking initial estimation")?></h3>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Delivery")?></label>
  
  <input type="text" name="tracking_estimation_delivery1" 
         value="<?php echo htmlspecialchars($this->functions->getOption( 'tracking_estimation_delivery1',$merchant_id)); ?>" 
         placeholder="<?php echo htmlspecialchars($this->functions->translation("default","in minutes")); ?>" 
         class="numeric_only" />
  
  <span><?php echo $this->functions->translation("default","To")?></span>
  
  <input type="text" name="tracking_estimation_delivery2" 
         value="<?php echo htmlspecialchars($this->functions->getOption( 'tracking_estimation_delivery2',$merchant_id)); ?>" 
         placeholder="<?php echo htmlspecialchars($this->functions->translation("default","in minutes")); ?>" 
         class="numeric_only" />
</div>



<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Pickup")?></label>
  
  <input type="text" name="tracking_estimation_pickup1" 
         value="<?php echo htmlspecialchars($this->functions->getOption('tracking_estimation_pickup1',$merchant_id)); ?>" 
         placeholder="<?php echo htmlspecialchars($this->functions->translation("default","in minutes")); ?>" 
         class="numeric_only" />
  
  <span><?php echo $this->functions->translation("default","To")?></span>
  
  <input type="text" name="tracking_estimation_pickup2" 
         value="<?php echo htmlspecialchars($this->functions->getOption( 'tracking_estimation_pickup2',$merchant_id)); ?>" 
         placeholder="<?php echo htmlspecialchars($this->functions->translation("default","in minutes")); ?>" 
         class="numeric_only" />
</div>



<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Dinein")?></label>
  
  <input type="text" name="tracking_estimation_dinein1" 
         value="<?php echo htmlspecialchars($this->functions->getOption( 'tracking_estimation_dinein1',$merchant_id)); ?>" 
         placeholder="<?php echo htmlspecialchars($this->functions->translation("default","in minutes")); ?>" 
         class="numeric_only" />
  
  <span><?php echo $this->functions->translation("default","To")?></span>
  
  <input type="text" name="tracking_estimation_dinein2" 
         value="<?php echo htmlspecialchars($this->functions->getOption( 'tracking_estimation_dinein2',$merchant_id)); ?>" 
         placeholder="<?php echo htmlspecialchars($this->functions->translation("default","in minutes")); ?>" 
         class="numeric_only" />
</div>

<h3 style="display:none;"><?php echo $this->functions->translation("default","Tips")?></h3>

<div class="uk-form-row" style="display:none;">
  <label class="uk-form-label">Enabled?</label>
  
  <input type="checkbox" name="merchant_enabled_tip" 
         <?php echo $this->functions->getOption("merchant_enabled_tip", $merchant_id) == 2 ? 'checked' : ''; ?> 
         class="icheck" 
         value="2" />
</div>



<div class="uk-form-row" style="display:none;">
  <label class="uk-form-label">Default Tip</label>
  <select name="merchant_tip_default">
    <?php foreach ((array)$tips_list as $value => $label): ?>
      <option value="<?php echo htmlspecialchars($value); ?>" <?php echo $this->functions->getOption("merchant_tip_default", $merchant_id) == $value ? 'selected' : ''; ?>>
        <?php echo htmlspecialchars($label); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>



<?php $days=$this->functions->getDays();?>
<h3><?php echo $this->functions->translation("default","Store Hours")?></h3>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Time Zone"); ?></label>
  <select name="merchant_timezone">
    <?php foreach ($this->functions->timezoneList() as $value => $label): ?>
      <option value="<?php echo htmlspecialchars($value); ?>" <?php echo $this->functions->getOption("merchant_timezone", $merchant_id) == $value ? 'selected' : ''; ?>>
        <?php echo htmlspecialchars($label); ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>



<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Pickup Time picker list interval"); ?></label>
  <input type="tel" 
         name="website_merchant_time_picker_interval" 
         value="<?php echo htmlspecialchars($this->functions->getOption('website_merchant_time_picker_interval',$merchant_id)); ?>" 
         class="numeric_only" 
         placeholder="default is 15mins" />
</div>



<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Delivery Time picker list interval"); ?></label>
  <input type="tel" 
         name="website_delivery_merchant_time_picker_interval" 
         value="<?php echo htmlspecialchars($this->functions->getOption( 'website_delivery_merchant_time_picker_interval',$merchant_id)); ?>" 
         class="numeric_only" 
         placeholder="default is 15mins" />
</div>

<div class="uk-form-row">
  <label class="uk-form-label"><?php echo $this->functions->translation("default","Cart Note (Under delivery info)"); ?></label>
  


<textarea name="merchant_cart_note" class="uk-form-width-large" placeholder=""><?php echo htmlspecialchars(trim($merchant_cart_note)); ?></textarea>

</div>



<div class="uk-form-row">
  <label class="uk-form-label">
  <?php echo $this->functions->translation("default","Store days(s) Open:")?>  
  </label>  
  <div class="clear"></div>
  <p class="uk-text-muted"><?php echo $this->functions->translation("default","If days has not been selected then merchant will be set to open")?></p>
  <ul class="uk-list uk-list-striped">
  <?php foreach ($days as $key=>$val):?>
  <li>
  <div class="uk-grid" >
  
    <div class="uk-width-1-6" style="width:5%;">
    <input type="checkbox" 
           name="stores_open_day[]" 
           value="<?php echo htmlspecialchars($key); ?>" 
           <?php echo in_array($key, (array)$stores_open_day) ? 'checked' : ''; ?> 
           class="icheck" />
</div>

    
    <div class="uk-width-1-6" style="width:8%"><?php echo ucwords($this->functions->translateDate($val));?></div>    
    <div class="uk-width-1-6" style="width:12%">
    <input type="text" 
           name="stores_open_starts[<?php echo htmlspecialchars($key); ?>]" 
           value="<?php echo htmlspecialchars(array_key_exists($key, (array)$stores_open_starts) ? $this->functions->timeFormat($stores_open_starts[$key], true) : ''); ?>" 
           placeholder="<?php echo htmlspecialchars($this->functions->translation('default', 'Start')); ?>" 
           class="timepick" />
</div>

    
    <div class="uk-width-1-6" style="width:5%;"><?php echo $this->functions->translation("default","To")?></div>
    <div class="uk-width-1-6" style="width:12%">
    <input type="text" 
           name="stores_open_ends[<?php echo htmlspecialchars($key); ?>]" 
           value="<?php echo htmlspecialchars(array_key_exists($key, (array)$stores_open_ends) ? $this->functions->timeFormat($stores_open_ends[$key], true) : ''); ?>" 
           placeholder="<?php echo htmlspecialchars($this->functions->translation('default', 'End')); ?>" 
           class="timepick" />
</div>


     <!-- waseem code starts -->
    <div class="uk-width-1-6" style="width:12%;">
    <div class="rowcustom">
      <div class="rowcustom1">
    <input type="checkbox" 
           name="stores_pickup_day[<?php echo htmlspecialchars($key); ?>]" 
           value="1" 
           <?php echo ($stores_open_pickups[$key] == 1) ? 'checked' : ''; ?> 
           class="icheck" />
</div>

      <div class="rowcustom1">
        Pickup
      </div>

    </div>

    <div class="rowcustom">
      <div class="rowcustom1">
    <input type="checkbox" 
           name="stores_del_day[<?php echo htmlspecialchars($key); ?>]" 
           value="1" 
           <?php echo ($stores_open_del[$key] == 1) ? 'checked' : ''; ?> 
           class="icheck" />
</div>

      <div class="rowcustom1">
        Delivery
      </div>

    </div>

    <div class="rowcustom">
      <div class="rowcustom1">
    <input type="checkbox" 
           name="stores_dine_day[<?php echo htmlspecialchars($key); ?>]" 
           value="1" 
           <?php echo ($stores_open_dine[$key] == 1) ? 'checked' : ''; ?> 
           class="icheck" />
</div>

      <div class="rowcustom1">
        Dinein
      </div>

    </div>
    </div>
<!-- waseem code ends -->


    

    
    <div class="uk-width-1-6" style="width:2%;">
    /
    </div>
        
    <div class="uk-width-1-6" style="width:9%">
    <input type="text" 
           name="stores_open_pm_start[<?php echo htmlspecialchars($key); ?>]" 
           placeholder="<?php echo htmlspecialchars($this->functions->translation("default", "Start")); ?>" 
           value="<?php echo htmlspecialchars(array_key_exists($key, (array)$stores_open_pm_start) ? $this->functions->timeFormat($stores_open_pm_start[$key], true) : ""); ?>" 
           class="timepick" />
</div>

    <div class="uk-width-1-6" style="width:2%;"><?php echo $this->functions->translation("default","To")?></div>
   <div class="uk-width-1-6" style="width:8%">
    <input type="text" 
           name="stores_open_pm_ends[<?php echo htmlspecialchars($key); ?>]" 
           placeholder="<?php echo htmlspecialchars($this->functions->translation("default", "End")); ?>" 
           value="<?php echo htmlspecialchars(array_key_exists($key, (array)$stores_open_pm_ends) ? $this->functions->timeFormat($stores_open_pm_ends[$key], true) : ""); ?>" 
           class="timepick" />
</div>

    
    <div class="uk-width-1-6" style="width:10%">
    <input type="text" 
           name="stores_open_custom_text[<?php echo htmlspecialchars($key); ?>]" 
           placeholder="<?php echo htmlspecialchars($this->functions->translation("default", "Custom text")); ?>" 
           value="<?php echo htmlspecialchars(array_key_exists($key, (array)$stores_open_custom_text) ? $stores_open_custom_text[$key] : ""); ?>" />
</div>


   <!-- waseem code starts -->
    <div class="uk-width-1-6" style="width:10%;">
    <div class="rowcustom">
      <div class="rowcustom1">
    <input type="checkbox" 
           name="stores_pickup_day_2[<?php echo htmlspecialchars($key); ?>]" 
           <?php echo ($stores_open_pickups_2[$key] == 1) ? 'checked' : ''; ?> 
           value="1" 
           class="icheck" />
</div>

      <div class="rowcustom1">
        Pickup
      </div>

    </div>

    <div class="rowcustom">
    <div class="rowcustom1">
        <input type="checkbox" 
               name="stores_del_day_2[<?php echo htmlspecialchars($key); ?>]" 
               <?php echo ($stores_open_del_2[$key] == 1) ? 'checked' : ''; ?> 
               value="1" 
               class="icheck" />
    </div>
    <div class="rowcustom1">
        Delivery
    </div>
</div>


   <div class="rowcustom">
    <div class="rowcustom1">
        <input type="checkbox" 
               name="stores_dine_day_2[<?php echo htmlspecialchars($key); ?>]" 
               <?php echo ($stores_open_dine_2[$key] == 1) ? 'checked' : ''; ?> 
               value="1" 
               class="icheck" />
    </div>
    <div class="rowcustom1">
        Dinein
    </div>
</div>

    </div>
<!-- waseem code ends -->



    



   </div>    
  </li>
  <?php endforeach;?>
  </ul>
</div>

<div class="uk-form-row">
    <label class="uk-form-label">
        <?php echo htmlspecialchars($this->functions->translation("default", "Accept Pre-orders")); ?>
    </label>
    <input type="checkbox" 
           name="merchant_preorder" 
           <?php echo ($this->functions->getOption("merchant_preorder", $merchant_id) == 1) ? 'checked' : ''; ?> 
           value="1" 
           class="icheck" />
</div>




<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default","Close Message")?></label>
    
    <textarea class="uk-form-width-large" name="merchant_close_msg" id="merchant_close_msg"><?php echo trim($this->functions->getOption("merchant_close_msg", $merchant_id)); ?></textarea>
</div>





<div class="uk-form-row">
<label class="uk-form-label"><?php echo $this->functions->translation("default","Holidays")?>:</label>

<div class="holiday_list">


<?php if ( $m_holiday=$this->functions->getMerchantHoliday($merchant_id)):?>
<?php foreach ($m_holiday as $m_h):?>
<div class="holiday_row">
    <input type="text" 
           name="merchant_holiday[]" 
           value="<?php echo htmlspecialchars($m_h); ?>" 
           class="j_date_normal small_date" />
    <a href="javascript:;" class="remove_holiday">
        <i class="fa fa-minus-square"></i>
    </a>
</div>

<?php endforeach;?>

<?php else:?>

<div class="holiday_row">
    <input type="text" 
           name="merchant_holiday[]" 
           value="" 
           class="j_date_normal small_date" />
</div>


<?php endif;?>

</div> <!--holiday_list-->

<a href="javascript:;" class="add_new_holiday"><i class="fa fa-plus-square"></i></a>

</div>


<div class="uk-form-row">
    <label class="uk-form-label"><?php echo $this->functions->translation("default","Holiday Close Message")?></label>
    
    <textarea class="uk-form-width-large" name="merchant_close_msg_holiday" id="merchant_close_msg_holiday"><?php echo trim($this->functions->getOption("merchant_close_msg_holiday", $merchant_id)); ?></textarea>
</div>




<div class="uk-form-row">
<label class="uk-form-label"></label>
<input type="submit" value="<?php echo $this->functions->translation("default","Save")?>" class="uk-button uk-form-width-medium uk-button-success">
</div>

</form>

<style>
  .rowcustom{
    float: left;
    width: 100%;
    display: flex;
    justify-content: center;
  }

  .rowcustom1{
    float: left;
    width: 30%;
    
  }


  
  .checkbox1{
    float: left;
    width: 100%;
  }
  .checkbox1left{
    float: left;
    width: 50%;
  }

  .checkbox1left span{
    font-size: 12px;
  }
</style>