<?php
$merchant_id = $this->functions->getMerchantID();
$startingDate = $this->functions->calculate_starting_date($merchant_id);
$startDate = new DateTime($startingDate);

// raw options
$stores_open_starts_raw   = $this->functions->getOption("stores_open_starts", $merchant_id);
$stores_open_ends_raw     = $this->functions->getOption("stores_open_ends", $merchant_id);
$stores_open_pm_start_raw = $this->functions->getOption("stores_open_pm_start", $merchant_id);
$stores_open_pm_ends_raw  = $this->functions->getOption("stores_open_pm_ends", $merchant_id);
$stores_open_day_raw      = $this->functions->getOption("stores_open_day", $merchant_id);

$number_of_slots = $this->functions->getOption("number_of_slots", $merchant_id);
$party_size      = $this->functions->getOption("party_size", $merchant_id);

if($party_size==""){
    $party_size=1;
}

if($number_of_slots==""){
    $number_of_slots=3;
}

// decode to arrays (use empty array instead of false to avoid isset warnings)
$stores_open_starts   = !empty($stores_open_starts_raw)   ? (array)json_decode($stores_open_starts_raw, true)   : [];
$stores_open_ends     = !empty($stores_open_ends_raw)     ? (array)json_decode($stores_open_ends_raw, true)     : [];
$stores_open_pm_start = !empty($stores_open_pm_start_raw) ? (array)json_decode($stores_open_pm_start_raw, true) : [];
$stores_open_pm_ends  = !empty($stores_open_pm_ends_raw)  ? (array)json_decode($stores_open_pm_ends_raw, true)  : [];
$stores_open_day      = !empty($stores_open_day_raw)      ? (array)json_decode($stores_open_day_raw, true)      : [];




// Convert PM times to 24-hour format
foreach ($stores_open_pm_start as $day => $time) {
    if (!empty($time)) {
        $stores_open_pm_start[$day] = date("H:i", strtotime($time));
    }
}

foreach ($stores_open_pm_ends as $day => $time) {
    if (!empty($time)) {
        $stores_open_pm_ends[$day] = date("H:i", strtotime($time));
    }
}



/**
 * Returns true if the array has at least one non-empty (trimmed) value.
 */
$hasNonEmptyValue = function($arr) {
    if (empty($arr) || !is_array($arr)) return false;
    foreach ($arr as $k => $v) {
        if (is_array($v)) {
            foreach ($v as $v2) {
                if (trim((string)$v2) !== '') return true;
            }
        } else {
            if (trim((string)$v) !== '') return true;
        }
    }
    return false;
};

// normalize stores_open_day to an array of lowercase day names (support both indexed array and associative)
$normalized_days = [];
if (is_array($stores_open_day)) {
    foreach ($stores_open_day as $k => $v) {
        // if key looks like a day (e.g., "monday" => 1), add key
        if (is_string($k) && trim($k) !== '') {
            $normalized_days[] = strtolower(trim($k));
        }
        // if value is a day string (e.g., ["monday","tuesday"]), add value
        if (is_string($v) && trim($v) !== '') {
            $normalized_days[] = strtolower(trim($v));
        }
    }
    // dedupe
    $normalized_days = array_unique($normalized_days);
}

$has_open_days = count($normalized_days) > 0;
$has_any_times = $hasNonEmptyValue($stores_open_starts)
              || $hasNonEmptyValue($stores_open_ends)
              || $hasNonEmptyValue($stores_open_pm_start)
              || $hasNonEmptyValue($stores_open_pm_ends);
?>

<div class="uk-width-1">
    <h3 style="margin-top:10px !important;"><?php echo ("Booking Availability for 7 Days") ?></h3>
    <a href="<?php echo Config::$baseUrl; ?>/merchant/bookings_list" class="uk-button">
        <i class="fa fa-list"></i> <?php echo $this->functions->translation("default", "List") ?>
    </a>
</div>

<div class="spacer"></div>

<div id="error-message-wrapper"></div>

<form class="uk-form uk-form-horizontal forms" id="forms" method="post">
    <input type="hidden" name="action" id="action" value="add_bookingslots">
    <input type="hidden" name="id" value="<?php echo isset($_GET['id']) ? htmlspecialchars($_GET['id'], ENT_QUOTES, 'UTF-8') : ''; ?>">
    <?php if (!isset($_GET['id'])): ?>
        <input type="hidden" name="redirect" id="redirect" value="<?php echo htmlspecialchars(Config::$baseUrl . "/merchant/bookings_list", ENT_QUOTES, 'UTF-8'); ?>">
    <?php endif; ?>

    <?php if (!$has_open_days): ?>
        <div style="color:red; font-weight:bold; margin:15px 0;">
    <?php 
        echo $this->functions->translation(
            "default", 
            'Please configure store opening days in <a href="'.Config::$baseUrl.'/merchant/settings" style="color:red; text-decoration:underline;">settings</a> first before creating booking slots.'
        ); 
    ?>
</div>


    <?php elseif (!$has_any_times): ?>
        <div style="color:red; font-weight:bold; margin:15px 0;">
    <?php 
        echo $this->functions->translation(
            "default", 
            'Please configure store opening times in <a href="'.Config::$baseUrl.'/merchant/settings" style="color:red; text-decoration:underline;">settings</a> first before creating booking slots.'
        ); 
    ?>
</div>


    <?php else: ?>

        <div style="color:red; font-weight:bold; margin:15px 0;">
    <?php 
        echo $this->functions->translation(
            "default", 
            'If Some days are unavailable. Please review your opening hours in <a href="'.Config::$baseUrl.'/merchant/settings" style="color:red; text-decoration:underline;">Merchant Settings</a> to correct this before creating booking slots.'
        ); 
    ?>
</div>



        <div style="overflow-x: auto;">
            <table class="uk-table uk-table-striped" style="width:100%; max-width:100%;">
                <thead>
                    <tr>
                        <th>Enable</th>
                        <th>Day</th>
                        <th>Date</th>
                        <th>Shift 1<br>Start</th>
                        <th>Shift 1<br>End</th>
                        <th>Shift 2<br>Start</th>
                        <th>Shift 2<br>End</th>
                        <th>Person / Party</th>
                        <th>No. of Slots</th>
                    </tr>
                </thead>
                <tbody>
                  <?php for ($i = 0; $i < 7; $i++): 
    $dateVal = $startDate->format('Y-m-d');
    $dayName = $startDate->format('l');   
    $dayKey  = strtolower($dayName);

    $shift1_start = isset($stores_open_starts[$dayKey]) ? trim($stores_open_starts[$dayKey]) : '';
    $shift1_end   = isset($stores_open_ends[$dayKey])   ? trim($stores_open_ends[$dayKey])   : '';
    $shift2_start = isset($stores_open_pm_start[$dayKey]) ? trim($stores_open_pm_start[$dayKey]) : '';
    $shift2_end   = isset($stores_open_pm_ends[$dayKey])   ? trim($stores_open_pm_ends[$dayKey])   : '';

    // --- Validation ---
    $hasShift1 = !empty($shift1_start) && !empty($shift1_end);
    $hasShift2 = !empty($shift2_start) && !empty($shift2_end);

    // check incomplete combos
    $incompleteShift1 = (!empty($shift1_start) && empty($shift1_end)) || (empty($shift1_start) && !empty($shift1_end));
    $incompleteShift2 = (!empty($shift2_start) && empty($shift2_end)) || (empty($shift2_start) && !empty($shift2_end));

    // check invalid order
    $invalidShift1 = ($hasShift1 && strtotime($shift1_start) >= strtotime($shift1_end));
    $invalidShift2 = ($hasShift2 && strtotime($shift2_start) >= strtotime($shift2_end));

    // allow enabling only if:
    // - the day is in normalized_days (available), AND
    // - at least one valid combo exists, AND
    // - no incomplete or invalid combos
    $canEnable = in_array($dayKey, $normalized_days) 
                 && ($hasShift1 || $hasShift2) 
                 && !$incompleteShift1 && !$incompleteShift2 
                 && !$invalidShift1 && !$invalidShift2;
?>
<tr>
    <td>
        <input type="checkbox" 
               name="enabled[<?php echo $i; ?>]" 
               value="1" 
               class="icheck" 
               readonly
               <?php echo $canEnable ? 'checked' : 'disabled'; ?>>
    </td>
    <td>
        <?php echo htmlspecialchars($dayName); ?>
        <input type="hidden" name="day_name[<?php echo $i; ?>]" value="<?php echo htmlspecialchars($dayName); ?>">
        <input type="hidden" name="original_day_enabled[<?php echo $i; ?>]" value="<?php echo ($hasShift1 || $hasShift2) ? '1' : '0'; ?>">
    </td>
    <td>
        <input type="text" name="date[<?php echo $i; ?>]" value="<?php echo $dateVal; ?>" readonly class="uk-form-width-small">
    </td>
    <td><input type="text" name="shift1_start[<?php echo $i; ?>]" class="uk-form-width-small" value="<?php echo $shift1_start; ?>" readonly></td>
    <td><input type="text" name="shift1_end[<?php echo $i; ?>]" class="uk-form-width-small" value="<?php echo $shift1_end; ?>" readonly></td>
    <td><input type="text" name="shift2_start[<?php echo $i; ?>]" class="uk-form-width-small" value="<?php echo $shift2_start; ?>" readonly></td>
    <td><input type="text" name="shift2_end[<?php echo $i; ?>]" class="uk-form-width-small" value="<?php echo $shift2_end; ?>" readonly></td>
    <td><input type="number" name="person_per_party[<?php echo $i; ?>]" min="1" value="<?php echo $party_size ?? 1; ?>" class="uk-form-width-small" readonly></td>
    <td><input type="number" name="no_of_slots[<?php echo $i; ?>]" min="1" value="<?php echo $number_of_slots ?? 1; ?>" class="uk-form-width-small" readonly></td>
</tr>
<?php 
    $startDate->modify('+1 day');
endfor; ?>


                </tbody>
            </table>
        </div>

        <div class="spacer"></div>

        <div class="uk-form-row">
            <label class="uk-form-label"></label>
            <input type="submit" value="<?php echo $this->functions->translation("default", "Save") ?>" class="uk-button uk-form-width-medium uk-button-success">
        </div>

    <?php endif; ?>
</form>

<style>
.uk-form-width-small {
    width: 100px !important;
    margin-bottom: 5px;
}
</style>
