<?php
$merchant_id=$data['merchant_id'];
$order_status_list=$data['order_status_list'];
?>

<form method="post">

<input type="hidden" name="merchant_id" id="merchant_id" value="<?php echo $data['merchant_id']; ?>">

<input type="hidden" 
       name="singleapp_default_image" 
       id="singleapp_default_image" 
       class="singleapp_default_image" 
       value="<?php echo $this->functions->getOption('singleapp_default_image', $data['merchant_id']); ?>">


<div class="row">

  <div class="col-md-5">
  <div class="form-group">
    <label><?php echo "App Default Language"; ?></label>

    <select name="singleapp_default_lang" id="singleapp_default_lang" class="form-control">
      <?php 
        $selectedLang = $this->functions->getOption('singleapp_default_lang', $merchant_id);
        $languages = (array)$this->functions->getLanguageList(true);

        foreach ($languages as $key => $value): 
      ?>
        <option value="<?php echo $key; ?>" <?php echo ($key == $selectedLang) ? 'selected' : ''; ?>>
          <?php echo $value; ?>
        </option>
      <?php endforeach; ?>
    </select>

    <p class="text-muted small"><?php echo "Force default language"; ?></p>
  </div>
</div>

  
<div class="col-md-5">	
  <div class="form-group">
    <label><?php echo "Location Accuracy"; ?></label>

    <select name="singleapp_location_accuracy" id="singleapp_location_accuracy" class="form-control">
      <?php 
        $selectedAccuracy = $this->functions->getOption('singleapp_location_accuracy', $merchant_id);
        $accuracyOptions = $this->SingleAppClass->locationAccuracyList();

        foreach ($accuracyOptions as $key => $value): 
      ?>
        <option value="<?php echo $key; ?>" <?php echo ($key == $selectedAccuracy) ? 'selected' : ''; ?>>
          <?php echo $value; ?>
        </option>
      <?php endforeach; ?>
    </select>
    
  </div>     
</div>

  
</div> <!--row-->

<p class="between_div"><b><?php echo ("RTL Options")?></b></p>

<div class="row">
  <div class="col-md-3">
  <?php echo $this->htmlWrapper->checkbox('singleapp_rtl','',"Enabled", $this->functions->getOption('singleapp_rtl',$merchant_id) );?>
  </div> <!--col-->
</div>

<p class="between_div"><b><?php echo ("Registration Options")?></b></p>

<div class="row">
  <div class="col-md-12">
    <select name="singleapp_prefix" id="singleapp_prefix" class="form-control">
      <?php 
        $selectedPrefix = $this->functions->getOption('singleapp_prefix', $merchant_id);
        $prefixList = (array)$this->SingleAppClass->mobileCodeList();

        foreach ($prefixList as $key => $value): 
      ?>
        <option value="<?php echo $key; ?>" <?php echo ($key == $selectedPrefix) ? 'selected' : ''; ?>>
          <?php echo $value; ?>
        </option>
      <?php endforeach; ?>
    </select>

    <small class="form-text text-muted">
      <?php echo "Default Phone Prefix"; ?>
    </small>
  </div> 
</div> <!-- row -->


<div class="row pt-4"> 
  <div class="col-md-3">
  <?php echo $this->htmlWrapper->checkbox('singleapp_remove_phone_prefix','',"Turn off mobile prefix", $this->functions->getOption('singleapp_remove_phone_prefix',$merchant_id) );?>
  </div> <!--col-->
  <div class="col-md-3">
  <?php echo $this->htmlWrapper->checkbox('singleapp_reg_email','',"Customer Register via Email", $this->functions->getOption('singleapp_reg_email',$merchant_id) );?>
  </div> <!--col-->
  <div class="col-md-3">
  <?php echo $this->htmlWrapper->checkbox('singleapp_reg_phone','',"Customer Register via Phone", $this->functions->getOption('singleapp_reg_phone',$merchant_id) );?> 
  </div> <!--col-->  
</div> <!--row-->



<p class="between_div"><b><?php echo ("Menu/List Style")?></b></p>

<div class="row">
  <div class="col-md-12">
    <div class="form-group">
      <label><?php echo "Menu Type"; ?></label>        

      <select name="singleapp_menu_type" id="singleapp_menu_type" class="form-control">
        <?php 
          $selectedMenuType = $this->functions->getOption('singleapp_menu_type', $merchant_id);
          $menuTypes = $this->SingleAppClass->MenuType();

          foreach ($menuTypes as $key => $value): 
        ?>
          <option value="<?php echo $key; ?>" <?php echo ($key == $selectedMenuType) ? 'selected' : ''; ?>>
            <?php echo $value; ?>
          </option>
        <?php endforeach; ?>
      </select>

    </div>   
  </div> <!--col-->      
</div> <!--row-->


<div class="row pt-3">
  <div class="col-md-4">
  <?php echo $this->htmlWrapper->checkbox('singleapp_disabled_default_menu','',"Disabled Default Image", $this->functions->getOption('singleapp_disabled_default_menu',$merchant_id) );?> 
  </div> <!--col-->  
  
  <div class="col-md-4">
  <?php echo $this->htmlWrapper->checkbox('singleapp_enabled_addon_desc','',"Show Addon Description", $this->functions->getOption('singleapp_enabled_addon_desc',$merchant_id) );?> 
  </div> <!--col-->  
  
</div> 
<!--row-->


<p class="between_div"><b><?php echo ("Customer Order History")?></b></p>

<div class="row">
	<div class="col-md-4">
  <p><?php echo "Processing"; ?></p>
  <?php 
    unset($order_status_list[0]);
    $selectedProcessing = (array) json_decode($this->functions->getOption('singleapp_order_processing', $merchant_id));
  ?>
  <select name="singleapp_order_processing[]" id="singleapp_order_processing" class="form-control chosen" multiple="multiple">
    <?php foreach ((array)$order_status_list as $key => $value): ?>
      <option value="<?php echo $key; ?>" <?php echo in_array($key, $selectedProcessing) ? 'selected' : ''; ?>>
        <?php echo $value; ?>
      </option>
    <?php endforeach; ?>
  </select>
</div> <!--col-->

<div class="col-md-4">
  <p><?php echo "Completed"; ?></p>
  <?php 
    $selectedCompleted = (array) json_decode($this->functions->getOption('singleapp_order_completed', $merchant_id));
  ?>
  <select name="singleapp_order_completed[]" id="singleapp_order_completed" class="form-control chosen" multiple="multiple">
    <?php foreach ((array)$order_status_list as $key => $value): ?>
      <option value="<?php echo $key; ?>" <?php echo in_array($key, $selectedCompleted) ? 'selected' : ''; ?>>
        <?php echo $value; ?>
      </option>
    <?php endforeach; ?>
  </select>
</div> <!--col-->

	
	<div class="col-md-4">
  <p><?php echo "Cancelled"; ?></p>
  <?php 
    $selectedCancelled = (array) json_decode($this->functions->getOption('singleapp_order_cancelled', $merchant_id));
  ?>
  <select name="singleapp_order_cancelled[]" id="singleapp_order_cancelled" class="form-control chosen" multiple="multiple">
    <?php foreach ((array)$order_status_list as $key => $value): ?>
      <option value="<?php echo $key; ?>" <?php echo in_array($key, $selectedCancelled) ? 'selected' : ''; ?>>
        <?php echo $value; ?>
      </option>
    <?php endforeach; ?>
  </select>
</div> <!--col-->

	
</div>	 <!--row-->

<p class="between_div"><b><?php echo ("Cart Settings")?></b></p>

<div class="row">

<div class="col-md-12">
  <?php 
    $selectedCartTheme = $this->functions->getOption('singleapp_cart_theme', $merchant_id);
    $cartThemes = (array) $this->SingleAppClass->trackingTheme();
  ?>
  <select name="singleapp_cart_theme" id="singleapp_cart_theme" class="form-control">
    <?php foreach ($cartThemes as $key => $value): ?>
      <option value="<?php echo $key; ?>" <?php echo ($selectedCartTheme == $key) ? 'selected' : ''; ?>>
        <?php echo $value; ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>


</div><!-- row-->

<div class="row pt-3">


<div class="col-md-3">
	<?php echo $this->htmlWrapper->checkbox('singleapp_floating_category','',"Enabled floating Category", $this->functions->getOption('singleapp_floating_category',$merchant_id) );?>   	
</div>

<div class="col-md-3">
	<?php echo $this->htmlWrapper->checkbox('singleapp_confirm_future_order','',"Enabled Future Order Confirmation", $this->functions->getOption('singleapp_confirm_future_order',$merchant_id) );?>   	
</div>
</div>
<!--row-->


<p class="between_div"><b><?php echo ("Tracking Settings")?></b></p>

<div class="row">

<div class="col-md-5">
  <?php 
    $selectedTrackingTheme = $this->functions->getOption('singleapp_tracking_theme', $merchant_id);
    $trackingThemes = (array) $this->SingleAppClass->trackingTheme();
  ?>
  <select name="singleapp_tracking_theme" id="singleapp_tracking_theme" class="form-control">
    <?php foreach ($trackingThemes as $key => $value): ?>
      <option value="<?php echo $key; ?>" <?php echo ($selectedTrackingTheme == $key) ? 'selected' : ''; ?>>
        <?php echo $value; ?>
      </option>
    <?php endforeach; ?>
  </select>
  <small class="form-text text-muted">
    <?php echo ("Tracking Theme")?>
  </small>
</div>

<div class="col-md-5">
  <?php 
    $trackingInterval = $this->functions->getOption('singleapp_tracking_interval', $merchant_id);
  ?>
  <input 
    type="text" 
    name="singleapp_tracking_interval" 
    id="singleapp_tracking_interval" 
    class="numeric_only form-control" 
    placeholder="<?php echo ("Track Interval"); ?>" 
    value="<?php echo htmlspecialchars($trackingInterval); ?>"
  >
  <small class="form-text text-muted">
    <?php echo ("In Millisecond default is 60000, Minimum is 5000")?>
  </small>
</div>

  
</div> <!--row-->


<p class="between_div"><b><?php echo ("Custom Page Settings")?></b></p>

<div class="row">
  
<div class="col-md-5">
  <?php 
    $selectedPosition = $this->functions->getOption('singleapp_custom_pages_position', $merchant_id);
    $positions = array(
      1 => "Position 1 - in tab",
      2 => "Position 2 - in sidebar menu"
    );
  ?>
  <select name="singleapp_custom_pages_position" id="singleapp_custom_pages_position" class="form-control">
    <?php foreach ($positions as $key => $value): ?>
      <option value="<?php echo $key; ?>" <?php echo ($selectedPosition == $key) ? 'selected' : ''; ?>>
        <?php echo $value; ?>
      </option>
    <?php endforeach; ?>
  </select>
</div>


</div>



<div class="floating_action">
 
<input class="btn btn-raised btn-info" id="save-api" type="submit" name="yt0" value="Save Settings" />

</div>

</form>

<script type="text/javascript">
document.addEventListener("DOMContentLoaded", function () {
    // Add "active" class to first menu item
    const firstMenuItem = document.querySelector(".menu_nav li:first-child");
    if (firstMenuItem) {
        firstMenuItem.classList.add("active");
    }

    // Handle save-api button click
    document.body.addEventListener("click", function (e) {
        if (e.target && e.target.id === "save-api") {
            e.preventDefault();

            busy(true);
            const saveBtn = document.getElementById("save-api");
            saveBtn.value = "Processing";
            saveBtn.style.pointerEvents = "none";

            const form = saveBtn.closest("form");
            const formData = $(form).serialize(); // Using jQuery for serialization

            $.ajax({
                type: "POST",
                url: "/singlemerchant/ajax/save_appsettings",
                dataType: "json",
                cache: false,
                data: formData,
                success: function (data) {
                    if (data.code === 1) {
                        nAlert(data.msg, "success");
                    } else {
                        nAlert(data.msg, "warning");
                    }
                },
                complete: function () {
                    busy(false);
                    saveBtn.value = "Save Settings";
                    saveBtn.style.pointerEvents = "auto";
                }
            });
        }
    });
});
</script>