<?php
$current_url = $_SERVER['REQUEST_URI'];
$current_url = Config::$baseUrl . $current_url;

// Check if the URL contains "merchant_id"
$url_has_merchant_id = strpos($current_url, 'merchant_id') !== false;

$first_item = true;
$active_set = false;
?>

<div class="page_header">
  <div class="col"><div class="rounded-circle"><i class="fa fa-cog"></i></div></div>
  <div class="col">
    <h2><?php echo "Settings"; ?></h2>   
    <h6><?php echo $settings_title; ?></h6>	   
  </div>
</div>

<ul class="list-group pt-4">	  
<?php if (is_array($menu) && count($menu) >= 1): ?>
  <?php foreach ($menu as $val): ?>
    <?php
      $val['link'] = $val['link'] . "/merchant_id/" . $merchant_id;

      $is_active = false;

      // If URL does not contain merchant_id → first item should be active
      if (!$url_has_merchant_id && $first_item) {
          $is_active = true;
      }

      // If URL has merchant_id, apply matching logic
      if ($url_has_merchant_id && $current_url === $val['link']) {
          $is_active = true;
      }

      $first_item = false;
    ?>
    <a href="<?php echo $val['link']; ?>" class="list-group-item <?php echo $is_active ? 'active' : ''; ?>">
      <?php echo $val['label']; ?>
    </a>
  <?php endforeach; ?>
<?php endif; ?>
</ul>
