<?php
class WindcaveController extends Controller
{

    public function __construct()
    {
        $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        
        $this->SingleAppClass = new SingleAppClass();

        $this->InventoryWrapper=new InventoryWrapper();
    }




public function sendRequest_windcave($url, $method = 'POST', $data = [],$merchant_id) {

        
        $merchant_type=$this->functions->getMerchantMembershipType($merchant_id);  
        if($merchant_type=='1'){
          $paymode=$this->functions->getOption('windcave_mode',$merchant_id);
          if($paymode=='Sandbox'){
          $apiUsername = $this->functions->getOption('wind_user_id_sandbox', $merchant_id);
          $apiKey = $this->functions->getOption('wind_key_sandbox', $merchant_id);

          }else{
          $apiUsername = $this->functions->getOption('wind_user_id', $merchant_id);
          $apiKey = $this->functions->getOption('wind_key', $merchant_id);
          }


        }else{
          $paymode=$this->functions->getOptionAdmin('windcave_mode');

          if($paymode=='Sandbox'){
          $apiUsername = $this->functions->getOptionAdmin('wind_user_id_sandbox');
          $apiKey = $this->functions->getOptionAdmin('wind_key_sandbox');
          }else{
          $apiUsername = $this->functions->getOptionAdmin('wind_user_id');
          $apiKey = $this->functions->getOptionAdmin('wind_key');
          }
        }



       if($paymode=='Sandbox'){
     $url = "https://uat.windcave.com/api/v1/sessions";    
   }else{
      $url = "https://sec.windcave.com/api/v1/sessions";
   } 


        

        $auth = base64_encode("{$apiUsername}:{$apiKey}");
        
        $headers = [
            "Authorization: Basic $auth",
            "Content-Type: application/json",
        ];
        
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        if (!empty($data)) {
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        }
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        return json_decode($response, true);
    }



    
    public function index()
    {

          
      $order_id=$_GET['id'];

      $order_token=$order_id;
      $data = $this->functions->getOrderInfoByToken_appside($order_token);

      $merchant_id = $data['merchant_id'];
      
      $_SESSION['merchant_id'] = $merchant_id;
      

      $returnUrl = Config::$baseUrl . "/singlemerchant/windcave/verify?id=".$order_id;  // The URL for success page
      $notificationUrl = Config::$baseUrl . "/singlemerchant/windcave/windcave_notification";

      if ($this->functions->isClientLogin()){
        $cancel_url = $this->functions->websiteUrl() . "/singlemerchant/windcave/cancel_payment";
      }else{
        $cancel_url = $this->functions->websiteUrl() . "/singlemerchant/windcave/cancel_payment";
      }

      


      $currency = $this->functions->getCurrencyCode();
      $apiEndpoint = "https://uat.windcave.com/api/v1/sessions";
      $error = '';

      if ($data = $this->functions->getOrderInfoByToken_appside($order_token)) {

        $merchant_id=$data['merchant_id'];
         
         $price=$data['total_w_tax'];

         $credentials = $this->functions->getCredentials_windcave($merchant_id);
          if ($credentials['card_fee'] >= 0.0001) {
         
          $card_fee = $price*$credentials['card_fee']/100;
          $price=$price;
          }



         $price = number_format((float)$price, 2, '.', '');
         $merchantReference="Order#".$order_id;
         
$cancelUrl=$cancel_url;
      

        $data = [
    "type" => "purchase",
    "amount" => $price, // This would be dynamic in your case, such as $price
    "currency" => $currency, // You might want to replace this with your dynamic currency code, such as $currency
    "merchantReference" => $merchantReference, // Replace this with a dynamic reference if needed
    "callbackUrls" => [
        "approved" => $returnUrl, // Replace with your actual success URL
        "declined" => $cancelUrl,   // Replace with your actual failure URL
        "cancelled" => $cancelUrl // Replace with your actual cancel URL
    ],
    "notificationUrl" => $notificationUrl // Replace with your actual notification URL
];


        $sessionResponse = $this->sendRequest_windcave($apiEndpoint, 'POST', $data,$merchant_id);

        


         if (isset($sessionResponse['links'][1]['href'])) {
            // Redirect to the card entry view (second step)

           $payment_id = $sessionResponse['id'];
           $this->functions->update_payment_id($order_id,$payment_id);


           $formUrl = $sessionResponse['links'][1]['href'];
          header("Location: $formUrl");
    exit();
            /*$data_for_view = [
                    'sessionResponse' => $sessionResponse
                ];


            $this->view('merchant/windcave_buy', $data_for_view, 'layouts/merchant_tpl');*/

        } else {
            // Handle errors if session creation fails

           $error = "Error: " . $sessionResponse['message'];
        }



      }else {
        $error = $this->functions->translation("default", "Sorry but we cannot find what you are looking for.");
      }



      if (!empty($error)) {

        

        

          $redirect_link=Config::$baseUrl . "/singlemerchant/windcave/error?error=".$error;
            header('Location: ' . $redirect_link);


    }

        
    }




    public function verify()
{

// Logic for processing success response
        // e.g., check status, display success page, etc.
        $transactionId = $_GET['sessionId'] ?? null; // Get the transaction ID from the URL
        $status = $_GET['status'] ?? null; // Get the payment status
        
        
        
         $order_id=isset($_GET['id'])?$_GET['id']:''; 

         $stmt = $this->db->prepare("SELECT * FROM mt_order WHERE order_id = :order_id");
        $stmt->bindParam(':order_id', $order_id, PDO::PARAM_INT);
        $stmt->execute();

         $result = $stmt->fetch(PDO::FETCH_ASSOC);

         $merchant_id=$result['merchant_id'];


         $params_logs=array( 
                    'order_id'=>$order_id,  
                    'payment_type'=>"windcave", 
                    'payment_reference'=>$transactionId, 
                    'raw_response'=>'', 
                    'date_created'=>$this->functions->dateNow(),  
                    'ip_address'=>$_SERVER['REMOTE_ADDR'] 
                  );                          
                    
                     

         $this->functions->insertData('mt_payment_order', $params_logs);

         $get_id_orders = $this->functions->checkalreadyorder($merchant_id);  
         if($get_id_orders>=0){$order_number=$get_id_orders+1;}else{$order_number=1;}

         $params_update=array( 
                      'status'=>'paid', 
                      'date_modified'=>$this->functions->dateNow(),
                      'order_number'=>$order_number, 
                      'ip_address'=>$_SERVER['REMOTE_ADDR'] 
                    );    

                    
         $this->functions->updateData('mt_order', $params_update,'order_id',$order_id);

            // Payment successful
           
             $this->SingleAppClass->updatePoints($order_id,'paid'); 

            
            //+++inventory code
        if ($this->functions->inventoryEnabled($merchant_id)){
                                      
                                        try {  

                                            $this->InventoryWrapper->insertInventorySale($order_id,"paid");  
                                        } catch (Exception $e) {                                            
                                          // echo $e->getMessage();                                       
                                        }                                       
        }

       //---inventory code
                                 
                     

                     
                      
                    

                    $_SESSION['payment_process']=1;

                    
                    $order=$this->functions->getOrder($order_id);
                    $client_id=$order['client_id'];
                    $this->SingleAppClass->sendNotifications($order_id);
                    $this->SingleAppClass->clearCartByCustomerID($client_id);
                    $msg="Payment successfull";
                    $redirect_link=Config::$baseUrl . "/singlemerchant/windcave/success?message=".$msg;
                    header('Location: ' . $redirect_link);



                    exit();

    
}


 public function windcave_notification() {
    // Windcave will POST the response data to this URL (e.g., transaction status)
    $response = file_get_contents("php://input");  // Get raw POST data

    // Parse the response (assuming JSON format)
    $responseData = json_decode($response, true);

    // Check if the response indicates a successful transaction
    if ($responseData['status'] == 'APPROVED') {
        // Process the success (e.g., update your database, mark the order as paid)
        // Example: Update database to mark the payment as successful
        $transactionId = $responseData['transactionId'];
        // Your database code here to mark the transaction as successful
        // Example: $this->db->query("UPDATE orders SET status = 'paid' WHERE transaction_id = '$transactionId'");

        // Optionally, send a success response back to Windcave
        echo json_encode(["status" => "success"]);
    } else {
        // Handle the failure (e.g., log the error, send notification to admin)
        // Example: Log failure
        $errorMessage = $responseData['errorMessage'] ?? "Unknown error";
        // Log the error for future reference
        error_log("Payment failure: " . $errorMessage);

        echo json_encode(["status" => "failed", "message" => $errorMessage]);
    }
}










public function success()
    {
        $msg = isset($_GET['message'])?$_GET['message']:'';
        if(!empty($msg)){
            echo $msg;
        } else {
            echo "payment successfull";
        }
    }



    public function error()
    {
        $error = isset($_GET['error'])?$_GET['error']:'';
        if(!empty($error)){
            echo $error;
        } else echo "undefined error";
    }
    
    public function cancel()
    {
        
    }

    public function cancel_payment()
    {

       $sessionId = isset($_GET['sessionId'])?$_GET['sessionId']:''; 
       $merchant_id=$_SESSION['merchant_id']??3;
       

       $reason=$this->functions->windcavestatus($sessionId,$merchant_id);
       unset($_SESSION['merchant_id']);

      $reason_for_cancel="Your transaction could not be completed. Reason:".$reason;

       $redirect_link=Config::$baseUrl . "/singlemerchant/windcave/error?error=".$reason_for_cancel;
       header('Location: ' . $redirect_link);

    }
    

    
    
    
    
    
}
/*end class*/