<?php
class CronController extends Controller
{

	public function __construct()
	{
		$model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        $this->SingleAppClass = new SingleAppClass();

        $website_timezone=$this->functions->getOptionAdmin('website_timezone');
        if (!empty($website_timezone)){
            date_default_timezone_set($website_timezone);
        }

        
	}
	
	public function index()
	{
    echo 'cron is working';

		
	}


    public function ProcessBroadcast()
{
    if (1 == 1):

        $stmt = "
        SELECT a.*,
        (
         select option_value
         from mt_option
         where
         merchant_id = a.merchant_list
         and
         option_name = 'singleapp_fcm_provider'
         limit 0,1
        ) as fcm_provider,
        
        (
         select option_value
         from mt_option
         where
         merchant_id = a.merchant_list
         and
         option_name = 'singleapp_services_account_json'
         limit 0,1
        ) as services_account,

        (
         select option_value
         from mt_option
         where
         merchant_id = a.merchant_list
         and
         option_name = 'singleapp_android_push_key'
         limit 0,1
        ) as server_key         
            
        FROM mt_singleapp_broadcast a      
        
        WHERE a.status='pending'        
        AND 
        fcm_version='1'
        ORDER BY broadcast_id ASC       
        LIMIT 0,5   
        ";

        $stmt_query = $this->db->prepare($stmt);
        $stmt_query->execute();
        if ($res = $stmt_query->fetchAll(PDO::FETCH_ASSOC)) {

            foreach ($res as $val) {
                $process_status = '';
                $json_response = '';
                $process_date = $this->functions->dateNow();

                $device_id = trim($val['device_platform']);
                $merchant_id = (int) $val['merchant_list'];
                $file = $this->functions->uploadPath() . "/" . $val['services_account'];

                //$serviceAccount = json_decode(file_get_contents($file), true);
				$serviceAccount = $this->functions->readJsonFile($file);
                $projectId = $serviceAccount['project_id'];


                $server_key = trim($val['server_key']);

                try {
                   


                         $data=[
                            'target'=>'singleapp_broadcast'.$merchant_id,
                            'title'=>$val['push_title'],
                            'body'=>$val['push_message'],
                            'channel'=>'kmrs_singleapp',
                            'sound'=>'beep',
                            'apple_sound'=>'beep.wav',
                            'projectId'=>$projectId
                        ];
                        //print_r($data);die();

                    $json_response=$this->functions->sendFCMNotification($data,$serviceAccount,"broadcast");  

                    $process_status = 'process';




                } catch (Exception $e) {
                    $process_status = 'failed';
                    $json_response = $e->getMessage();
                }

                if (!empty($process_status)) {
                    $process_status = substr(strip_tags($process_status), 0, 255);
                } else {
                    $process_status = 'failed';
                }

                if (is_array($json_response) && count($json_response) >= 1) {
                    $json_response = json_encode($json_response);
                }

                $params = array(
                    'status' => $process_status,
                    'date_modified' => $process_date,
                    'fcm_response' => $json_response
                );

                $this->functions->updateData("mt_singleapp_broadcast", $params, 'broadcast_id', $val['broadcast_id']);
            }
        }else{
            echo "no record";die();
        }

    endif;
}




   

public function processpush()
{
    if (1 == 1):

        $stmt = "
        SELECT a.*,
        (
         select option_value
         from mt_option
         where
         merchant_id = a.merchant_id
         and
         option_name = 'singleapp_fcm_provider'
         limit 0,1
        ) as fcm_provider,
        
        (
         select option_value
         from mt_option
         where
         merchant_id = a.merchant_id
         and
         option_name = 'singleapp_services_account_json'
         limit 0,1
        ) as services_account,

        (
         select option_value
         from mt_option
         where
         merchant_id = a.merchant_id
         and
         option_name = 'singleapp_android_push_key'
         limit 0,1
        ) as server_key         
            
        FROM mt_singleapp_mobile_push_logs a       
        WHERE a.status='pending'        
        ORDER BY id ASC     
        LIMIT 0,10  
        ";

        $stmt_query = $this->db->prepare($stmt);
        $stmt_query->execute();
        if ($res = $stmt_query->fetchAll(PDO::FETCH_ASSOC)) {

            
            foreach ($res as $val) {

                $process_status = ''; 
                $json_response = '';
                $process_date = $this->functions->dateNow();

                $device_id = trim($val['device_id']);
                $merchant_id = (integer)$val['merchant_id'];
                $fcm_provider = $val['fcm_provider'] > 0 ? $val['fcm_provider'] : 1;


                $file = $this->functions->uploadPath() . "/" . $val['services_account'];
                //$serviceAccount = json_decode(file_get_contents($file), true);
				$serviceAccount = $this->functions->readJsonFile($file);
                $projectId = $serviceAccount['project_id'];
                $server_key = trim($val['server_key']);

                if ($fcm_provider == 2):

                    try {
                      


                        $process_status = 'process';

                        $data=[
                            'target'=>$val['device_id'],
                            'title'=>$val['push_title'],
                            'body'=>$val['push_message'],
                            'channel'=>'kmrs_singleapp',
                            'sound'=>'beep',
                            'apple_sound'=>'beep.wav',

                            'projectId'=>$projectId
                        ];

                        $json_response=$this->functions->sendFCMNotification($data,$serviceAccount,'push');

                    } catch (Exception $e) {
                        $process_status = 'failed';
                        $json_response = $e->getMessage();
                    }

                else:
                    // do nothing
                endif;

                if (!empty($process_status)) {
                    $process_status = substr(strip_tags($process_status), 0, 255);
                } else {
                    $process_status = 'failed';
                }

                if (is_array($json_response) && count($json_response) >= 1) {
                    $json_response = json_encode($json_response);
                }

                $params = array(
                    'status' => $process_status,
                    'date_process' => $process_date,
                    'json_response' => $json_response
                );

                $this->functions->updateData("mt_singleapp_mobile_push_logs", $params, 'id', $val['id']);
            } /* end foreach */
        }else{
            echo "no record";die();
        }

    endif;
}





public function trigger_order()
{

    


    if (1 == 1):

    $default_title = "Updates on your order id [order_id]";
    $default_push_content = 'hi [customer_name]
                            Your order id [order_id] has been updated to [order_status]';

    $stmt = "
    SELECT 
    a.trigger_id,
    a.trigger_type,
    a.order_id,
    a.order_status,
    a.order_status as request_status,
    a.remarks,
    a.remarks as merchant_remarks,
    a.language,
    a.status,
    b.merchant_id,
    b.client_id,
    c.restaurant_name,
    concat(d.first_name,' ',d.last_name) as customer_name,
    e.device_id,
    e.device_platform,
    e.push_enabled,
    e.code_version
    FROM mt_singleapp_order_trigger a
    LEFT JOIN mt_order b ON a.order_id = b.order_id
    LEFT JOIN mt_merchant c ON b.merchant_id = c.merchant_id
    LEFT JOIN mt_client d ON b.client_id = d.client_id
    LEFT JOIN mt_singleapp_device_reg e ON b.client_id = e.client_id
    WHERE a.status = 'pending'
    AND a.trigger_type NOT IN ('booking')
    AND e.push_enabled = 1
    LIMIT 0,50
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();


    
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        
        
        foreach ($res as $val) {
            $trigger_id = $val['trigger_id'];
            $order_status = $val['order_status'];
            $lang = $val['language'];
            $process_status = 'process';

            switch (trim($val['trigger_type'])) {
                case "order":
                    $enabled = $this->functions->getOptionAdmin("order_status_" . $order_status . "_push");
                    if ($enabled == 1) {
                        $push_title = $this->functions->getOptionAdmin("order_status_" . $order_status . "_push_title_$lang");
                        $push_message = $this->functions->getOptionAdmin("order_status_" . $order_status . "_push_content_$lang");
                        if (empty($push_title)) $push_title = $default_title;
                        if (empty($push_message)) $push_message = $default_push_content;

                        $pattern = explode(",", 'order_id,order_status,restaurant_name,customer_name,remarks,sitename,siteurl');
                        foreach ($pattern as $key) {
                            $push_title = $this->functions->smarty($key, isset($val[$key]) ? $val[$key] : '', $push_title);
                            $push_message = $this->functions->smarty($key, isset($val[$key]) ? $val[$key] : '', $push_message);
                        }

                        $params = [
                            'client_id' => (int)$val['client_id'],
                            'client_name' => trim($val['customer_name']),
                            'device_platform' => trim($val['device_platform']),
                            'device_id' => trim($val['device_id']),
                            'push_title' => $push_title,
                            'push_message' => $push_message,
                            'date_created' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                            'merchant_id' => (int)$val['merchant_id']
                        ];
                        $this->functions->insertData("mt_singleapp_mobile_push_logs", $params);
                    } else {
                        $process_status = 'error order status template is not enabled';
                    }
                    break;

                case "order_request_cancel":
                    $enabled = $this->functions->getOptionAdmin("order_request_cancel_to_customer_push");
                    if ($enabled == 1) {
                        $push_title = $this->functions->getOptionAdmin("order_request_cancel_to_customer_push_title_$lang");
                        $push_message = $this->functions->getOptionAdmin("order_request_cancel_to_customer_push_content_$lang");
                        if (empty($push_title)) $push_title = $default_title;
                        if (empty($push_message)) $push_message = $default_push_content;

                        $pattern = explode(",", 'order_id,order_status,restaurant_name,customer_name,request_status,sitename,siteurl');
                        foreach ($pattern as $key) {
                            $push_title = $this->functions->smarty($key, isset($val[$key]) ? $val[$key] : '', $push_title);
                            $push_message = $this->functions->smarty($key, isset($val[$key]) ? $val[$key] : '', $push_message);
                        }

                        $params = [
                            'client_id' => (int)$val['client_id'],
                            'client_name' => trim($val['customer_name']),
                            'device_platform' => trim($val['device_platform']),
                            'device_id' => trim($val['device_id']),
                            'push_title' => $push_title,
                            'push_message' => $push_message,
                            'date_created' => $this->functions->dateNow(),
                            'ip_address' => $_SERVER['REMOTE_ADDR'],
                            'merchant_id' => (int)$val['merchant_id']
                        ];
                        $this->functions->insertData("mt_singleapp_mobile_push_logs", $params);
                    } else {
                        $process_status = 'error order_request_cancel template is not enabled';
                    }
                    break;

                default:
                    $process_status = 'invalid triger type';
                    break;
            }

            $this->functions->updateData("mt_singleapp_order_trigger", [
                'status' => $process_status,
                'date_process' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR']
            ], 'trigger_id', $trigger_id);

            $this->processpush();
        }
    }

    /* BOOKING SECTION */
    $stmt = "
    SELECT 
    a.trigger_id,
    a.trigger_type,
    a.order_id,
    a.order_status,
    a.order_status as request_status,
    a.remarks,
    a.remarks as merchant_remarks,
    a.language,
    a.status,
    b.merchant_id,
    b.client_id,
    b.booking_id,
    b.number_guest,
    b.date_booking,
    b.booking_time as time,
    b.email,
    b.booking_notes as instruction,
    b.booking_name,
    c.restaurant_name,
    d.device_id,
    d.device_platform,
    d.push_enabled,
    d.code_version
    FROM mt_singleapp_order_trigger a
    LEFT JOIN mt_bookingtable b ON a.order_id = b.booking_id
    LEFT JOIN mt_merchant c ON b.merchant_id = c.merchant_id
    LEFT JOIN mt_singleapp_device_reg d ON b.client_id = d.client_id
    WHERE a.status = 'pending'
    AND a.trigger_type = 'booking'
    AND d.push_enabled = 1
    LIMIT 0,50
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {
            $trigger_id = $val['trigger_id'];
            $order_status = $val['order_status'];
            $lang = $val['language'];
            $process_status = 'process';
            $val['status'] = $val['order_status'];
            $val['customer_name'] = $val['booking_name'];

            $enabled = $this->functions->getOptionAdmin("booking_update_status_push");
            if ($enabled == 1) {
                $push_title = $this->functions->getOptionAdmin("booking_update_status_push_title_$lang");
                $push_message = $this->functions->getOptionAdmin("booking_update_status_push_content_$lang");
                if (empty($push_title)) $push_title = 'Update with your booking id [booking_id]';
                if (empty($push_message)) $push_message = 'Update on your booking id [booking_id] with status of [status]';

                $pattern = explode(",", 'booking_id,restaurant_name,number_guest,date_booking,time,customer_name,email,mobile,instruction,status,merchant_remarks,sitename,siteurl');
                foreach ($pattern as $key) {
                    $push_title = $this->functions->smarty($key, isset($val[$key]) ? $val[$key] : '', $push_title);
                    $push_message = $this->functions->smarty($key, isset($val[$key]) ? $val[$key] : '', $push_message);
                }

                $params = [
                    'client_id' => (int)$val['client_id'],
                    'client_name' => trim($val['customer_name']),
                    'device_platform' => trim($val['device_platform']),
                    'device_id' => trim($val['device_id']),
                    'push_title' => $push_title,
                    'push_message' => $push_message,
                    'date_created' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR'],
                    'merchant_id' => (int)$val['merchant_id']
                ];
                $this->functions->insertData("mt_singleapp_mobile_push_logs", $params);
            } else {
                $process_status = 'template is not enabled';
            }

            $this->functions->updateData("mt_singleapp_order_trigger", [
                'status' => $process_status,
                'date_process' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR']
            ], 'trigger_id', $trigger_id);

            $this->processpush();
        }
    }

    endif;
}


  public function getfbavatar()
{
    if (1 == 1):

        $stmt = "
        SELECT client_id, avatar, social_id
        FROM mt_client
        WHERE avatar = ''
        AND social_id != ''
        AND social_strategy = 'fb_mobile'
        LIMIT 0,2
        ";

        $query = $this->db->prepare($stmt);
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            foreach ($res as $val) {
                $params = array();
                $client_id = $val['client_id'];

                if ($avatar = $this->functions->saveFbAvatarPicture($val['social_id'])) {
                    $params['avatar'] = $avatar;
                } else {
                    $params['avatar'] = "avatar.jpg";
                }

                $params['date_modified'] = $this->functions->dateNow();
                $params['ip_address'] = $_SERVER['REMOTE_ADDR'];

                $this->functions->updateData("mt_client", $params, 'client_id', $client_id);
            }
        }

    endif;
}
  





	
	
	
	
	
}
/*end class*/