<?php
class PointsProgram{


    public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        
        

    }

    public  function moduleBaseUrl()
    {
        return Config::$baseUrl."/app/modules/pointsprogram";
    }

    public  function moduleName()
    {
        return "Loyalty Points Program";
    }

    public  function listPointExpiry()
    {
        return array(
           1=>"points expire at the end of the next year after you earned them",
           //2=>t("points expire after 6 months"),
           3=>"points never expire"
        );
    }
    
    public function frontMenu($echo = false)
{
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');

    if ($points_enabled == 1) {
        $t = '<li class="noclick">';
        $t .= '<a href="' . Config::$baseUrl . '/store/mypoints">';
        $t .= '<i class="fa fa-signal"></i> <span>My Points</span></a>';
        $t .= '</li>';

        if ($echo) {
            echo $t;
        } else {
            return $t;
        }
    }
}

public  function productPointLabel($item_id='')
    {
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled!=1){
            return;
        }
        
        $points=$this->getPointsByItem($item_id);               
        $pts_label=$this->functions->getOptionAdmin('pts_label');
        if ($points<1){
            return;
        }
        if ($points==FALSE){
            return;
        }
                
        echo '<p class="points-label">';
        if (!empty($pts_label)){            
            //echo t("Earn")." $points  $pts_label ".t("Points");
            $pts_label=$this->functions->smarty('points',$points,$pts_label);
            echo $pts_label;
        } else  echo "Earn $points Reward Points";
        echo '</p>';
    }

    public function getDisabledPointsByItem($item_id = '')
{
    $stmt = "
        SELECT points_disabled
        FROM mt_item
        WHERE item_id = :item_id
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->execute();
    
    $res = $query->fetch(PDO::FETCH_ASSOC);

    return $res ? $res : false;
}


public function getPointsByItem($item_id = '', $set_price = '', $mtid = '', $qty = '')
{
    $stmt = "
        SELECT points_earned, price, discount, points_disabled 
        FROM mt_item 
        WHERE item_id = :item_id 
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $query->execute();
    
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        if ($res['points_earned'] > 0) {
            if ($res['points_disabled'] == 2) {                    
                return 0;
            }                    

            if ($qty > 0) {
                return $res['points_earned'] * $qty;
            }
            return $res['points_earned'];
        } else {            
            if ($res['points_disabled'] == 2) {                    
                return 0;
            }

            $pts_earning_points = $this->functions->getOptionAdmin('pts_earning_points');
            $pts_earning_points_value = $this->functions->getOptionAdmin('pts_earning_points_value');

            $points_disabled_merchant_settings = $this->functions->getOptionAdmin('points_disabled_merchant_settings');

            if ($points_disabled_merchant_settings != 1) {
                if (!empty($mtid)) {
                    $mt_pts_earning_points = $this->functions->getOption('mt_pts_earning_points', $mtid);
                    $mt_pts_earning_points_value = $this->functions->getOption('mt_pts_earning_points_value', $mtid);                    
                    if ($mt_pts_earning_points > 0.01) {                        
                        $pts_earning_points = $mt_pts_earning_points;
                    }
                    if ($mt_pts_earning_points_value > 0.01) {                        
                        $pts_earning_points_value = $mt_pts_earning_points_value;
                    }
                }
            }

            $default_price = 0;
            $discount = '';

            if (!empty($res['price'])) {
                $price = json_decode($res['price'], true);
                if (is_array($price) && count($price) >= 1) {
                    foreach ($price as $val) {
                        $price = $val;
                        break;
                    }    
                }
                if ($res['discount'] > 0) {
                    $discount = $res['discount'];
                }
            }

            if (!empty($set_price) && is_numeric($set_price)) {
                $final_price = $set_price;
            } else {
                $final_price = (float)$price - (float)$discount;
            }

            if ($final_price > 0 && $pts_earning_points_value > 0 && $pts_earning_points > 0) {
                $t1 = ($final_price / $pts_earning_points_value) * $pts_earning_points;                    
                return intval($t1);
            }
        }
    }
    return false;
}

public function paymentOptionsList()
{
    return array(
        'cod' => "Cash On delivery",
        'ocr' => "Offline Credit Card Payment",
        'pyp' => "Paypal",
        'pyr' => "Pay On Delivery",
        'stp' => "Stripe",
        'mcd' => "Mercadopago",
        'payu' => "PayUMoney",
        'atz' => "Authorize.net",
        'obd' => "Offline Bank Deposit",
        'rzr' => "Razorpay",
        'ipay' => "Ipay"
    );
}

public  function cartTotalEarnPoints($cart='',$receipt=false,$sub_total=0,$mtid='')
    {       
        if ($receipt==true) {
            return ;
        }
                        
        /*CHECK IF ADMIN ENABLED THE POINTS SYSTEM*/
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled!=1){
            return;
        }
        
        /*CHECK IF MERCHANT HAS DISABLED POINTS SYSTEM*/
        if(isset($cart[0])){
            if(isset($cart[0]['merchant_id'])){
                //$mtid =  $cart[0]['merchant_id'];
                $mt_disabled_pts=$this->functions->getOption('mt_disabled_pts',$mtid);
                if($mt_disabled_pts==2){
                    return ;
                }
            }       
        }
        
        $points=0;      
        
        /*dump($sub_total);
        dump($cart);        */
        if (is_array($cart) && count($cart)>=1){
            
            $earning_type =  $this->getBasedEarnings($mtid);
            /*dump("mtid=>".$mtid);         
            dump($earning_type);*/
            
            if($earning_type==1){
                foreach ($cart as $val) {
                    $temp_price=explode("|",$val['price']);                                                     
                    if($val['discount']>=0.01){
                        $set_price = ($temp_price[0]-$val['discount'])*$val['qty'];
                    } else {                        
                        $set_price = (float)$temp_price[0]*$val['qty'];
                    }               
                                                        
                    $points+= $this->getPointsByItem($val['item_id'],$set_price , $mtid , $val['qty']);
                }
            } else {                                
                $points+=$this->getTotalEarningPoints($sub_total,$mtid);                
            }
            
            /*CHECK IF SUBTOTAL ORDER IS ABOVE */
            $pts_earn_above_amount=$this->functions->getOptionAdmin('pts_earn_above_amount');
            
            if(!$this->isMerchantSettingsDisabled()){
                $mt_pts_earn_above_amount=$this->functions->getOption('mt_pts_earn_above_amount',$mtid);
                if($mt_pts_earn_above_amount>0){
                    $pts_earn_above_amount = $mt_pts_earn_above_amount;
                }
            }
            
            if(is_numeric($pts_earn_above_amount)){
                if($pts_earn_above_amount>$sub_total){
                    $points=0;
                }
            }
                        
            $_SESSION['pts_earn']=$points;
            if ($points>0){
                $pts_label_earn=$this->functions->getOptionAdmin('pts_label_earn');
                
                $pts_payment_list1='';
                $pts_payment_list=$this->paymentOptionsList();              
                $pts_payment_option=$this->functions->getOptionAdmin('pts_payment_option');
                $pts_payment_option=!empty($pts_payment_option)?json_decode($pts_payment_option,true):false;
                if ($pts_payment_option!=false){
                    foreach ($pts_payment_option as $val_p) {                       
                        $pts_payment_list1.= $pts_payment_list[$val_p].", ";
                    }
                    $pts_payment_list1=substr($pts_payment_list1,0,-2);
                }
                                
                $payment_opt = "You can earn these points if you pay using: " . $pts_payment_list1;

                
                $help='<a style="font-size:15px;" href="javascript:;" data-toggle="tooltip" data-placement="top" title="'.$payment_opt.'" >
                <i class="ion-ios-help-outline"></i></a>';
                $help='';
                if (!empty($pts_label_earn)){
                    $pts_label_earn=$this->functions->smarty('points',$points,$pts_label_earn);
                    $pts_label_earn=$this->functions->smarty('points',$points,$pts_label_earn);
                    return '<p class="points-earn padtop15">'.$pts_label_earn.$help.'</p>';
                } else  return '<p class="points-earn padtop15">This order earned ' . $points . ' Points</p>';

            }
        }       
    }


    public  function saveEarnPoints($total_points_earn='',$client_id='',$merchant_id='',
    $order_id='',$payment_selected='',$order_status='')
    {
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled<>1){
            return false;
        }
        
        if(!$this->isMerchantSettingsDisabled()){
            $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$merchant_id);
            if($mt_disabled_pts==2){
                return false;
            }
        }
                        
        if ($total_points_earn>0){
            
            /*check if the client has reach the maximum points to be earn*/
            $max_points=$this->functions->getOptionAdmin('pts_maximum_points');
            if (is_numeric($max_points)){               
                $points_balance=$this->getTotalEarnPoints($client_id);              
                $total_points_earn2=$total_points_earn+$points_balance;             
                if ($total_points_earn2>$max_points){                   
                    $points_supposed_to_earn=$max_points-$points_balance;                   
                    $total_points_earn=$points_supposed_to_earn;
                }                               
            }
            
            $params=array(
              'client_id'=>$client_id,
              'merchant_id'=>$merchant_id,
              'order_id'=>$order_id,
              'total_points_earn'=>$total_points_earn,
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
            
            
            /*donnot saved the points if points is below zero*/     
            if ($total_points_earn<=0){
                return false;
            }
            
            $earn_status = $this->validateEarnByStatus($order_status,$merchant_id);
            if($earn_status){
                $params['status']="active";
            }                       
                        
            
            
            if ( $this->functions->insertData('mt_points_earn',$params)){
                $this->firstOrderRewards($client_id,
                isset($params['status'])?$params['status']:'inactive', $order_id);
                return true;
            }
        }       
        return false;
    }


     public  function saveEarnPoints_windcavepos_offline($total_points_earn='',$client_id='',$merchant_id='',
    $order_id='',$payment_selected='',$order_status='')
    {
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled<>1){
            return false;
        }
        
        if(!$this->isMerchantSettingsDisabled()){
            $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$merchant_id);
            if($mt_disabled_pts==2){
                return false;
            }
        }
                        
        if ($total_points_earn>0){
            
            /*check if the client has reach the maximum points to be earn*/
            $max_points=$this->functions->getOptionAdmin('pts_maximum_points');
            if (is_numeric($max_points)){               
                $points_balance=$this->getTotalEarnPoints($client_id);              
                $total_points_earn2=$total_points_earn+$points_balance;             
                if ($total_points_earn2>$max_points){                   
                    $points_supposed_to_earn=$max_points-$points_balance;                   
                    $total_points_earn=$points_supposed_to_earn;
                }                               
            }
            
            $params=array(
              'client_id'=>$client_id,
              'merchant_id'=>$merchant_id,
              'order_id'=>$order_id,
              'total_points_earn'=>$total_points_earn,
              'date_created'=>$this->functions->dateNow(),
              'ip_address'=>$_SERVER['REMOTE_ADDR']
            );
            
            
            /*donnot saved the points if points is below zero*/     
            if ($total_points_earn<=0){
                return false;
            }
            
            $earn_status = $this->validateEarnByStatus($order_status,$merchant_id);
            if($earn_status){
                $params['status']="active";
            }                       
                        
             $params['status']="inactive";
            
            if ( $this->functions->insertData('mt_points_earn',$params)){
                $this->firstOrderRewards($client_id,
                isset($params['status'])?$params['status']:'inactive', $order_id);
                return true;
            }
        }       
        return false;
    }




    public  function saveExpensesPoints($total_points='',$total_points_amt='',
    $client_id='',$merchant_id='',
    $order_id='',$payment_selected='')
    {
        
        if ($total_points<0.01){
            return false;
        }
        
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled<>1){
            return false;
        }
        
        $params=array(
          'client_id'=>$client_id,
          'merchant_id'=>$merchant_id,
          'order_id'=>$order_id,
          'total_points'=>$total_points,
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'total_points_amt'=>$total_points_amt
        );
        
        switch ($payment_selected) {
            case "cod":
            case "ocr":
            case "obd":     
            case "pyr":
                $params['status']="active";
                break;
                        
            default:
                $params['status']="active";
                break;
        }
                    
        
        if ($this->functions->insertData("mt_points_expenses",$params)){
            return true;
        }
        
        return false;
    }


     public  function saveExpensesPoints_windcave($total_points='',$total_points_amt='',
    $client_id='',$merchant_id='',
    $order_id='',$payment_selected='')
    {
        
        if ($total_points<0.01){
            return false;
        }
        
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled<>1){
            return false;
        }
        
        $params=array(
          'client_id'=>$client_id,
          'merchant_id'=>$merchant_id,
          'order_id'=>$order_id,
          'total_points'=>$total_points,
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'total_points_amt'=>$total_points_amt
        );
        
        
                    
        $params['status']="inactive";
        if ($this->functions->insertData("mt_points_expenses",$params)){
            return true;
        }
        
        return false;
    }



    public function updatePoints($order_id = '', $status = 'active')
{       
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    if ($points_enabled <> 1) {
        return false;
    }

    $params = ['status' => $status];

    // Update mt_points_earn
    $stmt = $this->db->prepare("UPDATE mt_points_earn SET status = :status WHERE order_id = :order_id");
    $stmt->execute([':status' => $status, ':order_id' => $order_id]);

    // Update points_expenses
    $stmt = $this->db->prepare("UPDATE points_expenses SET status = :status WHERE order_id = :order_id");
    $stmt->execute([':status' => $status, ':order_id' => $order_id]);

    // Update first order
    $stmt = $this->db->prepare("
        SELECT * FROM mt_points_earn 
        WHERE client_id = :client_id 
        AND trans_type = 'first_order' 
        AND status = 'inactive' 
        LIMIT 1
    ");
    $stmt->execute([':client_id' => $this->functions->getClientId()]);
    
    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $updateStmt = $this->db->prepare("UPDATE mt_points_earn SET status = 'active' WHERE id = :id");
        $updateStmt->execute([':id' => $res['id']]);
    }
}


public function getTotalEarnPoints($client_id = '', $merchant_id = '', $redeem_condition = '')
{
    

    $pts_redeem_condition = $this->functions->getOptionAdmin('pts_redeem_condition');
    
    if (!empty($redeem_condition)) {
        $pts_redeem_condition = $redeem_condition;
    }

    $and = '';

    if (!empty($merchant_id)) {
        switch ($pts_redeem_condition) {
            case 1:
                $and = " AND (merchant_id = :merchant_id OR trans_type = 'adjustment') ";
                break;

            case 3:
                $and = " AND (merchant_id = :merchant_id OR trans_type IN ('first_order', 'review', 'signup', 'adjustment', 'booking')) ";
                break;
        }
    }

    $stmt = "
    SELECT 
        SUM(total_points_earn) as total_earn,
        (
          SELECT SUM(total_points)
          FROM mt_points_expenses
          WHERE status = 'active' 
          AND client_id = :client_id
          $and
        ) as total_points_expenses
    FROM 
        mt_points_earn
    WHERE 
        status = 'active' 
        AND client_id = :client_id
    $and
    ";

    $params = [':client_id' => $client_id];
    
    if (!empty($merchant_id)) {
        $params[':merchant_id'] = $merchant_id;
    }

    $query = $this->db->prepare($stmt);
    $query->execute($params);
    
    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res['total_earn'] - $res['total_points_expenses'];
    }

    return 0;
}


    public function getExpiringPoints($client_id = '')
{
    $year = date('Y', strtotime("-1 year"));
    $pts_expiry = $this->functions->getOptionAdmin('pts_expiry');

    $and = '';
    if ($pts_expiry == 1) {
        $and = " AND date_created LIKE :year ";
    } else {
        return 0;
    }

    $stmt = "
    SELECT SUM(total_points_earn) as total_earn
    FROM mt_points_earn
    WHERE status = 'active'
    AND client_id = :client_id
    $and
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([
        ':client_id' => $client_id,
        ':year' => $year . '%'
    ]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        return $res['total_earn'];
    }

    return 0;
}


public  function redeemForm($merchant_id='')
    {
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled!=1){
            return;
        }
                
        $pts_disabled_redeem=$this->functions->getOptionAdmin('pts_disabled_redeem');   
        
        if(!$this->isMerchantSettingsDisabled()){
            
            /*CHECK IF MERCHANT DISABLED POINTS*/
            $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$merchant_id);
            if($mt_disabled_pts==2){
                return false;
            }
            
            $mt_pts_disabled_redeem=$this->functions->getOption('mt_pts_disabled_redeem',$merchant_id);         
            if(empty($mt_pts_disabled_redeem)){
                $pts_disabled_redeem='';
            }
        }
        
        if ( $pts_disabled_redeem==1){
            return ;
        }
        
        $label=$this->functions->getOptionAdmin('pts_label_input');
        

        $points=$this->getTotalEarnPoints( 
            $this->functions->getClientId(),$merchant_id
        );

        $points=$points+0;  
                
        /*dont show redeem form if balance is zero*/
        if ($points<1){
            $pts_redeem_balance_zero=$this->functions->getOptionAdmin('pts_redeem_balance_zero');
            if ( $pts_redeem_balance_zero==1){
                return ;
            }
        }
        ?>
        <div class="redeem-wrap bottom10">
           
              <input type="text" name="redeem_points" id="redeem_points" value="" placeholder="<?php echo $label; ?>" class="numeric_only grey-fields center">

              <button class="orange-button apply_redeem_pts">
               <?php echo ("Redeem")?>
              </button> 
              
              <p><?php echo ("Your points").":<span>".$points."</span>"?></p>
              
             <input type="hidden" name="pts_redeem_flag" id="pts_redeem_flag" value="<?php echo isset($_SESSION['pts_redeem_points']) ? $_SESSION['pts_redeem_points'] : ''; ?>">

              
              <div class="mytable pts_redeem_wrap">
                 <div class="col">
                   <span class="pts_points">
                   <?php echo isset($_SESSION['pts_redeem_points'])?$_SESSION['pts_redeem_points']:''.
                   " ".("Points")?></span>
                </div>
                <div class="col">
                 <span class="pts_amount">-<?php echo $this->price(isset($_SESSION['pts_redeem_amt'])?$_SESSION['pts_redeem_amt']:'')?></span>
                </div>
                <div class="col">
                  <a href="javascript:;" class="pts_cancel_redeem"><?php echo ("Cancel")?></a>
                </div>
              </div>  <!--pts_redeem_wrap-->
           
        </div> <!--redeem-wrap-->
        <?php
    }

    public  function price($price='')
    {
        $currency =$this->functions->adminCurrencySymbol();
        $amount   = $this->functions->standardPrettyFormat($price);
                
        $pos=$this->functions->getOptionAdmin('admin_currency_position');       
        if ( $pos=="right"){
            return $amount."".$currency;
        } else {            
            return $currency."".$amount;
        }
    }


    public  function signupReward($client_id='')
    {
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled!=1){
            return;
        }
        
        $pts_account_signup=$this->functions->getOptionAdmin('pts_account_signup');
        if ($pts_account_signup<1){
            return false;
        }

        $client_info=$this->functions->getClientInfo($client_id);
                
        
        $params=array(
          'client_id'=>(integer)$client_id,
          'merchant_id'=>(integer)$client_info['merchant_id'],
          'total_points_earn'=>(integer)$pts_account_signup,
          'status'=>'active',
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'trans_type'=>'signup'
        );
        
        $this->functions->insertData('mt_points_earn',$params);

    }


        public  function signupReward_withmerchant($client_id='',$merchant_id='')
    {
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled!=1){
            return;
        }
        
        $pts_account_signup=$this->functions->getOptionAdmin('pts_account_signup');
        if ($pts_account_signup<1){
            return false;
        }
                
        
        $params=array(
          'client_id'=>(integer)$client_id,
          'merchant_id'=>(integer)$merchant_id,
          'total_points_earn'=>(integer)$pts_account_signup,
          'status'=>'active',
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'trans_type'=>'signup'
        );
        
        $this->functions->insertData('mt_points_earn',$params);

    }


    public function firstOrderRewards($client_id = '', $status = '', $order_id = '')
{
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    if ($points_enabled != 1) {
        return;
    }

    $pts_first_order = $this->functions->getOptionAdmin('pts_first_order');
    if ($pts_first_order < 1) {
        return false;
    }

    $first_order = false;

    // Use PDO to check if it's the first order
    $stmt = "
        SELECT COUNT(*) as total
        FROM mt_order
        WHERE client_id = :client_id
    ";

    $query = $this->db->prepare($stmt);
    $query->execute([':client_id' => $client_id]);

    if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
        if ($res['total'] <= 1) {
            $first_order = true;
        }
    } else {
        $first_order = true; // If no records, treat as first order
    }

    if ($first_order) {

      $order_infos=$this->functions->getOrderInfo($order_id);

        $params = [
            'client_id' => $client_id,
            'merchant_id' => $order_infos['merchant_id'],
            'total_points_earn' => $pts_first_order,
            'status' => $status,
            'date_created' => $this->functions->dateNow(),
            'ip_address' => $_SERVER['REMOTE_ADDR'],
            'trans_type' => 'first_order',
            'order_id' => $order_id
        ];

        // Keep the original insertData() function
        $this->functions->insertData('mt_points_earn', $params);
    }
}


public  function reviewsReward($client_id='',$review_id='', $merchant_id='' )
    {
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled!=1){
            return;
        }
        $pts_merchant_reivew=$this->functions->getOptionAdmin('pts_merchant_reivew');
        if ($pts_merchant_reivew<1){
            return false;
        }
        
        if(!$this->isMerchantSettingsDisabled()){
            $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$merchant_id);
            if($mt_disabled_pts==2){
                return false;
            }
        }
        
        $params=array(
          'client_id'=>$client_id,
          'total_points_earn'=>$pts_merchant_reivew,
          'status'=>'active',
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'trans_type'=>'review',
          'review_id'=>$review_id
        );
        if(!is_numeric($params['review_id'])){
            unset($params['review_id']);
        }       
        
        
        $this->functions->insertData('mt_points_earn',$params);
    }


    public static function PointsDefinition($points_type = 'earn', $trans_type = '', $order_id = '', $total_points_earn = '')
{
    $label = '';

    if ($points_type === "earn") {
        switch ($trans_type) {
            case "signup":
                $label = "Points gained by signing up";
                break;

            case "first_order":
                $label = "Points gained on first order";
                break;

            case "review":
                $label = "Points gained by reviewing";
                break;

            case "adjustment":
                $label = "Points adjusted by admin";
                break;

            case "booking":
                $label = "Points gained by Booking Table";
                break;

            default:
                $label = "Points gained by buy item Order ID: " . $order_id;
                break;
        }
    } else {
        switch ($trans_type) {
            case "adjustment":
                $label = "Points adjusted by admin";
                break;

            default:
                $label = "Points Exchanged Into Discount On Order: " . $order_id;
                break;
        }
    }

    return $label;
}


public function updateOrderBasedOnStatus($status = '', $order_id = '')
{
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    if ($points_enabled != 1) {
        return false;
    }

    // Fetch points earn data
    $stmt = $this->db->prepare("
        SELECT id, order_id, merchant_id, client_id, status
        FROM mt_points_earn
        WHERE order_id = :order_id
        LIMIT 1
    ");
    $stmt->execute([':order_id' => $order_id]);
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        if ($this->validateEarnByStatus($status, $res['merchant_id'])) {
            // Set to active
            $this->functions->updateData("mt_points_earn", ['status' => "active"], 'id', $res['id']);
            $this->UpdateFirstOrder($res['client_id'], $res['order_id'], 'active');
        } else {
            // Set to inactive
            $this->functions->updateData("mt_points_earn", ['status' => "inactive"], 'id', $res['id']);
            $this->UpdateFirstOrder($res['client_id'], $res['order_id'], 'inactive');
        }
    }

    // Update expenses points
    $this->updatePointsExpenses($order_id, $status);
}


public  function validateEarnByStatus($status='',$merchant_id='')
    {       
        $status_list = $this->functions->getOptionAdmin('pts_earn_points_status');
        
        if(!$this->isMerchantSettingsDisabled()){
            $mt_pts_earn_points_status=$this->functions->getOption('mt_pts_earn_points_status',$merchant_id);
            if(!empty($mt_pts_earn_points_status)){
                $status_list=$mt_pts_earn_points_status;
            }
        }
                
        if(!empty($status_list)){
            $status_array=json_decode($status_list,true);
            if(is_array($status_array) && count($status_array)>=1){             
                if(in_array($status,$status_array)){
                    return true;
                }
            }           
        }       
        return false;
    }


    public  function getBasedEarnings($merchant_id='')
    {
        $points_based_earn = $this->functions->getOptionAdmin('points_based_earn');     
                
        if(empty($points_based_earn)){
            $points_based_earn=1;
        }
        
        /*CHECK MERCHANT SETTINGS*/ 
        $points_disabled_merchant_settings=$this->functions->getOptionAdmin('points_disabled_merchant_settings');
        if($points_disabled_merchant_settings!=1){
            $mt_points_based_earn=$this->functions->getOption('mt_points_based_earn',$merchant_id);
            if($mt_points_based_earn>0){
                $points_based_earn=$mt_points_based_earn;
            }
        }
        
        return $points_based_earn;
    }
    
    public  function getTotalEarningPoints($amount='', $merchant_id='')
    {
        $pts_earning_points=$this->functions->getOptionAdmin('pts_earning_points');
        $pts_earning_points_value=$this->functions->getOptionAdmin('pts_earning_points_value');
        
        $points_disabled_merchant_settings=$this->functions->getOptionAdmin('points_disabled_merchant_settings');
                                
        if($points_disabled_merchant_settings!=1){
            if(!empty($merchant_id)){
                $mt_pts_earning_points=$this->functions->getOption('mt_pts_earning_points',$merchant_id);
                $mt_pts_earning_points_value=$this->functions->getOption('mt_pts_earning_points_value',$merchant_id);                   
                if($mt_pts_earning_points>0.01){                        
                    $pts_earning_points = $mt_pts_earning_points;
                }
                if($mt_pts_earning_points_value>0.01){                      
                    $pts_earning_points_value = $mt_pts_earning_points_value;
                }
            }
        }
            
        if ($amount>0 && $pts_earning_points_value>0 && $pts_earning_points>0){
            $t1=($amount/$pts_earning_points_value)*$pts_earning_points;                    
            //return intval($t1);
            return floatval($t1);
        }
    }


    public function UpdateFirstOrder($client_id = '', $order_id = '', $status = '')
{
    if (!empty($client_id) && !empty($order_id) && !empty($status)) {
        $stmt = $this->db->prepare("
            UPDATE mt_points_earn
            SET status = :status
            WHERE client_id = :client_id
            AND order_id = :order_id
            AND trans_type = 'first_order'
        ");
        $stmt->execute([
            ':status' => $status,
            ':client_id' => $client_id,
            ':order_id' => $order_id
        ]);
    }
}

public function updateOrderBasedOnStatus_x($status = '', $order_id = '')
{
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    if ($points_enabled != 1) {
        return false;
    }

    // Use direct variable in SQL (NO parameter binding)
    $stmt = $this->db->prepare("
        SELECT id, order_id, merchant_id, client_id, status
        FROM mt_points_earn
        WHERE order_id = '$order_id'
        LIMIT 1
    ");
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        if ($this->validateEarnByStatus($status, $res['merchant_id'])) {
            // Set to active
            $this->functions->updateData("mt_points_earn", ['status' => "active"], 'id', $res['id']);
            $this->UpdateFirstOrder($res['client_id'], $res['order_id'], 'active');
        } else {
            // Set to inactive
            $this->functions->updateData("mt_points_earn", ['status' => "inactive"], 'id', $res['id']);
            $this->UpdateFirstOrder($res['client_id'], $res['order_id'], 'inactive');
        }
    }

    // Update expenses points
    $this->updatePointsExpenses($order_id, $status);
}


    public function deleteReviews($review_id = '')
{
    $stmt = $this->db->prepare("
        DELETE FROM mt_points_earn
        WHERE review_id = :review_id
    ");
    $stmt->execute([':review_id' => $review_id]);
}


public  function rewardsBookTable($booking_id='', $client_id='', $merchant_id='')
    {
                
        $points_enabled=$this->functions->getOptionAdmin('points_enabled');
        if ($points_enabled<>1){
            return false;
        }
        
        if(!$this->isMerchantSettingsDisabled()){
            $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts',$merchant_id);
            if($mt_disabled_pts==2){
                return false;
            }
        }       
        
        $total_points_earn = $this->functions->getOptionAdmin('pts_book_table');
        if(is_numeric($client_id) && $total_points_earn>0){        
           
           $params=array(
             'client_id'=>$client_id,
             'total_points_earn'=>$total_points_earn,
             'date_created'=>$this->functions->dateNow(),
             'ip_address'=>$_SERVER['REMOTE_ADDR'],
             'trans_type'=>"booking",
             'booking_id'=>$booking_id
           );
           
           $this->functions->insertData("mt_points_earn",$params);
        }
    }



    public  function updateBookTable($booking_id='', $status='')
    {       
        
        
        $points_status='inactive';
        
        if($status=="approved"){
            $points_status='active';
        }
        
        

        $this->functions->updateData("mt_points_earn",array(
          'status'=>$points_status,
          'date_modified'=>$this->functions->dateNow()
        ),'booking_id',$booking_id);
        
        
    }
    
    public  function isMerchantSettingsDisabled()
    {

        $points_disabled_merchant_settings=$this->functions->getOptionAdmin('points_disabled_merchant_settings');

        if($points_disabled_merchant_settings==1){

            return true;
        }
        
        return false;
    }


    public function addReviewsPerOrder($order_id = '', $client_id = '', $review_id = '', $merchant_id = '', $order_status = '')
{
    $points_enabled = $this->functions->getOptionAdmin('points_enabled');
    if ($points_enabled != 1) {
        return;
    }

    $pts_merchant_review = $this->functions->getOptionAdmin('pts_merchant_reivew');
    if (!is_numeric($pts_merchant_review)) {
        return false;
    }

    if (!$this->isMerchantSettingsDisabled()) {
        $mt_disabled_pts = $this->functions->getOption('mt_disabled_pts', $merchant_id);
        if ($mt_disabled_pts == 2) {
            return false;
        }
    }

    $status = 'inactive';

    // Check if order status is valid for review points
    $earn_points_review_status = $this->functions->getOptionAdmin('earn_points_review_status');
    if (!empty($earn_points_review_status)) {
        $earn_points_review_status = json_decode($earn_points_review_status, true);
        if (in_array($order_status, (array) $earn_points_review_status)) {
            $status = 'active';
        }
    }

    $params = [
        'client_id' => $client_id,
        'order_id' => $order_id,
        'merchant_id' => $merchant_id,
        'total_points_earn' => $pts_merchant_review,
        'status' => $status,
        'date_created' => $this->functions->dateNow(),
        'ip_address' => $_SERVER['REMOTE_ADDR'],
        'trans_type' => 'review',
        'review_id' => $review_id
    ];

    // Check if review points already exist
    $stmt = $this->db->prepare("
        SELECT id FROM mt_points_earn
        WHERE order_id = :order_id
        AND merchant_id = :merchant_id
        AND trans_type = 'review'
        LIMIT 1
    ");
    $stmt->execute([
        ':order_id' => $order_id,
        ':merchant_id' => $merchant_id
    ]);
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$res) {
        // Insert new review points
        $this->functions->insertData('mt_points_earn', $params);
        return true;
    } else {
        // Update existing review points
        $params_update = [
            'status' => $status,
            'date_modified' => $this->functions->dateNow()
        ];

        $this->functions->updateData('mt_points_earn', $params_update, 'id', $res['id']);
    }

    return false;
}


public function cancelReviews($order_id = '')
{
    if ($order_id > 0) {
        // Update mt_points_earn table
        $stmt1 = $this->db->prepare("
            UPDATE mt_points_earn
            SET status = 'inactive'
            WHERE order_id = :order_id
            AND trans_type = 'review'
        ");
        $stmt1->execute([':order_id' => $order_id]);

        // Update mt_review table
        $stmt2 = $this->db->prepare("
            UPDATE mt_review
            SET status = 'draft'
            WHERE order_id = :order_id
        ");
        $stmt2->execute([':order_id' => $order_id]);

        return true;
    }

    return false;
}


public  function getReviewsStatus($order_status='')
    {
        $status = 'inactive';
        $earn_points_review_status = $this->functions->getOptionAdmin('earn_points_review_status');     
        if(!empty($earn_points_review_status)){
            $earn_points_review_status = json_decode($earn_points_review_status,true);          
            if(in_array($order_status,(array)$earn_points_review_status)){
                $status='active';
            }
        }
        return $status;
    }

public function udapteReviews($order_id = '', $order_status = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_points_earn
        WHERE order_id = :order_id
        AND trans_type = 'review'
        LIMIT 1
    ");
    $stmt->execute([':order_id' => $order_id]);

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $points_status = $this->getReviewsStatus($order_status);
        
        if ($res['status'] !== $points_status) {
            $params = [
                'status' => $points_status,
                'date_modified' => $this->functions->dateNow()
            ];

            $this->functions->updateData("mt_points_earn", $params, 'id', $res['id']);
        }
    }
}

public function updatePointsExpenses($order_id = '', $status = '')
{
    $stmt = $this->db->prepare("
        SELECT * FROM mt_points_expenses
        WHERE order_id = :order_id
        LIMIT 1
    ");
    $stmt->execute([':order_id' => $order_id]);

    if ($res = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if (!$this->validateEarnByStatus($status, $res['merchant_id'])) {
            $params = [
                'status' => 'inactive',
                'date_modified' => $this->functions->dateNow(),
                'ip_address' => $_SERVER['REMOTE_ADDR']
            ];
            $this->functions->updateData("mt_points_expenses", $params, 'id', $res['id']);
        } else {
            if ($res['status'] === "inactive") {
                $params = [
                    'status' => 'active',
                    'date_modified' => $this->functions->dateNow(),
                    'ip_address' => $_SERVER['REMOTE_ADDR']
                ];
                $this->functions->updateData("mt_points_expenses", $params, 'id', $res['id']);
            }
        }
    }
}













    








    








        


    


















    
    

    
}/* end class*/