<?php
class itemWrapper
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        $this->mobileWrapper = new mobileWrapper();
        $this->sizes = array();
        $this->enabled_trans=false;
        
        //$this->CronWrapper = new CronWrapper();
        

    }


  public function getMenu($merchant_id = '', $pagenumber = 0, $pagelimit = 10, $cart_data = array())
{
    $paginate_total = 0;
    $menu_type = $this->mobileWrapper->getMenuType();

    $default_image = '';

    $disabled_default_image = $this->functions->getOptionAdmin('mobile2_disabled_default_image');
    $merchant_menu_type = $this->functions->getOptionAdmin('mobileapp2_merchant_menu_type');
    if ($merchant_menu_type == 3) {
        $default_image = 'resto_banner.jpg';
        $disabled_default_image = false;
    }

    if ($merchant_id > 0) {
        $this->sizes = $this->getSize($merchant_id);

        $todays_day = strtolower(date("l"));

        $and = '';

        $enabled_category_sked = $this->functions->getOption('enabled_category_sked', $merchant_id);
        if ($enabled_category_sked == 1) {
            $and .= " AND $todays_day='1' ";
        }

        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS *
            FROM mt_category
            WHERE merchant_id = :merchant_id
            AND status IN ('publish','published')
            AND web_available =2
            $and
            ORDER BY sequence, date_created ASC
            LIMIT :pagenumber, :pagelimit
        ";

        $query = $this->db->prepare($stmt);
        $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindValue(':pagenumber', (int)$pagenumber, PDO::PARAM_INT);
        $query->bindValue(':pagelimit', (int)$pagelimit, PDO::PARAM_INT);
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            $total_records = 0;
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $queryc = $this->db->query($stmtc);
            if ($resp = $queryc->fetch(PDO::FETCH_ASSOC)) {
                $total_records = $resp['total_records'];
            }

            $paginate_total = ceil($total_records / $pagelimit);

            $data = [];
            foreach ($res as $val) {
                $new_data['cat_id'] = $val['cat_id'];
                $new_data['category_name'] = $val['category_name'];
                $new_data['category_description'] = $val['category_description'];
                $new_data['category_pic'] = $this->mobileWrapper->getImage($val['photo'], $default_image, $disabled_default_image);

                if ($this->enabled_trans == true) {
                    $category_name = !empty($val['category_name_trans']) ? json_decode($val['category_name_trans'], true) : '';
                    // Merge translations with the original category name
                    $new_data['category_name'] = isset($category_name[$todays_day]) ? $category_name[$todays_day] : $new_data['category_name'];

                    $category_description = !empty($val['category_description_trans']) ? json_decode($val['category_description_trans'], true) : '';
                    // Merge translations with the original category description
                    $new_data['category_description'] = isset($category_description[$todays_day]) ? $category_description[$todays_day] : $new_data['category_description'];
                }

                if ($menu_type == 1) {
                    $item_data = $this->getItemByCategory($merchant_id, $val['cat_id'], false, 0, 10, array(), $cart_data);
                    $new_data['item'] = is_array($item_data['data']) ? $item_data['data'] : array();
                }

                $data[] = $new_data;
            }

            return [
                'paginate_total' => $paginate_total,
                'list' => $data
            ];
        }
    }
    return false;
}

public function getsizes(){
   return $this->sizes;
}



public function getMerchantCategory($merchant_id = '')
{
    $data = array();
    if ($merchant_id > 0) {
        $todays_day = strtolower(date("l"));

        $and = '';

        $enabled_category_sked = $this->functions->getOption('enabled_category_sked', $merchant_id);
        if ($enabled_category_sked == 1) {
            $and .= " AND $todays_day='1' ";
        }

        $cart_theme = $this->functions->getOptionAdmin('mobileapp2_cart_theme');

        $stmt = "
            SELECT 
            cat_id,
            category_name,
            category_description,
            photo,
            status,
            category_name_trans,
            category_description_trans
            FROM mt_category
            WHERE merchant_id = :merchant_id
            AND status IN ('publish','published')
            AND web_available=2
            $and
            ORDER BY sequence, date_created ASC
            LIMIT 0,1000
        ";

        $query = $this->db->prepare($stmt);
        $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->execute();

        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            if ($cart_theme == 2) {
                $this->enabled_trans = true;
            }

            if ($this->enabled_trans != true) {
                return $res;
            }

            foreach ($res as $val) {
                // Correctly merge translations into the category name and description
                $category_name_trans = !empty($val['category_name_trans']) ? json_decode($val['category_name_trans'], true) : [];
                $category_description_trans = !empty($val['category_description_trans']) ? json_decode($val['category_description_trans'], true) : [];

                // Check if translations exist, else fallback to original values
                $val['category_name'] = isset($category_name_trans[$todays_day]) ? $category_name_trans[$todays_day] : $val['category_name'];
                $val['category_description'] = isset($category_description_trans[$todays_day]) ? $category_description_trans[$todays_day] : $val['category_description'];

                if ($cart_theme == 2) {
                    $item_count = $this->getItemCountByCategory($val['cat_id']);
                    $val['item_count'] = "item " . $item_count;
                }

                $data[] = $val;
            }
            return $data;
        }
    }
    return false;
}


public function getCategoryByID($cat_id = '')
{
    if ($cat_id > 0) {
        $stmt = "
            SELECT 
                cat_id,
                category_name,
                category_description,
                photo,
                status,
                category_name_trans,
                category_description_trans
            FROM mt_category
            WHERE cat_id = :cat_id
            AND status IN ('publish')
            LIMIT 1
        ";

        $query = $this->db->prepare($stmt);
        $query->bindValue(':cat_id', $cat_id, PDO::PARAM_INT);
        $query->execute();

        if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
            return $res;
        }
    }
    return false;
}



public function getItemByCategory($merchant_id = '', $category_id = '', $paginate = false, 
    $pagenumber = 0, $pagelimit = 10, $filter_dishes = array(), $cart_data = array())
{
    $paginate_total = 0;
    $limit = "LIMIT $pagenumber, $pagelimit";

    if ($merchant_id > 0 && $category_id > 0) {

        if (!$paginate) {
            $limit = '';
        }

        $and = '';

        $default_image = '';

        $disabled_default_image = $this->functions->getOptionAdmin('mobile2_disabled_default_image');
        $merchant_menu_type = $this->functions->getOptionAdmin('mobileapp2_merchant_menu_type');
        if ($merchant_menu_type == 3) {
            $default_image = 'resto_banner.jpg';
            $disabled_default_image = false;
        }

        $food_option_not_available = $this->functions->getOption('food_option_not_available', $merchant_id);
        if ($food_option_not_available == 1) {
            $and = "AND not_available <> '2' ";
        }

        if (!empty($filter_dishes)) {
            $and .= " AND dish LIKE '%" . implode(',', $filter_dishes) . "%' ";
        }

        $stmt = "
        SELECT SQL_CALC_FOUND_ROWS 
        item_id,
        merchant_id,
        item_name,
        item_description,
        item_name_trans,
        item_description_trans,
        status,
        price,
        photo,
        discount,
        dish,
        addon_item,
        cooking_ref,
        ingredients
        FROM mt_item
        WHERE category LIKE '%$category_id%'
        AND status IN ('publish','published')
        AND merchant_id = $merchant_id
        $and
        ORDER BY sequence ASC
        $limit
        ";
        $this->InventoryWrapper=new InventoryWrapper();

            /*inventory*/               
        if($this->functions->inventoryEnabled($merchant_id)){
            $and_inv = '';
            if(!empty($filter_dishes)){         
                $and_inv.=" AND dish like ".('%"'.$filter_dishes.'"%')." ";
            }
            
            if($this->InventoryWrapper->hideItemOutStocks($merchant_id)){
               $stmt="
                SELECT SQL_CALC_FOUND_ROWS 
                item_id,
                merchant_id,
                item_name,
                item_description,
                item_name_trans,
                item_description_trans,
                status,
                price,
                photo,
                discount,
                dish,
                addon_item,
                cooking_ref,
                ingredients
                
                FROM
                mt_item a
                WHERE
                category like '%\"$category_id\"%'
                AND
                status IN ('publish','published')
                AND merchant_id = ".($merchant_id)."
                $and_inv
                AND item_id IN (
                          select item_id from mt_view_item_stocks_status
                          where available ='1'
                          and track_stock='1'
                          and stock_status not in ('Out of stocks')     
                          and item_id = a.item_id                 
                        )       
                        
                ORDER BY sequence ASC
                $limit
                ";          
            } else {                
                if($food_option_not_available==1):
                $stmt="
                SELECT SQL_CALC_FOUND_ROWS 
                item_id,
                merchant_id,
                item_name,
                item_description,
                item_name_trans,
                item_description_trans,
                status,
                price,
                photo,
                discount,
                dish,
                addon_item,
                cooking_ref,
                ingredients
                
                FROM
                mt_item a
                WHERE
                category like '%\"$category_id\"%'
                AND
                status IN ('publish','published')
                AND merchant_id = ".($merchant_id)."
                $and_inv
                AND item_id IN (
                  select item_id from mt_view_item_stocks_status
                  where available ='1'                        
                  and item_id = a.item_id                 
                )                               
                ORDER BY sequence ASC
                $limit
                ";      
                endif;
            }           
        }   





$query = $this->db->query($stmt);

if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {

            $total_records = 0;
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $queryc = $this->db->prepare($stmtc);
            $queryc->execute();

            if ($resp = $queryc->fetch(PDO::FETCH_ASSOC)) {
                $total_records = $resp['total_records'];
            }

            $paginate_total = ceil($total_records / $pagelimit);

            $data = array();
            foreach ($res as $val) {
                $price = '';
                $prices = array();
                $prices2 = array();

                if (json_decode($val['price'])) {
                    $price = json_decode($val['price'], true);
                    foreach ($price as $size_id => $priceval) {
                        $original_price = $priceval;
                        $discounted_price = 0;

                        if ($val['discount'] >= 0.001) {
                            $priceval = $priceval - $val['discount'];
                            $discounted_price = $priceval;
                        }

                        if (array_key_exists($size_id, (array)$this->sizes)) {
                            $prices[] = $this->sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($priceval);
                            $prices2[] = array(
                                'original_price' => $this->sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($original_price),
                                'discount' => $val['discount'],
                                'discounted_price_pretty' => $this->sizes[$size_id] . "&nbsp;" . $this->functions->prettyPrice($priceval),
                            );
                        } else {
                            $prices[] = $this->functions->prettyPrice($priceval);
                            $prices2[] = array(
                                'original_price' => $this->functions->prettyPrice($original_price),
                                'discount' => $val['discount'],
                                'discounted_price_pretty' => $this->functions->prettyPrice($priceval),
                            );
                        }
                    }
                }

                if ($this->enabled_trans == TRUE) {
                    // Proper translation logic
                    $item_name_trans = !empty($val['item_name_trans']) ? json_decode($val['item_name_trans'], true) : [];
                    $item_description_trans = !empty($val['item_description_trans']) ? json_decode($val['item_description_trans'], true) : [];

                    // Check if translations exist, else fallback to original values
                    $val['item_name'] = isset($item_name_trans[$todays_day]) ? $item_name_trans[$todays_day] : $val['item_name'];
                    $val['item_description'] = isset($item_description_trans[$todays_day]) ? $item_description_trans[$todays_day] : $val['item_description'];
                }

                $val['photo'] = $this->mobileWrapper->getImage($val['photo'], $default_image, $disabled_default_image);
                $val['item_description'] = $val['item_description'];

                $val['prices'] = $prices;
                $val['prices2'] = $prices2;
                $val['cat_id'] = $category_id;

                $icon_dish = array();
                if (!empty($val['dish'])) {
                    $icon_dish = $this->functions->getDishIcon($val['dish']);
                }

                $val['dish_image'] = $icon_dish;

                $customizable = false;
                if (is_array($val['prices']) && count((array)$val['prices']) >= 2) {
                    $customizable = true;
                }
                if (!empty($val['addon_item'])) {
                    $customizable = true;
                }
                if (!empty($val['cooking_ref'])) {
                    $customizable = true;
                }
                if (!empty($val['ingredients'])) {
                    $customizable = true;
                }

                $val['customizable'] = $customizable;

                $val['added_qty'] = 0;
                if (!$customizable) {
                    $item_id = $val['item_id'];
                    $category_id = $val['cat_id'];
                    if (is_array($cart_data) && count($cart_data) >= 1) {
                        foreach ($cart_data as $cart_data_val) {
                            if ($item_id == $cart_data_val['item_id'] && $category_id == $cart_data_val['category_id']) {
                                $val['added_qty'] = $cart_data_val['qty'];
                            }
                        }
                    }
                }

                $data[] = $val;
            }

            return array(
                'data' => $data,
                'paginate_total' => $paginate_total
            );
        }
    }
    return false;
}



public function getSize($merchant_id = '')
{   
    $stmt = "SELECT size_id, size_name, size_name_trans FROM mt_size 
             WHERE merchant_id = :merchant_id AND status = 'publish'";
    
    $query = $this->db->prepare($stmt);
    $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->execute();
    
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $data = [];
        foreach ($res as $val) {
            if ($this->enabled_trans == TRUE) {
    $val['size_name'] = isset($val['size_name_trans']) ? json_decode($val['size_name_trans'], true)[$val['size_name']] : $val['size_name'];
}

            $data[$val['size_id']] = $val['size_name'];
        }
         $this->sizes =$data;
        return $data;
    }
    return false;
}

public function searchItemByName_bkup_25_feb($merchant_id = '', $item_name = '')
{
    if ($merchant_id > 0 && !empty($item_name)) {
        $stmt = "SELECT 
            item_id,
            merchant_id,
            item_name,
            category,
            item_name_trans,
            item_description,
            item_description_trans,
            photo
        FROM mt_item
        WHERE merchant_id = :merchant_id
        AND item_name LIKE :item_name
        AND not_available <> '2'
        ORDER BY item_name ASC
        LIMIT 100";

        $query = $this->db->prepare($stmt);
        $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindValue(':item_name', "%$item_name%", PDO::PARAM_STR);
        $query->execute();
        
        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            return $res;
        }
    }
    return false;
}

public function searchItemByName($merchant_id = '', $item_name = '')
{
    if ($merchant_id > 0 && !empty($item_name)) {

        try {

            $stmt = "
            SELECT 
                i.item_id,
                i.merchant_id,
                i.item_name,
                i.category,
                i.item_name_trans,
                i.item_description,
                i.item_description_trans,
                i.photo
            FROM mt_item i
            WHERE i.merchant_id = :merchant_id
            AND i.item_name LIKE :item_name
            AND i.not_available <> '2'
            AND EXISTS (
                SELECT 1 
                FROM mt_category c
                WHERE c.web_available = '2'
                AND JSON_CONTAINS(i.category, CONCAT('\"', c.cat_id, '\"'))
            )
            ORDER BY i.item_name ASC
            LIMIT 100
            ";

            $query = $this->db->prepare($stmt);
            $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
            $query->bindValue(':item_name', "%$item_name%", PDO::PARAM_STR);
            $query->execute();

            return $query->fetchAll(PDO::FETCH_ASSOC);

        } catch (PDOException $e) {
            return "SQL Error: " . $e->getMessage();
            exit;
        }
    }

    return false;
}


    public function searchByCategoryByName($merchant_id = '', $category_name = '')
{
    if ($merchant_id > 0 && !empty($category_name)) {
        
        $and = '';
        $todays_day = strtolower(date("l"));
        $enabled_category_sked = $this->functions->getOption('enabled_category_sked', $merchant_id); 
        
        if ($enabled_category_sked == 1) {
            $and .= " AND $todays_day = '1' ";
        }

        $stmt = "SELECT 
            cat_id,
            merchant_id,
            category_name,
            category_description,
            photo,
            status,
            category_name_trans,
            category_description_trans          
        FROM mt_category
        WHERE merchant_id = :merchant_id  
        AND web_available = 2               
        $and        
        AND (category_name LIKE :category_name OR 
             category_description LIKE :category_name)           
        ORDER BY category_name ASC";

        $query = $this->db->prepare($stmt);
        $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->bindValue(':category_name', "%$category_name%", PDO::PARAM_STR);
        $query->execute();
        
        if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
            return $res;
        }
    }
    return false;
}


public function translateCookingRef($data = array())
{
    $new_data = array();
    if ($this->enabled_trans == TRUE) {
        if (is_array($data) && count($data) >= 1) {
            foreach ($data as $cook_id => $val) {
                if ($res = $this->functions->getCookingRef($cook_id)) {
                    // Corrected the translation part, just accessing the translation directly
                    $translated_name = isset($res['cooking_name_trans']) ? json_decode($res['cooking_name_trans'], true)[$res['cooking_name']] : $res['cooking_name'];
                    $val['cooking_name'] = $translated_name;
                }
                $new_data[$cook_id] = $val;
            }
            return $new_data;
        }
    }
    return $data;
}

public function translateIngredients($data = array())
{
    $new_data = array();
    if ($this->enabled_trans == TRUE) {
        if (is_array($data) && count($data) >= 1) {
            foreach ($data as $ingredients_id => $val) {
                if ($res = $this->functions->getIngredients($ingredients_id)) {
                    // Corrected the translation part, just accessing the translation directly
                    $translated_name = isset($res['ingredients_name_trans']) ? json_decode($res['ingredients_name_trans'], true)[$res['ingredients_name']] : $res['ingredients_name'];
                    $val['ingredients_name'] = $translated_name;
                }
                $new_data[$ingredients_id] = $val;
            }
            return $new_data;
        }
    }
    return $data;
}



    public function dishesList()
{
    $data = [];

    $stmt = "SELECT dish_id, dish_name 
             FROM mt_dishes 
             WHERE status IN ('publish') 
             ORDER BY dish_id ASC";

    $query = $this->db->prepare($stmt);
    $query->execute();

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        foreach ($res as $val) {
            $data[] = [
                'dish_id'   => $val['dish_id'],
                'dish_name' => $val['dish_name'],
            ];
        }
    }

    return $data;
}


public function getItemCountByCategory($category_id = '')
{
    $stmt = $this->db->prepare("SELECT COUNT(*) AS total FROM mt_item WHERE category LIKE :category");
    $category_param = "%" . $category_id . "%"; // Using LIKE with wildcards for partial match
    $stmt->bindParam(':category', $category_param, PDO::PARAM_STR);

    if ($stmt->execute()) {
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result['total'];
    }
    return 0;
}

public  function limitText($p='',$text='', $limit = 100)
    {
        return $text;
        
    }

   public function insertTagRelationship($banner_id = '', $tag_ids = array())
{
    // Delete existing relationships for the given banner_id
    $stmt = $this->db->prepare("DELETE FROM mt_tags_relationship WHERE banner_id = :banner_id");
    $stmt->bindParam(':banner_id', $banner_id, PDO::PARAM_INT);
    $stmt->execute();

    // Insert new tag relationships if there are any
    if (is_array($tag_ids) && count($tag_ids) >= 1) {
        foreach ($tag_ids as $tag_id) {
            $this->functions->insertData("mt_tags_relationship", array(
                'banner_id' => $banner_id,
                'tag_id' => $tag_id
            ));
        }
    }
}


public function getItem($id = '')
{
    $stmt = $this->db->prepare("SELECT * FROM mt_item WHERE item_id = :item_id LIMIT 1");
    $stmt->bindParam(':item_id', $id, PDO::PARAM_INT);
    $stmt->execute();

    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    return false;
}

public function getSizeByID($size_id = 0)
{
    $stmt = $this->db->prepare("SELECT * FROM mt_size WHERE size_id = :size_id LIMIT 1");
    $stmt->bindParam(':size_id', $size_id, PDO::PARAM_INT);
    $stmt->execute();

    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    return false;
}

public function verifyItemAvailable($item_id = 0)
{
    $stmt = $this->db->prepare("SELECT item_id, not_available FROM mt_item WHERE item_id = :item_id LIMIT 1");
    $stmt->bindParam(':item_id', $item_id, PDO::PARAM_INT);
    $stmt->execute();

    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        if ($resp['not_available'] == 2) {
            throw new Exception("Sorry but this item is not available");
        }
        return true;
    }

    throw new Exception("Item details not found");
}








	


        



	
	
	
	
	
  			
	    
}
/*END CLASS*/