<?php




class IndexController extends Controller {


    protected $functions;
    

    public function __construct() {

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
       
        $this->functions = new Functions();

        
        $this->mobileWrapper = new mobileWrapper();
        $this->htmlWrapper = new htmlWrapper();
        $this->BootstrapWrapper = new BootstrapWrapper();

        //echo "he";die();
        

        $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     
      date_default_timezone_set($website_timezone);
    //}
      //echo $_REQUEST['url'];die();

     if (!$this->functions->isAdminLogin() && $_REQUEST['url']!='admin/login'){           
       //print_r($_REQUEST);
        //$this->login();
    $bases=Config::$baseUrl;
    header("Location: ".$bases."/admin/login");
exit();
    
        }



   //echo date('Y-m-d H:i:s');die();

    }

    public function index() {

    
         
        //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call
   

        $data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"API Settings",
            'tpl'=>"settings_api",
            'data'=>array()
             
            ];
        $this->view('mobileapp/general_settings', $data, 'layouts_mobileapp/layout'); 
    }



    public function settings() {

        
        //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call
   

        $data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"API Settings",
            'tpl'=>"settings_api",
            'data'=>array()
             
            ];
        $this->view('mobileapp/general_settings', $data, 'layouts_mobileapp/layout'); 
    }

    public function test_api()
  {
    $api_has_key = $this->functions->getOptionAdmin('mobileapp2_api_has_key');    
    
    $api_settings = Config::$baseUrl."/mobileappv2/api/getsettings";
    if(!empty($api_has_key)){
      $api_settings.="/?api_key=".urlencode($api_has_key);
    }       
     header("Location: " . $api_settings);  // Redirects to the specified URL
     exit();  // Ensure no further code is executed after the redirect
  }


    public function settings_application()
  {

    //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call

    $this->pageTitle = "Settings";

    $country_list=$this->functions->CountryList();
    
    $mobile_country_list=$this->functions->getOptionAdmin('mobile_country_list');
    if (!empty($mobile_country_list)){
      $mobile_country_list=json_decode($mobile_country_list);
    } else $mobile_country_list=array();
    
    $search_options = $this->mobileWrapper->getDataSearchOptions();
    
    $data = array(
      'country_list'=>$country_list,
      'mobile_country_list'=>$mobile_country_list,
      'search_options'=>$search_options,
      'order_status_list'=>$this->functions->orderStatusList2(true)
    );
    
    
    $ref_data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"Application Settings",
            'tpl'=>"settings_application",
            'data'=>$data
             
            ];
        $this->view('mobileapp/general_settings', $ref_data, 'layouts_mobileapp/layout'); 



  }


    public function operating_hours()
  {

    //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call

    
    
    $data = array();
    $days=$this->functions->getDays();
    $data['days']=$days;
    $data['time_list'] = $this->functions->timeList();
    $data['opening_hours'] = $this->mobileWrapper->getOperatingHours();

    $ref_data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"Operating hours",
            'tpl'=>"operating_hours",
            'data'=>$data
             
            ];

    
          
    $this->view('mobileapp/general_settings', $ref_data, 'layouts_mobileapp/layout'); 



  }


  public function settings_startup()
  {

    //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call
    
        
    $startup_banner = $this->functions->getOptionAdmin('mobileapp2_startup_banner');   
    
   
    
    

    $ref_data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"App Startup",
            'tpl'=>"settings_startup",
            'data'=>array(
                 'startup_banner'=>!empty($startup_banner)?json_decode($startup_banner):false
                  )
             
            ];

          
    $this->view('mobileapp/general_settings', $ref_data, 'layouts_mobileapp/layout'); 



  }



  public function settings_social_login()
  {
    $this->pageTitle = "Settings";
        
    //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call
    

    $ref_data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"Social Login",
            'tpl'=>"settings_social_login",
            'data'=>array()
             
            ];

          
    $this->view('mobileapp/general_settings', $ref_data, 'layouts_mobileapp/layout'); 



  }


  public function settings_analytics()
  {

    //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call



    

    $ref_data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"Google Analytics",
            'tpl'=>"settings_analytics",
            'data'=>array()
             
            ];

          
    $this->view('mobileapp/general_settings', $ref_data, 'layouts_mobileapp/layout'); 





  }


  public function settings_android()
  {

    //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call
       
   

     $ref_data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"Android Settings",
            'tpl'=>"settings_android",
            'data'=>array(
        'upload_push_icon'=>$this->functions->getOptionAdmin('android_push_icon'),
            'upload_push_picture'=>$this->functions->getOptionAdmin('android_push_picture'),
      )
             
            ];

 $this->view('mobileapp/general_settings', $ref_data, 'layouts_mobileapp/layout');

  }


  public function settings_fcm()
  {

    //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call

    

     $ref_data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"FCM",
            'tpl'=>"settings_fcm",
            'data'=>array()
             
            ];

 $this->view('mobileapp/general_settings', $ref_data, 'layouts_mobileapp/layout');



  } 


public function rating_app()
  {
    
    $data = array();

    //+++must for every call
        $provider = $this->functions->getMapProvider(); 
        $map_api = isset($provider['map_api'])?trim($provider['map_api']):'';
        
        switch ($provider['provider']) {
      case "google.maps":
          $map_type='google';
          break;
      case "mapbox": 
      $map_type='mapbox';         
          break;    
        default:
          break;
      }
        //---must for every call

    
    

    $ref_data = [
            'map_api'=>$map_api,
            'provider'=>$provider['provider'],
            'map_type'=>$map_type,
            'pageTitle' => $this->functions->translation('default', "Settings"),
            'settings_title'=>"FCM",
            'tpl'=>"rating_app",
            'data'=>$data
             
            ];

$this->view('mobileapp/general_settings', $ref_data, 'layouts_mobileapp/layout');



  }


  public function device_list()
  {
    
    
     $ref_data = [
            
            'pageTitle' => $this->functions->translation('default', "Device List")
            
             
            ];

$this->view('mobileapp/device_list', $ref_data, 'layouts_mobileapp/layout');


    
  }


  public function broadcast_list()
  {
    

     $ref_data = [
            
            'pageTitle' => $this->functions->translation('default', "Broadcast")
            
             
            ];

$this->view('mobileapp/broadcast_list', $ref_data, 'layouts_mobileapp/layout');


    
  }


  public function old_broadcast()
  {
    

    $ref_data = [
            
            'pageTitle' => $this->functions->translation('default', "Broadcast")
            
             
            ];

$this->view('mobileapp/broadcast_old_list', $ref_data, 'layouts_mobileapp/layout');

  }



  public function broadcast_details($params=[])
  {
    $bid=$params['bid'];
    if(isset($bid)){
    $_GET['bid']=$bid;
    }
    $bid = isset($_GET['bid'])?$_GET['bid']:'';

    $ref_data = [
            'pageTitle' => $this->functions->translation('default', "Broadcast details"),
             'bid'=>$bid
            ];

$this->view('mobileapp/push_list', $ref_data, 'layouts_mobileapp/layout');


    
  }


  public function push_list()
  {
    

    $ref_data = [
            'pageTitle' => $this->functions->translation('default', "Push Logs")
            ];

$this->view('mobileapp/push_list', $ref_data, 'layouts_mobileapp/layout');

  }


  public function order_trigger()
  {
    

    $ref_data = [
            'pageTitle' => $this->functions->translation('default', "Order Trigger Notification")
            ];

   $this->view('mobileapp/order_trigger', $ref_data, 'layouts_mobileapp/layout');

  }


  public function home_category()
  {   
    
    
    
    $category = 'home_category';
    

      $ref_data = [
        'category'=>$category,
            'pageTitle' => $this->functions->translation('default', "Home categories"),
            'add_link'=>Config::$baseUrl."/mobileappv2/index/home_category_new"
            ];

   $this->view('mobileapp/banner_list', $ref_data, 'layouts_mobileapp/layout');


  }


    public function home_category_new($params=[])
  {
     $banner_id=$params['banner_id'];
    if(isset($banner_id)){
    $_GET['banner_id']=$banner_id;
    } 
    
    $category = 'home_category';
    $data = $_GET; $banner_id = '';  $resp = array();
    if(isset($data['banner_id'])){
      $banner_id = $data['banner_id'];
      if(!$resp = $this->mobileWrapper->getHomeBannerByID($banner_id)){
       

        $ref_data = [
            'pageTitle' => $this->functions->translation('default', "Home Banner"),
            'error' => $this->functions->translation('default', "sorry but we cannot find what you are looking for")
            ];

   $this->view('mobileapp/error', $ref_data, 'layouts_mobileapp/layout');



        return ;
      }
    }
    
    $last_increment = $this->functions->getLastIncrement('mt_mobile2_homebanner');  
    
    $tags = array();
        
      $tags =   (array)$this->functions->dropdownFormat(
         $this->functions->getTags(),'tag_id','tag_name'
      );
            
    
    


    


    $ref_data = [
      'pageTitle' => $this->functions->translation('default', "Home categories"),
            'data'=>$resp,
     'last_increment'=>$last_increment+0,
     'tags'=>(array)$tags,
     'category'=>$category,
     'back_url'=>Config::$baseUrl."/mobileappv2/index/home_category"
            ];

    


   $this->view('mobileapp/banner_add', $ref_data, 'layouts_mobileapp/layout');




  }



  public function home_banner_list()
  {   
          
    $category = 'home_banner';
    
    
   

    $ref_data = [
      'pageTitle' => $this->functions->translation('default', "Home Banner"),
            'category'=>$category,
      'add_link'=>Config::$baseUrl."/mobileappv2/index/home_banner_new"
            ];

     $this->view('mobileapp/banner_list', $ref_data, 'layouts_mobileapp/layout');


  }


  public function page_list()
  {
    
    
    

    $ref_data = [
      'pageTitle' => $this->functions->translation('default', "Page")
            ];

     $this->view('mobileapp/page_list', $ref_data, 'layouts_mobileapp/layout');


  }


  public function others()
  {
    


    
    $cron[] = array(
      'link'=>Config::$baseUrl."/mobileappv2/cron/processpush",
      'notes'=>$this->functions->translation("default","run this every minute")
    );
    $cron[] = array(
      
      'link'=>Config::$baseUrl."/mobileappv2/cron/processbroadcast",
      'notes'=>$this->functions->translation("default","run this every minute")
    );
    $cron[] = array(
      
      'link'=>Config::$baseUrl."/mobileappv2/cron/processoldbroadcast",
      'notes'=>$this->functions->translation("default","run this every minute")
    );
    $cron[] = array(
      
      'link'=>Config::$baseUrl."/mobileappv2/cron/triggerorder",
      'notes'=>$this->functions->translation("default","run this every minute")
    );
    $cron[] = array(
      
      'link'=>Config::$baseUrl."/mobileappv2/cron/getfbavatar",
      'notes'=>$this->functions->translation("default","run this every 5 minutes")
    );
    $cron[] = array(
      
      'link'=>Config::$baseUrl."/mobileappv2/cron/removeinactivedevice",
      'notes'=>$this->functions->translation("default","run once in a day")
    );
    
    $update_db = "";
    
   

    $ref_data = [
      'pageTitle' => $this->functions->translation('default', "Others"),
      'cron'=>$cron,
      'cron_sample'=>$cron[0]['link'],
      'update_db'=>$update_db
            ];

     $this->view('mobileapp/others', $ref_data, 'layouts_mobileapp/layout');


  }





  






  
}
