<?php
class AjaxController extends Controller
{
	public $code=2;
	public $msg;
	public $details;
	public $data;	
	public $merchant_id;
	
	public function __construct()
	{
		$this->data=$_POST;	
		$this->functions = new Functions();
		$this->mobileWrapper = new mobileWrapper();
        $this->DatatablesWrapper = new DatatablesWrapper();
        $this->itemWrapper = new itemWrapper();
        

		$model = Model::getInstance();
        
        $this->db = $model->getDb();
		
	}
	
	
	
	public function jsonResponse()
{
    $resp = array('code' => $this->code, 'msg' => $this->msg, 'details' => $this->details);
    echo json_encode($resp);
    exit();
}

	
	public function otableNodata()
	{
		if (isset($_POST['draw'])){
			$feed_data['draw']=$_POST['draw'];
		} else $feed_data['draw']=1;	   
		     
        $feed_data['recordsTotal']=0;
        $feed_data['recordsFiltered']=0;
        $feed_data['data']=array();		
        echo json_encode($feed_data);
    	die();
	}

	public function otableOutput($feed_data='')
	{
	  echo json_encode($feed_data);
	  die();
    }
    
	
	public function OKresponse()
	{
		$this->code = 1; $this->msg = "OK"; $this->details = array();
	}
	
	
	public function getNotification()
    {
      $this->msg = "No new notification";
        $this->jsonResponse();
    }

    public function savesettings()
    {
    
        $this->functions->updateOptionAdmin('mobileapp2_api_has_key',
        isset($this->data['mobileapp2_api_has_key'])? trim($this->data['mobileapp2_api_has_key']) :''
        );
            
        $this->code=1;
        $this->msg="settings saved";
        $this->jsonResponse();  
    }


    public function savesettings_app()
    {
      $this->functions->updateOptionAdmin('mobileapp2_language',
    isset($this->data['mobileapp2_language'])?$this->data['mobileapp2_language']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_select_map',
    isset($this->data['mobileapp2_select_map'])?$this->data['mobileapp2_select_map']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_location_accuracy',
    isset($this->data['mobileapp2_location_accuracy'])?$this->data['mobileapp2_location_accuracy']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_offer',
    isset($this->data['mobile2_home_offer'])?$this->data['mobile2_home_offer']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_featured',
    isset($this->data['mobile2_home_featured'])?$this->data['mobile2_home_featured']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_cuisine',
    isset($this->data['mobile2_home_cuisine'])?$this->data['mobile2_home_cuisine']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_all_restaurant',
    isset($this->data['mobile2_home_all_restaurant'])?$this->data['mobile2_home_all_restaurant']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_merchant_list_type',
    isset($this->data['mobileapp2_merchant_list_type'])?$this->data['mobileapp2_merchant_list_type']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_merchant_menu_type',
    isset($this->data['mobileapp2_merchant_menu_type'])?$this->data['mobileapp2_merchant_menu_type']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_disabled_default_image',
    isset($this->data['mobile2_disabled_default_image'])?$this->data['mobile2_disabled_default_image']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_distance_results',
    isset($this->data['mobileapp2_distance_results'])?$this->data['mobileapp2_distance_results']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_search_data',
    isset($this->data['mobile2_search_data'])?json_encode($this->data['mobile2_search_data']):''
    );
    
    $this->functions->updateOptionAdmin('mobile2_enabled_menu_carousel',
    isset($this->data['mobile2_enabled_menu_carousel'])?$this->data['mobile2_enabled_menu_carousel']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_order_processing',
    isset($this->data['mobileapp2_order_processing'])?json_encode($this->data['mobileapp2_order_processing']):''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_order_completed',
    isset($this->data['mobileapp2_order_completed'])?json_encode($this->data['mobileapp2_order_completed']):''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_order_cancelled',
    isset($this->data['mobileapp2_order_cancelled'])?json_encode($this->data['mobileapp2_order_cancelled']):''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_favorite_restaurant',
    isset($this->data['mobile2_home_favorite_restaurant'])?$this->data['mobile2_home_favorite_restaurant']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_show_only_current_location',
    isset($this->data['mobile2_show_only_current_location'])?$this->data['mobile2_show_only_current_location']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_enabled_dish',
    isset($this->data['mobile2_enabled_dish'])?$this->data['mobile2_enabled_dish']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_turnoff_prefix',
    isset($this->data['mobileapp2_turnoff_prefix'])?$this->data['mobileapp2_turnoff_prefix']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_reg_email',
    isset($this->data['mobileapp2_reg_email'])?$this->data['mobileapp2_reg_email']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_reg_phone',
    isset($this->data['mobileapp2_reg_phone'])?$this->data['mobileapp2_reg_phone']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_prefix',
    isset($this->data['mobileapp2_prefix'])?$this->data['mobileapp2_prefix']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_tracking_theme',
    isset($this->data['mobileapp2_tracking_theme'])?$this->data['mobileapp2_tracking_theme']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_tracking_interval',
    isset($this->data['mobileapp2_tracking_interval'])?$this->data['mobileapp2_tracking_interval']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_disabled_image_menu1',
    isset($this->data['mobile2_disabled_image_menu1'])?$this->data['mobile2_disabled_image_menu1']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_banner',
    isset($this->data['mobile2_home_banner'])?$this->data['mobile2_home_banner']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_cart_auto_address',
    isset($this->data['mobileapp2_cart_auto_address'])?$this->data['mobileapp2_cart_auto_address']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_cart_theme',
    isset($this->data['mobileapp2_cart_theme'])?$this->data['mobileapp2_cart_theme']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_search_mode',
    isset($this->data['mobileapp2_search_mode'])?$this->data['mobileapp2_search_mode']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_future_order_confirm',
    isset($this->data['mobileapp2_future_order_confirm'])?$this->data['mobileapp2_future_order_confirm']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_custom_pages_position',
    isset($this->data['mobileapp2_custom_pages_position'])?$this->data['mobileapp2_custom_pages_position']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_banner_full',
    isset($this->data['mobile2_home_banner_full'])?$this->data['mobile2_home_banner_full']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_enabled_addon_desc',
    isset($this->data['mobile2_enabled_addon_desc'])?$this->data['mobile2_enabled_addon_desc']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_enabled_contact',
    isset($this->data['mobileapp2_enabled_contact'])?$this->data['mobileapp2_enabled_contact']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_remove_contact',
    isset($this->data['mobileapp2_remove_contact'])?$this->data['mobileapp2_remove_contact']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_food_discount',
    isset($this->data['mobile2_home_food_discount'])?$this->data['mobile2_home_food_discount']:''
    );
    
    $this->functions->updateOptionAdmin('mobileapp2_onetime_payment',
    isset($this->data['mobileapp2_onetime_payment'])?$this->data['mobileapp2_onetime_payment']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_banner_auto_scroll',
    isset($this->data['mobile2_home_banner_auto_scroll'])?$this->data['mobile2_home_banner_auto_scroll']:''
    );
    
    $this->functions->updateOptionAdmin('mobile2_home_categories',
    isset($this->data['mobile2_home_categories'])?$this->data['mobile2_home_categories']:''
    );    
    
    $this->functions->updateOptionAdmin('mobile2_cart_with_qty',
    isset($this->data['mobile2_cart_with_qty'])?$this->data['mobile2_cart_with_qty']:''
    );    
    
    $this->functions->updateOptionAdmin('mobile2_food_share',
    isset($this->data['mobile2_food_share'])?$this->data['mobile2_food_share']:''
    );    
    
    $this->functions->updateOptionAdmin('mobile2_home_use_view_all',
    isset($this->data['mobile2_home_use_view_all'])?$this->data['mobile2_home_use_view_all']:''
    );    
    
    $this->functions->updateOptionAdmin('mobile2_home_all_as_list',
    isset($this->data['mobile2_home_all_as_list'])?$this->data['mobile2_home_all_as_list']:''
    );    
    
      $this->code=1;
      $this->msg="settings saved";
    $this->jsonResponse();  
    }

     public function save_operating_hours()
{
    $params = array();
    
    $this->functions->updateOptionAdmin(
        'enabled_operating_hours',
        isset($this->data['enabled_operating_hours']) ? trim($this->data['enabled_operating_hours']) : ''
    );      

    // Delete existing opening hours for merchant_id = 0 using PDO
    $stmt = $this->db->prepare("DELETE FROM mt_opening_hours WHERE merchant_id = :merchant_id");
    $stmt->execute([':merchant_id' => 0]);

    $days = $this->functions->getDays();

    if (isset($this->data['operating_hours'])) {
        foreach ($days as $day_key => $day) {                
            $params = array(
                'merchant_id' => 0,
                'day' => $day_key,
                'status' => in_array($day_key, (array)$this->data['operating_hours']) ? "open" : "close",
                'start_time' => isset($this->data['start_time'][$day_key]) ? $this->data['start_time'][$day_key] : '',
                'end_time' => isset($this->data['end_time'][$day_key]) ? $this->data['end_time'][$day_key] : '',
            );
            
            // Keep the insertData function as is
            $this->functions->insertData("mt_opening_hours", $params);
        }
    }

    $this->code = 1;
    $this->msg = "Settings saved";
    $this->jsonResponse();  
}


 public function uploadFile()
    {
        

        require_once(__DIR__ . '/../../../vendor/SimpleUploader.php');


        if ( !$this->functions->isAdminLogin()){
            $this->msg = "Session has expired";
            $this->jsonResponse();
        }
        
        

        $path_to_upload = __DIR__ . '/../../../public/';
              
      if(!file_exists($path_to_upload)) { 
           if (!@mkdir($path_to_upload,0777)){
                $this->msg=$this->functions->translation("default","Cannot create upload folder. Please create the upload folder manually on your rood directory with 777 permission.");
                return ;
           }        
      }
        
    $htaccess =$this->functions->htaccessForUpload();
    $htfile=$path_to_upload.'.htaccess';        
      if (!file_exists($htfile)){
        $myfile = fopen($htfile, "w") or die("Unable to open file!".$htfile);    
            fwrite($myfile, $htaccess);        
            fclose($myfile);
      }

$path_to_upload = __DIR__ . '/../../../upload/';


        
        $valid_extensions = $this->functions->validImageExtension();        
        $Upload = new FileUpload('uploadfile');
        $ext = $Upload->getExtension();
        $time=time();
        $filename = $Upload->getFileNameWithoutExt();       
        $new_filename =  "$time-$filename.$ext";
        $Upload->newFileName = $new_filename;
        $Upload->sizeLimit = $this->functions->imageLimitSize();
        $result = $Upload->handleUpload($path_to_upload, $valid_extensions); 

        if (!$result) {
             $this->msg=$Upload->getErrorMsg();

        } else {
            
             $fields = ''; $remove_class='remove_picture';
             if($_GET['id']=="multi_upload"){
                $remove_class='multi_remove_picture';
                $fields = '<input type="hidden" name="'.$_GET['field_name'].'[]" value="'.$new_filename.'" > ';
             }
            
             $class_name = "preview_".$_GET['id'];
             $html_preview='             
             <div class="card '.$class_name.'" style="width: 10rem;">
                <img class="img-thumbnail" src="'.$this->functions->websiteUrl()."/upload/$new_filename".'" >
                
                <div class="card-body">
                  <a href="javascript:;" data-id="'.$_GET['id'].'" 
                  data-fieldname="'.$_GET['field_name'].'" 
                  class="card-link '.$remove_class.'">'.("Remove Image").'</a>
                </div>
                
                '.$fields.'
                
             </div>          
             <div class="height10"></div>
             ';
                         
             
             $this->code = 1;
             $this->msg="OK";
             $this->details=array(
               'file_name'=>$new_filename,
               'file_url'=>$this->functions->websiteUrl()."/upload/$new_filename",
               'html_preview'=>$html_preview
             );
        }
        $this->jsonResponse();
    }


    public function uploadFile2()
    {
        require_once(__DIR__ . '/../../../vendor/SimpleUploader.php');
        if ( !$this->functions->isAdminLogin()){
            $this->msg = "Session has expired";
            $this->jsonResponse();
        }
        
       $path_to_upload = __DIR__ . '/../../../public/';
              
      if(!file_exists($path_to_upload)) { 
           if (!@mkdir($path_to_upload,0777)){
                $this->msg=$this->functions->translation("default","Cannot create upload folder. Please create the upload folder manually on your rood directory with 777 permission.");
                return ;
           }        
      }

        $htaccess =$this->functions->htaccessForUpload();
    $htfile=$path_to_upload.'.htaccess';        
      if (!file_exists($htfile)){
        $myfile = fopen($htfile, "w") or die("Unable to open file!".$htfile);    
            fwrite($myfile, $htaccess);        
            fclose($myfile);
      }
      $path_to_upload = __DIR__ . '/../../../upload/';
        
        $valid_extensions = array('json');
        $Upload = new FileUpload('uploadfile');
        $ext = $Upload->getExtension();
        $time=time();
        $filename = $Upload->getFileNameWithoutExt();         
        $new_filename =  "$filename.$ext";
        $Upload->newFileName = $new_filename;
        $Upload->sizeLimit = $this->functions->imageLimitSize();
        $result = $Upload->handleUpload($path_to_upload, $valid_extensions); 
        if (!$result) {
             $this->msg=$Upload->getErrorMsg();
        } else {                    
            
             

             $field_name = isset($_GET['field_name'])?$_GET['field_name']:'file_name';
        $input = '<input type="hidden" name="' . htmlspecialchars($field_name, ENT_QUOTES, 'UTF-8') . '" id="' . htmlspecialchars($field_name, ENT_QUOTES, 'UTF-8') . '" value="' . htmlspecialchars($new_filename, ENT_QUOTES, 'UTF-8') . '">';


            $input.= "File ".$new_filename;


                 
             $this->code = 1;
             $this->msg="OK";
             $this->details=array(
               'file_name'=>$new_filename,
               'field_name'=>$field_name,
               'input'=>$input
             );
        }
        $this->jsonResponse();
    }





       public function savesettings_startup()
    {
                        
        $this->functions->updateOptionAdmin('mobileapp2_startup',
        isset($this->data['mobileapp2_startup'])?$this->data['mobileapp2_startup']:''
        );
        
        $this->functions->updateOptionAdmin('mobileapp2_startup_banner',
        isset($this->data['mobileapp2_startup_banner'])?json_encode($this->data['mobileapp2_startup_banner']):''
        );
        
        $this->functions->updateOptionAdmin('mobile2_enabled_select_language',
        isset($this->data['mobile2_enabled_select_language'])?$this->data['mobile2_enabled_select_language']:''
        );
        
        $this->functions->updateOptionAdmin('mobileapp2_startup_interval',
        isset($this->data['mobileapp2_startup_interval'])?$this->data['mobileapp2_startup_interval']:''
        );
        
        $this->functions->updateOptionAdmin('mobileapp2_startup_auto_scroll',
        isset($this->data['mobileapp2_startup_auto_scroll'])?$this->data['mobileapp2_startup_auto_scroll']:''
        );
            
        $this->code=1;
        $this->msg="settings saved";
        $this->jsonResponse();  
        
        
    }


    public function savesettings_social()
    {
        $this->functions->updateOptionAdmin('mobile2_enabled_fblogin',
        isset($this->data['mobile2_enabled_fblogin'])?$this->data['mobile2_enabled_fblogin']:''
        );
        
        $this->functions->updateOptionAdmin('mobile2_enabled_googlogin',
        isset($this->data['mobile2_enabled_googlogin'])?$this->data['mobile2_enabled_googlogin']:''
        );
        
        $this->code=1;
        $this->msg="settings saved";
        $this->jsonResponse();  
    }


    public function savesettings_analytics()
    {       
        $this->functions->updateOptionAdmin('mobile2_analytics_enabled',
        isset($this->data['mobile2_analytics_enabled'])?$this->data['mobile2_analytics_enabled']:''
        );
        $this->functions->updateOptionAdmin('mobile2_analytics_id',
        isset($this->data['mobile2_analytics_id'])?$this->data['mobile2_analytics_id']:''
        );
        $this->code=1;
        $this->msg="settings saved";
        $this->jsonResponse();  
    }

    public function savesettings_android()
    {
        $this->functions->updateOptionAdmin('android_push_icon',
        isset($this->data['android_push_icon'])?$this->data['android_push_icon']:''
        );
        $this->functions->updateOptionAdmin('android_push_picture',
        isset($this->data['android_push_picture'])?$this->data['android_push_picture']:''
        );
        $this->functions->updateOptionAdmin('android_enabled_pushpic',
        isset($this->data['android_enabled_pushpic'])?$this->data['android_enabled_pushpic']:''
        );
        
        $this->code=1;
        $this->msg="settings saved";
        $this->jsonResponse();    
    }


     public function savesettings_fcm()
    {
        $this->functions->updateOptionAdmin('mobileapp2_push_server_key',
        isset($this->data['mobileapp2_push_server_key'])?$this->data['mobileapp2_push_server_key']:''
        );

        $this->functions->updateOptionAdmin('mobileapp2_fcm_provider',
        isset($this->data['mobileapp2_fcm_provider'])?$this->data['mobileapp2_fcm_provider']:''
        );  
        
        $this->functions->updateOptionAdmin('mobileapp2_services_account_json',
        isset($this->data['mobileapp2_services_account_json'])?$this->data['mobileapp2_services_account_json']:''
        );
                
        $this->functions->updateOptionAdmin('mobileapp2_fcm_v1','');       
        
        $this->code=1;
        $this->msg="settings saved";
        $this->jsonResponse();  
    }


     public function save_app_rating()
    {
        $this->functions->updateOptionAdmin('mobileapp2_enabled_app_rating',
        isset($this->data['mobileapp2_enabled_app_rating'])? trim($this->data['mobileapp2_enabled_app_rating']) :''
        );      
                
        $this->functions->updateOptionAdmin('mobileapp2_feedback_email',
        isset($this->data['mobileapp2_feedback_email'])? trim($this->data['mobileapp2_feedback_email']) :''
        );      
        
        $this->functions->updateOptionAdmin('mobileapp2_app_rating_ios_id',
        isset($this->data['mobileapp2_app_rating_ios_id'])? trim($this->data['mobileapp2_app_rating_ios_id']) :''
        );      
        
        $this->functions->updateOptionAdmin('mobileapp2_app_rating_android_id',
        isset($this->data['mobileapp2_app_rating_android_id'])? trim($this->data['mobileapp2_app_rating_android_id']) :''
        );      
        
        $this->code=1;
        $this->msg="settings saved";
        $this->jsonResponse();  
    }



 public function device_list()
{       
    $this->data = $_POST; 
    $feed_data = array();
    
    $cols = array(
        'id', 'full_name', 'device_platform', 'device_uiid', 'device_id', 
        'push_enabled', 'subscribe_topic', 'date_created', 'last_login', 'id'
    );          
        
    $resp = $this->DatatablesWrapper->format($cols, $this->data);           
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];
    
    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.* FROM mt_mobile2_device_reg_view a 
             WHERE status = 'active' 
             AND push_enabled = '1' 
             AND device_id<>'' 
             $where 
             $order 
             $limit";
    
    $query = $this->db->prepare($stmt);
    $query->execute();
    
    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        
        $total_records = 0;                                   
        $count_stmt = $this->db->prepare("SELECT FOUND_ROWS() as total_records");
        $count_stmt->execute();
        
        if ($resc = $count_stmt->fetch(PDO::FETCH_ASSOC)) {                      
            $total_records = $resc['total_records'];
        }           
        
        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;
            
        $datas = array(); 
        foreach ($res as $val) {
            
            $actions = '<a href="javascript:;" data-id="'.$val['id'].'" class="send_push" >' . 
                        $this->functions->translation("default", "send push") . '</a>';
            
            $cols_data = array();
            foreach ($cols as $key_cols => $cols_val) {                         
                if (array_key_exists($cols_val, (array) $val)) {     
                    if ($key_cols == 7 || $key_cols == 8) {
                        $cols_data[] = $this->functions->prettyDate($val[$cols_val]) . 
                                       " " . $this->functions->prettyTime($val[$cols_val]);
                    } elseif ($key_cols == 3) {
                        $cols_data[] = ($val[$cols_val]);
                    } elseif ($key_cols == 4) {                           
                        $info = "<a href=\"javascript:;\" class=\"show_device_id\" data-id=\"" . 
                                $val[$cols_val] . "\" data-toggle=\"modal\" data-target=\"#deviceDetails\" >";
                        $info .= '<div class="concat-text">' . $val[$cols_val] . "</div>";
                        $info .= "</a> ";               
                        $cols_data[] = $info;
                    } elseif ($key_cols == 5 || $key_cols == 6) {
                        $cols_data[] = ($val[$cols_val] == 1) ? "yes" : "no";
                    } elseif ($key_cols == 9) {  
                        $cols_data[] = $actions;
                    } else {
                        $cols_data[] = $val[$cols_val];
                    }
                }            
            }
            $datas[] = $cols_data;
        }           
        
        $feed_data['data'] = $datas;          
        $this->otableOutput($feed_data);            
    } else {
        $this->otableNodata();
    }
}



public function broadcast_list()
{
    $this->data = $_POST;
    $feed_data = array();
    
    $cols = array(
        'broadcast_id', 'push_title', 'push_message',
        'device_platform', 'date_created', 'date_modified'
    );          
    
    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];
    
    // Prepare the query
    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.* FROM
             mt_mobile2_broadcast a
             WHERE 1
             $where
             $order
             $limit";
    
    // Execute the query using PDO
    $res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC);
    
    if ($res) {
        $total_records = 0;
        
        // Get total records
        $stmtTotal = "SELECT FOUND_ROWS() as total_records";
        $resc = $this->db->query($stmtTotal)->fetch(PDO::FETCH_ASSOC);
        $total_records = $resc['total_records'];
        
        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;
        
        $platform_list = $this->mobileWrapper->platFormList();
        
        $datas = array();
        foreach ($res as $val) {
            $link = Config::$baseUrl . "/mobileappv2/index/broadcast_details/bid/" . $val['broadcast_id'];
            
            $cols_data = array();
            foreach ($cols as $key_cols => $cols_val) {
                $link = Config::$baseUrl . "/mobileappv2/index/broadcast_details/bid/" . $val['broadcast_id'];
                
                $actions = '<a href="' . $link . '">' . $this->functions->translation("default", "view details") . '</a>';
                
                if (array_key_exists($cols_val, (array)$val)) {
                    if ($key_cols == 4) {
                        if (isset($platform_list[$val['device_platform']])) {
                            $t = '';
                            $t .= $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                            $t .= "<br/>" . $actions;
                            $cols_data[] = $t;
                        } else {
                            $t = $this->mobileWrapper->prettyBadge($val['status']);
                            $t .= "<a href=\"javascript:;\" class=\"show_error_details\" data-id=\"" . $val['broadcast_id'] . "\" data-toggle=\"modal\" data-target=\"#errorDetails\">
                                     <i class=\"pl-2 fas fa-question-circle\"></i></a>";
                            $t .= "<div></div>";
                            $t .= $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                            $cols_data[] = $t;
                        }
                    } elseif ($key_cols == 5) {
                        $cols_data[] = $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                    } elseif ($key_cols == 3) {
                        if (isset($platform_list[$val[$cols_val]])) {
                            $cols_data[] = ($platform_list[$val[$cols_val]]);
                        } else {
                            $cols_data[] = $val[$cols_val];
                        }
                    } else {
                        $cols_data[] = $val[$cols_val];
                    }
                }
            }
            $datas[] = $cols_data;
        }
        
        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


   public function send_push()
    {       
        $id = isset($this->data['id'])?$this->data['id']:'';    
        if($id>=1){
            if ($res = $this->mobileWrapper->getDeviceByID($id)){              
                $params = array(
                  'push_type'=>'campaign',
                  'client_id'=>$res['client_id'],
                  'client_name'=>$res['full_name'],
                  'device_platform'=>trim($res['device_platform']),
                  'device_id'=>trim($res['device_id']),
                  'device_uiid'=>trim($res['device_uiid']),
                  'push_title'=>trim($this->data['push_title']),
                  'push_message'=>trim($this->data['push_message']),
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR']
                );              
                
                if($this->functions->insertData("mt_mobile2_push_logs",$params)){
                    $this->code = 1;
                    $this->msg = ("Request has been sent");
                    
                    //FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl(APP_FOLDER."/cron/processpush"));
                    
                } else $this->msg = ("failed cannot insert records");
            } else $this->msg = ("Record not found");
        } else $this->msg = ("Invalid id");
        $this->jsonResponse();
    }


public function save_broadcast()
    {               
        
        $params = array(
           'push_title'=>isset($this->data['push_title'])?$this->data['push_title']:'',
           'push_message'=>isset($this->data['push_message'])?$this->data['push_message']:'',
           'device_platform'=>isset($this->data['device_platform'])?$this->data['device_platform']:'',
           'date_created'=>$this->functions->dateNow(),
           'ip_address'=>$_SERVER['REMOTE_ADDR'],
           'fcm_version'=>isset($this->data['fcm_version'])?$this->data['fcm_version']:''
        ); 

        $last_insert_id = $this->functions->insertData('mt_mobile2_broadcast', $params);
        if ($last_insert_id!== false){      
                   
            $this->code = 1;
            $this->msg = $this->functions->translation("default","Successful");                                  
                                
        } else $this->msg = $this->functions->translation("default","Failed cannot insert records");
        $this->jsonResponse();
    }



   public function errorDetails()
{
    $stmt = '';
    $id = isset($this->data['details_id']) ? (int)$this->data['details_id'] : '';
    $current_page = isset($this->data['current_page']) ? $this->data['current_page'] : '';

    if ($id > 0) {
        switch ($current_page) {
            case "push_list":
            case "broadcast_details":
                $stmt = "
                SELECT json_response as fcm_response
                FROM mt_mobile2_push_logs
                WHERE id = :id
                LIMIT 0,1
                ";
                break;

            case "broadcast_list":
            case "old_broadcast":
                $stmt = "
                SELECT fcm_response
                FROM mt_mobile2_broadcast
                WHERE broadcast_id = :id
                LIMIT 0,1
                ";
                break;

            default:
                break;
        }

        if (!empty($stmt)) {
            // Prepare and execute the PDO statement
            $query = $this->db->prepare($stmt);
            $query->bindParam(':id', $id, PDO::PARAM_INT);
            $query->execute();

            // Fetch the result
            $res = $query->fetch(PDO::FETCH_ASSOC);

            if ($res) {
                $this->code = 1;
                $this->msg = !empty($res['fcm_response']) ? $res['fcm_response'] : "None";
            } else {
                $this->msg = "Record not found";
            }
        } else {
            $this->msg = "Invalid table";
        }
    } else {
        $this->msg = "Invalid details id";
    }

    $this->jsonResponse();
}


    public function push_list()
{
    $this->data = $_POST;
    $feed_data = array();
    
    $cols = array(
        'id', 'push_type', 'client_name', 'device_platform', 'device_id',
        'push_title', 'push_message', 'date_created', 'date_process'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = '';
    if (isset($this->data['broadcast_id'])) {
        $and = " AND broadcast_id = :broadcast_id ";
    }

    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.* FROM
        mt_mobile2_push_logs a
        WHERE 1
        $where
        $and
        $order
        $limit
    ";

    $command = $this->db->prepare($stmt);

    if (isset($this->data['broadcast_id'])) {
        $command->bindParam(':broadcast_id', $this->data['broadcast_id'], PDO::PARAM_INT);
    }

    $command->execute();
    $res = $command->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $total_records = 0;
        $totalStmt = "SELECT FOUND_ROWS() as total_records";
        $totalCommand = $this->db->prepare($totalStmt);
        $totalCommand->execute();
        $resc = $totalCommand->fetch(PDO::FETCH_ASSOC);

        if ($resc) {
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        $datas = array();
        foreach ($res as $val) {
            $cols_data = array();
            foreach ($cols as $key_cols => $cols_val) {
                if (array_key_exists($cols_val, (array)$val)) {
                    if ($key_cols == 7) {
                        $t = $this->mobileWrapper->prettyBadge($val['status']);
                        $t .= "<a href=\"javascript:;\" class=\"show_error_details\" data-id=\"" . $val['id'] . "\" data-toggle=\"modal\" data-target=\"#errorDetails\" >
                        <i class=\"pl-2 fas fa-question-circle\"></i></a> ";
                        $t .= "<div></div>";
                        $t .= $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);

                        $cols_data[] = $t;
                    } elseif ($key_cols == 1 || $key_cols == 3) {
                        $cols_data[] = ($val[$cols_val]);
                    } elseif ($key_cols == 4) {
                        $info = "<a href=\"javascript:;\" class=\"show_device_id\" data-id=\"" . $val[$cols_val] . "\" data-toggle=\"modal\" data-target=\"#deviceDetails\" >";
                        $info .= '<div class="concat-text">' . $val[$cols_val] . "</div>";
                        $info .= "</a> ";
                        $cols_data[] = $info;
                    } elseif ($key_cols == 8) {
                        $cols_data[] = $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                    } else {
                        $cols_data[] = $val[$cols_val];
                    }
                }
            }
            $datas[] = $cols_data;
        }
        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}



public function order_trigger()
{
    $this->data = $_POST;
    $feed_data = array();

    $cols = array(
        'trigger_id', 'trigger_type',
        'order_id', 'order_status', 'remarks', 'date_created'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    // Prepare SQL statement
    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.* FROM mt_mobile2_order_trigger a WHERE 1 $where $order $limit";

    // Use PDO to execute the query
    $query = $this->db->prepare($stmt);
    $query->execute();

    // Fetch the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {

        // Get the total number of records
        $total_records = 0;
        $totalQuery = $this->db->prepare("SELECT FOUND_ROWS() as total_records");
        $totalQuery->execute();
        $resc = $totalQuery->fetch(PDO::FETCH_ASSOC);
        if ($resc) {
            $total_records = $resc['total_records'];
        }

        // Prepare response data
        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        $datas = array();
        foreach ($res as $val) {

            $cols_data = array();
            foreach ($cols as $key_cols => $cols_val) {
                if (array_key_exists($cols_val, (array)$val)) {
                    if ($key_cols == 5) {

                        $t = $this->mobileWrapper->prettyBadge($val['status']);
                        $t .= "<div></div>";
                        $t .= $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                        $cols_data[] = $t;

                    } elseif ($key_cols == 1) {
                        $cols_data[] = ($val[$cols_val]);
                    } elseif ($key_cols == 3) {
                        $cols_data[] = ($val[$cols_val]);
                    } else {
                        $cols_data[] = $val[$cols_val];
                    }
                }
            }
            $datas[] = $cols_data;
        }

        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


 public function home_banner_list()
{
    $this->data = $_POST;
    $feed_data = array();

    $cols = array(
        'banner_id', 'title', 'banner_name', 'sequence', 'tag_name', 'date_created', 'banner_id'
    );

    $and = '';
    $category = isset($this->data['category']) ? $this->data['category'] : '';
    if (!empty($category)) {
        $and .= " AND category = :category ";
    }

    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    // Prepare the SQL query
    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.* FROM mt_mobile2_homebanner_view a WHERE 1 $and $where $order $limit";

    // Use PDO to prepare and execute the query
    $query = $this->db->prepare($stmt);

    // Bind the category parameter if it's set
    if (!empty($category)) {
        $query->bindParam(':category', $category, PDO::PARAM_INT);
    }

    $query->execute();

    // Fetch the results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {

        // Get the total number of records
        $total_records = 0;
        $totalQuery = $this->db->prepare("SELECT FOUND_ROWS() as total_records");
        $totalQuery->execute();
        $resc = $totalQuery->fetch(PDO::FETCH_ASSOC);
        if ($resc) {
            $total_records = $resc['total_records'];
        }

        // Prepare response data
        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        $datas = array();
        foreach ($res as $val) {

            $banner_id = $val['banner_id'];

            // Build the edit link based on category
            $edit_link = Config::$baseUrl . "/mobileappv2/index/home_banner_new/banner_id/" . $banner_id;

            if ($category == "home_category") {
                $edit_link = Config::$baseUrl . "/mobileappv2/index/home_category_new/banner_id/" . $banner_id;
            }

            // Define actions
            $actions = '<a href="' . $edit_link . '" class="edit_page btn btn-info" ><i class="fas fa-edit" aria-hidden="true"></i></a>';
            $actions .= '<a href="javascript:;" class="delete_home_banner btn btn-danger" data-banner_id="' . $banner_id . '" ><i class="fas fa-trash" aria-hidden="true"></i></a>';

            // Get image URL
            $image_url = $this->mobileWrapper->getImage($val['banner_name']);
            $image_link = "<p><a target=\"_blank\" href=\"$image_url\" targe=\"_blank\" >" . ("view") . "</a></p>";

            // Prepare columns data
            $cols_data = array();
            foreach ($cols as $key_cols => $cols_val) {
                if (array_key_exists($cols_val, (array)$val)) {
                    if ($key_cols == 5) {

                        $t = $this->mobileWrapper->prettyBadge($val['status']);
                        $t .= "<div></div>";
                        $t .= $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                        $cols_data[] = $t;

                    } elseif ($key_cols == 2) {
                        $cols_data[] = '<div class="concat-text">' . $val[$cols_val] . $image_link . "</div>";
                    } elseif ($key_cols == 6) {
                        $cols_data[] = $actions;
                    } else {
                        $cols_data[] = $val[$cols_val];
                    }
                }
            }
            $datas[] = $cols_data;
        }

        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


public function save_home_banner()
    {       
        
        $banner_id = isset($this->data['banner_id'])?$this->data['banner_id']:'';
        $category = isset($this->data['category'])?$this->data['category']:'';
        
        $params = array(
          'title'=>isset($this->data['title'])?$this->data['title']:'',
          'sub_title'=>isset($this->data['sub_title'])?$this->data['sub_title']:'',
          'banner_name'=>isset($this->data['home_banner'])?$this->data['home_banner']:'',
          'sequence'=>isset($this->data['sequence'])?$this->data['sequence']:'',
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR'],
          'status'=>isset($this->data['status'])?$this->data['status']:'',
          'tag_id'=>isset($this->data['tag_id'])?json_encode($this->data['tag_id']):'',
          'category'=>$category
        );      
        
        if(!is_numeric($params['sequence'])){
            $params['sequence']=0;
        }
        
        if($category=="home_category"){
           
             $redirect_link = Config::$baseUrl."/mobileappv2/index/home_category";
        } else {
            
            $redirect_link = Config::$baseUrl."/mobileappv2/index/home_banner_list";
        }               
                
        if(!empty($params['banner_name'])){         
            if($banner_id>0){
                unset($params['date_created']);
                $params['date_modified']=$this->functions->dateNow();
                                                                
               

                 $this->functions->updateData('mt_mobile2_homebanner', $params, 'banner_id', $banner_id);

                
                $this->itemWrapper->insertTagRelationship($banner_id, (array) json_decode($params['tag_id']) );
                
                $this->code = 1;
                $this->msg = "Successfully updated";
                                
                $this->details = $redirect_link;
            } else {                    

                       
                

                $banner_id = $this->functions->insertData('mt_mobile2_homebanner', $params);
       
                                
                $this->itemWrapper->insertTagRelationship($banner_id, (array) json_decode($params['tag_id']) );
                                                
                $this->code = 1;
                $this->msg = "Successful";
                $this->details = $redirect_link;
            }
            
        } else $this->msg = "please upload your banner";
        $this->jsonResponse();
    }


    public function delete_home_banner()
{       
    $banner_id = isset($this->data['banner_id']) ? (int)$this->data['banner_id'] : 0;
    
    if ($banner_id > 0) {
        if ($this->mobileWrapper->getHomeBannerByID($banner_id)) {
            try {
                $stmt = $this->db->prepare("DELETE FROM mt_mobile2_homebanner WHERE banner_id = :banner_id");
                $stmt->bindParam(':banner_id', $banner_id, PDO::PARAM_INT);
                $stmt->execute();
                
                $this->code = 1;
                $this->msg = "Successful";
            } catch (PDOException $e) {
                $this->msg = "Error: " . $e->getMessage();
            }
        } else {
            $this->msg = "Invalid banner ID";
        }
    } else {
        $this->msg = "Invalid banner ID";
    }
    
    $this->jsonResponse();
}



public function page_list()
{
    $this->data = $_POST;
    $feed_data = array();

    $cols = array(
        'page_id', 'title', 'content', 'icon', 'use_html', 'sequence',
        'date_created', 'page_id'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.* FROM mt_mobile2_pages a WHERE 1 $where $order $limit";
    
    $query = $this->db->prepare($stmt);
    $query->execute();
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $total_records = 0;
        
        $query_total = $this->db->prepare("SELECT FOUND_ROWS() as total_records");
        $query_total->execute();
        $resc = $query_total->fetch(PDO::FETCH_ASSOC);
        
        if ($resc) {
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        $datas = array();
        foreach ($res as $val) {
            $page_id = $val['page_id'];
            $actions = '<a href="javascript:;" class="edit_page btn btn-info" data-page_id="' . $page_id . '" ><i class="fas fa-edit" aria-hidden="true"></i></a>';
            $actions .= '<a href="javascript:;" class="delete_page btn btn-danger" data-page_id="' . $page_id . '" ><i class="fas fa-trash" aria-hidden="true"></i></a>';

            $cols_data = array();
            foreach ($cols as $key_cols => $cols_val) {
                if (array_key_exists($cols_val, (array)$val)) {
                    if ($key_cols == 6) {
                        $t = $this->mobileWrapper->prettyBadge($val['status']);
                        $t .= "<div></div>";
                        $t .= $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                        $cols_data[] = $t;
                    } elseif ($key_cols == 2) {
                        $cols_data[] = '<div class="concat-text">' .strip_tags(($val[$cols_val])) . "</div>";
                    } elseif ($key_cols == 4) {
                        $cols_data[] = $val[$cols_val] == 1 ? '<i class="fa fa-check" aria-hidden="true"></i>' : '';
                    } elseif ($key_cols == 7) {
                        $cols_data[] = $actions;
                    } else {
                        $cols_data[] = $val[$cols_val];
                    }
                }
            }
            $datas[] = $cols_data;
        }
        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}



  public function save_page()
    {       
        
        $params = array(
          'title'=>isset($this->data['title'])?$this->data['title']:'',
          'content'=>isset($this->data['content'])?$this->data['content']:'',
          'use_html'=>isset($this->data['use_html'])?$this->data['use_html']:0,
          'icon'=>isset($this->data['icon'])?$this->data['icon']:'',
          'sequence'=>isset($this->data['sequence'])?$this->data['sequence']:'0',
          'status'=>isset($this->data['status'])?$this->data['status']:'',
          'date_created'=>$this->functions->dateNow(),
          'ip_address'=>$_SERVER['REMOTE_ADDR']
        );
        
        if($params['sequence']<=0){         
            if($max_count = $this->mobileWrapper->getMaxPage()){               
                $params['sequence']=$max_count;
            }           
        }
        
        /*dump($params);
        die();*/
        
        if($this->functions->multipleField()){             
            if ( $fields=$this->functions->getLanguageList(false)){
                foreach ($fields as $lang) {                    
                    $params["title_$lang"] = isset($this->data["title_$lang"])?$this->data["title_$lang"]:'';
                    $params["content_$lang"] = isset($this->data["content_$lang"])?$this->data["content_$lang"]:'';
                }
            }           
        }
                
        $page_id = isset($this->data['page_id'])?$this->data['page_id']:'';
        if($page_id>0){         
            unset($params['date_created']);
            $params['date_modified']=$this->functions->dateNow();

            if($this->functions->updateData('mt_mobile2_pages', $params, 'page_id', $page_id)){
                $this->code = 1;
                $this->msg = "Successful";              
            } else $this->msg = "Failed cannot update records";
        } else {
            if (!$this->mobileWrapper->getPageByTitle($params['title'])){
                
                $this->functions->insertData('mt_mobile2_pages', $params);

                $this->code = 1;
                $this->msg = "Successful";
            } else $this->msg = "Page title already exist";
        }
        
        $this->jsonResponse();
    }


    public function get_page()
    {
        $page_id = isset($this->data['page_id'])?$this->data['page_id']:'';    
        if($page_id>=1){
            if ($res=$this->mobileWrapper->getPageByID($page_id)){   
                
                $lang=array();
                if($this->functions->multipleField()){
                    //$lang = DBTableWrapper::getLangList();
                }
                            
                $this->code = 1;
                $this->msg = "ok";
                $this->details = array(
                 'lang'=>$lang,
                 'data'=>$res
                );
                                
            } else $this->msg = "records not found";
        } else $this->msg = "Invalid page id";
        $this->jsonResponse();
    }


     public function delete_page()
    {
        $page_id = isset($this->data['page_id'])?$this->data['page_id']:'';
        if($page_id>=1){
            $this->mobileWrapper->deletePage($page_id);
            $this->code = 1;
            $this->msg = "Successful";
        } else $this->msg = "Invalid page id";
        $this->jsonResponse();
    }


    public function save_webconfig()
    {
        $this->functions->updateOptionAdmin('mobile2_notification_delay',
        isset($this->data['mobile2_notification_delay'])?$this->data['mobile2_notification_delay']:''
        );
        
        $this->functions->updateOptionAdmin('mobile2_table_length',
        isset($this->data['mobile2_table_length'])?$this->data['mobile2_table_length']:''
        );
            
        $this->code=1;
        $this->msg="settings saved";
        $this->jsonResponse();  
    }











	
	



   











	
	
	
}
/*end class*/