<?php
class AjaxController extends Controller
{
	public $code=2;
	public $msg;
	public $details;
	public $data;	
	public $merchant_id;
	
	public function __construct()
	{
		$this->data=$_POST;	
		$this->functions = new Functions();
		
        
        $this->MerchantWrapper = new MerchantWrapper();
        $this->DatatablesWrapper = new DatatablesWrapper();
        $this->MerchantUserWrapper=new MerchantUserWrapper();

		$model = Model::getInstance();
        
        $this->db = $model->getDb();
		
	}
	
	
	
	public function jsonResponse()
{
    $resp = array('code' => $this->code, 'msg' => $this->msg, 'details' => $this->details);
    echo json_encode($resp);
    exit();
}

	
	public function otableNodata()
	{
		if (isset($_POST['draw'])){
			$feed_data['draw']=$_POST['draw'];
		} else $feed_data['draw']=1;	   
		     
        $feed_data['recordsTotal']=0;
        $feed_data['recordsFiltered']=0;
        $feed_data['data']=array();		
        echo json_encode($feed_data);
    	die();
	}

	public function otableOutput($feed_data='')
	{
	  echo json_encode($feed_data);
	  die();
    }
    
	
	public function OKresponse()
	{
		$this->code = 1; $this->msg = "OK"; $this->details = array();
	}
	
	
	 public function savesettings()
    {
            
        $this->functions->updateOptionAdmin('merchantappv2_api_hash_key',
        isset($this->data['merchantappv2_api_hash_key'])? trim($this->data['merchantappv2_api_hash_key']) :''
        );
            
        $this->code=1;
        $this->msg="Settings saved";
        $this->jsonResponse();  
    }


    public function application_settings()
    {
      $this->functions->updateOptionAdmin('order_unattended_minutes',
    isset($this->data['order_unattended_minutes'])? trim($this->data['order_unattended_minutes']) :''
    );
    
    $this->functions->updateOptionAdmin('ready_outgoing_minutes',
    isset($this->data['ready_outgoing_minutes'])? trim($this->data['ready_outgoing_minutes']) :''
    );
    
    $this->functions->updateOptionAdmin('ready_unattended_minutes',
    isset($this->data['ready_unattended_minutes'])? trim($this->data['ready_unattended_minutes']) :''
    );
    
    $this->functions->updateOptionAdmin('booking_incoming_unattended_minutes',
    isset($this->data['booking_incoming_unattended_minutes'])? trim($this->data['booking_incoming_unattended_minutes']) :''
    );
    
    $this->functions->updateOptionAdmin('booking_cancel_unattended_minutes',
    isset($this->data['booking_cancel_unattended_minutes'])? trim($this->data['booking_cancel_unattended_minutes']) :''
    );
    
    $this->functions->updateOptionAdmin('merchantapp_keep_awake',
    isset($this->data['merchantapp_keep_awake'])? trim($this->data['merchantapp_keep_awake']) :''
    );
    
    $this->functions->updateOptionAdmin('refresh_order',
    isset($this->data['refresh_order'])? (integer)trim($this->data['refresh_order']) :''
    );
    
    $this->functions->updateOptionAdmin('refresh_cancel_order',
    isset($this->data['refresh_cancel_order'])? (integer)trim($this->data['refresh_cancel_order']) :''
    );
    
    $this->functions->updateOptionAdmin('refresh_booking',
    isset($this->data['refresh_booking'])? (integer)trim($this->data['refresh_booking']) :''
    );
    
    $this->functions->updateOptionAdmin('refresh_cancel_booking',
    isset($this->data['refresh_cancel_booking'])? (integer)trim($this->data['refresh_cancel_booking']) :''
    );
    
    $this->functions->updateOptionAdmin('interval_ready_order',
    isset($this->data['interval_ready_order'])? (integer)trim($this->data['interval_ready_order']) :''
    );
    
    $this->functions->updateOptionAdmin('merchantapp_upload_resize_width',
    isset($this->data['merchantapp_upload_resize_width'])? (integer)trim($this->data['merchantapp_upload_resize_width']) :''
    );
    
    $this->functions->updateOptionAdmin('merchantapp_upload_resize_height',
    isset($this->data['merchantapp_upload_resize_height'])? (integer)trim($this->data['merchantapp_upload_resize_height']) :''
    );
    
    $this->functions->updateOptionAdmin('merchantapp_upload_resize_enabled',
    isset($this->data['merchantapp_upload_resize_enabled'])? (integer)trim($this->data['merchantapp_upload_resize_enabled']) :''
    );
    
    $order_estimated_time='';
    if(isset($this->data['order_estimated_time'])){
      $new_json = array();
      if($json = json_decode($this->data['order_estimated_time'],true)){
        foreach ($json as $val) {
          if((integer)$val['value']>0){
            $new_json[]= $val;
          }
        }
        $order_estimated_time=json_encode($new_json);
      }
    }   
    
    $this->functions->updateOptionAdmin('order_estimated_time',$order_estimated_time);
    
    $this->functions->updateOptionAdmin('decline_reason_list',
    isset($this->data['decline_reason_list'])? trim($this->data['decline_reason_list']) :''
    );
    
    $this->functions->updateOptionAdmin('number_of_alert',
    isset($this->data['number_of_alert'])? (integer) trim($this->data['number_of_alert']) :''
    );
    
      $this->code=1;
      $this->msg="Settings saved";
    $this->jsonResponse();  
    }


      public function savesettings_app()
    {
        $this->functions->updateOptionAdmin('order_incoming_status',
        isset($this->data['order_incoming_status'])? json_encode($this->data['order_incoming_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_outgoing_status',
        isset($this->data['order_outgoing_status'])? json_encode($this->data['order_outgoing_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_ready_status',
        isset($this->data['order_ready_status'])? json_encode($this->data['order_ready_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_failed_status',
        isset($this->data['order_failed_status'])? json_encode($this->data['order_failed_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_successful_status',
        isset($this->data['order_successful_status'])? json_encode($this->data['order_successful_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_action_accepted_status',
        isset($this->data['order_action_accepted_status'])? trim($this->data['order_action_accepted_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_action_decline_status',
        isset($this->data['order_action_decline_status'])? trim($this->data['order_action_decline_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_action_cancel_status',
        isset($this->data['order_action_cancel_status'])? trim($this->data['order_action_cancel_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_action_food_done_status',
        isset($this->data['order_action_food_done_status'])? trim($this->data['order_action_food_done_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_action_delayed_status',
        isset($this->data['order_action_delayed_status'])? trim($this->data['order_action_delayed_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_action_completed_status',
        isset($this->data['order_action_completed_status'])? trim($this->data['order_action_completed_status']) :''
        );
        
        $this->functions->updateOptionAdmin('order_action_approved_cancel_order',
        isset($this->data['order_action_approved_cancel_order'])? trim($this->data['order_action_approved_cancel_order']) :''
        );
        
        $this->functions->updateOptionAdmin('order_action_decline_cancel_order',
        isset($this->data['order_action_decline_cancel_order'])? trim($this->data['order_action_decline_cancel_order']) :''
        );
        
        $this->functions->updateOptionAdmin('accepted_based_time',
        isset($this->data['accepted_based_time'])? trim($this->data['accepted_based_time']) :''
        );
        
        $this->functions->updateOptionAdmin('merchantapp_remove_accepting_time',
        isset($this->data['merchantapp_remove_accepting_time'])? (integer)trim($this->data['merchantapp_remove_accepting_time']) :''
        );
        
        $this->functions->updateOptionAdmin('merchantapp_remove_cancel_status',
        isset($this->data['merchantapp_remove_cancel_status'])? (integer)trim($this->data['merchantapp_remove_cancel_status']) :''
        );
            
         $this->code=1;
      $this->msg="Settings saved";
    $this->jsonResponse(); 
    }


    public function savesettings_fcm()
    {
        $app_folder="merchantappv2";
        $this->functions->updateOptionAdmin('merchantapp_services_account_json',
        isset($this->data['merchantapp_services_account_json'])?$this->data['merchantapp_services_account_json']:''
        );
        
        $this->functions->updateOptionAdmin($app_folder.'_fcm','');
        
        $this->functions->updateOptionAdmin('merchantapp_disabled_broadcast',
        isset($this->data['merchantapp_disabled_broadcast'])?$this->data['merchantapp_disabled_broadcast']:''
        );
        
        $this->code=1;
        $this->msg="Settings saved";     
        $this->jsonResponse();
    }


    public function errorDetails()
{
    $stmt = '';
    $id = isset($this->data['details_id']) ? (integer)$this->data['details_id'] : '';
    $current_page = isset($this->data['current_page']) ? $this->data['current_page'] : '';
    
    if ($id > 0) {

        switch ($current_page) {
            case "push_logs":
                $stmt = "
                SELECT json_response as fcm_response
                FROM mt_merchantapp_push_logs
                WHERE id = $id
                LIMIT 0,1
                ";
                break;

            case "push_broadcast":
            case "device_list":
                $stmt = "
                SELECT fcm_response
                FROM mt_merchantapp_broadcast
                WHERE broadcast_id = $id
                LIMIT 0,1
                ";
                break;

            default:
                break;
        }

        if (!empty($stmt)) {
            $query = $this->db->prepare($stmt);
            $query->execute();
            if ($res = $query->fetch(PDO::FETCH_ASSOC)) {
                $this->code = 1;
                $this->msg = !empty($res['fcm_response']) ? $res['fcm_response'] : "None";
                $this->details = array(
                    'next_action' => "set_push_status"
                );
            } else {
                $this->msg = "Record not found";
            }
        } else {
            $this->msg = "Invalid table";
        }

    } else {
        $this->msg = "Invalid details id";
    }

    $this->jsonResponse();
}
   


        public function sendpush()
    {
        if(empty($this->data['push_title'])){
            $this->msg =("Push title is required");
            $this->jsonResponse();
        }
        if(empty($this->data['push_message'])){
            $this->msg =("Push message is required");
            $this->jsonResponse();
        }
                    
        $id = isset($this->data['id'])?(integer)$this->data['id']:0;        
        if($id>0){
            if ($data = $this->MerchantUserWrapper->getDeviceByID($id)){                               
                $params = array(                  
                  'push_type'=>"campaign",
                  'merchant_name'=>isset($data['name'])?$data['name']:'',
                  'device_platform'=>$data['device_platform'],
                  'device_id'=>$data['device_id'],
                  'device_uiid'=>$data['device_uiid'],
                  'push_title'=>$this->data['push_title'],
                  'push_message'=>$this->data['push_message'],                
                  'date_created'=>$this->functions->dateNow(),
                  'ip_address'=>$_SERVER['REMOTE_ADDR'],                  
                );                              
                if($this->functions->insertData("mt_merchantapp_push_logs",$params)){   
                    $this->code = 1;
                    $this->msg = ("Request has been sent");    
                    $this->details = array(
                      'next_action'=>"close_send_push_modal"
                    );
                    //FunctionsV3::fastRequest(FunctionsV3::getHostURL().Yii::app()->createUrl("merchantappv2/cron/processpush"));
                } else $this->msg = ("failed cannot insert records. please try again later");
            } else $this->msg = ("device id not found");
        } else $this->msg = ("Invalid registration id");
        $this->jsonResponse();
    }


      public function savesettings_printer()
    {       
        $prefix = "print_";
        
       $this->functions->updateOptionAdmin($prefix.'merchant_name',
        isset($this->data[$prefix.'merchant_name'])? trim($this->data[$prefix.'merchant_name']) :''
        );
        
       $this->functions->updateOptionAdmin($prefix.'merchant_address',
        isset($this->data[$prefix.'merchant_address'])? trim($this->data[$prefix.'merchant_address']) :''
        );
        
       $this->functions->updateOptionAdmin($prefix.'merchant_contact_phone',
        isset($this->data[$prefix.'merchant_contact_phone'])? trim($this->data[$prefix.'merchant_contact_phone']) :''
        );
        
       $this->functions->updateOptionAdmin($prefix.'printed_date',
        isset($this->data[$prefix.'printed_date'])? trim($this->data[$prefix.'printed_date']) :''
        );
        
       $this->functions->updateOptionAdmin($prefix.'customer_name',
        isset($this->data[$prefix.'customer_name'])? trim($this->data[$prefix.'customer_name']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'trans_type',
        isset($this->data[$prefix.'trans_type'])? trim($this->data[$prefix.'trans_type']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'payment_type',
        isset($this->data[$prefix.'payment_type'])? trim($this->data[$prefix.'payment_type']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'order_id',
        isset($this->data[$prefix.'order_id'])? trim($this->data[$prefix.'order_id']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'date_created',
        isset($this->data[$prefix.'date_created'])? trim($this->data[$prefix.'date_created']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'delivery_date',
        isset($this->data[$prefix.'delivery_date'])? trim($this->data[$prefix.'delivery_date']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'delivery_time',
        isset($this->data[$prefix.'delivery_time'])? trim($this->data[$prefix.'delivery_time']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'delivery_address',
        isset($this->data[$prefix.'delivery_address'])? trim($this->data[$prefix.'delivery_address']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'delivery_instruction',
        isset($this->data[$prefix.'delivery_instruction'])? trim($this->data[$prefix.'delivery_instruction']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'location_name',
        isset($this->data[$prefix.'location_name'])? trim($this->data[$prefix.'location_name']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'contact_phone',
        isset($this->data[$prefix.'contact_phone'])? trim($this->data[$prefix.'contact_phone']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'order_change',
        isset($this->data[$prefix.'order_change'])? trim($this->data[$prefix.'order_change']) :''
        );
        
       $this->functions->updateOptionAdmin($prefix.'site_url',
        isset($this->data[$prefix.'site_url'])? trim($this->data[$prefix.'site_url']) :''
        );
       $this->functions->updateOptionAdmin($prefix.'footer',
        isset($this->data[$prefix.'footer'])? trim($this->data[$prefix.'footer']) :''
        );
        
       $this->functions->updateOptionAdmin($prefix.'footer',
        isset($this->data[$prefix.'footer'])? trim($this->data[$prefix.'footer']) :''
        );
        
       $this->functions->updateOptionAdmin($prefix.'enabled_printer',
        isset($this->data[$prefix.'enabled_printer'])? trim($this->data[$prefix.'enabled_printer']) :''
        );
        
       $this->functions->updateOptionAdmin($prefix.'enabled_printer_fp_wifi',
        isset($this->data[$prefix.'enabled_printer_fp_wifi'])? trim($this->data[$prefix.'enabled_printer_fp_wifi']) :''
        );
        
        
        $this->code=1;
        $this->msg="Settings saved";
        $this->jsonResponse();  
    }


  public function pushLogs()
{
    $cols = array(
        'id', 'push_type', 'merchant_name', 'device_platform',
        'device_id', 'push_title', 'push_message',
        'date_created', 'date_process'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);           
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = '';        
    $search_fields = isset($this->data['search_fields']) ? trim($this->data['search_fields']) : '';
    if (!empty($search_fields)) {
        $and .= " AND (
            a.merchant_name LIKE " . $this->db->quote("%$search_fields%") . " OR
            a.push_type LIKE " . $this->db->quote("%$search_fields%") . " OR
            a.device_platform LIKE " . $this->db->quote("%$search_fields%") . " OR
            a.device_id LIKE " . $this->db->quote("%$search_fields%") . " OR
            a.device_uiid LIKE " . $this->db->quote("%$search_fields%") . " OR
            a.push_title LIKE " . $this->db->quote("%$search_fields%") . " OR
            a.push_message LIKE " . $this->db->quote("%$search_fields%") . "
        )";
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS a.*
    FROM mt_merchantapp_push_logs a
    WHERE 1
    $and
    $order
    $limit
    ";

    $query = $this->db->prepare($stmt);
    $query->execute();

    if ($res = $query->fetchAll(PDO::FETCH_ASSOC)) {
        $total_records = 0;
        $stmt_count = $this->db->prepare("SELECT FOUND_ROWS() as total_records");
        $stmt_count->execute();
        if ($resc = $stmt_count->fetch(PDO::FETCH_ASSOC)) {
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        foreach ($res as $val) {
            $t = $this->MerchantWrapper->prettyBadge($val['status']);
            $t .= "<a href=\"javascript:;\" class=\"show_error_details\" data-id=\"" . $val['id'] . "\" data-toggle=\"modal\" data-target=\"#errorDetails\" >
                    <i class=\"pl-2 fas fa-question-circle\"></i></a>";
            $t .= "<div></div>";
            $t .= $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);

            $date_process = $this->functions->prettyDate($val['date_process']) . " " . $this->functions->prettyTime($val['date_process']);

            $info = "<a href=\"javascript:;\" class=\"show_device_id\" data-id=\"" . $val['device_id'] . "\" data-toggle=\"modal\" data-target=\"#deviceDetails\" >";
            $info .= '<div class="concat-text">' . $val['device_id'] . "</div>";
            $info .= "</a>";

            $feed_data['aaData'][] = array(
                $val['id'],
                ($val['push_type']),
                $val['merchant_name'],
                (strtolower($val['device_platform'])),
                $info,
                ($val['push_title']),
                ($val['push_message']),
                $t,
                $date_process
            );
        }

        $this->otableOutput($feed_data);
    }

    $this->otableNodata();
}







    public function auto_order_settings()
    {
        
        $this->functions->updateOptionAdmin('merchantapp_enabled_auto_status_enabled',
        isset($this->data['merchantapp_enabled_auto_status_enabled'])? trim($this->data['merchantapp_enabled_auto_status_enabled']) :''
        );
        
        $this->functions->updateOptionAdmin('merchantapp_enabled_auto_status_time',
        isset($this->data['merchantapp_enabled_auto_status_time'])? trim($this->data['merchantapp_enabled_auto_status_time']) :''
        );
        
        $this->functions->updateOptionAdmin('merchantapp_enabled_auto_status',
        isset($this->data['merchantapp_enabled_auto_status'])? trim($this->data['merchantapp_enabled_auto_status']) :''
        );
        
        $this->functions->updateOptionAdmin('merchantapp_enabled_auto_status_readyin',
        isset($this->data['merchantapp_enabled_auto_status_readyin'])? trim($this->data['merchantapp_enabled_auto_status_readyin']) :''
        );
            
        $this->code=1;
        $this->msg="Settings saved";
        $this->jsonResponse();  
    }


     public function booking_settings()
    {
        $this->functions->updateOptionAdmin('booking_incoming_status',
        isset($this->data['booking_incoming_status'])? json_encode($this->data['booking_incoming_status']) :''
        );
        
        $this->functions->updateOptionAdmin('booking_cancel_status',
        isset($this->data['booking_cancel_status'])? json_encode($this->data['booking_cancel_status']) :''
        );
        
        $this->functions->updateOptionAdmin('booking_done_status',
        isset($this->data['booking_done_status'])? json_encode($this->data['booking_done_status']) :''
        );
        
        $this->functions->updateOptionAdmin('merchantapp_enabled_booking',
        isset($this->data['merchantapp_enabled_booking'])? trim($this->data['merchantapp_enabled_booking']) :''
        );
        
        $this->code=1;
        $this->msg="Settings saved";
        $this->jsonResponse();  
    }


    public function savesettings_policy()
    {
        $this->functions->updateOptionAdmin('merchantapp_privacy_policy_link',
        isset($this->data['merchantapp_privacy_policy_link'])? trim($this->data['merchantapp_privacy_policy_link']) :''
        );
        
        
        $this->code=1;
        $this->msg="Settings saved";
        $this->jsonResponse();  
    }


public function registeredDeviceList()
{
    $cols = array(
        'registration_id', 'name', 'device_platform', 'device_uiid', 'device_id',
        'push_enabled', 'subscribe_topic', 'date_created', 'last_login', 'registration_id'
    );

    $resp = $this->DatatablesWrapper->format($cols, $this->data);
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = " AND a.status IN ('active')";
    $and .= " AND a.device_id !=''";

    $search_fields = isset($this->data['search_fields']) ? trim($this->data['search_fields']) : '';
    $params = [];
    if (!empty($search_fields)) {
        $and .= " AND (
            a.name LIKE :search OR
            a.device_platform LIKE :search OR
            a.device_uiid LIKE :search OR
            a.device_id LIKE :search
        )";
        $params[':search'] = "%$search_fields%";
    }

    $stmt = "
        SELECT SQL_CALC_FOUND_ROWS
            a.registration_id,
            a.name,     
            a.device_platform,
            a.device_uiid,
            a.device_id,
            a.push_enabled,
            a.subscribe_topic,
            a.date_created,
            a.last_login
        FROM mt_view_merchantapp_device a
        WHERE 1              
        $and
        $order
        $limit
    ";

    $query = $this->db->prepare($stmt);
    $query->execute($params);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $total_records = 0;
        $count_stmt = $this->db->prepare("SELECT FOUND_ROWS() as total_records");
        $count_stmt->execute();
        $resc = $count_stmt->fetch(PDO::FETCH_ASSOC);
        if ($resc) {
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        foreach ($res as $val) {
            $date_created = $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);
            $last_login = $this->functions->prettyDate($val['last_login']) . " " . $this->functions->prettyTime($val['last_login']);

            $enabled_push = $val['push_enabled'] == 1 ? "Yes" : "No";
            $subscribe_topic = $val['subscribe_topic'] == 1 ? "Yes" : "No";

            $actions = '<a href="javascript:;" data-id="' . $val['registration_id'] . '" class="send_push" >' . ("send push") . '</a>';

            $info = "<a href=\"javascript:;\" class=\"show_device_id\" data-id=\"" . $val['device_id'] . "\" data-toggle=\"modal\" data-target=\"#deviceDetails\" >";
            $info .= '<div class="concat-text">' . $val['device_id'] . "</div>";
            $info .= "</a> ";

            $feed_data['aaData'][] = array(
                $val['registration_id'],
                $val['name'],
                strtolower($val['device_platform']),
                "<p class=\"concat-text\">" . $val['device_uiid'] . "</p>",
                $info,
                $this->MerchantWrapper->prettyBadge($enabled_push),
                $this->MerchantWrapper->prettyBadge($subscribe_topic),
                $date_created,
                $last_login,
                $actions
            );
        }

        if (isset($_GET['debug'])) {
            // debug output if needed
        }

        $this->otableOutput($feed_data);
    }

    $this->otableNodata();
}



public function pushBroadcast()
{
    $cols = array(
        'broadcast_id','push_title','push_message','merchant_name',
        'topics','date_created','date_modified'
    );
    
    $resp = $this->DatatablesWrapper->format($cols, $this->data);           
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = "";

    $search_fields = isset($this->data['search_fields']) ? trim($this->data['search_fields']) : '';
    if (!empty($search_fields)) {
        $search = "%$search_fields%";
        $and .= " AND (
            a.merchant_name LIKE :search OR
            a.push_title LIKE :search OR
            a.push_message LIKE :search
        )";
    }

    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.*
        FROM mt_merchantapp_broadcast a
        WHERE 1
        $and
        $order
        $limit
    ";

    $query = $this->db->prepare($stmt);

    if (!empty($search_fields)) {
        $query->bindValue(':search', $search, PDO::PARAM_STR);
    }

    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        
        $total_records = 0;
        $count_stmt = $this->db->query("SELECT FOUND_ROWS() as total_records");
        if ($resc = $count_stmt->fetch(PDO::FETCH_ASSOC)) {
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        foreach ($res as $val) {
            $details_link = Config::$baseUrl . "/singlemerchant/index/broadcast_details/id/" . $val['broadcast_id'];
            $action = '<a href="' . $details_link . '">' . ("View details") . '</a>';

            $date_modified = $this->functions->prettyDate($val['date_modified']) . " " . $this->functions->prettyTime($val['date_modified']);

            $t = $this->MerchantWrapper->prettyBadge($val['status']);
            $t .= "<a href=\"javascript:;\" class=\"show_error_details\" data-id=\"" . $val['broadcast_id'] . "\" data-toggle=\"modal\" data-target=\"#errorDetails\" >
                 <i class=\"pl-2 fas fa-question-circle\"></i></a> ";

            $t .= "<div></div>";
            $t .= $this->functions->prettyDate($val['date_created']) . " " . $this->functions->prettyTime($val['date_created']);

            $feed_data['aaData'][] = array(
                $val['broadcast_id'],
                $val['push_title'],
                $val['push_message'],
                $val['merchant_name'],
                $val['topics'],
                $t,
                $date_modified
            );
        }

        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


    public function datable_localize()
    {
        header('Content-type: application/json');
        $data = array(
          'decimal'=>'',
          'emptyTable'=> 'No data available in table',
          'info'=> "Showing _START_ to _END_ of _TOTAL_ entries",
          'infoEmpty'=> "Showing 0 to 0 of 0 entries",
          'infoFiltered'=>"filtered from _MAX_ total entries",
          'infoPostFix'=>'',
          'thousands'=>',',
          'lengthMenu'=> "Show _MENU_ entries",
          'loadingRecords'=>('Loading...'),
          'processing'=>("Processing..."),
          'search'=>("Search:"),
          'zeroRecords'=>("No matching records found"),
          'paginate' =>array(
            'first'=>("First"),
            'last'=>("Last"),
            'next'=>("Next"),
            'previous'=>("Previous")
          ),
          'aria'=>array(
            'sortAscending'=>(": activate to sort column ascending"),
            'sortDescending'=>(": activate to sort column descending")
          )
        );      
        echo json_encode($data);
    }  


public function merchant_list()
{
    $this->data = $_GET; 
    $data = array(); 
    $and = '';      

    if (isset($this->data['search'])) {           
        if (strlen($this->data['search']) > 0) {
            $and = " AND restaurant_name LIKE :search ";
        }
    }

    $stmt = "
        SELECT merchant_id as id, restaurant_name as text
        FROM mt_merchant
        WHERE status IN ('active')      
        $and
        ORDER BY restaurant_name ASC
        LIMIT 0,20
    ";

    $query = $this->db->prepare($stmt);

    if (!empty($and)) {
        $search_term = $this->data['search'] . '%';
        $query->bindValue(':search', $search_term, PDO::PARAM_STR);
    }

    if ($query->execute()) {
        $res = $query->fetchAll(PDO::FETCH_ASSOC);
        $data = $res;
    }

    $result = array(
        'results' => $data
    );

    header('Content-type: application/json');
    echo json_encode($result);
}

   public function save_broadcast()
    {               
        
        $merchant_id = isset($this->data['merchant_list'])?(integer)$this->data['merchant_list']:0;
        if($merchant_id<0){
            $this->msg = ("Merchant is required");
            $this->jsonResponse();
        }
        
        try {
            $resp = $this->MerchantWrapper->getMerchantInformation($merchant_id);
            
        } catch (Exception $e) {
            $this->msg = ($e->getMessage());
            $this->jsonResponse();
        }               
        
        $params = array(
           'merchant_id'=>$merchant_id,
           'merchant_name'=>$resp['restaurant_name'],
           'push_title'=>isset($this->data['push_title'])?$this->data['push_title']:'',
           'push_message'=>isset($this->data['push_message'])?$this->data['push_message']:'',
           'topics'=>'merchant_alert_'.$merchant_id,
           'date_created'=>$this->functions->dateNow(),
           'ip_address'=>$_SERVER['REMOTE_ADDR'],                  
        );              
        
        if($this->functions->insertData("mt_merchantapp_broadcast",$params)){   
            $this->code = 1;
            $this->msg = ("Successful");                                   
            $this->details = array(
              'next_action'=>"close_broadcast_modal"
            );
                    
                                 
        } else $this->msg = "failed cannot insert records. please try again later";
        $this->jsonResponse();
    }   


    public function order_trigger()
{               
    $feed_data = array();
    
    $cols = array(
      'trigger_id','trigger_type',
      'order_id','order_status','status','date_process'
    );          
        
    $resp = $this->DatatablesWrapper->format($cols, $this->data);       
    $where = '';
    $order = $resp['order'];
    $limit = $resp['limit'];
    
    $and = '';
    
    $search_fields = isset($this->data['search_fields']) ? trim($this->data['search_fields']) : '';
    if (!empty($search_fields)) {
        $search_fields = addslashes($search_fields);
        $and .= " AND 
        (             
          a.trigger_id LIKE '{$search_fields}%' OR
          a.trigger_type LIKE '%{$search_fields}%' OR
          a.order_status LIKE '%{$search_fields}%' OR
          a.status LIKE '%{$search_fields}%' OR
          a.order_id LIKE '{$search_fields}%'            
        )
        ";
    }
    
    $stmt = "SELECT SQL_CALC_FOUND_ROWS a.* FROM
    mt_merchantapp_order_trigger a
    WHERE 1
    $where
    $and
    $order
    $limit
    ";

    $res = $this->db->query($stmt);
    if ($res) {
        $res = $res->fetchAll(PDO::FETCH_ASSOC);
        
        $total_records = 0;
        $resc = $this->db->query("SELECT FOUND_ROWS() as total_records");
        if ($resc) {
            $resc = $resc->fetch(PDO::FETCH_ASSOC);
            $total_records = $resc['total_records'];
        }

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;
        
        $datas = array(); 
        foreach ($res as $val) {
            $cols_data = array();
            foreach ($cols as $key_cols => $cols_val) {
                if (array_key_exists($cols_val, (array)$val)) {
                    if ($key_cols == 5) {
                        $t = $this->MerchantWrapper->prettyBadge($val['status']);
                        $t .= "<div></div>";
                        $t .= $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                        $cols_data[] = $t;
                    } elseif ($key_cols == 1) {
                        $cols_data[] = ($val[$cols_val]);
                    } elseif ($key_cols == 3) {
                        $cols_data[] = ($val[$cols_val]);
                    } elseif ($key_cols == 4) {
                        $cols_data[] = ($val[$cols_val]);
                    } else {
                        $cols_data[] = $val[$cols_val];
                    }
                }
            }
            $datas[] = $cols_data;
        }

        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}
  




  public function uploadFile2()
    {
        require_once(__DIR__ . '/../../../vendor/SimpleUploader.php');
        if ( !$this->functions->isAdminLogin()){
            $this->msg = "Session has expired";
            $this->jsonResponse();
        }
        
        $path_to_upload = __DIR__ . '/../../../public/';
              
      if(!file_exists($path_to_upload)) { 
           if (!@mkdir($path_to_upload,0777)){
                $this->msg=$this->functions->translation("default","Cannot create upload folder. Please create the upload folder manually on your rood directory with 777 permission.");
                return ;
           }        
      }

       $htaccess =$this->functions->htaccessForUpload();
    $htfile=$path_to_upload.'.htaccess';        
      if (!file_exists($htfile)){
        $myfile = fopen($htfile, "w") or die("Unable to open file!".$htfile);    
            fwrite($myfile, $htaccess);        
            fclose($myfile);
      }

   $path_to_upload = __DIR__ . '/../../../upload/';

        
        $valid_extensions = array('json');
        $Upload = new FileUpload('uploadfile');
        $ext = $Upload->getExtension();
        $time=time();
        $filename = $Upload->getFileNameWithoutExt();         
        $new_filename =  "$filename.$ext";
        $Upload->newFileName = $new_filename;
        $Upload->sizeLimit = $this->functions->imageLimitSize();
        $result = $Upload->handleUpload($path_to_upload, $valid_extensions); 
        if (!$result) {
             $this->msg=$Upload->getErrorMsg();
        } else {                    
            
            


              $field_name = isset($_GET['field_name'])?$_GET['field_name']:'file_name';
        $input = '<input type="hidden" name="' . htmlspecialchars($field_name, ENT_QUOTES, 'UTF-8') . '" id="' . htmlspecialchars($field_name, ENT_QUOTES, 'UTF-8') . '" value="' . htmlspecialchars($new_filename, ENT_QUOTES, 'UTF-8') . '">';


            $input.= "File ".$new_filename;
            
             
             $this->functions->updateOptionAdmin('merchantappv2_fcm','');
                 
             $this->code = 1;
             $this->msg="OK";
             $this->details=array(
               'file_name'=>$new_filename,
               'field_name'=>$field_name,
               'input'=>$input
             );
        }
        $this->jsonResponse();
    }








	
	



   











	
	
	
}
/*end class*/