<?php

class UserWrapper
{	
	


	public function __construct() {
       
        //$model = new Model();
        
        $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
		$this->functions = new Functions(); // Create an instance of Functions

    $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);

       
	
		

    }

	
	public function login($username = '', $password = '', $user_type = '')
{
    if (empty($username)) {
        throw new Exception("Username is required");
    }
    if (empty($password)) {
        throw new Exception("Password is required");
    }
    if (empty($user_type)) {
        throw new Exception("User type is required");
    }

    $new_user_type = [];
    switch ($user_type) {
        case "admin":
            $new_user_type = ['user_type', 'admin'];
            break;

        case "merchant":
            $new_user_type = ['merchant_user', 'merchant'];
            break;

        default:
            break;
    }

    // Prepare the SQL query
    $query = "SELECT id, user_type, session_token, status, username, email_address, inventory_enabled 
              FROM mt_user_master_list 
              WHERE username = :username AND password = :password AND user_type IN (:type1, :type2)
              LIMIT 1";

    // Prepare statement
    $stmt = $this->db->prepare($query);

    // Bind parameters
    $stmt->bindParam(':username', $username, PDO::PARAM_STR);
    $stmt->bindParam(':password', $hashedPassword = md5($password), PDO::PARAM_STR);
    $stmt->bindParam(':type1', $new_user_type[0], PDO::PARAM_STR);
    $stmt->bindParam(':type2', $new_user_type[1], PDO::PARAM_STR);

    // Execute and fetch result
    $stmt->execute();
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        if ($resp['inventory_enabled'] <= 0) {
            throw new Exception("Your account is not allowed to access this platform");
        }

        $table_name = '';
        $where_id = '';

        $table = $this->getTableByUseType($resp['user_type']);

        $table_name = $table['table_name'];
        $where_id = $table['where_id'];

        if (!empty($table_name)) {
            $token = $this->generateToken();

            // Update session token in the corresponding table
            $updateQuery = "UPDATE $table_name SET session_token = :session_token WHERE $where_id = :id";
            $updateStmt = $this->db->prepare($updateQuery);
            $updateStmt->bindParam(':session_token', $token, PDO::PARAM_STR);
            $updateStmt->bindParam(':id', $resp['id'], PDO::PARAM_INT);
            $updateStmt->execute();

            // Set cookies using native PHP
            setcookie('inventory_token', $token, [
                'expires' => time() + 3600,
                'path' => '/',
                'secure' => isset($_SERVER['HTTPS']),
                'httponly' => true,
                'samesite' => 'Strict',
            ]);
            setcookie('inventory_token_type', $resp['user_type'], [
                'expires' => time() + 3600,
                'path' => '/',
                'secure' => isset($_SERVER['HTTPS']),
                'httponly' => true,
                'samesite' => 'Strict',
            ]);
            setcookie('inventory_token_user', $resp['username'], [
                'expires' => time() + 3600,
                'path' => '/',
                'secure' => isset($_SERVER['HTTPS']),
                'httponly' => true,
                'samesite' => 'Strict',
            ]);
            setcookie('inventory_token_email', $resp['email_address'], [
                'expires' => time() + 3600,
                'path' => '/',
                'secure' => isset($_SERVER['HTTPS']),
                'httponly' => true,
                'samesite' => 'Strict',
            ]);

            return true;
        } else {
            throw new Exception("Login failed.");
        }
    }

    throw new Exception("Either username or password are invalid");
}


public  function getTableByUseType($user_type='')
	{
		$table_name=''; $where_id=''; 
				
		switch ($user_type) {
     		case "user_type":// admin
     			$table_name  ='mt_admin_user';
     			$where_id = 'admin_id';
     			$user_type = 'admin';
     			break;
     	
     		case "merchant_user":
     			$table_name  ='mt_merchant_user';
     			$where_id = 'merchant_user_id';
     			$user_type = $user_type;
     			break;
     			
     		case "merchant":
     			$table_name ='mt_merchant';
     			$where_id = 'merchant_id';
     			$user_type = $user_type;
     			break;
     				
     		default:
     			break;
     	}         	
     	return array(
     	  'table_name'=>$table_name,
     	  'where_id'=>$where_id,
     	  'user_type'=>$user_type
     	);
	}


	public function getToken()
{
    $token = '';
    
    // Check if the user is logged in using PHP sessions
    if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
        $token = isset($_SESSION['user_token']) ? $_SESSION['user_token'] : '';
    }
    
    return $token;
}

public function getUserType()
{
    $type = '';
    
    // Check if the user is logged in using PHP sessions
    if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
        $type = isset($_SESSION['user_type']) ? $_SESSION['user_type'] : '';
    }
    
    // Adjust user type if needed
    if ($type === "user_type") {
        $type = 'admin';
    }
    
    return $type;
}


public function getUserName()
{
    $user_name = '';
    
    // Check if the user is logged in using PHP sessions
    if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
        $user_name = isset($_SESSION['username']) ? $_SESSION['username'] : '';
    }
    
    return $user_name;
}

public function getUserEmail()
{
    $user_email = '';
    
    // Check if the user is logged in using PHP sessions
    if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
        $user_email = isset($_SESSION['user_email']) ? $_SESSION['user_email'] : '';
    }
    
    return $user_email;
}

public  function generateToken()
    {
        $agent = md5($_SERVER['HTTP_USER_AGENT']);      
        return sha1(uniqid(mt_rand(), true)).$agent;
    }


  public function validToken_bkupbywas_26dec($status = 'active')
{
    // Check if the user is logged in using PHP sessions
    if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
        $token = $this->getToken();
        
       if (!empty($token)) {
    // Check if the user type is 'merchant'
    if ($_SESSION['user_type'] == 'merchant') {
        // Prepare the PDO query
        $stmt = $this->db->prepare("
            SELECT merchant_id 
            FROM mt_merchant 
            WHERE session_token = :session_token AND status = :status
            LIMIT 1
        ");

        // Bind parameters and execute the query
        $stmt->execute([
            ':session_token' => $token,
            ':status' => $status,
        ]);

        // Fetch the result
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($resp) {
            // Token is valid and the merchant exists
            return true;
        }
    }
}

    }

    return false;
}

  public function validToken($status = 'active')
{
    if(isset($_SESSION['inventory_merchant'])){
        return true;
    }else{
        return false;
    }
    
}




public function getAcessRules($status = 'active')
{
    $access = array('none');
    $token = $this->getToken();

    if (!empty($token)) {
        // Prepare the SQL query
        $stmt = "
            SELECT 
                a.user_type,
                a.role_id,          
                a.session_token,
                a.status,
                b.access
            FROM 
                mt_user_master_list a
            LEFT JOIN mt_inventory_access_role b
                ON a.role_id = b.role_id
            WHERE
                a.session_token = :session_token
            LIMIT 1
        ";

        // Prepare and execute the query using PDO
        $query = $this->db->prepare($stmt);
        $query->execute([
            ':session_token' => $token,
        ]);

        // Fetch the result
        $res = $query->fetch(PDO::FETCH_ASSOC);

        if ($res && !empty($res['access'])) {
            $access = json_decode($res['access'], true);
        }
    }

    return $access;
}


public  function AllowAccess()
    {
        return $this->validToken();
    }

    public  function AllowAccessAdmin()
    {
        $validtoken =  $this->validToken();
        $user_type = $this->getUserType();
        if($user_type=="admin" && $validtoken==true){
            return true;
        }
        return false;
    }


public function logout()
{
    $token = $this->getToken();

    if (!empty($token)) {
        // Prepare the SQL query to fetch user data by session_token
        $stmt = "
            SELECT id, user_type, session_token, status
            FROM mt_user_master_list
            WHERE session_token = :session_token
            LIMIT 1
        ";

        // Execute the query using PDO
        $query = $this->db->prepare($stmt);
        $query->execute([
            ':session_token' => $token,
        ]);

        // Fetch the result
        $resp = $query->fetch(PDO::FETCH_ASSOC);

        if ($resp) {
            // Get table name by user type
            $table = $this->getTableByUseType($resp['user_type']);
            $new_token = $this->generateToken();

            if (!empty($table['table_name'])) {
                // Prepare and execute the update query to clear the session token
                $updateStmt = "
                    UPDATE {$table['table_name']}
                    SET session_token = :new_token
                    WHERE session_token = :session_token
                ";

                // Execute the update using PDO
                $updateQuery = $this->db->prepare($updateStmt);
                $updateQuery->execute([
                    ':new_token' => $new_token,
                    ':session_token' => $token,
                ]);
            }
        }
    }

    // Clear user session data (using PHP session handling instead of Yii)
    session_unset();
    session_destroy();
}


public function getMerchantIDByAccesToken()
{
    $token = $this->getToken();

    if (!empty($token)) {
        // Prepare the SQL query to fetch user data by session_token
        $stmt = "
            SELECT id, user_type, session_token, status, merchant_id
            FROM mt_user_master_list
            WHERE session_token = :session_token
            LIMIT 1
        ";

        // Execute the query using PDO
        $query = $this->db->prepare($stmt);
        $query->execute([
            ':session_token' => $token,
        ]);

        // Fetch the result
        $resp = $query->fetch(PDO::FETCH_ASSOC);

        if ($resp) {
            // Get table details based on user type
            $user = $this->getTableByUseType($resp['user_type']);

            // Determine the merchant ID based on the user type
            switch ($user['user_type']) {
                case 'merchant':
                    return $resp['id'];
                    break;

                case 'merchant_user':
                    return $resp['merchant_id'];
                    break;

                default:
                    break;
            }
        }
    }
    return false;
}



public function getAllUserByMerchantID($merchant_id = '')
{
    $merchant_id = (int)$merchant_id;

    if ($merchant_id > 0) {
        // Simplified SQL query to fetch all active users
        $stmt = "
            SELECT id, 
                   merchant_id, 
                   user_type, 
                   username, 
                   status
            FROM mt_user_master_list
            WHERE status = 'active'
        ";

        // Prepare and execute the query
        $query = $this->db->prepare($stmt);
        $query->execute();

        // Fetch the results
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        // Filter results in PHP
        if ($res) {
            return array_filter($res, function ($row) use ($merchant_id) {
                return ($row['id'] == $merchant_id || $row['merchant_id'] == $merchant_id) &&
                       in_array($row['user_type'], ['merchant', 'merchant_user']);
            });
        }
    }
    return false;
}







public function insertAccessRole($params = array(), $id = '')
{
    if ($id > 0) {
        // Prepare the select query to check if the role already exists
        $stmt = "
            SELECT role_name
            FROM mt_inventory_access_role
            WHERE role_name = :role_name AND role_id <> :role_id
            LIMIT 1
        ";
        $query = $this->db->prepare($stmt);
        $query->execute([
            ':role_name' => $params['role_name'],
            ':role_id'   => $id
        ]);
        $resp = $query->fetch(PDO::FETCH_ASSOC);

        if (!$resp) {
            // Prepare the update query if no existing role name is found
            $stmt = "
                UPDATE mt_inventory_access_role
                SET role_name = :role_name
                WHERE role_id = :role_id
            ";
            $query = $this->db->prepare($stmt);
            $query->execute([
                ':role_name' => $params['role_name'],
                ':role_id'   => $id
            ]);

            if ($query->rowCount() > 0) {
                return true;
            } else {
                throw new Exception("Failed to update records");
            }
        } else {
            throw new Exception("Role name already exists");
        }
    } else {
        // Prepare the select query to check if the role name already exists
        $stmt = "
            SELECT role_name
            FROM mt_inventory_access_role
            WHERE role_name = :role_name
            LIMIT 1
        ";
        $query = $this->db->prepare($stmt);
        $query->execute([
            ':role_name' => $params['role_name']
        ]);
        $resp = $query->fetch(PDO::FETCH_ASSOC);

        if (!$resp) {
            // Prepare the insert query if the role name does not exist
            $stmt = "
                INSERT INTO mt_inventory_access_role (role_name)
                VALUES (:role_name)
            ";
            $query = $this->db->prepare($stmt);
            $query->execute([
                ':role_name' => $params['role_name']
            ]);

            if ($query->rowCount() > 0) {
                return true;
            } else {
                throw new Exception("Failed to insert records");
            }
        } else {
            throw new Exception("Role name already exists");
        }
    }

    throw new Exception("An error has occurred");
}



public function deleteRole($ids = array())
{
    // Convert the ids array into a comma-separated string for the IN condition
    $ids = implode(",", array_map('intval', $ids));

    // Prepare the select query to check for protected roles
    $stmt = "
        SELECT is_protected 
        FROM mt_inventory_access_role
        WHERE is_protected = '1'
        AND role_id IN ($ids)
    ";
    $query = $this->db->prepare($stmt);
    $query->execute();
    $res = $query->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        throw new Exception("Failed: Protected access cannot be deleted");
    }

    // Prepare the delete query to remove roles from the database
    $stmt = "
        DELETE FROM mt_inventory_access_role
        WHERE role_id IN ($ids)
    ";
    $query = $this->db->prepare($stmt);
    $query->execute();

    // Check if any rows were deleted
    if ($query->rowCount() > 0) {
        return true;
    } else {
        throw new Exception("Failed: Cannot delete records");
    }
}



public function getAccessRole()
{
    // Prepare the SQL query to select all records from the mt_inventory_access_role table
    $stmt = "SELECT * FROM mt_inventory_access_role ORDER BY role_name ASC";
    $query = $this->db->prepare($stmt);
    
    // Execute the query
    $query->execute();

    // Fetch all results
    $resp = $query->fetchAll(PDO::FETCH_ASSOC);

    // Check if any records are found
    if ($resp) {
        return $resp;
    } else {
        throw new Exception("Record not found");
    }
}


public function insertUserAccess($user_type='', $merchant_id='', $params=array(), $id='')
{
    // Prepare the condition to exclude the ID if provided
    $and = "";
    if ($id > 0) {
        $and .= " AND id <> :id ";
    }

    // Check if username or email already exists
    $stmt = "
    SELECT username FROM 
    mt_user_master_list
    WHERE 1
    AND user_type IN ('merchant_user', 'merchant')
    AND (username = :username OR email_address = :contact_email)
    $and
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':username', $params['username'], PDO::PARAM_STR);
    $query->bindParam(':contact_email', $params['contact_email'], PDO::PARAM_STR);
    if ($id > 0) {
        $query->bindParam(':id', $id, PDO::PARAM_INT);
    }
    $query->execute();

    // If any records are found, throw an exception
    if ($query->rowCount() > 0) {
        throw new Exception("Username or email address already exist");
    }

    // Handle based on user type
    switch ($user_type) {
        case "merchant":
            if ($id > 0) {
                $stmt = "
                SELECT merchant_id FROM mt_merchant
                WHERE merchant_id = :merchant_id
                LIMIT 1
                ";
                $query = $this->db->prepare($stmt);
                $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
                $query->execute();
                $resp = $query->fetch(PDO::FETCH_ASSOC);

                if ($resp) {
                    // Update merchant record
                    $stmt = "
                    UPDATE mt_merchant 
                    SET column_name = :column_value
                    WHERE merchant_id = :merchant_id
                    ";
                    $query = $this->db->prepare($stmt);
                    // Bind your $params values for update
                    $query->bindParam(':merchant_id', $id, PDO::PARAM_INT);
                    // Bind other parameters (replace column_name with actual column name)
                    if ($query->execute()) {
                        return true;
                    } else {
                        throw new Exception("Failed, cannot update records");
                    }
                } else {
                    throw new Exception("Record not found");
                }
            } else {
                // Handle insert logic for new merchant here (if needed)
            }
            break;

        case "merchant_user":
            if ($id > 0) {
                $stmt = "
                SELECT merchant_id FROM mt_merchant_user
                WHERE merchant_id = :merchant_id AND merchant_user_id = :merchant_user_id
                LIMIT 1
                ";
                $query = $this->db->prepare($stmt);
                $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
                $query->bindParam(':merchant_user_id', $id, PDO::PARAM_INT);
                $query->execute();
                $resp = $query->fetch(PDO::FETCH_ASSOC);

                if ($resp) {
                    // Update merchant user record
                    $stmt = "
                    UPDATE mt_merchant_user
                    SET column_name = :column_value
                    WHERE merchant_user_id = :merchant_user_id
                    ";
                    $query = $this->db->prepare($stmt);
                    // Bind your $params values for update
                    $query->bindParam(':merchant_user_id', $id, PDO::PARAM_INT);
                    if ($query->execute()) {
                        return true;
                    } else {
                        throw new Exception("Failed, cannot update records");
                    }
                } else {
                    throw new Exception("Record not found");
                }
            } else {
                // Insert new merchant user
                $stmt = "
                INSERT INTO mt_merchant_user (column_name1, column_name2)
                VALUES (:value1, :value2)
                ";
                $query = $this->db->prepare($stmt);
                // Bind parameters
                $query->bindParam(':value1', $params['value1'], PDO::PARAM_STR);
                $query->bindParam(':value2', $params['value2'], PDO::PARAM_STR);
                if ($query->execute()) {
                    return true;
                } else {
                    throw new Exception("Failed, cannot insert records");
                }
            }
            break;

        default:
            throw new Exception("Invalid user type");
            break;
    }
}


public function deleteUser($merchant_id = '', $ids = array())
{
    $ok = true;
    
    // Loop through all the IDs to check the user type
    foreach ($ids as $id) {
        // SQL query to select the user type
        $stmt = "
        SELECT user_type
        FROM mt_user_master_list
        WHERE id = :id
        AND merchant_id = :merchant_id
        ";
        
        // Prepare the statement
        $query = $this->db->prepare($stmt);
        $query->bindParam(':id', $id, PDO::PARAM_INT);
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $query->execute();
        
        // If the user type is 'merchant', prevent deletion
        if ($query->rowCount() > 0) {
            $res = $query->fetch(PDO::FETCH_ASSOC);
            if ($res['user_type'] == 'merchant') {
                $ok = false;
            }
        }
    }
    
    // If allowed to proceed with deletion
    if ($ok) {
        // SQL query to delete records from 'mt_merchant_user'
        $placeholders = rtrim(str_repeat('?,', count($ids)), ','); // Create placeholders for IN clause
        $stmt = "
        DELETE FROM mt_merchant_user
        WHERE merchant_id = :merchant_id
        AND merchant_user_id IN ($placeholders)
        ";

        // Prepare the statement
        $query = $this->db->prepare($stmt);
        $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        
        // Bind the user IDs for the IN condition
        foreach ($ids as $index => $id) {
            $query->bindValue($index + 1, $id, PDO::PARAM_INT);
        }
        
        // Execute the query and check if deletion was successful
        if ($query->execute()) {
            return true;
        } else {
            throw new Exception("Failed, cannot delete records");
        }
    } else {
        throw new Exception("Failed, you cannot delete the main user account");
    }
}


public function merchantUserValidate($user_type = '', $email_address = '', $contact_phone = '', $token = '')
{
    if ($user_type == "admin") {
        $user_type = 'user_type';
    }
    
    // Prepare SQL statement with placeholders for parameters
    $stmt = "
    SELECT email_address, contact_number 
    FROM mt_user_master_list 
    WHERE user_type = :user_type
    AND (email_address = :email_address OR contact_number = :contact_phone)
    AND session_token != :token
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind parameters to prevent SQL injection
    $query->bindParam(':user_type', $user_type, PDO::PARAM_STR);
    $query->bindParam(':email_address', $email_address, PDO::PARAM_STR);
    $query->bindParam(':contact_phone', $contact_phone, PDO::PARAM_STR);
    $query->bindParam(':token', $token, PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Check if any results were returned
    if ($query->rowCount() > 0) {
        $res = $query->fetch(PDO::FETCH_ASSOC);

        // Check if email or contact number already exists
        if ($res['email_address'] == $email_address) {
            throw new Exception("Email address already exists");
        }
        if ($res['contact_number'] == $contact_phone) {
            throw new Exception("Contact number already exists");
        }

        // If neither is found, throw a generic exception
        throw new Exception("Either email address or contact number already exists");
    }

    return true;
}



















	
	
	
}
/*end class*/