<?php
class StocksWrapper
{

	public function __construct() {
        // Access the PDO connection from the Model class
        //$model = new Model();
        $model = Model::getInstance();
        
        $this->db = $model->getDb();
        

        $this->functions = new Functions();
        $this->ItemWrap = new ItemWrap();
        $this->InventoryWrapper = new InventoryWrapper();
        

    }


	public  function adjustmentType()
	{
		return array(
		  'receive_items'=>"Receive Items",
		  'inventory_count'=>"Inventory count",
		  'loss'=>"Loss",
		  'damage'=>"Damage",
		  'item_edit'=>"Item edit",
		  'sale'=>"Sale"
		);
	}
	
	public  function adjustmentTypeList()
	{
		$arr1 =  array(
		  'all'=>"All reason"		  
		);
		$arr2 = $this->adjustmentType();
		return $arr1+$arr2;
	}
	
	public  function purchaseStatus()
	{
		return array(
		  'all'=>"All",
		  'pending'=>"Pending",
		  'partially_received'=>"Partially received",
		  'closed'=>"Closed",
		);
	}
	
public  function tableProperties()
{
    return array(
        'receive_items'=> array(
            'label'=> array('Item', 'In Stock', 'Add Stock', 'Cost', 'Stock after', ''),
            'sizes'=> array('30%', '10%', '12%', '12%', '12%', '10%')
        ),
        'inventory_count'=> array(
            'label'=> array('Item', 'Expected stock', 'Counted stock', ''),
            'sizes'=> array('30%', '10%', '12%', '12%')
        ),
        'loss'=> array(
            'label'=> array('Item', 'In stock', 'Remove stock', 'Stock after', ''),
            'sizes'=> array('30%', '10%', '12%', '12%', '10%')
        ),
        'damage'=> array(
            'label'=> array('Item', 'In stock', 'Remove stock', 'Stock after', ''),
            'sizes'=> array('30%', '10%', '12%', '12%', '10%')
        )
    );
}

	
	public function tablePropertiesView()
{
    return array(
        'receive_items'=> array(
            'label'=> array('Item', 'Add Stock', 'Cost'),
            'fields'=> array('item_name', 'qty', 'cost_price'),
            'class'=> array('', 'col-qty', 'col-qty')
        ),
        'inventory_count'=> array(
            'label'=> array('Item', 'Counted stock'),
            'fields'=> array('item_name', 'qty'),
            'class'=> array('', 'col-qty')
        ),
        'loss'=> array(
            'label'=> array('Item', 'Remove stock'),
            'fields'=> array('item_name', 'qty'),
            'class'=> array('', 'col-qty')
        ),
        'damage'=> array(
            'label'=> array('Item', 'Remove stock'),
            'fields'=> array('item_name', 'qty'),
            'class'=> array('', 'col-qty')
        )
    );
}

	
	public function autoGenerateTransactionID()
{
    $stmt = $this->db->prepare("SHOW TABLE STATUS LIKE 'mt_inventory_transaction'");
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res['Auto_increment'];
    }

    return false;
}

	
	public function autoGenerateID($table = '')
{
    $stmt = $this->db->prepare("SHOW TABLE STATUS LIKE :table");
    $stmt->bindParam(':table', $table, PDO::PARAM_STR);
    $stmt->execute();
    $res = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($res) {
        return $res['Auto_increment'];
    }

    return false;
}

	
	public  function transactionCode($type='')
	{
		$options = array(
		 'sa'=>"SA",
		 'po'=>"PO",
		 'or'=>"OR"
		);
		if(array_key_exists($type,$options)){
			return $options[$type];
		}
		return 'NA';
	}
	
	public  function insertAdjustment($params=array(), $params2=array() )
	{		
		$transaction_type = isset($params['transaction_type'])?$params['transaction_type']:'';
		if(empty($transaction_type)){
			throw new Exception( "Invalid transaction type" );
		}
		
		if($this->functions->insertData("mt_inventory_transaction",$params)){
			foreach ($params2 as $val) {				
				$i = $this->functions->insertData("mt_inventory_transaction_details",$val);
				
				$stock_after = 0;
				$stock_balance = (float) $this->getStocksSKU($val['sku']);		
				$qty  = (float) $val['qty'];		
				
				/*dump("stock_balance=>$stock_balance");
				dump("qty=>$stock_balance");*/
				
				switch ($transaction_type) {
					case "inventory_count":		
					      if($qty>=$stock_balance){
					      	 $difference = $qty-$stock_balance;
					      	 $qty = $difference;
					      	 $stock_after = $stock_balance+$difference;
					      } else {
					      	 $stock_after = $qty;
					      	 $qty = -($stock_balance-$qty);
					      }
						break;
						
					case "loss":   
					case "damage":				
					    $stock_after = $stock_balance - $val['qty'];
					    break;
					        
					default:
						$stock_after = $stock_balance + $val['qty'];
						break;
				}				
				
				$params_trans = array(
				  'created_at'=>$this->functions->dateNow(),
				  'sku'=>$val['sku'],
				  'merchant_id'=>$params['merchant_id'],
				  'transaction_type'=>$params['transaction_type'],
				  'transaction_id'=>$val['transaction_id'],
				  'transaction_code'=>$params['transaction_code'],
				  'adjustment'=>(float)$qty,
				  'stock_after'=>(float)$stock_after,				  
				  'cost_price'=>(float)$val['cost_price'],
				  'added_by'=>$_SESSION['username'] ,
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);												
				$this->insertInventoryStocks($params_trans);
			}
		 } else throw new Exception( "Failed cannot insert records" );
	}
	
	public  function insertInventoryStocks($data=array()){
		if($this->functions->insertData("mt_inventory_stocks",$data)){
	    	return true;
	    } else throw new Exception( "Failed cannot insert records" );
	}
	
	public function getStocksSKU($sku = '')
{
    // Prepare the SQL query
    $sql = "SELECT stock_after FROM mt_inventory_stocks WHERE sku = :sku ORDER BY stock_id DESC LIMIT 1";
    
    // Prepare the statement
    $stmt = $this->db->prepare($sql);
    
    // Bind the SKU parameter
    $stmt->bindParam(':sku', $sku, PDO::PARAM_STR);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch the result
    $resp = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Check if we got a result and return the stock_after value
    if ($resp) {
        return $resp['stock_after'];
    }
    
    // If no result, return 0
    return 0;
}

	
	public function getTransactionDetails($transaction_id = '', $merchant_id = '')
{
    // Prepare the SQL query
    $sql = "
        SELECT 
            a.*, 
            b.sku, 
            b.cost_price, 
            b.qty, 
            c.item_name, 
            c.size_name
        FROM mt_inventory_transaction a
        LEFT JOIN mt_inventory_transaction_details b
            ON a.transaction_id = b.transaction_id
        LEFT JOIN mt_view_item c
            ON b.sku = c.sku
        WHERE a.transaction_id = :transaction_id
            AND a.merchant_id = :merchant_id
    ";
    
    // Prepare the statement
    $stmt = $this->db->prepare($sql);
    
    // Bind parameters
    $stmt->bindParam(':transaction_id', $transaction_id, PDO::PARAM_INT);
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    
    // Execute the query
    $stmt->execute();
    
    // Fetch all the results
    $res = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Check if results are found
    if ($res) {
        return $res;
    } else {
        throw new Exception("Record not found");
    }
}

	
	public function insertSupplier($merchant_id = '', $params = array(), $id = '')
{
    // Check if $id is greater than 0 for updating an existing supplier
    if ($id > 0) {
        // Prepare the SELECT query to check if the supplier already exists with the same name
        $sql = "
            SELECT supplier_name
            FROM mt_inventory_supplier
            WHERE merchant_id = :merchant_id
              AND supplier_name = :supplier_name
              AND supplier_id <> :supplier_id
            LIMIT 1
        ";
        
        // Prepare the statement
        $stmt = $this->db->prepare($sql);
        
        // Bind parameters
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':supplier_name', $params['supplier_name'], PDO::PARAM_STR);
        $stmt->bindParam(':supplier_id', $id, PDO::PARAM_INT);
        
        // Execute the query
        $stmt->execute();
        
        // Fetch the result
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // If supplier does not exist, proceed to update
        if (!$resp) {
            // Update the supplier data
            $updateSql = "
                UPDATE mt_inventory_supplier
                SET supplier_name = :supplier_name
                WHERE supplier_id = :supplier_id
            ";
            
            // Prepare the update statement
            $updateStmt = $this->db->prepare($updateSql);
            
            // Bind parameters for update
            $updateStmt->bindParam(':supplier_name', $params['supplier_name'], PDO::PARAM_STR);
            $updateStmt->bindParam(':supplier_id', $id, PDO::PARAM_INT);
            
            // Execute the update query
            $updateStmt->execute();
            
            // Check if the update was successful
            if ($updateStmt->rowCount() > 0) {
                return true;
            } else {
                throw new Exception("Failed to update the records");
            }
        } else {
            throw new Exception("Supplier name already exists");
        }
    } else {
        // Prepare the SELECT query to check if the supplier exists
        $sql = "
            SELECT supplier_name
            FROM mt_inventory_supplier
            WHERE merchant_id = :merchant_id
              AND supplier_name = :supplier_name
            LIMIT 1
        ";
        
        // Prepare the statement
        $stmt = $this->db->prepare($sql);
        
        // Bind parameters
        $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
        $stmt->bindParam(':supplier_name', $params['supplier_name'], PDO::PARAM_STR);
        
        // Execute the query
        $stmt->execute();
        
        // Fetch the result
        $resp = $stmt->fetch(PDO::FETCH_ASSOC);
        
        // If supplier does not exist, proceed to insert
        if (!$resp) {
            // Prepare the INSERT query
            $insertSql = "
                INSERT INTO mt_inventory_supplier (supplier_name, merchant_id)
                VALUES (:supplier_name, :merchant_id)
            ";
            
            // Prepare the insert statement
            $insertStmt = $this->db->prepare($insertSql);
            
            // Bind parameters for insert
            $insertStmt->bindParam(':supplier_name', $params['supplier_name'], PDO::PARAM_STR);
            $insertStmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
            
            // Execute the insert query
            $insertStmt->execute();
            
            // Check if the insert was successful
            if ($insertStmt->rowCount() > 0) {
                return true;
            } else {
                throw new Exception("Failed to insert records");
            }
        } else {
            throw new Exception("Supplier name already exists");
        }
    }
    
    // If none of the conditions match, throw a generic error
    throw new Exception("An error has occurred");
}


	public function deleteSupplier($merchant_id = '', $ids = array())
{
    // Check if there are IDs provided
    if (empty($ids)) {
        throw new Exception("No supplier IDs provided for deletion");
    }

    // Prepare the DELETE query with placeholders
    $sql = "
        DELETE FROM mt_inventory_supplier
        WHERE merchant_id = :merchant_id
        AND supplier_id IN (" . implode(',', array_fill(0, count($ids), '?')) . ")
    ";

    // Prepare the statement
    $stmt = $this->db->prepare($sql);

    // Bind the merchant_id parameter
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Bind the supplier_ids dynamically
    foreach ($ids as $index => $id) {
        $stmt->bindValue($index + 1, $id, PDO::PARAM_INT);
    }

    // Execute the DELETE query
    $stmt->execute();

    // Check if rows were affected
    if ($stmt->rowCount() > 0) {
        return true;
    } else {
        throw new Exception("Failed, cannot delete records");
    }
}

	
	public function getSupplier($merchant_id = '')
{
    // Prepare the SELECT query
    $sql = "
        SELECT supplier_id, supplier_name
        FROM mt_inventory_supplier
        WHERE merchant_id = :merchant_id
        ORDER BY supplier_name ASC
    ";

    // Prepare the statement
    $stmt = $this->db->prepare($sql);

    // Bind the merchant_id parameter
    $stmt->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    $stmt->execute();

    // Fetch all results
    $resp = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Check if results were found
    if ($resp) {
        return $resp;
    }

    return false;
}

	
	public  function insertPurchase($params=array(), $params2=array(), $row_id=0)
	{
		if(count($params)<=0){			
			throw new Exception( "invalid parameters" );
		}
		if(count($params2)<=0){			
			throw new Exception( "invalid items" );
		}
				
		
		/*dump("row=>$row_id");
		dump($params);
		dump($params2);
		die();*/		

		if($row_id>0){


			

          	$up = $this->functions->updateData("mt_inventory_purchase_order", $params, 'po_id', $row_id);




          	if($up){
          		foreach ($params2 as $val) {
          			$po_details_id = isset($val['po_details_id'])? (integer) $val['po_details_id'] :'';
          			unset($val['po_details_id']);
          			if($po_details_id>0){          			
          				$this->functions->updateData(
					    "mt_inventory_purchase_order_details",  // Table name
					    $val,                                    // Associative array of columns to update
					    'po_details_id',                         // Column name for WHERE clause
					    $po_details_id                           // Value for WHERE clause
						);

          			} else {
          				$i = $this->functions->insertData("mt_inventory_purchase_order_details",$val);
          			}
          		}          		
          		
          		$this->functions->updatePurchaseOrderStatus($row_id);
          		
          	} else throw new Exception( "Failed cannot update records" );
		} else {		
			if($this->functions->insertData("mt_inventory_purchase_order",$params)){
				foreach ($params2 as $val) {
					$i = $this->functions->insertData("mt_inventory_purchase_order_details",$val);
				}
			} else throw new Exception( "Failed cannot insert records" );
		}
	}
	
	public function getPurchaseDetails($po_id = '', $merchant_id = '')
{
    if ($po_id <= 0) {
        throw new Exception("Invalid purchase number");
    }
    if ($merchant_id <= 0) {
        throw new Exception("Invalid merchant ID");
    }

    $stmt = "
        SELECT 
            a.po_id, a.merchant_id, a.purchase_date, a.supplier_id, a.supplier_name, 
            a.notes, a.total_qty, a.added_by, a.status, a.expected_on,
            b.sku, c.item_name, c.size_name, b.po_details_id, b.qty, b.cost_price,
            IFNULL(
                (SELECT available_stocks FROM mt_view_item_stocks WHERE sku = b.sku), 0
            ) AS available_stocks,
            IFNULL(
                (SELECT SUM(qty) FROM mt_inventory_purchase_receive WHERE po_details_id = b.po_details_id), 0
            ) AS total_receive,
            IFNULL(
                (SELECT incoming_balance FROM mt_view_inventory_purchase_stocks WHERE sku = b.sku), 0
            ) AS incoming_balance
        FROM 
            mt_view_inventory_purchase_order a
        LEFT JOIN 
            mt_inventory_purchase_order_details b ON a.po_id = b.po_id
        LEFT JOIN 
            mt_view_item c ON b.sku = c.sku
        WHERE 
            a.merchant_id = :merchant_id
        AND 
            a.po_id = :po_id
        ORDER BY 
            b.po_details_id ASC
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':po_id', $po_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $result = $query->fetchAll(PDO::FETCH_ASSOC);
        if (!empty($result)) {
            return $result;
        } else {
            throw new Exception("Record not found");
        }
    } else {
        throw new Exception("Database query failed");
    }
}
	
	
	public  function insertPurchaseReceive( $data = array() , $merchant_id='')
	{
		$po_id='';
		if(is_array($data) && count($data)>=1){
			foreach ($data as $params) {				
				
				$po_id = $params['po_id'];
				$stock_balance = (float) $this->getStocksSKU($params['sku']);
				$stock_after = (float)$stock_balance + (float)$params['qty'] ;
				$track_stock = $params['track_stock'];
				
				$params_stocks = array(
				  'created_at'=>$this->functions->dateNow(),
				  'sku'=>$params['sku'],
				  'merchant_id'=>$merchant_id,
				  'transaction_type'=>"receive_items",
				  'transaction_id'=>$params['po_id'],
				  'transaction_code'=>$this->transactionCode('po'),
				  'adjustment'=>$params['qty'],
				  'stock_after'=>$stock_after,
				  'cost_price'=>$params['cost_price'],
				  'added_by'=>$_SESSION['username'],
				  'ip_address'=>$_SERVER['REMOTE_ADDR']
				);								
				unset($params['cost_price']);
				unset($params['track_stock']);
				if($this->functions->insertData("{{inventory_purchase_receive}}",$params)){
					if($track_stock==1){
					   $this->insertInventoryStocks($params_stocks);					
					}
				} else throw new Exception( "Failed cannot insert records" );
			}
			
			$this->updatePurchaseOrderStatus($po_id);
			
		} else throw new Exception( "Receive data is invalid" );	
	}
	
	public function getPurchaseBalance($po_id = '')
{
    if ($po_id <= 0) {
        throw new Exception("Invalid purchase number");
    }

    $balance = 0;

    $stmt = "
        SELECT 
            IFNULL(
                (SELECT SUM(qty) 
                 FROM mt_inventory_purchase_order_details 
                 WHERE po_id = :po_id), 0
            ) - 
            IFNULL(
                (SELECT SUM(qty) 
                 FROM mt_inventory_purchase_receive 
                 WHERE po_id = :po_id), 0
            ) AS balance
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':po_id', $po_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $result = $query->fetch(PDO::FETCH_ASSOC);
        if ($result && isset($result['balance'])) {
            $balance = $result['balance'];
        }
    }

    return $balance;
}

	
	public  function updatePurchaseOrderStatus($po_id='')
	{	
		$purchase_balance = $this->getPurchaseBalance( (integer) $po_id);
		
		$status = '';
		
		if($purchase_balance<=0){
			$status='closed';
		} else if ($purchase_balance>0) {
			$status='partially_received';
		}
		
		if (!empty($status)){
			$params = array('status'=>$status,'updated_at'=>$this->functions->dateNow());
			$this->functions->updateData(
            "mt_inventory_purchase_order",
            $params,
            'po_id',  // The column name
            $po_id    // The value for the WHERE condition
            );

		}
	}
	
public function getPurchaseOrder($po_id = '', $merchant_id = '')
{
    if ($po_id <= 0) {
        throw new Exception("Invalid purchase order ID");
    }
    if ($merchant_id <= 0) {
        throw new Exception("Invalid merchant ID");
    }

    $stmt = "
        SELECT *
        FROM mt_inventory_purchase_order
        WHERE merchant_id = :merchant_id AND po_id = :po_id
        LIMIT 1
    ";

    $query = $this->db->prepare($stmt);
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':po_id', $po_id, PDO::PARAM_INT);

    if ($query->execute()) {
        $resp = $query->fetch(PDO::FETCH_ASSOC);
        if ($resp) {
            return $resp;
        }
    }
    return false;
}

	
	public function getPurchaseOrderView($po_id = '', $merchant_id = '')
{
    if ($po_id <= 0) {
        throw new Exception("Invalid purchase order ID");
    }
    if ($merchant_id <= 0) {
        throw new Exception("Invalid merchant ID");
    }

    $stmt = "
        SELECT *
        FROM mt_view_inventory_purchase_order
        WHERE merchant_id = :merchant_id AND po_id = :po_id
        LIMIT 1
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':merchant_id', $merchant_id, PDO::PARAM_INT);
    $query->bindParam(':po_id', $po_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        // Fetch the result
        $resp = $query->fetch(PDO::FETCH_ASSOC);
        if ($resp) {
            return $resp;
        }
    }

    return false;
}

	
	public function getReceiveSum($po_id = '', $po_details_id = '')
{
    if ($po_id <= 0) {
        throw new Exception("Invalid purchase order ID");
    }
    if ($po_details_id <= 0) {
        throw new Exception("Invalid purchase order details ID");
    }

    $stmt = "
        SELECT SUM(qty) as total
        FROM mt_inventory_purchase_receive
        WHERE po_id = :po_id AND po_details_id = :po_details_id
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindParam(':po_id', $po_id, PDO::PARAM_INT);
    $query->bindParam(':po_details_id', $po_details_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return $res['total'] ?? 0; // Return total or 0 if no result
    }

    return 0;
}

	
	public function getReceiveByPO($po_id = '')
{
    if ($po_id <= 0) {
        throw new Exception("Invalid purchase order ID");
    }

    $stmt = "
        SELECT SUM(qty) as total
        FROM mt_inventory_purchase_receive
        WHERE po_id = :po_id
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind the parameter
    $query->bindParam(':po_id', $po_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        $res = $query->fetch(PDO::FETCH_ASSOC);
        return (float) ($res['total'] ?? 0); // Return total as float or 0 if no result
    }

    return 0.0;
}

	
	public function getSKUByPurchaseDetails($po_details_id = '')
{
    if ($po_details_id <= 0) {
        throw new Exception("Invalid purchase details ID");
    }

    $stmt = "
        SELECT sku
        FROM mt_inventory_purchase_order_details
        WHERE po_details_id = :po_details_id
        LIMIT 1
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind the parameter
    $query->bindParam(':po_details_id', $po_details_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        $resp = $query->fetch(PDO::FETCH_ASSOC);
        return $resp['sku'] ?? ''; // Return SKU or empty string if not found
    }

    return '';
}

	
	public function getSKUPurchaseDetails($po_details_id = '')
{
    if ($po_details_id <= 0) {
        throw new Exception("Invalid purchase details ID");
    }

    $stmt = "
        SELECT sku, cost_price
        FROM mt_inventory_purchase_order_details
        WHERE po_details_id = :po_details_id
        LIMIT 1
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind the parameter
    $query->bindParam(':po_details_id', $po_details_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        $resp = $query->fetch(PDO::FETCH_ASSOC);
        return $resp ?: false; // Return the result array or false if not found
    }

    return false;
}

	
	public function getSKUPurchaseDetails2($po_details_id = '')
{
    if ($po_details_id <= 0) {
        throw new Exception("Invalid purchase details ID");
    }

    $stmt = "
        SELECT a.sku, a.cost_price, b.track_stock
        FROM mt_inventory_purchase_order_details a
        LEFT JOIN mt_view_item b
        ON a.sku = b.sku
        WHERE po_details_id = :po_details_id
        LIMIT 1
    ";

    // Prepare the statement
    $query = $this->db->prepare($stmt);

    // Bind the parameter
    $query->bindParam(':po_details_id', $po_details_id, PDO::PARAM_INT);

    // Execute the query
    if ($query->execute()) {
        $resp = $query->fetch(PDO::FETCH_ASSOC);
        return $resp ?: false; // Return the result array or false if not found
    }

    return false;
}

	
	public function setDeletePurchaseOrder($po_id='', $merchant_id='', $params=array())
{
    if ($po_id > 0) {
        // Get the total received quantity for the purchase order
        $total = $this->getReceiveByPO($po_id);

        if ($total <= 0) {
            // Prepare the SQL statement for updating the purchase order
            $stmt = "UPDATE mt_inventory_purchase_order 
                     SET " . implode(", ", array_map(function($key) {
                         return "$key = :$key";
                     }, array_keys($params))) . " 
                     WHERE merchant_id = :merchant_id AND po_id = :po_id";

            // Prepare the query
            $query = $this->db->prepare($stmt);

            // Bind parameters
            foreach ($params as $column => $value) {
                $query->bindValue(":$column", $value);
            }
            $query->bindValue(':merchant_id', $merchant_id);
            $query->bindValue(':po_id', $po_id);

            // Execute the query
            if ($query->execute()) {
                return true;
            } else {
                throw new Exception("Failed, cannot update records");
            }

        } else {
            throw new Exception("Sorry, we cannot cancel this purchase order as it has already received an item");
        }

    } else {
        throw new Exception("Invalid purchase number");
    }
}

	
	public  function prettyPurchaseStatus($status='')
	{
		$pretty_status='';
		$status_list = $this->purchaseStatus();
		
		if(array_key_exists($status,(array)$status_list)){
		   $pretty_status = $status_list[$status];
	    } else $pretty_status = $status;				
		
		switch ($status) {
			case "closed":
			case "cancel":
				return "<span class=\"badge badge-light\">".$pretty_status."</span>";
				break;
		
			default:
				return "<div class=\"badge badge-light\">$pretty_status</div>";;
				break;
		}
	}
	
	public  function prettyTransactionStatus($status='')
	{
		$pretty_status='';
		$status_list = $this->adjustmentType();
		
		if(array_key_exists($status,(array)$status_list)){
		   $pretty_status = $status_list[$status];
	    } else $pretty_status = $status;				
		
		return $pretty_status;
	}
	
	public  function prettyTransactionStatusWithRef($status='', $reference='',$transaction_code='', $transaction_id='',$remarks='')
	{
		$pretty_status='';
		$status_list = $this->adjustmentType();
		
		if(array_key_exists($status,(array)$status_list)){
		   $pretty_status = $status_list[$status];
	    } else $pretty_status = $status;		
	    
	    if(!empty($remarks)){
	    	$pretty_status.= " (".$remarks.") ";
	    }
		
	    if(!empty($reference)){
	    	$link = $this->generateLink($transaction_code,$transaction_id);
	    	$pretty_status.=" <a href=\"$link\" class=\"text-primary\">#".$reference."</a>";
	    }
	    
		return $pretty_status;
	}
	
	public  function generateLink($transaction_code='',$transaction_id='')
	{		
		$link = 'javascript:;';
		switch ( strtolower($transaction_code) ) {
			case "sa":
				

                $link = Config::$baseUrl."/inventory/stocks/adjustment_details?id=".$transaction_id;

				break;
				
			case "po":

			    

                 $link = Config::$baseUrl."/inventory/stocks/purchase_view?id=".$transaction_id;

			    break;
			    
			case "or" :
				

                $link = Config::$baseUrl."/inventory/stocks/sales_receipt?id=".$transaction_id;

			    break;
		
			default:
				break;
		}
		return $link;
	}
	
	public  function updateStocksEditItem($sku='', $cost_price=0, $in_stock=0,$merchant_id='', $added_by='')
	{
		$params = array(); $after_stock = 0;
		$stocks = $this->getStocksSKU($sku);		
		
		if(!$sku_details = $this->ItemWrap->getItemBySku($merchant_id,$sku)){
			return ;
		}
		
		if($sku_details['track_stock']<=0){			
			return;
		}
				
		if($stocks!=$in_stock){
			
			$params = array(
			  'created_at'=>$this->functions->dateNow(),
			  'sku'=>$sku,
			  'merchant_id'=> (integer) $merchant_id,
			  'transaction_type'=>"item_edit",
			  'added_by'=>$added_by,
			  'ip_address'=>$_SERVER['REMOTE_ADDR'],
			  'cost_price'=>(float) $cost_price
			);
			
			if($in_stock>$stocks){								
				$after_stock = $in_stock;		
				$params['adjustment']= (float) $in_stock-$stocks;
				$params['stock_after']= (float) $after_stock;
			} else {
				$adjustment = $stocks-$in_stock;
				$after_stock = $stocks-$adjustment;
				$params['adjustment']= (float) -$adjustment;
				$params['stock_after']= (float) $after_stock;
			}			
			$i = $this->functions->insertData("mt_inventory_stocks",$params);
		}		
	}
	
	public function getEvaluation($merchant_id='')
{
    // Prepare the SQL query
    $stmt = "
        SELECT 
            SUM(inventory_value) as inventory_value,
            SUM(retail_value) as retail_value,
            SUM(potential_profit) as potential_profit
        FROM mt_view_inventory_evaluation
        WHERE merchant_id = :merchant_id
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameter
    $query->bindValue(':merchant_id', $merchant_id, PDO::PARAM_INT);

    // Execute the query
    $query->execute();

    // Fetch the result
    $resp = $query->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }
    
    return false;
}

	
	public function getOwner($merchant_id='')
{
    // Prepare the SQL query
    $stmt = "
        SELECT id, username
        FROM mt_user_master_list
        WHERE id = :id AND user_type = :user_type
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    $query->bindValue(':id', $merchant_id, PDO::PARAM_INT);
    $query->bindValue(':user_type', 'merchant', PDO::PARAM_STR);

    // Execute the query
    $query->execute();

    // Fetch the result
    $resp = $query->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    return false;
}

	
	public function getStocksItem($merchant_id=0, $item_id=0, $size_id=0)
{
    // Initialize the SQL query conditions
    $where = 'merchant_id = :merchant_id AND item_id = :item_id';
    $where_val = array(
        ':merchant_id' => (int) $merchant_id,
        ':item_id' => (int) $item_id
    );

    // Add condition for size_id if it's greater than 0
    if ($size_id > 0) {
        $where .= " AND size_id = :size_id";
        $where_val[':size_id'] = (int) $size_id;
    }

    // Prepare the SQL query
    $stmt = "
        SELECT low_stock, available, available_stocks, track_stock
        FROM mt_view_item_stocks
        WHERE $where
        LIMIT 1
    ";

    // Prepare the query
    $query = $this->db->prepare($stmt);

    // Bind the parameters
    foreach ($where_val as $param => $value) {
        $query->bindValue($param, $value, PDO::PARAM_INT);
    }

    // Execute the query
    $query->execute();

    // Fetch the result
    $resp = $query->fetch(PDO::FETCH_ASSOC);

    if ($resp) {
        return $resp;
    }

    // If no result, throw an exception
    throw new Exception("Stocks not found");
}

	
	public  function getAvailableStocks($merchant_id=0, $item_id=0, $size_id=0 )
	{
		try {
			$resp = $this->getStocksItem($merchant_id,$item_id,$size_id);
			
			if($resp['track_stock']<=0){
				return true;
			}
			
			if($resp['available']<=0){
				throw new Exception( "This item is not available for sale");
			}
			
			$low_stock = (float) $resp['low_stock'];
			$available_stocks = (float) $resp['available_stocks'];
			
			$stocks_message = '';
			$inventory_in_stock = (integer) $this->functions->getOptionAdmin('inventory_in_stock');
			$inventory_low_stock = (integer) $this->functions->getOptionAdmin('inventory_low_stock');
			$inventory_items_left = (integer) $this->functions->getOptionAdmin('inventory_items_left');
			
			$inventory_in_stock = $inventory_in_stock>0?$inventory_in_stock:11;
			$inventory_low_stock = $inventory_low_stock>0?$inventory_low_stock:10;
			$inventory_items_left = $inventory_items_left>0?$inventory_items_left:8;
									
			//dump($available_stocks); dump($inventory_in_stock);
			if($available_stocks<=0){
				$stocks_message = "Out of stock";
			} elseif ($available_stocks>=$inventory_in_stock){
				$stocks_message= "In stock";
			} elseif ( $available_stocks<=$inventory_low_stock  && $available_stocks>=$inventory_low_stock){
				$stocks_message= "Low stock";
			} elseif ( $available_stocks<=$inventory_items_left){
				$stocks_message = "only [qty] items left";
			} else {
				$stocks_message= "In stock";
			}
			
			

            $stocks_message = "inventory ".$stocks_message." qty ".$available_stocks;
			
			return array(
			  'available_stocks'=>$available_stocks,
			  'message'=>$stocks_message
			);
			
		} catch (Exception $e) {	       
	        throw new Exception($e->getMessage());
	    } 
	}
	
	public  function verifyStocks($totalqty=0,$merchant_id=0, $item_id=0, $with_size=0, $value='')
	{				
		if($this->InventoryWrapper->allowNegativeStock($merchant_id)){
			return true;
		}
		
		try {
			
			$size_id=0;			
			if($with_size==1){
			   $value = explode("|",$value);
			   if(is_array($value) && count($value)>=1){
			     $size_id = isset($value[2])?(integer)$value[2]:0;
		       }
			}
			
			$resp = $this->getStocksItem($merchant_id,$item_id,$size_id);
			if($resp['track_stock']<=0){
				return true;
			}
						
			if($resp['available']<=0){
				throw new Exception( "This item is not available for sale");
			}
						
			if($resp['available_stocks']<=0){
				throw new Exception( "Out of stock");
			} else {
				if ($totalqty>$resp['available_stocks']){
					throw new Exception( "The maximum quantity available for this item is [qty]. ".$resp['available_stocks']);
					
				}
			}
			
		} catch (Exception $e) {	       
	        throw new Exception($e->getMessage());
	    } 
	}
	
	public function verifyStocksReOrder($order_id = 0, $merchant_id = 0)
{
    // Check if negative stock is allowed
    if ($this->InventoryWrapper->allowNegativeStock((int)$merchant_id)) {
        return true;
    }

    // Prepare the SQL statement
    $stmt = "
        SELECT 
            a.order_id, 
            a.item_id,
            b.item_name,
            b.track_stock,
            a.size, 
            SUM(a.qty) as qty, 
            a.size_id
        FROM mt_order_details a
        LEFT JOIN mt_item b ON a.item_id = b.item_id
        WHERE a.order_id = :order_id
        GROUP BY a.item_id, a.size_id
    ";

    // Prepare and execute the query
    $query = $this->db->prepare($stmt);
    $query->bindValue(':order_id', (int)$order_id, PDO::PARAM_INT);
    $query->execute();

    // Fetch all results
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    // If results exist, process each row
    if ($res) {
        foreach ($res as $val) {

            if ($val['track_stock'] >= 1) {
                $totalqty = $val['qty'];

                // Get the stock details for the item and size
                $resp = $this->getStocksItem((int)$merchant_id, $val['item_id'], (int)$val['size_id']);

                // Check stock availability
                if ($resp['available'] <= 0) {
                    throw new Exception("Stock alert: {$val['item_name']} is not available for sale");
                }

                // Check if the item is out of stock
                if ($resp['available_stocks'] <= 0) {
                    throw new Exception("Stock alert: {$val['item_name']} is Out of stock");
                } else {
                    // Check if the order quantity exceeds available stock
                    if ($totalqty > $resp['available_stocks']) {
                        throw new Exception("Stock alert: The maximum quantity available for {$val['item_name']} is {$resp['available_stocks']}.");
                    }
                }
            }
        }

        return true;
    } else {
        throw new Exception("Order not found");
    }
}

	
}
/*end class*/