<?php
class AjaxreportsController extends Controller
{
	public $code=2;
	public $msg;
	public $details;
	public $data;	
	public $merchant_id;
	
	public function __construct()
	{
		$this->data=$_POST;	
		$this->functions = new Functions();
		$this->InventoryWrapper = new InventoryWrapper();
        //$this->ItemWrap = new ItemWrap();
        $this->ReportsWrapper = new ReportsWrapper();

        //$this->ItemHtmlWrapper = new ItemHtmlWrapper();
		
		$this->merchant_id =$_SESSION['inventory_merchant'];

		$model = Model::getInstance();
        
        $this->db = $model->getDb();
		
	}
	
	
	
	public function jsonResponse()
{
    $resp = array('code' => $this->code, 'msg' => $this->msg, 'details' => $this->details);
    echo json_encode($resp);
    exit();
}

	
	public function otableNodata()
	{
		if (isset($_POST['draw'])){
			$feed_data['draw']=$_POST['draw'];
		} else $feed_data['draw']=1;	   
		     
        $feed_data['recordsTotal']=0;
        $feed_data['recordsFiltered']=0;
        $feed_data['data']=array();		
        echo json_encode($feed_data);
    	die();
	}

	public function otableOutput($feed_data='')
	{
	  echo json_encode($feed_data);
	  die();
    }
    
	
	public function OKresponse()
	{
		$this->code = 1; $this->msg = "OK"; $this->details = array();
	}


  public function ItemStockAlert()
{
    try {
        $data = array();

        // Prepare the SQL query
      $stmt = "
    SELECT item_name, size_name, sku, available_stocks
    FROM mt_view_item_stocks_status
    WHERE merchant_id = :merchant_id
    
    ORDER BY available_stocks ASC
    LIMIT 10
";


        // Prepare the statement using PDO
        $query = $this->db->prepare($stmt);
        
        // Bind the merchant_id parameter
        $query->bindParam(':merchant_id', $this->merchant_id, PDO::PARAM_INT);
        
        // Execute the query
        $query->execute();
        
        // Fetch all results
        $res = $query->fetchAll(PDO::FETCH_ASSOC);



        foreach ($res as $key => $val) {
            // Assuming randomColors and prettyItemName are available methods
            $colors = $this->ReportsWrapper->randomColors($key);
            $data[] = array(
                'item_name' => $this->InventoryWrapper->prettyItemName($val['item_name'], $val['size_name'], $val['sku']),
                'value' => $this->InventoryWrapper->prettyQuantity($val['available_stocks']),
                'color' => $colors
            );
        }

        // OK response (if applicable)
        $this->OKresponse();

        // Prepare the response details
        $this->details = array(
            'next_action' => 'stock_alert',
            'data' => $data
        );
        
    } catch (Exception $e) {
        // Handle error and translate the message if necessary
        $this->msg = ($e->getMessage());
    }
    
    // Return JSON response
    $this->jsonResponse();
}


public function Saleslast30days()
{
    try {
        $days = $this->InventoryWrapper->reportsRange();
        $data = array();
        $datenow = date("Y-m-d");
        $range2 = date("Y-m-d");
        $range1 = date("Y-m-d", strtotime($datenow . "-$days day"));

        $and = '';

        $status = $this->ReportsWrapper->getDefaultStatus($this->merchant_id);
        if (is_array($status) && count($status) >= 1) {
            $in_status = '';
            foreach ($status as $stats_val) {
                $in_status .= ($stats_val) . ",";
            }
            $in_status = substr($in_status, 0, -1);
            //$and .= " AND status IN ($in_status)";
            $and .= "";

        }

        // SQL query with placeholders for parameters
        $stmt = "
            SELECT SQL_CALC_FOUND_ROWS
                a.merchant_id,
                a.sale_date,
                SUM(a.total_sale) AS gross_sale,
                SUM(a.discount) AS discount,
                (SUM(a.total_sale) - SUM(a.discount)) AS net_sale,
                SUM(a.total_cost) AS total_cost,
                (SUM(a.total_sale) - SUM(a.discount)) - SUM(a.total_cost) AS gross_profit
            FROM mt_view_inventory_order_details a
            WHERE 1 
            AND a.merchant_id = :merchant_id
            AND sale_date BETWEEN :range1 AND :range2
            $and
            GROUP BY a.sale_date, a.merchant_id
        ";

        // Prepare the statement
        $query = $this->db->prepare($stmt);

        // Bind the parameters
        $query->bindParam(':merchant_id', $this->merchant_id, PDO::PARAM_INT);
        $query->bindParam(':range1', $range1, PDO::PARAM_STR);
        $query->bindParam(':range2', $range2, PDO::PARAM_STR);

        // Execute the query
        $query->execute();

        // Fetch all results
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        foreach ($res as $key => $val) {
            $data[] = array(
                'sale_date' => $this->InventoryWrapper->prettyDate($val['sale_date'], "[M] d"),
                'net_sale' => $this->functions->prettyPrice($val['net_sale'])
            );
        }

        // Prepare the response
        $this->OKresponse();
        $this->details = array(
            'next_action' => 'sales_last30',
            'data' => $data
        );

    } catch (Exception $e) {
        // Handle exception
        $this->msg = ($e->getMessage());
    }
    
    // Return JSON response
    $this->jsonResponse();
}








public function sales_summary_chart()
{				
	$chart_type = isset($this->data['chart_type'])?$this->data['chart_type']:'';
	
	$range1 = isset($this->data['range1'])?$this->data['range1']:'';
	$range2 = isset($this->data['range2'])?$this->data['range2']:'';
	
	$date = array(); $data = array(); $series = array(); $summary=array();
					
	try {
	    $date = $this->ReportsWrapper->generateDateRange($range1,$range2);
	} catch (Exception $e) {
	    $this->msg = ($e->getMessage());
	    $this->jsonResponse();
	}		
						
	$and = "AND a.merchant_id = :merchant_id ";
	$params = [':merchant_id' => $this->merchant_id];
	
	if( $this->InventoryWrapper->validDate($range1) && $this->InventoryWrapper->validDate($range2)){
		$and .= "AND sale_date BETWEEN :range1 AND :range2 ";
		$params[':range1'] = $range1;
		$params[':range2'] = $range2;
	}

	if(isset($this->data['status'])){
		if(!in_array('all',(array)$this->data['status'])){		
			$in_status = implode(",", array_map('intval', $this->data['status']));
			$and .= " AND status IN ($in_status)";
		}
	}
	
	$series_stmt = ''; $chart_title='';
	switch ($chart_type) {
		case "discount":			
		    $series_stmt="sum(a.discount) as value";	
		    $chart_title= "Discount";
			break;
			
	    case "net_sales":		
	        $series_stmt="(sum(a.total_sale)-sum(a.discount)) as value";
	        $chart_title= "Net sales";
			break;
			
		case "gross_profit":			
		   $series_stmt="(sum(a.total_sale)-sum(a.discount)) -  sum(a.total_cost) as value";
		   $chart_title= "Gross profit";
			break;	
			
		default:
			$series_stmt="sum(a.total_sale) as value";
			$chart_title= "Gross sales";
			break;
	}

	$stmt="
	select
	DATE_FORMAT(a.sale_date,'%b %d') as date,		
	$series_stmt
	from mt_view_inventory_order_details a
	WHERE 1		
	$and
	group by a.sale_date
	";		

	$query = $this->db->prepare($stmt);
	$query->execute($params);

	if($res = $query->fetchAll(PDO::FETCH_ASSOC)){			
		foreach ($res as $val) {
			$data[$val['date']] = $val['value'];
		}
	}		
			
	if(is_array($date) && count($date)>=1){
		foreach ($date as $date_val) {				
			if(array_key_exists($date_val,$data)){
				$series[] = (float) $this->functions->normalPrettyPrice($data[$date_val]) ;
			} else $series[] = 0;
		}				
		
		$stmt="
		select
		sum(a.total_sale) as gross_sale,
		sum(a.discount) as discount,
		(sum(a.total_sale)-sum(a.discount)) as net_sales,		    
	    (sum(a.total_sale)-sum(a.discount)) -  sum(a.total_cost) as gross_profit
		from mt_view_inventory_order_details a
		WHERE 1		
	    $and
		";			

		$query = $this->db->prepare($stmt);
		$query->execute($params);

		if($resp = $query->fetch(PDO::FETCH_ASSOC)){
		    foreach ($resp as $resp_key=>$resp_val) {
		    	$summary[$resp_key]=$this->functions->prettyPrice($resp_val);
		    }
		}			
				
		$this->code = 1;
		$this->msg = "ok";
		$this->details = array(
		  'next_action'=>'sales_summary_chart',
		  'categories'=>$date,
		  'series'=>$series,
		  'chart_title'=>$chart_title,
		  'summary'=>(array)$summary
		);					
	} else $this->msg = "invalid date";		
	$this->jsonResponse();
}


public function Sales_summary()
{
    $feed_data = array();

    $cols = array('sale_date', 'gross_sale', 'discount', 'net_sale', 'total_cost', 'gross_profit');
    $resp = $this->ReportsWrapper->format($cols, $this->data);    
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = "AND a.merchant_id = :merchant_id ";
    $params = [':merchant_id' => $this->merchant_id];

    $range1 = isset($this->data['range1']) ? $this->data['range1'] : '';
    $range2 = isset($this->data['range2']) ? $this->data['range2'] : '';    
    if ($this->InventoryWrapper->validDate($range1) && $this->InventoryWrapper->validDate($range2)) {
        $and .= "AND sale_date BETWEEN :range1 AND :range2 ";
        $params[':range1'] = $range1;
        $params[':range2'] = $range2;
    }

    if (isset($this->data['status'])) {
        if (!in_array('all', (array)$this->data['status'])) {
            $in_status = implode(',', array_map(function($item) {
                return (int)$item;
            }, $this->data['status']));
            $and .= " AND status IN ($in_status)";
        }
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS
        a.merchant_id,
        a.sale_date,
        SUM(a.total_sale) as gross_sale,
        SUM(a.discount) as discount,
        (SUM(a.total_sale) - SUM(a.discount)) as net_sale,
        SUM(a.total_cost) as total_cost,
        (SUM(a.total_sale) - SUM(a.discount)) - SUM(a.total_cost) as gross_profit
    FROM mt_view_inventory_order_details a
    WHERE 1
    $and
    $where
    GROUP BY a.sale_date, a.merchant_id
    $order
    $limit
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute($params);
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            // Get total records
            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $queryc = $this->db->prepare($stmtc);
            $queryc->execute();
            $resc = $queryc->fetch(PDO::FETCH_ASSOC);
            $total_records = $resc['total_records'];

            $feed_data['draw'] = $this->data['draw'];
            $feed_data['recordsTotal'] = $total_records;
            $feed_data['recordsFiltered'] = $total_records;

            $datas = array();
            foreach ($res as $val) {
                $cols_data = array();
                foreach ($cols as $key_cols => $cols_val) {
                    switch ($key_cols) {
                        case 0:
                            $cols_data[$cols_val] = $this->InventoryWrapper->prettyDate($val[$cols_val], "M d");
                            break;
                        default:
                            $cols_data[$cols_val] = $this->functions->prettyPrice($val[$cols_val]);
                            break;
                    }
                }
                $datas[] = $cols_data;
            }
            $feed_data['data'] = $datas;
            $this->otableOutput($feed_data);
        } else {
            $this->otableNodata();
        }
    } catch (PDOException $e) {
        $this->msg = "Database error: " . $e->getMessage();
        $this->otableNodata();
    }
}



public function Sales_payment_type()
{
    $feed_data = array();

    $cols = array('payment_type', 'payment_transaction', 'net_amount');
    $resp = $this->ReportsWrapper->format($cols, $this->data);
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = "AND a.merchant_id = :merchant_id ";
    $params = [':merchant_id' => $this->merchant_id];

    $range1 = isset($this->data['range1']) ? $this->data['range1'] : '';
    $range2 = isset($this->data['range2']) ? $this->data['range2'] : '';
    if ($this->InventoryWrapper->validDate($range1) && $this->InventoryWrapper->validDate($range2)) {
        $and .= "AND DATE_FORMAT(a.date_created, '%Y-%m-%d') BETWEEN :range1 AND :range2 ";
        $params[':range1'] = $range1;
        $params[':range2'] = $range2;
    }

    if (isset($this->data['status'])) {
        if (!in_array('all', (array)$this->data['status'])) {
            $in_status = implode(',', array_map('intval', $this->data['status']));
            $and .= " AND status IN ($in_status)";
        }
    }

    $stmt = "
        SELECT
        SQL_CALC_FOUND_ROWS
        a.payment_type,
        COUNT(*) as payment_transaction,
        SUM(a.total_w_tax) as net_amount
        FROM mt_order a
        WHERE 1
        $and
        $where
        GROUP BY a.payment_type
        $order
        $limit
    ";

    try {
        $query = $this->db->prepare($stmt);
        $query->execute($params);

        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            $total_records = 0;

            $stmtc = "SELECT FOUND_ROWS() as total_records";
            $queryc = $this->db->prepare($stmtc);
            $queryc->execute();
            $resc = $queryc->fetch(PDO::FETCH_ASSOC);

            if ($resc) {
                $total_records = $resc['total_records'];
            }

            $feed_data['draw'] = $this->data['draw'];
            $feed_data['recordsTotal'] = $total_records;
            $feed_data['recordsFiltered'] = $total_records;

            $datas = array();
            foreach ($res as $val) {
                $cols_data = array();
                foreach ($cols as $key_cols => $cols_val) {
                    switch ($key_cols) {
                        case 0:
                            $cols_data[$cols_val] = $val[$cols_val];
                            break;
                        case 1:
                            $cols_data[$cols_val] = $this->InventoryWrapper->prettyQuantity($val[$cols_val]);
                            break;
                        default:
                            $cols_data[$cols_val] = $this->functions->prettyPrice($val[$cols_val]);
                            break;
                    }
                }
                $datas[] = $cols_data;
            }
            $feed_data['data'] = $datas;
            $this->otableOutput($feed_data);
        } else {
            $this->otableNodata();
        }
    } catch (Exception $e) {
        // Handle exception, optionally log errors
        echo "Error: " . $e->getMessage();
    }
}





public function TopItems()
{
    $top_5 = array();
    $and = "AND a.merchant_id = :merchant_id ";
    
    $range1 = isset($this->data['range1']) ? $this->data['range1'] : '';
    $range2 = isset($this->data['range2']) ? $this->data['range2'] : '';

    if ($this->InventoryWrapper->validDate($range1) && $this->InventoryWrapper->validDate($range2)) {
        $and .= "AND sale_date BETWEEN :range1 AND :range2 ";
    }

    if (isset($this->data['status'])) {
        if (!in_array('all', (array) $this->data['status'])) {
            $status_placeholders = [];
            foreach ($this->data['status'] as $index => $stats_val) {
                $status_placeholders[] = ":status_$index";
            }
            $and .= " AND status IN (" . implode(', ', $status_placeholders) . ")";
        }
    }

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS
        a.sku,
        a.item_name,
        a.size_name,
        a.discount,
        a.category_name AS categories_name,                
        SUM(a.total_sale) - SUM(a.discount) AS net_sale        
    FROM mt_view_inventory_order_details a                        
    WHERE 1        
    $and        
    GROUP BY a.sku
    ORDER BY SUM(a.total_sale) - SUM(a.discount) DESC
    LIMIT 0, 5";

    try {
        $query = $this->db->prepare($stmt);

        // Bind named parameters
        $query->bindParam(':merchant_id', $this->merchant_id, PDO::PARAM_INT);

        if ($this->InventoryWrapper->validDate($range1) && $this->InventoryWrapper->validDate($range2)) {
            $query->bindParam(':range1', $range1);
            $query->bindParam(':range2', $range2);
        }

        // Bind dynamic status parameters
        if (isset($this->data['status']) && !in_array('all', (array) $this->data['status'])) {
            foreach ($this->data['status'] as $index => $stats_val) {
                $query->bindValue(":status_$index", $stats_val, PDO::PARAM_STR);
            }
        }

        $query->execute();
        $res = $query->fetchAll(PDO::FETCH_ASSOC);

        if ($res) {
            foreach ($res as $key => $val) {
                $colors = $this->ReportsWrapper->randomColors($key);
                $top_5[] = array(
                    'color' => $colors,
                    'item_name' => $this->InventoryWrapper->prettyItemName(
                        $val['item_name'],
                        $val['size_name'],
                        $val['sku']
                    ),
                    'value' => $this->functions->normalPrettyPrice($val['net_sale'])
                );
            }
            $this->code=1;
        	$this->msg="OK";
            $this->details = array(
                'next_action' => 'show_top_items',
                'data' => $top_5,
            );
        } else {
        	$this->code=1;
        	$this->msg="OK";
            $this->details = array(
                'next_action' => 'clear_top_items'
            );
        }

        $this->jsonResponse();
    } catch (PDOException $e) {
        error_log($e->getMessage());
        $this->details = array(
            'next_action' => 'clear_top_items',
            'error' => $e->getMessage()
        );
        $this->jsonResponse();
    }
}



public function Chart_sales_item()
{
    $chart_title = "Sales by item";
    
    $range1 = isset($this->data['range1']) ? $this->data['range1'] : '';
    $range2 = isset($this->data['range2']) ? $this->data['range2'] : '';
    $chart_type = isset($this->data['chart_type']) ? $this->data['chart_type'] : '';
    
    $date = array();
    $data = array();
    $series = array();
    $summary = array();
    
    try {
        $date = $this->ReportsWrapper->generateDateRange($range1, $range2, false);
    } catch (Exception $e) {
        $this->msg = $e->getMessage();
        $this->jsonResponse();
    }

    $and = "AND a.merchant_id = " . ($this->merchant_id) . " ";
    if ($this->InventoryWrapper->validDate($range1) && $this->InventoryWrapper->validDate($range2)) {
        $and .= "AND sale_date BETWEEN :range1 AND :range2 ";
    }

    $and_status = '';
    if (isset($this->data['status'])) {
    if (!in_array('all', (array) $this->data['status'])) {
        // Make sure the status values are properly quoted
        $in_status = "'" . implode("', '", $this->data['status']) . "'";
        $and .= " AND status IN ($in_status)";
        $and_status .= " AND status IN ($in_status)";
    }
}

    
    if ($chart_type == "pie") {

        $stmt = "
            SELECT
                a.sku,
                a.item_name,
                a.size_name,
                DATE_FORMAT(a.sale_date, '%b %d') as date,
                SUM(a.total_sale) - SUM(a.discount) as value
            FROM mt_view_inventory_order_details a
            WHERE 1
            $and
            GROUP BY a.sku
            ORDER BY SUM(a.total_sale) - SUM(a.discount) DESC
        ";

        $command = $this->db->prepare($stmt);
        if ($range1 && $range2) {
            $command->bindParam(':range1', $range1);
            $command->bindParam(':range2', $range2);
        }
        $command->execute();
        $res = $command->fetchAll(PDO::FETCH_ASSOC);

        foreach ($res as $key => $val) {
            $colors = $this->ReportsWrapper->randomColors($key);
            
            $item_name = $val['item_name'];
            if (!empty($val['size_name'])) {
                $item_name = $val['item_name'] . " (" . $val['size_name'] . ")";
            }
            
            $series[] = array(
                'name' => $item_name,
                'y' => (float) $this->functions->normalPrettyPrice($val['value']),
                'color' => $colors
            );
        }
    } else {

        $stmt = "
            SELECT
                a.sku,
                a.item_name,
                a.size_name
            FROM mt_view_inventory_order_details a
            WHERE 1
            $and
            GROUP BY a.sku
            ORDER BY SUM(a.total_sale) - SUM(a.discount) DESC
        ";

        $command = $this->db->prepare($stmt);
        if ($range1 && $range2) {
            $command->bindParam(':range1', $range1);
            $command->bindParam(':range2', $range2);
        }
        $command->execute();
        $res = $command->fetchAll(PDO::FETCH_ASSOC);

        $empty_res_chk=$res;
        //print_r($empty_res_chk);die();
        

        foreach ($res as $key => $val) {
        	
            $colors = $this->ReportsWrapper->randomColors($key);

           
            
            
            $stmt_data = "
                SELECT
                    a.sku,
                    a.item_name,
                    a.size_name,
                    DATE_FORMAT(a.sale_date, '%b %d') as date,
                    SUM(a.total_sale) - SUM(a.discount) as value
                FROM mt_view_inventory_order_details a
                WHERE 1
                AND a.sku = :sku
                $and
                GROUP BY a.sale_date
                ORDER BY a.sale_date ASC
            ";

            $command_data = $this->db->prepare($stmt_data);
            $command_data->bindParam(':sku', $val['sku']);
            if ($range1 && $range2) {
                $command_data->bindParam(':range1', $range1);
                $command_data->bindParam(':range2', $range2);
            }
            $command_data->execute();
            $resp = $command_data->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($date as $date_val) {
                $key = array_search($date_val, array_column((array) $resp, 'date'));
                if (is_numeric($key)) {
                    $data[] = (float) $this->functions->normalPrettyPrice($resp[$key]['value']);
                } else {
                    $data[] = 0;
                }
            }

            $item_name = $val['item_name'];
            if (!empty($val['size_name'])) {
                $item_name = $val['item_name'] . " (" . $val['size_name'] . ")";
            }


            $series[$item_name] = array(
                'color' => $colors,
                'data' => $data
            );




            $data = array();
        }

    }
     

     if (empty($series)) {
     	foreach ($date as $date_val) {
					$data[]=0;
				}					
				$series['']=array(
				  'color'=>'#78909C', 
				  'data'=>$data
				);
     }



    $this->code = 1;
    $this->msg = "ok";
    $this->details = array(
        'next_action' => 'chart_sales_item',
        'categories' => $date,
        'series' => $series,
        'chart_title' => $chart_title,
    );

    $this->jsonResponse();
}




public function Sales_item()
{
    $feed_data = [];
    $cols = ['item_name', 'categories_name', 'item_sold', 'discount', 'net_sale', 'total_cost', 'gross_profit'];

    $resp = $this->ReportsWrapper->format($cols, $this->data);    
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = "AND a.merchant_id = :merchant_id ";
    $params = ['merchant_id' => $this->merchant_id];

    $range1 = isset($this->data['range1']) ? $this->data['range1'] : '';
    $range2 = isset($this->data['range2']) ? $this->data['range2'] : '';
    if ($this->InventoryWrapper->validDate($range1) && $this->InventoryWrapper->validDate($range2)) {
        $and .= "AND sale_date BETWEEN :range1 AND :range2 ";
        $params['range1'] = $range1;
        $params['range2'] = $range2;
    }

    if (isset($this->data['status'])) {
        if (!in_array('all', (array) $this->data['status'])) {
            $in_status = implode(',', array_map(function ($status) {
                return "'" . addslashes($status) . "'";
            }, $this->data['status']));
            $and .= "AND status IN ($in_status)";
        }
    }

    $order = "ORDER BY item_name ASC";

    $stmt = "
    SELECT SQL_CALC_FOUND_ROWS
        a.sku,
        a.item_name,
        a.size_name,
        a.discount,
        a.category_name AS categories_name,
        SUM(a.qty) AS item_sold,
        SUM(a.total_sale) - SUM(a.discount) AS net_sale,
        SUM(a.total_cost) AS total_cost,
        (SUM(a.total_sale) - SUM(a.discount)) - SUM(a.total_cost) AS gross_profit
    FROM mt_view_inventory_order_details a
    WHERE 1
    $and
    $where
    GROUP BY a.sku
    $order
    $limit";

    $query = $this->db->prepare($stmt);
    $query->execute($params);

    $res = $query->fetchAll(PDO::FETCH_ASSOC);
    if ($res) {
        // Get total records
        $stmtc = "SELECT FOUND_ROWS() AS total_records";
        $queryc = $this->db->query($stmtc);
        $resc = $queryc->fetch(PDO::FETCH_ASSOC);

        $total_records = $resc['total_records'] ?? 0;
        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        $datas = [];
        foreach ($res as $val) {
            $cols_data = [];
            foreach ($cols as $key_cols => $cols_val) {
                switch ($key_cols) {
                    case 0:
                        $cols_data[$cols_val] = $this->InventoryWrapper->prettyItemName($val[$cols_val], $val['size_name'], $val['sku']);
                        break;
                    case 1:
                        $cols_data[$cols_val] = $val[$cols_val];
                        break;
                    case 2:
                        $cols_data[$cols_val] = $this->InventoryWrapper->prettyQuantity($val[$cols_val]);
                        break;
                    default:
                        $cols_data[$cols_val] = $this->functions->prettyPrice($val[$cols_val]);
                        break;
                }
            }
            $datas[] = $cols_data;
        }

        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}



 public function Sales_receipt()
{
    $feed_data = array();
    $cols = array('order_id', 'date_created', 'trans_type', 'customer_name', 'payment_type', 'request_from', 'status', 'total_w_tax');

    $resp = $this->ReportsWrapper->format($cols, $this->data);
    $where = $resp['where'];
    $order = $resp['order'];
    $limit = $resp['limit'];

    $and = "AND a.merchant_id = :merchant_id ";
    $params = [':merchant_id' => $this->merchant_id];

    $range1 = isset($this->data['range1']) ? $this->data['range1'] : '';
    $range2 = isset($this->data['range2']) ? $this->data['range2'] : '';
    if ($this->InventoryWrapper->validDate($range1) && $this->InventoryWrapper->validDate($range2)) {
        $and .= "AND DATE_FORMAT(a.date_created, '%Y-%m-%d') BETWEEN :range1 AND :range2 ";
        $params[':range1'] = $range1;
        $params[':range2'] = $range2;
    }

    if (isset($this->data['status'])) {
        if (!in_array('all', (array)$this->data['status'])) {
            $in_status = implode(',', array_map('intval', $this->data['status']));
            $and .= "AND a.status IN ($in_status) ";
        }
    }

    $search_field = isset($this->data['search_field']) ? $this->data['search_field'] : '';
    if (!empty($search_field)) {
        $and .= "AND order_id = :search_field ";
        $params[':search_field'] = $search_field;
    }

    $stmt = "
    SELECT 
        SQL_CALC_FOUND_ROWS
        a.order_id,
        a.date_created,
        a.trans_type,
        CONCAT(b.first_name, ' ', b.last_name) AS customer_name,
        a.payment_type,
        a.request_from,
        a.status,
        a.total_w_tax
    FROM mt_order a
    LEFT JOIN mt_client b ON a.client_id = b.client_id
    WHERE 1
    $and
    $where
    $order
    $limit
    ";

    $query = $this->db->prepare($stmt);
    $query->execute($params);
    $res = $query->fetchAll(PDO::FETCH_ASSOC);

    if ($res) {
        $total_records = 0;
        $stmtc = "SELECT FOUND_ROWS() as total_records";
        $queryc = $this->db->prepare($stmtc);
        $queryc->execute();
        $resc = $queryc->fetch(PDO::FETCH_ASSOC);
        $total_records = $resc['total_records'];

        $feed_data['draw'] = $this->data['draw'];
        $feed_data['recordsTotal'] = $total_records;
        $feed_data['recordsFiltered'] = $total_records;

        $datas = [];
        foreach ($res as $val) {
            $cols_data = array();
            $cols_data["DT_RowId"] = $val['order_id'];
            foreach ($cols as $key_cols => $cols_val) {
                switch ($key_cols) {
                    case 1:
                        $cols_data[$cols_val] = $this->functions->prettyDate($val[$cols_val]) . " " . $this->functions->prettyTime($val[$cols_val]);
                        break;

                    case 4:
                    case 5:
                    case 6:
                        $cols_data[$cols_val] = '<div class="badge badge-light">' . ($val[$cols_val]) . '</div>';
                        break;

                    case 7:
                        $cols_data[$cols_val] = $this->functions->prettyPrice($val[$cols_val]);
                        break;

                    default:
                        $cols_data[$cols_val] = $val[$cols_val];
                        break;
                }
            }
            $datas[] = $cols_data;
        }
        $feed_data['data'] = $datas;
        $this->otableOutput($feed_data);
    } else {
        $this->otableNodata();
    }
}


public function Receipt()
{
    $order_id = (integer) isset($_POST['order_id']) ? $_POST['order_id'] : '';
    if ($order_id > 0) {
        try {
            $resp = $this->InventoryWrapper->prepareReceipt($order_id);

            ob_start(); // Start capturing HTML output
            $data = $resp; // Match the view expectation

            // ---- Begin "View" code below ----
?>
<div class="row pt-2">
  <div class="col-md-6">
     <h2>#<?php echo $data['data']['order_id']?></h2>
     <h6><?php echo ("Order id")?></h6>
  </div>
  <div class="col-md-6">
    <h2><?php echo $this->functions->prettyPrice($data['data']['total_w_tax'])?></h2>
     <h6><?php echo ("Total")?></h6>
  </div>
</div>
<hr/>

<?php if(is_array($data['print']) && count($data['print'])>=1):?>
<table class="table table-borderless">
<?php foreach ($data['print'] as $val):?>
<tr>
 <td><?php echo ($val['label'])?> : <?php echo $val['value']?></td>
</tr>
<?php endforeach;?>
</table>
<?php endif;?>

<hr/>

<?php if(is_array($data['raw']['item']) && count($data['raw']['item'])>=1):?>
<table class="table table-borderless">
<?php foreach ($data['raw']['item'] as $item):
   $price = $item['normal_price']; $qty = $item['qty']; $addon_total=0;
   if($item['discount']>0){
      $price = $item['discounted_price']; 
   }
   $item_total = (integer)$qty* (float) $price;   
?>
<tr>
 <td>
   <b><?php echo $item['category_name']?></b><br/>
   <?php 
   if(!empty($item['size_words'])){
       echo $item['item_name']." ".$item['size_words'];
   } else echo $item['item_name'];
   ?>
   <p class="text-muted"><?php echo $qty?> x <?php echo $this->functions->prettyPrice($price)?></p>
   
   <?php if(!empty($item['cooking_ref'])):?>
   <p class="text-secondary no_margin"><?php echo $item['cooking_ref']?></p>
   <?php endif;?>
   <?php if(!empty($item['order_notes'])):?>
   <p class="text-info no_margin"><?php echo $item['order_notes']?></p>
   <?php endif;?>
   
   <?php if(is_array($item['ingredients']) && count( (array) $item['ingredients'])>=1 ):?>
   <p class="text-success no_margin pt-1"><?php echo ("Ingredients")?>:</p>
   <?php foreach ($item['ingredients'] as $ingredients):?>
     <p class="text-secondary no_margin"><?php echo $ingredients?></p>
   <?php endforeach;?>
   <?php endif;?>
   
   <?php if(isset($item['sub_item'])):?>
     <?php foreach ($item['sub_item'] as $sub_item):?>
       <br>+<?php echo $sub_item['addon_name']?> (<?php echo $sub_item['addon_qty']?>x<?php echo $this->functions->prettyPrice($sub_item['addon_price'])?>)
       <?php $addon_total+= $sub_item['addon_qty']*$sub_item['addon_price'];?>
     <?php endforeach;?>
   <?php endif;?>
 </td>
 <td class="col-qty"><?php echo $this->functions->prettyPrice($item_total+$addon_total)?></td>
</tr>
<?php endforeach;?>
</table>
<?php endif;?>

<hr/>

<?php $total = $data['raw']['total']; ?>
<table class="table table-borderless">

<?php if($total['less_voucher']>0):?>
<tr>
 <td><?php echo ("Less Voucher")?></td>
 <td class="col-qty">(<?php echo $this->functions->prettyPrice($total['less_voucher'])?>)</td>
</tr>
<?php endif;?>

<?php if($total['pts_redeem_amt']>0):?>
<tr>
 <td><?php echo ("Points Discount")?></td>
 <td class="col-qty">(<?php echo $this->functions->prettyPrice($total['pts_redeem_amt'])?>)</td>
</tr>
<?php endif;?>

<?php if($total['subtotal']>0):?>
<tr>
 <td><b><?php echo ("Sub Total")?></b></td>
 <td class="col-qty"><b><?php echo $this->functions->prettyPrice($total['subtotal'])?></b></td>
</tr>
<?php endif;?>

<?php if($total['delivery_charges']>0):?>
<tr>
 <td><?php echo ("Delivery Fee")?></td>
 <td class="col-qty"><?php echo $this->functions->prettyPrice($total['delivery_charges'])?></td>
</tr>
<?php endif;?>

<?php if($total['merchant_packaging_charge']>0):?>
<tr>
 <td><?php echo ("Packaging")?></td>
 <td class="col-qty"><?php echo $this->functions->prettyPrice($total['merchant_packaging_charge'])?></td>
</tr>
<?php endif;?>

<?php if($total['taxable_total']>0):?>
<tr>
 

 <td><?php echo "Tax " . $this->functions->normalPrettyPrice($total['tax'] * 100) . "%" ?></td>


 <td class="col-qty"><?php echo $this->functions->prettyPrice($total['taxable_total'])?></td>
</tr>
<?php endif;?>

<?php if($total['taxable_total']>0):?>
<tr>
 <td><?php echo "Tips ".$total['tips_percent']?></td>
 <td class="col-qty"><?php echo $this->functions->prettyPrice($total['tips'])?></td>
</tr>
<?php endif;?>

<?php if($total['total']>0):?>
<tr>
 <td><b><?php echo ("Total")?></b></td>
 <td class="col-qty"><b><?php echo $this->functions->prettyPrice($total['total'])?></b></td>
</tr>
<?php endif;?>

</table>
<?php
            // ---- End "View" code ----

            $html = ob_get_clean(); // Get the captured HTML and clean buffer

            $this->OKresponse();
            $this->details = array(
              'html' => $html,
              'next_action' => 'show_receipt'
            );

        } catch (Exception $e) {
            $this->msg = ($e->getMessage());
        }
    } else {
        $this->msg = ("Invalid order id");
    }
    $this->jsonResponse();
}











	
	
	
	
	



  













	
	
	
}
/*end class*/