<?php




class UpdateController extends Controller {


    protected $functions;
    

    public function __construct() {
       
        $this->functions = new Functions();
        $used_currency = $this->functions->getCurrencyCode();
        $this->functions->initPriceFormatter($used_currency);

        $website_timezone=$this->functions->getOptionAdmin("website_timezone");  
         //echo $website_timezone;die();
    //if (!empty($website_timezone)){     
      date_default_timezone_set($website_timezone);

      $model = Model::getInstance();
        //$this->db = $model->db;
        $this->db = $model->getDb(); 
    //}

    require_once(__DIR__ . '/../../vendor/smtp/src/PHPMailer.php');
    require_once(__DIR__ . '/../../vendor/smtp/src/SMTP.php');
    require_once(__DIR__ . '/../../vendor/smtp/src/Exception.php');
   
	
	if (!$this->functions->isAdminLogin() && $_REQUEST['url']!='admin/login'){           
       //print_r($_REQUEST);
        //$this->login();
		$bases=Config::$baseUrl;
		header("Location: ".$bases."/admin/login");
exit();
		
        }


       


   //echo date('Y-m-d H:i:s');die();

    }

    public function index() {

        $prefix="mt_";  
        $table_prefix=$prefix; $loger=array();
        // Default date for MySQL version check
$date_default = "datetime NOT NULL DEFAULT CURRENT_TIMESTAMP";

// Check MySQL version


// Create languages table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "languages (
  `lang_id` int(14) NOT NULL AUTO_INCREMENT,
  `country_code` varchar(14) NOT NULL DEFAULT '',
  `language_code` varchar(10) NOT NULL DEFAULT '',
  `source_text` text,
  `is_assign` int(1) NOT NULL DEFAULT '2',
  `date_created` $date_default,
  `last_updated` $date_default,
  `status` varchar(50) NOT NULL DEFAULT '',
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`lang_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table languages..<br/>";
if (!$this->functions->isTableExist("languages")) {
    if ($this->db->exec($stmt) !== false) {
        echo "(Done)<br/>";
    } else {
        echo "(Failed)<br/>";
    }
} else {
    echo "Table languages already exist.<br/>";
}

echo "<br/>";

// Create stripe_logs table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "stripe_logs (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `order_id` int(14) NOT NULL DEFAULT '0',
  `json_result` text CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
";

echo "Creating Table stripe_logs..<br/>";
if (!$this->functions->isTableExist("stripe_logs")) {
    if ($this->db->exec($stmt) !== false) {
        echo "(Done)<br/>";
    } else {
        echo "(Failed)<br/>";
    }
} else {
    echo "Table stripe_logs already exist.<br/>";
}

echo "<br/>Updating Table admin_user.<br/>";
$new_field = [
    'user_lang' => "int(14) NOT NULL DEFAULT '0'",
    'email_address' => "varchar(255) NOT NULL",
    'lost_password_code' => "varchar(255) NOT NULL"
];

$this->alterTable('admin_user', $new_field);
echo "<br/>";


// Create sms_broadcast table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "sms_broadcast (
  `broadcast_id` int(14) NOT NULL AUTO_INCREMENT,
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `send_to` int(14) NOT NULL DEFAULT '0',
  `list_mobile_number` text CHARACTER SET utf8 NOT NULL,
  `sms_alert_message` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) CHARACTER SET utf8 NOT NULL DEFAULT 'pending',
  `date_created` $date_default,
  `date_modified` $date_default,
  `ip_address` varchar(50) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`broadcast_id`)
) ENGINE=InnoDB DEFAULT CHARSET=ucs2 AUTO_INCREMENT=1;
";

echo "Creating Table sms_broadcast..<br/>";
if (!$this->functions->isTableExist("sms_broadcast")) {
    if ($this->db->exec($stmt) !== false) {
        echo "(Done)<br/>";
    } else {
        echo "(Failed)<br/>";
    }
} else {
    echo "Table sms_broadcast already exists.<br/>";
}

// Create sms_broadcast_details table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "sms_broadcast_details (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `broadcast_id` int(14) NOT NULL DEFAULT '0',
  `client_id` int(14) NOT NULL DEFAULT '0',
  `client_name` varchar(255) NOT NULL DEFAULT '',
  `contact_phone` varchar(50) NOT NULL DEFAULT '',
  `sms_message` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `gateway_response` text,
  `date_created` $date_default,
  `date_executed` $date_default,
  `ip_address` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table sms_broadcast_details..<br/>";
if (!$this->functions->isTableExist("sms_broadcast_details")) {
    if ($this->db->exec($stmt) !== false) {
        echo "(Done)<br/>";
    } else {
        echo "(Failed)<br/>";
    }
} else {
    echo "Table sms_broadcast_details already exists.<br/>";
}

// Create sms_package table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "sms_package (
  `sms_package_id` int(14) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `price` float(14,4) NOT NULL,
  `promo_price` float(14,4) NOT NULL,
  `sms_limit` int(14) NOT NULL DEFAULT '0',
  `sequence` int(14) NOT NULL DEFAULT '0',
  `status` varchar(100) NOT NULL DEFAULT '',
  `date_created` $date_default,
  `date_modified` $date_default,
  `ip_address` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`sms_package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table sms_package..<br/>";
if (!$this->functions->isTableExist("sms_package")) {
    if ($this->db->exec($stmt) !== false) {
        echo "(Done)<br/>";
    } else {
        echo "(Failed)<br/>";
    }
} else {
    echo "Table sms_package already exists.<br/>";
}

// Create sms_package_trans table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "sms_package_trans (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `sms_package_id` int(14) NOT NULL DEFAULT '0',
  `payment_type` varchar(50) NOT NULL DEFAULT '',
  `package_price` float(14,4) NOT NULL,
  `sms_limit` int(14) NOT NULL DEFAULT '0',
  `status` varchar(100) NOT NULL DEFAULT 'pending',
  `payment_reference` varchar(255) NOT NULL DEFAULT '',
  `payment_gateway_response` text,
  `date_created` $date_default,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table sms_package_trans..<br/>";
if (!$this->functions->isTableExist("sms_package_trans")) {
    if ($this->db->exec($stmt) !== false) {
        echo "(Done)<br/>";
    } else {
        echo "(Failed)<br/>";
    }
} else {
    echo "Table sms_package_trans already exists.<br/>";
}

// Create payment_order table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "payment_order (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(10) NOT NULL DEFAULT '',
  `payment_reference` varchar(255) NOT NULL DEFAULT '',
  `order_id` int(14) NOT NULL DEFAULT '0',
  `raw_response` text,
  `date_created` $date_default,
  `ip_address` varchar(100) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
";

echo "Creating Table payment_order..<br/>";
if (!$this->functions->isTableExist("payment_order")) {
    if ($this->db->exec($stmt) !== false) {
        echo "(Done)<br/>";
    } else {
        echo "(Failed)<br/>";
    }
} else {
    echo "Table payment_order already exists.<br/>";
}

// Updating Table merchant
echo "<br/>Updating Table merchant.<br/>";
$new_field = array(
    'user_lang' => "int(14) NOT NULL DEFAULT '0'",
    'membership_purchase_date' => "$date_default",
    'sort_featured' => "int(14) NOT NULL DEFAULT '0'",
    'is_commission' => "int(1) NOT NULL DEFAULT '1'",
    'percent_commision' => "float(14,5) NOT NULL",
);
$this->alterTable('merchant', $new_field);
echo "<br/>";

// Updating Table packages
echo "<br/>Updating Table packages.<br/>";
$new_field = array(
    'sell_limit' => "int(14) NOT NULL DEFAULT '0'"
);
$this->alterTable('packages', $new_field);
echo "<br/>";

// Create merchant_user table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "merchant_user (
  `merchant_user_id` int(14) NOT NULL AUTO_INCREMENT,
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `last_name` varchar(255) NOT NULL DEFAULT '',
  `username` varchar(255) NOT NULL DEFAULT '',
  `password` varchar(255) NOT NULL DEFAULT '',
  `user_access` text,
  `date_created` $date_default,
  `date_modified` $date_default,
  `status` varchar(100) NOT NULL DEFAULT 'active',
  `last_login` $date_default,
  `ip_address` varchar(50) NOT NULL '',
  PRIMARY KEY (`merchant_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table merchant_user..<br/>";
if (!$this->functions->isTableExist("merchant_user")) {
    if ($this->db->exec($stmt) !== false) {
        echo "(Done)<br/>";
    } else {
        echo "(Failed)<br/>";
    }
} else {
    echo "Table merchant_user already exists.<br/>";
}

echo "<br/>Updating Table payment_order.<br/>";        
$new_field = [         
    'payment_type' => "varchar(10) NOT NULL DEFAULT ''"     
];        
$this->alterTable('payment_order', $new_field);
echo "<br/>";

echo "<br/>Updating Table client.<br/>";        
$new_field = [         
    'status' => "varchar(100) NOT NULL DEFAULT 'active'",
    "token" => "varchar(255) NOT NULL DEFAULT ''",  
    "mobile_verification_code" => "int(14) NOT NULL DEFAULT '0'",  
    "mobile_verification_date" => "$date_default", 
    'custom_field1' => "varchar(255) NOT NULL DEFAULT ''",
    'custom_field2' => "varchar(255) NOT NULL DEFAULT ''",
    'avatar' => "varchar(255) NOT NULL DEFAULT ''",
    'email_verification_code' => "varchar(14) NOT NULL DEFAULT ''",
];        
$this->alterTable('client', $new_field);
echo "<br/>";        

$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "bookingtable (
    `booking_id` int(14) NOT NULL AUTO_INCREMENT,
    `merchant_id` int(14) NOT NULL DEFAULT '0',
    `number_guest` int(14) NOT NULL DEFAULT '0',
    `date_booking` date NOT NULL,
    `booking_time` varchar(50) NOT NULL DEFAULT '',
    `booking_name` varchar(255) NOT NULL DEFAULT '',
    `email` varchar(255) NOT NULL DEFAULT '',
    `mobile` varchar(100) NOT NULL DEFAULT '',
    `booking_notes` text,
    `date_created` $date_default,
    `ip_address` varchar(100) NOT NULL DEFAULT '',
    `date_modified` $date_default,
    PRIMARY KEY (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Creating Table bookingtable..<br/>";    
if (!$this->functions->isTableExist("bookingtable")) {            
    if ($this->db->exec($stmt)) {
        echo "(Done)<br/>";
    } else {
        echo "(Failed)<br/>";    
    } 
} else {
    echo "Table bookingtable already exists.<br/>";
} 

echo "<br/>Updating Booking table<br/>";        
$new_field = [         
    'status' => "varchar(255) NOT NULL DEFAULT 'pending'",
    'viewed' => "int(1) NOT NULL DEFAULT '1'"
];        
$this->alterTable('bookingtable', $new_field);
echo "<br/>";    

$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "bank_deposit (
    `id` int(14) NOT NULL AUTO_INCREMENT,
    `merchant_id` int(14) NOT NULL DEFAULT '0',
    `branch_code` varchar(100) NOT NULL DEFAULT '',
    `date_of_deposit` date NOT NULL,
    `time_of_deposit` varchar(50) NOT NULL DEFAULT '',
    `amount` float(14,4) NOT NULL,
    `scanphoto` varchar(255) NOT NULL DEFAULT '',
    `status` varchar(100) NOT NULL DEFAULT 'pending',
    `date_created` date NOT NULL,
    `ip_address` varchar(50) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Updating Table bank_deposit..<br/>";    
$this->db->exec($stmt);
echo "(Done)<br/>";

echo "<br/>Updating Bank deposit table<br/>";        
$new_field = [         
    'transaction_type' => "varchar(255) NOT NULL DEFAULT 'merchant_signup'",
    "client_id" => "int(14) NOT NULL DEFAULT '0'",
    "order_id" => "int(14) NOT NULL DEFAULT '0'"
];        
$this->alterTable('bank_deposit', $new_field);
echo "<br/>";        

echo "<br/>Updating custom_page table<br/>";        
$new_field = [         
    'open_new_tab' => "int(11) NOT NULL DEFAULT '1'",
    'is_custom_link' => "int(2) NOT NULL DEFAULT '1'"
];        
$this->alterTable('custom_page', $new_field);
echo "<br/>";                

echo "<br/>Updating order table<br/>";        
$new_field = [         
    'order_change' => "float(14,4) NOT NULL",
    'payment_provider_name' => "varchar(255) NOT NULL DEFAULT ''",
    'discounted_amount' => "float(14,5) NOT NULL",
    'discount_percentage' => "float(14,5) NOT NULL",
    'percent_commision' => "float(14,4) NOT NULL",
    'total_commission' => "float(14,4) NOT NULL",
    'commision_ontop' => "int(2) NOT NULL DEFAULT '2'",
    'merchant_earnings' => "float(14,4) NOT NULL",
    'packaging' => "float(14,4) NOT NULL",
    'cart_tip_percentage' => "float(14,4) NOT NULL",
    "cart_tip_value" => "float(14,4) NOT NULL",
    "card_fee" => "float(14,4) NOT NULL",
    'donot_apply_tax_delivery' => "int(1) NOT NULL DEFAULT '1'",
    'order_locked' => "int(1) NOT NULL DEFAULT '1'",
    'request_from' => "varchar(10) NOT NULL DEFAULT 'web'",
    'mobile_cart_details' => "text"
];        
$this->alterTable('order', $new_field);
echo "<br/>";                 


$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "payment_provider (
    `id` int(14) NOT NULL AUTO_INCREMENT,
    `payment_name` varchar(255) NOT NULL DEFAULT '',
    `payment_logo` varchar(255) NOT NULL DEFAULT '',
    `sequence` int(14) NOT NULL DEFAULT '0',
    `status` varchar(255) NOT NULL DEFAULT 'publish',
    `date_created` $date_default,
    `date_modified` $date_default,
    `ip_address` varchar(50) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Creating Table payment_provider..<br/>";    
$this->db->exec($stmt);
echo "(Done)<br/>";


// Updating Table payment_order.
echo "<br/>Updating Table payment_order.<br/>";
$new_field = array(
    'payment_type' => "varchar(10) NOT NULL DEFAULT ''"
);
$this->alterTable('payment_order', $new_field);
echo "<br/>";

// Updating Table client.
echo "<br/>Updating Table client.<br/>";
$new_field = array(
    'status' => "varchar(100) NOT NULL DEFAULT 'active'",
    "token" => "varchar(255) NOT NULL DEFAULT ''",
    "mobile_verification_code" => "int(14) NOT NULL DEFAULT '0'",
    "mobile_verification_date" => "$date_default",
    'custom_field1' => "varchar(255) NOT NULL DEFAULT ''",
    'custom_field2' => "varchar(255) NOT NULL DEFAULT ''",
    'avatar' => "varchar(255) NOT NULL DEFAULT ''",
    'email_verification_code' => "varchar(14) NOT NULL DEFAULT ''",
);
$this->alterTable('client', $new_field);
echo "<br/>";

// Creating Table bookingtable
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "bookingtable (
    `booking_id` int(14) NOT NULL AUTO_INCREMENT,
    `merchant_id` int(14) NOT NULL DEFAULT '0',
    `number_guest` int(14) NOT NULL DEFAULT '0',
    `date_booking` date NOT NULL,
    `booking_time` varchar(50) NOT NULL DEFAULT '',
    `booking_name` varchar(255) NOT NULL DEFAULT '',
    `email` varchar(255) NOT NULL DEFAULT '',
    `mobile` varchar(100) NOT NULL DEFAULT '',
    `booking_notes` text,
    `date_created` $date_default,
    `ip_address` varchar(100) NOT NULL DEFAULT '',
    `date_modified` $date_default,
    PRIMARY KEY (`booking_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Creating Table bookingtable..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Updating Booking table
echo "<br/>Updating Booking table<br/>";
$new_field = array(
    'status' => "varchar(255) NOT NULL DEFAULT 'pending'",
    'viewed' => "int(1) NOT NULL DEFAULT '1'"
);
$this->alterTable('bookingtable', $new_field);
echo "<br/>";

// Creating Table bank_deposit
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "bank_deposit (
    `id` int(14) NOT NULL AUTO_INCREMENT,
    `merchant_id` int(14) NOT NULL DEFAULT '0',
    `branch_code` varchar(100) NOT NULL DEFAULT '',
    `date_of_deposit` date NOT NULL,
    `time_of_deposit` varchar(50) NOT NULL DEFAULT '',
    `amount` float(14,4) NOT NULL,
    `scanphoto` varchar(255) NOT NULL DEFAULT '',
    `status` varchar(100) NOT NULL DEFAULT 'pending',
    `date_created` date NOT NULL,
    `ip_address` varchar(50) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Creating Table bank_deposit..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Updating Bank deposit table
echo "<br/>Updating Bank deposit table<br/>";
$new_field = array(
    'transaction_type' => "varchar(255) NOT NULL DEFAULT 'merchant_signup'",
    "client_id" => "int(14) NOT NULL DEFAULT '0'",
    "order_id" => "int(14) NOT NULL DEFAULT '0'"
);
$this->alterTable('bank_deposit', $new_field);
echo "<br/>";

// Updating custom_page table
echo "<br/>Updating custom_page table<br/>";
$new_field = array(
    'open_new_tab' => "int(11) NOT NULL DEFAULT '1'",
    'is_custom_link' => "int(2) NOT NULL DEFAULT '1'"
);
$this->alterTable('custom_page', $new_field);
echo "<br/>";

// Updating order table
echo "<br/>Updating order table<br/>";
$new_field = array(
    'order_change' => "float(14,4) NOT NULL",
    'payment_provider_name' => "varchar(255) NOT NULL DEFAULT ''",
    'discounted_amount' => "float(14,5) NOT NULL",
    'discount_percentage' => "float(14,5) NOT NULL",
    'percent_commision' => "float(14,4) NOT NULL",
    'total_commission' => "float(14,4) NOT NULL",
    'commision_ontop' => "int(2) NOT NULL DEFAULT '2'",
    'merchant_earnings' => "float(14,4) NOT NULL",
    'packaging' => "float(14,4) NOT NULL",
    'cart_tip_percentage' => "float(14,4) NOT NULL",
    "cart_tip_value" => "float(14,4) NOT NULL",
    "card_fee" => "float(14,4) NOT NULL",
    'donot_apply_tax_delivery' => "int(1) NOT NULL DEFAULT '1'",
    'order_locked' => "int(1) NOT NULL DEFAULT '1'",
    'request_from' => "varchar(10) NOT NULL DEFAULT 'web'",
    'mobile_cart_details' => "text"
);
$this->alterTable('order', $new_field);
echo "<br/>";

// Creating Table payment_provider
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "payment_provider (
    `id` int(14) NOT NULL AUTO_INCREMENT,
    `payment_name` varchar(255) NOT NULL DEFAULT '',
    `payment_logo` varchar(255) NOT NULL DEFAULT '',
    `sequence` int(14) NOT NULL DEFAULT '0',
    `status` varchar(255) NOT NULL DEFAULT 'publish',
    `date_created` $date_default,
    `date_modified` $date_default,
    `ip_address` varchar(50) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Creating Table _payment_provider..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Creating Table offers
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "offers (
    `offers_id` int(14) NOT NULL AUTO_INCREMENT,
    `merchant_id` int(14) NOT NULL DEFAULT '0',
    `offer_percentage` float(14,4) NOT NULL,
    `offer_price` float(14,4) NOT NULL,
    `valid_from` date NOT NULL,
    `valid_to` date NOT NULL,
    `status` varchar(255) NOT NULL DEFAULT 'pending',
    `date_created` $date_default,
    `date_modified` $date_default,
    `ip_address` varchar(50) NOT NULL DEFAULT '',
    `applicable_to` varchar(100) NOT NULL DEFAULT 'all',
    PRIMARY KEY (`offers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Creating Table _offers..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Creating Table newsletter
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "newsletter (
    `id` int(14) NOT NULL AUTO_INCREMENT,
    `email_address` varchar(255) NOT NULL DEFAULT '',
    `date_created` $date_default,
    `ip_address` varchar(50) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Creating Table _newsletter..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Updating Table sms_broadcast_details.
echo "<br/>Updating Table sms_broadcast_details.<br/>";
$new_field = array(
    'gateway' => "varchar(255) NOT NULL DEFAULT 'twilio'"
);
$this->alterTable('sms_broadcast_details', $new_field);
echo "<br/>";

// Creating Table barclay_trans
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "barclay_trans (
    `id` int(14) NOT NULL AUTO_INCREMENT,
    `orderid` varchar(255) NOT NULL DEFAULT '',
    `token` varchar(255) NOT NULL DEFAULT '',
    `transaction_type` varchar(255) NOT NULL DEFAULT 'signup',
    `date_created` date NOT NULL,
    `ip_address` varchar(50) NOT NULL DEFAULT '',
    `param1` varchar(255) NOT NULL DEFAULT '',
    `param2` text,
    `param3` text,
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Creating Table barclay_trans..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Creating Table ingredients
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "ingredients (
    `ingredients_id` int(14) NOT NULL AUTO_INCREMENT,
    `merchant_id` int(14) NOT NULL DEFAULT '0',
    `ingredients_name` varchar(255) NOT NULL DEFAULT '',
    `sequence` int(14) NOT NULL DEFAULT '0',
    `date_created` $date_default,
    `date_modified` $date_default,
    `status` varchar(50) NOT NULL DEFAULT 'published',
    `ip_address` varchar(50) NOT NULL DEFAULT '',
    PRIMARY KEY (`ingredients_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;";

echo "Creating Table ingredients..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";


// New fields for the item table
$new_field = array(
    'ingredients' => "text",
    'spicydish' => "int(2) NOT NULL DEFAULT '1'",
    "two_flavors" => "int(2) NOT NULL",
    "two_flavors_position" => "text",
    "require_addon" => "text",
    'dish' => "text",
    'item_name_trans' => "text",
    'item_description_trans' => "text",
    'non_taxable' => "int(1) NOT NULL DEFAULT '1'",
    'not_available' => "int(1) NOT NULL DEFAULT '1'",
    'gallery_photo' => "text"
);  
$this->alterTable('item', $new_field);
echo "<br/>";

// New fields for the order_details table
$new_field = array(         
    'ingredients' => "text",
    'non_taxable' => "int(1) NOT NULL DEFAULT '1'"
);  
$this->alterTable('order_details', $new_field);
echo "<br/>";

// SQL statement to create withdrawal table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "withdrawal (
  `withdrawal_id` int(14) NOT NULL AUTO_INCREMENT,
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `payment_type` varchar(100) NOT NULL DEFAULT '',
  `payment_method` varchar(100) NOT NULL DEFAULT '',
  `amount` float(14,4) NOT NULL,
  `current_balance` float(14,4) NOT NULL,
  `balance` float(14,4) NOT NULL,
  `currency_code` varchar(3) NOT NULL DEFAULT '',
  `account` varchar(255) NOT NULL DEFAULT '',
  `account_name` varchar(255) NOT NULL DEFAULT '',
  `bank_account_number` varchar(255) NOT NULL DEFAULT '',
  `swift_code` varchar(100) NOT NULL DEFAULT '',
  `bank_name` varchar(255) NOT NULL DEFAULT '',
  `bank_branch` varchar(255) NOT NULL DEFAULT '',
  `bank_country` varchar(50) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `viewed` int(2) NOT NULL DEFAULT '1',
  `date_created` $date_default,
  `date_to_process` date NOT NULL,
  `date_process` $date_default,
  `api_raw_response` text,
  `withdrawal_token` text,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  `bank_type` varchar(255) NOT NULL DEFAULT 'default',
  PRIMARY KEY (`withdrawal_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";
echo "Creating Table withdrawal..<br/>";  
$this->db->exec($stmt);
echo "(Done)<br/>";

// New fields for the withdrawal table
$new_field = array(         
    'bank_type' => "varchar(255) NOT NULL DEFAULT 'default'"          
);  
$this->alterTable('withdrawal', $new_field);
echo "<br/>";

// New fields for the merchant_user table
$new_field = array(         
    'contact_email' => "varchar(255) NOT NULL DEFAULT ''",
    'session_token' => "varchar(255) NOT NULL DEFAULT ''",
);  
$this->alterTable('merchant_user', $new_field);
echo "<br/>";

// New fields for the merchant table
$new_field = array(         
    'abn' => "varchar(255) NOT NULL DEFAULT ''",
    'session_token' => "varchar(255) NOT NULL DEFAULT ''",
    'commision_type' => "varchar(50) NOT NULL DEFAULT 'percentage'"     
);  
$this->alterTable('merchant', $new_field);
echo "<br/>";

// SQL statement to create fax_package table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $prefix . "fax_package (
  `fax_package_id` int(14) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `price` float(14,4) NOT NULL,
  `promo_price` float(14,4) NOT NULL,
  `fax_limit` int(14) NOT NULL DEFAULT '0',
  `sequence` int(14) NOT NULL DEFAULT '0',
  `status` varchar(100) NOT NULL DEFAULT '',
  `date_created` $date_default,
  `date_modified` $date_default,
  `ip_address` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`fax_package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";
echo "Creating Table fax_package..<br/>"; 
$this->db->exec($stmt);
echo "(Done)<br/>";

// SQL statement to create fax_package_trans table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $table_prefix . "fax_package_trans (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `fax_package_id` int(14) NOT NULL DEFAULT '0',
  `payment_type` varchar(50) NOT NULL DEFAULT '',
  `package_price` float(14,4) NOT NULL,
  `fax_limit` int(14) NOT NULL DEFAULT '0',
  `status` varchar(100) NOT NULL DEFAULT 'pending',
  `payment_reference` varchar(255) NOT NULL DEFAULT '',
  `payment_gateway_response` text NOT NULL,
  `date_created` $date_default,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table fax_package_trans..<br/>"; 
$this->db->exec($stmt);
echo "(Done)<br/>";                      

// SQL statement to create fax_broadcast table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $table_prefix . "fax_broadcast (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `faxno` varchar(50) NOT NULL DEFAULT '',
  `recipname` varchar(32) NOT NULL DEFAULT '',
  `faxurl` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `jobid` varchar(255) NOT NULL DEFAULT '',
  `api_raw_response` text,
  `date_created` $date_default,
  `date_process` $date_default,
  `date_postback` $date_default,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table fax_broadcast..<br/>"; 
$this->db->exec($stmt);
echo "(Done)<br/>";

// SQL statement to create shipping_rate table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $table_prefix . "shipping_rate (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `distance_from` int(14) NOT NULL DEFAULT '0',
  `distance_to` int(14) NOT NULL DEFAULT '0',
  `shipping_units` varchar(5) NOT NULL DEFAULT '',
  `distance_price` float(14,4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table shipping_rate..<br/>"; 
$this->db->exec($stmt);
echo "(Done)<br/>";

// New fields for the category table
$new_field = array(         
    'spicydish' => "int(2) NOT NULL DEFAULT '1'",
    'spicydish_notes' => "text",
    'dish' => "text",
    'category_name_trans' => "text",
    'category_description_trans' => "text",
);  
$this->alterTable('category', $new_field);
echo "<br/>";  

// New fields for the admin_user table
$new_field = array(         
    'session_token' => "varchar(255) NOT NULL DEFAULT ''",
    'last_login' => "$date_default",
    'user_access' => "text"
);  
$this->alterTable('admin_user', $new_field);
echo "<br/>";
$this->addIndex('option','merchant_id');
$this->addIndex('rating','merchant_id');
$this->addIndex('rating','client_id');
$this->addIndex('order','merchant_id');
$this->addIndex('order','client_id');

// SQL statement to create order_delivery_address table
$stmt = "
CREATE TABLE IF NOT EXISTS " . $table_prefix . "order_delivery_address (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `order_id` int(14) NOT NULL DEFAULT '0',
  `client_id` int(14) NOT NULL DEFAULT '0',
  `street` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `state` varchar(255) NOT NULL DEFAULT '',
  `zipcode` varchar(255) NOT NULL DEFAULT '',
  `location_name` varchar(255) NOT NULL DEFAULT '',
  `country` varchar(255) NOT NULL DEFAULT '',
  `date_created` $date_default,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  `contact_phone` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table order_delivery_address..<br/>";  
$this->db->exec($stmt);
echo "(Done)<br/>";

// New fields for the package_trans table
$new_field = array(         
    'fee' => "float(14,4) NOT NULL"          
);   
$this->alterTable('package_trans', $new_field);
echo "<br/>";  

// New field for the order_delivery_address table
$new_field = array(         
    'contact_phone' => "varchar(100) NOT NULL DEFAULT ''" 
);   
$this->alterTable('order_delivery_address', $new_field);
echo "<br/>";  

// New fields for the subcategory table
$new_field = array(         
    'status' => "varchar(100) NOT NULL DEFAULT 'publish'",
    'subcategory_name_trans' => "text",
    'subcategory_description_trans' => "text",
);   
$this->alterTable('subcategory', $new_field);
echo "<br/>";


$stmt = "SELECT * FROM mt_admin_user WHERE user_access <> ''";        
if (!$this->db->query($stmt)->fetchAll()) {
    $user_all_access = '["autologin","dashboard","merchant","sponsoredMerchantList","packages","Cuisine","dishes","OrderStatus","settings","commisionsettings","voucher","merchantcommission","withdrawal","incomingwithdrawal","withdrawalsettings","emailsettings","emailtpl","customPage","Ratings","ContactSettings","SocialSettings","ManageCurrency","ManageLanguage","Seo","analytics","customerlist","subscriberlist","reviews","bankdeposit","paymentgatewaysettings","paymentgateway","paypalSettings","stripeSettings","mercadopagoSettings","sisowsettings","payumonenysettings","obdsettings","payserasettings","payondelivery","barclay","epaybg","authorize","sms","smsSettings","smsPackage","smstransaction","smslogs","fax","faxtransaction","faxpackage","faxlogs","faxsettings","reports","rptMerchantReg","rptMerchantPayment","rptMerchanteSales","rptmerchantsalesummary","rptbookingsummary","userList"]';

    $stmt_update_admin = "UPDATE mt_admin_user SET user_access = :user_access";
    $update_stmt = $this->db->prepare($stmt_update_admin);
    $update_stmt->bindParam(':user_access', $user_all_access);
    $update_stmt->execute();
}

$alter_table = "
ALTER TABLE mt_currency CHANGE 
`currency_symbol` `currency_symbol` VARCHAR(100)  
CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT ''"; 

echo $alter_table; // Assuming you want to output the SQL command
$this->db->exec($alter_table);


$stmt = "
CREATE TABLE IF NOT EXISTS ".$table_prefix."dishes (
  `dish_id` int(14) NOT NULL AUTO_INCREMENT,
  `dish_name` varchar(255) NOT NULL DEFAULT '',
  `photo` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(100) NOT NULL DEFAULT '',
  `date_created` $date_default,
  `date_modified` $date_default,
  `ip_address` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`dish_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table dishes..<br/>";  
$this->db->exec($stmt);
echo "(Done)<br/>";

$stmt = "
CREATE TABLE IF NOT EXISTS ".$table_prefix."voucher_new (
  `voucher_id` int(14) NOT NULL AUTO_INCREMENT,
  `voucher_owner` varchar(255) NOT NULL DEFAULT 'merchant',
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `joining_merchant` text,
  `voucher_name` varchar(255) NOT NULL DEFAULT '',
  `voucher_type` varchar(255) NOT NULL DEFAULT '',
  `amount` float(14,4) NOT NULL,
  `expiration` date NOT NULL,
  `status` varchar(100) NOT NULL DEFAULT '',
  `date_created` $date_default,
  `date_modified` $date_default,
  `ip_address` varchar(100) NOT NULL DEFAULT '',
  `used_once` int(1) NOT NULL DEFAULT '1',  
  PRIMARY KEY (`voucher_id`),
  KEY `voucher_name` (`voucher_name`),
  KEY `status` (`status`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table voucher_new..<br/>"; 
$this->db->exec($stmt);
echo "(Done)<br/>";

$stmt = "
CREATE TABLE IF NOT EXISTS ".$table_prefix."address_book (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `client_id` int(14) NOT NULL DEFAULT '0',
  `street` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `state` varchar(255) NOT NULL DEFAULT '',
  `zipcode` varchar(255) NOT NULL DEFAULT '',
  `location_name` varchar(255) NOT NULL DEFAULT '',
  `country_code` varchar(3) NOT NULL DEFAULT '',
  `as_default` int(1) NOT NULL DEFAULT '1',
  `date_created` $date_default,
  `date_modified` $date_default,
  `ip_address` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";

echo "Creating Table address_book..<br/>";  
$this->db->exec($stmt);
echo "(Done)<br/>";

// Adding new fields to existing tables
$new_field = array(
    'size_name_trans' => "text"
);
$this->alterTable('size', $new_field);
echo "<br/>";

$new_field = array(
    'ingredients_name_trans' => "text"
);
$this->alterTable('ingredients', $new_field);
echo "<br/>";

$new_field = array(
    'sub_item_name_trans' => "text",
    'item_description_trans' => "text"
);
$this->alterTable('subcategory_item', $new_field);
echo "<br/>";

$new_field = array(
    'cooking_name_trans' => "text"
);
$this->alterTable('cooking_ref', $new_field);
echo "<br/>";

$new_field = array(
    'used_once' => "int(1) NOT NULL DEFAULT '1'"
);
$this->alterTable('voucher_new', $new_field);
echo "<br/>";

// New fields for update version 2.4
$new_field = array(
    'order_id' => "varchar(14) NOT NULL DEFAULT ''"
);
$this->alterTable('review', $new_field);
echo "<br/>";

// Creating the order_history table
$stmt = "
CREATE TABLE IF NOT EXISTS ".$table_prefix."order_history (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `order_id` int(14) NOT NULL DEFAULT '0',
  `status` varchar(255) NOT NULL DEFAULT '',
  `remarks` text,
  `date_created` $date_default,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";
echo "Creating Table order_history..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Creating the order_sms table
$stmt = "
CREATE TABLE IF NOT EXISTS ".$table_prefix."order_sms (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `mobile` varchar(50) NOT NULL DEFAULT '',
  `code` int(4) NOT NULL,
  `session` varchar(255) NOT NULL DEFAULT '',
  `date_created` $date_default,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `session` (`session`),
  KEY `code` (`code`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";
echo "Creating Table order_sms..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Creating the zipcode table
$stmt = "
CREATE TABLE IF NOT EXISTS ".$table_prefix."zipcode (
  `zipcode_id` int(14) NOT NULL AUTO_INCREMENT,
  `zipcode` varchar(255) NOT NULL DEFAULT '',
  `country_code` varchar(5) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `area` varchar(255) NOT NULL DEFAULT '',
  `stree_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `date_created` $date_default,
  `date_modified` $date_default,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`zipcode_id`),
  KEY `country_code` (`country_code`),
  KEY `area` (`area`),
  KEY `stree_name` (`stree_name`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;
";
echo "Creating Table zipcode..<br/>"; 
$this->db->exec($stmt);
echo "(Done)<br/>";

// New fields for update version 3.1
$new_field = array(
    'cuisine_name_trans' => "text"
);
$this->alterTable('cuisine', $new_field);
echo "<br/>";

// Special category
$new_field = array(
    'parent_cat_id' => "int(14) NOT NULL DEFAULT '0'"
);
$this->alterTable('category', $new_field);
echo "<br/>";

// Updating table order_delivery_address
echo "Updating table order_delivery_address<br/>";
$new_field = array(
    'formatted_address' => "text",
    'google_lat' => "varchar(50) NOT NULL DEFAULT ''",
    'google_lng' => "varchar(50) NOT NULL DEFAULT ''",
);
$this->alterTable('order_delivery_address', $new_field);

// Updating table bookingtable
echo "Updating table bookingtable<br/>";
$new_field = array(
    'client_id' => "int(14) NOT NULL DEFAULT '0'"
);
$this->alterTable('bookingtable', $new_field);

// Updating table client
echo "Updating table client<br/>";
$new_field = array(
    'is_guest' => "int(1) NOT NULL DEFAULT '2'"
);
$this->alterTable('client', $new_field);

// Creating the receive_post table
$stmt = "
CREATE TABLE IF NOT EXISTS ".$prefix."receive_post (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(3) NOT NULL DEFAULT '',
  `receive_post` text,
  `status` text,
  `date_created` $date_default,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1;
";

echo "Creating Table receive_post..<br/>";  
$this->db->exec($stmt);
echo "(Done)<br/>";


// Creating the email_logs table
$stmt = "
CREATE TABLE IF NOT EXISTS ".$prefix."email_logs (
  `id` int(14) NOT NULL,
  `email_address` varchar(255) NOT NULL DEFAULT '',
  `sender` varchar(255) NOT NULL DEFAULT '',
  `subject` varchar(255) NOT NULL DEFAULT '',
  `content` text,
  `status` varchar(200) NOT NULL DEFAULT 'pending',
  `date_created` $date_default,
  `ip_address` varchar(50) NOT NULL DEFAULT '',
  `module_type` varchar(255) NOT NULL DEFAULT '',
  `user_type` varchar(100) NOT NULL DEFAULT '',
  `user_id` int(14) NOT NULL DEFAULT '0',
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `email_provider` varchar(100) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

echo "Creating Table email_logs..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Adding keys to email_logs table


// Modifying id column to AUTO_INCREMENT
$stmt = "
ALTER TABLE ".$prefix."email_logs
  MODIFY `id` int(14) NOT NULL AUTO_INCREMENT;
";
$this->db->exec($stmt);

// Altering email_logs to add a new field
$new_field = array( 
    'email_provider' => "varchar(100) NOT NULL DEFAULT ''",         
);
$this->alterTable('email_logs', $new_field);

// Creating the minimum_table
$stmt = "
CREATE TABLE IF NOT EXISTS ".$prefix."minimum_table (
  `id` int(14) NOT NULL,
  `merchant_id` int(14) NOT NULL DEFAULT '0',
  `distance_from` int(14) NOT NULL DEFAULT '0',
  `distance_to` int(14) DEFAULT '0',
  `shipping_units` varchar(5) NOT NULL DEFAULT '',
  `min_order` float(14,4) NOT NULL DEFAULT '0.0000'
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

echo "Creating Table minimum_table..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";



// Modifying id column to AUTO_INCREMENT
$stmt = "
ALTER TABLE ".$prefix."minimum_table
  MODIFY `id` int(14) NOT NULL AUTO_INCREMENT;
";
$this->db->exec($stmt);

// Updating table _order
echo "Updating table _order<br/>";
$new_field = array( 
    'apply_food_tax' => "int(1) NOT NULL DEFAULT '0'",         
    'order_id_token' => "varchar(100) NOT NULL DEFAULT ''",
    'admin_viewed' => "int(1) NOT NULL DEFAULT '0'",
    'merchantapp_viewed' => "int(1) NOT NULL DEFAULT '0'",
    'dinein_number_of_guest' => "varchar(14) NOT NULL DEFAULT ''",
    'dinein_special_instruction' => "varchar(255) NOT NULL DEFAULT ''",
    'critical' => "int(1) NOT NULL DEFAULT '1'",
    'commision_type' => "varchar(50) NOT NULL DEFAULT 'percentage'"
);
$this->alterTable('order', $new_field);

// Updating table _merchant
echo "Updating table _merchant<br/>";
$new_field = array( 
    'merchant_key' => "varchar(255) NOT NULL DEFAULT ''", 
    'latitude' => "varchar(50) NOT NULL DEFAULT ''", 
    'lontitude' => "varchar(50) NOT NULL DEFAULT ''", 
    'delivery_charges' => "float(14,5) NOT NULL DEFAULT '0.00000'", 
    'minimum_order' => "float(14,5) NOT NULL DEFAULT '0.00000'", 
    'delivery_minimum_order' => "float(14,5) NOT NULL DEFAULT '0.00000'", 
    'delivery_maximum_order' => "float(14,5) NOT NULL DEFAULT '0.00000'", 
    'pickup_minimum_order' => "float(14,5) NOT NULL DEFAULT '0.00000'", 
    'pickup_maximum_order' => "float(14,5) NOT NULL DEFAULT '0.00000'", 
    'country_name' => "varchar(255) NOT NULL DEFAULT ''", 
    'country_id' => "int(14) NOT NULL DEFAULT '0'", 
    'state_id' => "int(14) NOT NULL DEFAULT '0'", 
    'city_id' => "int(14) NOT NULL DEFAULT '0'", 
    'area_id' => "int(14) NOT NULL DEFAULT '0'", 
    'logo' => "varchar(255) NOT NULL DEFAULT ''", 
    'merchant_type' => "int(1) NOT NULL DEFAULT '1'", 
    'invoice_terms' => "int(14) NOT NULL DEFAULT '7'", 
);
$this->alterTable('merchant', $new_field);

// Creating the bookingtable_history table
$stmt = "
CREATE TABLE IF NOT EXISTS ".$prefix."bookingtable_history (
  `id` int(14) NOT NULL,
  `booking_id` int(14) NOT NULL DEFAULT '0',
  `status` varchar(255) NOT NULL DEFAULT '',
  `remarks` varchar(255) NOT NULL DEFAULT '',
  `date_created` $date_default
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

echo "Creating Table bookingtable_history..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Adding keys to bookingtable_history


// Modifying id column to AUTO_INCREMENT
$stmt = "
ALTER TABLE ".$prefix."bookingtable_history
  MODIFY `id` int(14) NOT NULL AUTO_INCREMENT;
";
$this->db->exec($stmt);









// Create location_states table
$stmt = "
    CREATE TABLE IF NOT EXISTS ".$prefix."location_states (
        `state_id` int(11) NOT NULL AUTO_INCREMENT,
        `name` varchar(30) NOT NULL DEFAULT '',
        `country_id` int(11) NOT NULL DEFAULT '1',
        `sequence` int(14) NOT NULL DEFAULT '0',
        `date_created` $date_default,
        `date_modified` $date_default,
        `ip_address` varchar(50) NOT NULL DEFAULT '',
        PRIMARY KEY (`state_id`),
        KEY `country_id` (`country_id`),
        KEY `sequence` (`sequence`),
        KEY `name` (`name`)
    ) ENGINE=InnoDB DEFAULT CHARSET=latin1;
";

echo "Creating Table location_states..<br/>";    
$this->db->exec($stmt);
echo "(Done)<br/>";



// Create location_rate table
// Create location_rate table
$stmt = "
    CREATE TABLE IF NOT EXISTS ".$prefix."location_rate (
        `rate_id` int(14) NOT NULL AUTO_INCREMENT,
        `merchant_id` int(14) NOT NULL DEFAULT '0',
        `country_id` int(14) NOT NULL DEFAULT '0',
        `state_id` int(14) NOT NULL DEFAULT '0',
        `city_id` int(14) DEFAULT '0',
        `area_id` int(14) NOT NULL DEFAULT '0',
        `fee` float(14,5) NOT NULL DEFAULT '0.00000',
        `sequence` int(14) NOT NULL DEFAULT '0',
        `date_created` $date_default,
        `date_modified` $date_default,
        `ip_address` varchar(50) NOT NULL DEFAULT '',
        PRIMARY KEY (`rate_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

echo "Creating Table location_rate..<br/>";    
$this->db->exec($stmt);
echo "(Done)<br/>";


// Update order_delivery_address table to add new field
echo "Updating table order_delivery_address<br/>";
$new_field = array(
    'area_name' => "varchar(255) NOT NULL DEFAULT ''",
);
$this->alterTable('order_delivery_address', $new_field);

$stmt = "
    CREATE TABLE IF NOT EXISTS ".$prefix."invoice (
        `invoice_number` int(14) NOT NULL AUTO_INCREMENT,
        `invoice_token` varchar(100) NOT NULL DEFAULT '',
        `merchant_id` int(14) NOT NULL DEFAULT '0',
        `merchant_name` varchar(255) NOT NULL DEFAULT '',
        `merchant_contact_email` varchar(200) NOT NULL DEFAULT '',
        `merchant_contact_phone` varchar(50) NOT NULL DEFAULT '',
        `invoice_terms` int(14) NOT NULL DEFAULT '0',
        `invoice_total` float(14,4) NOT NULL DEFAULT '0.0000',
        `date_from` date NOT NULL DEFAULT '0000-00-00',
        `date_to` date NOT NULL DEFAULT '0000-00-00',
        `pdf_filename` varchar(255) NOT NULL DEFAULT '',
        `status` varchar(255) NOT NULL DEFAULT 'pending',
        `payment_status` varchar(255) NOT NULL DEFAULT 'unpaid',
        `viewed` varchar(2) NOT NULL DEFAULT '2',
        `date_created` $date_default,
        `date_process` $date_default,
        `ip_address` varchar(50) NOT NULL DEFAULT '',
        PRIMARY KEY (`invoice_number`),
        KEY `invoice_token` (`invoice_token`),
        KEY `merchant_id` (`merchant_id`),
        KEY `status` (`status`),
        KEY `date_from` (`date_from`),
        KEY `date_to` (`date_to`),
        KEY `invoice_total` (`invoice_total`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

echo "Creating Table invoice..<br/>";    
$this->db->exec($stmt);
echo "(Done)<br/>";


// Create invoice_history table
$stmt = "
    CREATE TABLE IF NOT EXISTS ".$prefix."invoice_history (
        `id` int(14) NOT NULL AUTO_INCREMENT,
        `invoice_number` varchar(14) NOT NULL DEFAULT '',
        `payment_status` varchar(100) NOT NULL DEFAULT '',
        `remarks` varchar(255) NOT NULL DEFAULT '',
        `date_created` $date_default,
        `ip_address` varchar(50) NOT NULL DEFAULT '',
        PRIMARY KEY (`id`),  -- Define primary key here
        KEY `invoice_number` (`invoice_number`),
        KEY `payment_status` (`payment_status`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

echo "Creating Table invoice_history..<br/>";    
$this->db->exec($stmt);
echo "(Done)<br/>";


// Updating review table
echo "Updating table review<br/>";    
$new_field = array( 
    'parent_id' => "int(14) NOT NULL DEFAULT '0'",
    'reply_from' => "varchar(255) NOT NULL DEFAULT ''",
    'date_modified' => "$date_default",
);
$this->alterTable('review', $new_field);

// Updating sms_package_trans table
$new_field = array( 
    'cc_id' => "int(14) NOT NULL DEFAULT '0'",
);
$this->alterTable('sms_package_trans', $new_field);
$this->addIndex("sms_package_trans", "cc_id");
$this->addIndex("sms_package_trans", "merchant_id");
$this->addIndex("sms_package_trans", "sms_package_id");
$this->addIndex("sms_package_trans", "payment_type");

// Updating order table
echo "Updating table order<br/>";   
$new_field = array( 
    'sofort_trans_id' => "varchar(255) NOT NULL DEFAULT ''",
);
$this->alterTable('order', $new_field);

// Updating offers table
echo "Updating table offers<br/>";    
$new_field = array( 
    'applicable_to' => "varchar(100) NOT NULL DEFAULT 'all'",
);
$this->alterTable('offers', $new_field);

// Updating order table again
echo "Updating table order<br/>";   
$new_field = array( 
    'calculation_method' => "int(1) NOT NULL DEFAULT '1'",
);
$this->alterTable('order', $new_field);

// Final updates to the order table
echo "Updating table order<br/>";   
$new_field = array( 
    'request_cancel' => "int(1) NOT NULL DEFAULT '2'",
    'request_cancel_viewed' => "int(1) NOT NULL DEFAULT '2'",
    'request_cancel_status' => "varchar(255) NOT NULL DEFAULT 'pending'",
);
$this->alterTable('order', $new_field);

// Create address_book_location table
// Create address_book_location table
$stmt = "
    CREATE TABLE IF NOT EXISTS ".$prefix."address_book_location (
        `id` int(11) NOT NULL AUTO_INCREMENT,  -- Set AUTO_INCREMENT here
        `client_id` int(14) NOT NULL DEFAULT '0',
        `street` varchar(255) NOT NULL DEFAULT '',
        `location_name` varchar(255) NOT NULL DEFAULT '',
        `country_id` int(14) NOT NULL DEFAULT '0',
        `state_id` int(14) NOT NULL DEFAULT '0',
        `city_id` int(14) NOT NULL DEFAULT '0',
        `area_id` int(14) NOT NULL DEFAULT '0',
        `as_default` int(1) NOT NULL DEFAULT '0',
        `date_created` $date_default,
        `date_modified` $date_default,
        `ip_address` varchar(50) NOT NULL DEFAULT '',
        PRIMARY KEY (`id`)  -- Define primary key here
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

echo "Creating Table address_book_location..<br/>";    
$this->db->exec($stmt);
echo "(Done)<br/>";



// Updating item table
echo "Updating table item<br/>";    
$new_field = array( 
    'packaging_fee' => "float(14,4) NOT NULL DEFAULT '0.0000'",
    'packaging_incremental' => "int(1) NOT NULL DEFAULT '0'",
);
$this->alterTable('item', $new_field);

// Updating category table
echo "Updating table category<br/>";    
$new_field = array( 
    'monday' => "int(1) NOT NULL DEFAULT '0'",
    'tuesday' => "int(1) NOT NULL DEFAULT '0'",
    'wednesday' => "int(1) NOT NULL DEFAULT '0'",
    'thursday' => "int(1) NOT NULL DEFAULT '0'",
    'friday' => "int(1) NOT NULL DEFAULT '0'",
    'saturday' => "int(1) NOT NULL DEFAULT '0'",
    'sunday' => "int(1) NOT NULL DEFAULT '0'",
);
$this->alterTable('category', $new_field);

/*4.8*/
echo "Creating table favorites<br/>";
$stmt = "
    CREATE TABLE IF NOT EXISTS ".$prefix."favorites (
        `id` int(14) NOT NULL AUTO_INCREMENT,
        `fav_type` varchar(100) NOT NULL DEFAULT 'restaurant',
        `client_id` int(14) NOT NULL DEFAULT '0',
        `merchant_id` int(14) NOT NULL DEFAULT '0',
        `date_created` $date_default,
        `date_modified` $date_default,
        `ip_address` varchar(50) NOT NULL DEFAULT '',
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

$this->db->exec($stmt);
echo "(Done)<br/>";


// Updating order table
echo "Updating table order<br/>";   
$new_field = array( 
    'dinein_table_number' => "varchar(50) NOT NULL DEFAULT ''",
);
$this->alterTable('order', $new_field);

// Assuming $this->db is a PDO instance

// Create table sms_trans_logs
$stmt = "
    CREATE TABLE IF NOT EXISTS ".$prefix."sms_trans_logs (
      `id` int(14) NOT NULL,
      `merchant_id` int(14) NOT NULL DEFAULT '0',
      `sms_package_id` int(14) NOT NULL DEFAULT '0',
      `payment_type` varchar(100) NOT NULL DEFAULT '',
      `package_price` float(14,4) NOT NULL DEFAULT '0.0000',
      `sms_limit` varchar(14) NOT NULL DEFAULT '',
      `payment_reference` varchar(255) NOT NULL DEFAULT '',
      `status` varchar(255) NOT NULL DEFAULT 'pending',
      `payment_gateway_ref` varchar(255) NOT NULL DEFAULT '',
      `gateway_response` text,
      `date_created` $date_default,
      `date_modified` $date_default,
      `ip_address` varchar(50) NOT NULL DEFAULT ''
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

echo "Creating table sms_trans_logs<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Alter package_trans table
echo "Updating table package_trans<br/>";
$new_field = "merchant_ref varchar(255) NOT NULL DEFAULT ''";
$this->alterTable('package_trans', [$new_field]);

// Alter sms_package_trans table
echo "Updating table sms_package_trans<br/>";
$new_field = "merchant_ref varchar(255) NOT NULL DEFAULT ''";
$this->alterTable('sms_package_trans', [$new_field]);

// Alter payment_order table
echo "Updating table payment_order<br/>";
$new_field = "merchant_ref varchar(255) NOT NULL DEFAULT ''";
$this->alterTable('payment_order', [$new_field]);

// Alter cuisine table
echo "Updating table cuisine<br/>";
$new_field = [
    "status varchar(100) NOT NULL DEFAULT 'publish'",
    "featured_image varchar(255) NOT NULL DEFAULT ''"
];
$this->alterTable('cuisine', $new_field);

// END 5.0

// 5.1 - Updating the order and merchant tables
$new_field = "payment_gateway_ref varchar(255) NOT NULL DEFAULT ''";
$this->alterTable('order', [$new_field]);

$new_field = [
    "payment_gateway_ref varchar(255) NOT NULL DEFAULT ''",
    "user_access text"
];
$this->alterTable('merchant', $new_field);

$new_field = [
    "encrypted_card binary(255) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0'",
];
$this->alterTable('client_cc', $new_field);

$new_field = [
    "encrypted_card binary(255) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0'",
    "date_modified $date_default"
];
$this->alterTable('merchant_cc', $new_field);

$stmt = "               
    CREATE TABLE IF NOT EXISTS ".$prefix."stripe_logger (
        `id` int(14) NOT NULL,
        `trans_type` varchar(255) NOT NULL DEFAULT '',
        `payment_intent` varchar(255) NOT NULL DEFAULT '',
        `post_receive` text,
        `webhooks_response` text,
        `date_created` $date_default,
        `post_receive_date` $date_default,
        `ip_address` varchar(50) NOT NULL DEFAULT ''
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

echo "Creating table stripe_logger<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

$this->addIndex("order", "payment_gateway_ref");
$this->addIndex("stripe_logger", "payment_intent");

/*END 5.1*/

/*5.2*/
$stmt = "
ALTER TABLE ".$prefix."payment_order CHANGE `payment_type` `payment_type` 
VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT ''; 
";    
$this->db->exec($stmt);
/*END 5.2*/

/*5.4*/
$new_field = array(                    
    'payment_customer_id' => "varchar(255) NOT NULL DEFAULT ''",
    'social_id' => "varchar(255) NOT NULL DEFAULT ''",
    'verify_code_requested' => $date_default,
    'single_app_merchant_id' => "int(14) NOT NULL DEFAULT '0'",
    'payment_customer_type' => "varchar(255) NOT NULL DEFAULT 'sandbox'",
);

$this->alterTable('client', $new_field);












$new_field=array(              
       'update_by_type'=>"varchar(255) NOT NULL DEFAULT ''",
       'update_by_id'=>"int(14) NOT NULL DEFAULT '0'",
       'update_by_name'=>"varchar(255) NOT NULL DEFAULT ''",
    );
    $this->alterTable('order_history',$new_field);
    
    $new_field=array(              
       'page_name_trans'=>"text",
       'content_trans'=>"text",
       'seo_title_trans'=>"text",
       'meta_description_trans'=>"text",
       'meta_keywords_trans'=>"text",
    );
    $this->alterTable('custom_page',$new_field);
    
    $new_field=array(              
       'distance'=>"varchar(100) NOT NULL DEFAULT ''",
       'cancel_reason'=>"text"       
    );
    $this->alterTable('order',$new_field);
    
    $new_field=array(              
       'latitude'=>"varchar(255) NOT NULL DEFAULT ''",
       'longitude'=>"varchar(255) NOT NULL DEFAULT ''",
    );
    $this->alterTable('address_book',$new_field);
    
    $new_field=array(              
       'distance_unit'=>"varchar(20) NOT NULL DEFAULT 'mi'",
       'delivery_distance_covered'=>"float(14,2) NOT NULL DEFAULT '0.00'",
    );
    $this->alterTable('merchant',$new_field);
    
    $new_field=array(              
       'slug'=>"varchar(255) NOT NULL DEFAULT ''"      
    );
    $this->alterTable('cuisine',$new_field);
        
    $this->alterTable('bookingtable',array(
      'request_cancel'=>"int(1) NOT NULL DEFAULT '0'"      
    ));
    
    $this->alterTable('review',array(
      'as_anonymous'=>"varchar(1) NOT NULL DEFAULT '0'",     
    ));
    
    $new_field=array(              
       'first_name'=>"varchar(255) NOT NULL DEFAULT ''",
       'last_name'=>"varchar(255) NOT NULL DEFAULT ''",
       'contact_email'=>"varchar(255) NOT NULL DEFAULT ''",
       'dinein_number_of_guest'=>"varchar(14) NOT NULL DEFAULT ''",
       'dinein_special_instruction'=>"varchar(255) NOT NULL DEFAULT ''",
       'dinein_table_number'=>"varchar(50) NOT NULL DEFAULT ''",
       'opt_contact_delivery'=>"int(1) NOT NULL DEFAULT '0'",
       'estimated_time'=>"int(14) NOT NULL DEFAULT '0'",
       'estimated_date_time'=>$date_default
    );
    $this->alterTable('order_delivery_address',$new_field);
    
    $new_field=array(              
       'size_id'=>"int(14) NOT NULL DEFAULT '0'",
       'cat_id'=>"int(14) NOT NULL DEFAULT '0'",
    );
    $this->alterTable('order_details',$new_field);


   $stmt = "
    CREATE TABLE IF NOT EXISTS " . $prefix . "tags (
      `tag_id` bigint(20) NOT NULL AUTO_INCREMENT,
      `tag_name` varchar(255) NOT NULL DEFAULT '',
      `slug` varchar(255) NOT NULL DEFAULT '',
      `description` text,
      `tag_name_trans` text,
      `description_trans` text,
      `date_created` $date_default,
      `ip_address` varchar(50) NOT NULL DEFAULT '',
      PRIMARY KEY (`tag_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

$this->db->exec($stmt);


$stmt = "
    CREATE TABLE IF NOT EXISTS " . $prefix . "opening_hours (
      `id` int(14) NOT NULL AUTO_INCREMENT,
      `merchant_id` int(14) NOT NULL DEFAULT '0',
      `day` varchar(20) NOT NULL DEFAULT '',
      `status` varchar(100) NOT NULL DEFAULT 'open',
      `start_time` varchar(14) NOT NULL DEFAULT '',
      `end_time` varchar(14) NOT NULL DEFAULT '',
      `start_time_pm` varchar(14) NOT NULL DEFAULT '',
      `end_time_pm` varchar(14) NOT NULL DEFAULT '',
      PRIMARY KEY (`id`),
      KEY `merchant_id` (`merchant_id`),
      KEY `day` (`day`),
      KEY `status` (`status`),
      KEY `start_time` (`start_time`),
      KEY `end_time` (`end_time`),
      KEY `start_time_pm` (`start_time_pm`),
      KEY `end_time_pm` (`end_time_pm`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

$this->db->exec($stmt);


$stmt = "
    CREATE TABLE IF NOT EXISTS " . $prefix . "cuisine_merchant (
      `id` int(14) NOT NULL AUTO_INCREMENT,
      `merchant_id` varchar(14) NOT NULL DEFAULT '0',
      `cuisine_id` varchar(14) NOT NULL DEFAULT '0',
      PRIMARY KEY (`id`),
      KEY `merchant_id` (`merchant_id`),
      KEY `cuisine_id` (`cuisine_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
";

$this->db->exec($stmt);


$new_field=array(              
      'single_app_keys'=>"varchar(255) NOT NULL DEFAULT ''",
      'pin'=>"int(4) NOT NULL DEFAULT '0'",
      'close_store'=>"int(14) NOT NULL DEFAULT '0'"     
    );
    $this->alterTable('merchant',$new_field);
    
    $new_field=array(              
      'item_token'=>"varchar(50) NOT NULL DEFAULT ''",
      'with_size'=>"int(1) NOT NULL DEFAULT '0'",
      'track_stock'=>"int(1) NOT NULL DEFAULT '1'",
      'supplier_id'=>"int(14) NOT NULL DEFAULT '0'",
    );
    $this->alterTable('item',$new_field);
    
    $new_field=array(           
      'description'=>"varchar(255) NOT NULL DEFAULT '' AFTER currency_symbol",   
      'as_default'=>"int(1) NOT NULL DEFAULT '0'",
      'is_hidden'=>"int(1) NOT NULL DEFAULT '0'",
      'currency_position'=>"varchar(100) NOT NULL DEFAULT 'left'",
      'exchange_rate'=>"float(14,4) NOT NULL DEFAULT '0'",
      'exchange_rate_fee'=>"float(14,4) NOT NULL DEFAULT '0'",
      'number_decimal'=>"int(14) NOT NULL DEFAULT '2'",
      'decimal_separator'=>"varchar(5) NOT NULL DEFAULT '.'",
      'thousand_separator'=>"varchar(5) NOT NULL DEFAULT ''",
    );
    $this->alterTable('currency',$new_field);
    
    $new_field=array(              
      'used_currency'=>"varchar(5) NOT NULL DEFAULT ''",
      'base_currency'=>"varchar(5) NOT NULL DEFAULT ''",
      'exchange_rate'=>"float(14,4) NOT NULL DEFAULT '1'"     
    );
    $this->alterTable('order_delivery_address',$new_field);

    if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "subcategory_item_relationships'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "subcategory_item_relationships (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `sub_item_id` INT(14) NOT NULL DEFAULT '0',
            `subcat_id` INT(14) NOT NULL DEFAULT '0'
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";

    $this->db->exec($stmt);
}
$this->addIndex("subcategory_item_relationships","sub_item_id");
    $this->addIndex("subcategory_item_relationships","subcat_id");

    if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "item_relationship_size'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "item_relationship_size (
            `item_size_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `merchant_id` INT(14) NOT NULL DEFAULT '0',
            `item_token` VARCHAR(255) NOT NULL DEFAULT '',
            `item_id` INT(14) NOT NULL DEFAULT '0',
            `size_id` INT(14) NOT NULL DEFAULT '0',
            `price` FLOAT(14,4) NOT NULL DEFAULT '0',
            `cost_price` FLOAT(14,4) NOT NULL DEFAULT '0',
            `sku` VARCHAR(255) NOT NULL DEFAULT '',
            `available` INT(1) NOT NULL DEFAULT '1',
            `low_stock` FLOAT(14,2) NOT NULL DEFAULT '0',
            `created_at` VARCHAR(50) NOT NULL DEFAULT '',
            `updated_at` VARCHAR(50) NOT NULL DEFAULT ''
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";

    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("item_relationship_size", "merchant_id");
    $this->addIndex("item_relationship_size", "item_token");
    $this->addIndex("item_relationship_size", "item_id");
    $this->addIndex("item_relationship_size", "size_id");
}


// Check and create item_relationship_category table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "item_relationship_category'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "item_relationship_category (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `merchant_id` INT(14) NOT NULL DEFAULT '0',
            `item_id` INT(14) NOT NULL DEFAULT '0',
            `cat_id` INT(14) NOT NULL DEFAULT '0'
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("item_relationship_category", "merchant_id");
    $this->addIndex("item_relationship_category", "item_id");
    $this->addIndex("item_relationship_category", "cat_id");
}

// Check and create item_relationship_subcategory table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "item_relationship_subcategory'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "item_relationship_subcategory (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `merchant_id` INT(14) NOT NULL DEFAULT '0',
            `item_id` INT(14) NOT NULL DEFAULT '0',
            `subcat_id` INT(14) NOT NULL DEFAULT '0'
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("item_relationship_subcategory", "merchant_id");
    $this->addIndex("item_relationship_subcategory", "item_id");
    $this->addIndex("item_relationship_subcategory", "subcat_id");
}

// Check and create category_translation table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "category_translation'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "category_translation (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `cat_id` INT(14) NOT NULL DEFAULT '0',
            `language` VARCHAR(100) NOT NULL DEFAULT '',
            `category_name` VARCHAR(255) NOT NULL DEFAULT '',
            `category_description` TEXT
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("category_translation", "cat_id");
    $this->addIndex("category_translation", "language");
}

// Check and create size_translation table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "size_translation'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "size_translation (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `size_id` INT(14) NOT NULL DEFAULT '0',
            `language` VARCHAR(100) NOT NULL DEFAULT '',
            `size_name` VARCHAR(255) NOT NULL DEFAULT ''
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("size_translation", "size_id");
    $this->addIndex("size_translation", "language");
}

// Check and create subcategory_translation table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "subcategory_translation'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "subcategory_translation (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `subcat_id` INT(14) NOT NULL DEFAULT '0',
            `language` VARCHAR(100) NOT NULL DEFAULT '',
            `subcategory_name` VARCHAR(255) NOT NULL DEFAULT '',
            `subcategory_description` TEXT
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("subcategory_translation", "subcat_id");
    $this->addIndex("subcategory_translation", "language");
}

// Check and create subcategory_item_translation table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "subcategory_item_translation'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "subcategory_item_translation (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `sub_item_id` INT(14) NOT NULL DEFAULT '0',
            `language` VARCHAR(100) NOT NULL DEFAULT '',
            `sub_item_name` VARCHAR(255) NOT NULL DEFAULT '',
            `item_description` TEXT
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("subcategory_item_translation", "sub_item_id");
    $this->addIndex("subcategory_item_translation", "language");
}
// Check and create ingredients_translation table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "ingredients_translation'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "ingredients_translation (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `ingredients_id` INT(14) NOT NULL DEFAULT '0',
            `language` VARCHAR(100) NOT NULL DEFAULT '',
            `ingredients_name` VARCHAR(255) NOT NULL DEFAULT ''
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("ingredients_translation", "ingredients_id");
    $this->addIndex("ingredients_translation", "language");
}

// Check and create cooking_ref_translation table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "cooking_ref_translation'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "cooking_ref_translation (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `cook_id` INT(14) NOT NULL DEFAULT '0',
            `language` VARCHAR(100) NOT NULL DEFAULT '',
            `cooking_name` VARCHAR(255) NOT NULL DEFAULT ''
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("cooking_ref_translation", "cook_id");
    $this->addIndex("cooking_ref_translation", "language");
}

// Check and create item_translation table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "item_translation'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "item_translation (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `item_id` INT(14) NOT NULL DEFAULT '0',
            `language` VARCHAR(100) NOT NULL DEFAULT '',
            `item_name` VARCHAR(255) NOT NULL DEFAULT '',
            `item_description` TEXT
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("item_translation", "item_id");
    $this->addIndex("item_translation", "language");
    $this->addIndex("item_translation", "item_name");
}

// Check and create cuisine_translation table
if (!$this->db->query("SHOW TABLES LIKE '" . $prefix . "cuisine_translation'")->fetch()) {
    $stmt = "
        CREATE TABLE " . $prefix . "cuisine_translation (
            `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
            `cuisine_id` INT(14) NOT NULL DEFAULT '0',
            `language` VARCHAR(100) NOT NULL DEFAULT '',
            `cuisine_name` VARCHAR(255) NOT NULL DEFAULT ''
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8;
    ";
    $this->db->exec($stmt);
    
    // Adding indexes
    $this->addIndex("cuisine_translation", "cuisine_id");
    $this->addIndex("cuisine_translation", "language");
    $this->addIndex("cuisine_translation", "cuisine_name");
}

$stmt = "
    CREATE OR REPLACE VIEW " . $prefix . "view_item AS
    SELECT 
        a.item_id,
        a.item_token,
        a.merchant_id,
        a.item_name,
        a.item_name_trans,
        a.item_description,
        a.item_description_trans,
        a.status,
        a.with_size,
        a.supplier_id,
        a.photo,
        a.discount,
        a.not_available,
        a.cooking_ref,
        a.ingredients,
        a.spicydish,
        a.dish,
        a.sequence AS item_sequence,
        IFNULL(b.item_size_id, '') AS item_size_id,
        IFNULL(b.item_token, '') AS item_size_token,
        IFNULL(b.size_id, 0) AS size_id,
        IFNULL(c.size_name, '') AS size_name,
        IFNULL(c.size_name_trans, '') AS size_name_trans,
        IFNULL(b.price, 0) AS price,
        IFNULL(b.cost_price, 0) AS cost_price,
        IFNULL(b.sku, '') AS sku,
        a.track_stock,
        IFNULL(b.available, 0) AS available,
        IFNULL(b.low_stock, 0) AS low_stock
    FROM " . $prefix . "item a
    LEFT JOIN " . $prefix . "item_relationship_size b ON a.item_id = b.item_id
    LEFT JOIN " . $prefix . "size c ON b.size_id = c.size_id
";

try {
    $this->db->exec($stmt);
    $loger[] = "Create view mt_view_item done";
} catch (PDOException $e) {
    $loger[] = "Create view mt_view_item failed: " . $e->getMessage();
}


// Drop mt_view_item if it exists as a table
$this->db->exec("DROP TABLE IF EXISTS " . $prefix . "view_item");

// Now create the view
$stmt = "
    CREATE OR REPLACE VIEW " . $prefix . "view_item AS
    SELECT 
        a.item_id,
        a.item_token,
        a.merchant_id,
        a.item_name,
        a.item_name_trans,
        a.item_description,
        a.item_description_trans,
        a.status,
        a.with_size,
        a.supplier_id,
        a.photo,
        a.discount,
        a.not_available,
        a.cooking_ref,
        a.ingredients,
        a.spicydish,
        a.dish,
        a.sequence AS item_sequence,
        IFNULL(b.item_size_id, '') AS item_size_id,
        IFNULL(b.item_token, '') AS item_size_token,
        IFNULL(b.size_id, 0) AS size_id,
        IFNULL(c.size_name, '') AS size_name,
        IFNULL(c.size_name_trans, '') AS size_name_trans,
        IFNULL(b.price, 0) AS price,
        IFNULL(b.cost_price, 0) AS cost_price,
        IFNULL(b.sku, '') AS sku,
        a.track_stock,
        IFNULL(b.available, 0) AS available,
        IFNULL(b.low_stock, 0) AS low_stock
    FROM " . $prefix . "item a
    LEFT JOIN " . $prefix . "item_relationship_size b ON a.item_id = b.item_id
    LEFT JOIN " . $prefix . "size c ON b.size_id = c.size_id
";

// Execute the statement
$this->db->exec($stmt);


// Check if the execution was successful
if ($result !== false) {
    $loger[] = "Create view mt_view_item done";
} else {
    $loger[] = "Create view mt_view_item failed";
}

// Creating the view mt_view_item_cat

$this->db->exec("DROP TABLE IF EXISTS mt_view_item_cat");

$stmt1 = "
    CREATE OR REPLACE VIEW mt_view_item_cat AS
    SELECT 
        a.cat_id,
        c.category_name,
        c.category_description,
        c.category_name_trans,
        c.category_description_trans,
        c.sequence AS category_sequence,
        b.*
    FROM mt_item_relationship_category a
    LEFT JOIN mt_view_item b ON a.item_id = b.item_id
    LEFT JOIN mt_category c ON a.cat_id = c.cat_id
    WHERE b.item_id > 0
";

// Execute the first statement
$result1 = $this->db->exec($stmt1);

// Check if the execution was successful for the first view
if ($result1 !== false) {
    $loger[] = "Create view mt_view_item_cat done";
} else {
    $loger[] = "Create view mt_view_item_cat failed";
}

// Creating the view mt_view_rs_category
$this->db->exec("DROP TABLE IF EXISTS mt_view_rs_category");
$stmt2 = "
    CREATE OR REPLACE VIEW mt_view_rs_category AS
    SELECT 
        a.id,
        a.merchant_id,
        a.item_id,
        a.cat_id,
        b.category_name,
        b.category_description,
        b.category_name_trans,
        b.category_description_trans,
        b.photo,
        b.status,
        b.sequence,
        c.not_available
    FROM mt_item_relationship_category a
    LEFT JOIN mt_category b ON a.cat_id = b.cat_id
    LEFT JOIN mt_item c ON a.item_id = c.item_id
    WHERE c.item_id IN (
        SELECT item_id FROM mt_item
        WHERE item_id = c.item_id
    )
";

// Execute the second statement
$result2 = $this->db->exec($stmt2);

// Check if the execution was successful for the second view
if ($result2 !== false) {
    $loger[] = "Create view mt_view_rs_category done";
} else {
    $loger[] = "Create view mt_view_rs_category failed";
}


// Check and create mt_item_meta table
if (!$this->db->query("SHOW TABLES LIKE 'mt_item_meta'")->rowCount()) {
    $stmt = "
        CREATE TABLE mt_item_meta (
            id INT PRIMARY KEY AUTO_INCREMENT,
            merchant_id INT(14) NOT NULL DEFAULT '0',
            item_id INT(14) NOT NULL DEFAULT '0',
            meta_name VARCHAR(255) NOT NULL DEFAULT '',
            meta_id INT(14) NOT NULL DEFAULT '0'
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    $this->db->exec($stmt);
}
$this->addIndex("item_meta", "merchant_id");
$this->addIndex("item_meta", "item_id");
$this->addIndex("item_meta", "meta_name");
$this->addIndex("item_meta", "meta_id");

// Check and create mt_item_relationship_subcategory_item table
if (!$this->db->query("SHOW TABLES LIKE 'mt_item_relationship_subcategory_item'")->rowCount()) {
    $stmt = "
        CREATE TABLE mt_item_relationship_subcategory_item (
            id INT PRIMARY KEY AUTO_INCREMENT,
            merchant_id INT(14) NOT NULL DEFAULT '0',
            item_id INT(14) NOT NULL DEFAULT '0',
            subcat_id INT(14) NOT NULL DEFAULT '0',
            sub_item_id INT(14) NOT NULL DEFAULT '0'
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    $this->db->exec($stmt);
}
$this->addIndex("item_relationship_subcategory_item", "merchant_id");
$this->addIndex("item_relationship_subcategory_item", "item_id");
$this->addIndex("item_relationship_subcategory_item", "subcat_id");
$this->addIndex("item_relationship_subcategory_item", "sub_item_id");

// Check and create mt_dishes_translation table
if (!$this->db->query("SHOW TABLES LIKE 'mt_dishes_translation'")->rowCount()) {
    $stmt = "
        CREATE TABLE mt_dishes_translation (
            id INT PRIMARY KEY AUTO_INCREMENT,
            dish_id INT(14) NOT NULL DEFAULT '0',
            language VARCHAR(100) NOT NULL DEFAULT '',
            dish_name VARCHAR(255) NOT NULL DEFAULT ''
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    $this->db->exec($stmt);
}
$this->addIndex("dishes_translation", "dish_id");
$this->addIndex("dishes_translation", "language");
$this->addIndex("dishes_translation", "dish_name");

// Check and create mt_order_time_management table
if (!$this->db->query("SHOW TABLES LIKE 'mt_order_time_management'")->rowCount()) {
    $stmt = "
        CREATE TABLE mt_order_time_management (
            id INT PRIMARY KEY AUTO_INCREMENT,
            group_id INT(14) NOT NULL DEFAULT '0',
            merchant_id INT(14) NOT NULL DEFAULT '0',
            transaction_type VARCHAR(100) NOT NULL DEFAULT '',
            days VARCHAR(200) NOT NULL DEFAULT '',
            start_time VARCHAR(5) NOT NULL DEFAULT '',
            end_time VARCHAR(5) NOT NULL DEFAULT '',
            number_order_allowed INT(14) NOT NULL DEFAULT '0',
            order_status TEXT
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8";
    $this->db->exec($stmt);
}
$this->addIndex("order_time_management", "group_id");
$this->addIndex("order_time_management", "merchant_id");
$this->addIndex("order_time_management", "transaction_type");
$this->addIndex("order_time_management", "days");
$this->addIndex("order_time_management", "start_time");
$this->addIndex("order_time_management", "end_time");


echo "Updating table order_delivery_address<br/>";
    $new_field=array( 
       'service_fee'=>"float(14,5) NOT NULL DEFAULT '0'",
       'service_fee_applytax'=>"integer(14) NOT NULL DEFAULT '0'",
    );
    $this->alterTable('order_delivery_address',$new_field);

      
    $new_field=array( 
       'free_above_subtotal'=>"float(14,5) NOT NULL DEFAULT '0' AFTER fee",
       'minimum_order'=>"float(14,5) NOT NULL DEFAULT '0' AFTER fee",            
    );
    $this->alterTable('location_rate',$new_field);
    
    $new_field=array( 
       'monday_start'=>"varchar(5) NOT NULL DEFAULT ''", 
       'monday_end'=>"varchar(5) NOT NULL DEFAULT ''", 
       'tuesday_start'=>"varchar(5) NOT NULL DEFAULT ''", 
       'tuesday_end'=>"varchar(5) NOT NULL DEFAULT ''", 
       'wednesday_start'=>"varchar(5) NOT NULL DEFAULT ''", 
       'wednesday_end'=>"varchar(5) NOT NULL DEFAULT ''", 
       'thursday_start'=>"varchar(5) NOT NULL DEFAULT ''", 
       'thursday_end'=>"varchar(5) NOT NULL DEFAULT ''", 
       'friday_start'=>"varchar(5) NOT NULL DEFAULT ''", 
       'friday_end'=>"varchar(5) NOT NULL DEFAULT ''", 
       'saturday_start'=>"varchar(5) NOT NULL DEFAULT ''", 
       'saturday_end'=>"varchar(5) NOT NULL DEFAULT ''", 
       'sunday_start'=>"varchar(5) NOT NULL DEFAULT ''", 
       'sunday_end'=>"varchar(5) NOT NULL DEFAULT ''"
    );
    $this->alterTable('category',$new_field);
    
    $new_field=array( 
       'min_order'=>"float(14,5) NOT NULL DEFAULT '0'",
       'monday'=>"int(1) NOT NULL DEFAULT '0'",
       'tuesday'=>"int(1) NOT NULL DEFAULT '0'",
       'wednesday'=>"int(1) NOT NULL DEFAULT '0'",
       'thursday'=>"int(1) NOT NULL DEFAULT '0'",
       'friday'=>"int(1) NOT NULL DEFAULT '0'",
       'saturday'=>"int(1) NOT NULL DEFAULT '0'",
       'sunday'=>"int(1) NOT NULL DEFAULT '0'",
    );
    $this->alterTable('voucher_new',$new_field);
    
    /*END 5.4.4*/
    
    /*ADD INDEX*/
    /*MERCHANT TABLE*/
    $this->addIndex("merchant","restaurant_slug");
    $this->addIndex("merchant","restaurant_name");
    $this->addIndex("merchant","post_code");
    $this->addIndex("merchant","service");
    $this->addIndex("merchant","username");
    $this->addIndex("merchant","password");
    $this->addIndex("merchant","status");
    $this->addIndex("merchant","package_id");
    $this->addIndex("merchant","payment_steps");
    $this->addIndex("merchant","is_featured");
    $this->addIndex("merchant","is_ready");
    $this->addIndex("merchant","is_sponsored");
    $this->addIndex("merchant","is_commission");
    $this->addIndex("merchant","percent_commision");
    $this->addIndex("merchant","session_token");
    $this->addIndex("merchant","commision_type");
    $this->addIndex("merchant","delivery_charges");
    $this->addIndex("merchant","merchant_id");    
    $this->addIndex("merchant","latitude");
    $this->addIndex("merchant","lontitude");
    $this->addIndex("merchant","merchant_type");
    $this->addIndex("merchant","invoice_terms");
    
    /*RATINGS TABLE*/
    $this->addIndex("rating","ratings");
    
    /*ORDER TABLE*/
    $this->addIndex("order","viewed");
    $this->addIndex("order","admin_viewed");
    $this->addIndex("order","merchantapp_viewed");
    $this->addIndex("order","order_id_token");
    $this->addIndex("order","total_commission");
    $this->addIndex("order","merchant_earnings");
    $this->addIndex("order","total_w_tax");
    $this->addIndex("order","taxable_total");
    $this->addIndex("order","sub_total");
    $this->addIndex("order","payment_type");
    $this->addIndex("order","trans_type");
    
    /*ORDER DETAILS TABLE*/
    $this->addIndex("order_details","order_id");
    $this->addIndex("order_details","client_id");
    $this->addIndex("order_details","item_id");
    
    /*address_book*/
    $this->addIndex("address_book","client_id");
    $this->addIndex("address_book","as_default");
    
    /*admin_user*/
    $this->addIndex("admin_user","admin_id");
    $this->addIndex("admin_user","username");
    $this->addIndex("admin_user","password");
    $this->addIndex("admin_user","lost_password_code");
    $this->addIndex("admin_user","session_token");
    
    /*bank_deposit*/
    $this->addIndex("bank_deposit","merchant_id");
    $this->addIndex("bank_deposit","status");
    $this->addIndex("bank_deposit","client_id");
    $this->addIndex("bank_deposit","order_id");
    
    /*barclay_trans*/
    $this->addIndex("barclay_trans","orderid");
    $this->addIndex("barclay_trans","token");
    $this->addIndex("barclay_trans","transaction_type");
    
    /*bookingtable*/
    $this->addIndex("bookingtable","merchant_id");
    $this->addIndex("bookingtable","status");
    $this->addIndex("bookingtable","viewed");
    $this->addIndex("bookingtable","client_id");
    $this->addIndex("bookingtable","date_booking");
    
    /*category*/
    $this->addIndex("category","merchant_id");
    $this->addIndex("category","category_name");
    $this->addIndex("category","status");
    $this->addIndex("category","sequence");
    $this->addIndex("category","parent_cat_id");
    
    /*client*/
    $this->addIndex("client","social_strategy");
    $this->addIndex("client","email_address");
    $this->addIndex("client","password");
    $this->addIndex("client","street");
    $this->addIndex("client","city");
    $this->addIndex("client","state");
    $this->addIndex("client","contact_phone");
    $this->addIndex("client","lost_password_token");
    $this->addIndex("client","status");
    $this->addIndex("client","token");
    $this->addIndex("client","mobile_verification_code");
    $this->addIndex("client","is_guest");
    $this->addIndex("client","email_verification_code");
    
    /*client_cc*/
    $this->addIndex("client_cc","client_id");
    
    /*cooking_ref*/
    $this->addIndex("cooking_ref","merchant_id");
    $this->addIndex("cooking_ref","cooking_name");
    $this->addIndex("cooking_ref","sequence");
    $this->addIndex("cooking_ref","status");
    
    /*cuisine*/
    $this->addIndex("cuisine","cuisine_name");
    $this->addIndex("cuisine","sequence");
    
    /*currency*/
    $this->addIndex("currency","currency_symbol");
    $this->addIndex("currency","currency_code");
    
    /*custom_page*/
    $this->addIndex("custom_page","slug_name");
    
    /*dishes*/
    $this->addIndex("dishes","dish_name");
    
    /*fax_broadcast*/
    $this->addIndex("fax_broadcast","merchant_id");   
    
    /*fax_package*/
    $this->addIndex("fax_package","title");
    $this->addIndex("fax_package","status");
    
    /*ingredients*/
    $this->addIndex("ingredients","merchant_id");
    $this->addIndex("ingredients","status");
    $this->addIndex("ingredients","ingredients_name");
    
    /*item*/
    $this->addIndex("item","merchant_id");
    $this->addIndex("item","item_name");
    $this->addIndex("item","status");
    $this->addIndex("item","is_featured");
    $this->addIndex("item","spicydish");
    $this->addIndex("item","two_flavors");
    /*$this->addIndex("item","points_earned");
    $this->addIndex("item","points_disabled");*/
    
    /*item*/
    $this->addIndex("merchant_cc","merchant_id");
    
    /*merchant_user*/
    $this->addIndex("merchant_user","merchant_id");
    $this->addIndex("merchant_user","username");
    $this->addIndex("merchant_user","password");
    $this->addIndex("merchant_user","status");
    $this->addIndex("merchant_user","session_token");
    /*$this->addIndex("merchant_user","mobile_session_token");
    $this->addIndex("merchant_user","lost_password_code");*/
    
    /*newsletter*/
    $this->addIndex("newsletter","email_address");
    
    /*offers*/
    $this->addIndex("offers","merchant_id");
    $this->addIndex("offers","status");
    
    /*offers*/
    $this->addIndex("option","option_name");
    
    /*order_delivery_address*/
    $this->addIndex("order_delivery_address","order_id");
    $this->addIndex("order_delivery_address","client_id");    
    $this->addIndex("order_delivery_address","google_lat");
    $this->addIndex("order_delivery_address","google_lng");
    
    /*order_history*/
    $this->addIndex("order_history","order_id");
    $this->addIndex("order_history","status");    
    /*$this->addIndex("order_history","task_id");
    $this->addIndex("order_history","driver_id");
    $this->addIndex("order_history","driver_location_lat");
    $this->addIndex("order_history","driver_location_lng");*/
    
    /*order_status*/
    $this->addIndex("order_status","merchant_id");
    
    /*packages*/
    $this->addIndex("packages","title");
    $this->addIndex("packages","status");
    
    /*package_trans*/
    $this->addIndex("package_trans","package_id");
    $this->addIndex("package_trans","merchant_id");
    $this->addIndex("package_trans","TRANSACTIONID");
    $this->addIndex("package_trans","status");
    
    /*payment_order*/
    $this->addIndex("payment_order","order_id");
    $this->addIndex("payment_order","payment_type");
    $this->addIndex("payment_order","payment_reference");
    
    /*payment_provider*/
    $this->addIndex("payment_provider","payment_name");
    $this->addIndex("payment_provider","status");
    
    /*paypal_checkout*/
    $this->addIndex("paypal_checkout","order_id");
    $this->addIndex("paypal_checkout","token");
    $this->addIndex("paypal_checkout","status");
    
    /*paypal_checkout*/
    $this->addIndex("paypal_checkout","order_id");
    $this->addIndex("paypal_checkout","token");
    $this->addIndex("paypal_checkout","status");
    
    /*review*/
    $this->addIndex("review","client_id");
    $this->addIndex("review","merchant_id");
    $this->addIndex("review","rating");
    $this->addIndex("review","status");
    
    /*size*/
    $this->addIndex("size","merchant_id");    
    $this->addIndex("size","size_name");    
    $this->addIndex("size","status");   
    
    /*shipping_rate*/
    $this->addIndex("shipping_rate","merchant_id");   
    
    /*sms_broadcast*/
    $this->addIndex("sms_broadcast","merchant_id");   
    $this->addIndex("sms_broadcast","send_to");   
    $this->addIndex("sms_broadcast","status");    
    
    /*sms_broadcast_details*/
    $this->addIndex("sms_broadcast_details","merchant_id");   
    $this->addIndex("sms_broadcast_details","broadcast_id");
    $this->addIndex("sms_broadcast_details","client_id");
    $this->addIndex("sms_broadcast_details","status");
    $this->addIndex("sms_broadcast_details","gateway");
    
    /*subcategory*/
    $this->addIndex("subcategory","merchant_id");   
    $this->addIndex("subcategory","subcategory_name");
    $this->addIndex("subcategory","status");
    
    /*subcategory_item*/
    $this->addIndex("subcategory_item","merchant_id");
    $this->addIndex("subcategory_item","sub_item_name");
    $this->addIndex("subcategory_item","status");
    
    
    /*voucher_new*/
    $this->addIndex("voucher_new","voucher_owner");
    $this->addIndex("voucher_new","merchant_id");
    $this->addIndex("voucher_new","voucher_type");
    $this->addIndex("voucher_new","status");
    
    /*withdrawal*/
    $this->addIndex("withdrawal","merchant_id");
    $this->addIndex("withdrawal","payment_type");
    $this->addIndex("withdrawal","payment_method");
    $this->addIndex("withdrawal","status");
    $this->addIndex("withdrawal","viewed");
        
    /*review*/
    $this->addIndex("review","parent_id");

    // Create or replace view mt_view_ratings

    $this->db->exec("DROP TABLE IF EXISTS mt_view_ratings");

$stmt = "
    CREATE OR REPLACE VIEW mt_view_ratings AS
    SELECT 
        merchant_id,
        COUNT(*) AS review_count,
        SUM(rating)/COUNT(*) AS ratings
    FROM
        mt_review
    WHERE
        status IN ('publish', 'published')
    GROUP BY merchant_id
";

echo "Updating view Table view_ratings..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Create or replace view mt_view_merchant
$this->db->exec("DROP TABLE IF EXISTS mt_view_merchant");
$stmt = "
    CREATE OR REPLACE VIEW mt_view_merchant AS
    SELECT a.*,        
        IFNULL(f.ratings, 0) AS ratings,
        IFNULL(f.review_count, 0) AS review_count,
        IFNULL(f.review_count, 0) AS ratings_votes
    FROM mt_merchant a
    LEFT JOIN mt_view_ratings f ON 
        a.merchant_id = f.merchant_id
";

echo "Updating view Table merchant..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";

// Create or replace view mt_view_order_details
$this->db->exec("DROP TABLE IF EXISTS mt_view_order_details");
$stmt = "
    CREATE OR REPLACE VIEW mt_view_order_details AS
    SELECT a.*,
        b.merchant_id,
        b.status,
        b.date_created
    FROM mt_order_details a
    LEFT JOIN mt_order b ON
        a.order_id = b.order_id
";

echo "Creating Table view_order_details..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";


// Create or replace view mt_view_location_rate
$this->db->exec("DROP TABLE IF EXISTS mt_view_location_rate");
$stmt = "
    CREATE OR REPLACE VIEW mt_view_location_rate AS
    SELECT 
        a.rate_id,
        a.merchant_id,
        a.country_id,
        b.country_name,
        a.state_id,
        c.name AS state_name,
        a.city_id,
        d.name AS city_name,
        d.postal_code,
        a.area_id,
        e.name AS area_name,
        a.fee,
        a.minimum_order,
        a.free_above_subtotal,
        a.sequence,
        a.date_created,
        a.date_modified,
        a.ip_address
    FROM
        mt_location_rate a
    LEFT JOIN mt_location_countries b ON
        a.country_id = b.country_id    
    LEFT JOIN mt_location_states c ON
        a.state_id = c.state_id
    LEFT JOIN mt_location_cities d ON
        a.city_id = d.city_id
    LEFT JOIN mt_location_area e ON
        a.area_id = e.area_id
";

echo "Creating Table view_location_rate..<br/>";
$this->db->exec($stmt);
echo "(Done)<br/>";


// Creating or replacing the view mt_view_cuisine_merchant
$this->db->exec("DROP TABLE IF EXISTS mt_view_cuisine_merchant");
$stmt = "
    CREATE OR REPLACE VIEW mt_view_cuisine_merchant AS
    SELECT 
        a.merchant_id,
        a.cuisine_id,
        b.cuisine_name,
        b.cuisine_name_trans,
        b.status,
        b.featured_image,
        c.restaurant_name
    FROM 
        mt_cuisine_merchant a
    LEFT JOIN mt_cuisine b ON
        a.cuisine_id = b.cuisine_id 
    LEFT JOIN mt_merchant c ON
        a.merchant_id = c.merchant_id
    WHERE 
        a.merchant_id = c.merchant_id
";

echo "Creating Table view_cuisine_merchant..<br/>"; 
$this->db->exec($stmt);
echo "(Done)<br/>";       

/* 5.4.3 */
// Creating or replacing the view mt_view_order
$this->db->exec("DROP TABLE IF EXISTS mt_view_order");
$stmt = "
    CREATE OR REPLACE VIEW mt_view_order AS
    SELECT 
        a.order_id,
        a.order_id_token,
        a.client_id,
        CONCAT(b.first_name, ' ', b.last_name) AS customer_name,
        CONCAT(c.first_name, ' ', c.last_name) AS profile_customer_name,
        b.first_name,
        b.last_name,
        b.contact_email,
        b.contact_phone,
        c.contact_phone AS profile_contact_phone,
        b.dinein_number_of_guest,
        b.dinein_special_instruction,
        b.dinein_table_number,
        b.opt_contact_delivery,
        b.estimated_time,
        b.estimated_date_time,
        b.used_currency,
        b.base_currency,
        b.exchange_rate,
        b.service_fee,
        b.service_fee_applytax,
        c.payment_customer_id,
        c.payment_customer_type,
        a.merchant_id,
        d.restaurant_name,
        a.trans_type,
        a.payment_type,
        a.total_w_tax AS total_amount,
        a.delivery_charge,
        a.status,
        a.delivery_date,
        a.delivery_time,
        a.delivery_asap,
        a.delivery_instruction,
        a.date_created,
        a.request_cancel
    FROM  
        mt_order a
    LEFT JOIN mt_order_delivery_address b ON
        a.order_id = b.order_id
    LEFT JOIN mt_client c ON
        a.client_id = c.client_id
    LEFT JOIN mt_merchant d ON
        a.merchant_id = d.merchant_id
";

echo "Creating Table view_order..<br/>";  
$this->db->exec($stmt);
echo "(Done)<br/>";

// Creating or replacing the view mt_view_order_summary
$this->db->exec("DROP TABLE IF EXISTS mt_view_order_summary");
$stmt = "
    CREATE OR REPLACE VIEW mt_view_order_summary AS
    SELECT
        a.order_id,
        a.merchant_id,
        a.payment_type,
        a.trans_type,
        a.commision_ontop,
        a.percent_commision,
        status,
        a.sub_total,
        total_w_tax,
        total_commission,
        merchant_earnings,
        b.used_currency,
        b.base_currency,
        b.exchange_rate,
        
        IFNULL((sub_total / b.exchange_rate), 0) AS sub_total_ex,
        IFNULL((total_w_tax / b.exchange_rate), 0) AS total_w_tax_ex,
        IFNULL((total_commission / b.exchange_rate), 0) AS total_commission_ex,
        IFNULL((merchant_earnings / b.exchange_rate), 0) AS merchant_earnings_ex,
        
        a.date_created
    FROM 
        mt_order a
    LEFT JOIN mt_order_delivery_address b ON
        a.order_id = b.order_id
";

$result = $this->db->exec($stmt);
if ($result !== false) {
    $loger[] = "Create table mt_view_order_summary done";
} else {
    $loger[] = "Create table mt_view_order_summary failed";
}

// Dumping log messages
//dump($loger);

echo "<br/>";
echo "FINISH UPDATE(s)";























    }

     public function addIndex($table = '', $index_name = '')
{
    $prefix = "mt_";    
    $table = $prefix . $table;

    // Prepare the statement to check for existing indexes
    $stmt = "SHOW INDEX FROM $table";    
    $found = false;

    // Use PDO to execute the query
    $res = $this->db->query($stmt)->fetchAll(PDO::FETCH_ASSOC);
    
    // Check if the index exists
    foreach ($res as $val) {        
        if ($val['Key_name'] == $index_name) {
            $found = true;
            break;
        }
    } 

    // If index not found, create it
    if (!$found) {
        echo "Creating index<br>";
        $stmt_index = "ALTER TABLE $table ADD INDEX ($index_name)";
        
        // Execute the index creation statement
        $this->db->exec($stmt_index);
        echo "Creating Index $index_name on $table <br/>";    
        echo "(Done)<br/>";   
    } 
}


public function alterTable($table = '', $new_field = [])
{
    $prefix = "mt_";    
    $existing_field = [];

    // Check the table structure
    if ($res = $this->functions->checkTableStructure($table)) {
        foreach ($res as $val) {                
            $existing_field[$val['Field']] = $val['Field'];
        }     

        // Iterate over new fields to add
        foreach ($new_field as $key_new => $val_new) {        
            if (!in_array($key_new, $existing_field)) {
                echo "Creating field $key_new <br/>";
                $stmt_alter = "ALTER TABLE " . $prefix . "$table ADD $key_new $val_new";
                
                // Use PDO to execute the alter table statement
                try {
                    $this->db->exec($stmt_alter);
                    echo "(Done)<br/>";
                } catch (PDOException $e) {
                    echo "(Failed): " . $e->getMessage() . "<br/>";
                }
            } else {
                echo "Field $key_new already exists<br/>";
            }
        }
    }
}


	
	
	


    
    
   
}
